// ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_DATA_VIEW_H_
#define UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"


namespace ax::mojom {
class AXLocationChangeDataView;

class AXScrollChangeDataView;

class AXLocationAndScrollUpdatesDataView;



}  // ax::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXLocationChangeDataView> {
  using Data = ::ax::mojom::internal::AXLocationChange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ax::mojom::AXScrollChangeDataView> {
  using Data = ::ax::mojom::internal::AXScrollChange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ax::mojom::AXLocationAndScrollUpdatesDataView> {
  using Data = ::ax::mojom::internal::AXLocationAndScrollUpdates_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXLocationChangeDataView {
 public:
  AXLocationChangeDataView() = default;

  AXLocationChangeDataView(
      internal::AXLocationChange_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetNewLocationDataView(
      ::ax::mojom::AXRelativeBoundsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewLocation(UserType* output) {
    
    auto* pointer = data_->new_location.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXRelativeBoundsDataView>(
        pointer, output, message_);
  }
 private:
  internal::AXLocationChange_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AXScrollChangeDataView {
 public:
  AXScrollChangeDataView() = default;

  AXScrollChangeDataView(
      internal::AXScrollChange_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t scroll_x() const {
    return data_->scroll_x;
  }
  int32_t scroll_y() const {
    return data_->scroll_y;
  }
 private:
  internal::AXScrollChange_Data* data_ = nullptr;
};


class AXLocationAndScrollUpdatesDataView {
 public:
  AXLocationAndScrollUpdatesDataView() = default;

  AXLocationAndScrollUpdatesDataView(
      internal::AXLocationAndScrollUpdates_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationChangesDataView(
      mojo::ArrayDataView<AXLocationChangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocationChanges(UserType* output) {
    
    auto* pointer = data_->location_changes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXLocationChangeDataView>>(
        pointer, output, message_);
  }
  inline void GetScrollChangesDataView(
      mojo::ArrayDataView<AXScrollChangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollChanges(UserType* output) {
    
    auto* pointer = data_->scroll_changes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXScrollChangeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AXLocationAndScrollUpdates_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

#endif  // UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_DATA_VIEW_H_