// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/webrtc/webrtc_features.h"

#include "base/command_line.h"
#include "base/metrics/field_trial_params.h"
#include "build/build_config.h"
#include "third_party/webrtc/modules/audio_processing/include/audio_processing.h"

namespace features {

// When enabled we will tell WebRTC that we want to use the
// Windows.Graphics.Capture API based screen capturer, if it is available.
BASE_FEATURE(kWebRtcAllowWgcScreenCapturer,
             "AllowWgcScreenCapturer",
             base::FEATURE_DISABLED_BY_DEFAULT);

// When enabled we will tell WebRTC that we want to use the
// Windows.Graphics.Capture API based window capturer, if it is available.
BASE_FEATURE(kWebRtcAllowWgcWindowCapturer,
             "AllowWgcWindowCapturer",
             base::FEATURE_ENABLED_BY_DEFAULT);

// When enabled we will tell WebRTC that we want to use the 0Hz mode of the
// Windows.Graphics.Capture API based {Screen/Window} capturer, if the WGC
// capturer is available and enabled. In this mode, only frames with new content
// will be sent to the client leading to to 0fps for a static {Screen/Window}
// source.
// This flag only has an effect if kWebRtcAllowWgcScreenCapturer is enabled.
BASE_FEATURE(kWebRtcAllowWgcScreenZeroHz,
             "AllowWgcScreenZeroHz",
             base::FEATURE_DISABLED_BY_DEFAULT);
// This flag only has an effect if kWebRtcAllowWgcWindowCapturer is enabled.
BASE_FEATURE(kWebRtcAllowWgcWindowZeroHz,
             "AllowWgcWindowZeroHz",
             base::FEATURE_ENABLED_BY_DEFAULT);

#if BUILDFLAG(IS_WIN)
// When enabled, instruct WGC to draw a border around the captured
// window or screen.
BASE_FEATURE(kWebRtcWgcRequireBorder,
             "WebRtcWgcRequireBorder",
             base::FEATURE_DISABLED_BY_DEFAULT);
#endif

// TODO(crbug.com/40872787): Deactivate the flag gradually before deleting it.
// When disabled, any WebRTC Audio Processing Module input volume recommendation
// is ignored and no adjustment takes place.
BASE_FEATURE(kWebRtcAllowInputVolumeAdjustment,
             "WebRtcAllowInputVolumeAdjustment",
             base::FEATURE_ENABLED_BY_DEFAULT);

// When enabled, overrides the Audio Processing Module parameter that controls
// how multi-channel capture audio is downmixed to mono (when downmixing is
// needed).
BASE_FEATURE(kWebRtcApmDownmixCaptureAudioMethod,
             "WebRtcApmDownmixCaptureAudioMethod",
             base::FEATURE_DISABLED_BY_DEFAULT);

// When enabled, allow H.265 codec to be used for sending WebRTC streams.
// Platform hardware H.265 encoder needs to be supported and enabled in order to
// negotiate usage of H.265 in SDP in the direction of sending.
BASE_FEATURE(kWebRtcAllowH265Send,
             "WebRtcAllowH265Send",
             base::FEATURE_ENABLED_BY_DEFAULT);

// When enabled, allow H.265 codec to be used for receiving WebRTC streams.
// Platform hardware H.265 decoder needs to be supported and enabled in order to
// negotiate usage of H.265 in SDP in the direction of receiving.
BASE_FEATURE(kWebRtcAllowH265Receive,
             "WebRtcAllowH265Receive",
             base::FEATURE_ENABLED_BY_DEFAULT);

// When enabled, allows H.265 L1T2 to be used for sending WebRTC streams, if the
// accelerator reports support of encoding in L1T2.
BASE_FEATURE(kWebRtcH265L1T2,
             "WebRtcH265L1T2",
             base::FEATURE_DISABLED_BY_DEFAULT);

// When enabled, allows H.265 L1T3 to be used for sending WebRTC streams, if the
// accelerator reports support of encoding in L1T3. If this is enabled, L1T2 is
// also implied to be enabled.
BASE_FEATURE(kWebRtcH265L1T3,
             "WebRtcH265L1T3",
             base::FEATURE_DISABLED_BY_DEFAULT);

// When enabled, allows AV1 HW encoding to be used for WebRTC streams, if the
// platform accelerator supports encoding of AV1.
#if BUILDFLAG(IS_WIN)
BASE_FEATURE(kWebRtcAV1HWEncode,
             "WebRtcAV1HWEncode",
             base::FEATURE_DISABLED_BY_DEFAULT
);
#else
BASE_FEATURE(kWebRtcAV1HWEncode,
             "WebRtcAV1HWEncode",
             base::FEATURE_ENABLED_BY_DEFAULT
);
#endif  // BUILDFLAG(IS_WIN)

#if BUILDFLAG(IS_ANDROID)
// Kill-switch for using 48 kHz as sample rate for Audio Processing Module
// processing on Android. When enabled, enforces a 16 kHz sample rate for audio
// processing on Android.
BASE_FEATURE(kWebRtcApm48kHzSampleRateOnAndroidKillSwitch,
             "WebRtcApm48kHzSampleRateOnAndroidKillSwitch",
             base::FEATURE_DISABLED_BY_DEFAULT);
#endif

}  // namespace features
