// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>


#include "../Color.h"
#include "ImageProperty.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class CornerPropertyPrivate;

/*!
\class Union::Properties::CornerProperty
\inmodule core
\ingroup core-properties

\brief A property group containing the properties of a corner.

*/
class UNION_EXPORT CornerProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    CornerProperty();
    /*!
     * Copy constructor.
     */
    CornerProperty(const CornerProperty &other);
    /*!
     * Move constructor.
     */
    CornerProperty(CornerProperty &&other);
    ~CornerProperty();

    /*!
     * Copy assignment operator.
     */
    CornerProperty &operator=(const CornerProperty &other);
    /*!
     * Move assignment operator.
     */
    CornerProperty &operator=(CornerProperty &&other);

    /*!
     * Returns the value of radius.
     */
    std::optional<qreal> radius() const;
    /*!
     * Set the value of radius.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setRadius(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of width.
     */
    std::optional<qreal> width() const;
    /*!
     * Set the value of width.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setWidth(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of height.
     */
    std::optional<qreal> height() const;
    /*!
     * Set the value of height.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setHeight(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of color.
     */
    std::optional<Union::Color> color() const;
    /*!
     * Set the value of color.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setColor(const std::optional<Union::Color> &newValue);

    /*!
     * Returns the value of image.
     */
    std::optional<ImageProperty> image() const;
    /*!
     * Returns image if set or a new ImageProperty if not.
     */
    ImageProperty image_or_new() const;
    /*!
     * Set the value of image.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setImage(const std::optional<ImageProperty> &newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Returns if this property is considered empty.
     *
     * A property is considered empty if it has no values or if the values it
     * contains are all considered empty values.
     */
    bool isEmpty() const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const CornerProperty &source, CornerProperty &destination);

    /*!
     * Create and return an empty CornerProperty instance.
     *
     * This will create an empty CornerProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static CornerProperty empty();

private:
    std::unique_ptr<CornerPropertyPrivate> d;
};

/*!
 * \relates Union::Properties::CornerProperty
 * Equality comparison for CornerProperty.
 */
UNION_EXPORT bool operator==(const CornerProperty &left, const CornerProperty &right);
}
}

/*!
 * \relates Union::Properties::CornerProperty
 * QDebug support for CornerProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, const Union::Properties::CornerProperty &type);