/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * XCore Disassembler                                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// an integer-typed field.
template <typename IntType>
static std::enable_if_t<std::is_integral_v<IntType>, void>
insertBits(IntType &field, IntType bits, unsigned startBit, unsigned numBits) {
  // Check that no bit beyond numBits is set, so that a simple bitwise |
  // is sufficient.
  assert((~(((IntType)1 << numBits) - 1) & bits) == 0 &&
           "bits has more than numBits bits set");
  assert(startBit + numBits <= sizeof(IntType) * 8);
  (void)numBits;
  field |= bits << startBit;
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTable16[] = {
/* 0 */       MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 3 */       MCD::OPC_FilterValue, 0, 117, 0, // Skip to: 124
/* 7 */       MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 10 */      MCD::OPC_FilterValue, 236, 15, 4, 0, // Skip to: 19
/* 15 */      MCD::OPC_Decode, 150, 4, 0, // Opcode: WAITEU_0R, DecodeIdx: 0
/* 19 */      MCD::OPC_FilterValue, 237, 15, 4, 0, // Skip to: 28
/* 24 */      MCD::OPC_Decode, 229, 2, 0, // Opcode: CLRE_0R, DecodeIdx: 0
/* 28 */      MCD::OPC_FilterValue, 238, 15, 4, 0, // Skip to: 37
/* 33 */      MCD::OPC_Decode, 254, 3, 0, // Opcode: SSYNC_0r, DecodeIdx: 0
/* 37 */      MCD::OPC_FilterValue, 239, 15, 4, 0, // Skip to: 46
/* 42 */      MCD::OPC_Decode, 133, 3, 0, // Opcode: FREET_0R, DecodeIdx: 0
/* 46 */      MCD::OPC_FilterValue, 252, 15, 4, 0, // Skip to: 55
/* 51 */      MCD::OPC_Decode, 238, 2, 0, // Opcode: DCALL_0R, DecodeIdx: 0
/* 55 */      MCD::OPC_FilterValue, 253, 15, 4, 0, // Skip to: 64
/* 60 */      MCD::OPC_Decode, 164, 3, 0, // Opcode: KRET_0R, DecodeIdx: 0
/* 64 */      MCD::OPC_FilterValue, 254, 15, 4, 0, // Skip to: 73
/* 69 */      MCD::OPC_Decode, 244, 2, 0, // Opcode: DRET_0R, DecodeIdx: 0
/* 73 */      MCD::OPC_FilterValue, 255, 15, 4, 0, // Skip to: 82
/* 78 */      MCD::OPC_Decode, 235, 3, 0, // Opcode: SETKEP_0R, DecodeIdx: 0
/* 82 */      MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 85 */      MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 93
/* 89 */      MCD::OPC_Decode, 247, 2, 1, // Opcode: EDU_1r, DecodeIdx: 1
/* 93 */      MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 101
/* 97 */      MCD::OPC_Decode, 250, 2, 1, // Opcode: EEU_1r, DecodeIdx: 1
/* 101 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 104 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 112
/* 108 */     MCD::OPC_Decode, 151, 3, 2, // Opcode: INITPC_2r, DecodeIdx: 2
/* 112 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 120
/* 116 */     MCD::OPC_Decode, 145, 3, 2, // Opcode: GETST_2r, DecodeIdx: 2
/* 120 */     MCD::OPC_Decode, 137, 4, 3, // Opcode: STW_2rus, DecodeIdx: 3
/* 124 */     MCD::OPC_FilterValue, 1, 117, 0, // Skip to: 245
/* 128 */     MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 131 */     MCD::OPC_FilterValue, 236, 15, 4, 0, // Skip to: 140
/* 136 */     MCD::OPC_Decode, 190, 3, 0, // Opcode: LDSPC_0R, DecodeIdx: 0
/* 140 */     MCD::OPC_FilterValue, 237, 15, 4, 0, // Skip to: 149
/* 145 */     MCD::OPC_Decode, 131, 4, 0, // Opcode: STSPC_0R, DecodeIdx: 0
/* 149 */     MCD::OPC_FilterValue, 238, 15, 4, 0, // Skip to: 158
/* 154 */     MCD::OPC_Decode, 191, 3, 0, // Opcode: LDSSR_0R, DecodeIdx: 0
/* 158 */     MCD::OPC_FilterValue, 239, 15, 4, 0, // Skip to: 167
/* 163 */     MCD::OPC_Decode, 132, 4, 0, // Opcode: STSSR_0R, DecodeIdx: 0
/* 167 */     MCD::OPC_FilterValue, 252, 15, 4, 0, // Skip to: 176
/* 172 */     MCD::OPC_Decode, 130, 4, 0, // Opcode: STSED_0R, DecodeIdx: 0
/* 176 */     MCD::OPC_FilterValue, 253, 15, 4, 0, // Skip to: 185
/* 181 */     MCD::OPC_Decode, 129, 4, 0, // Opcode: STET_0R, DecodeIdx: 0
/* 185 */     MCD::OPC_FilterValue, 254, 15, 4, 0, // Skip to: 194
/* 190 */     MCD::OPC_Decode, 135, 3, 0, // Opcode: GETED_0R, DecodeIdx: 0
/* 194 */     MCD::OPC_FilterValue, 255, 15, 4, 0, // Skip to: 203
/* 199 */     MCD::OPC_Decode, 136, 3, 0, // Opcode: GETET_0R, DecodeIdx: 0
/* 203 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 206 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 214
/* 210 */     MCD::OPC_Decode, 149, 4, 1, // Opcode: WAITET_1R, DecodeIdx: 1
/* 214 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 222
/* 218 */     MCD::OPC_Decode, 148, 4, 1, // Opcode: WAITEF_1R, DecodeIdx: 1
/* 222 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 225 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 233
/* 229 */     MCD::OPC_Decode, 149, 3, 2, // Opcode: INITDP_2r, DecodeIdx: 2
/* 233 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 241
/* 237 */     MCD::OPC_Decode, 220, 3, 4, // Opcode: OUTT_2r, DecodeIdx: 4
/* 241 */     MCD::OPC_Decode, 200, 3, 3, // Opcode: LDW_2rus, DecodeIdx: 3
/* 245 */     MCD::OPC_FilterValue, 2, 108, 0, // Skip to: 357
/* 249 */     MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 252 */     MCD::OPC_FilterValue, 236, 15, 4, 0, // Skip to: 261
/* 257 */     MCD::OPC_Decode, 239, 2, 0, // Opcode: DENTSP_0R, DecodeIdx: 0
/* 261 */     MCD::OPC_FilterValue, 237, 15, 4, 0, // Skip to: 270
/* 266 */     MCD::OPC_Decode, 243, 2, 0, // Opcode: DRESTSP_0R, DecodeIdx: 0
/* 270 */     MCD::OPC_FilterValue, 238, 15, 4, 0, // Skip to: 279
/* 275 */     MCD::OPC_Decode, 137, 3, 0, // Opcode: GETID_0R, DecodeIdx: 0
/* 279 */     MCD::OPC_FilterValue, 239, 15, 4, 0, // Skip to: 288
/* 284 */     MCD::OPC_Decode, 138, 3, 0, // Opcode: GETKEP_0R, DecodeIdx: 0
/* 288 */     MCD::OPC_FilterValue, 252, 15, 4, 0, // Skip to: 297
/* 293 */     MCD::OPC_Decode, 139, 3, 0, // Opcode: GETKSP_0R, DecodeIdx: 0
/* 297 */     MCD::OPC_FilterValue, 253, 15, 4, 0, // Skip to: 306
/* 302 */     MCD::OPC_Decode, 189, 3, 0, // Opcode: LDSED_0R, DecodeIdx: 0
/* 306 */     MCD::OPC_FilterValue, 254, 15, 4, 0, // Skip to: 315
/* 311 */     MCD::OPC_Decode, 187, 3, 0, // Opcode: LDET_0R, DecodeIdx: 0
/* 315 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 318 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 326
/* 322 */     MCD::OPC_Decode, 132, 3, 1, // Opcode: FREER_1r, DecodeIdx: 1
/* 326 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 334
/* 330 */     MCD::OPC_Decode, 208, 3, 1, // Opcode: MJOIN_1r, DecodeIdx: 1
/* 334 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 337 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 345
/* 341 */     MCD::OPC_Decode, 152, 3, 2, // Opcode: INITSP_2r, DecodeIdx: 2
/* 345 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 353
/* 349 */     MCD::OPC_Decode, 233, 3, 4, // Opcode: SETD_2r, DecodeIdx: 4
/* 353 */     MCD::OPC_Decode, 197, 2, 5, // Opcode: ADD_3r, DecodeIdx: 5
/* 357 */     MCD::OPC_FilterValue, 3, 42, 0, // Skip to: 403
/* 361 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 364 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 372
/* 368 */     MCD::OPC_Decode, 147, 4, 1, // Opcode: TSTART_1R, DecodeIdx: 1
/* 372 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 380
/* 376 */     MCD::OPC_Decode, 211, 3, 1, // Opcode: MSYNC_1r, DecodeIdx: 1
/* 380 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 383 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 391
/* 387 */     MCD::OPC_Decode, 148, 3, 2, // Opcode: INITCP_2r, DecodeIdx: 2
/* 391 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 399
/* 395 */     MCD::OPC_Decode, 145, 4, 6, // Opcode: TSETMR_2r, DecodeIdx: 6
/* 399 */     MCD::OPC_Decode, 140, 4, 5, // Opcode: SUB_3r, DecodeIdx: 5
/* 403 */     MCD::OPC_FilterValue, 4, 33, 0, // Skip to: 440
/* 407 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 410 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 418
/* 414 */     MCD::OPC_Decode, 208, 2, 1, // Opcode: BLA_1r, DecodeIdx: 1
/* 418 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 426
/* 422 */     MCD::OPC_Decode, 202, 2, 1, // Opcode: BAU_1r, DecodeIdx: 1
/* 426 */     MCD::OPC_CheckField, 4, 1, 1, 4, 0, // Skip to: 436
/* 432 */     MCD::OPC_Decode, 249, 2, 2, // Opcode: EET_2r, DecodeIdx: 2
/* 436 */     MCD::OPC_Decode, 251, 3, 5, // Opcode: SHL_3r, DecodeIdx: 5
/* 440 */     MCD::OPC_FilterValue, 5, 42, 0, // Skip to: 486
/* 444 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 447 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 455
/* 451 */     MCD::OPC_Decode, 225, 2, 1, // Opcode: BRU_1r, DecodeIdx: 1
/* 455 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 463
/* 459 */     MCD::OPC_Decode, 241, 3, 1, // Opcode: SETSP_1r, DecodeIdx: 1
/* 463 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 466 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 474
/* 470 */     MCD::OPC_Decode, 198, 2, 7, // Opcode: ANDNOT_2r, DecodeIdx: 7
/* 474 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 482
/* 478 */     MCD::OPC_Decode, 248, 2, 2, // Opcode: EEF_2r, DecodeIdx: 2
/* 482 */     MCD::OPC_Decode, 253, 3, 5, // Opcode: SHR_3r, DecodeIdx: 5
/* 486 */     MCD::OPC_FilterValue, 6, 42, 0, // Skip to: 532
/* 490 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 493 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 501
/* 497 */     MCD::OPC_Decode, 232, 3, 1, // Opcode: SETDP_1r, DecodeIdx: 1
/* 501 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 509
/* 505 */     MCD::OPC_Decode, 228, 3, 1, // Opcode: SETCP_1r, DecodeIdx: 1
/* 509 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 512 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 520
/* 516 */     MCD::OPC_Decode, 248, 3, 7, // Opcode: SEXT_2r, DecodeIdx: 7
/* 520 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 528
/* 524 */     MCD::OPC_Decode, 249, 3, 8, // Opcode: SEXT_rus, DecodeIdx: 8
/* 528 */     MCD::OPC_Decode, 255, 2, 5, // Opcode: EQ_3r, DecodeIdx: 5
/* 532 */     MCD::OPC_FilterValue, 7, 42, 0, // Skip to: 578
/* 536 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 539 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 547
/* 543 */     MCD::OPC_Decode, 240, 2, 1, // Opcode: DGETREG_1r, DecodeIdx: 1
/* 547 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 555
/* 551 */     MCD::OPC_Decode, 234, 3, 1, // Opcode: SETEV_1r, DecodeIdx: 1
/* 555 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 558 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 566
/* 562 */     MCD::OPC_Decode, 146, 3, 2, // Opcode: GETTS_2r, DecodeIdx: 2
/* 566 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 574
/* 570 */     MCD::OPC_Decode, 239, 3, 4, // Opcode: SETPT_2r, DecodeIdx: 4
/* 574 */     MCD::OPC_Decode, 199, 2, 5, // Opcode: AND_3r, DecodeIdx: 5
/* 578 */     MCD::OPC_FilterValue, 8, 42, 0, // Skip to: 624
/* 582 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 585 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 593
/* 589 */     MCD::OPC_Decode, 157, 3, 1, // Opcode: KCALL_1r, DecodeIdx: 1
/* 593 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 601
/* 597 */     MCD::OPC_Decode, 247, 3, 1, // Opcode: SETV_1r, DecodeIdx: 1
/* 601 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 604 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 612
/* 608 */     MCD::OPC_Decode, 152, 4, 7, // Opcode: ZEXT_2r, DecodeIdx: 7
/* 612 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 620
/* 616 */     MCD::OPC_Decode, 153, 4, 8, // Opcode: ZEXT_rus, DecodeIdx: 8
/* 620 */     MCD::OPC_Decode, 215, 3, 5, // Opcode: OR_3r, DecodeIdx: 5
/* 624 */     MCD::OPC_FilterValue, 9, 42, 0, // Skip to: 670
/* 628 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 631 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 639
/* 635 */     MCD::OPC_Decode, 245, 2, 1, // Opcode: ECALLF_1r, DecodeIdx: 1
/* 639 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 647
/* 643 */     MCD::OPC_Decode, 246, 2, 1, // Opcode: ECALLT_1r, DecodeIdx: 1
/* 647 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 650 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 658
/* 654 */     MCD::OPC_Decode, 216, 3, 2, // Opcode: OUTCT_2r, DecodeIdx: 2
/* 658 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 666
/* 662 */     MCD::OPC_Decode, 217, 3, 9, // Opcode: OUTCT_rus, DecodeIdx: 9
/* 666 */     MCD::OPC_Decode, 201, 3, 5, // Opcode: LDW_3r, DecodeIdx: 5
/* 670 */     MCD::OPC_FilterValue, 10, 17, 0, // Skip to: 691
/* 674 */     MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 677 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 685
/* 681 */     MCD::OPC_Decode, 134, 4, 10, // Opcode: STWDP_ru6, DecodeIdx: 10
/* 685 */     MCD::OPC_FilterValueOrFail, 1, 
/* 687 */     MCD::OPC_Decode, 136, 4, 10, // Opcode: STWSP_ru6, DecodeIdx: 10
/* 691 */     MCD::OPC_FilterValue, 11, 17, 0, // Skip to: 712
/* 695 */     MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 698 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 706
/* 702 */     MCD::OPC_Decode, 197, 3, 10, // Opcode: LDWDP_ru6, DecodeIdx: 10
/* 706 */     MCD::OPC_FilterValueOrFail, 1, 
/* 708 */     MCD::OPC_Decode, 199, 3, 10, // Opcode: LDWSP_ru6, DecodeIdx: 10
/* 712 */     MCD::OPC_FilterValue, 12, 17, 0, // Skip to: 733
/* 716 */     MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 719 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 727
/* 723 */     MCD::OPC_Decode, 180, 3, 10, // Opcode: LDAWDP_ru6, DecodeIdx: 10
/* 727 */     MCD::OPC_FilterValueOrFail, 1, 
/* 729 */     MCD::OPC_Decode, 184, 3, 10, // Opcode: LDAWSP_ru6, DecodeIdx: 10
/* 733 */     MCD::OPC_FilterValue, 13, 17, 0, // Skip to: 754
/* 737 */     MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 740 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 748
/* 744 */     MCD::OPC_Decode, 186, 3, 10, // Opcode: LDC_ru6, DecodeIdx: 10
/* 748 */     MCD::OPC_FilterValueOrFail, 1, 
/* 750 */     MCD::OPC_Decode, 194, 3, 10, // Opcode: LDWCP_ru6, DecodeIdx: 10
/* 754 */     MCD::OPC_FilterValue, 14, 87, 0, // Skip to: 845
/* 758 */     MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 761 */     MCD::OPC_FilterValue, 0, 39, 0, // Skip to: 804
/* 765 */     MCD::OPC_ExtractField, 6, 4,  // Inst{9-6} ...
/* 768 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 776
/* 772 */     MCD::OPC_Decode, 224, 2, 11, // Opcode: BRFU_u6, DecodeIdx: 11
/* 776 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 784
/* 780 */     MCD::OPC_Decode, 207, 2, 11, // Opcode: BLAT_u6, DecodeIdx: 11
/* 784 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 792
/* 788 */     MCD::OPC_Decode, 129, 3, 11, // Opcode: EXTDP_u6, DecodeIdx: 11
/* 792 */     MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 800
/* 796 */     MCD::OPC_Decode, 159, 3, 11, // Opcode: KCALL_u6, DecodeIdx: 11
/* 800 */     MCD::OPC_Decode, 222, 2, 12, // Opcode: BRFT_ru6, DecodeIdx: 12
/* 804 */     MCD::OPC_FilterValueOrFail, 1, 
/* 806 */     MCD::OPC_ExtractField, 6, 4,  // Inst{9-6} ...
/* 809 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 817
/* 813 */     MCD::OPC_Decode, 218, 2, 13, // Opcode: BRBU_u6, DecodeIdx: 13
/* 817 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 825
/* 821 */     MCD::OPC_Decode, 253, 2, 11, // Opcode: ENTSP_u6, DecodeIdx: 11
/* 825 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 833
/* 829 */     MCD::OPC_Decode, 131, 3, 11, // Opcode: EXTSP_u6, DecodeIdx: 11
/* 833 */     MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 841
/* 837 */     MCD::OPC_Decode, 226, 3, 11, // Opcode: RETSP_u6, DecodeIdx: 11
/* 841 */     MCD::OPC_Decode, 216, 2, 14, // Opcode: BRBT_ru6, DecodeIdx: 14
/* 845 */     MCD::OPC_FilterValue, 15, 71, 0, // Skip to: 920
/* 849 */     MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 852 */     MCD::OPC_FilterValue, 0, 39, 0, // Skip to: 895
/* 856 */     MCD::OPC_ExtractField, 6, 4,  // Inst{9-6} ...
/* 859 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 867
/* 863 */     MCD::OPC_Decode, 234, 2, 11, // Opcode: CLRSR_u6, DecodeIdx: 11
/* 867 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 875
/* 871 */     MCD::OPC_Decode, 245, 3, 11, // Opcode: SETSR_u6, DecodeIdx: 11
/* 875 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 883
/* 879 */     MCD::OPC_Decode, 161, 3, 11, // Opcode: KENTSP_u6, DecodeIdx: 11
/* 883 */     MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 891
/* 887 */     MCD::OPC_Decode, 163, 3, 11, // Opcode: KRESTSP_u6, DecodeIdx: 11
/* 891 */     MCD::OPC_Decode, 220, 2, 12, // Opcode: BRFF_ru6, DecodeIdx: 12
/* 895 */     MCD::OPC_FilterValueOrFail, 1, 
/* 897 */     MCD::OPC_ExtractField, 6, 4,  // Inst{9-6} ...
/* 900 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 908
/* 904 */     MCD::OPC_Decode, 144, 3, 11, // Opcode: GETSR_u6, DecodeIdx: 11
/* 908 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 916
/* 912 */     MCD::OPC_Decode, 178, 3, 11, // Opcode: LDAWCP_u6, DecodeIdx: 11
/* 916 */     MCD::OPC_Decode, 214, 2, 14, // Opcode: BRBF_ru6, DecodeIdx: 14
/* 920 */     MCD::OPC_FilterValue, 16, 42, 0, // Skip to: 966
/* 924 */     MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 927 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 935
/* 931 */     MCD::OPC_Decode, 230, 2, 1, // Opcode: CLRPT_1R, DecodeIdx: 1
/* 935 */     MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 943
/* 939 */     MCD::OPC_Decode, 141, 4, 1, // Opcode: SYNCR_1r, DecodeIdx: 1
/* 943 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 946 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 954
/* 950 */     MCD::OPC_Decode, 142, 3, 9, // Opcode: GETR_rus, DecodeIdx: 9
/* 954 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 962
/* 958 */     MCD::OPC_Decode, 147, 3, 2, // Opcode: INCT_2r, DecodeIdx: 2
/* 962 */     MCD::OPC_Decode, 166, 3, 5, // Opcode: LD16S_3r, DecodeIdx: 5
/* 966 */     MCD::OPC_FilterValue, 17, 23, 0, // Skip to: 993
/* 970 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 973 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 981
/* 977 */     MCD::OPC_Decode, 214, 3, 2, // Opcode: NOT, DecodeIdx: 2
/* 981 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 989
/* 985 */     MCD::OPC_Decode, 155, 3, 2, // Opcode: INT_2r, DecodeIdx: 2
/* 989 */     MCD::OPC_Decode, 167, 3, 5, // Opcode: LD8U_3r, DecodeIdx: 5
/* 993 */     MCD::OPC_FilterValue, 18, 23, 0, // Skip to: 1020
/* 997 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 1000 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1008
/* 1004 */    MCD::OPC_Decode, 213, 3, 2, // Opcode: NEG, DecodeIdx: 2
/* 1008 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1016
/* 1012 */    MCD::OPC_Decode, 251, 2, 2, // Opcode: ENDIN_2r, DecodeIdx: 2
/* 1016 */    MCD::OPC_Decode, 196, 2, 3, // Opcode: ADD_2rus, DecodeIdx: 3
/* 1020 */    MCD::OPC_FilterValue, 19, 4, 0, // Skip to: 1028
/* 1024 */    MCD::OPC_Decode, 139, 4, 3, // Opcode: SUB_2rus, DecodeIdx: 3
/* 1028 */    MCD::OPC_FilterValue, 20, 23, 0, // Skip to: 1055
/* 1032 */    MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 1035 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1043
/* 1039 */    MCD::OPC_Decode, 209, 3, 2, // Opcode: MKMSK_2r, DecodeIdx: 2
/* 1043 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1051
/* 1047 */    MCD::OPC_Decode, 210, 3, 15, // Opcode: MKMSK_rus, DecodeIdx: 15
/* 1051 */    MCD::OPC_Decode, 250, 3, 16, // Opcode: SHL_2rus, DecodeIdx: 16
/* 1055 */    MCD::OPC_FilterValue, 21, 23, 0, // Skip to: 1082
/* 1059 */    MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 1062 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1070
/* 1066 */    MCD::OPC_Decode, 221, 3, 4, // Opcode: OUT_2r, DecodeIdx: 4
/* 1070 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1078
/* 1074 */    MCD::OPC_Decode, 219, 3, 7, // Opcode: OUTSHR_2r, DecodeIdx: 7
/* 1078 */    MCD::OPC_Decode, 252, 3, 16, // Opcode: SHR_2rus, DecodeIdx: 16
/* 1082 */    MCD::OPC_FilterValue, 22, 23, 0, // Skip to: 1109
/* 1086 */    MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 1089 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1097
/* 1093 */    MCD::OPC_Decode, 156, 3, 2, // Opcode: IN_2r, DecodeIdx: 2
/* 1097 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1105
/* 1101 */    MCD::OPC_Decode, 154, 3, 7, // Opcode: INSHR_2r, DecodeIdx: 7
/* 1105 */    MCD::OPC_Decode, 254, 2, 3, // Opcode: EQ_2rus, DecodeIdx: 3
/* 1109 */    MCD::OPC_FilterValue, 23, 23, 0, // Skip to: 1136
/* 1113 */    MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 1116 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1124
/* 1120 */    MCD::OPC_Decode, 222, 3, 2, // Opcode: PEEK_2r, DecodeIdx: 2
/* 1124 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1132
/* 1128 */    MCD::OPC_Decode, 142, 4, 2, // Opcode: TESTCT_2r, DecodeIdx: 2
/* 1132 */    MCD::OPC_Decode, 146, 4, 17, // Opcode: TSETR_3r, DecodeIdx: 17
/* 1136 */    MCD::OPC_FilterValue, 24, 23, 0, // Skip to: 1163
/* 1140 */    MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 1143 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1151
/* 1147 */    MCD::OPC_Decode, 237, 3, 4, // Opcode: SETPSC_2r, DecodeIdx: 4
/* 1151 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1159
/* 1155 */    MCD::OPC_Decode, 144, 4, 2, // Opcode: TESTWCT_2r, DecodeIdx: 2
/* 1159 */    MCD::OPC_Decode, 203, 3, 5, // Opcode: LSS_3r, DecodeIdx: 5
/* 1163 */    MCD::OPC_FilterValue, 25, 23, 0, // Skip to: 1190
/* 1167 */    MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 1170 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1178
/* 1174 */    MCD::OPC_Decode, 227, 2, 2, // Opcode: CHKCT_2r, DecodeIdx: 2
/* 1178 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1186
/* 1182 */    MCD::OPC_Decode, 228, 2, 15, // Opcode: CHKCT_rus, DecodeIdx: 15
/* 1186 */    MCD::OPC_Decode, 205, 3, 5, // Opcode: LSU_3r, DecodeIdx: 5
/* 1190 */    MCD::OPC_FilterValue, 26, 17, 0, // Skip to: 1211
/* 1194 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 1197 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1205
/* 1201 */    MCD::OPC_Decode, 212, 2, 18, // Opcode: BLRF_u10, DecodeIdx: 18
/* 1205 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1207 */    MCD::OPC_Decode, 210, 2, 19, // Opcode: BLRB_u10, DecodeIdx: 19
/* 1211 */    MCD::OPC_FilterValue, 27, 17, 0, // Skip to: 1232
/* 1215 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 1218 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1226
/* 1222 */    MCD::OPC_Decode, 174, 3, 18, // Opcode: LDAPF_u10, DecodeIdx: 18
/* 1226 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1228 */    MCD::OPC_Decode, 171, 3, 19, // Opcode: LDAPB_u10, DecodeIdx: 19
/* 1232 */    MCD::OPC_FilterValue, 28, 17, 0, // Skip to: 1253
/* 1236 */    MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 1239 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1247
/* 1243 */    MCD::OPC_Decode, 205, 2, 18, // Opcode: BLACP_u10, DecodeIdx: 18
/* 1247 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1249 */    MCD::OPC_Decode, 195, 3, 18, // Opcode: LDWCP_u10, DecodeIdx: 18
/* 1253 */    MCD::OPC_FilterValueOrFail, 29, 
/* 1255 */    MCD::OPC_CheckFieldOrFail, 10, 1, 0, 
/* 1259 */    MCD::OPC_Decode, 231, 3, 12, // Opcode: SETC_ru6, DecodeIdx: 12
/* 1263 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTable32[] = {
/* 0 */       MCD::OPC_ExtractField, 27, 5,  // Inst{31-27} ...
/* 3 */       MCD::OPC_FilterValue, 0, 91, 0, // Skip to: 98
/* 7 */       MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 10 */      MCD::OPC_FilterValueOrFail, 31, 
/* 12 */      MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 15 */      MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 30
/* 19 */      MCD::OPC_CheckField, 16, 11, 236, 15, 19, 0, // Skip to: 45
/* 26 */      MCD::OPC_Decode, 203, 2, 20, // Opcode: BITREV_l2r, DecodeIdx: 20
/* 30 */      MCD::OPC_FilterValue, 1, 11, 0, // Skip to: 45
/* 34 */      MCD::OPC_CheckField, 16, 11, 236, 15, 4, 0, // Skip to: 45
/* 41 */      MCD::OPC_Decode, 226, 2, 20, // Opcode: BYTEREV_l2r, DecodeIdx: 20
/* 45 */      MCD::OPC_CheckField, 16, 11, 236, 15, 4, 0, // Skip to: 56
/* 52 */      MCD::OPC_Decode, 138, 4, 21, // Opcode: STW_l3r, DecodeIdx: 21
/* 56 */      MCD::OPC_ExtractField, 20, 7,  // Inst{26-20} ...
/* 59 */      MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 67
/* 63 */      MCD::OPC_Decode, 236, 2, 22, // Opcode: CRC8_l4r, DecodeIdx: 22
/* 67 */      MCD::OPC_FilterValue, 127, 4, 0, // Skip to: 75
/* 71 */      MCD::OPC_Decode, 207, 3, 23, // Opcode: MACCU_l4r, DecodeIdx: 23
/* 75 */      MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 78 */      MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 86
/* 82 */      MCD::OPC_Decode, 188, 3, 24, // Opcode: LDIVU_l5r, DecodeIdx: 24
/* 86 */      MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 94
/* 90 */      MCD::OPC_Decode, 165, 3, 24, // Opcode: LADD_l5r, DecodeIdx: 24
/* 94 */      MCD::OPC_Decode, 202, 3, 25, // Opcode: LMUL_l6r, DecodeIdx: 25
/* 98 */      MCD::OPC_FilterValue, 1, 83, 0, // Skip to: 185
/* 102 */     MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 105 */     MCD::OPC_FilterValueOrFail, 31, 
/* 107 */     MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 110 */     MCD::OPC_FilterValueOrFail, 0, 
/* 112 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 115 */     MCD::OPC_FilterValue, 0, 16, 0, // Skip to: 135
/* 119 */     MCD::OPC_CheckField, 21, 6, 63, 30, 0, // Skip to: 155
/* 125 */     MCD::OPC_CheckField, 16, 4, 12, 24, 0, // Skip to: 155
/* 131 */     MCD::OPC_Decode, 235, 2, 20, // Opcode: CLZ_l2r, DecodeIdx: 20
/* 135 */     MCD::OPC_FilterValue, 1, 16, 0, // Skip to: 155
/* 139 */     MCD::OPC_CheckField, 21, 6, 63, 10, 0, // Skip to: 155
/* 145 */     MCD::OPC_CheckField, 16, 4, 12, 4, 0, // Skip to: 155
/* 151 */     MCD::OPC_Decode, 227, 3, 26, // Opcode: SETCLK_l2r, DecodeIdx: 26
/* 155 */     MCD::OPC_CheckField, 21, 6, 63, 10, 0, // Skip to: 171
/* 161 */     MCD::OPC_CheckField, 16, 4, 12, 4, 0, // Skip to: 171
/* 167 */     MCD::OPC_Decode, 151, 4, 21, // Opcode: XOR_l3r, DecodeIdx: 21
/* 171 */     MCD::OPC_CheckField, 21, 6, 63, 4, 0, // Skip to: 181
/* 177 */     MCD::OPC_Decode, 206, 3, 23, // Opcode: MACCS_l4r, DecodeIdx: 23
/* 181 */     MCD::OPC_Decode, 204, 3, 24, // Opcode: LSUB_l5r, DecodeIdx: 24
/* 185 */     MCD::OPC_FilterValue, 2, 30, 0, // Skip to: 219
/* 189 */     MCD::OPC_ExtractField, 11, 16,  // Inst{26-11} ...
/* 192 */     MCD::OPC_FilterValueOrFail, 159, 251, 3, 
/* 196 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 199 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 207
/* 203 */     MCD::OPC_Decode, 150, 3, 20, // Opcode: INITLR_l2r, DecodeIdx: 20
/* 207 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 215
/* 211 */     MCD::OPC_Decode, 141, 3, 20, // Opcode: GETPS_l2r, DecodeIdx: 20
/* 215 */     MCD::OPC_Decode, 201, 2, 21, // Opcode: ASHR_l3r, DecodeIdx: 21
/* 219 */     MCD::OPC_FilterValue, 3, 30, 0, // Skip to: 253
/* 223 */     MCD::OPC_ExtractField, 11, 16,  // Inst{26-11} ...
/* 226 */     MCD::OPC_FilterValueOrFail, 159, 251, 3, 
/* 230 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 233 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 241
/* 237 */     MCD::OPC_Decode, 238, 3, 26, // Opcode: SETPS_l2r, DecodeIdx: 26
/* 241 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 249
/* 245 */     MCD::OPC_Decode, 134, 3, 20, // Opcode: GETD_l2r, DecodeIdx: 20
/* 249 */     MCD::OPC_Decode, 182, 3, 21, // Opcode: LDAWF_l3r, DecodeIdx: 21
/* 253 */     MCD::OPC_FilterValue, 4, 30, 0, // Skip to: 287
/* 257 */     MCD::OPC_ExtractField, 11, 16,  // Inst{26-11} ...
/* 260 */     MCD::OPC_FilterValueOrFail, 159, 251, 3, 
/* 264 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 267 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 275
/* 271 */     MCD::OPC_Decode, 143, 4, 20, // Opcode: TESTLCL_l2r, DecodeIdx: 20
/* 275 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 283
/* 279 */     MCD::OPC_Decode, 246, 3, 26, // Opcode: SETTW_l2r, DecodeIdx: 26
/* 283 */     MCD::OPC_Decode, 176, 3, 21, // Opcode: LDAWB_l3r, DecodeIdx: 21
/* 287 */     MCD::OPC_FilterValue, 5, 30, 0, // Skip to: 321
/* 291 */     MCD::OPC_ExtractField, 11, 16,  // Inst{26-11} ...
/* 294 */     MCD::OPC_FilterValueOrFail, 159, 251, 3, 
/* 298 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 301 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 309
/* 305 */     MCD::OPC_Decode, 240, 3, 26, // Opcode: SETRDY_l2r, DecodeIdx: 26
/* 309 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 317
/* 313 */     MCD::OPC_Decode, 229, 3, 20, // Opcode: SETC_l2r, DecodeIdx: 20
/* 317 */     MCD::OPC_Decode, 169, 3, 21, // Opcode: LDA16F_l3r, DecodeIdx: 21
/* 321 */     MCD::OPC_FilterValue, 6, 30, 0, // Skip to: 355
/* 325 */     MCD::OPC_ExtractField, 11, 16,  // Inst{26-11} ...
/* 328 */     MCD::OPC_FilterValueOrFail, 159, 251, 3, 
/* 332 */     MCD::OPC_ExtractField, 4, 1,  // Inst{4} ...
/* 335 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 343
/* 339 */     MCD::OPC_Decode, 236, 3, 26, // Opcode: SETN_l2r, DecodeIdx: 26
/* 343 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 351
/* 347 */     MCD::OPC_Decode, 140, 3, 20, // Opcode: GETN_l2r, DecodeIdx: 20
/* 351 */     MCD::OPC_Decode, 168, 3, 21, // Opcode: LDA16B_l3r, DecodeIdx: 21
/* 355 */     MCD::OPC_FilterValue, 7, 10, 0, // Skip to: 369
/* 359 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 365 */     MCD::OPC_Decode, 212, 3, 21, // Opcode: MUL_l3r, DecodeIdx: 21
/* 369 */     MCD::OPC_FilterValue, 8, 10, 0, // Skip to: 383
/* 373 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 379 */     MCD::OPC_Decode, 241, 2, 21, // Opcode: DIVS_l3r, DecodeIdx: 21
/* 383 */     MCD::OPC_FilterValue, 9, 10, 0, // Skip to: 397
/* 387 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 393 */     MCD::OPC_Decode, 242, 2, 21, // Opcode: DIVU_l3r, DecodeIdx: 21
/* 397 */     MCD::OPC_FilterValue, 10, 25, 0, // Skip to: 426
/* 401 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 404 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 416
/* 408 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 412 */     MCD::OPC_Decode, 133, 4, 27, // Opcode: STWDP_lru6, DecodeIdx: 27
/* 416 */     MCD::OPC_FilterValueOrFail, 1, 
/* 418 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 422 */     MCD::OPC_Decode, 135, 4, 27, // Opcode: STWSP_lru6, DecodeIdx: 27
/* 426 */     MCD::OPC_FilterValue, 11, 25, 0, // Skip to: 455
/* 430 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 433 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 445
/* 437 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 441 */     MCD::OPC_Decode, 196, 3, 27, // Opcode: LDWDP_lru6, DecodeIdx: 27
/* 445 */     MCD::OPC_FilterValueOrFail, 1, 
/* 447 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 451 */     MCD::OPC_Decode, 198, 3, 27, // Opcode: LDWSP_lru6, DecodeIdx: 27
/* 455 */     MCD::OPC_FilterValue, 12, 25, 0, // Skip to: 484
/* 459 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 462 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 474
/* 466 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 470 */     MCD::OPC_Decode, 179, 3, 27, // Opcode: LDAWDP_lru6, DecodeIdx: 27
/* 474 */     MCD::OPC_FilterValueOrFail, 1, 
/* 476 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 480 */     MCD::OPC_Decode, 183, 3, 27, // Opcode: LDAWSP_lru6, DecodeIdx: 27
/* 484 */     MCD::OPC_FilterValue, 13, 25, 0, // Skip to: 513
/* 488 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 491 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 503
/* 495 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 499 */     MCD::OPC_Decode, 185, 3, 27, // Opcode: LDC_lru6, DecodeIdx: 27
/* 503 */     MCD::OPC_FilterValueOrFail, 1, 
/* 505 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 509 */     MCD::OPC_Decode, 192, 3, 27, // Opcode: LDWCP_lru6, DecodeIdx: 27
/* 513 */     MCD::OPC_FilterValue, 14, 97, 0, // Skip to: 614
/* 517 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 520 */     MCD::OPC_FilterValue, 0, 44, 0, // Skip to: 568
/* 524 */     MCD::OPC_ExtractField, 10, 6,  // Inst{15-10} ...
/* 527 */     MCD::OPC_FilterValueOrFail, 60, 
/* 529 */     MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 532 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 540
/* 536 */     MCD::OPC_Decode, 223, 2, 28, // Opcode: BRFU_lu6, DecodeIdx: 28
/* 540 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 548
/* 544 */     MCD::OPC_Decode, 206, 2, 28, // Opcode: BLAT_lu6, DecodeIdx: 28
/* 548 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 556
/* 552 */     MCD::OPC_Decode, 128, 3, 28, // Opcode: EXTDP_lu6, DecodeIdx: 28
/* 556 */     MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 564
/* 560 */     MCD::OPC_Decode, 158, 3, 28, // Opcode: KCALL_lu6, DecodeIdx: 28
/* 564 */     MCD::OPC_Decode, 221, 2, 29, // Opcode: BRFT_lru6, DecodeIdx: 29
/* 568 */     MCD::OPC_FilterValueOrFail, 1, 
/* 570 */     MCD::OPC_ExtractField, 10, 6,  // Inst{15-10} ...
/* 573 */     MCD::OPC_FilterValueOrFail, 60, 
/* 575 */     MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 578 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 586
/* 582 */     MCD::OPC_Decode, 217, 2, 30, // Opcode: BRBU_lu6, DecodeIdx: 30
/* 586 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 594
/* 590 */     MCD::OPC_Decode, 252, 2, 28, // Opcode: ENTSP_lu6, DecodeIdx: 28
/* 594 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 602
/* 598 */     MCD::OPC_Decode, 130, 3, 28, // Opcode: EXTSP_lu6, DecodeIdx: 28
/* 602 */     MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 610
/* 606 */     MCD::OPC_Decode, 225, 3, 28, // Opcode: RETSP_lu6, DecodeIdx: 28
/* 610 */     MCD::OPC_Decode, 215, 2, 31, // Opcode: BRBT_lru6, DecodeIdx: 31
/* 614 */     MCD::OPC_FilterValue, 15, 81, 0, // Skip to: 699
/* 618 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 621 */     MCD::OPC_FilterValue, 0, 44, 0, // Skip to: 669
/* 625 */     MCD::OPC_ExtractField, 10, 6,  // Inst{15-10} ...
/* 628 */     MCD::OPC_FilterValueOrFail, 60, 
/* 630 */     MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 633 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 641
/* 637 */     MCD::OPC_Decode, 233, 2, 28, // Opcode: CLRSR_lu6, DecodeIdx: 28
/* 641 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 649
/* 645 */     MCD::OPC_Decode, 244, 3, 28, // Opcode: SETSR_lu6, DecodeIdx: 28
/* 649 */     MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 657
/* 653 */     MCD::OPC_Decode, 160, 3, 28, // Opcode: KENTSP_lu6, DecodeIdx: 28
/* 657 */     MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 665
/* 661 */     MCD::OPC_Decode, 162, 3, 28, // Opcode: KRESTSP_lu6, DecodeIdx: 28
/* 665 */     MCD::OPC_Decode, 219, 2, 29, // Opcode: BRFF_lru6, DecodeIdx: 29
/* 669 */     MCD::OPC_FilterValueOrFail, 1, 
/* 671 */     MCD::OPC_ExtractField, 10, 6,  // Inst{15-10} ...
/* 674 */     MCD::OPC_FilterValueOrFail, 60, 
/* 676 */     MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 679 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 687
/* 683 */     MCD::OPC_Decode, 143, 3, 28, // Opcode: GETSR_lu6, DecodeIdx: 28
/* 687 */     MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 695
/* 691 */     MCD::OPC_Decode, 177, 3, 28, // Opcode: LDAWCP_lu6, DecodeIdx: 28
/* 695 */     MCD::OPC_Decode, 213, 2, 31, // Opcode: BRBF_lru6, DecodeIdx: 31
/* 699 */     MCD::OPC_FilterValue, 16, 10, 0, // Skip to: 713
/* 703 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 709 */     MCD::OPC_Decode, 255, 3, 21, // Opcode: ST16_l3r, DecodeIdx: 21
/* 713 */     MCD::OPC_FilterValue, 17, 10, 0, // Skip to: 727
/* 717 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 723 */     MCD::OPC_Decode, 128, 4, 21, // Opcode: ST8_l3r, DecodeIdx: 21
/* 727 */     MCD::OPC_FilterValue, 18, 31, 0, // Skip to: 762
/* 731 */     MCD::OPC_ExtractField, 11, 16,  // Inst{26-11} ...
/* 734 */     MCD::OPC_FilterValue, 159, 251, 3, 4, 0, // Skip to: 744
/* 740 */     MCD::OPC_Decode, 200, 2, 32, // Opcode: ASHR_l2rus, DecodeIdx: 32
/* 744 */     MCD::OPC_FilterValue, 191, 251, 3, 4, 0, // Skip to: 754
/* 750 */     MCD::OPC_Decode, 218, 3, 32, // Opcode: OUTPW_l2rus, DecodeIdx: 32
/* 754 */     MCD::OPC_FilterValueOrFail, 223, 251, 3, 
/* 758 */     MCD::OPC_Decode, 153, 3, 32, // Opcode: INPW_l2rus, DecodeIdx: 32
/* 762 */     MCD::OPC_FilterValue, 19, 10, 0, // Skip to: 776
/* 766 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 772 */     MCD::OPC_Decode, 181, 3, 33, // Opcode: LDAWF_l2rus, DecodeIdx: 33
/* 776 */     MCD::OPC_FilterValue, 20, 10, 0, // Skip to: 790
/* 780 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 786 */     MCD::OPC_Decode, 175, 3, 33, // Opcode: LDAWB_l2rus, DecodeIdx: 33
/* 790 */     MCD::OPC_FilterValue, 21, 10, 0, // Skip to: 804
/* 794 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 800 */     MCD::OPC_Decode, 237, 2, 34, // Opcode: CRC_l3r, DecodeIdx: 34
/* 804 */     MCD::OPC_FilterValue, 24, 10, 0, // Skip to: 818
/* 808 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 814 */     MCD::OPC_Decode, 223, 3, 21, // Opcode: REMS_l3r, DecodeIdx: 21
/* 818 */     MCD::OPC_FilterValue, 25, 10, 0, // Skip to: 832
/* 822 */     MCD::OPC_CheckFieldOrFail, 11, 16, 159, 251, 3, 
/* 828 */     MCD::OPC_Decode, 224, 3, 21, // Opcode: REMU_l3r, DecodeIdx: 21
/* 832 */     MCD::OPC_FilterValue, 26, 25, 0, // Skip to: 861
/* 836 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 839 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 851
/* 843 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 847 */     MCD::OPC_Decode, 211, 2, 35, // Opcode: BLRF_lu10, DecodeIdx: 35
/* 851 */     MCD::OPC_FilterValueOrFail, 1, 
/* 853 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 857 */     MCD::OPC_Decode, 209, 2, 36, // Opcode: BLRB_lu10, DecodeIdx: 36
/* 861 */     MCD::OPC_FilterValue, 27, 25, 0, // Skip to: 890
/* 865 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 868 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 880
/* 872 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 876 */     MCD::OPC_Decode, 172, 3, 35, // Opcode: LDAPF_lu10, DecodeIdx: 35
/* 880 */     MCD::OPC_FilterValueOrFail, 1, 
/* 882 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 886 */     MCD::OPC_Decode, 170, 3, 36, // Opcode: LDAPB_lu10, DecodeIdx: 36
/* 890 */     MCD::OPC_FilterValue, 28, 25, 0, // Skip to: 919
/* 894 */     MCD::OPC_ExtractField, 26, 1,  // Inst{26} ...
/* 897 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 909
/* 901 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 905 */     MCD::OPC_Decode, 204, 2, 35, // Opcode: BLACP_lu10, DecodeIdx: 35
/* 909 */     MCD::OPC_FilterValueOrFail, 1, 
/* 911 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 915 */     MCD::OPC_Decode, 193, 3, 35, // Opcode: LDWCP_lu10, DecodeIdx: 35
/* 919 */     MCD::OPC_FilterValueOrFail, 29, 
/* 921 */     MCD::OPC_CheckFieldOrFail, 26, 1, 0, 
/* 925 */     MCD::OPC_CheckFieldOrFail, 10, 6, 60, 
/* 929 */     MCD::OPC_Decode, 230, 3, 29, // Opcode: SETC_lru6, DecodeIdx: 29
/* 933 */     MCD::OPC_Fail,
  0
};

// Handling 37 cases.
template <typename InsnType>
static DecodeStatus decodeToMCInst(unsigned Idx, DecodeStatus S, InsnType insn, MCInst &MI, uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 2:
    if (!Check(S, Decode2RInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 3:
    if (!Check(S, Decode2RUSInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 4:
    if (!Check(S, DecodeR2RInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    if (!Check(S, Decode3RInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    if (!Check(S, Decode2RImmInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 7:
    if (!Check(S, Decode2RSrcDstInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 8:
    if (!Check(S, DecodeRUSSrcDstBitpInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 9:
    if (!Check(S, DecodeRUSInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 6, 4);
    if (!Check(S, DecodeRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 6, 4);
    if (!Check(S, DecodeGRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 0, 6);
    if (!Check(S, DecodeNegImmOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 6, 4);
    if (!Check(S, DecodeGRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 6);
    if (!Check(S, DecodeNegImmOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 15:
    if (!Check(S, DecodeRUSBitpInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 16:
    if (!Check(S, Decode2RUSBitpInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 17:
    if (!Check(S, Decode3RImmInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 18:
    tmp = fieldFromInstruction(insn, 0, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 19:
    tmp = fieldFromInstruction(insn, 0, 10);
    if (!Check(S, DecodeNegImmOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 20:
    if (!Check(S, DecodeL2RInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 21:
    if (!Check(S, DecodeL3RInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 22:
    if (!Check(S, DecodeL4RSrcDstInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 23:
    if (!Check(S, DecodeL4RSrcDstSrcDstInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 24:
    if (!Check(S, DecodeL5RInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 25:
    if (!Check(S, DecodeL6RInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 26:
    if (!Check(S, DecodeLR2RInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 22, 4);
    if (!Check(S, DecodeRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 6, 10);
    insertBits(tmp, fieldFromInstruction(insn, 16, 6), 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 28:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 6, 10);
    insertBits(tmp, fieldFromInstruction(insn, 16, 6), 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 22, 4);
    if (!Check(S, DecodeGRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 6, 10);
    insertBits(tmp, fieldFromInstruction(insn, 16, 6), 0, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 30:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 6, 10);
    insertBits(tmp, fieldFromInstruction(insn, 16, 6), 0, 6);
    if (!Check(S, DecodeNegImmOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 31:
    tmp = fieldFromInstruction(insn, 22, 4);
    if (!Check(S, DecodeGRRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 6, 10);
    insertBits(tmp, fieldFromInstruction(insn, 16, 6), 0, 6);
    if (!Check(S, DecodeNegImmOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 32:
    if (!Check(S, DecodeL2RUSBitpInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 33:
    if (!Check(S, DecodeL2RUSInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 34:
    if (!Check(S, DecodeL3RSrcDstInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 35:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 10, 10);
    insertBits(tmp, fieldFromInstruction(insn, 16, 10), 0, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 36:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 10, 10);
    insertBits(tmp, fieldFromInstruction(insn, 16, 10), 0, 10);
    if (!Check(S, DecodeNegImmOperand(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

static unsigned decodeNumToSkip(const uint8_t *&Ptr) {
  unsigned NumToSkip = *Ptr++;
  NumToSkip |= (*Ptr++) << 8;
  return NumToSkip;
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    const uint8_t DecoderOp = *Ptr++;
    switch (DecoderOp) {
    default:
      errs() << Loc << ": Unexpected decode table opcode: "
             << (int)DecoderOp << '\n';
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue:
    case MCD::OPC_FilterValueOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_FilterValueOrFail;
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(Ptr);
      bool Failed = Val != CurFieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      // Note: Print NumToSkip even for OPC_FilterValueOrFail to simplify debug
      // prints.
      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_FilterValueOrFail" : "OPC_FilterValue";
        dbgs() << Loc << ": " << OpName << '(' << Val << ", " << NumToSkip
                << ") " << (Failed ? "FAIL:" : "PASS:")
                << " continuing at " << (Ptr - DecodeTable) << '\n';
      });

      // Perform the filter operation.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckField:
    case MCD::OPC_CheckFieldOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckFieldOrFail;
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      bool Failed = ExpectedValue != FieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckFieldOrFail" : "OPC_CheckField";
        dbgs() << Loc << ": " << OpName << '(' << Start << ", " << Len << ", "
                << ExpectedValue << ", " << NumToSkip << "): FieldValue = "
                << FieldValue << ", ExpectedValue = " << ExpectedValue << ": "
                << (Failed ? "FAIL\n" : "PASS\n");
      });

      // If the actual and expected values don't match, skip or fail.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(DecodeIdx, S, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS\n" : "FAIL\n"));
      return S;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // namespace
