/* src/bazaar.p/bz-blocklist-condition.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-blocklist-condition.h"

G_DEFINE_ENUM_TYPE (
    BzBlocklistConditionPostProcessKind,
    bz_blocklist_condition_post_process_kind,
    G_DEFINE_ENUM_VALUE (BZ_BLOCKLIST_CONDITION_POST_PROCESS_KIND_IDENTITY, "identity"),
    G_DEFINE_ENUM_VALUE (BZ_BLOCKLIST_CONDITION_POST_PROCESS_KIND_INVERT, "invert"));

struct _BzBlocklistCondition
{
  GObject parent_instance;

  BzBlocklistConditionMatchEnvvar *match_envvar;
  BzBlocklistConditionMatchLocale *match_locale;
  BzBlocklistConditionPostProcessKind post_process;
};

G_DEFINE_FINAL_TYPE (BzBlocklistCondition, bz_blocklist_condition, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_MATCH_ENVVAR,
  PROP_MATCH_LOCALE,
  PROP_POST_PROCESS,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_blocklist_condition_dispose (GObject *object)
{
  BzBlocklistCondition *self = BZ_BLOCKLIST_CONDITION (object);

  g_clear_pointer (&self->match_envvar, g_object_unref);
  g_clear_pointer (&self->match_locale, g_object_unref);

  G_OBJECT_CLASS (bz_blocklist_condition_parent_class)->dispose (object);
}

static void
bz_blocklist_condition_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzBlocklistCondition *self = BZ_BLOCKLIST_CONDITION (object);

  switch (prop_id)
    {
    case PROP_MATCH_ENVVAR:
      g_value_set_object (value, bz_blocklist_condition_get_match_envvar (self));
      break;
    case PROP_MATCH_LOCALE:
      g_value_set_object (value, bz_blocklist_condition_get_match_locale (self));
      break;
    case PROP_POST_PROCESS:
      g_value_set_enum (value, bz_blocklist_condition_get_post_process (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_blocklist_condition_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzBlocklistCondition *self = BZ_BLOCKLIST_CONDITION (object);

  switch (prop_id)
    {
    case PROP_MATCH_ENVVAR:
      bz_blocklist_condition_set_match_envvar (self, g_value_get_object (value));
      break;
    case PROP_MATCH_LOCALE:
      bz_blocklist_condition_set_match_locale (self, g_value_get_object (value));
      break;
    case PROP_POST_PROCESS:
      bz_blocklist_condition_set_post_process (self, g_value_get_enum (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_blocklist_condition_class_init (BzBlocklistConditionClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_blocklist_condition_set_property;
  object_class->get_property = bz_blocklist_condition_get_property;
  object_class->dispose      = bz_blocklist_condition_dispose;

  props[PROP_MATCH_ENVVAR] =
      g_param_spec_object (
          "match-envvar",
          NULL, NULL,
          BZ_TYPE_BLOCKLIST_CONDITION_MATCH_ENVVAR,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_MATCH_LOCALE] =
      g_param_spec_object (
          "match-locale",
          NULL, NULL,
          BZ_TYPE_BLOCKLIST_CONDITION_MATCH_LOCALE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_POST_PROCESS] =
      g_param_spec_enum (
          "post-process",
          NULL, NULL,
          BZ_TYPE_BLOCKLIST_CONDITION_POST_PROCESS_KIND, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_blocklist_condition_init (BzBlocklistCondition *self)
{
}

BzBlocklistCondition *
bz_blocklist_condition_new (void){
  return g_object_new (BZ_TYPE_BLOCKLIST_CONDITION, NULL);
}

BzBlocklistConditionMatchEnvvar *
bz_blocklist_condition_get_match_envvar (BzBlocklistCondition *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST_CONDITION (self), NULL);
  return self->match_envvar;
}

BzBlocklistConditionMatchLocale *
bz_blocklist_condition_get_match_locale (BzBlocklistCondition *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST_CONDITION (self), NULL);
  return self->match_locale;
}

BzBlocklistConditionPostProcessKind
bz_blocklist_condition_get_post_process (BzBlocklistCondition *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST_CONDITION (self), 0);
  return self->post_process;
}

void
bz_blocklist_condition_set_match_envvar (BzBlocklistCondition *self,
    BzBlocklistConditionMatchEnvvar *match_envvar){
  g_return_if_fail (BZ_IS_BLOCKLIST_CONDITION (self));

  if (match_envvar == self->match_envvar)
    return;

  g_clear_pointer (&self->match_envvar, g_object_unref);
  if (match_envvar != NULL)
    self->match_envvar = g_object_ref (match_envvar);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_MATCH_ENVVAR]);
}

void
bz_blocklist_condition_set_match_locale (BzBlocklistCondition *self,
    BzBlocklistConditionMatchLocale *match_locale){
  g_return_if_fail (BZ_IS_BLOCKLIST_CONDITION (self));

  if (match_locale == self->match_locale)
    return;

  g_clear_pointer (&self->match_locale, g_object_unref);
  if (match_locale != NULL)
    self->match_locale = g_object_ref (match_locale);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_MATCH_LOCALE]);
}

void
bz_blocklist_condition_set_post_process (BzBlocklistCondition *self,
    BzBlocklistConditionPostProcessKind post_process){
  g_return_if_fail (BZ_IS_BLOCKLIST_CONDITION (self));

  if (post_process == self->post_process)
    return;

  self->post_process = post_process;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_POST_PROCESS]);
}

/* End of src/bazaar.p/bz-blocklist-condition.c */
