/* src/bazaar.p/bz-blocklist-condition.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include "bz-blocklist-condition-match-envvar.h"
#include "bz-blocklist-condition-match-locale.h"

G_BEGIN_DECLS

typedef enum
{
  BZ_BLOCKLIST_CONDITION_POST_PROCESS_KIND_IDENTITY,
  BZ_BLOCKLIST_CONDITION_POST_PROCESS_KIND_INVERT,
} BzBlocklistConditionPostProcessKind;
GType bz_blocklist_condition_post_process_kind_get_type (void);
#define BZ_TYPE_BLOCKLIST_CONDITION_POST_PROCESS_KIND (bz_blocklist_condition_post_process_kind_get_type ())

#define BZ_TYPE_BLOCKLIST_CONDITION (bz_blocklist_condition_get_type ())
G_DECLARE_FINAL_TYPE (BzBlocklistCondition, bz_blocklist_condition, BZ, BLOCKLIST_CONDITION, GObject)

BzBlocklistCondition *
bz_blocklist_condition_new (void);

BzBlocklistConditionMatchEnvvar *
bz_blocklist_condition_get_match_envvar (BzBlocklistCondition *self);

BzBlocklistConditionMatchLocale *
bz_blocklist_condition_get_match_locale (BzBlocklistCondition *self);

BzBlocklistConditionPostProcessKind
bz_blocklist_condition_get_post_process (BzBlocklistCondition *self);

void
bz_blocklist_condition_set_match_envvar (BzBlocklistCondition *self,
    BzBlocklistConditionMatchEnvvar *match_envvar);

void
bz_blocklist_condition_set_match_locale (BzBlocklistCondition *self,
    BzBlocklistConditionMatchLocale *match_locale);

void
bz_blocklist_condition_set_post_process (BzBlocklistCondition *self,
    BzBlocklistConditionPostProcessKind post_process);

G_END_DECLS

/* End of src/bazaar.p/bz-blocklist-condition.h */
