/* StatusApplet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from StatusApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "statusapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libpeas.h>

#define GNOME_SETTINGS_SCHEMA "org.gnome.desktop.interface"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	STATUS_PLUGIN_0_PROPERTY,
	STATUS_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* status_plugin_properties[STATUS_PLUGIN_NUM_PROPERTIES];
enum  {
	STATUS_SETTINGS_0_PROPERTY,
	STATUS_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* status_settings_properties[STATUS_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	STATUS_APPLET_0_PROPERTY,
	STATUS_APPLET_UUID_PROPERTY,
	STATUS_APPLET_NUM_PROPERTIES
};
static GParamSpec* status_applet_properties[STATUS_APPLET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;

struct _StatusSettingsPrivate {
	GSettings* settings;
	GSettings* gnome_settings;
	GtkSpinButton* spinbutton_spacing;
	GtkSwitch* switch_show_battery_percentage;
};

struct _StatusAppletPrivate {
	gchar* _uuid;
	GSettings* settings;
	GSettings* gnome_settings;
	BudgiePopoverManager* manager;
};

struct _Block1Data {
	int _ref_count_;
	StatusApplet* self;
	GtkWidget* parent_widget;
	BudgiePopover* popover;
};

static gpointer status_plugin_parent_class = NULL;
static BudgiePluginIface * status_plugin_budgie_plugin_parent_iface = NULL;
static GType status_plugin_type_id = 0;
static gint StatusSettings_private_offset;
static gpointer status_settings_parent_class = NULL;
static GType status_settings_type_id = 0;
static gint StatusApplet_private_offset;
static gpointer status_applet_parent_class = NULL;
static GType status_applet_type_id = 0;

static BudgieApplet* status_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                   const gchar* uuid);
static void status_settings_finalize (GObject * obj);
static void status_applet_setup_popover (StatusApplet* self,
                                  GtkWidget* parent_widget,
                                  BudgiePopover* popover);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda37_ (Block1Data* _data1_,
                      GdkEventButton* e);
static gboolean ___lambda37__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void __lambda38_ (StatusApplet* self,
                  const gchar* key);
static void ___lambda38__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda39_ (StatusApplet* self,
                  const gchar* key);
static void ___lambda39__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void status_applet_real_panel_position_changed (BudgieApplet* base,
                                                BudgiePanelPosition position);
static void status_applet_real_update_popovers (BudgieApplet* base,
                                         BudgiePopoverManager* manager);
static gboolean status_applet_real_supports_settings (BudgieApplet* base);
static GtkWidget* status_applet_real_get_settings_ui (BudgieApplet* base);
static void status_applet_finalize (GObject * obj);
static void _vala_status_applet_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_status_applet_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
GType battery_icon_register_type (GTypeModule * module);
GType power_profiles_option_register_type (GTypeModule * module);
GType power_profiles_selector_register_type (GTypeModule * module);
GType power_indicator_register_type (GTypeModule * module);
GType sound_indicator_register_type (GTypeModule * module);
GType bluetooth_client_register_type (GTypeModule * module);
GType bluetooth_indicator_register_type (GTypeModule * module);
GType bt_device_row_register_type (GTypeModule * module);
GType obex_manager_register_type (GTypeModule * module);
GType power_profiles_dbus_register_type (GTypeModule * module);
VALA_EXTERN void power_profiles_dbus_proxy_register_dynamic_type (GTypeModule* module);
GType adapter1_register_type (GTypeModule * module);
VALA_EXTERN void adapter1_proxy_register_dynamic_type (GTypeModule* module);
GType device1_register_type (GTypeModule * module);
VALA_EXTERN void device1_proxy_register_dynamic_type (GTypeModule* module);
GType transfer_register_type (GTypeModule * module);
VALA_EXTERN void transfer_proxy_register_dynamic_type (GTypeModule* module);
GType session_register_type (GTypeModule * module);
VALA_EXTERN void session_proxy_register_dynamic_type (GTypeModule* module);
GType rfkill_register_type (GTypeModule * module);
VALA_EXTERN void rfkill_proxy_register_dynamic_type (GTypeModule* module);

static BudgieApplet*
status_plugin_real_get_panel_widget (BudgiePlugin* base,
                                     const gchar* uuid)
{
	StatusPlugin * self;
	StatusApplet* _tmp0_;
	BudgieApplet* result;
	self = (StatusPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = status_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

StatusPlugin*
status_plugin_construct (GType object_type)
{
	StatusPlugin * self = NULL;
	self = (StatusPlugin*) g_object_new (object_type, NULL);
	return self;
}

StatusPlugin*
status_plugin_new (void)
{
	return status_plugin_construct (TYPE_STATUS_PLUGIN);
}

static void
status_plugin_class_init (StatusPluginClass * klass,
                          gpointer klass_data)
{
	status_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
status_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                            gpointer iface_data)
{
	status_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) status_plugin_real_get_panel_widget;
}

static void
status_plugin_instance_init (StatusPlugin * self,
                             gpointer klass)
{
}

GType
status_plugin_get_type (void)
{
	return status_plugin_type_id;
}

GType
status_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (StatusPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusPlugin), 0, (GInstanceInitFunc) status_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) status_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	status_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "StatusPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, status_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return status_plugin_type_id;
}

static inline gpointer
status_settings_get_instance_private (StatusSettings* self)
{
	return G_STRUCT_MEMBER_P (self, StatusSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

StatusSettings*
status_settings_construct (GType object_type,
                           GSettings* settings)
{
	StatusSettings * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkSpinButton* _tmp2_;
	GSettings* _tmp3_;
	GtkSwitch* _tmp4_;
	self = (StatusSettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_settings_new (GNOME_SETTINGS_SCHEMA);
	_g_object_unref0 (self->priv->gnome_settings);
	self->priv->gnome_settings = _tmp1_;
	_tmp2_ = self->priv->spinbutton_spacing;
	g_settings_bind (settings, "spacing", (GObject*) _tmp2_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = self->priv->gnome_settings;
	_tmp4_ = self->priv->switch_show_battery_percentage;
	g_settings_bind (_tmp3_, "show-battery-percentage", (GObject*) _tmp4_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

StatusSettings*
status_settings_new (GSettings* settings)
{
	return status_settings_construct (TYPE_STATUS_SETTINGS, settings);
}

static void
status_settings_class_init (StatusSettingsClass * klass,
                            gpointer klass_data)
{
	status_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StatusSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = status_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/status/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinbutton_spacing", FALSE, StatusSettings_private_offset + G_STRUCT_OFFSET (StatusSettingsPrivate, spinbutton_spacing));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_show_battery_percentage", FALSE, StatusSettings_private_offset + G_STRUCT_OFFSET (StatusSettingsPrivate, switch_show_battery_percentage));
}

static void
status_settings_instance_init (StatusSettings * self,
                               gpointer klass)
{
	self->priv = status_settings_get_instance_private (self);
	self->priv->settings = NULL;
	self->priv->gnome_settings = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
status_settings_finalize (GObject * obj)
{
	StatusSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATUS_SETTINGS, StatusSettings);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->gnome_settings);
	G_OBJECT_CLASS (status_settings_parent_class)->finalize (obj);
}

GType
status_settings_get_type (void)
{
	return status_settings_type_id;
}

GType
status_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (StatusSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusSettings), 0, (GInstanceInitFunc) status_settings_instance_init, NULL };
	status_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "StatusSettings", &g_define_type_info, 0);
	StatusSettings_private_offset = sizeof (StatusSettingsPrivate);
	return status_settings_type_id;
}

static inline gpointer
status_applet_get_instance_private (StatusApplet* self)
{
	return G_STRUCT_MEMBER_P (self, StatusApplet_private_offset);
}

/**
 * Set up an EventBox for popovers
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		StatusApplet* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->parent_widget);
		_g_object_unref0 (_data1_->popover);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda37_ (Block1Data* _data1_,
             GdkEventButton* e)
{
	StatusApplet* self;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if (gtk_widget_get_visible ((GtkWidget*) _data1_->popover)) {
		gtk_widget_hide ((GtkWidget*) _data1_->popover);
	} else {
		BudgiePopoverManager* _tmp0_;
		_tmp0_ = self->priv->manager;
		budgie_popover_manager_show_popover (_tmp0_, _data1_->parent_widget);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda37__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda37_ (self, event);
	return result;
}

static void
status_applet_setup_popover (StatusApplet* self,
                             GtkWidget* parent_widget,
                             BudgiePopover* popover)
{
	Block1Data* _data1_;
	GtkWidget* _tmp0_;
	BudgiePopover* _tmp1_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (parent_widget);
	_g_object_unref0 (_data1_->parent_widget);
	_data1_->parent_widget = _tmp0_;
	_tmp1_ = _g_object_ref0 (popover);
	_g_object_unref0 (_data1_->popover);
	_data1_->popover = _tmp1_;
	g_signal_connect_data (_data1_->parent_widget, "button-press-event", (GCallback) ___lambda37__gtk_widget_button_press_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
__lambda38_ (StatusApplet* self,
             const gchar* key)
{
	GtkBox* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->widget;
	if (_tmp0_ != NULL) {
		GtkBox* _tmp1_;
		GSettings* _tmp2_;
		_tmp1_ = self->widget;
		_tmp2_ = self->priv->settings;
		gtk_box_set_spacing (_tmp1_, g_settings_get_int (_tmp2_, "spacing"));
	}
}

static void
___lambda38__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda38_ ((StatusApplet*) self, key);
}

static void
__lambda39_ (StatusApplet* self,
             const gchar* key)
{
	PowerIndicator* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->power;
	_tmp1_ = self->priv->gnome_settings;
	power_indicator_update_labels (_tmp0_, g_settings_get_boolean (_tmp1_, "show-battery-percentage"));
}

static void
___lambda39__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda39_ ((StatusApplet*) self, key);
}

StatusApplet*
status_applet_construct (GType object_type,
                         const gchar* uuid)
{
	StatusApplet * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkEventBox* _tmp3_;
	GSettings* _tmp4_;
	GtkBox* _tmp5_;
	GtkEventBox* _tmp6_;
	GtkBox* _tmp7_;
	PowerIndicator* _tmp8_;
	GSettings* _tmp9_;
	PowerIndicator* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GtkBox* _tmp13_;
	PowerIndicator* _tmp14_;
	SoundIndicator* _tmp15_;
	GtkBox* _tmp16_;
	SoundIndicator* _tmp17_;
	SoundIndicator* _tmp18_;
	PowerIndicator* _tmp19_;
	GtkEventBox* _tmp20_;
	PowerIndicator* _tmp21_;
	BudgiePopover* _tmp22_;
	SoundIndicator* _tmp23_;
	GtkEventBox* _tmp24_;
	SoundIndicator* _tmp25_;
	BudgiePopover* _tmp26_;
	BluetoothIndicator* _tmp27_;
	GtkBox* _tmp28_;
	BluetoothIndicator* _tmp29_;
	BluetoothIndicator* _tmp30_;
	GtkEventBox* _tmp31_;
	BluetoothIndicator* _tmp32_;
	BudgiePopover* _tmp33_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (StatusApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.status");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/status");
	_tmp0_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed::spacing", (GCallback) ___lambda38__g_settings_changed, self, 0);
	_tmp2_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->wrap);
	self->wrap = _tmp2_;
	_tmp3_ = self->wrap;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, g_settings_get_int (_tmp4_, "spacing"));
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp5_;
	_tmp6_ = self->wrap;
	_tmp7_ = self->widget;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp8_ = power_indicator_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->power);
	self->power = _tmp8_;
	_tmp9_ = g_settings_new (GNOME_SETTINGS_SCHEMA);
	_g_object_unref0 (self->priv->gnome_settings);
	self->priv->gnome_settings = _tmp9_;
	_tmp10_ = self->power;
	_tmp11_ = self->priv->gnome_settings;
	power_indicator_update_labels (_tmp10_, g_settings_get_boolean (_tmp11_, "show-battery-percentage"));
	_tmp12_ = self->priv->gnome_settings;
	g_signal_connect_object (_tmp12_, "changed::show-battery-percentage", (GCallback) ___lambda39__g_settings_changed, self, 0);
	_tmp13_ = self->widget;
	_tmp14_ = self->power;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = sound_indicator_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->sound);
	self->sound = _tmp15_;
	_tmp16_ = self->widget;
	_tmp17_ = self->sound;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, FALSE, (guint) 0);
	_tmp18_ = self->sound;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
	_tmp19_ = self->power;
	_tmp20_ = _tmp19_->ebox;
	_tmp21_ = self->power;
	_tmp22_ = _tmp21_->popover;
	status_applet_setup_popover (self, (GtkWidget*) _tmp20_, _tmp22_);
	_tmp23_ = self->sound;
	_tmp24_ = _tmp23_->ebox;
	_tmp25_ = self->sound;
	_tmp26_ = _tmp25_->popover;
	status_applet_setup_popover (self, (GtkWidget*) _tmp24_, _tmp26_);
	_tmp27_ = bluetooth_indicator_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->blue);
	self->blue = _tmp27_;
	_tmp28_ = self->widget;
	_tmp29_ = self->blue;
	gtk_box_pack_start (_tmp28_, (GtkWidget*) _tmp29_, FALSE, FALSE, (guint) 0);
	_tmp30_ = self->blue;
	_tmp31_ = _tmp30_->ebox;
	_tmp32_ = self->blue;
	_tmp33_ = _tmp32_->popover;
	status_applet_setup_popover (self, (GtkWidget*) _tmp31_, _tmp33_);
	return self;
}

StatusApplet*
status_applet_new (const gchar* uuid)
{
	return status_applet_construct (TYPE_STATUS_APPLET, uuid);
}

static void
status_applet_real_panel_position_changed (BudgieApplet* base,
                                           BudgiePanelPosition position)
{
	StatusApplet * self;
	GtkOrientation orient = 0;
	gboolean _tmp0_ = FALSE;
	GtkBox* _tmp1_;
	PowerIndicator* _tmp2_;
	self = (StatusApplet*) base;
	orient = GTK_ORIENTATION_HORIZONTAL;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		orient = GTK_ORIENTATION_VERTICAL;
	}
	_tmp1_ = self->widget;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp1_, orient);
	_tmp2_ = self->power;
	power_indicator_change_orientation (_tmp2_, orient);
}

static void
status_applet_real_update_popovers (BudgieApplet* base,
                                    BudgiePopoverManager* manager)
{
	StatusApplet * self;
	BudgiePopoverManager* _tmp0_;
	PowerIndicator* _tmp1_;
	GtkEventBox* _tmp2_;
	PowerIndicator* _tmp3_;
	BudgiePopover* _tmp4_;
	SoundIndicator* _tmp5_;
	GtkEventBox* _tmp6_;
	SoundIndicator* _tmp7_;
	BudgiePopover* _tmp8_;
	BluetoothIndicator* _tmp9_;
	GtkEventBox* _tmp10_;
	BluetoothIndicator* _tmp11_;
	BudgiePopover* _tmp12_;
	self = (StatusApplet*) base;
	_tmp0_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp0_;
	_tmp1_ = self->power;
	_tmp2_ = _tmp1_->ebox;
	_tmp3_ = self->power;
	_tmp4_ = _tmp3_->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp2_, (GtkPopover*) _tmp4_);
	_tmp5_ = self->sound;
	_tmp6_ = _tmp5_->ebox;
	_tmp7_ = self->sound;
	_tmp8_ = _tmp7_->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp6_, (GtkPopover*) _tmp8_);
	_tmp9_ = self->blue;
	_tmp10_ = _tmp9_->ebox;
	_tmp11_ = self->blue;
	_tmp12_ = _tmp11_->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp10_, (GtkPopover*) _tmp12_);
}

static gboolean
status_applet_real_supports_settings (BudgieApplet* base)
{
	StatusApplet * self;
	gboolean result;
	self = (StatusApplet*) base;
	result = TRUE;
	return result;
}

static GtkWidget*
status_applet_real_get_settings_ui (BudgieApplet* base)
{
	StatusApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	StatusSettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (StatusApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = status_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

const gchar*
status_applet_get_uuid (StatusApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
status_applet_set_uuid (StatusApplet* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = status_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, status_applet_properties[STATUS_APPLET_UUID_PROPERTY]);
	}
}

static void
status_applet_class_init (StatusAppletClass * klass,
                          gpointer klass_data)
{
	status_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StatusApplet_private_offset);
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) status_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) status_applet_real_update_popovers;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) status_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) status_applet_real_get_settings_ui;
	G_OBJECT_CLASS (klass)->get_property = _vala_status_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_status_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = status_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STATUS_APPLET_UUID_PROPERTY, status_applet_properties[STATUS_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
status_applet_instance_init (StatusApplet * self,
                             gpointer klass)
{
	self->priv = status_applet_get_instance_private (self);
	self->priv->manager = NULL;
}

static void
status_applet_finalize (GObject * obj)
{
	StatusApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATUS_APPLET, StatusApplet);
	_g_free0 (self->priv->_uuid);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->blue);
	_g_object_unref0 (self->sound);
	_g_object_unref0 (self->power);
	_g_object_unref0 (self->wrap);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->gnome_settings);
	_g_object_unref0 (self->priv->manager);
	G_OBJECT_CLASS (status_applet_parent_class)->finalize (obj);
}

GType
status_applet_get_type (void)
{
	return status_applet_type_id;
}

GType
status_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (StatusAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusApplet), 0, (GInstanceInitFunc) status_applet_instance_init, NULL };
	status_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "StatusApplet", &g_define_type_info, 0);
	StatusApplet_private_offset = sizeof (StatusAppletPrivate);
	return status_applet_type_id;
}

static void
_vala_status_applet_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	StatusApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STATUS_APPLET, StatusApplet);
	switch (property_id) {
		case STATUS_APPLET_UUID_PROPERTY:
		g_value_set_string (value, status_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_status_applet_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	StatusApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STATUS_APPLET, StatusApplet);
	switch (property_id) {
		case STATUS_APPLET_UUID_PROPERTY:
		status_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	status_plugin_register_type (module);
	status_settings_register_type (module);
	status_applet_register_type (module);
	battery_icon_register_type (module);
	power_profiles_option_register_type (module);
	power_profiles_selector_register_type (module);
	power_indicator_register_type (module);
	sound_indicator_register_type (module);
	bluetooth_client_register_type (module);
	bluetooth_indicator_register_type (module);
	bt_device_row_register_type (module);
	obex_manager_register_type (module);
	power_profiles_dbus_register_type (module);
	power_profiles_dbus_proxy_register_dynamic_type (module);
	adapter1_register_type (module);
	adapter1_proxy_register_dynamic_type (module);
	device1_register_type (module);
	device1_proxy_register_dynamic_type (module);
	transfer_register_type (module);
	transfer_proxy_register_dynamic_type (module);
	session_register_type (module);
	session_proxy_register_dynamic_type (module);
	rfkill_register_type (module);
	rfkill_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_STATUS_PLUGIN);
	_g_object_unref0 (objmodule);
}

