/* TrayApplet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TrayApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "trayapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <math.h>
#include <float.h>
#include <libpeas.h>

#define TRAY_APPLET_DEFAULT_PANEL_SIZE 36
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	TRAY_PLUGIN_0_PROPERTY,
	TRAY_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* tray_plugin_properties[TRAY_PLUGIN_NUM_PROPERTIES];
enum  {
	TRAY_SETTINGS_0_PROPERTY,
	TRAY_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* tray_settings_properties[TRAY_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DBUS_SERVICE_INFO (dbus_service_info_get_type ())
typedef struct _DBusServiceInfo DBusServiceInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SN_WATCHER_INTERFACE (sn_watcher_interface_get_type ())
#define SN_WATCHER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SN_WATCHER_INTERFACE, SnWatcherInterface))
#define IS_SN_WATCHER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SN_WATCHER_INTERFACE))
#define SN_WATCHER_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SN_WATCHER_INTERFACE, SnWatcherInterfaceIface))

typedef struct _SnWatcherInterface SnWatcherInterface;
typedef struct _SnWatcherInterfaceIface SnWatcherInterfaceIface;

#define TYPE_SN_WATCHER_INTERFACE_PROXY (sn_watcher_interface_proxy_get_type ())
enum  {
	SN_WATCHER_INTERFACE_STATUS_NOTIFIER_ITEM_REGISTERED_BUDGIE_SIGNAL,
	SN_WATCHER_INTERFACE_STATUS_NOTIFIER_ITEM_UNREGISTERED_BUDGIE_SIGNAL,
	SN_WATCHER_INTERFACE_NUM_SIGNALS
};
static guint sn_watcher_interface_signals[SN_WATCHER_INTERFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy SnWatcherInterfaceProxy;
typedef GDBusProxyClass SnWatcherInterfaceProxyClass;

#define TYPE_TRAY_ITEM (tray_item_get_type ())
#define TRAY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRAY_ITEM, TrayItem))
#define TRAY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRAY_ITEM, TrayItemClass))
#define IS_TRAY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRAY_ITEM))
#define IS_TRAY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRAY_ITEM))
#define TRAY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRAY_ITEM, TrayItemClass))

typedef struct _TrayItem TrayItem;
typedef struct _TrayItemClass TrayItemClass;
enum  {
	TRAY_APPLET_0_PROPERTY,
	TRAY_APPLET_UUID_PROPERTY,
	TRAY_APPLET_NUM_PROPERTIES
};
static GParamSpec* tray_applet_properties[TRAY_APPLET_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;

struct _TraySettingsPrivate {
	GSettings* settings;
	GtkSpinButton* spinbutton_spacing;
	GtkSwitch* switch_scaling;
};

struct _DBusServiceInfo {
	gchar* name;
	gchar* object_path;
	gchar* sender;
	gchar* owner;
};

struct _SnWatcherInterfaceIface {
	GTypeInterface parent_iface;
	void (*register_status_notifier_host) (SnWatcherInterface* self, const gchar* service, GError** error);
	DBusServiceInfo* (*get_registered_status_notifier_pathnames_budgie) (SnWatcherInterface* self, gint* result_length1, GError** error);
	gchar** (*get_registered_status_notifier_items) (SnWatcherInterface* self, gint* result_length1);
	gboolean (*get_is_status_notifier_host_registered) (SnWatcherInterface* self);
	gint32 (*get_protocol_version) (SnWatcherInterface* self);
};

struct _TrayAppletPrivate {
	gchar* _uuid;
	GSettings* settings;
	GtkEventBox* box;
	GtkBox* layout;
	GHashTable* items;
	guint dbus_identifier;
	SnWatcherInterface* watcher;
	gint panel_size;
};

struct _Block4Data {
	int _ref_count_;
	TrayApplet* self;
	gchar* host_name;
};

static gpointer tray_plugin_parent_class = NULL;
static BudgiePluginIface * tray_plugin_budgie_plugin_parent_iface = NULL;
static GType tray_plugin_type_id = 0;
static gint TraySettings_private_offset;
static gpointer tray_settings_parent_class = NULL;
static GType tray_settings_type_id = 0;
static GType sn_watcher_interface_type_id = 0;
static gint TrayApplet_private_offset;
static gpointer tray_applet_parent_class = NULL;
static GType tray_applet_type_id = 0;

static BudgieApplet* tray_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                 const gchar* uuid);
static void tray_settings_finalize (GObject * obj);
VALA_EXTERN GType dbus_service_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN DBusServiceInfo* dbus_service_info_dup (const DBusServiceInfo* self);
VALA_EXTERN void dbus_service_info_free (DBusServiceInfo* self);
VALA_EXTERN void dbus_service_info_copy (const DBusServiceInfo* self,
                             DBusServiceInfo* dest);
VALA_EXTERN void dbus_service_info_destroy (DBusServiceInfo* self);
VALA_EXTERN GType sn_watcher_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sn_watcher_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint sn_watcher_interface_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
GType sn_watcher_interface_register_type (GTypeModule * module);
VALA_EXTERN GType sn_watcher_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sn_watcher_interface_register_status_notifier_host (SnWatcherInterface* self,
                                                         const gchar* service,
                                                         GError** error);
VALA_EXTERN DBusServiceInfo* sn_watcher_interface_get_registered_status_notifier_pathnames_budgie (SnWatcherInterface* self,
                                                                                       gint* result_length1,
                                                                                       GError** error);
VALA_EXTERN gchar** sn_watcher_interface_get_registered_status_notifier_items (SnWatcherInterface* self,
                                                                   gint* result_length1);
VALA_EXTERN gboolean sn_watcher_interface_get_is_status_notifier_host_registered (SnWatcherInterface* self);
VALA_EXTERN gint32 sn_watcher_interface_get_protocol_version (SnWatcherInterface* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING (GClosure * closure,
                                                                GValue * return_value,
                                                                guint n_param_values,
                                                                const GValue * param_values,
                                                                gpointer invocation_hint,
                                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void sn_watcher_interface_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static void _dbus_handle_sn_watcher_interface_status_notifier_item_registered_budgie (SnWatcherInterface* self,
                                                                               GVariant* parameters);
static void _dbus_handle_sn_watcher_interface_status_notifier_item_unregistered_budgie (SnWatcherInterface* self,
                                                                                 GVariant* parameters);
static void sn_watcher_interface_proxy_register_status_notifier_host (SnWatcherInterface* self,
                                                               const gchar* service,
                                                               GError** error);
static DBusServiceInfo* sn_watcher_interface_proxy_get_registered_status_notifier_pathnames_budgie (SnWatcherInterface* self,
                                                                                             gint* result_length1,
                                                                                             GError** error);
static gchar** sn_watcher_interface_dbus_proxy_get_registered_status_notifier_items (SnWatcherInterface* self,
                                                                              gint* result_length1);
static gboolean sn_watcher_interface_dbus_proxy_get_is_status_notifier_host_registered (SnWatcherInterface* self);
static gint32 sn_watcher_interface_dbus_proxy_get_protocol_version (SnWatcherInterface* self);
static void sn_watcher_interface_proxy_sn_watcher_interface_interface_init (SnWatcherInterfaceIface* iface);
static void _dbus_sn_watcher_interface_register_status_notifier_host (SnWatcherInterface* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation);
static void _vala_DBusServiceInfo_array_free (DBusServiceInfo * array,
                                       gssize array_length);
static void _dbus_sn_watcher_interface_get_registered_status_notifier_pathnames_budgie (SnWatcherInterface* self,
                                                                                 GVariant* _parameters_,
                                                                                 GDBusMethodInvocation* invocation);
static void sn_watcher_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* sn_watcher_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static GVariant* _dbus_sn_watcher_interface_get_registered_status_notifier_items (SnWatcherInterface* self);
static GVariant* _dbus_sn_watcher_interface_get_is_status_notifier_host_registered (SnWatcherInterface* self);
static GVariant* _dbus_sn_watcher_interface_get_protocol_version (SnWatcherInterface* self);
static gboolean sn_watcher_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_sn_watcher_interface_status_notifier_item_registered_budgie (GObject* _sender,
                                                                        const gchar* name,
                                                                        const gchar* object_path,
                                                                        const gchar* sender,
                                                                        const gchar* owner,
                                                                        gpointer* _data);
static void _dbus_sn_watcher_interface_status_notifier_item_unregistered_budgie (GObject* _sender,
                                                                          const gchar* name,
                                                                          const gchar* object_path,
                                                                          const gchar* sender,
                                                                          gpointer* _data);
static void _sn_watcher_interface_unregister_object (gpointer user_data);
GType tray_item_register_type (GTypeModule * module);
VALA_EXTERN GType tray_item_get_type (void) G_GNUC_CONST ;
static void __lambda21_ (TrayApplet* self,
                  const gchar* key);
static void ___lambda21__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda22_ (TrayApplet* self,
                  const gchar* key);
static void __lambda23_ (TrayApplet* self,
                  TrayItem* item);
VALA_EXTERN void tray_item_resize (TrayItem* self,
                       gint applet_size);
static gint tray_applet_get_target_panel_size (TrayApplet* self);
static void ___lambda23__gfunc (gconstpointer data,
                         gpointer self);
static void ___lambda22__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void tray_applet_get_watcher_proxy (TrayApplet* self);
static void tray_applet_on_dbus_get (TrayApplet* self,
                              GObject* o,
                              GAsyncResult* res);
static void _tray_applet_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                     GAsyncResult* res,
                                                     gpointer self);
static void __lambda24_ (TrayApplet* self,
                  GDBusConnection* conn,
                  const gchar* name,
                  const gchar* owner);
static gboolean __lambda25_ (TrayApplet* self);
static void tray_applet_on_watcher_init (TrayApplet* self);
static gboolean ___lambda25__gsource_func (gpointer self);
static void ___lambda24__gbus_name_appeared_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               const gchar* name_owner,
                                               gpointer self);
static void __lambda28_ (TrayApplet* self,
                  GDBusConnection* conn,
                  const gchar* name);
static void ___lambda28__gbus_name_vanished_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void tray_applet_register_new_item (TrayApplet* self,
                                    const gchar* name,
                                    const gchar* object_path,
                                    const gchar* sender,
                                    const gchar* owner);
static void _tray_applet_register_new_item_sn_watcher_interface_status_notifier_item_registered_budgie (SnWatcherInterface* _sender,
                                                                                                 const gchar* name,
                                                                                                 const gchar* object_path,
                                                                                                 const gchar* sender,
                                                                                                 const gchar* owner,
                                                                                                 gpointer self);
static void __lambda26_ (TrayApplet* self,
                  const gchar* name,
                  const gchar* path,
                  const gchar* sender);
static void ___lambda26__sn_watcher_interface_status_notifier_item_unregistered_budgie (SnWatcherInterface* _sender,
                                                                                 const gchar* name,
                                                                                 const gchar* object_path,
                                                                                 const gchar* sender,
                                                                                 gpointer self);
static void __lambda27_ (Block4Data* _data4_,
                  GDBusConnection* conn,
                  const gchar* name);
static void ___lambda27__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
VALA_EXTERN TrayItem* tray_item_new (const gchar* dbus_name,
                         const gchar* dbus_object_path,
                         gint applet_size,
                         GError** error);
VALA_EXTERN TrayItem* tray_item_construct (GType object_type,
                               const gchar* dbus_name,
                               const gchar* dbus_object_path,
                               gint applet_size,
                               GError** error);
static void tray_applet_real_panel_position_changed (BudgieApplet* base,
                                              BudgiePanelPosition position);
static void tray_applet_real_panel_size_changed (BudgieApplet* base,
                                          gint panel,
                                          gint icon,
                                          gint small_icon);
static void __lambda29_ (TrayApplet* self,
                  TrayItem* item);
static void ___lambda29__gfunc (gconstpointer data,
                         gpointer self);
static gboolean tray_applet_real_supports_settings (BudgieApplet* base);
static GtkWidget* tray_applet_real_get_settings_ui (BudgieApplet* base);
static void tray_applet_finalize (GObject * obj);
static void _vala_tray_applet_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_tray_applet_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
GType dbus_menu_register_type (GTypeModule * module);
GType dbus_menu_node_register_type (GTypeModule * module);
GType dbus_menu_item_register_type (GTypeModule * module);
GType properties_register_type (GTypeModule * module);
GType tray_item_register_type (GTypeModule * module);
GType dbus_menu_interface_register_type (GTypeModule * module);
VALA_EXTERN void dbus_menu_interface_proxy_register_dynamic_type (GTypeModule* module);
GType sn_item_properties_register_type (GTypeModule * module);
VALA_EXTERN void sn_item_properties_proxy_register_dynamic_type (GTypeModule* module);
GType sn_item_interface_register_type (GTypeModule * module);
VALA_EXTERN void sn_item_interface_proxy_register_dynamic_type (GTypeModule* module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_register_status_notifier_host_service = {-1, "service", "s", NULL};
static const GDBusArgInfo * const _sn_watcher_interface_dbus_arg_info_register_status_notifier_host_in[] = {&_sn_watcher_interface_dbus_arg_info_register_status_notifier_host_service, NULL};
static const GDBusArgInfo * const _sn_watcher_interface_dbus_arg_info_register_status_notifier_host_out[] = {NULL};
static const GDBusMethodInfo _sn_watcher_interface_dbus_method_info_register_status_notifier_host = {-1, "RegisterStatusNotifierHost", (GDBusArgInfo **) (&_sn_watcher_interface_dbus_arg_info_register_status_notifier_host_in), (GDBusArgInfo **) (&_sn_watcher_interface_dbus_arg_info_register_status_notifier_host_out), NULL};
static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_get_registered_status_notifier_pathnames_budgie_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _sn_watcher_interface_dbus_arg_info_get_registered_status_notifier_pathnames_budgie_in[] = {NULL};
static const GDBusArgInfo * const _sn_watcher_interface_dbus_arg_info_get_registered_status_notifier_pathnames_budgie_out[] = {&_sn_watcher_interface_dbus_arg_info_get_registered_status_notifier_pathnames_budgie_result, NULL};
static const GDBusMethodInfo _sn_watcher_interface_dbus_method_info_get_registered_status_notifier_pathnames_budgie = {-1, "GetRegisteredStatusNotifierPathnamesBudgie", (GDBusArgInfo **) (&_sn_watcher_interface_dbus_arg_info_get_registered_status_notifier_pathnames_budgie_in), (GDBusArgInfo **) (&_sn_watcher_interface_dbus_arg_info_get_registered_status_notifier_pathnames_budgie_out), NULL};
static const GDBusMethodInfo * const _sn_watcher_interface_dbus_method_info[] = {&_sn_watcher_interface_dbus_method_info_register_status_notifier_host, &_sn_watcher_interface_dbus_method_info_get_registered_status_notifier_pathnames_budgie, NULL};
static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie_object_path = {-1, "object_path", "s", NULL};
static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie_owner = {-1, "owner", "s", NULL};
static const GDBusArgInfo * const _sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie[] = {&_sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie_name, &_sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie_object_path, &_sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie_sender, &_sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie_owner, NULL};
static const GDBusSignalInfo _sn_watcher_interface_dbus_signal_info_status_notifier_item_registered_budgie = {-1, "StatusNotifierItemRegisteredBudgie", (GDBusArgInfo **) (&_sn_watcher_interface_dbus_arg_info_status_notifier_item_registered_budgie), NULL};
static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_status_notifier_item_unregistered_budgie_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_status_notifier_item_unregistered_budgie_object_path = {-1, "object_path", "s", NULL};
static const GDBusArgInfo _sn_watcher_interface_dbus_arg_info_status_notifier_item_unregistered_budgie_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _sn_watcher_interface_dbus_arg_info_status_notifier_item_unregistered_budgie[] = {&_sn_watcher_interface_dbus_arg_info_status_notifier_item_unregistered_budgie_name, &_sn_watcher_interface_dbus_arg_info_status_notifier_item_unregistered_budgie_object_path, &_sn_watcher_interface_dbus_arg_info_status_notifier_item_unregistered_budgie_sender, NULL};
static const GDBusSignalInfo _sn_watcher_interface_dbus_signal_info_status_notifier_item_unregistered_budgie = {-1, "StatusNotifierItemUnregisteredBudgie", (GDBusArgInfo **) (&_sn_watcher_interface_dbus_arg_info_status_notifier_item_unregistered_budgie), NULL};
static const GDBusSignalInfo * const _sn_watcher_interface_dbus_signal_info[] = {&_sn_watcher_interface_dbus_signal_info_status_notifier_item_registered_budgie, &_sn_watcher_interface_dbus_signal_info_status_notifier_item_unregistered_budgie, NULL};
static const GDBusPropertyInfo _sn_watcher_interface_dbus_property_info_registered_status_notifier_items = {-1, "RegisteredStatusNotifierItems", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_watcher_interface_dbus_property_info_is_status_notifier_host_registered = {-1, "IsStatusNotifierHostRegistered", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_watcher_interface_dbus_property_info_protocol_version = {-1, "ProtocolVersion", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _sn_watcher_interface_dbus_property_info[] = {&_sn_watcher_interface_dbus_property_info_registered_status_notifier_items, &_sn_watcher_interface_dbus_property_info_is_status_notifier_host_registered, &_sn_watcher_interface_dbus_property_info_protocol_version, NULL};
static const GDBusInterfaceInfo _sn_watcher_interface_dbus_interface_info = {-1, "org.freedesktop.StatusNotifierWatcher", (GDBusMethodInfo **) (&_sn_watcher_interface_dbus_method_info), (GDBusSignalInfo **) (&_sn_watcher_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_sn_watcher_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _sn_watcher_interface_dbus_interface_vtable = {sn_watcher_interface_dbus_interface_method_call, sn_watcher_interface_dbus_interface_get_property, sn_watcher_interface_dbus_interface_set_property};

static BudgieApplet*
tray_plugin_real_get_panel_widget (BudgiePlugin* base,
                                   const gchar* uuid)
{
	TrayPlugin * self;
	TrayApplet* _tmp0_;
	BudgieApplet* result;
	self = (TrayPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = tray_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

TrayPlugin*
tray_plugin_construct (GType object_type)
{
	TrayPlugin * self = NULL;
	self = (TrayPlugin*) g_object_new (object_type, NULL);
	return self;
}

TrayPlugin*
tray_plugin_new (void)
{
	return tray_plugin_construct (TYPE_TRAY_PLUGIN);
}

static void
tray_plugin_class_init (TrayPluginClass * klass,
                        gpointer klass_data)
{
	tray_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
tray_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                          gpointer iface_data)
{
	tray_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) tray_plugin_real_get_panel_widget;
}

static void
tray_plugin_instance_init (TrayPlugin * self,
                           gpointer klass)
{
}

GType
tray_plugin_get_type (void)
{
	return tray_plugin_type_id;
}

GType
tray_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrayPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tray_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrayPlugin), 0, (GInstanceInitFunc) tray_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) tray_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	tray_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "TrayPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, tray_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return tray_plugin_type_id;
}

static inline gpointer
tray_settings_get_instance_private (TraySettings* self)
{
	return G_STRUCT_MEMBER_P (self, TraySettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

TraySettings*
tray_settings_construct (GType object_type,
                         GSettings* settings)
{
	TraySettings * self = NULL;
	GSettings* _tmp0_;
	GtkSpinButton* _tmp1_;
	GtkSwitch* _tmp2_;
	self = (TraySettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->spinbutton_spacing;
	g_settings_bind (settings, "spacing", (GObject*) _tmp1_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp2_ = self->priv->switch_scaling;
	g_settings_bind (settings, "scaling", (GObject*) _tmp2_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

TraySettings*
tray_settings_new (GSettings* settings)
{
	return tray_settings_construct (TYPE_TRAY_SETTINGS, settings);
}

static void
tray_settings_class_init (TraySettingsClass * klass,
                          gpointer klass_data)
{
	tray_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TraySettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = tray_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/tray/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinbutton_spacing", FALSE, TraySettings_private_offset + G_STRUCT_OFFSET (TraySettingsPrivate, spinbutton_spacing));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_scaling", FALSE, TraySettings_private_offset + G_STRUCT_OFFSET (TraySettingsPrivate, switch_scaling));
}

static void
tray_settings_instance_init (TraySettings * self,
                             gpointer klass)
{
	self->priv = tray_settings_get_instance_private (self);
	self->priv->settings = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
tray_settings_finalize (GObject * obj)
{
	TraySettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRAY_SETTINGS, TraySettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (tray_settings_parent_class)->finalize (obj);
}

GType
tray_settings_get_type (void)
{
	return tray_settings_type_id;
}

GType
tray_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TraySettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tray_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TraySettings), 0, (GInstanceInitFunc) tray_settings_instance_init, NULL };
	tray_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "TraySettings", &g_define_type_info, 0);
	TraySettings_private_offset = sizeof (TraySettingsPrivate);
	return tray_settings_type_id;
}

void
dbus_service_info_copy (const DBusServiceInfo* self,
                        DBusServiceInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).object_path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).object_path);
	(*dest).object_path = _tmp3_;
	_tmp4_ = (*self).sender;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).sender);
	(*dest).sender = _tmp5_;
	_tmp6_ = (*self).owner;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).owner);
	(*dest).owner = _tmp7_;
}

void
dbus_service_info_destroy (DBusServiceInfo* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).object_path);
	_g_free0 ((*self).sender);
	_g_free0 ((*self).owner);
}

DBusServiceInfo*
dbus_service_info_dup (const DBusServiceInfo* self)
{
	DBusServiceInfo* dup;
	dup = g_new0 (DBusServiceInfo, 1);
	dbus_service_info_copy (self, dup);
	return dup;
}

void
dbus_service_info_free (DBusServiceInfo* self)
{
	dbus_service_info_destroy (self);
	g_free (self);
}

static GType
dbus_service_info_get_type_once (void)
{
	GType dbus_service_info_type_id;
	dbus_service_info_type_id = g_boxed_type_register_static ("DBusServiceInfo", (GBoxedCopyFunc) dbus_service_info_dup, (GBoxedFreeFunc) dbus_service_info_free);
	return dbus_service_info_type_id;
}

GType
dbus_service_info_get_type (void)
{
	static volatile gsize dbus_service_info_type_id__once = 0;
	if (g_once_init_enter (&dbus_service_info_type_id__once)) {
		GType dbus_service_info_type_id;
		dbus_service_info_type_id = dbus_service_info_get_type_once ();
		g_once_init_leave (&dbus_service_info_type_id__once, dbus_service_info_type_id);
	}
	return dbus_service_info_type_id__once;
}

void
sn_watcher_interface_register_status_notifier_host (SnWatcherInterface* self,
                                                    const gchar* service,
                                                    GError** error)
{
	SnWatcherInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SN_WATCHER_INTERFACE_GET_INTERFACE (self);
	if (_iface_->register_status_notifier_host) {
		_iface_->register_status_notifier_host (self, service, error);
	}
}

DBusServiceInfo*
sn_watcher_interface_get_registered_status_notifier_pathnames_budgie (SnWatcherInterface* self,
                                                                      gint* result_length1,
                                                                      GError** error)
{
	SnWatcherInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_WATCHER_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_registered_status_notifier_pathnames_budgie) {
		return _iface_->get_registered_status_notifier_pathnames_budgie (self, result_length1, error);
	}
	return NULL;
}

gchar**
sn_watcher_interface_get_registered_status_notifier_items (SnWatcherInterface* self,
                                                           gint* result_length1)
{
	SnWatcherInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_WATCHER_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_registered_status_notifier_items) {
		return _iface_->get_registered_status_notifier_items (self, result_length1);
	}
	return NULL;
}

gboolean
sn_watcher_interface_get_is_status_notifier_host_registered (SnWatcherInterface* self)
{
	SnWatcherInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SN_WATCHER_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_is_status_notifier_host_registered) {
		return _iface_->get_is_status_notifier_host_registered (self);
	}
	return FALSE;
}

gint32
sn_watcher_interface_get_protocol_version (SnWatcherInterface* self)
{
	SnWatcherInterfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = SN_WATCHER_INTERFACE_GET_INTERFACE (self);
	if (_iface_->get_protocol_version) {
		return _iface_->get_protocol_version (self);
	}
	return -1;
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}

static void
sn_watcher_interface_default_init (SnWatcherInterfaceIface * iface,
                                   gpointer iface_data)
{
	sn_watcher_interface_signals[SN_WATCHER_INTERFACE_STATUS_NOTIFIER_ITEM_REGISTERED_BUDGIE_SIGNAL] = g_signal_new ("status-notifier-item-registered-budgie", TYPE_SN_WATCHER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	sn_watcher_interface_signals[SN_WATCHER_INTERFACE_STATUS_NOTIFIER_ITEM_UNREGISTERED_BUDGIE_SIGNAL] = g_signal_new ("status-notifier-item-unregistered-budgie", TYPE_SN_WATCHER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
}

GType
sn_watcher_interface_get_type (void)
{
	return sn_watcher_interface_type_id;
}

GType
sn_watcher_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SnWatcherInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sn_watcher_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	sn_watcher_interface_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SnWatcherInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (sn_watcher_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (sn_watcher_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) sn_watcher_interface_proxy_get_type);
	g_type_set_qdata (sn_watcher_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.StatusNotifierWatcher");
	g_type_set_qdata (sn_watcher_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_sn_watcher_interface_dbus_interface_info));
	g_type_set_qdata (sn_watcher_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) sn_watcher_interface_register_object);
	return sn_watcher_interface_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (SnWatcherInterfaceProxy, sn_watcher_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_SN_WATCHER_INTERFACE, sn_watcher_interface_proxy_sn_watcher_interface_interface_init) )
static void
sn_watcher_interface_proxy_class_init (SnWatcherInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = sn_watcher_interface_proxy_g_signal;
}

static void
_dbus_handle_sn_watcher_interface_status_notifier_item_registered_budgie (SnWatcherInterface* self,
                                                                          GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp75_;
	gchar* object_path = NULL;
	GVariant* _tmp76_;
	gchar* sender = NULL;
	GVariant* _tmp77_;
	gchar* owner = NULL;
	GVariant* _tmp78_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp75_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp75_, NULL);
	g_variant_unref (_tmp75_);
	_tmp76_ = g_variant_iter_next_value (&_arguments_iter);
	object_path = g_variant_dup_string (_tmp76_, NULL);
	g_variant_unref (_tmp76_);
	_tmp77_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp77_, NULL);
	g_variant_unref (_tmp77_);
	_tmp78_ = g_variant_iter_next_value (&_arguments_iter);
	owner = g_variant_dup_string (_tmp78_, NULL);
	g_variant_unref (_tmp78_);
	g_signal_emit_by_name (self, "status-notifier-item-registered-budgie", name, object_path, sender, owner);
	_g_free0 (name);
	_g_free0 (object_path);
	_g_free0 (sender);
	_g_free0 (owner);
}

static void
_dbus_handle_sn_watcher_interface_status_notifier_item_unregistered_budgie (SnWatcherInterface* self,
                                                                            GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp79_;
	gchar* object_path = NULL;
	GVariant* _tmp80_;
	gchar* sender = NULL;
	GVariant* _tmp81_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp79_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp79_, NULL);
	g_variant_unref (_tmp79_);
	_tmp80_ = g_variant_iter_next_value (&_arguments_iter);
	object_path = g_variant_dup_string (_tmp80_, NULL);
	g_variant_unref (_tmp80_);
	_tmp81_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp81_, NULL);
	g_variant_unref (_tmp81_);
	g_signal_emit_by_name (self, "status-notifier-item-unregistered-budgie", name, object_path, sender);
	_g_free0 (name);
	_g_free0 (object_path);
	_g_free0 (sender);
}

static void
sn_watcher_interface_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
	if (strcmp (signal_name, "StatusNotifierItemRegisteredBudgie") == 0) {
		_dbus_handle_sn_watcher_interface_status_notifier_item_registered_budgie ((SnWatcherInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "StatusNotifierItemUnregisteredBudgie") == 0) {
		_dbus_handle_sn_watcher_interface_status_notifier_item_unregistered_budgie ((SnWatcherInterface*) proxy, parameters);
	}
}

static void
sn_watcher_interface_proxy_class_finalize (SnWatcherInterfaceProxyClass* klass)
{
}

void
sn_watcher_interface_proxy_register_dynamic_type (GTypeModule* module)
{
	sn_watcher_interface_proxy_register_type (module);
}

static void
sn_watcher_interface_proxy_init (SnWatcherInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_sn_watcher_interface_dbus_interface_info));
}

static void
sn_watcher_interface_proxy_register_status_notifier_host (SnWatcherInterface* self,
                                                          const gchar* service,
                                                          GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.StatusNotifierWatcher", "RegisterStatusNotifierHost");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (service));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static DBusServiceInfo*
sn_watcher_interface_proxy_get_registered_status_notifier_pathnames_budgie (SnWatcherInterface* self,
                                                                            gint* result_length1,
                                                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DBusServiceInfo* _result = NULL;
	gint _result_length1;
	GVariant* _tmp82_;
	DBusServiceInfo* _tmp83_;
	gint _tmp83__length;
	gint _tmp83__size;
	gint _tmp83__length1;
	GVariantIter _tmp84_;
	GVariant* _tmp85_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.StatusNotifierWatcher", "GetRegisteredStatusNotifierPathnamesBudgie");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp82_ = g_variant_iter_next_value (&_reply_iter);
	_tmp83_ = g_new (DBusServiceInfo, 5);
	_tmp83__length = 0;
	_tmp83__size = 4;
	_tmp83__length1 = 0;
	g_variant_iter_init (&_tmp84_, _tmp82_);
	for (; (_tmp85_ = g_variant_iter_next_value (&_tmp84_)) != NULL; _tmp83__length1++) {
		DBusServiceInfo _tmp86_;
		GVariantIter _tmp87_;
		GVariant* _tmp88_;
		GVariant* _tmp89_;
		GVariant* _tmp90_;
		GVariant* _tmp91_;
		if (_tmp83__size == _tmp83__length) {
			_tmp83__size = 2 * _tmp83__size;
			_tmp83_ = g_renew (DBusServiceInfo, _tmp83_, _tmp83__size + 1);
		}
		g_variant_iter_init (&_tmp87_, _tmp85_);
		_tmp88_ = g_variant_iter_next_value (&_tmp87_);
		_tmp86_.name = g_variant_dup_string (_tmp88_, NULL);
		g_variant_unref (_tmp88_);
		_tmp89_ = g_variant_iter_next_value (&_tmp87_);
		_tmp86_.object_path = g_variant_dup_string (_tmp89_, NULL);
		g_variant_unref (_tmp89_);
		_tmp90_ = g_variant_iter_next_value (&_tmp87_);
		_tmp86_.sender = g_variant_dup_string (_tmp90_, NULL);
		g_variant_unref (_tmp90_);
		_tmp91_ = g_variant_iter_next_value (&_tmp87_);
		_tmp86_.owner = g_variant_dup_string (_tmp91_, NULL);
		g_variant_unref (_tmp91_);
		_tmp83_[_tmp83__length++] = _tmp86_;
		g_variant_unref (_tmp85_);
	}
	_result_length1 = _tmp83__length1;
	_result = _tmp83_;
	g_variant_unref (_tmp82_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static gchar**
sn_watcher_interface_dbus_proxy_get_registered_status_notifier_items (SnWatcherInterface* self,
                                                                      gint* result_length1)
{
	GVariant *_inner_reply;
	gchar** _result;
	gint _result_length1;
	gchar** _tmp92_;
	gint _tmp92__length;
	gint _tmp92__size;
	gint _tmp92__length1;
	GVariantIter _tmp93_;
	GVariant* _tmp94_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "RegisteredStatusNotifierItems");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.StatusNotifierWatcher"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("RegisteredStatusNotifierItems"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp92_ = g_new (gchar*, 5);
	_tmp92__length = 0;
	_tmp92__size = 4;
	_tmp92__length1 = 0;
	g_variant_iter_init (&_tmp93_, _inner_reply);
	for (; (_tmp94_ = g_variant_iter_next_value (&_tmp93_)) != NULL; _tmp92__length1++) {
		if (_tmp92__size == _tmp92__length) {
			_tmp92__size = 2 * _tmp92__size;
			_tmp92_ = g_renew (gchar*, _tmp92_, _tmp92__size + 1);
		}
		_tmp92_[_tmp92__length++] = g_variant_dup_string (_tmp94_, NULL);
		g_variant_unref (_tmp94_);
	}
	_result_length1 = _tmp92__length1;
	_tmp92_[_tmp92__length] = NULL;
	_result = _tmp92_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
sn_watcher_interface_dbus_proxy_get_is_status_notifier_host_registered (SnWatcherInterface* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "IsStatusNotifierHostRegistered");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.StatusNotifierWatcher"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("IsStatusNotifierHostRegistered"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp95_ = FALSE;
			return _tmp95_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gint32
sn_watcher_interface_dbus_proxy_get_protocol_version (SnWatcherInterface* self)
{
	GVariant *_inner_reply;
	gint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "ProtocolVersion");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.StatusNotifierWatcher"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ProtocolVersion"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint32 _tmp96_ = 0;
			return _tmp96_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
sn_watcher_interface_proxy_sn_watcher_interface_interface_init (SnWatcherInterfaceIface* iface)
{
	iface->register_status_notifier_host = sn_watcher_interface_proxy_register_status_notifier_host;
	iface->get_registered_status_notifier_pathnames_budgie = sn_watcher_interface_proxy_get_registered_status_notifier_pathnames_budgie;
	iface->get_registered_status_notifier_items = sn_watcher_interface_dbus_proxy_get_registered_status_notifier_items;
	iface->get_is_status_notifier_host_registered = sn_watcher_interface_dbus_proxy_get_is_status_notifier_host_registered;
	iface->get_protocol_version = sn_watcher_interface_dbus_proxy_get_protocol_version;
}

static void
_dbus_sn_watcher_interface_register_status_notifier_host (SnWatcherInterface* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* service = NULL;
	GVariant* _tmp97_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp97_ = g_variant_iter_next_value (&_arguments_iter);
	service = g_variant_dup_string (_tmp97_, NULL);
	g_variant_unref (_tmp97_);
	sn_watcher_interface_register_status_notifier_host (self, service, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (service);
	;
}

static void
_vala_DBusServiceInfo_array_free (DBusServiceInfo * array,
                                  gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			dbus_service_info_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_sn_watcher_interface_get_registered_status_notifier_pathnames_budgie (SnWatcherInterface* self,
                                                                            GVariant* _parameters_,
                                                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DBusServiceInfo* result;
	gint result_length1 = 0;
	DBusServiceInfo* _tmp98_;
	GVariantBuilder _tmp99_;
	gint _tmp100_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = sn_watcher_interface_get_registered_status_notifier_pathnames_budgie (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp98_ = result;
	g_variant_builder_init (&_tmp99_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp100_ = 0; _tmp100_ < result_length1; _tmp100_++) {
		GVariantBuilder _tmp101_;
		g_variant_builder_init (&_tmp101_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*_tmp98_).name));
		g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*_tmp98_).object_path));
		g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*_tmp98_).sender));
		g_variant_builder_add_value (&_tmp101_, g_variant_new_string ((*_tmp98_).owner));
		g_variant_builder_add_value (&_tmp99_, g_variant_builder_end (&_tmp101_));
		_tmp98_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp99_));
	result = (_vala_DBusServiceInfo_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
sn_watcher_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "RegisterStatusNotifierHost") == 0) {
		_dbus_sn_watcher_interface_register_status_notifier_host (object, parameters, invocation);
	} else if (strcmp (method_name, "GetRegisteredStatusNotifierPathnamesBudgie") == 0) {
		_dbus_sn_watcher_interface_get_registered_status_notifier_pathnames_budgie (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_sn_watcher_interface_get_registered_status_notifier_items (SnWatcherInterface* self)
{
	gchar** result;
	gint result_length1 = 0;
	GVariant* _reply;
	gchar** _tmp102_;
	GVariantBuilder _tmp103_;
	gint _tmp104_;
	result = sn_watcher_interface_get_registered_status_notifier_items (self, &result_length1);
	_tmp102_ = result;
	g_variant_builder_init (&_tmp103_, G_VARIANT_TYPE ("as"));
	for (_tmp104_ = 0; _tmp104_ < result_length1; _tmp104_++) {
		g_variant_builder_add_value (&_tmp103_, g_variant_new_string (*_tmp102_));
		_tmp102_++;
	}
	_reply = g_variant_builder_end (&_tmp103_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}

static GVariant*
_dbus_sn_watcher_interface_get_is_status_notifier_host_registered (SnWatcherInterface* self)
{
	gboolean result;
	GVariant* _reply;
	result = sn_watcher_interface_get_is_status_notifier_host_registered (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_sn_watcher_interface_get_protocol_version (SnWatcherInterface* self)
{
	gint32 result;
	GVariant* _reply;
	result = sn_watcher_interface_get_protocol_version (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
sn_watcher_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "RegisteredStatusNotifierItems") == 0) {
		return _dbus_sn_watcher_interface_get_registered_status_notifier_items (object);
	} else if (strcmp (property_name, "IsStatusNotifierHostRegistered") == 0) {
		return _dbus_sn_watcher_interface_get_is_status_notifier_host_registered (object);
	} else if (strcmp (property_name, "ProtocolVersion") == 0) {
		return _dbus_sn_watcher_interface_get_protocol_version (object);
	}
	return NULL;
}

static gboolean
sn_watcher_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_sn_watcher_interface_status_notifier_item_registered_budgie (GObject* _sender,
                                                                   const gchar* name,
                                                                   const gchar* object_path,
                                                                   const gchar* sender,
                                                                   const gchar* owner,
                                                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (object_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (owner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.StatusNotifierWatcher", "StatusNotifierItemRegisteredBudgie", _arguments, NULL);
}

static void
_dbus_sn_watcher_interface_status_notifier_item_unregistered_budgie (GObject* _sender,
                                                                     const gchar* name,
                                                                     const gchar* object_path,
                                                                     const gchar* sender,
                                                                     gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (object_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.StatusNotifierWatcher", "StatusNotifierItemUnregisteredBudgie", _arguments, NULL);
}

guint
sn_watcher_interface_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_sn_watcher_interface_dbus_interface_info), &_sn_watcher_interface_dbus_interface_vtable, data, _sn_watcher_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "status-notifier-item-registered-budgie", (GCallback) _dbus_sn_watcher_interface_status_notifier_item_registered_budgie, data);
	g_signal_connect (object, "status-notifier-item-unregistered-budgie", (GCallback) _dbus_sn_watcher_interface_status_notifier_item_unregistered_budgie, data);
	return result;
}

static void
_sn_watcher_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_watcher_interface_status_notifier_item_registered_budgie, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_watcher_interface_status_notifier_item_unregistered_budgie, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
tray_applet_get_instance_private (TrayApplet* self)
{
	return G_STRUCT_MEMBER_P (self, TrayApplet_private_offset);
}

static void
__lambda21_ (TrayApplet* self,
             const gchar* key)
{
	GtkBox* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->layout;
	_tmp1_ = self->priv->settings;
	gtk_box_set_spacing (_tmp0_, g_settings_get_int (_tmp1_, "spacing"));
}

static void
___lambda21__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda21_ ((TrayApplet*) self, key);
}

static void
__lambda23_ (TrayApplet* self,
             TrayItem* item)
{
	g_return_if_fail (item != NULL);
	tray_item_resize (item, tray_applet_get_target_panel_size (self));
}

static void
___lambda23__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda23_ ((TrayApplet*) self, (TrayItem*) data);
}

static void
__lambda22_ (TrayApplet* self,
             const gchar* key)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda23__gfunc, self);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
}

static void
___lambda22__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda22_ ((TrayApplet*) self, key);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

TrayApplet*
tray_applet_construct (GType object_type,
                       const gchar* uuid)
{
	TrayApplet * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkEventBox* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GSettings* _tmp9_;
	GtkBox* _tmp10_;
	GtkEventBox* _tmp11_;
	GtkBox* _tmp12_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (TrayApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "system-tray-applet");
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp1_;
	_tmp2_ = self->priv->box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.tray");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/tray");
	_tmp3_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = self->priv->settings;
	g_signal_connect_object (_tmp4_, "changed::spacing", (GCallback) ___lambda21__g_settings_changed, self, 0);
	_tmp5_ = self->priv->settings;
	g_signal_connect_object (_tmp5_, "changed::scaling", (GCallback) ___lambda22__g_settings_changed, self, 0);
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->items);
	self->priv->items = _tmp8_;
	_tmp9_ = self->priv->settings;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, g_settings_get_int (_tmp9_, "spacing"));
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp10_;
	_tmp11_ = self->priv->box;
	_tmp12_ = self->priv->layout;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	tray_applet_get_watcher_proxy (self);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

TrayApplet*
tray_applet_new (const gchar* uuid)
{
	return tray_applet_construct (TYPE_TRAY_APPLET, uuid);
}

static void
_tray_applet_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                GAsyncResult* res,
                                                gpointer self)
{
	tray_applet_on_dbus_get ((TrayApplet*) self, source_object, res);
	g_object_unref (self);
}

static void
tray_applet_get_watcher_proxy (TrayApplet* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_async_initable_new_async (TYPE_SN_WATCHER_INTERFACE_PROXY, 0, NULL, _tray_applet_on_dbus_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", "org.freedesktop.StatusNotifierWatcher", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/StatusNotifierWatcher", "g-interface-name", "org.freedesktop.StatusNotifierWatcher", NULL);
}

static gboolean
__lambda25_ (TrayApplet* self)
{
	gboolean result;
	tray_applet_on_watcher_init (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda25_ ((TrayApplet*) self);
	return result;
}

static void
__lambda24_ (TrayApplet* self,
             GDBusConnection* conn,
             const gchar* name,
             const gchar* owner)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (owner != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda25__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda24__gbus_name_appeared_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          const gchar* name_owner,
                                          gpointer self)
{
	__lambda24_ ((TrayApplet*) self, connection, name, name_owner);
}

static void
__lambda28_ (TrayApplet* self,
             GDBusConnection* conn,
             const gchar* name)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	tray_applet_get_watcher_proxy (self);
}

static void
___lambda28__gbus_name_vanished_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda28_ ((TrayApplet*) self, connection, name);
}

static void
tray_applet_on_dbus_get (TrayApplet* self,
                         GObject* o,
                         GAsyncResult* res)
{
	SnWatcherInterface* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->watcher;
	if (_tmp0_ != NULL) {
		return;
	}
	{
		SnWatcherInterface* _tmp1_ = NULL;
		SnWatcherInterface* _tmp2_;
		SnWatcherInterface* _tmp3_;
		SnWatcherInterface* _tmp4_;
		_tmp2_ = g_async_result_get_source_object (res);
		_tmp3_ = (SnWatcherInterface*) g_async_initable_new_finish ((GAsyncInitable *) _tmp2_, res, &_inner_error0_);
		g_object_unref (_tmp2_);
		_tmp1_ = (SnWatcherInterface*) _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->watcher);
		self->priv->watcher = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("TrayApplet.vala:116: Unable to connect to status notifier watcher: %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "org.freedesktop.StatusNotifierWatcher", 0, (GClosure*) ((___lambda24__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda24__gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda28__gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda28__gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TrayApplet* self;
		self = _data4_->self;
		_g_free0 (_data4_->host_name);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_tray_applet_register_new_item_sn_watcher_interface_status_notifier_item_registered_budgie (SnWatcherInterface* _sender,
                                                                                            const gchar* name,
                                                                                            const gchar* object_path,
                                                                                            const gchar* sender,
                                                                                            const gchar* owner,
                                                                                            gpointer self)
{
	tray_applet_register_new_item ((TrayApplet*) self, name, object_path, sender, owner);
}

static void
__lambda26_ (TrayApplet* self,
             const gchar* name,
             const gchar* path,
             const gchar* sender)
{
	gchar* key = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = g_strconcat (sender, name, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, path, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	key = _tmp3_;
	_tmp4_ = self->priv->items;
	_tmp5_ = key;
	if (g_hash_table_contains (_tmp4_, _tmp5_)) {
		GtkBox* _tmp6_;
		GHashTable* _tmp7_;
		const gchar* _tmp8_;
		gconstpointer _tmp9_;
		GHashTable* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = self->priv->layout;
		_tmp7_ = self->priv->items;
		_tmp8_ = key;
		_tmp9_ = g_hash_table_lookup (_tmp7_, _tmp8_);
		gtk_container_remove ((GtkContainer*) _tmp6_, (GtkWidget*) ((TrayItem*) _tmp9_));
		_tmp10_ = self->priv->items;
		_tmp11_ = key;
		g_hash_table_remove (_tmp10_, _tmp11_);
	}
	_g_free0 (key);
}

static void
___lambda26__sn_watcher_interface_status_notifier_item_unregistered_budgie (SnWatcherInterface* _sender,
                                                                            const gchar* name,
                                                                            const gchar* object_path,
                                                                            const gchar* sender,
                                                                            gpointer self)
{
	__lambda26_ ((TrayApplet*) self, name, object_path, sender);
}

static void
__lambda27_ (Block4Data* _data4_,
             GDBusConnection* conn,
             const gchar* name)
{
	TrayApplet* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	{
		SnWatcherInterface* _tmp0_;
		_tmp0_ = self->priv->watcher;
		sn_watcher_interface_register_status_notifier_host (_tmp0_, _data4_->host_name, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("TrayApplet.vala:163: Failed to register Status Notifier host: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda27__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda27_ (self, connection, name);
}

static void
tray_applet_on_watcher_init (TrayApplet* self)
{
	Block4Data* _data4_;
	SnWatcherInterface* _tmp15_;
	SnWatcherInterface* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	{
		DBusServiceInfo* services = NULL;
		SnWatcherInterface* _tmp0_;
		gint _tmp1_ = 0;
		DBusServiceInfo* _tmp2_;
		gint services_length1;
		gint _services_size_;
		_tmp0_ = self->priv->watcher;
		_tmp2_ = sn_watcher_interface_get_registered_status_notifier_pathnames_budgie (_tmp0_, &_tmp1_, &_inner_error0_);
		services = _tmp2_;
		services_length1 = _tmp1_;
		_services_size_ = services_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			DBusServiceInfo* service_collection = NULL;
			gint service_collection_length1 = 0;
			gint _service_collection_size_ = 0;
			gint service_it = 0;
			service_collection = services;
			service_collection_length1 = services_length1;
			for (service_it = 0; service_it < service_collection_length1; service_it = service_it + 1) {
				DBusServiceInfo _tmp3_;
				DBusServiceInfo _tmp4_ = {0};
				DBusServiceInfo service = {0};
				_tmp3_ = service_collection[service_it];
				dbus_service_info_copy (&_tmp3_, &_tmp4_);
				service = _tmp4_;
				{
					DBusServiceInfo _tmp5_;
					const gchar* _tmp6_;
					DBusServiceInfo _tmp7_;
					const gchar* _tmp8_;
					DBusServiceInfo _tmp9_;
					const gchar* _tmp10_;
					DBusServiceInfo _tmp11_;
					const gchar* _tmp12_;
					_tmp5_ = service;
					_tmp6_ = _tmp5_.name;
					_tmp7_ = service;
					_tmp8_ = _tmp7_.object_path;
					_tmp9_ = service;
					_tmp10_ = _tmp9_.sender;
					_tmp11_ = service;
					_tmp12_ = _tmp11_.owner;
					tray_applet_register_new_item (self, _tmp6_, _tmp8_, _tmp10_, _tmp12_);
					dbus_service_info_destroy (&service);
				}
			}
		}
		services = (_vala_DBusServiceInfo_array_free (services, services_length1), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_critical ("TrayApplet.vala:139: Unable to fetch existing status notifier items: %" \
"s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp15_ = self->priv->watcher;
	g_signal_connect_object (_tmp15_, "status-notifier-item-registered-budgie", (GCallback) _tray_applet_register_new_item_sn_watcher_interface_status_notifier_item_registered_budgie, self, 0);
	_tmp16_ = self->priv->watcher;
	g_signal_connect_object (_tmp16_, "status-notifier-item-unregistered-budgie", (GCallback) ___lambda26__sn_watcher_interface_status_notifier_item_unregistered_budgie, self, 0);
	_tmp17_ = self->priv->_uuid;
	_tmp18_ = g_strconcat ("org.freedesktop.StatusNotifierHost-budgie_", _tmp17_, NULL);
	_data4_->host_name = _tmp18_;
	self->priv->dbus_identifier = g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, _data4_->host_name, G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT | G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda27__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda27__gbus_name_acquired_callback, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
tray_applet_register_new_item (TrayApplet* self,
                               const gchar* name,
                               const gchar* object_path,
                               const gchar* sender,
                               const gchar* owner)
{
	gchar* key = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (owner != NULL);
	_tmp0_ = g_strconcat (sender, name, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, object_path, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	key = _tmp3_;
	_tmp4_ = self->priv->items;
	_tmp5_ = key;
	if (g_hash_table_contains (_tmp4_, _tmp5_)) {
		_g_free0 (key);
		return;
	}
	{
		TrayItem* new_item = NULL;
		TrayItem* _tmp6_;
		GHashTable* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		TrayItem* _tmp10_;
		TrayItem* _tmp11_;
		_tmp6_ = tray_item_new (name, object_path, tray_applet_get_target_panel_size (self), &_inner_error0_);
		g_object_ref_sink (_tmp6_);
		new_item = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->items;
		_tmp8_ = key;
		_tmp9_ = g_strdup (_tmp8_);
		_tmp10_ = new_item;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		g_hash_table_insert (_tmp7_, _tmp9_, _tmp11_);
		if (g_strcmp0 (object_path, "/org/ayatana/NotificationItem/nm_applet") == 0) {
			GtkBox* _tmp12_;
			TrayItem* _tmp13_;
			_tmp12_ = self->priv->layout;
			_tmp13_ = new_item;
			gtk_box_pack_end (_tmp12_, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
		} else {
			GtkBox* _tmp14_;
			TrayItem* _tmp15_;
			GtkBox* _tmp16_;
			TrayItem* _tmp17_;
			_tmp14_ = self->priv->layout;
			_tmp15_ = new_item;
			gtk_box_pack_start (_tmp14_, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
			_tmp16_ = self->priv->layout;
			_tmp17_ = new_item;
			gtk_box_reorder_child (_tmp16_, (GtkWidget*) _tmp17_, 0);
		}
		_g_object_unref0 (new_item);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("TrayApplet.vala:184: Failed to fetch dbus item info for name=%s and pa" \
"th=%s", name, object_path);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (key);
}

static gint
tray_applet_get_target_panel_size (TrayApplet* self)
{
	GSettings* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp0_, "scaling")) {
		result = self->priv->panel_size;
		return result;
	} else {
		result = (gint) fmin ((gdouble) self->priv->panel_size, (gdouble) TRAY_APPLET_DEFAULT_PANEL_SIZE);
		return result;
	}
}

static void
tray_applet_real_panel_position_changed (BudgieApplet* base,
                                         BudgiePanelPosition position)
{
	TrayApplet * self;
	gboolean _tmp0_ = FALSE;
	self = (TrayApplet*) base;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		GtkBox* _tmp1_;
		_tmp1_ = self->priv->layout;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp1_, GTK_ORIENTATION_VERTICAL);
		gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_BASELINE);
		gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	} else {
		GtkBox* _tmp2_;
		_tmp2_ = self->priv->layout;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp2_, GTK_ORIENTATION_HORIZONTAL);
		gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
		gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_BASELINE);
	}
}

static void
__lambda29_ (TrayApplet* self,
             TrayItem* item)
{
	g_return_if_fail (item != NULL);
	tray_item_resize (item, tray_applet_get_target_panel_size (self));
}

static void
___lambda29__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda29_ ((TrayApplet*) self, (TrayItem*) data);
}

static void
tray_applet_real_panel_size_changed (BudgieApplet* base,
                                     gint panel,
                                     gint icon,
                                     gint small_icon)
{
	TrayApplet * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	self = (TrayApplet*) base;
	self->priv->panel_size = panel;
	_tmp0_ = self->priv->items;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda29__gfunc, self);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
}

static gboolean
tray_applet_real_supports_settings (BudgieApplet* base)
{
	TrayApplet * self;
	gboolean result;
	self = (TrayApplet*) base;
	result = TRUE;
	return result;
}

static GtkWidget*
tray_applet_real_get_settings_ui (BudgieApplet* base)
{
	TrayApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	TraySettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (TrayApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tray_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

const gchar*
tray_applet_get_uuid (TrayApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
tray_applet_set_uuid (TrayApplet* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tray_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tray_applet_properties[TRAY_APPLET_UUID_PROPERTY]);
	}
}

static void
tray_applet_class_init (TrayAppletClass * klass,
                        gpointer klass_data)
{
	tray_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TrayApplet_private_offset);
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) tray_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->panel_size_changed = (void (*) (BudgieApplet*, gint, gint, gint)) tray_applet_real_panel_size_changed;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) tray_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) tray_applet_real_get_settings_ui;
	G_OBJECT_CLASS (klass)->get_property = _vala_tray_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tray_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = tray_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRAY_APPLET_UUID_PROPERTY, tray_applet_properties[TRAY_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tray_applet_instance_init (TrayApplet * self,
                           gpointer klass)
{
	self->priv = tray_applet_get_instance_private (self);
	self->priv->watcher = NULL;
}

static void
tray_applet_finalize (GObject * obj)
{
	TrayApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRAY_APPLET, TrayApplet);
	g_bus_unown_name (self->priv->dbus_identifier);
	_g_free0 (self->priv->_uuid);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->layout);
	_g_hash_table_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->watcher);
	G_OBJECT_CLASS (tray_applet_parent_class)->finalize (obj);
}

GType
tray_applet_get_type (void)
{
	return tray_applet_type_id;
}

GType
tray_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrayAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tray_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrayApplet), 0, (GInstanceInitFunc) tray_applet_instance_init, NULL };
	tray_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "TrayApplet", &g_define_type_info, 0);
	TrayApplet_private_offset = sizeof (TrayAppletPrivate);
	return tray_applet_type_id;
}

static void
_vala_tray_applet_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	TrayApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TRAY_APPLET, TrayApplet);
	switch (property_id) {
		case TRAY_APPLET_UUID_PROPERTY:
		g_value_set_string (value, tray_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tray_applet_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	TrayApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TRAY_APPLET, TrayApplet);
	switch (property_id) {
		case TRAY_APPLET_UUID_PROPERTY:
		tray_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	dbus_menu_register_type (module);
	dbus_menu_node_register_type (module);
	dbus_menu_item_register_type (module);
	properties_register_type (module);
	tray_plugin_register_type (module);
	tray_settings_register_type (module);
	tray_applet_register_type (module);
	tray_item_register_type (module);
	dbus_menu_interface_register_type (module);
	dbus_menu_interface_proxy_register_dynamic_type (module);
	sn_watcher_interface_register_type (module);
	sn_watcher_interface_proxy_register_dynamic_type (module);
	sn_item_properties_register_type (module);
	sn_item_properties_proxy_register_dynamic_type (module);
	sn_item_interface_register_type (module);
	sn_item_interface_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_TRAY_PLUGIN);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

