/* dbus.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dbus.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdio.h>

#define BUDGIE_TRACKER_DBUS_NAME "org.buddiesofbudgie.XDGDirTracker"
#define BUDGIE_TRACKER_DBUS_OBJECT_PATH "/org/buddiesofbudgie/XDGDirTracker"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_XDG_DIR_TRACKER (budgie_xdg_dir_tracker_get_type ())
#define BUDGIE_XDG_DIR_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTracker))
#define BUDGIE_XDG_DIR_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTrackerClass))
#define BUDGIE_IS_XDG_DIR_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER))
#define BUDGIE_IS_XDG_DIR_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_XDG_DIR_TRACKER))
#define BUDGIE_XDG_DIR_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTrackerClass))

typedef struct _BudgieXDGDirTracker BudgieXDGDirTracker;
typedef struct _BudgieXDGDirTrackerClass BudgieXDGDirTrackerClass;
typedef struct _BudgieXDGDirTrackerPrivate BudgieXDGDirTrackerPrivate;
enum  {
	BUDGIE_XDG_DIR_TRACKER_0_PROPERTY,
	BUDGIE_XDG_DIR_TRACKER_NUM_PROPERTIES
};
static GParamSpec* budgie_xdg_dir_tracker_properties[BUDGIE_XDG_DIR_TRACKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_XDG_DIR_TRACKER_XDG_DIRS_EXIST_SIGNAL,
	BUDGIE_XDG_DIR_TRACKER_NUM_SIGNALS
};
static guint budgie_xdg_dir_tracker_signals[BUDGIE_XDG_DIR_TRACKER_NUM_SIGNALS] = {0};

struct _BudgieXDGDirTracker {
	GObject parent_instance;
	BudgieXDGDirTrackerPrivate * priv;
	GUserDirectory* dirs;
	gint dirs_length1;
};

struct _BudgieXDGDirTrackerClass {
	GObjectClass parent_class;
};

struct _BudgieXDGDirTrackerPrivate {
	GFile* home_dir_file;
	GFileMonitor* home_dir_monitor;
};

static gint BudgieXDGDirTracker_private_offset;
static gpointer budgie_xdg_dir_tracker_parent_class = NULL;

VALA_EXTERN GType budgie_xdg_dir_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieXDGDirTracker, g_object_unref)
VALA_EXTERN guint budgie_xdg_dir_tracker_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN BudgieXDGDirTracker* budgie_xdg_dir_tracker_new (void);
VALA_EXTERN BudgieXDGDirTracker* budgie_xdg_dir_tracker_construct (GType object_type);
static void budgie_xdg_dir_tracker_on_homedir_changed (BudgieXDGDirTracker* self);
static void _budgie_xdg_dir_tracker_on_homedir_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                        GFile* file,
                                                                        GFile* other_file,
                                                                        GFileMonitorEvent event_type,
                                                                        gpointer self);
VALA_EXTERN GUserDirectory* budgie_xdg_dir_tracker_get_dirs (BudgieXDGDirTracker* self,
                                                 gint* result_length1,
                                                 GError** error);
static GUserDirectory* _vala_array_dup2 (GUserDirectory* self,
                                  gssize length);
VALA_EXTERN void budgie_xdg_dir_tracker_setup_dbus (BudgieXDGDirTracker* self,
                                        gboolean replace);
static void budgie_xdg_dir_tracker_on_dbus_acquired (BudgieXDGDirTracker* self,
                                              GDBusConnection* conn);
static void _budgie_xdg_dir_tracker_on_dbus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      gpointer self);
static void __lambda46_ (BudgieXDGDirTracker* self);
static void ___lambda46__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
VALA_EXTERN void budgie_DaemonNameLost (GDBusConnection* conn,
                            const gchar* name);
static void _budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                     const gchar* name,
                                                     gpointer self);
static void _vala_array_add5 (GUserDirectory* * array,
                       gint* length,
                       gint* size,
                       GUserDirectory value);
static void _vala_array_add6 (GUserDirectory* * array,
                       gint* length,
                       gint* size,
                       GUserDirectory value);
static void budgie_xdg_dir_tracker_update_xdgs (BudgieXDGDirTracker* self,
                                         GUserDirectory* xdgs,
                                         gint xdgs_length1);
static GUserDirectory* _vala_array_dup3 (GUserDirectory* self,
                                  gssize length);
static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void budgie_xdg_dir_tracker_finalize (GObject * obj);
static GType budgie_xdg_dir_tracker_get_type_once (void);
static void _dbus_budgie_xdg_dir_tracker_get_dirs (BudgieXDGDirTracker* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void budgie_xdg_dir_tracker_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* budgie_xdg_dir_tracker_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static gboolean budgie_xdg_dir_tracker_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _dbus_budgie_xdg_dir_tracker_xdg_dirs_exist (GObject* _sender,
                                                  GUserDirectory* dirs,
                                                  gint dirs_length1,
                                                  gpointer* _data);
static void _budgie_xdg_dir_tracker_unregister_object (gpointer user_data);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GUserDirectory BUDGIE_XDG_DIR_TRACKER_xdg_dirs[6] = {G_USER_DIRECTORY_DESKTOP, G_USER_DIRECTORY_DOCUMENTS, G_USER_DIRECTORY_DOWNLOAD, G_USER_DIRECTORY_MUSIC, G_USER_DIRECTORY_PICTURES, G_USER_DIRECTORY_VIDEOS};
static const GDBusArgInfo _budgie_xdg_dir_tracker_dbus_arg_info_get_dirs_result = {-1, "result", "ai", NULL};
static const GDBusArgInfo * const _budgie_xdg_dir_tracker_dbus_arg_info_get_dirs_in[] = {NULL};
static const GDBusArgInfo * const _budgie_xdg_dir_tracker_dbus_arg_info_get_dirs_out[] = {&_budgie_xdg_dir_tracker_dbus_arg_info_get_dirs_result, NULL};
static const GDBusMethodInfo _budgie_xdg_dir_tracker_dbus_method_info_get_dirs = {-1, "GetDirs", (GDBusArgInfo **) (&_budgie_xdg_dir_tracker_dbus_arg_info_get_dirs_in), (GDBusArgInfo **) (&_budgie_xdg_dir_tracker_dbus_arg_info_get_dirs_out), NULL};
static const GDBusMethodInfo * const _budgie_xdg_dir_tracker_dbus_method_info[] = {&_budgie_xdg_dir_tracker_dbus_method_info_get_dirs, NULL};
static const GDBusArgInfo _budgie_xdg_dir_tracker_dbus_arg_info_xdg_dirs_exist_dirs = {-1, "dirs", "ai", NULL};
static const GDBusArgInfo * const _budgie_xdg_dir_tracker_dbus_arg_info_xdg_dirs_exist[] = {&_budgie_xdg_dir_tracker_dbus_arg_info_xdg_dirs_exist_dirs, NULL};
static const GDBusSignalInfo _budgie_xdg_dir_tracker_dbus_signal_info_xdg_dirs_exist = {-1, "XdgDirsExist", (GDBusArgInfo **) (&_budgie_xdg_dir_tracker_dbus_arg_info_xdg_dirs_exist), NULL};
static const GDBusSignalInfo * const _budgie_xdg_dir_tracker_dbus_signal_info[] = {&_budgie_xdg_dir_tracker_dbus_signal_info_xdg_dirs_exist, NULL};
static const GDBusPropertyInfo * const _budgie_xdg_dir_tracker_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_xdg_dir_tracker_dbus_interface_info = {-1, "org.buddiesofbudgie.XDGDirTracker", (GDBusMethodInfo **) (&_budgie_xdg_dir_tracker_dbus_method_info), (GDBusSignalInfo **) (&_budgie_xdg_dir_tracker_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_xdg_dir_tracker_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_xdg_dir_tracker_dbus_interface_vtable = {budgie_xdg_dir_tracker_dbus_interface_method_call, budgie_xdg_dir_tracker_dbus_interface_get_property, budgie_xdg_dir_tracker_dbus_interface_set_property};

static inline gpointer
budgie_xdg_dir_tracker_get_instance_private (BudgieXDGDirTracker* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieXDGDirTracker_private_offset);
}

static void
_budgie_xdg_dir_tracker_on_homedir_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                   GFile* file,
                                                                   GFile* other_file,
                                                                   GFileMonitorEvent event_type,
                                                                   gpointer self)
{
	budgie_xdg_dir_tracker_on_homedir_changed ((BudgieXDGDirTracker*) self);
}

BudgieXDGDirTracker*
budgie_xdg_dir_tracker_construct (GType object_type)
{
	BudgieXDGDirTracker * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (BudgieXDGDirTracker*) g_object_new (object_type, NULL);
	{
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFileMonitor* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		GFileMonitor* _tmp6_;
		_tmp0_ = g_get_home_dir ();
		_tmp1_ = g_file_new_for_path (_tmp0_);
		_g_object_unref0 (self->priv->home_dir_file);
		self->priv->home_dir_file = _tmp1_;
		_tmp3_ = self->priv->home_dir_file;
		_tmp4_ = g_file_monitor_directory (_tmp3_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->home_dir_monitor);
		self->priv->home_dir_monitor = _tmp5_;
		_tmp6_ = self->priv->home_dir_monitor;
		g_signal_connect_object (_tmp6_, "changed", (GCallback) _budgie_xdg_dir_tracker_on_homedir_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("dbus.vala:33: Failed to create our XDGDirTracker: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

BudgieXDGDirTracker*
budgie_xdg_dir_tracker_new (void)
{
	return budgie_xdg_dir_tracker_construct (BUDGIE_TYPE_XDG_DIR_TRACKER);
}

static GUserDirectory*
_vala_array_dup2 (GUserDirectory* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (GUserDirectory));
	}
	return NULL;
}

GUserDirectory*
budgie_xdg_dir_tracker_get_dirs (BudgieXDGDirTracker* self,
                                 gint* result_length1,
                                 GError** error)
{
	GUserDirectory* _tmp0_;
	gint _tmp0__length1;
	GUserDirectory* _tmp1_;
	gint _tmp1__length1;
	GUserDirectory* _tmp2_;
	gint _tmp2__length1;
	GUserDirectory* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->dirs;
	_tmp0__length1 = self->dirs_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_budgie_xdg_dir_tracker_on_dbus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                 const gchar* name,
                                                                 gpointer self)
{
	budgie_xdg_dir_tracker_on_dbus_acquired ((BudgieXDGDirTracker*) self, connection);
}

static void
__lambda46_ (BudgieXDGDirTracker* self)
{
}

static void
___lambda46__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda46_ ((BudgieXDGDirTracker*) self);
}

static void
_budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self)
{
	budgie_DaemonNameLost (connection, name);
}

void
budgie_xdg_dir_tracker_setup_dbus (BudgieXDGDirTracker* self,
                                   gboolean replace)
{
	GBusNameOwnerFlags flags = 0U;
	g_return_if_fail (self != NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	if (replace) {
		flags |= G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_TRACKER_DBUS_NAME, flags, (GClosure*) ((_budgie_xdg_dir_tracker_on_dbus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_xdg_dir_tracker_on_dbus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda46__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda46__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) g_cclosure_new ((GCallback) _budgie_DaemonNameLost_gbus_name_lost_callback, NULL, (GClosureNotify) NULL));
}

static void
budgie_xdg_dir_tracker_on_dbus_acquired (BudgieXDGDirTracker* self,
                                         GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_xdg_dir_tracker_register_object (self, conn, BUDGIE_TRACKER_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		budgie_xdg_dir_tracker_on_homedir_changed (self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Error registering our XDGDirTracker: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_vala_array_add5 (GUserDirectory* * array,
                  gint* length,
                  gint* size,
                  GUserDirectory value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GUserDirectory, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add6 (GUserDirectory* * array,
                  gint* length,
                  gint* size,
                  GUserDirectory value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GUserDirectory, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
budgie_xdg_dir_tracker_on_homedir_changed (BudgieXDGDirTracker* self)
{
	GUserDirectory* existing_xdgs = NULL;
	GUserDirectory* _tmp0_;
	gint existing_xdgs_length1;
	gint _existing_xdgs_size_;
	gboolean _tmp27_ = FALSE;
	GUserDirectory* _tmp28_;
	gint _tmp28__length1;
	GUserDirectory* _tmp31_;
	gint _tmp31__length1;
	GUserDirectory* _tmp32_;
	gint _tmp32__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (GUserDirectory, 0);
	existing_xdgs = _tmp0_;
	existing_xdgs_length1 = 0;
	_existing_xdgs_size_ = existing_xdgs_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GUserDirectory xdg_dir = 0;
				GUserDirectory _tmp3_;
				const gchar* path = NULL;
				const gchar* _tmp4_;
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp6_;
				GFile* xdg_file = NULL;
				const gchar* _tmp11_;
				GFile* _tmp12_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < G_N_ELEMENTS (BUDGIE_XDG_DIR_TRACKER_xdg_dirs))) {
					break;
				}
				_tmp3_ = BUDGIE_XDG_DIR_TRACKER_xdg_dirs[i];
				xdg_dir = _tmp3_;
				_tmp4_ = g_get_user_special_dir (xdg_dir);
				path = _tmp4_;
				_tmp6_ = path;
				if (_tmp6_ == NULL) {
					_tmp5_ = TRUE;
				} else {
					const gchar* _tmp7_;
					GFile* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp7_ = path;
					_tmp8_ = self->priv->home_dir_file;
					_tmp9_ = g_file_get_path (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp5_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
					_g_free0 (_tmp10_);
				}
				if (_tmp5_) {
					continue;
				}
				_tmp11_ = path;
				_tmp12_ = g_file_new_for_path (_tmp11_);
				xdg_file = _tmp12_;
				{
					GFileInfo* info = NULL;
					GFile* _tmp13_;
					GFileInfo* _tmp14_;
					GFileInfo* _tmp15_;
					GFileType t = 0;
					GFileInfo* _tmp16_;
					_tmp13_ = xdg_file;
					_tmp14_ = g_file_query_info (_tmp13_, "standard::*", 0, NULL, &_inner_error0_);
					info = _tmp14_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp15_ = info;
					if (_tmp15_ == NULL) {
						_g_object_unref0 (info);
						_g_object_unref0 (xdg_file);
						continue;
					}
					_tmp16_ = info;
					t = g_file_info_get_file_type (_tmp16_);
					if (t == G_FILE_TYPE_DIRECTORY) {
						_vala_array_add5 (&existing_xdgs, &existing_xdgs_length1, &_existing_xdgs_size_, xdg_dir);
					} else {
						if (t == G_FILE_TYPE_SYMBOLIC_LINK) {
							gchar* symlink_target = NULL;
							GFileInfo* _tmp17_;
							const gchar* _tmp18_;
							gchar* _tmp19_;
							const gchar* _tmp20_;
							GFile* sym_file = NULL;
							const gchar* _tmp21_;
							GFile* _tmp22_;
							GFile* _tmp23_;
							_tmp17_ = info;
							_tmp18_ = g_file_info_get_symlink_target (_tmp17_);
							_tmp19_ = g_strdup (_tmp18_);
							symlink_target = _tmp19_;
							_tmp20_ = symlink_target;
							if (_tmp20_ == NULL) {
								_g_free0 (symlink_target);
								_g_object_unref0 (info);
								_g_object_unref0 (xdg_file);
								continue;
							}
							_tmp21_ = symlink_target;
							_tmp22_ = g_file_new_for_path (_tmp21_);
							sym_file = _tmp22_;
							_tmp23_ = sym_file;
							if (!g_file_query_exists (_tmp23_, NULL)) {
								_g_object_unref0 (sym_file);
								_g_free0 (symlink_target);
								_g_object_unref0 (info);
								_g_object_unref0 (xdg_file);
								continue;
							}
							_vala_array_add6 (&existing_xdgs, &existing_xdgs_length1, &_existing_xdgs_size_, xdg_dir);
							_g_object_unref0 (sym_file);
							_g_free0 (symlink_target);
						}
					}
					_g_object_unref0 (info);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp24_;
					GError* _tmp25_;
					const gchar* _tmp26_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp24_ = path;
					_tmp25_ = e;
					_tmp26_ = _tmp25_->message;
					g_warning ("dbus.vala:99: Failed to get file info for %s: %s", _tmp24_, _tmp26_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (xdg_file);
					existing_xdgs = (g_free (existing_xdgs), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_object_unref0 (xdg_file);
			}
		}
	}
	_tmp28_ = self->dirs;
	_tmp28__length1 = self->dirs_length1;
	if (_tmp28_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		GUserDirectory* _tmp29_;
		gint _tmp29__length1;
		_tmp29_ = self->dirs;
		_tmp29__length1 = self->dirs_length1;
		_tmp27_ = _tmp29__length1 == 0;
	}
	if (_tmp27_) {
		GUserDirectory* _tmp30_;
		gint _tmp30__length1;
		_tmp30_ = existing_xdgs;
		_tmp30__length1 = existing_xdgs_length1;
		budgie_xdg_dir_tracker_update_xdgs (self, _tmp30_, (gint) _tmp30__length1);
		existing_xdgs = (g_free (existing_xdgs), NULL);
		return;
	}
	_tmp31_ = self->dirs;
	_tmp31__length1 = self->dirs_length1;
	_tmp32_ = existing_xdgs;
	_tmp32__length1 = existing_xdgs_length1;
	if (_tmp31__length1 != _tmp32__length1) {
		GUserDirectory* _tmp33_;
		gint _tmp33__length1;
		_tmp33_ = existing_xdgs;
		_tmp33__length1 = existing_xdgs_length1;
		budgie_xdg_dir_tracker_update_xdgs (self, _tmp33_, (gint) _tmp33__length1);
		existing_xdgs = (g_free (existing_xdgs), NULL);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				GUserDirectory* _tmp36_;
				gint _tmp36__length1;
				GUserDirectory path = 0;
				GUserDirectory* _tmp37_;
				gint _tmp37__length1;
				GUserDirectory _tmp38_;
				GUserDirectory existing_entry = 0;
				GUserDirectory* _tmp39_;
				gint _tmp39__length1;
				GUserDirectory _tmp40_;
				if (!_tmp34_) {
					gint _tmp35_;
					_tmp35_ = i;
					i = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp36_ = existing_xdgs;
				_tmp36__length1 = existing_xdgs_length1;
				if (!(i < _tmp36__length1)) {
					break;
				}
				_tmp37_ = existing_xdgs;
				_tmp37__length1 = existing_xdgs_length1;
				_tmp38_ = _tmp37_[i];
				path = _tmp38_;
				_tmp39_ = self->dirs;
				_tmp39__length1 = self->dirs_length1;
				_tmp40_ = _tmp39_[i];
				existing_entry = _tmp40_;
				if (path != existing_entry) {
					GUserDirectory* _tmp41_;
					gint _tmp41__length1;
					_tmp41_ = existing_xdgs;
					_tmp41__length1 = existing_xdgs_length1;
					budgie_xdg_dir_tracker_update_xdgs (self, _tmp41_, (gint) _tmp41__length1);
					existing_xdgs = (g_free (existing_xdgs), NULL);
					return;
				}
			}
		}
	}
	existing_xdgs = (g_free (existing_xdgs), NULL);
}

static GUserDirectory*
_vala_array_dup3 (GUserDirectory* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (GUserDirectory));
	}
	return NULL;
}

static void
budgie_xdg_dir_tracker_update_xdgs (BudgieXDGDirTracker* self,
                                    GUserDirectory* xdgs,
                                    gint xdgs_length1)
{
	GUserDirectory* _tmp0_;
	gint _tmp0__length1;
	GUserDirectory* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (xdgs != NULL) ? _vala_array_dup3 (xdgs, xdgs_length1) : xdgs;
	_tmp0__length1 = xdgs_length1;
	self->dirs = (g_free (self->dirs), NULL);
	self->dirs = _tmp0_;
	self->dirs_length1 = _tmp0__length1;
	_tmp1_ = self->dirs;
	_tmp1__length1 = self->dirs_length1;
	g_signal_emit (self, budgie_xdg_dir_tracker_signals[BUDGIE_XDG_DIR_TRACKER_XDG_DIRS_EXIST_SIGNAL], 0, _tmp1_, (gint) _tmp1__length1);
}

static void
g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__POINTER_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
budgie_xdg_dir_tracker_class_init (BudgieXDGDirTrackerClass * klass,
                                   gpointer klass_data)
{
	budgie_xdg_dir_tracker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieXDGDirTracker_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_xdg_dir_tracker_finalize;
	budgie_xdg_dir_tracker_signals[BUDGIE_XDG_DIR_TRACKER_XDG_DIRS_EXIST_SIGNAL] = g_signal_new ("xdg-dirs-exist", BUDGIE_TYPE_XDG_DIR_TRACKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT);
}

static void
budgie_xdg_dir_tracker_instance_init (BudgieXDGDirTracker * self,
                                      gpointer klass)
{
	GUserDirectory* _tmp0_;
	self->priv = budgie_xdg_dir_tracker_get_instance_private (self);
	_tmp0_ = g_new0 (GUserDirectory, 0);
	self->dirs = _tmp0_;
	self->dirs_length1 = 0;
}

static void
budgie_xdg_dir_tracker_finalize (GObject * obj)
{
	BudgieXDGDirTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_XDG_DIR_TRACKER, BudgieXDGDirTracker);
	self->dirs = (g_free (self->dirs), NULL);
	_g_object_unref0 (self->priv->home_dir_file);
	_g_object_unref0 (self->priv->home_dir_monitor);
	G_OBJECT_CLASS (budgie_xdg_dir_tracker_parent_class)->finalize (obj);
}

static GType
budgie_xdg_dir_tracker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieXDGDirTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_xdg_dir_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieXDGDirTracker), 0, (GInstanceInitFunc) budgie_xdg_dir_tracker_instance_init, NULL };
	GType budgie_xdg_dir_tracker_type_id;
	budgie_xdg_dir_tracker_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieXDGDirTracker", &g_define_type_info, 0);
	g_type_set_qdata (budgie_xdg_dir_tracker_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_xdg_dir_tracker_register_object);
	BudgieXDGDirTracker_private_offset = g_type_add_instance_private (budgie_xdg_dir_tracker_type_id, sizeof (BudgieXDGDirTrackerPrivate));
	return budgie_xdg_dir_tracker_type_id;
}

GType
budgie_xdg_dir_tracker_get_type (void)
{
	static volatile gsize budgie_xdg_dir_tracker_type_id__once = 0;
	if (g_once_init_enter (&budgie_xdg_dir_tracker_type_id__once)) {
		GType budgie_xdg_dir_tracker_type_id;
		budgie_xdg_dir_tracker_type_id = budgie_xdg_dir_tracker_get_type_once ();
		g_once_init_leave (&budgie_xdg_dir_tracker_type_id__once, budgie_xdg_dir_tracker_type_id);
	}
	return budgie_xdg_dir_tracker_type_id__once;
}

static void
_dbus_budgie_xdg_dir_tracker_get_dirs (BudgieXDGDirTracker* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUserDirectory* result;
	gint result_length1 = 0;
	GUserDirectory* _tmp70_;
	GVariantBuilder _tmp71_;
	gint _tmp72_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_xdg_dir_tracker_get_dirs (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp70_ = result;
	g_variant_builder_init (&_tmp71_, G_VARIANT_TYPE ("ai"));
	for (_tmp72_ = 0; _tmp72_ < result_length1; _tmp72_++) {
		g_variant_builder_add_value (&_tmp71_, g_variant_new_int32 (*_tmp70_));
		_tmp70_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp71_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_xdg_dir_tracker_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetDirs") == 0) {
		_dbus_budgie_xdg_dir_tracker_get_dirs (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_xdg_dir_tracker_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_xdg_dir_tracker_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_budgie_xdg_dir_tracker_xdg_dirs_exist (GObject* _sender,
                                             GUserDirectory* dirs,
                                             gint dirs_length1,
                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GUserDirectory* _tmp73_;
	GVariantBuilder _tmp74_;
	gint _tmp75_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp73_ = dirs;
	g_variant_builder_init (&_tmp74_, G_VARIANT_TYPE ("ai"));
	for (_tmp75_ = 0; _tmp75_ < dirs_length1; _tmp75_++) {
		g_variant_builder_add_value (&_tmp74_, g_variant_new_int32 (*_tmp73_));
		_tmp73_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp74_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.buddiesofbudgie.XDGDirTracker", "XdgDirsExist", _arguments, NULL);
}

guint
budgie_xdg_dir_tracker_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_xdg_dir_tracker_dbus_interface_info), &_budgie_xdg_dir_tracker_dbus_interface_vtable, data, _budgie_xdg_dir_tracker_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "xdg-dirs-exist", (GCallback) _dbus_budgie_xdg_dir_tracker_xdg_dirs_exist, data);
	return result;
}

static void
_budgie_xdg_dir_tracker_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_xdg_dir_tracker_xdg_dirs_exist, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

