/* IconButton.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from IconButton.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "icontasklistapplet.h"
#include "budgie-private.h"
#include "plugin.h"
#include <glib.h>
#include "budgie-windowing.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <libxfce4windowing/libxfce4windowing.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>

#define ICON_BUTTON_DEFAULT_OPACITY 0.1
#define ICON_BUTTON_INDICATOR_PADDING 2
#define ICON_BUTTON_INDICATOR_SIZE 2
#define ICON_BUTTON_INDICATOR_SPACING 1
#define ICON_BUTTON_INACTIVE_INDICATOR_SPACING 4
#define ICON_BUTTON_DEFAULT_ICON_SIZE 32
#define ICON_BUTTON_TARGET_ICON_PADDING 18
#define ICON_BUTTON_TARGET_ICON_SCALE (2.0 / 3.0)
#define ICON_BUTTON_FORMULA_SWAP_POINT (ICON_BUTTON_TARGET_ICON_PADDING * 3)
#define ICON_BUTTON_SCROLL_TIMEOUT ((gint64) 300000)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ICON_BUTTON_0_PROPERTY,
	ICON_BUTTON_APP_PROPERTY,
	ICON_BUTTON_POPOVER_MANAGER_PROPERTY,
	ICON_BUTTON_PINNED_PROPERTY,
	ICON_BUTTON_HAS_ACTIVE_WINDOW_PROPERTY,
	ICON_BUTTON_NUM_PROPERTIES
};
static GParamSpec* icon_button_properties[ICON_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IconButtonPrivate {
	BudgieApplication* _app;
	BudgiePopoverManager* _popover_manager;
	gboolean _pinned;
	gboolean _has_active_window;
	BudgieWindowingWindowGroup* window_group;
	Icon* icon;
	IconTasklistButtonPopover* popover;
	GtkAllocation definite_allocation;
	gint target_icon_size;
	gint panel_size;
	BudgiePanelPosition panel_position;
	GtkOrientation orientation;
	gint64 last_scroll_time;
	gboolean urgent;
};

static gint IconButton_private_offset;
static gpointer icon_button_parent_class = NULL;
static GType icon_button_type_id = 0;

static void icon_button_on_size_allocate (IconButton* self,
                                   GtkAllocation* allocation);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static void icon_button_set_window_button_geometry (IconButton* self,
                                             XfwWindow* window,
                                             GError** error);
static gboolean icon_button_real_scroll_event (GtkWidget* base,
                                        GdkEventScroll* event);
static gboolean icon_button_real_draw (GtkWidget* base,
                                cairo_t* ctx);
static void icon_button_real_get_preferred_width (GtkWidget* base,
                                           gint* min,
                                           gint* nat);
static void icon_button_real_get_preferred_height (GtkWidget* base,
                                            gint* min,
                                            gint* nat);
static void icon_button_set_has_active_window (IconButton* self,
                                        gboolean value);
static void __lambda21_ (IconButton* self,
                  XfwWindow* window);
static void ___lambda21__budgie_windowing_window_group_active_window_changed (BudgieWindowingWindowGroup* _sender,
                                                                       XfwWindow* window,
                                                                       gpointer self);
static void __lambda22_ (IconButton* self);
static void ___lambda22__budgie_windowing_window_group_app_icon_changed (BudgieWindowingWindowGroup* _sender,
                                                                  gpointer self);
static void __lambda23_ (IconButton* self,
                  XfwWindow* window);
static void __lambda24_ (IconButton* self,
                  XfwWindowState changed_mask,
                  XfwWindowState new_state);
static void ___lambda24__libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                          XfwWindowState changed_mask,
                                                          XfwWindowState new_state,
                                                          gpointer self);
static void ___lambda23__budgie_windowing_window_group_window_added (BudgieWindowingWindowGroup* _sender,
                                                              XfwWindow* window,
                                                              gpointer self);
static void __lambda25_ (IconButton* self,
                  XfwWindow* window);
static void ___lambda25__budgie_windowing_window_group_window_removed (BudgieWindowingWindowGroup* _sender,
                                                                XfwWindow* window,
                                                                gpointer self);
static GObject * icon_button_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _icon_button____lambda26_ (IconButton* self);
static void __icon_button____lambda26__budgie_application_launch_failed (BudgieApplication* _sender,
                                                                  const gchar* startup_notify_id,
                                                                  gpointer self);
static void _icon_button_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                             GtkAllocation* allocation,
                                                             gpointer self);
static void icon_button_finalize (GObject * obj);
static void _vala_icon_button_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_icon_button_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
icon_button_get_instance_private (IconButton* self)
{
	return G_STRUCT_MEMBER_P (self, IconButton_private_offset);
}

IconButton*
icon_button_construct (GType object_type,
                       BudgiePopoverManager* popover_manager,
                       BudgieApplication* app)
{
	IconButton * self = NULL;
	g_return_val_if_fail (popover_manager != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	self = (IconButton*) g_object_new (object_type, "app", app, "popover-manager", popover_manager, "relief", GTK_RELIEF_NONE, NULL);
	return self;
}

IconButton*
icon_button_new (BudgiePopoverManager* popover_manager,
                 BudgieApplication* app)
{
	return icon_button_construct (TYPE_ICON_BUTTON, popover_manager, app);
}

IconButton*
icon_button_construct_with_group (GType object_type,
                                  BudgieWindowingWindowGroup* window_group,
                                  BudgiePopoverManager* popover_manager,
                                  BudgieApplication* app)
{
	IconButton * self = NULL;
	g_return_val_if_fail (window_group != NULL, NULL);
	g_return_val_if_fail (popover_manager != NULL, NULL);
	self = (IconButton*) g_object_new (object_type, "app", app, "popover-manager", popover_manager, "relief", GTK_RELIEF_NONE, NULL);
	icon_button_set_window_group (self, window_group);
	return self;
}

IconButton*
icon_button_new_with_group (BudgieWindowingWindowGroup* window_group,
                            BudgiePopoverManager* popover_manager,
                            BudgieApplication* app)
{
	return icon_button_construct_with_group (TYPE_ICON_BUTTON, window_group, popover_manager, app);
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static void
icon_button_on_size_allocate (IconButton* self,
                              GtkAllocation* allocation)
{
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_;
	GtkAllocation _tmp4_;
	GtkAllocation _tmp5_;
	gboolean _tmp6_ = FALSE;
	BudgieWindowingWindowGroup* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = self->priv->definite_allocation;
	_tmp1_ = *allocation;
	if (_cairo_rectangle_int_equal (&_tmp0_, &_tmp1_) != TRUE) {
		gint max = 0;
		GtkAllocation _tmp2_;
		GtkAllocation _tmp3_;
		_tmp2_ = *allocation;
		_tmp3_ = *allocation;
		max = (gint) fmin ((gdouble) _tmp2_.width, (gdouble) _tmp3_.height);
		if (max > ICON_BUTTON_FORMULA_SWAP_POINT) {
			self->priv->target_icon_size = max - ICON_BUTTON_TARGET_ICON_PADDING;
		} else {
			self->priv->target_icon_size = (gint) round (ICON_BUTTON_TARGET_ICON_SCALE * max);
		}
		icon_button_update_icon (self);
	}
	_tmp4_ = *allocation;
	self->priv->definite_allocation = _tmp4_;
	_tmp5_ = self->priv->definite_allocation;
	GTK_WIDGET_CLASS (icon_button_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), &_tmp5_);
	_tmp7_ = self->priv->window_group;
	if (_tmp7_ != NULL) {
		BudgieWindowingWindowGroup* _tmp8_;
		_tmp8_ = self->priv->window_group;
		_tmp6_ = budgie_windowing_window_group_has_windows (_tmp8_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		BudgieWindowingWindowGroup* _tmp9_;
		GList* _tmp10_;
		_tmp9_ = self->priv->window_group;
		_tmp10_ = budgie_windowing_window_group_get_windows (_tmp9_);
		{
			GList* win_collection = NULL;
			GList* win_it = NULL;
			win_collection = _tmp10_;
			for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
				XfwWindow* win = NULL;
				win = (XfwWindow*) win_it->data;
				{
					{
						XfwWindow* _tmp11_;
						_tmp11_ = win;
						icon_button_set_window_button_geometry (self, _tmp11_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						XfwWindow* _tmp12_;
						const gchar* _tmp13_;
						GError* _tmp14_;
						const gchar* _tmp15_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp12_ = win;
						_tmp13_ = xfw_window_get_name (_tmp12_);
						_tmp14_ = e;
						_tmp15_ = _tmp14_->message;
						g_warning ("IconButton.vala:124: Unable to set button geometry for window %s: %s", _tmp13_, _tmp15_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						(win_collection == NULL) ? NULL : (win_collection = (g_list_free (win_collection), NULL));
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			(win_collection == NULL) ? NULL : (win_collection = (g_list_free (win_collection), NULL));
		}
	}
}

/**
 * Sets the button geometry for a window.
 *
 * What this means is that when a window is minimized, it will minimize to
 * the icon button's location on the screen.
 *
 * Throws: if the button geometry could not be set
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
icon_button_set_window_button_geometry (IconButton* self,
                                        XfwWindow* window,
                                        GError** error)
{
	gint x = 0;
	gint y = 0;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GtkWidget* _tmp9_;
	GdkWindow* _tmp10_;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	GdkRectangle rect = {0};
	GtkAllocation _tmp13_;
	GtkAllocation _tmp14_;
	GdkRectangle _tmp15_ = {0};
	GtkWidget* _tmp16_;
	GdkWindow* _tmp17_;
	GdkRectangle _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	toplevel = _tmp1_;
	_tmp3_ = toplevel;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GtkWidget* _tmp4_;
		GdkWindow* _tmp5_;
		_tmp4_ = toplevel;
		_tmp5_ = gtk_widget_get_window (_tmp4_);
		_tmp2_ = _tmp5_ == NULL;
	}
	if (_tmp2_) {
		_g_object_unref0 (toplevel);
		return;
	}
	_tmp6_ = toplevel;
	gtk_widget_translate_coordinates ((GtkWidget*) self, _tmp6_, 0, 0, &_tmp7_, &_tmp8_);
	x = _tmp7_;
	y = _tmp8_;
	_tmp9_ = toplevel;
	_tmp10_ = gtk_widget_get_window (_tmp9_);
	gdk_window_get_root_coords (_tmp10_, x, y, &_tmp11_, &_tmp12_);
	x = _tmp11_;
	y = _tmp12_;
	_tmp13_ = self->priv->definite_allocation;
	_tmp14_ = self->priv->definite_allocation;
	_tmp15_.x = x;
	_tmp15_.y = y;
	_tmp15_.width = _tmp13_.width;
	_tmp15_.height = _tmp14_.height;
	rect = _tmp15_;
	_tmp16_ = toplevel;
	_tmp17_ = gtk_widget_get_window (_tmp16_);
	_tmp18_ = rect;
	xfw_window_set_button_geometry (window, _tmp17_, &_tmp18_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (toplevel);
		return;
	}
	_g_object_unref0 (toplevel);
}

static gboolean
icon_button_real_scroll_event (GtkWidget* base,
                               GdkEventScroll* event)
{
	IconButton * self;
	BudgieWindowingWindowGroup* _tmp0_;
	XfwWindow* target_window = NULL;
	BudgieWindowingWindowGroup* _tmp1_ = NULL;
	BudgieWindowingWindowGroup* _tmp2_;
	XfwWindow* _tmp3_ = NULL;
	XfwWindow* active_window = NULL;
	XfwWindow* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (IconButton*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((g_get_monotonic_time () - self->priv->last_scroll_time) < ICON_BUTTON_SCROLL_TIMEOUT) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp0_ = self->priv->window_group;
	if (_tmp0_ == NULL) {
		result = GDK_EVENT_STOP;
		return result;
	}
	target_window = NULL;
	_tmp2_ = self->priv->window_group;
	_tmp1_ = _tmp2_;
	_tmp3_ = NULL;
	if (_tmp1_ != NULL) {
		XfwWindow* _tmp4_;
		_tmp4_ = budgie_windowing_window_group_get_active_window (_tmp1_);
		_tmp3_ = _tmp4_;
	}
	active_window = _tmp3_;
	_tmp5_ = active_window;
	if (_tmp5_ == NULL) {
		BudgieWindowingWindowGroup* _tmp6_;
		XfwWindow* _tmp7_;
		_tmp6_ = self->priv->window_group;
		_tmp7_ = budgie_windowing_window_group_get_last_active_window (_tmp6_);
		active_window = _tmp7_;
	}
	switch (event->direction) {
		case GDK_SCROLL_UP:
		{
			BudgieWindowingWindowGroup* _tmp8_;
			XfwWindow* _tmp9_;
			XfwWindow* _tmp10_;
			_tmp8_ = self->priv->window_group;
			_tmp9_ = active_window;
			_tmp10_ = budgie_windowing_window_group_get_next_window (_tmp8_, _tmp9_, FALSE);
			target_window = _tmp10_;
			{
				XfwWindow* _tmp11_;
				_tmp11_ = target_window;
				xfw_window_activate (_tmp11_, NULL, (guint64) event->time, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				XfwWindow* _tmp12_;
				const gchar* _tmp13_;
				GError* _tmp14_;
				const gchar* _tmp15_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp12_ = target_window;
				_tmp13_ = xfw_window_get_name (_tmp12_);
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				g_warning ("IconButton.vala:184: Error activating and unminimizing window '%s': %s", _tmp13_, _tmp15_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp16_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp16_;
			}
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			XfwWindow* _tmp17_;
			XfwWindow* _tmp18_;
			XfwWindow* _tmp19_;
			_tmp17_ = active_window;
			target_window = _tmp17_;
			_tmp18_ = target_window;
			if (_tmp18_ == NULL) {
				break;
			}
			_tmp19_ = target_window;
			if (xfw_window_is_minimized (_tmp19_)) {
				break;
			}
			{
				XfwWindow* _tmp20_;
				_tmp20_ = target_window;
				xfw_window_set_minimized (_tmp20_, TRUE, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				XfwWindow* _tmp21_;
				const gchar* _tmp22_;
				GError* _tmp23_;
				const gchar* _tmp24_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp21_ = target_window;
				_tmp22_ = xfw_window_get_name (_tmp21_);
				_tmp23_ = e;
				_tmp24_ = _tmp23_->message;
				g_warning ("IconButton.vala:205: Error minimizing window '%s': %s", _tmp22_, _tmp24_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp25_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp25_;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	self->priv->last_scroll_time = g_get_monotonic_time ();
	result = GDK_EVENT_STOP;
	return result;
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static gboolean
icon_button_real_draw (GtkWidget* base,
                       cairo_t* ctx)
{
	IconButton * self;
	gint x = 0;
	GtkAllocation _tmp0_;
	gint y = 0;
	GtkAllocation _tmp1_;
	gint width = 0;
	GtkAllocation _tmp2_;
	gint height = 0;
	GtkAllocation _tmp3_;
	GList* windows = NULL;
	gboolean _tmp4_ = FALSE;
	BudgieWindowingWindowGroup* _tmp5_;
	GList* _tmp9_;
	gint count = 0;
	GList* _tmp10_;
	gint spacing = 0;
	gint _tmp11_ = 0;
	gint previous_x = 0;
	gint previous_y = 0;
	gboolean result;
	self = (IconButton*) base;
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->definite_allocation;
	x = _tmp0_.x;
	_tmp1_ = self->priv->definite_allocation;
	y = _tmp1_.y;
	_tmp2_ = self->priv->definite_allocation;
	width = _tmp2_.width;
	_tmp3_ = self->priv->definite_allocation;
	height = _tmp3_.height;
	_tmp5_ = self->priv->window_group;
	if (_tmp5_ != NULL) {
		BudgieWindowingWindowGroup* _tmp6_;
		_tmp6_ = self->priv->window_group;
		_tmp4_ = budgie_windowing_window_group_has_windows (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		BudgieWindowingWindowGroup* _tmp7_;
		GList* _tmp8_;
		_tmp7_ = self->priv->window_group;
		_tmp8_ = budgie_windowing_window_group_get_windows (_tmp7_);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = _tmp8_;
	} else {
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = NULL;
	}
	_tmp9_ = windows;
	if (vala_g_list_is_empty (_tmp9_)) {
		result = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), ctx);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	if (!gtk_toggle_button_get_active ((GtkToggleButton*) self)) {
		result = icon_button_draw_inactive (self, ctx);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp10_ = windows;
	count = MIN ((gint) g_list_length (_tmp10_), 5);
	spacing = width % count;
	if (spacing == 0) {
		_tmp11_ = ICON_BUTTON_INDICATOR_SPACING;
	} else {
		_tmp11_ = spacing;
	}
	spacing = _tmp11_;
	previous_x = 0;
	previous_y = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				XfwWindow* window = NULL;
				GList* _tmp14_;
				gconstpointer _tmp15_;
				XfwWindow* _tmp16_;
				XfwWindow* _tmp17_;
				gint indicator_x = 0;
				gint indicator_y = 0;
				gint length = 0;
				GdkRGBA color = {0};
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_;
				GdkRGBA _tmp38_;
				GdkRGBA _tmp39_;
				GdkRGBA _tmp40_;
				gint to = 0;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp14_ = windows;
				_tmp15_ = g_list_nth_data (_tmp14_, (guint) i);
				_tmp16_ = _g_object_ref0 ((XfwWindow*) _tmp15_);
				window = _tmp16_;
				_tmp17_ = window;
				if (xfw_window_is_skip_tasklist (_tmp17_)) {
					_g_object_unref0 (window);
					continue;
				}
				indicator_x = 0;
				indicator_y = 0;
				length = 0;
				switch (self->priv->panel_position) {
					case BUDGIE_PANEL_POSITION_LEFT:
					case BUDGIE_PANEL_POSITION_RIGHT:
					{
						length = height / count;
						break;
					}
					default:
					{
						length = width / count;
						break;
					}
				}
				switch (self->priv->panel_position) {
					case BUDGIE_PANEL_POSITION_LEFT:
					{
						indicator_x = x + ICON_BUTTON_INDICATOR_PADDING;
						break;
					}
					case BUDGIE_PANEL_POSITION_RIGHT:
					{
						indicator_x = (x + width) - ICON_BUTTON_INDICATOR_PADDING;
						break;
					}
					case BUDGIE_PANEL_POSITION_TOP:
					case BUDGIE_PANEL_POSITION_BOTTOM:
					{
						if (i == 0) {
							indicator_x = x;
						} else {
							indicator_x = previous_x;
							indicator_x += length;
							previous_x = indicator_x;
							indicator_x += spacing;
						}
						break;
					}
					default:
					{
						break;
					}
				}
				switch (self->priv->panel_position) {
					case BUDGIE_PANEL_POSITION_LEFT:
					case BUDGIE_PANEL_POSITION_RIGHT:
					{
						if (i == 0) {
							indicator_y = y;
						} else {
							indicator_y = previous_y;
							indicator_y += length;
							previous_y = indicator_y;
							indicator_y += spacing;
						}
						break;
					}
					case BUDGIE_PANEL_POSITION_TOP:
					{
						indicator_y = y + ICON_BUTTON_INDICATOR_PADDING;
						break;
					}
					case BUDGIE_PANEL_POSITION_BOTTOM:
					{
						indicator_y = (y + height) - ICON_BUTTON_INDICATOR_PADDING;
						break;
					}
					default:
					{
						break;
					}
				}
				_tmp19_ = self->priv->_has_active_window;
				if (_tmp19_) {
					BudgieWindowingWindowGroup* _tmp20_ = NULL;
					BudgieWindowingWindowGroup* _tmp21_;
					XfwWindow* _tmp22_ = NULL;
					XfwWindow* _tmp24_;
					_tmp21_ = self->priv->window_group;
					_tmp20_ = _tmp21_;
					_tmp22_ = NULL;
					if (_tmp20_ != NULL) {
						XfwWindow* _tmp23_;
						_tmp23_ = budgie_windowing_window_group_get_active_window (_tmp20_);
						_tmp22_ = _tmp23_;
					}
					_tmp24_ = window;
					_tmp18_ = _tmp24_ == _tmp22_;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					GtkStyleContext* _tmp25_;
					GdkRGBA _tmp26_ = {0};
					gboolean _tmp27_;
					_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) self);
					_tmp27_ = gtk_style_context_lookup_color (_tmp25_, "budgie_tasklist_indicator_color_active_window", &_tmp26_);
					color = _tmp26_;
					if (!_tmp27_) {
						gdk_rgba_parse (&color, "#5294E2");
					}
				} else {
					gboolean _tmp28_;
					_tmp28_ = self->priv->_has_active_window;
					if (_tmp28_) {
						GtkStyleContext* _tmp29_;
						GdkRGBA _tmp30_ = {0};
						gboolean _tmp31_;
						_tmp29_ = gtk_widget_get_style_context ((GtkWidget*) self);
						_tmp31_ = gtk_style_context_lookup_color (_tmp29_, "budgie_tasklist_indicator_color_active", &_tmp30_);
						color = _tmp30_;
						if (!_tmp31_) {
							gdk_rgba_parse (&color, "#6BBFFF");
						}
					} else {
						GtkStyleContext* _tmp32_;
						GdkRGBA _tmp33_ = {0};
						gboolean _tmp34_;
						_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) self);
						_tmp34_ = gtk_style_context_lookup_color (_tmp32_, "budgie_tasklist_indicator_color", &_tmp33_);
						color = _tmp33_;
						if (!_tmp34_) {
							gdk_rgba_parse (&color, "#3C6DA6");
						}
					}
				}
				if (self->priv->urgent) {
					GtkStyleContext* _tmp35_;
					GdkRGBA _tmp36_ = {0};
					gboolean _tmp37_;
					_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) self);
					_tmp37_ = gtk_style_context_lookup_color (_tmp35_, "budgie_tasklist_indicator_color_attention", &_tmp36_);
					color = _tmp36_;
					if (!_tmp37_) {
						gdk_rgba_parse (&color, "#D84E4E");
					}
				}
				_tmp38_ = color;
				_tmp39_ = color;
				_tmp40_ = color;
				cairo_set_source_rgba (ctx, _tmp38_.red, _tmp39_.green, _tmp40_.blue, (gdouble) 1);
				cairo_set_line_width (ctx, (gdouble) (ICON_BUTTON_INDICATOR_SIZE + 1));
				cairo_move_to (ctx, (gdouble) indicator_x, (gdouble) indicator_y);
				to = 0;
				switch (self->priv->panel_position) {
					case BUDGIE_PANEL_POSITION_LEFT:
					case BUDGIE_PANEL_POSITION_RIGHT:
					{
						if (i == (count - 1)) {
							to = y + height;
						} else {
							to = previous_y;
							to += length;
						}
						cairo_line_to (ctx, (gdouble) indicator_x, (gdouble) to);
						break;
					}
					default:
					{
						if (i == (count - 1)) {
							to = x + width;
						} else {
							to = previous_x;
							to += length;
						}
						cairo_line_to (ctx, (gdouble) to, (gdouble) indicator_y);
						break;
					}
				}
				cairo_stroke (ctx);
				_g_object_unref0 (window);
			}
		}
	}
	result = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), ctx);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

gboolean
icon_button_draw_inactive (IconButton* self,
                           cairo_t* ctx)
{
	gint x = 0;
	GtkAllocation _tmp0_;
	gint y = 0;
	GtkAllocation _tmp1_;
	gint width = 0;
	GtkAllocation _tmp2_;
	gint height = 0;
	GtkAllocation _tmp3_;
	GList* windows = NULL;
	gboolean _tmp4_ = FALSE;
	BudgieWindowingWindowGroup* _tmp5_;
	GList* _tmp9_;
	gint count = 0;
	GList* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->definite_allocation;
	x = _tmp0_.x;
	_tmp1_ = self->priv->definite_allocation;
	y = _tmp1_.y;
	_tmp2_ = self->priv->definite_allocation;
	width = _tmp2_.width;
	_tmp3_ = self->priv->definite_allocation;
	height = _tmp3_.height;
	_tmp5_ = self->priv->window_group;
	if (_tmp5_ != NULL) {
		BudgieWindowingWindowGroup* _tmp6_;
		_tmp6_ = self->priv->window_group;
		_tmp4_ = budgie_windowing_window_group_has_windows (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		BudgieWindowingWindowGroup* _tmp7_;
		GList* _tmp8_;
		_tmp7_ = self->priv->window_group;
		_tmp8_ = budgie_windowing_window_group_get_windows (_tmp7_);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = _tmp8_;
	} else {
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = NULL;
	}
	_tmp9_ = windows;
	if (vala_g_list_is_empty (_tmp9_)) {
		result = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), ctx);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp10_ = windows;
	count = MIN ((gint) g_list_length (_tmp10_), 5);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				XfwWindow* window = NULL;
				GList* _tmp13_;
				gconstpointer _tmp14_;
				XfwWindow* _tmp15_;
				XfwWindow* _tmp16_;
				gint indicator_x = 0;
				gint indicator_y = 0;
				GdkRGBA color = {0};
				GdkRGBA _tmp23_;
				GdkRGBA _tmp24_;
				GdkRGBA _tmp25_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp13_ = windows;
				_tmp14_ = g_list_nth_data (_tmp13_, (guint) i);
				_tmp15_ = _g_object_ref0 ((XfwWindow*) _tmp14_);
				window = _tmp15_;
				_tmp16_ = window;
				if (xfw_window_is_skip_tasklist (_tmp16_)) {
					_g_object_unref0 (window);
					continue;
				}
				indicator_x = 0;
				indicator_y = 0;
				switch (self->priv->panel_position) {
					case BUDGIE_PANEL_POSITION_TOP:
					case BUDGIE_PANEL_POSITION_BOTTOM:
					{
						indicator_x = x + (width / 2);
						indicator_x -= ((count * (ICON_BUTTON_INDICATOR_SIZE + ICON_BUTTON_INACTIVE_INDICATOR_SPACING)) / 2) - ICON_BUTTON_INACTIVE_INDICATOR_SPACING;
						indicator_x += ((ICON_BUTTON_INDICATOR_SIZE + ICON_BUTTON_INACTIVE_INDICATOR_SPACING) * i) - 1;
						break;
					}
					case BUDGIE_PANEL_POSITION_LEFT:
					{
						indicator_x = (y + (ICON_BUTTON_INDICATOR_SIZE / 2)) - ICON_BUTTON_INDICATOR_PADDING;
						break;
					}
					case BUDGIE_PANEL_POSITION_RIGHT:
					{
						indicator_x = ((y + width) - (ICON_BUTTON_INDICATOR_SIZE / 2)) + ICON_BUTTON_INDICATOR_PADDING;
						break;
					}
					default:
					{
						break;
					}
				}
				switch (self->priv->panel_position) {
					case BUDGIE_PANEL_POSITION_TOP:
					{
						indicator_y = (y + (ICON_BUTTON_INDICATOR_SIZE / 2)) + ICON_BUTTON_INDICATOR_PADDING;
						break;
					}
					case BUDGIE_PANEL_POSITION_BOTTOM:
					{
						indicator_y = ((y + height) - (ICON_BUTTON_INDICATOR_SIZE / 2)) - ICON_BUTTON_INDICATOR_PADDING;
						break;
					}
					case BUDGIE_PANEL_POSITION_LEFT:
					{
						indicator_y = x + (height / 2);
						indicator_y -= ((count * (ICON_BUTTON_INDICATOR_SIZE + ICON_BUTTON_INACTIVE_INDICATOR_SPACING)) / 2) - (ICON_BUTTON_INACTIVE_INDICATOR_SPACING * 2);
						indicator_y += (ICON_BUTTON_INDICATOR_SIZE + ICON_BUTTON_INACTIVE_INDICATOR_SPACING) * i;
						break;
					}
					case BUDGIE_PANEL_POSITION_RIGHT:
					{
						indicator_y = x + (height / 2);
						indicator_y -= ((count * (ICON_BUTTON_INDICATOR_SIZE + ICON_BUTTON_INACTIVE_INDICATOR_SPACING)) / 2) - ICON_BUTTON_INACTIVE_INDICATOR_SPACING;
						indicator_y += (ICON_BUTTON_INDICATOR_SIZE + ICON_BUTTON_INACTIVE_INDICATOR_SPACING) * i;
						break;
					}
					default:
					{
						break;
					}
				}
				if (self->priv->urgent) {
					GtkStyleContext* _tmp17_;
					GdkRGBA _tmp18_ = {0};
					gboolean _tmp19_;
					_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) self);
					_tmp19_ = gtk_style_context_lookup_color (_tmp17_, "budgie_tasklist_indicator_color_attention", &_tmp18_);
					color = _tmp18_;
					if (!_tmp19_) {
						gdk_rgba_parse (&color, "#D84E4E");
					}
				} else {
					GtkStyleContext* _tmp20_;
					GdkRGBA _tmp21_ = {0};
					gboolean _tmp22_;
					_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) self);
					_tmp22_ = gtk_style_context_lookup_color (_tmp20_, "budgie_tasklist_indicator_color", &_tmp21_);
					color = _tmp21_;
					if (!_tmp22_) {
						gdk_rgba_parse (&color, "#3C6DA6");
					}
				}
				_tmp23_ = color;
				_tmp24_ = color;
				_tmp25_ = color;
				cairo_set_source_rgba (ctx, _tmp23_.red, _tmp24_.green, _tmp25_.blue, (gdouble) 1);
				cairo_arc (ctx, (gdouble) indicator_x, (gdouble) indicator_y, (gdouble) ICON_BUTTON_INDICATOR_SIZE, (gdouble) 0, G_PI * 2);
				cairo_fill (ctx);
				_g_object_unref0 (window);
			}
		}
	}
	result = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), ctx);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

static void
icon_button_real_get_preferred_width (GtkWidget* base,
                                      gint* min,
                                      gint* nat)
{
	IconButton * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (IconButton*) base;
	if (self->priv->orientation == GTK_ORIENTATION_HORIZONTAL) {
		_vala_nat = self->priv->panel_size;
		_vala_min = _vala_nat;
	} else {
		gint m = 0;
		gint n = 0;
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GTK_WIDGET_CLASS (icon_button_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), &_tmp0_, &_tmp1_);
		m = _tmp0_;
		n = _tmp1_;
		_vala_min = m;
		_vala_nat = n;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
icon_button_real_get_preferred_height (GtkWidget* base,
                                       gint* min,
                                       gint* nat)
{
	IconButton * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (IconButton*) base;
	if (self->priv->orientation == GTK_ORIENTATION_VERTICAL) {
		_vala_nat = self->priv->panel_size;
		_vala_min = _vala_nat;
	} else {
		gint m = 0;
		gint n = 0;
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GTK_WIDGET_CLASS (icon_button_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), &_tmp0_, &_tmp1_);
		m = _tmp0_;
		n = _tmp1_;
		_vala_min = m;
		_vala_nat = n;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

gboolean
icon_button_has_window (IconButton* self,
                        XfwWindow* window)
{
	gboolean _tmp0_ = FALSE;
	BudgieWindowingWindowGroup* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	_tmp1_ = self->priv->window_group;
	if (_tmp1_ != NULL) {
		BudgieWindowingWindowGroup* _tmp2_;
		_tmp2_ = self->priv->window_group;
		_tmp0_ = budgie_windowing_window_group_has_window (_tmp2_, window);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Icon*
icon_button_get_icon (IconButton* self)
{
	Icon* _tmp0_;
	Icon* _tmp1_;
	Icon* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
icon_button_launch (IconButton* self)
{
	BudgieApplication* _tmp0_;
	gboolean _tmp1_;
	Icon* _tmp2_;
	Icon* _tmp3_;
	Icon* _tmp4_;
	BudgieApplication* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_app;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_pinned;
	if (!_tmp1_) {
		g_warning ("IconButton.vala:516: IconButton was clicked with no active windows, bu" \
"t is not pinned!");
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->icon;
	icon_animate_launch (_tmp2_, self->priv->panel_position);
	_tmp3_ = self->priv->icon;
	_tmp3_->waiting = TRUE;
	_tmp4_ = self->priv->icon;
	icon_animate_wait (_tmp4_);
	_tmp5_ = self->priv->_app;
	result = budgie_application_launch (_tmp5_);
	return result;
}

void
icon_button_set_active_window (IconButton* self,
                               gboolean active)
{
	g_return_if_fail (self != NULL);
	icon_button_set_has_active_window (self, active);
}

void
icon_button_set_icon_size (IconButton* self,
                           gint size)
{
	g_return_if_fail (self != NULL);
	self->priv->target_icon_size = size;
}

void
icon_button_set_orientation (IconButton* self,
                             GtkOrientation orientation)
{
	g_return_if_fail (self != NULL);
	self->priv->orientation = orientation;
}

void
icon_button_set_panel_size (IconButton* self,
                            gint size)
{
	g_return_if_fail (self != NULL);
	self->priv->panel_size = size;
}

void
icon_button_set_panel_position (IconButton* self,
                                BudgiePanelPosition position)
{
	g_return_if_fail (self != NULL);
	self->priv->panel_position = position;
}

BudgieWindowingWindowGroup*
icon_button_get_window_group (IconButton* self)
{
	BudgieWindowingWindowGroup* _tmp0_;
	BudgieWindowingWindowGroup* _tmp1_;
	BudgieWindowingWindowGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->window_group;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
icon_button_set_urgent (IconButton* self,
                        gboolean urgent)
{
	g_return_if_fail (self != NULL);
	self->priv->urgent = urgent;
	if (urgent) {
		GtkStyleContext* _tmp0_;
		Icon* _tmp1_;
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp0_, "needs-attention");
		_tmp1_ = self->priv->icon;
		icon_animate_attention (_tmp1_, &self->priv->panel_position);
	} else {
		GtkStyleContext* _tmp2_;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp2_, "needs-attention");
	}
	icon_button_update (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
__lambda21_ (IconButton* self,
             XfwWindow* window)
{
	if (window != NULL) {
		const gchar* _tmp0_;
		_tmp0_ = xfw_window_get_name (window);
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp0_);
	}
}

static void
___lambda21__budgie_windowing_window_group_active_window_changed (BudgieWindowingWindowGroup* _sender,
                                                                  XfwWindow* window,
                                                                  gpointer self)
{
	__lambda21_ ((IconButton*) self, window);
}

static void
__lambda22_ (IconButton* self)
{
	icon_button_update_icon (self);
}

static void
___lambda22__budgie_windowing_window_group_app_icon_changed (BudgieWindowingWindowGroup* _sender,
                                                             gpointer self)
{
	__lambda22_ ((IconButton*) self);
}

static void
__lambda24_ (IconButton* self,
             XfwWindowState changed_mask,
             XfwWindowState new_state)
{
	if (!((changed_mask & XFW_WINDOW_STATE_URGENT) == XFW_WINDOW_STATE_URGENT)) {
		return;
	}
	self->priv->urgent = (new_state & XFW_WINDOW_STATE_URGENT) != 0;
	icon_button_set_urgent (self, self->priv->urgent);
}

static void
___lambda24__libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                     XfwWindowState changed_mask,
                                                     XfwWindowState new_state,
                                                     gpointer self)
{
	__lambda24_ ((IconButton*) self, changed_mask, new_state);
}

static void
__lambda23_ (IconButton* self,
             XfwWindow* window)
{
	IconTasklistButtonPopover* _tmp0_;
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->popover;
	icon_tasklist_button_popover_add_window (_tmp0_, window);
	g_signal_connect_object (window, "state-changed", (GCallback) ___lambda24__libxfce4windowing_window_state_changed, self, 0);
	icon_button_update (self);
}

static void
___lambda23__budgie_windowing_window_group_window_added (BudgieWindowingWindowGroup* _sender,
                                                         XfwWindow* window,
                                                         gpointer self)
{
	__lambda23_ ((IconButton*) self, window);
}

static void
__lambda25_ (IconButton* self,
             XfwWindow* window)
{
	IconTasklistButtonPopover* _tmp0_;
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->popover;
	icon_tasklist_button_popover_remove_window (_tmp0_, window);
	icon_button_update (self);
}

static void
___lambda25__budgie_windowing_window_group_window_removed (BudgieWindowingWindowGroup* _sender,
                                                           XfwWindow* window,
                                                           gpointer self)
{
	__lambda25_ ((IconButton*) self, window);
}

void
icon_button_set_window_group (IconButton* self,
                              BudgieWindowingWindowGroup* window_group)
{
	BudgieWindowingWindowGroup* _tmp0_;
	IconTasklistButtonPopover* _tmp1_;
	GList* _tmp2_;
	BudgieWindowingWindowGroup* _tmp5_ = NULL;
	XfwWindow* _tmp6_ = NULL;
	XfwWindow* window = NULL;
	XfwWindow* _tmp8_;
	XfwWindow* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (window_group);
	_g_object_unref0 (self->priv->window_group);
	self->priv->window_group = _tmp0_;
	_tmp1_ = self->priv->popover;
	icon_tasklist_button_popover_set_group (_tmp1_, window_group);
	if (window_group == NULL) {
		return;
	}
	_tmp2_ = budgie_windowing_window_group_get_windows (window_group);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			XfwWindow* window = NULL;
			window = (XfwWindow*) window_it->data;
			{
				IconTasklistButtonPopover* _tmp3_;
				XfwWindow* _tmp4_;
				_tmp3_ = self->priv->popover;
				_tmp4_ = window;
				icon_tasklist_button_popover_add_window (_tmp3_, _tmp4_);
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	_tmp5_ = window_group;
	_tmp6_ = NULL;
	if (_tmp5_ != NULL) {
		XfwWindow* _tmp7_;
		_tmp7_ = budgie_windowing_window_group_get_active_window (_tmp5_);
		_tmp6_ = _tmp7_;
	}
	_tmp8_ = _g_object_ref0 (_tmp6_);
	window = _tmp8_;
	_tmp9_ = window;
	if (_tmp9_ != NULL) {
		XfwWindow* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = window;
		_tmp11_ = xfw_window_get_name (_tmp10_);
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp11_);
	} else {
		XfwWindow* _tmp12_;
		_tmp12_ = budgie_windowing_window_group_get_last_active_window (window_group);
		if (_tmp12_ != NULL) {
			XfwWindow* _tmp13_;
			XfwWindow* _tmp14_;
			XfwWindow* _tmp15_;
			const gchar* _tmp16_;
			_tmp13_ = budgie_windowing_window_group_get_last_active_window (window_group);
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_g_object_unref0 (window);
			window = _tmp14_;
			_tmp15_ = window;
			_tmp16_ = xfw_window_get_name (_tmp15_);
			gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp16_);
		}
	}
	g_signal_connect_object (window_group, "active-window-changed", (GCallback) ___lambda21__budgie_windowing_window_group_active_window_changed, self, 0);
	g_signal_connect_object (window_group, "app-icon-changed", (GCallback) ___lambda22__budgie_windowing_window_group_app_icon_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object (window_group, "window-added", (GCallback) ___lambda23__budgie_windowing_window_group_window_added, self, 0);
	g_signal_connect_object (window_group, "window-removed", (GCallback) ___lambda25__budgie_windowing_window_group_window_removed, self, 0);
	_g_object_unref0 (window);
}

void
icon_button_update (IconButton* self)
{
	gboolean _tmp0_ = FALSE;
	BudgieWindowingWindowGroup* _tmp1_;
	gboolean _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->window_group;
	if (_tmp1_ != NULL) {
		BudgieWindowingWindowGroup* _tmp2_;
		_tmp2_ = self->priv->window_group;
		_tmp0_ = budgie_windowing_window_group_has_windows (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkStyleContext* _tmp3_;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp3_, "running");
	} else {
		gboolean _tmp4_ = FALSE;
		BudgieWindowingWindowGroup* _tmp5_;
		_tmp5_ = self->priv->window_group;
		if (_tmp5_ != NULL) {
			BudgieWindowingWindowGroup* _tmp6_;
			_tmp6_ = self->priv->window_group;
			_tmp4_ = !budgie_windowing_window_group_has_windows (_tmp6_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GtkStyleContext* _tmp7_;
			gboolean _tmp8_;
			BudgieWindowingWindowGroup* _tmp9_ = NULL;
			BudgieWindowingWindowGroup* _tmp10_;
			XfwWindow* _tmp11_ = NULL;
			XfwWindow* _tmp13_ = NULL;
			XfwWindow* active_window = NULL;
			XfwWindow* _tmp18_;
			BudgieApplication* _tmp19_ = NULL;
			BudgieApplication* _tmp20_;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) self);
			gtk_style_context_remove_class (_tmp7_, "running");
			_tmp8_ = self->priv->_pinned;
			if (!_tmp8_) {
				return;
			}
			_tmp10_ = self->priv->window_group;
			_tmp9_ = _tmp10_;
			_tmp11_ = NULL;
			if (_tmp9_ != NULL) {
				XfwWindow* _tmp12_;
				_tmp12_ = budgie_windowing_window_group_get_active_window (_tmp9_);
				_tmp11_ = _tmp12_;
			}
			_tmp13_ = _tmp11_;
			if (_tmp13_ == NULL) {
				BudgieWindowingWindowGroup* _tmp14_ = NULL;
				BudgieWindowingWindowGroup* _tmp15_;
				XfwWindow* _tmp16_ = NULL;
				_tmp15_ = self->priv->window_group;
				_tmp14_ = _tmp15_;
				_tmp16_ = NULL;
				if (_tmp14_ != NULL) {
					XfwWindow* _tmp17_;
					_tmp17_ = budgie_windowing_window_group_get_last_active_window (_tmp14_);
					_tmp16_ = _tmp17_;
				}
				_tmp13_ = _tmp16_;
			}
			_tmp18_ = _g_object_ref0 (_tmp13_);
			active_window = _tmp18_;
			_tmp20_ = self->priv->_app;
			_tmp19_ = _tmp20_;
			_tmp21_ = NULL;
			if (_tmp19_ != NULL) {
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp22_ = budgie_application_get_name (_tmp19_);
				_tmp23_ = _tmp22_;
				_tmp21_ = _tmp23_;
			}
			_tmp24_ = _tmp21_;
			if (_tmp24_ == NULL) {
				XfwWindow* _tmp25_ = NULL;
				XfwWindow* _tmp26_;
				const gchar* _tmp27_ = NULL;
				const gchar* _tmp29_ = NULL;
				_tmp26_ = active_window;
				_tmp25_ = _tmp26_;
				_tmp27_ = NULL;
				if (_tmp25_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = xfw_window_get_name (_tmp25_);
					_tmp27_ = _tmp28_;
				}
				_tmp29_ = _tmp27_;
				if (_tmp29_ == NULL) {
					_tmp29_ = "";
				}
				_tmp24_ = _tmp29_;
			}
			gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp24_);
			_g_object_unref0 (self->priv->window_group);
			self->priv->window_group = NULL;
			_g_object_unref0 (active_window);
		}
	}
	_tmp30_ = self->priv->_has_active_window;
	gtk_toggle_button_set_active ((GtkToggleButton*) self, _tmp30_);
	icon_button_update_icon (self);
	gtk_widget_queue_resize ((GtkWidget*) self);
}

void
icon_button_update_icon (IconButton* self)
{
	gboolean _tmp0_ = FALSE;
	BudgieWindowingWindowGroup* _tmp1_;
	BudgieWindowingWindowGroup* _tmp4_;
	gint _tmp24_ = 0;
	Icon* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->window_group;
	if (_tmp1_ != NULL) {
		BudgieWindowingWindowGroup* _tmp2_;
		_tmp2_ = self->priv->window_group;
		_tmp0_ = budgie_windowing_window_group_has_windows (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Icon* _tmp3_;
		_tmp3_ = self->priv->icon;
		_tmp3_->waiting = FALSE;
	}
	_tmp4_ = self->priv->window_group;
	if (_tmp4_ != NULL) {
		gint _tmp5_ = 0;
		gint size = 0;
		GdkPixbuf* pixbuf = NULL;
		BudgieWindowingWindowGroup* _tmp6_;
		XfwApplication* _tmp7_;
		XfwApplication* _tmp8_;
		GdkPixbuf* _tmp9_;
		Icon* _tmp10_;
		GdkPixbuf* _tmp11_;
		if (self->priv->target_icon_size == 0) {
			_tmp5_ = ICON_BUTTON_DEFAULT_ICON_SIZE;
		} else {
			_tmp5_ = self->priv->target_icon_size;
		}
		size = _tmp5_;
		_tmp6_ = self->priv->window_group;
		_tmp7_ = budgie_windowing_window_group_get_application (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = xfw_application_get_icon (_tmp8_, size, gtk_widget_get_scale_factor ((GtkWidget*) self));
		pixbuf = _tmp9_;
		_tmp10_ = self->priv->icon;
		_tmp11_ = pixbuf;
		gtk_image_set_from_pixbuf ((GtkImage*) _tmp10_, _tmp11_);
	} else {
		BudgieApplication* _tmp12_ = NULL;
		BudgieApplication* _tmp13_;
		GIcon* _tmp14_ = NULL;
		_tmp13_ = self->priv->_app;
		_tmp12_ = _tmp13_;
		_tmp14_ = NULL;
		if (_tmp12_ != NULL) {
			GIcon* _tmp15_;
			GIcon* _tmp16_;
			_tmp15_ = budgie_application_get_icon (_tmp12_);
			_tmp16_ = _tmp15_;
			_tmp14_ = _tmp16_;
		}
		if (_tmp14_ != NULL) {
			BudgieApplication* _tmp17_ = NULL;
			BudgieApplication* _tmp18_;
			GIcon* _tmp19_ = NULL;
			Icon* _tmp22_;
			_tmp18_ = self->priv->_app;
			_tmp17_ = _tmp18_;
			_tmp19_ = NULL;
			if (_tmp17_ != NULL) {
				GIcon* _tmp20_;
				GIcon* _tmp21_;
				_tmp20_ = budgie_application_get_icon (_tmp17_);
				_tmp21_ = _tmp20_;
				_tmp19_ = _tmp21_;
			}
			_tmp22_ = self->priv->icon;
			gtk_image_set_from_gicon ((GtkImage*) _tmp22_, _tmp19_, (GtkIconSize) GTK_ICON_SIZE_INVALID);
		} else {
			Icon* _tmp23_;
			_tmp23_ = self->priv->icon;
			gtk_image_set_from_icon_name ((GtkImage*) _tmp23_, "image-missing", (GtkIconSize) GTK_ICON_SIZE_INVALID);
		}
	}
	if (self->priv->target_icon_size > 0) {
		_tmp24_ = self->priv->target_icon_size;
	} else {
		_tmp24_ = ICON_BUTTON_DEFAULT_ICON_SIZE;
	}
	_tmp25_ = self->priv->icon;
	gtk_image_set_pixel_size ((GtkImage*) _tmp25_, _tmp24_);
}

BudgieApplication*
icon_button_get_app (IconButton* self)
{
	BudgieApplication* result;
	BudgieApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app;
	result = _tmp0_;
	return result;
}

static void
icon_button_set_app (IconButton* self,
                     BudgieApplication* value)
{
	BudgieApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_button_get_app (self);
	if (old_value != value) {
		BudgieApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app);
		self->priv->_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, icon_button_properties[ICON_BUTTON_APP_PROPERTY]);
	}
}

BudgiePopoverManager*
icon_button_get_popover_manager (IconButton* self)
{
	BudgiePopoverManager* result;
	BudgiePopoverManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_popover_manager;
	result = _tmp0_;
	return result;
}

static void
icon_button_set_popover_manager (IconButton* self,
                                 BudgiePopoverManager* value)
{
	BudgiePopoverManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_button_get_popover_manager (self);
	if (old_value != value) {
		self->priv->_popover_manager = value;
		g_object_notify_by_pspec ((GObject *) self, icon_button_properties[ICON_BUTTON_POPOVER_MANAGER_PROPERTY]);
	}
}

gboolean
icon_button_get_pinned (IconButton* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pinned;
	return result;
}

void
icon_button_set_pinned (IconButton* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_button_get_pinned (self);
	if (old_value != value) {
		self->priv->_pinned = value;
		g_object_notify_by_pspec ((GObject *) self, icon_button_properties[ICON_BUTTON_PINNED_PROPERTY]);
	}
}

gboolean
icon_button_get_has_active_window (IconButton* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_active_window;
	return result;
}

static void
icon_button_set_has_active_window (IconButton* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = icon_button_get_has_active_window (self);
	if (old_value != value) {
		self->priv->_has_active_window = value;
		g_object_notify_by_pspec ((GObject *) self, icon_button_properties[ICON_BUTTON_HAS_ACTIVE_WINDOW_PROPERTY]);
	}
}

static void
_icon_button____lambda26_ (IconButton* self)
{
	Icon* _tmp0_;
	_tmp0_ = self->priv->icon;
	_tmp0_->waiting = FALSE;
}

static void
__icon_button____lambda26__budgie_application_launch_failed (BudgieApplication* _sender,
                                                             const gchar* startup_notify_id,
                                                             gpointer self)
{
	_icon_button____lambda26_ ((IconButton*) self);
}

static void
_icon_button_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                        GtkAllocation* allocation,
                                                        gpointer self)
{
	icon_button_on_size_allocate ((IconButton*) self, allocation);
}

static GObject *
icon_button_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	IconButton * self;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	Icon* _tmp3_;
	Icon* _tmp4_;
	GtkStyleContext* _tmp5_;
	BudgieApplication* _tmp6_;
	BudgieWindowingWindowGroup* _tmp7_;
	gboolean _tmp8_;
	IconTasklistButtonPopover* _tmp9_ = NULL;
	IconTasklistButtonPopover* _tmp10_;
	BudgieApplication* _tmp11_;
	BudgiePopoverManager* _tmp29_;
	IconTasklistButtonPopover* _tmp30_;
	Icon* _tmp31_;
	parent_class = G_OBJECT_CLASS (icon_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_BUTTON, IconButton);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp0_, GTK_STYLE_CLASS_BUTTON);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp1_, "toggle");
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "launcher");
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_SCROLL_MASK);
	self->priv->definite_allocation.width = 0;
	self->priv->definite_allocation.height = 0;
	_tmp3_ = icon_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp3_;
	_tmp4_ = self->priv->icon;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "icon");
	_tmp6_ = self->priv->_app;
	_tmp7_ = self->priv->window_group;
	_tmp8_ = self->priv->_pinned;
	_tmp9_ = icon_tasklist_button_popover_new (self, _tmp6_, _tmp7_);
	icon_tasklist_button_popover_set_pinned (_tmp9_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp9_;
	_tmp10_ = self->priv->popover;
	g_object_bind_property_with_closures ((GObject*) _tmp10_, "pinned", (GObject*) self, "pinned", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = self->priv->_app;
	if (_tmp11_ != NULL) {
		BudgieApplication* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		BudgieApplication* _tmp15_;
		_tmp12_ = self->priv->_app;
		_tmp13_ = budgie_application_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp14_);
		_tmp15_ = self->priv->_app;
		g_signal_connect_object (_tmp15_, "launch-failed", (GCallback) __icon_button____lambda26__budgie_application_launch_failed, self, G_CONNECT_AFTER);
	} else {
		BudgieWindowingWindowGroup* _tmp16_ = NULL;
		BudgieWindowingWindowGroup* _tmp17_;
		XfwWindow* _tmp18_ = NULL;
		XfwWindow* _tmp20_ = NULL;
		XfwWindow* window = NULL;
		XfwWindow* _tmp25_;
		XfwWindow* _tmp26_;
		_tmp17_ = self->priv->window_group;
		_tmp16_ = _tmp17_;
		_tmp18_ = NULL;
		if (_tmp16_ != NULL) {
			XfwWindow* _tmp19_;
			_tmp19_ = budgie_windowing_window_group_get_active_window (_tmp16_);
			_tmp18_ = _tmp19_;
		}
		_tmp20_ = _tmp18_;
		if (_tmp20_ == NULL) {
			BudgieWindowingWindowGroup* _tmp21_ = NULL;
			BudgieWindowingWindowGroup* _tmp22_;
			XfwWindow* _tmp23_ = NULL;
			_tmp22_ = self->priv->window_group;
			_tmp21_ = _tmp22_;
			_tmp23_ = NULL;
			if (_tmp21_ != NULL) {
				XfwWindow* _tmp24_;
				_tmp24_ = budgie_windowing_window_group_get_last_active_window (_tmp21_);
				_tmp23_ = _tmp24_;
			}
			_tmp20_ = _tmp23_;
		}
		_tmp25_ = _g_object_ref0 (_tmp20_);
		window = _tmp25_;
		_tmp26_ = window;
		if (_tmp26_ != NULL) {
			XfwWindow* _tmp27_;
			const gchar* _tmp28_;
			_tmp27_ = window;
			_tmp28_ = xfw_window_get_name (_tmp27_);
			gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp28_);
		}
		_g_object_unref0 (window);
	}
	_tmp29_ = self->priv->_popover_manager;
	_tmp30_ = self->priv->popover;
	budgie_popover_manager_register_popover (_tmp29_, (GtkWidget*) self, (GtkPopover*) _tmp30_);
	_tmp31_ = self->priv->icon;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp31_);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _icon_button_on_size_allocate_gtk_widget_size_allocate, self, 0);
	return obj;
}

static void
icon_button_class_init (IconButtonClass * klass,
                        gpointer klass_data)
{
	icon_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &IconButton_private_offset);
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) icon_button_real_scroll_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) icon_button_real_draw;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) icon_button_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) icon_button_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_icon_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_icon_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = icon_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = icon_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BUTTON_APP_PROPERTY, icon_button_properties[ICON_BUTTON_APP_PROPERTY] = g_param_spec_object ("app", "app", "app", BUDGIE_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BUTTON_POPOVER_MANAGER_PROPERTY, icon_button_properties[ICON_BUTTON_POPOVER_MANAGER_PROPERTY] = g_param_spec_object ("popover-manager", "popover-manager", "popover-manager", budgie_popover_manager_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BUTTON_PINNED_PROPERTY, icon_button_properties[ICON_BUTTON_PINNED_PROPERTY] = g_param_spec_boolean ("pinned", "pinned", "pinned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ICON_BUTTON_HAS_ACTIVE_WINDOW_PROPERTY, icon_button_properties[ICON_BUTTON_HAS_ACTIVE_WINDOW_PROPERTY] = g_param_spec_boolean ("has-active-window", "has-active-window", "has-active-window", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
icon_button_instance_init (IconButton * self,
                           gpointer klass)
{
	self->priv = icon_button_get_instance_private (self);
	self->priv->_pinned = FALSE;
	self->priv->_has_active_window = FALSE;
	self->priv->window_group = NULL;
	self->priv->target_icon_size = 0;
	self->priv->panel_size = 0;
	self->priv->last_scroll_time = (gint64) 0;
	self->priv->urgent = FALSE;
}

static void
icon_button_finalize (GObject * obj)
{
	IconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_BUTTON, IconButton);
	_g_object_unref0 (self->priv->_app);
	_g_object_unref0 (self->priv->window_group);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->popover);
	G_OBJECT_CLASS (icon_button_parent_class)->finalize (obj);
}

GType
icon_button_get_type (void)
{
	return icon_button_type_id;
}

GType
icon_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (IconButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconButton), 0, (GInstanceInitFunc) icon_button_instance_init, NULL };
	icon_button_type_id = g_type_module_register_type (module, gtk_toggle_button_get_type (), "IconButton", &g_define_type_info, 0);
	IconButton_private_offset = sizeof (IconButtonPrivate);
	return icon_button_type_id;
}

static void
_vala_icon_button_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	IconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_BUTTON, IconButton);
	switch (property_id) {
		case ICON_BUTTON_APP_PROPERTY:
		g_value_set_object (value, icon_button_get_app (self));
		break;
		case ICON_BUTTON_POPOVER_MANAGER_PROPERTY:
		g_value_set_object (value, icon_button_get_popover_manager (self));
		break;
		case ICON_BUTTON_PINNED_PROPERTY:
		g_value_set_boolean (value, icon_button_get_pinned (self));
		break;
		case ICON_BUTTON_HAS_ACTIVE_WINDOW_PROPERTY:
		g_value_set_boolean (value, icon_button_get_has_active_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_icon_button_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	IconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ICON_BUTTON, IconButton);
	switch (property_id) {
		case ICON_BUTTON_APP_PROPERTY:
		icon_button_set_app (self, g_value_get_object (value));
		break;
		case ICON_BUTTON_POPOVER_MANAGER_PROPERTY:
		icon_button_set_popover_manager (self, g_value_get_object (value));
		break;
		case ICON_BUTTON_PINNED_PROPERTY:
		icon_button_set_pinned (self, g_value_get_boolean (value));
		break;
		case ICON_BUTTON_HAS_ACTIVE_WINDOW_PROPERTY:
		icon_button_set_has_active_window (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

