// Copyright 2024-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/plugin/check/v1/rule.proto

//go:build !protoopaque

package checkv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the Rule.
//
// Currently, there are only two types of rules: lint rules, and breaking change rules.
// Breaking change rules require FileDescriptors to check against; if the Rule ID of a breaking change
// Rule is specified in a Check call, then against_file_descriptors are required.
type RuleType int32

const (
	// The unspecified value.
	RuleType_RULE_TYPE_UNSPECIFIED RuleType = 0
	// A lint rule.
	RuleType_RULE_TYPE_LINT RuleType = 1
	// A breaking change rule.
	RuleType_RULE_TYPE_BREAKING RuleType = 2
)

// Enum value maps for RuleType.
var (
	RuleType_name = map[int32]string{
		0: "RULE_TYPE_UNSPECIFIED",
		1: "RULE_TYPE_LINT",
		2: "RULE_TYPE_BREAKING",
	}
	RuleType_value = map[string]int32{
		"RULE_TYPE_UNSPECIFIED": 0,
		"RULE_TYPE_LINT":        1,
		"RULE_TYPE_BREAKING":    2,
	}
)

func (x RuleType) Enum() *RuleType {
	p := new(RuleType)
	*p = x
	return p
}

func (x RuleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RuleType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_plugin_check_v1_rule_proto_enumTypes[0].Descriptor()
}

func (RuleType) Type() protoreflect.EnumType {
	return &file_buf_plugin_check_v1_rule_proto_enumTypes[0]
}

func (x RuleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// A rule that a CheckService implements.
type Rule struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Rule IDs must also be unique relative to Category IDs.
	//
	// Rule and Category IDs must be unique across all plugins used at the same time with
	// Buf. That is, no two plugins can both publish the same Rule or Category ID.
	//
	// This must have at least three characters.
	// This must start and end with a capital letter from A-Z or digits from 0-9, and only
	// consist of capital letters from A-Z, digits from 0-0, and underscores.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The IDs of the categories that the Rule is a part of.
	//
	// Buf uses categories to include or exclude sets of rules via configuration.
	//
	// Optional.
	//
	// The constraints for category IDs are the same as Rule IDs.
	CategoryIds []string `protobuf:"bytes,2,rep,name=category_ids,json=categoryIds,proto3" json:"category_ids,omitempty"`
	// Whether the Rule will be called by default if no Rule IDs are specified on a Check request.
	//
	// A deprecated Rule can never be a default Rule.
	Default bool `protobuf:"varint,3,opt,name=default,proto3" json:"default,omitempty"`
	// A user-displayable purpose of the rule.
	//
	// Required.
	//
	// This should be a proper sentence that starts with a capital letter and ends in a period.
	Purpose string `protobuf:"bytes,4,opt,name=purpose,proto3" json:"purpose,omitempty"`
	// The type of the rule.
	//
	// Required.
	Type RuleType `protobuf:"varint,5,opt,name=type,proto3,enum=buf.plugin.check.v1.RuleType" json:"type,omitempty"`
	// Whether or not this Rule is deprecated.
	//
	// If the Rule is deprecated, it may be replaced by 0 or more Rules. These will be denoted
	// by replacement_ids.
	Deprecated bool `protobuf:"varint,6,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// The IDs of the Rules that replace this Rule, if this Rule is deprecated.
	//
	// This means that the combination of the Rules specified by replacement_ids replace this Rule entirely,
	// and this Rule is considered equivalent to the AND of the rules specified by replacement_ids.
	//
	// This will only be non-empty if deprecated is true.
	// This may be empty even if deprecated is true.
	//
	// It is not valid for a deprecated Rule to specfiy another deprecated Rule as a replacement.
	ReplacementIds []string `protobuf:"bytes,7,rep,name=replacement_ids,json=replacementIds,proto3" json:"replacement_ids,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Rule) Reset() {
	*x = Rule{}
	mi := &file_buf_plugin_check_v1_rule_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_check_v1_rule_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Rule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Rule) GetCategoryIds() []string {
	if x != nil {
		return x.CategoryIds
	}
	return nil
}

func (x *Rule) GetDefault() bool {
	if x != nil {
		return x.Default
	}
	return false
}

func (x *Rule) GetPurpose() string {
	if x != nil {
		return x.Purpose
	}
	return ""
}

func (x *Rule) GetType() RuleType {
	if x != nil {
		return x.Type
	}
	return RuleType_RULE_TYPE_UNSPECIFIED
}

func (x *Rule) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *Rule) GetReplacementIds() []string {
	if x != nil {
		return x.ReplacementIds
	}
	return nil
}

func (x *Rule) SetId(v string) {
	x.Id = v
}

func (x *Rule) SetCategoryIds(v []string) {
	x.CategoryIds = v
}

func (x *Rule) SetDefault(v bool) {
	x.Default = v
}

func (x *Rule) SetPurpose(v string) {
	x.Purpose = v
}

func (x *Rule) SetType(v RuleType) {
	x.Type = v
}

func (x *Rule) SetDeprecated(v bool) {
	x.Deprecated = v
}

func (x *Rule) SetReplacementIds(v []string) {
	x.ReplacementIds = v
}

type Rule_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Rule IDs must also be unique relative to Category IDs.
	//
	// Rule and Category IDs must be unique across all plugins used at the same time with
	// Buf. That is, no two plugins can both publish the same Rule or Category ID.
	//
	// This must have at least three characters.
	// This must start and end with a capital letter from A-Z or digits from 0-9, and only
	// consist of capital letters from A-Z, digits from 0-0, and underscores.
	Id string
	// The IDs of the categories that the Rule is a part of.
	//
	// Buf uses categories to include or exclude sets of rules via configuration.
	//
	// Optional.
	//
	// The constraints for category IDs are the same as Rule IDs.
	CategoryIds []string
	// Whether the Rule will be called by default if no Rule IDs are specified on a Check request.
	//
	// A deprecated Rule can never be a default Rule.
	Default bool
	// A user-displayable purpose of the rule.
	//
	// Required.
	//
	// This should be a proper sentence that starts with a capital letter and ends in a period.
	Purpose string
	// The type of the rule.
	//
	// Required.
	Type RuleType
	// Whether or not this Rule is deprecated.
	//
	// If the Rule is deprecated, it may be replaced by 0 or more Rules. These will be denoted
	// by replacement_ids.
	Deprecated bool
	// The IDs of the Rules that replace this Rule, if this Rule is deprecated.
	//
	// This means that the combination of the Rules specified by replacement_ids replace this Rule entirely,
	// and this Rule is considered equivalent to the AND of the rules specified by replacement_ids.
	//
	// This will only be non-empty if deprecated is true.
	// This may be empty even if deprecated is true.
	//
	// It is not valid for a deprecated Rule to specfiy another deprecated Rule as a replacement.
	ReplacementIds []string
}

func (b0 Rule_builder) Build() *Rule {
	m0 := &Rule{}
	b, x := &b0, m0
	_, _ = b, x
	x.Id = b.Id
	x.CategoryIds = b.CategoryIds
	x.Default = b.Default
	x.Purpose = b.Purpose
	x.Type = b.Type
	x.Deprecated = b.Deprecated
	x.ReplacementIds = b.ReplacementIds
	return m0
}

var File_buf_plugin_check_v1_rule_proto protoreflect.FileDescriptor

const file_buf_plugin_check_v1_rule_proto_rawDesc = "" +
	"\n" +
	"\x1ebuf/plugin/check/v1/rule.proto\x12\x13buf.plugin.check.v1\x1a\x1bbuf/validate/validate.proto\"\xd9\x05\n" +
	"\x04Rule\x12:\n" +
	"\x02id\x18\x01 \x01(\tB*\xbaH'\xc8\x01\x01r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\x02id\x12O\n" +
	"\fcategory_ids\x18\x02 \x03(\tB,\xbaH)\x92\x01&\"$r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\vcategoryIds\x12\x18\n" +
	"\adefault\x18\x03 \x01(\bR\adefault\x125\n" +
	"\apurpose\x18\x04 \x01(\tB\x1b\xbaH\x18\xc8\x01\x01r\x13\x10\x02\x18\x80\x022\f^[A-Z].*[.]$R\apurpose\x129\n" +
	"\x04type\x18\x05 \x01(\x0e2\x1d.buf.plugin.check.v1.RuleTypeB\x06\xbaH\x03\xc8\x01\x01R\x04type\x12\x1e\n" +
	"\n" +
	"deprecated\x18\x06 \x01(\bR\n" +
	"deprecated\x12U\n" +
	"\x0freplacement_ids\x18\a \x03(\tB,\xbaH)\x92\x01&\"$r\"\x10\x03\x18@2\x1c^[A-Z0-9][A-Z0-9_]*[A-Z0-9]$R\x0ereplacementIds:\xc0\x02\xbaH\xbc\x02\x1a\xb2\x01\n" +
	"*deprecated_true_if_replacement_ids_present\x126deprecated must be true if replacement_ids are present\x1aL!has(this.replacement_ids) || (has(this.replacement_ids) && this.deprecated)\x1a\x84\x01\n" +
	" deprecated_false_if_default_true\x12+deprecated must be false if default is true\x1a3!this.default || (this.default && !this.deprecated)*Q\n" +
	"\bRuleType\x12\x19\n" +
	"\x15RULE_TYPE_UNSPECIFIED\x10\x00\x12\x12\n" +
	"\x0eRULE_TYPE_LINT\x10\x01\x12\x16\n" +
	"\x12RULE_TYPE_BREAKING\x10\x02BTZRbuf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/check/v1;checkv1b\x06proto3"

var file_buf_plugin_check_v1_rule_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_plugin_check_v1_rule_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_plugin_check_v1_rule_proto_goTypes = []any{
	(RuleType)(0), // 0: buf.plugin.check.v1.RuleType
	(*Rule)(nil),  // 1: buf.plugin.check.v1.Rule
}
var file_buf_plugin_check_v1_rule_proto_depIdxs = []int32{
	0, // 0: buf.plugin.check.v1.Rule.type:type_name -> buf.plugin.check.v1.RuleType
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_buf_plugin_check_v1_rule_proto_init() }
func file_buf_plugin_check_v1_rule_proto_init() {
	if File_buf_plugin_check_v1_rule_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_plugin_check_v1_rule_proto_rawDesc), len(file_buf_plugin_check_v1_rule_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_plugin_check_v1_rule_proto_goTypes,
		DependencyIndexes: file_buf_plugin_check_v1_rule_proto_depIdxs,
		EnumInfos:         file_buf_plugin_check_v1_rule_proto_enumTypes,
		MessageInfos:      file_buf_plugin_check_v1_rule_proto_msgTypes,
	}.Build()
	File_buf_plugin_check_v1_rule_proto = out.File
	file_buf_plugin_check_v1_rule_proto_goTypes = nil
	file_buf_plugin_check_v1_rule_proto_depIdxs = nil
}
