// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/registry/module/v1/module_service.proto

//go:build !protoopaque

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	v1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListModulesRequest_Order int32

const (
	ListModulesRequest_ORDER_UNSPECIFIED ListModulesRequest_Order = 0
	// Order by create_time newest to oldest.
	ListModulesRequest_ORDER_CREATE_TIME_DESC ListModulesRequest_Order = 1
	// Order by create_time oldest to newest.
	ListModulesRequest_ORDER_CREATE_TIME_ASC ListModulesRequest_Order = 2
)

// Enum value maps for ListModulesRequest_Order.
var (
	ListModulesRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListModulesRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListModulesRequest_Order) Enum() *ListModulesRequest_Order {
	p := new(ListModulesRequest_Order)
	*p = x
	return p
}

func (x ListModulesRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListModulesRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_module_service_proto_enumTypes[0].Descriptor()
}

func (ListModulesRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_module_service_proto_enumTypes[0]
}

func (x ListModulesRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetModulesRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Modules to request.
	ModuleRefs    []*ModuleRef `protobuf:"bytes,1,rep,name=module_refs,json=moduleRefs,proto3" json:"module_refs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetModulesRequest) Reset() {
	*x = GetModulesRequest{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulesRequest) ProtoMessage() {}

func (x *GetModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModulesRequest) GetModuleRefs() []*ModuleRef {
	if x != nil {
		return x.ModuleRefs
	}
	return nil
}

func (x *GetModulesRequest) SetModuleRefs(v []*ModuleRef) {
	x.ModuleRefs = v
}

type GetModulesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Modules to request.
	ModuleRefs []*ModuleRef
}

func (b0 GetModulesRequest_builder) Build() *GetModulesRequest {
	m0 := &GetModulesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.ModuleRefs = b.ModuleRefs
	return m0
}

type GetModulesResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The retrieved Modules in the same order as requested.
	Modules       []*Module `protobuf:"bytes,1,rep,name=modules,proto3" json:"modules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetModulesResponse) Reset() {
	*x = GetModulesResponse{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModulesResponse) ProtoMessage() {}

func (x *GetModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

func (x *GetModulesResponse) SetModules(v []*Module) {
	x.Modules = v
}

type GetModulesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The retrieved Modules in the same order as requested.
	Modules []*Module
}

func (b0 GetModulesResponse_builder) Build() *GetModulesResponse {
	m0 := &GetModulesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Modules = b.Modules
	return m0
}

type ListModulesRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The specific Users or Organizations to list Modules for.
	//
	// If empty, all Modules for all owners are listed, but this functionality
	// is limited to Users with the necessary permissions.
	OwnerRefs []*v1.OwnerRef `protobuf:"bytes,3,rep,name=owner_refs,json=ownerRefs,proto3" json:"owner_refs,omitempty"`
	// The order to return the Modules.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order         ListModulesRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.module.v1.ListModulesRequest_Order" json:"order,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListModulesRequest) Reset() {
	*x = ListModulesRequest{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModulesRequest) ProtoMessage() {}

func (x *ListModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListModulesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListModulesRequest) GetOwnerRefs() []*v1.OwnerRef {
	if x != nil {
		return x.OwnerRefs
	}
	return nil
}

func (x *ListModulesRequest) GetOrder() ListModulesRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListModulesRequest_ORDER_UNSPECIFIED
}

func (x *ListModulesRequest) SetPageSize(v uint32) {
	x.PageSize = v
}

func (x *ListModulesRequest) SetPageToken(v string) {
	x.PageToken = v
}

func (x *ListModulesRequest) SetOwnerRefs(v []*v1.OwnerRef) {
	x.OwnerRefs = v
}

func (x *ListModulesRequest) SetOrder(v ListModulesRequest_Order) {
	x.Order = v
}

type ListModulesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The specific Users or Organizations to list Modules for.
	//
	// If empty, all Modules for all owners are listed, but this functionality
	// is limited to Users with the necessary permissions.
	OwnerRefs []*v1.OwnerRef
	// The order to return the Modules.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListModulesRequest_Order
}

func (b0 ListModulesRequest_builder) Build() *ListModulesRequest {
	m0 := &ListModulesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.PageSize = b.PageSize
	x.PageToken = b.PageToken
	x.OwnerRefs = b.OwnerRefs
	x.Order = b.Order
	return m0
}

type ListModulesResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The listed Modules.
	Modules       []*Module `protobuf:"bytes,2,rep,name=modules,proto3" json:"modules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListModulesResponse) Reset() {
	*x = ListModulesResponse{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModulesResponse) ProtoMessage() {}

func (x *ListModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

func (x *ListModulesResponse) SetNextPageToken(v string) {
	x.NextPageToken = v
}

func (x *ListModulesResponse) SetModules(v []*Module) {
	x.Modules = v
}

type ListModulesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The listed Modules.
	Modules []*Module
}

func (b0 ListModulesResponse_builder) Build() *ListModulesResponse {
	m0 := &ListModulesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.NextPageToken = b.NextPageToken
	x.Modules = b.Modules
	return m0
}

type CreateModulesRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Modules to create.
	Values        []*CreateModulesRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateModulesRequest) Reset() {
	*x = CreateModulesRequest{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModulesRequest) ProtoMessage() {}

func (x *CreateModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateModulesRequest) GetValues() []*CreateModulesRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *CreateModulesRequest) SetValues(v []*CreateModulesRequest_Value) {
	x.Values = v
}

type CreateModulesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Modules to create.
	Values []*CreateModulesRequest_Value
}

func (b0 CreateModulesRequest_builder) Build() *CreateModulesRequest {
	m0 := &CreateModulesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

type CreateModulesResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The created Modules in the same order as given on the request.
	Modules       []*Module `protobuf:"bytes,1,rep,name=modules,proto3" json:"modules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateModulesResponse) Reset() {
	*x = CreateModulesResponse{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModulesResponse) ProtoMessage() {}

func (x *CreateModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

func (x *CreateModulesResponse) SetModules(v []*Module) {
	x.Modules = v
}

type CreateModulesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The created Modules in the same order as given on the request.
	Modules []*Module
}

func (b0 CreateModulesResponse_builder) Build() *CreateModulesResponse {
	m0 := &CreateModulesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Modules = b.Modules
	return m0
}

type UpdateModulesRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Modules to update.
	Values        []*UpdateModulesRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateModulesRequest) Reset() {
	*x = UpdateModulesRequest{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateModulesRequest) ProtoMessage() {}

func (x *UpdateModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateModulesRequest) GetValues() []*UpdateModulesRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *UpdateModulesRequest) SetValues(v []*UpdateModulesRequest_Value) {
	x.Values = v
}

type UpdateModulesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Modules to update.
	Values []*UpdateModulesRequest_Value
}

func (b0 UpdateModulesRequest_builder) Build() *UpdateModulesRequest {
	m0 := &UpdateModulesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

type UpdateModulesResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The updated Modules in the same order as given on the request.
	Modules       []*Module `protobuf:"bytes,1,rep,name=modules,proto3" json:"modules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateModulesResponse) Reset() {
	*x = UpdateModulesResponse{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateModulesResponse) ProtoMessage() {}

func (x *UpdateModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateModulesResponse) GetModules() []*Module {
	if x != nil {
		return x.Modules
	}
	return nil
}

func (x *UpdateModulesResponse) SetModules(v []*Module) {
	x.Modules = v
}

type UpdateModulesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The updated Modules in the same order as given on the request.
	Modules []*Module
}

func (b0 UpdateModulesResponse_builder) Build() *UpdateModulesResponse {
	m0 := &UpdateModulesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Modules = b.Modules
	return m0
}

type DeleteModulesRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Modules to delete.
	ModuleRefs    []*ModuleRef `protobuf:"bytes,1,rep,name=module_refs,json=moduleRefs,proto3" json:"module_refs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteModulesRequest) Reset() {
	*x = DeleteModulesRequest{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModulesRequest) ProtoMessage() {}

func (x *DeleteModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteModulesRequest) GetModuleRefs() []*ModuleRef {
	if x != nil {
		return x.ModuleRefs
	}
	return nil
}

func (x *DeleteModulesRequest) SetModuleRefs(v []*ModuleRef) {
	x.ModuleRefs = v
}

type DeleteModulesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Modules to delete.
	ModuleRefs []*ModuleRef
}

func (b0 DeleteModulesRequest_builder) Build() *DeleteModulesRequest {
	m0 := &DeleteModulesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.ModuleRefs = b.ModuleRefs
	return m0
}

type DeleteModulesResponse struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteModulesResponse) Reset() {
	*x = DeleteModulesResponse{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModulesResponse) ProtoMessage() {}

func (x *DeleteModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteModulesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteModulesResponse_builder) Build() *DeleteModulesResponse {
	m0 := &DeleteModulesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// An individual request to create a Module.
type CreateModulesRequest_Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The User or Organization to create the Module under.
	OwnerRef *v1.OwnerRef `protobuf:"bytes,1,opt,name=owner_ref,json=ownerRef,proto3" json:"owner_ref,omitempty"`
	// The name of the Module.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The module's visibility.
	//
	// If not specified, it uses the value from the instance or organization visibility control,
	// which defaults to MODULE_VISIBILITY_PRIVATE.
	Visibility ModuleVisibility `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.registry.module.v1.ModuleVisibility" json:"visibility,omitempty"`
	// The configurable description of the Module.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The configurable URL in the description of the module.
	Url string `protobuf:"bytes,5,opt,name=url,proto3" json:"url,omitempty"`
	// The name of the default Label of the Module.
	//
	// If not set, the default Label will be named "main" upon creation.
	//
	// This may point to an archived Label.
	DefaultLabelName string `protobuf:"bytes,6,opt,name=default_label_name,json=defaultLabelName,proto3" json:"default_label_name,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *CreateModulesRequest_Value) Reset() {
	*x = CreateModulesRequest_Value{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateModulesRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModulesRequest_Value) ProtoMessage() {}

func (x *CreateModulesRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateModulesRequest_Value) GetOwnerRef() *v1.OwnerRef {
	if x != nil {
		return x.OwnerRef
	}
	return nil
}

func (x *CreateModulesRequest_Value) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateModulesRequest_Value) GetVisibility() ModuleVisibility {
	if x != nil {
		return x.Visibility
	}
	return ModuleVisibility_MODULE_VISIBILITY_UNSPECIFIED
}

func (x *CreateModulesRequest_Value) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateModulesRequest_Value) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *CreateModulesRequest_Value) GetDefaultLabelName() string {
	if x != nil {
		return x.DefaultLabelName
	}
	return ""
}

func (x *CreateModulesRequest_Value) SetOwnerRef(v *v1.OwnerRef) {
	x.OwnerRef = v
}

func (x *CreateModulesRequest_Value) SetName(v string) {
	x.Name = v
}

func (x *CreateModulesRequest_Value) SetVisibility(v ModuleVisibility) {
	x.Visibility = v
}

func (x *CreateModulesRequest_Value) SetDescription(v string) {
	x.Description = v
}

func (x *CreateModulesRequest_Value) SetUrl(v string) {
	x.Url = v
}

func (x *CreateModulesRequest_Value) SetDefaultLabelName(v string) {
	x.DefaultLabelName = v
}

func (x *CreateModulesRequest_Value) HasOwnerRef() bool {
	if x == nil {
		return false
	}
	return x.OwnerRef != nil
}

func (x *CreateModulesRequest_Value) ClearOwnerRef() {
	x.OwnerRef = nil
}

type CreateModulesRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The User or Organization to create the Module under.
	OwnerRef *v1.OwnerRef
	// The name of the Module.
	Name string
	// The module's visibility.
	//
	// If not specified, it uses the value from the instance or organization visibility control,
	// which defaults to MODULE_VISIBILITY_PRIVATE.
	Visibility ModuleVisibility
	// The configurable description of the Module.
	Description string
	// The configurable URL in the description of the module.
	Url string
	// The name of the default Label of the Module.
	//
	// If not set, the default Label will be named "main" upon creation.
	//
	// This may point to an archived Label.
	DefaultLabelName string
}

func (b0 CreateModulesRequest_Value_builder) Build() *CreateModulesRequest_Value {
	m0 := &CreateModulesRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.OwnerRef = b.OwnerRef
	x.Name = b.Name
	x.Visibility = b.Visibility
	x.Description = b.Description
	x.Url = b.Url
	x.DefaultLabelName = b.DefaultLabelName
	return m0
}

// An individual request to update a Module.
type UpdateModulesRequest_Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Module to update.
	ModuleRef *ModuleRef `protobuf:"bytes,1,opt,name=module_ref,json=moduleRef,proto3" json:"module_ref,omitempty"`
	// The module's visibility.
	Visibility *ModuleVisibility `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.registry.module.v1.ModuleVisibility,oneof" json:"visibility,omitempty"`
	// The deprecation status of the module.
	State *ModuleState `protobuf:"varint,4,opt,name=state,proto3,enum=buf.registry.module.v1.ModuleState,oneof" json:"state,omitempty"`
	// The configurable description of the module.
	Description *string `protobuf:"bytes,5,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The configurable URL in the description of the module.
	Url *string `protobuf:"bytes,6,opt,name=url,proto3,oneof" json:"url,omitempty"`
	// The name of the default Label of the Module.
	//
	// This Label may not yet exist.
	//
	// This may not point to an archived Label.
	DefaultLabelName *string `protobuf:"bytes,7,opt,name=default_label_name,json=defaultLabelName,proto3,oneof" json:"default_label_name,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *UpdateModulesRequest_Value) Reset() {
	*x = UpdateModulesRequest_Value{}
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateModulesRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateModulesRequest_Value) ProtoMessage() {}

func (x *UpdateModulesRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_module_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateModulesRequest_Value) GetModuleRef() *ModuleRef {
	if x != nil {
		return x.ModuleRef
	}
	return nil
}

func (x *UpdateModulesRequest_Value) GetVisibility() ModuleVisibility {
	if x != nil && x.Visibility != nil {
		return *x.Visibility
	}
	return ModuleVisibility_MODULE_VISIBILITY_UNSPECIFIED
}

func (x *UpdateModulesRequest_Value) GetState() ModuleState {
	if x != nil && x.State != nil {
		return *x.State
	}
	return ModuleState_MODULE_STATE_UNSPECIFIED
}

func (x *UpdateModulesRequest_Value) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *UpdateModulesRequest_Value) GetUrl() string {
	if x != nil && x.Url != nil {
		return *x.Url
	}
	return ""
}

func (x *UpdateModulesRequest_Value) GetDefaultLabelName() string {
	if x != nil && x.DefaultLabelName != nil {
		return *x.DefaultLabelName
	}
	return ""
}

func (x *UpdateModulesRequest_Value) SetModuleRef(v *ModuleRef) {
	x.ModuleRef = v
}

func (x *UpdateModulesRequest_Value) SetVisibility(v ModuleVisibility) {
	x.Visibility = &v
}

func (x *UpdateModulesRequest_Value) SetState(v ModuleState) {
	x.State = &v
}

func (x *UpdateModulesRequest_Value) SetDescription(v string) {
	x.Description = &v
}

func (x *UpdateModulesRequest_Value) SetUrl(v string) {
	x.Url = &v
}

func (x *UpdateModulesRequest_Value) SetDefaultLabelName(v string) {
	x.DefaultLabelName = &v
}

func (x *UpdateModulesRequest_Value) HasModuleRef() bool {
	if x == nil {
		return false
	}
	return x.ModuleRef != nil
}

func (x *UpdateModulesRequest_Value) HasVisibility() bool {
	if x == nil {
		return false
	}
	return x.Visibility != nil
}

func (x *UpdateModulesRequest_Value) HasState() bool {
	if x == nil {
		return false
	}
	return x.State != nil
}

func (x *UpdateModulesRequest_Value) HasDescription() bool {
	if x == nil {
		return false
	}
	return x.Description != nil
}

func (x *UpdateModulesRequest_Value) HasUrl() bool {
	if x == nil {
		return false
	}
	return x.Url != nil
}

func (x *UpdateModulesRequest_Value) HasDefaultLabelName() bool {
	if x == nil {
		return false
	}
	return x.DefaultLabelName != nil
}

func (x *UpdateModulesRequest_Value) ClearModuleRef() {
	x.ModuleRef = nil
}

func (x *UpdateModulesRequest_Value) ClearVisibility() {
	x.Visibility = nil
}

func (x *UpdateModulesRequest_Value) ClearState() {
	x.State = nil
}

func (x *UpdateModulesRequest_Value) ClearDescription() {
	x.Description = nil
}

func (x *UpdateModulesRequest_Value) ClearUrl() {
	x.Url = nil
}

func (x *UpdateModulesRequest_Value) ClearDefaultLabelName() {
	x.DefaultLabelName = nil
}

type UpdateModulesRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Module to update.
	ModuleRef *ModuleRef
	// The module's visibility.
	Visibility *ModuleVisibility
	// The deprecation status of the module.
	State *ModuleState
	// The configurable description of the module.
	Description *string
	// The configurable URL in the description of the module.
	Url *string
	// The name of the default Label of the Module.
	//
	// This Label may not yet exist.
	//
	// This may not point to an archived Label.
	DefaultLabelName *string
}

func (b0 UpdateModulesRequest_Value_builder) Build() *UpdateModulesRequest_Value {
	m0 := &UpdateModulesRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.ModuleRef = b.ModuleRef
	x.Visibility = b.Visibility
	x.State = b.State
	x.Description = b.Description
	x.Url = b.Url
	x.DefaultLabelName = b.DefaultLabelName
	return m0
}

var File_buf_registry_module_v1_module_service_proto protoreflect.FileDescriptor

const file_buf_registry_module_v1_module_service_proto_rawDesc = "" +
	"\n" +
	"+buf/registry/module/v1/module_service.proto\x12\x16buf.registry.module.v1\x1a#buf/registry/module/v1/module.proto\x1a!buf/registry/owner/v1/owner.proto\x1a\x1bbuf/validate/validate.proto\"d\n" +
	"\x11GetModulesRequest\x12O\n" +
	"\vmodule_refs\x18\x01 \x03(\v2!.buf.registry.module.v1.ModuleRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\n" +
	"moduleRefs\"X\n" +
	"\x12GetModulesResponse\x12B\n" +
	"\amodules\x18\x01 \x03(\v2\x1e.buf.registry.module.v1.ModuleB\b\xbaH\x05\x92\x01\x02\b\x01R\amodules\"\xcd\x02\n" +
	"\x12ListModulesRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12>\n" +
	"\n" +
	"owner_refs\x18\x03 \x03(\v2\x1f.buf.registry.owner.v1.OwnerRefR\townerRefs\x12P\n" +
	"\x05order\x18\x04 \x01(\x0e20.buf.registry.module.v1.ListModulesRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\"U\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x1a\n" +
	"\x16ORDER_CREATE_TIME_DESC\x10\x01\x12\x19\n" +
	"\x15ORDER_CREATE_TIME_ASC\x10\x02\"\x81\x01\n" +
	"\x13ListModulesResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x128\n" +
	"\amodules\x18\x02 \x03(\v2\x1e.buf.registry.module.v1.ModuleR\amodules\"\xb8\x03\n" +
	"\x14CreateModulesRequest\x12W\n" +
	"\x06values\x18\x01 \x03(\v22.buf.registry.module.v1.CreateModulesRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\xc6\x02\n" +
	"\x05Value\x12D\n" +
	"\towner_ref\x18\x01 \x01(\v2\x1f.buf.registry.owner.v1.OwnerRefB\x06\xbaH\x03\xc8\x01\x01R\bownerRef\x12\x1d\n" +
	"\x04name\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x04name\x12R\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2(.buf.registry.module.v1.ModuleVisibilityB\b\xbaH\x05\x82\x01\x02\x10\x01R\n" +
	"visibility\x12*\n" +
	"\vdescription\x18\x04 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription\x12 \n" +
	"\x03url\x18\x05 \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\x03url\x126\n" +
	"\x12default_label_name\x18\x06 \x01(\tB\b\xbaH\x05r\x03\x18\xfa\x01R\x10defaultLabelName\"[\n" +
	"\x15CreateModulesResponse\x12B\n" +
	"\amodules\x18\x01 \x03(\v2\x1e.buf.registry.module.v1.ModuleB\b\xbaH\x05\x92\x01\x02\b\x01R\amodules\"\x8b\x05\n" +
	"\x14UpdateModulesRequest\x12W\n" +
	"\x06values\x18\x01 \x03(\v22.buf.registry.module.v1.UpdateModulesRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\x99\x04\n" +
	"\x05Value\x12H\n" +
	"\n" +
	"module_ref\x18\x01 \x01(\v2!.buf.registry.module.v1.ModuleRefB\x06\xbaH\x03\xc8\x01\x01R\tmoduleRef\x12Y\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2(.buf.registry.module.v1.ModuleVisibilityB\n" +
	"\xbaH\a\x82\x01\x04\x10\x01 \x00H\x00R\n" +
	"visibility\x88\x01\x01\x12J\n" +
	"\x05state\x18\x04 \x01(\x0e2#.buf.registry.module.v1.ModuleStateB\n" +
	"\xbaH\a\x82\x01\x04\x10\x01 \x00H\x01R\x05state\x88\x01\x01\x12/\n" +
	"\vdescription\x18\x05 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02H\x02R\vdescription\x88\x01\x01\x12g\n" +
	"\x03url\x18\x06 \x01(\tBP\xbaHM\xba\x01E\n" +
	"\furi_or_empty\x12\x19value must be a valid URI\x1a\x1athis == '' || this.isUri()r\x03\x18\xff\x01H\x03R\x03url\x88\x01\x01\x12=\n" +
	"\x12default_label_name\x18\a \x01(\tB\n" +
	"\xbaH\ar\x05\x10\x01\x18\xfa\x01H\x04R\x10defaultLabelName\x88\x01\x01B\r\n" +
	"\v_visibilityB\b\n" +
	"\x06_stateB\x0e\n" +
	"\f_descriptionB\x06\n" +
	"\x04_urlB\x15\n" +
	"\x13_default_label_name\"[\n" +
	"\x15UpdateModulesResponse\x12B\n" +
	"\amodules\x18\x01 \x03(\v2\x1e.buf.registry.module.v1.ModuleB\b\xbaH\x05\x92\x01\x02\b\x01R\amodules\"g\n" +
	"\x14DeleteModulesRequest\x12O\n" +
	"\vmodule_refs\x18\x01 \x03(\v2!.buf.registry.module.v1.ModuleRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\n" +
	"moduleRefs\"\x17\n" +
	"\x15DeleteModulesResponse2\xbf\x04\n" +
	"\rModuleService\x12h\n" +
	"\n" +
	"GetModules\x12).buf.registry.module.v1.GetModulesRequest\x1a*.buf.registry.module.v1.GetModulesResponse\"\x03\x90\x02\x01\x12k\n" +
	"\vListModules\x12*.buf.registry.module.v1.ListModulesRequest\x1a+.buf.registry.module.v1.ListModulesResponse\"\x03\x90\x02\x01\x12q\n" +
	"\rCreateModules\x12,.buf.registry.module.v1.CreateModulesRequest\x1a-.buf.registry.module.v1.CreateModulesResponse\"\x03\x90\x02\x02\x12q\n" +
	"\rUpdateModules\x12,.buf.registry.module.v1.UpdateModulesRequest\x1a-.buf.registry.module.v1.UpdateModulesResponse\"\x03\x90\x02\x02\x12q\n" +
	"\rDeleteModules\x12,.buf.registry.module.v1.DeleteModulesRequest\x1a-.buf.registry.module.v1.DeleteModulesResponse\"\x03\x90\x02\x02BWZUbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1;modulev1b\x06proto3"

var file_buf_registry_module_v1_module_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_module_v1_module_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_registry_module_v1_module_service_proto_goTypes = []any{
	(ListModulesRequest_Order)(0),      // 0: buf.registry.module.v1.ListModulesRequest.Order
	(*GetModulesRequest)(nil),          // 1: buf.registry.module.v1.GetModulesRequest
	(*GetModulesResponse)(nil),         // 2: buf.registry.module.v1.GetModulesResponse
	(*ListModulesRequest)(nil),         // 3: buf.registry.module.v1.ListModulesRequest
	(*ListModulesResponse)(nil),        // 4: buf.registry.module.v1.ListModulesResponse
	(*CreateModulesRequest)(nil),       // 5: buf.registry.module.v1.CreateModulesRequest
	(*CreateModulesResponse)(nil),      // 6: buf.registry.module.v1.CreateModulesResponse
	(*UpdateModulesRequest)(nil),       // 7: buf.registry.module.v1.UpdateModulesRequest
	(*UpdateModulesResponse)(nil),      // 8: buf.registry.module.v1.UpdateModulesResponse
	(*DeleteModulesRequest)(nil),       // 9: buf.registry.module.v1.DeleteModulesRequest
	(*DeleteModulesResponse)(nil),      // 10: buf.registry.module.v1.DeleteModulesResponse
	(*CreateModulesRequest_Value)(nil), // 11: buf.registry.module.v1.CreateModulesRequest.Value
	(*UpdateModulesRequest_Value)(nil), // 12: buf.registry.module.v1.UpdateModulesRequest.Value
	(*ModuleRef)(nil),                  // 13: buf.registry.module.v1.ModuleRef
	(*Module)(nil),                     // 14: buf.registry.module.v1.Module
	(*v1.OwnerRef)(nil),                // 15: buf.registry.owner.v1.OwnerRef
	(ModuleVisibility)(0),              // 16: buf.registry.module.v1.ModuleVisibility
	(ModuleState)(0),                   // 17: buf.registry.module.v1.ModuleState
}
var file_buf_registry_module_v1_module_service_proto_depIdxs = []int32{
	13, // 0: buf.registry.module.v1.GetModulesRequest.module_refs:type_name -> buf.registry.module.v1.ModuleRef
	14, // 1: buf.registry.module.v1.GetModulesResponse.modules:type_name -> buf.registry.module.v1.Module
	15, // 2: buf.registry.module.v1.ListModulesRequest.owner_refs:type_name -> buf.registry.owner.v1.OwnerRef
	0,  // 3: buf.registry.module.v1.ListModulesRequest.order:type_name -> buf.registry.module.v1.ListModulesRequest.Order
	14, // 4: buf.registry.module.v1.ListModulesResponse.modules:type_name -> buf.registry.module.v1.Module
	11, // 5: buf.registry.module.v1.CreateModulesRequest.values:type_name -> buf.registry.module.v1.CreateModulesRequest.Value
	14, // 6: buf.registry.module.v1.CreateModulesResponse.modules:type_name -> buf.registry.module.v1.Module
	12, // 7: buf.registry.module.v1.UpdateModulesRequest.values:type_name -> buf.registry.module.v1.UpdateModulesRequest.Value
	14, // 8: buf.registry.module.v1.UpdateModulesResponse.modules:type_name -> buf.registry.module.v1.Module
	13, // 9: buf.registry.module.v1.DeleteModulesRequest.module_refs:type_name -> buf.registry.module.v1.ModuleRef
	15, // 10: buf.registry.module.v1.CreateModulesRequest.Value.owner_ref:type_name -> buf.registry.owner.v1.OwnerRef
	16, // 11: buf.registry.module.v1.CreateModulesRequest.Value.visibility:type_name -> buf.registry.module.v1.ModuleVisibility
	13, // 12: buf.registry.module.v1.UpdateModulesRequest.Value.module_ref:type_name -> buf.registry.module.v1.ModuleRef
	16, // 13: buf.registry.module.v1.UpdateModulesRequest.Value.visibility:type_name -> buf.registry.module.v1.ModuleVisibility
	17, // 14: buf.registry.module.v1.UpdateModulesRequest.Value.state:type_name -> buf.registry.module.v1.ModuleState
	1,  // 15: buf.registry.module.v1.ModuleService.GetModules:input_type -> buf.registry.module.v1.GetModulesRequest
	3,  // 16: buf.registry.module.v1.ModuleService.ListModules:input_type -> buf.registry.module.v1.ListModulesRequest
	5,  // 17: buf.registry.module.v1.ModuleService.CreateModules:input_type -> buf.registry.module.v1.CreateModulesRequest
	7,  // 18: buf.registry.module.v1.ModuleService.UpdateModules:input_type -> buf.registry.module.v1.UpdateModulesRequest
	9,  // 19: buf.registry.module.v1.ModuleService.DeleteModules:input_type -> buf.registry.module.v1.DeleteModulesRequest
	2,  // 20: buf.registry.module.v1.ModuleService.GetModules:output_type -> buf.registry.module.v1.GetModulesResponse
	4,  // 21: buf.registry.module.v1.ModuleService.ListModules:output_type -> buf.registry.module.v1.ListModulesResponse
	6,  // 22: buf.registry.module.v1.ModuleService.CreateModules:output_type -> buf.registry.module.v1.CreateModulesResponse
	8,  // 23: buf.registry.module.v1.ModuleService.UpdateModules:output_type -> buf.registry.module.v1.UpdateModulesResponse
	10, // 24: buf.registry.module.v1.ModuleService.DeleteModules:output_type -> buf.registry.module.v1.DeleteModulesResponse
	20, // [20:25] is the sub-list for method output_type
	15, // [15:20] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_module_service_proto_init() }
func file_buf_registry_module_v1_module_service_proto_init() {
	if File_buf_registry_module_v1_module_service_proto != nil {
		return
	}
	file_buf_registry_module_v1_module_proto_init()
	file_buf_registry_module_v1_module_service_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_module_v1_module_service_proto_rawDesc), len(file_buf_registry_module_v1_module_service_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1_module_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_module_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_module_v1_module_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_module_v1_module_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_module_service_proto = out.File
	file_buf_registry_module_v1_module_service_proto_goTypes = nil
	file_buf_registry_module_v1_module_service_proto_depIdxs = nil
}
