/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta3

// ExemptPriorityLevelConfigurationApplyConfiguration represents a declarative configuration of the ExemptPriorityLevelConfiguration type for use
// with apply.
//
// ExemptPriorityLevelConfiguration describes the configurable aspects
// of the handling of exempt requests.
// In the mandatory exempt configuration object the values in the fields
// here can be modified by authorized users, unlike the rest of the `spec`.
type ExemptPriorityLevelConfigurationApplyConfiguration struct {
	// `nominalConcurrencyShares` (NCS) contributes to the computation of the
	// NominalConcurrencyLimit (NominalCL) of this level.
	// This is the number of execution seats nominally reserved for this priority level.
	// This DOES NOT limit the dispatching from this priority level
	// but affects the other priority levels through the borrowing mechanism.
	// The server's concurrency limit (ServerCL) is divided among all the
	// priority levels in proportion to their NCS values:
	//
	// NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs )
	// sum_ncs = sum[priority level k] NCS(k)
	//
	// Bigger numbers mean a larger nominal concurrency limit,
	// at the expense of every other priority level.
	// This field has a default value of zero.
	NominalConcurrencyShares *int32 `json:"nominalConcurrencyShares,omitempty"`
	// `lendablePercent` prescribes the fraction of the level's NominalCL that
	// can be borrowed by other priority levels.  This value of this
	// field must be between 0 and 100, inclusive, and it defaults to 0.
	// The number of seats that other levels can borrow from this level, known
	// as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
	//
	// LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
	LendablePercent *int32 `json:"lendablePercent,omitempty"`
}

// ExemptPriorityLevelConfigurationApplyConfiguration constructs a declarative configuration of the ExemptPriorityLevelConfiguration type for use with
// apply.
func ExemptPriorityLevelConfiguration() *ExemptPriorityLevelConfigurationApplyConfiguration {
	return &ExemptPriorityLevelConfigurationApplyConfiguration{}
}

// WithNominalConcurrencyShares sets the NominalConcurrencyShares field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NominalConcurrencyShares field is set to the value of the last call.
func (b *ExemptPriorityLevelConfigurationApplyConfiguration) WithNominalConcurrencyShares(value int32) *ExemptPriorityLevelConfigurationApplyConfiguration {
	b.NominalConcurrencyShares = &value
	return b
}

// WithLendablePercent sets the LendablePercent field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LendablePercent field is set to the value of the last call.
func (b *ExemptPriorityLevelConfigurationApplyConfiguration) WithLendablePercent(value int32) *ExemptPriorityLevelConfigurationApplyConfiguration {
	b.LendablePercent = &value
	return b
}
