// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: terminal.proto

package terminal

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type SessionRequest struct {
	// Types that are valid to be assigned to Msg:
	//
	//	*SessionRequest_Stdout
	//	*SessionRequest_Stderr
	//	*SessionRequest_Exit
	Msg isSessionRequest_Msg `protobuf_oneof:"msg"`
}

func (m *SessionRequest) Reset()      { *m = SessionRequest{} }
func (*SessionRequest) ProtoMessage() {}
func (*SessionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff8b8260c8ef16ad, []int{0}
}
func (m *SessionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SessionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SessionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SessionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SessionRequest.Merge(m, src)
}
func (m *SessionRequest) XXX_Size() int {
	return m.Size()
}
func (m *SessionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SessionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SessionRequest proto.InternalMessageInfo

type isSessionRequest_Msg interface {
	isSessionRequest_Msg()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type SessionRequest_Stdout struct {
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3,oneof" json:"stdout,omitempty"`
}
type SessionRequest_Stderr struct {
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3,oneof" json:"stderr,omitempty"`
}
type SessionRequest_Exit struct {
	Exit int32 `protobuf:"varint,3,opt,name=exit,proto3,oneof" json:"exit,omitempty"`
}

func (*SessionRequest_Stdout) isSessionRequest_Msg() {}
func (*SessionRequest_Stderr) isSessionRequest_Msg() {}
func (*SessionRequest_Exit) isSessionRequest_Msg()   {}

func (m *SessionRequest) GetMsg() isSessionRequest_Msg {
	if m != nil {
		return m.Msg
	}
	return nil
}

func (m *SessionRequest) GetStdout() []byte {
	if x, ok := m.GetMsg().(*SessionRequest_Stdout); ok {
		return x.Stdout
	}
	return nil
}

func (m *SessionRequest) GetStderr() []byte {
	if x, ok := m.GetMsg().(*SessionRequest_Stderr); ok {
		return x.Stderr
	}
	return nil
}

func (m *SessionRequest) GetExit() int32 {
	if x, ok := m.GetMsg().(*SessionRequest_Exit); ok {
		return x.Exit
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SessionRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SessionRequest_Stdout)(nil),
		(*SessionRequest_Stderr)(nil),
		(*SessionRequest_Exit)(nil),
	}
}

type SessionResponse struct {
	// Types that are valid to be assigned to Msg:
	//
	//	*SessionResponse_Stdin
	//	*SessionResponse_Resize
	//	*SessionResponse_Ready
	Msg isSessionResponse_Msg `protobuf_oneof:"msg"`
}

func (m *SessionResponse) Reset()      { *m = SessionResponse{} }
func (*SessionResponse) ProtoMessage() {}
func (*SessionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff8b8260c8ef16ad, []int{1}
}
func (m *SessionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SessionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SessionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SessionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SessionResponse.Merge(m, src)
}
func (m *SessionResponse) XXX_Size() int {
	return m.Size()
}
func (m *SessionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SessionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SessionResponse proto.InternalMessageInfo

type isSessionResponse_Msg interface {
	isSessionResponse_Msg()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type SessionResponse_Stdin struct {
	Stdin []byte `protobuf:"bytes,1,opt,name=stdin,proto3,oneof" json:"stdin,omitempty"`
}
type SessionResponse_Resize struct {
	Resize *Resize `protobuf:"bytes,2,opt,name=resize,proto3,oneof" json:"resize,omitempty"`
}
type SessionResponse_Ready struct {
	Ready *Ready `protobuf:"bytes,3,opt,name=ready,proto3,oneof" json:"ready,omitempty"`
}

func (*SessionResponse_Stdin) isSessionResponse_Msg()  {}
func (*SessionResponse_Resize) isSessionResponse_Msg() {}
func (*SessionResponse_Ready) isSessionResponse_Msg()  {}

func (m *SessionResponse) GetMsg() isSessionResponse_Msg {
	if m != nil {
		return m.Msg
	}
	return nil
}

func (m *SessionResponse) GetStdin() []byte {
	if x, ok := m.GetMsg().(*SessionResponse_Stdin); ok {
		return x.Stdin
	}
	return nil
}

func (m *SessionResponse) GetResize() *Resize {
	if x, ok := m.GetMsg().(*SessionResponse_Resize); ok {
		return x.Resize
	}
	return nil
}

func (m *SessionResponse) GetReady() *Ready {
	if x, ok := m.GetMsg().(*SessionResponse_Ready); ok {
		return x.Ready
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SessionResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SessionResponse_Stdin)(nil),
		(*SessionResponse_Resize)(nil),
		(*SessionResponse_Ready)(nil),
	}
}

type Resize struct {
	Width  int32 `protobuf:"varint,1,opt,name=Width,proto3" json:"Width,omitempty"`
	Height int32 `protobuf:"varint,2,opt,name=Height,proto3" json:"Height,omitempty"`
}

func (m *Resize) Reset()      { *m = Resize{} }
func (*Resize) ProtoMessage() {}
func (*Resize) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff8b8260c8ef16ad, []int{2}
}
func (m *Resize) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Resize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Resize.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Resize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resize.Merge(m, src)
}
func (m *Resize) XXX_Size() int {
	return m.Size()
}
func (m *Resize) XXX_DiscardUnknown() {
	xxx_messageInfo_Resize.DiscardUnknown(m)
}

var xxx_messageInfo_Resize proto.InternalMessageInfo

func (m *Resize) GetWidth() int32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *Resize) GetHeight() int32 {
	if m != nil {
		return m.Height
	}
	return 0
}

type Ready struct {
}

func (m *Ready) Reset()      { *m = Ready{} }
func (*Ready) ProtoMessage() {}
func (*Ready) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff8b8260c8ef16ad, []int{3}
}
func (m *Ready) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Ready) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Ready.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Ready) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ready.Merge(m, src)
}
func (m *Ready) XXX_Size() int {
	return m.Size()
}
func (m *Ready) XXX_DiscardUnknown() {
	xxx_messageInfo_Ready.DiscardUnknown(m)
}

var xxx_messageInfo_Ready proto.InternalMessageInfo

func init() {
	proto.RegisterType((*SessionRequest)(nil), "dagger.terminal.SessionRequest")
	proto.RegisterType((*SessionResponse)(nil), "dagger.terminal.SessionResponse")
	proto.RegisterType((*Resize)(nil), "dagger.terminal.Resize")
	proto.RegisterType((*Ready)(nil), "dagger.terminal.Ready")
}

func init() { proto.RegisterFile("terminal.proto", fileDescriptor_ff8b8260c8ef16ad) }

var fileDescriptor_ff8b8260c8ef16ad = []byte{
	// 334 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x91, 0x3f, 0x4b, 0x03, 0x31,
	0x18, 0xc6, 0x13, 0x6b, 0xae, 0xe5, 0xad, 0xb4, 0x10, 0x4a, 0x3d, 0x1c, 0x62, 0xe9, 0xd4, 0xe9,
	0xd0, 0x0a, 0x8e, 0x0e, 0x9d, 0x3a, 0xca, 0x29, 0x08, 0xe2, 0x72, 0x72, 0x2f, 0xd7, 0x80, 0xbd,
	0xab, 0x49, 0x0a, 0xd6, 0xc9, 0x8f, 0x20, 0xf8, 0x25, 0xfc, 0x28, 0x8e, 0x1d, 0x3b, 0xda, 0x74,
	0x71, 0xec, 0x47, 0x90, 0xe6, 0xee, 0x8a, 0x7f, 0xc7, 0x27, 0xef, 0x93, 0xe7, 0xf7, 0xe4, 0x0d,
	0x34, 0x0c, 0xaa, 0xb1, 0x4c, 0xa3, 0xbb, 0x60, 0xa2, 0x32, 0x93, 0xf1, 0x66, 0x1c, 0x25, 0x09,
	0xaa, 0xa0, 0x3c, 0xee, 0x46, 0xd0, 0xb8, 0x40, 0xad, 0x65, 0x96, 0x86, 0x78, 0x3f, 0x45, 0x6d,
	0xb8, 0x0f, 0x9e, 0x36, 0x71, 0x36, 0x35, 0x3e, 0xed, 0xd0, 0xde, 0xde, 0x90, 0x84, 0x85, 0x2e,
	0x26, 0xa8, 0x94, 0xbf, 0xf3, 0x65, 0x82, 0x4a, 0xf1, 0x16, 0xec, 0xe2, 0x83, 0x34, 0x7e, 0xa5,
	0x43, 0x7b, 0x6c, 0x48, 0x42, 0xa7, 0x06, 0x0c, 0x2a, 0x63, 0x9d, 0x74, 0x5f, 0x28, 0x34, 0xb7,
	0x0c, 0x3d, 0xc9, 0x52, 0x8d, 0xbc, 0x0d, 0x4c, 0x9b, 0x58, 0xa6, 0x5b, 0x46, 0x2e, 0xf9, 0x31,
	0x78, 0x0a, 0xb5, 0x7c, 0x44, 0x87, 0xa8, 0xf7, 0xf7, 0x83, 0x1f, 0x85, 0x83, 0xd0, 0x8d, 0x37,
	0xec, 0xdc, 0xc8, 0x03, 0x60, 0x0a, 0xa3, 0x78, 0xe6, 0xe0, 0xf5, 0x7e, 0xfb, 0x8f, 0x1b, 0x51,
	0x3c, 0xdb, 0x20, 0x9c, 0xad, 0x6c, 0x75, 0x0a, 0x5e, 0x1e, 0xc5, 0x5b, 0xc0, 0xae, 0x64, 0x6c,
	0x46, 0xae, 0x0b, 0x0b, 0x73, 0xc1, 0xdb, 0xe0, 0x0d, 0x51, 0x26, 0x23, 0xe3, 0x9a, 0xb0, 0xb0,
	0x50, 0xdd, 0x2a, 0x30, 0x17, 0xd8, 0xbf, 0x81, 0xda, 0x65, 0x81, 0xe0, 0xe7, 0x50, 0x2d, 0x5e,
	0xc8, 0x0f, 0x7f, 0xf1, 0xbf, 0xef, 0xf7, 0xa0, 0xf3, 0xbf, 0x21, 0x5f, 0x4e, 0x8f, 0x1e, 0xd1,
	0xc1, 0xd9, 0x7c, 0x29, 0xc8, 0x62, 0x29, 0xc8, 0x7a, 0x29, 0xe8, 0x93, 0x15, 0xf4, 0xd5, 0x0a,
	0xfa, 0x66, 0x05, 0x9d, 0x5b, 0x41, 0xdf, 0xad, 0xa0, 0x1f, 0x56, 0x90, 0xb5, 0x15, 0xf4, 0x79,
	0x25, 0xc8, 0x7c, 0x25, 0xc8, 0x62, 0x25, 0xc8, 0x75, 0xad, 0xcc, 0xbc, 0xf5, 0xdc, 0x7f, 0x9f,
	0x7c, 0x06, 0x00, 0x00, 0xff, 0xff, 0x13, 0x37, 0xb0, 0xfb, 0x01, 0x02, 0x00, 0x00,
}

func (this *SessionRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionRequest)
	if !ok {
		that2, ok := that.(SessionRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Msg == nil {
		if this.Msg != nil {
			return false
		}
	} else if this.Msg == nil {
		return false
	} else if !this.Msg.Equal(that1.Msg) {
		return false
	}
	return true
}
func (this *SessionRequest_Stdout) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionRequest_Stdout)
	if !ok {
		that2, ok := that.(SessionRequest_Stdout)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Stdout, that1.Stdout) {
		return false
	}
	return true
}
func (this *SessionRequest_Stderr) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionRequest_Stderr)
	if !ok {
		that2, ok := that.(SessionRequest_Stderr)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Stderr, that1.Stderr) {
		return false
	}
	return true
}
func (this *SessionRequest_Exit) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionRequest_Exit)
	if !ok {
		that2, ok := that.(SessionRequest_Exit)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Exit != that1.Exit {
		return false
	}
	return true
}
func (this *SessionResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionResponse)
	if !ok {
		that2, ok := that.(SessionResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Msg == nil {
		if this.Msg != nil {
			return false
		}
	} else if this.Msg == nil {
		return false
	} else if !this.Msg.Equal(that1.Msg) {
		return false
	}
	return true
}
func (this *SessionResponse_Stdin) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionResponse_Stdin)
	if !ok {
		that2, ok := that.(SessionResponse_Stdin)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Stdin, that1.Stdin) {
		return false
	}
	return true
}
func (this *SessionResponse_Resize) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionResponse_Resize)
	if !ok {
		that2, ok := that.(SessionResponse_Resize)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Resize.Equal(that1.Resize) {
		return false
	}
	return true
}
func (this *SessionResponse_Ready) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SessionResponse_Ready)
	if !ok {
		that2, ok := that.(SessionResponse_Ready)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Ready.Equal(that1.Ready) {
		return false
	}
	return true
}
func (this *Resize) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Resize)
	if !ok {
		that2, ok := that.(Resize)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Width != that1.Width {
		return false
	}
	if this.Height != that1.Height {
		return false
	}
	return true
}
func (this *Ready) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Ready)
	if !ok {
		that2, ok := that.(Ready)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *SessionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&terminal.SessionRequest{")
	if this.Msg != nil {
		s = append(s, "Msg: "+fmt.Sprintf("%#v", this.Msg)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SessionRequest_Stdout) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&terminal.SessionRequest_Stdout{` +
		`Stdout:` + fmt.Sprintf("%#v", this.Stdout) + `}`}, ", ")
	return s
}
func (this *SessionRequest_Stderr) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&terminal.SessionRequest_Stderr{` +
		`Stderr:` + fmt.Sprintf("%#v", this.Stderr) + `}`}, ", ")
	return s
}
func (this *SessionRequest_Exit) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&terminal.SessionRequest_Exit{` +
		`Exit:` + fmt.Sprintf("%#v", this.Exit) + `}`}, ", ")
	return s
}
func (this *SessionResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&terminal.SessionResponse{")
	if this.Msg != nil {
		s = append(s, "Msg: "+fmt.Sprintf("%#v", this.Msg)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SessionResponse_Stdin) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&terminal.SessionResponse_Stdin{` +
		`Stdin:` + fmt.Sprintf("%#v", this.Stdin) + `}`}, ", ")
	return s
}
func (this *SessionResponse_Resize) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&terminal.SessionResponse_Resize{` +
		`Resize:` + fmt.Sprintf("%#v", this.Resize) + `}`}, ", ")
	return s
}
func (this *SessionResponse_Ready) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&terminal.SessionResponse_Ready{` +
		`Ready:` + fmt.Sprintf("%#v", this.Ready) + `}`}, ", ")
	return s
}
func (this *Resize) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&terminal.Resize{")
	s = append(s, "Width: "+fmt.Sprintf("%#v", this.Width)+",\n")
	s = append(s, "Height: "+fmt.Sprintf("%#v", this.Height)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Ready) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&terminal.Ready{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringTerminal(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TerminalClient is the client API for Terminal service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TerminalClient interface {
	Session(ctx context.Context, opts ...grpc.CallOption) (Terminal_SessionClient, error)
}

type terminalClient struct {
	cc *grpc.ClientConn
}

func NewTerminalClient(cc *grpc.ClientConn) TerminalClient {
	return &terminalClient{cc}
}

func (c *terminalClient) Session(ctx context.Context, opts ...grpc.CallOption) (Terminal_SessionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Terminal_serviceDesc.Streams[0], "/dagger.terminal.Terminal/Session", opts...)
	if err != nil {
		return nil, err
	}
	x := &terminalSessionClient{stream}
	return x, nil
}

type Terminal_SessionClient interface {
	Send(*SessionRequest) error
	Recv() (*SessionResponse, error)
	grpc.ClientStream
}

type terminalSessionClient struct {
	grpc.ClientStream
}

func (x *terminalSessionClient) Send(m *SessionRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *terminalSessionClient) Recv() (*SessionResponse, error) {
	m := new(SessionResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TerminalServer is the server API for Terminal service.
type TerminalServer interface {
	Session(Terminal_SessionServer) error
}

// UnimplementedTerminalServer can be embedded to have forward compatible implementations.
type UnimplementedTerminalServer struct {
}

func (*UnimplementedTerminalServer) Session(srv Terminal_SessionServer) error {
	return status.Errorf(codes.Unimplemented, "method Session not implemented")
}

func RegisterTerminalServer(s *grpc.Server, srv TerminalServer) {
	s.RegisterService(&_Terminal_serviceDesc, srv)
}

func _Terminal_Session_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(TerminalServer).Session(&terminalSessionServer{stream})
}

type Terminal_SessionServer interface {
	Send(*SessionResponse) error
	Recv() (*SessionRequest, error)
	grpc.ServerStream
}

type terminalSessionServer struct {
	grpc.ServerStream
}

func (x *terminalSessionServer) Send(m *SessionResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *terminalSessionServer) Recv() (*SessionRequest, error) {
	m := new(SessionRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Terminal_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dagger.terminal.Terminal",
	HandlerType: (*TerminalServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Session",
			Handler:       _Terminal_Session_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "terminal.proto",
}

func (m *SessionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SessionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Msg != nil {
		{
			size := m.Msg.Size()
			i -= size
			if _, err := m.Msg.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *SessionRequest_Stdout) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionRequest_Stdout) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Stdout != nil {
		i -= len(m.Stdout)
		copy(dAtA[i:], m.Stdout)
		i = encodeVarintTerminal(dAtA, i, uint64(len(m.Stdout)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *SessionRequest_Stderr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionRequest_Stderr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Stderr != nil {
		i -= len(m.Stderr)
		copy(dAtA[i:], m.Stderr)
		i = encodeVarintTerminal(dAtA, i, uint64(len(m.Stderr)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *SessionRequest_Exit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionRequest_Exit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintTerminal(dAtA, i, uint64(m.Exit))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *SessionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SessionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Msg != nil {
		{
			size := m.Msg.Size()
			i -= size
			if _, err := m.Msg.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *SessionResponse_Stdin) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionResponse_Stdin) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Stdin != nil {
		i -= len(m.Stdin)
		copy(dAtA[i:], m.Stdin)
		i = encodeVarintTerminal(dAtA, i, uint64(len(m.Stdin)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *SessionResponse_Resize) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionResponse_Resize) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Resize != nil {
		{
			size, err := m.Resize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTerminal(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *SessionResponse_Ready) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionResponse_Ready) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Ready != nil {
		{
			size, err := m.Ready.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTerminal(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Resize) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Resize) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Resize) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Height != 0 {
		i = encodeVarintTerminal(dAtA, i, uint64(m.Height))
		i--
		dAtA[i] = 0x10
	}
	if m.Width != 0 {
		i = encodeVarintTerminal(dAtA, i, uint64(m.Width))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Ready) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Ready) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Ready) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func encodeVarintTerminal(dAtA []byte, offset int, v uint64) int {
	offset -= sovTerminal(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SessionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Msg != nil {
		n += m.Msg.Size()
	}
	return n
}

func (m *SessionRequest_Stdout) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stdout != nil {
		l = len(m.Stdout)
		n += 1 + l + sovTerminal(uint64(l))
	}
	return n
}
func (m *SessionRequest_Stderr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stderr != nil {
		l = len(m.Stderr)
		n += 1 + l + sovTerminal(uint64(l))
	}
	return n
}
func (m *SessionRequest_Exit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovTerminal(uint64(m.Exit))
	return n
}
func (m *SessionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Msg != nil {
		n += m.Msg.Size()
	}
	return n
}

func (m *SessionResponse_Stdin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stdin != nil {
		l = len(m.Stdin)
		n += 1 + l + sovTerminal(uint64(l))
	}
	return n
}
func (m *SessionResponse_Resize) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resize != nil {
		l = m.Resize.Size()
		n += 1 + l + sovTerminal(uint64(l))
	}
	return n
}
func (m *SessionResponse_Ready) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Ready != nil {
		l = m.Ready.Size()
		n += 1 + l + sovTerminal(uint64(l))
	}
	return n
}
func (m *Resize) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Width != 0 {
		n += 1 + sovTerminal(uint64(m.Width))
	}
	if m.Height != 0 {
		n += 1 + sovTerminal(uint64(m.Height))
	}
	return n
}

func (m *Ready) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovTerminal(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTerminal(x uint64) (n int) {
	return sovTerminal(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *SessionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionRequest{`,
		`Msg:` + fmt.Sprintf("%v", this.Msg) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionRequest_Stdout) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionRequest_Stdout{`,
		`Stdout:` + fmt.Sprintf("%v", this.Stdout) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionRequest_Stderr) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionRequest_Stderr{`,
		`Stderr:` + fmt.Sprintf("%v", this.Stderr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionRequest_Exit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionRequest_Exit{`,
		`Exit:` + fmt.Sprintf("%v", this.Exit) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionResponse{`,
		`Msg:` + fmt.Sprintf("%v", this.Msg) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionResponse_Stdin) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionResponse_Stdin{`,
		`Stdin:` + fmt.Sprintf("%v", this.Stdin) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionResponse_Resize) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionResponse_Resize{`,
		`Resize:` + strings.Replace(fmt.Sprintf("%v", this.Resize), "Resize", "Resize", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionResponse_Ready) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionResponse_Ready{`,
		`Ready:` + strings.Replace(fmt.Sprintf("%v", this.Ready), "Ready", "Ready", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resize) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resize{`,
		`Width:` + fmt.Sprintf("%v", this.Width) + `,`,
		`Height:` + fmt.Sprintf("%v", this.Height) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Ready) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Ready{`,
		`}`,
	}, "")
	return s
}
func valueToStringTerminal(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *SessionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTerminal
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stdout", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTerminal
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTerminal
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Msg = &SessionRequest_Stdout{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stderr", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTerminal
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTerminal
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Msg = &SessionRequest_Stderr{v}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exit", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Msg = &SessionRequest_Exit{v}
		default:
			iNdEx = preIndex
			skippy, err := skipTerminal(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTerminal
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SessionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTerminal
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stdin", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTerminal
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthTerminal
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Msg = &SessionResponse_Stdin{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTerminal
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTerminal
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Resize{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Msg = &SessionResponse_Resize{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ready", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTerminal
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTerminal
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Ready{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Msg = &SessionResponse_Ready{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTerminal(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTerminal
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resize) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTerminal
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resize: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resize: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Width", wireType)
			}
			m.Width = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Width |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Height", wireType)
			}
			m.Height = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Height |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTerminal(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTerminal
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Ready) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTerminal
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ready: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ready: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTerminal(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthTerminal
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTerminal(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTerminal
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTerminal
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTerminal
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupTerminal
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthTerminal
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthTerminal        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTerminal          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupTerminal = fmt.Errorf("proto: unexpected end of group")
)
