// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/storage/v1/storage.proto

package storagepb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BigQueryRead_CreateReadSession_FullMethodName = "/google.cloud.bigquery.storage.v1.BigQueryRead/CreateReadSession"
	BigQueryRead_ReadRows_FullMethodName          = "/google.cloud.bigquery.storage.v1.BigQueryRead/ReadRows"
	BigQueryRead_SplitReadStream_FullMethodName   = "/google.cloud.bigquery.storage.v1.BigQueryRead/SplitReadStream"
)

// BigQueryReadClient is the client API for BigQueryRead service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BigQueryReadClient interface {
	// Creates a new read session. A read session divides the contents of a
	// BigQuery table into one or more streams, which can then be used to read
	// data from the table. The read session also specifies properties of the
	// data to be read, such as a list of columns or a push-down filter describing
	// the rows to be returned.
	//
	// A particular row can be read by at most one stream. When the caller has
	// reached the end of each stream in the session, then all the data in the
	// table has been read.
	//
	// Data is assigned to each stream such that roughly the same number of
	// rows can be read from each stream. Because the server-side unit for
	// assigning data is collections of rows, the API does not guarantee that
	// each stream will return the same number or rows. Additionally, the
	// limits are enforced based on the number of pre-filtered rows, so some
	// filters can lead to lopsided assignments.
	//
	// Read sessions automatically expire 6 hours after they are created and do
	// not require manual clean-up by the caller.
	CreateReadSession(ctx context.Context, in *CreateReadSessionRequest, opts ...grpc.CallOption) (*ReadSession, error)
	// Reads rows from the stream in the format prescribed by the ReadSession.
	// Each response contains one or more table rows, up to a maximum of 128 MB
	// per response; read requests which attempt to read individual rows larger
	// than 128 MB will fail.
	//
	// Each request also returns a set of stream statistics reflecting the current
	// state of the stream.
	ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigQueryRead_ReadRowsClient, error)
	// Splits a given `ReadStream` into two `ReadStream` objects. These
	// `ReadStream` objects are referred to as the primary and the residual
	// streams of the split. The original `ReadStream` can still be read from in
	// the same manner as before. Both of the returned `ReadStream` objects can
	// also be read from, and the rows returned by both child streams will be
	// the same as the rows read from the original stream.
	//
	// Moreover, the two child streams will be allocated back-to-back in the
	// original `ReadStream`. Concretely, it is guaranteed that for streams
	// original, primary, and residual, that original[0-j] = primary[0-j] and
	// original[j-n] = residual[0-m] once the streams have been read to
	// completion.
	SplitReadStream(ctx context.Context, in *SplitReadStreamRequest, opts ...grpc.CallOption) (*SplitReadStreamResponse, error)
}

type bigQueryReadClient struct {
	cc grpc.ClientConnInterface
}

func NewBigQueryReadClient(cc grpc.ClientConnInterface) BigQueryReadClient {
	return &bigQueryReadClient{cc}
}

func (c *bigQueryReadClient) CreateReadSession(ctx context.Context, in *CreateReadSessionRequest, opts ...grpc.CallOption) (*ReadSession, error) {
	out := new(ReadSession)
	err := c.cc.Invoke(ctx, BigQueryRead_CreateReadSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryReadClient) ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigQueryRead_ReadRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &BigQueryRead_ServiceDesc.Streams[0], BigQueryRead_ReadRows_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigQueryReadReadRowsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BigQueryRead_ReadRowsClient interface {
	Recv() (*ReadRowsResponse, error)
	grpc.ClientStream
}

type bigQueryReadReadRowsClient struct {
	grpc.ClientStream
}

func (x *bigQueryReadReadRowsClient) Recv() (*ReadRowsResponse, error) {
	m := new(ReadRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigQueryReadClient) SplitReadStream(ctx context.Context, in *SplitReadStreamRequest, opts ...grpc.CallOption) (*SplitReadStreamResponse, error) {
	out := new(SplitReadStreamResponse)
	err := c.cc.Invoke(ctx, BigQueryRead_SplitReadStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigQueryReadServer is the server API for BigQueryRead service.
// All implementations should embed UnimplementedBigQueryReadServer
// for forward compatibility
type BigQueryReadServer interface {
	// Creates a new read session. A read session divides the contents of a
	// BigQuery table into one or more streams, which can then be used to read
	// data from the table. The read session also specifies properties of the
	// data to be read, such as a list of columns or a push-down filter describing
	// the rows to be returned.
	//
	// A particular row can be read by at most one stream. When the caller has
	// reached the end of each stream in the session, then all the data in the
	// table has been read.
	//
	// Data is assigned to each stream such that roughly the same number of
	// rows can be read from each stream. Because the server-side unit for
	// assigning data is collections of rows, the API does not guarantee that
	// each stream will return the same number or rows. Additionally, the
	// limits are enforced based on the number of pre-filtered rows, so some
	// filters can lead to lopsided assignments.
	//
	// Read sessions automatically expire 6 hours after they are created and do
	// not require manual clean-up by the caller.
	CreateReadSession(context.Context, *CreateReadSessionRequest) (*ReadSession, error)
	// Reads rows from the stream in the format prescribed by the ReadSession.
	// Each response contains one or more table rows, up to a maximum of 128 MB
	// per response; read requests which attempt to read individual rows larger
	// than 128 MB will fail.
	//
	// Each request also returns a set of stream statistics reflecting the current
	// state of the stream.
	ReadRows(*ReadRowsRequest, BigQueryRead_ReadRowsServer) error
	// Splits a given `ReadStream` into two `ReadStream` objects. These
	// `ReadStream` objects are referred to as the primary and the residual
	// streams of the split. The original `ReadStream` can still be read from in
	// the same manner as before. Both of the returned `ReadStream` objects can
	// also be read from, and the rows returned by both child streams will be
	// the same as the rows read from the original stream.
	//
	// Moreover, the two child streams will be allocated back-to-back in the
	// original `ReadStream`. Concretely, it is guaranteed that for streams
	// original, primary, and residual, that original[0-j] = primary[0-j] and
	// original[j-n] = residual[0-m] once the streams have been read to
	// completion.
	SplitReadStream(context.Context, *SplitReadStreamRequest) (*SplitReadStreamResponse, error)
}

// UnimplementedBigQueryReadServer should be embedded to have forward compatible implementations.
type UnimplementedBigQueryReadServer struct {
}

func (UnimplementedBigQueryReadServer) CreateReadSession(context.Context, *CreateReadSessionRequest) (*ReadSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReadSession not implemented")
}
func (UnimplementedBigQueryReadServer) ReadRows(*ReadRowsRequest, BigQueryRead_ReadRowsServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadRows not implemented")
}
func (UnimplementedBigQueryReadServer) SplitReadStream(context.Context, *SplitReadStreamRequest) (*SplitReadStreamResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SplitReadStream not implemented")
}

// UnsafeBigQueryReadServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BigQueryReadServer will
// result in compilation errors.
type UnsafeBigQueryReadServer interface {
	mustEmbedUnimplementedBigQueryReadServer()
}

func RegisterBigQueryReadServer(s grpc.ServiceRegistrar, srv BigQueryReadServer) {
	s.RegisterService(&BigQueryRead_ServiceDesc, srv)
}

func _BigQueryRead_CreateReadSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReadSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryReadServer).CreateReadSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryRead_CreateReadSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryReadServer).CreateReadSession(ctx, req.(*CreateReadSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryRead_ReadRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRowsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigQueryReadServer).ReadRows(m, &bigQueryReadReadRowsServer{stream})
}

type BigQueryRead_ReadRowsServer interface {
	Send(*ReadRowsResponse) error
	grpc.ServerStream
}

type bigQueryReadReadRowsServer struct {
	grpc.ServerStream
}

func (x *bigQueryReadReadRowsServer) Send(m *ReadRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BigQueryRead_SplitReadStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitReadStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryReadServer).SplitReadStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryRead_SplitReadStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryReadServer).SplitReadStream(ctx, req.(*SplitReadStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BigQueryRead_ServiceDesc is the grpc.ServiceDesc for BigQueryRead service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BigQueryRead_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1.BigQueryRead",
	HandlerType: (*BigQueryReadServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReadSession",
			Handler:    _BigQueryRead_CreateReadSession_Handler,
		},
		{
			MethodName: "SplitReadStream",
			Handler:    _BigQueryRead_SplitReadStream_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadRows",
			Handler:       _BigQueryRead_ReadRows_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1/storage.proto",
}

const (
	BigQueryWrite_CreateWriteStream_FullMethodName       = "/google.cloud.bigquery.storage.v1.BigQueryWrite/CreateWriteStream"
	BigQueryWrite_AppendRows_FullMethodName              = "/google.cloud.bigquery.storage.v1.BigQueryWrite/AppendRows"
	BigQueryWrite_GetWriteStream_FullMethodName          = "/google.cloud.bigquery.storage.v1.BigQueryWrite/GetWriteStream"
	BigQueryWrite_FinalizeWriteStream_FullMethodName     = "/google.cloud.bigquery.storage.v1.BigQueryWrite/FinalizeWriteStream"
	BigQueryWrite_BatchCommitWriteStreams_FullMethodName = "/google.cloud.bigquery.storage.v1.BigQueryWrite/BatchCommitWriteStreams"
	BigQueryWrite_FlushRows_FullMethodName               = "/google.cloud.bigquery.storage.v1.BigQueryWrite/FlushRows"
)

// BigQueryWriteClient is the client API for BigQueryWrite service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BigQueryWriteClient interface {
	// Creates a write stream to the given table.
	// Additionally, every table has a special stream named '_default'
	// to which data can be written. This stream doesn't need to be created using
	// CreateWriteStream. It is a stream that can be used simultaneously by any
	// number of clients. Data written to this stream is considered committed as
	// soon as an acknowledgement is received.
	CreateWriteStream(ctx context.Context, in *CreateWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error)
	// Appends data to the given stream.
	//
	// If `offset` is specified, the `offset` is checked against the end of
	// stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
	// attempt is made to append to an offset beyond the current end of the stream
	// or `ALREADY_EXISTS` if user provides an `offset` that has already been
	// written to. User can retry with adjusted offset within the same RPC
	// connection. If `offset` is not specified, append happens at the end of the
	// stream.
	//
	// The response contains an optional offset at which the append
	// happened.  No offset information will be returned for appends to a
	// default stream.
	//
	// Responses are received in the same order in which requests are sent.
	// There will be one response for each successful inserted request.  Responses
	// may optionally embed error information if the originating AppendRequest was
	// not successfully processed.
	//
	// The specifics of when successfully appended data is made visible to the
	// table are governed by the type of stream:
	//
	// * For COMMITTED streams (which includes the default stream), data is
	// visible immediately upon successful append.
	//
	// * For BUFFERED streams, data is made visible via a subsequent `FlushRows`
	// rpc which advances a cursor to a newer offset in the stream.
	//
	// * For PENDING streams, data is not made visible until the stream itself is
	// finalized (via the `FinalizeWriteStream` rpc), and the stream is explicitly
	// committed via the `BatchCommitWriteStreams` rpc.
	AppendRows(ctx context.Context, opts ...grpc.CallOption) (BigQueryWrite_AppendRowsClient, error)
	// Gets information about a write stream.
	GetWriteStream(ctx context.Context, in *GetWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error)
	// Finalize a write stream so that no new data can be appended to the
	// stream. Finalize is not supported on the '_default' stream.
	FinalizeWriteStream(ctx context.Context, in *FinalizeWriteStreamRequest, opts ...grpc.CallOption) (*FinalizeWriteStreamResponse, error)
	// Atomically commits a group of `PENDING` streams that belong to the same
	// `parent` table.
	//
	// Streams must be finalized before commit and cannot be committed multiple
	// times. Once a stream is committed, data in the stream becomes available
	// for read operations.
	BatchCommitWriteStreams(ctx context.Context, in *BatchCommitWriteStreamsRequest, opts ...grpc.CallOption) (*BatchCommitWriteStreamsResponse, error)
	// Flushes rows to a BUFFERED stream.
	//
	// If users are appending rows to BUFFERED stream, flush operation is
	// required in order for the rows to become available for reading. A
	// Flush operation flushes up to any previously flushed offset in a BUFFERED
	// stream, to the offset specified in the request.
	//
	// Flush is not supported on the _default stream, since it is not BUFFERED.
	FlushRows(ctx context.Context, in *FlushRowsRequest, opts ...grpc.CallOption) (*FlushRowsResponse, error)
}

type bigQueryWriteClient struct {
	cc grpc.ClientConnInterface
}

func NewBigQueryWriteClient(cc grpc.ClientConnInterface) BigQueryWriteClient {
	return &bigQueryWriteClient{cc}
}

func (c *bigQueryWriteClient) CreateWriteStream(ctx context.Context, in *CreateWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error) {
	out := new(WriteStream)
	err := c.cc.Invoke(ctx, BigQueryWrite_CreateWriteStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) AppendRows(ctx context.Context, opts ...grpc.CallOption) (BigQueryWrite_AppendRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &BigQueryWrite_ServiceDesc.Streams[0], BigQueryWrite_AppendRows_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigQueryWriteAppendRowsClient{stream}
	return x, nil
}

type BigQueryWrite_AppendRowsClient interface {
	Send(*AppendRowsRequest) error
	Recv() (*AppendRowsResponse, error)
	grpc.ClientStream
}

type bigQueryWriteAppendRowsClient struct {
	grpc.ClientStream
}

func (x *bigQueryWriteAppendRowsClient) Send(m *AppendRowsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *bigQueryWriteAppendRowsClient) Recv() (*AppendRowsResponse, error) {
	m := new(AppendRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigQueryWriteClient) GetWriteStream(ctx context.Context, in *GetWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error) {
	out := new(WriteStream)
	err := c.cc.Invoke(ctx, BigQueryWrite_GetWriteStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) FinalizeWriteStream(ctx context.Context, in *FinalizeWriteStreamRequest, opts ...grpc.CallOption) (*FinalizeWriteStreamResponse, error) {
	out := new(FinalizeWriteStreamResponse)
	err := c.cc.Invoke(ctx, BigQueryWrite_FinalizeWriteStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) BatchCommitWriteStreams(ctx context.Context, in *BatchCommitWriteStreamsRequest, opts ...grpc.CallOption) (*BatchCommitWriteStreamsResponse, error) {
	out := new(BatchCommitWriteStreamsResponse)
	err := c.cc.Invoke(ctx, BigQueryWrite_BatchCommitWriteStreams_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) FlushRows(ctx context.Context, in *FlushRowsRequest, opts ...grpc.CallOption) (*FlushRowsResponse, error) {
	out := new(FlushRowsResponse)
	err := c.cc.Invoke(ctx, BigQueryWrite_FlushRows_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigQueryWriteServer is the server API for BigQueryWrite service.
// All implementations should embed UnimplementedBigQueryWriteServer
// for forward compatibility
type BigQueryWriteServer interface {
	// Creates a write stream to the given table.
	// Additionally, every table has a special stream named '_default'
	// to which data can be written. This stream doesn't need to be created using
	// CreateWriteStream. It is a stream that can be used simultaneously by any
	// number of clients. Data written to this stream is considered committed as
	// soon as an acknowledgement is received.
	CreateWriteStream(context.Context, *CreateWriteStreamRequest) (*WriteStream, error)
	// Appends data to the given stream.
	//
	// If `offset` is specified, the `offset` is checked against the end of
	// stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
	// attempt is made to append to an offset beyond the current end of the stream
	// or `ALREADY_EXISTS` if user provides an `offset` that has already been
	// written to. User can retry with adjusted offset within the same RPC
	// connection. If `offset` is not specified, append happens at the end of the
	// stream.
	//
	// The response contains an optional offset at which the append
	// happened.  No offset information will be returned for appends to a
	// default stream.
	//
	// Responses are received in the same order in which requests are sent.
	// There will be one response for each successful inserted request.  Responses
	// may optionally embed error information if the originating AppendRequest was
	// not successfully processed.
	//
	// The specifics of when successfully appended data is made visible to the
	// table are governed by the type of stream:
	//
	// * For COMMITTED streams (which includes the default stream), data is
	// visible immediately upon successful append.
	//
	// * For BUFFERED streams, data is made visible via a subsequent `FlushRows`
	// rpc which advances a cursor to a newer offset in the stream.
	//
	// * For PENDING streams, data is not made visible until the stream itself is
	// finalized (via the `FinalizeWriteStream` rpc), and the stream is explicitly
	// committed via the `BatchCommitWriteStreams` rpc.
	AppendRows(BigQueryWrite_AppendRowsServer) error
	// Gets information about a write stream.
	GetWriteStream(context.Context, *GetWriteStreamRequest) (*WriteStream, error)
	// Finalize a write stream so that no new data can be appended to the
	// stream. Finalize is not supported on the '_default' stream.
	FinalizeWriteStream(context.Context, *FinalizeWriteStreamRequest) (*FinalizeWriteStreamResponse, error)
	// Atomically commits a group of `PENDING` streams that belong to the same
	// `parent` table.
	//
	// Streams must be finalized before commit and cannot be committed multiple
	// times. Once a stream is committed, data in the stream becomes available
	// for read operations.
	BatchCommitWriteStreams(context.Context, *BatchCommitWriteStreamsRequest) (*BatchCommitWriteStreamsResponse, error)
	// Flushes rows to a BUFFERED stream.
	//
	// If users are appending rows to BUFFERED stream, flush operation is
	// required in order for the rows to become available for reading. A
	// Flush operation flushes up to any previously flushed offset in a BUFFERED
	// stream, to the offset specified in the request.
	//
	// Flush is not supported on the _default stream, since it is not BUFFERED.
	FlushRows(context.Context, *FlushRowsRequest) (*FlushRowsResponse, error)
}

// UnimplementedBigQueryWriteServer should be embedded to have forward compatible implementations.
type UnimplementedBigQueryWriteServer struct {
}

func (UnimplementedBigQueryWriteServer) CreateWriteStream(context.Context, *CreateWriteStreamRequest) (*WriteStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWriteStream not implemented")
}
func (UnimplementedBigQueryWriteServer) AppendRows(BigQueryWrite_AppendRowsServer) error {
	return status.Errorf(codes.Unimplemented, "method AppendRows not implemented")
}
func (UnimplementedBigQueryWriteServer) GetWriteStream(context.Context, *GetWriteStreamRequest) (*WriteStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWriteStream not implemented")
}
func (UnimplementedBigQueryWriteServer) FinalizeWriteStream(context.Context, *FinalizeWriteStreamRequest) (*FinalizeWriteStreamResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeWriteStream not implemented")
}
func (UnimplementedBigQueryWriteServer) BatchCommitWriteStreams(context.Context, *BatchCommitWriteStreamsRequest) (*BatchCommitWriteStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCommitWriteStreams not implemented")
}
func (UnimplementedBigQueryWriteServer) FlushRows(context.Context, *FlushRowsRequest) (*FlushRowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FlushRows not implemented")
}

// UnsafeBigQueryWriteServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BigQueryWriteServer will
// result in compilation errors.
type UnsafeBigQueryWriteServer interface {
	mustEmbedUnimplementedBigQueryWriteServer()
}

func RegisterBigQueryWriteServer(s grpc.ServiceRegistrar, srv BigQueryWriteServer) {
	s.RegisterService(&BigQueryWrite_ServiceDesc, srv)
}

func _BigQueryWrite_CreateWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).CreateWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryWrite_CreateWriteStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).CreateWriteStream(ctx, req.(*CreateWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_AppendRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BigQueryWriteServer).AppendRows(&bigQueryWriteAppendRowsServer{stream})
}

type BigQueryWrite_AppendRowsServer interface {
	Send(*AppendRowsResponse) error
	Recv() (*AppendRowsRequest, error)
	grpc.ServerStream
}

type bigQueryWriteAppendRowsServer struct {
	grpc.ServerStream
}

func (x *bigQueryWriteAppendRowsServer) Send(m *AppendRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *bigQueryWriteAppendRowsServer) Recv() (*AppendRowsRequest, error) {
	m := new(AppendRowsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _BigQueryWrite_GetWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).GetWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryWrite_GetWriteStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).GetWriteStream(ctx, req.(*GetWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_FinalizeWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).FinalizeWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryWrite_FinalizeWriteStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).FinalizeWriteStream(ctx, req.(*FinalizeWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_BatchCommitWriteStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCommitWriteStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).BatchCommitWriteStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryWrite_BatchCommitWriteStreams_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).BatchCommitWriteStreams(ctx, req.(*BatchCommitWriteStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_FlushRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FlushRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).FlushRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryWrite_FlushRows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).FlushRows(ctx, req.(*FlushRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BigQueryWrite_ServiceDesc is the grpc.ServiceDesc for BigQueryWrite service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BigQueryWrite_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1.BigQueryWrite",
	HandlerType: (*BigQueryWriteServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWriteStream",
			Handler:    _BigQueryWrite_CreateWriteStream_Handler,
		},
		{
			MethodName: "GetWriteStream",
			Handler:    _BigQueryWrite_GetWriteStream_Handler,
		},
		{
			MethodName: "FinalizeWriteStream",
			Handler:    _BigQueryWrite_FinalizeWriteStream_Handler,
		},
		{
			MethodName: "BatchCommitWriteStreams",
			Handler:    _BigQueryWrite_BatchCommitWriteStreams_Handler,
		},
		{
			MethodName: "FlushRows",
			Handler:    _BigQueryWrite_FlushRows_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "AppendRows",
			Handler:       _BigQueryWrite_AppendRows_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1/storage.proto",
}
