// This file is generated by kconfig_compiler_kf6 from easyeffects_db_echo_canceller.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_ECHOCANCELLER_H
#define DB_ECHOCANCELLER_H

#include <kconfig_base_ee.hpp>

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace db {

class EchoCanceller : public KConfigBaseEE
{
  Q_OBJECT
  public:

    EchoCanceller( const QString & masterGroup, const QString & instanceIndex );
    ~EchoCanceller() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set enableEchoCanceller
    */
    void setEnableEchoCanceller( bool v )
    {
      if (v != mEnableEchoCanceller && !isEnableEchoCancellerImmutable()) {
        mEnableEchoCanceller = v;
        Q_EMIT enableEchoCancellerChanged();
      }
    }

    Q_PROPERTY(bool enableEchoCanceller READ enableEchoCanceller WRITE setEnableEchoCanceller NOTIFY enableEchoCancellerChanged)
    Q_PROPERTY(bool isEnableEchoCancellerImmutable READ isEnableEchoCancellerImmutable CONSTANT)
    Q_PROPERTY(bool defaultEnableEchoCancellerValue READ defaultEnableEchoCancellerValue CONSTANT)
    /**
      Get enableEchoCanceller
    */
    bool enableEchoCanceller() const
    {
      return mEnableEchoCanceller;
    }

    /**
      Is enableEchoCanceller Immutable
    */
    bool isEnableEchoCancellerImmutable() const
    {
      return isImmutable( QStringLiteral( "enableEchoCanceller" ) );
    }

    /**
      Get enableEchoCanceller default value
    */
    bool defaultEnableEchoCancellerValue() const
    {
        return defaultEnableEchoCancellerValue_helper();
    }

    /**
      Set echoCancellerMobileMode
    */
    void setEchoCancellerMobileMode( bool v )
    {
      if (v != mEchoCancellerMobileMode && !isEchoCancellerMobileModeImmutable()) {
        mEchoCancellerMobileMode = v;
        Q_EMIT echoCancellerMobileModeChanged();
      }
    }

    Q_PROPERTY(bool echoCancellerMobileMode READ echoCancellerMobileMode WRITE setEchoCancellerMobileMode NOTIFY echoCancellerMobileModeChanged)
    Q_PROPERTY(bool isEchoCancellerMobileModeImmutable READ isEchoCancellerMobileModeImmutable CONSTANT)
    Q_PROPERTY(bool defaultEchoCancellerMobileModeValue READ defaultEchoCancellerMobileModeValue CONSTANT)
    /**
      Get echoCancellerMobileMode
    */
    bool echoCancellerMobileMode() const
    {
      return mEchoCancellerMobileMode;
    }

    /**
      Is echoCancellerMobileMode Immutable
    */
    bool isEchoCancellerMobileModeImmutable() const
    {
      return isImmutable( QStringLiteral( "echoCancellerMobileMode" ) );
    }

    /**
      Get echoCancellerMobileMode default value
    */
    bool defaultEchoCancellerMobileModeValue() const
    {
        return defaultEchoCancellerMobileModeValue_helper();
    }

    /**
      Set echoCancellerEnforceHighPass
    */
    void setEchoCancellerEnforceHighPass( bool v )
    {
      if (v != mEchoCancellerEnforceHighPass && !isEchoCancellerEnforceHighPassImmutable()) {
        mEchoCancellerEnforceHighPass = v;
        Q_EMIT echoCancellerEnforceHighPassChanged();
      }
    }

    Q_PROPERTY(bool echoCancellerEnforceHighPass READ echoCancellerEnforceHighPass WRITE setEchoCancellerEnforceHighPass NOTIFY echoCancellerEnforceHighPassChanged)
    Q_PROPERTY(bool isEchoCancellerEnforceHighPassImmutable READ isEchoCancellerEnforceHighPassImmutable CONSTANT)
    Q_PROPERTY(bool defaultEchoCancellerEnforceHighPassValue READ defaultEchoCancellerEnforceHighPassValue CONSTANT)
    /**
      Get echoCancellerEnforceHighPass
    */
    bool echoCancellerEnforceHighPass() const
    {
      return mEchoCancellerEnforceHighPass;
    }

    /**
      Is echoCancellerEnforceHighPass Immutable
    */
    bool isEchoCancellerEnforceHighPassImmutable() const
    {
      return isImmutable( QStringLiteral( "echoCancellerEnforceHighPass" ) );
    }

    /**
      Get echoCancellerEnforceHighPass default value
    */
    bool defaultEchoCancellerEnforceHighPassValue() const
    {
        return defaultEchoCancellerEnforceHighPassValue_helper();
    }

    /**
      Set enableNoiseSuppression
    */
    void setEnableNoiseSuppression( bool v )
    {
      if (v != mEnableNoiseSuppression && !isEnableNoiseSuppressionImmutable()) {
        mEnableNoiseSuppression = v;
        Q_EMIT enableNoiseSuppressionChanged();
      }
    }

    Q_PROPERTY(bool enableNoiseSuppression READ enableNoiseSuppression WRITE setEnableNoiseSuppression NOTIFY enableNoiseSuppressionChanged)
    Q_PROPERTY(bool isEnableNoiseSuppressionImmutable READ isEnableNoiseSuppressionImmutable CONSTANT)
    Q_PROPERTY(bool defaultEnableNoiseSuppressionValue READ defaultEnableNoiseSuppressionValue CONSTANT)
    /**
      Get enableNoiseSuppression
    */
    bool enableNoiseSuppression() const
    {
      return mEnableNoiseSuppression;
    }

    /**
      Is enableNoiseSuppression Immutable
    */
    bool isEnableNoiseSuppressionImmutable() const
    {
      return isImmutable( QStringLiteral( "enableNoiseSuppression" ) );
    }

    /**
      Get enableNoiseSuppression default value
    */
    bool defaultEnableNoiseSuppressionValue() const
    {
        return defaultEnableNoiseSuppressionValue_helper();
    }

    /**
      Set noiseSuppressionLevelLabels
    */
    void setNoiseSuppressionLevelLabels( const QStringList & v )
    {
      if (v != mNoiseSuppressionLevelLabels && !isNoiseSuppressionLevelLabelsImmutable()) {
        mNoiseSuppressionLevelLabels = v;
        Q_EMIT noiseSuppressionLevelLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList noiseSuppressionLevelLabels READ noiseSuppressionLevelLabels WRITE setNoiseSuppressionLevelLabels NOTIFY noiseSuppressionLevelLabelsChanged)
    Q_PROPERTY(bool isNoiseSuppressionLevelLabelsImmutable READ isNoiseSuppressionLevelLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultNoiseSuppressionLevelLabelsValue READ defaultNoiseSuppressionLevelLabelsValue CONSTANT)
    /**
      Get noiseSuppressionLevelLabels
    */
    QStringList noiseSuppressionLevelLabels() const
    {
      return mNoiseSuppressionLevelLabels;
    }

    /**
      Is noiseSuppressionLevelLabels Immutable
    */
    bool isNoiseSuppressionLevelLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "noiseSuppressionLevelLabels" ) );
    }

    /**
      Get noiseSuppressionLevelLabels default value
    */
    QStringList defaultNoiseSuppressionLevelLabelsValue() const
    {
        return defaultNoiseSuppressionLevelLabelsValue_helper();
    }

    /**
      Set Noise Suppression Level
    */
    void setNoiseSuppressionLevel( int v )
    {
      if (v != mNoiseSuppressionLevel && !isNoiseSuppressionLevelImmutable()) {
        mNoiseSuppressionLevel = v;
        Q_EMIT noiseSuppressionLevelChanged();
      }
    }

    Q_PROPERTY(int noiseSuppressionLevel READ noiseSuppressionLevel WRITE setNoiseSuppressionLevel NOTIFY noiseSuppressionLevelChanged)
    Q_PROPERTY(bool isNoiseSuppressionLevelImmutable READ isNoiseSuppressionLevelImmutable CONSTANT)
    Q_PROPERTY(int defaultNoiseSuppressionLevelValue READ defaultNoiseSuppressionLevelValue CONSTANT)
    /**
      Get Noise Suppression Level
    */
    int noiseSuppressionLevel() const
    {
      return mNoiseSuppressionLevel;
    }

    /**
      Is Noise Suppression Level Immutable
    */
    bool isNoiseSuppressionLevelImmutable() const
    {
      return isImmutable( QStringLiteral( "noiseSuppressionLevel" ) );
    }

    /**
      Get Noise Suppression Level default value
    */
    int defaultNoiseSuppressionLevelValue() const
    {
        return defaultNoiseSuppressionLevelValue_helper();
    }

    /**
      Set enableHighPassFilter
    */
    void setEnableHighPassFilter( bool v )
    {
      if (v != mEnableHighPassFilter && !isEnableHighPassFilterImmutable()) {
        mEnableHighPassFilter = v;
        Q_EMIT enableHighPassFilterChanged();
      }
    }

    Q_PROPERTY(bool enableHighPassFilter READ enableHighPassFilter WRITE setEnableHighPassFilter NOTIFY enableHighPassFilterChanged)
    Q_PROPERTY(bool isEnableHighPassFilterImmutable READ isEnableHighPassFilterImmutable CONSTANT)
    Q_PROPERTY(bool defaultEnableHighPassFilterValue READ defaultEnableHighPassFilterValue CONSTANT)
    /**
      Get enableHighPassFilter
    */
    bool enableHighPassFilter() const
    {
      return mEnableHighPassFilter;
    }

    /**
      Is enableHighPassFilter Immutable
    */
    bool isEnableHighPassFilterImmutable() const
    {
      return isImmutable( QStringLiteral( "enableHighPassFilter" ) );
    }

    /**
      Get enableHighPassFilter default value
    */
    bool defaultEnableHighPassFilterValue() const
    {
        return defaultEnableHighPassFilterValue_helper();
    }

    /**
      Set highPassFilterFullBand
    */
    void setHighPassFilterFullBand( bool v )
    {
      if (v != mHighPassFilterFullBand && !isHighPassFilterFullBandImmutable()) {
        mHighPassFilterFullBand = v;
        Q_EMIT highPassFilterFullBandChanged();
      }
    }

    Q_PROPERTY(bool highPassFilterFullBand READ highPassFilterFullBand WRITE setHighPassFilterFullBand NOTIFY highPassFilterFullBandChanged)
    Q_PROPERTY(bool isHighPassFilterFullBandImmutable READ isHighPassFilterFullBandImmutable CONSTANT)
    Q_PROPERTY(bool defaultHighPassFilterFullBandValue READ defaultHighPassFilterFullBandValue CONSTANT)
    /**
      Get highPassFilterFullBand
    */
    bool highPassFilterFullBand() const
    {
      return mHighPassFilterFullBand;
    }

    /**
      Is highPassFilterFullBand Immutable
    */
    bool isHighPassFilterFullBandImmutable() const
    {
      return isImmutable( QStringLiteral( "highPassFilterFullBand" ) );
    }

    /**
      Get highPassFilterFullBand default value
    */
    bool defaultHighPassFilterFullBandValue() const
    {
        return defaultHighPassFilterFullBandValue_helper();
    }

    /**
      Set enableAGC
    */
    void setEnableAGC( bool v )
    {
      if (v != mEnableAGC && !isEnableAGCImmutable()) {
        mEnableAGC = v;
        Q_EMIT enableAGCChanged();
      }
    }

    Q_PROPERTY(bool enableAGC READ enableAGC WRITE setEnableAGC NOTIFY enableAGCChanged)
    Q_PROPERTY(bool isEnableAGCImmutable READ isEnableAGCImmutable CONSTANT)
    Q_PROPERTY(bool defaultEnableAGCValue READ defaultEnableAGCValue CONSTANT)
    /**
      Get enableAGC
    */
    bool enableAGC() const
    {
      return mEnableAGC;
    }

    /**
      Is enableAGC Immutable
    */
    bool isEnableAGCImmutable() const
    {
      return isImmutable( QStringLiteral( "enableAGC" ) );
    }

    /**
      Get enableAGC default value
    */
    bool defaultEnableAGCValue() const
    {
        return defaultEnableAGCValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalEnableEchoCancellerChanged = 4,
      signalEchoCancellerMobileModeChanged = 5,
      signalEchoCancellerEnforceHighPassChanged = 6,
      signalEnableNoiseSuppressionChanged = 7,
      signalNoiseSuppressionLevelLabelsChanged = 8,
      signalNoiseSuppressionLevelChanged = 9,
      signalEnableHighPassFilterChanged = 10,
      signalHighPassFilterFullBandChanged = 11,
      signalEnableAGCChanged = 12
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void enableEchoCancellerChanged();

    void echoCancellerMobileModeChanged();

    void echoCancellerEnforceHighPassChanged();

    void enableNoiseSuppressionChanged();

    void noiseSuppressionLevelLabelsChanged();

    void noiseSuppressionLevelChanged();

    void enableHighPassFilterChanged();

    void highPassFilterFullBandChanged();

    void enableAGCChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // EchoCanceller#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    bool mEnableEchoCanceller;
    bool defaultEnableEchoCancellerValue_helper() const;
    bool mEchoCancellerMobileMode;
    bool defaultEchoCancellerMobileModeValue_helper() const;
    bool mEchoCancellerEnforceHighPass;
    bool defaultEchoCancellerEnforceHighPassValue_helper() const;
    bool mEnableNoiseSuppression;
    bool defaultEnableNoiseSuppressionValue_helper() const;
    QStringList mNoiseSuppressionLevelLabels;
    QStringList defaultNoiseSuppressionLevelLabelsValue_helper() const;
    int mNoiseSuppressionLevel;
    int defaultNoiseSuppressionLevelValue_helper() const;
    bool mEnableHighPassFilter;
    bool defaultEnableHighPassFilterValue_helper() const;
    bool mHighPassFilterFullBand;
    bool defaultHighPassFilterFullBandValue_helper() const;
    bool mEnableAGC;
    bool defaultEnableAGCValue_helper() const;

  private:
};

}

#endif

