#ifndef YCF_YIELDING_C_FUN_HELPERS
#define YCF_YIELDING_C_FUN_HELPERS 1
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/*
 * YCF_GCC_DIAG_ON and YCF_GCC_DIAG_OFF can be used to temporarly
 * disable a gcc or clang warning in a file.
 *
 * Example:
 * YCF_GCC_DIAG_OFF(unused-function)
 * static int test(){ return 0;}
 * YCF_GCC_DIAG_ON(unused-function)
 *
 * These macros were originally authored by Jonathan Wakely and has
 * been modified by Patrick Horgan.
 *
 * Source: http://dbp-consulting.com/tutorials/SuppressingGCCWarnings.html
 *
 */
#if defined(_MSC_VER)
#  define YCF_GCC_DIAG_OFF(x) __pragma(warning(push, 0))
#  define YCF_GCC_DIAG_ON(x)  __pragma(warning(pop))
#elif ((__GNUC__ * 100) + __GNUC_MINOR__) >= 402
#define YCF_GCC_DIAG_STR(s) #s
#define YCF_GCC_DIAG_JOINSTR(x,y) YCF_GCC_DIAG_STR(x ## y)
# define YCF_GCC_DIAG_DO_PRAGMA(x) _Pragma (#x)
# define YCF_GCC_DIAG_PRAGMA(x) YCF_GCC_DIAG_DO_PRAGMA(GCC diagnostic x)
# if ((__GNUC__ * 100) + __GNUC_MINOR__) >= 406
#  define YCF_GCC_DIAG_OFF(x) YCF_GCC_DIAG_PRAGMA(push) \
      YCF_GCC_DIAG_PRAGMA(ignored YCF_GCC_DIAG_JOINSTR(-W,x))
#  define YCF_GCC_DIAG_ON(x) YCF_GCC_DIAG_PRAGMA(pop)
# else
#  define YCF_GCC_DIAG_OFF(x) YCF_GCC_DIAG_PRAGMA(ignored YCF_GCC_DIAG_JOINSTR(-W,x))
#  define YCF_GCC_DIAG_ON(x)  YCF_GCC_DIAG_PRAGMA(warning YCF_GCC_DIAG_JOINSTR(-W,x))
# endif
#else
# define YCF_GCC_DIAG_OFF(x)
# define YCF_GCC_DIAG_ON(x)
#endif
#ifdef __GNUC__
#  if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ > 5) || defined(__clang__)
#    define YCF_GCC_ATTRIBUTE_UNUSED __attribute__ ((unused))
#  else
#    define YCF_GCC_ATTRIBUTE_UNUSED
#  endif
#else
#  define YCF_GCC_ATTRIBUTE_UNUSED
#endif

typedef void* (*ycf_yield_alloc_type) (size_t,void*);
typedef void (*ycf_yield_free_type) (void*,void*);

struct ycf_alloc_data {
  size_t size;
  size_t max_size;
  int needs_freeing;
  char* data;
};

#define YCF_ALLOC_NEXT_BLOCK() (\
 ycf_frame_alloc_data.data == NULL \
   ? NULL \
   : ((void*)(&ycf_frame_alloc_data.data[ycf_frame_alloc_data.size]))\
)
#define YCF_ALLOC_NEXT_MAX_SIZE() (\
 ycf_frame_alloc_data.data == NULL \
   ? ycf_frame_alloc_data.max_size \
   : (ycf_frame_alloc_data.max_size - ycf_frame_alloc_data.size)\
)

/* Macros for special code sections */
#define ON_SAVE_YIELD_STATE ON_SAVE_YIELD_STATE
#define ON_RESTORE_YIELD_STATE ON_RESTORE_YIELD_STATE
#define ON_DESTROY_STATE ON_DESTROY_STATE
#define ON_RETURN ON_RETURN
#define ON_DESTROY_STATE_OR_RETURN ON_DESTROY_STATE_OR_RETURN
#define YCF_SPECIAL_CODE_START(PARAM) \
   /*special_code_start:PARAM*/       \
   if(0){
#define YCF_SPECIAL_CODE_END() \
   }\
   /*special_code_end*/

YCF_GCC_ATTRIBUTE_UNUSED
static void* ycf_stack_alloc(size_t size,
                             struct ycf_alloc_data* data,
                             ycf_yield_alloc_type allocator,
                             void* ycf_yield_alloc_free_context,
                             size_t default_stack_size){
  void * ret = NULL;
  if (data->data == NULL) {
    if (default_stack_size == 0) {
      fprintf(stderr, "ycf_alloc: not enough stack!! (max size = 0)\n");
      exit(1);
    }
    data->data = allocator(default_stack_size, ycf_yield_alloc_free_context);
    data->needs_freeing = 1;
    data->max_size = default_stack_size;
    data->size = 0;
  }
  if (data->size + size > data->max_size) {
    fprintf(stderr, "ycf_alloc: not enough stack! (max size = %zu)\n", default_stack_size);
    exit(1);
  }
  ret = &data->data[data->size];
  data->size = data->size + size + (sizeof(void * ) - (size % sizeof(void * ))) % sizeof(void * );
  return ret;
}
YCF_GCC_ATTRIBUTE_UNUSED
static void ycf_destroy_stack_allocator(struct ycf_alloc_data* data,
                                        ycf_yield_free_type freer,
                                        void* ycf_yield_alloc_free_context){
  if(data->needs_freeing){
    freer(data->data, ycf_yield_alloc_free_context);
  }
}


#include <limits.h>
#define YCF_MAX_NR_OF_REDS LONG_MAX
#define YCF_NR_OF_REDS_LEFT() ycf_nr_of_reductions
#define YCF_SET_NR_OF_REDS_LEFT(NEW_NR_OF_REDS_LEFT) \
  do{ycf_nr_of_reductions = (NEW_NR_OF_REDS_LEFT);}while(0)

#define YCF_GET_EXTRA_CONTEXT() ycf_extra_context

#define YCF_IS_YIELDED(CTX) (CTX != NULL)

#define YCF_YIELD_CODE_GENERATED 1


/* end of YCF_YIELDING_C_FUN_HELPERS guard */
#endif



struct gen_ycf_trap_state_for_hashmap_from_validated_list;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_from_validated_list_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_from_validated_list_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

static Eterm hashmap_from_validated_list_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process *p_N218_N240,
                                         Eterm list_N219_N241,
                                         Eterm fill_value_N220_N242,
                                         Uint size_N221_N243);



struct gen_ycf_trap_state_for_maps_from_list_1_helper;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  BIF_RETTYPE  maps_from_list_1_helper_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void maps_from_list_1_helper_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

static BIF_RETTYPE maps_from_list_1_helper_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N191_N199, Eterm* bif_args_N192_N200);



struct gen_ycf_trap_state_for_maps_from_keys_2_helper;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  BIF_RETTYPE  maps_from_keys_2_helper_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void maps_from_keys_2_helper_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

static BIF_RETTYPE maps_from_keys_2_helper_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N176_N184, Eterm* bif_args_N177_N185);



struct gen_ycf_trap_state_for_maps_values_1_helper;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  BIF_RETTYPE  maps_values_1_helper_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void maps_values_1_helper_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

static BIF_RETTYPE maps_values_1_helper_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N159_N169, Eterm* bif_args_N160_N170);



struct gen_ycf_trap_state_for_maps_keys_1_helper;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  BIF_RETTYPE  maps_keys_1_helper_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void maps_keys_1_helper_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

static BIF_RETTYPE maps_keys_1_helper_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N140_N150, Eterm* bif_args_N141_N151);



struct gen_ycf_trap_state_for_hashmap_from_chunked_array;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_from_chunked_array_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_from_chunked_array_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */



/* **Important Note**
 *
 * A yielding version of this function is generated with YCF. This
 * means that the code has to follow some restrictions. See note about
 * YCF near the top of the file for more information.
 */
static Eterm hashmap_from_chunked_array_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,ErtsHeapFactory *factory_N105_N128, hxnode_t *hxns_N106_N129, Uint n_N107_N130,
                                        Uint size_N108_N131,
                                        ErtsAlcType_t temp_memory_allocator_N109_N132);



struct gen_ycf_trap_state_for_hashmap_from_sorted_unique_array;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_from_sorted_unique_array_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_from_sorted_unique_array_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */



/* **Important Note**
 *
 * A yielding version of this function is generated with YCF. This
 * means that the code has to follow some restrictions. See note about
 * YCF near the top of the file for more information.
 */
static Eterm hashmap_from_sorted_unique_array_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,ErtsHeapFactory* factory_N69_N83,
                                              hxnode_t *hxns_N70_N84, Uint n_N71_N85,
                                              ErtsAlcType_t temp_memory_allocator_N72_N86);



struct gen_ycf_trap_state_for_hashmap_from_unsorted_array;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_from_unsorted_array_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_from_unsorted_array_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */



/* **Important Note**
 *
 * A yielding version of this function is generated with YCF. This
 * means that the code has to follow some restrictions. See note about
 * YCF near the top of the file for more information.
 */
static Eterm hashmap_from_unsorted_array_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,ErtsHeapFactory* factory_N40_N55,
                                         hxnode_t *hxns_N41_N56, Uint n_N42_N57,
                                         int reject_dupkeys_N43_N58,
                                         ErtsAlcType_t temp_memory_allocator_N44_N59);



struct gen_ycf_trap_state_for_hashmap_values;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_values_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_values_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

static Eterm hashmap_values_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N23_N31, Eterm node_N24_N32);



struct gen_ycf_trap_state_for_hashmap_keys;

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_keys_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_keys_ycf_gen_destroy(void* ycf_my_trap_state_param);
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

static Eterm hashmap_keys_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N7_N15, Eterm node_N8_N16);



struct gen_ycf_trap_state_for_hashmap_keys {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm stack_default_wstack_N1_N9[16];
    ErtsWStack stack_N2_N10;
    hashmap_head_t* root_N3_N11;
    Eterm *hp_N4_N12;
    Eterm *kv_N5_N13;
    Eterm res_N6_N14;Process* p_N7_N15; Eterm node_N8_N16;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_keys_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_hashmap_keys* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm stack_default_wstack_N1_N9[16];
    ErtsWStack stack_N2_N10;
    hashmap_head_t* root_N3_N11;
    Eterm *hp_N4_N12;
    Eterm *kv_N5_N13;
    Eterm res_N6_N14;Process* p_N7_N15; Eterm node_N8_N16;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    memcpy(stack_default_wstack_N1_N9, ycf_my_trap_state->stack_default_wstack_N1_N9, 16 *  sizeof(
    Eterm));
    stack_N2_N10 = ycf_my_trap_state->stack_N2_N10;
    root_N3_N11 = ycf_my_trap_state->root_N3_N11;
    hp_N4_N12 = ycf_my_trap_state->hp_N4_N12;
    kv_N5_N13 = ycf_my_trap_state->kv_N5_N13;
    res_N6_N14 = ycf_my_trap_state->res_N6_N14;
    p_N7_N15 = ycf_my_trap_state->p_N7_N15;
    node_N8_N16 = ycf_my_trap_state->node_N8_N16;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{

    {
        DESTROY_WSTACK_EXPLICIT_DEFAULT_ARRAY(stack_N2_N10, stack_default_wstack_N1_N9);
    }}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_keys_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_hashmap_keys* ycf_my_trap_state = *ycf_trap_state;
return hashmap_keys_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->p_N7_N15,ycf_my_trap_state->node_N8_N16)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */
static Eterm hashmap_keys_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N7_N15, Eterm node_N8_N16) {
    Eterm stack_default_wstack_N1_N9[16];
    ErtsWStack stack_N2_N10;
    hashmap_head_t* root_N3_N11;
    Eterm *hp_N4_N12;
    Eterm *kv_N5_N13;
    Eterm res_N6_N14;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_hashmap_keys* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    memcpy(stack_default_wstack_N1_N9, ycf_my_trap_state->stack_default_wstack_N1_N9, 16 *  sizeof(
    Eterm));
    stack_N2_N10 = ycf_my_trap_state->stack_N2_N10;
    root_N3_N11 = ycf_my_trap_state->root_N3_N11;
    hp_N4_N12 = ycf_my_trap_state->hp_N4_N12;
    kv_N5_N13 = ycf_my_trap_state->kv_N5_N13;
    res_N6_N14 = ycf_my_trap_state->res_N6_N14;
    p_N7_N15 = ycf_my_trap_state->p_N7_N15;
    node_N8_N16 = ycf_my_trap_state->node_N8_N16;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;

}
  }
}
{

}
    res_N6_N14 = NIL;
#if DEF_WSTACK_SIZE != (16)
#error "The macro DEF_WSTACK_SIZE has changed from 16 (need to change constant above)"
    /* We cannot use "UWord stack_default_wstack[DEF_WSTACK_SIZE];"
       because macros are not expanded before the code is passed to
       YCF, and YCF needs to know the size of the array */
#endif
    stack_N2_N10 = WSTACK_DEFAULT_VALUE(stack_default_wstack_N1_N9, ERTS_ALC_T_MAP_TRAP);
/* YCF Replaced special code */

/* YCF Replaced special code */


    root_N3_N11 = (hashmap_head_t*) boxed_val(node_N8_N16);
    hp_N4_N12  = HAlloc(p_N7_N15, root_N3_N11->size * 2);
    hashmap_iterator_init(&stack_N2_N10, node_N8_N16, 0);
    while ((kv_N5_N13=hashmap_iterator_next(&stack_N2_N10)) != NULL)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 1;
  goto ycf_do_yield_label_hashmap_keys;
  ycf_yield_location_label_1:;
}

}
    {
	res_N6_N14 = CONS(hp_N4_N12, CAR(kv_N5_N13), res_N6_N14);
	hp_N4_N12 += 2;
    }

}
    DESTROY_WSTACK_EXPLICIT_DEFAULT_ARRAY(stack_N2_N10, stack_default_wstack_N1_N9);
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

    return res_N6_N14;
}

{
  struct gen_ycf_trap_state_for_hashmap_keys* ycf_my_trap_state;
  ycf_do_yield_label_hashmap_keys:;

    {
        ENSURE_WSTACK_HEAP_STACK_ARRAY(stack_N2_N10, stack_default_wstack_N1_N9);
    }

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_hashmap_keys), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    memcpy(ycf_my_trap_state->stack_default_wstack_N1_N9, stack_default_wstack_N1_N9, 16 *  sizeof(
    Eterm));
    ycf_my_trap_state->stack_N2_N10 = stack_N2_N10;
    ycf_my_trap_state->root_N3_N11 = root_N3_N11;
    ycf_my_trap_state->hp_N4_N12 = hp_N4_N12;
    ycf_my_trap_state->kv_N5_N13 = kv_N5_N13;
    ycf_my_trap_state->res_N6_N14 = res_N6_N14;
    ycf_my_trap_state->p_N7_N15 = p_N7_N15;
    ycf_my_trap_state->node_N8_N16 = node_N8_N16;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   Eterm  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_hashmap_values {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm stack_default_wstack_N17_N25[16];
    ErtsWStack stack_N18_N26;
    hashmap_head_t* root_N19_N27;
    Eterm *hp_N20_N28;
    Eterm *kv_N21_N29;
    Eterm res_N22_N30;Process* p_N23_N31; Eterm node_N24_N32;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_values_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_hashmap_values* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm stack_default_wstack_N17_N25[16];
    ErtsWStack stack_N18_N26;
    hashmap_head_t* root_N19_N27;
    Eterm *hp_N20_N28;
    Eterm *kv_N21_N29;
    Eterm res_N22_N30;Process* p_N23_N31; Eterm node_N24_N32;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    memcpy(stack_default_wstack_N17_N25, ycf_my_trap_state->stack_default_wstack_N17_N25, 16 *  sizeof(
    Eterm));
    stack_N18_N26 = ycf_my_trap_state->stack_N18_N26;
    root_N19_N27 = ycf_my_trap_state->root_N19_N27;
    hp_N20_N28 = ycf_my_trap_state->hp_N20_N28;
    kv_N21_N29 = ycf_my_trap_state->kv_N21_N29;
    res_N22_N30 = ycf_my_trap_state->res_N22_N30;
    p_N23_N31 = ycf_my_trap_state->p_N23_N31;
    node_N24_N32 = ycf_my_trap_state->node_N24_N32;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{

    {
        DESTROY_WSTACK_EXPLICIT_DEFAULT_ARRAY(stack_N18_N26, stack_default_wstack_N17_N25);
    }}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_values_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_hashmap_values* ycf_my_trap_state = *ycf_trap_state;
return hashmap_values_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->p_N23_N31,ycf_my_trap_state->node_N24_N32)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */
static Eterm hashmap_values_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N23_N31, Eterm node_N24_N32) {
    Eterm stack_default_wstack_N17_N25[16];
    ErtsWStack stack_N18_N26;
    hashmap_head_t* root_N19_N27;
    Eterm *hp_N20_N28;
    Eterm *kv_N21_N29;
    Eterm res_N22_N30;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_hashmap_values* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    memcpy(stack_default_wstack_N17_N25, ycf_my_trap_state->stack_default_wstack_N17_N25, 16 *  sizeof(
    Eterm));
    stack_N18_N26 = ycf_my_trap_state->stack_N18_N26;
    root_N19_N27 = ycf_my_trap_state->root_N19_N27;
    hp_N20_N28 = ycf_my_trap_state->hp_N20_N28;
    kv_N21_N29 = ycf_my_trap_state->kv_N21_N29;
    res_N22_N30 = ycf_my_trap_state->res_N22_N30;
    p_N23_N31 = ycf_my_trap_state->p_N23_N31;
    node_N24_N32 = ycf_my_trap_state->node_N24_N32;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;

}
  }
}
{

}
    res_N22_N30 = NIL;
#if DEF_WSTACK_SIZE != (16)
#error "The macro DEF_WSTACK_SIZE has changed from 16 (need to change constant above)"
    /* We cannot use "UWord stack_default_wstack[DEF_WSTACK_SIZE];"
       because macros are not expanded before the code is passed to
       YCF, and YCF needs to know the size of the array */
#endif
    stack_N18_N26 = WSTACK_DEFAULT_VALUE(stack_default_wstack_N17_N25, ERTS_ALC_T_MAP_TRAP);
/* YCF Replaced special code */

/* YCF Replaced special code */



    root_N19_N27 = (hashmap_head_t*) boxed_val(node_N24_N32);
    hp_N20_N28  = HAlloc(p_N23_N31, root_N19_N27->size * 2);
    hashmap_iterator_init(&stack_N18_N26, node_N24_N32, 0);
    while ((kv_N21_N29=hashmap_iterator_next(&stack_N18_N26)) != NULL)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 1;
  goto ycf_do_yield_label_hashmap_values;
  ycf_yield_location_label_1:;
}

}
    {
	res_N22_N30 = CONS(hp_N20_N28, CDR(kv_N21_N29), res_N22_N30);
	hp_N20_N28 += 2;
    }

}
    DESTROY_WSTACK_EXPLICIT_DEFAULT_ARRAY(stack_N18_N26, stack_default_wstack_N17_N25);
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

    return res_N22_N30;
}

{
  struct gen_ycf_trap_state_for_hashmap_values* ycf_my_trap_state;
  ycf_do_yield_label_hashmap_values:;

    {
        ENSURE_WSTACK_HEAP_STACK_ARRAY(stack_N18_N26, stack_default_wstack_N17_N25);
    }

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_hashmap_values), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    memcpy(ycf_my_trap_state->stack_default_wstack_N17_N25, stack_default_wstack_N17_N25, 16 *  sizeof(
    Eterm));
    ycf_my_trap_state->stack_N18_N26 = stack_N18_N26;
    ycf_my_trap_state->root_N19_N27 = root_N19_N27;
    ycf_my_trap_state->hp_N20_N28 = hp_N20_N28;
    ycf_my_trap_state->kv_N21_N29 = kv_N21_N29;
    ycf_my_trap_state->res_N22_N30 = res_N22_N30;
    ycf_my_trap_state->p_N23_N31 = p_N23_N31;
    ycf_my_trap_state->node_N24_N32 = node_N24_N32;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   Eterm  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_hashmap_from_unsorted_array {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Uint jx_N35_N48;
    Uint ix_N36_N49;
    Uint lx_N37_N50;
    Uint cx_N38_N51;
    Eterm res_N39_N52;
        Eterm slot_N33_N53;
        Eterm *hp_N34_N54;
void* ycf_sub_fun_trap_state_wb_N45;

void* ycf_sub_fun_trap_state_wb_N46;

void* ycf_sub_fun_trap_state_wb_N47;ErtsHeapFactory* factory_N40_N55;
                                         hxnode_t *hxns_N41_N56; Uint n_N42_N57;
                                         int reject_dupkeys_N43_N58;
                                         ErtsAlcType_t temp_memory_allocator_N44_N59;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_from_unsorted_array_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_hashmap_from_unsorted_array* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Uint jx_N35_N48;
    Uint ix_N36_N49;
    Uint lx_N37_N50;
    Uint cx_N38_N51;
    Eterm res_N39_N52;
        Eterm slot_N33_N53;
        Eterm *hp_N34_N54;
void* ycf_sub_fun_trap_state_wb_N45;

void* ycf_sub_fun_trap_state_wb_N46;

void* ycf_sub_fun_trap_state_wb_N47;ErtsHeapFactory* factory_N40_N55;
                                         hxnode_t *hxns_N41_N56; Uint n_N42_N57;
                                         int reject_dupkeys_N43_N58;
                                         ErtsAlcType_t temp_memory_allocator_N44_N59;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    jx_N35_N48 = ycf_my_trap_state->jx_N35_N48;
    ix_N36_N49 = ycf_my_trap_state->ix_N36_N49;
    lx_N37_N50 = ycf_my_trap_state->lx_N37_N50;
    cx_N38_N51 = ycf_my_trap_state->cx_N38_N51;
    res_N39_N52 = ycf_my_trap_state->res_N39_N52;
    slot_N33_N53 = ycf_my_trap_state->slot_N33_N53;
    hp_N34_N54 = ycf_my_trap_state->hp_N34_N54;
    ycf_sub_fun_trap_state_wb_N45 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N45;
    ycf_sub_fun_trap_state_wb_N46 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N46;
    ycf_sub_fun_trap_state_wb_N47 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N47;
    factory_N40_N55 = ycf_my_trap_state->factory_N40_N55;
    hxns_N41_N56 = ycf_my_trap_state->hxns_N41_N56;
    n_N42_N57 = ycf_my_trap_state->n_N42_N57;
    reject_dupkeys_N43_N58 = ycf_my_trap_state->reject_dupkeys_N43_N58;
    temp_memory_allocator_N44_N59 = ycf_my_trap_state->temp_memory_allocator_N44_N59;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{
  if(ycf_sub_fun_trap_state_wb_N45 != NULL)
{     erts_qsort_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N45);
  }
}
{
  if(ycf_sub_fun_trap_state_wb_N46 != NULL)
{     erts_qsort_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N46);
  }
}
{
  if(ycf_sub_fun_trap_state_wb_N47 != NULL)
{     hashmap_from_sorted_unique_array_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N47);
  }
}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_from_unsorted_array_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_hashmap_from_unsorted_array* ycf_my_trap_state = *ycf_trap_state;
return hashmap_from_unsorted_array_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->factory_N40_N55,ycf_my_trap_state->hxns_N41_N56,ycf_my_trap_state->n_N42_N57,ycf_my_trap_state->reject_dupkeys_N43_N58,ycf_my_trap_state->temp_memory_allocator_N44_N59)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */


/* **Important Note**
 *
 * A yielding version of this function is generated with YCF. This
 * means that the code has to follow some restrictions. See note about
 * YCF near the top of the file for more information.
 */
static Eterm hashmap_from_unsorted_array_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,ErtsHeapFactory* factory_N40_N55,
                                         hxnode_t *hxns_N41_N56, Uint n_N42_N57,
                                         int reject_dupkeys_N43_N58,
                                         ErtsAlcType_t temp_memory_allocator_N44_N59) {
    Uint jx_N35_N48;
    Uint ix_N36_N49;
    Uint lx_N37_N50;
    Uint cx_N38_N51;
    Eterm res_N39_N52;
        Eterm slot_N33_N53;
        Eterm *hp_N34_N54;
void* ycf_sub_fun_trap_state_wb_N45;

void* ycf_sub_fun_trap_state_wb_N46;

void* ycf_sub_fun_trap_state_wb_N47;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_hashmap_from_unsorted_array* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    jx_N35_N48 = ycf_my_trap_state->jx_N35_N48;
    ix_N36_N49 = ycf_my_trap_state->ix_N36_N49;
    lx_N37_N50 = ycf_my_trap_state->lx_N37_N50;
    cx_N38_N51 = ycf_my_trap_state->cx_N38_N51;
    res_N39_N52 = ycf_my_trap_state->res_N39_N52;
    slot_N33_N53 = ycf_my_trap_state->slot_N33_N53;
    hp_N34_N54 = ycf_my_trap_state->hp_N34_N54;
    ycf_sub_fun_trap_state_wb_N45 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N45;
    ycf_sub_fun_trap_state_wb_N46 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N46;
    ycf_sub_fun_trap_state_wb_N47 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N47;
    factory_N40_N55 = ycf_my_trap_state->factory_N40_N55;
    hxns_N41_N56 = ycf_my_trap_state->hxns_N41_N56;
    n_N42_N57 = ycf_my_trap_state->n_N42_N57;
    reject_dupkeys_N43_N58 = ycf_my_trap_state->reject_dupkeys_N43_N58;
    temp_memory_allocator_N44_N59 = ycf_my_trap_state->temp_memory_allocator_N44_N59;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;
case 2: goto ycf_yield_location_label_2;
case 3: goto ycf_yield_location_label_3;
case 4: goto ycf_yield_location_label_4;
case 5: goto ycf_yield_location_label_5;
case 6: goto ycf_yield_location_label_6;
case 7: goto ycf_yield_location_label_7;
case 8: goto ycf_yield_location_label_8;
case 9: goto ycf_yield_location_label_9;
case 10: goto ycf_yield_location_label_10;
case 11: goto ycf_yield_location_label_11;
case 12: goto ycf_yield_location_label_12;

}
  }
}
{

ycf_sub_fun_trap_state_wb_N45 = NULL;

ycf_sub_fun_trap_state_wb_N46 = NULL;

ycf_sub_fun_trap_state_wb_N47 = NULL;

}
    jx_N35_N48 = 0;
    ix_N36_N49 = 0;

    ASSERT(n_N42_N57 > 0);
{

ycf_sub_fun_trap_state_wb_N45 = NULL;
{
 erts_qsort_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N45,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,hxns_N41_N56, n_N42_N57, sizeof(hxnode_t), hxnodecmp);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N45)){
   ycf_trap_location = 1;
   goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_1:;
    erts_qsort_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N45,
                            ycf_extra_context);
}


}
/* YCF Replaced special code */

}


    ix_N36_N49 = 0, cx_N38_N51 = 0;
    while(ix_N36_N49 < n_N42_N57 - 1)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 4;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_4:;
}

}
    {
	if (hxns_N41_N56[ix_N36_N49].hx == hxns_N41_N56[ix_N36_N49+1].hx)
{
    {

	    /* find region of equal hash values */
	    jx_N35_N48 = ix_N36_N49 + 2;
	    while(jx_N35_N48 < n_N42_N57 && hxns_N41_N56[ix_N36_N49].hx == hxns_N41_N56[jx_N35_N48].hx)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 5;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_5:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 6;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_6:;
}

}
    { jx_N35_N48++; }

}

}
{


ycf_sub_fun_trap_state_wb_N46 = NULL;
{
 erts_qsort_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N46,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,&hxns_N41_N56[ix_N36_N49], jx_N35_N48 - ix_N36_N49, sizeof(hxnode_t), hxnodecmpkey);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N46)){
   ycf_trap_location = 2;
   goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_2:;
    erts_qsort_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N46,
                            ycf_extra_context);
}


}
/* YCF Replaced special code */

}



	    while(ix_N36_N49 < jx_N35_N48)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 7;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_7:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 8;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_8:;
}

}
    {
		lx_N37_N50 = ix_N36_N49;
		while(++ix_N36_N49 < jx_N35_N48 && EQ(CAR(list_val(hxns_N41_N56[ix_N36_N49].val)),
				      CAR(list_val(hxns_N41_N56[lx_N37_N50].val))))
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 9;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_9:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 10;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_10:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 11;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_11:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 12;
  goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_12:;
}

}
    {
                    if (reject_dupkeys_N43_N58)
{
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

   
                        return THE_NON_VALUE;
}

}

                    if (hxns_N41_N56[ix_N36_N49].i > hxns_N41_N56[lx_N37_N50].i)
{
    {
			lx_N37_N50 = ix_N36_N49;
		    }

}
		}

}

}

}

}
		hxns_N41_N56[cx_N38_N51].hx  = hxns_N41_N56[lx_N37_N50].hx;
		hxns_N41_N56[cx_N38_N51].val = hxns_N41_N56[lx_N37_N50].val;
		cx_N38_N51++;
	    }

}

}
	    ix_N36_N49 = jx_N35_N48;
	    continue;
	}

}
	if (ix_N36_N49 > cx_N38_N51)
{
    {
	    hxns_N41_N56[cx_N38_N51].hx  = hxns_N41_N56[ix_N36_N49].hx;
	    hxns_N41_N56[cx_N38_N51].val = hxns_N41_N56[ix_N36_N49].val;
	}

}
	cx_N38_N51++;
	ix_N36_N49++;
    }

}

    if (ix_N36_N49 < n_N42_N57)
{
    {
	hxns_N41_N56[cx_N38_N51].hx  = hxns_N41_N56[ix_N36_N49].hx;
	hxns_N41_N56[cx_N38_N51].val = hxns_N41_N56[ix_N36_N49].val;
	cx_N38_N51++;
    }

}

    if (cx_N38_N51 > 1)
{
{


ycf_sub_fun_trap_state_wb_N47 = NULL;
{
  Eterm  ycf_tmp_fun_call_tmp_var;
ycf_tmp_fun_call_tmp_var =  hashmap_from_sorted_unique_array_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N47,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,factory_N40_N55, hxns_N41_N56, cx_N38_N51,
                                               temp_memory_allocator_N44_N59);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N47)){
   ycf_trap_location = 3;
   goto ycf_do_yield_label_hashmap_from_unsorted_array;
  ycf_yield_location_label_3:;
   ycf_tmp_fun_call_tmp_var =  hashmap_from_sorted_unique_array_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N47,
                            ycf_extra_context);
}

        /* recursive decompose array */
        res_N39_N52 = ycf_tmp_fun_call_tmp_var;


}
/* YCF Replaced special code */

}


} else
{
    {

        /* We only have one item, either because n was 1 or because we have
         * multiples of the same key.
         *
         * As the hash value has been swizzled, we need to drag it down to get
         * the correct slot. */
        slot_N33_N53 = hxns_N41_N56[0].hx >> ((HAMT_MAX_LEVEL - 1) * 4);
        ASSERT(slot_N33_N53 < 16);

        hp_N34_N54    = erts_produce_heap(factory_N40_N55, HAMT_HEAD_BITMAP_SZ(1), 0);
        hp_N34_N54[0] = MAP_HEADER_HAMT_HEAD_BITMAP(1 << slot_N33_N53);
        hp_N34_N54[1] = 1;
        hp_N34_N54[2] = hxns_N41_N56[0].val;
        res_N39_N52   = make_hashmap(hp_N34_N54);
    }

}
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


    return res_N39_N52;
}

{
  struct gen_ycf_trap_state_for_hashmap_from_unsorted_array* ycf_my_trap_state;
  ycf_do_yield_label_hashmap_from_unsorted_array:;
  
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_hashmap_from_unsorted_array), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    ycf_my_trap_state->jx_N35_N48 = jx_N35_N48;
    ycf_my_trap_state->ix_N36_N49 = ix_N36_N49;
    ycf_my_trap_state->lx_N37_N50 = lx_N37_N50;
    ycf_my_trap_state->cx_N38_N51 = cx_N38_N51;
    ycf_my_trap_state->res_N39_N52 = res_N39_N52;
    ycf_my_trap_state->slot_N33_N53 = slot_N33_N53;
    ycf_my_trap_state->hp_N34_N54 = hp_N34_N54;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N45 = ycf_sub_fun_trap_state_wb_N45;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N46 = ycf_sub_fun_trap_state_wb_N46;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N47 = ycf_sub_fun_trap_state_wb_N47;
    ycf_my_trap_state->factory_N40_N55 = factory_N40_N55;
    ycf_my_trap_state->hxns_N41_N56 = hxns_N41_N56;
    ycf_my_trap_state->n_N42_N57 = n_N42_N57;
    ycf_my_trap_state->reject_dupkeys_N43_N58 = reject_dupkeys_N43_N58;
    ycf_my_trap_state->temp_memory_allocator_N44_N59 = temp_memory_allocator_N44_N59;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   Eterm  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_hashmap_from_sorted_unique_array {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm res_N65_N74;
    Uint ix_N66_N75;
    Uint elems_N67_N76;
    hxnode_t *tmp_N68_N77;
            Uint n_colliders_N60_N78;
            Eterm* hp_N61_N79;
            Eterm collision_node_N62_N80;
            Uint jx_N63_N81;
            Uint i_N64_N82;
void* ycf_sub_fun_trap_state_wb_N73;ErtsHeapFactory* factory_N69_N83;
                                              hxnode_t *hxns_N70_N84; Uint n_N71_N85;
                                              ErtsAlcType_t temp_memory_allocator_N72_N86;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_from_sorted_unique_array_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_hashmap_from_sorted_unique_array* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm res_N65_N74;
    Uint ix_N66_N75;
    Uint elems_N67_N76;
    hxnode_t *tmp_N68_N77;
            Uint n_colliders_N60_N78;
            Eterm* hp_N61_N79;
            Eterm collision_node_N62_N80;
            Uint jx_N63_N81;
            Uint i_N64_N82;
void* ycf_sub_fun_trap_state_wb_N73;ErtsHeapFactory* factory_N69_N83;
                                              hxnode_t *hxns_N70_N84; Uint n_N71_N85;
                                              ErtsAlcType_t temp_memory_allocator_N72_N86;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    res_N65_N74 = ycf_my_trap_state->res_N65_N74;
    ix_N66_N75 = ycf_my_trap_state->ix_N66_N75;
    elems_N67_N76 = ycf_my_trap_state->elems_N67_N76;
    tmp_N68_N77 = ycf_my_trap_state->tmp_N68_N77;
    n_colliders_N60_N78 = ycf_my_trap_state->n_colliders_N60_N78;
    hp_N61_N79 = ycf_my_trap_state->hp_N61_N79;
    collision_node_N62_N80 = ycf_my_trap_state->collision_node_N62_N80;
    jx_N63_N81 = ycf_my_trap_state->jx_N63_N81;
    i_N64_N82 = ycf_my_trap_state->i_N64_N82;
    ycf_sub_fun_trap_state_wb_N73 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N73;
    factory_N69_N83 = ycf_my_trap_state->factory_N69_N83;
    hxns_N70_N84 = ycf_my_trap_state->hxns_N70_N84;
    n_N71_N85 = ycf_my_trap_state->n_N71_N85;
    temp_memory_allocator_N72_N86 = ycf_my_trap_state->temp_memory_allocator_N72_N86;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{

    {
        if (tmp_N68_N77 != NULL) {
            /* Execution of this function got destroyed while yielding in
               the loop above */
            erts_free(temp_memory_allocator_N72_N86, (void *) tmp_N68_N77);
        }
    }}
{
  if(ycf_sub_fun_trap_state_wb_N73 != NULL)
{     hashmap_from_chunked_array_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N73);
  }
}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_from_sorted_unique_array_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_hashmap_from_sorted_unique_array* ycf_my_trap_state = *ycf_trap_state;
return hashmap_from_sorted_unique_array_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->factory_N69_N83,ycf_my_trap_state->hxns_N70_N84,ycf_my_trap_state->n_N71_N85,ycf_my_trap_state->temp_memory_allocator_N72_N86)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */


/* **Important Note**
 *
 * A yielding version of this function is generated with YCF. This
 * means that the code has to follow some restrictions. See note about
 * YCF near the top of the file for more information.
 */
static Eterm hashmap_from_sorted_unique_array_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,ErtsHeapFactory* factory_N69_N83,
                                              hxnode_t *hxns_N70_N84, Uint n_N71_N85,
                                              ErtsAlcType_t temp_memory_allocator_N72_N86) {
    Eterm res_N65_N74;
    Uint ix_N66_N75;
    Uint elems_N67_N76;
    hxnode_t *tmp_N68_N77;
            Uint n_colliders_N60_N78;
            Eterm* hp_N61_N79;
            Eterm collision_node_N62_N80;
            Uint jx_N63_N81;
            Uint i_N64_N82;
void* ycf_sub_fun_trap_state_wb_N73;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_hashmap_from_sorted_unique_array* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    res_N65_N74 = ycf_my_trap_state->res_N65_N74;
    ix_N66_N75 = ycf_my_trap_state->ix_N66_N75;
    elems_N67_N76 = ycf_my_trap_state->elems_N67_N76;
    tmp_N68_N77 = ycf_my_trap_state->tmp_N68_N77;
    n_colliders_N60_N78 = ycf_my_trap_state->n_colliders_N60_N78;
    hp_N61_N79 = ycf_my_trap_state->hp_N61_N79;
    collision_node_N62_N80 = ycf_my_trap_state->collision_node_N62_N80;
    jx_N63_N81 = ycf_my_trap_state->jx_N63_N81;
    i_N64_N82 = ycf_my_trap_state->i_N64_N82;
    ycf_sub_fun_trap_state_wb_N73 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N73;
    factory_N69_N83 = ycf_my_trap_state->factory_N69_N83;
    hxns_N70_N84 = ycf_my_trap_state->hxns_N70_N84;
    n_N71_N85 = ycf_my_trap_state->n_N71_N85;
    temp_memory_allocator_N72_N86 = ycf_my_trap_state->temp_memory_allocator_N72_N86;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;
case 2: goto ycf_yield_location_label_2;
case 3: goto ycf_yield_location_label_3;
case 4: goto ycf_yield_location_label_4;
case 5: goto ycf_yield_location_label_5;
case 6: goto ycf_yield_location_label_6;

}
  }
}
{

ycf_sub_fun_trap_state_wb_N73 = NULL;

}
    res_N65_N74 = NIL;
    tmp_N68_N77 = NULL;

    ix_N66_N75 = 0;
    elems_N67_N76 = 1;
    while (ix_N66_N75 < n_N71_N85 - 1)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 2;
  goto ycf_do_yield_label_hashmap_from_sorted_unique_array;
  ycf_yield_location_label_2:;
}

}
    {
	if (hxns_N70_N84[ix_N66_N75].hx == hxns_N70_N84[ix_N66_N75+1].hx)
{
    {
            jx_N63_N81 = ix_N66_N75 + 2;

	    while (jx_N63_N81 < n_N71_N85 && hxns_N70_N84[ix_N66_N75].hx == hxns_N70_N84[jx_N63_N81].hx)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 3;
  goto ycf_do_yield_label_hashmap_from_sorted_unique_array;
  ycf_yield_location_label_3:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 4;
  goto ycf_do_yield_label_hashmap_from_sorted_unique_array;
  ycf_yield_location_label_4:;
}

}
{
   
                jx_N63_N81++;
}

}

}

            n_colliders_N60_N78 = jx_N63_N81 - ix_N66_N75;
            hp_N61_N79 = erts_produce_heap(factory_N69_N83, HAMT_COLLISION_NODE_SZ(n_colliders_N60_N78),
                                   HALLOC_EXTRA);
            collision_node_N62_N80 = make_tuple(hp_N61_N79);

            *hp_N61_N79++ = MAP_HEADER_HAMT_COLLISION_NODE(n_colliders_N60_N78);
            for (i_N64_N82 = 0; i_N64_N82 < n_colliders_N60_N78; i_N64_N82++)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 5;
  goto ycf_do_yield_label_hashmap_from_sorted_unique_array;
  ycf_yield_location_label_5:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 6;
  goto ycf_do_yield_label_hashmap_from_sorted_unique_array;
  ycf_yield_location_label_6:;
}

}
    {
                *hp_N61_N79++ = hxns_N70_N84[ix_N66_N75 + i_N64_N82].val;
                ASSERT(i_N64_N82 == 0
                       || CMP_TERM(CAR(list_val(hxns_N70_N84[ix_N66_N75+i_N64_N82-1].val)),
                                   CAR(list_val(hxns_N70_N84[ix_N66_N75+i_N64_N82].val))) < 0);
            }

}

}

            hxns_N70_N84[ix_N66_N75].val  = collision_node_N62_N80;
            hxns_N70_N84[ix_N66_N75].skip = n_colliders_N60_N78;
            ix_N66_N75 = jx_N63_N81;

            if (ix_N66_N75 < n_N71_N85)
{
    { elems_N67_N76++; }

}
            continue;
	}

}
        hxns_N70_N84[ix_N66_N75].skip = 1;
        elems_N67_N76++;
        ix_N66_N75++;
    }

}
/* YCF Replaced special code */

{

ycf_sub_fun_trap_state_wb_N73 = NULL;
{
  Eterm  ycf_tmp_fun_call_tmp_var;
ycf_tmp_fun_call_tmp_var =  hashmap_from_chunked_array_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N73,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,factory_N69_N83, hxns_N70_N84, elems_N67_N76, n_N71_N85, temp_memory_allocator_N72_N86);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N73)){
   ycf_trap_location = 1;
   goto ycf_do_yield_label_hashmap_from_sorted_unique_array;
  ycf_yield_location_label_1:;
   ycf_tmp_fun_call_tmp_var =  hashmap_from_chunked_array_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N73,
                            ycf_extra_context);
}


    res_N65_N74 = ycf_tmp_fun_call_tmp_var;


}
/* YCF Replaced special code */

}


    ERTS_FACTORY_HOLE_CHECK(factory_N69_N83);
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


    return res_N65_N74;
}

{
  struct gen_ycf_trap_state_for_hashmap_from_sorted_unique_array* ycf_my_trap_state;
  ycf_do_yield_label_hashmap_from_sorted_unique_array:;
  
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_hashmap_from_sorted_unique_array), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    ycf_my_trap_state->res_N65_N74 = res_N65_N74;
    ycf_my_trap_state->ix_N66_N75 = ix_N66_N75;
    ycf_my_trap_state->elems_N67_N76 = elems_N67_N76;
    ycf_my_trap_state->tmp_N68_N77 = tmp_N68_N77;
    ycf_my_trap_state->n_colliders_N60_N78 = n_colliders_N60_N78;
    ycf_my_trap_state->hp_N61_N79 = hp_N61_N79;
    ycf_my_trap_state->collision_node_N62_N80 = collision_node_N62_N80;
    ycf_my_trap_state->jx_N63_N81 = jx_N63_N81;
    ycf_my_trap_state->i_N64_N82 = i_N64_N82;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N73 = ycf_sub_fun_trap_state_wb_N73;
    ycf_my_trap_state->factory_N69_N83 = factory_N69_N83;
    ycf_my_trap_state->hxns_N70_N84 = hxns_N70_N84;
    ycf_my_trap_state->n_N71_N85 = n_N71_N85;
    ycf_my_trap_state->temp_memory_allocator_N72_N86 = temp_memory_allocator_N72_N86;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   Eterm  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_hashmap_from_chunked_array {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Uint ix_N88_N110;
    Uint d_N89_N111;
    Uint dn_N90_N112;
    Uint dc_N91_N113;
    Uint slot_N92_N114;
    Uint elems_N93_N115;
    erts_ihash_t v_N94_N116;
    erts_ihash_t vp_N95_N117;
    erts_ihash_t vn_N96_N118;
    Uint32 hdr_N97_N119;
    Uint bp_N98_N120;
    Uint sz_N99_N121;
    Eterm res_N100_N122;
    Eterm *hp_N101_N123;
    Eterm *nhp_N102_N124;
    Eterm stack_default_estack_N103_N125[16];    ErtsEStack stack_N104_N126;
	    int wat_N87_N127;ErtsHeapFactory *factory_N105_N128; hxnode_t *hxns_N106_N129; Uint n_N107_N130;
                                        Uint size_N108_N131;
                                        ErtsAlcType_t temp_memory_allocator_N109_N132;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_from_chunked_array_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_hashmap_from_chunked_array* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Uint ix_N88_N110;
    Uint d_N89_N111;
    Uint dn_N90_N112;
    Uint dc_N91_N113;
    Uint slot_N92_N114;
    Uint elems_N93_N115;
    erts_ihash_t v_N94_N116;
    erts_ihash_t vp_N95_N117;
    erts_ihash_t vn_N96_N118;
    Uint32 hdr_N97_N119;
    Uint bp_N98_N120;
    Uint sz_N99_N121;
    Eterm res_N100_N122;
    Eterm *hp_N101_N123;
    Eterm *nhp_N102_N124;
    Eterm stack_default_estack_N103_N125[16];    ErtsEStack stack_N104_N126;
	    int wat_N87_N127;ErtsHeapFactory *factory_N105_N128; hxnode_t *hxns_N106_N129; Uint n_N107_N130;
                                        Uint size_N108_N131;
                                        ErtsAlcType_t temp_memory_allocator_N109_N132;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    ix_N88_N110 = ycf_my_trap_state->ix_N88_N110;
    d_N89_N111 = ycf_my_trap_state->d_N89_N111;
    dn_N90_N112 = ycf_my_trap_state->dn_N90_N112;
    dc_N91_N113 = ycf_my_trap_state->dc_N91_N113;
    slot_N92_N114 = ycf_my_trap_state->slot_N92_N114;
    elems_N93_N115 = ycf_my_trap_state->elems_N93_N115;
    v_N94_N116 = ycf_my_trap_state->v_N94_N116;
    vp_N95_N117 = ycf_my_trap_state->vp_N95_N117;
    vn_N96_N118 = ycf_my_trap_state->vn_N96_N118;
    hdr_N97_N119 = ycf_my_trap_state->hdr_N97_N119;
    bp_N98_N120 = ycf_my_trap_state->bp_N98_N120;
    sz_N99_N121 = ycf_my_trap_state->sz_N99_N121;
    res_N100_N122 = ycf_my_trap_state->res_N100_N122;
    hp_N101_N123 = ycf_my_trap_state->hp_N101_N123;
    nhp_N102_N124 = ycf_my_trap_state->nhp_N102_N124;
    memcpy(stack_default_estack_N103_N125, ycf_my_trap_state->stack_default_estack_N103_N125, 16 *  sizeof(
    Eterm));
    stack_N104_N126 = ycf_my_trap_state->stack_N104_N126;
    wat_N87_N127 = ycf_my_trap_state->wat_N87_N127;
    factory_N105_N128 = ycf_my_trap_state->factory_N105_N128;
    hxns_N106_N129 = ycf_my_trap_state->hxns_N106_N129;
    n_N107_N130 = ycf_my_trap_state->n_N107_N130;
    size_N108_N131 = ycf_my_trap_state->size_N108_N131;
    temp_memory_allocator_N109_N132 = ycf_my_trap_state->temp_memory_allocator_N109_N132;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{

    {
        DESTROY_ESTACK_EXPLICIT_DEFAULT_ARRAY(stack_N104_N126, stack_default_estack_N103_N125);
    }}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_from_chunked_array_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_hashmap_from_chunked_array* ycf_my_trap_state = *ycf_trap_state;
return hashmap_from_chunked_array_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->factory_N105_N128,ycf_my_trap_state->hxns_N106_N129,ycf_my_trap_state->n_N107_N130,ycf_my_trap_state->size_N108_N131,ycf_my_trap_state->temp_memory_allocator_N109_N132)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */


/* **Important Note**
 *
 * A yielding version of this function is generated with YCF. This
 * means that the code has to follow some restrictions. See note about
 * YCF near the top of the file for more information.
 */
static Eterm hashmap_from_chunked_array_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,ErtsHeapFactory *factory_N105_N128, hxnode_t *hxns_N106_N129, Uint n_N107_N130,
                                        Uint size_N108_N131,
                                        ErtsAlcType_t temp_memory_allocator_N109_N132) {
    Uint ix_N88_N110;
    Uint d_N89_N111;
    Uint dn_N90_N112;
    Uint dc_N91_N113;
    Uint slot_N92_N114;
    Uint elems_N93_N115;
    erts_ihash_t v_N94_N116;
    erts_ihash_t vp_N95_N117;
    erts_ihash_t vn_N96_N118;
    Uint32 hdr_N97_N119;
    Uint bp_N98_N120;
    Uint sz_N99_N121;
    Eterm res_N100_N122;
    Eterm *hp_N101_N123;
    Eterm *nhp_N102_N124;
    Eterm stack_default_estack_N103_N125[16];    ErtsEStack stack_N104_N126;
	    int wat_N87_N127;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_hashmap_from_chunked_array* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    ix_N88_N110 = ycf_my_trap_state->ix_N88_N110;
    d_N89_N111 = ycf_my_trap_state->d_N89_N111;
    dn_N90_N112 = ycf_my_trap_state->dn_N90_N112;
    dc_N91_N113 = ycf_my_trap_state->dc_N91_N113;
    slot_N92_N114 = ycf_my_trap_state->slot_N92_N114;
    elems_N93_N115 = ycf_my_trap_state->elems_N93_N115;
    v_N94_N116 = ycf_my_trap_state->v_N94_N116;
    vp_N95_N117 = ycf_my_trap_state->vp_N95_N117;
    vn_N96_N118 = ycf_my_trap_state->vn_N96_N118;
    hdr_N97_N119 = ycf_my_trap_state->hdr_N97_N119;
    bp_N98_N120 = ycf_my_trap_state->bp_N98_N120;
    sz_N99_N121 = ycf_my_trap_state->sz_N99_N121;
    res_N100_N122 = ycf_my_trap_state->res_N100_N122;
    hp_N101_N123 = ycf_my_trap_state->hp_N101_N123;
    nhp_N102_N124 = ycf_my_trap_state->nhp_N102_N124;
    memcpy(stack_default_estack_N103_N125, ycf_my_trap_state->stack_default_estack_N103_N125, 16 *  sizeof(
    Eterm));
    stack_N104_N126 = ycf_my_trap_state->stack_N104_N126;
    wat_N87_N127 = ycf_my_trap_state->wat_N87_N127;
    factory_N105_N128 = ycf_my_trap_state->factory_N105_N128;
    hxns_N106_N129 = ycf_my_trap_state->hxns_N106_N129;
    n_N107_N130 = ycf_my_trap_state->n_N107_N130;
    size_N108_N131 = ycf_my_trap_state->size_N108_N131;
    temp_memory_allocator_N109_N132 = ycf_my_trap_state->temp_memory_allocator_N109_N132;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;
case 2: goto ycf_yield_location_label_2;
case 3: goto ycf_yield_location_label_3;
case 4: goto ycf_yield_location_label_4;
case 5: goto ycf_yield_location_label_5;
case 6: goto ycf_yield_location_label_6;
case 7: goto ycf_yield_location_label_7;
case 8: goto ycf_yield_location_label_8;
case 9: goto ycf_yield_location_label_9;
case 10: goto ycf_yield_location_label_10;
case 11: goto ycf_yield_location_label_11;
case 12: goto ycf_yield_location_label_12;
case 13: goto ycf_yield_location_label_13;
case 14: goto ycf_yield_location_label_14;
case 15: goto ycf_yield_location_label_15;
case 16: goto ycf_yield_location_label_16;
case 17: goto ycf_yield_location_label_17;
case 18: goto ycf_yield_location_label_18;
case 19: goto ycf_yield_location_label_19;

}
  }
}
{

}
    res_N100_N122 = NIL;
    hp_N101_N123 = NULL;
    nhp_N102_N124 = NULL;
#if DEF_ESTACK_SIZE != (16)
    #error "The macro DEF_ESTACK_SIZE has changed from 16 (need to change constant above)"
    /* We cannot use "Eterm stack_default_estack[DEF_ESTACK_SIZE];"
       because macros are not expanded before the code is passed to
       YCF, and YCF needs to know the size of the array */
#endif

{

/* moved declaration (stack)*/

}
    stack_N104_N126 = ESTACK_DEFAULT_VALUE(stack_default_estack_N103_N125, temp_memory_allocator_N109_N132);
/* YCF Replaced special code */

/* YCF Replaced special code */


    /* if we get here with only one element then
     * we have eight levels of collisions
     */

    if (n_N107_N130 == 1)
{
    {
	res_N100_N122 = hxns_N106_N129[0].val;
	v_N94_N116   = hxns_N106_N129[0].hx;
	for (d_N89_N111 = HAMT_MAX_LEVEL-1; d_N89_N111 > 0; d_N89_N111--)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 1;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_1:;
}

}
    {
	    slot_N92_N114  = maskval(v_N94_N116,d_N89_N111);
	    hp_N101_N123    = erts_produce_heap(factory_N105_N128, HAMT_NODE_BITMAP_SZ(1), HALLOC_EXTRA);
	    hp_N101_N123[0] = MAP_HEADER_HAMT_NODE_BITMAP(1 << slot_N92_N114);
	    hp_N101_N123[1] = res_N100_N122;
	    res_N100_N122   = make_hashmap(hp_N101_N123);
	}

}

	slot_N92_N114  = maskval(v_N94_N116,0);
	hp_N101_N123    = erts_produce_heap(factory_N105_N128, 3, 0);

        hp_N101_N123[0] = MAP_HEADER_HAMT_HEAD_BITMAP(1 << slot_N92_N114);
        hp_N101_N123[1] = size_N108_N131;
        hp_N101_N123[2] = res_N100_N122;
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

	return make_hashmap(hp_N101_N123);
}
    }

}

    /* push initial nodes on the stack,
     * this is the starting depth */

    ix_N88_N110 = 0;
    d_N89_N111  = 0;
    vp_N95_N117 = hxns_N106_N129[ix_N88_N110].hx;
    v_N94_N116  = hxns_N106_N129[ix_N88_N110 + hxns_N106_N129[ix_N88_N110].skip].hx;

    ASSERT(vp_N95_N117 > v_N94_N116);
    slot_N92_N114 = maskval(vp_N95_N117,d_N89_N111);

    while(slot_N92_N114 == maskval(v_N94_N116,d_N89_N111))
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 2;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_2:;
}

}
    {
	ESTACK_PUSH(stack_N104_N126, 1 << slot_N92_N114);
	d_N89_N111++;
	slot_N92_N114 = maskval(vp_N95_N117,d_N89_N111);
    }

}

    res_N100_N122 = hxns_N106_N129[ix_N88_N110].val;

    if (hxns_N106_N129[ix_N88_N110].skip > 1)
{
    {
	dc_N91_N113 = HAMT_MAX_LEVEL - 1;
	/* build collision nodes */
	while (dc_N91_N113 > d_N89_N111)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 3;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_3:;
}

}
    {
	    hp_N101_N123    = erts_produce_heap(factory_N105_N128, HAMT_NODE_BITMAP_SZ(1), HALLOC_EXTRA);
	    hp_N101_N123[0] = MAP_HEADER_HAMT_NODE_BITMAP(1 << maskval(vp_N95_N117,dc_N91_N113));
	    hp_N101_N123[1] = res_N100_N122;
	    res_N100_N122   = make_hashmap(hp_N101_N123);
	    dc_N91_N113--;
	}

}
    }

}

    ESTACK_PUSH2(stack_N104_N126,res_N100_N122,1 << slot_N92_N114);

    /* all of the other nodes .. */
    elems_N93_N115 = n_N107_N130 - 2; /* remove first and last elements */
    while(elems_N93_N115--)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 4;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_4:;
}

}
    {
	hdr_N97_N119 = ESTACK_POP(stack_N104_N126);
	ix_N88_N110  = ix_N88_N110 + hxns_N106_N129[ix_N88_N110].skip;

	/* determine if node or subtree should be built by looking
	 * at the next value. */

	vn_N96_N118 = hxns_N106_N129[ix_N88_N110 + hxns_N106_N129[ix_N88_N110].skip].hx;
	dn_N90_N112 = cdepth(v_N94_N116,vn_N96_N118);
	ASSERT(v_N94_N116 > vn_N96_N118);

	res_N100_N122 = hxns_N106_N129[ix_N88_N110].val;

	if (hxns_N106_N129[ix_N88_N110].skip > 1)
{
    {
	    wat_N87_N127 = (d_N89_N111 > dn_N90_N112) ? d_N89_N111 : dn_N90_N112;
	    dc_N91_N113 = HAMT_MAX_LEVEL - 1;
	    /* build collision nodes */
	    while (dc_N91_N113 > wat_N87_N127)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 5;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_5:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 6;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_6:;
}

}
    {
		hp_N101_N123    = erts_produce_heap(factory_N105_N128, HAMT_NODE_BITMAP_SZ(1), HALLOC_EXTRA);
		hp_N101_N123[0] = MAP_HEADER_HAMT_NODE_BITMAP(1 << maskval(v_N94_N116,dc_N91_N113));
		hp_N101_N123[1] = res_N100_N122;
		res_N100_N122   = make_hashmap(hp_N101_N123);
		dc_N91_N113--;
	    }

}

}
	}

}

	/* next depth is higher (implies collision) */
	if (d_N89_N111 < dn_N90_N112)
{
    {
	    /* hdr is the popped one initially */
	    while(d_N89_N111 < dn_N90_N112)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 7;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_7:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 8;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_8:;
}

}
    {
		slot_N92_N114 = maskval(v_N94_N116, d_N89_N111);
		bp_N98_N120   = 1 << slot_N92_N114;
		ESTACK_PUSH(stack_N104_N126, hdr_N97_N119 | bp_N98_N120);
		d_N89_N111++;
		hdr_N97_N119 = 0; /* clear hdr for all other collisions */
	    }

}

}

	    slot_N92_N114 = maskval(v_N94_N116, d_N89_N111);
	    bp_N98_N120   = 1 << slot_N92_N114;
	    /* no more collisions */
            ESTACK_PUSH2(stack_N104_N126,res_N100_N122,bp_N98_N120);
	}

} else
{
{
    if (d_N89_N111 == dn_N90_N112)
{
    {
	    /* no collisions at all */
	    slot_N92_N114 = maskval(v_N94_N116, d_N89_N111);
	    bp_N98_N120   = 1 << slot_N92_N114;
            ESTACK_PUSH2(stack_N104_N126,res_N100_N122,hdr_N97_N119 | bp_N98_N120);
	}

} else
{
    {
	    /* dn < n, we have a drop and we are done
	     * build nodes and subtree */
	    while (dn_N90_N112 != d_N89_N111)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 9;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_9:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 10;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_10:;
}

}
    {
		slot_N92_N114  = maskval(v_N94_N116, d_N89_N111);
		bp_N98_N120    = 1 << slot_N92_N114;
		/* OR bitposition before sz calculation to handle
		 * redundant collisions */
		hdr_N97_N119  |= bp_N98_N120;
		sz_N99_N121    = hashmap_bitcount(hdr_N97_N119);
		hp_N101_N123    = erts_produce_heap(factory_N105_N128, HAMT_NODE_BITMAP_SZ(sz_N99_N121), HALLOC_EXTRA);
		nhp_N102_N124   = hp_N101_N123;
		*hp_N101_N123++ = MAP_HEADER_HAMT_NODE_BITMAP(hdr_N97_N119);
		*hp_N101_N123++ = res_N100_N122; sz_N99_N121--;
		while (sz_N99_N121--)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 11;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_11:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 12;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_12:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 13;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_13:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 14;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_14:;
}

}
    { *hp_N101_N123++ = ESTACK_POP(stack_N104_N126); }

}

}

}

}
		ASSERT((hp_N101_N123 - nhp_N102_N124) < 18);
		res_N100_N122 = make_hashmap(nhp_N102_N124);

		/* we need to pop the next hdr and push if we don't need it */

		hdr_N97_N119 = ESTACK_POP(stack_N104_N126);
		d_N89_N111--;
	    }

}

}
            ESTACK_PUSH2(stack_N104_N126,res_N100_N122,hdr_N97_N119);
	}

}
}

}

	vp_N95_N117 = v_N94_N116;
	v_N94_N116  = vn_N96_N118;
	d_N89_N111  = dn_N90_N112;
	ERTS_FACTORY_HOLE_CHECK(factory_N105_N128);
    }

}

    /* v and vp are reused from above */
    dn_N90_N112  = cdepth(vp_N95_N117,v_N94_N116);
    ix_N88_N110  = ix_N88_N110 + hxns_N106_N129[ix_N88_N110].skip;
    res_N100_N122 = hxns_N106_N129[ix_N88_N110].val;

    if (hxns_N106_N129[ix_N88_N110].skip > 1)
{
    {
	dc_N91_N113 = HAMT_MAX_LEVEL - 1;
	/* build collision nodes */
	while (dc_N91_N113 > dn_N90_N112)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 15;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_15:;
}

}
    {
	    hp_N101_N123    = erts_produce_heap(factory_N105_N128, HAMT_NODE_BITMAP_SZ(1), HALLOC_EXTRA);
	    hp_N101_N123[0] = MAP_HEADER_HAMT_NODE_BITMAP(1 << maskval(v_N94_N116,dc_N91_N113));
	    hp_N101_N123[1] = res_N100_N122;
	    res_N100_N122   = make_hashmap(hp_N101_N123);
	    dc_N91_N113--;
	}

}
    }

}

    hdr_N97_N119 = ESTACK_POP(stack_N104_N126);
    /* pop remaining subtree if any */
    while (dn_N90_N112)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 16;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_16:;
}

}
    {
	slot_N92_N114  = maskval(v_N94_N116, dn_N90_N112);
	bp_N98_N120    = 1 << slot_N92_N114;
	/* OR bitposition before sz calculation to handle
	 * redundant collisions */
	hdr_N97_N119  |= bp_N98_N120;
	sz_N99_N121    = hashmap_bitcount(hdr_N97_N119);
	hp_N101_N123    = erts_produce_heap(factory_N105_N128, HAMT_NODE_BITMAP_SZ(sz_N99_N121), HALLOC_EXTRA);
	nhp_N102_N124   = hp_N101_N123;
	*hp_N101_N123++ = MAP_HEADER_HAMT_NODE_BITMAP(hdr_N97_N119);
	*hp_N101_N123++ = res_N100_N122; sz_N99_N121--;

        ASSERT(ESTACK_COUNT(stack_N104_N126) > sz_N99_N121);

	while (sz_N99_N121--)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 17;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_17:;
}

}

{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 18;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_18:;
}

}
    { *hp_N101_N123++ = ESTACK_POP(stack_N104_N126); }

}

}
	res_N100_N122 = make_hashmap(nhp_N102_N124);
	hdr_N97_N119 = ESTACK_POP(stack_N104_N126);
	dn_N90_N112--;
    }

}

    /* and finally the root .. */

    slot_N92_N114  = maskval(v_N94_N116, dn_N90_N112);
    bp_N98_N120    = 1 << slot_N92_N114;
    hdr_N97_N119  |= bp_N98_N120;
    sz_N99_N121    = hashmap_bitcount(hdr_N97_N119);
    hp_N101_N123    = erts_produce_heap(factory_N105_N128, sz_N99_N121 + /* hdr + item */ 2, 0);
    nhp_N102_N124   = hp_N101_N123;

    *hp_N101_N123++ = (hdr_N97_N119 == 0xffff) ? MAP_HEADER_HAMT_HEAD_ARRAY : MAP_HEADER_HAMT_HEAD_BITMAP(hdr_N97_N119);
    *hp_N101_N123++ = size_N108_N131;

    *hp_N101_N123++ = res_N100_N122; sz_N99_N121--;
    while (sz_N99_N121--)
{
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 19;
  goto ycf_do_yield_label_hashmap_from_chunked_array;
  ycf_yield_location_label_19:;
}

}
    { *hp_N101_N123++ = ESTACK_POP(stack_N104_N126); }

}

    res_N100_N122 = make_hashmap(nhp_N102_N124);

    ASSERT(ESTACK_COUNT(stack_N104_N126) == 0);
    DESTROY_ESTACK_EXPLICIT_DEFAULT_ARRAY(stack_N104_N126, stack_default_estack_N103_N125);
    ERTS_FACTORY_HOLE_CHECK(factory_N105_N128);
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

    return res_N100_N122;
}

{
  struct gen_ycf_trap_state_for_hashmap_from_chunked_array* ycf_my_trap_state;
  ycf_do_yield_label_hashmap_from_chunked_array:;

    {
        ENSURE_ESTACK_HEAP_STACK_ARRAY(stack_N104_N126, stack_default_estack_N103_N125);
    }

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_hashmap_from_chunked_array), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    ycf_my_trap_state->ix_N88_N110 = ix_N88_N110;
    ycf_my_trap_state->d_N89_N111 = d_N89_N111;
    ycf_my_trap_state->dn_N90_N112 = dn_N90_N112;
    ycf_my_trap_state->dc_N91_N113 = dc_N91_N113;
    ycf_my_trap_state->slot_N92_N114 = slot_N92_N114;
    ycf_my_trap_state->elems_N93_N115 = elems_N93_N115;
    ycf_my_trap_state->v_N94_N116 = v_N94_N116;
    ycf_my_trap_state->vp_N95_N117 = vp_N95_N117;
    ycf_my_trap_state->vn_N96_N118 = vn_N96_N118;
    ycf_my_trap_state->hdr_N97_N119 = hdr_N97_N119;
    ycf_my_trap_state->bp_N98_N120 = bp_N98_N120;
    ycf_my_trap_state->sz_N99_N121 = sz_N99_N121;
    ycf_my_trap_state->res_N100_N122 = res_N100_N122;
    ycf_my_trap_state->hp_N101_N123 = hp_N101_N123;
    ycf_my_trap_state->nhp_N102_N124 = nhp_N102_N124;
    memcpy(ycf_my_trap_state->stack_default_estack_N103_N125, stack_default_estack_N103_N125, 16 *  sizeof(
    Eterm));
    ycf_my_trap_state->stack_N104_N126 = stack_N104_N126;
    ycf_my_trap_state->wat_N87_N127 = wat_N87_N127;
    ycf_my_trap_state->factory_N105_N128 = factory_N105_N128;
    ycf_my_trap_state->hxns_N106_N129 = hxns_N106_N129;
    ycf_my_trap_state->n_N107_N130 = n_N107_N130;
    ycf_my_trap_state->size_N108_N131 = size_N108_N131;
    ycf_my_trap_state->temp_memory_allocator_N109_N132 = temp_memory_allocator_N109_N132;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   Eterm  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_maps_keys_1_helper {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm map_N139_N143;
	Eterm *hp_N133_N144;
        Eterm *ks_N134_N145;
        Eterm res_N135_N146;
	flatmap_t *mp_N136_N147;
	Uint n_N137_N148;
        /* YCF cannot handle function calls as return expression */
        BIF_RETTYPE res_N138_N149;

void* ycf_sub_fun_trap_state_wb_N142;Process* p_N140_N150; Eterm* bif_args_N141_N151;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void maps_keys_1_helper_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_maps_keys_1_helper* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm map_N139_N143;
	Eterm *hp_N133_N144;
        Eterm *ks_N134_N145;
        Eterm res_N135_N146;
	flatmap_t *mp_N136_N147;
	Uint n_N137_N148;
        /* YCF cannot handle function calls as return expression */
        BIF_RETTYPE res_N138_N149;

void* ycf_sub_fun_trap_state_wb_N142;Process* p_N140_N150; Eterm* bif_args_N141_N151;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    map_N139_N143 = ycf_my_trap_state->map_N139_N143;
    hp_N133_N144 = ycf_my_trap_state->hp_N133_N144;
    ks_N134_N145 = ycf_my_trap_state->ks_N134_N145;
    res_N135_N146 = ycf_my_trap_state->res_N135_N146;
    mp_N136_N147 = ycf_my_trap_state->mp_N136_N147;
    n_N137_N148 = ycf_my_trap_state->n_N137_N148;
    res_N138_N149 = ycf_my_trap_state->res_N138_N149;
    ycf_sub_fun_trap_state_wb_N142 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N142;
    p_N140_N150 = ycf_my_trap_state->p_N140_N150;
    bif_args_N141_N151 = ycf_my_trap_state->bif_args_N141_N151;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{
  if(ycf_sub_fun_trap_state_wb_N142 != NULL)
{     hashmap_keys_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N142);
  }
}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  BIF_RETTYPE  maps_keys_1_helper_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_maps_keys_1_helper* ycf_my_trap_state = *ycf_trap_state;
return maps_keys_1_helper_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->p_N140_N150,ycf_my_trap_state->bif_args_N141_N151)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */
static BIF_RETTYPE maps_keys_1_helper_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N140_N150, Eterm* bif_args_N141_N151) {
    Eterm map_N139_N143;
	Eterm *hp_N133_N144;
        Eterm *ks_N134_N145;
        Eterm res_N135_N146;
	flatmap_t *mp_N136_N147;
	Uint n_N137_N148;
        /* YCF cannot handle function calls as return expression */
        BIF_RETTYPE res_N138_N149;

void* ycf_sub_fun_trap_state_wb_N142;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_maps_keys_1_helper* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    map_N139_N143 = ycf_my_trap_state->map_N139_N143;
    hp_N133_N144 = ycf_my_trap_state->hp_N133_N144;
    ks_N134_N145 = ycf_my_trap_state->ks_N134_N145;
    res_N135_N146 = ycf_my_trap_state->res_N135_N146;
    mp_N136_N147 = ycf_my_trap_state->mp_N136_N147;
    n_N137_N148 = ycf_my_trap_state->n_N137_N148;
    res_N138_N149 = ycf_my_trap_state->res_N138_N149;
    ycf_sub_fun_trap_state_wb_N142 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N142;
    p_N140_N150 = ycf_my_trap_state->p_N140_N150;
    bif_args_N141_N151 = ycf_my_trap_state->bif_args_N141_N151;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;

}
  }
}
{

ycf_sub_fun_trap_state_wb_N142 = NULL;

}
    map_N139_N143 = bif_args_N141_N151[0];
    if (is_flatmap(map_N139_N143))
{
    {
        res_N135_N146 = NIL;

	mp_N136_N147  = (flatmap_t*)flatmap_val(map_N139_N143);
	n_N137_N148   = flatmap_get_size(mp_N136_N147);

	if (n_N137_N148 == 0)
{
{
   
	    BIF_RET(res_N135_N146);
}

}

	hp_N133_N144  = HAlloc(p_N140_N150, (2 * n_N137_N148));
	ks_N134_N145  = flatmap_get_keys(mp_N136_N147);

	while(n_N137_N148--)
{
    {
	    res_N135_N146 = CONS(hp_N133_N144, ks_N134_N145[n_N137_N148], res_N135_N146); hp_N133_N144 += 2;
	}

}
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


	return res_N135_N146;
}
    }

} else
{
{
    if (is_hashmap(bif_args_N141_N151[0]))
{
    {
{


ycf_sub_fun_trap_state_wb_N142 = NULL;
{
  Eterm  ycf_tmp_fun_call_tmp_var;
ycf_tmp_fun_call_tmp_var =  hashmap_keys_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N142,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,p_N140_N150, map_N139_N143);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N142)){
   ycf_trap_location = 1;
   goto ycf_do_yield_label_maps_keys_1_helper;
  ycf_yield_location_label_1:;
   ycf_tmp_fun_call_tmp_var =  hashmap_keys_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N142,
                            ycf_extra_context);
}

        /* YCF cannot handle function calls as return expression */
        res_N138_N149 = ycf_tmp_fun_call_tmp_var;


}
/* YCF Replaced special code */

}

{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


	return res_N138_N149;
}
    }

}
}

}
    p_N140_N150->fvalue = map_N139_N143;
    (p_N140_N150)->freason = BADMAP;
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

    return THE_NON_VALUE;
}

{
  struct gen_ycf_trap_state_for_maps_keys_1_helper* ycf_my_trap_state;
  ycf_do_yield_label_maps_keys_1_helper:;
  
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_maps_keys_1_helper), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    ycf_my_trap_state->map_N139_N143 = map_N139_N143;
    ycf_my_trap_state->hp_N133_N144 = hp_N133_N144;
    ycf_my_trap_state->ks_N134_N145 = ks_N134_N145;
    ycf_my_trap_state->res_N135_N146 = res_N135_N146;
    ycf_my_trap_state->mp_N136_N147 = mp_N136_N147;
    ycf_my_trap_state->n_N137_N148 = n_N137_N148;
    ycf_my_trap_state->res_N138_N149 = res_N138_N149;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N142 = ycf_sub_fun_trap_state_wb_N142;
    ycf_my_trap_state->p_N140_N150 = p_N140_N150;
    ycf_my_trap_state->bif_args_N141_N151 = bif_args_N141_N151;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   BIF_RETTYPE  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_maps_values_1_helper {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm map_N158_N162;
        Eterm *hp_N152_N163;
        Eterm *vs_N153_N164;
        Eterm res_N154_N165;
	flatmap_t *mp_N155_N166;
	Uint n_N156_N167;
        /* YCF cannot handle function calls as return expression */
        BIF_RETTYPE res_N157_N168;

void* ycf_sub_fun_trap_state_wb_N161;Process* p_N159_N169; Eterm* bif_args_N160_N170;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void maps_values_1_helper_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_maps_values_1_helper* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm map_N158_N162;
        Eterm *hp_N152_N163;
        Eterm *vs_N153_N164;
        Eterm res_N154_N165;
	flatmap_t *mp_N155_N166;
	Uint n_N156_N167;
        /* YCF cannot handle function calls as return expression */
        BIF_RETTYPE res_N157_N168;

void* ycf_sub_fun_trap_state_wb_N161;Process* p_N159_N169; Eterm* bif_args_N160_N170;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    map_N158_N162 = ycf_my_trap_state->map_N158_N162;
    hp_N152_N163 = ycf_my_trap_state->hp_N152_N163;
    vs_N153_N164 = ycf_my_trap_state->vs_N153_N164;
    res_N154_N165 = ycf_my_trap_state->res_N154_N165;
    mp_N155_N166 = ycf_my_trap_state->mp_N155_N166;
    n_N156_N167 = ycf_my_trap_state->n_N156_N167;
    res_N157_N168 = ycf_my_trap_state->res_N157_N168;
    ycf_sub_fun_trap_state_wb_N161 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N161;
    p_N159_N169 = ycf_my_trap_state->p_N159_N169;
    bif_args_N160_N170 = ycf_my_trap_state->bif_args_N160_N170;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{
  if(ycf_sub_fun_trap_state_wb_N161 != NULL)
{     hashmap_values_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N161);
  }
}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  BIF_RETTYPE  maps_values_1_helper_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_maps_values_1_helper* ycf_my_trap_state = *ycf_trap_state;
return maps_values_1_helper_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->p_N159_N169,ycf_my_trap_state->bif_args_N160_N170)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */
static BIF_RETTYPE maps_values_1_helper_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N159_N169, Eterm* bif_args_N160_N170) {
    Eterm map_N158_N162;
        Eterm *hp_N152_N163;
        Eterm *vs_N153_N164;
        Eterm res_N154_N165;
	flatmap_t *mp_N155_N166;
	Uint n_N156_N167;
        /* YCF cannot handle function calls as return expression */
        BIF_RETTYPE res_N157_N168;

void* ycf_sub_fun_trap_state_wb_N161;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_maps_values_1_helper* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    map_N158_N162 = ycf_my_trap_state->map_N158_N162;
    hp_N152_N163 = ycf_my_trap_state->hp_N152_N163;
    vs_N153_N164 = ycf_my_trap_state->vs_N153_N164;
    res_N154_N165 = ycf_my_trap_state->res_N154_N165;
    mp_N155_N166 = ycf_my_trap_state->mp_N155_N166;
    n_N156_N167 = ycf_my_trap_state->n_N156_N167;
    res_N157_N168 = ycf_my_trap_state->res_N157_N168;
    ycf_sub_fun_trap_state_wb_N161 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N161;
    p_N159_N169 = ycf_my_trap_state->p_N159_N169;
    bif_args_N160_N170 = ycf_my_trap_state->bif_args_N160_N170;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;

}
  }
}
{

ycf_sub_fun_trap_state_wb_N161 = NULL;

}
    map_N158_N162 = bif_args_N160_N170[0];
    if (is_flatmap(map_N158_N162))
{
    {
        res_N154_N165 = NIL;

	mp_N155_N166  = (flatmap_t*)flatmap_val(map_N158_N162);
	n_N156_N167   = flatmap_get_size(mp_N155_N166);

	if (n_N156_N167 == 0)
{
{
   
	    BIF_RET(res_N154_N165);
}

}

	hp_N152_N163  = HAlloc(p_N159_N169, (2 * n_N156_N167));
	vs_N153_N164  = flatmap_get_values(mp_N155_N166);

	while(n_N156_N167--)
{
    {
	    res_N154_N165 = CONS(hp_N152_N163, vs_N153_N164[n_N156_N167], res_N154_N165); hp_N152_N163 += 2;
	}

}
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


	return res_N154_N165;
}
    }

} else
{
{
    if (is_hashmap(map_N158_N162))
{
    {
{


ycf_sub_fun_trap_state_wb_N161 = NULL;
{
  Eterm  ycf_tmp_fun_call_tmp_var;
ycf_tmp_fun_call_tmp_var =  hashmap_values_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N161,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,p_N159_N169, map_N158_N162);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N161)){
   ycf_trap_location = 1;
   goto ycf_do_yield_label_maps_values_1_helper;
  ycf_yield_location_label_1:;
   ycf_tmp_fun_call_tmp_var =  hashmap_values_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N161,
                            ycf_extra_context);
}

        /* YCF cannot handle function calls as return expression */
        res_N157_N168 = ycf_tmp_fun_call_tmp_var;


}
/* YCF Replaced special code */

}

{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


	return res_N157_N168;
}
    }

}
}

}
    p_N159_N169->fvalue = map_N158_N162;
    (p_N159_N169)->freason = BADMAP;
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

    return THE_NON_VALUE;
}

{
  struct gen_ycf_trap_state_for_maps_values_1_helper* ycf_my_trap_state;
  ycf_do_yield_label_maps_values_1_helper:;
  
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_maps_values_1_helper), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    ycf_my_trap_state->map_N158_N162 = map_N158_N162;
    ycf_my_trap_state->hp_N152_N163 = hp_N152_N163;
    ycf_my_trap_state->vs_N153_N164 = vs_N153_N164;
    ycf_my_trap_state->res_N154_N165 = res_N154_N165;
    ycf_my_trap_state->mp_N155_N166 = mp_N155_N166;
    ycf_my_trap_state->n_N156_N167 = n_N156_N167;
    ycf_my_trap_state->res_N157_N168 = res_N157_N168;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N161 = ycf_sub_fun_trap_state_wb_N161;
    ycf_my_trap_state->p_N159_N169 = p_N159_N169;
    ycf_my_trap_state->bif_args_N160_N170 = bif_args_N160_N170;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   BIF_RETTYPE  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_maps_from_keys_2_helper {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm list_N171_N179;
    Eterm value_N172_N180;
    Eterm item_N173_N181;
    Eterm res_N174_N182;
    Uint  size_N175_N183;

void* ycf_sub_fun_trap_state_wb_N178;Process* p_N176_N184; Eterm* bif_args_N177_N185;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void maps_from_keys_2_helper_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_maps_from_keys_2_helper* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm list_N171_N179;
    Eterm value_N172_N180;
    Eterm item_N173_N181;
    Eterm res_N174_N182;
    Uint  size_N175_N183;

void* ycf_sub_fun_trap_state_wb_N178;Process* p_N176_N184; Eterm* bif_args_N177_N185;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    list_N171_N179 = ycf_my_trap_state->list_N171_N179;
    value_N172_N180 = ycf_my_trap_state->value_N172_N180;
    item_N173_N181 = ycf_my_trap_state->item_N173_N181;
    res_N174_N182 = ycf_my_trap_state->res_N174_N182;
    size_N175_N183 = ycf_my_trap_state->size_N175_N183;
    ycf_sub_fun_trap_state_wb_N178 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N178;
    p_N176_N184 = ycf_my_trap_state->p_N176_N184;
    bif_args_N177_N185 = ycf_my_trap_state->bif_args_N177_N185;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{
  if(ycf_sub_fun_trap_state_wb_N178 != NULL)
{     hashmap_from_validated_list_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N178);
  }
}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  BIF_RETTYPE  maps_from_keys_2_helper_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_maps_from_keys_2_helper* ycf_my_trap_state = *ycf_trap_state;
return maps_from_keys_2_helper_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->p_N176_N184,ycf_my_trap_state->bif_args_N177_N185)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */
static BIF_RETTYPE maps_from_keys_2_helper_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N176_N184, Eterm* bif_args_N177_N185) {
    Eterm list_N171_N179;
    Eterm value_N172_N180;
    Eterm item_N173_N181;
    Eterm res_N174_N182;
    Uint  size_N175_N183;

void* ycf_sub_fun_trap_state_wb_N178;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_maps_from_keys_2_helper* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    list_N171_N179 = ycf_my_trap_state->list_N171_N179;
    value_N172_N180 = ycf_my_trap_state->value_N172_N180;
    item_N173_N181 = ycf_my_trap_state->item_N173_N181;
    res_N174_N182 = ycf_my_trap_state->res_N174_N182;
    size_N175_N183 = ycf_my_trap_state->size_N175_N183;
    ycf_sub_fun_trap_state_wb_N178 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N178;
    p_N176_N184 = ycf_my_trap_state->p_N176_N184;
    bif_args_N177_N185 = ycf_my_trap_state->bif_args_N177_N185;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;
case 2: goto ycf_yield_location_label_2;

}
  }
}
{

ycf_sub_fun_trap_state_wb_N178 = NULL;

}
    list_N171_N179 = bif_args_N177_N185[0];
    value_N172_N180 = bif_args_N177_N185[1];
    item_N173_N181 = list_N171_N179;
    size_N175_N183 = 0;
    if (is_list(item_N173_N181) || is_nil(item_N173_N181))
{
    {
        /* Calculate size and check validity */
        while(is_list(item_N173_N181))
{
    {
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 2;
  goto ycf_do_yield_label_maps_from_keys_2_helper;
  ycf_yield_location_label_2:;
}

}
            size_N175_N183++;
            item_N173_N181 = CDR(list_val(item_N173_N181));
        }

}

        if (is_not_nil(item_N173_N181))
{
{
   
            goto error;
}

}

        if (size_N175_N183 > MAP_SMALL_MAP_LIMIT)
{
    {
{


ycf_sub_fun_trap_state_wb_N178 = NULL;
{
  Eterm  ycf_tmp_fun_call_tmp_var;
ycf_tmp_fun_call_tmp_var =  hashmap_from_validated_list_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N178,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,p_N176_N184, list_N171_N179, value_N172_N180, size_N175_N183);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N178)){
   ycf_trap_location = 1;
   goto ycf_do_yield_label_maps_from_keys_2_helper;
  ycf_yield_location_label_1:;
   ycf_tmp_fun_call_tmp_var =  hashmap_from_validated_list_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N178,
                            ycf_extra_context);
}

            /* Cannot put call in return statement because
               YCF cannot handle that */
            res_N174_N182 = ycf_tmp_fun_call_tmp_var;


}
/* YCF Replaced special code */

}

{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


            return res_N174_N182;
}
        }

} else
{
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

            /* We don't yield while constructing flatmap because
               MAP_SMALL_MAP_LIMIT is small */
	    return flatmap_from_validated_list(p_N176_N184, list_N171_N179, value_N172_N180, size_N175_N183);
}

}
    }

}

error:

    BIF_ERROR(p_N176_N184, BADARG);

{
  struct gen_ycf_trap_state_for_maps_from_keys_2_helper* ycf_my_trap_state;
  ycf_do_yield_label_maps_from_keys_2_helper:;
  
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_maps_from_keys_2_helper), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    ycf_my_trap_state->list_N171_N179 = list_N171_N179;
    ycf_my_trap_state->value_N172_N180 = value_N172_N180;
    ycf_my_trap_state->item_N173_N181 = item_N173_N181;
    ycf_my_trap_state->res_N174_N182 = res_N174_N182;
    ycf_my_trap_state->size_N175_N183 = size_N175_N183;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N178 = ycf_sub_fun_trap_state_wb_N178;
    ycf_my_trap_state->p_N176_N184 = p_N176_N184;
    ycf_my_trap_state->bif_args_N177_N185 = bif_args_N177_N185;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   BIF_RETTYPE  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_maps_from_list_1_helper {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm list_N186_N194;
    Eterm res_N187_N195;
    Eterm *kv_N188_N196;
    Uint  size_N189_N197;
    Eterm item_N190_N198;

void* ycf_sub_fun_trap_state_wb_N193;Process* p_N191_N199; Eterm* bif_args_N192_N200;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void maps_from_list_1_helper_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_maps_from_list_1_helper* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm list_N186_N194;
    Eterm res_N187_N195;
    Eterm *kv_N188_N196;
    Uint  size_N189_N197;
    Eterm item_N190_N198;

void* ycf_sub_fun_trap_state_wb_N193;Process* p_N191_N199; Eterm* bif_args_N192_N200;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    list_N186_N194 = ycf_my_trap_state->list_N186_N194;
    res_N187_N195 = ycf_my_trap_state->res_N187_N195;
    kv_N188_N196 = ycf_my_trap_state->kv_N188_N196;
    size_N189_N197 = ycf_my_trap_state->size_N189_N197;
    item_N190_N198 = ycf_my_trap_state->item_N190_N198;
    ycf_sub_fun_trap_state_wb_N193 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N193;
    p_N191_N199 = ycf_my_trap_state->p_N191_N199;
    bif_args_N192_N200 = ycf_my_trap_state->bif_args_N192_N200;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{
  if(ycf_sub_fun_trap_state_wb_N193 != NULL)
{     hashmap_from_validated_list_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N193);
  }
}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  BIF_RETTYPE  maps_from_list_1_helper_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_maps_from_list_1_helper* ycf_my_trap_state = *ycf_trap_state;
return maps_from_list_1_helper_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->p_N191_N199,ycf_my_trap_state->bif_args_N192_N200)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */
static BIF_RETTYPE maps_from_list_1_helper_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process* p_N191_N199, Eterm* bif_args_N192_N200) {
    Eterm list_N186_N194;
    Eterm res_N187_N195;
    Eterm *kv_N188_N196;
    Uint  size_N189_N197;
    Eterm item_N190_N198;

void* ycf_sub_fun_trap_state_wb_N193;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_maps_from_list_1_helper* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    list_N186_N194 = ycf_my_trap_state->list_N186_N194;
    res_N187_N195 = ycf_my_trap_state->res_N187_N195;
    kv_N188_N196 = ycf_my_trap_state->kv_N188_N196;
    size_N189_N197 = ycf_my_trap_state->size_N189_N197;
    item_N190_N198 = ycf_my_trap_state->item_N190_N198;
    ycf_sub_fun_trap_state_wb_N193 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N193;
    p_N191_N199 = ycf_my_trap_state->p_N191_N199;
    bif_args_N192_N200 = ycf_my_trap_state->bif_args_N192_N200;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;
case 2: goto ycf_yield_location_label_2;

}
  }
}
{

ycf_sub_fun_trap_state_wb_N193 = NULL;

}
    list_N186_N194 = bif_args_N192_N200[0];
    size_N189_N197 = 0;
    item_N190_N198 = list_N186_N194;
    if (is_list(item_N190_N198) || is_nil(item_N190_N198))
{
    {

	/* Calculate size and check validity */

	while(is_list(item_N190_N198))
{
    {
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 2;
  goto ycf_do_yield_label_maps_from_list_1_helper;
  ycf_yield_location_label_2:;
}

}
	    res_N187_N195 = CAR(list_val(item_N190_N198));
	    if (is_not_tuple(res_N187_N195))
{
{
   
		goto error;
}

}

	    kv_N188_N196 = tuple_val(res_N187_N195);
	    if (*kv_N188_N196 != make_arityval(2))
{
{
   
		goto error;
}

}

	    size_N189_N197++;
	    item_N190_N198 = CDR(list_val(item_N190_N198));
	}

}

	if (is_not_nil(item_N190_N198))
{
{
   
	    goto error;
}

}

	if (size_N189_N197 > MAP_SMALL_MAP_LIMIT)
{
    {
{


ycf_sub_fun_trap_state_wb_N193 = NULL;
{
  Eterm  ycf_tmp_fun_call_tmp_var;
ycf_tmp_fun_call_tmp_var =  hashmap_from_validated_list_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N193,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,p_N191_N199, list_N186_N194, THE_NON_VALUE, size_N189_N197);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N193)){
   ycf_trap_location = 1;
   goto ycf_do_yield_label_maps_from_list_1_helper;
  ycf_yield_location_label_1:;
   ycf_tmp_fun_call_tmp_var =  hashmap_from_validated_list_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N193,
                            ycf_extra_context);
}

            /* Cannot put call in return statement because
               YCF cannot handle that */
            res_N187_N195 = ycf_tmp_fun_call_tmp_var;


}
/* YCF Replaced special code */

}

{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


            return res_N187_N195;
}
	}

} else
{
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

            /* We don't yield while constructing flatmap because
               MAP_SMALL_MAP_LIMIT is small */
	    return flatmap_from_validated_list(p_N191_N199, list_N186_N194, THE_NON_VALUE, size_N189_N197);
}

}
    }

}

error:

    BIF_ERROR(p_N191_N199, BADARG);

{
  struct gen_ycf_trap_state_for_maps_from_list_1_helper* ycf_my_trap_state;
  ycf_do_yield_label_maps_from_list_1_helper:;
  
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_maps_from_list_1_helper), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    ycf_my_trap_state->list_N186_N194 = list_N186_N194;
    ycf_my_trap_state->res_N187_N195 = res_N187_N195;
    ycf_my_trap_state->kv_N188_N196 = kv_N188_N196;
    ycf_my_trap_state->size_N189_N197 = size_N189_N197;
    ycf_my_trap_state->item_N190_N198 = item_N190_N198;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N193 = ycf_sub_fun_trap_state_wb_N193;
    ycf_my_trap_state->p_N191_N199 = p_N191_N199;
    ycf_my_trap_state->bif_args_N192_N200 = bif_args_N192_N200;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   BIF_RETTYPE  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN



struct gen_ycf_trap_state_for_hashmap_from_validated_list {
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm item_N207_N223;
    Eterm *hp_N208_N224;
    Eterm *kv_N209_N225;
    Eterm res_N210_N226;
    Eterm key_N211_N227;
    Eterm value_N212_N228;
    erts_ihash_t sw_N213_N229;
    erts_ihash_t hx_N214_N230;
    Uint ix_N215_N231;
    hxnode_t *hxns_N216_N232;
    ErtsHeapFactory *factory_N217_N233;
	Eterm *kv_N201_N234;
        Eterm *ks_N202_N235;
        Eterm *vs_N203_N236;
	flatmap_t *mp_N204_N237;
	Eterm keys_N205_N238;
        Uint n_N206_N239;
void* ycf_sub_fun_trap_state_wb_N222;Process *p_N218_N240;
                                         Eterm list_N219_N241;
                                         Eterm fill_value_N220_N242;
                                         Uint size_N221_N243;
};


/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

static void hashmap_from_validated_list_ycf_gen_destroy(void* ycf_my_trap_state_param){
     {
     struct gen_ycf_trap_state_for_hashmap_from_validated_list* ycf_my_trap_state = ycf_my_trap_state_param;
     
ycf_yield_alloc_type ycf_yield_alloc;
ycf_yield_free_type ycf_yield_free;
void* ycf_yield_alloc_free_context;
size_t ycf_stack_alloc_size_or_max_size;
void* ycf_stack_alloc_data;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;
    Eterm item_N207_N223;
    Eterm *hp_N208_N224;
    Eterm *kv_N209_N225;
    Eterm res_N210_N226;
    Eterm key_N211_N227;
    Eterm value_N212_N228;
    erts_ihash_t sw_N213_N229;
    erts_ihash_t hx_N214_N230;
    Uint ix_N215_N231;
    hxnode_t *hxns_N216_N232;
    ErtsHeapFactory *factory_N217_N233;
	Eterm *kv_N201_N234;
        Eterm *ks_N202_N235;
        Eterm *vs_N203_N236;
	flatmap_t *mp_N204_N237;
	Eterm keys_N205_N238;
        Uint n_N206_N239;
void* ycf_sub_fun_trap_state_wb_N222;Process *p_N218_N240;
                                         Eterm list_N219_N241;
                                         Eterm fill_value_N220_N242;
                                         Uint size_N221_N243;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    item_N207_N223 = ycf_my_trap_state->item_N207_N223;
    hp_N208_N224 = ycf_my_trap_state->hp_N208_N224;
    kv_N209_N225 = ycf_my_trap_state->kv_N209_N225;
    res_N210_N226 = ycf_my_trap_state->res_N210_N226;
    key_N211_N227 = ycf_my_trap_state->key_N211_N227;
    value_N212_N228 = ycf_my_trap_state->value_N212_N228;
    sw_N213_N229 = ycf_my_trap_state->sw_N213_N229;
    hx_N214_N230 = ycf_my_trap_state->hx_N214_N230;
    ix_N215_N231 = ycf_my_trap_state->ix_N215_N231;
    hxns_N216_N232 = ycf_my_trap_state->hxns_N216_N232;
    factory_N217_N233 = ycf_my_trap_state->factory_N217_N233;
    kv_N201_N234 = ycf_my_trap_state->kv_N201_N234;
    ks_N202_N235 = ycf_my_trap_state->ks_N202_N235;
    vs_N203_N236 = ycf_my_trap_state->vs_N203_N236;
    mp_N204_N237 = ycf_my_trap_state->mp_N204_N237;
    keys_N205_N238 = ycf_my_trap_state->keys_N205_N238;
    n_N206_N239 = ycf_my_trap_state->n_N206_N239;
    ycf_sub_fun_trap_state_wb_N222 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N222;
    p_N218_N240 = ycf_my_trap_state->p_N218_N240;
    list_N219_N241 = ycf_my_trap_state->list_N219_N241;
    fill_value_N220_N242 = ycf_my_trap_state->fill_value_N220_N242;
    size_N221_N243 = ycf_my_trap_state->size_N221_N243;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     
/* YCF SPECIAL CUSTOM CODE START */
{
  if(ycf_sub_fun_trap_state_wb_N222 != NULL)
{     hashmap_from_unsorted_array_ycf_gen_destroy(ycf_sub_fun_trap_state_wb_N222);
  }
}
{

    {
        if (hxns_N216_N232 != NULL) {
            /* Execution of this function got destroyed while yielding in
               the loop above */
            erts_free(ERTS_ALC_T_MAP_TRAP, (void *) hxns_N216_N232);
        }
    }}

/* YCF SPECIAL CUSTOM CODE END */

     ycf_destroy_stack_allocator(&ycf_frame_alloc_data, ycf_yield_free, ycf_yield_alloc_free_context);
     ycf_yield_free(ycf_my_trap_state, ycf_yield_alloc_free_context);
     }
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unused-but-set-variable)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */


/* clang-format off */
YCF_GCC_DIAG_OFF(unused-function)
/* clang-format on */

   static  Eterm  hashmap_from_validated_list_ycf_gen_continue(long* ycf_number_of_reduction_param,
                       void** ycf_trap_state,
                       void* ycf_extra_context){
     struct gen_ycf_trap_state_for_hashmap_from_validated_list* ycf_my_trap_state = *ycf_trap_state;
return hashmap_from_validated_list_ycf_gen_yielding(ycf_number_of_reduction_param,
                    ycf_trap_state,
                    ycf_extra_context,
                    ycf_my_trap_state->ycf_yield_alloc,
                    ycf_my_trap_state->ycf_yield_free,
                    ycf_my_trap_state->ycf_yield_alloc_free_context,
                    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size,
                    ycf_my_trap_state->ycf_stack_alloc_data
                    ,ycf_my_trap_state->p_N218_N240,ycf_my_trap_state->list_N219_N241,ycf_my_trap_state->fill_value_N220_N242,ycf_my_trap_state->size_N221_N243)
;
}
/* clang-format off */
YCF_GCC_DIAG_ON(unused-function)
/* clang-format on */

#define YCF_IN_YIELDING_FUN 1
#undef YCF_STACK_ALLOC
#define YCF_STACK_ALLOC(SIZE) \
    ycf_stack_alloc(SIZE,\
                    &ycf_frame_alloc_data,\
                    ycf_yield_alloc, ycf_yield_alloc_free_context,\
                     ycf_stack_alloc_size_or_max_size)

/* clang-format off */
YCF_GCC_DIAG_OFF(pragmas)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_OFF(uninitialized)
/* clang-format on */
static Eterm hashmap_from_validated_list_ycf_gen_yielding(
long* ycf_nr_of_reductions_param,
void** ycf_trap_state,
void* ycf_extra_context,
ycf_yield_alloc_type ycf_yield_alloc,
ycf_yield_free_type ycf_yield_free,
void* ycf_yield_alloc_free_context,
size_t ycf_stack_alloc_size_or_max_size,
void* ycf_stack_alloc_data,Process *p_N218_N240,
                                         Eterm list_N219_N241,
                                         Eterm fill_value_N220_N242,
                                         Uint size_N221_N243) {
    Eterm item_N207_N223;
    Eterm *hp_N208_N224;
    Eterm *kv_N209_N225;
    Eterm res_N210_N226;
    Eterm key_N211_N227;
    Eterm value_N212_N228;
    erts_ihash_t sw_N213_N229;
    erts_ihash_t hx_N214_N230;
    Uint ix_N215_N231;
    hxnode_t *hxns_N216_N232;
    ErtsHeapFactory *factory_N217_N233;
	Eterm *kv_N201_N234;
        Eterm *ks_N202_N235;
        Eterm *vs_N203_N236;
	flatmap_t *mp_N204_N237;
	Eterm keys_N205_N238;
        Uint n_N206_N239;
void* ycf_sub_fun_trap_state_wb_N222;
int ycf_trap_location;
long ycf_nr_of_reductions;
struct ycf_alloc_data ycf_frame_alloc_data;

{
  
  ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
  ycf_frame_alloc_data.size = 0;
  ycf_frame_alloc_data.max_size = ycf_stack_alloc_size_or_max_size;
  ycf_frame_alloc_data.data = ycf_stack_alloc_data;
  ycf_frame_alloc_data.needs_freeing = 0;
  if(*ycf_trap_state != NULL){
     struct gen_ycf_trap_state_for_hashmap_from_validated_list* ycf_my_trap_state = *ycf_trap_state;
     
    ycf_yield_alloc = ycf_my_trap_state->ycf_yield_alloc;
    ycf_yield_free = ycf_my_trap_state->ycf_yield_free;
    ycf_yield_alloc_free_context = ycf_my_trap_state->ycf_yield_alloc_free_context;
    ycf_stack_alloc_size_or_max_size = ycf_my_trap_state->ycf_stack_alloc_size_or_max_size;
    ycf_stack_alloc_data = ycf_my_trap_state->ycf_stack_alloc_data;
    ycf_trap_location = ycf_my_trap_state->ycf_trap_location;
    ycf_nr_of_reductions = ycf_my_trap_state->ycf_nr_of_reductions;
    ycf_frame_alloc_data = ycf_my_trap_state->ycf_frame_alloc_data;
    item_N207_N223 = ycf_my_trap_state->item_N207_N223;
    hp_N208_N224 = ycf_my_trap_state->hp_N208_N224;
    kv_N209_N225 = ycf_my_trap_state->kv_N209_N225;
    res_N210_N226 = ycf_my_trap_state->res_N210_N226;
    key_N211_N227 = ycf_my_trap_state->key_N211_N227;
    value_N212_N228 = ycf_my_trap_state->value_N212_N228;
    sw_N213_N229 = ycf_my_trap_state->sw_N213_N229;
    hx_N214_N230 = ycf_my_trap_state->hx_N214_N230;
    ix_N215_N231 = ycf_my_trap_state->ix_N215_N231;
    hxns_N216_N232 = ycf_my_trap_state->hxns_N216_N232;
    factory_N217_N233 = ycf_my_trap_state->factory_N217_N233;
    kv_N201_N234 = ycf_my_trap_state->kv_N201_N234;
    ks_N202_N235 = ycf_my_trap_state->ks_N202_N235;
    vs_N203_N236 = ycf_my_trap_state->vs_N203_N236;
    mp_N204_N237 = ycf_my_trap_state->mp_N204_N237;
    keys_N205_N238 = ycf_my_trap_state->keys_N205_N238;
    n_N206_N239 = ycf_my_trap_state->n_N206_N239;
    ycf_sub_fun_trap_state_wb_N222 = ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N222;
    p_N218_N240 = ycf_my_trap_state->p_N218_N240;
    list_N219_N241 = ycf_my_trap_state->list_N219_N241;
    fill_value_N220_N242 = ycf_my_trap_state->fill_value_N220_N242;
    size_N221_N243 = ycf_my_trap_state->size_N221_N243;

     
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

     ycf_nr_of_reductions = *ycf_nr_of_reductions_param;
     switch(ycf_trap_location){
case 1: goto ycf_yield_location_label_1;
case 2: goto ycf_yield_location_label_2;

}
  }
}
{

ycf_sub_fun_trap_state_wb_N222 = NULL;

}
    item_N207_N223 = list_N219_N241;
    ix_N215_N231 = 0;
#ifdef NOT_YCF_YIELDING_VERSION
    /* Macro to make YCF ignore declarations */
#define YCF_IGNORE(X) X
    YCF_IGNORE(ErtsHeapFactory factory_instance;)
#undef YCF_IGNORE
    factory_N217_N233 = &factory_instance;
#else
    factory_N217_N233 = YCF_STACK_ALLOC(sizeof(ErtsHeapFactory));
#endif
    ASSERT(size_N221_N243 > 0);

    hp_N208_N224 = HAlloc(p_N218_N240, (2 * size_N221_N243));

    /* create tmp hx values and leaf ptrs */
    hxns_N216_N232 = (hxnode_t *)erts_alloc(ERTS_ALC_T_MAP_TRAP, size_N221_N243 * sizeof(hxnode_t));

    while(is_list(item_N207_N223))
{
    {
{
ycf_nr_of_reductions = ycf_nr_of_reductions - (1);
if (ycf_nr_of_reductions <= 0) {
  ycf_trap_location = 2;
  goto ycf_do_yield_label_hashmap_from_validated_list;
  ycf_yield_location_label_2:;
}

}
	res_N210_N226 = CAR(list_val(item_N207_N223));
	if(is_value(fill_value_N220_N242))
{
    {
	    key_N211_N227 = res_N210_N226;
	    value_N212_N228 = fill_value_N220_N242;
	}

} else
{
    {
	    kv_N209_N225 = tuple_val(res_N210_N226);
	    key_N211_N227 = kv_N209_N225[1];
	    value_N212_N228 = kv_N209_N225[2];
	}

}
	hx_N214_N230  = hashmap_restore_hash(0,key_N211_N227);
	sw_N213_N229 = swizzle_map_hash(hx_N214_N230);
	hxns_N216_N232[ix_N215_N231].hx   = sw_N213_N229;
	hxns_N216_N232[ix_N215_N231].val  = CONS(hp_N208_N224, key_N211_N227, value_N212_N228); hp_N208_N224 += 2;
	hxns_N216_N232[ix_N215_N231].skip = 1; /* will be reassigned in from_array */
	hxns_N216_N232[ix_N215_N231].i    = ix_N215_N231;
	ix_N215_N231++;
	item_N207_N223 = CDR(list_val(item_N207_N223));
    }

}

    erts_factory_proc_init(factory_N217_N233, p_N218_N240);
{

ycf_sub_fun_trap_state_wb_N222 = NULL;
{
  Eterm  ycf_tmp_fun_call_tmp_var;
ycf_tmp_fun_call_tmp_var =  hashmap_from_unsorted_array_ycf_gen_yielding(&ycf_nr_of_reductions,
                         &ycf_sub_fun_trap_state_wb_N222,ycf_extra_context,
                         ycf_yield_alloc,ycf_yield_free,
                         ycf_yield_alloc_free_context,
                         YCF_ALLOC_NEXT_MAX_SIZE(),
                         YCF_ALLOC_NEXT_BLOCK()
                         ,factory_N217_N233, hxns_N216_N232, size_N221_N243, 0, ERTS_ALC_T_MAP_TRAP);
while(YCF_IS_YIELDED(ycf_sub_fun_trap_state_wb_N222)){
   ycf_trap_location = 1;
   goto ycf_do_yield_label_hashmap_from_validated_list;
  ycf_yield_location_label_1:;
   ycf_tmp_fun_call_tmp_var =  hashmap_from_unsorted_array_ycf_gen_continue(&ycf_nr_of_reductions,
                            &ycf_sub_fun_trap_state_wb_N222,
                            ycf_extra_context);
}

    res_N210_N226 = ycf_tmp_fun_call_tmp_var;


}
/* YCF Replaced special code */

}

    erts_factory_close(factory_N217_N233);
/* YCF Replaced special code */


    erts_free(ERTS_ALC_T_MAP_TRAP, (void *) hxns_N216_N232);
    /* Memory management depends on the line below */
    hxns_N216_N232 = NULL;
    ERTS_VERIFY_UNUSED_TEMP_ALLOC(p_N218_N240);
    
   /* No yielding in the loops below as the number of loop
      iterations must be small */

    if (hashmap_size(res_N210_N226) <= MAP_SMALL_MAP_LIMIT)
{
    {
        DECLARE_WSTACK(wstack);
{

/* moved declaration (kv)*/

}
{

/* moved declaration (ks)*/

}
{

/* moved declaration (vs)*/

}
{

/* moved declaration (mp)*/

}
{

/* moved declaration (keys)*/

}
        n_N206_N239 = hashmap_size(res_N210_N226);
        ASSERT(n_N206_N239 > 0);
	/* build flat structure */
	hp_N208_N224    = HAlloc(p_N218_N240, 3 + 1 + (2 * n_N206_N239));
	keys_N205_N238  = make_tuple(hp_N208_N224);
	*hp_N208_N224++ = make_arityval(n_N206_N239);
	ks_N202_N235    = hp_N208_N224;
	hp_N208_N224   += n_N206_N239;
	mp_N204_N237    = (flatmap_t*)hp_N208_N224;
	hp_N208_N224   += MAP_HEADER_FLATMAP_SZ;
	vs_N203_N236    = hp_N208_N224;

	mp_N204_N237->thing_word = MAP_HEADER_FLATMAP;
	mp_N204_N237->size = n_N206_N239;
	mp_N204_N237->keys = keys_N205_N238;

	hashmap_iterator_init(&wstack, res_N210_N226, 0);

	while ((kv_N201_N234=hashmap_iterator_next(&wstack)) != NULL)
{
    {
	    *ks_N202_N235++ = CAR(kv_N201_N234);
	    *vs_N203_N236++ = CDR(kv_N201_N234);
	}

}

	/* it cannot have multiple keys */
	erts_validate_and_sort_flatmap(mp_N204_N237);

	DESTROY_WSTACK(wstack);
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

	return make_flatmap(mp_N204_N237);
}
    }

}
{

if (*ycf_trap_state != NULL) {
   ycf_yield_free(*ycf_trap_state, ycf_yield_alloc_free_context);
   *ycf_trap_state = NULL;
}
ycf_destroy_stack_allocator(&ycf_frame_alloc_data,
                            ycf_yield_free,
                            ycf_yield_alloc_free_context);
*ycf_nr_of_reductions_param = ycf_nr_of_reductions;
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */

/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */


    return res_N210_N226;
}

{
  struct gen_ycf_trap_state_for_hashmap_from_validated_list* ycf_my_trap_state;
  ycf_do_yield_label_hashmap_from_validated_list:;
  
/* YCF SPECIAL CUSTOM CODE START */

/* YCF SPECIAL CUSTOM CODE END */
  if (*ycf_trap_state == NULL) {
    ycf_my_trap_state = ycf_yield_alloc(sizeof(struct gen_ycf_trap_state_for_hashmap_from_validated_list), ycf_yield_alloc_free_context);
      } else {
    ycf_my_trap_state = *ycf_trap_state;
  }
      ycf_my_trap_state->ycf_yield_alloc = ycf_yield_alloc;
    ycf_my_trap_state->ycf_yield_free = ycf_yield_free;
    ycf_my_trap_state->ycf_yield_alloc_free_context = ycf_yield_alloc_free_context;
    ycf_my_trap_state->ycf_stack_alloc_size_or_max_size = ycf_stack_alloc_size_or_max_size;
    ycf_my_trap_state->ycf_stack_alloc_data = ycf_stack_alloc_data;
    ycf_my_trap_state->ycf_trap_location = ycf_trap_location;
    ycf_my_trap_state->ycf_nr_of_reductions = ycf_nr_of_reductions;
    ycf_my_trap_state->ycf_frame_alloc_data = ycf_frame_alloc_data;
    ycf_my_trap_state->item_N207_N223 = item_N207_N223;
    ycf_my_trap_state->hp_N208_N224 = hp_N208_N224;
    ycf_my_trap_state->kv_N209_N225 = kv_N209_N225;
    ycf_my_trap_state->res_N210_N226 = res_N210_N226;
    ycf_my_trap_state->key_N211_N227 = key_N211_N227;
    ycf_my_trap_state->value_N212_N228 = value_N212_N228;
    ycf_my_trap_state->sw_N213_N229 = sw_N213_N229;
    ycf_my_trap_state->hx_N214_N230 = hx_N214_N230;
    ycf_my_trap_state->ix_N215_N231 = ix_N215_N231;
    ycf_my_trap_state->hxns_N216_N232 = hxns_N216_N232;
    ycf_my_trap_state->factory_N217_N233 = factory_N217_N233;
    ycf_my_trap_state->kv_N201_N234 = kv_N201_N234;
    ycf_my_trap_state->ks_N202_N235 = ks_N202_N235;
    ycf_my_trap_state->vs_N203_N236 = vs_N203_N236;
    ycf_my_trap_state->mp_N204_N237 = mp_N204_N237;
    ycf_my_trap_state->keys_N205_N238 = keys_N205_N238;
    ycf_my_trap_state->n_N206_N239 = n_N206_N239;
    ycf_my_trap_state->ycf_sub_fun_trap_state_wb_N222 = ycf_sub_fun_trap_state_wb_N222;
    ycf_my_trap_state->p_N218_N240 = p_N218_N240;
    ycf_my_trap_state->list_N219_N241 = list_N219_N241;
    ycf_my_trap_state->fill_value_N220_N242 = fill_value_N220_N242;
    ycf_my_trap_state->size_N221_N243 = size_N221_N243;

  *ycf_nr_of_reductions_param = ycf_nr_of_reductions;
  *ycf_trap_state = ycf_my_trap_state;
      {
    static   Eterm  const ycf_unused_ret_value;
    return ycf_unused_ret_value;
  }

}
}
/* clang-format off */
YCF_GCC_DIAG_ON(uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(maybe-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(sometimes-uninitialized)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(unknown-warning-option)
/* clang-format on */

/* clang-format off */
YCF_GCC_DIAG_ON(pragmas)
/* clang-format on */

#undef YCF_STACK_ALLOC
#undef YCF_IN_YIELDING_FUN
