
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "combotabbar_wrapper.h"

// Wrappers providing overrides
#include "searchenginesdialog_wrapper.h"
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_ComboTabBar_Type = nullptr;
static PyTypeObject *Sbk_ComboTabBar_TypeF(void)
{
    return _Sbk_ComboTabBar_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void ComboTabBarWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::ComboTabBar::SizeType >("ComboTabBar::SizeType");
    qRegisterMetaType< ::ComboTabBar::DropIndicatorPosition >("ComboTabBar::DropIndicatorPosition");
}

void ComboTabBarWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

ComboTabBarWrapper::ComboTabBarWrapper(::QWidget * parent) : ComboTabBar(parent)
{
}

void ComboTabBarWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

int ComboTabBarWrapper::comboTabBarPixelMetric(::ComboTabBar::SizeType sizeType) const
{
    static const char *funcName = "comboTabBarPixelMetric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::comboTabBarPixelMetric(sizeType);
    }
    return sbk_o_comboTabBarPixelMetric("ComboTabBar", funcName, gil, pyOverride, sizeType);
}

int ComboTabBarWrapper::sbk_o_comboTabBarPixelMetric(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::ComboTabBar::SizeType sizeType)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_SizeType_IDX])))->converter, &sizeType)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_SizeType_IDX])))->converter, &sizeType)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void ComboTabBarWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ComboTabBar", funcName, gil, pyOverride, signal);
}

void ComboTabBarWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

int ComboTabBarWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("ComboTabBar", funcName, gil, pyOverride);
}

void ComboTabBarWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ComboTabBar", funcName, gil, pyOverride, signal);
}

void ComboTabBarWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

bool ComboTabBarWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::event(event);
    }
    return WebViewWrapper::sbk_o_event("ComboTabBar", funcName, gil, pyOverride, event);
}

bool ComboTabBarWrapper::eventFilter(::QObject * obj, ::QEvent * ev)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::eventFilter(obj, ev);
    }
    return WebViewWrapper::sbk_o_eventFilter("ComboTabBar", funcName, gil, pyOverride, obj, ev);
}

void ComboTabBarWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

bool ComboTabBarWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("ComboTabBar", funcName, gil, pyOverride, next);
}

void ComboTabBarWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

bool ComboTabBarWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("ComboTabBar", funcName, gil, pyOverride);
}

int ComboTabBarWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("ComboTabBar", funcName, gil, pyOverride, arg__1);
}

void ComboTabBarWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("ComboTabBar", funcName, gil, pyOverride, painter);
}

void ComboTabBarWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

::QVariant ComboTabBarWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("ComboTabBar", funcName, gil, pyOverride, arg__1);
}

void ComboTabBarWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

int ComboTabBarWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("ComboTabBar", funcName, gil, pyOverride, arg__1);
}

::QSize ComboTabBarWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("ComboTabBar", funcName, gil, pyOverride);
}

void ComboTabBarWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

bool ComboTabBarWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("ComboTabBar", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * ComboTabBarWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("ComboTabBar", funcName, gil, pyOverride);
}

void ComboTabBarWrapper::paintEvent(::QPaintEvent * ev)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::paintEvent(ev);
    }
    WebViewWrapper::sbk_o_paintEvent("ComboTabBar", funcName, gil, pyOverride, ev);
}

::QPaintDevice * ComboTabBarWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("ComboTabBar", funcName, gil, pyOverride, offset);
}

void ComboTabBarWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("ComboTabBar", funcName, gil, pyOverride, visible);
}

::QPainter * ComboTabBarWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("ComboTabBar", funcName, gil, pyOverride);
}

void ComboTabBarWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

::QSize ComboTabBarWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("ComboTabBar", funcName, gil, pyOverride);
}

void ComboTabBarWrapper::tabInserted(int index)
{
    static const char *funcName = "tabInserted";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::tabInserted(index);
    }
    SearchEnginesDialogWrapper::sbk_o_done("ComboTabBar", funcName, gil, pyOverride, index);
}

void ComboTabBarWrapper::tabRemoved(int index)
{
    static const char *funcName = "tabRemoved";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::tabRemoved(index);
    }
    SearchEnginesDialogWrapper::sbk_o_done("ComboTabBar", funcName, gil, pyOverride, index);
}

::QSize ComboTabBarWrapper::tabSizeHint(int index, bool fast) const
{
    static const char *funcName = "tabSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::tabSizeHint(index, fast);
    }
    return sbk_o_tabSizeHint("ComboTabBar", funcName, gil, pyOverride, index, fast);
}

::QSize ComboTabBarWrapper::sbk_o_tabSizeHint(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int index, bool fast)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &index),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &fast)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iN)",
        index,
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &fast)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QSize >()), Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void ComboTabBarWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

void ComboTabBarWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ComboTabBar_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::ComboTabBar::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("ComboTabBar", funcName, gil, pyOverride, event);
}

const QMetaObject *ComboTabBarWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return ComboTabBar::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int ComboTabBarWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = ComboTabBar::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *ComboTabBarWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< ComboTabBarWrapper *>(this));
    }
    return ComboTabBar::qt_metacast(_clname);
}

ComboTabBarWrapper::~ComboTabBarWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_ComboTabBar_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_ComboTabBar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::ComboTabBar >()))
        return -1;

    ComboTabBarWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:ComboTabBar", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: ComboTabBar::ComboTabBar(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // ComboTabBar(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // ComboTabBar(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ComboTabBar(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) ComboTabBarWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new ComboTabBarWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ComboTabBar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);
    };


    return 1;
}

static PyObject *Sbk_ComboTabBarFunc_addCornerWidget(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addCornerWidget", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::addCornerWidget(QWidget*,Qt::Corner)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Corner_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // addCornerWidget(QWidget*,Qt::Corner)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addCornerWidget", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::Corner cppArg1{Qt::TopLeftCorner};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addCornerWidget(QWidget*,Qt::Corner)
            cppSelf->addCornerWidget(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_addTab(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addTab", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::addTab(QIcon,QString)->int
    // 1: ComboTabBar::addTab(QString)->int
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 1; // addTab(QString)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // addTab(QIcon,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addTab", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addTab(const QIcon &icon, const QString &text)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addTab(QIcon,QString)
                int cppResult = cppSelf->addTab(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // addTab(const QString &text)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addTab(QString)
                int cppResult = cppSelf->addTab(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_clearDropIndicator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearDropIndicator()
        cppSelf->clearDropIndicator();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_closeButtonPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // closeButtonPosition()const
        QTabBar::ButtonPosition cppResult = QTabBar::ButtonPosition(const_cast<const ComboTabBarWrapper *>(cppSelf)->closeButtonPosition());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QTabBar_ButtonPosition_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_closeButtonSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // closeButtonSize()const
        QSize cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->closeButtonSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_comboTabBarPixelMetric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::comboTabBarPixelMetric(ComboTabBar::SizeType)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_SizeType_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // comboTabBarPixelMetric(ComboTabBar::SizeType)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "comboTabBarPixelMetric", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        ::ComboTabBar::SizeType cppArg0{ComboTabBar::PinnedTabWidth};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // comboTabBarPixelMetric(ComboTabBar::SizeType)const
            int cppResult = static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::comboTabBarPixelMetric_protected(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_cornerWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::cornerWidth(Qt::Corner)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Corner_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // cornerWidth(Qt::Corner)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "cornerWidth", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        ::Qt::Corner cppArg0{Qt::TopLeftCorner};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // cornerWidth(Qt::Corner)const
            int cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->cornerWidth(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // count()const
        int cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->count();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_currentIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentIndex()const
        int cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->currentIndex();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_documentMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // documentMode()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->documentMode();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_draggedTabRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // draggedTabRect()const
        QRect cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->draggedTabRect();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_drawBase(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // drawBase()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->drawBase();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_elideMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // elideMode()const
        Qt::TextElideMode cppResult = Qt::TextElideMode(const_cast<const ComboTabBarWrapper *>(cppSelf)->elideMode());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_TextElideMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_emptyArea(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::emptyArea(QPoint)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArg)))) {
        overloadId = 0; // emptyArea(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "emptyArea", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // emptyArea(QPoint)const
            bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->emptyArea(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_ensureVisible(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "ensureVisible", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    if (PyArg_ParseTuple(args, "|OO:ensureVisible", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::ensureVisible(int=,int=)
    if (numArgs == 0) {
        overloadId = 0; // ensureVisible(int,int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // ensureVisible(int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // ensureVisible(int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "ensureVisible", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"index", 0}, {"xmargin", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "ensureVisible", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = -1;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ensureVisible(int,int)
            cppSelf->ensureVisible(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::event_protected(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::eventFilter_protected(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_expanding(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // expanding()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->expanding();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_iconButtonPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // iconButtonPosition()const
        QTabBar::ButtonPosition cppResult = QTabBar::ButtonPosition(const_cast<const ComboTabBarWrapper *>(cppSelf)->iconButtonPosition());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QTabBar_ButtonPosition_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_iconButtonSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // iconButtonSize()const
        QSize cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->iconButtonSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_insertCloseButton(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::insertCloseButton(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // insertCloseButton(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "insertCloseButton", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertCloseButton(int)
            cppSelf->insertCloseButton(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_insertTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "insertTab", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:insertTab", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::insertTab(int,QIcon,QString,bool=)->int
    // 1: ComboTabBar::insertTab(int,QString)->int
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 1; // insertTab(int,QString)
        } else if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // insertTab(int,QIcon,QString,bool)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
                overloadId = 0; // insertTab(int,QIcon,QString,bool)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insertTab", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // insertTab(int index, const QIcon &icon, const QString &text, bool pinned)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"pinned", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "insertTab", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QIcon cppArg1_local;
            ::QIcon *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            bool cppArg3 = false;
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // insertTab(int,QIcon,QString,bool)
                int cppResult = cppSelf->insertTab(cppArg0, *cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // insertTab(int index, const QString &text)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "insertTab", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // insertTab(int,QString)
                int cppResult = cppSelf->insertTab(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_isDragInProgress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isDragInProgress()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->isDragInProgress();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_isMainBarOverflowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isMainBarOverflowed()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->isMainBarOverflowed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_isMovable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isMovable()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->isMovable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_isPinned(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::isPinned(int)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // isPinned(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isPinned", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isPinned(int)const
            bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->isPinned(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_isScrollInProgress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isScrollInProgress()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->isScrollInProgress();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_isTabEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::isTabEnabled(int)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // isTabEnabled(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isTabEnabled", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isTabEnabled(int)const
            bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->isTabEnabled(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_mainTabBarCurrentIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mainTabBarCurrentIndex()const
        int cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->mainTabBarCurrentIndex();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_mainTabBarWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mainTabBarWidth()const
        int cppResult = static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::mainTabBarWidth_protected();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_moveTab(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "moveTab", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::moveTab(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // moveTab(int,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "moveTab", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // moveTab(int,int)
            cppSelf->moveTab(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_normalTabsCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // normalTabsCount()const
        int cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->normalTabsCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::paintEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_pinTabBarWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pinTabBarWidth()const
        int cppResult = static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::pinTabBarWidth_protected();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_pinnedTabsCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pinnedTabsCount()const
        int cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->pinnedTabsCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_removeTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::removeTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // removeTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeTab", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeTab(int)
            cppSelf->removeTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_selectionBehaviorOnRemove(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectionBehaviorOnRemove()const
        QTabBar::SelectionBehavior cppResult = QTabBar::SelectionBehavior(const_cast<const ComboTabBarWrapper *>(cppSelf)->selectionBehaviorOnRemove());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QTabBar_SelectionBehavior_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_setCloseButtonsToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setCloseButtonsToolTip(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setCloseButtonsToolTip(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCloseButtonsToolTip", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCloseButtonsToolTip(QString)
            cppSelf->setCloseButtonsToolTip(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setCurrentIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setCurrentIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentIndex", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentIndex(int)
            cppSelf->setCurrentIndex(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setCurrentNextEnabledIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setCurrentNextEnabledIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentNextEnabledIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentNextEnabledIndex", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentNextEnabledIndex(int)
            cppSelf->setCurrentNextEnabledIndex(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setDocumentMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setDocumentMode(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDocumentMode(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDocumentMode", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDocumentMode(bool)
            cppSelf->setDocumentMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setDrawBase(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setDrawBase(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDrawBase(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDrawBase", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDrawBase(bool)
            cppSelf->setDrawBase(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setElideMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setElideMode(Qt::TextElideMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_TextElideMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setElideMode(Qt::TextElideMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setElideMode", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        ::Qt::TextElideMode cppArg0{Qt::ElideLeft};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setElideMode(Qt::TextElideMode)
            cppSelf->setElideMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setExpanding(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setExpanding(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setExpanding(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setExpanding", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setExpanding(bool)
            cppSelf->setExpanding(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setFocusPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::setFocusPolicy(Qt::FocusPolicy)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_FocusPolicy_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setFocusPolicy(Qt::FocusPolicy)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFocusPolicy", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        ::Qt::FocusPolicy cppArg0{Qt::NoFocus};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFocusPolicy(Qt::FocusPolicy)
            cppSelf->setFocusPolicy(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setMouseTracking(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::setMouseTracking(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMouseTracking(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMouseTracking", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMouseTracking(bool)
            cppSelf->setMouseTracking(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setMovable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setMovable(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMovable(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMovable", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMovable(bool)
            cppSelf->setMovable(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setObjectName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setObjectName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setObjectName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setObjectName", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setObjectName(QString)
            cppSelf->setObjectName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setSelectionBehaviorOnRemove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setSelectionBehaviorOnRemove(QTabBar::SelectionBehavior)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QTabBar_SelectionBehavior_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setSelectionBehaviorOnRemove(QTabBar::SelectionBehavior)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSelectionBehaviorOnRemove", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        ::QTabBar::SelectionBehavior cppArg0{QTabBar::SelectLeftTab};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSelectionBehaviorOnRemove(QTabBar::SelectionBehavior)
            cppSelf->setSelectionBehaviorOnRemove(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setTabButton(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTabButton", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::setTabButton(int,QTabBar::ButtonPosition,QWidget*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QTabBar_ButtonPosition_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
        overloadId = 0; // setTabButton(int,QTabBar::ButtonPosition,QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTabButton", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QTabBar::ButtonPosition cppArg1{QTabBar::LeftSide};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabButton(int,QTabBar::ButtonPosition,QWidget*)
            cppSelf->setTabButton(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setTabEnabled(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTabEnabled", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::setTabEnabled(int,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setTabEnabled(int,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTabEnabled", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabEnabled(int,bool)
            cppSelf->setTabEnabled(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setTabText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTabText", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::setTabText(int,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setTabText(int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTabText", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabText(int,QString)
            cppSelf->setTabText(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setTabTextColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTabTextColor", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::setTabTextColor(int,QColor)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setTabTextColor(int,QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTabTextColor", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabTextColor(int,QColor)
            cppSelf->setTabTextColor(cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setTabToolTip(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTabToolTip", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::setTabToolTip(int,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setTabToolTip(int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTabToolTip", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabToolTip(int,QString)
            cppSelf->setTabToolTip(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setTabsClosable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setTabsClosable(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setTabsClosable(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTabsClosable", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabsClosable(bool)
            cppSelf->setTabsClosable(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setUpLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setUpLayout()
        cppSelf->setUpLayout();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_setUsesScrollButtons(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::setUsesScrollButtons(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUsesScrollButtons(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUsesScrollButtons", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setUsesScrollButtons(bool)
            cppSelf->setUsesScrollButtons(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_showDropIndicator(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "showDropIndicator", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::showDropIndicator(int,ComboTabBar::DropIndicatorPosition)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_DropIndicatorPosition_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // showDropIndicator(int,ComboTabBar::DropIndicatorPosition)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "showDropIndicator", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::ComboTabBar::DropIndicatorPosition cppArg1{ComboTabBar::BeforeTab};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showDropIndicator(int,ComboTabBar::DropIndicatorPosition)
            cppSelf->showDropIndicator(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_slideAnimationDuration(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // slideAnimationDuration()
        int cppResult = ::ComboTabBar::slideAnimationDuration();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabAt(QPoint)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArg)))) {
        overloadId = 0; // tabAt(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabAt", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // tabAt(QPoint)const
            int cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->tabAt(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabButton(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "tabButton", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::tabButton(int,QTabBar::ButtonPosition)const->QWidget*
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QTabBar_ButtonPosition_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // tabButton(int,QTabBar::ButtonPosition)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "tabButton", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QTabBar::ButtonPosition cppArg1{QTabBar::LeftSide};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabButton(int,QTabBar::ButtonPosition)const
            QWidget * cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->tabButton(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
            // Ownership transferences (return value heuristics).
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabInserted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabInserted(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabInserted(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabInserted", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabInserted(int)
            static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::tabInserted_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_tabPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabPixmap(int)const->QPixmap
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabPixmap(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabPixmap", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabPixmap(int)const
            QPixmap cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->tabPixmap(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabRect(int)const->QRect
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabRect(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabRect", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabRect(int)const
            QRect cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->tabRect(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabRemoved(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabRemoved(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabRemoved(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabRemoved", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabRemoved(int)
            static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::tabRemoved_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ComboTabBarFunc_tabSizeHint(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "tabSizeHint", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    if (PyArg_ParseTuple(args, "|OO:tabSizeHint", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: ComboTabBar::tabSizeHint(int,bool=)const->QSize
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // tabSizeHint(int,bool)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // tabSizeHint(int,bool)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "tabSizeHint", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"fast", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "tabSizeHint", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabSizeHint(int,bool)const
            QSize cppResult = static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::tabSizeHint_protected(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabText(int)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabText(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabText", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabText(int)const
            QString cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->tabText(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabTextColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabTextColor(int)const->QColor
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabTextColor(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabTextColor", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabTextColor(int)const
            QColor cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->tabTextColor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::tabToolTip(int)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabToolTip(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabToolTip", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabToolTip(int)const
            QString cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->tabToolTip(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_tabsClosable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabsClosable()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->tabsClosable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_usesScrollButtons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // usesScrollButtons()const
        bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->usesScrollButtons();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_validIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ComboTabBar::validIndex(int)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // validIndex(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "validIndex", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // validIndex(int)const
            bool cppResult = const_cast<const ComboTabBarWrapper *>(cppSelf)->validIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ComboTabBarFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ComboTabBarWrapper *>(reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::wheelEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "wheelEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // wheelEvent(QWheelEvent*)
            static_cast<ComboTabBarWrapper *>(cppSelf)->ComboTabBarWrapper::wheelEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_ComboTabBar_PropertyStrings[] = {
    "count:",
    "currentIndex::",
    nullptr // Sentinel
};

static const char *Sbk_ComboTabBar_EnumFlagInfo[] = {
    "DropIndicatorPosition:IntEnum",
    "SizeType:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_ComboTabBar_methods[] = {
    {"addCornerWidget", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_addCornerWidget), METH_VARARGS, nullptr},
    {"addTab", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_addTab), METH_VARARGS, nullptr},
    {"clearDropIndicator", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_clearDropIndicator), METH_NOARGS, nullptr},
    {"closeButtonPosition", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_closeButtonPosition), METH_NOARGS, nullptr},
    {"closeButtonSize", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_closeButtonSize), METH_NOARGS, nullptr},
    {"comboTabBarPixelMetric", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_comboTabBarPixelMetric), METH_O, nullptr},
    {"cornerWidth", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_cornerWidth), METH_O, nullptr},
    {"count", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_count), METH_NOARGS, nullptr},
    {"currentIndex", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_currentIndex), METH_NOARGS, nullptr},
    {"documentMode", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_documentMode), METH_NOARGS, nullptr},
    {"draggedTabRect", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_draggedTabRect), METH_NOARGS, nullptr},
    {"drawBase", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_drawBase), METH_NOARGS, nullptr},
    {"elideMode", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_elideMode), METH_NOARGS, nullptr},
    {"emptyArea", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_emptyArea), METH_O, nullptr},
    {"ensureVisible", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_ensureVisible), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_event), METH_O, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_eventFilter), METH_VARARGS, nullptr},
    {"expanding", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_expanding), METH_NOARGS, nullptr},
    {"iconButtonPosition", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_iconButtonPosition), METH_NOARGS, nullptr},
    {"iconButtonSize", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_iconButtonSize), METH_NOARGS, nullptr},
    {"insertCloseButton", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_insertCloseButton), METH_O, nullptr},
    {"insertTab", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_insertTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"isDragInProgress", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_isDragInProgress), METH_NOARGS, nullptr},
    {"isMainBarOverflowed", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_isMainBarOverflowed), METH_NOARGS, nullptr},
    {"isMovable", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_isMovable), METH_NOARGS, nullptr},
    {"isPinned", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_isPinned), METH_O, nullptr},
    {"isScrollInProgress", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_isScrollInProgress), METH_NOARGS, nullptr},
    {"isTabEnabled", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_isTabEnabled), METH_O, nullptr},
    {"mainTabBarCurrentIndex", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_mainTabBarCurrentIndex), METH_NOARGS, nullptr},
    {"mainTabBarWidth", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_mainTabBarWidth), METH_NOARGS, nullptr},
    {"moveTab", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_moveTab), METH_VARARGS, nullptr},
    {"normalTabsCount", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_normalTabsCount), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_paintEvent), METH_O, nullptr},
    {"pinTabBarWidth", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_pinTabBarWidth), METH_NOARGS, nullptr},
    {"pinnedTabsCount", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_pinnedTabsCount), METH_NOARGS, nullptr},
    {"removeTab", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_removeTab), METH_O, nullptr},
    {"selectionBehaviorOnRemove", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_selectionBehaviorOnRemove), METH_NOARGS, nullptr},
    {"setCloseButtonsToolTip", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setCloseButtonsToolTip), METH_O, nullptr},
    {"setCurrentIndex", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setCurrentIndex), METH_O, nullptr},
    {"setCurrentNextEnabledIndex", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setCurrentNextEnabledIndex), METH_O, nullptr},
    {"setDocumentMode", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setDocumentMode), METH_O, nullptr},
    {"setDrawBase", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setDrawBase), METH_O, nullptr},
    {"setElideMode", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setElideMode), METH_O, nullptr},
    {"setExpanding", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setExpanding), METH_O, nullptr},
    {"setFocusPolicy", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setFocusPolicy), METH_O, nullptr},
    {"setMouseTracking", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setMouseTracking), METH_O, nullptr},
    {"setMovable", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setMovable), METH_O, nullptr},
    {"setObjectName", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setObjectName), METH_O, nullptr},
    {"setSelectionBehaviorOnRemove", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setSelectionBehaviorOnRemove), METH_O, nullptr},
    {"setTabButton", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setTabButton), METH_VARARGS, nullptr},
    {"setTabEnabled", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setTabEnabled), METH_VARARGS, nullptr},
    {"setTabText", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setTabText), METH_VARARGS, nullptr},
    {"setTabTextColor", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setTabTextColor), METH_VARARGS, nullptr},
    {"setTabToolTip", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setTabToolTip), METH_VARARGS, nullptr},
    {"setTabsClosable", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setTabsClosable), METH_O, nullptr},
    {"setUpLayout", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setUpLayout), METH_NOARGS, nullptr},
    {"setUsesScrollButtons", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_setUsesScrollButtons), METH_O, nullptr},
    {"showDropIndicator", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_showDropIndicator), METH_VARARGS, nullptr},
    {"slideAnimationDuration", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_slideAnimationDuration), METH_NOARGS|METH_STATIC, nullptr},
    {"tabAt", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabAt), METH_O, nullptr},
    {"tabButton", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabButton), METH_VARARGS, nullptr},
    {"tabInserted", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabInserted), METH_O, nullptr},
    {"tabPixmap", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabPixmap), METH_O, nullptr},
    {"tabRect", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabRect), METH_O, nullptr},
    {"tabRemoved", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabRemoved), METH_O, nullptr},
    {"tabSizeHint", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabSizeHint), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"tabText", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabText), METH_O, nullptr},
    {"tabTextColor", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabTextColor), METH_O, nullptr},
    {"tabToolTip", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabToolTip), METH_O, nullptr},
    {"tabsClosable", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_tabsClosable), METH_NOARGS, nullptr},
    {"usesScrollButtons", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_usesScrollButtons), METH_NOARGS, nullptr},
    {"validIndex", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_validIndex), METH_O, nullptr},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_ComboTabBarFunc_wheelEvent), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_ComboTabBar_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::ComboTabBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<ComboTabBarWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_ComboTabBar_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_ComboTabBar_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_ComboTabBarSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::ComboTabBar *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_ComboTabBar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_ComboTabBar_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_ComboTabBar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_ComboTabBar_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_ComboTabBar_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_ComboTabBar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_ComboTabBar_spec = {
    "1:PyFalkon.ComboTabBar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_ComboTabBar_slots
};

} //extern "C"

static void *Sbk_ComboTabBar_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::ComboTabBar *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::ComboTabBar *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::ComboTabBar *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_ComboTabBar_SizeType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::ComboTabBar::SizeType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::ComboTabBar::SizeType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_ComboTabBar_SizeType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_SizeType_IDX])))
        return Enum_PythonToCpp_ComboTabBar_SizeType;
    return {};
}

static PyObject *ComboTabBar_SizeType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::ComboTabBar::SizeType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::ComboTabBar::SizeType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_ComboTabBar_DropIndicatorPosition(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::ComboTabBar::DropIndicatorPosition>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::ComboTabBar::DropIndicatorPosition *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_ComboTabBar_DropIndicatorPosition_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_DropIndicatorPosition_IDX])))
        return Enum_PythonToCpp_ComboTabBar_DropIndicatorPosition;
    return {};
}

static PyObject *ComboTabBar_DropIndicatorPosition_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::ComboTabBar::DropIndicatorPosition>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::ComboTabBar::DropIndicatorPosition *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ComboTabBar_PythonToCpp_ComboTabBar_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_ComboTabBar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ComboTabBar_PythonToCpp_ComboTabBar_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_ComboTabBar_TypeF()))
        return ComboTabBar_PythonToCpp_ComboTabBar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ComboTabBar_PTR_CppToPython_ComboTabBar(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::ComboTabBar *>(const_cast<void *>(cppIn)), Sbk_ComboTabBar_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *ComboTabBar_SignatureStrings[] = {
    "PyFalkon.ComboTabBar(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,currentIndex:int=None,count:int=None)",
    "PyFalkon.ComboTabBar.addCornerWidget(self,widget:PySide6.QtWidgets.QWidget,corner:PySide6.QtCore.Qt.Corner)",
    "1:PyFalkon.ComboTabBar.addTab(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString)->int",
    "0:PyFalkon.ComboTabBar.addTab(self,text:QString)->int",
    "PyFalkon.ComboTabBar.clearDropIndicator(self)",
    "PyFalkon.ComboTabBar.closeButtonPosition(self)->PySide6.QtWidgets.QTabBar.ButtonPosition",
    "PyFalkon.ComboTabBar.closeButtonSize(self)->PySide6.QtCore.QSize",
    "PyFalkon.ComboTabBar.comboTabBarPixelMetric(self,sizeType:PyFalkon.ComboTabBar.SizeType)->int",
    "PyFalkon.ComboTabBar.cornerWidth(self,corner:PySide6.QtCore.Qt.Corner)->int",
    "PyFalkon.ComboTabBar.count(self)->int",
    "PyFalkon.ComboTabBar.currentIndex(self)->int",
    "PyFalkon.ComboTabBar.documentMode(self)->bool",
    "PyFalkon.ComboTabBar.draggedTabRect(self)->PySide6.QtCore.QRect",
    "PyFalkon.ComboTabBar.drawBase(self)->bool",
    "PyFalkon.ComboTabBar.elideMode(self)->PySide6.QtCore.Qt.TextElideMode",
    "PyFalkon.ComboTabBar.emptyArea(self,pos:PySide6.QtCore.QPoint)->bool",
    "PyFalkon.ComboTabBar.ensureVisible(self,index:int=-1,xmargin:int=-1)",
    "PyFalkon.ComboTabBar.event(self,event:PySide6.QtCore.QEvent)->bool",
    "PyFalkon.ComboTabBar.eventFilter(self,obj:PySide6.QtCore.QObject,ev:PySide6.QtCore.QEvent)->bool",
    "PyFalkon.ComboTabBar.expanding(self)->bool",
    "PyFalkon.ComboTabBar.iconButtonPosition(self)->PySide6.QtWidgets.QTabBar.ButtonPosition",
    "PyFalkon.ComboTabBar.iconButtonSize(self)->PySide6.QtCore.QSize",
    "PyFalkon.ComboTabBar.insertCloseButton(self,index:int)",
    "1:PyFalkon.ComboTabBar.insertTab(self,index:int,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,pinned:bool=false)->int",
    "0:PyFalkon.ComboTabBar.insertTab(self,index:int,text:QString)->int",
    "PyFalkon.ComboTabBar.isDragInProgress(self)->bool",
    "PyFalkon.ComboTabBar.isMainBarOverflowed(self)->bool",
    "PyFalkon.ComboTabBar.isMovable(self)->bool",
    "PyFalkon.ComboTabBar.isPinned(self,index:int)->bool",
    "PyFalkon.ComboTabBar.isScrollInProgress(self)->bool",
    "PyFalkon.ComboTabBar.isTabEnabled(self,index:int)->bool",
    "PyFalkon.ComboTabBar.mainTabBarCurrentIndex(self)->int",
    "PyFalkon.ComboTabBar.mainTabBarWidth(self)->int",
    "PyFalkon.ComboTabBar.moveTab(self,from:int,to:int)",
    "PyFalkon.ComboTabBar.normalTabsCount(self)->int",
    "PyFalkon.ComboTabBar.paintEvent(self,ev:PySide6.QtGui.QPaintEvent)",
    "PyFalkon.ComboTabBar.pinTabBarWidth(self)->int",
    "PyFalkon.ComboTabBar.pinnedTabsCount(self)->int",
    "PyFalkon.ComboTabBar.removeTab(self,index:int)",
    "PyFalkon.ComboTabBar.selectionBehaviorOnRemove(self)->PySide6.QtWidgets.QTabBar.SelectionBehavior",
    "PyFalkon.ComboTabBar.setCloseButtonsToolTip(self,tip:QString)",
    "PyFalkon.ComboTabBar.setCurrentIndex(self,index:int)",
    "PyFalkon.ComboTabBar.setCurrentNextEnabledIndex(self,offset:int)",
    "PyFalkon.ComboTabBar.setDocumentMode(self,set:bool)",
    "PyFalkon.ComboTabBar.setDrawBase(self,drawTheBase:bool)",
    "PyFalkon.ComboTabBar.setElideMode(self,elide:PySide6.QtCore.Qt.TextElideMode)",
    "PyFalkon.ComboTabBar.setExpanding(self,enabled:bool)",
    "PyFalkon.ComboTabBar.setFocusPolicy(self,policy:PySide6.QtCore.Qt.FocusPolicy)",
    "PyFalkon.ComboTabBar.setMouseTracking(self,enable:bool)",
    "PyFalkon.ComboTabBar.setMovable(self,movable:bool)",
    "PyFalkon.ComboTabBar.setObjectName(self,name:QString)",
    "PyFalkon.ComboTabBar.setSelectionBehaviorOnRemove(self,behavior:PySide6.QtWidgets.QTabBar.SelectionBehavior)",
    "PyFalkon.ComboTabBar.setTabButton(self,index:int,position:PySide6.QtWidgets.QTabBar.ButtonPosition,widget:PySide6.QtWidgets.QWidget)",
    "PyFalkon.ComboTabBar.setTabEnabled(self,index:int,enabled:bool)",
    "PyFalkon.ComboTabBar.setTabText(self,index:int,text:QString)",
    "PyFalkon.ComboTabBar.setTabTextColor(self,index:int,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "PyFalkon.ComboTabBar.setTabToolTip(self,index:int,tip:QString)",
    "PyFalkon.ComboTabBar.setTabsClosable(self,closable:bool)",
    "PyFalkon.ComboTabBar.setUpLayout(self)",
    "PyFalkon.ComboTabBar.setUsesScrollButtons(self,useButtons:bool)",
    "PyFalkon.ComboTabBar.showDropIndicator(self,index:int,position:PyFalkon.ComboTabBar.DropIndicatorPosition)",
    "PyFalkon.ComboTabBar.slideAnimationDuration()->int",
    "PyFalkon.ComboTabBar.tabAt(self,pos:PySide6.QtCore.QPoint)->int",
    "PyFalkon.ComboTabBar.tabButton(self,index:int,position:PySide6.QtWidgets.QTabBar.ButtonPosition)->PySide6.QtWidgets.QWidget",
    "PyFalkon.ComboTabBar.tabInserted(self,index:int)",
    "PyFalkon.ComboTabBar.tabPixmap(self,index:int)->PySide6.QtGui.QPixmap",
    "PyFalkon.ComboTabBar.tabRect(self,index:int)->PySide6.QtCore.QRect",
    "PyFalkon.ComboTabBar.tabRemoved(self,index:int)",
    "PyFalkon.ComboTabBar.tabSizeHint(self,index:int,fast:bool=false)->PySide6.QtCore.QSize",
    "PyFalkon.ComboTabBar.tabText(self,index:int)->QString",
    "PyFalkon.ComboTabBar.tabTextColor(self,index:int)->PySide6.QtGui.QColor",
    "PyFalkon.ComboTabBar.tabToolTip(self,index:int)->QString",
    "PyFalkon.ComboTabBar.tabsClosable(self)->bool",
    "PyFalkon.ComboTabBar.usesScrollButtons(self)->bool",
    "PyFalkon.ComboTabBar.validIndex(self,index:int)->bool",
    "PyFalkon.ComboTabBar.wheelEvent(self,event:PySide6.QtGui.QWheelEvent)",
    nullptr}; // Sentinel
#else
static constexpr size_t ComboTabBar_SignatureByteSize = 1083;
static constexpr uint8_t ComboTabBar_SignatureBytes[1083] = {
    0x78, 0xda, 0xb5, 0x57, 0xc1, 0x6e, 0xdb, 0x38, 0x10, 0xbd, 0xe7, 0x2b, 0x72, 0xac, 0x17, 0x8a,
    0xb1, 0x01, 0x16, 0x3d, 0x08, 0x48, 0x81, 0xc4, 0x71, 0xba, 0xc1, 0x36, 0x89, 0x1d, 0xbb, 0xed,
    0x61, 0xd1, 0x03, 0x25, 0x8d, 0x6d, 0xb6, 0x14, 0x29, 0x90, 0x94, 0x1d, 0xf7, 0xeb, 0x77, 0x28,
    0x4a, 0xb6, 0x2c, 0x89, 0x94, 0x5c, 0x74, 0x4f, 0xa6, 0xe4, 0x79, 0x6f, 0x86, 0xa3, 0x99, 0x37,
    0xe4, 0x6c, 0xff, 0x40, 0xd8, 0x0f, 0xc1, 0xc7, 0x13, 0x91, 0x46, 0x62, 0x49, 0xa2, 0x3b, 0x22,
    0xdf, 0x29, 0x60, 0xab, 0x20, 0x23, 0x12, 0xb8, 0x0e, 0x67, 0xfb, 0x05, 0x4d, 0xe0, 0xfd, 0x78,
    0xae, 0xbf, 0xd2, 0x64, 0x0d, 0x5a, 0x8d, 0xe7, 0x76, 0x71, 0xc3, 0x73, 0xc6, 0x32, 0x2d, 0x83,
    0x3f, 0xc2, 0x7f, 0x60, 0xbf, 0x13, 0x32, 0x79, 0xe1, 0x6c, 0x7f, 0xf3, 0x2c, 0x38, 0x04, 0x71,
    0x2e, 0x0d, 0xf8, 0x91, 0x27, 0xf0, 0x16, 0x52, 0xae, 0xcb, 0xb7, 0x22, 0x47, 0xc2, 0xea, 0x71,
    0x74, 0x31, 0xeb, 0xf0, 0x3d, 0x26, 0x49, 0x32, 0x11, 0x92, 0x83, 0xb4, 0x5e, 0x6c, 0x2c, 0xbb,
    0x62, 0xed, 0x8e, 0x05, 0xa9, 0x0d, 0xa4, 0x66, 0x80, 0x1c, 0x80, 0x3f, 0x63, 0xcb, 0x35, 0xba,
    0xb8, 0x0e, 0x5d, 0xde, 0x70, 0x65, 0x9d, 0xd0, 0x58, 0xf0, 0x50, 0xef, 0x33, 0xca, 0xd7, 0xe3,
    0xcf, 0x9c, 0x0a, 0xfe, 0xef, 0x91, 0xee, 0x63, 0x4e, 0xc7, 0xf3, 0x47, 0x34, 0x08, 0x2e, 0x1b,
    0x2f, 0x67, 0xf4, 0x2d, 0x25, 0xd9, 0xb7, 0x40, 0xc3, 0x9b, 0x0e, 0xe7, 0x0b, 0x2d, 0x11, 0x3e,
    0xba, 0xfa, 0x80, 0xbb, 0xbc, 0xf8, 0xb3, 0xdf, 0x67, 0x07, 0xaa, 0x13, 0x13, 0x33, 0x20, 0xf2,
    0x5e, 0x8a, 0x0c, 0x53, 0x4a, 0x63, 0xa2, 0x85, 0xfd, 0x48, 0x23, 0x97, 0xb5, 0x50, 0x70, 0x97,
    0x6b, 0x2d, 0xf8, 0x4c, 0x28, 0xaa, 0x71, 0x2f, 0xd6, 0xfc, 0xea, 0x43, 0x47, 0x0a, 0x4b, 0xd0,
    0xa9, 0x7d, 0x2f, 0xf1, 0x82, 0xfe, 0x84, 0x36, 0xa9, 0x4d, 0xbb, 0xf9, 0xcf, 0x41, 0x70, 0x5c,
    0x63, 0xe2, 0x80, 0x3d, 0x01, 0x6e, 0x3d, 0xb6, 0xb9, 0x50, 0x88, 0x5a, 0xee, 0x33, 0xe8, 0xce,
    0xda, 0xa2, 0xfc, 0xd7, 0x9b, 0xa5, 0xaa, 0x70, 0xf4, 0xc6, 0x52, 0xf6, 0x95, 0x85, 0x97, 0x0b,
    0x8b, 0xb5, 0xda, 0xa0, 0xdb, 0xaa, 0x56, 0xe8, 0xbd, 0xc6, 0x89, 0x88, 0xf3, 0x14, 0xad, 0x9f,
    0x44, 0x72, 0x48, 0x5d, 0x24, 0x04, 0x73, 0x58, 0x4b, 0xb2, 0x5e, 0x83, 0x29, 0x95, 0x57, 0x88,
    0xb5, 0x2b, 0xd5, 0xe6, 0x3f, 0x27, 0x7e, 0x77, 0x47, 0xd4, 0x00, 0x4f, 0xc0, 0x90, 0xb2, 0x1e,
    0x54, 0x3b, 0x5f, 0x4b, 0xac, 0xd3, 0x69, 0x65, 0xe6, 0x60, 0x49, 0x33, 0xbd, 0xbf, 0x95, 0x40,
    0x4a, 0xf9, 0x10, 0xaa, 0x95, 0xf7, 0x99, 0xc0, 0xdc, 0xf8, 0x43, 0xe1, 0x2a, 0x97, 0xf0, 0x85,
    0x2a, 0x1a, 0x31, 0x28, 0xdb, 0xf2, 0x20, 0x22, 0x57, 0xd7, 0x01, 0xf6, 0x9a, 0x5c, 0x53, 0x5e,
    0x3e, 0x3a, 0xca, 0x1f, 0xb6, 0x50, 0x7e, 0xba, 0xa0, 0x58, 0xb6, 0xe2, 0x98, 0x9a, 0xb7, 0xfe,
    0x38, 0x8c, 0xc5, 0x03, 0x65, 0x1a, 0x4a, 0x35, 0x14, 0xd1, 0xf7, 0x16, 0xcd, 0x4b, 0xf4, 0x1d,
    0xb3, 0x8f, 0x3e, 0x7e, 0xc5, 0xc1, 0x5b, 0x46, 0xb0, 0x95, 0xf9, 0xba, 0xff, 0xf3, 0x18, 0x5d,
    0xfa, 0x3f, 0x9a, 0xf9, 0xc8, 0xfb, 0x6b, 0xbd, 0x4c, 0xb9, 0x02, 0xa9, 0x27, 0x47, 0x49, 0x68,
    0x7c, 0x2f, 0xa7, 0xe8, 0x5a, 0xe0, 0x51, 0x77, 0x2b, 0xc0, 0x6f, 0x54, 0xe0, 0x00, 0x39, 0x38,
    0x24, 0xa1, 0xc9, 0xea, 0xcd, 0x8a, 0x30, 0x05, 0x7e, 0x4d, 0x76, 0x86, 0x34, 0x54, 0xa0, 0xa9,
    0xba, 0xc7, 0x7e, 0x7d, 0xe4, 0x33, 0x29, 0xd6, 0x12, 0x94, 0x1a, 0xf0, 0x59, 0xd5, 0x13, 0xa1,
    0x1c, 0x57, 0x2f, 0x5b, 0x90, 0x2b, 0x26, 0x76, 0x90, 0x0c, 0x02, 0x89, 0x2d, 0xa9, 0x7a, 0xa3,
    0xc7, 0x74, 0x56, 0xe4, 0xa0, 0xf9, 0x55, 0xfc, 0x98, 0x45, 0x2c, 0x05, 0x63, 0xe7, 0xed, 0x03,
    0x17, 0x53, 0x6e, 0x82, 0x3a, 0xcb, 0x57, 0x8a, 0xbb, 0xb7, 0xcb, 0xc9, 0x39, 0x22, 0x7a, 0x84,
    0x1d, 0x75, 0xde, 0x6b, 0x2f, 0xb6, 0x70, 0xf8, 0xae, 0x2b, 0x29, 0x52, 0xfb, 0x59, 0x85, 0xad,
    0xd0, 0x4e, 0x08, 0x17, 0x32, 0x25, 0x0c, 0x1f, 0xd4, 0x64, 0xd0, 0x10, 0xc8, 0x30, 0x24, 0x3d,
    0xad, 0x8b, 0x4e, 0xd8, 0x2c, 0xd1, 0x83, 0x85, 0xc3, 0x65, 0x76, 0xde, 0xa6, 0x6c, 0x75, 0x0f,
    0x8f, 0x50, 0xc2, 0x49, 0x1a, 0x6a, 0x2d, 0xda, 0x69, 0x8e, 0x46, 0x28, 0x6c, 0xd8, 0x7f, 0x77,
    0xb0, 0x21, 0x5b, 0x2a, 0xe4, 0x0b, 0x7f, 0x2d, 0x18, 0xfa, 0x85, 0x67, 0xd1, 0x84, 0xba, 0x3c,
    0xd4, 0x85, 0x43, 0x2d, 0xb1, 0x4a, 0x96, 0x34, 0x2b, 0xcf, 0x44, 0x34, 0x3b, 0x74, 0x9c, 0x1b,
    0xdd, 0xac, 0x99, 0x01, 0x9b, 0xaa, 0x40, 0xcf, 0x66, 0x98, 0xd9, 0x82, 0xad, 0xe1, 0xc5, 0x6a,
    0x85, 0x26, 0x7e, 0x82, 0xfb, 0xe6, 0x04, 0x0f, 0x0c, 0xc4, 0xd4, 0xb8, 0x07, 0x53, 0x9f, 0xc3,
    0x81, 0x99, 0xca, 0xcb, 0x0d, 0x98, 0x17, 0x3d, 0xb8, 0xe9, 0xc9, 0x54, 0x0e, 0x8a, 0x21, 0x1d,
    0xf6, 0x4c, 0x66, 0x0f, 0xdb, 0xc9, 0xbc, 0x09, 0xc0, 0x6e, 0xbf, 0x27, 0x84, 0x07, 0xdc, 0xae,
    0x9a, 0x09, 0x46, 0xe3, 0x7d, 0x35, 0xd4, 0xcd, 0xba, 0x23, 0x8a, 0x9a, 0xa5, 0x9b, 0xee, 0x49,
    0xe4, 0x0a, 0x96, 0x92, 0xc4, 0x3f, 0x1a, 0x71, 0xf4, 0x84, 0x51, 0x97, 0xbc, 0x20, 0xb5, 0x0f,
    0x3d, 0x10, 0x3b, 0x9a, 0x9f, 0x49, 0x5a, 0xa2, 0x38, 0xae, 0xfa, 0x8b, 0x6a, 0xe1, 0xad, 0xfb,
    0x20, 0x2a, 0xdf, 0x86, 0x67, 0x94, 0xbf, 0xdb, 0x99, 0x59, 0x75, 0x8d, 0x4d, 0x73, 0x72, 0x2a,
    0xa6, 0x76, 0x38, 0x74, 0xbc, 0xf7, 0x5e, 0x8f, 0xbc, 0x41, 0x74, 0x4b, 0xf7, 0xc0, 0x0a, 0xc1,
    0x95, 0x29, 0x40, 0xef, 0xd4, 0xec, 0x03, 0x4f, 0x04, 0x2b, 0xaf, 0x33, 0x35, 0x86, 0xd8, 0xbc,
    0xf4, 0x9e, 0x05, 0x0a, 0x58, 0x70, 0x39, 0xff, 0x44, 0x34, 0xe5, 0xd7, 0xe5, 0xd8, 0x6f, 0x9e,
    0x0d, 0x5e, 0xd7, 0x11, 0x79, 0xff, 0x17, 0x5a, 0x7d, 0x21, 0x92, 0x12, 0xe4, 0xbd, 0x6c, 0xd7,
    0xee, 0x47, 0x26, 0x22, 0xc2, 0x2a, 0xba, 0x8a, 0x28, 0xe7, 0x8a, 0xae, 0x51, 0x64, 0x2f, 0x31,
    0x9a, 0x6f, 0xfe, 0x3d, 0xd4, 0xc5, 0xab, 0x96, 0x83, 0x21, 0x32, 0x56, 0x48, 0x38, 0x0a, 0xe1,
    0xb1, 0xbe, 0xe3, 0xf2, 0xa9, 0x27, 0xf1, 0x9f, 0xb3, 0x4f, 0x64, 0x2f, 0x72, 0xed, 0xbb, 0x06,
    0x1a, 0x33, 0x05, 0xe5, 0x48, 0x2f, 0x95, 0xd6, 0x3a, 0xc9, 0x0f, 0xca, 0xeb, 0x75, 0xb3, 0x11,
    0xbb, 0xf6, 0x9d, 0xb3, 0xbb, 0x52, 0x3b, 0xe0, 0x27, 0xd0, 0xaa, 0x56, 0x5d, 0xae, 0x8c, 0x82,
    0xdd, 0x72, 0x9a, 0x12, 0x63, 0x74, 0x9f, 0xcb, 0xe2, 0xf7, 0x9d, 0x6f, 0xa6, 0x69, 0x12, 0xdd,
    0xea, 0xfe, 0xbb, 0x86, 0x0f, 0xff, 0x9b, 0xfa, 0xaf, 0x7b, 0x20, 0xda, 0x85, 0xd3, 0xf7, 0x63,
    0x71, 0xe2, 0x6c, 0x1f, 0x99, 0x9c, 0x00, 0x7b, 0xcc, 0x6d, 0x9f, 0xb0, 0x3a, 0x4f, 0xc3, 0x4e,
    0x96, 0xc3, 0x5d, 0xd2, 0xc1, 0xd1, 0x77, 0xab, 0x2c, 0x28, 0x8c, 0x24, 0x0e, 0x0f, 0xdc, 0xdc,
    0x20, 0xfe, 0xa6, 0xbc, 0x25, 0x12, 0x2b, 0xa2, 0xf4, 0xe9, 0x01, 0x7d, 0xf8, 0xdd, 0x43, 0x77,
    0xea, 0x0e, 0x52, 0x94, 0x1d, 0xe7, 0x45, 0x75, 0x09, 0x4e, 0x3b, 0x91, 0x85, 0x95, 0x9b, 0xa7,
    0xb3, 0xe9, 0x07, 0x04, 0x70, 0xda, 0xee, 0xde, 0x13, 0x72, 0xde, 0xd9, 0xbc, 0x5e, 0xc8, 0x96,
    0x60, 0x23, 0x75, 0x1e, 0x8a, 0x7c, 0xa8, 0xdd, 0x06, 0x80, 0x4d, 0xdd, 0xb7, 0xe6, 0x22, 0x1f,
    0x5f, 0x0f, 0x46, 0xa3, 0x8b, 0xff, 0x00, 0x59, 0xa9, 0x55, 0xe9
};
#endif

PyTypeObject *init_ComboTabBar(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX].type;

    Shiboken::AutoDecRef Sbk_ComboTabBar_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_ComboTabBar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "ComboTabBar",
        "ComboTabBar*",
        &Sbk_ComboTabBar_spec,
        &Shiboken::callCppDestructor< ComboTabBar >,
        Sbk_ComboTabBar_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_ComboTabBar_Type; // references _Sbk_ComboTabBar_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, ComboTabBar_SignatureStrings);
#else
    InitSignatureBytes(pyType, ComboTabBar_SignatureBytes, ComboTabBar_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_ComboTabBar_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        ComboTabBar_PythonToCpp_ComboTabBar_PTR,
        is_ComboTabBar_PythonToCpp_ComboTabBar_PTR_Convertible,
        ComboTabBar_PTR_CppToPython_ComboTabBar);

    Shiboken::Conversions::registerConverterName(converter, "ComboTabBar");
    Shiboken::Conversions::registerConverterName(converter, "ComboTabBar*");
    Shiboken::Conversions::registerConverterName(converter, "ComboTabBar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::ComboTabBar).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(ComboTabBarWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_ComboTabBar_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_ComboTabBar_TypeF(), &Sbk_ComboTabBarSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_ComboTabBar_TypeF(), &Sbk_ComboTabBar_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_ComboTabBar_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'SizeType'.
    const char *SizeType_Initializer[] = {
        "PinnedTabWidth",
        "ActiveTabMinimumWidth",
        "NormalTabMinimumWidth",
        "NormalTabMaximumWidth",
        "OverflowedTabWidth",
        "ExtraReservedWidth",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t SizeType_InitializerValues[] = {
        uint8_t(ComboTabBar::SizeType::PinnedTabWidth),        //  0x00  0
        uint8_t(ComboTabBar::SizeType::ActiveTabMinimumWidth), //  0x01  1
        uint8_t(ComboTabBar::SizeType::NormalTabMinimumWidth), //  0x02  2
        uint8_t(ComboTabBar::SizeType::NormalTabMaximumWidth), //  0x03  3
        uint8_t(ComboTabBar::SizeType::OverflowedTabWidth),    //  0x04  4
        uint8_t(ComboTabBar::SizeType::ExtraReservedWidth)     //  0x05  5
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_ComboTabBar_TypeF(),
        "1:PyFalkon.ComboTabBar.SizeType",
        SizeType_Initializer, SizeType_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_ComboTabBar_SizeType_IDX].type = EType;
    // Register converter for enum 'ComboTabBar::SizeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            ComboTabBar_SizeType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_ComboTabBar_SizeType,
            is_Enum_PythonToCpp_ComboTabBar_SizeType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "ComboTabBar::SizeType");
        Shiboken::Conversions::registerConverterAlias(converter, "SizeType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'SizeType' enum.

    // Initialization of enum 'DropIndicatorPosition'.
    const char *DropIndicatorPosition_Initializer[] = {
        "BeforeTab",
        "AfterTab",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t DropIndicatorPosition_InitializerValues[] = {
        uint8_t(ComboTabBar::DropIndicatorPosition::BeforeTab), //  0x00  0
        uint8_t(ComboTabBar::DropIndicatorPosition::AfterTab)   //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_ComboTabBar_TypeF(),
        "1:PyFalkon.ComboTabBar.DropIndicatorPosition",
        DropIndicatorPosition_Initializer, DropIndicatorPosition_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_ComboTabBar_DropIndicatorPosition_IDX].type = EType;
    // Register converter for enum 'ComboTabBar::DropIndicatorPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            ComboTabBar_DropIndicatorPosition_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_ComboTabBar_DropIndicatorPosition,
            is_Enum_PythonToCpp_ComboTabBar_DropIndicatorPosition_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "ComboTabBar::DropIndicatorPosition");
        Shiboken::Conversions::registerConverterAlias(converter, "DropIndicatorPosition");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'DropIndicatorPosition' enum.

    PySide::Signal::registerSignals(pyType, &::ComboTabBar::staticMetaObject);
    ComboTabBarWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::ComboTabBar::staticMetaObject, sizeof(ComboTabBarWrapper));

    return pyType;
}
