#ifndef SBK_WEBPAGEWRAPPER_H
#define SBK_WEBPAGEWRAPPER_H

#include <webpage.h>


// Argument includes
#include <QString>
#include <QStringList>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qprinter.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwebenginecertificateerror.h>
#include <qwebenginefullscreenrequest.h>
#include <qwebenginepage.h>
#include <webhittestresult.h>
#include <webview.h>
#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class WebPageWrapper : public WebPage
{
public:
    WebPageWrapper(::QObject * parent = nullptr);
    WebPageWrapper(const WebPageWrapper &) = delete;
    WebPageWrapper& operator=(const WebPageWrapper &) = delete;
    WebPageWrapper(WebPageWrapper &&) = delete;
    WebPageWrapper& operator=(WebPageWrapper &&) = delete;
    ~WebPageWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QWebEnginePage * createWindow_protected(::QWebEnginePage::WebWindowType type) { return QWebEnginePage::createWindow(QWebEnginePage::WebWindowType(type)); }
    ::QWebEnginePage * createWindow(::QWebEnginePage::WebWindowType type) override;
    static ::QWebEnginePage * sbk_o_createWindow(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEnginePage::WebWindowType type);
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void finished_protected() { WebPage::finished(); }
    void javaScriptAlert(const ::QUrl & securityOrigin, const ::QString & msg) override;
    static void sbk_o_javaScriptAlert(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & securityOrigin, const ::QString & msg);
    bool javaScriptConfirm(const ::QUrl & securityOrigin, const ::QString & msg) override;
    static bool sbk_o_javaScriptConfirm(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & securityOrigin, const ::QString & msg);
    void javaScriptConsoleMessage(::QWebEnginePage::JavaScriptConsoleMessageLevel level, const ::QString & message, int lineNumber, const ::QString & sourceID) override;
    static void sbk_o_javaScriptConsoleMessage(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEnginePage::JavaScriptConsoleMessageLevel level, const ::QString & message, int lineNumber, const ::QString & sourceID);
    bool javaScriptPrompt_protected(const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result) { return QWebEnginePage::javaScriptPrompt(securityOrigin, msg, defaultValue, result); }
    bool javaScriptPrompt(const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result) override;
    static bool sbk_o_javaScriptPrompt(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result);
    void progress_protected(int prog) { WebPage::progress(prog); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    void triggerAction(::QWebEnginePage::WebAction action, bool checked = false) override;
    static void sbk_o_triggerAction(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEnginePage::WebAction action, bool checked = false);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    static ::std::pair<bool,QString> javaScriptPromptPyOverride(Shiboken::GilState &gil, PyObject *pyOverride, ::QUrl securityOrigin, ::QString msg, ::QString defaultValue);

    mutable std::array<PyObject *, 13> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  ifndef SBK_QWEBENGINEPAGEWRAPPER_H
#  define SBK_QWEBENGINEPAGEWRAPPER_H

// Inherited base class:
class QWebEnginePageWrapper : public QWebEnginePage
{
public:
    QWebEnginePageWrapper(::QObject * parent = nullptr);
    QWebEnginePageWrapper(::QWebEngineProfile * profile, ::QObject * parent = nullptr);
    QWebEnginePageWrapper(const QWebEnginePageWrapper &) = delete;
    QWebEnginePageWrapper& operator=(const QWebEnginePageWrapper &) = delete;
    QWebEnginePageWrapper(QWebEnginePageWrapper &&) = delete;
    QWebEnginePageWrapper& operator=(QWebEnginePageWrapper &&) = delete;
    ~QWebEnginePageWrapper() override;

    bool acceptNavigationRequest_protected(const ::QUrl & url, ::QWebEnginePage::NavigationType type, bool isMainFrame) { return QWebEnginePage::acceptNavigationRequest(url, QWebEnginePage::NavigationType(type), isMainFrame); }
    bool acceptNavigationRequest(const ::QUrl & url, ::QWebEnginePage::NavigationType type, bool isMainFrame) override;
    static bool sbk_o_acceptNavigationRequest(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & url, ::QWebEnginePage::NavigationType type, bool isMainFrame);
    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    ::QStringList chooseFiles_protected(::QWebEnginePage::FileSelectionMode mode, const ::QStringList & oldFiles, const ::QStringList & acceptedMimeTypes) { return QWebEnginePage::chooseFiles(QWebEnginePage::FileSelectionMode(mode), oldFiles, acceptedMimeTypes); }
    ::QStringList chooseFiles(::QWebEnginePage::FileSelectionMode mode, const ::QStringList & oldFiles, const ::QStringList & acceptedMimeTypes) override;
    static ::QStringList sbk_o_chooseFiles(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWebEnginePage::FileSelectionMode mode, const ::QStringList & oldFiles, const ::QStringList & acceptedMimeTypes);
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QWebEnginePage * createWindow_protected(::QWebEnginePage::WebWindowType type) { return QWebEnginePage::createWindow(QWebEnginePage::WebWindowType(type)); }
    ::QWebEnginePage * createWindow(::QWebEnginePage::WebWindowType type) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void javaScriptAlert_protected(const ::QUrl & securityOrigin, const ::QString & msg) { QWebEnginePage::javaScriptAlert(securityOrigin, msg); }
    void javaScriptAlert(const ::QUrl & securityOrigin, const ::QString & msg) override;
    bool javaScriptConfirm_protected(const ::QUrl & securityOrigin, const ::QString & msg) { return QWebEnginePage::javaScriptConfirm(securityOrigin, msg); }
    bool javaScriptConfirm(const ::QUrl & securityOrigin, const ::QString & msg) override;
    void javaScriptConsoleMessage_protected(::QWebEnginePage::JavaScriptConsoleMessageLevel level, const ::QString & message, int lineNumber, const ::QString & sourceID) { QWebEnginePage::javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel(level), message, lineNumber, sourceID); }
    void javaScriptConsoleMessage(::QWebEnginePage::JavaScriptConsoleMessageLevel level, const ::QString & message, int lineNumber, const ::QString & sourceID) override;
    bool javaScriptPrompt_protected(const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result) { return QWebEnginePage::javaScriptPrompt(securityOrigin, msg, defaultValue, result); }
    bool javaScriptPrompt(const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result) override;
    static bool sbk_o_javaScriptPrompt(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result);
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    void triggerAction(::QWebEnginePage::WebAction action, bool checked = false) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    static ::std::pair<bool,QString> javaScriptPromptPyOverride(Shiboken::GilState &gil, PyObject *pyOverride, ::QUrl securityOrigin, ::QString msg, ::QString defaultValue);

    mutable std::array<PyObject *, 15> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QWEBENGINEPAGEWRAPPER_H

#  ifndef SBK_QOBJECTWRAPPER_H
#  define SBK_QOBJECTWRAPPER_H

// Inherited base class:
class QObjectWrapper : public QObject
{
public:
    QObjectWrapper(::QObject * parent = nullptr);
    QObjectWrapper(const QObjectWrapper &) = delete;
    QObjectWrapper& operator=(const QObjectWrapper &) = delete;
    QObjectWrapper(QObjectWrapper &&) = delete;
    QObjectWrapper& operator=(QObjectWrapper &&) = delete;
    ~QObjectWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    bool isSignalConnected_protected(const ::QMetaMethod & signal) const { return QObject::isSignalConnected(signal); }
    int receivers_protected(const char * signal) const { return QObject::receivers(signal); }
    ::QObject * sender_protected() const { return QObject::sender(); }
    int senderSignalIndex_protected() const { return QObject::senderSignalIndex(); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QOBJECTWRAPPER_H

#endif // SBK_WEBPAGEWRAPPER_H
