// Generated from libavfilter/opencl/avgblur.cl
const char *ff_source_avgblur_cl =
"/*\n"
" * Copyright (c) 2018 Dylan Fernando\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"\n"
"__kernel void avgblur_horiz(__write_only image2d_t dst,\n"
"                            __read_only  image2d_t src,\n"
"                            int rad)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_FILTER_NEAREST);\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    int2 size = (int2)(get_global_size(0), get_global_size(1));\n"
"\n"
"    int count = 0;\n"
"    float4 acc = (float4)(0,0,0,0);\n"
"\n"
"    for (int xx = max(0, loc.x - rad); xx < min(loc.x + rad + 1, size.x); xx++) {\n"
"        count++;\n"
"        acc += read_imagef(src, sampler, (int2)(xx, loc.y));\n"
"    }\n"
"\n"
"    write_imagef(dst, loc, acc / count);\n"
"}\n"
"\n"
"__kernel void avgblur_vert(__write_only image2d_t dst,\n"
"                           __read_only  image2d_t src,\n"
"                           int radv)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_FILTER_NEAREST);\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"    int2 size = (int2)(get_global_size(0), get_global_size(1));\n"
"\n"
"    int count = 0;\n"
"    float4 acc = (float4)(0,0,0,0);\n"
"\n"
"    for (int yy = max(0, loc.y - radv); yy < min(loc.y + radv + 1, size.y); yy++) {\n"
"        count++;\n"
"        acc += read_imagef(src, sampler, (int2)(loc.x, yy));\n"
"    }\n"
"\n"
"    write_imagef(dst, loc, acc / count);\n"
"}\n"
;
