/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM BlobEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "BlobEvent.h"
#include "BlobEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Blob.h"
#include "mozilla/dom/BlobEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(BlobEvent)

NS_IMPL_ADDREF_INHERITED(BlobEvent, Event)
NS_IMPL_RELEASE_INHERITED(BlobEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(BlobEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mData)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(BlobEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(BlobEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mData)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(BlobEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

BlobEvent::BlobEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

BlobEvent::~BlobEvent()
{
}

BlobEvent*
BlobEvent::AsBlobEvent()
{
  return this;
}

JSObject*
BlobEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return BlobEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<BlobEvent>
BlobEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const BlobEventInit& aEventInitDict)
{
  RefPtr<BlobEvent> e = new BlobEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mData = aEventInitDict.mData;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<BlobEvent>
BlobEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const BlobEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

Blob*
BlobEvent::Data() const
{
  return mData;
}


} // namespace mozilla::dom
