/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM DeviceOrientationEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "DeviceOrientationEvent.h"
#include "DeviceOrientationEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/DeviceOrientationEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "nsGlobalWindowInner.h"

namespace mozilla::dom {


DeviceOrientationEvent::DeviceOrientationEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

DeviceOrientationEvent::~DeviceOrientationEvent()
{
}

DeviceOrientationEvent*
DeviceOrientationEvent::AsDeviceOrientationEvent()
{
  return this;
}

JSObject*
DeviceOrientationEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return DeviceOrientationEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<DeviceOrientationEvent>
DeviceOrientationEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const DeviceOrientationEventInit& aEventInitDict)
{
  RefPtr<DeviceOrientationEvent> e = new DeviceOrientationEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mAlpha = aEventInitDict.mAlpha;
  e->mBeta = aEventInitDict.mBeta;
  e->mGamma = aEventInitDict.mGamma;
  e->mAbsolute = aEventInitDict.mAbsolute;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<DeviceOrientationEvent>
DeviceOrientationEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const DeviceOrientationEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

Nullable<double>
DeviceOrientationEvent::GetAlpha() const
{
  return mAlpha;
}

Nullable<double>
DeviceOrientationEvent::GetBeta() const
{
  return mBeta;
}

Nullable<double>
DeviceOrientationEvent::GetGamma() const
{
  return mGamma;
}

bool
DeviceOrientationEvent::Absolute() const
{
  return mAbsolute;
}

void
DeviceOrientationEvent::InitDeviceOrientationEvent(const nsAString& aType, bool aCanBubble, bool aCancelable, const Nullable<double>& aAlpha, const Nullable<double>& aBeta, const Nullable<double>& aGamma, bool aAbsolute)
{
  InitEvent(aType, aCanBubble, aCancelable);
  mAlpha = aAlpha;
  mBeta = aBeta;
  mGamma = aGamma;
  mAbsolute = aAbsolute;

}


} // namespace mozilla::dom
