struct composite_FAST_PATH_TEXTURE_RECT_common {
struct Samplers {
 sampler2DRect_impl sColor0_impl;
 int sColor0_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 2:
   sColor0_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aDeviceRect = NULL_ATTRIB;
 int aDeviceClipRect = NULL_ATTRIB;
 int aParams = NULL_ATTRIB;
 int aFlip = NULL_ATTRIB;
 int aUvRect0 = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aDeviceRect", name) == 0) { aDeviceRect = index; return; }
  if (strcmp("aDeviceClipRect", name) == 0) { aDeviceClipRect = index; return; }
  if (strcmp("aParams", name) == 0) { aParams = index; return; }
  if (strcmp("aFlip", name) == 0) { aFlip = index; return; }
  if (strcmp("aUvRect0", name) == 0) { aUvRect0 = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aDeviceRect", name) == 0) { return aDeviceRect != NULL_ATTRIB ? aDeviceRect : -1; }
  if (strcmp("aDeviceClipRect", name) == 0) { return aDeviceClipRect != NULL_ATTRIB ? aDeviceClipRect : -1; }
  if (strcmp("aParams", name) == 0) { return aParams != NULL_ATTRIB ? aParams : -1; }
  if (strcmp("aFlip", name) == 0) { return aFlip != NULL_ATTRIB ? aFlip : -1; }
  if (strcmp("aUvRect0", name) == 0) { return aUvRect0 != NULL_ATTRIB ? aUvRect0 : -1; }
  return -1;
 }
} attrib_locations;
sampler2DRect sColor0;
mat4_scalar uTransform;
void bind_textures() {
 sColor0 = lookup_sampler(&samplers.sColor0_impl, samplers.sColor0_slot);
}
};
struct composite_FAST_PATH_TEXTURE_RECT_vert : VertexShaderImpl, composite_FAST_PATH_TEXTURE_RECT_common {
private:
typedef composite_FAST_PATH_TEXTURE_RECT_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
// sampler2DRect sColor0;
// sampler2DRect sColor1;
// sampler2DRect sColor2;
vec2 vUv;
vec4_scalar aDeviceRect;
vec4_scalar aDeviceClipRect;
vec4_scalar aColor;
vec4_scalar aParams;
vec2_scalar aFlip;
vec4_scalar aUvRect0;
ALWAYS_INLINE void main(void) {
 vec4_scalar device_rect = mix((aDeviceRect).sel(X,Y,Z,W), (aDeviceRect).sel(Z,W,X,Y), (aFlip).sel(X,Y,X,Y));
 vec2 world_pos = mix((device_rect).sel(X,Y), (device_rect).sel(Z,W), (aPosition).sel(X,Y));
 vec2 clipped_world_pos = clamp(world_pos, (aDeviceClipRect).sel(X,Y), (aDeviceClipRect).sel(Z,W));
 vec2 uv = ((clipped_world_pos)-((device_rect).sel(X,Y)))/(((device_rect).sel(Z,W))-((device_rect).sel(X,Y)));
 uv = mix((aUvRect0).sel(X,Y), (aUvRect0).sel(Z,W), uv);
 vec4_scalar uvBounds = make_vec4(min((aUvRect0).sel(X,Y), (aUvRect0).sel(Z,W)), max((aUvRect0).sel(X,Y), (aUvRect0).sel(Z,W)));
 if ((make_int((aParams).y))==(1)) {
  {
   vec2_scalar texture_size = make_vec2(1.f, 1.f);
   uvBounds += make_vec4(0.5f, 0.5f, -(0.5f), -(0.5f));
  }
 }
 vUv = uv;
 gl_Position = (uTransform)*(make_vec4(clipped_world_pos, 0.f, 1.f));
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 2:
  assert(0); // sColor0
  break;
 case 1:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 2:
  assert(0); // sColor0
  break;
 case 1:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 2:
  assert(0); // sColor0
  break;
 case 1:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aDeviceRect, attribs[self->attrib_locations.aDeviceRect], start, instance, count);
 load_flat_attrib(self->aDeviceClipRect, attribs[self->attrib_locations.aDeviceClipRect], start, instance, count);
 load_flat_attrib(self->aParams, attribs[self->attrib_locations.aParams], start, instance, count);
 load_flat_attrib(self->aFlip, attribs[self->attrib_locations.aFlip], start, instance, count);
 load_flat_attrib(self->aUvRect0, attribs[self->attrib_locations.aUvRect0], start, instance, count);
}
public:
struct InterpOutputs {
vec2_scalar vUv;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vUv = get_nth(vUv, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
composite_FAST_PATH_TEXTURE_RECT_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct composite_FAST_PATH_TEXTURE_RECT_frag : FragmentShaderImpl, composite_FAST_PATH_TEXTURE_RECT_vert {
private:
typedef composite_FAST_PATH_TEXTURE_RECT_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
// sampler2DRect sColor0;
// sampler2DRect sColor1;
// sampler2DRect sColor2;
vec2 vUv;
void write_output(vec4 color) {
 oFragColor = color;
}
ALWAYS_INLINE void main(void) {
 vec2 uv = vUv;
 vec4 texel = texture(sColor0, (uv).sel(X,Y));
 vec4 color = texel;
 write_output(color);
}
void swgl_drawSpanRGBA8() {
 vec4_scalar color = make_vec4(1.f);
 vec4_scalar uvBounds = make_vec4(make_vec2(0.f), make_vec2(textureSize(sColor0)));
 if ((color)!=(make_vec4(1.f))) {
  {
   swgl_commitTextureColorRGBA8(sColor0, vUv, uvBounds, color);
  }
 } else  {
  swgl_commitTextureRGBA8(sColor0, vUv, uvBounds);
 }
}
typedef composite_FAST_PATH_TEXTURE_RECT_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec2 vUv;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vUv = init_interp(init->vUv, step->vUv);
  self->interp_step.vUv = step->vUv * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vUv = init_interp(init->vUv, step->vUv);
  self->vUv = self->interp_perspective.vUv * w;
  self->interp_step.vUv = step->vUv * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vUv += interp_step.vUv * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vUv += interp_step.vUv * chunks;
  vUv = w * interp_perspective.vUv;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
static int draw_span_RGBA8(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl; DISPATCH_DRAW_SPAN(self, RGBA8); }
public:
composite_FAST_PATH_TEXTURE_RECT_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 draw_span_RGBA8_func = &draw_span_RGBA8;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct composite_FAST_PATH_TEXTURE_RECT_program : ProgramImpl, composite_FAST_PATH_TEXTURE_RECT_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sColor0", name) == 0) { return 2; }
 if (strcmp("uTransform", name) == 0) { return 1; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "composite_FAST_PATH_TEXTURE_RECT"; }
static ProgramImpl* loader() { return new composite_FAST_PATH_TEXTURE_RECT_program; }
};

