/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_PseudoElementHashEntry_h
#define mozilla_PseudoElementHashEntry_h

#include "PLDHashTable.h"
#include "mozilla/AnimationTarget.h"
#include "mozilla/HashFunctions.h"
#include "mozilla/dom/Element.h"

namespace mozilla {

// A hash entry that uses a RefPtr<dom::Element>, PseudoStyleType pair
class PseudoElementHashEntry : public PLDHashEntryHdr {
 public:
  typedef NonOwningAnimationTarget KeyType;
  typedef const NonOwningAnimationTarget* KeyTypePointer;

  explicit PseudoElementHashEntry(KeyTypePointer aKey)
      : mElement(aKey->mElement), mPseudoRequest(aKey->mPseudoRequest) {}
  PseudoElementHashEntry(PseudoElementHashEntry&& aOther) = default;

  ~PseudoElementHashEntry() = default;

  KeyType GetKey() const { return {mElement, mPseudoRequest}; }
  bool KeyEquals(KeyTypePointer aKey) const {
    return mElement == aKey->mElement && mPseudoRequest == aKey->mPseudoRequest;
  }

  static KeyTypePointer KeyToPointer(KeyType& aKey) { return &aKey; }
  static PLDHashNumber HashKey(KeyTypePointer aKey) {
    if (!aKey) return 0;

    // Convert the scoped enum into an integer while adding it to hash.
    static_assert(sizeof(PseudoStyleType) == sizeof(uint8_t), "");
    return mozilla::HashGeneric(
        aKey->mElement, static_cast<uint8_t>(aKey->mPseudoRequest.mType),
        aKey->mPseudoRequest.mIdentifier.get());
  }
  enum { ALLOW_MEMMOVE = true };

  RefPtr<dom::Element> mElement;
  PseudoStyleRequest mPseudoRequest;
};

}  // namespace mozilla

#endif  // mozilla_PseudoElementHashEntry_h
