//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/camera/PCamerasParent.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/MediaIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/PContentParent.h"
#include "mozilla/ipc/PBackgroundParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace camera {


MOZ_IMPLICIT PCamerasParent::PCamerasParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PCamerasParent);
}

PCamerasParent::~PCamerasParent()
{
    MOZ_COUNT_DTOR(PCamerasParent);
}

auto PCamerasParent::ActorAlloc() -> void
{
}

auto PCamerasParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PCamerasParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCamerasParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCamerasParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCamerasParent::Manager() const -> PBackgroundParent*
{
    return static_cast<PBackgroundParent*>(IProtocol::Manager());
}

auto PCamerasParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PCamerasParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PCamerasParent::SendCaptureEnded(const int& streamId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_CaptureEnded(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), streamId);
    // Sentinel = 'streamId'
    ((&(writer__)))->WriteSentinel(254935866);


    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_CaptureEnded", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendDeliverFrame(
        const int& streamId,
        Shmem&& buffer,
        const VideoFrameProperties& props) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_DeliverFrame(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), streamId);
    // Sentinel = 'streamId'
    ((&(writer__)))->WriteSentinel(254935866);
    IPC::WriteParam((&(writer__)), std::move(buffer));
    // Sentinel = 'buffer'
    ((&(writer__)))->WriteSentinel(144769659);
    IPC::WriteParam((&(writer__)), props);
    // Sentinel = 'props'
    ((&(writer__)))->WriteSentinel(110953013);


    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_DeliverFrame", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendDeviceChange() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_DeviceChange(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_DeviceChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendReplyNumberOfCaptureDevices(const int& deviceCount) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReplyNumberOfCaptureDevices(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), deviceCount);
    // Sentinel = 'deviceCount'
    ((&(writer__)))->WriteSentinel(444859514);


    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReplyNumberOfCaptureDevices", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendReplyNumberOfCapabilities(const int& capabilityCount) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReplyNumberOfCapabilities(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), capabilityCount);
    // Sentinel = 'capabilityCount'
    ((&(writer__)))->WriteSentinel(814089772);


    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReplyNumberOfCapabilities", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendReplyAllocateCapture(const int& captureId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReplyAllocateCapture(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), captureId);
    // Sentinel = 'captureId'
    ((&(writer__)))->WriteSentinel(311034786);


    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReplyAllocateCapture", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendReplyGetCaptureCapability(const VideoCaptureCapability& cap) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReplyGetCaptureCapability(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), cap);
    // Sentinel = 'cap'
    ((&(writer__)))->WriteSentinel(39715125);


    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReplyGetCaptureCapability", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendReplyGetCaptureDevice(
        const nsACString& device_name,
        const nsACString& device_id,
        const bool& scary) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReplyGetCaptureDevice(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), device_name);
    // Sentinel = 'device_name'
    ((&(writer__)))->WriteSentinel(448726129);
    IPC::WriteParam((&(writer__)), device_id);
    // Sentinel = 'device_id'
    ((&(writer__)))->WriteSentinel(305857437);
    IPC::WriteParam((&(writer__)), scary);
    // Sentinel = 'scary'
    ((&(writer__)))->WriteSentinel(105906723);


    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReplyGetCaptureDevice", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendReplyFailure() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReplyFailure(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReplyFailure", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::SendReplySuccess() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCameras::Msg_ReplySuccess(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg_ReplySuccess", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCamerasParent::Send__delete__(PCamerasParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PCameras::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCamerasParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCameras::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PCamerasParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PCamerasParent::OnMessageReceived(const Message& msg__) -> PCamerasParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCameras::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PCameras::Msg_NumberOfCaptureDevices__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_NumberOfCaptureDevices", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNumberOfCaptureDevices(std::move(engine));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_NumberOfCapabilities__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_NumberOfCapabilities", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            auto maybe__deviceUniqueIdUTF8 = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__deviceUniqueIdUTF8) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& deviceUniqueIdUTF8 = *maybe__deviceUniqueIdUTF8;
            // Sentinel = 'deviceUniqueIdUTF8'
            if ((!(((&(reader__)))->ReadSentinel(1137903292)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvNumberOfCapabilities(std::move(engine), std::move(deviceUniqueIdUTF8));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_GetCaptureCapability__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_GetCaptureCapability", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            auto maybe__unique_idUTF8 = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__unique_idUTF8) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& unique_idUTF8 = *maybe__unique_idUTF8;
            // Sentinel = 'unique_idUTF8'
            if ((!(((&(reader__)))->ReadSentinel(628032747)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__capability_number = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__capability_number) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& capability_number = *maybe__capability_number;
            // Sentinel = 'capability_number'
            if ((!(((&(reader__)))->ReadSentinel(1050543883)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvGetCaptureCapability(std::move(engine), std::move(unique_idUTF8), std::move(capability_number));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_GetCaptureDevice__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_GetCaptureDevice", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            auto maybe__deviceIndex = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__deviceIndex) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& deviceIndex = *maybe__deviceIndex;
            // Sentinel = 'deviceIndex'
            if ((!(((&(reader__)))->ReadSentinel(442303593)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvGetCaptureDevice(std::move(engine), std::move(deviceIndex));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_AllocateCapture__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_AllocateCapture", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            auto maybe__unique_idUTF8 = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__unique_idUTF8) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& unique_idUTF8 = *maybe__unique_idUTF8;
            // Sentinel = 'unique_idUTF8'
            if ((!(((&(reader__)))->ReadSentinel(628032747)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__windowID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__windowID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& windowID = *maybe__windowID;
            // Sentinel = 'windowID'
            if ((!(((&(reader__)))->ReadSentinel(253625126)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvAllocateCapture(std::move(engine), std::move(unique_idUTF8), std::move(windowID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReleaseCapture__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReleaseCapture", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            auto maybe__captureId = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__captureId) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& captureId = *maybe__captureId;
            // Sentinel = 'captureId'
            if ((!(((&(reader__)))->ReadSentinel(311034786)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReleaseCapture(std::move(engine), std::move(captureId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_StartCapture__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_StartCapture", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            auto maybe__captureId = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__captureId) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& captureId = *maybe__captureId;
            // Sentinel = 'captureId'
            if ((!(((&(reader__)))->ReadSentinel(311034786)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            auto maybe__capability = IPC::ReadParam<VideoCaptureCapability>((&(reader__)));
            if (!maybe__capability) {
                FatalError("Error deserializing 'VideoCaptureCapability'");
                return MsgValueError;

            }
            auto& capability = *maybe__capability;
            // Sentinel = 'capability'
            if ((!(((&(reader__)))->ReadSentinel(371000355)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VideoCaptureCapability'");
                return MsgValueError;
            }
            auto maybe__constraints = IPC::ReadParam<NormalizedConstraints>((&(reader__)));
            if (!maybe__constraints) {
                FatalError("Error deserializing 'NormalizedConstraints'");
                return MsgValueError;

            }
            auto& constraints = *maybe__constraints;
            // Sentinel = 'constraints'
            if ((!(((&(reader__)))->ReadSentinel(471729337)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NormalizedConstraints'");
                return MsgValueError;
            }
            auto maybe__resizeMode = IPC::ReadParam<VideoResizeModeEnum>((&(reader__)));
            if (!maybe__resizeMode) {
                FatalError("Error deserializing 'VideoResizeModeEnum'");
                return MsgValueError;

            }
            auto& resizeMode = *maybe__resizeMode;
            // Sentinel = 'resizeMode'
            if ((!(((&(reader__)))->ReadSentinel(386204696)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'VideoResizeModeEnum'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvStartCapture(std::move(engine), std::move(captureId), std::move(capability), std::move(constraints), std::move(resizeMode));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_FocusOnSelectedSource__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_FocusOnSelectedSource", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            auto maybe__captureId = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__captureId) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& captureId = *maybe__captureId;
            // Sentinel = 'captureId'
            if ((!(((&(reader__)))->ReadSentinel(311034786)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvFocusOnSelectedSource(std::move(engine), std::move(captureId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_StopCapture__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_StopCapture", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            auto maybe__captureId = IPC::ReadParam<int>((&(reader__)));
            if (!maybe__captureId) {
                FatalError("Error deserializing 'int'");
                return MsgValueError;

            }
            auto& captureId = *maybe__captureId;
            // Sentinel = 'captureId'
            if ((!(((&(reader__)))->ReadSentinel(311034786)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvStopCapture(std::move(engine), std::move(captureId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_ReleaseFrame__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_ReleaseFrame", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__s = IPC::ReadParam<Shmem>((&(reader__)));
            if (!maybe__s) {
                FatalError("Error deserializing 'Shmem'");
                return MsgValueError;

            }
            auto& s = *maybe__s;
            // Sentinel = 's'
            if ((!(((&(reader__)))->ReadSentinel(7602292)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Shmem'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReleaseFrame(std::move(s));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCameras::Msg_EnsureInitialized__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCameras", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCamerasParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCameras::Msg_EnsureInitialized", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__engine = IPC::ReadParam<CaptureEngine>((&(reader__)));
            if (!maybe__engine) {
                FatalError("Error deserializing 'CaptureEngine'");
                return MsgValueError;

            }
            auto& engine = *maybe__engine;
            // Sentinel = 'engine'
            if ((!(((&(reader__)))->ReadSentinel(144835191)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CaptureEngine'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvEnsureInitialized(std::move(engine));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PCamerasParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCamerasParent::Result
{
    return MsgNotKnown;
}



} // namespace camera
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::camera::PCamerasParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PCameras'
    (aWriter)->WriteSentinel(216204045);
}

auto ParamTraits<::mozilla::camera::PCamerasParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PCameras actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PCameras'
    if ((!((aReader)->ReadSentinel(216204045)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PCameras actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PCamerasMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PCameras)");

        return {};
    }
    return static_cast<::mozilla::camera::PCamerasParent*>(actor);
}

} // namespace IPC
