/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM SpeechSynthesisErrorEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "SpeechSynthesisErrorEvent.h"
#include "SpeechSynthesisErrorEventBinding.h"
#include "SpeechSynthesisEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/SpeechSynthesisErrorEvent.h"

namespace mozilla::dom {


SpeechSynthesisErrorEvent::SpeechSynthesisErrorEvent(mozilla::dom::EventTarget* aOwner)
  : SpeechSynthesisEvent(aOwner)
{
}

SpeechSynthesisErrorEvent::~SpeechSynthesisErrorEvent()
{
}

SpeechSynthesisErrorEvent*
SpeechSynthesisErrorEvent::AsSpeechSynthesisErrorEvent()
{
  return this;
}

JSObject*
SpeechSynthesisErrorEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return SpeechSynthesisErrorEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<SpeechSynthesisErrorEvent>
SpeechSynthesisErrorEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const SpeechSynthesisErrorEventInit& aEventInitDict)
{
  RefPtr<SpeechSynthesisErrorEvent> e = new SpeechSynthesisErrorEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mError = aEventInitDict.mError;
  e->mUtterance = aEventInitDict.mUtterance;
  e->mCharIndex = aEventInitDict.mCharIndex;
  e->mCharLength = aEventInitDict.mCharLength;
  e->mElapsedTime = aEventInitDict.mElapsedTime;
  e->mName = aEventInitDict.mName;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<SpeechSynthesisErrorEvent>
SpeechSynthesisErrorEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const SpeechSynthesisErrorEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

SpeechSynthesisErrorCode
SpeechSynthesisErrorEvent::Error() const
{
  return mError;
}


} // namespace mozilla::dom
