/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "StaticComponents.h"

#include "mozilla/ArrayUtils.h"
#ifdef MOZ_BACKGROUNDTASKS
#  include "mozilla/BackgroundTasks.h"
#endif
#include "mozilla/PerfectHash.h"
#include "mozilla/ResultExtensions.h"
#include "mozilla/StaticPtr.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozJSModuleLoader.h"
#include "nsCOMPtr.h"
#include "nsComponentManager.h"
#include "nsContentUtils.h"
#include "nsIFactory.h"
#include "nsISupports.h"
#include "nsIXPConnect.h"
#include "nsString.h"
#include "nsStringEnumerator.h"
#include "nsTArray.h"
#include "xptdata.h"
#include "xptinfo.h"
#include "js/PropertyAndElement.h"  // JS_GetProperty

// Cleanup pollution from zipstruct.h
#undef UNSUPPORTED

// Public includes
#include "CacheStorageService.h"
#include "ContentHandlerService.h"
#include "GMPService.h"
#include "ImageBlocker.h"
#include "NSSErrorsService.h"
#include "PaymentRequestData.h"
#include "PaymentRequestService.h"
#include "ProcessToolsService.h"
#include "imgLoader.h"
#include "imgRequestProxy.h"
#include "mozilla/AddonContentPolicy.h"
#include "mozilla/AddonManagerStartup.h"
#include "mozilla/AlertNotification.h"
#include "mozilla/BackgroundTasks.h"
#include "mozilla/BackgroundTasksRunner.h"
#include "mozilla/CascadeFilter.h"
#include "mozilla/ContentBlockingTelemetryService.h"
#include "mozilla/DAPTelemetry.h"
#include "mozilla/ExtensionPolicyService.h"
#include "mozilla/FOG.h"
#include "mozilla/FinalizationWitnessService.h"
#include "mozilla/IdentityCredentialStorageService.h"
#include "mozilla/LoadContextInfo.h"
#include "mozilla/MediaManager.h"
#include "mozilla/Preferences.h"
#include "mozilla/ProfileAfterChangeGate.h"
#include "mozilla/ScriptableContentIterator.h"
#include "mozilla/StaticPtr.h"
#include "mozilla/Telemetry.h"
#include "mozilla/TextInputProcessor.h"
#include "mozilla/URLQueryStringStripper.h"
#include "mozilla/dom/BlobURL.h"
#include "mozilla/dom/BlobURLProtocolHandler.h"
#include "mozilla/dom/EventSourceEventService.h"
#include "mozilla/dom/FakeSpeechRecognitionService.h"
#include "mozilla/dom/IndexedDatabaseManager.h"
#include "mozilla/dom/IntegrityPolicy.h"
#include "mozilla/dom/IntegrityPolicyService.h"
#include "mozilla/dom/OnlineSpeechRecognitionService.h"
#include "mozilla/dom/PolicyContainer.h"
#include "mozilla/dom/PushNotifier.h"
#include "mozilla/dom/ReferrerInfo.h"
#include "mozilla/dom/SDBConnection.h"
#include "mozilla/dom/ServiceWorkerManager.h"
#include "mozilla/dom/StorageActivityService.h"
#include "mozilla/dom/WorkerDebuggerManager.h"
#include "mozilla/dom/notification/NotificationHandler.h"
#include "mozilla/dom/nsCSPContext.h"
#include "mozilla/dom/nsCSPService.h"
#include "mozilla/dom/nsContentSecurityManager.h"
#include "mozilla/dom/nsMixedContentBlocker.h"
#include "mozilla/dom/nsSynthVoiceRegistry.h"
#include "mozilla/dom/power/PowerManagerService.h"
#include "mozilla/dom/quota/QuotaManagerService.h"
#include "mozilla/extensions/ExtensionsChild.h"
#include "mozilla/extensions/NativeMessagingPortal.h"
#include "mozilla/extensions/WebNavigationContent.h"
#include "mozilla/image/RemoteImageProtocolHandler.h"
#include "mozilla/intl/LocaleService.h"
#include "mozilla/intl/OSPreferences.h"
#include "mozilla/ipc/ForkServer.h"
#include "mozilla/ipc/ForkServiceChild.h"
#include "mozilla/ml/MLUtils.h"
#include "mozilla/net/CachePurgeLock.h"
#include "mozilla/net/CaptivePortalService.h"
#include "mozilla/net/ChannelClassifierService.h"
#include "mozilla/net/CookieJarSettings.h"
#include "mozilla/net/Dashboard.h"
#include "mozilla/net/ExtensionProtocolHandler.h"
#include "mozilla/net/MozNewTabWallpaperProtocolHandler.h"
#include "mozilla/net/NetworkConnectivityService.h"
#include "mozilla/net/PageThumbProtocolHandler.h"
#include "mozilla/net/SFVService.h"
#include "mozilla/net/SubstitutingJARURI.h"
#include "mozilla/net/SubstitutingURL.h"
#include "mozilla/net/UrlClassifierExceptionList.h"
#include "mozilla/net/UrlClassifierExceptionListEntry.h"
#include "mozilla/net/WebSocketEventService.h"
#include "mozilla/net/WebTransportEventService.h"
#include "mozilla/net/nsFileProtocolHandler.h"
#include "mozilla/nsMemoryInfoDumper.h"
#include "mozilla/places/History.h"
#include "mozilla/places/PageIconProtocolHandler.h"
#include "mozilla/places/SyncedBookmarksMirror.h"
#include "mozilla/widget/ScreenManager.h"
#include "nsAppRunner.h"
#include "nsArray.h"
#include "nsBrowserStatusFilter.h"
#include "nsClientAuthRemember.h"
#include "nsConverterInputStream.h"
#include "nsDebugImpl.h"
#include "nsDeviceSensors.h"
#include "nsDirectoryService.h"
#include "nsDocLoader.h"
#include "nsExternalHelperAppService.h"
#include "nsFileStreams.h"
#include "nsGIOProtocolHandler.h"
#include "nsHashPropertyBag.h"
#include "nsInputStreamPump.h"
#include "nsJARURI.h"
#include "nsJSProtocolHandler.h"
#include "nsMIMEInputStream.h"
#include "nsMediaSniffer.h"
#include "nsMultiplexInputStream.h"
#include "nsNSSCertificate.h"
#include "nsNSSComponent.h"
#include "nsOSPermissionRequest.h"
#include "nsOpenWindowInfo.h"
#include "nsParserUtils.h"
#include "nsProcess.h"
#include "nsScriptSecurityManager.h"
#include "nsScriptableInputStream.h"
#include "nsSerializationHelper.h"
#include "nsSimpleNestedURI.h"
#include "nsSimpleURI.h"
#include "nsStorageStream.h"
#include "nsStructuredCloneContainer.h"
#include "nsStyleSheetService.h"
#include "nsSupportsPrimitives.h"
#include "nsSystemInfo.h"
#include "nsTerminator.h"
#include "nsURILoader.h"
#include "nsURLParsers.h"
#include "nsUrlClassifierPrefixSet.h"
#include "nsVariant.h"
#include "nsWindowWatcher.h"
#include "transport/stun_socket_filter.h"

// Relative includes
#include "../../browser/components/about/AboutRedirector.h"
#include "../../browser/components/shell/nsGNOMEShellService.h"
#include "../../caps/ContentPrincipal.h"
#include "../../caps/ExpandedPrincipal.h"
#include "../../caps/NullPrincipal.h"
#include "../../caps/SystemPrincipal.h"
#include "../../chrome/nsChromeProtocolHandler.h"
#include "../../chrome/nsChromeRegistry.h"
#include "../../devtools/platform/JSDebugger.h"
#include "../../devtools/platform/nsJSInspector.h"
#include "../../docshell/base/nsAboutRedirector.h"
#include "../../docshell/base/nsWebNavigationInfo.h"
#include "../../docshell/build/nsDocShellModule.h"
#include "../../dom/base/ThirdPartyUtil.h"
#include "../../dom/base/nsDataDocumentContentPolicy.h"
#include "../../dom/base/nsNoDataProtocolContentPolicy.h"
#include "../../dom/bindings/nsScriptError.h"
#include "../../dom/geolocation/Geolocation.h"
#include "../../dom/ipc/LoginDetectionService.h"
#include "../../dom/media/webspeech/synth/speechd/SpeechDispatcherService.h"
#include "../../dom/media/webspeech/synth/test/nsFakeSynthServices.h"
#include "../../dom/payments/PaymentActionResponse.h"
#include "../../dom/quota/nsIndexedDBProtocolHandler.h"
#include "../../dom/webauthn/WebAuthnService.h"
#include "../../dom/webbrowserpersist/nsWebBrowserPersist.h"
#include "../../extensions/permissions/PermissionDelegateHandler.h"
#include "../../extensions/permissions/PermissionManager.h"
#include "../../extensions/pref/autoconfig/src/nsReadConfig.h"
#include "../../extensions/spellcheck/src/mozPersonalDictionary.h"
#include "../../gfx/src/nsThebesFontEnumerator.h"
#include "../../image/build/nsImageModule.h"
#include "../../image/decoders/icon/nsIconProtocolHandler.h"
#include "../../image/decoders/icon/nsIconURI.h"
#include "../../image/encoders/bmp/nsBMPEncoder.h"
#include "../../image/encoders/ico/nsICOEncoder.h"
#include "../../image/encoders/jpeg/nsJPEGEncoder.h"
#include "../../image/encoders/png/nsPNGEncoder.h"
#include "../../image/encoders/webp/nsWebPEncoder.h"
#include "../../image/imgTools.h"
#include "../../intl/strres/nsStringBundleService.h"
#include "../../intl/uconv/nsConverterOutputStream.h"
#include "../../intl/uconv/nsScriptableUConv.h"
#include "../../intl/uconv/nsTextToSubURI.h"
#include "../../js/xpconnect/loader/mozJSSubScriptLoader.h"
#include "../../layout/build/nsLayoutModule.h"
#include "../../layout/inspector/inDeepTreeWalker.h"
#include "../../modules/libjar/nsJAR.h"
#include "../../modules/libjar/nsJARProtocolHandler.h"
#include "../../modules/libjar/zipwriter/nsDeflateConverter.h"
#include "../../modules/libjar/zipwriter/nsZipWriter.h"
#include "../../netwerk/base/ArrayBufferInputStream.h"
#include "../../netwerk/base/BackgroundFileSaver.h"
#include "../../netwerk/base/DefaultURI.h"
#include "../../netwerk/base/MockNetworkLayerController.h"
#include "../../netwerk/base/TLSServerSocket.h"
#include "../../netwerk/base/ThrottleQueue.h"
#include "../../netwerk/base/nsAsyncStreamCopier.h"
#include "../../netwerk/base/nsBufferedStreams.h"
#include "../../netwerk/base/nsDownloader.h"
#include "../../netwerk/base/nsIOService.h"
#include "../../netwerk/base/nsIncrementalStreamLoader.h"
#include "../../netwerk/base/nsInputStreamChannel.h"
#include "../../netwerk/base/nsProtocolProxyService.h"
#include "../../netwerk/base/nsServerSocket.h"
#include "../../netwerk/base/nsSimpleStreamListener.h"
#include "../../netwerk/base/nsSocketTransportService2.h"
#include "../../netwerk/base/nsStandardURL.h"
#include "../../netwerk/base/nsStreamListenerTee.h"
#include "../../netwerk/base/nsStreamLoader.h"
#include "../../netwerk/base/nsStreamTransportService.h"
#include "../../netwerk/base/nsUDPSocket.h"
#include "../../netwerk/build/nsNetModule.h"
#include "../../netwerk/cookie/CookieService.h"
#include "../../netwerk/dns/GetAddrInfo.h"
#include "../../netwerk/dns/nsDNSService2.h"
#include "../../netwerk/dns/nsEffectiveTLDService.h"
#include "../../netwerk/dns/nsIDNService.h"
#include "../../netwerk/mime/nsMIMEHeaderParamImpl.h"
#include "../../netwerk/protocol/about/nsAboutBlank.h"
#include "../../netwerk/protocol/about/nsAboutCache.h"
#include "../../netwerk/protocol/about/nsAboutCacheEntry.h"
#include "../../netwerk/protocol/about/nsAboutProtocolHandler.h"
#include "../../netwerk/protocol/data/nsDataHandler.h"
#include "../../netwerk/protocol/http/ObliviousHttpService.h"
#include "../../netwerk/protocol/http/ReplacedHttpResponse.h"
#include "../../netwerk/protocol/http/binary_http/src/binary_http.h"
#include "../../netwerk/protocol/http/nsCORSListenerProxy.h"
#include "../../netwerk/protocol/http/nsHttpActivityDistributor.h"
#include "../../netwerk/protocol/http/nsHttpAuthCache.h"
#include "../../netwerk/protocol/http/nsHttpAuthManager.h"
#include "../../netwerk/protocol/http/oblivious_http/src/oblivious_http.h"
#include "../../netwerk/protocol/res/MozSrcProtocolHandler.h"
#include "../../netwerk/protocol/res/nsResProtocolHandler.h"
#include "../../netwerk/protocol/viewsource/nsViewSourceHandler.h"
#include "../../netwerk/streamconv/converters/nsIndexedToHTML.h"
#include "../../netwerk/system/linux/nsNetworkLinkService.h"
#include "../../netwerk/wifi/nsWifiMonitor.h"
#include "../../security/certverifier/CRLiteTimestamp.h"
#include "../../security/manager/pki/nsNSSDialogs.h"
#include "../../security/manager/ssl/DataStorageManager.h"
#include "../../security/manager/ssl/PublicKeyPinningService.h"
#include "../../security/manager/ssl/cert_storage/src/cert_storage.h"
#include "../../security/manager/ssl/crypto_hash/crypto_hash.h"
#include "../../security/manager/ssl/nsCertOverrideService.h"
#include "../../security/manager/ssl/nsNSSModule.h"
#include "../../security/manager/ssl/nsNSSVersion.h"
#include "../../security/manager/ssl/nsSiteSecurityService.h"
#include "../../storage/VacuumManager.h"
#include "../../storage/mozStorageService.h"
#include "../../toolkit/components/alerts/nsAlertsService.h"
#include "../../toolkit/components/antitracking/ContentBlockingAllowList.h"
#include "../../toolkit/components/antitracking/bouncetrackingprotection/BounceTrackingProtection.h"
#include "../../toolkit/components/autocomplete/nsAutoCompleteController.h"
#include "../../toolkit/components/autocomplete/nsAutoCompleteSimpleResult.h"
#include "../../toolkit/components/browser/nsWebBrowserContentPolicy.h"
#include "../../toolkit/components/build/nsToolkitCompsModule.h"
#include "../../toolkit/components/contentanalysis/ContentAnalysis.h"
#include "../../toolkit/components/cookiebanners/nsCookieBannerRule.h"
#include "../../toolkit/components/cookiebanners/nsCookieBannerService.h"
#include "../../toolkit/components/ctypes/ctypes.h"
#include "../../toolkit/components/downloads/DownloadPlatform.h"
#include "../../toolkit/components/find/nsFind.h"
#include "../../toolkit/components/find/nsFindService.h"
#include "../../toolkit/components/kvstore/nsKeyValueModule.h"
#include "../../toolkit/components/mozintl/MozIntlHelper.h"
#include "../../toolkit/components/parentalcontrols/nsParentalControlsService.h"
#include "../../toolkit/components/places/nsCachedFaviconProtocolHandler.h"
#include "../../toolkit/components/places/nsFaviconService.h"
#include "../../toolkit/components/places/nsNavBookmarks.h"
#include "../../toolkit/components/places/nsNavHistory.h"
#include "../../toolkit/components/reflect/reflect.h"
#include "../../toolkit/components/reputationservice/ApplicationReputation.h"
#include "../../toolkit/components/resistfingerprinting/nsRFPService.h"
#include "../../toolkit/components/resistfingerprinting/nsRFPTargetSetIDL.h"
#include "../../toolkit/components/satchel/nsFormFillController.h"
#include "../../toolkit/components/startup/nsAppStartup.h"
#include "../../toolkit/components/typeaheadfind/nsTypeAheadFind.h"
#include "../../toolkit/components/url-classifier/nsUrlClassifierStreamUpdater.h"
#include "../../toolkit/components/url-classifier/nsUrlClassifierTestUtils.h"
#include "../../toolkit/components/url-classifier/nsUrlClassifierUtils.h"
#include "../../toolkit/components/windowwatcher/nsDialogParamBlock.h"
#include "../../toolkit/profile/nsToolkitProfileService.h"
#include "../../toolkit/system/gnome/nsGIOService.h"
#include "../../toolkit/system/gnome/nsSystemAlertsService.h"
#include "../../toolkit/xre/nsXREDirProvider.h"
#include "../../tools/profiler/gecko/nsProfiler.h"
#include "../../uriloader/exthandler/nsDBusHandlerApp.h"
#include "../../uriloader/exthandler/nsExternalProtocolHandler.h"
#include "../../uriloader/exthandler/nsLocalHandlerApp.h"
#include "../../uriloader/prefetch/nsPrefetchService.h"
#include "../../widget/gtk/GfxInfo.h"
#include "../../widget/gtk/TaskbarProgress.h"
#include "../../widget/gtk/nsApplicationChooser.h"
#include "../../widget/gtk/nsColorPicker.h"
#include "../../widget/gtk/nsDeviceContextSpecG.h"
#include "../../widget/gtk/nsDragService.h"
#include "../../widget/gtk/nsFilePicker.h"
#include "../../widget/gtk/nsPrintDialogGTK.h"
#include "../../widget/gtk/nsPrintSettingsServiceGTK.h"
#include "../../widget/gtk/nsSound.h"
#include "../../widget/gtk/nsUserIdleServiceGTK.h"
#include "../../widget/gtk/nsWidgetFactory.h"
#include "../../widget/nsClipboardHelper.h"
#include "../../widget/nsClipboardProxy.h"
#include "../../widget/nsColorPickerProxy.h"
#include "../../widget/nsContentProcessWidgetFactory.h"
#include "../../widget/nsDragServiceProxy.h"
#include "../../widget/nsFilePickerProxy.h"
#include "../../widget/nsHTMLFormatConverter.h"
#include "../../widget/nsPrinterListCUPS.h"
#include "../../widget/nsTransferable.h"
#include "../../xpcom/base/AvailableMemoryWatcher.h"
#include "../../xpcom/base/nsConsoleService.h"
#include "../../xpcom/base/nsMemoryReporterManager.h"
#include "../../xpcom/base/nsSecurityConsoleMessage.h"
#include "../../xpcom/base/nsUUIDGenerator.h"
#include "../../xpcom/base/nsVersionComparatorImpl.h"
#include "../../xpcom/build/XPCOMModule.h"
#include "../../xpcom/components/nsCategoryManager.h"
#include "../../xpcom/components/nsComponentManager.h"
#include "../../xpcom/ds/nsINIParserImpl.h"
#include "../../xpcom/ds/nsObserverService.h"
#include "../../xpcom/io/nsBinaryStream.h"
#include "../../xpcom/io/nsIOUtil.h"
#include "../../xpcom/io/nsPipe.h"
#include "../../xpcom/io/nsScriptableBase64Encoder.h"
#include "../../xpcom/threads/nsEnvironment.h"
#include "../../xpcom/threads/nsTimerImpl.h"
#include "../../xpfe/appshell/nsAppShellService.h"
#include "../../xpfe/appshell/nsWindowMediator.h"

class ContentSignatureVerifier;
class OSKeyStore;
class OSReauthenticator;
class SecretDecoderRing;
class mozHunspell;
class mozISandboxReporter;
class mozISandboxSettings;
class nsCertTree;
class nsIAccessibilityService;
class nsIClipboard;
class nsIContentSerializer;
class nsIDocumentLoaderFactory;
class nsIDocumentViewer;
class nsIEventListenerService;
class nsIFocusManager;
class nsISessionStorageService;
class nsIStartupCacheInfo;
class nsISupports;
class nsITelemetry;
class nsNSSCertificateDB;
class nsPK11TokenDB;
class nsPrefLocalizedString;
class nsPrefOverrideMap;
class nsRandomGenerator;
class nsUnixSystemProxySettings;
namespace mozilla {
class PeerConnectionImpl;
namespace net {
class nsHttpHandler;
class nsHttpsHandler;
}  // namespace net
namespace psm {
class PKCS11ModuleDB;
class TransportSecurityInfo;
}  // namespace psm
}  // namespace mozilla

namespace mozilla {

using dom::AutoJSAPI;

namespace xpcom {

static constexpr uint32_t kNoContractID = 0xffffffff;

namespace {
// Template helpers for constructor function sanity checks.
template <typename T>
struct RemoveAlreadyAddRefed {
  using Type = T;
};

template <typename T>
struct RemoveAlreadyAddRefed<already_AddRefed<T>> {
  using Type = T;
};
}  // anonymous namespace


uint8_t gInvalidContracts[kContractCount / 8 + 1];

static StaticRefPtr<nsISupports> gServiceInstances[kStaticModuleCount];

uint8_t gInitCalled[kModuleInitCount / 8 + 1];

static const char gStrings[] =
    /* 0x0 */ "@mozilla.org/streamconv;1\0"
    /* 0x1a */ "?from=application/http-index-format&to=text/html\0"
    /* 0x4b */ "\0"
    /* 0x4c */ "?from=application/x-unknown-content-type&to=*/*\0"
    /* 0x7c */ "?from=br&to=uncompressed\0"
    /* 0x95 */ "?from=compress&to=uncompressed\0"
    /* 0xb4 */ "?from=deflate&to=uncompressed\0"
    /* 0xd2 */ "?from=gzip&to=uncompressed\0"
    /* 0xed */ "?from=multipart/byteranges&to=*/*\0"
    /* 0x10f */ "?from=multipart/mixed&to=*/*\0"
    /* 0x12c */ "?from=multipart/x-mixed-replace&to=*/*\0"
    /* 0x153 */ "?from=x-compress&to=uncompressed\0"
    /* 0x174 */ "?from=x-gzip&to=uncompressed\0"
    /* 0x191 */ "Gecko-Content-Viewers\0"
    /* 0x1a7 */ "application/http-index-format\0"
    /* 0x1c5 */ "@mozilla.org/content-viewers/http-index-format\0"
    /* 0x1f4 */ "application/mathml+xml\0"
    /* 0x20b */ "@mozilla.org/content/document-loader-factory;1\0"
    /* 0x23a */ "application/rdf+xml\0"
    /* 0x24e */ "application/vnd.wap.xhtml+xml\0"
    /* 0x26c */ "application/x-view-source\0"
    /* 0x286 */ "application/xhtml+xml\0"
    /* 0x29c */ "application/xml\0"
    /* 0x2ac */ "image/apng\0"
    /* 0x2b7 */ "image/avif\0"
    /* 0x2c2 */ "image/bmp\0"
    /* 0x2cc */ "image/gif\0"
    /* 0x2d6 */ "image/icon\0"
    /* 0x2e1 */ "image/jpeg\0"
    /* 0x2ec */ "image/jpg\0"
    /* 0x2f6 */ "image/pjpeg\0"
    /* 0x302 */ "image/png\0"
    /* 0x30c */ "image/svg+xml\0"
    /* 0x31a */ "image/vnd.microsoft.icon\0"
    /* 0x333 */ "image/webp\0"
    /* 0x33e */ "image/x-icon\0"
    /* 0x34b */ "image/x-ms-bmp\0"
    /* 0x35a */ "image/x-png\0"
    /* 0x366 */ "text/html\0"
    /* 0x370 */ "text/plain\0"
    /* 0x37b */ "text/rdf\0"
    /* 0x384 */ "text/vtt\0"
    /* 0x38d */ "text/xml\0"
    /* 0x396 */ "app-startup\0"
    /* 0x3a2 */ "ExtensionsChild\0"
    /* 0x3b2 */ "@mozilla.org/extensions/child;1\0"
    /* 0x3d2 */ "FormFillController\0"
    /* 0x3e5 */ "@mozilla.org/satchel/form-fill-controller;1\0"
    /* 0x411 */ "WebNavigationContent\0"
    /* 0x426 */ "@mozilla.org/extensions/web-navigation-content;1\0"
    /* 0x457 */ "startupRecorder\0"
    /* 0x467 */ "@mozilla.org/test/startuprecorder;1\0"
    /* 0x48b */ "command-line-handler\0"
    /* 0x4a0 */ "l-taskbar-tabs\0"
    /* 0x4af */ "@mozilla.org/browser/taskbar-tabs-clh;1\0"
    /* 0x4d7 */ "m-backgroundtasks\0"
    /* 0x4e9 */ "@mozilla.org/backgroundtasksmanager;1\0"
    /* 0x50f */ "m-browser\0"
    /* 0x519 */ "@mozilla.org/browser/clh;1\0"
    /* 0x534 */ "m-devtools\0"
    /* 0x53f */ "@mozilla.org/devtools/startup-clh;1\0"
    /* 0x563 */ "m-marionette\0"
    /* 0x570 */ "@mozilla.org/remote/marionette;1\0"
    /* 0x591 */ "m-remote\0"
    /* 0x59a */ "@mozilla.org/remote/agent;1\0"
    /* 0x5b6 */ "m-sps\0"
    /* 0x5bc */ "@mozilla.org/browser/selectable-profiles-service-clh;1\0"
    /* 0x5f3 */ "x-default\0"
    /* 0x5fd */ "@mozilla.org/browser/final-clh;1\0"
    /* 0x61e */ "y-default\0"
    /* 0x628 */ "@mozilla.org/toolkit/default-clh;1\0"
    /* 0x64b */ "command-line-validator\0"
    /* 0x662 */ "b-browser\0"
    /* 0x66c */ "content-policy\0"
    /* 0x67b */ "@mozilla.org/data-document-content-policy;1\0"
    /* 0x6a7 */ "@mozilla.org/embedding/browser/content-policy;1\0"
    /* 0x6d7 */ "@mozilla.org/image-blocker-content-policy;1\0"
    /* 0x703 */ "@mozilla.org/integritypolicyservice;1\0"
    /* 0x729 */ "@mozilla.org/mixedcontentblocker;1\0"
    /* 0x74c */ "@mozilla.org/no-data-protocol-content-policy;1\0"
    /* 0x77b */ "CSPService\0"
    /* 0x786 */ "@mozilla.org/cspservice;1\0"
    /* 0x7a0 */ "content-process-ready-for-script\0"
    /* 0x7c1 */ "TelemetryControllerContent\0"
    /* 0x7dc */ "@mozilla.org/base/telemetry-controller-content;1\0"
    /* 0x80d */ "content-sniffing-services\0"
    /* 0x827 */ "@mozilla.org/image/loader;1\0"
    /* 0x843 */ "@mozilla.org/image/cache;1\0"
    /* 0x85e */ "@mozilla.org/media/sniffer;1\0"
    /* 0x87b */ "idle-daily\0"
    /* 0x886 */ "BounceTrackingProtection\0"
    /* 0x89f */ "@mozilla.org/bounce-tracking-protection;1\0"
    /* 0x8c9 */ "ContentBlockingTelemetryService\0"
    /* 0x8e9 */ "@mozilla.org/content-blocking-telemetry-service;1\0"
    /* 0x91b */ "MozStorage Vacuum Manager\0"
    /* 0x935 */ "@mozilla.org/storage/vacuum;1\0"
    /* 0x953 */ "PlacesDBUtilsIdleMaintenance\0"
    /* 0x970 */ "@mozilla.org/places/databaseUtilsIdleMaintenance;1\0"
    /* 0x9a3 */ "QuotaManagerService\0"
    /* 0x9b7 */ "@mozilla.org/dom/quota-manager-service;1\0"
    /* 0x9e0 */ "UrlClassifierExceptionListService\0"
    /* 0xa02 */ "@mozilla.org/url-classifier/exception-list-service;1\0"
    /* 0xa37 */ "nsCookieBannerService\0"
    /* 0xa4d */ "@mozilla.org/cookie-banner-service;1\0"
    /* 0xa72 */ "net-and-orb-content-sniffers\0"
    /* 0xa8f */ "JSONView\0"
    /* 0xa98 */ "@mozilla.org/devtools/jsonview-sniffer;1\0"
    /* 0xac1 */ "net-channel-event-sinks\0"
    /* 0xad9 */ "net-content-sniffers\0"
    /* 0xaee */ "Binary Detector\0"
    /* 0xafe */ "@mozilla.org/network/binary-detector;1\0"
    /* 0xb25 */ "orb-content-sniffers\0"
    /* 0xb3a */ "payment-request\0"
    /* 0xb4a */ "BasicCardMethodChangeDetails\0"
    /* 0xb67 */ "@mozilla.org/dom/payments/basiccard-change-details;1\0"
    /* 0xb9c */ "BasicCardResponseData\0"
    /* 0xbb2 */ "@mozilla.org/dom/payments/basiccard-response-data;1\0"
    /* 0xbe6 */ "GeneralMethodChangeDetails\0"
    /* 0xc01 */ "@mozilla.org/dom/payments/general-change-details;1\0"
    /* 0xc34 */ "GeneralResponseData\0"
    /* 0xc48 */ "@mozilla.org/dom/payments/general-response-data;1\0"
    /* 0xc7a */ "PaymentAbortActionResponse\0"
    /* 0xc95 */ "@mozilla.org/dom/payments/payment-abort-action-response;1\0"
    /* 0xccf */ "PaymentAddress\0"
    /* 0xcde */ "@mozilla.org/dom/payments/payment-address;1\0"
    /* 0xd0a */ "PaymentCanMakeActionResponse\0"
    /* 0xd27 */ "@mozilla.org/dom/payments/payment-canmake-action-response;1\0"
    /* 0xd63 */ "PaymentCompleteActionResponse\0"
    /* 0xd81 */ "@mozilla.org/dom/payments/payment-complete-action-response;1\0"
    /* 0xdbe */ "PaymentRequestService\0"
    /* 0xdd4 */ "@mozilla.org/dom/payments/payment-request-service;1\0"
    /* 0xe08 */ "PaymentShowActionResponse\0"
    /* 0xe22 */ "@mozilla.org/dom/payments/payment-show-action-response;1\0"
    /* 0xe5b */ "places-init-complete\0"
    /* 0xe70 */ "PlacesFrecencyRecalculator\0"
    /* 0xe8b */ "@mozilla.org/places/frecency-recalculator;1\0"
    /* 0xeb7 */ "nsPlacesExpiration\0"
    /* 0xeca */ "@mozilla.org/places/expiration;1\0"
    /* 0xeeb */ "pref-config-startup\0"
    /* 0xeff */ "ReadConfig Module\0"
    /* 0xf11 */ "@mozilla.org/readconfig;1\0"
    /* 0xf2b */ "profile-after-change\0"
    /* 0xf40 */ "CrashMonitor\0"
    /* 0xf4d */ "@mozilla.org/toolkit/crashmonitor;1\0"
    /* 0xf71 */ "CrashService\0"
    /* 0xf7e */ "@mozilla.org/crashservice;1\0"
    /* 0xf9a */ "EssentialDomainsRemoteSettings\0"
    /* 0xfb9 */ "@mozilla.org/EssentialDomainsRemoteSettings;1\0"
    /* 0xfe7 */ "Marionette\0"
    /* 0xff2 */ "PurgeTrackerService\0"
    /* 0x1006 */ "@mozilla.org/purge-tracker-service;1\0"
    /* 0x102b */ "RemoteAgent\0"
    /* 0x1037 */ "RemotePermissionService\0"
    /* 0x104f */ "@mozilla.org/remote-permission-service;1\0"
    /* 0x1078 */ "SimpleURIUnknownSchemesRemoteObserver\0"
    /* 0x109e */ "@mozilla.org/SimpleURIUnknownSchemesRemoteObserver;1\0"
    /* 0x10d3 */ "URLQueryStringStripper\0"
    /* 0x10ea */ "@mozilla.org/url-query-string-stripper;1\0"
    /* 0x1113 */ "formHistoryStartup\0"
    /* 0x1126 */ "@mozilla.org/satchel/form-history-startup;1\0"
    /* 0x1152 */ "nsRFPService\0"
    /* 0x115f */ "@mozilla.org/rfp-service;1\0"
    /* 0x117a */ "nsUpdateTimerManager\0"
    /* 0x118f */ "@mozilla.org/updates/timer-manager;1\0"
    /* 0x11b4 */ "service,@mozilla.org/profile-after-change-gate;1\0"
    /* 0x11e5 */ "@mozilla.org/profile-after-change-gate;1\0"
    /* 0x120e */ "push\0"
    /* 0x1213 */ "chrome://fxa-device-update\0"
    /* 0x122e */ "@mozilla.org/fxaccounts/push;1\0"
    /* 0x124d */ "speech-synth-started\0"
    /* 0x1262 */ "Fake Speech Synth\0"
    /* 0x1274 */ "@mozilla.org/fakesynth;1\0"
    /* 0x128d */ "SpeechDispatcher Speech Synth\0"
    /* 0x12ab */ "@mozilla.org/synthspeechdispatcher;1\0"
    /* 0x12d0 */ "vacuum-participant\0"
    /* 0x12e3 */ "Places\0"
    /* 0x12ea */ "@mozilla.org/browser/nav-history-service;1\0"
    /* 0x1315 */ "xpcom-startup\0"
    /* 0x1323 */ "Fork Server Launcher\0"
    /* 0x1338 */ "@mozilla.org/fork-server-launcher;1\0"
    /* 0x135c */ "nsGIOProtocolHandler\0"
    /* 0x1371 */ "@mozilla.org/network/protocol;1?name=moz-gio\0"
    /* 0x139e */ "chrome://remote/content/components/Marionette.sys.mjs\0"
    /* 0x13d4 */ "chrome://remote/content/components/RemoteAgent.sys.mjs\0"
    /* 0x140b */ "moz-src:///browser/components/mozcachedohttp/MozCachedOHTTPProtocolHandler.sys.mjs\0"
    /* 0x145e */ "moz-src:///browser/components/permissions/ContentPermissionPrompt.sys.mjs\0"
    /* 0x14a8 */ "moz-src:///dom/notification/NotificationStorage.sys.mjs\0"
    /* 0x14e0 */ "resource:///modules/AboutDebuggingRegistration.sys.mjs\0"
    /* 0x1517 */ "resource:///modules/AboutDevToolsToolboxRegistration.sys.mjs\0"
    /* 0x1554 */ "resource:///modules/AboutNewTabRedirector.sys.mjs\0"
    /* 0x1586 */ "resource:///modules/BrowserContentHandler.sys.mjs\0"
    /* 0x15b8 */ "resource:///modules/BrowserGlue.sys.mjs\0"
    /* 0x15e0 */ "resource:///modules/DevToolsStartup.sys.mjs\0"
    /* 0x160c */ "resource:///modules/ProfileMigrator.sys.mjs\0"
    /* 0x1638 */ "resource:///modules/PromptCollection.sys.mjs\0"
    /* 0x1665 */ "resource:///modules/StartupRecorder.sys.mjs\0"
    /* 0x1691 */ "resource:///modules/WebProtocolHandlerRegistrar.sys.mjs\0"
    /* 0x16c9 */ "resource:///modules/profiles/SelectableProfileService.sys.mjs\0"
    /* 0x1707 */ "resource:///modules/sessionstore/SessionStoreFunctions.sys.mjs\0"
    /* 0x1746 */ "resource:///modules/taskbartabs/TaskbarTabsCmd.sys.mjs\0"
    /* 0x177d */ "resource://devtools/client/jsonview/Converter.sys.mjs\0"
    /* 0x17b3 */ "resource://devtools/client/jsonview/Sniffer.sys.mjs\0"
    /* 0x17e7 */ "resource://gre/modules/AutoCompleteSimpleSearch.sys.mjs\0"
    /* 0x181f */ "resource://gre/modules/BTPRemoteExceptionList.sys.mjs\0"
    /* 0x1855 */ "resource://gre/modules/BackgroundTasksManager.sys.mjs\0"
    /* 0x188b */ "resource://gre/modules/CaptiveDetect.sys.mjs\0"
    /* 0x18b8 */ "resource://gre/modules/ClearBySiteEntry.sys.mjs\0"
    /* 0x18e8 */ "resource://gre/modules/ClearDataService.sys.mjs\0"
    /* 0x1918 */ "resource://gre/modules/ConsoleAPIStorage.sys.mjs\0"
    /* 0x1949 */ "resource://gre/modules/ContentAreaDropListener.sys.mjs\0"
    /* 0x1980 */ "resource://gre/modules/ContentDispatchChooser.sys.mjs\0"
    /* 0x19b6 */ "resource://gre/modules/ContentPrefService2.sys.mjs\0"
    /* 0x19e9 */ "resource://gre/modules/CookieBannerListService.sys.mjs\0"
    /* 0x1a20 */ "resource://gre/modules/CrashManager.sys.mjs\0"
    /* 0x1a4c */ "resource://gre/modules/CrashService.sys.mjs\0"
    /* 0x1a78 */ "resource://gre/modules/CredentialChooserService.sys.mjs\0"
    /* 0x1ab0 */ "resource://gre/modules/DefaultCLH.sys.mjs\0"
    /* 0x1ada */ "resource://gre/modules/DownloadLegacy.sys.mjs\0"
    /* 0x1b08 */ "resource://gre/modules/EnterprisePolicies.sys.mjs\0"
    /* 0x1b3a */ "resource://gre/modules/EssentialDomainsRemoteSettings.sys.mjs\0"
    /* 0x1b78 */ "resource://gre/modules/ExtHandlerService.sys.mjs\0"
    /* 0x1ba9 */ "resource://gre/modules/FingerprintingWebCompatService.sys.mjs\0"
    /* 0x1be7 */ "resource://gre/modules/FormHistoryAutoComplete.sys.mjs\0"
    /* 0x1c1e */ "resource://gre/modules/FormHistoryStartup.sys.mjs\0"
    /* 0x1c50 */ "resource://gre/modules/FxAccountsPush.sys.mjs\0"
    /* 0x1c7e */ "resource://gre/modules/HelperAppDlg.sys.mjs\0"
    /* 0x1caa */ "resource://gre/modules/IdentityCredentialPromptService.sys.mjs\0"
    /* 0x1ce9 */ "resource://gre/modules/LoginAutoComplete.sys.mjs\0"
    /* 0x1d1a */ "resource://gre/modules/LoginInfo.sys.mjs\0"
    /* 0x1d43 */ "resource://gre/modules/LoginManager.sys.mjs\0"
    /* 0x1d6f */ "resource://gre/modules/LoginManagerAuthPrompter.sys.mjs\0"
    /* 0x1da7 */ "resource://gre/modules/LoginManagerPrompter.sys.mjs\0"
    /* 0x1ddb */ "resource://gre/modules/MainProcessSingleton.sys.mjs\0"
    /* 0x1e0f */ "resource://gre/modules/MozProtocolHandler.sys.mjs\0"
    /* 0x1e41 */ "resource://gre/modules/NetworkErrorLogging.sys.mjs\0"
    /* 0x1e74 */ "resource://gre/modules/NetworkGeolocationProvider.sys.mjs\0"
    /* 0x1eae */ "resource://gre/modules/PageThumbsStorageService.sys.mjs\0"
    /* 0x1ee6 */ "resource://gre/modules/PartitioningExceptionListService.sys.mjs\0"
    /* 0x1f26 */ "resource://gre/modules/PlacesDBUtils.sys.mjs\0"
    /* 0x1f53 */ "resource://gre/modules/PlacesExpiration.sys.mjs\0"
    /* 0x1f83 */ "resource://gre/modules/PlacesFrecencyRecalculator.sys.mjs\0"
    /* 0x1fbd */ "resource://gre/modules/PlacesPreviews.sys.mjs\0"
    /* 0x1feb */ "resource://gre/modules/PrivateAttributionService.sys.mjs\0"
    /* 0x2024 */ "resource://gre/modules/ProcessSelector.sys.mjs\0"
    /* 0x2053 */ "resource://gre/modules/Prompter.sys.mjs\0"
    /* 0x207b */ "resource://gre/modules/PurgeTrackerService.sys.mjs\0"
    /* 0x20ae */ "resource://gre/modules/Push.sys.mjs\0"
    /* 0x20d2 */ "resource://gre/modules/PushComponents.sys.mjs\0"
    /* 0x2100 */ "resource://gre/modules/QuotaUtilsService.sys.mjs\0"
    /* 0x2131 */ "resource://gre/modules/RemotePermissionService.sys.mjs\0"
    /* 0x2168 */ "resource://gre/modules/SearchService.sys.mjs\0"
    /* 0x2195 */ "resource://gre/modules/SearchSuggestions.sys.mjs\0"
    /* 0x21c6 */ "resource://gre/modules/ShieldContentProcess.sys.mjs\0"
    /* 0x21fa */ "resource://gre/modules/SimpleServices.sys.mjs\0"
    /* 0x2228 */ "resource://gre/modules/SimpleURIUnknownSchemesRemoteObserver.sys.mjs\0"
    /* 0x226d */ "resource://gre/modules/SlowScriptDebug.sys.mjs\0"
    /* 0x229c */ "resource://gre/modules/TaggingService.sys.mjs\0"
    /* 0x22ca */ "resource://gre/modules/TelemetryControllerContent.sys.mjs\0"
    /* 0x2304 */ "resource://gre/modules/TelemetryStartup.sys.mjs\0"
    /* 0x2334 */ "resource://gre/modules/ThirdPartyCookieBlockingExceptionListService.sys.mjs\0"
    /* 0x2380 */ "resource://gre/modules/TooltipTextProvider.sys.mjs\0"
    /* 0x23b3 */ "resource://gre/modules/TrackingDBService.sys.mjs\0"
    /* 0x23e4 */ "resource://gre/modules/URIFixup.sys.mjs\0"
    /* 0x240c */ "resource://gre/modules/URLDecorationAnnotationsService.sys.mjs\0"
    /* 0x244b */ "resource://gre/modules/URLFormatter.sys.mjs\0"
    /* 0x2477 */ "resource://gre/modules/URLQueryStrippingListService.sys.mjs\0"
    /* 0x24b3 */ "resource://gre/modules/UpdateTimerManager.sys.mjs\0"
    /* 0x24e5 */ "resource://gre/modules/UrlClassifierExceptionListService.sys.mjs\0"
    /* 0x2526 */ "resource://gre/modules/UrlClassifierHashCompleter.sys.mjs\0"
    /* 0x2560 */ "resource://gre/modules/UrlClassifierLib.sys.mjs\0"
    /* 0x2590 */ "resource://gre/modules/UrlClassifierListManager.sys.mjs\0"
    /* 0x25c8 */ "resource://gre/modules/UrlClassifierRemoteSettingsService.sys.mjs\0"
    /* 0x260a */ "resource://gre/modules/UserCharacteristicsPageService.sys.mjs\0"
    /* 0x2648 */ "resource://gre/modules/WebHandlerApp.sys.mjs\0"
    /* 0x2675 */ "resource://gre/modules/WebVTTParserWrapper.sys.mjs\0"
    /* 0x26a8 */ "resource://gre/modules/WellKnownOpportunisticUtils.sys.mjs\0"
    /* 0x26e3 */ "resource://gre/modules/WindowsMediaFoundationCDMOriginsListService.sys.mjs\0"
    /* 0x272e */ "resource://gre/modules/XULStore.sys.mjs\0"
    /* 0x2756 */ "resource://gre/modules/amContentHandler.sys.mjs\0"
    /* 0x2786 */ "resource://gre/modules/amManager.sys.mjs\0"
    /* 0x27af */ "resource://gre/modules/amWebAPI.sys.mjs\0"
    /* 0x27d7 */ "resource://gre/modules/crypto-SDR.sys.mjs\0"
    /* 0x2801 */ "resource://gre/modules/media/PeerConnection.sys.mjs\0"
    /* 0x2835 */ "resource://gre/modules/mozIntl.sys.mjs\0"
    /* 0x285c */ "resource://gre/modules/nsAsyncShutdown.sys.mjs\0"
    /* 0x288b */ "resource://gre/modules/nsCrashMonitor.sys.mjs\0"
    /* 0x28b9 */ "resource://gre/modules/pdfjs.sys.mjs\0"
    /* 0x28de */ "resource://gre/modules/psm/ClientAuthDialogService.sys.mjs\0"
    /* 0x2919 */ "resource://services-settings/RemoteSettingsComponents.sys.mjs\0"
    /* 0x2957 */ "resource://services-sync/Weave.sys.mjs\0"
    /* 0x297e */ "resource://webcompat/AboutCompat.sys.mjs\0"
    /* 0x29a7 */ "@mozilla.org/xre/app-info;1\0"
    /* 0x29c3 */ "@mozilla.org/contentanalysis;1\0"
    /* 0x29e2 */ "@mozilla.org/alerts-service;1\0"
    /* 0x2a00 */ "@mozilla.org/system-info;1\0"
    /* 0x2a1b */ "@mozilla.org/embedcomp/window-watcher;1\0"
    /* 0x2a43 */ "@mozilla.org/widget/clipboard;1\0"
    /* 0x2a63 */ "@mozilla.org/network/protocol/about;1?what=support\0"
    /* 0x2a96 */ "@mozilla.org/services/settings;1\0"
    /* 0x2ab7 */ "@mozilla.org/network/protocol/about;1?what=logging\0"
    /* 0x2aea */ "@mozilla.org/gio-service;1\0"
    /* 0x2b05 */ "@mozilla.org/xul/xulstore;1\0"
    /* 0x2b21 */ "@mozilla.org/browser/identity-credential-storage-service;1\0"
    /* 0x2b5c */ "@mozilla.org/network/incremental-stream-loader;1\0"
    /* 0x2b8d */ "@mozilla.org/network/protocol/about;1?what=asrouter\0"
    /* 0x2bc1 */ "@mozilla.org/network/incremental-download;1\0"
    /* 0x2bed */ "@mozilla.org/nss_errors_service;1\0"
    /* 0x2c0f */ "@mozilla.org/weave/service;1\0"
    /* 0x2c2c */ "@mozilla.org/network/protocol/about;1?what=unloads\0"
    /* 0x2c5f */ "@mozilla.org/filepicker;1\0"
    /* 0x2c79 */ "@mozilla.org/libjar/zip-reader;1\0"
    /* 0x2c9a */ "@mozilla.org/scriptable-content-iterator;1\0"
    /* 0x2cc5 */ "@mozilla.org/uriloader/web-handler-app;1\0"
    /* 0x2cee */ "@mozilla.org/securityconsole/message;1\0"
    /* 0x2d15 */ "@mozilla.org/webspeech/service;1?name=online\0"
    /* 0x2d42 */ "@mozilla.org/uriloader/content-handler;1?type=text/html\0"
    /* 0x2d7a */ "@mozilla.org/streamConverters;1\0"
    /* 0x2d9a */ "@mozilla.org/dom/sdb-connection;1\0"
    /* 0x2dbc */ "@mozilla.org/network/replaced-http-response;1\0"
    /* 0x2dea */ "@mozilla.org/jsdebugger;1\0"
    /* 0x2e04 */ "@mozilla.org/scriptableinputstream;1\0"
    /* 0x2e29 */ "@mozilla.org/dom/rtcdtmfsender;1\0"
    /* 0x2e4a */ "@mozilla.org/network/background-file-saver;1?mode=streamlistener\0"
    /* 0x2e8b */ "@mozilla.org/base/daptelemetry;1\0"
    /* 0x2eac */ "@mozilla.org/network/oblivious-http-service;1\0"
    /* 0x2eda */ "@mozilla.org/network/well-known-opportunistic-utils;1\0"
    /* 0x2f10 */ "@mozilla.org/network/protocol/about;1?what=glean\0"
    /* 0x2f41 */ "@mozilla.org/dom/slow-script-debug;1\0"
    /* 0x2f66 */ "@mozilla.org/io/string-input-stream;1\0"
    /* 0x2f8c */ "@mozilla.org/url-classifier/jslib;1\0"
    /* 0x2fb0 */ "@mozilla.org/network/protocol;1?name=javascript\0"
    /* 0x2fe0 */ "@mozilla.org/categorymanager;1\0"
    /* 0x2fff */ "@mozilla.org/parent/colorpicker;1\0"
    /* 0x3021 */ "@mozilla.org/embedcomp/prompt-collection;1\0"
    /* 0x304c */ "@mozilla.org/network/protocol/about;1?what=debugging\0"
    /* 0x3081 */ "@mozilla.org/url-classifier/exception-list-entry;1\0"
    /* 0x30b4 */ "@mozilla.org/dom/workers/workerdebuggermanager;1\0"
    /* 0x30e5 */ "@mozilla.org/clear-data-service;1\0"
    /* 0x3107 */ "@mozilla.org/security/oskeystore;1\0"
    /* 0x312a */ "@mozilla.org/autocomplete/search;1?name=form-fill-controller\0"
    /* 0x3167 */ "@mozilla.org/streamconv;1?from=application/x-unknown-content-type&to=*/*\0"
    /* 0x31b0 */ "@mozilla.org/network/url-parser;1?auth=yes\0"
    /* 0x31db */ "@mozilla.org/network/captive-portal-service;1\0"
    /* 0x3209 */ "@mozilla.org/applicationchooser;1\0"
    /* 0x322b */ "@mozilla.org/geolocation/mls-provider;1\0"
    /* 0x3253 */ "@mozilla.org/network/protocol/about;1?what=welcome\0"
    /* 0x3286 */ "@mozilla.org/autocomplete/search;1?name=login-doorhanger-password\0"
    /* 0x32c8 */ "@mozilla.org/network/protocol;1?name=default\0"
    /* 0x32f5 */ "@mozilla.org/dom/peerconnection;1\0"
    /* 0x3317 */ "@mozilla.org/toolkit/sessionstore-functions;1\0"
    /* 0x3345 */ "@mozilla.org/webspeech/service;1?name=fake\0"
    /* 0x3370 */ "@mozilla.org/intl/texttosuburi;1\0"
    /* 0x3391 */ "@mozilla.org/network/protocol;1?name=cached-favicon\0"
    /* 0x33c5 */ "@mozilla.org/passwordmanager/authpromptfactory;1\0"
    /* 0x33f6 */ "@mozilla.org/contentsecuritymanager;1\0"
    /* 0x341c */ "@mozilla.org/sandbox/syscall-reporter;1\0"
    /* 0x3444 */ "@mozilla.org/security/hash;1\0"
    /* 0x3461 */ "@mozilla.org/network/protocol/about;1?what=downloads\0"
    /* 0x3496 */ "@mozilla.org/supports-PRUint8;1\0"
    /* 0x34b6 */ "@mozilla.org/url-classifier/list-service;1\0"
    /* 0x34e1 */ "@mozilla.org/widget/htmlformatconverter;1\0"
    /* 0x350b */ "@mozilla.org/supports-float;1\0"
    /* 0x3529 */ "@mozilla.org/binaryinputstream;1\0"
    /* 0x354a */ "@mozilla.org/network/protocol/about;1?what=home\0"
    /* 0x357a */ "@mozilla.org/network/protocol/about;1?what=url-classifier\0"
    /* 0x35b4 */ "@mozilla.org/network/protocol;1?name=jar\0"
    /* 0x35dd */ "@mozilla.org/network/protocol/about;1?what=protections\0"
    /* 0x3614 */ "@mozilla.org/intl/converter-output-stream;1\0"
    /* 0x3640 */ "@mozilla.org/uriloader;1\0"
    /* 0x3659 */ "@mozilla.org/prompter;1\0"
    /* 0x3671 */ "@mozilla.org/docshell/uri-fixup-info;1\0"
    /* 0x3698 */ "@mozilla.org/security/nsCertTree;1\0"
    /* 0x36bb */ "@mozilla.org/image/request;1\0"
    /* 0x36d8 */ "@mozilla.org/widget/printdialog-service;1\0"
    /* 0x3702 */ "@mozilla.org/content/colorpicker;1\0"
    /* 0x3725 */ "@mozilla.org/reputationservice/application-reputation-service;1\0"
    /* 0x3765 */ "@mozilla.org/network/input-stream-channel;1\0"
    /* 0x3791 */ "@mozilla.org/policycontainer;1\0"
    /* 0x37b0 */ "@mozilla.org/toolkit/crash-reporter;1\0"
    /* 0x37d6 */ "@mozilla.org/xpcom/debug;1\0"
    /* 0x37f1 */ "@mozilla.org/security/certstorage;1\0"
    /* 0x3815 */ "@mozilla.org/query-stripping-list-service;1\0"
    /* 0x3841 */ "@mozilla.org/cookieService;1\0"
    /* 0x385e */ "@mozilla.org/network/dns-service;1\0"
    /* 0x3881 */ "@mozilla.org/cascade-filter;1\0"
    /* 0x389f */ "@mozilla.org/image/encoder;2?type=image/bmp\0"
    /* 0x38cb */ "@mozilla.org/network/protocol;1?name=moz\0"
    /* 0x38f4 */ "@mozilla.org/mozintl;1\0"
    /* 0x390b */ "@mozilla.org/streamconv;1?from=application/octet-stream&to=text/html\0"
    /* 0x3950 */ "@mozilla.org/gfx/printsettings-service;1\0"
    /* 0x3979 */ "@mozilla.org/image/encoder;2?type=image/vnd.microsoft.icon\0"
    /* 0x39b4 */ "@mozilla.org/widget/clipboardhelper;1\0"
    /* 0x39da */ "@mozilla.org/content-dispatch-chooser;1\0"
    /* 0x3a02 */ "@mozilla.org/spellchecker/engine;1\0"
    /* 0x3a25 */ "@mozilla.org/streamconv;1?from=application/pdf&to=*/*\0"
    /* 0x3a5b */ "@mozilla.org/network/protocol;1?name=moz-safe-about\0"
    /* 0x3a8f */ "@mozilla.org/network/default-uri-mutator;1\0"
    /* 0x3aba */ "@mozilla.org/consoleAPI-storage;1\0"
    /* 0x3adc */ "@mozilla.org/gfx/printerlist;1\0"
    /* 0x3afb */ "@mozilla.org/layout/contentserializer;1?mimetype=text/plain\0"
    /* 0x3b37 */ "@mozilla.org/thirdpartyutil;1\0"
    /* 0x3b55 */ "@mozilla.org/permissiondelegatehandler;1\0"
    /* 0x3b7e */ "@mozilla.org/addons/policy-service;1\0"
    /* 0x3ba3 */ "@mozilla.org/security/certoverride;1\0"
    /* 0x3bc8 */ "@mozilla.org/dom/peerconnectionobserver;1\0"
    /* 0x3bf2 */ "@mozilla.org/binaryoutputstream;1\0"
    /* 0x3c14 */ "@mozilla.org/systemprincipal;1\0"
    /* 0x3c33 */ "@mozilla.org/network/url-parser;1?auth=maybe\0"
    /* 0x3c60 */ "@mozilla.org/streamconv;1?from=application/vnd.mozilla.json.view&to=*/*\0"
    /* 0x3ca8 */ "@mozilla.org/intl/ospreferences;1\0"
    /* 0x3cca */ "@mozilla.org/hash-property-bag;1\0"
    /* 0x3ceb */ "@mozilla.org/url-classifier/prefixset;1\0"
    /* 0x3d13 */ "@mozilla.org/cookieJarSettings;1\0"
    /* 0x3d34 */ "@mozilla.org/extensions/blocklist;1\0"
    /* 0x3d58 */ "@mozilla.org/intl/localeservice;1\0"
    /* 0x3d7a */ "@mozilla.org/network/atomic-file-output-stream;1\0"
    /* 0x3dab */ "@mozilla.org/xpcom/version-comparator;1\0"
    /* 0x3dd3 */ "@mozilla.org/memory-info-dumper;1\0"
    /* 0x3df5 */ "@mozilla.org/childprocessmessagemanager;1\0"
    /* 0x3e1f */ "@mozilla.org/network/simple-stream-listener;1\0"
    /* 0x3e4d */ "@mozilla.org/network/protocol/about;1?what=certerror\0"
    /* 0x3e82 */ "@mozilla.org/url-classifier/channel-classifier-service;1\0"
    /* 0x3ebb */ "@mozilla.org/login-manager/prompter;1\0"
    /* 0x3ee1 */ "@mozilla.org/embedding/browser/nsWebBrowserPersist;1\0"
    /* 0x3f16 */ "@mozilla.org/url-classifier/dbservice;1\0"
    /* 0x3f3e */ "@mozilla.org/security/random-generator;1\0"
    /* 0x3f67 */ "@mozilla.org/places/previews-helper;1\0"
    /* 0x3f8d */ "@mozilla.org/login-manager/loginInfo;1\0"
    /* 0x3fb4 */ "@mozilla.org/network/protocol/about;1?what=compat\0"
    /* 0x3fe6 */ "@mozilla.org/network/protocol;1?name=resource\0"
    /* 0x4014 */ "@mozilla.org/network/mime-hdrparam;1\0"
    /* 0x4039 */ "@mozilla.org/streamconv;1?from=br&to=uncompressed\0"
    /* 0x406b */ "@mozilla.org/parental-controls-service;1\0"
    /* 0x4094 */ "@mozilla.org/network/oblivious-http;1\0"
    /* 0x40ba */ "@mozilla.org/mozintlhelper;1\0"
    /* 0x40d7 */ "@mozilla.org/gfx/content/screenmanager;1\0"
    /* 0x4100 */ "@mozilla.org/dom/indexeddb/manager;1\0"
    /* 0x4125 */ "@mozilla.org/scriptablebase64encoder;1\0"
    /* 0x414c */ "@mozilla.org/network-error-logging;1\0"
    /* 0x4171 */ "@mozilla.org/colorpicker;1\0"
    /* 0x418c */ "@mozilla.org/uuid-generator;1\0"
    /* 0x41aa */ "@mozilla.org/network/protocol/about;1?what=logins\0"
    /* 0x41dc */ "@mozilla.org/storagestream;1\0"
    /* 0x41f9 */ "@mozilla.org/network/util;1\0"
    /* 0x4215 */ "@mozilla.org/process/util;1\0"
    /* 0x4231 */ "@mozilla.org/network/tcp-filter-handler;1?name=stun\0"
    /* 0x4265 */ "@mozilla.org/addon-web-api/manager;1\0"
    /* 0x428a */ "@mozilla.org/autocomplete/simple-result;1\0"
    /* 0x42b4 */ "@mozilla.org/url-classifier/test-utils;1\0"
    /* 0x42dd */ "@mozilla.org/toolkit/profile-service;1\0"
    /* 0x4304 */ "@mozilla.org/netwerk/cache-storage-service;1\0"
    /* 0x4331 */ "@mozilla.org/toolkit/download-platform;1\0"
    /* 0x435a */ "@mozilla.org/streamconv;1?from=multipart/x-mixed-replace&to=*/*\0"
    /* 0x439a */ "@mozilla.org/mediaManagerService;1\0"
    /* 0x43bd */ "@mozilla.org/appshell/appShellService;1\0"
    /* 0x43e5 */ "@mozilla.org/network/protocol/about;1?what=framecrashed\0"
    /* 0x441d */ "@mozilla.org/prefetch-service;1\0"
    /* 0x443d */ "@mozilla.org/network/protocol/about;1?what=crashparent\0"
    /* 0x4474 */ "@mozilla.org/uriloader/handler-service;1\0"
    /* 0x449d */ "@mozilla.org/network/network-link-service;1\0"
    /* 0x44c9 */ "@mozilla.org/network/cache-storage-service;1\0"
    /* 0x44f6 */ "@mozilla.org/dom/session-storage-service;1\0"
    /* 0x4521 */ "@mozilla.org/alert-notification;1\0"
    /* 0x4543 */ "@mozilla.org/url-classifier/utils;1\0"
    /* 0x4567 */ "@mozilla.org/network/load-group;1\0"
    /* 0x4589 */ "@mozilla.org/dom/peerconnectionmanager;1\0"
    /* 0x45b2 */ "@mozilla.org/network/protocol/about;1?what=blocked\0"
    /* 0x45e5 */ "@mozilla.org/nsCertificateDialogs;1\0"
    /* 0x4609 */ "@mozilla.org/appshell/component/browser-status-filter;1\0"
    /* 0x4641 */ "@mozilla.org/network/protocol/about;1?what=policies\0"
    /* 0x4675 */ "@mozilla.org/widget/parent/clipboard;1\0"
    /* 0x469c */ "@mozilla.org/http-sfv-service;1\0"
    /* 0x46bc */ "@mozilla.org/parserutils;1\0"
    /* 0x46d7 */ "@mozilla.org/gfx/fontenumerator;1\0"
    /* 0x46f9 */ "@mozilla.org/network/protocol/about;1?what=aichatcontent\0"
    /* 0x4732 */ "@mozilla.org/network/protocol/about;1?what=webrtc\0"
    /* 0x4764 */ "@mozilla.org/network/protocol/about;1?what=devtools-toolbox\0"
    /* 0x47a0 */ "@mozilla.org/security/ClientAuthDialogService;1\0"
    /* 0x47d0 */ "@mozilla.org/dom/rtcsessiondescription;1\0"
    /* 0x47f9 */ "@mozilla.org/uriloader/content-handler;1?type=image/bmp\0"
    /* 0x4831 */ "@mozilla.org/xpcom/ini-parser-factory;1\0"
    /* 0x4859 */ "@mozilla.org/url-classifier/exception-list;1\0"
    /* 0x4886 */ "@mozilla.org/network/protocol/about;1?what=crashes\0"
    /* 0x48b9 */ "@mozilla.org/network/protocol/about;1?what=performance\0"
    /* 0x48f0 */ "@mozilla.org/network/protocol/about;1?what=memory\0"
    /* 0x4922 */ "@mozilla.org/browser/browserglue;1\0"
    /* 0x4945 */ "@mozilla.org/network/protocol;1?name=indexeddb\0"
    /* 0x4974 */ "@mozilla.org/net/CachePurgeLock;1\0"
    /* 0x4996 */ "@mozilla.org/satchel/form-history-autocomplete;1\0"
    /* 0x49c7 */ "@mozilla.org/network/protocol/about;1?what=certificate\0"
    /* 0x49fe */ "@mozilla.org/array;1\0"
    /* 0x4a13 */ "@mozilla.org/uriloader/content-handler;1?type=image/x-icon\0"
    /* 0x4a4e */ "@mozilla.org/sandbox/sandbox-settings;1\0"
    /* 0x4a76 */ "@mozilla.org/system-proxy-settings;1\0"
    /* 0x4a9b */ "@mozilla.org/autocomplete/search;1?name=login-doorhanger-username\0"
    /* 0x4add */ "@mozilla.org/uriloader/content-handler;1?type=text/xml\0"
    /* 0x4b14 */ "@mozilla.org/network/protocol/about;1?what=studies\0"
    /* 0x4b47 */ "@mozilla.org/network/http-auth-cache;1\0"
    /* 0x4b6e */ "@mozilla.org/network/http-activity-distributor;1\0"
    /* 0x4b9f */ "@mozilla.org/network/protocol;1?name=file\0"
    /* 0x4bc9 */ "@mozilla.org/network/cors-preflight-cache;1\0"
    /* 0x4bf5 */ "@mozilla.org/base/telemetry;1\0"
    /* 0x4c13 */ "@mozilla.org/dom/rtcicecandidate;1\0"
    /* 0x4c36 */ "@mozilla.org/ospermissionrequest;1\0"
    /* 0x4c59 */ "@mozilla.org/btp-remote-exception-list;1\0"
    /* 0x4c82 */ "@mozilla.org/login-manager/authprompter;1\0"
    /* 0x4cac */ "@mozilla.org/network/downloader;1\0"
    /* 0x4cce */ "@mozilla.org/login-detection-service;1\0"
    /* 0x4cf5 */ "@mozilla.org/content-blocking-allow-list;1\0"
    /* 0x4d20 */ "@mozilla.org/content/dropped-link-handler;1\0"
    /* 0x4d4c */ "@mozilla.org/backgroundtasksrunner;1\0"
    /* 0x4d71 */ "@mozilla.org/addons/integration;1\0"
    /* 0x4d93 */ "@mozilla.org/network/protocol/about;1?what=telemetry\0"
    /* 0x4dc8 */ "@mozilla.org/network/native-dns-override;1\0"
    /* 0x4df3 */ "@mozilla.org/network/protocol;1?name=ws\0"
    /* 0x4e1b */ "@mozilla.org/libjar/zip-reader-cache;1\0"
    /* 0x4e42 */ "@mozilla.org/private-attribution;1\0"
    /* 0x4e65 */ "@mozilla.org/network/protocol/about;1?what=deleteprofile\0"
    /* 0x4e9e */ "@mozilla.org/uriloader/content-handler;1?type=text/plain\0"
    /* 0x4ed7 */ "@mozilla.org/network/protocol;1?name=data\0"
    /* 0x4f01 */ "@mozilla.org/network/udp-filter-handler;1?name=stun\0"
    /* 0x4f35 */ "@mozilla.org/network/protocol/about;1?what=translations\0"
    /* 0x4f6d */ "@mozilla.org/layout/contentserializer;1?mimetype=application/vnd.mozilla.xul+xml\0"
    /* 0x4fbe */ "@mozilla.org/storage/service;1\0"
    /* 0x4fdd */ "@mozilla.org/async-shutdown-service;1\0"
    /* 0x5003 */ "@mozilla.org/dom/sessionStorage-manager;1\0"
    /* 0x502d */ "@mozilla.org/gfx/devicecontextspec;1\0"
    /* 0x5052 */ "@mozilla.org/network/protocol/about;1?what=keyboard\0"
    /* 0x5086 */ "@mozilla.org/network/throttlequeue;1\0"
    /* 0x50ab */ "@mozilla.org/embeddor.implemented/web-protocol-handler-registrar;1\0"
    /* 0x50ee */ "@mozilla.org/browser/shell-service;1\0"
    /* 0x5113 */ "@mozilla.org/network/protocol/about;1?what=crashextensions\0"
    /* 0x514e */ "@mozilla.org/observer-service;1\0"
    /* 0x516e */ "@mozilla.org/webauthn/service;1\0"
    /* 0x518e */ "@mozilla.org/supports-interface-pointer;1\0"
    /* 0x51b8 */ "@mozilla.org/network/buffered-input-stream;1\0"
    /* 0x51e5 */ "@mozilla.org/network/protocol/about;1?what=neterror\0"
    /* 0x5219 */ "@mozilla.org/peerconnection;1\0"
    /* 0x5237 */ "@mozilla.org/network/protocol/about;1?what=welcomeback\0"
    /* 0x526e */ "@mozilla.org/autocomplete/search;1?name=search-autocomplete\0"
    /* 0x52aa */ "@mozilla.org/security/osreauthenticator;1\0"
    /* 0x52d4 */ "@mozilla.org/network/mock-network-controller;1\0"
    /* 0x5303 */ "@mozilla.org/network/protocol/about;1?what=profilemanager\0"
    /* 0x533d */ "@mozilla.org/network/protocol;1?name=blob\0"
    /* 0x5367 */ "@mozilla.org/streamconv;1?from=uncompressed&to=x-gzip\0"
    /* 0x539d */ "@mozilla.org/xre/runtime;1\0"
    /* 0x53b8 */ "@mozilla.org/docshell/uri-fixup;1\0"
    /* 0x53da */ "@mozilla.org/network/protocol;1?name=moz-extension\0"
    /* 0x540d */ "@mozilla.org/url-classifier/hashcompleter;1\0"
    /* 0x5439 */ "@mozilla.org/network/protocol/about;1?what=about\0"
    /* 0x546a */ "@mozilla.org/widget/dragservice;1\0"
    /* 0x548c */ "@mozilla.org/dom/peerconnectionstatic;1\0"
    /* 0x54b4 */ "@mozilla.org/content/plugin/document-loader-factory;1\0"
    /* 0x54ea */ "@mozilla.org/uriloader/content-handler;1?type=image/gif\0"
    /* 0x5522 */ "@mozilla.org/supports-cstring;1\0"
    /* 0x5542 */ "@mozilla.org/uriloader/dbus-handler-app;1\0"
    /* 0x556c */ "@mozilla.org/login-manager;1\0"
    /* 0x5589 */ "@mozilla.org/devicesensors;1\0"
    /* 0x55a6 */ "@mozilla.org/network/protocol/about;1?what=robots\0"
    /* 0x55d8 */ "@mozilla.org/variant;1\0"
    /* 0x55ef */ "@mozilla.org/security/sdr;1\0"
    /* 0x560b */ "@mozilla.org/process/environment;1\0"
    /* 0x562e */ "@mozilla.org/supports-double;1\0"
    /* 0x564d */ "@mozilla.org/sqlite-key-value-service;1\0"
    /* 0x5675 */ "@mozilla.org/network/protocol/about;1?what=preferences\0"
    /* 0x56ac */ "@mozilla.org/image/encoder;2?type=image/webp\0"
    /* 0x56d9 */ "@mozilla.org/network/udp-socket;1\0"
    /* 0x56fb */ "@mozilla.org/network/protocol/about;1?what=opentabs\0"
    /* 0x572f */ "@mozilla.org/backgroundtasks;1\0"
    /* 0x574e */ "@mozilla.org/supports-PRUint64;1\0"
    /* 0x576f */ "@mozilla.org/network/protocol/about;1?what=tabcrashed\0"
    /* 0x57a5 */ "@mozilla.org/pref-localizedstring;1\0"
    /* 0x57c9 */ "@mozilla.org/uriloader/content-handler;1?type=image/svg+xml\0"
    /* 0x5805 */ "@mozilla.org/login-manager/autocompletesearch;1\0"
    /* 0x5835 */ "@mozilla.org/extensions/native-messaging-portal;1\0"
    /* 0x5867 */ "@mozilla.org/network/safe-file-output-stream;1\0"
    /* 0x5896 */ "@mozilla.org/uriloader/content-handler;1?type=image/jpeg\0"
    /* 0x58cf */ "@mozilla.org/embedcomp/dialogparam;1\0"
    /* 0x58f4 */ "@mozilla.org/streamconv;1?from=uncompressed&to=rawdeflate\0"
    /* 0x592e */ "@mozilla.org/security/contentsignatureverifier;1\0"
    /* 0x595f */ "@mozilla.org/network/protocol/about;1?what=cache-entry\0"
    /* 0x5996 */ "@mozilla.org/security/nssversion;1\0"
    /* 0x59b9 */ "@mozilla.org/gfx/screenmanager;1\0"
    /* 0x59da */ "@mozilla.org/network/protocol/about;1?what=blank\0"
    /* 0x5a0b */ "@mozilla.org/supports-PRBool;1\0"
    /* 0x5a2a */ "@mozilla.org/network/protocol/about;1?what=restricted\0"
    /* 0x5a60 */ "@mozilla.org/network/protocol/about;1?what=serviceworkers\0"
    /* 0x5a9a */ "@mozilla.org/dom/rtpsender;1\0"
    /* 0x5ab7 */ "@mozilla.org/jsctypes;1\0"
    /* 0x5acf */ "@mozilla.org/thread-manager;1\0"
    /* 0x5aed */ "@mozilla.org/streamconv;1?from=compress&to=uncompressed\0"
    /* 0x5b25 */ "@mozilla.org/supports-PRTime;1\0"
    /* 0x5b44 */ "@mozilla.org/parent/filepicker;1\0"
    /* 0x5b65 */ "@mozilla.org/network/protocol/about;1?what=buildconfig\0"
    /* 0x5b9c */ "@mozilla.org/network/protocol-proxy-service;1\0"
    /* 0x5bca */ "@mozilla.org/streamconv;1?from=x-compress&to=uncompressed\0"
    /* 0x5c04 */ "@mozilla.org/browser/credentialchooserservice;1\0"
    /* 0x5c34 */ "@mozilla.org/jsreflect;1\0"
    /* 0x5c4d */ "@mozilla.org/network/protocol;1?name=moz-newtab-wallpaper\0"
    /* 0x5c87 */ "@mozilla.org/thumbnails/pagethumbs-service;1\0"
    /* 0x5cb4 */ "@mozilla.org/gfx/parent/screenmanager;1\0"
    /* 0x5cdc */ "@mozilla.org/memory-reporter-manager;1\0"
    /* 0x5d03 */ "@mozilla.org/serviceworkers/manager;1\0"
    /* 0x5d29 */ "@mozilla.org/find/find_service;1\0"
    /* 0x5d4a */ "@mozilla.org/widget/transferable;1\0"
    /* 0x5d6d */ "@mozilla.org/network/protocol;1?name=moz-icon\0"
    /* 0x5d9b */ "@mozilla.org/uriloader/external-helper-app-service;1\0"
    /* 0x5dd0 */ "@mozilla.org/third-party-cookie-blocking-exception-list-service;1\0"
    /* 0x5e12 */ "@mozilla.org/security/transportsecurityinfo;1\0"
    /* 0x5e40 */ "@mozilla.org/streamconv;1?from=application/http-index-format&to=text/html\0"
    /* 0x5e8a */ "@mozilla.org/layout/contentserializer;1?mimetype=text/xml\0"
    /* 0x5ec4 */ "@mozilla.org/memoryNotificationStorage;1\0"
    /* 0x5eed */ "@mozilla.org/addons/glean-daily-ping;1\0"
    /* 0x5f14 */ "@mozilla.org/inspector/deep-tree-walker;1\0"
    /* 0x5f3e */ "@mozilla.org/load-context-info-factory;1\0"
    /* 0x5f67 */ "@mozilla.org/security/pk11tokendb;1\0"
    /* 0x5f8b */ "@mozilla.org/jsinspector;1\0"
    /* 0x5fa6 */ "@mozilla.org/gfx/info;1\0"
    /* 0x5fbe */ "@mozilla.org/streamconv;1?from=uncompressed&to=gzip\0"
    /* 0x5ff2 */ "@mozilla.org/network/stream-listener-tee;1\0"
    /* 0x601d */ "@mozilla.org/network/protocol/about;1?what=editprofile\0"
    /* 0x6054 */ "@mozilla.org/network/protocol/about;1?what=firefoxview\0"
    /* 0x608b */ "@mozilla.org/webtransportevent/service;1\0"
    /* 0x60b4 */ "@mozilla.org/main-process-singleton;1\0"
    /* 0x60da */ "@mozilla.org/synth-voice-registry;1\0"
    /* 0x60fe */ "@mozilla.org/cookie-banner-rule;1\0"
    /* 0x6120 */ "@mozilla.org/network/protocol/about;1?what=messagepreview\0"
    /* 0x615a */ "@mozilla.org/third-party-cookie-exception-entry;1\0"
    /* 0x618c */ "@mozilla.org/dom/rtpreceiver;1\0"
    /* 0x61ab */ "@mozilla.org/enterprisepolicies;1\0"
    /* 0x61cd */ "@mozilla.org/layout/contentserializer;1?mimetype=image/svg+xml\0"
    /* 0x620c */ "@mozilla.org/push/PushManager;1\0"
    /* 0x622c */ "@mozilla.org/layout/contentserializer;1?mimetype=application/xhtml+xml\0"
    /* 0x6273 */ "@mozilla.org/timer-manager;1\0"
    /* 0x6290 */ "@mozilla.org/globalmessagemanager;1\0"
    /* 0x62b4 */ "@mozilla.org/network/protocol/about;1?what=profiling\0"
    /* 0x62e9 */ "@mozilla.org/network/binary-http;1\0"
    /* 0x630c */ "@mozilla.org/network/file-output-stream;1\0"
    /* 0x6336 */ "@mozilla.org/uriloader/content-handler;1?type=image/vnd.microsoft.icon\0"
    /* 0x637d */ "@mozilla.org/network/buffered-output-stream;1\0"
    /* 0x63ab */ "@mozilla.org/zipwriter;1\0"
    /* 0x63c4 */ "@mozilla.org/toolkit/glean;1\0"
    /* 0x63e1 */ "@mozilla.org/content-pref/service;1\0"
    /* 0x6405 */ "@mozilla.org/autocomplete/controller;1\0"
    /* 0x642c */ "@mozilla.org/startupcacheinfo;1\0"
    /* 0x644c */ "@mozilla.org/webnavigation-info;1\0"
    /* 0x646e */ "@mozilla.org/transfer;1\0"
    /* 0x6486 */ "@mozilla.org/addons/content-policy;1\0"
    /* 0x64ab */ "@mozilla.org/network/stream-loader;1\0"
    /* 0x64d0 */ "@mozilla.org/network/protocol/about;1?what=profiles\0"
    /* 0x6504 */ "@mozilla.org/uriloader/content-handler;1?type=image/png\0"
    /* 0x653c */ "@mozilla.org/crashmanager;1\0"
    /* 0x6558 */ "@mozilla.org/network/dashboard;1\0"
    /* 0x6579 */ "@mozilla.org/streamconv;1?from=application/octet-stream&to=*/*\0"
    /* 0x65b8 */ "@mozilla.org/security/datastoragemanager;1\0"
    /* 0x65e3 */ "@mozilla.org/network/async-stream-copier;1\0"
    /* 0x660e */ "@mozilla.org/network/protocol/about;1?what=sessionrestore\0"
    /* 0x6648 */ "@mozilla.org/network/protocol/about;1?what=loginsimportreport\0"
    /* 0x6686 */ "@mozilla.org/network/protocol/about;1?what=settings\0"
    /* 0x66ba */ "@mozilla.org/layout/contentserializer;1?mimetype=application/xml\0"
    /* 0x66fb */ "@mozilla.org/timer;1\0"
    /* 0x6710 */ "@mozilla.org/supports-PRInt32;1\0"
    /* 0x6730 */ "@mozilla.org/tracking-db-service;1\0"
    /* 0x6753 */ "@mozilla.org/layout/contentserializer;1?mimetype=text/html\0"
    /* 0x678e */ "@mozilla.org/network/protocol;1?name=http\0"
    /* 0x67b8 */ "@mozilla.org/network/protocol/about;1?what=processes\0"
    /* 0x67ed */ "@mozilla.org/streamconv;1?from=zstd&to=uncompressed\0"
    /* 0x6821 */ "@mozilla.org/network/idn-service;1\0"
    /* 0x6844 */ "@mozilla.org/helperapplauncherdialog;1\0"
    /* 0x686b */ "@mozilla.org/content/style-sheet-service;1\0"
    /* 0x6896 */ "@mozilla.org/dom/quota-utils-service;1\0"
    /* 0x68bd */ "@mozilla.org/network/protocol/about;1?what=crashcontent\0"
    /* 0x68f5 */ "@mozilla.org/push/Service;1\0"
    /* 0x6911 */ "@mozilla.org/scripterror;1\0"
    /* 0x692c */ "@mozilla.org/network/protocol/about;1?what=reader\0"
    /* 0x695e */ "@mozilla.org/toolkit/captive-detector;1\0"
    /* 0x6986 */ "@mozilla.org/browser/favicon-service;1\0"
    /* 0x69ad */ "@mozilla.org/network/protocol/about;1?what=credits\0"
    /* 0x69e0 */ "@mozilla.org/text-input-processor;1\0"
    /* 0x6a04 */ "@mozilla.org/dom/rtcstatsreport;1\0"
    /* 0x6a26 */ "@mozilla.org/supports-PRUint16;1\0"
    /* 0x6a47 */ "@mozilla.org/network/url-parser;1?auth=no\0"
    /* 0x6a71 */ "@mozilla.org/consoleservice;1\0"
    /* 0x6a8f */ "@mozilla.org/content-permission/prompt;1\0"
    /* 0x6ab8 */ "@mozilla.org/referrer-info;1\0"
    /* 0x6ad5 */ "@mozilla.org/widget/parent/dragservice;1\0"
    /* 0x6afe */ "@mozilla.org/supports-PRInt16;1\0"
    /* 0x6b1e */ "@mozilla.org/supports-PRInt64;1\0"
    /* 0x6b3e */ "@mozilla.org/network/protocol;1?name=moz-page-thumb\0"
    /* 0x6b72 */ "@mozilla.org/network/input-stream-pump;1\0"
    /* 0x6b9b */ "@mozilla.org/ml-utils;1\0"
    /* 0x6bb3 */ "@mozilla.org/geolocation/provider;1\0"
    /* 0x6bd7 */ "@mozilla.org/network/background-file-saver;1?mode=outputstream\0"
    /* 0x6c16 */ "@mozilla.org/intl/converter-input-stream;1\0"
    /* 0x6c41 */ "@mozilla.org/network/protocol;1?name=page-icon\0"
    /* 0x6c70 */ "@mozilla.org/uriloader/content-handler;1?type=image/jpg\0"
    /* 0x6ca8 */ "@mozilla.org/network/server-socket;1\0"
    /* 0x6ccd */ "@mozilla.org/io/multiplex-input-stream;1\0"
    /* 0x6cf6 */ "@mozilla.org/ipc/processselector;1\0"
    /* 0x6d19 */ "@mozilla.org/toolkit/profile-migrator;1\0"
    /* 0x6d41 */ "@mozilla.org/wifi/monitor;1\0"
    /* 0x6d5d */ "@mozilla.org/preferences-service;1\0"
    /* 0x6d80 */ "@mozilla.org/xpcom/memory-watcher;1\0"
    /* 0x6da4 */ "@mozilla.org/uriloader/external-protocol-service;1\0"
    /* 0x6dd7 */ "@mozilla.org/partitioning/exception-list-service;1\0"
    /* 0x6e0a */ "@mozilla.org/network/protocol;1?name=chrome\0"
    /* 0x6e36 */ "@mozilla.org/network/standard-url-mutator;1\0"
    /* 0x6e62 */ "@mozilla.org/docshell/structured-clone-container;1\0"
    /* 0x6e95 */ "@mozilla.org/image/encoder;2?type=image/png\0"
    /* 0x6ec1 */ "@mozilla.org/network/protocol/about;1?what=fingerprintingprotection\0"
    /* 0x6f05 */ "@mozilla.org/network/protocol/about;1?what=config\0"
    /* 0x6f37 */ "@mozilla.org/toolkit/shell-service;1\0"
    /* 0x6f5c */ "@mozilla.org/spellchecker/personaldictionary;1\0"
    /* 0x6f8b */ "@mozilla.org/uriloader/content-handler;1?type=application/x-xpinstall\0"
    /* 0x6fd1 */ "@mozilla.org/streamconv;1?from=application/pdf&to=text/html\0"
    /* 0x700d */ "@mozilla.org/network/io-service;1\0"
    /* 0x702f */ "@mozilla.org/network/protocol/about;1?what=sync-log\0"
    /* 0x7063 */ "@mozilla.org/login-manager/crypto/SDR;1\0"
    /* 0x708b */ "@mozilla.org/pipe;1\0"
    /* 0x709f */ "@mozilla.org/toolkit/shutdown-terminator;1\0"
    /* 0x70ca */ "@mozilla.org/network/protocol;1?name=view-source\0"
    /* 0x70fb */ "@mozilla.org/uriclassifierservice\0"
    /* 0x711d */ "@mozilla.org/io-util;1\0"
    /* 0x7134 */ "@mozilla.org/network/protocol;1?name=wss\0"
    /* 0x715d */ "@mozilla.org/browser/history;1\0"
    /* 0x717c */ "@mozilla.org/url-classifier/listmanager;1\0"
    /* 0x71a6 */ "@mozilla.org/tracking-url-decoration-service;1\0"
    /* 0x71d5 */ "@mozilla.org/gecko-media-plugin-service;1\0"
    /* 0x71ff */ "@mozilla.org/user-characteristics-page;1\0"
    /* 0x7228 */ "@mozilla.org/image/tools;1\0"
    /* 0x7243 */ "@mozilla.org/typeaheadfind;1\0"
    /* 0x7260 */ "@mozilla.org/file/directory_service;1\0"
    /* 0x7286 */ "@mozilla.org/ssservice;1\0"
    /* 0x729f */ "@mozilla.org/appshell/window-mediator;1\0"
    /* 0x72c7 */ "@mozilla.org/push/Notifier;1\0"
    /* 0x72e4 */ "@mozilla.org/network/protocol/about;1?what=newprofile\0"
    /* 0x731a */ "@mozilla.org/moz/jssubscript-loader;1\0"
    /* 0x7340 */ "@mozilla.org/supports-char;1\0"
    /* 0x735d */ "@mozilla.org/widget/useridleservice;1\0"
    /* 0x7383 */ "@mozilla.org/browser/identitycredentialpromptservice;1\0"
    /* 0x73ba */ "@mozilla.org/network/protocol/about;1?what=webauthn\0"
    /* 0x73ee */ "@mozilla.org/focus-manager;1\0"
    /* 0x740b */ "@mozilla.org/fingerprinting-override;1\0"
    /* 0x7432 */ "@mozilla.org/geolocation;1\0"
    /* 0x744d */ "@mozilla.org/network/protocol;1?name=about\0"
    /* 0x7478 */ "@mozilla.org/toolkit/app-startup;1\0"
    /* 0x749b */ "@mozilla.org/sound;1\0"
    /* 0x74b0 */ "@mozilla.org/xre/directory-provider;1\0"
    /* 0x74d6 */ "@mozilla.org/storage/activity-service;1\0"
    /* 0x74fe */ "@mozilla.org/pref-override-map;1\0"
    /* 0x751f */ "@mozilla.org/streamconv;1?from=multipart/mixed&to=*/*\0"
    /* 0x7555 */ "@mozilla.org/security/x509certdb;1\0"
    /* 0x7578 */ "@mozilla.org/uriloader/content-handler;1?type=text/css\0"
    /* 0x75af */ "@mozilla.org/network/socket-transport-service;1\0"
    /* 0x75df */ "@mozilla.org/security/clientAuthRememberService;1\0"
    /* 0x7611 */ "@mozilla.org/network/protocol;1?name=https\0"
    /* 0x763c */ "@mozilla.org/scriptsecuritymanager;1\0"
    /* 0x7661 */ "@mozilla.org/supports-PRUint32;1\0"
    /* 0x7682 */ "@mozilla.org/browser/tagging-service;1\0"
    /* 0x76a9 */ "@mozilla.org/tools/profiler;1\0"
    /* 0x76c7 */ "@mozilla.org/security/pkcs11moduledb;1\0"
    /* 0x76ee */ "@mozilla.org/uriloader/content-handler;1?type=text/rdf\0"
    /* 0x7725 */ "@mozilla.org/security/publickeypinningservice;1\0"
    /* 0x7755 */ "@mozilla.org/image/encoder;2?type=image/jpeg\0"
    /* 0x7782 */ "@mozilla.org/uriloader/handler-service-parent;1\0"
    /* 0x77b2 */ "@mozilla.org/addons/addon-manager-startup;1\0"
    /* 0x77de */ "@mozilla.org/fingerprinting-webcompat-service;1\0"
    /* 0x780e */ "@mozilla.org/browser/nav-bookmarks-service;1\0"
    /* 0x783b */ "@mozilla.org/nsTokenPasswordDialogs;1\0"
    /* 0x7861 */ "@mozilla.org/notification-handler;1\0"
    /* 0x7885 */ "@mozilla.org/network/protocol/about;1?what=mozilla\0"
    /* 0x78b8 */ "@mozilla.org/content/filepicker;1\0"
    /* 0x78da */ "@mozilla.org/embedcomp/default-tooltiptextprovider;1\0"
    /* 0x790f */ "@mozilla.org/network/protocol/about;1?what=cache\0"
    /* 0x7940 */ "@mozilla.org/network/http-auth-manager;1\0"
    /* 0x7969 */ "@mozilla.org/network/file-random-access-stream;1\0"
    /* 0x799a */ "@mozilla.org/processtools-service;1\0"
    /* 0x79be */ "@mozilla.org/eventlistenerservice;1\0"
    /* 0x79e2 */ "@mozilla.org/supports-string;1\0"
    /* 0x7a01 */ "@mozilla.org/network/protocol/about;1?what=networking\0"
    /* 0x7a37 */ "@mozilla.org/mime;1\0"
    /* 0x7a4b */ "@mozilla.org/uriloader/content-handler;1?type=application/http-index-format\0"
    /* 0x7a97 */ "@mozilla.org/media/wmfcdm-origins-list;1\0"
    /* 0x7ac0 */ "@mozilla.org/toolkit/finalizationwitness;1\0"
    /* 0x7aeb */ "@mozilla.org/network/simple-uri-mutator;1\0"
    /* 0x7b15 */ "@mozilla.org/network/protocol;1?name=moz-src\0"
    /* 0x7b42 */ "@mozilla.org/network/file-input-stream;1\0"
    /* 0x7b6b */ "@mozilla.org/streamconv;1?from=uncompressed&to=deflate\0"
    /* 0x7ba2 */ "@mozilla.org/network/serialization-helper;1\0"
    /* 0x7bce */ "@mozilla.org/system-alerts-service;1\0"
    /* 0x7bf3 */ "@mozilla.org/widget/content/clipboard;1\0"
    /* 0x7c1b */ "@mozilla.org/network/protocol;1?name=moz-remote-image\0"
    /* 0x7c51 */ "@mozilla.org/network/protocol/about;1?what=newtab\0"
    /* 0x7c83 */ "@mozilla.org/streamconv;1?from=gzip&to=uncompressed\0"
    /* 0x7cb7 */ "@mozilla.org/permissionmanager;1\0"
    /* 0x7cd8 */ "@mozilla.org/layout/content-policy;1\0"
    /* 0x7cfd */ "@mozilla.org/network/protocol/about;1?what=srcdoc\0"
    /* 0x7d2f */ "@mozilla.org/websocketevent/service;1\0"
    /* 0x7d55 */ "@mozilla.org/autocomplete/search;1?name=places-tag-autocomplete\0"
    /* 0x7d95 */ "@mozilla.org/dom/localStorage-manager;1\0"
    /* 0x7dbd */ "@mozilla.org/network/protocol/about;1?what=privatebrowsing\0"
    /* 0x7df8 */ "@mozilla.org/network/stream-transport-service;1\0"
    /* 0x7e28 */ "@mozilla.org/network/protocol/about;1?what=logo\0"
    /* 0x7e58 */ "@mozilla.org/txttohtmlconv;1\0"
    /* 0x7e75 */ "@mozilla.org/accessibilityService;1\0"
    /* 0x7e99 */ "@mozilla.org/base/telemetry-startup;1\0"
    /* 0x7ebf */ "@mozilla.org/network/effective-tld-service;1\0"
    /* 0x7eec */ "@mozilla.org/streamconv;1?from=multipart/byteranges&to=*/*\0"
    /* 0x7f27 */ "@mozilla.org/parentprocessmessagemanager;1\0"
    /* 0x7f52 */ "@mozilla.org/file/local;1\0"
    /* 0x7f6c */ "@mozilla.org/browser/search-service;1\0"
    /* 0x7f92 */ "@mozilla.org/network/protocol/about;1?what=httpsonlyerror\0"
    /* 0x7fcc */ "@mozilla.org/network/protocol/about;1?what=addons\0"
    /* 0x7ffe */ "@mozilla.org/remote;1\0"
    /* 0x8014 */ "@mozilla.org/intl/scriptableunicodeconverter\0"
    /* 0x8041 */ "@mozilla.org/network/authprompt-adapter-factory;1\0"
    /* 0x8073 */ "@mozilla.org/uriloader/content-handler;1?type=application/xhtml+xml\0"
    /* 0x80b7 */ "@mozilla.org/intl/stringbundle;1\0"
    /* 0x80d8 */ "@mozilla.org/security/CRLiteTimestamp;1\0"
    /* 0x8100 */ "@mozilla.org/network/protocol/about;1?what=rights\0"
    /* 0x8132 */ "@mozilla.org/clear-by-site-entry;1\0"
    /* 0x8155 */ "@mozilla.org/network/protocol;1?name=moz-cached-ohttp\0"
    /* 0x818b */ "@mozilla.org/dom/createofferrequest;1\0"
    /* 0x81b1 */ "@mozilla.org/integritypolicy;1\0"
    /* 0x81d0 */ "@mozilla.org/network/protocol/about;1?what=crashgpu\0"
    /* 0x8204 */ "@mozilla.org/streamconv;1?from=deflate&to=uncompressed\0"
    /* 0x823b */ "@mozilla.org/widget/content/dragservice;1\0"
    /* 0x8265 */ "@mozilla.org/key-value-service;1\0"
    /* 0x8286 */ "@mozilla.org/network/tls-server-socket;1\0"
    /* 0x82af */ "@mozilla.org/widget/taskbarprogress/gtk;1\0"
    /* 0x82d9 */ "@mozilla.org/docloaderservice;1\0"
    /* 0x82f9 */ "@mozilla.org/notificationStorage;1\0"
    /* 0x831c */ "@mozilla.org/cookie-banner-list-service;1\0"
    /* 0x8346 */ "@mozilla.org/streamconv;1?from=x-gzip&to=uncompressed\0"
    /* 0x837c */ "@mozilla.org/network/network-connectivity-service;1\0"
    /* 0x83b0 */ "@mozilla.org/uriloader/local-handler-app;1\0"
    /* 0x83db */ "@mozilla.org/psm;1\0"
    /* 0x83ee */ "@mozilla.org/toolkit/URLFormatterService;1\0"
    /* 0x8419 */ "@mozilla.org/io/arraybuffer-input-stream;1\0"
    /* 0x8444 */ "@mozilla.org/embedcomp/rangefind;1\0"
    /* 0x8467 */ "@mozilla.org/url-classifier/streamupdater;1\0"
    /* 0x8493 */ "@mozilla.org/widget/appshell/gtk;1\0"
    /* 0x84b6 */ "@mozilla.org/chrome/chrome-registry;1\0"
    /* 0x84dc */ "@mozilla.org/network/protocol/about;1?what=restartrequired\0"
    /* 0x8517 */ "@mozilla.org/streamconv;1?from=application/vnd.mozilla.webext.unlocalized&to=text/css\0"
    /* 0x856d */ "@mozilla.org/network/protocol/about;1?what=license\0"
    /* 0x85a0 */ "@mozilla.org/network/mime-input-stream;1\0"
    /* 0x85c9 */ "@mozilla.org/eventsourceevent/service;1\0"
    /* 0x85f1 */ "@mozilla.org/cookiemanager;1\0"
    /* 0x860e */ "@mozilla.org/power/powermanagerservice;1\0"
    /* 0x8637 */ "@mozilla.org/webvttParserWrapper;1\0"
    /* 0x865a */ "@mozilla.org/network/protocol/about;1?what=checkerboard\0"
    /* 0x8692 */ "@mozilla.org/browser/synced-bookmarks-merger;1\0"
    /* 0x86c1 */ "@mozilla.org/cspcontext;1\0"
    /* 0x86db */ "focus\0"
    /* 0x86e1 */ "cpmm\0"
    /* 0x86e6 */ "telemetry\0"
    /* 0x86f0 */ "uuid\0"
    /* 0x86f5 */ "policies\0"
    /* 0x86fe */ "strings\0"
    /* 0x8706 */ "crashmanager\0"
    /* 0x8713 */ "cookieBanners\0"
    /* 0x8721 */ "ppmm\0"
    /* 0x8726 */ "prefs\0"
    /* 0x872c */ "search\0"
    /* 0x8733 */ "els\0"
    /* 0x8737 */ "dirsvc\0"
    /* 0x873e */ "loadContextInfo\0"
    /* 0x874e */ "cache2\0"
    /* 0x8755 */ "env\0"
    /* 0x8759 */ "logins\0"
    /* 0x8760 */ "vc\0"
    /* 0x8763 */ "wm\0"
    /* 0x8766 */ "eTLD\0"
    /* 0x876b */ "droppedLinkHandler\0"
    /* 0x877e */ "catMan\0"
    /* 0x8785 */ "io\0"
    /* 0x8788 */ "locale\0"
    /* 0x878f */ "clearData\0"
    /* 0x8799 */ "dns\0"
    /* 0x879d */ "profiler\0"
    /* 0x87a6 */ "clipboard\0"
    /* 0x87b0 */ "scriptSecurityManager\0"
    /* 0x87c6 */ "cookies\0"
    /* 0x87ce */ "tm\0"
    /* 0x87d1 */ "xulStore\0"
    /* 0x87da */ "obs\0"
    /* 0x87de */ "console\0"
    /* 0x87e6 */ "perms\0"
    /* 0x87ec */ "qms\0"
    /* 0x87f0 */ "urlFormatter\0"
    /* 0x87fd */ "textToSubURI\0"
    /* 0x880a */ "sysinfo\0"
    /* 0x8812 */ "storage\0"
    /* 0x881a */ "appinfo\0"
    /* 0x8822 */ "sessionStorage\0"
    /* 0x8831 */ "DAPTelemetry\0"
    /* 0x883e */ "appShell\0"
    /* 0x8847 */ "startup\0"
    /* 0x884f */ "scriptloader\0"
    /* 0x885c */ "blocklist\0"
    /* 0x8866 */ "prompt\0"
    /* 0x886d */ "uriFixup\0"
    /* 0x8876 */ "domStorageManager\0"
    /* 0x8888 */ "rfp\0"
    /* 0x888c */ "ww\0"
    /* 0x888f */ "intl\0"
    /* 0x8894 */ "fog\0"
    /* 0x8898 */ "mm\0"
    /* 0x889b */ "about\0"
    /* 0x88a1 */ "default\0"
    /* 0x88a9 */ "ws\0"
    /* 0x88ac */ "blob\0"
    /* 0x88b1 */ "cached-favicon\0"
    /* 0x88c0 */ "moz-gio\0"
    /* 0x88c8 */ "data\0"
    /* 0x88cd */ "jar\0"
    /* 0x88d1 */ "moz-page-thumb\0"
    /* 0x88e0 */ "wss\0"
    /* 0x88e4 */ "resource\0"
    /* 0x88ed */ "moz-extension\0"
    /* 0x88fb */ "moz-src\0"
    /* 0x8903 */ "http\0"
    /* 0x8908 */ "view-source\0"
    /* 0x8914 */ "moz-cached-ohttp\0"
    /* 0x8925 */ "moz-icon\0"
    /* 0x892e */ "file\0"
    /* 0x8933 */ "javascript\0"
    /* 0x893e */ "https\0"
    /* 0x8944 */ "indexeddb\0"
    /* 0x894e */ "page-icon\0"
    /* 0x8958 */ "moz-newtab-wallpaper\0"
    /* 0x896d */ "moz\0"
    /* 0x8971 */ "chrome\0"
    /* 0x8978 */ "moz-remote-image\0"
    /* 0x8989 */ "moz-safe-about\0"
  "";

const StaticCategory gStaticCategories[kStaticCategoryCount] = {
  { { 0x0 } /* "@mozilla.org/streamconv;1" */,
    0, 11 },
  { { 0x191 } /* "Gecko-Content-Viewers" */,
    11, 27 },
  { { 0x396 } /* "app-startup" */,
    38, 4 },
  { { 0x48b } /* "command-line-handler" */,
    42, 9 },
  { { 0x64b } /* "command-line-validator" */,
    51, 1 },
  { { 0x66c } /* "content-policy" */,
    52, 7 },
  { { 0x7a0 } /* "content-process-ready-for-script" */,
    59, 1 },
  { { 0x80d } /* "content-sniffing-services" */,
    60, 2 },
  { { 0x87b } /* "idle-daily" */,
    62, 7 },
  { { 0xa72 } /* "net-and-orb-content-sniffers" */,
    69, 3 },
  { { 0xac1 } /* "net-channel-event-sinks" */,
    72, 2 },
  { { 0xad9 } /* "net-content-sniffers" */,
    74, 3 },
  { { 0xb25 } /* "orb-content-sniffers" */,
    77, 2 },
  { { 0xb3a } /* "payment-request" */,
    79, 10 },
  { { 0xe5b } /* "places-init-complete" */,
    89, 2 },
  { { 0xeeb } /* "pref-config-startup" */,
    91, 1 },
  { { 0xf2b } /* "profile-after-change" */,
    92, 14 },
  { { 0x120e } /* "push" */,
    106, 1 },
  { { 0x124d } /* "speech-synth-started" */,
    107, 2 },
  { { 0x12d0 } /* "vacuum-participant" */,
    109, 1 },
  { { 0x1315 } /* "xpcom-startup" */,
    110, 2 },
};
const StaticCategoryEntry gStaticCategoryEntries[] = {
  /* "@mozilla.org/streamconv;1" */
  { { 0x1a } /* "?from=application/http-index-format&to=text/html" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x4c } /* "?from=application/x-unknown-content-type&to=*\/\*" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x7c } /* "?from=br&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x95 } /* "?from=compress&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0xb4 } /* "?from=deflate&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0xd2 } /* "?from=gzip&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0xed } /* "?from=multipart/byteranges&to=*\/\*" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x10f } /* "?from=multipart/mixed&to=*\/\*" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x12c } /* "?from=multipart/x-mixed-replace&to=*\/\*" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x153 } /* "?from=x-compress&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },
  { { 0x174 } /* "?from=x-gzip&to=uncompressed" */,
    { 0x4b } /* "" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS },

  /* "Gecko-Content-Viewers" */
  { { 0x1a7 } /* "application/http-index-format" */,
    { 0x1c5 } /* "@mozilla.org/content-viewers/http-index-format" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x1f4 } /* "application/mathml+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x23a } /* "application/rdf+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x24e } /* "application/vnd.wap.xhtml+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x26c } /* "application/x-view-source" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x286 } /* "application/xhtml+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x29c } /* "application/xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2ac } /* "image/apng" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2b7 } /* "image/avif" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2c2 } /* "image/bmp" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2cc } /* "image/gif" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2d6 } /* "image/icon" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2e1 } /* "image/jpeg" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2ec } /* "image/jpg" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x2f6 } /* "image/pjpeg" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x302 } /* "image/png" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x30c } /* "image/svg+xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x31a } /* "image/vnd.microsoft.icon" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x333 } /* "image/webp" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x33e } /* "image/x-icon" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x34b } /* "image/x-ms-bmp" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x35a } /* "image/x-png" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x366 } /* "text/html" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x370 } /* "text/plain" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x37b } /* "text/rdf" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x384 } /* "text/vtt" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x38d } /* "text/xml" */,
    { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "app-startup" */
  { { 0x3a2 } /* "ExtensionsChild" */,
    { 0x3b2 } /* "@mozilla.org/extensions/child;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x3d2 } /* "FormFillController" */,
    { 0x3e5 } /* "@mozilla.org/satchel/form-fill-controller;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x411 } /* "WebNavigationContent" */,
    { 0x426 } /* "@mozilla.org/extensions/web-navigation-content;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x457 } /* "startupRecorder" */,
    { 0x467 } /* "@mozilla.org/test/startuprecorder;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },

  /* "command-line-handler" */
  { { 0x4a0 } /* "l-taskbar-tabs" */,
    { 0x4af } /* "@mozilla.org/browser/taskbar-tabs-clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x4d7 } /* "m-backgroundtasks" */,
    { 0x4e9 } /* "@mozilla.org/backgroundtasksmanager;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x50f } /* "m-browser" */,
    { 0x519 } /* "@mozilla.org/browser/clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x534 } /* "m-devtools" */,
    { 0x53f } /* "@mozilla.org/devtools/startup-clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x563 } /* "m-marionette" */,
    { 0x570 } /* "@mozilla.org/remote/marionette;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x591 } /* "m-remote" */,
    { 0x59a } /* "@mozilla.org/remote/agent;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x5b6 } /* "m-sps" */,
    { 0x5bc } /* "@mozilla.org/browser/selectable-profiles-service-clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x5f3 } /* "x-default" */,
    { 0x5fd } /* "@mozilla.org/browser/final-clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x61e } /* "y-default" */,
    { 0x628 } /* "@mozilla.org/toolkit/default-clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "command-line-validator" */
  { { 0x662 } /* "b-browser" */,
    { 0x519 } /* "@mozilla.org/browser/clh;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },

  /* "content-policy" */
  { { 0x67b } /* "@mozilla.org/data-document-content-policy;1" */,
    { 0x67b } /* "@mozilla.org/data-document-content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x6a7 } /* "@mozilla.org/embedding/browser/content-policy;1" */,
    { 0x6a7 } /* "@mozilla.org/embedding/browser/content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x6d7 } /* "@mozilla.org/image-blocker-content-policy;1" */,
    { 0x6d7 } /* "@mozilla.org/image-blocker-content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x703 } /* "@mozilla.org/integritypolicyservice;1" */,
    { 0x703 } /* "@mozilla.org/integritypolicyservice;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x729 } /* "@mozilla.org/mixedcontentblocker;1" */,
    { 0x729 } /* "@mozilla.org/mixedcontentblocker;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x74c } /* "@mozilla.org/no-data-protocol-content-policy;1" */,
    { 0x74c } /* "@mozilla.org/no-data-protocol-content-policy;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x77b } /* "CSPService" */,
    { 0x786 } /* "@mozilla.org/cspservice;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "content-process-ready-for-script" */
  { { 0x7c1 } /* "TelemetryControllerContent" */,
    { 0x7dc } /* "@mozilla.org/base/telemetry-controller-content;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::CONTENT_PROCESS_ONLY },

  /* "content-sniffing-services" */
  { { 0x827 } /* "@mozilla.org/image/loader;1" */,
    { 0x843 } /* "@mozilla.org/image/cache;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
    { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "idle-daily" */
  { { 0x886 } /* "BounceTrackingProtection" */,
    { 0x89f } /* "@mozilla.org/bounce-tracking-protection;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x8c9 } /* "ContentBlockingTelemetryService" */,
    { 0x8e9 } /* "@mozilla.org/content-blocking-telemetry-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x91b } /* "MozStorage Vacuum Manager" */,
    { 0x935 } /* "@mozilla.org/storage/vacuum;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x953 } /* "PlacesDBUtilsIdleMaintenance" */,
    { 0x970 } /* "@mozilla.org/places/databaseUtilsIdleMaintenance;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x9a3 } /* "QuotaManagerService" */,
    { 0x9b7 } /* "@mozilla.org/dom/quota-manager-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x9e0 } /* "UrlClassifierExceptionListService" */,
    { 0xa02 } /* "@mozilla.org/url-classifier/exception-list-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xa37 } /* "nsCookieBannerService" */,
    { 0xa4d } /* "@mozilla.org/cookie-banner-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },

  /* "net-and-orb-content-sniffers" */
  { { 0x827 } /* "@mozilla.org/image/loader;1" */,
    { 0x843 } /* "@mozilla.org/image/cache;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
    { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xa8f } /* "JSONView" */,
    { 0xa98 } /* "@mozilla.org/devtools/jsonview-sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "net-channel-event-sinks" */
  { { 0x729 } /* "@mozilla.org/mixedcontentblocker;1" */,
    { 0x729 } /* "@mozilla.org/mixedcontentblocker;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x77b } /* "CSPService" */,
    { 0x786 } /* "@mozilla.org/cspservice;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "net-content-sniffers" */
  { { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
    { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xaee } /* "Binary Detector" */,
    { 0xafe } /* "@mozilla.org/network/binary-detector;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xa8f } /* "JSONView" */,
    { 0xa98 } /* "@mozilla.org/devtools/jsonview-sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "orb-content-sniffers" */
  { { 0x827 } /* "@mozilla.org/image/loader;1" */,
    { 0x843 } /* "@mozilla.org/image/cache;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
    { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "payment-request" */
  { { 0xb4a } /* "BasicCardMethodChangeDetails" */,
    { 0xb67 } /* "@mozilla.org/dom/payments/basiccard-change-details;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xb9c } /* "BasicCardResponseData" */,
    { 0xbb2 } /* "@mozilla.org/dom/payments/basiccard-response-data;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xbe6 } /* "GeneralMethodChangeDetails" */,
    { 0xc01 } /* "@mozilla.org/dom/payments/general-change-details;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xc34 } /* "GeneralResponseData" */,
    { 0xc48 } /* "@mozilla.org/dom/payments/general-response-data;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xc7a } /* "PaymentAbortActionResponse" */,
    { 0xc95 } /* "@mozilla.org/dom/payments/payment-abort-action-response;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xccf } /* "PaymentAddress" */,
    { 0xcde } /* "@mozilla.org/dom/payments/payment-address;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xd0a } /* "PaymentCanMakeActionResponse" */,
    { 0xd27 } /* "@mozilla.org/dom/payments/payment-canmake-action-response;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xd63 } /* "PaymentCompleteActionResponse" */,
    { 0xd81 } /* "@mozilla.org/dom/payments/payment-complete-action-response;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xdbe } /* "PaymentRequestService" */,
    { 0xdd4 } /* "@mozilla.org/dom/payments/payment-request-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xe08 } /* "PaymentShowActionResponse" */,
    { 0xe22 } /* "@mozilla.org/dom/payments/payment-show-action-response;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "places-init-complete" */
  { { 0xe70 } /* "PlacesFrecencyRecalculator" */,
    { 0xe8b } /* "@mozilla.org/places/frecency-recalculator;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xeb7 } /* "nsPlacesExpiration" */,
    { 0xeca } /* "@mozilla.org/places/expiration;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "pref-config-startup" */
  { { 0xeff } /* "ReadConfig Module" */,
    { 0xf11 } /* "@mozilla.org/readconfig;1" */,
    Module::BackgroundTasksSelector::ALL_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "profile-after-change" */
  { { 0xf40 } /* "CrashMonitor" */,
    { 0xf4d } /* "@mozilla.org/toolkit/crashmonitor;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xf71 } /* "CrashService" */,
    { 0xf7e } /* "@mozilla.org/crashservice;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xf9a } /* "EssentialDomainsRemoteSettings" */,
    { 0xfb9 } /* "@mozilla.org/EssentialDomainsRemoteSettings;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0xfe7 } /* "Marionette" */,
    { 0x570 } /* "@mozilla.org/remote/marionette;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xff2 } /* "PurgeTrackerService" */,
    { 0x1006 } /* "@mozilla.org/purge-tracker-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x102b } /* "RemoteAgent" */,
    { 0x59a } /* "@mozilla.org/remote/agent;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x1037 } /* "RemotePermissionService" */,
    { 0x104f } /* "@mozilla.org/remote-permission-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x1078 } /* "SimpleURIUnknownSchemesRemoteObserver" */,
    { 0x109e } /* "@mozilla.org/SimpleURIUnknownSchemesRemoteObserver;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x10d3 } /* "URLQueryStringStripper" */,
    { 0x10ea } /* "@mozilla.org/url-query-string-stripper;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x1113 } /* "formHistoryStartup" */,
    { 0x1126 } /* "@mozilla.org/satchel/form-history-startup;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0xa37 } /* "nsCookieBannerService" */,
    { 0xa4d } /* "@mozilla.org/cookie-banner-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x1152 } /* "nsRFPService" */,
    { 0x115f } /* "@mozilla.org/rfp-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x117a } /* "nsUpdateTimerManager" */,
    { 0x118f } /* "@mozilla.org/updates/timer-manager;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x11b4 } /* "service,@mozilla.org/profile-after-change-gate;1" */,
    { 0x11e5 } /* "@mozilla.org/profile-after-change-gate;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "push" */
  { { 0x1213 } /* "chrome://fxa-device-update" */,
    { 0x122e } /* "@mozilla.org/fxaccounts/push;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },

  /* "speech-synth-started" */
  { { 0x1262 } /* "Fake Speech Synth" */,
    { 0x1274 } /* "@mozilla.org/fakesynth;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
  { { 0x128d } /* "SpeechDispatcher Speech Synth" */,
    { 0x12ab } /* "@mozilla.org/synthspeechdispatcher;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "vacuum-participant" */
  { { 0x12e3 } /* "Places" */,
    { 0x12ea } /* "@mozilla.org/browser/nav-history-service;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },

  /* "xpcom-startup" */
  { { 0x1323 } /* "Fork Server Launcher" */,
    { 0x1338 } /* "@mozilla.org/fork-server-launcher;1" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::MAIN_PROCESS_ONLY },
  { { 0x135c } /* "nsGIOProtocolHandler" */,
    { 0x1371 } /* "@mozilla.org/network/protocol;1?name=moz-gio" */,
    Module::BackgroundTasksSelector::NO_TASKS,
    Module::ProcessSelector::ANY_PROCESS },
};

const nsXPTInterface gInterfaces[] = {
  nsXPTInterface::nsIURIFixup,
  nsXPTInterface::nsIDroppedLinkHandler,
  nsXPTInterface::nsIIndexedDatabaseManager,
  nsXPTInterface::nsISessionStorageService,
  nsXPTInterface::nsIPermissionManager,
  nsXPTInterface::nsIStringBundleService,
  nsXPTInterface::mozILocaleService,
  nsXPTInterface::nsITextToSubURI,
  nsXPTInterface::mozIJSSubScriptLoader,
  nsXPTInterface::nsIPrefService,
  nsXPTInterface::nsIPrefBranch,
  nsXPTInterface::nsILoadContextInfoFactory,
  nsXPTInterface::nsICacheStorageService,
  nsXPTInterface::nsIDNSService,
  nsXPTInterface::nsIEffectiveTLDService,
  nsXPTInterface::nsIIOService,
  nsXPTInterface::nsISpeculativeConnect,
  nsXPTInterface::nsINetUtil,
  nsXPTInterface::nsICookieService,
  nsXPTInterface::nsICookieManager,
  nsXPTInterface::nsIObliviousHttpService,
  nsXPTInterface::nsIReplacedHttpResponse,
  nsXPTInterface::nsIUrlClassifierExceptionListEntry,
  nsXPTInterface::nsIUrlClassifierExceptionList,
  nsXPTInterface::mozIStorageService,
  nsXPTInterface::nsIBounceTrackingProtection,
  nsXPTInterface::nsIURLQueryStringStripper,
  nsXPTInterface::nsIAppStartup,
  nsXPTInterface::nsIClearDataService,
  nsXPTInterface::nsIClearBySiteEntry,
  nsXPTInterface::nsIContentBlockingAllowList,
  nsXPTInterface::nsICookieBannerService,
  nsXPTInterface::nsICookieBannerRule,
  nsXPTInterface::nsIIdentityCredentialStorageService,
  nsXPTInterface::nsIDAPTelemetry,
  nsXPTInterface::nsIEnterprisePolicies,
  nsXPTInterface::nsIFOG,
  nsXPTInterface::nsIMLUtils,
  nsXPTInterface::mozIMozIntl,
  nsXPTInterface::nsILoginManager,
  nsXPTInterface::nsIPromptService,
  nsXPTInterface::nsIRFPService,
  nsXPTInterface::nsIRFPTargetSetIDL,
  nsXPTInterface::nsISearchService,
  nsXPTInterface::nsITelemetry,
  nsXPTInterface::nsIURLFormatter,
  nsXPTInterface::nsIXULStore,
  nsXPTInterface::nsIBlocklistService,
  nsXPTInterface::nsIXULRuntime,
  nsXPTInterface::nsIXULAppInfo,
  nsXPTInterface::nsICrashReporter,
  nsXPTInterface::nsIWindowWatcher,
  nsXPTInterface::nsIProfiler,
  nsXPTInterface::nsIClipboard,
  nsXPTInterface::nsIClipboard,
  nsXPTInterface::nsIConsoleService,
  nsXPTInterface::nsIPropertyBag2,
  nsXPTInterface::nsISystemInfo,
  nsXPTInterface::nsIThreadManager,
  nsXPTInterface::nsIUUIDGenerator,
  nsXPTInterface::nsIVersionComparator,
  nsXPTInterface::nsICategoryManager,
  nsXPTInterface::nsIObserverService,
  nsXPTInterface::nsIDirectoryService,
  nsXPTInterface::nsIProperties,
  nsXPTInterface::nsIEnvironment,
  nsXPTInterface::nsIAppShellService,
  nsXPTInterface::nsIWindowMediator,
  nsXPTInterface::nsIDOMStorageManager,
  nsXPTInterface::nsILocalStorageManager,
  nsXPTInterface::nsIQuotaManagerService,
  nsXPTInterface::nsIEventListenerService,
  nsXPTInterface::nsIFocusManager,
  nsXPTInterface::nsIScriptSecurityManager,
};

const StringOffset gComponentESModules[] = {
 { 0x139e } /* "chrome://remote/content/components/Marionette.sys.mjs" */,
 { 0x13d4 } /* "chrome://remote/content/components/RemoteAgent.sys.mjs" */,
 { 0x140b } /* "moz-src:///browser/components/mozcachedohttp/MozCachedOHTTPProtocolHandler.sys.mjs" */,
 { 0x145e } /* "moz-src:///browser/components/permissions/ContentPermissionPrompt.sys.mjs" */,
 { 0x14a8 } /* "moz-src:///dom/notification/NotificationStorage.sys.mjs" */,
 { 0x14e0 } /* "resource:///modules/AboutDebuggingRegistration.sys.mjs" */,
 { 0x1517 } /* "resource:///modules/AboutDevToolsToolboxRegistration.sys.mjs" */,
 { 0x1554 } /* "resource:///modules/AboutNewTabRedirector.sys.mjs" */,
 { 0x1586 } /* "resource:///modules/BrowserContentHandler.sys.mjs" */,
 { 0x15b8 } /* "resource:///modules/BrowserGlue.sys.mjs" */,
 { 0x15e0 } /* "resource:///modules/DevToolsStartup.sys.mjs" */,
 { 0x160c } /* "resource:///modules/ProfileMigrator.sys.mjs" */,
 { 0x1638 } /* "resource:///modules/PromptCollection.sys.mjs" */,
 { 0x1665 } /* "resource:///modules/StartupRecorder.sys.mjs" */,
 { 0x1691 } /* "resource:///modules/WebProtocolHandlerRegistrar.sys.mjs" */,
 { 0x16c9 } /* "resource:///modules/profiles/SelectableProfileService.sys.mjs" */,
 { 0x1707 } /* "resource:///modules/sessionstore/SessionStoreFunctions.sys.mjs" */,
 { 0x1746 } /* "resource:///modules/taskbartabs/TaskbarTabsCmd.sys.mjs" */,
 { 0x177d } /* "resource://devtools/client/jsonview/Converter.sys.mjs" */,
 { 0x17b3 } /* "resource://devtools/client/jsonview/Sniffer.sys.mjs" */,
 { 0x17e7 } /* "resource://gre/modules/AutoCompleteSimpleSearch.sys.mjs" */,
 { 0x181f } /* "resource://gre/modules/BTPRemoteExceptionList.sys.mjs" */,
 { 0x1855 } /* "resource://gre/modules/BackgroundTasksManager.sys.mjs" */,
 { 0x188b } /* "resource://gre/modules/CaptiveDetect.sys.mjs" */,
 { 0x18b8 } /* "resource://gre/modules/ClearBySiteEntry.sys.mjs" */,
 { 0x18e8 } /* "resource://gre/modules/ClearDataService.sys.mjs" */,
 { 0x1918 } /* "resource://gre/modules/ConsoleAPIStorage.sys.mjs" */,
 { 0x1949 } /* "resource://gre/modules/ContentAreaDropListener.sys.mjs" */,
 { 0x1980 } /* "resource://gre/modules/ContentDispatchChooser.sys.mjs" */,
 { 0x19b6 } /* "resource://gre/modules/ContentPrefService2.sys.mjs" */,
 { 0x19e9 } /* "resource://gre/modules/CookieBannerListService.sys.mjs" */,
 { 0x1a20 } /* "resource://gre/modules/CrashManager.sys.mjs" */,
 { 0x1a4c } /* "resource://gre/modules/CrashService.sys.mjs" */,
 { 0x1a78 } /* "resource://gre/modules/CredentialChooserService.sys.mjs" */,
 { 0x1ab0 } /* "resource://gre/modules/DefaultCLH.sys.mjs" */,
 { 0x1ada } /* "resource://gre/modules/DownloadLegacy.sys.mjs" */,
 { 0x1b08 } /* "resource://gre/modules/EnterprisePolicies.sys.mjs" */,
 { 0x1b3a } /* "resource://gre/modules/EssentialDomainsRemoteSettings.sys.mjs" */,
 { 0x1b78 } /* "resource://gre/modules/ExtHandlerService.sys.mjs" */,
 { 0x1ba9 } /* "resource://gre/modules/FingerprintingWebCompatService.sys.mjs" */,
 { 0x1be7 } /* "resource://gre/modules/FormHistoryAutoComplete.sys.mjs" */,
 { 0x1c1e } /* "resource://gre/modules/FormHistoryStartup.sys.mjs" */,
 { 0x1c50 } /* "resource://gre/modules/FxAccountsPush.sys.mjs" */,
 { 0x1c7e } /* "resource://gre/modules/HelperAppDlg.sys.mjs" */,
 { 0x1caa } /* "resource://gre/modules/IdentityCredentialPromptService.sys.mjs" */,
 { 0x1ce9 } /* "resource://gre/modules/LoginAutoComplete.sys.mjs" */,
 { 0x1d1a } /* "resource://gre/modules/LoginInfo.sys.mjs" */,
 { 0x1d43 } /* "resource://gre/modules/LoginManager.sys.mjs" */,
 { 0x1d6f } /* "resource://gre/modules/LoginManagerAuthPrompter.sys.mjs" */,
 { 0x1da7 } /* "resource://gre/modules/LoginManagerPrompter.sys.mjs" */,
 { 0x1ddb } /* "resource://gre/modules/MainProcessSingleton.sys.mjs" */,
 { 0x1e0f } /* "resource://gre/modules/MozProtocolHandler.sys.mjs" */,
 { 0x1e41 } /* "resource://gre/modules/NetworkErrorLogging.sys.mjs" */,
 { 0x1e74 } /* "resource://gre/modules/NetworkGeolocationProvider.sys.mjs" */,
 { 0x1eae } /* "resource://gre/modules/PageThumbsStorageService.sys.mjs" */,
 { 0x1ee6 } /* "resource://gre/modules/PartitioningExceptionListService.sys.mjs" */,
 { 0x1f26 } /* "resource://gre/modules/PlacesDBUtils.sys.mjs" */,
 { 0x1f53 } /* "resource://gre/modules/PlacesExpiration.sys.mjs" */,
 { 0x1f83 } /* "resource://gre/modules/PlacesFrecencyRecalculator.sys.mjs" */,
 { 0x1fbd } /* "resource://gre/modules/PlacesPreviews.sys.mjs" */,
 { 0x1feb } /* "resource://gre/modules/PrivateAttributionService.sys.mjs" */,
 { 0x2024 } /* "resource://gre/modules/ProcessSelector.sys.mjs" */,
 { 0x2053 } /* "resource://gre/modules/Prompter.sys.mjs" */,
 { 0x207b } /* "resource://gre/modules/PurgeTrackerService.sys.mjs" */,
 { 0x20ae } /* "resource://gre/modules/Push.sys.mjs" */,
 { 0x20d2 } /* "resource://gre/modules/PushComponents.sys.mjs" */,
 { 0x2100 } /* "resource://gre/modules/QuotaUtilsService.sys.mjs" */,
 { 0x2131 } /* "resource://gre/modules/RemotePermissionService.sys.mjs" */,
 { 0x2168 } /* "resource://gre/modules/SearchService.sys.mjs" */,
 { 0x2195 } /* "resource://gre/modules/SearchSuggestions.sys.mjs" */,
 { 0x21c6 } /* "resource://gre/modules/ShieldContentProcess.sys.mjs" */,
 { 0x21fa } /* "resource://gre/modules/SimpleServices.sys.mjs" */,
 { 0x2228 } /* "resource://gre/modules/SimpleURIUnknownSchemesRemoteObserver.sys.mjs" */,
 { 0x226d } /* "resource://gre/modules/SlowScriptDebug.sys.mjs" */,
 { 0x229c } /* "resource://gre/modules/TaggingService.sys.mjs" */,
 { 0x22ca } /* "resource://gre/modules/TelemetryControllerContent.sys.mjs" */,
 { 0x2304 } /* "resource://gre/modules/TelemetryStartup.sys.mjs" */,
 { 0x2334 } /* "resource://gre/modules/ThirdPartyCookieBlockingExceptionListService.sys.mjs" */,
 { 0x2380 } /* "resource://gre/modules/TooltipTextProvider.sys.mjs" */,
 { 0x23b3 } /* "resource://gre/modules/TrackingDBService.sys.mjs" */,
 { 0x23e4 } /* "resource://gre/modules/URIFixup.sys.mjs" */,
 { 0x240c } /* "resource://gre/modules/URLDecorationAnnotationsService.sys.mjs" */,
 { 0x244b } /* "resource://gre/modules/URLFormatter.sys.mjs" */,
 { 0x2477 } /* "resource://gre/modules/URLQueryStrippingListService.sys.mjs" */,
 { 0x24b3 } /* "resource://gre/modules/UpdateTimerManager.sys.mjs" */,
 { 0x24e5 } /* "resource://gre/modules/UrlClassifierExceptionListService.sys.mjs" */,
 { 0x2526 } /* "resource://gre/modules/UrlClassifierHashCompleter.sys.mjs" */,
 { 0x2560 } /* "resource://gre/modules/UrlClassifierLib.sys.mjs" */,
 { 0x2590 } /* "resource://gre/modules/UrlClassifierListManager.sys.mjs" */,
 { 0x25c8 } /* "resource://gre/modules/UrlClassifierRemoteSettingsService.sys.mjs" */,
 { 0x260a } /* "resource://gre/modules/UserCharacteristicsPageService.sys.mjs" */,
 { 0x2648 } /* "resource://gre/modules/WebHandlerApp.sys.mjs" */,
 { 0x2675 } /* "resource://gre/modules/WebVTTParserWrapper.sys.mjs" */,
 { 0x26a8 } /* "resource://gre/modules/WellKnownOpportunisticUtils.sys.mjs" */,
 { 0x26e3 } /* "resource://gre/modules/WindowsMediaFoundationCDMOriginsListService.sys.mjs" */,
 { 0x272e } /* "resource://gre/modules/XULStore.sys.mjs" */,
 { 0x2756 } /* "resource://gre/modules/amContentHandler.sys.mjs" */,
 { 0x2786 } /* "resource://gre/modules/amManager.sys.mjs" */,
 { 0x27af } /* "resource://gre/modules/amWebAPI.sys.mjs" */,
 { 0x27d7 } /* "resource://gre/modules/crypto-SDR.sys.mjs" */,
 { 0x2801 } /* "resource://gre/modules/media/PeerConnection.sys.mjs" */,
 { 0x2835 } /* "resource://gre/modules/mozIntl.sys.mjs" */,
 { 0x285c } /* "resource://gre/modules/nsAsyncShutdown.sys.mjs" */,
 { 0x288b } /* "resource://gre/modules/nsCrashMonitor.sys.mjs" */,
 { 0x28b9 } /* "resource://gre/modules/pdfjs.sys.mjs" */,
 { 0x28de } /* "resource://gre/modules/psm/ClientAuthDialogService.sys.mjs" */,
 { 0x2919 } /* "resource://services-settings/RemoteSettingsComponents.sys.mjs" */,
 { 0x2957 } /* "resource://services-sync/Weave.sys.mjs" */,
 { 0x297e } /* "resource://webcompat/AboutCompat.sys.mjs" */,
};

/**
 * Returns a nsCString corresponding to the given entry in the `gStrings` string
 * table. The resulting nsCString points directly to static storage, and does
 * not incur any memory allocation overhead.
 */
static inline nsCString GetString(const StringOffset& aOffset) {
  const char* str = &gStrings[aOffset.mOffset];
  nsCString result;
  result.AssignLiteral(str, strlen(str));
  return result;
}

nsCString ContractEntry::ContractID() const {
  return GetString(mContractID);
}

bool ContractEntry::Matches(const nsACString& aContractID) const {
  return aContractID == ContractID() && Module().Active();
}

static nsresult ConstructESModuleComponent(const nsACString& aURI,
                                      const char* aConstructor,
                                      nsISupports** aResult) {
  if (!nsComponentManagerImpl::JSLoaderReady()) {
    return NS_ERROR_NOT_AVAILABLE;
  }

  AutoJSAPI jsapi;
  MOZ_ALWAYS_TRUE(jsapi.Init(xpc::PrivilegedJunkScope()));
  JSContext* cx = jsapi.cx();

  JS::Rooted<JSObject*> exports(cx);
  MOZ_TRY(mozJSModuleLoader::Get()->ImportESModule(cx, aURI, &exports));

  JS::Rooted<JS::Value> ctor(cx);
  if (!JS_GetProperty(cx, exports, aConstructor, &ctor) ||
      !ctor.isObject()) {
    return NS_ERROR_XPC_JSOBJECT_HAS_NO_FUNCTION_NAMED;
  }

  JS::Rooted<JSObject*> inst(cx);
  if (!JS::Construct(cx, ctor, JS::HandleValueArray::empty(), &inst)) {
    return NS_ERROR_FAILURE;
  }

  return nsContentUtils::XPConnect()->WrapJS(cx, inst, NS_GET_IID(nsISupports),
                                             (void**)aResult);
}

const StaticModule gStaticModules[] = {
  
          /* Anonymous260 */ {
            /* {db82286d-d649-47fb-8599-ba31673a58c5} */
            { 0xdb82286d, 0xd649, 0x47fb, { 0x85, 0x99, 0xba, 0x31, 0x67, 0x3a, 0x58, 0xc5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous325 */ {
            /* {7beb3ba8-6ec3-41b4-b67c-da89b8518922} */
            { 0x7beb3ba8, 0x6ec3, 0x41b4, { 0xb6, 0x7c, 0xda, 0x89, 0xb8, 0x51, 0x89, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous024 */ {
            /* {56ebedd4-6ccf-48e8-bdae-adc77f044567} */
            { 0x56ebedd4, 0x6ccf, 0x48e8, { 0xbd, 0xae, 0xad, 0xc7, 0x7f, 0x04, 0x45, 0x67 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous357 */ {
            /* {f55f5d31-dbb7-4d0d-9f6f-a4f4cd8e8ef1} */
            { 0xf55f5d31, 0xdbb7, 0x4d0d, { 0x9f, 0x6f, 0xa4, 0xf4, 0xcd, 0x8e, 0x8e, 0xf1 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous302 */ {
            /* {895db6c7-dbdf-40ea-9f64-b175033243dc} */
            { 0x895db6c7, 0xdbdf, 0x40ea, { 0x9f, 0x64, 0xb1, 0x75, 0x03, 0x32, 0x43, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous342 */ {
            /* {8b5314bb-db01-11d2-96ce-0060b0fb9956} */
            { 0x8b5314bb, 0xdb01, 0x11d2, { 0x96, 0xce, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous441 */ {
            /* {e7c2aaf5-c11a-4954-9dbf-e28edec1fd91} */
            { 0xe7c2aaf5, 0xc11a, 0x4954, { 0x9d, 0xbf, 0xe2, 0x8e, 0xde, 0xc1, 0xfd, 0x91 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ServiceWorkerManager */ {
            /* {c74bde32-bcc7-4840-8430-c733351b212a} */
            { 0xc74bde32, 0xbcc7, 0x4840, { 0x84, 0x30, 0xc7, 0x33, 0x35, 0x1b, 0x21, 0x2a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous146 */ {
            /* {a181af0d-68b8-4308-94db-d4f859058215} */
            { 0xa181af0d, 0x68b8, 0x4308, { 0x94, 0xdb, 0xd4, 0xf8, 0x59, 0x05, 0x82, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous228 */ {
            /* {5874af6d-5719-4e1b-b155-ef4eae7fcb32} */
            { 0x5874af6d, 0x5719, 0x4e1b, { 0xb1, 0x55, 0xef, 0x4e, 0xae, 0x7f, 0xcb, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous426 */ {
            /* {38bd0634-0fd4-46f0-b85f-13ced889eeec} */
            { 0x38bd0634, 0xfd4, 0x46f0, { 0xb8, 0x5f, 0x13, 0xce, 0xd8, 0x89, 0xee, 0xec } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous366 */ {
            /* {68bf4793-5204-45cf-9ee2-69adffbc2e38} */
            { 0x68bf4793, 0x5204, 0x45cf, { 0x9e, 0xe2, 0x69, 0xad, 0xff, 0xbc, 0x2e, 0x38 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous102 */ {
            /* {245abae2-b947-4ded-a46d-9829d3cca462} */
            { 0x245abae2, 0xb947, 0x4ded, { 0xa4, 0x6d, 0x98, 0x29, 0xd3, 0xcc, 0xa4, 0x62 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UrlClassifierStreamUpdater */ {
            /* {e1797597-f4d6-4dd3-a1e1-745ad352cd80} */
            { 0xe1797597, 0xf4d6, 0x4dd3, { 0xa1, 0xe1, 0x74, 0x5a, 0xd3, 0x52, 0xcd, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* IdentityCredentialStorageService */ {
            /* {029823d0-0448-46c5-af1f-25cd4501d0d7} */
            { 0x29823d0, 0x448, 0x46c5, { 0xaf, 0x1f, 0x25, 0xcd, 0x45, 0x01, 0xd0, 0xd7 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous056 */ {
            /* {37f819b0-0b5c-11e3-8ffd-0800200c9a67} */
            { 0x37f819b0, 0xb5c, 0x11e3, { 0x8f, 0xfd, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x67 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous151 */ {
            /* {04445aa0-fd27-4c99-bd41-6be6318ae92c} */
            { 0x4445aa0, 0xfd27, 0x4c99, { 0xbd, 0x41, 0x6b, 0xe6, 0x31, 0x8a, 0xe9, 0x2c } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous089 */ {
            /* {38d1592e-b81e-432b-86f8-471878bbfe07} */
            { 0x38d1592e, 0xb81e, 0x432b, { 0x86, 0xf8, 0x47, 0x18, 0x78, 0xbb, 0xfe, 0x07 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous037 */ {
            /* {91fdaa4e-eba4-4ed3-831c-ce05c142822d} */
            { 0x91fdaa4e, 0xeba4, 0x4ed3, { 0x83, 0x1c, 0xce, 0x05, 0xc1, 0x42, 0x82, 0x2d } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous398 */ {
            /* {91775d60-d5dc-11d2-92fb-00e09805570f} */
            { 0x91775d60, 0xd5dc, 0x11d2, { 0x92, 0xfb, 0x00, 0xe0, 0x98, 0x05, 0x57, 0x0f } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous126 */ {
            /* {6ddb050c-0d04-11d4-986e-00c04fa0cf4a} */
            { 0x6ddb050c, 0xd04, 0x11d4, { 0x98, 0x6e, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous428 */ {
            /* {64e4bf03-773e-408e-939a-e11652fdfd28} */
            { 0x64e4bf03, 0x773e, 0x408e, { 0x93, 0x9a, 0xe1, 0x16, 0x52, 0xfd, 0xfd, 0x28 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous142 */ {
            /* {4abd60aa-6b7d-4f3b-bf52-d7ce8ae6dd36} */
            { 0x4abd60aa, 0x6b7d, 0x4f3b, { 0xbf, 0x52, 0xd7, 0xce, 0x8a, 0xe6, 0xdd, 0x36 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous355 */ {
            /* {8b5314bc-db01-11d2-96ce-0060b0fb9956} */
            { 0x8b5314bc, 0xdb01, 0x11d2, { 0x96, 0xce, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous460 */ {
            /* {abfbb785-5a44-49cf-88db-2f300bf727c9} */
            { 0xabfbb785, 0x5a44, 0x49cf, { 0x88, 0xdb, 0x2f, 0x30, 0x0b, 0xf7, 0x27, 0xc9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous438 */ {
            /* {bfcb82c2-5611-4318-90d6-baf4a7864252} */
            { 0xbfcb82c2, 0x5611, 0x4318, { 0x90, 0xd6, 0xba, 0xf4, 0xa7, 0x86, 0x42, 0x52 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous343 */ {
            /* {28be18ae-73ee-494f-8c6d-5d14b7c998c7} */
            { 0x28be18ae, 0x73ee, 0x494f, { 0x8c, 0x6d, 0x5d, 0x14, 0xb7, 0xc9, 0x98, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous010 */ {
            /* {38971986-c834-4f52-bf17-5123fbc9dde5} */
            { 0x38971986, 0xc834, 0x4f52, { 0xbf, 0x17, 0x51, 0x23, 0xfb, 0xc9, 0xdd, 0xe5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* URILoader */ {
            /* {9f6d5d40-90e7-11d3-af80-00a024ffc08c} */
            { 0x9f6d5d40, 0x90e7, 0x11d3, { 0xaf, 0x80, 0x00, 0xa0, 0x24, 0xff, 0xc0, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous264 */ {
            /* {6cc1a0a8-af97-4d41-9b4a-58dcec46ebce} */
            { 0x6cc1a0a8, 0xaf97, 0x4d41, { 0x9b, 0x4a, 0x58, 0xdc, 0xec, 0x46, 0xeb, 0xce } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous311 */ {
            /* {f376627f-0bbc-47b8-887e-fc92574cc91f} */
            { 0xf376627f, 0xbbc, 0x47b8, { 0x88, 0x7e, 0xfc, 0x92, 0x57, 0x4c, 0xc9, 0x1f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous250 */ {
            /* {e3f772f3-023f-4b32-b074-36cf0fd5d414} */
            { 0xe3f772f3, 0x23f, 0x4b32, { 0xb0, 0x74, 0x36, 0xcf, 0x0f, 0xd5, 0xd4, 0x14 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous103 */ {
            /* {19d9161b-a2a9-4518-b2c9-fcb8296d6dcd} */
            { 0x19d9161b, 0xa2a9, 0x4518, { 0xb2, 0xc9, 0xfc, 0xb8, 0x29, 0x6d, 0x6d, 0xcd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* PermissionManager */ {
            /* {4f6b5e00-0c36-11d5-a535-0010a401eb10} */
            { 0x4f6b5e00, 0xc36, 0x11d5, { 0xa5, 0x35, 0x00, 0x10, 0xa4, 0x01, 0xeb, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous433 */ {
            /* {e8ee88b0-5571-4086-a45b-39a716906bdb} */
            { 0xe8ee88b0, 0x5571, 0x4086, { 0xa4, 0x5b, 0x39, 0xa7, 0x16, 0x90, 0x6b, 0xdb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous072 */ {
            /* {b6f2f870-b0bc-4a1a-9c40-02cc171adb5b} */
            { 0xb6f2f870, 0xb0bc, 0x4a1a, { 0x9c, 0x40, 0x02, 0xcc, 0x17, 0x1a, 0xdb, 0x5b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous183 */ {
            /* {1ee0cc18-c968-4105-a895-bdea08e187eb} */
            { 0x1ee0cc18, 0xc968, 0x4105, { 0xa8, 0x95, 0xbd, 0xea, 0x08, 0xe1, 0x87, 0xeb } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous337 */ {
            /* {8b1ae382-51a9-4972-b930-56977a57919d} */
            { 0x8b1ae382, 0x51a9, 0x4972, { 0xb9, 0x30, 0x56, 0x97, 0x7a, 0x57, 0x91, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous086 */ {
            /* {13a5320c-4c91-4fa4-bd16-b081a3ba8c0b} */
            { 0x13a5320c, 0x4c91, 0x4fa4, { 0xbd, 0x16, 0xb0, 0x81, 0xa3, 0xba, 0x8c, 0x0b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous173 */ {
            /* {50d50ddf-f16a-4652-8705-936b19c3763b} */
            { 0x50d50ddf, 0xf16a, 0x4652, { 0x87, 0x05, 0x93, 0x6b, 0x19, 0xc3, 0x76, 0x3b } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous075 */ {
            /* {ebe8a51d-bd54-4838-b031-cd2289990e14} */
            { 0xebe8a51d, 0xbd54, 0x4838, { 0xb0, 0x31, 0xcd, 0x22, 0x89, 0x99, 0x0e, 0x14 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous002 */ {
            /* {5d0ce354-df01-421a-83fb-7ead0990c24e} */
            { 0x5d0ce354, 0xdf01, 0x421a, { 0x83, 0xfb, 0x7e, 0xad, 0x09, 0x90, 0xc2, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous422 */ {
            /* {3662958c-0e34-4f57-bc6d-2accdeb4342e} */
            { 0x3662958c, 0xe34, 0x4f57, { 0xbc, 0x6d, 0x2a, 0xcc, 0xde, 0xb4, 0x34, 0x2e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous303 */ {
            /* {23530265-31d1-4ee9-864c-c081975fb7bc} */
            { 0x23530265, 0x31d1, 0x4ee9, { 0x86, 0x4c, 0xc0, 0x81, 0x97, 0x5f, 0xb7, 0xbc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous076 */ {
            /* {07611dc6-bf4d-4d8a-a64b-f3a5904dddc7} */
            { 0x7611dc6, 0xbf4d, 0x4d8a, { 0xa6, 0x4b, 0xf3, 0xa5, 0x90, 0x4d, 0xdd, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous244 */ {
            /* {d9cd00ba-aa4d-47b1-8792-b1fe0cd35060} */
            { 0xd9cd00ba, 0xaa4d, 0x47b1, { 0x87, 0x92, 0xb1, 0xfe, 0x0c, 0xd3, 0x50, 0x60 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous187 */ {
            /* {b43b3f73-8160-4ab2-9f5d-4129a9708081} */
            { 0xb43b3f73, 0x8160, 0x4ab2, { 0x9f, 0x5d, 0x41, 0x29, 0xa9, 0x70, 0x80, 0x81 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous371 */ {
            /* {eb833911-4f49-4623-845f-e58a8e6de4c2} */
            { 0xeb833911, 0x4f49, 0x4623, { 0x84, 0x5f, 0xe5, 0x8a, 0x8e, 0x6d, 0xe4, 0xc2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous306 */ {
            /* {aa892eb4-ffbf-477d-9f9a-06c995ae9f27} */
            { 0xaa892eb4, 0xffbf, 0x477d, { 0x9f, 0x9a, 0x06, 0xc9, 0x95, 0xae, 0x9f, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous298 */ {
            /* {07f45442-1806-44be-9230-12eb79de9bac} */
            { 0x7f45442, 0x1806, 0x44be, { 0x92, 0x30, 0x12, 0xeb, 0x79, 0xde, 0x9b, 0xac } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous409 */ {
            /* {574ce83e-fe9f-4095-b85c-7909abbf7c37} */
            { 0x574ce83e, 0xfe9f, 0x4095, { 0xb8, 0x5c, 0x79, 0x09, 0xab, 0xbf, 0x7c, 0x37 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous220 */ {
            /* {74b89fb0-f200-4ae8-a3ec-dd164117f6de} */
            { 0x74b89fb0, 0xf200, 0x4ae8, { 0xa3, 0xec, 0xdd, 0x16, 0x41, 0x17, 0xf6, 0xde } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous160 */ {
            /* {275d800e-3f60-4896-adb7-d7f390ce0e42} */
            { 0x275d800e, 0x3f60, 0x4896, { 0xad, 0xb7, 0xd7, 0xf3, 0x90, 0xce, 0x0e, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous319 */ {
            /* {6f46b6f4-c8b1-4bd4-a4fa-9ebbed0753ea} */
            { 0x6f46b6f4, 0xc8b1, 0x4bd4, { 0xa4, 0xfa, 0x9e, 0xbb, 0xed, 0x07, 0x53, 0xea } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* ChromeRegistry */ {
            /* {47049e42-1d87-482a-984d-56ae185e367a} */
            { 0x47049e42, 0x1d87, 0x482a, { 0x98, 0x4d, 0x56, 0xae, 0x18, 0x5e, 0x36, 0x7a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous262 */ {
            /* {acb22042-2b6c-427b-b550-b9f407c6fff6} */
            { 0xacb22042, 0x2b6c, 0x427b, { 0xb5, 0x50, 0xb9, 0xf4, 0x07, 0xc6, 0xff, 0xf6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous038 */ {
            /* {b93af7a1-3411-44a8-bd0a-8af3dde4d8d8} */
            { 0xb93af7a1, 0x3411, 0x44a8, { 0xbd, 0x0a, 0x8a, 0xf3, 0xdd, 0xe4, 0xd8, 0xd8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous008 */ {
            /* {08ab87cc-95c2-4e67-885c-12bb7a146eea} */
            { 0x8ab87cc, 0x95c2, 0x4e67, { 0x88, 0x5c, 0x12, 0xbb, 0x7a, 0x14, 0x6e, 0xea } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous100 */ {
            /* {88e2fd0b-f7f4-480c-9483-7846b00e8dad} */
            { 0x88e2fd0b, 0xf7f4, 0x480c, { 0x94, 0x83, 0x78, 0x46, 0xb0, 0x0e, 0x8d, 0xad } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous167 */ {
            /* {56388dad-287b-4240-a785-85c394012503} */
            { 0x56388dad, 0x287b, 0x4240, { 0xa7, 0x85, 0x85, 0xc3, 0x94, 0x01, 0x25, 0x03 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous137 */ {
            /* {aea16cd0-f020-4138-b068-0716c4a15b5a} */
            { 0xaea16cd0, 0xf020, 0x4138, { 0xb0, 0x68, 0x07, 0x16, 0xc4, 0xa1, 0x5b, 0x5a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous159 */ {
            /* {78804a84-8173-42b6-bb94-789f0816a810} */
            { 0x78804a84, 0x8173, 0x42b6, { 0xbb, 0x94, 0x78, 0x9f, 0x08, 0x16, 0xa8, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* XULRuntime */ {
            /* {95d89e3e-a169-41a3-8e56-719978e15b12} */
            { 0x95d89e3e, 0xa169, 0x41a3, { 0x8e, 0x56, 0x71, 0x99, 0x78, 0xe1, 0x5b, 0x12 } },
            { 0x29a7 } /* "@mozilla.org/xre/app-info;1" */,
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous061 */ {
            /* {b986773e-2b30-4ed2-b8fe-6a96631c8000} */
            { 0xb986773e, 0x2b30, 0x4ed2, { 0xb8, 0xfe, 0x6a, 0x96, 0x63, 0x1c, 0x80, 0x00 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous251 */ {
            /* {eb1904db-e0d1-4760-a721-db76b1ca3e94} */
            { 0xeb1904db, 0xe0d1, 0x4760, { 0xa7, 0x21, 0xdb, 0x76, 0xb1, 0xca, 0x3e, 0x94 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous208 */ {
            /* {57972956-5718-42d2-8070-b3fc72212eaf} */
            { 0x57972956, 0x5718, 0x42d2, { 0x80, 0x70, 0xb3, 0xfc, 0x72, 0x21, 0x2e, 0xaf } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous376 */ {
            /* {aaf68860-f849-40ee-bb7a-b229bce036a3} */
            { 0xaaf68860, 0xf849, 0x40ee, { 0xbb, 0x7a, 0xb2, 0x29, 0xbc, 0xe0, 0x36, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UrlClassifierUtils */ {
            /* {b7b2ccec-7912-4ea6-a548-b038447004bd} */
            { 0xb7b2ccec, 0x7912, 0x4ea6, { 0xa5, 0x48, 0xb0, 0x38, 0x44, 0x70, 0x04, 0xbd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous336 */ {
            /* {220cc253-b60f-41f6-b9cf-fdcb325f970f} */
            { 0x220cc253, 0xb60f, 0x41f6, { 0xb9, 0xcf, 0xfd, 0xcb, 0x32, 0x5f, 0x97, 0x0f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous081 */ {
            /* {a6cf9115-15b3-11d2-932e-00805f8add32} */
            { 0xa6cf9115, 0x15b3, 0x11d2, { 0x93, 0x2e, 0x00, 0x80, 0x5f, 0x8a, 0xdd, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous263 */ {
            /* {98d0e975-9cad-4ce3-ae2f-f878b8be6307} */
            { 0x98d0e975, 0x9cad, 0x4ce3, { 0xae, 0x2f, 0xf8, 0x78, 0xb8, 0xbe, 0x63, 0x07 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous461 */ {
            /* {54e6b9d6-248c-4eb0-81b8-e72f04067f3c} */
            { 0x54e6b9d6, 0x248c, 0x4eb0, { 0x81, 0xb8, 0xe7, 0x2f, 0x04, 0x06, 0x7f, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous454 */ {
            /* {f68037ec-2790-44c5-8e5f-df5da58b93a7} */
            { 0xf68037ec, 0x2790, 0x44c5, { 0x8e, 0x5f, 0xdf, 0x5d, 0xa5, 0x8b, 0x93, 0xa7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous266 */ {
            /* {a9b28d1f-7e11-4c5f-85a0-4fd39db1f7c9} */
            { 0xa9b28d1f, 0x7e11, 0x4c5f, { 0x85, 0xa0, 0x4f, 0xd3, 0x9d, 0xb1, 0xf7, 0xc9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous435 */ {
            /* {7b121f7e-ebe4-43ab-9410-dc9087a1dba6} */
            { 0x7b121f7e, 0xebe4, 0x43ab, { 0x94, 0x10, 0xdc, 0x90, 0x87, 0xa1, 0xdb, 0xa6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous161 */ {
            /* {cf0f71fd-fafd-4e2b-9fdc-134d972e16e2} */
            { 0xcf0f71fd, 0xfafd, 0x4e2b, { 0x9f, 0xdc, 0x13, 0x4d, 0x97, 0x2e, 0x16, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous122 */ {
            /* {648705e9-757a-4d4b-a5bf-0248e512c309} */
            { 0x648705e9, 0x757a, 0x4d4b, { 0xa5, 0xbf, 0x02, 0x48, 0xe5, 0x12, 0xc3, 0x09 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous359 */ {
            /* {0ba77e04-2adb-422f-af01-5a57b8013100} */
            { 0xba77e04, 0x2adb, 0x422f, { 0xaf, 0x01, 0x5a, 0x57, 0xb8, 0x01, 0x31, 0x00 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* DNS */ {
            /* {b0ff4572-dae4-4bef-a092-83c1b88f6be9} */
            { 0xb0ff4572, 0xdae4, 0x4bef, { 0xa0, 0x92, 0x83, 0xc1, 0xb8, 0x8f, 0x6b, 0xe9 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous399 */ {
            /* {35c66fd1-95e9-4e0a-80c5-c3bd2b375481} */
            { 0x35c66fd1, 0x95e9, 0x4e0a, { 0x80, 0xc5, 0xc3, 0xbd, 0x2b, 0x37, 0x54, 0x81 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous088 */ {
            /* {ac2bb8fe-eeeb-4572-b40f-be03932b56e0} */
            { 0xac2bb8fe, 0xeeeb, 0x4572, { 0xb4, 0x0f, 0xbe, 0x03, 0x93, 0x2b, 0x56, 0xe0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous198 */ {
            /* {23ad3531-11d2-4e8e-805a-6a752e91681a} */
            { 0x23ad3531, 0x11d2, 0x4e8e, { 0x80, 0x5a, 0x6a, 0x75, 0x2e, 0x91, 0x68, 0x1a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* nsIContentAnalysis */ {
            /* {61497587-2bba-4a88-acd3-3fbb2cedf163} */
            { 0x61497587, 0x2bba, 0x4a88, { 0xac, 0xd3, 0x3f, 0xbb, 0x2c, 0xed, 0xf1, 0x63 } },
            { 0x29c3 } /* "@mozilla.org/contentanalysis;1" */,
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous416 */ {
            /* {fc886801-e768-11d4-9885-00c04fa0cf4b} */
            { 0xfc886801, 0xe768, 0x11d4, { 0x98, 0x85, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous238 */ {
            /* {f66bc334-1dd1-11b2-bab2-90e04fe15c19} */
            { 0xf66bc334, 0x1dd1, 0x11b2, { 0xba, 0xb2, 0x90, 0xe0, 0x4f, 0xe1, 0x5c, 0x19 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous219 */ {
            /* {5e756573-234a-49ea-bbe4-59ec7a70657d} */
            { 0x5e756573, 0x234a, 0x49ea, { 0xbb, 0xe4, 0x59, 0xec, 0x7a, 0x70, 0x65, 0x7d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous222 */ {
            /* {a6b2f8b0-7438-11ea-bc55-0242ac130003} */
            { 0xa6b2f8b0, 0x7438, 0x11ea, { 0xbc, 0x55, 0x02, 0x42, 0xac, 0x13, 0x00, 0x03 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous124 */ {
            /* {a62af1ba-79b3-4896-8aaf-b148bfce4280} */
            { 0xa62af1ba, 0x79b3, 0x4896, { 0x8a, 0xaf, 0xb1, 0x48, 0xbf, 0xce, 0x42, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous312 */ {
            /* {26a4a019-2827-4a89-a85c-5931a678823a} */
            { 0x26a4a019, 0x2827, 0x4a89, { 0xa8, 0x5c, 0x59, 0x31, 0xa6, 0x78, 0x82, 0x3a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous032 */ {
            /* {2dc08eaf-6eef-4394-b1df-a3a927c1290b} */
            { 0x2dc08eaf, 0x6eef, 0x4394, { 0xb1, 0xdf, 0xa3, 0xa9, 0x27, 0xc1, 0x29, 0x0b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous459 */ {
            /* {31689828-da66-49a6-870c-df62b83fe789} */
            { 0x31689828, 0xda66, 0x49a6, { 0x87, 0x0c, 0xdf, 0x62, 0xb8, 0x3f, 0xe7, 0x89 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous163 */ {
            /* {66230b2b-17fa-4bd3-abf4-07986151022d} */
            { 0x66230b2b, 0x17fa, 0x4bd3, { 0xab, 0xf4, 0x07, 0x98, 0x61, 0x51, 0x02, 0x2d } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous119 */ {
            /* {510a86bb-6019-4ed1-bb4f-965cffd23ece} */
            { 0x510a86bb, 0x6019, 0x4ed1, { 0xbb, 0x4f, 0x96, 0x5c, 0xff, 0xd2, 0x3e, 0xce } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous286 */ {
            /* {bbc23860-2553-479d-8b78-94d9038334f7} */
            { 0xbbc23860, 0x2553, 0x479d, { 0x8b, 0x78, 0x94, 0xd9, 0x03, 0x83, 0x34, 0xf7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous377 */ {
            /* {43ebf210-8a7b-4ddb-a83d-b87c51a058db} */
            { 0x43ebf210, 0x8a7b, 0x4ddb, { 0xa8, 0x3d, 0xb8, 0x7c, 0x51, 0xa0, 0x58, 0xdb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AddonContentPolicy */ {
            /* {c26a8241-ecf4-4aed-9f3c-f1f5c713b9a5} */
            { 0xc26a8241, 0xecf4, 0x4aed, { 0x9f, 0x3c, 0xf1, 0xf5, 0xc7, 0x13, 0xb9, 0xa5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* CacheStorage */ {
            /* {ea70b098-5014-4e21-aee1-75e6b2c4b8e0} */
            { 0xea70b098, 0x5014, 0x4e21, { 0xae, 0xe1, 0x75, 0xe6, 0xb2, 0xc4, 0xb8, 0xe0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous212 */ {
            /* {4ea60761-31d6-491d-9e34-4b53a26c416c} */
            { 0x4ea60761, 0x31d6, 0x491d, { 0x9e, 0x34, 0x4b, 0x53, 0xa2, 0x6c, 0x41, 0x6c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous189 */ {
            /* {b1f08d56-fca6-4290-9500-d5168dc9d8c3} */
            { 0xb1f08d56, 0xfca6, 0x4290, { 0x95, 0x00, 0xd5, 0x16, 0x8d, 0xc9, 0xd8, 0xc3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous257 */ {
            /* {58a4c579-d2dd-46b7-9c3b-6881a1c36c6a} */
            { 0x58a4c579, 0xd2dd, 0x46b7, { 0x9c, 0x3b, 0x68, 0x81, 0xa1, 0xc3, 0x6c, 0x6a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous131 */ {
            /* {3decd6c8-30ef-11d3-8cd0-0060b0fc14a3} */
            { 0x3decd6c8, 0x30ef, 0x11d3, { 0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous107 */ {
            /* {064d9cee-1dd2-11b2-83e3-d25ab0193c26} */
            { 0x64d9cee, 0x1dd2, 0x11b2, { 0x83, 0xe3, 0xd2, 0x5a, 0xb0, 0x19, 0x3c, 0x26 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* MimeHeaderParam */ {
            /* {1f4dbcf7-245c-4c8c-943d-8a1da0495e8a} */
            { 0x1f4dbcf7, 0x245c, 0x4c8c, { 0x94, 0x3d, 0x8a, 0x1d, 0xa0, 0x49, 0x5e, 0x8a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous155 */ {
            /* {4c39159c-cd90-4dd3-97a7-06af5e6d84c4} */
            { 0x4c39159c, 0xcd90, 0x4dd3, { 0x97, 0xa7, 0x06, 0xaf, 0x5e, 0x6d, 0x84, 0xc4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous420 */ {
            /* {8d2f40b2-4875-4c95-97d9-3f7dca2cb460} */
            { 0x8d2f40b2, 0x4875, 0x4c95, { 0x97, 0xd9, 0x3f, 0x7d, 0xca, 0x2c, 0xb4, 0x60 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous285 */ {
            /* {88cecbb7-6c63-4b3b-8cd4-84f3b8228c69} */
            { 0x88cecbb7, 0x6c63, 0x4b3b, { 0x8c, 0xd4, 0x84, 0xf3, 0xb8, 0x22, 0x8c, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous313 */ {
            /* {ca168834-cc00-48f9-b83c-fd018e58cae3} */
            { 0xca168834, 0xcc00, 0x48f9, { 0xb8, 0x3c, 0xfd, 0x01, 0x8e, 0x58, 0xca, 0xe3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* FileProtocolHandler */ {
            /* {fbc81170-1f69-11d3-9344-00104ba0fd40} */
            { 0xfbc81170, 0x1f69, 0x11d3, { 0x93, 0x44, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ApplicationReputation */ {
            /* {d21b4c33-716f-4117-8041-2770b59ff8a6} */
            { 0xd21b4c33, 0x716f, 0x4117, { 0x80, 0x41, 0x27, 0x70, 0xb5, 0x9f, 0xf8, 0xa6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous134 */ {
            /* {9e3b6c90-2f75-11d3-8cd0-0060b0fc14a3} */
            { 0x9e3b6c90, 0x2f75, 0x11d3, { 0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous014 */ {
            /* {974fe39b-4584-4cb5-bf62-5c141aedc557} */
            { 0x974fe39b, 0x4584, 0x4cb5, { 0xbf, 0x62, 0x5c, 0x14, 0x1a, 0xed, 0xc5, 0x57 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous041 */ {
            /* {bdc2e533-b308-4708-ac8e-a8bfade6d851} */
            { 0xbdc2e533, 0xb308, 0x4708, { 0xac, 0x8e, 0xa8, 0xbf, 0xad, 0xe6, 0xd8, 0x51 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous036 */ {
            /* {1a26a7b7-d06e-4f45-8b45-d7ad60f7a9ab} */
            { 0x1a26a7b7, 0xd06e, 0x4f45, { 0x8b, 0x45, 0xd7, 0xad, 0x60, 0xf7, 0xa9, 0xab } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous254 */ {
            /* {c887b6a9-a5eb-4566-a440-bebaea3e54fd} */
            { 0xc887b6a9, 0xa5eb, 0x4566, { 0xa4, 0x40, 0xbe, 0xba, 0xea, 0x3e, 0x54, 0xfd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous445 */ {
            /* {daf1461b-bf29-4f88-8d0e-4bcdf332c862} */
            { 0xdaf1461b, 0xbf29, 0x4f88, { 0x8d, 0x0e, 0x4b, 0xcd, 0xf3, 0x32, 0xc8, 0x62 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous213 */ {
            /* {9676cfc4-6e84-11ec-a30d-d3cd0af86e01} */
            { 0x9676cfc4, 0x6e84, 0x11ec, { 0xa3, 0x0d, 0xd3, 0xcd, 0x0a, 0xf8, 0x6e, 0x01 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous074 */ {
            /* {77da64d3-7458-4920-9491-86cc9914f904} */
            { 0x77da64d3, 0x7458, 0x4920, { 0x94, 0x91, 0x86, 0xcc, 0x99, 0x14, 0xf9, 0x04 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous411 */ {
            /* {48118355-e9a5-4452-ab18-59cc426fb817} */
            { 0x48118355, 0xe9a5, 0x4452, { 0xab, 0x18, 0x59, 0xcc, 0x42, 0x6f, 0xb8, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous269 */ {
            /* {b43c96be-2b3a-4dc4-90e9-b06d34219b68} */
            { 0xb43c96be, 0x2b3a, 0x4dc4, { 0x90, 0xe9, 0xb0, 0x6d, 0x34, 0x21, 0x9b, 0x68 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous391 */ {
            /* {acf8dc48-4a25-11d3-9890-006008962422} */
            { 0xacf8dc48, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous053 */ {
            /* {e7d52d9e-c148-47d8-ab2a-95d7f40ea53d} */
            { 0xe7d52d9e, 0xc148, 0x47d8, { 0xab, 0x2a, 0x95, 0xd7, 0xf4, 0x0e, 0xa5, 0x3d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous046 */ {
            /* {7293e901-2be3-4c02-b4bd-cbef6fc24f78} */
            { 0x7293e901, 0x2be3, 0x4c02, { 0xb4, 0xbd, 0xcb, 0xef, 0x6f, 0xc2, 0x4f, 0x78 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous341 */ {
            /* {11a77259-9d16-4386-8ac8-94338ee22f78} */
            { 0x11a77259, 0x9d16, 0x4386, { 0x8a, 0xc8, 0x94, 0x33, 0x8e, 0xe2, 0x2f, 0x78 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous079 */ {
            /* {56c778e4-1bee-45f3-a689-886692a97fe7} */
            { 0x56c778e4, 0x1bee, 0x45f3, { 0xa6, 0x89, 0x88, 0x66, 0x92, 0xa9, 0x7f, 0xe7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous462 */ {
            /* {7090524d-5574-4492-a77f-d8d558ced59d} */
            { 0x7090524d, 0x5574, 0x4492, { 0xa7, 0x7f, 0xd8, 0xd5, 0x58, 0xce, 0xd5, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous279 */ {
            /* {c47ff942-9678-44a5-bc9b-05e0d676c79c} */
            { 0xc47ff942, 0x9678, 0x44a5, { 0xbc, 0x9b, 0x05, 0xe0, 0xd6, 0x76, 0xc7, 0x9c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous240 */ {
            /* {15686f9d-483e-4361-98cd-37f1e8f1e61d} */
            { 0x15686f9d, 0x483e, 0x4361, { 0x98, 0xcd, 0x37, 0xf1, 0xe8, 0xf1, 0xe6, 0x1d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous200 */ {
            /* {b084a2ce-1dd1-11b2-bf10-8324f8e065cc} */
            { 0xb084a2ce, 0x1dd1, 0x11b2, { 0xbf, 0x10, 0x83, 0x24, 0xf8, 0xe0, 0x65, 0xcc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous332 */ {
            /* {5573967d-f6cf-4c63-8e0e-9ac06e04d62b} */
            { 0x5573967d, 0xf6cf, 0x4c63, { 0x8e, 0x0e, 0x9a, 0xc0, 0x6e, 0x04, 0xd6, 0x2b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous133 */ {
            /* {7fa5237d-b0eb-438f-9e50-ca0166e63788} */
            { 0x7fa5237d, 0xb0eb, 0x438f, { 0x9e, 0x50, 0xca, 0x01, 0x66, 0xe6, 0x37, 0x88 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous129 */ {
            /* {58a1c31c-1dd2-11b2-a3f6-d36949d48268} */
            { 0x58a1c31c, 0x1dd2, 0x11b2, { 0xa3, 0xf6, 0xd3, 0x69, 0x49, 0xd4, 0x82, 0x68 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* PrivateAttribution */ {
            /* {57d16147-1deb-46ac-8f1c-1140b5e1ddfd} */
            { 0x57d16147, 0x1deb, 0x46ac, { 0x8f, 0x1c, 0x11, 0x40, 0xb5, 0xe1, 0xdd, 0xfd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous140 */ {
            /* {1423e739-782c-4081-b5d8-fe6fba68c0ef} */
            { 0x1423e739, 0x782c, 0x4081, { 0xb5, 0xd8, 0xfe, 0x6f, 0xba, 0x68, 0xc0, 0xef } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous077 */ {
            /* {a4b1b3b1-b68a-4129-aa2f-eb086162a8c7} */
            { 0xa4b1b3b1, 0xb68a, 0x4129, { 0xaa, 0x2f, 0xeb, 0x08, 0x61, 0x62, 0xa8, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous378 */ {
            /* {669a9795-6ff7-4ed4-9150-c34ce2971b63} */
            { 0x669a9795, 0x6ff7, 0x4ed4, { 0x91, 0x50, 0xc3, 0x4c, 0xe2, 0x97, 0x1b, 0x63 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous116 */ {
            /* {9226888e-da08-11d3-8cda-0060b0fc14a3} */
            { 0x9226888e, 0xda08, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous323 */ {
            /* {867d65a0-9784-4496-9a2e-f168f960f7c7} */
            { 0x867d65a0, 0x9784, 0x4496, { 0x9a, 0x2e, 0xf1, 0x68, 0xf9, 0x60, 0xf7, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous130 */ {
            /* {2693457e-3ba5-4455-991f-5350946adb12} */
            { 0x2693457e, 0x3ba5, 0x4455, { 0x99, 0x1f, 0x53, 0x50, 0x94, 0x6a, 0xdb, 0x12 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous358 */ {
            /* {77221d5a-1dd2-11b2-8c69-c710f15d2ed5} */
            { 0x77221d5a, 0x1dd2, 0x11b2, { 0x8c, 0x69, 0xc7, 0x10, 0xf1, 0x5d, 0x2e, 0xd5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ScriptSecurityManager */ {
            /* {7ee2a4c0-4b93-17d3-ba18-0060b0f199a2} */
            { 0x7ee2a4c0, 0x4b93, 0x17d3, { 0xba, 0x18, 0x00, 0x60, 0xb0, 0xf1, 0x99, 0xa2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous259 */ {
            /* {49e8d8ef-a713-492a-a3d2-5c9dad4ce2e5} */
            { 0x49e8d8ef, 0xa713, 0x492a, { 0xa3, 0xd2, 0x5c, 0x9d, 0xad, 0x4c, 0xe2, 0xe5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous382 */ {
            /* {cbf86870-4ac0-11d3-baea-00805f8a5dd7} */
            { 0xcbf86870, 0x4ac0, 0x11d3, { 0xba, 0xea, 0x00, 0x80, 0x5f, 0x8a, 0x5d, 0xd7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous051 */ {
            /* {74b2122d-65a8-4824-aa9e-3d664cb75dc2} */
            { 0x74b2122d, 0x65a8, 0x4824, { 0xaa, 0x9e, 0x3d, 0x66, 0x4c, 0xb7, 0x5d, 0xc2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* CORSPreflightCache */ {
            /* {e764a6ec-4eff-45e8-9241-024521d9413f} */
            { 0xe764a6ec, 0x4eff, 0x45e8, { 0x92, 0x41, 0x02, 0x45, 0x21, 0xd9, 0x41, 0x3f } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous127 */ {
            /* {ccd0e960-7947-4635-b70e-4c661b63d675} */
            { 0xccd0e960, 0x7947, 0x4635, { 0xb7, 0x0e, 0x4c, 0x66, 0x1b, 0x63, 0xd6, 0x75 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous368 */ {
            /* {86c37b9a-74e7-4672-844e-6e7dd83ba484} */
            { 0x86c37b9a, 0x74e7, 0x4672, { 0x84, 0x4e, 0x6e, 0x7d, 0xd8, 0x3b, 0xa4, 0x84 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UrlClassifierPrefixSet */ {
            /* {3d8579f0-75fa-4e00-ba41-38661d5b5d17} */
            { 0x3d8579f0, 0x75fa, 0x4e00, { 0xba, 0x41, 0x38, 0x66, 0x1d, 0x5b, 0x5d, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous392 */ {
            /* {acf8dc44-4a25-11d3-9890-006008962422} */
            { 0xacf8dc44, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous353 */ {
            /* {948a0023-e3a7-11d2-96cf-0060b0fb9956} */
            { 0x948a0023, 0xe3a7, 0x11d2, { 0x96, 0xcf, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous293 */ {
            /* {0636a680-45cb-11e4-916c-0800200c9a66} */
            { 0x636a680, 0x45cb, 0x11e4, { 0x91, 0x6c, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous284 */ {
            /* {9de95a0c-39a4-4d64-9a53-17940dd7cabb} */
            { 0x9de95a0c, 0x39a4, 0x4d64, { 0x9a, 0x53, 0x17, 0x94, 0x0d, 0xd7, 0xca, 0xbb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous096 */ {
            /* {ff8780a5-bbb1-4bc5-8ee7-057e7bc5c925} */
            { 0xff8780a5, 0xbbb1, 0x4bc5, { 0x8e, 0xe7, 0x05, 0x7e, 0x7b, 0xc5, 0xc9, 0x25 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* IDN */ {
            /* {62b778a6-bce3-456b-8c31-2865fbb68c91} */
            { 0x62b778a6, 0xbce3, 0x456b, { 0x8c, 0x31, 0x28, 0x65, 0xfb, 0xb6, 0x8c, 0x91 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous369 */ {
            /* {61ba33c0-3031-11d3-8cd0-0060b0fc14a3} */
            { 0x61ba33c0, 0x3031, 0x11d3, { 0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous356 */ {
            /* {e221df9b-3d66-4045-9a66-5720949f8d10} */
            { 0xe221df9b, 0x3d66, 0x4045, { 0x9a, 0x66, 0x57, 0x20, 0x94, 0x9f, 0x8d, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous421 */ {
            /* {4812ff32-1bff-423b-97fc-40a5696dad22} */
            { 0x4812ff32, 0x1bff, 0x423b, { 0x97, 0xfc, 0x40, 0xa5, 0x69, 0x6d, 0xad, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous407 */ {
            /* {0099907d-123c-4853-a46a-43098b5fb68c} */
            { 0x99907d, 0x123c, 0x4853, { 0xa4, 0x6a, 0x43, 0x09, 0x8b, 0x5f, 0xb6, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous171 */ {
            /* {de9472d0-8034-11d3-9399-00104ba0fd40} */
            { 0xde9472d0, 0x8034, 0x11d3, { 0x93, 0x99, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous388 */ {
            /* {acf8dc49-4a25-11d3-9890-006008962422} */
            { 0xacf8dc49, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous025 */ {
            /* {95790842-75a0-430d-98bf-f5ce3788ea6d} */
            { 0x95790842, 0x75a0, 0x430d, { 0x98, 0xbf, 0xf5, 0xce, 0x37, 0x88, 0xea, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous095 */ {
            /* {2bc2ad62-ad5d-4b7b-a9db-f74ae203c527} */
            { 0x2bc2ad62, 0xad5d, 0x4b7b, { 0xa9, 0xdb, 0xf7, 0x4a, 0xe2, 0x03, 0xc5, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous106 */ {
            /* {430d416c-a722-4ad1-be98-d9a445f85e3f} */
            { 0x430d416c, 0xa722, 0x4ad1, { 0xbe, 0x98, 0xd9, 0xa4, 0x45, 0xf8, 0x5e, 0x3f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous049 */ {
            /* {4fff5d46-d827-4cd4-a970-8fd53977440e} */
            { 0x4fff5d46, 0xd827, 0x4cd4, { 0xa9, 0x70, 0x8f, 0xd5, 0x39, 0x77, 0x44, 0x0e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous390 */ {
            /* {acf8dc47-4a25-11d3-9890-006008962422} */
            { 0xacf8dc47, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous069 */ {
            /* {cde1d019-fad8-4044-b141-65fb4fb7a245} */
            { 0xcde1d019, 0xfad8, 0x4044, { 0xb1, 0x41, 0x65, 0xfb, 0x4f, 0xb7, 0xa2, 0x45 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous023 */ {
            /* {33d75835-722f-42c0-89cc-44f328e56a86} */
            { 0x33d75835, 0x722f, 0x42c0, { 0x89, 0xcc, 0x44, 0xf3, 0x28, 0xe5, 0x6a, 0x86 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* GfxInfo */ {
            /* {d755a760-9f27-11df-0800-200c9a664242} */
            { 0xd755a760, 0x9f27, 0x11df, { 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66, 0x42, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_PROCESS,
          },
  
          /* Anonymous245 */ {
            /* {c8d0b0b3-17f8-458b-9264-7b67b288fe79} */
            { 0xc8d0b0b3, 0x17f8, 0x458b, { 0x92, 0x64, 0x7b, 0x67, 0xb2, 0x88, 0xfe, 0x79 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous386 */ {
            /* {acf8dc4c-4a25-11d3-9890-006008962422} */
            { 0xacf8dc4c, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous158 */ {
            /* {ff41913b-546a-4bff-9201-dc9b2c032eba} */
            { 0xff41913b, 0x546a, 0x4bff, { 0x92, 0x01, 0xdc, 0x9b, 0x2c, 0x03, 0x2e, 0xba } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous439 */ {
            /* {0e3afd3d-eb60-4c2b-963b-56d7c439f124} */
            { 0xe3afd3d, 0xeb60, 0x4c2b, { 0x96, 0x3b, 0x56, 0xd7, 0xc4, 0x39, 0xf1, 0x24 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous115 */ {
            /* {a2027ec6-ba0d-4c72-805d-148233f5f33c} */
            { 0xa2027ec6, 0xba0d, 0x4c72, { 0x80, 0x5d, 0x14, 0x82, 0x33, 0xf5, 0xf3, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous283 */ {
            /* {984e3259-9266-49cf-b605-60b022a00756} */
            { 0x984e3259, 0x9266, 0x49cf, { 0xb6, 0x05, 0x60, 0xb0, 0x22, 0xa0, 0x07, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous186 */ {
            /* {b4f96c89-5238-450c-8bda-e12c26f1d150} */
            { 0xb4f96c89, 0x5238, 0x450c, { 0x8b, 0xda, 0xe1, 0x2c, 0x26, 0xf1, 0xd1, 0x50 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous255 */ {
            /* {d9d75e86-8f17-4c57-993e-f738f0d86d42} */
            { 0xd9d75e86, 0x8f17, 0x4c57, { 0x99, 0x3e, 0xf7, 0x38, 0xf0, 0xd8, 0x6d, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous401 */ {
            /* {e4a0ee4e-0775-457b-9118-b3ae97a7c758} */
            { 0xe4a0ee4e, 0x775, 0x457b, { 0x91, 0x18, 0xb3, 0xae, 0x97, 0xa7, 0xc7, 0x58 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous405 */ {
            /* {5ff24248-1dd2-11b2-8427-fbab44f29bc8} */
            { 0x5ff24248, 0x1dd2, 0x11b2, { 0x84, 0x27, 0xfb, 0xab, 0x44, 0xf2, 0x9b, 0xc8 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_SOCKET_AND_UTILITY_PROCESS,
          },
  
          /* SocketTransport */ {
            /* {ad56b25f-e6bb-4db3-9f7b-5b7db33fd2b1} */
            { 0xad56b25f, 0xe6bb, 0x4db3, { 0x9f, 0x7b, 0x5b, 0x7d, 0xb3, 0x3f, 0xd2, 0xb1 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous194 */ {
            /* {807535bf-018e-4300-b8d3-4a6405fb9f65} */
            { 0x807535bf, 0x18e, 0x4300, { 0xb8, 0xd3, 0x4a, 0x64, 0x05, 0xfb, 0x9f, 0x65 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous063 */ {
            /* {49a02241-7e48-477a-9345-9f246925dcb3} */
            { 0x49a02241, 0x7e48, 0x477a, { 0x93, 0x45, 0x9f, 0x24, 0x69, 0x25, 0xdc, 0xb3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* DownloadPlatform */ {
            /* {649a14c9-fe5c-48ec-9c85-00cad9ccf32e} */
            { 0x649a14c9, 0xfe5c, 0x48ec, { 0x9c, 0x85, 0x00, 0xca, 0xd9, 0xcc, 0xf3, 0x2e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous078 */ {
            /* {ba5bc4c6-1dd1-11b2-bb89-b844c6ec0339} */
            { 0xba5bc4c6, 0x1dd1, 0x11b2, { 0xbb, 0x89, 0xb8, 0x44, 0xc6, 0xec, 0x03, 0x39 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous028 */ {
            /* {f30bc0a2-958b-4287-bf62-ce38ba0c811e} */
            { 0xf30bc0a2, 0x958b, 0x4287, { 0xbf, 0x62, 0xce, 0x38, 0xba, 0x0c, 0x81, 0x1e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous362 */ {
            /* {06beec76-a183-4d9f-85dd-085f26da565a} */
            { 0x6beec76, 0xa183, 0x4d9f, { 0x85, 0xdd, 0x08, 0x5f, 0x26, 0xda, 0x56, 0x5a } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous164 */ {
            /* {7584ce90-5b25-11d3-a175-0050041caf44} */
            { 0x7584ce90, 0x5b25, 0x11d3, { 0xa1, 0x75, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* IdentityCredentialPromptService */ {
            /* {936007db-a957-4f1d-a23d-f7d9403223e6} */
            { 0x936007db, 0xa957, 0x4f1d, { 0xa2, 0x3d, 0xf7, 0xd9, 0x40, 0x32, 0x23, 0xe6 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous027 */ {
            /* {bc0017e3-2438-47be-a567-41db58f17627} */
            { 0xbc0017e3, 0x2438, 0x47be, { 0xa5, 0x67, 0x41, 0xdb, 0x58, 0xf1, 0x76, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous344 */ {
            /* {bd57cee8-1dd1-11b2-9fe7-95cf4709aea3} */
            { 0xbd57cee8, 0x1dd1, 0x11b2, { 0x9f, 0xe7, 0x95, 0xcf, 0x47, 0x09, 0xae, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous195 */ {
            /* {8f685a9d-8181-46d6-a71d-869289099c6d} */
            { 0x8f685a9d, 0x8181, 0x46d6, { 0xa7, 0x1d, 0x86, 0x92, 0x89, 0x09, 0x9c, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous040 */ {
            /* {3e43ee93-829e-4ea6-a34e-62d9e4c9f993} */
            { 0x3e43ee93, 0x829e, 0x4ea6, { 0xa3, 0x4e, 0x62, 0xd9, 0xe4, 0xc9, 0xf9, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* StreamConverter */ {
            /* {892ffeb0-3f80-11d3-a16c-0050041caf44} */
            { 0x892ffeb0, 0x3f80, 0x11d3, { 0xa1, 0x6c, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous082 */ {
            /* {c1354898-e3fe-4602-88a7-c4520c21cb4e} */
            { 0xc1354898, 0xe3fe, 0x4602, { 0x88, 0xa7, 0xc4, 0x52, 0x0c, 0x21, 0xcb, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous380 */ {
            /* {acf8dc4a-4a25-11d3-9890-006008962422} */
            { 0xacf8dc4a, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous365 */ {
            /* {cb6cdb94-e417-4601-b4a5-f991bf41453d} */
            { 0xcb6cdb94, 0xe417, 0x4601, { 0xb4, 0xa5, 0xf9, 0x91, 0xbf, 0x41, 0x45, 0x3d } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_SOCKET_AND_UTILITY_PROCESS,
          },
  
          /* Anonymous068 */ {
            /* {18c2e238-3a0a-4153-89fc-166b3b1465a1} */
            { 0x18c2e238, 0x3a0a, 0x4153, { 0x89, 0xfc, 0x16, 0x6b, 0x3b, 0x14, 0x65, 0xa1 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_AND_SOCKET_PROCESS,
          },
  
          /* Anonymous033 */ {
            /* {e740ddb4-18b4-4aac-8ae1-9b0f4320769d} */
            { 0xe740ddb4, 0x18b4, 0x4aac, { 0x8a, 0xe1, 0x9b, 0x0f, 0x43, 0x20, 0x76, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* DBusHandlerApp */ {
            /* {6c3c274b-4cbf-4bb5-a635-05ad2cbb6535} */
            { 0x6c3c274b, 0x4cbf, 0x4bb5, { 0xa6, 0x35, 0x05, 0xad, 0x2c, 0xbb, 0x65, 0x35 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous437 */ {
            /* {130b016f-fad7-4526-bc7f-827dabf79265} */
            { 0x130b016f, 0xfad7, 0x4526, { 0xbc, 0x7f, 0x82, 0x7d, 0xab, 0xf7, 0x92, 0x65 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous408 */ {
            /* {79a2b7cc-f05b-4605-bfa0-fac54f27eec8} */
            { 0x79a2b7cc, 0xf05b, 0x4605, { 0xbf, 0xa0, 0xfa, 0xc5, 0x4f, 0x27, 0xee, 0xc8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous417 */ {
            /* {0ddf4df8-4dbb-4133-8b79-9afb966514f5} */
            { 0xddf4df8, 0x4dbb, 0x4133, { 0x8b, 0x79, 0x9a, 0xfb, 0x96, 0x65, 0x14, 0xf5 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous052 */ {
            /* {8817b1cf-5ada-43bf-bd73-607657703d0d} */
            { 0x8817b1cf, 0x5ada, 0x43bf, { 0xbd, 0x73, 0x60, 0x76, 0x57, 0x70, 0x3d, 0x0d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous381 */ {
            /* {cbf86871-4ac0-11d3-baea-00805f8a5dd7} */
            { 0xcbf86871, 0x4ac0, 0x11d3, { 0xba, 0xea, 0x00, 0x80, 0x5f, 0x8a, 0x5d, 0xd7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous197 */ {
            /* {518e071f-1dd2-11b2-937e-c45f14def778} */
            { 0x518e071f, 0x1dd2, 0x11b2, { 0x93, 0x7e, 0xc4, 0x5f, 0x14, 0xde, 0xf7, 0x78 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous050 */ {
            /* {d974b814-8fde-411c-8c45-b86791b81030} */
            { 0xd974b814, 0x8fde, 0x411c, { 0x8c, 0x45, 0xb8, 0x67, 0x91, 0xb8, 0x10, 0x30 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous318 */ {
            /* {742ad274-34c5-43d1-a8b7-293eaf8962d6} */
            { 0x742ad274, 0x34c5, 0x43d1, { 0xa8, 0xb7, 0x29, 0x3e, 0xaf, 0x89, 0x62, 0xd6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous277 */ {
            /* {0f2f347c-1e4f-40cc-8efd-792dea70a85e} */
            { 0xf2f347c, 0x1e4f, 0x40cc, { 0x8e, 0xfd, 0x79, 0x2d, 0xea, 0x70, 0xa8, 0x5e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous011 */ {
            /* {7913837c-9623-11ea-bb37-0242ac130002} */
            { 0x7913837c, 0x9623, 0x11ea, { 0xbb, 0x37, 0x02, 0x42, 0xac, 0x13, 0x00, 0x02 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous101 */ {
            /* {c7e410d4-85f2-11d3-9f63-006008a6efe9} */
            { 0xc7e410d4, 0x85f2, 0x11d3, { 0x9f, 0x63, 0x00, 0x60, 0x08, 0xa6, 0xef, 0xe9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous431 */ {
            /* {62ec8731-55ad-4246-b2ea-f26c1fe19d2d} */
            { 0x62ec8731, 0x55ad, 0x4246, { 0xb2, 0xea, 0xf2, 0x6c, 0x1f, 0xe1, 0x9d, 0x2d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous185 */ {
            /* {ee706783-3af8-4d19-9e84-e2ebfe213480} */
            { 0xee706783, 0x3af8, 0x4d19, { 0x9e, 0x84, 0xe2, 0xeb, 0xfe, 0x21, 0x34, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous138 */ {
            /* {450a2b55-620a-44b3-9f67-839b3b0c329c} */
            { 0x450a2b55, 0x620a, 0x44b3, { 0x9f, 0x67, 0x83, 0x9b, 0x3b, 0x0c, 0x32, 0x9c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Dashboard */ {
            /* {c79eb3c6-091a-45a6-8544-5a8d1ab79537} */
            { 0xc79eb3c6, 0x91a, 0x45a6, { 0x85, 0x44, 0x5a, 0x8d, 0x1a, 0xb7, 0x95, 0x37 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* IO */ {
            /* {9ac9e770-18bc-11d3-9337-00104ba0fd40} */
            { 0x9ac9e770, 0x18bc, 0x11d3, { 0x93, 0x37, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous215 */ {
            /* {d7d2490d-2640-411b-9f09-a538803c11ee} */
            { 0xd7d2490d, 0x2640, 0x411b, { 0x9f, 0x09, 0xa5, 0x38, 0x80, 0x3c, 0x11, 0xee } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous017 */ {
            /* {d8c9acee-dec5-11e4-8c75-1681e6b88ec1} */
            { 0xd8c9acee, 0xdec5, 0x11e4, { 0x8c, 0x75, 0x16, 0x81, 0xe6, 0xb8, 0x8e, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous148 */ {
            /* {2ec62893-3b35-48fa-ab1d-5e68a9f45f08} */
            { 0x2ec62893, 0x3b35, 0x48fa, { 0xab, 0x1d, 0x5e, 0x68, 0xa9, 0xf4, 0x5f, 0x08 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous300 */ {
            /* {ce3e9659-e311-49fb-b18b-7f27c6659b23} */
            { 0xce3e9659, 0xe311, 0x49fb, { 0xb1, 0x8b, 0x7f, 0x27, 0xc6, 0x65, 0x9b, 0x23 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous104 */ {
            /* {608b7f6f-4b60-40d6-87ed-d933bf53d8c1} */
            { 0x608b7f6f, 0x4b60, 0x40d6, { 0x87, 0xed, 0xd9, 0x33, 0xbf, 0x53, 0xd8, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous135 */ {
            /* {b6ed3030-6183-11d3-a178-0050041caf44} */
            { 0xb6ed3030, 0x6183, 0x11d3, { 0xa1, 0x78, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous229 */ {
            /* {90d1fd17-2018-4e16-b73c-a04a26fa6dd4} */
            { 0x90d1fd17, 0x2018, 0x4e16, { 0xb7, 0x3c, 0xa0, 0x4a, 0x26, 0xfa, 0x6d, 0xd4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous299 */ {
            /* {e7b1da06-2594-4670-aea4-131070baca4c} */
            { 0xe7b1da06, 0x2594, 0x4670, { 0xae, 0xa4, 0x13, 0x10, 0x70, 0xba, 0xca, 0x4c } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous071 */ {
            /* {3e65d9b5-5b41-4c18-ac7b-681b9df9df97} */
            { 0x3e65d9b5, 0x5b41, 0x4c18, { 0xac, 0x7b, 0x68, 0x1b, 0x9d, 0xf9, 0xdf, 0x97 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* NetworkErrorLogging */ {
            /* {ce24d145-19f5-43ed-a0d1-09385850b1cc} */
            { 0xce24d145, 0x19f5, 0x43ed, { 0xa0, 0xd1, 0x09, 0x38, 0x58, 0x50, 0xb1, 0xcc } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous214 */ {
            /* {71b49926-fd4e-43e2-ab8d-d9b049413c0b} */
            { 0x71b49926, 0xfd4e, 0x43e2, { 0xab, 0x8d, 0xd9, 0xb0, 0x49, 0x41, 0x3c, 0x0b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous270 */ {
            /* {35ec195a-e8d0-4300-83af-c8a2cc84b4a3} */
            { 0x35ec195a, 0xe8d0, 0x4300, { 0x83, 0xaf, 0xc8, 0xa2, 0xcc, 0x84, 0xb4, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous147 */ {
            /* {d6ef593d-a429-4b14-a887-d9e2f765d9ed} */
            { 0xd6ef593d, 0xa429, 0x4b14, { 0xa8, 0x87, 0xd9, 0xe2, 0xf7, 0x65, 0xd9, 0xed } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous248 */ {
            /* {6ebc941a-f2ff-4d56-b3b6-f7d0b9d73344} */
            { 0x6ebc941a, 0xf2ff, 0x4d56, { 0xb3, 0xb6, 0xf7, 0xd0, 0xb9, 0xd7, 0x33, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous112 */ {
            /* {6eae857e-4ba9-11e3-9b39-b4036188709b} */
            { 0x6eae857e, 0x4ba9, 0x11e3, { 0x9b, 0x39, 0xb4, 0x03, 0x61, 0x88, 0x70, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous003 */ {
            /* {47cd0651-b1be-4a0f-b5c4-10e5a573ef71} */
            { 0x47cd0651, 0xb1be, 0x4a0f, { 0xb5, 0xc4, 0x10, 0xe5, 0xa5, 0x73, 0xef, 0x71 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous012 */ {
            /* {efbd7b87-9b15-4684-abf0-dc2679daadb1} */
            { 0xefbd7b87, 0x9b15, 0x4684, { 0xab, 0xf0, 0xdc, 0x26, 0x79, 0xda, 0xad, 0xb1 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous375 */ {
            /* {7b4eeb20-d781-11d4-8a83-0010a4e0c9ca} */
            { 0x7b4eeb20, 0xd781, 0x11d4, { 0x8a, 0x83, 0x00, 0x10, 0xa4, 0xe0, 0xc9, 0xca } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous196 */ {
            /* {786a1369-dca5-4adc-8486-33d23c88010a} */
            { 0x786a1369, 0xdca5, 0x4adc, { 0x84, 0x86, 0x33, 0xd2, 0x3c, 0x88, 0x01, 0x0a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous174 */ {
            /* {e0da1d70-2f7b-11d3-8cd0-0060b0fc14a3} */
            { 0xe0da1d70, 0x2f7b, 0x11d3, { 0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous291 */ {
            /* {7d47b41d-7cc5-4882-b293-d8f3f3b48b46} */
            { 0x7d47b41d, 0x7cc5, 0x4882, { 0xb2, 0x93, 0xd8, 0xf3, 0xf3, 0xb4, 0x8b, 0x46 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* TypeAheadFind */ {
            /* {e7f70966-9a37-48d7-8aeb-35998f31090e} */
            { 0xe7f70966, 0x9a37, 0x48d7, { 0x8a, 0xeb, 0x35, 0x99, 0x8f, 0x31, 0x09, 0x0e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous295 */ {
            /* {1c978d25-b37f-43a8-a2d6-0c7a239ead87} */
            { 0x1c978d25, 0xb37f, 0x43a8, { 0xa2, 0xd6, 0x0c, 0x7a, 0x23, 0x9e, 0xad, 0x87 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous114 */ {
            /* {208de7fc-a781-4031-bbae-cc0de539f61a} */
            { 0x208de7fc, 0xa781, 0x4031, { 0xbb, 0xae, 0xcc, 0x0d, 0xe5, 0x39, 0xf6, 0x1a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous326 */ {
            /* {e35d5067-95bc-4029-8432-e8f1e431148d} */
            { 0xe35d5067, 0x95bc, 0x4029, { 0x84, 0x32, 0xe8, 0xf1, 0xe4, 0x31, 0x14, 0x8d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous413 */ {
            /* {bbe50ef2-80eb-469d-b70d-02858275389f} */
            { 0xbbe50ef2, 0x80eb, 0x469d, { 0xb7, 0x0d, 0x02, 0x85, 0x82, 0x75, 0x38, 0x9f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous157 */ {
            /* {c9f74572-7b8e-4fec-bb4a-03c0d3021bd6} */
            { 0xc9f74572, 0x7b8e, 0x4fec, { 0xbb, 0x4a, 0x03, 0xc0, 0xd3, 0x02, 0x1b, 0xd6 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* ProtocolProxy */ {
            /* {e9b301c0-e0e4-11d3-a1a8-0050041caf44} */
            { 0xe9b301c0, 0xe0e4, 0x11d3, { 0xa1, 0xa8, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous370 */ {
            /* {678c50b8-6bcb-4ad0-b9b8-c81175955199} */
            { 0x678c50b8, 0x6bcb, 0x4ad0, { 0xb9, 0xb8, 0xc8, 0x11, 0x75, 0x95, 0x51, 0x99 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous414 */ {
            /* {f5475c51-59a7-4757-b3d9-e211a9410872} */
            { 0xf5475c51, 0x59a7, 0x4757, { 0xb3, 0xd9, 0xe2, 0x11, 0xa9, 0x41, 0x08, 0x72 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous085 */ {
            /* {3d8fa16d-c9e1-4b50-bdef-2c7ae249967a} */
            { 0x3d8fa16d, 0xc9e1, 0x4b50, { 0xbd, 0xef, 0x2c, 0x7a, 0xe2, 0x49, 0x96, 0x7a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous330 */ {
            /* {471f4944-1dd2-11b2-87ac-90be0a51d609} */
            { 0x471f4944, 0x1dd2, 0x11b2, { 0x87, 0xac, 0x90, 0xbe, 0x0a, 0x51, 0xd6, 0x09 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous273 */ {
            /* {cb9e0de8-3598-4ed7-857b-827f011ad5d8} */
            { 0xcb9e0de8, 0x3598, 0x4ed7, { 0x85, 0x7b, 0x82, 0x7f, 0x01, 0x1a, 0xd5, 0xd8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous087 */ {
            /* {92ae3ab2-8968-41b1-8709-b6123bceaf21} */
            { 0x92ae3ab2, 0x8968, 0x41b1, { 0x87, 0x09, 0xb6, 0x12, 0x3b, 0xce, 0xaf, 0x21 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* HttpActivityDistributor */ {
            /* {15629ada-a41c-4a09-961f-6553cd60b1a2} */
            { 0x15629ada, 0xa41c, 0x4a09, { 0x96, 0x1f, 0x65, 0x53, 0xcd, 0x60, 0xb1, 0xa2 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous099 */ {
            /* {929814d6-1dd2-11b2-8e08-82fa0a339b00} */
            { 0x929814d6, 0x1dd2, 0x11b2, { 0x8e, 0x08, 0x82, 0xfa, 0x0a, 0x33, 0x9b, 0x00 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous168 */ {
            /* {9c4e9d49-ce64-4ca3-acef-3075c5e5aba7} */
            { 0x9c4e9d49, 0xce64, 0x4ca3, { 0xac, 0xef, 0x30, 0x75, 0xc5, 0xe5, 0xab, 0xa7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous267 */ {
            /* {3fdd6c28-5b87-4e3e-8b57-8e83c23c1a6d} */
            { 0x3fdd6c28, 0x5b87, 0x4e3e, { 0x8b, 0x57, 0x8e, 0x83, 0xc2, 0x3c, 0x1a, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous327 */ {
            /* {e3a1f3c9-3ae1-4b40-a5e0-7b457fc9a9ad} */
            { 0xe3a1f3c9, 0x3ae1, 0x4b40, { 0xa5, 0xe0, 0x7b, 0x45, 0x7f, 0xc9, 0xa9, 0xad } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous162 */ {
            /* {7d7008a0-c49a-11d3-9b22-0080c7cb1080} */
            { 0x7d7008a0, 0xc49a, 0x11d3, { 0x9b, 0x22, 0x00, 0x80, 0xc7, 0xcb, 0x10, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous083 */ {
            /* {f6fcd651-164b-4416-b001-9c8c393fd93b} */
            { 0xf6fcd651, 0x164b, 0x4416, { 0xb0, 0x01, 0x9c, 0x8c, 0x39, 0x3f, 0xd9, 0x3b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous121 */ {
            /* {c272fee0-c7e9-11d3-8cda-0060b0fc14a3} */
            { 0xc272fee0, 0xc7e9, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous204 */ {
            /* {36a1d3b3-d886-4317-96ff-87b0005cfef7} */
            { 0x36a1d3b3, 0xd886, 0x4317, { 0x96, 0xff, 0x87, 0xb0, 0x00, 0x5c, 0xfe, 0xf7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous113 */ {
            /* {62147d1e-ef6a-40e8-aaf8-d039f5caaa81} */
            { 0x62147d1e, 0xef6a, 0x40e8, { 0xaa, 0xf8, 0xd0, 0x39, 0xf5, 0xca, 0xaa, 0x81 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous177 */ {
            /* {4ce234f1-52e8-47a9-8c8d-b02f815733c7} */
            { 0x4ce234f1, 0x52e8, 0x47a9, { 0x8c, 0x8d, 0xb0, 0x2f, 0x81, 0x57, 0x33, 0xc7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous241 */ {
            /* {6356aa16-7916-4215-a825-cbc2692ca87a} */
            { 0x6356aa16, 0x7916, 0x4215, { 0xa8, 0x25, 0xcb, 0xc2, 0x69, 0x2c, 0xa8, 0x7a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* CaptivePortal */ {
            /* {bdbe0555-fc3d-4f7b-9205-c309ceb2d641} */
            { 0xbdbe0555, 0xfc3d, 0x4f7b, { 0x92, 0x05, 0xc3, 0x09, 0xce, 0xb2, 0xd6, 0x41 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous400 */ {
            /* {565e3a2c-1dd2-11b2-8da1-b4cef17e568d} */
            { 0x565e3a2c, 0x1dd2, 0x11b2, { 0x8d, 0xa1, 0xb4, 0xce, 0xf1, 0x7e, 0x56, 0x8d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous136 */ {
            /* {dccbe7e4-7750-466b-a557-5ea36c8ff24e} */
            { 0xdccbe7e4, 0x7750, 0x466b, { 0xa5, 0x57, 0x5e, 0xa3, 0x6c, 0x8f, 0xf2, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous406 */ {
            /* {d39a8904-2e09-4a3a-a273-c3bec7db2bfe} */
            { 0xd39a8904, 0x2e09, 0x4a3a, { 0xa2, 0x73, 0xc3, 0xbe, 0xc7, 0xdb, 0x2b, 0xfe } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous223 */ {
            /* {bbbb1d61-438f-4436-92ed-8308e5830fb0} */
            { 0xbbbb1d61, 0x438f, 0x4436, { 0x92, 0xed, 0x83, 0x08, 0xe5, 0x83, 0x0f, 0xb0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous048 */ {
            /* {0fb47c47-a205-4583-a9fc-cbadf8c95880} */
            { 0xfb47c47, 0xa205, 0x4583, { 0xa9, 0xfc, 0xcb, 0xad, 0xf8, 0xc9, 0x58, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous182 */ {
            /* {72da39cc-0b9b-4fff-8ff9-d3b9a41d0dc4} */
            { 0x72da39cc, 0xb9b, 0x4fff, { 0x8f, 0xf9, 0xd3, 0xb9, 0xa4, 0x1d, 0x0d, 0xc4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous346 */ {
            /* {c401eb80-f9ea-11d3-bb6f-e732b73ebe7c} */
            { 0xc401eb80, 0xf9ea, 0x11d3, { 0xbb, 0x6f, 0xe7, 0x32, 0xb7, 0x3e, 0xbe, 0x7c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous006 */ {
            /* {6f8bb968-c14f-4d6f-9733-6c6737b35dce} */
            { 0x6f8bb968, 0xc14f, 0x4d6f, { 0x97, 0x33, 0x6c, 0x67, 0x37, 0xb3, 0x5d, 0xce } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous339 */ {
            /* {c0ed2a75-96f8-4166-91d4-2fe8774448dc} */
            { 0xc0ed2a75, 0x96f8, 0x4166, { 0x91, 0xd4, 0x2f, 0xe8, 0x77, 0x44, 0x48, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous029 */ {
            /* {a7f800e0-4306-11d4-98d0-001083010e9b} */
            { 0xa7f800e0, 0x4306, 0x11d4, { 0x98, 0xd0, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous340 */ {
            /* {0f872c8c-3ee6-46bd-92a2-69652c6b474e} */
            { 0xf872c8c, 0x3ee6, 0x46bd, { 0x92, 0xa2, 0x69, 0x65, 0x2c, 0x6b, 0x47, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous209 */ {
            /* {4fe082ae-6ff0-4b41-b24f-eaa664f6e46a} */
            { 0x4fe082ae, 0x6ff0, 0x4b41, { 0xb2, 0x4f, 0xea, 0xa6, 0x64, 0xf6, 0xe4, 0x6a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous247 */ {
            /* {e50161b0-3a69-4ec0-add9-6480850b8a98} */
            { 0xe50161b0, 0x3a69, 0x4ec0, { 0xad, 0xd9, 0x64, 0x80, 0x85, 0x0b, 0x8a, 0x98 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous176 */ {
            /* {e1676f84-e6e5-45d0-a4bf-d9905efc5b2e} */
            { 0xe1676f84, 0xe6e5, 0x45d0, { 0xa4, 0xbf, 0xd9, 0x90, 0x5e, 0xfc, 0x5b, 0x2e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous001 */ {
            /* {63c7b9f4-0cc8-43f8-b666-0a661655cb73} */
            { 0x63c7b9f4, 0xcc8, 0x43f8, { 0xb6, 0x66, 0x0a, 0x66, 0x16, 0x55, 0xcb, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* FindService */ {
            /* {5060b803-340e-11d5-be5b-b3e063ec6a3c} */
            { 0x5060b803, 0x340e, 0x11d5, { 0xbe, 0x5b, 0xb3, 0xe0, 0x63, 0xec, 0x6a, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous144 */ {
            /* {dc01db59-a513-4c90-824b-085cce06c0aa} */
            { 0xdc01db59, 0xa513, 0x4c90, { 0x82, 0x4b, 0x08, 0x5c, 0xce, 0x06, 0xc0, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous415 */ {
            /* {fe0ff7c3-8e97-448b-9a8a-86afdb9fbbb6} */
            { 0xfe0ff7c3, 0x8e97, 0x448b, { 0x9a, 0x8a, 0x86, 0xaf, 0xdb, 0x9f, 0xbb, 0xb6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous217 */ {
            /* {5118a6f9-2493-4f97-9552-620663e03cb3} */
            { 0x5118a6f9, 0x2493, 0x4f97, { 0x95, 0x52, 0x62, 0x06, 0x63, 0xe0, 0x3c, 0xb3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous243 */ {
            /* {2e59cc70-f83a-412f-89d4-453885837217} */
            { 0x2e59cc70, 0xf83a, 0x412f, { 0x89, 0xd4, 0x45, 0x38, 0x85, 0x83, 0x72, 0x17 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* NSSErrors */ {
            /* {9ef18451-a157-4d17-8132-47afef213689} */
            { 0x9ef18451, 0xa157, 0x4d17, { 0x81, 0x32, 0x47, 0xaf, 0xef, 0x21, 0x36, 0x89 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous383 */ {
            /* {a99febba-1dd1-11b2-a943-b02334a6d083} */
            { 0xa99febba, 0x1dd1, 0x11b2, { 0xa9, 0x43, 0xb0, 0x23, 0x34, 0xa6, 0xd0, 0x83 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous022 */ {
            /* {11342911-3135-45a8-8d71-737a2b0ad469} */
            { 0x11342911, 0x3135, 0x45a8, { 0x8d, 0x71, 0x73, 0x7a, 0x2b, 0x0a, 0xd4, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous066 */ {
            /* {cccd665f-edf3-41fc-ab9b-fc55b37340aa} */
            { 0xcccd665f, 0xedf3, 0x41fc, { 0xab, 0x9b, 0xfc, 0x55, 0xb3, 0x73, 0x40, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* StringBundle */ {
            /* {d85a17c1-aa7c-11d2-9b8c-00805f8a16d9} */
            { 0xd85a17c1, 0xaa7c, 0x11d2, { 0x9b, 0x8c, 0x00, 0x80, 0x5f, 0x8a, 0x16, 0xd9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous317 */ {
            /* {ded150e3-c92e-4077-a396-0dba9953e39f} */
            { 0xded150e3, 0xc92e, 0x4077, { 0xa3, 0x96, 0x0d, 0xba, 0x99, 0x53, 0xe3, 0x9f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous216 */ {
            /* {5516303d-9007-45a0-94b9-940ef134a6e2} */
            { 0x5516303d, 0x9007, 0x45a0, { 0x94, 0xb9, 0x94, 0x0e, 0xf1, 0x34, 0xa6, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous013 */ {
            /* {45ce6b2d-ffc8-4051-bb41-37ceeeb19e94} */
            { 0x45ce6b2d, 0xffc8, 0x4051, { 0xbb, 0x41, 0x37, 0xce, 0xee, 0xb1, 0x9e, 0x94 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous345 */ {
            /* {40fd47f2-463a-4e4a-a33f-27eb148bfee4} */
            { 0x40fd47f2, 0x463a, 0x4e4a, { 0xa3, 0x3f, 0x27, 0xeb, 0x14, 0x8b, 0xfe, 0xe4 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous360 */ {
            /* {6987230e-0098-4e78-bc5f-1493ee7519fa} */
            { 0x6987230e, 0x98, 0x4e78, { 0xbc, 0x5f, 0x14, 0x93, 0xee, 0x75, 0x19, 0xfa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous282 */ {
            /* {e8b8bdb7-c96c-4d82-9c6f-2b3c585ec7ea} */
            { 0xe8b8bdb7, 0xc96c, 0x4d82, { 0x9c, 0x6f, 0x2b, 0x3c, 0x58, 0x5e, 0xc7, 0xea } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous280 */ {
            /* {dc185a77-ba88-4caa-8f16-465253f7599a} */
            { 0xdc185a77, 0xba88, 0x4caa, { 0x8f, 0x16, 0x46, 0x52, 0x53, 0xf7, 0x59, 0x9a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UUIDGenerator */ {
            /* {706d36bb-bf79-4293-81f2-8f6828c18f9d} */
            { 0x706d36bb, 0xbf79, 0x4293, { 0x81, 0xf2, 0x8f, 0x68, 0x28, 0xc1, 0x8f, 0x9d } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous111 */ {
            /* {e746a8b1-c97a-4fc5-baa4-66607521bd08} */
            { 0xe746a8b1, 0xc97a, 0x4fc5, { 0xba, 0xa4, 0x66, 0x60, 0x75, 0x21, 0xbd, 0x08 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous261 */ {
            /* {8a9a1406-d700-4221-8615-1d84b0d213fb} */
            { 0x8a9a1406, 0xd700, 0x4221, { 0x86, 0x15, 0x1d, 0x84, 0xb0, 0xd2, 0x13, 0xfb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous055 */ {
            /* {37f819b0-0b5c-11e3-8ffd-0800200c9a66} */
            { 0x37f819b0, 0xb5c, 0x11e3, { 0x8f, 0xfd, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous348 */ {
            /* {2d96b3df-c051-11d1-a827-0040959a28c9} */
            { 0x2d96b3df, 0xc051, 0x11d1, { 0xa8, 0x27, 0x00, 0x40, 0x95, 0x9a, 0x28, 0xc9 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous092 */ {
            /* {1460df3b-774c-4205-8349-838e507c3ef9} */
            { 0x1460df3b, 0x774c, 0x4205, { 0x83, 0x49, 0x83, 0x8e, 0x50, 0x7c, 0x3e, 0xf9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous288 */ {
            /* {705a423f-2f69-42f3-b9fe-1517e0dee56f} */
            { 0x705a423f, 0x2f69, 0x42f3, { 0xb9, 0xfe, 0x15, 0x17, 0xe0, 0xde, 0xe5, 0x6f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous005 */ {
            /* {11c095b2-e42e-4bdf-9dd0-aed87595f6a4} */
            { 0x11c095b2, 0xe42e, 0x4bdf, { 0x9d, 0xd0, 0xae, 0xd8, 0x75, 0x95, 0xf6, 0xa4 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous418 */ {
            /* {3b55e72e-ab7e-431b-89c0-3b06a8b14016} */
            { 0x3b55e72e, 0xab7e, 0x431b, { 0x89, 0xc0, 0x3b, 0x06, 0xa8, 0xb1, 0x40, 0x16 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous361 */ {
            /* {d3f69889-e13a-4321-980c-a39332e21f34} */
            { 0xd3f69889, 0xe13a, 0x4321, { 0x98, 0x0c, 0xa3, 0x93, 0x32, 0xe2, 0x1f, 0x34 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* CredentialChooserService */ {
            /* {673ddc19-03e2-4b30-a868-06297e8fed89} */
            { 0x673ddc19, 0x3e2, 0x4b30, { 0xa8, 0x68, 0x06, 0x29, 0x7e, 0x8f, 0xed, 0x89 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous329 */ {
            /* {0fa3158c-d5a7-43de-9181-a285e74cf1d4} */
            { 0xfa3158c, 0xd5a7, 0x43de, { 0x91, 0x81, 0xa2, 0x85, 0xe7, 0x4c, 0xf1, 0xd4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous117 */ {
            /* {9868b4ce-da08-11d3-8cda-0060b0fc14a3} */
            { 0x9868b4ce, 0xda08, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous294 */ {
            /* {79a13656-a472-4713-b0e1-ab39a15cf790} */
            { 0x79a13656, 0xa472, 0x4713, { 0xb0, 0xe1, 0xab, 0x39, 0xa1, 0x5c, 0xf7, 0x90 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous246 */ {
            /* {0c06583d-7dd8-4293-b1a5-912205f779aa} */
            { 0xc06583d, 0x7dd8, 0x4293, { 0xb1, 0xa5, 0x91, 0x22, 0x05, 0xf7, 0x79, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous227 */ {
            /* {3c9c43b6-09eb-4ed2-9b87-e29f4221eef0} */
            { 0x3c9c43b6, 0x9eb, 0x4ed2, { 0x9b, 0x87, 0xe2, 0x9f, 0x42, 0x21, 0xee, 0xf0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous226 */ {
            /* {f8319188-1992-4c16-a581-c06a950b01bf} */
            { 0xf8319188, 0x1992, 0x4c16, { 0xa5, 0x81, 0xc0, 0x6a, 0x95, 0x0b, 0x01, 0xbf } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous397 */ {
            /* {dfac10a9-dd24-43cf-a095-6ffa2e4b6a6c} */
            { 0xdfac10a9, 0xdd24, 0x43cf, { 0xa0, 0x95, 0x6f, 0xfa, 0x2e, 0x4b, 0x6a, 0x6c } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_AND_UTILITY_PROCESS,
          },
  
          /* Anonymous225 */ {
            /* {06f13674-fb28-4dfc-bf25-342c83705b2f} */
            { 0x6f13674, 0xfb28, 0x4dfc, { 0xbf, 0x25, 0x34, 0x2c, 0x83, 0x70, 0x5b, 0x2f } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous232 */ {
            /* {afff16f0-3fd2-4153-9ccd-c6d9abd879e4} */
            { 0xafff16f0, 0x3fd2, 0x4153, { 0x9c, 0xcd, 0xc6, 0xd9, 0xab, 0xd8, 0x79, 0xe4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous035 */ {
            /* {b43964aa-a078-44b2-b06b-fd4d1b172e66} */
            { 0xb43964aa, 0xa078, 0x44b2, { 0xb0, 0x6b, 0xfd, 0x4d, 0x1b, 0x17, 0x2e, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous211 */ {
            /* {f64432b9-e8c6-41b4-b2da-8eb004344bba} */
            { 0xf64432b9, 0xe8c6, 0x41b4, { 0xb2, 0xda, 0x8e, 0xb0, 0x04, 0x34, 0x4b, 0xba } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous350 */ {
            /* {a9339876-0027-430f-b953-84c9c11c2da3} */
            { 0xa9339876, 0x27, 0x430f, { 0xb9, 0x53, 0x84, 0xc9, 0xc1, 0x1c, 0x2d, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous203 */ {
            /* {1dbc6eb6-0972-4bdb-9dc4-acd0abf72369} */
            { 0x1dbc6eb6, 0x972, 0x4bdb, { 0x9d, 0xc4, 0xac, 0xd0, 0xab, 0xf7, 0x23, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous047 */ {
            /* {7fe6e18b-0da3-4056-bf3b-440ef3809e06} */
            { 0x7fe6e18b, 0xda3, 0x4056, { 0xbf, 0x3b, 0x44, 0x0e, 0xf3, 0x80, 0x9e, 0x06 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* PlacesPreviewsHelper */ {
            /* {bd0a4d3b-ff26-4d4d-9a62-a513e1c1bf92} */
            { 0xbd0a4d3b, 0xff26, 0x4d4d, { 0x9a, 0x62, 0xa5, 0x13, 0xe1, 0xc1, 0xbf, 0x92 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous224 */ {
            /* {3b667ee0-d2da-4ccc-9c3d-95f2ca6a8b4c} */
            { 0x3b667ee0, 0xd2da, 0x4ccc, { 0x9c, 0x3d, 0x95, 0xf2, 0xca, 0x6a, 0x8b, 0x4c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* StreamTransport */ {
            /* {0885d4f8-f7b8-4cda-902e-94ba38bc256e} */
            { 0x885d4f8, 0xf7b8, 0x4cda, { 0x90, 0x2e, 0x94, 0xba, 0x38, 0xbc, 0x25, 0x6e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous105 */ {
            /* {461cd5dd-73c6-47a4-8cc3-603b37d84a61} */
            { 0x461cd5dd, 0x73c6, 0x47a4, { 0x8c, 0xc3, 0x60, 0x3b, 0x37, 0xd8, 0x4a, 0x61 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous429 */ {
            /* {5a75c25a-5e7e-4d90-8f7c-07eb15cc0aa8} */
            { 0x5a75c25a, 0x5e7e, 0x4d90, { 0x8f, 0x7c, 0x07, 0xeb, 0x15, 0xcc, 0x0a, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous193 */ {
            /* {8753a413-3ed6-4a61-a1dc-b31a7e69b796} */
            { 0x8753a413, 0x3ed6, 0x4a61, { 0xa1, 0xdc, 0xb3, 0x1a, 0x7e, 0x69, 0xb7, 0x96 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous016 */ {
            /* {4148c488-dca1-49fc-a621-2a0097a62422} */
            { 0x4148c488, 0xdca1, 0x49fc, { 0xa6, 0x21, 0x2a, 0x00, 0x97, 0xa6, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous373 */ {
            /* {00bd71fb-7f09-4ec3-96af-a0b522b77969} */
            { 0xbd71fb, 0x7f09, 0x4ec3, { 0x96, 0xaf, 0xa0, 0xb5, 0x22, 0xb7, 0x79, 0x69 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous154 */ {
            /* {9879908a-2972-40c0-890b-a91dd7dfb954} */
            { 0x9879908a, 0x2972, 0x40c0, { 0x89, 0x0b, 0xa9, 0x1d, 0xd7, 0xdf, 0xb9, 0x54 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous271 */ {
            /* {47a45e5f-691e-4799-8686-14f8d3fc0f8c} */
            { 0x47a45e5f, 0x691e, 0x4799, { 0x86, 0x86, 0x14, 0xf8, 0xd3, 0xfc, 0x0f, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous057 */ {
            /* {c1faff54-7ca2-424e-b36f-3c6020b578e7} */
            { 0xc1faff54, 0x7ca2, 0x424e, { 0xb3, 0x6f, 0x3c, 0x60, 0x20, 0xb5, 0x78, 0xe7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous423 */ {
            /* {c9da865e-c3d7-4aa1-a271-0f571f013c30} */
            { 0xc9da865e, 0xc3d7, 0x4aa1, { 0xa2, 0x71, 0x0f, 0x57, 0x1f, 0x01, 0x3c, 0x30 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous175 */ {
            /* {c375fa80-150f-11d6-a618-0010a401eb10} */
            { 0xc375fa80, 0x150f, 0x11d6, { 0xa6, 0x18, 0x00, 0x10, 0xa4, 0x01, 0xeb, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Directory */ {
            /* {f00152d0-b40b-11d3-8c9c-000064657374} */
            { 0xf00152d0, 0xb40b, 0x11d3, { 0x8c, 0x9c, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous059 */ {
            /* {0d55a5e6-d185-44f0-b992-a8e1321e4bce} */
            { 0xd55a5e6, 0xd185, 0x44f0, { 0xb9, 0x92, 0xa8, 0xe1, 0x32, 0x1e, 0x4b, 0xce } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous385 */ {
            /* {acf8dc4b-4a25-11d3-9890-006008962422} */
            { 0xacf8dc4b, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous202 */ {
            /* {660a3226-915c-4ffb-bb20-8985a632df05} */
            { 0x660a3226, 0x915c, 0x4ffb, { 0xbb, 0x20, 0x89, 0x85, 0xa6, 0x32, 0xdf, 0x05 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous297 */ {
            /* {d5cce16c-7b6b-4bae-9597-08670d1eeaaa} */
            { 0xd5cce16c, 0x7b6b, 0x4bae, { 0x95, 0x97, 0x08, 0x67, 0x0d, 0x1e, 0xea, 0xaa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous281 */ {
            /* {d0c5195d-e798-49d4-b1d3-9324328b2291} */
            { 0xd0c5195d, 0xe798, 0x49d4, { 0xb1, 0xd3, 0x93, 0x24, 0x32, 0x8b, 0x22, 0x91 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous109 */ {
            /* {3014dde6-aa1c-41db-87d0-48764a3710f6} */
            { 0x3014dde6, 0xaa1c, 0x41db, { 0x87, 0xd0, 0x48, 0x76, 0x4a, 0x37, 0x10, 0xf6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous073 */ {
            /* {7ec4bc82-5022-4d32-8e98-ffbceadb692c} */
            { 0x7ec4bc82, 0x5022, 0x4d32, { 0x8e, 0x98, 0xff, 0xbc, 0xea, 0xdb, 0x69, 0x2c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous152 */ {
            /* {ce7d7da0-fb28-44a3-8c7b-000c165918f4} */
            { 0xce7d7da0, 0xfb28, 0x44a3, { 0x8c, 0x7b, 0x00, 0x0c, 0x16, 0x59, 0x18, 0xf4 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Locale */ {
            /* {92735ff4-6384-4ad6-8508-757010e149ee} */
            { 0x92735ff4, 0x6384, 0x4ad6, { 0x85, 0x08, 0x75, 0x70, 0x10, 0xe1, 0x49, 0xee } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous060 */ {
            /* {e031267e-bec8-4f3c-b0b1-396b77ca260c} */
            { 0xe031267e, 0xbec8, 0x4f3c, { 0xb0, 0xb1, 0x39, 0x6b, 0x77, 0xca, 0x26, 0x0c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous172 */ {
            /* {dea9657c-18cf-4984-bde9-ccef5d8ab473} */
            { 0xdea9657c, 0x18cf, 0x4984, { 0xbd, 0xe9, 0xcc, 0xef, 0x5d, 0x8a, 0xb4, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous178 */ {
            /* {86606ba1-de17-4df4-9013-e571ab94fd94} */
            { 0x86606ba1, 0xde17, 0x4df4, { 0x90, 0x13, 0xe5, 0x71, 0xab, 0x94, 0xfd, 0x94 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous234 */ {
            /* {2ee3039b-2de4-43d9-93b0-649beacff39a} */
            { 0x2ee3039b, 0x2de4, 0x43d9, { 0x93, 0xb0, 0x64, 0x9b, 0xea, 0xcf, 0xf3, 0x9a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous434 */ {
            /* {cf7fd51f-aba2-44c1-9ff0-11f7508efcd4} */
            { 0xcf7fd51f, 0xaba2, 0x44c1, { 0x9f, 0xf0, 0x11, 0xf7, 0x50, 0x8e, 0xfc, 0xd4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous364 */ {
            /* {a6cf9129-15b3-11d2-932e-00805f8add32} */
            { 0xa6cf9129, 0x15b3, 0x11d2, { 0x93, 0x2e, 0x00, 0x80, 0x5f, 0x8a, 0xdd, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous453 */ {
            /* {2fc2d3e3-020f-404e-b06a-6ecf3ea2334a} */
            { 0x2fc2d3e3, 0x20f, 0x404e, { 0xb0, 0x6a, 0x6e, 0xcf, 0x3e, 0xa2, 0x33, 0x4a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous108 */ {
            /* {72ec5df0-b5af-47a7-93b7-e9495f662ab2} */
            { 0x72ec5df0, 0xb5af, 0x47a7, { 0x93, 0xb7, 0xe9, 0x49, 0x5f, 0x66, 0x2a, 0xb2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Observer */ {
            /* {d07f5195-e3d1-11d2-8acd-00105a1b8860} */
            { 0xd07f5195, 0xe3d1, 0x11d2, { 0x8a, 0xcd, 0x00, 0x10, 0x5a, 0x1b, 0x88, 0x60 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous289 */ {
            /* {d38926e0-29c1-11eb-8588-0800200c9a66} */
            { 0xd38926e0, 0x29c1, 0x11eb, { 0x85, 0x88, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous252 */ {
            /* {1d8d9470-97d3-4885-a108-44a5c4fb36e2} */
            { 0x1d8d9470, 0x97d3, 0x4885, { 0xa1, 0x08, 0x44, 0xa5, 0xc4, 0xfb, 0x36, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* AuthPromptAdapter */ {
            /* {6e134924-6c3a-4d86-81ac-69432dd971dc} */
            { 0x6e134924, 0x6c3a, 0x4d86, { 0x81, 0xac, 0x69, 0x43, 0x2d, 0xd9, 0x71, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous018 */ {
            /* {ec5aa99c-7abb-4142-ac5f-aab2419e38e2} */
            { 0xec5aa99c, 0x7abb, 0x4142, { 0xac, 0x5f, 0xaa, 0xb2, 0x41, 0x9e, 0x38, 0xe2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous301 */ {
            /* {6c072f47-f25c-484f-add8-051b07789593} */
            { 0x6c072f47, 0xf25c, 0x484f, { 0xad, 0xd8, 0x05, 0x1b, 0x07, 0x78, 0x95, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous062 */ {
            /* {8c72bcdb-0c37-4786-a9e5-510afa2f8ede} */
            { 0x8c72bcdb, 0xc37, 0x4786, { 0xa9, 0xe5, 0x51, 0x0a, 0xfa, 0x2f, 0x8e, 0xde } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous021 */ {
            /* {1060afaf-dc9e-43da-8646-23a2faf48493} */
            { 0x1060afaf, 0xdc9e, 0x43da, { 0x86, 0x46, 0x23, 0xa2, 0xfa, 0xf4, 0x84, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* HttpHandler */ {
            /* {4f47e42e-4d23-4dd3-bfda-eb29255e9ea3} */
            { 0x4f47e42e, 0x4d23, 0x4dd3, { 0xbf, 0xda, 0xeb, 0x29, 0x25, 0x5e, 0x9e, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous190 */ {
            /* {067cb318-9b67-4442-9c1c-93e62dac8a7c} */
            { 0x67cb318, 0x9b67, 0x4442, { 0x9c, 0x1c, 0x93, 0xe6, 0x2d, 0xac, 0x8a, 0x7c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous150 */ {
            /* {2be14592-28d4-4a83-8fe9-08e778849f6e} */
            { 0x2be14592, 0x28d4, 0x4a83, { 0x8f, 0xe9, 0x08, 0xe7, 0x78, 0x84, 0x9f, 0x6e } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous145 */ {
            /* {dc01dbbb-a5bb-4cbb-82bb-085cce06c0bb} */
            { 0xdc01dbbb, 0xa5bb, 0x4cbb, { 0x82, 0xbb, 0x08, 0x5c, 0xce, 0x06, 0xc0, 0xbb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ExternalProtocolHandler */ {
            /* {bd6390c8-fbea-11d4-98f6-001083010e9b} */
            { 0xbd6390c8, 0xfbea, 0x11d4, { 0x98, 0xf6, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* DocLoader */ {
            /* {057b04d0-0ccf-11d2-beba-00805f8a66dc} */
            { 0x57b04d0, 0xccf, 0x11d2, { 0xbe, 0xba, 0x00, 0x80, 0x5f, 0x8a, 0x66, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* EffectiveTLD */ {
            /* {cb9abbae-66b6-4609-8594-5c4ff300888e} */
            { 0xcb9abbae, 0x66b6, 0x4609, { 0x85, 0x94, 0x5c, 0x4f, 0xf3, 0x00, 0x88, 0x8e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous451 */ {
            /* {af7b24cb-893f-41bb-961f-5a69388e27c3} */
            { 0xaf7b24cb, 0x893f, 0x41bb, { 0x96, 0x1f, 0x5a, 0x69, 0x38, 0x8e, 0x27, 0xc3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous030 */ {
            /* {1f34bc80-1bc7-11d6-a384-d705dd0746fc} */
            { 0x1f34bc80, 0x1bc7, 0x11d6, { 0xa3, 0x84, 0xd7, 0x05, 0xdd, 0x07, 0x46, 0xfc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Console */ {
            /* {7e3ff85c-1dd2-11b2-8d4b-eb452cb0ff40} */
            { 0x7e3ff85c, 0x1dd2, 0x11b2, { 0x8d, 0x4b, 0xeb, 0x45, 0x2c, 0xb0, 0xff, 0x40 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous084 */ {
            /* {20557898-1dd2-11b2-8f65-9c462ee2bc95} */
            { 0x20557898, 0x1dd2, 0x11b2, { 0x8f, 0x65, 0x9c, 0x46, 0x2e, 0xe2, 0xbc, 0x95 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Alerts */ {
            /* {a0ccaaf8-09da-44d8-b250-9ac3e93c8117} */
            { 0xa0ccaaf8, 0x9da, 0x44d8, { 0xb2, 0x50, 0x9a, 0xc3, 0xe9, 0x3c, 0x81, 0x17 } },
            { 0x29e2 } /* "@mozilla.org/alerts-service;1" */,
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous412 */ {
            /* {f4fecc26-02fe-46dc-935c-4d6f9acb18a6} */
            { 0xf4fecc26, 0x2fe, 0x46dc, { 0x93, 0x5c, 0x4d, 0x6f, 0x9a, 0xcb, 0x18, 0xa6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous274 */ {
            /* {749e62f4-60ae-4569-a8a2-de78b649660e} */
            { 0x749e62f4, 0x60ae, 0x4569, { 0xa8, 0xa2, 0xde, 0x78, 0xb6, 0x49, 0x66, 0x0e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous218 */ {
            /* {1b7db999-2ecd-4abf-bb95-a726896798ca} */
            { 0x1b7db999, 0x2ecd, 0x4abf, { 0xbb, 0x95, 0xa7, 0x26, 0x89, 0x67, 0x98, 0xca } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous125 */ {
            /* {5d6352a3-b9c3-4fa3-87aa-b2a3c6e5a501} */
            { 0x5d6352a3, 0xb9c3, 0x4fa3, { 0x87, 0xaa, 0xb2, 0xa3, 0xc6, 0xe5, 0xa5, 0x01 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous448 */ {
            /* {ac9e3e82-bfbd-4f26-941e-f58c8ee178c1} */
            { 0xac9e3e82, 0xbfbd, 0x4f26, { 0x94, 0x1e, 0xf5, 0x8c, 0x8e, 0xe1, 0x78, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous097 */ {
            /* {0a698c44-3bff-11d4-9649-00c0ca135b4e} */
            { 0xa698c44, 0x3bff, 0x11d4, { 0x96, 0x49, 0x00, 0xc0, 0xca, 0x13, 0x5b, 0x4e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous258 */ {
            /* {1b4c85df-cbdd-4bb6-b04e-613caece083c} */
            { 0x1b4c85df, 0xcbdd, 0x4bb6, { 0xb0, 0x4e, 0x61, 0x3c, 0xae, 0xce, 0x08, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous067 */ {
            /* {184385cb-2d35-4b99-a9a3-7c780bf66b9b} */
            { 0x184385cb, 0x2d35, 0x4b99, { 0xa9, 0xa3, 0x7c, 0x78, 0x0b, 0xf6, 0x6b, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous403 */ {
            /* {0abb0835-5000-4790-af28-61b3ba17c295} */
            { 0xabb0835, 0x5000, 0x4790, { 0xaf, 0x28, 0x61, 0xb3, 0xba, 0x17, 0xc2, 0x95 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* NSSComponent */ {
            /* {4cb64dfd-ca98-4e24-befd-0d9285a33bcb} */
            { 0x4cb64dfd, 0xca98, 0x4e24, { 0xbe, 0xfd, 0x0d, 0x92, 0x85, 0xa3, 0x3b, 0xcb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous118 */ {
            /* {4ffae79e-57bd-4d7a-a0c9-0045a17b3615} */
            { 0x4ffae79e, 0x57bd, 0x4d7a, { 0xa0, 0xc9, 0x00, 0x45, 0xa1, 0x7b, 0x36, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous166 */ {
            /* {2f277c00-0eaf-4ddb-b936-41326ba48aae} */
            { 0x2f277c00, 0xeaf, 0x4ddb, { 0xb9, 0x36, 0x41, 0x32, 0x6b, 0xa4, 0x8a, 0xae } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous410 */ {
            /* {58f089ee-512a-42d2-a935-d0c874128930} */
            { 0x58f089ee, 0x512a, 0x42d2, { 0xa9, 0x35, 0xd0, 0xc8, 0x74, 0x12, 0x89, 0x30 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous384 */ {
            /* {acf8dc43-4a25-11d3-9890-006008962422} */
            { 0xacf8dc43, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous184 */ {
            /* {8200e12c-416c-42eb-8af5-db9745d2e527} */
            { 0x8200e12c, 0x416c, 0x42eb, { 0x8a, 0xf5, 0xdb, 0x97, 0x45, 0xd2, 0xe5, 0x27 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous210 */ {
            /* {16e5c837-f877-4e23-9c64-eddf905e30e6} */
            { 0x16e5c837, 0xf877, 0x4e23, { 0x9c, 0x64, 0xed, 0xdf, 0x90, 0x5e, 0x30, 0xe6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous201 */ {
            /* {ff9fbcd7-9517-4334-b97a-ceed78909974} */
            { 0xff9fbcd7, 0x9517, 0x4334, { 0xb9, 0x7a, 0xce, 0xed, 0x78, 0x90, 0x99, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous404 */ {
            /* {03d68f92-9513-4e25-9be9-7cb239874172} */
            { 0x3d68f92, 0x9513, 0x4e25, { 0x9b, 0xe9, 0x7c, 0xb2, 0x39, 0x87, 0x41, 0x72 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous316 */ {
            /* {e6156350-2be8-11db-a98b-0800200c9a66} */
            { 0xe6156350, 0x2be8, 0x11db, { 0xa9, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous394 */ {
            /* {7a4204c6-e45a-4c37-8ebb-6709a22c917c} */
            { 0x7a4204c6, 0xe45a, 0x4c37, { 0x8e, 0xbb, 0x67, 0x09, 0xa2, 0x2c, 0x91, 0x7c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous149 */ {
            /* {fb8cbf4e-4701-4ba1-b1d6-5388e041fb67} */
            { 0xfb8cbf4e, 0x4701, 0x4ba1, { 0xb1, 0xd6, 0x53, 0x88, 0xe0, 0x41, 0xfb, 0x67 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous379 */ {
            /* {acf8dc41-4a25-11d3-9890-006008962422} */
            { 0xacf8dc41, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous043 */ {
            /* {3610c242-654e-11e6-8ec0-6d1be389a607} */
            { 0x3610c242, 0x654e, 0x11e6, { 0x8e, 0xc0, 0x6d, 0x1b, 0xe3, 0x89, 0xa6, 0x07 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous020 */ {
            /* {9e9a9283-0ce9-4e4a-8f1c-ba129a032c32} */
            { 0x9e9a9283, 0xce9, 0x4e4a, { 0x8f, 0x1c, 0xba, 0x12, 0x9a, 0x03, 0x2c, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous314 */ {
            /* {9111de73-9322-4bfc-8b65-2b727f3e6ec8} */
            { 0x9111de73, 0x9322, 0x4bfc, { 0x8b, 0x65, 0x2b, 0x72, 0x7f, 0x3e, 0x6e, 0xc8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous165 */ {
            /* {77c0e42a-1dd2-11b2-8ebf-edc6606f2f4b} */
            { 0x77c0e42a, 0x1dd2, 0x11b2, { 0x8e, 0xbf, 0xed, 0xc6, 0x60, 0x6f, 0x2f, 0x4b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* SiteSecurity */ {
            /* {16955eee-6c48-4152-9309-c42a465138a1} */
            { 0x16955eee, 0x6c48, 0x4152, { 0x93, 0x09, 0xc4, 0x2a, 0x46, 0x51, 0x38, 0xa1 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous090 */ {
            /* {a8e5a8e5-bebf-4512-9f50-e41e4748ce28} */
            { 0xa8e5a8e5, 0xbebf, 0x4512, { 0x9f, 0x50, 0xe4, 0x1e, 0x47, 0x48, 0xce, 0x28 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous139 */ {
            /* {64095195-aa8a-4d17-8ec8-c470d85b609b} */
            { 0x64095195, 0xaa8a, 0x4d17, { 0x8e, 0xc8, 0xc4, 0x70, 0xd8, 0x5b, 0x60, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous389 */ {
            /* {acf8dc46-4a25-11d3-9890-006008962422} */
            { 0xacf8dc46, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous004 */ {
            /* {eab9012e-5f74-4cbc-b2b5-a590235513cc} */
            { 0xeab9012e, 0x5f74, 0x4cbc, { 0xb2, 0xb5, 0xa5, 0x90, 0x23, 0x55, 0x13, 0xcc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* History */ {
            /* {0937a705-91a6-417a-8292-b22eb10da86c} */
            { 0x937a705, 0x91a6, 0x417a, { 0x82, 0x92, 0xb2, 0x2e, 0xb1, 0x0d, 0xa8, 0x6c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous402 */ {
            /* {7225c040-a9bf-11d3-a197-0050041caf44} */
            { 0x7225c040, 0xa9bf, 0x11d3, { 0xa1, 0x97, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* CategoryManager */ {
            /* {16d222a6-1dd2-11b2-b693-f38b02c021b2} */
            { 0x16d222a6, 0x1dd2, 0x11b2, { 0xb6, 0x93, 0xf3, 0x8b, 0x02, 0xc0, 0x21, 0xb2 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_SOCKET_AND_UTILITY_PROCESS,
          },
  
          /* Anonymous442 */ {
            /* {9d3f70da-86e9-11d4-95ec-00b0d03e37b7} */
            { 0x9d3f70da, 0x86e9, 0x11d4, { 0x95, 0xec, 0x00, 0xb0, 0xd0, 0x3e, 0x37, 0xb7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* SystemInfo */ {
            /* {d962398a-99e5-49b2-857a-c159049c7f6c} */
            { 0xd962398a, 0x99e5, 0x49b2, { 0x85, 0x7a, 0xc1, 0x59, 0x04, 0x9c, 0x7f, 0x6c } },
            { 0x2a00 } /* "@mozilla.org/system-info;1" */,
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous287 */ {
            /* {1dcc23b0-d4cb-11dc-9ad6-479d56d89593} */
            { 0x1dcc23b0, 0xd4cb, 0x11dc, { 0x9a, 0xd6, 0x47, 0x9d, 0x56, 0xd8, 0x95, 0x93 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* UrlClassifierTestUtils */ {
            /* {d63d6302-05fe-4b0e-aff9-f6b118f91ada} */
            { 0xd63d6302, 0x5fe, 0x4b0e, { 0xaf, 0xf9, 0xf6, 0xb1, 0x18, 0xf9, 0x1a, 0xda } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous120 */ {
            /* {be9a53ae-c7e9-11d3-8cda-0060b0fc14a3} */
            { 0xbe9a53ae, 0xc7e9, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous237 */ {
            /* {8cd92fce-1ec3-470a-ad09-c0de9d98497e} */
            { 0x8cd92fce, 0x1ec3, 0x470a, { 0xad, 0x09, 0xc0, 0xde, 0x9d, 0x98, 0x49, 0x7e } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous272 */ {
            /* {6ab96943-a163-482c-9622-4faedc0e827f} */
            { 0x6ab96943, 0xa163, 0x482c, { 0x96, 0x22, 0x4f, 0xae, 0xdc, 0x0e, 0x82, 0x7f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous268 */ {
            /* {a2568d74-be41-46a5-abfc-6dbab0b80f95} */
            { 0xa2568d74, 0xbe41, 0x46a5, { 0xab, 0xfc, 0x6d, 0xba, 0xb0, 0xb8, 0x0f, 0x95 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous070 */ {
            /* {daaa8d73-677e-4233-8acd-2c404bd01658} */
            { 0xdaaa8d73, 0x677e, 0x4233, { 0x8a, 0xcd, 0x2c, 0x40, 0x4b, 0xd0, 0x16, 0x58 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous239 */ {
            /* {17a59a6b-92b8-42e5-bce0-ab434c7a7135} */
            { 0x17a59a6b, 0x92b8, 0x42e5, { 0xbc, 0xe0, 0xab, 0x43, 0x4c, 0x7a, 0x71, 0x35 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* CookieBannerService */ {
            /* {eac9cdc4-ecee-49f2-91da-7627e15c1f3c} */
            { 0xeac9cdc4, 0xecee, 0x49f2, { 0x91, 0xda, 0x76, 0x27, 0xe1, 0x5c, 0x1f, 0x3c } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous199 */ {
            /* {0c4f1ddc-1dd2-11b2-9d95-f2fdf113044b} */
            { 0xc4f1ddc, 0x1dd2, 0x11b2, { 0x9d, 0x95, 0xf2, 0xfd, 0xf1, 0x13, 0x04, 0x4b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous452 */ {
            /* {653e0e4d-3ee4-45fa-b272-97c20bc01eb8} */
            { 0x653e0e4d, 0x3ee4, 0x45fa, { 0xb2, 0x72, 0x97, 0xc2, 0x0b, 0xc0, 0x1e, 0xb8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous253 */ {
            /* {92668367-1b17-4190-86b2-1061b2179744} */
            { 0x92668367, 0x1b17, 0x4190, { 0x86, 0xb2, 0x10, 0x61, 0xb2, 0x17, 0x97, 0x44 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous354 */ {
            /* {b148eed2-236d-11d3-b35c-00a0cc3c1cde} */
            { 0xb148eed2, 0x236d, 0x11d3, { 0xb3, 0x5c, 0x00, 0xa0, 0xcc, 0x3c, 0x1c, 0xde } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous235 */ {
            /* {cdc33a1f-e8ae-4a4f-85d0-6ec633fe872c} */
            { 0xcdc33a1f, 0xe8ae, 0x4a4f, { 0x85, 0xd0, 0x6e, 0xc6, 0x33, 0xfe, 0x87, 0x2c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Prefetch */ {
            /* {6b8bdffc-3394-417d-be83-a81b7c0f63bf} */
            { 0x6b8bdffc, 0x3394, 0x417d, { 0xbe, 0x83, 0xa8, 0x1b, 0x7c, 0x0f, 0x63, 0xbf } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous058 */ {
            /* {5296f79e-15ea-40c3-8196-19cfa64d328c} */
            { 0x5296f79e, 0x15ea, 0x40c3, { 0x81, 0x96, 0x19, 0xcf, 0xa6, 0x4d, 0x32, 0x8c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous236 */ {
            /* {4d48c536-e16f-4699-8f9c-add4f28f92f0} */
            { 0x4d48c536, 0xe16f, 0x4699, { 0x8f, 0x9c, 0xad, 0xd4, 0xf2, 0x8f, 0x92, 0xf0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous191 */ {
            /* {7a6da992-dbce-4943-b463-5a2dd011fa1a} */
            { 0x7a6da992, 0xdbce, 0x4943, { 0xb4, 0x63, 0x5a, 0x2d, 0xd0, 0x11, 0xfa, 0x1a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous094 */ {
            /* {65944815-e9ae-48bd-a2bf-f1108720950c} */
            { 0x65944815, 0xe9ae, 0x48bd, { 0xa2, 0xbf, 0xf1, 0x10, 0x87, 0x20, 0x95, 0x0c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous019 */ {
            /* {0365cbd5-d46e-4e94-a39f-83b63cd1a963} */
            { 0x365cbd5, 0xd46e, 0x4e94, { 0xa3, 0x9f, 0x83, 0xb6, 0x3c, 0xd1, 0xa9, 0x63 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous054 */ {
            /* {acf6e493-0092-4b26-b172-241e375c57ab} */
            { 0xacf6e493, 0x92, 0x4b26, { 0xb1, 0x72, 0x24, 0x1e, 0x37, 0x5c, 0x57, 0xab } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous278 */ {
            /* {dc6c2976-0f73-4f1f-b9ff-3d72b4e28309} */
            { 0xdc6c2976, 0xf73, 0x4f1f, { 0xb9, 0xff, 0x3d, 0x72, 0xb4, 0xe2, 0x83, 0x09 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous449 */ {
            /* {bd066e5f-146f-4472-8331-7bfd05b1ed90} */
            { 0xbd066e5f, 0x146f, 0x4472, { 0x83, 0x31, 0x7b, 0xfd, 0x05, 0xb1, 0xed, 0x90 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous349 */ {
            /* {e9537f8f-c07e-4435-8ab3-83f1ad6e3bbf} */
            { 0xe9537f8f, 0xc07e, 0x4435, { 0x8a, 0xb3, 0x83, 0xf1, 0xad, 0x6e, 0x3b, 0xbf } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_AND_MAIN_PROCESS,
          },
  
          /* Anonymous026 */ {
            /* {c4b6fb7c-bfb1-49dc-a65f-035796524b53} */
            { 0xc4b6fb7c, 0xbfb1, 0x49dc, { 0xa6, 0x5f, 0x03, 0x57, 0x96, 0x52, 0x4b, 0x53 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous034 */ {
            /* {96cf7855-dfa9-4c6d-8276-f9705b4890f2} */
            { 0x96cf7855, 0xdfa9, 0x4c6d, { 0x82, 0x76, 0xf9, 0x70, 0x5b, 0x48, 0x90, 0xf2 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous443 */ {
            /* {6030f7ef-32ed-46a7-9a63-6a5d3f90445f} */
            { 0x6030f7ef, 0x32ed, 0x46a7, { 0x9a, 0x63, 0x6a, 0x5d, 0x3f, 0x90, 0x44, 0x5f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* RFPService */ {
            /* {20093b2e-d5d5-4ce0-8355-96b8d2dc7ff5} */
            { 0x20093b2e, 0xd5d5, 0x4ce0, { 0x83, 0x55, 0x96, 0xb8, 0xd2, 0xdc, 0x7f, 0xf5 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous065 */ {
            /* {62c01e69-9ca4-4060-99e4-b95f628c8e6d} */
            { 0x62c01e69, 0x9ca4, 0x4060, { 0x99, 0xe4, 0xb9, 0x5f, 0x62, 0x8c, 0x8e, 0x6d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ContentSecurityManager */ {
            /* {cdcc1ab8-3cea-4e6c-a294-a651fa35227f} */
            { 0xcdcc1ab8, 0x3cea, 0x4e6c, { 0xa2, 0x94, 0xa6, 0x51, 0xfa, 0x35, 0x22, 0x7f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous463 */ {
            /* {0ff5ce56-5b09-4db8-adc6-8266af95f864} */
            { 0xff5ce56, 0x5b09, 0x4db8, { 0xad, 0xc6, 0x82, 0x66, 0xaf, 0x95, 0xf8, 0x64 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous322 */ {
            /* {4399533d-08d1-458c-a87a-235f74451cfa} */
            { 0x4399533d, 0x8d1, 0x458c, { 0xa8, 0x7a, 0x23, 0x5f, 0x74, 0x45, 0x1c, 0xfa } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous132 */ {
            /* {9158c470-86e4-11d4-9be2-00e09872a416} */
            { 0x9158c470, 0x86e4, 0x11d4, { 0x9b, 0xe2, 0x00, 0xe0, 0x98, 0x72, 0xa4, 0x16 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous320 */ {
            /* {f68578eb-6ec2-4169-ae19-8c6243f0abe1} */
            { 0xf68578eb, 0x6ec2, 0x4169, { 0xae, 0x19, 0x8c, 0x62, 0x43, 0xf0, 0xab, 0xe1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous456 */ {
            /* {69da374a-fda3-4a93-9fbc-d9304f66a7fe} */
            { 0x69da374a, 0xfda3, 0x4a93, { 0x9f, 0xbc, 0xd9, 0x30, 0x4f, 0x66, 0xa7, 0xfe } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous308 */ {
            /* {efc1415c-5708-41cc-8226-82bf1d3bee16} */
            { 0xefc1415c, 0x5708, 0x41cc, { 0x82, 0x26, 0x82, 0xbf, 0x1d, 0x3b, 0xee, 0x16 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* AppStartup */ {
            /* {7dd4d320-c84b-4624-8d45-7bb9b2356977} */
            { 0x7dd4d320, 0xc84b, 0x4624, { 0x8d, 0x45, 0x7b, 0xb9, 0xb2, 0x35, 0x69, 0x77 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous206 */ {
            /* {67ba681d-5485-4fff-952c-2ee337ffdcd6} */
            { 0x67ba681d, 0x5485, 0x4fff, { 0x95, 0x2c, 0x2e, 0xe3, 0x37, 0xff, 0xdc, 0xd6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* WindowWatcher */ {
            /* {a21bfa01-f349-4394-a84c-8de5cf0737d0} */
            { 0xa21bfa01, 0xf349, 0x4394, { 0xa8, 0x4c, 0x8d, 0xe5, 0xcf, 0x07, 0x37, 0xd0 } },
            { 0x2a1b } /* "@mozilla.org/embedcomp/window-watcher;1" */,
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous205 */ {
            /* {45a5fe2f-c350-4b86-962d-02d5aaaa955a} */
            { 0x45a5fe2f, 0xc350, 0x4b86, { 0x96, 0x2d, 0x02, 0xd5, 0xaa, 0xaa, 0x95, 0x5a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous352 */ {
            /* {1940fed5-7d02-4122-8acf-7abaac698983} */
            { 0x1940fed5, 0x7d02, 0x4122, { 0x8a, 0xcf, 0x7a, 0xba, 0xac, 0x69, 0x89, 0x83 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous310 */ {
            /* {b322a5c0-a419-484e-96ba-d7182163899f} */
            { 0xb322a5c0, 0xa419, 0x484e, { 0x96, 0xba, 0xd7, 0x18, 0x21, 0x63, 0x89, 0x9f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous039 */ {
            /* {9fea635a-2fc2-4d08-9721-d238d3f52f92} */
            { 0x9fea635a, 0x2fc2, 0x4d08, { 0x97, 0x21, 0xd2, 0x38, 0xd3, 0xf5, 0x2f, 0x92 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous367 */ {
            /* {c521a612-2aad-46db-b6ab-3b821fb150b1} */
            { 0xc521a612, 0x2aad, 0x46db, { 0xb6, 0xab, 0x3b, 0x82, 0x1f, 0xb1, 0x50, 0xb1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous374 */ {
            /* {fb97e4f5-32dd-497a-baa2-7d1e55079910} */
            { 0xfb97e4f5, 0x32dd, 0x497a, { 0xba, 0xa2, 0x7d, 0x1e, 0x55, 0x07, 0x99, 0x10 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous351 */ {
            /* {4364de1a-798e-419c-a6f5-ca28866b6d5f} */
            { 0x4364de1a, 0x798e, 0x419c, { 0xa6, 0xf5, 0xca, 0x28, 0x86, 0x6b, 0x6d, 0x5f } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous230 */ {
            /* {ab94809d-33f0-4f28-af38-01efbd3baf22} */
            { 0xab94809d, 0x33f0, 0x4f28, { 0xaf, 0x38, 0x01, 0xef, 0xbd, 0x3b, 0xaf, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous436 */ {
            /* {01e1c3ff-094a-d048-44b4-62d29c7b4f39} */
            { 0x1e1c3ff, 0x94a, 0xd048, { 0x44, 0xb4, 0x62, 0xd2, 0x9c, 0x7b, 0x4f, 0x39 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous221 */ {
            /* {d28f8a0b-95da-48f4-b712-caf37097be41} */
            { 0xd28f8a0b, 0x95da, 0x48f4, { 0xb7, 0x12, 0xca, 0xf3, 0x70, 0x97, 0xbe, 0x41 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* URLQueryStringStripper */ {
            /* {6b42a890-2624-4560-99c4-b25380e8cd77} */
            { 0x6b42a890, 0x2624, 0x4560, { 0x99, 0xc4, 0xb2, 0x53, 0x80, 0xe8, 0xcd, 0x77 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous315 */ {
            /* {1980624c-c50b-4b46-a91c-dfaba7792706} */
            { 0x1980624c, 0xc50b, 0x4b46, { 0xa9, 0x1c, 0xdf, 0xab, 0xa7, 0x79, 0x27, 0x06 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous170 */ {
            /* {b3cfeb91-332a-46c9-ad97-93ff39841494} */
            { 0xb3cfeb91, 0x332a, 0x46c9, { 0xad, 0x97, 0x93, 0xff, 0x39, 0x84, 0x14, 0x94 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous372 */ {
            /* {2e23e220-60be-11d3-8c4a-000064657374} */
            { 0x2e23e220, 0x60be, 0x11d3, { 0x8c, 0x4a, 0x00, 0x00, 0x64, 0x65, 0x73, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous363 */ {
            /* {841387c8-72e6-484b-9296-bf6eea80d58a} */
            { 0x841387c8, 0x72e6, 0x484b, { 0x92, 0x96, 0xbf, 0x6e, 0xea, 0x80, 0xd5, 0x8a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous128 */ {
            /* {e1c61582-2a84-11d3-8cce-0060b0fc14a3} */
            { 0xe1c61582, 0x2a84, 0x11d3, { 0x8c, 0xce, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous347 */ {
            /* {b2cdd51c-4277-417b-a931-08306c7814c3} */
            { 0xb2cdd51c, 0x4277, 0x417b, { 0xa9, 0x31, 0x08, 0x30, 0x6c, 0x78, 0x14, 0xc3 } },
            { 0xffffffff },
            Module::ProcessSelector::CONTENT_PROCESS_ONLY,
          },
  
          /* Anonymous192 */ {
            /* {b9f4fd03-9d87-4bfd-9958-85a821750ddc} */
            { 0xb9f4fd03, 0x9d87, 0x4bfd, { 0x99, 0x58, 0x85, 0xa8, 0x21, 0x75, 0x0d, 0xdc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous427 */ {
            /* {656db07c-aa80-49e4-bce8-e431baae697d} */
            { 0x656db07c, 0xaa80, 0x49e4, { 0xbc, 0xe8, 0xe4, 0x31, 0xba, 0xae, 0x69, 0x7d } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* URIFixup */ {
            /* {c6cf88b7-452e-47eb-bdc9-86e3561648ef} */
            { 0xc6cf88b7, 0x452e, 0x47eb, { 0xbd, 0xc9, 0x86, 0xe3, 0x56, 0x16, 0x48, 0xef } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous181 */ {
            /* {75a500a2-0030-40f7-86f8-63f225b940ae} */
            { 0x75a500a2, 0x30, 0x40f7, { 0x86, 0xf8, 0x63, 0xf2, 0x25, 0xb9, 0x40, 0xae } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous335 */ {
            /* {25db9b8e-8123-4de1-b66d-8bbbedf2cdf4} */
            { 0x25db9b8e, 0x8123, 0x4de1, { 0xb6, 0x6d, 0x8b, 0xbb, 0xed, 0xf2, 0xcd, 0xf4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous424 */ {
            /* {1147d32c-215b-4014-b180-07fe7aedf915} */
            { 0x1147d32c, 0x215b, 0x4014, { 0xb1, 0x80, 0x07, 0xfe, 0x7a, 0xed, 0xf9, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous444 */ {
            /* {abc622ea-9655-4123-80d9-22621bdd5465} */
            { 0xabc622ea, 0x9655, 0x4123, { 0x80, 0xd9, 0x22, 0x62, 0x1b, 0xdd, 0x54, 0x65 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous290 */ {
            /* {60a1f7c6-4ff9-4a42-84d3-5a185faa6f32} */
            { 0x60a1f7c6, 0x4ff9, 0x4a42, { 0x84, 0xd3, 0x5a, 0x18, 0x5f, 0xaa, 0x6f, 0x32 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous457 */ {
            /* {4a6212db-accb-11d3-b765-0060b0b6cecb} */
            { 0x4a6212db, 0xaccb, 0x11d3, { 0xb7, 0x65, 0x00, 0x60, 0xb0, 0xb6, 0xce, 0xcb } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous324 */ {
            /* {8866d8e3-4ea5-48b7-a891-13ba0ac15235} */
            { 0x8866d8e3, 0x4ea5, 0x48b7, { 0xa8, 0x91, 0x13, 0xba, 0x0a, 0xc1, 0x52, 0x35 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous265 */ {
            /* {994c0350-84a1-4d62-86ff-712e769a6638} */
            { 0x994c0350, 0x84a1, 0x4d62, { 0x86, 0xff, 0x71, 0x2e, 0x76, 0x9a, 0x66, 0x38 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous141 */ {
            /* {e64f152a-9f07-11d3-8cda-0060b0fc14a3} */
            { 0xe64f152a, 0x9f07, 0x11d3, { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous098 */ {
            /* {cdb4757f-f51b-40c0-8b38-66d12c3bff7b} */
            { 0xcdb4757f, 0xf51b, 0x40c0, { 0x8b, 0x38, 0x66, 0xd1, 0x2c, 0x3b, 0xff, 0x7b } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous395 */ {
            /* {0d6ea1d0-879c-11d5-90ef-0010a4e73d9a} */
            { 0xd6ea1d0, 0x879c, 0x11d5, { 0x90, 0xef, 0x00, 0x10, 0xa4, 0xe7, 0x3d, 0x9a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* PageThumbsStorage */ {
            /* {97943eec-0e48-49ef-b7b7-cf4aa0109bb6} */
            { 0x97943eec, 0xe48, 0x49ef, { 0xb7, 0xb7, 0xcf, 0x4a, 0xa0, 0x10, 0x9b, 0xb6 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* NSSCertificateDB */ {
            /* {fb0bbc5c-452e-4783-b32c-80124693d871} */
            { 0xfb0bbc5c, 0x452e, 0x4783, { 0xb3, 0x2c, 0x80, 0x12, 0x46, 0x93, 0xd8, 0x71 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous207 */ {
            /* {16786594-0296-4471-8096-8f84497ca428} */
            { 0x16786594, 0x296, 0x4471, { 0x80, 0x96, 0x8f, 0x84, 0x49, 0x7c, 0xa4, 0x28 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous143 */ {
            /* {9c7ec5d1-23f9-11d5-aea8-8fcc0793e97f} */
            { 0x9c7ec5d1, 0x23f9, 0x11d5, { 0xae, 0xa8, 0x8f, 0xcc, 0x07, 0x93, 0xe9, 0x7f } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous153 */ {
            /* {831f8f13-7aa8-485f-b02e-77c881cc5773} */
            { 0x831f8f13, 0x7aa8, 0x485f, { 0xb0, 0x2e, 0x77, 0xc8, 0x81, 0xcc, 0x57, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous091 */ {
            /* {d0f9db12-249c-11d5-9905-001083010e9b} */
            { 0xd0f9db12, 0x249c, 0x11d5, { 0x99, 0x05, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous169 */ {
            /* {b0054ef3-b096-483d-8242-4ee36b7b2115} */
            { 0xb0054ef3, 0xb096, 0x483d, { 0x82, 0x42, 0x4e, 0xe3, 0x6b, 0x7b, 0x21, 0x15 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous000 */ {
            /* {7e4bb6ad-2fc4-4dc6-89ef-23e8e5ccf980} */
            { 0x7e4bb6ad, 0x2fc4, 0x4dc6, { 0x89, 0xef, 0x23, 0xe8, 0xe5, 0xcc, 0xf9, 0x80 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous276 */ {
            /* {8aa66d77-1bbb-45a6-991e-b8f47751c291} */
            { 0x8aa66d77, 0x1bbb, 0x45a6, { 0x99, 0x1e, 0xb8, 0xf4, 0x77, 0x51, 0xc2, 0x91 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* BounceTrackingProtection */ {
            /* {4866f748-29da-4c10-8eaa-ed2f7851e6b1} */
            { 0x4866f748, 0x29da, 0x4c10, { 0x8e, 0xaa, 0xed, 0x2f, 0x78, 0x51, 0xe6, 0xb1 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* WifiMonitor */ {
            /* {3ff8fb9f-ee63-48df-89f0-dace0242fd82} */
            { 0x3ff8fb9f, 0xee63, 0x48df, { 0x89, 0xf0, 0xda, 0xce, 0x02, 0x42, 0xfd, 0x82 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous249 */ {
            /* {00ed5d73-9de5-42cf-868c-e739a94f6b37} */
            { 0xed5d73, 0x9de5, 0x42cf, { 0x86, 0x8c, 0xe7, 0x39, 0xa9, 0x4f, 0x6b, 0x37 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* HttpAuthCache */ {
            /* {e4aa6025-e0d8-40f0-92c7-f0100c6d6174} */
            { 0xe4aa6025, 0xe0d8, 0x40f0, { 0x92, 0xc7, 0xf0, 0x10, 0x0c, 0x6d, 0x61, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous307 */ {
            /* {117b219f-92fe-4bd2-a21b-95a342a9d474} */
            { 0x117b219f, 0x92fe, 0x4bd2, { 0xa2, 0x1b, 0x95, 0xa3, 0x42, 0xa9, 0xd4, 0x74 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* UrlClassifierDB */ {
            /* {7a258022-6765-11e5-b379-b37b1f2354be} */
            { 0x7a258022, 0x6765, 0x11e5, { 0xb3, 0x79, 0xb3, 0x7b, 0x1f, 0x23, 0x54, 0xbe } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous393 */ {
            /* {acf8dc42-4a25-11d3-9890-006008962422} */
            { 0xacf8dc42, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous123 */ {
            /* {36b63ef3-e0fa-4c49-9fd4-e065e85568f4} */
            { 0x36b63ef3, 0xe0fa, 0x4c49, { 0x9f, 0xd4, 0xe0, 0x65, 0xe8, 0x55, 0x68, 0xf4 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous309 */ {
            /* {aea477f2-b3a2-469c-aa29-0a82d132b829} */
            { 0xaea477f2, 0xb3a2, 0x469c, { 0xaa, 0x29, 0x0a, 0x82, 0xd1, 0x32, 0xb8, 0x29 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* Anonymous275 */ {
            /* {2bdac17c-53f1-4896-a521-682ccdeef3a8} */
            { 0x2bdac17c, 0x53f1, 0x4896, { 0xa5, 0x21, 0x68, 0x2c, 0xcd, 0xee, 0xf3, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous464 */ {
            /* {48c345e7-9929-4f9a-a563-f478222dabcd} */
            { 0x48c345e7, 0x9929, 0x4f9a, { 0xa5, 0x63, 0xf4, 0x78, 0x22, 0x2d, 0xab, 0xcd } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous465 */ {
            /* {3b265b69-f813-48ff-880d-d88d101af404} */
            { 0x3b265b69, 0xf813, 0x48ff, { 0x88, 0x0d, 0xd8, 0x8d, 0x10, 0x1a, 0xf4, 0x04 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous045 */ {
            /* {1775081b-b62d-4954-8ffe-a067bbf508a7} */
            { 0x1775081b, 0xb62d, 0x4954, { 0x8f, 0xfe, 0xa0, 0x67, 0xbb, 0xf5, 0x08, 0xa7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous031 */ {
            /* {c616fcfd-9737-41f1-aa74-cee72a38f91b} */
            { 0xc616fcfd, 0x9737, 0x41f1, { 0xaa, 0x74, 0xce, 0xe7, 0x2a, 0x38, 0xf9, 0x1b } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous430 */ {
            /* {ae2793c0-2ba3-4adb-9c5e-c23525812c64} */
            { 0xae2793c0, 0x2ba3, 0x4adb, { 0x9c, 0x5e, 0xc2, 0x35, 0x25, 0x81, 0x2c, 0x64 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous458 */ {
            /* {caaab47f-1e31-478e-8919-970904e9cb72} */
            { 0xcaaab47f, 0x1e31, 0x478e, { 0x89, 0x19, 0x97, 0x09, 0x04, 0xe9, 0xcb, 0x72 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Preferences */ {
            /* {91ca2441-050f-4f7c-9df8-75b40ea40156} */
            { 0x91ca2441, 0x50f, 0x4f7c, { 0x9d, 0xf8, 0x75, 0xb4, 0x0e, 0xa4, 0x01, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_GPU_RDD_VR_SOCKET_UTILITY_AND_GMPLUGIN_PROCESS,
          },
  
          /* AlertNotification */ {
            /* {9a7b7a41-0b47-47f7-b61b-15a210d6f020} */
            { 0x9a7b7a41, 0xb47, 0x47f7, { 0xb6, 0x1b, 0x15, 0xa2, 0x10, 0xd6, 0xf0, 0x20 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous328 */ {
            /* {84e11f80-ca55-11dd-ad8b-0800200c9a66} */
            { 0x84e11f80, 0xca55, 0x11dd, { 0xad, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous334 */ {
            /* {5f5e59ce-27bc-47eb-9d1f-b09ca9049836} */
            { 0x5f5e59ce, 0x27bc, 0x47eb, { 0x9d, 0x1f, 0xb0, 0x9c, 0xa9, 0x04, 0x98, 0x36 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous007 */ {
            /* {0f43b610-0a05-4d65-9780-c2b6e508d6f0} */
            { 0xf43b610, 0xa05, 0x4d65, { 0x97, 0x80, 0xc2, 0xb6, 0xe5, 0x08, 0xd6, 0xf0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous188 */ {
            /* {d581149e-3319-4563-b95e-46c64af5c4e8} */
            { 0xd581149e, 0x3319, 0x4563, { 0xb9, 0x5e, 0x46, 0xc6, 0x4a, 0xf5, 0xc4, 0xe8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous331 */ {
            /* {7e677795-c582-4cd1-9e8d-8271b3474d2a} */
            { 0x7e677795, 0xc582, 0x4cd1, { 0x9e, 0x8d, 0x82, 0x71, 0xb3, 0x47, 0x4d, 0x2a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous396 */ {
            /* {c6e47036-ca94-4be3-963a-9abd8705f7a8} */
            { 0xc6e47036, 0xca94, 0x4be3, { 0x96, 0x3a, 0x9a, 0xbd, 0x87, 0x05, 0xf7, 0xa8 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous321 */ {
            /* {66354bc9-7ed1-4692-ae1d-8da97d6b205e} */
            { 0x66354bc9, 0x7ed1, 0x4692, { 0xae, 0x1d, 0x8d, 0xa9, 0x7d, 0x6b, 0x20, 0x5e } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous156 */ {
            /* {1813cbb4-c98e-4622-8c7d-839167f3f272} */
            { 0x1813cbb4, 0xc98e, 0x4622, { 0x8c, 0x7d, 0x83, 0x91, 0x67, 0xf3, 0xf2, 0x72 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous447 */ {
            /* {bfc310d2-38a0-11d3-8cd3-0060b0fc14a3} */
            { 0xbfc310d2, 0x38a0, 0x11d3, { 0x8c, 0xd3, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous304 */ {
            /* {3a0012eb-007f-4bb8-aa81-a07385f77a25} */
            { 0x3a0012eb, 0x7f, 0x4bb8, { 0xaa, 0x81, 0xa0, 0x73, 0x85, 0xf7, 0x7a, 0x25 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous110 */ {
            /* {62d4b190-3642-4450-b019-d1c1fba56025} */
            { 0x62d4b190, 0x3642, 0x4450, { 0xb0, 0x19, 0xd1, 0xc1, 0xfb, 0xa5, 0x60, 0x25 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous093 */ {
            /* {4c733bd7-0bea-435a-ae1e-e65f3269d519} */
            { 0x4c733bd7, 0xbea, 0x435a, { 0xae, 0x1e, 0xe6, 0x5f, 0x32, 0x69, 0xd5, 0x19 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous455 */ {
            /* {1950539a-90f0-4d22-b5af-71329c68fa35} */
            { 0x1950539a, 0x90f0, 0x4d22, { 0xb5, 0xaf, 0x71, 0x32, 0x9c, 0x68, 0xfa, 0x35 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous440 */ {
            /* {4aef38b7-6364-4e23-a5e7-12f837fbbd9c} */
            { 0x4aef38b7, 0x6364, 0x4e23, { 0xa5, 0xe7, 0x12, 0xf8, 0x37, 0xfb, 0xbd, 0x9c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ThirdPartyUtil */ {
            /* {08c6cc8b-cfb0-421d-b1f7-683ff2989681} */
            { 0x8c6cc8b, 0xcfb0, 0x421d, { 0xb1, 0xf7, 0x68, 0x3f, 0xf2, 0x98, 0x96, 0x81 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous450 */ {
            /* {2a058404-fb85-44ec-8cfd-e8cbdc988dc1} */
            { 0x2a058404, 0xfb85, 0x44ec, { 0x8c, 0xfd, 0xe8, 0xcb, 0xdc, 0x98, 0x8d, 0xc1 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous242 */ {
            /* {580530e5-118c-4bc7-ab88-bc2cd2b97223} */
            { 0x580530e5, 0x118c, 0x4bc7, { 0xab, 0x88, 0xbc, 0x2c, 0xd2, 0xb9, 0x72, 0x23 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* RandomGenerator */ {
            /* {be65e2b7-fe46-4e0f-88e0-4b385db4d68a} */
            { 0xbe65e2b7, 0xfe46, 0x4e0f, { 0x88, 0xe0, 0x4b, 0x38, 0x5d, 0xb4, 0xd6, 0x8a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous425 */ {
            /* {ecba5203-77da-465a-865e-78b7af10d8f7} */
            { 0xecba5203, 0x77da, 0x465a, { 0x86, 0x5e, 0x78, 0xb7, 0xaf, 0x10, 0xd8, 0xf7 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous333 */ {
            /* {4e4aae11-8901-46cc-8217-dad7c5415873} */
            { 0x4e4aae11, 0x8901, 0x46cc, { 0x82, 0x17, 0xda, 0xd7, 0xc5, 0x41, 0x58, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous042 */ {
            /* {d1748d4c-7f6a-4dc5-add6-d55b7678537e} */
            { 0xd1748d4c, 0x7f6a, 0x4dc5, { 0xad, 0xd6, 0xd5, 0x5b, 0x76, 0x78, 0x53, 0x7e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous044 */ {
            /* {02b9970c-433d-4cc2-923d-f7028ac66073} */
            { 0x2b9970c, 0x433d, 0x4cc2, { 0x92, 0x3d, 0xf7, 0x02, 0x8a, 0xc6, 0x60, 0x73 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous338 */ {
            /* {8b5314ba-db01-11d2-96ce-0060b0fb9956} */
            { 0x8b5314ba, 0xdb01, 0x11d2, { 0x96, 0xce, 0x00, 0x60, 0xb0, 0xfb, 0x99, 0x56 } },
            { 0x2a43 } /* "@mozilla.org/widget/clipboard;1" */,
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous009 */ {
            /* {d8903bf6-68d5-4e97-bcd1-e4d3012f721a} */
            { 0xd8903bf6, 0x68d5, 0x4e97, { 0xbc, 0xd1, 0xe4, 0xd3, 0x01, 0x2f, 0x72, 0x1a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* AsyncShutdown */ {
            /* {35c496de-a115-475d-93b5-ffa3f3ae6fe3} */
            { 0x35c496de, 0xa115, 0x475d, { 0x93, 0xb5, 0xff, 0xa3, 0xf3, 0xae, 0x6f, 0xe3 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous256 */ {
            /* {0c797702-1c60-4051-9dd7-4d7405605642} */
            { 0xc797702, 0x1c60, 0x4051, { 0x9d, 0xd7, 0x4d, 0x74, 0x05, 0x60, 0x56, 0x42 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous179 */ {
            /* {82b09188-8809-44c5-b41e-d8b85b8c2743} */
            { 0x82b09188, 0x8809, 0x44c5, { 0xb4, 0x1e, 0xd8, 0xb8, 0x5b, 0x8c, 0x27, 0x43 } },
            { 0xffffffff },
            Module::ProcessSelector::ALLOW_IN_SOCKET_PROCESS,
          },
  
          /* Anonymous180 */ {
            /* {962dbf40-2c3f-4c1f-8ae8-90e8c9d85368} */
            { 0x962dbf40, 0x2c3f, 0x4c1f, { 0x8a, 0xe8, 0x90, 0xe8, 0xc9, 0xd8, 0x53, 0x68 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* TextToSubURI */ {
            /* {8b042e22-6f87-11d3-b3c8-00805f8a6670} */
            { 0x8b042e22, 0x6f87, 0x11d3, { 0xb3, 0xc8, 0x00, 0x80, 0x5f, 0x8a, 0x66, 0x70 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous419 */ {
            /* {09d9ed1a-e5d4-4004-bfe0-27ceb923d9ac} */
            { 0x9d9ed1a, 0xe5d4, 0x4004, { 0xbf, 0xe0, 0x27, 0xce, 0xb9, 0x23, 0xd9, 0xac } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous305 */ {
            /* {7319788a-fe93-4db3-9f39-818cf08f4256} */
            { 0x7319788a, 0xfe93, 0x4db3, { 0x9f, 0x39, 0x81, 0x8c, 0xf0, 0x8f, 0x42, 0x56 } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous015 */ {
            /* {97bf9550-2a7b-11e9-b56e-0800200c9a66} */
            { 0x97bf9550, 0x2a7b, 0x11e9, { 0xb5, 0x6e, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous064 */ {
            /* {52fc3f9f-c0cb-4874-b3d4-ee4b6e9cbe9c} */
            { 0x52fc3f9f, 0xc0cb, 0x4874, { 0xb3, 0xd4, 0xee, 0x4b, 0x6e, 0x9c, 0xbe, 0x9c } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous446 */ {
            /* {041a129f-10ce-4bda-a60d-e027a26d5ed0} */
            { 0x41a129f, 0x10ce, 0x4bda, { 0xa6, 0x0d, 0xe0, 0x27, 0xa2, 0x6d, 0x5e, 0xd0 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous387 */ {
            /* {acf8dc4d-4a25-11d3-9890-006008962422} */
            { 0xacf8dc4d, 0x4a25, 0x11d3, { 0x98, 0x90, 0x00, 0x60, 0x08, 0x96, 0x24, 0x22 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous296 */ {
            /* {1a817186-357a-47cd-8aea-2850d60e959e} */
            { 0x1a817186, 0x357a, 0x47cd, { 0x8a, 0xea, 0x28, 0x50, 0xd6, 0x0e, 0x95, 0x9e } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous231 */ {
            /* {42906796-d16a-44a1-b518-0f108ab38eba} */
            { 0x42906796, 0xd16a, 0x44a1, { 0xb5, 0x18, 0x0f, 0x10, 0x8a, 0xb3, 0x8e, 0xba } },
            { 0xffffffff },
            Module::ProcessSelector::MAIN_PROCESS_ONLY,
          },
  
          /* Anonymous080 */ {
            /* {7ef52eaf-b7e1-462b-87e2-5d1dbaca9048} */
            { 0x7ef52eaf, 0xb7e1, 0x462b, { 0x87, 0xe2, 0x5d, 0x1d, 0xba, 0xca, 0x90, 0x48 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* ExtensionPolicy */ {
            /* {562de129-8338-482c-bb96-a1ff09ee53cc} */
            { 0x562de129, 0x8338, 0x482c, { 0xbb, 0x96, 0xa1, 0xff, 0x09, 0xee, 0x53, 0xcc } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous292 */ {
            /* {1141fd31-4c1a-48eb-8f1a-2f05fad94085} */
            { 0x1141fd31, 0x4c1a, 0x48eb, { 0x8f, 0x1a, 0x2f, 0x05, 0xfa, 0xd9, 0x40, 0x85 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous432 */ {
            /* {baa34652-f1f1-4185-b224-244ee82a413a} */
            { 0xbaa34652, 0xf1f1, 0x4185, { 0xb2, 0x24, 0x24, 0x4e, 0xe8, 0x2a, 0x41, 0x3a } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          },
  
          /* Anonymous233 */ {
            /* {f6d5ebbd-34f4-487d-9d10-3d34123e3eb9} */
            { 0xf6d5ebbd, 0x34f4, 0x487d, { 0x9d, 0x10, 0x3d, 0x34, 0x12, 0x3e, 0x3e, 0xb9 } },
            { 0xffffffff },
            Module::ProcessSelector::ANY_PROCESS,
          }
};



const StaticModule*
ModuleByCID(const nsID& aKey)
{
  static const uint16_t BASES[] = {
       0,   3,   2,   5,   1,   0,   0,   1,   1,   2,   5,   2,   2,   0,   1,   1,
       4,   2,   2,  10,   5,   1,   0,   0,   1,   0,   2,   1,   2,   0,   4,   0,
       0,   0,   3,   3,   1,   0,   1,   0,   2,   1,   0,   0,   2,   1,   4,   4,
       0,   2,   2,   1,   1,   4,   0,   2,   1,   8,   0,   7,   1,   0,   3,   2,
       7,   1,   0,   0,   0,   0,   1,  10,   1,   2,   0,  12,   0,   1,   3,   0,
       0,   0,   2,   2,   0,   5,   0,   5,   2,   0,   4,   0,   0,   1,   2,   1,
       7,   0,   0,   0,   2,   5,   5,   5,   0,   3,   4,   2,   0,   0,   0,   3,
       2,   1,   1,   2,   1,   0,   3,   1,   2,  11,   0,   9,   2,   1,   0,   9,
       0,   2,   3,   0,   0,   1,   3,   1,   4,   8,   2,   0,   1,   5,   0,   0,
       0,   3,   2,   0,   2,   3,   3,  14,   0,   5,   0,   2,   2,   4,   0,   1,
       8,   2,   0,   2,   7,   1,   1,   2,   9,   4,  16,   0,   0,   2,   7,   9,
       5,   5,   0,   0,   2,   3,   3,   5,   1,   0,   2,   2,   2,   3,   5,   9,
       2,   1,   3,   1,   3,   0,   0,   0,   1,   0,   5,   5,   1,   1,   1,  14,
       9,   0,  16,   0,   8,   1,   1,   0,   0,   0,  10,   5,   2,   0,   9,   0,
       3,   7,   0,   6,   0,   4,   4,  12,   6,   8,   0,   0,   0,   0,   1,   2,
       2,   0,   0,   0,   1,   4,   0,   0,   0,   0,   2,   0,  10,   5,   2,   0,
       1,   0,   0,   8,   0,   4,   3,   3,   1,   2,  10,  11,   1,   2,   0,   0,
       3,   0,   5,   2,   1,   0,   8,  13,  14,   0,   0,   0,   2,   0,   0,   0,
       0,  20,   3,  18,   1,   0,   4,   3,   2,   2,   6,   0,   0,   2,   0,   2,
      12,   6,   3,   9,   0,   7,   2,   0,   2,   0,  16,   1,  22,   9,   0,  10,
       8,   7,   2,   5,   9,   0,   0,   0,   0,   0,   7,   7,   3,   0,   1,   0,
       0,   2,   2,  11,   0,   1,  23,   8,   2,   8,   2,   1,   0,  19,   1,   4,
      16,   3,  10,   0,   0,  18,   0,   3,   0,   5,   6,   1,   6,   2,   1,   0,
       0,  23,   4,   3,  24,   0,   0,   1,   6,   0,   0,   0,   8,  18,   1,   1,
       4,   1,  28,   2,   0,   0,   4,  16,   7,   5,   0,   1,   1,  13,   0,   4,
       5,  29,   0,   0,   0,   3,   1,   0,  35,  12,   0,   7,   0,   4,   0,   0,
       0,   0,   0,  58,   5,   8,   5,   6,  24,   0,   0,   1,  66,  20,   0,  12,
      12,   2,   0,  24,   0,   0,  34,  29,   0,  59,   4,  42,   5,   7,   0,  20,
      12,  77,  51,  72, 110,   0,  14,   3,  83,  19,   1,  51,   2,   0,  14,   0,
       0,   0,   6,   0,   0,   1,   0,  45,   0,   0,   2,   3,  82,   0,   0,   0,
       1,  89,   0,   0,   0,  15,  16,   0,  18,   0,   7, 106,   8, 151,   0, 139,
       0,   0, 494,   0,   0,   0,  43,   6,   9,  23,   0,   0,   2,   3,  26, 198,
  };
  

  const char* bytes = reinterpret_cast<const char*>(&aKey);
  size_t length = sizeof(nsID);
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             gStaticModules);
  return entry.CID().Equals(aKey) && entry.Active() ? &entry : nullptr;
}

const ContractEntry gContractEntries[] = {
  
          {
            { 0x2a63 } /* "@mozilla.org/network/protocol/about;1?what=support" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x2a96 } /* "@mozilla.org/services/settings;1" */,
            ModuleID::Anonymous219,
          },
  
          {
            { 0x2ab7 } /* "@mozilla.org/network/protocol/about;1?what=logging" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x2aea } /* "@mozilla.org/gio-service;1" */,
            ModuleID::Anonymous327,
          },
  
          {
            { 0x2b05 } /* "@mozilla.org/xul/xulstore;1" */,
            ModuleID::Anonymous319,
          },
  
          {
            { 0x1c5 } /* "@mozilla.org/content-viewers/http-index-format" */,
            ModuleID::Anonymous318,
          },
  
          {
            { 0x2b21 } /* "@mozilla.org/browser/identity-credential-storage-service;1" */,
            ModuleID::IdentityCredentialStorageService,
          },
  
          {
            { 0x2b5c } /* "@mozilla.org/network/incremental-stream-loader;1" */,
            ModuleID::Anonymous125,
          },
  
          {
            { 0x1006 } /* "@mozilla.org/purge-tracker-service;1" */,
            ModuleID::Anonymous229,
          },
  
          {
            { 0x2b8d } /* "@mozilla.org/network/protocol/about;1?what=asrouter" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x2bc1 } /* "@mozilla.org/network/incremental-download;1" */,
            ModuleID::Anonymous124,
          },
  
          {
            { 0x2bed } /* "@mozilla.org/nss_errors_service;1" */,
            ModuleID::NSSErrors,
          },
  
          {
            { 0x2c0f } /* "@mozilla.org/weave/service;1" */,
            ModuleID::Anonymous220,
          },
  
          {
            { 0x2c2c } /* "@mozilla.org/network/protocol/about;1?what=unloads" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x2c5f } /* "@mozilla.org/filepicker;1" */,
            ModuleID::Anonymous344,
          },
  
          {
            { 0x2c79 } /* "@mozilla.org/libjar/zip-reader;1" */,
            ModuleID::Anonymous100,
          },
  
          {
            { 0x2c9a } /* "@mozilla.org/scriptable-content-iterator;1" */,
            ModuleID::Anonymous454,
          },
  
          {
            { 0x2cc5 } /* "@mozilla.org/uriloader/web-handler-app;1" */,
            ModuleID::Anonymous337,
          },
  
          {
            { 0x2cee } /* "@mozilla.org/securityconsole/message;1" */,
            ModuleID::Anonymous377,
          },
  
          {
            { 0x3b2 } /* "@mozilla.org/extensions/child;1" */,
            ModuleID::Anonymous260,
          },
  
          {
            { 0x2d15 } /* "@mozilla.org/webspeech/service;1?name=online" */,
            ModuleID::Anonymous463,
          },
  
          {
            { 0x2d42 } /* "@mozilla.org/uriloader/content-handler;1?type=text/html" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x2d7a } /* "@mozilla.org/streamConverters;1" */,
            ModuleID::StreamConverter,
          },
  
          {
            { 0x2d9a } /* "@mozilla.org/dom/sdb-connection;1" */,
            ModuleID::Anonymous430,
          },
  
          {
            { 0x2dbc } /* "@mozilla.org/network/replaced-http-response;1" */,
            ModuleID::Anonymous190,
          },
  
          {
            { 0x89f } /* "@mozilla.org/bounce-tracking-protection;1" */,
            ModuleID::BounceTrackingProtection,
          },
  
          {
            { 0x2dea } /* "@mozilla.org/jsdebugger;1" */,
            ModuleID::Anonymous019,
          },
  
          {
            { 0x2e04 } /* "@mozilla.org/scriptableinputstream;1" */,
            ModuleID::Anonymous402,
          },
  
          {
            { 0x2e29 } /* "@mozilla.org/dom/rtcdtmfsender;1" */,
            ModuleID::Anonymous043,
          },
  
          {
            { 0x935 } /* "@mozilla.org/storage/vacuum;1" */,
            ModuleID::Anonymous224,
          },
  
          {
            { 0x2e4a } /* "@mozilla.org/network/background-file-saver;1?mode=streamlistener" */,
            ModuleID::Anonymous114,
          },
  
          {
            { 0x2e8b } /* "@mozilla.org/base/daptelemetry;1" */,
            ModuleID::Anonymous257,
          },
  
          {
            { 0x2eac } /* "@mozilla.org/network/oblivious-http-service;1" */,
            ModuleID::Anonymous189,
          },
  
          {
            { 0x2eda } /* "@mozilla.org/network/well-known-opportunistic-utils;1" */,
            ModuleID::Anonymous186,
          },
  
          {
            { 0x2f10 } /* "@mozilla.org/network/protocol/about;1?what=glean" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x2f41 } /* "@mozilla.org/dom/slow-script-debug;1" */,
            ModuleID::Anonymous033,
          },
  
          {
            { 0x2f66 } /* "@mozilla.org/io/string-input-stream;1" */,
            ModuleID::Anonymous403,
          },
  
          {
            { 0x2f8c } /* "@mozilla.org/url-classifier/jslib;1" */,
            ModuleID::Anonymous312,
          },
  
          {
            { 0x2fb0 } /* "@mozilla.org/network/protocol;1?name=javascript" */,
            ModuleID::Anonymous447,
          },
  
          {
            { 0x2fe0 } /* "@mozilla.org/categorymanager;1" */,
            ModuleID::CategoryManager,
          },
  
          {
            { 0x2fff } /* "@mozilla.org/parent/colorpicker;1" */,
            ModuleID::Anonymous351,
          },
  
          {
            { 0x11e5 } /* "@mozilla.org/profile-after-change-gate;1" */,
            ModuleID::Anonymous226,
          },
  
          {
            { 0x3021 } /* "@mozilla.org/embedcomp/prompt-collection;1" */,
            ModuleID::Anonymous011,
          },
  
          {
            { 0x304c } /* "@mozilla.org/network/protocol/about;1?what=debugging" */,
            ModuleID::Anonymous021,
          },
  
          {
            { 0x3081 } /* "@mozilla.org/url-classifier/exception-list-entry;1" */,
            ModuleID::Anonymous193,
          },
  
          {
            { 0x30b4 } /* "@mozilla.org/dom/workers/workerdebuggermanager;1" */,
            ModuleID::Anonymous431,
          },
  
          {
            { 0x30e5 } /* "@mozilla.org/clear-data-service;1" */,
            ModuleID::Anonymous246,
          },
  
          {
            { 0x3107 } /* "@mozilla.org/security/oskeystore;1" */,
            ModuleID::Anonymous208,
          },
  
          {
            { 0x1126 } /* "@mozilla.org/satchel/form-history-startup;1" */,
            ModuleID::Anonymous304,
          },
  
          {
            { 0x312a } /* "@mozilla.org/autocomplete/search;1?name=form-fill-controller" */,
            ModuleID::Anonymous302,
          },
  
          {
            { 0x3167 } /* "@mozilla.org/streamconv;1?from=application/x-unknown-content-type&to=*\/\*" */,
            ModuleID::Anonymous162,
          },
  
          {
            { 0x31b0 } /* "@mozilla.org/network/url-parser;1?auth=yes" */,
            ModuleID::Anonymous160,
          },
  
          {
            { 0x31db } /* "@mozilla.org/network/captive-portal-service;1" */,
            ModuleID::CaptivePortal,
          },
  
          {
            { 0x3209 } /* "@mozilla.org/applicationchooser;1" */,
            ModuleID::Anonymous356,
          },
  
          {
            { 0x322b } /* "@mozilla.org/geolocation/mls-provider;1" */,
            ModuleID::Anonymous074,
          },
  
          {
            { 0x3253 } /* "@mozilla.org/network/protocol/about;1?what=welcome" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x3286 } /* "@mozilla.org/autocomplete/search;1?name=login-doorhanger-password" */,
            ModuleID::Anonymous280,
          },
  
          {
            { 0x32c8 } /* "@mozilla.org/network/protocol;1?name=default" */,
            ModuleID::ExternalProtocolHandler,
          },
  
          {
            { 0x32f5 } /* "@mozilla.org/dom/peerconnection;1" */,
            ModuleID::Anonymous041,
          },
  
          {
            { 0x1274 } /* "@mozilla.org/fakesynth;1" */,
            ModuleID::Anonymous053,
          },
  
          {
            { 0x3317 } /* "@mozilla.org/toolkit/sessionstore-functions;1" */,
            ModuleID::Anonymous013,
          },
  
          {
            { 0xafe } /* "@mozilla.org/network/binary-detector;1" */,
            ModuleID::Anonymous115,
          },
  
          {
            { 0x3345 } /* "@mozilla.org/webspeech/service;1?name=fake" */,
            ModuleID::Anonymous464,
          },
  
          {
            { 0x109e } /* "@mozilla.org/SimpleURIUnknownSchemesRemoteObserver;1" */,
            ModuleID::Anonymous178,
          },
  
          {
            { 0x3370 } /* "@mozilla.org/intl/texttosuburi;1" */,
            ModuleID::TextToSubURI,
          },
  
          {
            { 0x8e9 } /* "@mozilla.org/content-blocking-telemetry-service;1" */,
            ModuleID::Anonymous231,
          },
  
          {
            { 0x3391 } /* "@mozilla.org/network/protocol;1?name=cached-favicon" */,
            ModuleID::Anonymous282,
          },
  
          {
            { 0x33c5 } /* "@mozilla.org/passwordmanager/authpromptfactory;1" */,
            ModuleID::Anonymous274,
          },
  
          {
            { 0x33f6 } /* "@mozilla.org/contentsecuritymanager;1" */,
            ModuleID::ContentSecurityManager,
          },
  
          {
            { 0x341c } /* "@mozilla.org/sandbox/syscall-reporter;1" */,
            ModuleID::Anonymous217,
          },
  
          {
            { 0x3444 } /* "@mozilla.org/security/hash;1" */,
            ModuleID::Anonymous204,
          },
  
          {
            { 0x3461 } /* "@mozilla.org/network/protocol/about;1?what=downloads" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x3496 } /* "@mozilla.org/supports-PRUint8;1" */,
            ModuleID::Anonymous392,
          },
  
          {
            { 0x3e5 } /* "@mozilla.org/satchel/form-fill-controller;1" */,
            ModuleID::Anonymous302,
          },
  
          {
            { 0x34b6 } /* "@mozilla.org/url-classifier/list-service;1" */,
            ModuleID::Anonymous315,
          },
  
          {
            { 0x34e1 } /* "@mozilla.org/widget/htmlformatconverter;1" */,
            ModuleID::Anonymous353,
          },
  
          {
            { 0x350b } /* "@mozilla.org/supports-float;1" */,
            ModuleID::Anonymous382,
          },
  
          {
            { 0x3529 } /* "@mozilla.org/binaryinputstream;1" */,
            ModuleID::Anonymous367,
          },
  
          {
            { 0x354a } /* "@mozilla.org/network/protocol/about;1?what=home" */,
            ModuleID::Anonymous008,
          },
  
          {
            { 0x357a } /* "@mozilla.org/network/protocol/about;1?what=url-classifier" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x35b4 } /* "@mozilla.org/network/protocol;1?name=jar" */,
            ModuleID::Anonymous101,
          },
  
          {
            { 0x35dd } /* "@mozilla.org/network/protocol/about;1?what=protections" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x3614 } /* "@mozilla.org/intl/converter-output-stream;1" */,
            ModuleID::Anonymous096,
          },
  
          {
            { 0x3640 } /* "@mozilla.org/uriloader;1" */,
            ModuleID::URILoader,
          },
  
          {
            { 0x3659 } /* "@mozilla.org/prompter;1" */,
            ModuleID::Anonymous295,
          },
  
          {
            { 0x3671 } /* "@mozilla.org/docshell/uri-fixup-info;1" */,
            ModuleID::Anonymous023,
          },
  
          {
            { 0x3698 } /* "@mozilla.org/security/nsCertTree;1" */,
            ModuleID::Anonymous212,
          },
  
          {
            { 0x36bb } /* "@mozilla.org/image/request;1" */,
            ModuleID::Anonymous084,
          },
  
          {
            { 0x36d8 } /* "@mozilla.org/widget/printdialog-service;1" */,
            ModuleID::Anonymous362,
          },
  
          {
            { 0x3702 } /* "@mozilla.org/content/colorpicker;1" */,
            ModuleID::Anonymous341,
          },
  
          {
            { 0xf4d } /* "@mozilla.org/toolkit/crashmonitor;1" */,
            ModuleID::Anonymous255,
          },
  
          {
            { 0x3725 } /* "@mozilla.org/reputationservice/application-reputation-service;1" */,
            ModuleID::ApplicationReputation,
          },
  
          {
            { 0x3765 } /* "@mozilla.org/network/input-stream-channel;1" */,
            ModuleID::Anonymous126,
          },
  
          {
            { 0x3791 } /* "@mozilla.org/policycontainer;1" */,
            ModuleID::Anonymous423,
          },
  
          {
            { 0x37b0 } /* "@mozilla.org/toolkit/crash-reporter;1" */,
            ModuleID::XULRuntime,
          },
  
          {
            { 0x37d6 } /* "@mozilla.org/xpcom/debug;1" */,
            ModuleID::Anonymous365,
          },
  
          {
            { 0x37f1 } /* "@mozilla.org/security/certstorage;1" */,
            ModuleID::Anonymous210,
          },
  
          {
            { 0x3815 } /* "@mozilla.org/query-stripping-list-service;1" */,
            ModuleID::Anonymous232,
          },
  
          {
            { 0x3841 } /* "@mozilla.org/cookieService;1" */,
            ModuleID::Anonymous175,
          },
  
          {
            { 0x385e } /* "@mozilla.org/network/dns-service;1" */,
            ModuleID::DNS,
          },
  
          {
            { 0x3881 } /* "@mozilla.org/cascade-filter;1" */,
            ModuleID::Anonymous245,
          },
  
          {
            { 0x389f } /* "@mozilla.org/image/encoder;2?type=image/bmp" */,
            ModuleID::Anonymous086,
          },
  
          {
            { 0x38cb } /* "@mozilla.org/network/protocol;1?name=moz" */,
            ModuleID::Anonymous271,
          },
  
          {
            { 0x38f4 } /* "@mozilla.org/mozintl;1" */,
            ModuleID::Anonymous270,
          },
  
          {
            { 0x390b } /* "@mozilla.org/streamconv;1?from=application/octet-stream&to=text/html" */,
            ModuleID::Anonymous281,
          },
  
          {
            { 0x3950 } /* "@mozilla.org/gfx/printsettings-service;1" */,
            ModuleID::Anonymous363,
          },
  
          {
            { 0x3979 } /* "@mozilla.org/image/encoder;2?type=image/vnd.microsoft.icon" */,
            ModuleID::Anonymous087,
          },
  
          {
            { 0x39b4 } /* "@mozilla.org/widget/clipboardhelper;1" */,
            ModuleID::Anonymous358,
          },
  
          {
            { 0x39da } /* "@mozilla.org/content-dispatch-chooser;1" */,
            ModuleID::Anonymous326,
          },
  
          {
            { 0x3a02 } /* "@mozilla.org/spellchecker/engine;1" */,
            ModuleID::Anonymous079,
          },
  
          {
            { 0x3a25 } /* "@mozilla.org/streamconv;1?from=application/pdf&to=*\/\*" */,
            ModuleID::Anonymous281,
          },
  
          {
            { 0x3a5b } /* "@mozilla.org/network/protocol;1?name=moz-safe-about" */,
            ModuleID::Anonymous140,
          },
  
          {
            { 0x3a8f } /* "@mozilla.org/network/default-uri-mutator;1" */,
            ModuleID::Anonymous151,
          },
  
          {
            { 0x3aba } /* "@mozilla.org/consoleAPI-storage;1" */,
            ModuleID::Anonymous034,
          },
  
          {
            { 0x3adc } /* "@mozilla.org/gfx/printerlist;1" */,
            ModuleID::Anonymous364,
          },
  
          {
            { 0x5fd } /* "@mozilla.org/browser/final-clh;1" */,
            ModuleID::Anonymous003,
          },
  
          {
            { 0x3afb } /* "@mozilla.org/layout/contentserializer;1?mimetype=text/plain" */,
            ModuleID::Anonymous443,
          },
  
          {
            { 0x3b37 } /* "@mozilla.org/thirdpartyutil;1" */,
            ModuleID::ThirdPartyUtil,
          },
  
          {
            { 0x3b55 } /* "@mozilla.org/permissiondelegatehandler;1" */,
            ModuleID::Anonymous076,
          },
  
          {
            { 0x3b7e } /* "@mozilla.org/addons/policy-service;1" */,
            ModuleID::ExtensionPolicy,
          },
  
          {
            { 0x3ba3 } /* "@mozilla.org/security/certoverride;1" */,
            ModuleID::Anonymous206,
          },
  
          {
            { 0x3bc8 } /* "@mozilla.org/dom/peerconnectionobserver;1" */,
            ModuleID::Anonymous042,
          },
  
          {
            { 0x3bf2 } /* "@mozilla.org/binaryoutputstream;1" */,
            ModuleID::Anonymous368,
          },
  
          {
            { 0x3c14 } /* "@mozilla.org/systemprincipal;1" */,
            ModuleID::Anonymous457,
          },
  
          {
            { 0x3c33 } /* "@mozilla.org/network/url-parser;1?auth=maybe" */,
            ModuleID::Anonymous158,
          },
  
          {
            { 0x3c60 } /* "@mozilla.org/streamconv;1?from=application/vnd.mozilla.json.view&to=*\/\*" */,
            ModuleID::Anonymous017,
          },
  
          {
            { 0x3ca8 } /* "@mozilla.org/intl/ospreferences;1" */,
            ModuleID::Anonymous094,
          },
  
          {
            { 0x3cca } /* "@mozilla.org/hash-property-bag;1" */,
            ModuleID::Anonymous370,
          },
  
          {
            { 0x3ceb } /* "@mozilla.org/url-classifier/prefixset;1" */,
            ModuleID::UrlClassifierPrefixSet,
          },
  
          {
            { 0x3d13 } /* "@mozilla.org/cookieJarSettings;1" */,
            ModuleID::Anonymous177,
          },
  
          {
            { 0x3d34 } /* "@mozilla.org/extensions/blocklist;1" */,
            ModuleID::Anonymous321,
          },
  
          {
            { 0x3d58 } /* "@mozilla.org/intl/localeservice;1" */,
            ModuleID::Locale,
          },
  
          {
            { 0x3d7a } /* "@mozilla.org/network/atomic-file-output-stream;1" */,
            ModuleID::Anonymous112,
          },
  
          {
            { 0x3dab } /* "@mozilla.org/xpcom/version-comparator;1" */,
            ModuleID::Anonymous396,
          },
  
          {
            { 0x3dd3 } /* "@mozilla.org/memory-info-dumper;1" */,
            ModuleID::Anonymous373,
          },
  
          {
            { 0x3df5 } /* "@mozilla.org/childprocessmessagemanager;1" */,
            ModuleID::Anonymous415,
          },
  
          {
            { 0x3e1f } /* "@mozilla.org/network/simple-stream-listener;1" */,
            ModuleID::Anonymous149,
          },
  
          {
            { 0x3e4d } /* "@mozilla.org/network/protocol/about;1?what=certerror" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x3e82 } /* "@mozilla.org/url-classifier/channel-classifier-service;1" */,
            ModuleID::Anonymous191,
          },
  
          {
            { 0x3ebb } /* "@mozilla.org/login-manager/prompter;1" */,
            ModuleID::Anonymous279,
          },
  
          {
            { 0x3ee1 } /* "@mozilla.org/embedding/browser/nsWebBrowserPersist;1" */,
            ModuleID::Anonymous331,
          },
  
          {
            { 0x3f16 } /* "@mozilla.org/url-classifier/dbservice;1" */,
            ModuleID::UrlClassifierDB,
          },
  
          {
            { 0x3f3e } /* "@mozilla.org/security/random-generator;1" */,
            ModuleID::RandomGenerator,
          },
  
          {
            { 0x3f67 } /* "@mozilla.org/places/previews-helper;1" */,
            ModuleID::PlacesPreviewsHelper,
          },
  
          {
            { 0x3f8d } /* "@mozilla.org/login-manager/loginInfo;1" */,
            ModuleID::Anonymous277,
          },
  
          {
            { 0x3fb4 } /* "@mozilla.org/network/protocol/about;1?what=compat" */,
            ModuleID::Anonymous015,
          },
  
          {
            { 0x3fe6 } /* "@mozilla.org/network/protocol;1?name=resource" */,
            ModuleID::Anonymous141,
          },
  
          {
            { 0x4014 } /* "@mozilla.org/network/mime-hdrparam;1" */,
            ModuleID::MimeHeaderParam,
          },
  
          {
            { 0x4039 } /* "@mozilla.org/streamconv;1?from=br&to=uncompressed" */,
            ModuleID::Anonymous163,
          },
  
          {
            { 0x406b } /* "@mozilla.org/parental-controls-service;1" */,
            ModuleID::Anonymous242,
          },
  
          {
            { 0x4094 } /* "@mozilla.org/network/oblivious-http;1" */,
            ModuleID::Anonymous188,
          },
  
          {
            { 0x40ba } /* "@mozilla.org/mozintlhelper;1" */,
            ModuleID::Anonymous269,
          },
  
          {
            { 0x40d7 } /* "@mozilla.org/gfx/content/screenmanager;1" */,
            ModuleID::Anonymous347,
          },
  
          {
            { 0x4100 } /* "@mozilla.org/dom/indexeddb/manager;1" */,
            ModuleID::Anonymous036,
          },
  
          {
            { 0x4125 } /* "@mozilla.org/scriptablebase64encoder;1" */,
            ModuleID::Anonymous376,
          },
  
          {
            { 0x414c } /* "@mozilla.org/network-error-logging;1" */,
            ModuleID::NetworkErrorLogging,
          },
  
          {
            { 0x4171 } /* "@mozilla.org/colorpicker;1" */,
            ModuleID::Anonymous340,
          },
  
          {
            { 0x418c } /* "@mozilla.org/uuid-generator;1" */,
            ModuleID::UUIDGenerator,
          },
  
          {
            { 0x59a } /* "@mozilla.org/remote/agent;1" */,
            ModuleID::Anonymous195,
          },
  
          {
            { 0x41aa } /* "@mozilla.org/network/protocol/about;1?what=logins" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x41dc } /* "@mozilla.org/storagestream;1" */,
            ModuleID::Anonymous378,
          },
  
          {
            { 0x41f9 } /* "@mozilla.org/network/util;1" */,
            ModuleID::IO,
          },
  
          {
            { 0x4215 } /* "@mozilla.org/process/util;1" */,
            ModuleID::Anonymous375,
          },
  
          {
            { 0x4231 } /* "@mozilla.org/network/tcp-filter-handler;1?name=stun" */,
            ModuleID::Anonymous039,
          },
  
          {
            { 0x4265 } /* "@mozilla.org/addon-web-api/manager;1" */,
            ModuleID::Anonymous324,
          },
  
          {
            { 0x428a } /* "@mozilla.org/autocomplete/simple-result;1" */,
            ModuleID::Anonymous234,
          },
  
          {
            { 0xf11 } /* "@mozilla.org/readconfig;1" */,
            ModuleID::Anonymous078,
          },
  
          {
            { 0x42b4 } /* "@mozilla.org/url-classifier/test-utils;1" */,
            ModuleID::UrlClassifierTestUtils,
          },
  
          {
            { 0x42dd } /* "@mozilla.org/toolkit/profile-service;1" */,
            ModuleID::Anonymous334,
          },
  
          {
            { 0x4304 } /* "@mozilla.org/netwerk/cache-storage-service;1" */,
            ModuleID::CacheStorage,
          },
  
          {
            { 0x4331 } /* "@mozilla.org/toolkit/download-platform;1" */,
            ModuleID::DownloadPlatform,
          },
  
          {
            { 0x435a } /* "@mozilla.org/streamconv;1?from=multipart/x-mixed-replace&to=*\/\*" */,
            ModuleID::Anonymous164,
          },
  
          {
            { 0x439a } /* "@mozilla.org/mediaManagerService;1" */,
            ModuleID::Anonymous444,
          },
  
          {
            { 0x43bd } /* "@mozilla.org/appshell/appShellService;1" */,
            ModuleID::Anonymous407,
          },
  
          {
            { 0x43e5 } /* "@mozilla.org/network/protocol/about;1?what=framecrashed" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x441d } /* "@mozilla.org/prefetch-service;1" */,
            ModuleID::Prefetch,
          },
  
          {
            { 0x443d } /* "@mozilla.org/network/protocol/about;1?what=crashparent" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x4474 } /* "@mozilla.org/uriloader/handler-service;1" */,
            ModuleID::Anonymous026,
          },
  
          {
            { 0x449d } /* "@mozilla.org/network/network-link-service;1" */,
            ModuleID::Anonymous181,
          },
  
          {
            { 0x44c9 } /* "@mozilla.org/network/cache-storage-service;1" */,
            ModuleID::CacheStorage,
          },
  
          {
            { 0x44f6 } /* "@mozilla.org/dom/session-storage-service;1" */,
            ModuleID::Anonymous073,
          },
  
          {
            { 0x4521 } /* "@mozilla.org/alert-notification;1" */,
            ModuleID::AlertNotification,
          },
  
          {
            { 0x4543 } /* "@mozilla.org/url-classifier/utils;1" */,
            ModuleID::UrlClassifierUtils,
          },
  
          {
            { 0x4567 } /* "@mozilla.org/network/load-group;1" */,
            ModuleID::Anonymous128,
          },
  
          {
            { 0x4589 } /* "@mozilla.org/dom/peerconnectionmanager;1" */,
            ModuleID::Anonymous046,
          },
  
          {
            { 0x45b2 } /* "@mozilla.org/network/protocol/about;1?what=blocked" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x519 } /* "@mozilla.org/browser/clh;1" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x45e5 } /* "@mozilla.org/nsCertificateDialogs;1" */,
            ModuleID::Anonymous197,
          },
  
          {
            { 0x4609 } /* "@mozilla.org/appshell/component/browser-status-filter;1" */,
            ModuleID::Anonymous241,
          },
  
          {
            { 0x4641 } /* "@mozilla.org/network/protocol/about;1?what=policies" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x4675 } /* "@mozilla.org/widget/parent/clipboard;1" */,
            ModuleID::Anonymous357,
          },
  
          {
            { 0x469c } /* "@mozilla.org/http-sfv-service;1" */,
            ModuleID::Anonymous176,
          },
  
          {
            { 0x46bc } /* "@mozilla.org/parserutils;1" */,
            ModuleID::Anonymous451,
          },
  
          {
            { 0x46d7 } /* "@mozilla.org/gfx/fontenumerator;1" */,
            ModuleID::Anonymous081,
          },
  
          {
            { 0x46f9 } /* "@mozilla.org/network/protocol/about;1?what=aichatcontent" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x53f } /* "@mozilla.org/devtools/startup-clh;1" */,
            ModuleID::Anonymous020,
          },
  
          {
            { 0x4732 } /* "@mozilla.org/network/protocol/about;1?what=webrtc" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x4764 } /* "@mozilla.org/network/protocol/about;1?what=devtools-toolbox" */,
            ModuleID::Anonymous022,
          },
  
          {
            { 0x47a0 } /* "@mozilla.org/security/ClientAuthDialogService;1" */,
            ModuleID::Anonymous215,
          },
  
          {
            { 0x786 } /* "@mozilla.org/cspservice;1" */,
            ModuleID::Anonymous420,
          },
  
          {
            { 0x47d0 } /* "@mozilla.org/dom/rtcsessiondescription;1" */,
            ModuleID::Anonymous045,
          },
  
          {
            { 0x47f9 } /* "@mozilla.org/uriloader/content-handler;1?type=image/bmp" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x4831 } /* "@mozilla.org/xpcom/ini-parser-factory;1" */,
            ModuleID::Anonymous397,
          },
  
          {
            { 0x4859 } /* "@mozilla.org/url-classifier/exception-list;1" */,
            ModuleID::Anonymous194,
          },
  
          {
            { 0x4886 } /* "@mozilla.org/network/protocol/about;1?what=crashes" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x48b9 } /* "@mozilla.org/network/protocol/about;1?what=performance" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x48f0 } /* "@mozilla.org/network/protocol/about;1?what=memory" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x12ea } /* "@mozilla.org/browser/nav-history-service;1" */,
            ModuleID::Anonymous285,
          },
  
          {
            { 0x467 } /* "@mozilla.org/test/startuprecorder;1" */,
            ModuleID::Anonymous005,
          },
  
          {
            { 0x4922 } /* "@mozilla.org/browser/browserglue;1" */,
            ModuleID::Anonymous004,
          },
  
          {
            { 0x2a00 } /* "@mozilla.org/system-info;1" */,
            ModuleID::SystemInfo,
          },
  
          {
            { 0x4945 } /* "@mozilla.org/network/protocol;1?name=indexeddb" */,
            ModuleID::Anonymous072,
          },
  
          {
            { 0x4974 } /* "@mozilla.org/net/CachePurgeLock;1" */,
            ModuleID::Anonymous182,
          },
  
          {
            { 0x4996 } /* "@mozilla.org/satchel/form-history-autocomplete;1" */,
            ModuleID::Anonymous303,
          },
  
          {
            { 0x49c7 } /* "@mozilla.org/network/protocol/about;1?what=certificate" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x49fe } /* "@mozilla.org/array;1" */,
            ModuleID::Anonymous399,
          },
  
          {
            { 0x4a13 } /* "@mozilla.org/uriloader/content-handler;1?type=image/x-icon" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x4a4e } /* "@mozilla.org/sandbox/sandbox-settings;1" */,
            ModuleID::Anonymous216,
          },
  
          {
            { 0x1371 } /* "@mozilla.org/network/protocol;1?name=moz-gio" */,
            ModuleID::Anonymous185,
          },
  
          {
            { 0x4a76 } /* "@mozilla.org/system-proxy-settings;1" */,
            ModuleID::Anonymous329,
          },
  
          {
            { 0x4a9b } /* "@mozilla.org/autocomplete/search;1?name=login-doorhanger-username" */,
            ModuleID::Anonymous280,
          },
  
          {
            { 0x4add } /* "@mozilla.org/uriloader/content-handler;1?type=text/xml" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x4b14 } /* "@mozilla.org/network/protocol/about;1?what=studies" */,
            ModuleID::Anonymous272,
          },
  
          {
            { 0xe8b } /* "@mozilla.org/places/frecency-recalculator;1" */,
            ModuleID::Anonymous292,
          },
  
          {
            { 0x4b47 } /* "@mozilla.org/network/http-auth-cache;1" */,
            ModuleID::HttpAuthCache,
          },
  
          {
            { 0x4b6e } /* "@mozilla.org/network/http-activity-distributor;1" */,
            ModuleID::HttpActivityDistributor,
          },
  
          {
            { 0x4b9f } /* "@mozilla.org/network/protocol;1?name=file" */,
            ModuleID::FileProtocolHandler,
          },
  
          {
            { 0x4bc9 } /* "@mozilla.org/network/cors-preflight-cache;1" */,
            ModuleID::CORSPreflightCache,
          },
  
          {
            { 0xcde } /* "@mozilla.org/dom/payments/payment-address;1" */,
            ModuleID::Anonymous063,
          },
  
          {
            { 0x4bf5 } /* "@mozilla.org/base/telemetry;1" */,
            ModuleID::Anonymous309,
          },
  
          {
            { 0x4c13 } /* "@mozilla.org/dom/rtcicecandidate;1" */,
            ModuleID::Anonymous044,
          },
  
          {
            { 0x4c36 } /* "@mozilla.org/ospermissionrequest;1" */,
            ModuleID::Anonymous025,
          },
  
          {
            { 0x4c59 } /* "@mozilla.org/btp-remote-exception-list;1" */,
            ModuleID::Anonymous225,
          },
  
          {
            { 0x4c82 } /* "@mozilla.org/login-manager/authprompter;1" */,
            ModuleID::Anonymous276,
          },
  
          {
            { 0x4cac } /* "@mozilla.org/network/downloader;1" */,
            ModuleID::Anonymous119,
          },
  
          {
            { 0x4cce } /* "@mozilla.org/login-detection-service;1" */,
            ModuleID::Anonymous037,
          },
  
          {
            { 0x4cf5 } /* "@mozilla.org/content-blocking-allow-list;1" */,
            ModuleID::Anonymous249,
          },
  
          {
            { 0x4d20 } /* "@mozilla.org/content/dropped-link-handler;1" */,
            ModuleID::Anonymous030,
          },
  
          {
            { 0x4d4c } /* "@mozilla.org/backgroundtasksrunner;1" */,
            ModuleID::Anonymous237,
          },
  
          {
            { 0x570 } /* "@mozilla.org/remote/marionette;1" */,
            ModuleID::Anonymous196,
          },
  
          {
            { 0x4d71 } /* "@mozilla.org/addons/integration;1" */,
            ModuleID::Anonymous322,
          },
  
          {
            { 0x4d93 } /* "@mozilla.org/network/protocol/about;1?what=telemetry" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x4dc8 } /* "@mozilla.org/network/native-dns-override;1" */,
            ModuleID::Anonymous118,
          },
  
          {
            { 0x4df3 } /* "@mozilla.org/network/protocol;1?name=ws" */,
            ModuleID::Anonymous144,
          },
  
          {
            { 0x4e1b } /* "@mozilla.org/libjar/zip-reader-cache;1" */,
            ModuleID::Anonymous104,
          },
  
          {
            { 0x4e42 } /* "@mozilla.org/private-attribution;1" */,
            ModuleID::PrivateAttribution,
          },
  
          {
            { 0x5bc } /* "@mozilla.org/browser/selectable-profiles-service-clh;1" */,
            ModuleID::Anonymous010,
          },
  
          {
            { 0x4e65 } /* "@mozilla.org/network/protocol/about;1?what=deleteprofile" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x4e9e } /* "@mozilla.org/uriloader/content-handler;1?type=text/plain" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x4ed7 } /* "@mozilla.org/network/protocol;1?name=data" */,
            ModuleID::Anonymous135,
          },
  
          {
            { 0x4f01 } /* "@mozilla.org/network/udp-filter-handler;1?name=stun" */,
            ModuleID::Anonymous040,
          },
  
          {
            { 0x4f35 } /* "@mozilla.org/network/protocol/about;1?what=translations" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x4f6d } /* "@mozilla.org/layout/contentserializer;1?mimetype=application/vnd.mozilla.xul+xml" */,
            ModuleID::Anonymous440,
          },
  
          {
            { 0x4fbe } /* "@mozilla.org/storage/service;1" */,
            ModuleID::Anonymous223,
          },
  
          {
            { 0x4fdd } /* "@mozilla.org/async-shutdown-service;1" */,
            ModuleID::AsyncShutdown,
          },
  
          {
            { 0x5003 } /* "@mozilla.org/dom/sessionStorage-manager;1" */,
            ModuleID::Anonymous428,
          },
  
          {
            { 0x502d } /* "@mozilla.org/gfx/devicecontextspec;1" */,
            ModuleID::Anonymous361,
          },
  
          {
            { 0xfb9 } /* "@mozilla.org/EssentialDomainsRemoteSettings;1" */,
            ModuleID::Anonymous180,
          },
  
          {
            { 0x5052 } /* "@mozilla.org/network/protocol/about;1?what=keyboard" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x5086 } /* "@mozilla.org/network/throttlequeue;1" */,
            ModuleID::Anonymous155,
          },
  
          {
            { 0xb67 } /* "@mozilla.org/dom/payments/basiccard-change-details;1" */,
            ModuleID::Anonymous058,
          },
  
          {
            { 0x50ab } /* "@mozilla.org/embeddor.implemented/web-protocol-handler-registrar;1" */,
            ModuleID::Anonymous012,
          },
  
          {
            { 0x703 } /* "@mozilla.org/integritypolicyservice;1" */,
            ModuleID::Anonymous422,
          },
  
          {
            { 0x50ee } /* "@mozilla.org/browser/shell-service;1" */,
            ModuleID::Anonymous001,
          },
  
          {
            { 0x5113 } /* "@mozilla.org/network/protocol/about;1?what=crashextensions" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x74c } /* "@mozilla.org/no-data-protocol-content-policy;1" */,
            ModuleID::Anonymous448,
          },
  
          {
            { 0x514e } /* "@mozilla.org/observer-service;1" */,
            ModuleID::Observer,
          },
  
          {
            { 0x516e } /* "@mozilla.org/webauthn/service;1" */,
            ModuleID::Anonymous075,
          },
  
          {
            { 0x518e } /* "@mozilla.org/supports-interface-pointer;1" */,
            ModuleID::Anonymous383,
          },
  
          {
            { 0x51b8 } /* "@mozilla.org/network/buffered-input-stream;1" */,
            ModuleID::Anonymous116,
          },
  
          {
            { 0x51e5 } /* "@mozilla.org/network/protocol/about;1?what=neterror" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x5219 } /* "@mozilla.org/peerconnection;1" */,
            ModuleID::Anonymous038,
          },
  
          {
            { 0x5237 } /* "@mozilla.org/network/protocol/about;1?what=welcomeback" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x526e } /* "@mozilla.org/autocomplete/search;1?name=search-autocomplete" */,
            ModuleID::Anonymous306,
          },
  
          {
            { 0x52aa } /* "@mozilla.org/security/osreauthenticator;1" */,
            ModuleID::Anonymous209,
          },
  
          {
            { 0x52d4 } /* "@mozilla.org/network/mock-network-controller;1" */,
            ModuleID::Anonymous179,
          },
  
          {
            { 0x20b } /* "@mozilla.org/content/document-loader-factory;1" */,
            ModuleID::Anonymous416,
          },
  
          {
            { 0x5303 } /* "@mozilla.org/network/protocol/about;1?what=profilemanager" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x533d } /* "@mozilla.org/network/protocol;1?name=blob" */,
            ModuleID::Anonymous035,
          },
  
          {
            { 0x5367 } /* "@mozilla.org/streamconv;1?from=uncompressed&to=x-gzip" */,
            ModuleID::Anonymous105,
          },
  
          {
            { 0x539d } /* "@mozilla.org/xre/runtime;1" */,
            ModuleID::XULRuntime,
          },
  
          {
            { 0x53b8 } /* "@mozilla.org/docshell/uri-fixup;1" */,
            ModuleID::URIFixup,
          },
  
          {
            { 0x53da } /* "@mozilla.org/network/protocol;1?name=moz-extension" */,
            ModuleID::Anonymous137,
          },
  
          {
            { 0x540d } /* "@mozilla.org/url-classifier/hashcompleter;1" */,
            ModuleID::Anonymous314,
          },
  
          {
            { 0x628 } /* "@mozilla.org/toolkit/default-clh;1" */,
            ModuleID::Anonymous248,
          },
  
          {
            { 0x5439 } /* "@mozilla.org/network/protocol/about;1?what=about" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x546a } /* "@mozilla.org/widget/dragservice;1" */,
            ModuleID::Anonymous342,
          },
  
          {
            { 0x548c } /* "@mozilla.org/dom/peerconnectionstatic;1" */,
            ModuleID::Anonymous048,
          },
  
          {
            { 0x54b4 } /* "@mozilla.org/content/plugin/document-loader-factory;1" */,
            ModuleID::Anonymous417,
          },
  
          {
            { 0x54ea } /* "@mozilla.org/uriloader/content-handler;1?type=image/gif" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x5522 } /* "@mozilla.org/supports-cstring;1" */,
            ModuleID::Anonymous379,
          },
  
          {
            { 0x5542 } /* "@mozilla.org/uriloader/dbus-handler-app;1" */,
            ModuleID::DBusHandlerApp,
          },
  
          {
            { 0x556c } /* "@mozilla.org/login-manager;1" */,
            ModuleID::Anonymous273,
          },
  
          {
            { 0x5589 } /* "@mozilla.org/devicesensors;1" */,
            ModuleID::Anonymous425,
          },
  
          {
            { 0x55a6 } /* "@mozilla.org/network/protocol/about;1?what=robots" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x55d8 } /* "@mozilla.org/variant;1" */,
            ModuleID::Anonymous395,
          },
  
          {
            { 0x55ef } /* "@mozilla.org/security/sdr;1" */,
            ModuleID::Anonymous199,
          },
  
          {
            { 0x560b } /* "@mozilla.org/process/environment;1" */,
            ModuleID::Anonymous404,
          },
  
          {
            { 0x562e } /* "@mozilla.org/supports-double;1" */,
            ModuleID::Anonymous381,
          },
  
          {
            { 0x564d } /* "@mozilla.org/sqlite-key-value-service;1" */,
            ModuleID::Anonymous265,
          },
  
          {
            { 0x5675 } /* "@mozilla.org/network/protocol/about;1?what=preferences" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x56ac } /* "@mozilla.org/image/encoder;2?type=image/webp" */,
            ModuleID::Anonymous090,
          },
  
          {
            { 0x56d9 } /* "@mozilla.org/network/udp-socket;1" */,
            ModuleID::Anonymous157,
          },
  
          {
            { 0x56fb } /* "@mozilla.org/network/protocol/about;1?what=opentabs" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x572f } /* "@mozilla.org/backgroundtasks;1" */,
            ModuleID::Anonymous235,
          },
  
          {
            { 0x574e } /* "@mozilla.org/supports-PRUint64;1" */,
            ModuleID::Anonymous391,
          },
  
          {
            { 0x576f } /* "@mozilla.org/network/protocol/about;1?what=tabcrashed" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x57a5 } /* "@mozilla.org/pref-localizedstring;1" */,
            ModuleID::Anonymous107,
          },
  
          {
            { 0x6d7 } /* "@mozilla.org/image-blocker-content-policy;1" */,
            ModuleID::Anonymous083,
          },
  
          {
            { 0x9b7 } /* "@mozilla.org/dom/quota-manager-service;1" */,
            ModuleID::Anonymous429,
          },
  
          {
            { 0x57c9 } /* "@mozilla.org/uriloader/content-handler;1?type=image/svg+xml" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x5805 } /* "@mozilla.org/login-manager/autocompletesearch;1" */,
            ModuleID::Anonymous275,
          },
  
          {
            { 0x5835 } /* "@mozilla.org/extensions/native-messaging-portal;1" */,
            ModuleID::Anonymous261,
          },
  
          {
            { 0xc48 } /* "@mozilla.org/dom/payments/general-response-data;1" */,
            ModuleID::Anonymous061,
          },
  
          {
            { 0x5867 } /* "@mozilla.org/network/safe-file-output-stream;1" */,
            ModuleID::Anonymous146,
          },
  
          {
            { 0x5896 } /* "@mozilla.org/uriloader/content-handler;1?type=image/jpeg" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x58cf } /* "@mozilla.org/embedcomp/dialogparam;1" */,
            ModuleID::Anonymous333,
          },
  
          {
            { 0x58f4 } /* "@mozilla.org/streamconv;1?from=uncompressed&to=rawdeflate" */,
            ModuleID::Anonymous105,
          },
  
          {
            { 0x592e } /* "@mozilla.org/security/contentsignatureverifier;1" */,
            ModuleID::Anonymous205,
          },
  
          {
            { 0x595f } /* "@mozilla.org/network/protocol/about;1?what=cache-entry" */,
            ModuleID::Anonymous133,
          },
  
          {
            { 0x5996 } /* "@mozilla.org/security/nssversion;1" */,
            ModuleID::Anonymous198,
          },
  
          {
            { 0x59b9 } /* "@mozilla.org/gfx/screenmanager;1" */,
            ModuleID::Anonymous346,
          },
  
          {
            { 0x59da } /* "@mozilla.org/network/protocol/about;1?what=blank" */,
            ModuleID::Anonymous131,
          },
  
          {
            { 0x5a0b } /* "@mozilla.org/supports-PRBool;1" */,
            ModuleID::Anonymous384,
          },
  
          {
            { 0x5a2a } /* "@mozilla.org/network/protocol/about;1?what=restricted" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x5a60 } /* "@mozilla.org/network/protocol/about;1?what=serviceworkers" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x5a9a } /* "@mozilla.org/dom/rtpsender;1" */,
            ModuleID::Anonymous049,
          },
  
          {
            { 0x5ab7 } /* "@mozilla.org/jsctypes;1" */,
            ModuleID::Anonymous256,
          },
  
          {
            { 0x5acf } /* "@mozilla.org/thread-manager;1" */,
            ModuleID::Anonymous394,
          },
  
          {
            { 0x5aed } /* "@mozilla.org/streamconv;1?from=compress&to=uncompressed" */,
            ModuleID::Anonymous163,
          },
  
          {
            { 0x5b25 } /* "@mozilla.org/supports-PRTime;1" */,
            ModuleID::Anonymous388,
          },
  
          {
            { 0x5b44 } /* "@mozilla.org/parent/filepicker;1" */,
            ModuleID::Anonymous352,
          },
  
          {
            { 0xbb2 } /* "@mozilla.org/dom/payments/basiccard-response-data;1" */,
            ModuleID::Anonymous059,
          },
  
          {
            { 0x5b65 } /* "@mozilla.org/network/protocol/about;1?what=buildconfig" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x5b9c } /* "@mozilla.org/network/protocol-proxy-service;1" */,
            ModuleID::ProtocolProxy,
          },
  
          {
            { 0x5bca } /* "@mozilla.org/streamconv;1?from=x-compress&to=uncompressed" */,
            ModuleID::Anonymous163,
          },
  
          {
            { 0x5c04 } /* "@mozilla.org/browser/credentialchooserservice;1" */,
            ModuleID::CredentialChooserService,
          },
  
          {
            { 0xeca } /* "@mozilla.org/places/expiration;1" */,
            ModuleID::Anonymous288,
          },
  
          {
            { 0x5c34 } /* "@mozilla.org/jsreflect;1" */,
            ModuleID::Anonymous296,
          },
  
          {
            { 0x5c4d } /* "@mozilla.org/network/protocol;1?name=moz-newtab-wallpaper" */,
            ModuleID::Anonymous139,
          },
  
          {
            { 0x5c87 } /* "@mozilla.org/thumbnails/pagethumbs-service;1" */,
            ModuleID::PageThumbsStorage,
          },
  
          {
            { 0xe22 } /* "@mozilla.org/dom/payments/payment-show-action-response;1" */,
            ModuleID::Anonymous067,
          },
  
          {
            { 0x5cb4 } /* "@mozilla.org/gfx/parent/screenmanager;1" */,
            ModuleID::Anonymous349,
          },
  
          {
            { 0x5cdc } /* "@mozilla.org/memory-reporter-manager;1" */,
            ModuleID::Anonymous374,
          },
  
          {
            { 0xd81 } /* "@mozilla.org/dom/payments/payment-complete-action-response;1" */,
            ModuleID::Anonymous065,
          },
  
          {
            { 0x5d03 } /* "@mozilla.org/serviceworkers/manager;1" */,
            ModuleID::ServiceWorkerManager,
          },
  
          {
            { 0x5d29 } /* "@mozilla.org/find/find_service;1" */,
            ModuleID::FindService,
          },
  
          {
            { 0x5d4a } /* "@mozilla.org/widget/transferable;1" */,
            ModuleID::Anonymous355,
          },
  
          {
            { 0x122e } /* "@mozilla.org/fxaccounts/push;1" */,
            ModuleID::Anonymous218,
          },
  
          {
            { 0x5d6d } /* "@mozilla.org/network/protocol;1?name=moz-icon" */,
            ModuleID::Anonymous091,
          },
  
          {
            { 0x5d9b } /* "@mozilla.org/uriloader/external-helper-app-service;1" */,
            ModuleID::Anonymous029,
          },
  
          {
            { 0x5dd0 } /* "@mozilla.org/third-party-cookie-blocking-exception-list-service;1" */,
            ModuleID::Anonymous183,
          },
  
          {
            { 0x5e12 } /* "@mozilla.org/security/transportsecurityinfo;1" */,
            ModuleID::Anonymous207,
          },
  
          {
            { 0x5e40 } /* "@mozilla.org/streamconv;1?from=application/http-index-format&to=text/html" */,
            ModuleID::Anonymous161,
          },
  
          {
            { 0x1338 } /* "@mozilla.org/fork-server-launcher;1" */,
            ModuleID::Anonymous098,
          },
  
          {
            { 0x5e8a } /* "@mozilla.org/layout/contentserializer;1?mimetype=text/xml" */,
            ModuleID::Anonymous440,
          },
  
          {
            { 0x5ec4 } /* "@mozilla.org/memoryNotificationStorage;1" */,
            ModuleID::Anonymous056,
          },
  
          {
            { 0x5eed } /* "@mozilla.org/addons/glean-daily-ping;1" */,
            ModuleID::Anonymous323,
          },
  
          {
            { 0x5f14 } /* "@mozilla.org/inspector/deep-tree-walker;1" */,
            ModuleID::Anonymous438,
          },
  
          {
            { 0x115f } /* "@mozilla.org/rfp-service;1" */,
            ModuleID::RFPService,
          },
  
          {
            { 0x5f3e } /* "@mozilla.org/load-context-info-factory;1" */,
            ModuleID::Anonymous110,
          },
  
          {
            { 0x5f67 } /* "@mozilla.org/security/pk11tokendb;1" */,
            ModuleID::Anonymous200,
          },
  
          {
            { 0x5f8b } /* "@mozilla.org/jsinspector;1" */,
            ModuleID::Anonymous018,
          },
  
          {
            { 0x5fa6 } /* "@mozilla.org/gfx/info;1" */,
            ModuleID::GfxInfo,
          },
  
          {
            { 0x5fbe } /* "@mozilla.org/streamconv;1?from=uncompressed&to=gzip" */,
            ModuleID::Anonymous105,
          },
  
          {
            { 0x5ff2 } /* "@mozilla.org/network/stream-listener-tee;1" */,
            ModuleID::Anonymous153,
          },
  
          {
            { 0x601d } /* "@mozilla.org/network/protocol/about;1?what=editprofile" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x6054 } /* "@mozilla.org/network/protocol/about;1?what=firefoxview" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x608b } /* "@mozilla.org/webtransportevent/service;1" */,
            ModuleID::Anonymous461,
          },
  
          {
            { 0x60b4 } /* "@mozilla.org/main-process-singleton;1" */,
            ModuleID::Anonymous293,
          },
  
          {
            { 0xdd4 } /* "@mozilla.org/dom/payments/payment-request-service;1" */,
            ModuleID::Anonymous066,
          },
  
          {
            { 0x60da } /* "@mozilla.org/synth-voice-registry;1" */,
            ModuleID::Anonymous462,
          },
  
          {
            { 0x60fe } /* "@mozilla.org/cookie-banner-rule;1" */,
            ModuleID::Anonymous251,
          },
  
          {
            { 0x6120 } /* "@mozilla.org/network/protocol/about;1?what=messagepreview" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x615a } /* "@mozilla.org/third-party-cookie-exception-entry;1" */,
            ModuleID::Anonymous184,
          },
  
          {
            { 0xa4d } /* "@mozilla.org/cookie-banner-service;1" */,
            ModuleID::CookieBannerService,
          },
  
          {
            { 0x618c } /* "@mozilla.org/dom/rtpreceiver;1" */,
            ModuleID::Anonymous050,
          },
  
          {
            { 0x61ab } /* "@mozilla.org/enterprisepolicies;1" */,
            ModuleID::Anonymous259,
          },
  
          {
            { 0x61cd } /* "@mozilla.org/layout/contentserializer;1?mimetype=image/svg+xml" */,
            ModuleID::Anonymous440,
          },
  
          {
            { 0x620c } /* "@mozilla.org/push/PushManager;1" */,
            ModuleID::Anonymous069,
          },
  
          {
            { 0x622c } /* "@mozilla.org/layout/contentserializer;1?mimetype=application/xhtml+xml" */,
            ModuleID::Anonymous441,
          },
  
          {
            { 0x6273 } /* "@mozilla.org/timer-manager;1" */,
            ModuleID::Anonymous406,
          },
  
          {
            { 0x6290 } /* "@mozilla.org/globalmessagemanager;1" */,
            ModuleID::Anonymous437,
          },
  
          {
            { 0x62b4 } /* "@mozilla.org/network/protocol/about;1?what=profiling" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0xa98 } /* "@mozilla.org/devtools/jsonview-sniffer;1" */,
            ModuleID::Anonymous016,
          },
  
          {
            { 0x62e9 } /* "@mozilla.org/network/binary-http;1" */,
            ModuleID::Anonymous187,
          },
  
          {
            { 0x630c } /* "@mozilla.org/network/file-output-stream;1" */,
            ModuleID::Anonymous121,
          },
  
          {
            { 0x6336 } /* "@mozilla.org/uriloader/content-handler;1?type=image/vnd.microsoft.icon" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x637d } /* "@mozilla.org/network/buffered-output-stream;1" */,
            ModuleID::Anonymous117,
          },
  
          {
            { 0x63ab } /* "@mozilla.org/zipwriter;1" */,
            ModuleID::Anonymous106,
          },
  
          {
            { 0x63c4 } /* "@mozilla.org/toolkit/glean;1" */,
            ModuleID::Anonymous263,
          },
  
          {
            { 0x63e1 } /* "@mozilla.org/content-pref/service;1" */,
            ModuleID::Anonymous250,
          },
  
          {
            { 0x970 } /* "@mozilla.org/places/databaseUtilsIdleMaintenance;1" */,
            ModuleID::Anonymous289,
          },
  
          {
            { 0x6405 } /* "@mozilla.org/autocomplete/controller;1" */,
            ModuleID::Anonymous233,
          },
  
          {
            { 0x642c } /* "@mozilla.org/startupcacheinfo;1" */,
            ModuleID::Anonymous222,
          },
  
          {
            { 0x644c } /* "@mozilla.org/webnavigation-info;1" */,
            ModuleID::Anonymous028,
          },
  
          {
            { 0x646e } /* "@mozilla.org/transfer;1" */,
            ModuleID::Anonymous258,
          },
  
          {
            { 0x6486 } /* "@mozilla.org/addons/content-policy;1" */,
            ModuleID::AddonContentPolicy,
          },
  
          {
            { 0x29a7 } /* "@mozilla.org/xre/app-info;1" */,
            ModuleID::XULRuntime,
          },
  
          {
            { 0x64ab } /* "@mozilla.org/network/stream-loader;1" */,
            ModuleID::Anonymous154,
          },
  
          {
            { 0x64d0 } /* "@mozilla.org/network/protocol/about;1?what=profiles" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x6504 } /* "@mozilla.org/uriloader/content-handler;1?type=image/png" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x653c } /* "@mozilla.org/crashmanager;1" */,
            ModuleID::Anonymous254,
          },
  
          {
            { 0x6558 } /* "@mozilla.org/network/dashboard;1" */,
            ModuleID::Dashboard,
          },
  
          {
            { 0x6579 } /* "@mozilla.org/streamconv;1?from=application/octet-stream&to=*\/\*" */,
            ModuleID::Anonymous281,
          },
  
          {
            { 0x65b8 } /* "@mozilla.org/security/datastoragemanager;1" */,
            ModuleID::Anonymous214,
          },
  
          {
            { 0x65e3 } /* "@mozilla.org/network/async-stream-copier;1" */,
            ModuleID::Anonymous111,
          },
  
          {
            { 0x660e } /* "@mozilla.org/network/protocol/about;1?what=sessionrestore" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x6648 } /* "@mozilla.org/network/protocol/about;1?what=loginsimportreport" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x6686 } /* "@mozilla.org/network/protocol/about;1?what=settings" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x66ba } /* "@mozilla.org/layout/contentserializer;1?mimetype=application/xml" */,
            ModuleID::Anonymous440,
          },
  
          {
            { 0x66fb } /* "@mozilla.org/timer;1" */,
            ModuleID::Anonymous405,
          },
  
          {
            { 0x4af } /* "@mozilla.org/browser/taskbar-tabs-clh;1" */,
            ModuleID::Anonymous014,
          },
  
          {
            { 0x6710 } /* "@mozilla.org/supports-PRInt32;1" */,
            ModuleID::Anonymous386,
          },
  
          {
            { 0x6730 } /* "@mozilla.org/tracking-db-service;1" */,
            ModuleID::Anonymous227,
          },
  
          {
            { 0x6753 } /* "@mozilla.org/layout/contentserializer;1?mimetype=text/html" */,
            ModuleID::Anonymous442,
          },
  
          {
            { 0x678e } /* "@mozilla.org/network/protocol;1?name=http" */,
            ModuleID::HttpHandler,
          },
  
          {
            { 0x67b8 } /* "@mozilla.org/network/protocol/about;1?what=processes" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x7dc } /* "@mozilla.org/base/telemetry-controller-content;1" */,
            ModuleID::Anonymous308,
          },
  
          {
            { 0x67ed } /* "@mozilla.org/streamconv;1?from=zstd&to=uncompressed" */,
            ModuleID::Anonymous163,
          },
  
          {
            { 0x6821 } /* "@mozilla.org/network/idn-service;1" */,
            ModuleID::IDN,
          },
  
          {
            { 0x6844 } /* "@mozilla.org/helperapplauncherdialog;1" */,
            ModuleID::Anonymous320,
          },
  
          {
            { 0x686b } /* "@mozilla.org/content/style-sheet-service;1" */,
            ModuleID::Anonymous418,
          },
  
          {
            { 0x6896 } /* "@mozilla.org/dom/quota-utils-service;1" */,
            ModuleID::Anonymous071,
          },
  
          {
            { 0x2a43 } /* "@mozilla.org/widget/clipboard;1" */,
            ModuleID::Anonymous338,
          },
  
          {
            { 0x68bd } /* "@mozilla.org/network/protocol/about;1?what=crashcontent" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x68f5 } /* "@mozilla.org/push/Service;1" */,
            ModuleID::Anonymous070,
          },
  
          {
            { 0x6a7 } /* "@mozilla.org/embedding/browser/content-policy;1" */,
            ModuleID::Anonymous238,
          },
  
          {
            { 0x6911 } /* "@mozilla.org/scripterror;1" */,
            ModuleID::Anonymous455,
          },
  
          {
            { 0x67b } /* "@mozilla.org/data-document-content-policy;1" */,
            ModuleID::Anonymous424,
          },
  
          {
            { 0x692c } /* "@mozilla.org/network/protocol/about;1?what=reader" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x695e } /* "@mozilla.org/toolkit/captive-detector;1" */,
            ModuleID::Anonymous244,
          },
  
          {
            { 0x6986 } /* "@mozilla.org/browser/favicon-service;1" */,
            ModuleID::Anonymous283,
          },
  
          {
            { 0x69ad } /* "@mozilla.org/network/protocol/about;1?what=credits" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x69e0 } /* "@mozilla.org/text-input-processor;1" */,
            ModuleID::Anonymous458,
          },
  
          {
            { 0x6a04 } /* "@mozilla.org/dom/rtcstatsreport;1" */,
            ModuleID::Anonymous047,
          },
  
          {
            { 0x6a26 } /* "@mozilla.org/supports-PRUint16;1" */,
            ModuleID::Anonymous389,
          },
  
          {
            { 0x6a47 } /* "@mozilla.org/network/url-parser;1?auth=no" */,
            ModuleID::Anonymous159,
          },
  
          {
            { 0x6a71 } /* "@mozilla.org/consoleservice;1" */,
            ModuleID::Console,
          },
  
          {
            { 0x6a8f } /* "@mozilla.org/content-permission/prompt;1" */,
            ModuleID::Anonymous009,
          },
  
          {
            { 0x6ab8 } /* "@mozilla.org/referrer-info;1" */,
            ModuleID::Anonymous446,
          },
  
          {
            { 0x6ad5 } /* "@mozilla.org/widget/parent/dragservice;1" */,
            ModuleID::Anonymous359,
          },
  
          {
            { 0x10ea } /* "@mozilla.org/url-query-string-stripper;1" */,
            ModuleID::URLQueryStringStripper,
          },
  
          {
            { 0x6afe } /* "@mozilla.org/supports-PRInt16;1" */,
            ModuleID::Anonymous385,
          },
  
          {
            { 0x6b1e } /* "@mozilla.org/supports-PRInt64;1" */,
            ModuleID::Anonymous387,
          },
  
          {
            { 0x6b3e } /* "@mozilla.org/network/protocol;1?name=moz-page-thumb" */,
            ModuleID::Anonymous138,
          },
  
          {
            { 0x6b72 } /* "@mozilla.org/network/input-stream-pump;1" */,
            ModuleID::Anonymous127,
          },
  
          {
            { 0x6b9b } /* "@mozilla.org/ml-utils;1" */,
            ModuleID::Anonymous268,
          },
  
          {
            { 0x6bb3 } /* "@mozilla.org/geolocation/provider;1" */,
            ModuleID::Anonymous074,
          },
  
          {
            { 0x6bd7 } /* "@mozilla.org/network/background-file-saver;1?mode=outputstream" */,
            ModuleID::Anonymous113,
          },
  
          {
            { 0x6c16 } /* "@mozilla.org/intl/converter-input-stream;1" */,
            ModuleID::Anonymous095,
          },
  
          {
            { 0x6c41 } /* "@mozilla.org/network/protocol;1?name=page-icon" */,
            ModuleID::Anonymous290,
          },
  
          {
            { 0x6c70 } /* "@mozilla.org/uriloader/content-handler;1?type=image/jpg" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x6ca8 } /* "@mozilla.org/network/server-socket;1" */,
            ModuleID::Anonymous148,
          },
  
          {
            { 0x6ccd } /* "@mozilla.org/io/multiplex-input-stream;1" */,
            ModuleID::Anonymous400,
          },
  
          {
            { 0x6cf6 } /* "@mozilla.org/ipc/processselector;1" */,
            ModuleID::Anonymous032,
          },
  
          {
            { 0x6d19 } /* "@mozilla.org/toolkit/profile-migrator;1" */,
            ModuleID::Anonymous006,
          },
  
          {
            { 0x6d41 } /* "@mozilla.org/wifi/monitor;1" */,
            ModuleID::WifiMonitor,
          },
  
          {
            { 0x6d5d } /* "@mozilla.org/preferences-service;1" */,
            ModuleID::Preferences,
          },
  
          {
            { 0xd27 } /* "@mozilla.org/dom/payments/payment-canmake-action-response;1" */,
            ModuleID::Anonymous064,
          },
  
          {
            { 0x118f } /* "@mozilla.org/updates/timer-manager;1" */,
            ModuleID::Anonymous310,
          },
  
          {
            { 0x6d80 } /* "@mozilla.org/xpcom/memory-watcher;1" */,
            ModuleID::Anonymous366,
          },
  
          {
            { 0x6da4 } /* "@mozilla.org/uriloader/external-protocol-service;1" */,
            ModuleID::Anonymous029,
          },
  
          {
            { 0x6dd7 } /* "@mozilla.org/partitioning/exception-list-service;1" */,
            ModuleID::Anonymous230,
          },
  
          {
            { 0x6e0a } /* "@mozilla.org/network/protocol;1?name=chrome" */,
            ModuleID::Anonymous369,
          },
  
          {
            { 0x6e36 } /* "@mozilla.org/network/standard-url-mutator;1" */,
            ModuleID::Anonymous152,
          },
  
          {
            { 0x6e62 } /* "@mozilla.org/docshell/structured-clone-container;1" */,
            ModuleID::Anonymous426,
          },
  
          {
            { 0x6e95 } /* "@mozilla.org/image/encoder;2?type=image/png" */,
            ModuleID::Anonymous089,
          },
  
          {
            { 0x6ec1 } /* "@mozilla.org/network/protocol/about;1?what=fingerprintingprotection" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x843 } /* "@mozilla.org/image/cache;1" */,
            ModuleID::Anonymous082,
          },
  
          {
            { 0x6f05 } /* "@mozilla.org/network/protocol/about;1?what=config" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x6f37 } /* "@mozilla.org/toolkit/shell-service;1" */,
            ModuleID::Anonymous001,
          },
  
          {
            { 0x6f5c } /* "@mozilla.org/spellchecker/personaldictionary;1" */,
            ModuleID::Anonymous080,
          },
  
          {
            { 0x6f8b } /* "@mozilla.org/uriloader/content-handler;1?type=application/x-xpinstall" */,
            ModuleID::Anonymous325,
          },
  
          {
            { 0x6fd1 } /* "@mozilla.org/streamconv;1?from=application/pdf&to=text/html" */,
            ModuleID::Anonymous281,
          },
  
          {
            { 0x700d } /* "@mozilla.org/network/io-service;1" */,
            ModuleID::IO,
          },
  
          {
            { 0x702f } /* "@mozilla.org/network/protocol/about;1?what=sync-log" */,
            ModuleID::Anonymous221,
          },
  
          {
            { 0x7063 } /* "@mozilla.org/login-manager/crypto/SDR;1" */,
            ModuleID::Anonymous278,
          },
  
          {
            { 0x708b } /* "@mozilla.org/pipe;1" */,
            ModuleID::Anonymous401,
          },
  
          {
            { 0x709f } /* "@mozilla.org/toolkit/shutdown-terminator;1" */,
            ModuleID::Anonymous243,
          },
  
          {
            { 0x2a1b } /* "@mozilla.org/embedcomp/window-watcher;1" */,
            ModuleID::WindowWatcher,
          },
  
          {
            { 0x70ca } /* "@mozilla.org/network/protocol;1?name=view-source" */,
            ModuleID::Anonymous143,
          },
  
          {
            { 0x104f } /* "@mozilla.org/remote-permission-service;1" */,
            ModuleID::Anonymous077,
          },
  
          {
            { 0x70fb } /* "@mozilla.org/uriclassifierservice" */,
            ModuleID::UrlClassifierDB,
          },
  
          {
            { 0x711d } /* "@mozilla.org/io-util;1" */,
            ModuleID::Anonymous371,
          },
  
          {
            { 0x7134 } /* "@mozilla.org/network/protocol;1?name=wss" */,
            ModuleID::Anonymous145,
          },
  
          {
            { 0x715d } /* "@mozilla.org/browser/history;1" */,
            ModuleID::History,
          },
  
          {
            { 0x717c } /* "@mozilla.org/url-classifier/listmanager;1" */,
            ModuleID::Anonymous313,
          },
  
          {
            { 0x71a6 } /* "@mozilla.org/tracking-url-decoration-service;1" */,
            ModuleID::Anonymous228,
          },
  
          {
            { 0x71d5 } /* "@mozilla.org/gecko-media-plugin-service;1" */,
            ModuleID::Anonymous435,
          },
  
          {
            { 0x71ff } /* "@mozilla.org/user-characteristics-page;1" */,
            ModuleID::Anonymous300,
          },
  
          {
            { 0x7228 } /* "@mozilla.org/image/tools;1" */,
            ModuleID::Anonymous085,
          },
  
          {
            { 0x7243 } /* "@mozilla.org/typeaheadfind;1" */,
            ModuleID::TypeAheadFind,
          },
  
          {
            { 0x7260 } /* "@mozilla.org/file/directory_service;1" */,
            ModuleID::Directory,
          },
  
          {
            { 0x7286 } /* "@mozilla.org/ssservice;1" */,
            ModuleID::SiteSecurity,
          },
  
          {
            { 0x12ab } /* "@mozilla.org/synthspeechdispatcher;1" */,
            ModuleID::Anonymous052,
          },
  
          {
            { 0x729f } /* "@mozilla.org/appshell/window-mediator;1" */,
            ModuleID::Anonymous408,
          },
  
          {
            { 0x72c7 } /* "@mozilla.org/push/Notifier;1" */,
            ModuleID::Anonymous453,
          },
  
          {
            { 0x72e4 } /* "@mozilla.org/network/protocol/about;1?what=newprofile" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x731a } /* "@mozilla.org/moz/jssubscript-loader;1" */,
            ModuleID::Anonymous099,
          },
  
          {
            { 0x7340 } /* "@mozilla.org/supports-char;1" */,
            ModuleID::Anonymous380,
          },
  
          {
            { 0x735d } /* "@mozilla.org/widget/useridleservice;1" */,
            ModuleID::Anonymous360,
          },
  
          {
            { 0x7383 } /* "@mozilla.org/browser/identitycredentialpromptservice;1" */,
            ModuleID::IdentityCredentialPromptService,
          },
  
          {
            { 0x73ba } /* "@mozilla.org/network/protocol/about;1?what=webauthn" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x73ee } /* "@mozilla.org/focus-manager;1" */,
            ModuleID::Anonymous434,
          },
  
          {
            { 0x740b } /* "@mozilla.org/fingerprinting-override;1" */,
            ModuleID::Anonymous298,
          },
  
          {
            { 0x7432 } /* "@mozilla.org/geolocation;1" */,
            ModuleID::Anonymous436,
          },
  
          {
            { 0x744d } /* "@mozilla.org/network/protocol;1?name=about" */,
            ModuleID::Anonymous134,
          },
  
          {
            { 0x7478 } /* "@mozilla.org/toolkit/app-startup;1" */,
            ModuleID::AppStartup,
          },
  
          {
            { 0x749b } /* "@mozilla.org/sound;1" */,
            ModuleID::Anonymous354,
          },
  
          {
            { 0x29e2 } /* "@mozilla.org/alerts-service;1" */,
            ModuleID::Alerts,
          },
  
          {
            { 0x74b0 } /* "@mozilla.org/xre/directory-provider;1" */,
            ModuleID::Anonymous332,
          },
  
          {
            { 0x74d6 } /* "@mozilla.org/storage/activity-service;1" */,
            ModuleID::Anonymous456,
          },
  
          {
            { 0x74fe } /* "@mozilla.org/pref-override-map;1" */,
            ModuleID::Anonymous108,
          },
  
          {
            { 0x827 } /* "@mozilla.org/image/loader;1" */,
            ModuleID::Anonymous082,
          },
  
          {
            { 0x751f } /* "@mozilla.org/streamconv;1?from=multipart/mixed&to=*\/\*" */,
            ModuleID::Anonymous164,
          },
  
          {
            { 0x7555 } /* "@mozilla.org/security/x509certdb;1" */,
            ModuleID::NSSCertificateDB,
          },
  
          {
            { 0x7578 } /* "@mozilla.org/uriloader/content-handler;1?type=text/css" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x75af } /* "@mozilla.org/network/socket-transport-service;1" */,
            ModuleID::SocketTransport,
          },
  
          {
            { 0x75df } /* "@mozilla.org/security/clientAuthRememberService;1" */,
            ModuleID::Anonymous203,
          },
  
          {
            { 0xf7e } /* "@mozilla.org/crashservice;1" */,
            ModuleID::Anonymous253,
          },
  
          {
            { 0x7611 } /* "@mozilla.org/network/protocol;1?name=https" */,
            ModuleID::Anonymous136,
          },
  
          {
            { 0x763c } /* "@mozilla.org/scriptsecuritymanager;1" */,
            ModuleID::ScriptSecurityManager,
          },
  
          {
            { 0x7661 } /* "@mozilla.org/supports-PRUint32;1" */,
            ModuleID::Anonymous390,
          },
  
          {
            { 0x7682 } /* "@mozilla.org/browser/tagging-service;1" */,
            ModuleID::Anonymous286,
          },
  
          {
            { 0x76a9 } /* "@mozilla.org/tools/profiler;1" */,
            ModuleID::Anonymous335,
          },
  
          {
            { 0x76c7 } /* "@mozilla.org/security/pkcs11moduledb;1" */,
            ModuleID::Anonymous201,
          },
  
          {
            { 0x76ee } /* "@mozilla.org/uriloader/content-handler;1?type=text/rdf" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x7725 } /* "@mozilla.org/security/publickeypinningservice;1" */,
            ModuleID::Anonymous211,
          },
  
          {
            { 0x7755 } /* "@mozilla.org/image/encoder;2?type=image/jpeg" */,
            ModuleID::Anonymous088,
          },
  
          {
            { 0x7782 } /* "@mozilla.org/uriloader/handler-service-parent;1" */,
            ModuleID::Anonymous336,
          },
  
          {
            { 0x77b2 } /* "@mozilla.org/addons/addon-manager-startup;1" */,
            ModuleID::Anonymous239,
          },
  
          {
            { 0x77de } /* "@mozilla.org/fingerprinting-webcompat-service;1" */,
            ModuleID::Anonymous299,
          },
  
          {
            { 0x780e } /* "@mozilla.org/browser/nav-bookmarks-service;1" */,
            ModuleID::Anonymous284,
          },
  
          {
            { 0x783b } /* "@mozilla.org/nsTokenPasswordDialogs;1" */,
            ModuleID::Anonymous197,
          },
  
          {
            { 0x7861 } /* "@mozilla.org/notification-handler;1" */,
            ModuleID::Anonymous057,
          },
  
          {
            { 0x7885 } /* "@mozilla.org/network/protocol/about;1?what=mozilla" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x78b8 } /* "@mozilla.org/content/filepicker;1" */,
            ModuleID::Anonymous345,
          },
  
          {
            { 0x78da } /* "@mozilla.org/embedcomp/default-tooltiptextprovider;1" */,
            ModuleID::Anonymous311,
          },
  
          {
            { 0x790f } /* "@mozilla.org/network/protocol/about;1?what=cache" */,
            ModuleID::Anonymous132,
          },
  
          {
            { 0x7940 } /* "@mozilla.org/network/http-auth-manager;1" */,
            ModuleID::Anonymous123,
          },
  
          {
            { 0x7969 } /* "@mozilla.org/network/file-random-access-stream;1" */,
            ModuleID::Anonymous122,
          },
  
          {
            { 0x799a } /* "@mozilla.org/processtools-service;1" */,
            ModuleID::Anonymous294,
          },
  
          {
            { 0x79be } /* "@mozilla.org/eventlistenerservice;1" */,
            ModuleID::Anonymous432,
          },
  
          {
            { 0x79e2 } /* "@mozilla.org/supports-string;1" */,
            ModuleID::Anonymous393,
          },
  
          {
            { 0x7a01 } /* "@mozilla.org/network/protocol/about;1?what=networking" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x7a37 } /* "@mozilla.org/mime;1" */,
            ModuleID::Anonymous029,
          },
  
          {
            { 0x7a4b } /* "@mozilla.org/uriloader/content-handler;1?type=application/http-index-format" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x7a97 } /* "@mozilla.org/media/wmfcdm-origins-list;1" */,
            ModuleID::Anonymous266,
          },
  
          {
            { 0x85e } /* "@mozilla.org/media/sniffer;1" */,
            ModuleID::Anonymous267,
          },
  
          {
            { 0x7ac0 } /* "@mozilla.org/toolkit/finalizationwitness;1" */,
            ModuleID::Anonymous240,
          },
  
          {
            { 0x7aeb } /* "@mozilla.org/network/simple-uri-mutator;1" */,
            ModuleID::Anonymous150,
          },
  
          {
            { 0x7b15 } /* "@mozilla.org/network/protocol;1?name=moz-src" */,
            ModuleID::Anonymous142,
          },
  
          {
            { 0x7b42 } /* "@mozilla.org/network/file-input-stream;1" */,
            ModuleID::Anonymous120,
          },
  
          {
            { 0x7b6b } /* "@mozilla.org/streamconv;1?from=uncompressed&to=deflate" */,
            ModuleID::Anonymous105,
          },
  
          {
            { 0x7ba2 } /* "@mozilla.org/network/serialization-helper;1" */,
            ModuleID::Anonymous147,
          },
  
          {
            { 0x7bce } /* "@mozilla.org/system-alerts-service;1" */,
            ModuleID::Anonymous328,
          },
  
          {
            { 0x7bf3 } /* "@mozilla.org/widget/content/clipboard;1" */,
            ModuleID::Anonymous339,
          },
  
          {
            { 0x7c1b } /* "@mozilla.org/network/protocol;1?name=moz-remote-image" */,
            ModuleID::Anonymous093,
          },
  
          {
            { 0xa02 } /* "@mozilla.org/url-classifier/exception-list-service;1" */,
            ModuleID::Anonymous192,
          },
  
          {
            { 0x7c51 } /* "@mozilla.org/network/protocol/about;1?what=newtab" */,
            ModuleID::Anonymous008,
          },
  
          {
            { 0xc95 } /* "@mozilla.org/dom/payments/payment-abort-action-response;1" */,
            ModuleID::Anonymous062,
          },
  
          {
            { 0x7c83 } /* "@mozilla.org/streamconv;1?from=gzip&to=uncompressed" */,
            ModuleID::Anonymous163,
          },
  
          {
            { 0x7cb7 } /* "@mozilla.org/permissionmanager;1" */,
            ModuleID::PermissionManager,
          },
  
          {
            { 0x7cd8 } /* "@mozilla.org/layout/content-policy;1" */,
            ModuleID::Anonymous439,
          },
  
          {
            { 0x7cfd } /* "@mozilla.org/network/protocol/about;1?what=srcdoc" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x7d2f } /* "@mozilla.org/websocketevent/service;1" */,
            ModuleID::Anonymous459,
          },
  
          {
            { 0x7d55 } /* "@mozilla.org/autocomplete/search;1?name=places-tag-autocomplete" */,
            ModuleID::Anonymous287,
          },
  
          {
            { 0x7d95 } /* "@mozilla.org/dom/localStorage-manager;1" */,
            ModuleID::Anonymous427,
          },
  
          {
            { 0x7dbd } /* "@mozilla.org/network/protocol/about;1?what=privatebrowsing" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x7df8 } /* "@mozilla.org/network/stream-transport-service;1" */,
            ModuleID::StreamTransport,
          },
  
          {
            { 0x7e28 } /* "@mozilla.org/network/protocol/about;1?what=logo" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x7e58 } /* "@mozilla.org/txttohtmlconv;1" */,
            ModuleID::Anonymous165,
          },
  
          {
            { 0x7e75 } /* "@mozilla.org/accessibilityService;1" */,
            ModuleID::Anonymous465,
          },
  
          {
            { 0x7e99 } /* "@mozilla.org/base/telemetry-startup;1" */,
            ModuleID::Anonymous307,
          },
  
          {
            { 0x7ebf } /* "@mozilla.org/network/effective-tld-service;1" */,
            ModuleID::EffectiveTLD,
          },
  
          {
            { 0xc01 } /* "@mozilla.org/dom/payments/general-change-details;1" */,
            ModuleID::Anonymous060,
          },
  
          {
            { 0x7eec } /* "@mozilla.org/streamconv;1?from=multipart/byteranges&to=*\/\*" */,
            ModuleID::Anonymous164,
          },
  
          {
            { 0x7f27 } /* "@mozilla.org/parentprocessmessagemanager;1" */,
            ModuleID::Anonymous450,
          },
  
          {
            { 0x7f52 } /* "@mozilla.org/file/local;1" */,
            ModuleID::Anonymous372,
          },
  
          {
            { 0x7f6c } /* "@mozilla.org/browser/search-service;1" */,
            ModuleID::Anonymous305,
          },
  
          {
            { 0x7f92 } /* "@mozilla.org/network/protocol/about;1?what=httpsonlyerror" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x7fcc } /* "@mozilla.org/network/protocol/about;1?what=addons" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x7ffe } /* "@mozilla.org/remote;1" */,
            ModuleID::Anonymous297,
          },
  
          {
            { 0x8014 } /* "@mozilla.org/intl/scriptableunicodeconverter" */,
            ModuleID::Anonymous097,
          },
  
          {
            { 0x8041 } /* "@mozilla.org/network/authprompt-adapter-factory;1" */,
            ModuleID::AuthPromptAdapter,
          },
  
          {
            { 0x8073 } /* "@mozilla.org/uriloader/content-handler;1?type=application/xhtml+xml" */,
            ModuleID::Anonymous002,
          },
  
          {
            { 0x80b7 } /* "@mozilla.org/intl/stringbundle;1" */,
            ModuleID::StringBundle,
          },
  
          {
            { 0x80d8 } /* "@mozilla.org/security/CRLiteTimestamp;1" */,
            ModuleID::Anonymous213,
          },
  
          {
            { 0x8100 } /* "@mozilla.org/network/protocol/about;1?what=rights" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x8132 } /* "@mozilla.org/clear-by-site-entry;1" */,
            ModuleID::Anonymous247,
          },
  
          {
            { 0x8155 } /* "@mozilla.org/network/protocol;1?name=moz-cached-ohttp" */,
            ModuleID::Anonymous007,
          },
  
          {
            { 0x818b } /* "@mozilla.org/dom/createofferrequest;1" */,
            ModuleID::Anonymous051,
          },
  
          {
            { 0x81b1 } /* "@mozilla.org/integritypolicy;1" */,
            ModuleID::Anonymous421,
          },
  
          {
            { 0x81d0 } /* "@mozilla.org/network/protocol/about;1?what=crashgpu" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x8204 } /* "@mozilla.org/streamconv;1?from=deflate&to=uncompressed" */,
            ModuleID::Anonymous163,
          },
  
          {
            { 0x823b } /* "@mozilla.org/widget/content/dragservice;1" */,
            ModuleID::Anonymous343,
          },
  
          {
            { 0x8265 } /* "@mozilla.org/key-value-service;1" */,
            ModuleID::Anonymous264,
          },
  
          {
            { 0x8286 } /* "@mozilla.org/network/tls-server-socket;1" */,
            ModuleID::Anonymous156,
          },
  
          {
            { 0x82af } /* "@mozilla.org/widget/taskbarprogress/gtk;1" */,
            ModuleID::Anonymous350,
          },
  
          {
            { 0x82d9 } /* "@mozilla.org/docloaderservice;1" */,
            ModuleID::DocLoader,
          },
  
          {
            { 0x82f9 } /* "@mozilla.org/notificationStorage;1" */,
            ModuleID::Anonymous055,
          },
  
          {
            { 0x831c } /* "@mozilla.org/cookie-banner-list-service;1" */,
            ModuleID::Anonymous252,
          },
  
          {
            { 0x8346 } /* "@mozilla.org/streamconv;1?from=x-gzip&to=uncompressed" */,
            ModuleID::Anonymous163,
          },
  
          {
            { 0x837c } /* "@mozilla.org/network/network-connectivity-service;1" */,
            ModuleID::Anonymous130,
          },
  
          {
            { 0x426 } /* "@mozilla.org/extensions/web-navigation-content;1" */,
            ModuleID::Anonymous262,
          },
  
          {
            { 0x83b0 } /* "@mozilla.org/uriloader/local-handler-app;1" */,
            ModuleID::Anonymous027,
          },
  
          {
            { 0x83db } /* "@mozilla.org/psm;1" */,
            ModuleID::NSSComponent,
          },
  
          {
            { 0x83ee } /* "@mozilla.org/toolkit/URLFormatterService;1" */,
            ModuleID::Anonymous316,
          },
  
          {
            { 0x8419 } /* "@mozilla.org/io/arraybuffer-input-stream;1" */,
            ModuleID::Anonymous109,
          },
  
          {
            { 0x4e9 } /* "@mozilla.org/backgroundtasksmanager;1" */,
            ModuleID::Anonymous236,
          },
  
          {
            { 0x8444 } /* "@mozilla.org/embedcomp/rangefind;1" */,
            ModuleID::Anonymous330,
          },
  
          {
            { 0x729 } /* "@mozilla.org/mixedcontentblocker;1" */,
            ModuleID::Anonymous445,
          },
  
          {
            { 0x8467 } /* "@mozilla.org/url-classifier/streamupdater;1" */,
            ModuleID::UrlClassifierStreamUpdater,
          },
  
          {
            { 0x8493 } /* "@mozilla.org/widget/appshell/gtk;1" */,
            ModuleID::Anonymous348,
          },
  
          {
            { 0x84b6 } /* "@mozilla.org/chrome/chrome-registry;1" */,
            ModuleID::ChromeRegistry,
          },
  
          {
            { 0x84dc } /* "@mozilla.org/network/protocol/about;1?what=restartrequired" */,
            ModuleID::Anonymous000,
          },
  
          {
            { 0x8517 } /* "@mozilla.org/streamconv;1?from=application/vnd.mozilla.webext.unlocalized&to=text/css" */,
            ModuleID::Anonymous317,
          },
  
          {
            { 0x856d } /* "@mozilla.org/network/protocol/about;1?what=license" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x85a0 } /* "@mozilla.org/network/mime-input-stream;1" */,
            ModuleID::Anonymous129,
          },
  
          {
            { 0x29c3 } /* "@mozilla.org/contentanalysis;1" */,
            ModuleID::nsIContentAnalysis,
          },
  
          {
            { 0x85c9 } /* "@mozilla.org/eventsourceevent/service;1" */,
            ModuleID::Anonymous460,
          },
  
          {
            { 0x85f1 } /* "@mozilla.org/cookiemanager;1" */,
            ModuleID::Anonymous175,
          },
  
          {
            { 0x860e } /* "@mozilla.org/power/powermanagerservice;1" */,
            ModuleID::Anonymous068,
          },
  
          {
            { 0x8637 } /* "@mozilla.org/webvttParserWrapper;1" */,
            ModuleID::Anonymous054,
          },
  
          {
            { 0x865a } /* "@mozilla.org/network/protocol/about;1?what=checkerboard" */,
            ModuleID::Anonymous024,
          },
  
          {
            { 0x8692 } /* "@mozilla.org/browser/synced-bookmarks-merger;1" */,
            ModuleID::Anonymous291,
          },
  
          {
            { 0x86c1 } /* "@mozilla.org/cspcontext;1" */,
            ModuleID::Anonymous419,
          }
};



const ContractEntry*
LookupContractID(const nsACString& aKey)
{
  static const uint16_t BASES[] = {
       1,   2,   5,   0,   4,   8,   1,   5,   4,   4,   1,   1,   0,   1,   1,   4,
       1,   1,   0,   0,   0,   2,   4,   2,   3,   1,   3,   4,  13,   0,   4,   4,
       0,   1,   1,   1,   0,   0,   2,   2,   0,   9,   0,   0,   1,   6,   2,   1,
       0,   6,   3,   1,   5,   3,   0,   1,   1,   2,   2,   2,   0,   0,   6,   9,
       2,   1,   5,   5,   2,   0,   1,   0,   0,   0,   1,   4,   0,   0,   6,   1,
       2,   1,   1,   2,   0,   0,   2,   2,   1,   0,   2,   0,   0,   0,   1,   2,
       5,   1,   2,   1,   6,   3,   5,  12,   1,   1,   1,   1,   1,   4,   7,   3,
       5,   1,   1,   1,   0,   1,   3,   0,   0,   0,   2,   5,   1,   0,   1,   7,
       6,   1,  10,   0,   4,   0,   0,   0,   1,   0,   2,   2,   1,   5,   6,   0,
       3,   4,   1,   0,   1,  16,   1,   0,   1,   2,   5,   0,   2,   0,   7,   1,
       2,   7,   6,   1,  11,   0,   1,   3,   2,   3,   2,   1,   1,   6,   3,   0,
       1,   1,  16,   3,   0,   1,   1,   1,   6,   0,   0,  10,   1,   1,  10,   5,
       0,   1,   2,   0,   1,   4,   1,   3,   1,   0,   3,   6,   1,   0,   5,   9,
       3,  27,   1,   1,   1,   4,   7,   7,   0,   0,   2,   2,  11,   1,   2,   2,
      15,   0,   9,   8,   5,   5,   4,   0,   3,   3,   2,   0,   2,   2,   1,   6,
      13,   4,   3,   7,   2,   0,   0,   1,   0,   7,   0,   3,   1,   0,   0,   3,
       0,   0,   1,   0,   1,   0,   0,   3,   0,   4,   0,   6,   2,   1,   3,   5,
      11,   2,   0,   0,   4,   5,   2,   3,   0,   8,   3,   1,   4,   6,   7,  10,
       2,   3,   0,   0,   3,   5,   2,   0,   1,   0,   8,   3,   5,   3,   1,   3,
      10,   0,   0,  11,   0,   1,   0,   1,   1,   4,   0,   0,   7,   0,   4,   1,
       6,   0,   4,   0,   6,   1,   1,   1,   0,   5,  13,   0,   0,  16,   6,   0,
       1,   1,   1,   1,  16,   1,   0,   0,   5,   8,   0,   0,   1,   2,  22,   0,
       3,   0,  36,   0,   0,   6,   2,   0,   0,   0,  11,   0,   0,  33,   0,   7,
       6,   3,   3,   1,   1,   0,   0,   9,   3,   3,   5,   0,   2,   0,   5,   1,
       9,   0,   3,  15,   3,   2,   0,  15,  10,   0,  34,   0,   0,  11,  24,  22,
       0,   0,  21,   0,  11,  17,   4,   1,   5,   5,   7,  12,   2,  22,  14,  10,
       0,   1,  48,   0,   0,   0,   1,   3,  28,   0,  65,  18,   0,   0,   9,   1,
       0,   5,   1,  32,   4,   0,  12,  12,   0,   5,   1,   2,   5,   0,   0,  12,
       3,  95,   9,   1,   0,  10,   6,   9,   3,   3,   1,   1,   0,  31,   8,   0,
      32,   0,  35,   4,   2,   3,   0,   0,  14,  56,   0,   0,  59,  50,  10,   7,
      19,  11,  37,  37,  28,   4,   0,  15, 169,   5, 169,   0,   1,  52, 204,   8,
       0,   7, 134,  10,   2,  92,   5,   0,   1, 751, 431,   6,   1,   8,   0,   0,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             gContractEntries);
  return entry.Matches(aKey) ? &entry : nullptr;
}

const JSServiceEntry gJSServices[] = {
  
          {
            { 0x86db } /* "focus" */,
            ModuleID::Anonymous434,
            { 72 },
            1
          },
  
          {
            { 0x86e1 } /* "cpmm" */,
            ModuleID::Anonymous415,
            { 68 },
            0
          },
  
          {
            { 0x86e6 } /* "telemetry" */,
            ModuleID::Anonymous309,
            { 44 },
            1
          },
  
          {
            { 0x86f0 } /* "uuid" */,
            ModuleID::UUIDGenerator,
            { 59 },
            1
          },
  
          {
            { 0x86f5 } /* "policies" */,
            ModuleID::Anonymous259,
            { 35 },
            1
          },
  
          {
            { 0x86fe } /* "strings" */,
            ModuleID::StringBundle,
            { 5 },
            1
          },
  
          {
            { 0x8706 } /* "crashmanager" */,
            ModuleID::Anonymous254,
            { 33 },
            0
          },
  
          {
            { 0x8713 } /* "cookieBanners" */,
            ModuleID::CookieBannerService,
            { 31 },
            1
          },
  
          {
            { 0x8721 } /* "ppmm" */,
            ModuleID::Anonymous450,
            { 73 },
            0
          },
  
          {
            { 0x8726 } /* "prefs" */,
            ModuleID::Preferences,
            { 9 },
            2
          },
  
          {
            { 0x872c } /* "search" */,
            ModuleID::Anonymous305,
            { 43 },
            1
          },
  
          {
            { 0x8733 } /* "els" */,
            ModuleID::Anonymous432,
            { 71 },
            1
          },
  
          {
            { 0x8737 } /* "dirsvc" */,
            ModuleID::Directory,
            { 63 },
            2
          },
  
          {
            { 0x873e } /* "loadContextInfo" */,
            ModuleID::Anonymous110,
            { 11 },
            1
          },
  
          {
            { 0x874e } /* "cache2" */,
            ModuleID::CacheStorage,
            { 12 },
            1
          },
  
          {
            { 0x8755 } /* "env" */,
            ModuleID::Anonymous404,
            { 65 },
            1
          },
  
          {
            { 0x8759 } /* "logins" */,
            ModuleID::Anonymous273,
            { 39 },
            1
          },
  
          {
            { 0x8760 } /* "vc" */,
            ModuleID::Anonymous396,
            { 60 },
            1
          },
  
          {
            { 0x8763 } /* "wm" */,
            ModuleID::Anonymous408,
            { 67 },
            1
          },
  
          {
            { 0x8766 } /* "eTLD" */,
            ModuleID::EffectiveTLD,
            { 14 },
            1
          },
  
          {
            { 0x876b } /* "droppedLinkHandler" */,
            ModuleID::Anonymous030,
            { 1 },
            1
          },
  
          {
            { 0x877e } /* "catMan" */,
            ModuleID::CategoryManager,
            { 61 },
            1
          },
  
          {
            { 0x8785 } /* "io" */,
            ModuleID::IO,
            { 15 },
            3
          },
  
          {
            { 0x8788 } /* "locale" */,
            ModuleID::Locale,
            { 6 },
            1
          },
  
          {
            { 0x878f } /* "clearData" */,
            ModuleID::Anonymous246,
            { 28 },
            1
          },
  
          {
            { 0x8799 } /* "dns" */,
            ModuleID::DNS,
            { 13 },
            1
          },
  
          {
            { 0x879d } /* "profiler" */,
            ModuleID::Anonymous335,
            { 52 },
            1
          },
  
          {
            { 0x87a6 } /* "clipboard" */,
            ModuleID::Anonymous338,
            { 53 },
            1
          },
  
          {
            { 0x87b0 } /* "scriptSecurityManager" */,
            ModuleID::ScriptSecurityManager,
            { 73 },
            1
          },
  
          {
            { 0x87c6 } /* "cookies" */,
            ModuleID::Anonymous175,
            { 18 },
            2
          },
  
          {
            { 0x87ce } /* "tm" */,
            ModuleID::Anonymous394,
            { 58 },
            1
          },
  
          {
            { 0x87d1 } /* "xulStore" */,
            ModuleID::Anonymous319,
            { 46 },
            1
          },
  
          {
            { 0x87da } /* "obs" */,
            ModuleID::Observer,
            { 62 },
            1
          },
  
          {
            { 0x87de } /* "console" */,
            ModuleID::Console,
            { 55 },
            1
          },
  
          {
            { 0x87e6 } /* "perms" */,
            ModuleID::PermissionManager,
            { 4 },
            1
          },
  
          {
            { 0x87ec } /* "qms" */,
            ModuleID::Anonymous429,
            { 70 },
            1
          },
  
          {
            { 0x87f0 } /* "urlFormatter" */,
            ModuleID::Anonymous316,
            { 45 },
            1
          },
  
          {
            { 0x87fd } /* "textToSubURI" */,
            ModuleID::TextToSubURI,
            { 7 },
            1
          },
  
          {
            { 0x880a } /* "sysinfo" */,
            ModuleID::SystemInfo,
            { 56 },
            2
          },
  
          {
            { 0x8812 } /* "storage" */,
            ModuleID::Anonymous223,
            { 24 },
            1
          },
  
          {
            { 0x881a } /* "appinfo" */,
            ModuleID::XULRuntime,
            { 48 },
            3
          },
  
          {
            { 0x8822 } /* "sessionStorage" */,
            ModuleID::Anonymous073,
            { 3 },
            1
          },
  
          {
            { 0x8831 } /* "DAPTelemetry" */,
            ModuleID::Anonymous257,
            { 34 },
            1
          },
  
          {
            { 0x883e } /* "appShell" */,
            ModuleID::Anonymous407,
            { 66 },
            1
          },
  
          {
            { 0x8847 } /* "startup" */,
            ModuleID::AppStartup,
            { 27 },
            1
          },
  
          {
            { 0x884f } /* "scriptloader" */,
            ModuleID::Anonymous099,
            { 8 },
            1
          },
  
          {
            { 0x885c } /* "blocklist" */,
            ModuleID::Anonymous321,
            { 47 },
            1
          },
  
          {
            { 0x8866 } /* "prompt" */,
            ModuleID::Anonymous295,
            { 40 },
            1
          },
  
          {
            { 0x886d } /* "uriFixup" */,
            ModuleID::URIFixup,
            { 0 },
            1
          },
  
          {
            { 0x8876 } /* "domStorageManager" */,
            ModuleID::Anonymous427,
            { 68 },
            2
          },
  
          {
            { 0x8888 } /* "rfp" */,
            ModuleID::RFPService,
            { 41 },
            1
          },
  
          {
            { 0x888c } /* "ww" */,
            ModuleID::WindowWatcher,
            { 51 },
            1
          },
  
          {
            { 0x888f } /* "intl" */,
            ModuleID::Anonymous270,
            { 38 },
            1
          },
  
          {
            { 0x8894 } /* "fog" */,
            ModuleID::Anonymous263,
            { 36 },
            1
          },
  
          {
            { 0x8898 } /* "mm" */,
            ModuleID::Anonymous437,
            { 73 },
            0
          }
};



const JSServiceEntry*
LookupJSService(const nsACString& aKey)
{
  static const uint8_t BASES[] = {
       0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   1,
       1,   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   1,   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   1,
       0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   2,   0,   1,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   2,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   3,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
       0,   0,   0,   0,  12,   0,   0,   0,   0,   0,   1,   0,   0,   3,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   3,   0,   6,   0,   0,   0,
       0,   0,   0,   2,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,
       0,   0,   0,   0,   0,   5,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
      32,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,
       0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   9,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0, 220,   0,   0,   0,   0,   0,   0,   0,   0,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             gJSServices);
  return entry.Name() == aKey ? &entry : nullptr;
}

const StaticProtocolHandler gStaticProtocolHandlers[] = {
  
          {
            .mScheme = { 0x889b } /* "about" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_SCHEME_NOT_SELF_LINKABLE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous134,
            .mHasDynamicFlags = true,
          },
  
          {
            .mScheme = { 0x88a1 } /* "default" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA,
            .mDefaultPort = 0,
            .mModuleID = ModuleID::ExternalProtocolHandler,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88a9 } /* "ws" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = 80,
            .mModuleID = ModuleID::Anonymous144,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88ac } /* "blob" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_LOADABLE_BY_SUBSUMERS | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous035,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88b1 } /* "cached-favicon" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous282,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88c0 } /* "moz-gio" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous185,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88c8 } /* "data" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_INHERITS_SECURITY_CONTEXT | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_SYNC_LOAD_IS_OK,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous135,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88cd } /* "jar" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous101,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88d1 } /* "moz-page-thumb" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous138,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88e0 } /* "wss" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = 443,
            .mModuleID = ModuleID::Anonymous145,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88e4 } /* "resource" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous141,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88ed } /* "moz-extension" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN | nsIProtocolHandler::URI_IS_WEBEXTENSION_RESOURCE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous137,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x88fb } /* "moz-src" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous142,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8903 } /* "http" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = 80,
            .mModuleID = ModuleID::HttpHandler,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8908 } /* "view-source" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_NON_PERSISTABLE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous143,
            .mHasDynamicFlags = true,
          },
  
          {
            .mScheme = { 0x8914 } /* "moz-cached-ohttp" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_SCHEME_NOT_SELF_LINKABLE,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous007,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8925 } /* "moz-icon" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE,
            .mDefaultPort = 0,
            .mModuleID = ModuleID::Anonymous091,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x892e } /* "file" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_IS_LOCAL_FILE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::FileProtocolHandler,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8933 } /* "javascript" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_INHERITS_SECURITY_CONTEXT | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_OPENING_EXECUTES_SCRIPT,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous447,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x893e } /* "https" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::ALLOWS_PROXY | nsIProtocolHandler::ALLOWS_PROXY_HTTP | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = 443,
            .mModuleID = ModuleID::Anonymous136,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8944 } /* "indexeddb" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD | nsIProtocolHandler::URI_DOES_NOT_RETURN_DATA | nsIProtocolHandler::URI_NON_PERSISTABLE | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous072,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x894e } /* "page-icon" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous290,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8958 } /* "moz-newtab-wallpaper" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous139,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x896d } /* "moz" */,
            .mProtocolFlags = nsIProtocolHandler::URI_DANGEROUS_TO_LOAD,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous271,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8971 } /* "chrome" */,
            .mProtocolFlags = nsIProtocolHandler::URI_STD | nsIProtocolHandler::URI_IS_UI_RESOURCE | nsIProtocolHandler::URI_IS_LOCAL_RESOURCE | nsIProtocolHandler::URI_HAS_WEB_EXPOSED_ORIGIN,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous369,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8978 } /* "moz-remote-image" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_DANGEROUS_TO_LOAD,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous093,
            .mHasDynamicFlags = false,
          },
  
          {
            .mScheme = { 0x8989 } /* "moz-safe-about" */,
            .mProtocolFlags = nsIProtocolHandler::URI_NORELATIVE | nsIProtocolHandler::URI_NOAUTH | nsIProtocolHandler::URI_LOADABLE_BY_ANYONE | nsIProtocolHandler::URI_IS_POTENTIALLY_TRUSTWORTHY,
            .mDefaultPort = -1,
            .mModuleID = ModuleID::Anonymous140,
            .mHasDynamicFlags = false,
          }
};



const StaticProtocolHandler*
LookupProtocolHandler(const nsACString& aKey)
{
  static const uint8_t BASES[] = {
       0,   9,  27,  20,   3,   1,   3,   0,   4,   0,   7,   0,  31,   9,  28, 119,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             gStaticProtocolHandlers);
  return entry.Scheme() == aKey ? &entry : nullptr;
}

static inline bool CalledInit(size_t aIdx) {
  return GetBit(gInitCalled, aIdx);
}

static nsresult CallInitFunc(size_t aIdx) {
  if (CalledInit(aIdx)) {
    return NS_OK;
  }

  nsresult rv = NS_OK;
  switch (aIdx) {
    case 0:
      mozilla::InitDocShellModule();
      break;
    case 1:
      mozilla::image::EnsureModuleInitialized();
      break;
    case 2:
      /* empty */
      break;
    case 3:
      nsNetStartup();
      break;
    case 4:
      /* empty */
      break;
    case 5:
      nsWidgetGtk2ModuleCtor();
      break;
    case 6:
      /* empty */
      break;
  }

  SetBit(gInitCalled, aIdx);

  MOZ_ASSERT(NS_SUCCEEDED(rv));
  return rv;
}

static void CallUnloadFuncs() {
  if (CalledInit(0)) {
    mozilla::UnloadDocShellModule();
  }
  if (CalledInit(2)) {
    mozilla::UnloadPrefsModule();
  }
  if (CalledInit(3)) {
    nsNetShutdown();
  }
  if (CalledInit(4)) {
    mozilla::Telemetry::ShutdownTelemetry();
  }
  if (CalledInit(5)) {
    nsWidgetGtk2ModuleDtor();
  }
  if (CalledInit(6)) {
    nsLayoutModuleDtor();
  }
}

nsresult CreateInstanceImpl(ModuleID aID, const nsIID& aIID, void** aResult) {
  // The full set of constructors for all static modules.
  // This switch statement will be compiled to a relative address jump table
  // with no runtime relocations and a single indirect jump.
  switch (aID) {
    case ModuleID::Anonymous260: {
      RefPtr<mozilla::extensions::ExtensionsChild> inst = mozilla::extensions::ExtensionsChild::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::extensions::ExtensionsChild::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::extensions::ExtensionsChild::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::extensions::ExtensionsChild, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous325: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amContentHandler.sys.mjs"),
                                         "amContentHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous024: {
      MOZ_TRY(CallInitFunc(0));
      return /* legacy */ nsAboutRedirector::Create(aIID, aResult);
    }
    case ModuleID::Anonymous357: {
      MOZ_TRY(CallInitFunc(5));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIClipboard>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous302: {
      RefPtr<nsFormFillController> inst = nsFormFillController::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsFormFillController::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsFormFillController::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsFormFillController, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous342: {
      RefPtr<nsISupports> inst = nsDragServiceSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsDragServiceSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsDragServiceSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous441: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateXHTMLContentSerializer(aIID, aResult);
    }
    case ModuleID::ServiceWorkerManager: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::ServiceWorkerManager> inst = mozilla::dom::ServiceWorkerManager::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::ServiceWorkerManager::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::ServiceWorkerManager::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::ServiceWorkerManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous146: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsSafeFileOutputStream> inst = new nsSafeFileOutputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous228: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URLDecorationAnnotationsService.sys.mjs"),
                                         "URLDecorationAnnotationsService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous426: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsStructuredCloneContainer> inst = new nsStructuredCloneContainer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous366: {
      RefPtr<mozilla::nsAvailableMemoryWatcherBase> inst = mozilla::nsAvailableMemoryWatcherBase::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::nsAvailableMemoryWatcherBase::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::nsAvailableMemoryWatcherBase::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::nsAvailableMemoryWatcherBase, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous102: {
      RefPtr<nsJARURI::Mutator> inst = new nsJARURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierStreamUpdater: {
      RefPtr<nsUrlClassifierStreamUpdater> inst = new nsUrlClassifierStreamUpdater();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::IdentityCredentialStorageService: {
      RefPtr<mozilla::IdentityCredentialStorageService> inst = mozilla::IdentityCredentialStorageService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::IdentityCredentialStorageService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::IdentityCredentialStorageService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::IdentityCredentialStorageService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous056: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("moz-src:///dom/notification/NotificationStorage.sys.mjs"),
                                         "MemoryNotificationStorage",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous151: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::DefaultURI::Mutator> inst = new mozilla::net::DefaultURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous089: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsPNGEncoder> inst = new nsPNGEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous037: {
      RefPtr<mozilla::dom::LoginDetectionService> inst = mozilla::dom::LoginDetectionService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::LoginDetectionService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::LoginDetectionService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::LoginDetectionService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous398: {
      return /* legacy */ nsComponentManagerImpl::Create(aIID, aResult);
    }
    case ModuleID::Anonymous126: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsInputStreamChannel> inst = new mozilla::net::nsInputStreamChannel();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous428: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ SessionStorageManagerConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous142: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::MozSrcProtocolHandler> inst = mozilla::net::MozSrcProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::MozSrcProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::MozSrcProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::MozSrcProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous355: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsTransferable> inst = new nsTransferable();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous460: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::EventSourceEventService> inst = mozilla::dom::EventSourceEventService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::EventSourceEventService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::EventSourceEventService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::EventSourceEventService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous438: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<inDeepTreeWalker> inst = new inDeepTreeWalker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous343: {
      RefPtr<nsDragServiceProxy> inst = new nsDragServiceProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous010: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/profiles/SelectableProfileService.sys.mjs"),
                                         "CommandLineHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::URILoader: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsURILoader> inst = new nsURILoader();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous264: {
      return /* legacy */ nsKeyValueServiceConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous311: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TooltipTextProvider.sys.mjs"),
                                         "TooltipTextProvider",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous250: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ContentPrefService2.sys.mjs"),
                                         "ContentPrefService2",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous103: {
      RefPtr<nsJARURI::Mutator> inst = new nsJARURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::PermissionManager: {
      RefPtr<nsIPermissionManager> inst = mozilla::PermissionManager::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::PermissionManager::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::PermissionManager::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIPermissionManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous433: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<ExpandedPrincipal::Deserializer> inst = new ExpandedPrincipal::Deserializer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous072: {
      RefPtr<nsIndexedDBProtocolHandler> inst = new nsIndexedDBProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous183: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ThirdPartyCookieBlockingExceptionListService.sys.mjs"),
                                         "ThirdPartyCookieBlockingExceptionListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous337: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/WebHandlerApp.sys.mjs"),
                                         "nsWebHandlerApp",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous086: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsBMPEncoder> inst = new nsBMPEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous173: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::SubstitutingJARURI> inst = new mozilla::net::SubstitutingJARURI();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous075: {
      RefPtr<nsISupports> inst = mozilla::dom::NewWebAuthnService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::NewWebAuthnService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::NewWebAuthnService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous002: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/BrowserContentHandler.sys.mjs"),
                                         "nsBrowserContentHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous422: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::IntegrityPolicyService> inst = new mozilla::dom::IntegrityPolicyService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous303: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FormHistoryAutoComplete.sys.mjs"),
                                         "FormHistoryAutoComplete",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous076: {
      RefPtr<PermissionDelegateHandler> inst = new PermissionDelegateHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous244: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/CaptiveDetect.sys.mjs"),
                                         "CaptivePortalDetector",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous187: {
      return /* legacy */ binary_http_constructor(aIID, aResult);
    }
    case ModuleID::Anonymous371: {
      RefPtr<nsIOUtil> inst = new nsIOUtil();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous306: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SearchSuggestions.sys.mjs"),
                                         "SearchSuggestAutoComplete",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous298: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FingerprintingWebCompatService.sys.mjs"),
                                         "FingerprintingOverride",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous409: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsJSURI::Mutator> inst = new nsJSURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous220: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://services-sync/Weave.sys.mjs"),
                                         "WeaveService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous160: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsAuthURLParser> inst = new nsAuthURLParser();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous319: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/XULStore.sys.mjs"),
                                         "XULStore",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ChromeRegistry: {
      RefPtr<nsChromeRegistry> inst = nsChromeRegistry::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsChromeRegistry::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsChromeRegistry::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsChromeRegistry, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous262: {
      RefPtr<mozilla::extensions::WebNavigationContent> inst = mozilla::extensions::WebNavigationContent::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::extensions::WebNavigationContent::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::extensions::WebNavigationContent::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::extensions::WebNavigationContent, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous038: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozilla::PeerConnectionImpl>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous008: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AboutNewTabRedirector.sys.mjs"),
                                         "AboutNewTabRedirectorStub",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous100: {
      RefPtr<nsJAR> inst = new nsJAR();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous167: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleNestedURI::Mutator> inst = new mozilla::net::nsSimpleNestedURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous137: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::ExtensionProtocolHandler> inst = mozilla::net::ExtensionProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::ExtensionProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::ExtensionProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::ExtensionProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous159: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsNoAuthURLParser> inst = new nsNoAuthURLParser();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::XULRuntime: {
      return /* legacy */ mozilla::AppInfoConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous061: {
      RefPtr<mozilla::dom::GeneralResponseData> inst = new mozilla::dom::GeneralResponseData();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous251: {
      RefPtr<mozilla::nsCookieBannerRule> inst = new mozilla::nsCookieBannerRule();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous208: {
      return /* legacy */ mozilla::psm::NSSConstructor<OSKeyStore>(aIID, aResult);
    }
    case ModuleID::Anonymous376: {
      RefPtr<nsScriptableBase64Encoder> inst = new nsScriptableBase64Encoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierUtils: {
      RefPtr<nsUrlClassifierUtils> inst = nsUrlClassifierUtils::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsUrlClassifierUtils::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsUrlClassifierUtils::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsUrlClassifierUtils, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous336: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ExtHandlerService.sys.mjs"),
                                         "HandlerService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous081: {
      RefPtr<nsThebesFontEnumerator> inst = new nsThebesFontEnumerator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous263: {
      RefPtr<mozilla::FOG> inst = mozilla::FOG::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::FOG::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::FOG::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::FOG, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous461: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::net::WebTransportEventService> inst = mozilla::net::WebTransportEventService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::WebTransportEventService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::WebTransportEventService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::WebTransportEventService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous454: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<ScriptableContentIterator> inst = new ScriptableContentIterator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous266: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/WindowsMediaFoundationCDMOriginsListService.sys.mjs"),
                                         "WindowsMediaFoundationCDMOriginsListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous435: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::gmp::GeckoMediaPluginService> inst = mozilla::gmp::GeckoMediaPluginService::GetGeckoMediaPluginService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::gmp::GeckoMediaPluginService::GetGeckoMediaPluginService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::gmp::GeckoMediaPluginService::GetGeckoMediaPluginService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::gmp::GeckoMediaPluginService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous161: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsIndexedToHTML::Create(aIID, aResult);
    }
    case ModuleID::Anonymous122: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsFileRandomAccessStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous359: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsDragService> inst = nsDragService::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsDragService::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsDragService::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsDragService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::DNS: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIDNSService> inst = nsDNSService::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsDNSService::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsDNSService::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIDNSService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous399: {
      return /* legacy */ nsArrayBase::XPCOMConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous088: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsJPEGEncoder> inst = new nsJPEGEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous198: {
      RefPtr<nsNSSVersion> inst = new nsNSSVersion();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::nsIContentAnalysis: {
      RefPtr<mozilla::contentanalysis::ContentAnalysis> inst = new mozilla::contentanalysis::ContentAnalysis();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous416: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIDocumentLoaderFactory>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous238: {
      RefPtr<nsWebBrowserContentPolicy> inst = new nsWebBrowserContentPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous219: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://services-settings/RemoteSettingsComponents.sys.mjs"),
                                         "RemoteSettingsTimer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous222: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIStartupCacheInfo>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous124: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ net_NewIncrementalDownload(aIID, aResult);
    }
    case ModuleID::Anonymous312: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierLib.sys.mjs"),
                                         "UrlClassifierLib",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous032: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ProcessSelector.sys.mjs"),
                                         "MinTabSelector",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous459: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::net::WebSocketEventService> inst = mozilla::net::WebSocketEventService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::WebSocketEventService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::WebSocketEventService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::WebSocketEventService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous163: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewHTTPCompressConvFactory(aIID, aResult);
    }
    case ModuleID::Anonymous119: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsDownloader> inst = new nsDownloader();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous286: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TaggingService.sys.mjs"),
                                         "TaggingService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous377: {
      RefPtr<nsSecurityConsoleMessage> inst = new nsSecurityConsoleMessage();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AddonContentPolicy: {
      RefPtr<AddonContentPolicy> inst = new AddonContentPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CacheStorage: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::CacheStorageService> inst = new mozilla::net::CacheStorageService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous212: {
      return /* legacy */ mozilla::psm::NSSConstructor<nsCertTree>(aIID, aResult);
    }
    case ModuleID::Anonymous189: {
      RefPtr<mozilla::net::ObliviousHttpService> inst = new mozilla::net::ObliviousHttpService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous257: {
      RefPtr<mozilla::DAPTelemetry> inst = new mozilla::DAPTelemetry();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous131: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsAboutBlank::Create(aIID, aResult);
    }
    case ModuleID::Anonymous107: {
      MOZ_TRY(CallInitFunc(2));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsPrefLocalizedString>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::MimeHeaderParam: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsMIMEHeaderParamImpl> inst = new nsMIMEHeaderParamImpl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous155: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIInputChannelThrottleQueue> inst = mozilla::net::ThrottleQueue::Create();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::ThrottleQueue::Create())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::ThrottleQueue::Create())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIInputChannelThrottleQueue, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous420: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<CSPService> inst = new CSPService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous285: {
      RefPtr<nsNavHistory> inst = nsNavHistory::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsNavHistory::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsNavHistory::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsNavHistory, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous313: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierListManager.sys.mjs"),
                                         "RegistrationData",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::FileProtocolHandler: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsFileProtocolHandler> inst = new nsFileProtocolHandler();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ApplicationReputation: {
      RefPtr<ApplicationReputationService> inst = ApplicationReputationService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(ApplicationReputationService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(ApplicationReputationService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<ApplicationReputationService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous134: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsAboutProtocolHandler> inst = new mozilla::net::nsAboutProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous014: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/taskbartabs/TaskbarTabsCmd.sys.mjs"),
                                         "CommandLineHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous041: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCPeerConnection",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous036: {
      RefPtr<mozilla::dom::IndexedDatabaseManager> inst = mozilla::dom::IndexedDatabaseManager::FactoryCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::IndexedDatabaseManager::FactoryCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::IndexedDatabaseManager::FactoryCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::IndexedDatabaseManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous254: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/CrashManager.sys.mjs"),
                                         "getCrashManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous445: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsMixedContentBlocker> inst = new nsMixedContentBlocker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous213: {
      RefPtr<mozilla::psm::CRLiteTimestamp> inst = new mozilla::psm::CRLiteTimestamp();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous074: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/NetworkGeolocationProvider.sys.mjs"),
                                         "NetworkGeolocationProvider",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous411: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIDocumentViewer>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous269: {
      RefPtr<mozilla::MozIntlHelper> inst = new mozilla::MozIntlHelper();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous391: {
      RefPtr<nsSupportsPRUint64> inst = new nsSupportsPRUint64();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous053: {
      RefPtr<mozilla::dom::nsFakeSynthServices> inst = mozilla::dom::nsFakeSynthServices::GetInstanceForService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::nsFakeSynthServices::GetInstanceForService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::nsFakeSynthServices::GetInstanceForService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::nsFakeSynthServices, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous046: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "GlobalPCList",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous341: {
      RefPtr<nsColorPickerProxy> inst = new nsColorPickerProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous079: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozHunspell>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous462: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::nsSynthVoiceRegistry> inst = mozilla::dom::nsSynthVoiceRegistry::GetInstanceForService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::nsSynthVoiceRegistry::GetInstanceForService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::nsSynthVoiceRegistry::GetInstanceForService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::nsSynthVoiceRegistry, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous279: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginManagerPrompter.sys.mjs"),
                                         "LoginManagerPrompter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous240: {
      RefPtr<mozilla::FinalizationWitnessService> inst = new mozilla::FinalizationWitnessService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous200: {
      return /* legacy */ mozilla::psm::NSSConstructor<nsPK11TokenDB>(aIID, aResult);
    }
    case ModuleID::Anonymous332: {
      RefPtr<nsXREDirProvider> inst = nsXREDirProvider::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsXREDirProvider::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsXREDirProvider::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsXREDirProvider, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous133: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsAboutCacheEntry> inst = new nsAboutCacheEntry();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous129: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsMIMEInputStreamConstructor(aIID, aResult);
    }
    case ModuleID::PrivateAttribution: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PrivateAttributionService.sys.mjs"),
                                         "PrivateAttributionService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous140: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSafeAboutProtocolHandler> inst = new mozilla::net::nsSafeAboutProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous077: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/RemotePermissionService.sys.mjs"),
                                         "RemotePermissionService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous378: {
      RefPtr<nsStorageStream> inst = new nsStorageStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous116: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsBufferedInputStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous323: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amManager.sys.mjs"),
                                         "amGleanDaily",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous130: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsINetworkConnectivityService> inst = mozilla::net::NetworkConnectivityService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::NetworkConnectivityService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::NetworkConnectivityService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsINetworkConnectivityService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous358: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsClipboardHelper> inst = new nsClipboardHelper();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ScriptSecurityManager: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ Construct_nsIScriptSecurityManager(aIID, aResult);
    }
    case ModuleID::Anonymous259: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/EnterprisePolicies.sys.mjs"),
                                         "EnterprisePolicies",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous382: {
      RefPtr<nsSupportsFloat> inst = new nsSupportsFloat();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous051: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "CreateOfferRequest",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CORSPreflightCache: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsICORSPreflightCache> inst = nsCORSListenerProxy::GetCORSPreflightSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsCORSListenerProxy::GetCORSPreflightSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsCORSListenerProxy::GetCORSPreflightSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICORSPreflightCache, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous127: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsInputStreamPump> inst = new nsInputStreamPump();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous368: {
      RefPtr<nsBinaryOutputStream> inst = new nsBinaryOutputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierPrefixSet: {
      RefPtr<nsUrlClassifierPrefixSet> inst = new nsUrlClassifierPrefixSet();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous392: {
      RefPtr<nsSupportsPRUint8> inst = new nsSupportsPRUint8();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous353: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsHTMLFormatConverter> inst = new nsHTMLFormatConverter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous293: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/MainProcessSingleton.sys.mjs"),
                                         "MainProcessSingleton",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous284: {
      RefPtr<nsNavBookmarks> inst = nsNavBookmarks::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsNavBookmarks::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsNavBookmarks::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsNavBookmarks, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous096: {
      RefPtr<nsConverterOutputStream> inst = new nsConverterOutputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::IDN: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIDNService> inst = new nsIDNService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous369: {
      RefPtr<nsChromeProtocolHandler> inst = new nsChromeProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous356: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsApplicationChooser> inst = new nsApplicationChooser();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous421: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::IntegrityPolicy> inst = new mozilla::dom::IntegrityPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous407: {
      RefPtr<nsAppShellService> inst = new nsAppShellService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous171: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsStandardURL::Mutator> inst = new mozilla::net::nsStandardURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous388: {
      RefPtr<nsSupportsPRTime> inst = new nsSupportsPRTime();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous025: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsOSPermissionRequest> inst = new nsOSPermissionRequest();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous095: {
      RefPtr<nsConverterInputStream> inst = new nsConverterInputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous106: {
      RefPtr<nsZipWriter> inst = new nsZipWriter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous049: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCRtpSender",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous390: {
      RefPtr<nsSupportsPRUint32> inst = new nsSupportsPRUint32();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous069: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/Push.sys.mjs"),
                                         "Push",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous023: {
      MOZ_TRY(CallInitFunc(0));
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URIFixup.sys.mjs"),
                                         "URIFixupInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::GfxInfo: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<mozilla::widget::GfxInfo> inst = new mozilla::widget::GfxInfo();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous245: {
      RefPtr<nsICascadeFilter> inst = mozilla::ConstructCascadeFilter();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::ConstructCascadeFilter())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::ConstructCascadeFilter())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICascadeFilter, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous386: {
      RefPtr<nsSupportsPRInt32> inst = new nsSupportsPRInt32();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous158: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsStdURLParser> inst = new nsStdURLParser();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous439: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateContentPolicy(aIID, aResult);
    }
    case ModuleID::Anonymous115: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewBinaryDetectorFactory(aIID, aResult);
    }
    case ModuleID::Anonymous283: {
      RefPtr<nsFaviconService> inst = nsFaviconService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsFaviconService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsFaviconService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsFaviconService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous186: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/WellKnownOpportunisticUtils.sys.mjs"),
                                         "WellKnownOpportunisticUtils",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous255: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/nsCrashMonitor.sys.mjs"),
                                         "CrashMonitor",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous401: {
      return /* legacy */ nsPipeConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous405: {
      return /* legacy */ nsTimer::XPCOMConstructor(aIID, aResult);
    }
    case ModuleID::SocketTransport: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSocketTransportService> inst = new mozilla::net::nsSocketTransportService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous194: {
      RefPtr<mozilla::net::UrlClassifierExceptionList> inst = new mozilla::net::UrlClassifierExceptionList();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous063: {
      RefPtr<mozilla::dom::payments::PaymentAddress> inst = new mozilla::dom::payments::PaymentAddress();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::DownloadPlatform: {
      RefPtr<DownloadPlatform> inst = new DownloadPlatform();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous078: {
      RefPtr<nsReadConfig> inst = new nsReadConfig();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous028: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsWebNavigationInfo> inst = new nsWebNavigationInfo();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous362: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsPrintDialogServiceGTK> inst = new nsPrintDialogServiceGTK();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous164: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewMultiMixedConvFactory(aIID, aResult);
    }
    case ModuleID::IdentityCredentialPromptService: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/IdentityCredentialPromptService.sys.mjs"),
                                         "IdentityCredentialPromptService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous027: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<PlatformLocalHandlerApp_t> inst = new PlatformLocalHandlerApp_t();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous344: {
      RefPtr<nsISupports> inst = nsFilePickerSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsFilePickerSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsFilePickerSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous195: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("chrome://remote/content/components/RemoteAgent.sys.mjs"),
                                         "RemoteAgentFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous040: {
      RefPtr<nsStunUDPSocketFilterHandler> inst = new nsStunUDPSocketFilterHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::StreamConverter: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewStreamConvServiceFactory(aIID, aResult);
    }
    case ModuleID::Anonymous082: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<imgLoader> inst = new imgLoader();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous380: {
      RefPtr<nsSupportsChar> inst = new nsSupportsChar();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous365: {
      return /* legacy */ nsDebugImpl::Create(aIID, aResult);
    }
    case ModuleID::Anonymous068: {
      RefPtr<mozilla::dom::power::PowerManagerService> inst = mozilla::dom::power::PowerManagerService::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::power::PowerManagerService::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::power::PowerManagerService::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::power::PowerManagerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous033: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SlowScriptDebug.sys.mjs"),
                                         "SlowScriptDebug",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::DBusHandlerApp: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsDBusHandlerApp> inst = new nsDBusHandlerApp();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous437: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateGlobalMessageManager(aIID, aResult);
    }
    case ModuleID::Anonymous408: {
      RefPtr<nsWindowMediator> inst = new nsWindowMediator();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous417: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIDocumentLoaderFactory>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous052: {
      RefPtr<mozilla::dom::SpeechDispatcherService> inst = mozilla::dom::SpeechDispatcherService::GetInstanceForService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::SpeechDispatcherService::GetInstanceForService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::SpeechDispatcherService::GetInstanceForService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::SpeechDispatcherService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous381: {
      RefPtr<nsSupportsDouble> inst = new nsSupportsDouble();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous197: {
      RefPtr<nsNSSDialogs> inst = new nsNSSDialogs();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous050: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCRtpReceiver",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous318: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SimpleServices.sys.mjs"),
                                         "HttpIndexViewer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous277: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginInfo.sys.mjs"),
                                         "nsLoginInfo",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous011: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/PromptCollection.sys.mjs"),
                                         "PromptCollection",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous101: {
      RefPtr<nsJARProtocolHandler> inst = nsJARProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsJARProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsJARProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsJARProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous431: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::WorkerDebuggerManager> inst = mozilla::dom::WorkerDebuggerManager::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::WorkerDebuggerManager::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::WorkerDebuggerManager::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::WorkerDebuggerManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous185: {
      RefPtr<nsGIOProtocolHandler> inst = nsGIOProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsGIOProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsGIOProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsGIOProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous138: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::PageThumbProtocolHandler> inst = mozilla::net::PageThumbProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::PageThumbProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::PageThumbProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::PageThumbProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Dashboard: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::Dashboard> inst = new mozilla::net::Dashboard();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::IO: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsIOService> inst = mozilla::net::nsIOService::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::nsIOService::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::nsIOService::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::nsIOService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous215: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/psm/ClientAuthDialogService.sys.mjs"),
                                         "ClientAuthDialogService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous017: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://devtools/client/jsonview/Converter.sys.mjs"),
                                         "Converter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous148: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsServerSocket> inst = new mozilla::net::nsServerSocket();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous300: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UserCharacteristicsPageService.sys.mjs"),
                                         "UserCharacteristicsPageService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous104: {
      RefPtr<nsZipReaderCache> inst = new nsZipReaderCache();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous135: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsDataHandler::Create(aIID, aResult);
    }
    case ModuleID::Anonymous229: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PurgeTrackerService.sys.mjs"),
                                         "PurgeTrackerService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous299: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FingerprintingWebCompatService.sys.mjs"),
                                         "FingerprintingWebCompatService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous071: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/QuotaUtilsService.sys.mjs"),
                                         "QuotaUtilsService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::NetworkErrorLogging: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/NetworkErrorLogging.sys.mjs"),
                                         "NetworkErrorLogging",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous214: {
      RefPtr<mozilla::DataStorageManager> inst = new mozilla::DataStorageManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous270: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/mozIntl.sys.mjs"),
                                         "MozIntl",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous147: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsSerializationHelper> inst = new nsSerializationHelper();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous248: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/DefaultCLH.sys.mjs"),
                                         "nsDefaultCLH",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous112: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsAtomicFileOutputStream> inst = new nsAtomicFileOutputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous003: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/BrowserContentHandler.sys.mjs"),
                                         "nsDefaultCommandLineHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous012: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/WebProtocolHandlerRegistrar.sys.mjs"),
                                         "WebProtocolHandlerRegistrar",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous375: {
      RefPtr<nsProcess> inst = new nsProcess();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous196: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("chrome://remote/content/components/Marionette.sys.mjs"),
                                         "MarionetteFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous174: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleURI::Mutator> inst = new mozilla::net::nsSimpleURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous291: {
      RefPtr<mozISyncedBookmarksMerger> inst = mozilla::places::NewSyncedBookmarksMerger();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::places::NewSyncedBookmarksMerger())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::places::NewSyncedBookmarksMerger())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozISyncedBookmarksMerger, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::TypeAheadFind: {
      RefPtr<nsTypeAheadFind> inst = new nsTypeAheadFind();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous295: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/Prompter.sys.mjs"),
                                         "Prompter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous114: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::BackgroundFileSaverStreamListener> inst = new mozilla::net::BackgroundFileSaverStreamListener();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous326: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ContentDispatchChooser.sys.mjs"),
                                         "nsContentDispatchChooser",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous413: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::BlobURL::Mutator> inst = new mozilla::dom::BlobURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous157: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsUDPSocket> inst = new mozilla::net::nsUDPSocket();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ProtocolProxy: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsProtocolProxyService> inst = new mozilla::net::nsProtocolProxyService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous370: {
      RefPtr<nsHashPropertyBagCC> inst = new nsHashPropertyBagCC();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous414: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::BlobURL::Mutator> inst = new mozilla::dom::BlobURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous085: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<mozilla::image::imgTools> inst = new mozilla::image::imgTools();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous330: {
      RefPtr<nsFind> inst = new nsFind();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous273: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginManager.sys.mjs"),
                                         "LoginManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous087: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsICOEncoder> inst = new nsICOEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::HttpActivityDistributor: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsHttpActivityDistributor> inst = new mozilla::net::nsHttpActivityDistributor();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous099: {
      RefPtr<mozJSSubScriptLoader> inst = new mozJSSubScriptLoader();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous168: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleNestedURI::Mutator> inst = new mozilla::net::nsSimpleNestedURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous267: {
      RefPtr<nsMediaSniffer> inst = new nsMediaSniffer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous327: {
      RefPtr<nsGIOService> inst = new nsGIOService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous162: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewUnknownDecoderFactory(aIID, aResult);
    }
    case ModuleID::Anonymous083: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<mozilla::image::ImageBlocker> inst = new mozilla::image::ImageBlocker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous121: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsFileOutputStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous204: {
      return /* legacy */ crypto_hash_constructor(aIID, aResult);
    }
    case ModuleID::Anonymous113: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::BackgroundFileSaverOutputStream> inst = new mozilla::net::BackgroundFileSaverOutputStream();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous177: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsICookieJarSettings> inst = mozilla::net::CookieJarSettings::CreateForXPCOM();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::CookieJarSettings::CreateForXPCOM())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::CookieJarSettings::CreateForXPCOM())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICookieJarSettings, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous241: {
      RefPtr<nsBrowserStatusFilter> inst = new nsBrowserStatusFilter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CaptivePortal: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsICaptivePortalService> inst = mozilla::net::CaptivePortalService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::CaptivePortalService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::CaptivePortalService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICaptivePortalService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous400: {
      return /* legacy */ nsMultiplexInputStreamConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous136: {
      MOZ_TRY(CallInitFunc(3));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozilla::net::nsHttpsHandler>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous406: {
      RefPtr<nsTimerManager> inst = new nsTimerManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous223: {
      RefPtr<mozilla::storage::Service> inst = mozilla::storage::Service::getSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::storage::Service::getSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::storage::Service::getSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::storage::Service, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous048: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCPeerConnectionStatic",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous182: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::CachePurgeLock> inst = new mozilla::net::CachePurgeLock();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous346: {
      RefPtr<nsISupports> inst = nsScreenManagerSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsScreenManagerSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsScreenManagerSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous006: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/ProfileMigrator.sys.mjs"),
                                         "ProfileMigrator",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous339: {
      RefPtr<nsClipboardProxy> inst = new nsClipboardProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous029: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsExternalHelperAppService> inst = nsExternalHelperAppService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsExternalHelperAppService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsExternalHelperAppService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsExternalHelperAppService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous340: {
      RefPtr<nsISupports> inst = nsColorPickerSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsColorPickerSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsColorPickerSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous209: {
      return /* legacy */ mozilla::psm::NSSConstructor<OSReauthenticator>(aIID, aResult);
    }
    case ModuleID::Anonymous247: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ClearBySiteEntry.sys.mjs"),
                                         "ClearBySiteEntry",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous176: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsISupports> inst = mozilla::net::GetSFVService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::GetSFVService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::GetSFVService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous001: {
      RefPtr<nsGNOMEShellService> inst = new nsGNOMEShellService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::FindService: {
      RefPtr<nsFindService> inst = new nsFindService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous144: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ mozilla::net::WebSocketChannelConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous415: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateChildMessageManager(aIID, aResult);
    }
    case ModuleID::Anonymous217: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozISandboxReporter>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous243: {
      RefPtr<mozilla::nsTerminator> inst = new mozilla::nsTerminator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::NSSErrors: {
      RefPtr<mozilla::psm::NSSErrorsService> inst = new mozilla::psm::NSSErrorsService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous383: {
      RefPtr<nsSupportsInterfacePointer> inst = new nsSupportsInterfacePointer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous022: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AboutDevToolsToolboxRegistration.sys.mjs"),
                                         "AboutDevtoolsToolbox",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous066: {
      RefPtr<mozilla::dom::PaymentRequestService> inst = mozilla::dom::PaymentRequestService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::PaymentRequestService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::PaymentRequestService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::PaymentRequestService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::StringBundle: {
      RefPtr<nsStringBundleService> inst = new nsStringBundleService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous317: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SimpleServices.sys.mjs"),
                                         "AddonLocalizationConverter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous216: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozISandboxSettings>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous013: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/sessionstore/SessionStoreFunctions.sys.mjs"),
                                         "SessionStoreFunctions",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous345: {
      RefPtr<nsFilePickerProxy> inst = new nsFilePickerProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous360: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsUserIdleService> inst = nsUserIdleServiceGTK::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsUserIdleServiceGTK::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsUserIdleServiceGTK::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsUserIdleService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous282: {
      RefPtr<nsCachedFaviconProtocolHandler> inst = new nsCachedFaviconProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous280: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/AutoCompleteSimpleSearch.sys.mjs"),
                                         "AutoCompleteSimpleSearch",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UUIDGenerator: {
      RefPtr<nsUUIDGenerator> inst = new nsUUIDGenerator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous111: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsAsyncStreamCopier> inst = new nsAsyncStreamCopier();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous261: {
      RefPtr<mozilla::extensions::NativeMessagingPortal> inst = mozilla::extensions::NativeMessagingPortal::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::extensions::NativeMessagingPortal::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::extensions::NativeMessagingPortal::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::extensions::NativeMessagingPortal, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous055: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("moz-src:///dom/notification/NotificationStorage.sys.mjs"),
                                         "NotificationStorage",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous348: {
      MOZ_TRY(CallInitFunc(5));
      return /* legacy */ nsAppShellConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous092: {
      RefPtr<nsMozIconURI::Mutator> inst = new nsMozIconURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous288: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PlacesExpiration.sys.mjs"),
                                         "nsPlacesExpiration",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous005: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/StartupRecorder.sys.mjs"),
                                         "StartupRecorder",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous418: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsStyleSheetService> inst = new nsStyleSheetService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous361: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsDeviceContextSpecGTK> inst = new nsDeviceContextSpecGTK();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CredentialChooserService: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/CredentialChooserService.sys.mjs"),
                                         "CredentialChooserService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous329: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsUnixSystemProxySettings>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous117: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsBufferedOutputStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous294: {
      RefPtr<nsIProcessToolsService> inst = GetProcessToolsService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(GetProcessToolsService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(GetProcessToolsService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIProcessToolsService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous246: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ClearDataService.sys.mjs"),
                                         "ClearDataService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous227: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TrackingDBService.sys.mjs"),
                                         "TrackingDBService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous226: {
      RefPtr<ProfileAfterChangeGate> inst = new ProfileAfterChangeGate();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous397: {
      RefPtr<nsINIParserFactory> inst = new nsINIParserFactory();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous225: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/BTPRemoteExceptionList.sys.mjs"),
                                         "BTPRemoteExceptionList",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous232: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URLQueryStrippingListService.sys.mjs"),
                                         "URLQueryStrippingListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous035: {
      RefPtr<mozilla::dom::BlobURLProtocolHandler> inst = new mozilla::dom::BlobURLProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous211: {
      RefPtr<psm::PublicKeyPinningService> inst = new psm::PublicKeyPinningService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous350: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<TaskbarProgress> inst = new TaskbarProgress();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous203: {
      RefPtr<nsClientAuthRememberService> inst = new nsClientAuthRememberService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous047: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCStatsReport",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::PlacesPreviewsHelper: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PlacesPreviews.sys.mjs"),
                                         "PlacesPreviewsHelperService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous224: {
      RefPtr<mozilla::storage::VacuumManager> inst = mozilla::storage::VacuumManager::getSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::storage::VacuumManager::getSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::storage::VacuumManager::getSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::storage::VacuumManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::StreamTransport: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsStreamTransportService> inst = new mozilla::net::nsStreamTransportService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous105: {
      RefPtr<nsDeflateConverter> inst = new nsDeflateConverter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous429: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::quota::QuotaManagerService> inst = mozilla::dom::quota::QuotaManagerService::FactoryCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::quota::QuotaManagerService::FactoryCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::quota::QuotaManagerService::FactoryCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::quota::QuotaManagerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous193: {
      RefPtr<mozilla::net::UrlClassifierExceptionListEntry> inst = new mozilla::net::UrlClassifierExceptionListEntry();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous016: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://devtools/client/jsonview/Sniffer.sys.mjs"),
                                         "Sniffer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous373: {
      RefPtr<nsMemoryInfoDumper> inst = new nsMemoryInfoDumper();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous154: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ mozilla::net::nsStreamLoader::Create(aIID, aResult);
    }
    case ModuleID::Anonymous271: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/MozProtocolHandler.sys.mjs"),
                                         "MozProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous057: {
      RefPtr<mozilla::dom::notification::NotificationHandler> inst = mozilla::dom::notification::NotificationHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::notification::NotificationHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::notification::NotificationHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::notification::NotificationHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous423: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<PolicyContainer> inst = new PolicyContainer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous175: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsICookieService> inst = mozilla::net::CookieService::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::CookieService::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::CookieService::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsICookieService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Directory: {
      return /* legacy */ nsDirectoryService::Create(aIID, aResult);
    }
    case ModuleID::Anonymous059: {
      RefPtr<mozilla::dom::BasicCardResponseData> inst = new mozilla::dom::BasicCardResponseData();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous385: {
      RefPtr<nsSupportsPRInt16> inst = new nsSupportsPRInt16();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous202: {
      RefPtr<nsNSSCertificate> inst = new nsNSSCertificate();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous297: {
      RefPtr<nsIRemoteService> inst = GetRemoteService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(GetRemoteService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(GetRemoteService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIRemoteService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous281: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/pdfjs.sys.mjs"),
                                         "StreamConverterFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous109: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<ArrayBufferInputStream> inst = new ArrayBufferInputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous073: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsISessionStorageService>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous152: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsStandardURL::Mutator> inst = new mozilla::net::nsStandardURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Locale: {
      RefPtr<mozilla::intl::LocaleService> inst = mozilla::intl::LocaleService::GetInstanceAddRefed();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::intl::LocaleService::GetInstanceAddRefed())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::intl::LocaleService::GetInstanceAddRefed())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::intl::LocaleService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous060: {
      RefPtr<mozilla::dom::GeneralMethodChangeDetails> inst = new mozilla::dom::GeneralMethodChangeDetails();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous172: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::SubstitutingURL::Mutator> inst = new mozilla::net::SubstitutingURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous178: {
      MOZ_TRY(CallInitFunc(3));
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SimpleURIUnknownSchemesRemoteObserver.sys.mjs"),
                                         "SimpleURIUnknownSchemesRemoteObserver",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous234: {
      RefPtr<nsAutoCompleteSimpleResult> inst = new nsAutoCompleteSimpleResult();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous434: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIFocusManager>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous364: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsPrinterListCUPS> inst = new nsPrinterListCUPS();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous453: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::PushNotifier> inst = new mozilla::dom::PushNotifier();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous108: {
      MOZ_TRY(CallInitFunc(2));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsPrefOverrideMap>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Observer: {
      return /* legacy */ nsObserverService::Create(aIID, aResult);
    }
    case ModuleID::Anonymous289: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PlacesDBUtils.sys.mjs"),
                                         "PlacesDBUtilsIdleMaintenance",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous252: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/CookieBannerListService.sys.mjs"),
                                         "CookieBannerListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AuthPromptAdapter: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/Prompter.sys.mjs"),
                                         "AuthPromptAdapterFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous018: {
      RefPtr<mozilla::jsinspector::nsJSInspector> inst = new mozilla::jsinspector::nsJSInspector();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous301: {
      RefPtr<mozilla::nsRFPTargetSetIDL> inst = new mozilla::nsRFPTargetSetIDL();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous062: {
      RefPtr<mozilla::dom::PaymentAbortActionResponse> inst = new mozilla::dom::PaymentAbortActionResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous021: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/AboutDebuggingRegistration.sys.mjs"),
                                         "AboutDebugging",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::HttpHandler: {
      MOZ_TRY(CallInitFunc(3));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozilla::net::nsHttpHandler>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous190: {
      RefPtr<mozilla::net::ReplacedHttpResponse> inst = new mozilla::net::ReplacedHttpResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous150: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleURI::Mutator> inst = new mozilla::net::nsSimpleURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous145: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ mozilla::net::WebSocketSSLChannelConstructor(aIID, aResult);
    }
    case ModuleID::ExternalProtocolHandler: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsExternalProtocolHandler> inst = new nsExternalProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::DocLoader: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsDocLoader> inst = new nsDocLoader();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::EffectiveTLD: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIEffectiveTLDService> inst = nsEffectiveTLDService::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsEffectiveTLDService::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsEffectiveTLDService::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIEffectiveTLDService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous451: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsParserUtils> inst = new nsParserUtils();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous030: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ContentAreaDropListener.sys.mjs"),
                                         "ContentAreaDropListener",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Console: {
      RefPtr<nsConsoleService> inst = new nsConsoleService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous084: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<imgRequestProxy> inst = new imgRequestProxy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Alerts: {
      RefPtr<nsAlertsService> inst = new nsAlertsService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous412: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsOpenWindowInfo> inst = new nsOpenWindowInfo();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous274: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginManagerAuthPrompter.sys.mjs"),
                                         "LoginManagerAuthPromptFactory",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous218: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FxAccountsPush.sys.mjs"),
                                         "FxAccountsPushService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous125: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsIncrementalStreamLoader::Create(aIID, aResult);
    }
    case ModuleID::Anonymous448: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsNoDataProtocolContentPolicy> inst = new nsNoDataProtocolContentPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous097: {
      RefPtr<nsScriptableUnicodeConverter> inst = new nsScriptableUnicodeConverter();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous258: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/DownloadLegacy.sys.mjs"),
                                         "DownloadLegacyTransfer",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous067: {
      RefPtr<mozilla::dom::PaymentShowActionResponse> inst = new mozilla::dom::PaymentShowActionResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous403: {
      return /* legacy */ nsStringInputStreamConstructor(aIID, aResult);
    }
    case ModuleID::NSSComponent: {
      RefPtr<nsNSSComponent> inst = new nsNSSComponent();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous118: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsINativeDNSResolverOverride> inst = mozilla::net::NativeDNSResolverOverride::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::NativeDNSResolverOverride::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::NativeDNSResolverOverride::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsINativeDNSResolverOverride, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous166: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsNestedAboutURI::Mutator> inst = new mozilla::net::nsNestedAboutURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous410: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsJSURI::Mutator> inst = new nsJSURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous384: {
      RefPtr<nsSupportsPRBool> inst = new nsSupportsPRBool();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous184: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ThirdPartyCookieBlockingExceptionListService.sys.mjs"),
                                         "ThirdPartyCookieExceptionEntry",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous210: {
      return /* legacy */ cert_storage_constructor(aIID, aResult);
    }
    case ModuleID::Anonymous201: {
      return /* legacy */ mozilla::psm::NSSConstructor<mozilla::psm::PKCS11ModuleDB>(aIID, aResult);
    }
    case ModuleID::Anonymous404: {
      return /* legacy */ nsEnvironment::Create(aIID, aResult);
    }
    case ModuleID::Anonymous316: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URLFormatter.sys.mjs"),
                                         "nsURLFormatterService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous394: {
      return /* legacy */ nsThreadManagerGetSingleton(aIID, aResult);
    }
    case ModuleID::Anonymous149: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsSimpleStreamListener> inst = new mozilla::net::nsSimpleStreamListener();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous379: {
      RefPtr<nsSupportsCString> inst = new nsSupportsCString();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous043: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCDTMFSender",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous020: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/DevToolsStartup.sys.mjs"),
                                         "DevToolsStartup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous314: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierHashCompleter.sys.mjs"),
                                         "HashCompleter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous165: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ CreateNewTXTToHTMLConvFactory(aIID, aResult);
    }
    case ModuleID::SiteSecurity: {
      RefPtr<nsSiteSecurityService> inst = new nsSiteSecurityService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous090: {
      MOZ_TRY(CallInitFunc(1));
      RefPtr<nsWebPEncoder> inst = new nsWebPEncoder();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous139: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::MozNewTabWallpaperProtocolHandler> inst = mozilla::net::MozNewTabWallpaperProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::MozNewTabWallpaperProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::MozNewTabWallpaperProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::net::MozNewTabWallpaperProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous389: {
      RefPtr<nsSupportsPRUint16> inst = new nsSupportsPRUint16();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous004: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource:///modules/BrowserGlue.sys.mjs"),
                                         "BrowserGlue",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::History: {
      RefPtr<mozilla::places::History> inst = mozilla::places::History::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::places::History::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::places::History::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::places::History, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous402: {
      return /* legacy */ nsScriptableInputStream::Create(aIID, aResult);
    }
    case ModuleID::CategoryManager: {
      return /* legacy */ nsCategoryManager::Create(aIID, aResult);
    }
    case ModuleID::Anonymous442: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateHTMLContentSerializer(aIID, aResult);
    }
    case ModuleID::SystemInfo: {
      RefPtr<nsSystemInfo> inst = new nsSystemInfo();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous287: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TaggingService.sys.mjs"),
                                         "TagAutoCompleteSearch",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierTestUtils: {
      RefPtr<nsUrlClassifierTestUtils> inst = nsUrlClassifierTestUtils::GetXPCOMSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsUrlClassifierTestUtils::GetXPCOMSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsUrlClassifierTestUtils::GetXPCOMSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsUrlClassifierTestUtils, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous120: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsFileInputStream::Create(aIID, aResult);
    }
    case ModuleID::Anonymous237: {
      RefPtr<BackgroundTasksRunner> inst = new BackgroundTasksRunner();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous272: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ShieldContentProcess.sys.mjs"),
                                         "AboutStudies",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous268: {
      RefPtr<mozilla::ml::MLUtils> inst = new mozilla::ml::MLUtils();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous070: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PushComponents.sys.mjs"),
                                         "Service",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous239: {
      RefPtr<mozilla::AddonManagerStartup> inst = mozilla::AddonManagerStartup::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::AddonManagerStartup::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::AddonManagerStartup::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::AddonManagerStartup, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::CookieBannerService: {
      RefPtr<mozilla::nsCookieBannerService> inst = mozilla::nsCookieBannerService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::nsCookieBannerService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::nsCookieBannerService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::nsCookieBannerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous199: {
      return /* legacy */ mozilla::psm::NSSConstructor<SecretDecoderRing>(aIID, aResult);
    }
    case ModuleID::Anonymous452: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::ContentPrincipal::Deserializer> inst = new mozilla::ContentPrincipal::Deserializer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous253: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/CrashService.sys.mjs"),
                                         "CrashService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous354: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsISound> inst = nsSound::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsSound::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsSound::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISound, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous235: {
      RefPtr<BackgroundTasks> inst = BackgroundTasks::GetSingletonAddRefed();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(BackgroundTasks::GetSingletonAddRefed())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(BackgroundTasks::GetSingletonAddRefed())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<BackgroundTasks, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Prefetch: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsPrefetchService> inst = new nsPrefetchService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous058: {
      RefPtr<mozilla::dom::BasicCardMethodChangeDetails> inst = new mozilla::dom::BasicCardMethodChangeDetails();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous236: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/BackgroundTasksManager.sys.mjs"),
                                         "BackgroundTasksManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous191: {
      RefPtr<nsIChannelClassifierService> inst = mozilla::net::ChannelClassifierService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::ChannelClassifierService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::ChannelClassifierService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIChannelClassifierService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous094: {
      RefPtr<mozilla::intl::OSPreferences> inst = mozilla::intl::OSPreferences::GetInstanceAddRefed();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::intl::OSPreferences::GetInstanceAddRefed())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::intl::OSPreferences::GetInstanceAddRefed())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::intl::OSPreferences, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous019: {
      RefPtr<mozilla::jsdebugger::JSDebugger> inst = new mozilla::jsdebugger::JSDebugger();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous054: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/WebVTTParserWrapper.sys.mjs"),
                                         "WebVTTParserWrapper",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous278: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/crypto-SDR.sys.mjs"),
                                         "LoginManagerCrypto_SDR",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous449: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::NullPrincipal::Deserializer> inst = new mozilla::NullPrincipal::Deserializer();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous349: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<mozilla::widget::ScreenManager> inst = mozilla::widget::ScreenManager::GetAddRefedSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::widget::ScreenManager::GetAddRefedSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::widget::ScreenManager::GetAddRefedSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::widget::ScreenManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous026: {
      MOZ_TRY(CallInitFunc(0));
      RefPtr<nsIHandlerService> inst = mozilla::dom::ContentHandlerService::Create();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::ContentHandlerService::Create())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::ContentHandlerService::Create())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIHandlerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous034: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ConsoleAPIStorage.sys.mjs"),
                                         "ConsoleAPIStorageService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous443: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreatePlainTextSerializer(aIID, aResult);
    }
    case ModuleID::RFPService: {
      RefPtr<mozilla::nsRFPService> inst = mozilla::nsRFPService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::nsRFPService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::nsRFPService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::nsRFPService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous065: {
      RefPtr<mozilla::dom::PaymentCompleteActionResponse> inst = new mozilla::dom::PaymentCompleteActionResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ContentSecurityManager: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsContentSecurityManager> inst = new nsContentSecurityManager();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous463: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::OnlineSpeechRecognitionService> inst = new mozilla::OnlineSpeechRecognitionService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous322: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amManager.sys.mjs"),
                                         "amManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous132: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsAboutCache::Create(aIID, aResult);
    }
    case ModuleID::Anonymous320: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/HelperAppDlg.sys.mjs"),
                                         "nsUnknownContentTypeDialog",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous456: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::StorageActivityService> inst = mozilla::dom::StorageActivityService::GetOrCreate();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::StorageActivityService::GetOrCreate())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::StorageActivityService::GetOrCreate())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::StorageActivityService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous308: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TelemetryControllerContent.sys.mjs"),
                                         "getTelemetryController",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AppStartup: {
      RefPtr<nsAppStartup> inst = new nsAppStartup();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous206: {
      RefPtr<nsCertOverrideService> inst = new nsCertOverrideService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::WindowWatcher: {
      RefPtr<nsWindowWatcher> inst = new nsWindowWatcher();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous205: {
      return /* legacy */ mozilla::psm::NSSConstructor<ContentSignatureVerifier>(aIID, aResult);
    }
    case ModuleID::Anonymous352: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsFilePicker> inst = new nsFilePicker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous310: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UpdateTimerManager.sys.mjs"),
                                         "TimerManager",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous039: {
      RefPtr<nsStunTCPSocketFilterHandler> inst = new nsStunTCPSocketFilterHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous367: {
      RefPtr<nsBinaryInputStream> inst = new nsBinaryInputStream();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous374: {
      RefPtr<nsMemoryReporterManager> inst = new nsMemoryReporterManager();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous351: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsColorPicker> inst = new nsColorPicker();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous230: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PartitioningExceptionListService.sys.mjs"),
                                         "PartitioningExceptionListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous436: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::Geolocation> inst = mozilla::dom::Geolocation::NonWindowSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::dom::Geolocation::NonWindowSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::dom::Geolocation::NonWindowSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::dom::Geolocation, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous221: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://services-sync/Weave.sys.mjs"),
                                         "AboutWeaveLog",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::URLQueryStringStripper: {
      RefPtr<mozilla::URLQueryStringStripper> inst = mozilla::URLQueryStringStripper::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::URLQueryStringStripper::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::URLQueryStringStripper::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::URLQueryStringStripper, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous315: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierRemoteSettingsService.sys.mjs"),
                                         "UrlClassifierRemoteSettingsService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous170: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::SubstitutingURL::Mutator> inst = new mozilla::net::SubstitutingURL::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous372: {
      return /* legacy */ nsLocalFileConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous363: {
      MOZ_TRY(CallInitFunc(5));
      RefPtr<nsPrintSettingsServiceGTK> inst = new nsPrintSettingsServiceGTK();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous128: {
      MOZ_TRY(CallInitFunc(3));
      return /* legacy */ nsLoadGroupConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous347: {
      RefPtr<mozilla::widget::ScreenManager> inst = mozilla::widget::ScreenManager::GetAddRefedSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::widget::ScreenManager::GetAddRefedSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::widget::ScreenManager::GetAddRefedSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::widget::ScreenManager, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous192: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/UrlClassifierExceptionListService.sys.mjs"),
                                         "UrlClassifierExceptionListService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous427: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ LocalStorageManagerConstructor(aIID, aResult);
    }
    case ModuleID::URIFixup: {
      MOZ_TRY(CallInitFunc(0));
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/URIFixup.sys.mjs"),
                                         "URIFixup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous181: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsNetworkLinkService> inst = new nsNetworkLinkService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous335: {
      RefPtr<nsProfiler> inst = new nsProfiler();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous424: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsDataDocumentContentPolicy> inst = new nsDataDocumentContentPolicy();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous444: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsIMediaManagerService> inst = mozilla::MediaManager::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::MediaManager::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::MediaManager::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIMediaManagerService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous290: {
      RefPtr<mozilla::places::PageIconProtocolHandler> inst = mozilla::places::PageIconProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::places::PageIconProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::places::PageIconProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::places::PageIconProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous457: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsIPrincipal> inst = nsScriptSecurityManager::SystemPrincipalSingletonConstructor();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsScriptSecurityManager::SystemPrincipalSingletonConstructor())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsScriptSecurityManager::SystemPrincipalSingletonConstructor())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIPrincipal, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous324: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amWebAPI.sys.mjs"),
                                         "WebAPI",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous265: {
      return /* legacy */ nsSQLiteKeyValueServiceConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous141: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsResProtocolHandler> inst = nsResProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsResProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsResProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsResProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous098: {
      RefPtr<mozilla::ipc::ForkServerLauncher> inst = mozilla::ipc::ForkServerLauncher::Create();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::ipc::ForkServerLauncher::Create())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::ipc::ForkServerLauncher::Create())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::ipc::ForkServerLauncher, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous395: {
      RefPtr<nsVariantCC> inst = new nsVariantCC();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::PageThumbsStorage: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PageThumbsStorageService.sys.mjs"),
                                         "PageThumbsStorageService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::NSSCertificateDB: {
      return /* legacy */ mozilla::psm::NSSConstructor<nsNSSCertificateDB>(aIID, aResult);
    }
    case ModuleID::Anonymous207: {
      nsCOMPtr<nsISupports> inst = mozCreateComponent<mozilla::psm::TransportSecurityInfo>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous143: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsViewSourceHandler> inst = new mozilla::net::nsViewSourceHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous153: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsStreamListenerTee> inst = new mozilla::net::nsStreamListenerTee();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous091: {
      RefPtr<nsIconProtocolHandler> inst = new nsIconProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous169: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsNestedAboutURI::Mutator> inst = new mozilla::net::nsNestedAboutURI::Mutator();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous000: {
      return /* legacy */ mozilla::browser::AboutRedirector::Create(aIID, aResult);
    }
    case ModuleID::Anonymous276: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginManagerAuthPrompter.sys.mjs"),
                                         "LoginManagerAuthPrompter",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::BounceTrackingProtection: {
      RefPtr<mozilla::BounceTrackingProtection> inst = mozilla::BounceTrackingProtection::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::BounceTrackingProtection::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::BounceTrackingProtection::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::BounceTrackingProtection, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::WifiMonitor: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsWifiMonitor> inst = new nsWifiMonitor();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous249: {
      RefPtr<mozilla::ContentBlockingAllowList> inst = new mozilla::ContentBlockingAllowList();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::HttpAuthCache: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIHttpAuthCache> inst = mozilla::net::nsHttpAuthManager::GetHttpAuthCacheSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::nsHttpAuthManager::GetHttpAuthCacheSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::nsHttpAuthManager::GetHttpAuthCacheSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIHttpAuthCache, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous307: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/TelemetryStartup.sys.mjs"),
                                         "TelemetryStartup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::UrlClassifierDB: {
      return /* legacy */ nsUrlClassifierDBServiceConstructor(aIID, aResult);
    }
    case ModuleID::Anonymous393: {
      RefPtr<nsSupportsString> inst = new nsSupportsString();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous123: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::nsHttpAuthManager> inst = new mozilla::net::nsHttpAuthManager();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous309: {
      MOZ_TRY(CallInitFunc(4));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsITelemetry>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous275: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/LoginAutoComplete.sys.mjs"),
                                         "LoginAutoComplete",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous464: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::FakeSpeechRecognitionService> inst = new mozilla::FakeSpeechRecognitionService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous465: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIAccessibilityService>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous045: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCSessionDescription",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous031: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/ProcessSelector.sys.mjs"),
                                         "RandomSelector",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous430: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ mozilla::dom::SDBConnection::Create(aIID, aResult);
    }
    case ModuleID::Anonymous458: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::TextInputProcessor> inst = new mozilla::TextInputProcessor();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Preferences: {
      MOZ_TRY(CallInitFunc(2));
      RefPtr<mozilla::Preferences> inst = mozilla::Preferences::GetInstanceForService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::Preferences::GetInstanceForService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::Preferences::GetInstanceForService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::Preferences, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AlertNotification: {
      RefPtr<mozilla::AlertNotification> inst = new mozilla::AlertNotification();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous328: {
      RefPtr<nsSystemAlertsService> inst = new nsSystemAlertsService();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous334: {
      RefPtr<nsToolkitProfileService> inst = NS_GetToolkitProfileService();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(NS_GetToolkitProfileService())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(NS_GetToolkitProfileService())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsToolkitProfileService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous007: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("moz-src:///browser/components/mozcachedohttp/MozCachedOHTTPProtocolHandler.sys.mjs"),
                                         "MozCachedOHTTPProtocolHandler",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous188: {
      return /* legacy */ oblivious_http_constructor(aIID, aResult);
    }
    case ModuleID::Anonymous331: {
      RefPtr<nsWebBrowserPersist> inst = new nsWebBrowserPersist();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous396: {
      RefPtr<nsVersionComparatorImpl> inst = new nsVersionComparatorImpl();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous321: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/amManager.sys.mjs"),
                                         "BlocklistService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous156: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::TLSServerSocket> inst = new mozilla::net::TLSServerSocket();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous447: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsJSProtocolHandler> inst = new nsJSProtocolHandler();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous304: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/FormHistoryStartup.sys.mjs"),
                                         "FormHistoryStartup",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous110: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<mozilla::net::LoadContextInfoFactory> inst = new mozilla::net::LoadContextInfoFactory();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous093: {
      RefPtr<mozilla::image::RemoteImageProtocolHandler> inst = mozilla::image::RemoteImageProtocolHandler::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::image::RemoteImageProtocolHandler::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::image::RemoteImageProtocolHandler::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::image::RemoteImageProtocolHandler, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous455: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsScriptError> inst = new nsScriptError();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous440: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateXMLContentSerializer(aIID, aResult);
    }
    case ModuleID::ThirdPartyUtil: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<ThirdPartyUtil> inst = new ThirdPartyUtil();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous450: {
      MOZ_TRY(CallInitFunc(6));
      return /* legacy */ CreateParentMessageManager(aIID, aResult);
    }
    case ModuleID::Anonymous242: {
      RefPtr<nsParentalControlsService> inst = new nsParentalControlsService();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::RandomGenerator: {
      return /* legacy */ mozilla::psm::NSSConstructor<nsRandomGenerator>(aIID, aResult);
    }
    case ModuleID::Anonymous425: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsDeviceSensors> inst = new nsDeviceSensors();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous333: {
      RefPtr<nsDialogParamBlock> inst = new nsDialogParamBlock();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous042: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "PeerConnectionObserver",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous044: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/media/PeerConnection.sys.mjs"),
                                         "RTCIceCandidate",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous338: {
      RefPtr<nsISupports> inst = nsClipboardSelector();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(nsClipboardSelector())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(nsClipboardSelector())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsISupports, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous009: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("moz-src:///browser/components/permissions/ContentPermissionPrompt.sys.mjs"),
                                         "ContentPermissionPrompt",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::AsyncShutdown: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/nsAsyncShutdown.sys.mjs"),
                                         "nsAsyncShutdownService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous256: {
      RefPtr<mozilla::ctypes::Module> inst = new mozilla::ctypes::Module();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous179: {
      MOZ_TRY(CallInitFunc(3));
      RefPtr<nsIMockNetworkLayerController> inst = mozilla::net::MockNetworkLayerController::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::net::MockNetworkLayerController::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::net::MockNetworkLayerController::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<nsIMockNetworkLayerController, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous180: {
      MOZ_TRY(CallInitFunc(3));
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/EssentialDomainsRemoteSettings.sys.mjs"),
                                         "EssentialDomainsRemoteSettings",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::TextToSubURI: {
      RefPtr<nsTextToSubURI> inst = new nsTextToSubURI();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous419: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<nsCSPContext> inst = new nsCSPContext();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous305: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/SearchService.sys.mjs"),
                                         "SearchService",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous015: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://webcompat/AboutCompat.sys.mjs"),
                                         "AboutCompat",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous064: {
      RefPtr<mozilla::dom::PaymentCanMakeActionResponse> inst = new mozilla::dom::PaymentCanMakeActionResponse();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous446: {
      MOZ_TRY(CallInitFunc(6));
      RefPtr<mozilla::dom::ReferrerInfo> inst = new mozilla::dom::ReferrerInfo();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous387: {
      RefPtr<nsSupportsPRInt64> inst = new nsSupportsPRInt64();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous296: {
      RefPtr<mozilla::reflect::Module> inst = new mozilla::reflect::Module();
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous231: {
      RefPtr<mozilla::ContentBlockingTelemetryService> inst = mozilla::ContentBlockingTelemetryService::GetSingleton();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::ContentBlockingTelemetryService::GetSingleton())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::ContentBlockingTelemetryService::GetSingleton())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::ContentBlockingTelemetryService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous080: {
      RefPtr<mozPersonalDictionary> inst = new mozPersonalDictionary();
      MOZ_TRY(inst->Init());
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::ExtensionPolicy: {
      RefPtr<mozilla::ExtensionPolicyService> inst = mozilla::ExtensionPolicyService::GetInstance();
      NS_ENSURE_TRUE(inst, NS_ERROR_OUT_OF_MEMORY);

      using T =
          RemoveAlreadyAddRefed<decltype(mozilla::ExtensionPolicyService::GetInstance())>::Type;
      static_assert(
          std::is_same_v<already_AddRefed<T>, decltype(mozilla::ExtensionPolicyService::GetInstance())>,
          "Singleton constructor must return already_AddRefed");
      static_assert(
          std::is_base_of<mozilla::ExtensionPolicyService, T>::value,
          "Singleton constructor must return correct already_AddRefed");

      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous292: {
      nsCOMPtr<nsISupports> inst;
      MOZ_TRY(ConstructESModuleComponent(nsLiteralCString("resource://gre/modules/PlacesFrecencyRecalculator.sys.mjs"),
                                         "PlacesFrecencyRecalculator",
                                         getter_AddRefs(inst)));
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous432: {
      MOZ_TRY(CallInitFunc(6));
      nsCOMPtr<nsISupports> inst = mozCreateComponent<nsIEventListenerService>();
      NS_ENSURE_TRUE(inst, NS_ERROR_FAILURE);
      return inst->QueryInterface(aIID, aResult);
    }
    case ModuleID::Anonymous233: {
      RefPtr<nsAutoCompleteController> inst = new nsAutoCompleteController();
      return inst->QueryInterface(aIID, aResult);
    }
  }

  MOZ_ASSERT_UNREACHABLE("Constructor didn't return");
  return NS_ERROR_FAILURE;
}


namespace {

class StaticModuleFactory final : public nsIFactory {
  NS_DECL_ISUPPORTS
  NS_DECL_NSIFACTORY

  explicit StaticModuleFactory(ModuleID aID) : mID(aID) {}

private:
  ~StaticModuleFactory() = default;

  const ModuleID mID;
};

NS_IMPL_ISUPPORTS(StaticModuleFactory, nsIFactory)

NS_IMETHODIMP StaticModuleFactory::CreateInstance(const nsIID& aIID,
                                                  void** aResult) {
  return CreateInstanceImpl(mID, aIID, aResult);
}

}  // anonymous namespace


already_AddRefed<nsIFactory> StaticModule::GetFactory() const {
  return do_AddRef(new StaticModuleFactory(ID()));
}

bool StaticModule::Active() const {
  return FastProcessSelectorMatches(mProcessSelector);
}

bool StaticModule::Overridable() const {
  return mContractID.mOffset != kNoContractID;
}

nsCString StaticModule::ContractID() const {
  MOZ_ASSERT(Overridable());
  return GetString(mContractID);
}

nsresult StaticModule::CreateInstance(const nsIID& aIID, void** aResult) const {
  return CreateInstanceImpl(ID(), aIID, aResult);
}

GetServiceHelper StaticModule::GetService() const {
  return { ID(), nullptr };
}

GetServiceHelper StaticModule::GetService(nsresult* aRv) const {
  return { ID(), aRv };
}


nsISupports* StaticModule::ServiceInstance() const {
  return gServiceInstances[Idx()];
}

void StaticModule::SetServiceInstance(
    already_AddRefed<nsISupports> aInst) const {
  gServiceInstances[Idx()] = aInst;
}


nsCString StaticCategoryEntry::Entry() const {
  return GetString(mEntry);
}

nsCString StaticCategoryEntry::Value() const {
  return GetString(mValue);
}

bool StaticCategoryEntry::Active() const {
  if (!FastProcessSelectorMatches(mProcessSelector)) {
    return false;
  }
#ifdef MOZ_BACKGROUNDTASKS
  if (MOZ_UNLIKELY(BackgroundTasks::IsBackgroundTaskMode())) {
    return mBackgroundTasksSelector != Module::BackgroundTasksSelector::NO_TASKS;
  }
#endif /* MOZ_BACKGROUNDTASKS */
  return true;
}

nsCString StaticCategory::Name() const {
  return GetString(mName);
}

nsCString JSServiceEntry::Name() const {
  return GetString(mName);
}

JSServiceEntry::InterfaceList JSServiceEntry::Interfaces() const {
  InterfaceList iids;
  iids.SetCapacity(mInterfaceCount);

  for (size_t i = 0; i < mInterfaceCount; i++) {
    nsXPTInterface ifaceID = gInterfaces[mInterfaceOffset.mOffset + i];
    iids.AppendElement(&nsXPTInterfaceInfo::Get(ifaceID)->IID());
  }
  return iids;
}


/* static */
const JSServiceEntry* JSServiceEntry::Lookup(const nsACString& aName) {
  return LookupJSService(aName);
}

nsCString StaticProtocolHandler::Scheme() const {
  return GetString(mScheme);
}

/* static */
const StaticProtocolHandler* StaticProtocolHandler::Lookup(const nsACString& aScheme) {
  return LookupProtocolHandler(aScheme);
}

/* static */ const StaticModule* StaticComponents::LookupByCID(
    const nsID& aCID) {
  return ModuleByCID(aCID);
}

/* static */ const StaticModule* StaticComponents::LookupByContractID(
    const nsACString& aContractID) {
  if (const ContractEntry* entry = LookupContractID(aContractID)) {
    if (!entry->Invalid()) {
      return &entry->Module();
    }
  }
  return nullptr;
}

/* static */ bool StaticComponents::InvalidateContractID(
    const nsACString& aContractID, bool aInvalid) {
  if (const ContractEntry* entry = LookupContractID(aContractID)) {
    entry->SetInvalid(aInvalid);
    return true;
  }
  return false;
}

/* static */ already_AddRefed<nsIUTF8StringEnumerator>
StaticComponents::GetComponentESModules() {
  auto esModules = MakeUnique<nsTArray<nsCString>>(std::size(gComponentESModules));

  for (const auto& entry : gComponentESModules) {
    esModules->AppendElement(GetString(entry));
  }

  nsCOMPtr<nsIUTF8StringEnumerator> result;
  MOZ_ALWAYS_SUCCEEDS(NS_NewAdoptingUTF8StringEnumerator(getter_AddRefs(result),
                                                         esModules.release()));
  return result.forget();
}

/* static */ Span<const JSServiceEntry> StaticComponents::GetJSServices() {
  return { gJSServices, std::size(gJSServices) };
}

/* static */ void StaticComponents::Shutdown() {
  CallUnloadFuncs();
}

/* static */ const nsID& Components::GetCID(ModuleID aID) {
  return gStaticModules[size_t(aID)].CID();
}

nsresult GetServiceHelper::operator()(const nsIID& aIID, void** aResult) const {
  nsresult rv =
      nsComponentManagerImpl::gComponentManager->GetService(mId, aIID, aResult);
  return SetResult(rv);
}

nsresult CreateInstanceHelper::operator()(const nsIID& aIID,
                                          void** aResult) const {
  const auto& entry = gStaticModules[size_t(mId)];
  if (!entry.Active()) {
    return SetResult(NS_ERROR_FACTORY_NOT_REGISTERED);
  }

  nsresult rv = entry.CreateInstance(aIID, aResult);
  return SetResult(rv);
}

}  // namespace xpcom
}  // namespace mozilla
