/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM DocumentPictureInPictureEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "DocumentPictureInPictureEvent.h"
#include "DocumentPictureInPictureEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/DocumentPictureInPictureEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "nsGlobalWindowInner.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(DocumentPictureInPictureEvent)

NS_IMPL_ADDREF_INHERITED(DocumentPictureInPictureEvent, Event)
NS_IMPL_RELEASE_INHERITED(DocumentPictureInPictureEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(DocumentPictureInPictureEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mWindow)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(DocumentPictureInPictureEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(DocumentPictureInPictureEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mWindow)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(DocumentPictureInPictureEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

DocumentPictureInPictureEvent::DocumentPictureInPictureEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

DocumentPictureInPictureEvent::~DocumentPictureInPictureEvent()
{
}

DocumentPictureInPictureEvent*
DocumentPictureInPictureEvent::AsDocumentPictureInPictureEvent()
{
  return this;
}

JSObject*
DocumentPictureInPictureEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return DocumentPictureInPictureEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<DocumentPictureInPictureEvent>
DocumentPictureInPictureEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const DocumentPictureInPictureEventInit& aEventInitDict)
{
  RefPtr<DocumentPictureInPictureEvent> e = new DocumentPictureInPictureEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mWindow = aEventInitDict.mWindow;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<DocumentPictureInPictureEvent>
DocumentPictureInPictureEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const DocumentPictureInPictureEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

nsGlobalWindowInner*
DocumentPictureInPictureEvent::Window() const
{
  return mWindow;
}


} // namespace mozilla::dom
