/* THIS FILE IS AUTOGENERATED FROM URLPattern.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "URLPatternBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/URLPattern.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



URLPatternInit::URLPatternInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
URLPatternInit::InitIds(JSContext* cx, URLPatternInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->username_id.init(cx, "username") ||
      !atomsCache->search_id.init(cx, "search") ||
      !atomsCache->protocol_id.init(cx, "protocol") ||
      !atomsCache->port_id.init(cx, "port") ||
      !atomsCache->pathname_id.init(cx, "pathname") ||
      !atomsCache->password_id.init(cx, "password") ||
      !atomsCache->hostname_id.init(cx, "hostname") ||
      !atomsCache->hash_id.init(cx, "hash") ||
      !atomsCache->baseURL_id.init(cx, "baseURL")) {
    return false;
  }
  return true;
}

bool
URLPatternInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  URLPatternInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<URLPatternInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->baseURL_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mBaseURL.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mBaseURL.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hash_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mHash.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mHash.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hostname_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mHostname.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mHostname.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->password_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPassword.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mPassword.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->pathname_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPathname.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mPathname.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->port_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mPort.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mPort.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->protocol_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mProtocol.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mProtocol.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->search_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSearch.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mSearch.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->username_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mUsername.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mUsername.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
URLPatternInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
URLPatternInit::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  URLPatternInitAtoms* atomsCache = GetAtomCache<URLPatternInitAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mBaseURL.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mBaseURL.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->baseURL_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHash.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mHash.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->hash_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHostname.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mHostname.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->hostname_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPassword.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mPassword.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->password_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPathname.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mPathname.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->pathname_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPort.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mPort.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->port_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mProtocol.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mProtocol.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->protocol_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mSearch.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mSearch.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->search_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mUsername.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mUsername.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->username_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
URLPatternInit::TraceDictionary(JSTracer* trc)
{
}

URLPatternInit&
URLPatternInit::operator=(const URLPatternInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mBaseURL.Reset();
  if (aOther.mBaseURL.WasPassed()) {
    mBaseURL.Construct(aOther.mBaseURL.Value());
  }
  mHash.Reset();
  if (aOther.mHash.WasPassed()) {
    mHash.Construct(aOther.mHash.Value());
  }
  mHostname.Reset();
  if (aOther.mHostname.WasPassed()) {
    mHostname.Construct(aOther.mHostname.Value());
  }
  mPassword.Reset();
  if (aOther.mPassword.WasPassed()) {
    mPassword.Construct(aOther.mPassword.Value());
  }
  mPathname.Reset();
  if (aOther.mPathname.WasPassed()) {
    mPathname.Construct(aOther.mPathname.Value());
  }
  mPort.Reset();
  if (aOther.mPort.WasPassed()) {
    mPort.Construct(aOther.mPort.Value());
  }
  mProtocol.Reset();
  if (aOther.mProtocol.WasPassed()) {
    mProtocol.Construct(aOther.mProtocol.Value());
  }
  mSearch.Reset();
  if (aOther.mSearch.WasPassed()) {
    mSearch.Construct(aOther.mSearch.Value());
  }
  mUsername.Reset();
  if (aOther.mUsername.WasPassed()) {
    mUsername.Construct(aOther.mUsername.Value());
  }
  return *this;
}



URLPatternOptions::URLPatternOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
URLPatternOptions::InitIds(JSContext* cx, URLPatternOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->ignoreCase_id.init(cx, "ignoreCase")) {
    return false;
  }
  return true;
}

bool
URLPatternOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  URLPatternOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<URLPatternOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->ignoreCase_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'ignoreCase' member of URLPatternOptions", &mIgnoreCase)) {
      return false;
    }
  } else {
    mIgnoreCase = false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
URLPatternOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
URLPatternOptions::TraceDictionary(JSTracer* trc)
{
}

URLPatternOptions&
URLPatternOptions::operator=(const URLPatternOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mIgnoreCase = aOther.mIgnoreCase;
  return *this;
}


bool
UTF8StringOrUndefined::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char>& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}










bool
UTF8StringOrUndefined::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  if (value.isUndefined()) {
    SetUndefined();
  } else {
    bool done = false, failed = false, tryNext;
    do {
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
    if (failed) {
      return false;
    }
    if (!done) {
      cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "");
      return false;
    }
  }
  return true;
}

bool
UTF8StringOrUndefined::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
UTF8StringOrUndefined::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eUndefined: {
      rval.setUndefined();
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningUTF8StringOrUndefined::OwningUTF8StringOrUndefined(OwningUTF8StringOrUndefined&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eUTF8String: {
      mType = eUTF8String;
      mValue.mUTF8String.SetValue(std::move(aOther.mValue.mUTF8String.Value()));
      break;
    }
    case eUndefined: {
      MOZ_ASSERT(mType == eUninitialized);
      mType = eUndefined;
      break;
    }
  }
}



bool
OwningUTF8StringOrUndefined::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsCString& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsCString&
OwningUTF8StringOrUndefined::RawSetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}

[[nodiscard]] nsCString&
OwningUTF8StringOrUndefined::SetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  Uninit();
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}



void
OwningUTF8StringOrUndefined::DestroyUTF8String()
{
  MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
  mValue.mUTF8String.Destroy();
  mType = eUninitialized;
}





bool
OwningUTF8StringOrUndefined::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  if (value.isUndefined()) {
    SetUndefined();
  } else {
    bool done = false, failed = false, tryNext;
    do {
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
    if (failed) {
      return false;
    }
    if (!done) {
      cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "");
      return false;
    }
  }
  return true;
}

bool
OwningUTF8StringOrUndefined::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningUTF8StringOrUndefined::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eUTF8String: {
      DestroyUTF8String();
      break;
    }
    case eUndefined: {
      break;
    }
  }
}

bool
OwningUTF8StringOrUndefined::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eUndefined: {
      rval.setUndefined();
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningUTF8StringOrUndefined&
OwningUTF8StringOrUndefined::operator=(OwningUTF8StringOrUndefined&& aOther)
{
  this->~OwningUTF8StringOrUndefined();
  new (this) OwningUTF8StringOrUndefined (std::move(aOther));
  return *this;
}


OwningUTF8StringOrUndefined&
OwningUTF8StringOrUndefined::operator=(const OwningUTF8StringOrUndefined& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eUTF8String: {
      SetAsUTF8String() = aOther.GetAsUTF8String();
      break;
    }
    case eUndefined: {
      MOZ_ASSERT(mType == eUninitialized);
      mType = eUndefined;
      break;
    }
  }
  return *this;
}



URLPatternComponentResult::URLPatternComponentResult()
{
  // Safe to pass a null context if we pass a null value
  Init();
}



bool
URLPatternComponentResult::InitIds(JSContext* cx, URLPatternComponentResultAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->input_id.init(cx, "input") ||
      !atomsCache->groups_id.init(cx, "groups")) {
    return false;
  }
  return true;
}

bool
URLPatternComponentResult::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
URLPatternComponentResult::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  URLPatternComponentResultAtoms* atomsCache = GetAtomCache<URLPatternComponentResultAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mGroups.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Record<nsCString, OwningUTF8StringOrUndefined> const & currentValue = mGroups.InternalValue();

      JS::Rooted<JSObject*> returnObj(cx, JS_NewPlainObject(cx));
      if (!returnObj) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (auto& entry : currentValue.Entries()) {
          auto& recordValue0 = entry.mValue;
          // Control block to let us common up the JS_DefineUCProperty calls when there
          // are different ways to succeed at wrapping the value.
          do {
            if (!recordValue0.ToJSVal(cx, returnObj, &tmp)) {
              return false;
            }
            break;
          } while (false);
          NS_ConvertUTF8toUTF16 expandedKey(entry.mKey);
          if (!JS_DefineUCProperty(cx, returnObj,
                                   expandedKey.BeginReading(),
                                   expandedKey.Length(), tmp,
                                   JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnObj);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->groups_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mInput.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsCString const & currentValue = mInput.InternalValue();
      if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->input_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
URLPatternComponentResult::TraceDictionary(JSTracer* trc)
{
}


bool
UTF8StringOrURLPatternInit::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char>& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
UTF8StringOrURLPatternInit::TrySetToURLPatternInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastURLPatternInit& memberSlot = RawSetAsURLPatternInit();
    if (!IsConvertibleToDictionary(value)) {
      DestroyURLPatternInit();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "URLPatternInit branch of (USVString or URLPatternInit)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
UTF8StringOrURLPatternInit::TrySetToURLPatternInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToURLPatternInit(cx, value, tryNext, passedToJSImpl);
}







bool
UTF8StringOrURLPatternInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToURLPatternInit(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "URLPatternInit");
    return false;
  }
  return true;
}

bool
UTF8StringOrURLPatternInit::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
UTF8StringOrURLPatternInit::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eURLPatternInit: {
      if (!mValue.mURLPatternInit.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningUTF8StringOrURLPatternInit::OwningUTF8StringOrURLPatternInit(OwningUTF8StringOrURLPatternInit&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eUTF8String: {
      mType = eUTF8String;
      mValue.mUTF8String.SetValue(std::move(aOther.mValue.mUTF8String.Value()));
      break;
    }
    case eURLPatternInit: {
      mType = eURLPatternInit;
      mValue.mURLPatternInit.SetValue(std::move(aOther.mValue.mURLPatternInit.Value()));
      break;
    }
  }
}



bool
OwningUTF8StringOrURLPatternInit::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsCString& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsCString&
OwningUTF8StringOrURLPatternInit::RawSetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}

[[nodiscard]] nsCString&
OwningUTF8StringOrURLPatternInit::SetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  Uninit();
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}



void
OwningUTF8StringOrURLPatternInit::DestroyUTF8String()
{
  MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
  mValue.mUTF8String.Destroy();
  mType = eUninitialized;
}



bool
OwningUTF8StringOrURLPatternInit::TrySetToURLPatternInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    URLPatternInit& memberSlot = RawSetAsURLPatternInit();
    if (!IsConvertibleToDictionary(value)) {
      DestroyURLPatternInit();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "URLPatternInit branch of (USVString or URLPatternInit)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningUTF8StringOrURLPatternInit::TrySetToURLPatternInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToURLPatternInit(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] URLPatternInit&
OwningUTF8StringOrURLPatternInit::RawSetAsURLPatternInit()
{
  if (mType == eURLPatternInit) {
    return mValue.mURLPatternInit.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eURLPatternInit;
  return mValue.mURLPatternInit.SetValue();
}

[[nodiscard]] URLPatternInit&
OwningUTF8StringOrURLPatternInit::SetAsURLPatternInit()
{
  if (mType == eURLPatternInit) {
    return mValue.mURLPatternInit.Value();
  }
  Uninit();
  mType = eURLPatternInit;
  return mValue.mURLPatternInit.SetValue();
}


void
OwningUTF8StringOrURLPatternInit::DestroyURLPatternInit()
{
  MOZ_RELEASE_ASSERT(IsURLPatternInit(), "Wrong type!");
  mValue.mURLPatternInit.Destroy();
  mType = eUninitialized;
}



bool
OwningUTF8StringOrURLPatternInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToURLPatternInit(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "URLPatternInit");
    return false;
  }
  return true;
}

bool
OwningUTF8StringOrURLPatternInit::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningUTF8StringOrURLPatternInit::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eUTF8String: {
      DestroyUTF8String();
      break;
    }
    case eURLPatternInit: {
      DestroyURLPatternInit();
      break;
    }
  }
}

bool
OwningUTF8StringOrURLPatternInit::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eURLPatternInit: {
      if (!mValue.mURLPatternInit.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningUTF8StringOrURLPatternInit&
OwningUTF8StringOrURLPatternInit::operator=(OwningUTF8StringOrURLPatternInit&& aOther)
{
  this->~OwningUTF8StringOrURLPatternInit();
  new (this) OwningUTF8StringOrURLPatternInit (std::move(aOther));
  return *this;
}


OwningUTF8StringOrURLPatternInit&
OwningUTF8StringOrURLPatternInit::operator=(const OwningUTF8StringOrURLPatternInit& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eUTF8String: {
      SetAsUTF8String() = aOther.GetAsUTF8String();
      break;
    }
    case eURLPatternInit: {
      SetAsURLPatternInit() = aOther.GetAsURLPatternInit();
      break;
    }
  }
  return *this;
}



URLPatternResult::URLPatternResult()
{
  // Safe to pass a null context if we pass a null value
  Init();
}



bool
URLPatternResult::InitIds(JSContext* cx, URLPatternResultAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->username_id.init(cx, "username") ||
      !atomsCache->search_id.init(cx, "search") ||
      !atomsCache->protocol_id.init(cx, "protocol") ||
      !atomsCache->port_id.init(cx, "port") ||
      !atomsCache->pathname_id.init(cx, "pathname") ||
      !atomsCache->password_id.init(cx, "password") ||
      !atomsCache->inputs_id.init(cx, "inputs") ||
      !atomsCache->hostname_id.init(cx, "hostname") ||
      !atomsCache->hash_id.init(cx, "hash")) {
    return false;
  }
  return true;
}

bool
URLPatternResult::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
URLPatternResult::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  URLPatternResultAtoms* atomsCache = GetAtomCache<URLPatternResultAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mHash.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      URLPatternComponentResult const & currentValue = mHash.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->hash_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHostname.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      URLPatternComponentResult const & currentValue = mHostname.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->hostname_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mInputs.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<OwningUTF8StringOrURLPatternInit> const & currentValue = mInputs.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->inputs_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPassword.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      URLPatternComponentResult const & currentValue = mPassword.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->password_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPathname.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      URLPatternComponentResult const & currentValue = mPathname.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->pathname_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPort.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      URLPatternComponentResult const & currentValue = mPort.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->port_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mProtocol.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      URLPatternComponentResult const & currentValue = mProtocol.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->protocol_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mSearch.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      URLPatternComponentResult const & currentValue = mSearch.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->search_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mUsername.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      URLPatternComponentResult const & currentValue = mUsername.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->username_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
URLPatternResult::TraceDictionary(JSTracer* trc)
{
}


namespace URLPattern_Binding {

MOZ_CAN_RUN_SCRIPT static bool
test(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "URLPattern.test");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "test", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  UTF8StringOrURLPatternInit arg0;
  if (!(args.hasDefined(0))) {
    if (!arg0.RawSetAsURLPatternInit().Init(cx, JS::NullHandleValue, "Member of (USVString or URLPatternInit)")) {
      return false;
    }
  } else {
    if (!arg0.Init(cx, args[0], "Argument 1", false)) {
      return false;
    }
  }
  Optional<nsACString> arg1;
  binding_detail::FakeString<char> arg1_holder;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1_holder)) {
      return false;
    }
    arg1 = &arg1_holder;
  }
  FastErrorResult rv;
  bool result(MOZ_KnownLive(self)->Test(Constify(arg0), Constify(arg1), rv));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLPattern.test"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo test_methodinfo = {
  { (JSJitGetterOp)test },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
exec(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "URLPattern.exec");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "exec", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  UTF8StringOrURLPatternInit arg0;
  if (!(args.hasDefined(0))) {
    if (!arg0.RawSetAsURLPatternInit().Init(cx, JS::NullHandleValue, "Member of (USVString or URLPatternInit)")) {
      return false;
    }
  } else {
    if (!arg0.Init(cx, args[0], "Argument 1", false)) {
      return false;
    }
  }
  Optional<nsACString> arg1;
  binding_detail::FakeString<char> arg1_holder;
  if (args.hasDefined(1)) {
    if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1_holder)) {
      return false;
    }
    arg1 = &arg1_holder;
  }
  FastErrorResult rv;
  Nullable<URLPatternResult> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Exec(Constify(arg0), Constify(arg1), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Exec(Constify(arg0), Constify(arg1), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLPattern.exec"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo exec_methodinfo = {
  { (JSJitGetterOp)exec },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_protocol(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "protocol", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetProtocol(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetProtocol(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo protocol_getterinfo = {
  { get_protocol },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_username(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "username", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetUsername(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetUsername(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo username_getterinfo = {
  { get_username },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_password(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "password", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetPassword(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetPassword(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo password_getterinfo = {
  { get_password },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_hostname(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "hostname", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetHostname(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetHostname(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo hostname_getterinfo = {
  { get_hostname },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_port(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "port", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetPort(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetPort(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo port_getterinfo = {
  { get_port },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pathname(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "pathname", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetPathname(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetPathname(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo pathname_getterinfo = {
  { get_pathname },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_search(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "search", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSearch(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSearch(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo search_getterinfo = {
  { get_search },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_hash(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "hash", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetHash(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetHash(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo hash_getterinfo = {
  { get_hash },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_hasRegExpGroups(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "hasRegExpGroups", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::URLPattern*>(void_self);
  bool result(MOZ_KnownLive(self)->HasRegExpGroups());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo hasRegExpGroups_getterinfo = {
  { get_hasRegExpGroups },
  { prototypes::id::URLPattern },
  { PrototypeTraits<prototypes::id::URLPattern>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::URLPattern* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::URLPattern>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::URLPattern>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("test", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&test_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("exec", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&exec_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("protocol", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &protocol_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("username", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &username_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("password", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &password_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("hostname", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &hostname_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("port", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &port_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("pathname", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &pathname_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("search", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &search_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("hash", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &hash_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("hasRegExpGroups", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &hasRegExpGroups_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(9 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[11];
static PropertyInfo sNativeProperties_propertyInfos[11];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  11,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[2] }
  }
};
static_assert(11 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::URLPattern,
  constructors::id::URLPattern,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "URLPattern constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "URLPattern", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "URLPattern");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::URLPattern,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      GlobalObject global(cx, obj);
      if (global.Failed()) {
        return false;
      }

      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      UTF8StringOrURLPatternInit arg0;
      if (!(args.hasDefined(0))) {
        if (!arg0.RawSetAsURLPatternInit().Init(cx, JS::NullHandleValue, "Member of (USVString or URLPatternInit)")) {
          return false;
        }
      } else {
        if (!arg0.Init(cx, args[0], "Argument 1", false)) {
          return false;
        }
      }
      binding_detail::FastURLPatternOptions arg1;
      if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
        return false;
      }
      Maybe<JSAutoRealm> ar;
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        obj = js::CheckedUnwrapStatic(obj);
        if (!obj) {
          return false;
        }
        ar.emplace(cx, obj);
        if (!JS_WrapObject(cx, &desiredProto)) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::dom::URLPattern>(mozilla::dom::URLPattern::Constructor(global, Constify(arg0), Constify(arg1), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLPattern constructor"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      static_assert(!std::is_pointer_v<decltype(result)>,
                    "NewObject implies that we need to keep the object alive with a strong reference.");
      if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    case 2: {
      UTF8StringOrURLPatternInit arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", false)) {
        return false;
      }
      if (args[1].isNullOrUndefined()) {
        binding_detail::FastURLPatternOptions arg1;
        if (!arg1.Init(cx, args[1], "Argument 2", false)) {
          return false;
        }
        GlobalObject global(cx, obj);
        if (global.Failed()) {
          return false;
        }

        bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
        Maybe<JSAutoRealm> ar;
        if (objIsXray) {
          // Since our object is an Xray, we can just CheckedUnwrapStatic:
          // we know Xrays have no dynamic unwrap behavior.
          obj = js::CheckedUnwrapStatic(obj);
          if (!obj) {
            return false;
          }
          ar.emplace(cx, obj);
          if (!JS_WrapObject(cx, &desiredProto)) {
            return false;
          }
        }
        FastErrorResult rv;
        auto result(StrongOrRawPtr<mozilla::dom::URLPattern>(mozilla::dom::URLPattern::Constructor(global, Constify(arg0), Constify(arg1), rv)));
        if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLPattern constructor"))) {
          return false;
        }
        MOZ_ASSERT(!JS_IsExceptionPending(cx));
        static_assert(!std::is_pointer_v<decltype(result)>,
                      "NewObject implies that we need to keep the object alive with a strong reference.");
        if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        return true;
      }
      if (args[1].isObject()) {
        do {
          binding_detail::FastURLPatternOptions arg1;
          if (!arg1.Init(cx, args[1], "Argument 2", false)) {
            return false;
          }
          GlobalObject global(cx, obj);
          if (global.Failed()) {
            return false;
          }

          bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
          Maybe<JSAutoRealm> ar;
          if (objIsXray) {
            // Since our object is an Xray, we can just CheckedUnwrapStatic:
            // we know Xrays have no dynamic unwrap behavior.
            obj = js::CheckedUnwrapStatic(obj);
            if (!obj) {
              return false;
            }
            ar.emplace(cx, obj);
            if (!JS_WrapObject(cx, &desiredProto)) {
              return false;
            }
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::URLPattern>(mozilla::dom::URLPattern::Constructor(global, Constify(arg0), Constify(arg1), rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLPattern constructor"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          static_assert(!std::is_pointer_v<decltype(result)>,
                        "NewObject implies that we need to keep the object alive with a strong reference.");
          if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
      }
      GlobalObject global(cx, obj);
      if (global.Failed()) {
        return false;
      }

      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      binding_detail::FakeString<char> arg1;
      if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
        return false;
      }
      binding_detail::FastURLPatternOptions arg2;
      if (!arg2.Init(cx, (args.hasDefined(2)) ? args[2] : JS::NullHandleValue, "Argument 3", false)) {
        return false;
      }
      Maybe<JSAutoRealm> ar;
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        obj = js::CheckedUnwrapStatic(obj);
        if (!obj) {
          return false;
        }
        ar.emplace(cx, obj);
        if (!JS_WrapObject(cx, &desiredProto)) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::dom::URLPattern>(mozilla::dom::URLPattern::Constructor(global, Constify(arg0), Constify(arg1), Constify(arg2), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLPattern constructor"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      static_assert(!std::is_pointer_v<decltype(result)>,
                    "NewObject implies that we need to keep the object alive with a strong reference.");
      if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    case 3: {
      GlobalObject global(cx, obj);
      if (global.Failed()) {
        return false;
      }

      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      UTF8StringOrURLPatternInit arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", false)) {
        return false;
      }
      binding_detail::FakeString<char> arg1;
      if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
        return false;
      }
      binding_detail::FastURLPatternOptions arg2;
      if (!arg2.Init(cx, (args.hasDefined(2)) ? args[2] : JS::NullHandleValue, "Argument 3", false)) {
        return false;
      }
      Maybe<JSAutoRealm> ar;
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        obj = js::CheckedUnwrapStatic(obj);
        if (!obj) {
          return false;
        }
        ar.emplace(cx, obj);
        if (!JS_WrapObject(cx, &desiredProto)) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::dom::URLPattern>(mozilla::dom::URLPattern::Constructor(global, Constify(arg0), Constify(arg1), Constify(arg2), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "URLPattern constructor"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      static_assert(!std::is_pointer_v<decltype(result)>,
                    "NewObject implies that we need to keep the object alive with a strong reference.");
      if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::URLPattern>::Depth,
  prototypes::id::URLPattern,
  true,
  0,
  "URLPattern",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "URLPatternPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::URLPattern,
  PrototypeTraits<prototypes::id::URLPattern>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::dom_urlpattern_enabled();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "URLPattern",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::URLPattern>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::URLPattern, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::URLPattern>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::URLPattern>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::URLPattern>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::URLPattern>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::URLPattern* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::URLPattern>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::URLPattern*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::URLPattern> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::URLPattern);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::URLPattern);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "URLPattern",
                              ShouldExpose<URLPattern_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::URLPattern,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::URLPattern,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace URLPattern_Binding



} // namespace mozilla::dom
