/* gitg-remote.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-remote.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgit2-glib/ggit.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_REMOTE_TYPE_CALLBACKS (gitg_remote_callbacks_get_type ())
#define GITG_REMOTE_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacks))
#define GITG_REMOTE_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacksClass))
#define GITG_REMOTE_IS_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REMOTE_TYPE_CALLBACKS))
#define GITG_REMOTE_IS_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REMOTE_TYPE_CALLBACKS))
#define GITG_REMOTE_CALLBACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacksClass))

typedef struct _GitgRemoteCallbacks GitgRemoteCallbacks;
typedef struct _GitgRemoteCallbacksClass GitgRemoteCallbacksClass;
enum  {
	GITG_REMOTE_0_PROPERTY,
	GITG_REMOTE_TRANSFER_PROGRESS_PROPERTY,
	GITG_REMOTE_STATE_PROPERTY,
	GITG_REMOTE_FETCH_SPECS_PROPERTY,
	GITG_REMOTE_PUSH_SPECS_PROPERTY,
	GITG_REMOTE_CREDENTIALS_PROVIDER_PROPERTY,
	GITG_REMOTE_NUM_PROPERTIES
};
static GParamSpec* gitg_remote_properties[GITG_REMOTE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block22Data Block22Data;
typedef void (*GitgRemoteCallbacksTransferProgress) (GgitTransferProgress* stats, gpointer user_data);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgRemoteConnectData GitgRemoteConnectData;
typedef struct _GitgRemoteDisconnectData GitgRemoteDisconnectData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block23Data Block23Data;
typedef struct _GitgRemotePushInternData GitgRemotePushInternData;
typedef struct _Block24Data Block24Data;
#define __vala_GgitFetchOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitFetchOptions_free (var), NULL)))
typedef struct _GitgRemoteDownloadInternData GitgRemoteDownloadInternData;
typedef struct _GitgRemoteDownloadData GitgRemoteDownloadData;
typedef struct _GitgRemotePushData GitgRemotePushData;
typedef struct _GitgRemoteFetchData GitgRemoteFetchData;
typedef struct _GitgRemoteCallbacksPrivate GitgRemoteCallbacksPrivate;
enum  {
	GITG_REMOTE_CALLBACKS_0_PROPERTY,
	GITG_REMOTE_CALLBACKS_NUM_PROPERTIES
};
static GParamSpec* gitg_remote_callbacks_properties[GITG_REMOTE_CALLBACKS_NUM_PROPERTIES];
enum  {
	GITG_REMOTE_TIP_UPDATED_SIGNAL,
	GITG_REMOTE_NUM_SIGNALS
};
static guint gitg_remote_signals[GITG_REMOTE_NUM_SIGNALS] = {0};

struct _GitgRemotePrivate {
	GitgRemoteState d_state;
	gchar** d_fetch_specs;
	gint d_fetch_specs_length1;
	gint _d_fetch_specs_size_;
	gchar** d_push_specs;
	gint d_push_specs_length1;
	gint _d_push_specs_size_;
	guint d_reset_transfer_progress_timeout;
	gdouble d_transfer_progress;
	GitgRemoteCallbacks* d_callbacks;
	GitgCredentialsProvider* _credentials_provider;
};

struct _Block22Data {
	int _ref_count_;
	GitgRemote* self;
	GgitDirection direction;
	gpointer _async_data_;
};

struct _GitgRemoteConnectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRemote* self;
	GgitDirection direction;
	GgitRemoteCallbacks* callbacks;
	Block22Data* _data22_;
	GitgRemoteState _tmp0_;
	GitgRemoteState _tmp1_;
	GError* _tmp2_;
	GitgRemoteState _tmp3_;
	GitgRemoteState _tmp4_;
	GError* _tmp5_;
	GitgRemoteCallbacks* _tmp6_;
	GError* e;
	gboolean _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _inner_error0_;
};

struct _GitgRemoteDisconnectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRemote* self;
	GitgRemoteState _tmp0_;
	GitgRemoteState _tmp1_;
	GError* _tmp2_;
	GError* e;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_;
};

struct _Block23Data {
	int _ref_count_;
	GitgRemote* self;
	gchar* branch;
	GgitRemoteCallbacks* callbacks;
	gpointer _async_data_;
};

struct _GitgRemotePushInternData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRemote* self;
	gchar* branch;
	GgitRemoteCallbacks* callbacks;
	Block23Data* _data23_;
	GError* e;
	GError* _tmp0_;
	GError* _tmp1_;
	GError* _inner_error0_;
};

struct _Block24Data {
	int _ref_count_;
	GitgRemote* self;
	gchar* message;
	gpointer _async_data_;
};

struct _GitgRemoteDownloadInternData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRemote* self;
	gchar* message;
	GgitRemoteCallbacks* callbacks;
	Block24Data* _data24_;
	gboolean dis;
	GError* e;
	GError* _tmp0_;
	GError* _tmp1_;
	GError* _inner_error0_;
};

struct _GitgRemoteDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRemote* self;
	GgitRemoteCallbacks* callbacks;
	GError* _inner_error0_;
};

struct _GitgRemotePushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRemote* self;
	gchar* branch;
	GgitRemoteCallbacks* callbacks;
	GError* _inner_error0_;
};

struct _GitgRemoteFetchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgRemote* self;
	gchar* message;
	GgitRemoteCallbacks* callbacks;
	gchar* msg;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* name;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _GitgRemoteCallbacks {
	GgitRemoteCallbacks parent_instance;
	GitgRemoteCallbacksPrivate * priv;
};

struct _GitgRemoteCallbacksClass {
	GgitRemoteCallbacksClass parent_class;
};

struct _GitgRemoteCallbacksPrivate {
	GitgRemote* d_remote;
	GgitRemoteCallbacks* d_proxy;
	GitgRemoteCallbacksTransferProgress d_transfer_progress;
	gpointer d_transfer_progress_target;
	GDestroyNotify d_transfer_progress_target_destroy_notify;
};

static gint GitgRemote_private_offset;
static gpointer gitg_remote_parent_class = NULL;
static gint GitgRemoteCallbacks_private_offset;
static gpointer gitg_remote_callbacks_parent_class = NULL;

static GType gitg_credentials_provider_get_type_once (void);
static GType gitg_remote_callbacks_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void gitg_remote_real_dispose (GObject* base);
static void gitg_remote_do_reset_transfer_progress (GitgRemote* self);
static void gitg_remote_reset_transfer_progress (GitgRemote* self,
                                          gboolean with_delay);
static gboolean ___lambda80_ (GitgRemote* self);
static gboolean ____lambda80__gsource_func (gpointer self);
static void gitg_remote_update_transfer_progress (GitgRemote* self,
                                           GgitTransferProgress* stats);
static void gitg_remote_update_state (GitgRemote* self,
                               gboolean force_disconnect);
static void ____lambda82_ (GitgRemote* self,
                    GObject* obj,
                    GAsyncResult* res);
static void _____lambda82__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void gitg_remote_set_state (GitgRemote* self,
                            GitgRemoteState value);
static void gitg_remote_connect_data_free (gpointer _data);
static gboolean gitg_remote_connect_co (GitgRemoteConnectData* _data_);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void _gitg_remote_update_transfer_progress_gitg_remote_callbacks_transfer_progress (GgitTransferProgress* stats,
                                                                                    gpointer self);
static GitgRemoteCallbacks* gitg_remote_callbacks_new (GitgRemote* remote,
                                                GgitRemoteCallbacks* proxy,
                                                GitgRemoteCallbacksTransferProgress transfer_progress,
                                                gpointer transfer_progress_target,
                                                GDestroyNotify transfer_progress_target_destroy_notify);
static GitgRemoteCallbacks* gitg_remote_callbacks_construct (GType object_type,
                                                      GitgRemote* remote,
                                                      GgitRemoteCallbacks* proxy,
                                                      GitgRemoteCallbacksTransferProgress transfer_progress,
                                                      gpointer transfer_progress_target,
                                                      GDestroyNotify transfer_progress_target_destroy_notify);
static void ____lambda83_ (Block22Data* _data22_,
                    GError** error);
static void _____lambda83__gitg_async_thread_func (gpointer self,
                                            GError** error);
static void gitg_remote_connect_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_);
static void gitg_remote_disconnect_data_free (gpointer _data);
static gboolean gitg_remote_disconnect_co (GitgRemoteDisconnectData* _data_);
static void ___lambda81_ (GitgRemote* self,
                   GError** error);
static void ____lambda81__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_remote_disconnect_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void gitg_remote_push_intern_data_free (gpointer _data);
static void gitg_remote_push_intern (GitgRemote* self,
                              const gchar* branch,
                              GgitRemoteCallbacks* callbacks,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
static void gitg_remote_push_intern_finish (GitgRemote* self,
                                     GAsyncResult* _res_,
                                     GError** error);
static gboolean gitg_remote_push_intern_co (GitgRemotePushInternData* _data_);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void ___lambda84_ (Block23Data* _data23_,
                   GError** error);
static void ____lambda84__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_remote_push_intern_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void gitg_remote_download_intern_data_free (gpointer _data);
static void gitg_remote_download_intern (GitgRemote* self,
                                  const gchar* message,
                                  GgitRemoteCallbacks* callbacks,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void gitg_remote_download_intern_finish (GitgRemote* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static gboolean gitg_remote_download_intern_co (GitgRemoteDownloadInternData* _data_);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void gitg_remote_download_intern_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void ___lambda85_ (Block24Data* _data24_,
                   GError** error);
static void _vala_GgitFetchOptions_free (GgitFetchOptions* self);
static void ____lambda85__gitg_async_thread_func (gpointer self,
                                           GError** error);
static void gitg_remote_download_data_free (gpointer _data);
static gboolean gitg_remote_download_co (GitgRemoteDownloadData* _data_);
static void gitg_remote_download_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
static void gitg_remote_push_data_free (gpointer _data);
static gboolean gitg_remote_push_co (GitgRemotePushData* _data_);
static void gitg_remote_push_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_);
static void gitg_remote_fetch_data_free (gpointer _data);
static gboolean gitg_remote_fetch_co (GitgRemoteFetchData* _data_);
static void gitg_remote_fetch_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_);
static gchar** _vala_array_dup19 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup20 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup21 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup22 (gchar** self,
                           gssize length);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static void gitg_remote_callbacks_real_progress (GgitRemoteCallbacks* base,
                                          const gchar* message);
static void gitg_remote_callbacks_real_transfer_progress (GgitRemoteCallbacks* base,
                                                   GgitTransferProgress* stats);
static void gitg_remote_callbacks_real_update_tips (GgitRemoteCallbacks* base,
                                             const gchar* refname,
                                             GgitOId* a,
                                             GgitOId* b);
static void gitg_remote_callbacks_real_completion (GgitRemoteCallbacks* base,
                                            GgitRemoteCompletionType type);
static GgitCred* gitg_remote_callbacks_real_credentials (GgitRemoteCallbacks* base,
                                                  const gchar* url,
                                                  const gchar* username_from_url,
                                                  GgitCredtype allowed_types,
                                                  GError** error);
static void gitg_remote_callbacks_finalize (GObject * obj);
static GType gitg_remote_callbacks_get_type_once (void);
static void gitg_remote_finalize (GObject * obj);
static GType gitg_remote_get_type_once (void);
static void _vala_gitg_remote_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_gitg_remote_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

 G_GNUC_NO_INLINE static GType
gitg_remote_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_REMOTE_STATE_DISCONNECTED, "GITG_REMOTE_STATE_DISCONNECTED", "disconnected"}, {GITG_REMOTE_STATE_CONNECTING, "GITG_REMOTE_STATE_CONNECTING", "connecting"}, {GITG_REMOTE_STATE_CONNECTED, "GITG_REMOTE_STATE_CONNECTED", "connected"}, {GITG_REMOTE_STATE_TRANSFERRING, "GITG_REMOTE_STATE_TRANSFERRING", "transferring"}, {0, NULL, NULL}};
	GType gitg_remote_state_type_id;
	gitg_remote_state_type_id = g_enum_register_static ("GitgRemoteState", values);
	return gitg_remote_state_type_id;
}

GType
gitg_remote_state_get_type (void)
{
	static gsize gitg_remote_state_type_id__once = 0;
	if (g_once_init_enter (&gitg_remote_state_type_id__once)) {
		GType gitg_remote_state_type_id;
		gitg_remote_state_type_id = gitg_remote_state_get_type_once ();
		g_once_init_leave (&gitg_remote_state_type_id__once, gitg_remote_state_type_id);
	}
	return gitg_remote_state_type_id__once;
}

GQuark
gitg_remote_error_quark (void)
{
	return g_quark_from_static_string ("gitg-remote-error-quark");
}

 G_GNUC_NO_INLINE static GType
gitg_remote_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_REMOTE_ERROR_ALREADY_CONNECTED, "GITG_REMOTE_ERROR_ALREADY_CONNECTED", "already-connected"}, {GITG_REMOTE_ERROR_ALREADY_CONNECTING, "GITG_REMOTE_ERROR_ALREADY_CONNECTING", "already-connecting"}, {GITG_REMOTE_ERROR_ALREADY_DISCONNECTED, "GITG_REMOTE_ERROR_ALREADY_DISCONNECTED", "already-disconnected"}, {GITG_REMOTE_ERROR_STILL_CONNECTING, "GITG_REMOTE_ERROR_STILL_CONNECTING", "still-connecting"}, {0, NULL, NULL}};
	GType gitg_remote_error_type_id;
	gitg_remote_error_type_id = g_enum_register_static ("GitgRemoteError", values);
	return gitg_remote_error_type_id;
}

GType
gitg_remote_error_get_type (void)
{
	static gsize gitg_remote_error_type_id__once = 0;
	if (g_once_init_enter (&gitg_remote_error_type_id__once)) {
		GType gitg_remote_error_type_id;
		gitg_remote_error_type_id = gitg_remote_error_get_type_once ();
		g_once_init_leave (&gitg_remote_error_type_id__once, gitg_remote_error_type_id);
	}
	return gitg_remote_error_type_id__once;
}

GgitCred*
gitg_credentials_provider_credentials (GitgCredentialsProvider* self,
                                       const gchar* url,
                                       const gchar* username_from_url,
                                       GgitCredtype allowed_types,
                                       GError** error)
{
	GitgCredentialsProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GITG_CREDENTIALS_PROVIDER_GET_INTERFACE (self);
	if (_iface_->credentials) {
		return _iface_->credentials (self, url, username_from_url, allowed_types, error);
	}
	return NULL;
}

static void
gitg_credentials_provider_default_init (GitgCredentialsProviderIface * iface,
                                        gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
gitg_credentials_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgCredentialsProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_credentials_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gitg_credentials_provider_type_id;
	gitg_credentials_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgCredentialsProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gitg_credentials_provider_type_id, G_TYPE_OBJECT);
	return gitg_credentials_provider_type_id;
}

GType
gitg_credentials_provider_get_type (void)
{
	static gsize gitg_credentials_provider_type_id__once = 0;
	if (g_once_init_enter (&gitg_credentials_provider_type_id__once)) {
		GType gitg_credentials_provider_type_id;
		gitg_credentials_provider_type_id = gitg_credentials_provider_get_type_once ();
		g_once_init_leave (&gitg_credentials_provider_type_id__once, gitg_credentials_provider_type_id);
	}
	return gitg_credentials_provider_type_id__once;
}

static inline gpointer
gitg_remote_get_instance_private (GitgRemote* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRemote_private_offset);
}

static void
gitg_remote_real_dispose (GObject* base)
{
	GitgRemote * self;
	self = (GitgRemote*) base;
	if (self->priv->d_reset_transfer_progress_timeout != ((guint) 0)) {
		g_source_remove (self->priv->d_reset_transfer_progress_timeout);
		self->priv->d_reset_transfer_progress_timeout = (guint) 0;
	}
	G_OBJECT_CLASS (gitg_remote_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote));
}

static void
gitg_remote_do_reset_transfer_progress (GitgRemote* self)
{
	g_return_if_fail (self != NULL);
	self->priv->d_reset_transfer_progress_timeout = (guint) 0;
	self->priv->d_transfer_progress = 0.0;
	g_object_notify ((GObject*) self, "transfer-progress");
}

static gboolean
___lambda80_ (GitgRemote* self)
{
	gboolean result;
	gitg_remote_do_reset_transfer_progress (self);
	result = FALSE;
	return result;
}

static gboolean
____lambda80__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda80_ ((GitgRemote*) self);
	return result;
}

static void
gitg_remote_reset_transfer_progress (GitgRemote* self,
                                     gboolean with_delay)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_transfer_progress == ((gdouble) 0)) {
		return;
	}
	if (with_delay) {
		self->priv->d_reset_transfer_progress_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda80__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		if (self->priv->d_reset_transfer_progress_timeout == ((guint) 0)) {
			gitg_remote_do_reset_transfer_progress (self);
		}
	}
}

static void
gitg_remote_update_transfer_progress (GitgRemote* self,
                                      GgitTransferProgress* stats)
{
	guint total = 0U;
	guint received = 0U;
	guint indexed = 0U;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stats != NULL);
	total = ggit_transfer_progress_get_total_objects (stats);
	received = ggit_transfer_progress_get_received_objects (stats);
	indexed = ggit_transfer_progress_get_indexed_objects (stats);
	self->priv->d_transfer_progress = ((gdouble) (received + indexed)) / ((gdouble) (total + total));
	g_object_notify ((GObject*) self, "transfer-progress");
	if (received == total) {
		_tmp0_ = indexed == total;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gitg_remote_reset_transfer_progress (self, TRUE);
	}
}

static void
____lambda82_ (GitgRemote* self,
               GObject* obj,
               GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		gitg_remote_disconnect_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda82__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda82_ ((GitgRemote*) self, source_object, res);
	g_object_unref (self);
}

static void
gitg_remote_update_state (GitgRemote* self,
                          gboolean force_disconnect)
{
	g_return_if_fail (self != NULL);
	if (ggit_remote_get_connected ((GgitRemote*) self)) {
		if (force_disconnect) {
			gitg_remote_disconnect (self, _____lambda82__gasync_ready_callback, g_object_ref (self));
		} else {
			gitg_remote_set_state (self, GITG_REMOTE_STATE_CONNECTED);
		}
	} else {
		gitg_remote_set_state (self, GITG_REMOTE_STATE_DISCONNECTED);
	}
}

static void
gitg_remote_connect_data_free (gpointer _data)
{
	GitgRemoteConnectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->callbacks);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRemoteConnectData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gitg_remote_connect (GitgRemote* self,
                     GgitDirection direction,
                     GgitRemoteCallbacks* callbacks,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	GitgRemoteConnectData* _data_;
	GitgRemote* _tmp0_;
	GgitRemoteCallbacks* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgRemoteConnectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_remote_connect_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->direction = direction;
	_tmp1_ = _g_object_ref0 (callbacks);
	_g_object_unref0 (_data_->callbacks);
	_data_->callbacks = _tmp1_;
	gitg_remote_connect_co (_data_);
}

void
gitg_remote_connect_finish (GitgRemote* self,
                            GAsyncResult* _res_,
                            GError** error)
{
	GitgRemoteConnectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		GitgRemote* self;
		self = _data22_->self;
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
_gitg_remote_update_transfer_progress_gitg_remote_callbacks_transfer_progress (GgitTransferProgress* stats,
                                                                               gpointer self)
{
	gitg_remote_update_transfer_progress ((GitgRemote*) self, stats);
}

static void
____lambda83_ (Block22Data* _data22_,
               GError** error)
{
	GitgRemote* self;
	GitgRemoteCallbacks* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data22_->self;
	_tmp0_ = self->priv->d_callbacks;
	ggit_remote_connect (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), _data22_->direction, (GgitRemoteCallbacks*) _tmp0_, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_____lambda83__gitg_async_thread_func (gpointer self,
                                       GError** error)
{
	____lambda83_ (self, error);
}

static void
gitg_remote_connect_ready (GObject* source_object,
                           GAsyncResult* _res_,
                           gpointer _user_data_)
{
	GitgRemoteConnectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_remote_connect_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
gitg_remote_connect_co (GitgRemoteConnectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data22_ = g_slice_new0 (Block22Data);
	_data_->_data22_->_ref_count_ = 1;
	_data_->_data22_->self = g_object_ref (_data_->self);
	_data_->_data22_->direction = _data_->direction;
	_data_->_data22_->_async_data_ = _data_;
	if (ggit_remote_get_connected ((GgitRemote*) _data_->self)) {
		_data_->_tmp0_ = gitg_remote_get_state (_data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		if (_data_->_tmp1_ != GITG_REMOTE_STATE_CONNECTED) {
			gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_CONNECTED);
		}
		_data_->_tmp2_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_CONNECTED, "already connected");
		_data_->_inner_error0_ = _data_->_tmp2_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block22_data_unref (_data_->_data22_);
		_data_->_data22_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp3_ = gitg_remote_get_state (_data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		if (_data_->_tmp4_ == GITG_REMOTE_STATE_CONNECTING) {
			_data_->_tmp5_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_CONNECTING, "already connecting");
			_data_->_inner_error0_ = _data_->_tmp5_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block22_data_unref (_data_->_data22_);
			_data_->_data22_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			gitg_remote_reset_transfer_progress (_data_->self, FALSE);
		}
	}
	gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_CONNECTING);
	while (TRUE) {
		{
			_data_->_tmp6_ = gitg_remote_callbacks_new (_data_->self, _data_->callbacks, _gitg_remote_update_transfer_progress_gitg_remote_callbacks_transfer_progress, g_object_ref (_data_->self), g_object_unref);
			_g_object_unref0 (_data_->self->priv->d_callbacks);
			_data_->self->priv->d_callbacks = _data_->_tmp6_;
			_data_->_state_ = 1;
			gitg_async_thread (_____lambda83__gitg_async_thread_func, _data_->_data22_, gitg_remote_connect_ready, _data_);
			return FALSE;
			_state_1:
			gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_g_object_unref0 (_data_->self->priv->d_callbacks);
			_data_->self->priv->d_callbacks = NULL;
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			if (g_strcmp0 (_data_->_tmp9_, "Unexpected HTTP status code: 401") == 0) {
				_data_->_tmp7_ = TRUE;
			} else {
				_data_->_tmp10_ = _data_->e;
				_data_->_tmp11_ = _data_->_tmp10_->message;
				_data_->_tmp7_ = g_strcmp0 (_data_->_tmp11_, "error authenticating: Username/PublicKey combination invalid") == 0;
			}
			if (_data_->_tmp7_) {
				_g_error_free0 (_data_->e);
				continue;
			} else {
				gitg_remote_update_state (_data_->self, FALSE);
				_data_->_tmp12_ = _data_->e;
				_data_->_tmp13_ = _g_error_copy0 (_data_->_tmp12_);
				_data_->_inner_error0_ = _data_->_tmp13_;
				_g_error_free0 (_data_->e);
				goto __finally0;
			}
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block22_data_unref (_data_->_data22_);
			_data_->_data22_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		break;
	}
	gitg_remote_update_state (_data_->self, FALSE);
	block22_data_unref (_data_->_data22_);
	_data_->_data22_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_remote_disconnect_data_free (gpointer _data)
{
	GitgRemoteDisconnectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRemoteDisconnectData, _data_);
}

void
gitg_remote_disconnect (GitgRemote* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GitgRemoteDisconnectData* _data_;
	GitgRemote* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgRemoteDisconnectData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_remote_disconnect_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gitg_remote_disconnect_co (_data_);
}

void
gitg_remote_disconnect_finish (GitgRemote* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	GitgRemoteDisconnectData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
___lambda81_ (GitgRemote* self,
              GError** error)
{
	ggit_remote_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote));
}

static void
____lambda81__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda81_ ((GitgRemote*) self, error);
}

static void
gitg_remote_disconnect_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GitgRemoteDisconnectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_remote_disconnect_co (_data_);
}

static gboolean
gitg_remote_disconnect_co (GitgRemoteDisconnectData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!ggit_remote_get_connected ((GgitRemote*) _data_->self)) {
		_data_->_tmp0_ = gitg_remote_get_state (_data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		if (_data_->_tmp1_ != GITG_REMOTE_STATE_DISCONNECTED) {
			gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_DISCONNECTED);
		}
		_data_->_tmp2_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_DISCONNECTED, "already disconnected");
		_data_->_inner_error0_ = _data_->_tmp2_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		gitg_async_thread (____lambda81__gitg_async_thread_func, _data_->self, gitg_remote_disconnect_ready, _data_);
		return FALSE;
		_state_1:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		gitg_remote_update_state (_data_->self, FALSE);
		gitg_remote_reset_transfer_progress (_data_->self, TRUE);
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _g_error_copy0 (_data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	gitg_remote_update_state (_data_->self, FALSE);
	gitg_remote_reset_transfer_progress (_data_->self, TRUE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_remote_push_intern_data_free (gpointer _data)
{
	GitgRemotePushInternData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRemotePushInternData, _data_);
}

static void
gitg_remote_push_intern (GitgRemote* self,
                         const gchar* branch,
                         GgitRemoteCallbacks* callbacks,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	GitgRemotePushInternData* _data_;
	GitgRemote* _tmp0_;
	gchar* _tmp1_;
	GgitRemoteCallbacks* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (branch != NULL);
	_data_ = g_slice_new0 (GitgRemotePushInternData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_remote_push_intern_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (branch);
	_g_free0 (_data_->branch);
	_data_->branch = _tmp1_;
	_tmp2_ = _g_object_ref0 (callbacks);
	_g_object_unref0 (_data_->callbacks);
	_data_->callbacks = _tmp2_;
	gitg_remote_push_intern_co (_data_);
}

static void
gitg_remote_push_intern_finish (GitgRemote* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	GitgRemotePushInternData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		GitgRemote* self;
		self = _data23_->self;
		_g_free0 (_data23_->branch);
		_g_object_unref0 (_data23_->callbacks);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
___lambda84_ (Block23Data* _data23_,
              GError** error)
{
	GitgRemote* self;
	GgitPushOptions* options = NULL;
	GgitPushOptions* _tmp0_;
	GitgRemoteCallbacks* _tmp1_;
	GgitPushOptions* _tmp3_;
	GitgRemoteCallbacks* _tmp4_;
	gchar** push_refs = NULL;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint push_refs_length1;
	gint _push_refs_size_;
	gboolean _tmp7_ = FALSE;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GgitPushOptions* _tmp9_;
	GError* _inner_error0_ = NULL;
	self = _data23_->self;
	_tmp0_ = ggit_push_options_new ();
	options = _tmp0_;
	_tmp1_ = self->priv->d_callbacks;
	if (_tmp1_ == NULL) {
		GitgRemoteCallbacks* _tmp2_;
		_tmp2_ = gitg_remote_callbacks_new (self, _data23_->callbacks, _gitg_remote_update_transfer_progress_gitg_remote_callbacks_transfer_progress, g_object_ref (self), g_object_unref);
		_g_object_unref0 (self->priv->d_callbacks);
		self->priv->d_callbacks = _tmp2_;
	}
	_tmp3_ = options;
	_tmp4_ = self->priv->d_callbacks;
	ggit_push_options_set_remote_callbacks (_tmp3_, (GgitRemoteCallbacks*) _tmp4_);
	_tmp5_ = g_strdup_printf ("refs/heads/%s:refs/heads/%s", _data23_->branch, _data23_->branch);
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	push_refs = _tmp6_;
	push_refs_length1 = 1;
	_push_refs_size_ = push_refs_length1;
	_tmp8_ = push_refs;
	_tmp8__length1 = push_refs_length1;
	_tmp9_ = options;
	_tmp7_ = ggit_remote_push (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), _tmp8_, _tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		push_refs = (_vala_array_free (push_refs, push_refs_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (options);
		return;
	}
	if (!_tmp7_) {
		GError* _tmp10_;
		_tmp10_ = g_error_new ((GQuark) 0, 0, "push");
		_inner_error0_ = _tmp10_;
		g_propagate_error (error, _inner_error0_);
		push_refs = (_vala_array_free (push_refs, push_refs_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (options);
		return;
	}
	push_refs = (_vala_array_free (push_refs, push_refs_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (options);
}

static void
____lambda84__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda84_ (self, error);
}

static void
gitg_remote_push_intern_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	GitgRemotePushInternData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_remote_push_intern_co (_data_);
}

static gboolean
gitg_remote_push_intern_co (GitgRemotePushInternData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data23_ = g_slice_new0 (Block23Data);
	_data_->_data23_->_ref_count_ = 1;
	_data_->_data23_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data23_->branch);
	_data_->_data23_->branch = _data_->branch;
	_g_object_unref0 (_data_->_data23_->callbacks);
	_data_->_data23_->callbacks = _data_->callbacks;
	_data_->_data23_->_async_data_ = _data_;
	gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_TRANSFERRING);
	gitg_remote_reset_transfer_progress (_data_->self, FALSE);
	{
		_data_->_state_ = 1;
		gitg_async_thread (____lambda84__gitg_async_thread_func, _data_->_data23_, gitg_remote_push_intern_ready, _data_);
		return FALSE;
		_state_1:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		gitg_remote_reset_transfer_progress (_data_->self, TRUE);
		_data_->_tmp0_ = _data_->e;
		_data_->_tmp1_ = _g_error_copy0 (_data_->_tmp0_);
		_data_->_inner_error0_ = _data_->_tmp1_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block23_data_unref (_data_->_data23_);
		_data_->_data23_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	gitg_remote_reset_transfer_progress (_data_->self, TRUE);
	block23_data_unref (_data_->_data23_);
	_data_->_data23_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_remote_download_intern_data_free (gpointer _data)
{
	GitgRemoteDownloadInternData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->callbacks);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRemoteDownloadInternData, _data_);
}

static void
gitg_remote_download_intern (GitgRemote* self,
                             const gchar* message,
                             GgitRemoteCallbacks* callbacks,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GitgRemoteDownloadInternData* _data_;
	GitgRemote* _tmp0_;
	gchar* _tmp1_;
	GgitRemoteCallbacks* _tmp2_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgRemoteDownloadInternData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_remote_download_intern_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp1_;
	_tmp2_ = _g_object_ref0 (callbacks);
	_g_object_unref0 (_data_->callbacks);
	_data_->callbacks = _tmp2_;
	gitg_remote_download_intern_co (_data_);
}

static void
gitg_remote_download_intern_finish (GitgRemote* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	GitgRemoteDownloadInternData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		GitgRemote* self;
		self = _data24_->self;
		_g_free0 (_data24_->message);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
gitg_remote_download_intern_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	GitgRemoteDownloadInternData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_remote_download_intern_co (_data_);
}

static void
_vala_GgitFetchOptions_free (GgitFetchOptions* self)
{
	g_boxed_free (ggit_fetch_options_get_type (), self);
}

static void
___lambda85_ (Block24Data* _data24_,
              GError** error)
{
	GitgRemote* self;
	GgitFetchOptions* options = NULL;
	GgitFetchOptions* _tmp0_;
	GgitFetchOptions* _tmp1_;
	GitgRemoteCallbacks* _tmp2_;
	GgitFetchOptions* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = _data24_->self;
	_tmp0_ = ggit_fetch_options_new ();
	options = _tmp0_;
	_tmp1_ = options;
	_tmp2_ = self->priv->d_callbacks;
	ggit_fetch_options_set_remote_callbacks (_tmp1_, (GgitRemoteCallbacks*) _tmp2_);
	_tmp3_ = options;
	ggit_remote_download (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), NULL, _tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_GgitFetchOptions_free0 (options);
		return;
	}
	if (_data24_->message != NULL) {
		GitgRemoteCallbacks* _tmp4_;
		GgitFetchOptions* _tmp5_;
		_tmp4_ = self->priv->d_callbacks;
		_tmp5_ = options;
		ggit_remote_update_tips (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), (GgitRemoteCallbacks*) _tmp4_, TRUE, ggit_fetch_options_get_download_tags (_tmp5_), _data24_->message, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			__vala_GgitFetchOptions_free0 (options);
			return;
		}
	}
	__vala_GgitFetchOptions_free0 (options);
}

static void
____lambda85__gitg_async_thread_func (gpointer self,
                                      GError** error)
{
	___lambda85_ (self, error);
}

static gboolean
gitg_remote_download_intern_co (GitgRemoteDownloadInternData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data24_ = g_slice_new0 (Block24Data);
	_data_->_data24_->_ref_count_ = 1;
	_data_->_data24_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data24_->message);
	_data_->_data24_->message = _data_->message;
	_data_->_data24_->_async_data_ = _data_;
	_data_->dis = FALSE;
	if (!ggit_remote_get_connected ((GgitRemote*) _data_->self)) {
		_data_->dis = TRUE;
		_data_->_state_ = 1;
		gitg_remote_connect (_data_->self, GGIT_DIRECTION_FETCH, _data_->callbacks, gitg_remote_download_intern_ready, _data_);
		return FALSE;
		_state_1:
		gitg_remote_connect_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block24_data_unref (_data_->_data24_);
			_data_->_data24_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_TRANSFERRING);
	gitg_remote_reset_transfer_progress (_data_->self, FALSE);
	{
		_data_->_state_ = 2;
		gitg_async_thread (____lambda85__gitg_async_thread_func, _data_->_data24_, gitg_remote_download_intern_ready, _data_);
		return FALSE;
		_state_2:
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		gitg_remote_update_state (_data_->self, _data_->dis);
		gitg_remote_reset_transfer_progress (_data_->self, TRUE);
		_data_->_tmp0_ = _data_->e;
		_data_->_tmp1_ = _g_error_copy0 (_data_->_tmp0_);
		_data_->_inner_error0_ = _data_->_tmp1_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block24_data_unref (_data_->_data24_);
		_data_->_data24_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	gitg_remote_update_state (_data_->self, _data_->dis);
	gitg_remote_reset_transfer_progress (_data_->self, TRUE);
	block24_data_unref (_data_->_data24_);
	_data_->_data24_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_remote_download_data_free (gpointer _data)
{
	GitgRemoteDownloadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->callbacks);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRemoteDownloadData, _data_);
}

void
gitg_remote_download (GitgRemote* self,
                      GgitRemoteCallbacks* callbacks,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	GitgRemoteDownloadData* _data_;
	GitgRemote* _tmp0_;
	GgitRemoteCallbacks* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgRemoteDownloadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_remote_download_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (callbacks);
	_g_object_unref0 (_data_->callbacks);
	_data_->callbacks = _tmp1_;
	gitg_remote_download_co (_data_);
}

void
gitg_remote_download_finish (GitgRemote* self,
                             GAsyncResult* _res_,
                             GError** error)
{
	GitgRemoteDownloadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
gitg_remote_download_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	GitgRemoteDownloadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_remote_download_co (_data_);
}

static gboolean
gitg_remote_download_co (GitgRemoteDownloadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	gitg_remote_download_intern (_data_->self, NULL, _data_->callbacks, gitg_remote_download_ready, _data_);
	return FALSE;
	_state_1:
	gitg_remote_download_intern_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_remote_push_data_free (gpointer _data)
{
	GitgRemotePushData* _data_;
	_data_ = _data;
	_g_free0 (_data_->branch);
	_g_object_unref0 (_data_->callbacks);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRemotePushData, _data_);
}

void
gitg_remote_push (GitgRemote* self,
                  const gchar* branch,
                  GgitRemoteCallbacks* callbacks,
                  GAsyncReadyCallback _callback_,
                  gpointer _user_data_)
{
	GitgRemotePushData* _data_;
	GitgRemote* _tmp0_;
	gchar* _tmp1_;
	GgitRemoteCallbacks* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (branch != NULL);
	_data_ = g_slice_new0 (GitgRemotePushData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_remote_push_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (branch);
	_g_free0 (_data_->branch);
	_data_->branch = _tmp1_;
	_tmp2_ = _g_object_ref0 (callbacks);
	_g_object_unref0 (_data_->callbacks);
	_data_->callbacks = _tmp2_;
	gitg_remote_push_co (_data_);
}

void
gitg_remote_push_finish (GitgRemote* self,
                         GAsyncResult* _res_,
                         GError** error)
{
	GitgRemotePushData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
gitg_remote_push_ready (GObject* source_object,
                        GAsyncResult* _res_,
                        gpointer _user_data_)
{
	GitgRemotePushData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_remote_push_co (_data_);
}

static gboolean
gitg_remote_push_co (GitgRemotePushData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	gitg_remote_push_intern (_data_->self, _data_->branch, _data_->callbacks, gitg_remote_push_ready, _data_);
	return FALSE;
	_state_1:
	gitg_remote_push_intern_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_remote_fetch_data_free (gpointer _data)
{
	GitgRemoteFetchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->callbacks);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgRemoteFetchData, _data_);
}

void
gitg_remote_fetch (GitgRemote* self,
                   const gchar* message,
                   GgitRemoteCallbacks* callbacks,
                   GAsyncReadyCallback _callback_,
                   gpointer _user_data_)
{
	GitgRemoteFetchData* _data_;
	GitgRemote* _tmp0_;
	gchar* _tmp1_;
	GgitRemoteCallbacks* _tmp2_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GitgRemoteFetchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_remote_fetch_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp1_;
	_tmp2_ = _g_object_ref0 (callbacks);
	_g_object_unref0 (_data_->callbacks);
	_data_->callbacks = _tmp2_;
	gitg_remote_fetch_co (_data_);
}

void
gitg_remote_fetch_finish (GitgRemote* self,
                          GAsyncResult* _res_,
                          GError** error)
{
	GitgRemoteFetchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
gitg_remote_fetch_ready (GObject* source_object,
                         GAsyncResult* _res_,
                         gpointer _user_data_)
{
	GitgRemoteFetchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_remote_fetch_co (_data_);
}

static gboolean
gitg_remote_fetch_co (GitgRemoteFetchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup (_data_->message);
	_data_->msg = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->msg;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = ggit_remote_get_name ((GgitRemote*) _data_->self);
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_data_->name = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->name;
		if (_data_->_tmp4_ == NULL) {
			_data_->_tmp5_ = ggit_remote_get_url ((GgitRemote*) _data_->self);
			_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
			_g_free0 (_data_->name);
			_data_->name = _data_->_tmp6_;
		}
		_data_->_tmp7_ = _data_->name;
		if (_data_->_tmp7_ != NULL) {
			_data_->_tmp8_ = _data_->name;
			_data_->_tmp9_ = g_strconcat ("fetch: ", _data_->_tmp8_, NULL);
			_g_free0 (_data_->msg);
			_data_->msg = _data_->_tmp9_;
		} else {
			_data_->_tmp10_ = g_strdup ("");
			_g_free0 (_data_->msg);
			_data_->msg = _data_->_tmp10_;
		}
		_g_free0 (_data_->name);
	}
	_data_->_tmp11_ = _data_->msg;
	_data_->_state_ = 1;
	gitg_remote_download_intern (_data_->self, _data_->_tmp11_, _data_->callbacks, gitg_remote_fetch_ready, _data_);
	return FALSE;
	_state_1:
	gitg_remote_download_intern_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->msg);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->msg);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GitgRemote*
gitg_remote_construct (GType object_type)
{
	GitgRemote * self = NULL;
	self = (GitgRemote*) g_object_new (object_type, NULL);
	return self;
}

GitgRemote*
gitg_remote_new (void)
{
	return gitg_remote_construct (GITG_TYPE_REMOTE);
}

gdouble
gitg_remote_get_transfer_progress (GitgRemote* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->d_transfer_progress;
	return result;
}

GitgRemoteState
gitg_remote_get_state (GitgRemote* self)
{
	GitgRemoteState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->d_state;
	return result;
}

static void
gitg_remote_set_state (GitgRemote* self,
                       GitgRemoteState value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_state != value) {
		self->priv->d_state = value;
		g_object_notify ((GObject*) self, "state");
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_remote_properties[GITG_REMOTE_STATE_PROPERTY]);
}

static gchar**
_vala_array_dup19 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
gitg_remote_get_fetch_specs (GitgRemote* self,
                             gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_fetch_specs;
	_tmp0__length1 = self->priv->d_fetch_specs_length1;
	if (_tmp0_ != NULL) {
		gchar** _tmp1_;
		gint _tmp1__length1;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp1_ = self->priv->d_fetch_specs;
		_tmp1__length1 = self->priv->d_fetch_specs_length1;
		_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup19 (_tmp1_, _tmp1__length1) : _tmp1_;
		_tmp2__length1 = _tmp1__length1;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp2__length1;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	{
		gchar** _tmp4_ = NULL;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp4__length1;
		gint __tmp4__size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp6_ = _tmp5_ = ggit_remote_get_fetch_specs ((GgitRemote*) self, &_inner_error0_);
		_tmp4_ = _tmp6_;
		_tmp4__length1 = _vala_array_length (_tmp5_);
		__tmp4__size_ = _tmp4__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp7__length1 = _tmp4__length1;
		_tmp4_ = NULL;
		_tmp4__length1 = 0;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _tmp7__length1;
		if (result_length1) {
			*result_length1 = _tmp8__length1;
		}
		result = _tmp8_;
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar** _tmp9_;
		gint _tmp9__length1;
		g_clear_error (&_inner_error0_);
		_tmp9_ = NULL;
		_tmp9__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar**
_vala_array_dup20 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
gitg_remote_set_fetch_specs (GitgRemote* self,
                             gchar** value,
                             gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup20 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->d_fetch_specs = (_vala_array_free (self->priv->d_fetch_specs, self->priv->d_fetch_specs_length1, (GDestroyNotify) g_free), NULL);
	self->priv->d_fetch_specs = _tmp0_;
	self->priv->d_fetch_specs_length1 = _tmp0__length1;
	self->priv->_d_fetch_specs_size_ = self->priv->d_fetch_specs_length1;
	g_object_notify_by_pspec ((GObject *) self, gitg_remote_properties[GITG_REMOTE_FETCH_SPECS_PROPERTY]);
}

static gchar**
_vala_array_dup21 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
gitg_remote_get_push_specs (GitgRemote* self,
                            gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_push_specs;
	_tmp0__length1 = self->priv->d_push_specs_length1;
	if (_tmp0_ != NULL) {
		gchar** _tmp1_;
		gint _tmp1__length1;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp1_ = self->priv->d_push_specs;
		_tmp1__length1 = self->priv->d_push_specs_length1;
		_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup21 (_tmp1_, _tmp1__length1) : _tmp1_;
		_tmp2__length1 = _tmp1__length1;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp2__length1;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	{
		gchar** _tmp4_ = NULL;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp4__length1;
		gint __tmp4__size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp6_ = _tmp5_ = ggit_remote_get_push_specs ((GgitRemote*) self, &_inner_error0_);
		_tmp4_ = _tmp6_;
		_tmp4__length1 = _vala_array_length (_tmp5_);
		__tmp4__size_ = _tmp4__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp7__length1 = _tmp4__length1;
		_tmp4_ = NULL;
		_tmp4__length1 = 0;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _tmp7__length1;
		if (result_length1) {
			*result_length1 = _tmp8__length1;
		}
		result = _tmp8_;
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar** _tmp9_;
		gint _tmp9__length1;
		g_clear_error (&_inner_error0_);
		_tmp9_ = NULL;
		_tmp9__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar**
_vala_array_dup22 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
gitg_remote_set_push_specs (GitgRemote* self,
                            gchar** value,
                            gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup22 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->d_push_specs = (_vala_array_free (self->priv->d_push_specs, self->priv->d_push_specs_length1, (GDestroyNotify) g_free), NULL);
	self->priv->d_push_specs = _tmp0_;
	self->priv->d_push_specs_length1 = _tmp0__length1;
	self->priv->_d_push_specs_size_ = self->priv->d_push_specs_length1;
	g_object_notify_by_pspec ((GObject *) self, gitg_remote_properties[GITG_REMOTE_PUSH_SPECS_PROPERTY]);
}

GitgCredentialsProvider*
gitg_remote_get_credentials_provider (GitgRemote* self)
{
	GitgCredentialsProvider* result;
	GitgCredentialsProvider* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_credentials_provider;
	result = _tmp0_;
	return result;
}

void
gitg_remote_set_credentials_provider (GitgRemote* self,
                                      GitgCredentialsProvider* value)
{
	GitgCredentialsProvider* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_remote_get_credentials_provider (self);
	if (old_value != value) {
		GitgCredentialsProvider* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_credentials_provider);
		self->priv->_credentials_provider = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_remote_properties[GITG_REMOTE_CREDENTIALS_PROVIDER_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}

static inline gpointer
gitg_remote_callbacks_get_instance_private (GitgRemoteCallbacks* self)
{
	return G_STRUCT_MEMBER_P (self, GitgRemoteCallbacks_private_offset);
}

static GitgRemoteCallbacks*
gitg_remote_callbacks_construct (GType object_type,
                                 GitgRemote* remote,
                                 GgitRemoteCallbacks* proxy,
                                 GitgRemoteCallbacksTransferProgress transfer_progress,
                                 gpointer transfer_progress_target,
                                 GDestroyNotify transfer_progress_target_destroy_notify)
{
	GitgRemoteCallbacks * self = NULL;
	GitgRemote* _tmp0_;
	GgitRemoteCallbacks* _tmp1_;
	GitgRemoteCallbacksTransferProgress _tmp2_;
	gpointer _tmp2__target;
	GDestroyNotify _tmp2__target_destroy_notify;
	g_return_val_if_fail (remote != NULL, NULL);
	self = (GitgRemoteCallbacks*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (remote);
	_g_object_unref0 (self->priv->d_remote);
	self->priv->d_remote = _tmp0_;
	_tmp1_ = _g_object_ref0 (proxy);
	_g_object_unref0 (self->priv->d_proxy);
	self->priv->d_proxy = _tmp1_;
	_tmp2_ = transfer_progress;
	_tmp2__target = transfer_progress_target;
	_tmp2__target_destroy_notify = transfer_progress_target_destroy_notify;
	transfer_progress = NULL;
	transfer_progress_target = NULL;
	transfer_progress_target_destroy_notify = NULL;
	(self->priv->d_transfer_progress_target_destroy_notify == NULL) ? NULL : (self->priv->d_transfer_progress_target_destroy_notify (self->priv->d_transfer_progress_target), NULL);
	self->priv->d_transfer_progress = NULL;
	self->priv->d_transfer_progress_target = NULL;
	self->priv->d_transfer_progress_target_destroy_notify = NULL;
	self->priv->d_transfer_progress = _tmp2_;
	self->priv->d_transfer_progress_target = _tmp2__target;
	self->priv->d_transfer_progress_target_destroy_notify = _tmp2__target_destroy_notify;
	(transfer_progress_target_destroy_notify == NULL) ? NULL : (transfer_progress_target_destroy_notify (transfer_progress_target), NULL);
	transfer_progress = NULL;
	transfer_progress_target = NULL;
	transfer_progress_target_destroy_notify = NULL;
	return self;
}

static GitgRemoteCallbacks*
gitg_remote_callbacks_new (GitgRemote* remote,
                           GgitRemoteCallbacks* proxy,
                           GitgRemoteCallbacksTransferProgress transfer_progress,
                           gpointer transfer_progress_target,
                           GDestroyNotify transfer_progress_target_destroy_notify)
{
	return gitg_remote_callbacks_construct (GITG_REMOTE_TYPE_CALLBACKS, remote, proxy, transfer_progress, transfer_progress_target, transfer_progress_target_destroy_notify);
}

static void
gitg_remote_callbacks_real_progress (GgitRemoteCallbacks* base,
                                     const gchar* message)
{
	GitgRemoteCallbacks * self;
	GgitRemoteCallbacks* _tmp0_;
	self = (GitgRemoteCallbacks*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->d_proxy;
	if (_tmp0_ != NULL) {
		GgitRemoteCallbacks* _tmp1_;
		_tmp1_ = self->priv->d_proxy;
		g_signal_emit_by_name (_tmp1_, "progress", message);
	}
}

static void
gitg_remote_callbacks_real_transfer_progress (GgitRemoteCallbacks* base,
                                              GgitTransferProgress* stats)
{
	GitgRemoteCallbacks * self;
	GitgRemoteCallbacksTransferProgress _tmp0_;
	gpointer _tmp0__target;
	GgitRemoteCallbacks* _tmp2_;
	self = (GitgRemoteCallbacks*) base;
	g_return_if_fail (stats != NULL);
	_tmp0_ = self->priv->d_transfer_progress;
	_tmp0__target = self->priv->d_transfer_progress_target;
	if (_tmp0_ != NULL) {
		GitgRemoteCallbacksTransferProgress _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = self->priv->d_transfer_progress;
		_tmp1__target = self->priv->d_transfer_progress_target;
		_tmp1_ (stats, _tmp1__target);
	}
	_tmp2_ = self->priv->d_proxy;
	if (_tmp2_ != NULL) {
		GgitRemoteCallbacks* _tmp3_;
		_tmp3_ = self->priv->d_proxy;
		g_signal_emit_by_name (_tmp3_, "transfer-progress", stats);
	}
}

static void
gitg_remote_callbacks_real_update_tips (GgitRemoteCallbacks* base,
                                        const gchar* refname,
                                        GgitOId* a,
                                        GgitOId* b)
{
	GitgRemoteCallbacks * self;
	GitgRemote* _tmp0_;
	GgitRemoteCallbacks* _tmp1_;
	self = (GitgRemoteCallbacks*) base;
	g_return_if_fail (refname != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->d_remote;
	g_signal_emit (_tmp0_, gitg_remote_signals[GITG_REMOTE_TIP_UPDATED_SIGNAL], 0, refname, a, b);
	_tmp1_ = self->priv->d_proxy;
	if (_tmp1_ != NULL) {
		GgitRemoteCallbacks* _tmp2_;
		_tmp2_ = self->priv->d_proxy;
		g_signal_emit_by_name (_tmp2_, "update-tips", refname, a, b);
	}
}

static void
gitg_remote_callbacks_real_completion (GgitRemoteCallbacks* base,
                                       GgitRemoteCompletionType type)
{
	GitgRemoteCallbacks * self;
	GgitRemoteCallbacks* _tmp0_;
	self = (GitgRemoteCallbacks*) base;
	_tmp0_ = self->priv->d_proxy;
	if (_tmp0_ != NULL) {
		GgitRemoteCallbacks* _tmp1_;
		_tmp1_ = self->priv->d_proxy;
		g_signal_emit_by_name (_tmp1_, "completion", type);
	}
}

static GgitCred*
gitg_remote_callbacks_real_credentials (GgitRemoteCallbacks* base,
                                        const gchar* url,
                                        const gchar* username_from_url,
                                        GgitCredtype allowed_types,
                                        GError** error)
{
	GitgRemoteCallbacks * self;
	GgitCred* ret = NULL;
	GitgCredentialsProvider* provider = NULL;
	GitgRemote* _tmp0_;
	GitgCredentialsProvider* _tmp1_;
	GitgCredentialsProvider* _tmp2_;
	GitgCredentialsProvider* _tmp3_;
	GitgCredentialsProvider* _tmp4_;
	gboolean _tmp9_ = FALSE;
	GgitCred* _tmp10_;
	GError* _inner_error0_ = NULL;
	GgitCred* result;
	self = (GitgRemoteCallbacks*) base;
	g_return_val_if_fail (url != NULL, NULL);
	ret = NULL;
	_tmp0_ = self->priv->d_remote;
	_tmp1_ = gitg_remote_get_credentials_provider (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	provider = _tmp3_;
	_tmp4_ = provider;
	if (_tmp4_ != NULL) {
		GgitCred* _tmp5_ = NULL;
		GitgCredentialsProvider* _tmp6_;
		GgitCred* _tmp7_;
		GgitCred* _tmp8_;
		_tmp6_ = provider;
		_tmp7_ = gitg_credentials_provider_credentials (_tmp6_, url, username_from_url, allowed_types, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (provider);
			_g_object_unref0 (ret);
			return NULL;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (ret);
		ret = _tmp8_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp10_ = ret;
	if (_tmp10_ == NULL) {
		GgitRemoteCallbacks* _tmp11_;
		_tmp11_ = self->priv->d_proxy;
		_tmp9_ = _tmp11_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GgitCred* _tmp12_ = NULL;
		GgitRemoteCallbacks* _tmp13_;
		GgitCred* _tmp14_;
		GgitCred* _tmp15_;
		_tmp13_ = self->priv->d_proxy;
		_tmp14_ = G_TYPE_INSTANCE_GET_CLASS (_tmp13_, ggit_remote_callbacks_get_type (), GgitRemoteCallbacksClass)->credentials (_tmp13_, url, username_from_url, allowed_types, &_inner_error0_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (provider);
			_g_object_unref0 (ret);
			return NULL;
		}
		_tmp15_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (ret);
		ret = _tmp15_;
		_g_object_unref0 (_tmp12_);
	}
	result = ret;
	_g_object_unref0 (provider);
	return result;
}

static void
gitg_remote_callbacks_class_init (GitgRemoteCallbacksClass * klass,
                                  gpointer klass_data)
{
	gitg_remote_callbacks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRemoteCallbacks_private_offset);
	((GgitRemoteCallbacksClass *) klass)->progress = (void (*) (GgitRemoteCallbacks*, const gchar*)) gitg_remote_callbacks_real_progress;
	((GgitRemoteCallbacksClass *) klass)->transfer_progress = (void (*) (GgitRemoteCallbacks*, GgitTransferProgress*)) gitg_remote_callbacks_real_transfer_progress;
	((GgitRemoteCallbacksClass *) klass)->update_tips = (void (*) (GgitRemoteCallbacks*, const gchar*, GgitOId*, GgitOId*)) gitg_remote_callbacks_real_update_tips;
	((GgitRemoteCallbacksClass *) klass)->completion = (void (*) (GgitRemoteCallbacks*, GgitRemoteCompletionType)) gitg_remote_callbacks_real_completion;
	((GgitRemoteCallbacksClass *) klass)->credentials = (GgitCred* (*) (GgitRemoteCallbacks*, const gchar*, const gchar*, GgitCredtype, GError**)) gitg_remote_callbacks_real_credentials;
	G_OBJECT_CLASS (klass)->finalize = gitg_remote_callbacks_finalize;
}

static void
gitg_remote_callbacks_instance_init (GitgRemoteCallbacks * self,
                                     gpointer klass)
{
	self->priv = gitg_remote_callbacks_get_instance_private (self);
}

static void
gitg_remote_callbacks_finalize (GObject * obj)
{
	GitgRemoteCallbacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacks);
	_g_object_unref0 (self->priv->d_remote);
	_g_object_unref0 (self->priv->d_proxy);
	(self->priv->d_transfer_progress_target_destroy_notify == NULL) ? NULL : (self->priv->d_transfer_progress_target_destroy_notify (self->priv->d_transfer_progress_target), NULL);
	self->priv->d_transfer_progress = NULL;
	self->priv->d_transfer_progress_target = NULL;
	self->priv->d_transfer_progress_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gitg_remote_callbacks_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_remote_callbacks_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRemoteCallbacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remote_callbacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemoteCallbacks), 0, (GInstanceInitFunc) gitg_remote_callbacks_instance_init, NULL };
	GType gitg_remote_callbacks_type_id;
	gitg_remote_callbacks_type_id = g_type_register_static (ggit_remote_callbacks_get_type (), "GitgRemoteCallbacks", &g_define_type_info, 0);
	GitgRemoteCallbacks_private_offset = g_type_add_instance_private (gitg_remote_callbacks_type_id, sizeof (GitgRemoteCallbacksPrivate));
	return gitg_remote_callbacks_type_id;
}

static GType
gitg_remote_callbacks_get_type (void)
{
	static gsize gitg_remote_callbacks_type_id__once = 0;
	if (g_once_init_enter (&gitg_remote_callbacks_type_id__once)) {
		GType gitg_remote_callbacks_type_id;
		gitg_remote_callbacks_type_id = gitg_remote_callbacks_get_type_once ();
		g_once_init_leave (&gitg_remote_callbacks_type_id__once, gitg_remote_callbacks_type_id);
	}
	return gitg_remote_callbacks_type_id__once;
}

static void
gitg_remote_class_init (GitgRemoteClass * klass,
                        gpointer klass_data)
{
	gitg_remote_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgRemote_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_remote_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_remote_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_remote_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_remote_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_TRANSFER_PROGRESS_PROPERTY, gitg_remote_properties[GITG_REMOTE_TRANSFER_PROGRESS_PROPERTY] = g_param_spec_double ("transfer-progress", "transfer-progress", "transfer-progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_STATE_PROPERTY, gitg_remote_properties[GITG_REMOTE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", GITG_TYPE_REMOTE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_FETCH_SPECS_PROPERTY, gitg_remote_properties[GITG_REMOTE_FETCH_SPECS_PROPERTY] = g_param_spec_boxed ("fetch-specs", "fetch-specs", "fetch-specs", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_PUSH_SPECS_PROPERTY, gitg_remote_properties[GITG_REMOTE_PUSH_SPECS_PROPERTY] = g_param_spec_boxed ("push-specs", "push-specs", "push-specs", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_CREDENTIALS_PROVIDER_PROPERTY, gitg_remote_properties[GITG_REMOTE_CREDENTIALS_PROVIDER_PROPERTY] = g_param_spec_object ("credentials-provider", "credentials-provider", "credentials-provider", GITG_TYPE_CREDENTIALS_PROVIDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gitg_remote_signals[GITG_REMOTE_TIP_UPDATED_SIGNAL] = g_signal_new ("tip-updated", GITG_TYPE_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED, G_TYPE_NONE, 3, G_TYPE_STRING, ggit_oid_get_type (), ggit_oid_get_type ());
}

static void
gitg_remote_instance_init (GitgRemote * self,
                           gpointer klass)
{
	self->priv = gitg_remote_get_instance_private (self);
}

static void
gitg_remote_finalize (GObject * obj)
{
	GitgRemote * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REMOTE, GitgRemote);
	self->priv->d_fetch_specs = (_vala_array_free (self->priv->d_fetch_specs, self->priv->d_fetch_specs_length1, (GDestroyNotify) g_free), NULL);
	self->priv->d_push_specs = (_vala_array_free (self->priv->d_push_specs, self->priv->d_push_specs_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->d_callbacks);
	_g_object_unref0 (self->priv->_credentials_provider);
	G_OBJECT_CLASS (gitg_remote_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_remote_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgRemoteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remote_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemote), 0, (GInstanceInitFunc) gitg_remote_instance_init, NULL };
	GType gitg_remote_type_id;
	gitg_remote_type_id = g_type_register_static (ggit_remote_get_type (), "GitgRemote", &g_define_type_info, 0);
	GitgRemote_private_offset = g_type_add_instance_private (gitg_remote_type_id, sizeof (GitgRemotePrivate));
	return gitg_remote_type_id;
}

GType
gitg_remote_get_type (void)
{
	static gsize gitg_remote_type_id__once = 0;
	if (g_once_init_enter (&gitg_remote_type_id__once)) {
		GType gitg_remote_type_id;
		gitg_remote_type_id = gitg_remote_get_type_once ();
		g_once_init_leave (&gitg_remote_type_id__once, gitg_remote_type_id);
	}
	return gitg_remote_type_id__once;
}

static void
_vala_gitg_remote_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	GitgRemote * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOTE, GitgRemote);
	switch (property_id) {
		case GITG_REMOTE_TRANSFER_PROGRESS_PROPERTY:
		g_value_set_double (value, gitg_remote_get_transfer_progress (self));
		break;
		case GITG_REMOTE_STATE_PROPERTY:
		g_value_set_enum (value, gitg_remote_get_state (self));
		break;
		case GITG_REMOTE_FETCH_SPECS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, gitg_remote_get_fetch_specs (self, &length));
		}
		break;
		case GITG_REMOTE_PUSH_SPECS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, gitg_remote_get_push_specs (self, &length));
		}
		break;
		case GITG_REMOTE_CREDENTIALS_PROVIDER_PROPERTY:
		g_value_set_object (value, gitg_remote_get_credentials_provider (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_remote_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	GitgRemote * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOTE, GitgRemote);
	switch (property_id) {
		case GITG_REMOTE_STATE_PROPERTY:
		gitg_remote_set_state (self, g_value_get_enum (value));
		break;
		case GITG_REMOTE_FETCH_SPECS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			gitg_remote_set_fetch_specs (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case GITG_REMOTE_PUSH_SPECS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			gitg_remote_set_push_specs (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case GITG_REMOTE_CREDENTIALS_PROVIDER_PROPERTY:
		gitg_remote_set_credentials_provider (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

