// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.30.2
// source: repository.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	RepositoryService_RepositoryExists_FullMethodName             = "/gitaly.RepositoryService/RepositoryExists"
	RepositoryService_RepositorySize_FullMethodName               = "/gitaly.RepositoryService/RepositorySize"
	RepositoryService_RepositoryInfo_FullMethodName               = "/gitaly.RepositoryService/RepositoryInfo"
	RepositoryService_ObjectsSize_FullMethodName                  = "/gitaly.RepositoryService/ObjectsSize"
	RepositoryService_ObjectFormat_FullMethodName                 = "/gitaly.RepositoryService/ObjectFormat"
	RepositoryService_FetchRemote_FullMethodName                  = "/gitaly.RepositoryService/FetchRemote"
	RepositoryService_CreateRepository_FullMethodName             = "/gitaly.RepositoryService/CreateRepository"
	RepositoryService_GetArchive_FullMethodName                   = "/gitaly.RepositoryService/GetArchive"
	RepositoryService_HasLocalBranches_FullMethodName             = "/gitaly.RepositoryService/HasLocalBranches"
	RepositoryService_FetchSourceBranch_FullMethodName            = "/gitaly.RepositoryService/FetchSourceBranch"
	RepositoryService_Fsck_FullMethodName                         = "/gitaly.RepositoryService/Fsck"
	RepositoryService_WriteRef_FullMethodName                     = "/gitaly.RepositoryService/WriteRef"
	RepositoryService_FindMergeBase_FullMethodName                = "/gitaly.RepositoryService/FindMergeBase"
	RepositoryService_CreateFork_FullMethodName                   = "/gitaly.RepositoryService/CreateFork"
	RepositoryService_CreateRepositoryFromURL_FullMethodName      = "/gitaly.RepositoryService/CreateRepositoryFromURL"
	RepositoryService_CreateBundle_FullMethodName                 = "/gitaly.RepositoryService/CreateBundle"
	RepositoryService_CreateBundleFromRefList_FullMethodName      = "/gitaly.RepositoryService/CreateBundleFromRefList"
	RepositoryService_GenerateBundleURI_FullMethodName            = "/gitaly.RepositoryService/GenerateBundleURI"
	RepositoryService_FetchBundle_FullMethodName                  = "/gitaly.RepositoryService/FetchBundle"
	RepositoryService_CreateRepositoryFromBundle_FullMethodName   = "/gitaly.RepositoryService/CreateRepositoryFromBundle"
	RepositoryService_GetConfig_FullMethodName                    = "/gitaly.RepositoryService/GetConfig"
	RepositoryService_FindLicense_FullMethodName                  = "/gitaly.RepositoryService/FindLicense"
	RepositoryService_GetInfoAttributes_FullMethodName            = "/gitaly.RepositoryService/GetInfoAttributes"
	RepositoryService_CalculateChecksum_FullMethodName            = "/gitaly.RepositoryService/CalculateChecksum"
	RepositoryService_GetSnapshot_FullMethodName                  = "/gitaly.RepositoryService/GetSnapshot"
	RepositoryService_CreateRepositoryFromSnapshot_FullMethodName = "/gitaly.RepositoryService/CreateRepositoryFromSnapshot"
	RepositoryService_GetRawChanges_FullMethodName                = "/gitaly.RepositoryService/GetRawChanges"
	RepositoryService_SearchFilesByContent_FullMethodName         = "/gitaly.RepositoryService/SearchFilesByContent"
	RepositoryService_SearchFilesByName_FullMethodName            = "/gitaly.RepositoryService/SearchFilesByName"
	RepositoryService_RestoreCustomHooks_FullMethodName           = "/gitaly.RepositoryService/RestoreCustomHooks"
	RepositoryService_SetCustomHooks_FullMethodName               = "/gitaly.RepositoryService/SetCustomHooks"
	RepositoryService_BackupCustomHooks_FullMethodName            = "/gitaly.RepositoryService/BackupCustomHooks"
	RepositoryService_GetCustomHooks_FullMethodName               = "/gitaly.RepositoryService/GetCustomHooks"
	RepositoryService_GetObjectDirectorySize_FullMethodName       = "/gitaly.RepositoryService/GetObjectDirectorySize"
	RepositoryService_RemoveRepository_FullMethodName             = "/gitaly.RepositoryService/RemoveRepository"
	RepositoryService_ReplicateRepository_FullMethodName          = "/gitaly.RepositoryService/ReplicateRepository"
	RepositoryService_OptimizeRepository_FullMethodName           = "/gitaly.RepositoryService/OptimizeRepository"
	RepositoryService_PruneUnreachableObjects_FullMethodName      = "/gitaly.RepositoryService/PruneUnreachableObjects"
	RepositoryService_BackupRepository_FullMethodName             = "/gitaly.RepositoryService/BackupRepository"
	RepositoryService_RestoreRepository_FullMethodName            = "/gitaly.RepositoryService/RestoreRepository"
	RepositoryService_GetFileAttributes_FullMethodName            = "/gitaly.RepositoryService/GetFileAttributes"
	RepositoryService_FastExport_FullMethodName                   = "/gitaly.RepositoryService/FastExport"
	RepositoryService_MigrateReferenceBackend_FullMethodName      = "/gitaly.RepositoryService/MigrateReferenceBackend"
)

// RepositoryServiceClient is the client API for RepositoryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// RepositoryService is a service providing RPCs accessing repositories as a whole.
type RepositoryServiceClient interface {
	// RepositoryExists returns whether a given repository exists.
	RepositoryExists(ctx context.Context, in *RepositoryExistsRequest, opts ...grpc.CallOption) (*RepositoryExistsResponse, error)
	// RepositorySize returns information on the complete on-disk repository size. If you need more
	// detailed information about the size of various sub-structures you should instead use the
	// repositoryInfo RPC.
	RepositorySize(ctx context.Context, in *RepositorySizeRequest, opts ...grpc.CallOption) (*RepositorySizeResponse, error)
	// RepositoryInfo returns detailed information about a repository and its data structures.
	RepositoryInfo(ctx context.Context, in *RepositoryInfoRequest, opts ...grpc.CallOption) (*RepositoryInfoResponse, error)
	// ObjectsSize calculates the total on-disk object size of reachable objects in bytes. In contrast
	// to RepositorySize and RepositoryInfo, this RPC performs a graph walk of the specified revisions
	// and will thus return an accurate view of how large the accumulated on-disk size of reachable
	// objects is.
	//
	// As this RPC needs to perform a revision walk, it is significantly more expensive than the RPCs
	// which simply check the size of on-disk data structures. On the other hand, it allows the caller
	// to accurately compute the size of objects in a way that is at least somewhat detached from the
	// on-disk representation:
	//
	//   - Objects which exist in multiple packfiles will not be double-counted.
	//   - Objects which aren't reachable will not be accounted for.
	//   - It is possible to only account for a subset of references, e.g. only those that an admin
	//     would have direct control over.
	//
	// It is thus recommended to use this RPC whenever you want to calculate sizes which will end up
	// being shown to the user.
	//
	// Note that the size is still bound to change when repositories are getting repacked and thus
	// cannot be considered to be stable. This is because the on-disk size of any object can change
	// depending on how Git decides to deltify it in a packfile. Thus, when a repack would cause a
	// different delta base to be picked, the actual on-disk size of any given object may change.
	ObjectsSize(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[ObjectsSizeRequest, ObjectsSizeResponse], error)
	// ObjectFormat determines the object format that is being used by the repository.
	ObjectFormat(ctx context.Context, in *ObjectFormatRequest, opts ...grpc.CallOption) (*ObjectFormatResponse, error)
	// FetchRemote fetches references from a remote repository into the local
	// repository. The remote can be fetched via HTTP or SSH depending on the
	// request options provided.
	FetchRemote(ctx context.Context, in *FetchRemoteRequest, opts ...grpc.CallOption) (*FetchRemoteResponse, error)
	// CreateRepository creates a new empty repository.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*CreateRepositoryResponse, error)
	// GetArchive produces and returns an archive of a repository.
	GetArchive(ctx context.Context, in *GetArchiveRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetArchiveResponse], error)
	// HasLocalBranches returns whether the given repo contains any branches.
	HasLocalBranches(ctx context.Context, in *HasLocalBranchesRequest, opts ...grpc.CallOption) (*HasLocalBranchesResponse, error)
	// FetchSourceBranch fetches a branch from a second (potentially remote)
	// repository into the given repository.
	FetchSourceBranch(ctx context.Context, in *FetchSourceBranchRequest, opts ...grpc.CallOption) (*FetchSourceBranchResponse, error)
	// Fsck checks the repository for consistency via git-fsck(1). This can be used to check for
	// repository corruption.
	Fsck(ctx context.Context, in *FsckRequest, opts ...grpc.CallOption) (*FsckResponse, error)
	// WriteRef creates or updates a ref in a repository to point to a new value.
	// If the request contains object revisions that do not exist in the repository, the RPC returns
	// the NOT_FOUND code with the ReferenceNotFoundError detail.
	WriteRef(ctx context.Context, in *WriteRefRequest, opts ...grpc.CallOption) (*WriteRefResponse, error)
	// FindMergeBase returns the best common ancestor between two or more commits. Consult the man
	// pages of git-merge-base(1) for more information on how this is calculated.
	FindMergeBase(ctx context.Context, in *FindMergeBaseRequest, opts ...grpc.CallOption) (*FindMergeBaseResponse, error)
	// CreateFork creates a new repository from a specific source repository. This new repository will
	// have the same branches and tags as the source repository. Internal references will not be
	// recreated in the forked repository.
	//
	// all objects of the source repository will be duplicated, that is there are no space savings by
	// creating the repository like this. The newly created repository does not join the object pool
	// of the source repository, if there is any.
	CreateFork(ctx context.Context, in *CreateForkRequest, opts ...grpc.CallOption) (*CreateForkResponse, error)
	// CreateRepositoryFromURL creates a new repo and seeds it with the contents of an existing Git repo
	// reachable at the provided URL.
	CreateRepositoryFromURL(ctx context.Context, in *CreateRepositoryFromURLRequest, opts ...grpc.CallOption) (*CreateRepositoryFromURLResponse, error)
	// CreateBundle creates a bundle from all refs
	CreateBundle(ctx context.Context, in *CreateBundleRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[CreateBundleResponse], error)
	// CreateBundleFromRefList creates a bundle from a stream of ref patterns.
	// When the bundle would be empty the FailedPrecondition error code is returned.
	CreateBundleFromRefList(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[CreateBundleFromRefListRequest, CreateBundleFromRefListResponse], error)
	// GenerateBundleURI generates a bundle on the server for bundle-URI use.
	GenerateBundleURI(ctx context.Context, in *GenerateBundleURIRequest, opts ...grpc.CallOption) (*GenerateBundleURIResponse, error)
	// FetchBundle fetches references from a bundle into the local repository.
	// refs will be mirrored to the target repository with the refspec
	// "+refs/*:refs/*" and refs that do not exist in the bundle will be removed.
	FetchBundle(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[FetchBundleRequest, FetchBundleResponse], error)
	// CreateRepositoryFromBundle creates a Git repository at the specified storage and path, if it
	// does not already exist, from the provided Git bundle.
	CreateRepositoryFromBundle(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[CreateRepositoryFromBundleRequest, CreateRepositoryFromBundleResponse], error)
	// GetConfig reads the target repository's gitconfig and streams its contents
	// back. Returns a NotFound error in case no gitconfig was found.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetConfigResponse], error)
	// FindLicense looks in the given repository and attempts to detect all the
	// details about the license used in the repository.
	FindLicense(ctx context.Context, in *FindLicenseRequest, opts ...grpc.CallOption) (*FindLicenseResponse, error)
	// Deprecated: Do not use.
	// GetInfoAttributes reads the contents from info/attributes.
	// This RPC will be removed in 17.0.
	GetInfoAttributes(ctx context.Context, in *GetInfoAttributesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetInfoAttributesResponse], error)
	// CalculateChecksum returns a checksum of the repository by hashing its references. Refs
	// outside of well-known namespaces are not considered when computing the checksum.
	CalculateChecksum(ctx context.Context, in *CalculateChecksumRequest, opts ...grpc.CallOption) (*CalculateChecksumResponse, error)
	// GetSnapshot returns a snapshot of the repository. A snapshot comprises all Git references
	// and objects required to recreate the state of a repository at a point in time.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetSnapshotResponse], error)
	// CreateRepositoryFromSnapshot creates a new repository based on a snapshot created with
	// the GetSnapshot RPC. The snapshot is fetched via HTTP.
	//
	// Due to the inherent structure of the TAR format, it's challenging to definitively verify
	// if a provided TAR file is complete or truncated/malformed. While basic integrity checks
	// are performed, users should ensure the completeness and integrity of their TAR files.
	CreateRepositoryFromSnapshot(ctx context.Context, in *CreateRepositoryFromSnapshotRequest, opts ...grpc.CallOption) (*CreateRepositoryFromSnapshotResponse, error)
	// GetRawChanges returns metadata in raw format on the changes between two revisions.
	GetRawChanges(ctx context.Context, in *GetRawChangesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetRawChangesResponse], error)
	// SearchFilesByContent searches files in the repository using the provided grep pattern.
	// For each result, the matched line is returned along with the two previous and next lines.
	SearchFilesByContent(ctx context.Context, in *SearchFilesByContentRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[SearchFilesByContentResponse], error)
	// SearchFilesByName searches files in the repository based on its name and an
	// optional filter.
	SearchFilesByName(ctx context.Context, in *SearchFilesByNameRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[SearchFilesByNameResponse], error)
	// Deprecated: Do not use.
	// RestoreCustomHooks sets the git hooks for a repository. The hooks are sent
	// in a tar archive containing a `custom_hooks` directory. This directory is
	// ultimately extracted to the repository.
	RestoreCustomHooks(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RestoreCustomHooksRequest, RestoreCustomHooksResponse], error)
	// SetCustomHooks sets the git hooks for a repository. The hooks are sent in a
	// tar archive containing a `custom_hooks` directory (i.e. the response from the
	// GetCustomHooksResponse RPC. This directory will be extracted into the repository.
	SetCustomHooks(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[SetCustomHooksRequest, SetCustomHooksResponse], error)
	// Deprecated: Do not use.
	// BackupCustomHooks fetches the git hooks for a repository. The hooks are
	// sent in a tar archive containing a `custom_hooks` directory. If no hooks
	// are present in the repository, the response will have no data.
	BackupCustomHooks(ctx context.Context, in *BackupCustomHooksRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[BackupCustomHooksResponse], error)
	// GetCustomHooks fetches the git hooks for a repository. The hooks are sent
	// in a tar archive containing a `custom_hooks` directory. If no hooks are
	// present in the repository, the response will have no data.
	GetCustomHooks(ctx context.Context, in *GetCustomHooksRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetCustomHooksResponse], error)
	// GetObjectDirectorySize returns the size in kibibytes of the object directory of a repository.
	GetObjectDirectorySize(ctx context.Context, in *GetObjectDirectorySizeRequest, opts ...grpc.CallOption) (*GetObjectDirectorySizeResponse, error)
	// RemoveRepository will move the repository to `+gitaly/tmp/<relative_path>_removed` and
	// eventually remove it. This ensures that even on networked filesystems the
	// data is actually removed even if there's someone still handling the data.
	RemoveRepository(ctx context.Context, in *RemoveRepositoryRequest, opts ...grpc.CallOption) (*RemoveRepositoryResponse, error)
	// ReplicateRepository replicates data from a source repository to target repository. On the
	// target repository, this operation ensures synchronization of the following components:
	//
	// - Git config
	// - Git attributes
	// - Custom Git hooks,
	// - References and objects
	// - (Optional) Object deduplication network membership
	ReplicateRepository(ctx context.Context, in *ReplicateRepositoryRequest, opts ...grpc.CallOption) (*ReplicateRepositoryResponse, error)
	// OptimizeRepository performs all maintenance tasks in a repository to keep
	// it in an efficient state. It cleans up stale data, repacks objects,
	// updates auxiliary caches like commit-graphs and packs references. The
	// optimizations performed are based on heuristics and will adapt to the
	// repository's size. This RPC call is designed as a black-box such that
	// Gitaly has complete control of the on-disk state of repositories.
	OptimizeRepository(ctx context.Context, in *OptimizeRepositoryRequest, opts ...grpc.CallOption) (*OptimizeRepositoryResponse, error)
	// PruneUnreachableObjects will prune all objects which aren't reachable from
	// the repository's current set of references. Because pruning can only
	// happen for objects which aren't packed, you are required to first run
	// OptimizeRepository to explode any unreachable objects into loose objects.
	//
	// Furthermore, this RPC call has a grace period of 30 minutes: any
	// unreachable loose objects must not have been accessed or modified in the
	// last 30 minutes. This is a hard requirement to avoid repository corruption.
	//
	// to make proper use of this RPC you thus need to call OptimizeRepository,
	// wait 30 minutes, and then call PruneUnreachableObjects.
	PruneUnreachableObjects(ctx context.Context, in *PruneUnreachableObjectsRequest, opts ...grpc.CallOption) (*PruneUnreachableObjectsResponse, error)
	// BackupRepository creates a full or incremental backup streamed directly to
	// object-storage. The backup is created synchronously. The destination must
	// be configured in config.backup.go_cloud_url
	BackupRepository(ctx context.Context, in *BackupRepositoryRequest, opts ...grpc.CallOption) (*BackupRepositoryResponse, error)
	// RestoreRepository restores a backup streamed directly from object-storage.
	// The repository is restored synchronously. The source object-storage must
	// be configured in config.backup.go_cloud_url
	RestoreRepository(ctx context.Context, in *RestoreRepositoryRequest, opts ...grpc.CallOption) (*RestoreRepositoryResponse, error)
	// GetFileAttributes queries given file attributes as specified in .gitattributes file
	GetFileAttributes(ctx context.Context, in *GetFileAttributesRequest, opts ...grpc.CallOption) (*GetFileAttributesResponse, error)
	// FastExport runs git-fast-export on the repository, streaming the data back through the response
	FastExport(ctx context.Context, in *FastExportRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FastExportResponse], error)
	// MigrateReferenceBackend allows migrating a repository between the different Git
	// reference backends. Transactions must be enabled.
	MigrateReferenceBackend(ctx context.Context, in *MigrateReferenceBackendRequest, opts ...grpc.CallOption) (*MigrateReferenceBackendResponse, error)
}

type repositoryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRepositoryServiceClient(cc grpc.ClientConnInterface) RepositoryServiceClient {
	return &repositoryServiceClient{cc}
}

func (c *repositoryServiceClient) RepositoryExists(ctx context.Context, in *RepositoryExistsRequest, opts ...grpc.CallOption) (*RepositoryExistsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RepositoryExistsResponse)
	err := c.cc.Invoke(ctx, RepositoryService_RepositoryExists_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RepositorySize(ctx context.Context, in *RepositorySizeRequest, opts ...grpc.CallOption) (*RepositorySizeResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RepositorySizeResponse)
	err := c.cc.Invoke(ctx, RepositoryService_RepositorySize_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RepositoryInfo(ctx context.Context, in *RepositoryInfoRequest, opts ...grpc.CallOption) (*RepositoryInfoResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RepositoryInfoResponse)
	err := c.cc.Invoke(ctx, RepositoryService_RepositoryInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) ObjectsSize(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[ObjectsSizeRequest, ObjectsSizeResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[0], RepositoryService_ObjectsSize_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ObjectsSizeRequest, ObjectsSizeResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_ObjectsSizeClient = grpc.ClientStreamingClient[ObjectsSizeRequest, ObjectsSizeResponse]

func (c *repositoryServiceClient) ObjectFormat(ctx context.Context, in *ObjectFormatRequest, opts ...grpc.CallOption) (*ObjectFormatResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ObjectFormatResponse)
	err := c.cc.Invoke(ctx, RepositoryService_ObjectFormat_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FetchRemote(ctx context.Context, in *FetchRemoteRequest, opts ...grpc.CallOption) (*FetchRemoteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FetchRemoteResponse)
	err := c.cc.Invoke(ctx, RepositoryService_FetchRemote_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*CreateRepositoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CreateRepositoryResponse)
	err := c.cc.Invoke(ctx, RepositoryService_CreateRepository_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetArchive(ctx context.Context, in *GetArchiveRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetArchiveResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[1], RepositoryService_GetArchive_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetArchiveRequest, GetArchiveResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetArchiveClient = grpc.ServerStreamingClient[GetArchiveResponse]

func (c *repositoryServiceClient) HasLocalBranches(ctx context.Context, in *HasLocalBranchesRequest, opts ...grpc.CallOption) (*HasLocalBranchesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(HasLocalBranchesResponse)
	err := c.cc.Invoke(ctx, RepositoryService_HasLocalBranches_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FetchSourceBranch(ctx context.Context, in *FetchSourceBranchRequest, opts ...grpc.CallOption) (*FetchSourceBranchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FetchSourceBranchResponse)
	err := c.cc.Invoke(ctx, RepositoryService_FetchSourceBranch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) Fsck(ctx context.Context, in *FsckRequest, opts ...grpc.CallOption) (*FsckResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FsckResponse)
	err := c.cc.Invoke(ctx, RepositoryService_Fsck_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) WriteRef(ctx context.Context, in *WriteRefRequest, opts ...grpc.CallOption) (*WriteRefResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(WriteRefResponse)
	err := c.cc.Invoke(ctx, RepositoryService_WriteRef_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FindMergeBase(ctx context.Context, in *FindMergeBaseRequest, opts ...grpc.CallOption) (*FindMergeBaseResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FindMergeBaseResponse)
	err := c.cc.Invoke(ctx, RepositoryService_FindMergeBase_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateFork(ctx context.Context, in *CreateForkRequest, opts ...grpc.CallOption) (*CreateForkResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CreateForkResponse)
	err := c.cc.Invoke(ctx, RepositoryService_CreateFork_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateRepositoryFromURL(ctx context.Context, in *CreateRepositoryFromURLRequest, opts ...grpc.CallOption) (*CreateRepositoryFromURLResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CreateRepositoryFromURLResponse)
	err := c.cc.Invoke(ctx, RepositoryService_CreateRepositoryFromURL_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) CreateBundle(ctx context.Context, in *CreateBundleRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[CreateBundleResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[2], RepositoryService_CreateBundle_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[CreateBundleRequest, CreateBundleResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_CreateBundleClient = grpc.ServerStreamingClient[CreateBundleResponse]

func (c *repositoryServiceClient) CreateBundleFromRefList(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[CreateBundleFromRefListRequest, CreateBundleFromRefListResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[3], RepositoryService_CreateBundleFromRefList_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[CreateBundleFromRefListRequest, CreateBundleFromRefListResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_CreateBundleFromRefListClient = grpc.BidiStreamingClient[CreateBundleFromRefListRequest, CreateBundleFromRefListResponse]

func (c *repositoryServiceClient) GenerateBundleURI(ctx context.Context, in *GenerateBundleURIRequest, opts ...grpc.CallOption) (*GenerateBundleURIResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GenerateBundleURIResponse)
	err := c.cc.Invoke(ctx, RepositoryService_GenerateBundleURI_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FetchBundle(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[FetchBundleRequest, FetchBundleResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[4], RepositoryService_FetchBundle_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[FetchBundleRequest, FetchBundleResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_FetchBundleClient = grpc.ClientStreamingClient[FetchBundleRequest, FetchBundleResponse]

func (c *repositoryServiceClient) CreateRepositoryFromBundle(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[CreateRepositoryFromBundleRequest, CreateRepositoryFromBundleResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[5], RepositoryService_CreateRepositoryFromBundle_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[CreateRepositoryFromBundleRequest, CreateRepositoryFromBundleResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_CreateRepositoryFromBundleClient = grpc.ClientStreamingClient[CreateRepositoryFromBundleRequest, CreateRepositoryFromBundleResponse]

func (c *repositoryServiceClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetConfigResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[6], RepositoryService_GetConfig_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetConfigRequest, GetConfigResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetConfigClient = grpc.ServerStreamingClient[GetConfigResponse]

func (c *repositoryServiceClient) FindLicense(ctx context.Context, in *FindLicenseRequest, opts ...grpc.CallOption) (*FindLicenseResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FindLicenseResponse)
	err := c.cc.Invoke(ctx, RepositoryService_FindLicense_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *repositoryServiceClient) GetInfoAttributes(ctx context.Context, in *GetInfoAttributesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetInfoAttributesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[7], RepositoryService_GetInfoAttributes_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetInfoAttributesRequest, GetInfoAttributesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetInfoAttributesClient = grpc.ServerStreamingClient[GetInfoAttributesResponse]

func (c *repositoryServiceClient) CalculateChecksum(ctx context.Context, in *CalculateChecksumRequest, opts ...grpc.CallOption) (*CalculateChecksumResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CalculateChecksumResponse)
	err := c.cc.Invoke(ctx, RepositoryService_CalculateChecksum_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetSnapshotResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[8], RepositoryService_GetSnapshot_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetSnapshotRequest, GetSnapshotResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetSnapshotClient = grpc.ServerStreamingClient[GetSnapshotResponse]

func (c *repositoryServiceClient) CreateRepositoryFromSnapshot(ctx context.Context, in *CreateRepositoryFromSnapshotRequest, opts ...grpc.CallOption) (*CreateRepositoryFromSnapshotResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CreateRepositoryFromSnapshotResponse)
	err := c.cc.Invoke(ctx, RepositoryService_CreateRepositoryFromSnapshot_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetRawChanges(ctx context.Context, in *GetRawChangesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetRawChangesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[9], RepositoryService_GetRawChanges_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetRawChangesRequest, GetRawChangesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetRawChangesClient = grpc.ServerStreamingClient[GetRawChangesResponse]

func (c *repositoryServiceClient) SearchFilesByContent(ctx context.Context, in *SearchFilesByContentRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[SearchFilesByContentResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[10], RepositoryService_SearchFilesByContent_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[SearchFilesByContentRequest, SearchFilesByContentResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_SearchFilesByContentClient = grpc.ServerStreamingClient[SearchFilesByContentResponse]

func (c *repositoryServiceClient) SearchFilesByName(ctx context.Context, in *SearchFilesByNameRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[SearchFilesByNameResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[11], RepositoryService_SearchFilesByName_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[SearchFilesByNameRequest, SearchFilesByNameResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_SearchFilesByNameClient = grpc.ServerStreamingClient[SearchFilesByNameResponse]

// Deprecated: Do not use.
func (c *repositoryServiceClient) RestoreCustomHooks(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RestoreCustomHooksRequest, RestoreCustomHooksResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[12], RepositoryService_RestoreCustomHooks_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[RestoreCustomHooksRequest, RestoreCustomHooksResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_RestoreCustomHooksClient = grpc.ClientStreamingClient[RestoreCustomHooksRequest, RestoreCustomHooksResponse]

func (c *repositoryServiceClient) SetCustomHooks(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[SetCustomHooksRequest, SetCustomHooksResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[13], RepositoryService_SetCustomHooks_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[SetCustomHooksRequest, SetCustomHooksResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_SetCustomHooksClient = grpc.ClientStreamingClient[SetCustomHooksRequest, SetCustomHooksResponse]

// Deprecated: Do not use.
func (c *repositoryServiceClient) BackupCustomHooks(ctx context.Context, in *BackupCustomHooksRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[BackupCustomHooksResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[14], RepositoryService_BackupCustomHooks_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[BackupCustomHooksRequest, BackupCustomHooksResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_BackupCustomHooksClient = grpc.ServerStreamingClient[BackupCustomHooksResponse]

func (c *repositoryServiceClient) GetCustomHooks(ctx context.Context, in *GetCustomHooksRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetCustomHooksResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[15], RepositoryService_GetCustomHooks_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetCustomHooksRequest, GetCustomHooksResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetCustomHooksClient = grpc.ServerStreamingClient[GetCustomHooksResponse]

func (c *repositoryServiceClient) GetObjectDirectorySize(ctx context.Context, in *GetObjectDirectorySizeRequest, opts ...grpc.CallOption) (*GetObjectDirectorySizeResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetObjectDirectorySizeResponse)
	err := c.cc.Invoke(ctx, RepositoryService_GetObjectDirectorySize_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RemoveRepository(ctx context.Context, in *RemoveRepositoryRequest, opts ...grpc.CallOption) (*RemoveRepositoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RemoveRepositoryResponse)
	err := c.cc.Invoke(ctx, RepositoryService_RemoveRepository_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) ReplicateRepository(ctx context.Context, in *ReplicateRepositoryRequest, opts ...grpc.CallOption) (*ReplicateRepositoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReplicateRepositoryResponse)
	err := c.cc.Invoke(ctx, RepositoryService_ReplicateRepository_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) OptimizeRepository(ctx context.Context, in *OptimizeRepositoryRequest, opts ...grpc.CallOption) (*OptimizeRepositoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(OptimizeRepositoryResponse)
	err := c.cc.Invoke(ctx, RepositoryService_OptimizeRepository_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) PruneUnreachableObjects(ctx context.Context, in *PruneUnreachableObjectsRequest, opts ...grpc.CallOption) (*PruneUnreachableObjectsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PruneUnreachableObjectsResponse)
	err := c.cc.Invoke(ctx, RepositoryService_PruneUnreachableObjects_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) BackupRepository(ctx context.Context, in *BackupRepositoryRequest, opts ...grpc.CallOption) (*BackupRepositoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BackupRepositoryResponse)
	err := c.cc.Invoke(ctx, RepositoryService_BackupRepository_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) RestoreRepository(ctx context.Context, in *RestoreRepositoryRequest, opts ...grpc.CallOption) (*RestoreRepositoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RestoreRepositoryResponse)
	err := c.cc.Invoke(ctx, RepositoryService_RestoreRepository_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) GetFileAttributes(ctx context.Context, in *GetFileAttributesRequest, opts ...grpc.CallOption) (*GetFileAttributesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetFileAttributesResponse)
	err := c.cc.Invoke(ctx, RepositoryService_GetFileAttributes_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryServiceClient) FastExport(ctx context.Context, in *FastExportRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FastExportResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RepositoryService_ServiceDesc.Streams[16], RepositoryService_FastExport_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[FastExportRequest, FastExportResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_FastExportClient = grpc.ServerStreamingClient[FastExportResponse]

func (c *repositoryServiceClient) MigrateReferenceBackend(ctx context.Context, in *MigrateReferenceBackendRequest, opts ...grpc.CallOption) (*MigrateReferenceBackendResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MigrateReferenceBackendResponse)
	err := c.cc.Invoke(ctx, RepositoryService_MigrateReferenceBackend_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RepositoryServiceServer is the server API for RepositoryService service.
// All implementations must embed UnimplementedRepositoryServiceServer
// for forward compatibility.
//
// RepositoryService is a service providing RPCs accessing repositories as a whole.
type RepositoryServiceServer interface {
	// RepositoryExists returns whether a given repository exists.
	RepositoryExists(context.Context, *RepositoryExistsRequest) (*RepositoryExistsResponse, error)
	// RepositorySize returns information on the complete on-disk repository size. If you need more
	// detailed information about the size of various sub-structures you should instead use the
	// repositoryInfo RPC.
	RepositorySize(context.Context, *RepositorySizeRequest) (*RepositorySizeResponse, error)
	// RepositoryInfo returns detailed information about a repository and its data structures.
	RepositoryInfo(context.Context, *RepositoryInfoRequest) (*RepositoryInfoResponse, error)
	// ObjectsSize calculates the total on-disk object size of reachable objects in bytes. In contrast
	// to RepositorySize and RepositoryInfo, this RPC performs a graph walk of the specified revisions
	// and will thus return an accurate view of how large the accumulated on-disk size of reachable
	// objects is.
	//
	// As this RPC needs to perform a revision walk, it is significantly more expensive than the RPCs
	// which simply check the size of on-disk data structures. On the other hand, it allows the caller
	// to accurately compute the size of objects in a way that is at least somewhat detached from the
	// on-disk representation:
	//
	//   - Objects which exist in multiple packfiles will not be double-counted.
	//   - Objects which aren't reachable will not be accounted for.
	//   - It is possible to only account for a subset of references, e.g. only those that an admin
	//     would have direct control over.
	//
	// It is thus recommended to use this RPC whenever you want to calculate sizes which will end up
	// being shown to the user.
	//
	// Note that the size is still bound to change when repositories are getting repacked and thus
	// cannot be considered to be stable. This is because the on-disk size of any object can change
	// depending on how Git decides to deltify it in a packfile. Thus, when a repack would cause a
	// different delta base to be picked, the actual on-disk size of any given object may change.
	ObjectsSize(grpc.ClientStreamingServer[ObjectsSizeRequest, ObjectsSizeResponse]) error
	// ObjectFormat determines the object format that is being used by the repository.
	ObjectFormat(context.Context, *ObjectFormatRequest) (*ObjectFormatResponse, error)
	// FetchRemote fetches references from a remote repository into the local
	// repository. The remote can be fetched via HTTP or SSH depending on the
	// request options provided.
	FetchRemote(context.Context, *FetchRemoteRequest) (*FetchRemoteResponse, error)
	// CreateRepository creates a new empty repository.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*CreateRepositoryResponse, error)
	// GetArchive produces and returns an archive of a repository.
	GetArchive(*GetArchiveRequest, grpc.ServerStreamingServer[GetArchiveResponse]) error
	// HasLocalBranches returns whether the given repo contains any branches.
	HasLocalBranches(context.Context, *HasLocalBranchesRequest) (*HasLocalBranchesResponse, error)
	// FetchSourceBranch fetches a branch from a second (potentially remote)
	// repository into the given repository.
	FetchSourceBranch(context.Context, *FetchSourceBranchRequest) (*FetchSourceBranchResponse, error)
	// Fsck checks the repository for consistency via git-fsck(1). This can be used to check for
	// repository corruption.
	Fsck(context.Context, *FsckRequest) (*FsckResponse, error)
	// WriteRef creates or updates a ref in a repository to point to a new value.
	// If the request contains object revisions that do not exist in the repository, the RPC returns
	// the NOT_FOUND code with the ReferenceNotFoundError detail.
	WriteRef(context.Context, *WriteRefRequest) (*WriteRefResponse, error)
	// FindMergeBase returns the best common ancestor between two or more commits. Consult the man
	// pages of git-merge-base(1) for more information on how this is calculated.
	FindMergeBase(context.Context, *FindMergeBaseRequest) (*FindMergeBaseResponse, error)
	// CreateFork creates a new repository from a specific source repository. This new repository will
	// have the same branches and tags as the source repository. Internal references will not be
	// recreated in the forked repository.
	//
	// all objects of the source repository will be duplicated, that is there are no space savings by
	// creating the repository like this. The newly created repository does not join the object pool
	// of the source repository, if there is any.
	CreateFork(context.Context, *CreateForkRequest) (*CreateForkResponse, error)
	// CreateRepositoryFromURL creates a new repo and seeds it with the contents of an existing Git repo
	// reachable at the provided URL.
	CreateRepositoryFromURL(context.Context, *CreateRepositoryFromURLRequest) (*CreateRepositoryFromURLResponse, error)
	// CreateBundle creates a bundle from all refs
	CreateBundle(*CreateBundleRequest, grpc.ServerStreamingServer[CreateBundleResponse]) error
	// CreateBundleFromRefList creates a bundle from a stream of ref patterns.
	// When the bundle would be empty the FailedPrecondition error code is returned.
	CreateBundleFromRefList(grpc.BidiStreamingServer[CreateBundleFromRefListRequest, CreateBundleFromRefListResponse]) error
	// GenerateBundleURI generates a bundle on the server for bundle-URI use.
	GenerateBundleURI(context.Context, *GenerateBundleURIRequest) (*GenerateBundleURIResponse, error)
	// FetchBundle fetches references from a bundle into the local repository.
	// refs will be mirrored to the target repository with the refspec
	// "+refs/*:refs/*" and refs that do not exist in the bundle will be removed.
	FetchBundle(grpc.ClientStreamingServer[FetchBundleRequest, FetchBundleResponse]) error
	// CreateRepositoryFromBundle creates a Git repository at the specified storage and path, if it
	// does not already exist, from the provided Git bundle.
	CreateRepositoryFromBundle(grpc.ClientStreamingServer[CreateRepositoryFromBundleRequest, CreateRepositoryFromBundleResponse]) error
	// GetConfig reads the target repository's gitconfig and streams its contents
	// back. Returns a NotFound error in case no gitconfig was found.
	GetConfig(*GetConfigRequest, grpc.ServerStreamingServer[GetConfigResponse]) error
	// FindLicense looks in the given repository and attempts to detect all the
	// details about the license used in the repository.
	FindLicense(context.Context, *FindLicenseRequest) (*FindLicenseResponse, error)
	// Deprecated: Do not use.
	// GetInfoAttributes reads the contents from info/attributes.
	// This RPC will be removed in 17.0.
	GetInfoAttributes(*GetInfoAttributesRequest, grpc.ServerStreamingServer[GetInfoAttributesResponse]) error
	// CalculateChecksum returns a checksum of the repository by hashing its references. Refs
	// outside of well-known namespaces are not considered when computing the checksum.
	CalculateChecksum(context.Context, *CalculateChecksumRequest) (*CalculateChecksumResponse, error)
	// GetSnapshot returns a snapshot of the repository. A snapshot comprises all Git references
	// and objects required to recreate the state of a repository at a point in time.
	GetSnapshot(*GetSnapshotRequest, grpc.ServerStreamingServer[GetSnapshotResponse]) error
	// CreateRepositoryFromSnapshot creates a new repository based on a snapshot created with
	// the GetSnapshot RPC. The snapshot is fetched via HTTP.
	//
	// Due to the inherent structure of the TAR format, it's challenging to definitively verify
	// if a provided TAR file is complete or truncated/malformed. While basic integrity checks
	// are performed, users should ensure the completeness and integrity of their TAR files.
	CreateRepositoryFromSnapshot(context.Context, *CreateRepositoryFromSnapshotRequest) (*CreateRepositoryFromSnapshotResponse, error)
	// GetRawChanges returns metadata in raw format on the changes between two revisions.
	GetRawChanges(*GetRawChangesRequest, grpc.ServerStreamingServer[GetRawChangesResponse]) error
	// SearchFilesByContent searches files in the repository using the provided grep pattern.
	// For each result, the matched line is returned along with the two previous and next lines.
	SearchFilesByContent(*SearchFilesByContentRequest, grpc.ServerStreamingServer[SearchFilesByContentResponse]) error
	// SearchFilesByName searches files in the repository based on its name and an
	// optional filter.
	SearchFilesByName(*SearchFilesByNameRequest, grpc.ServerStreamingServer[SearchFilesByNameResponse]) error
	// Deprecated: Do not use.
	// RestoreCustomHooks sets the git hooks for a repository. The hooks are sent
	// in a tar archive containing a `custom_hooks` directory. This directory is
	// ultimately extracted to the repository.
	RestoreCustomHooks(grpc.ClientStreamingServer[RestoreCustomHooksRequest, RestoreCustomHooksResponse]) error
	// SetCustomHooks sets the git hooks for a repository. The hooks are sent in a
	// tar archive containing a `custom_hooks` directory (i.e. the response from the
	// GetCustomHooksResponse RPC. This directory will be extracted into the repository.
	SetCustomHooks(grpc.ClientStreamingServer[SetCustomHooksRequest, SetCustomHooksResponse]) error
	// Deprecated: Do not use.
	// BackupCustomHooks fetches the git hooks for a repository. The hooks are
	// sent in a tar archive containing a `custom_hooks` directory. If no hooks
	// are present in the repository, the response will have no data.
	BackupCustomHooks(*BackupCustomHooksRequest, grpc.ServerStreamingServer[BackupCustomHooksResponse]) error
	// GetCustomHooks fetches the git hooks for a repository. The hooks are sent
	// in a tar archive containing a `custom_hooks` directory. If no hooks are
	// present in the repository, the response will have no data.
	GetCustomHooks(*GetCustomHooksRequest, grpc.ServerStreamingServer[GetCustomHooksResponse]) error
	// GetObjectDirectorySize returns the size in kibibytes of the object directory of a repository.
	GetObjectDirectorySize(context.Context, *GetObjectDirectorySizeRequest) (*GetObjectDirectorySizeResponse, error)
	// RemoveRepository will move the repository to `+gitaly/tmp/<relative_path>_removed` and
	// eventually remove it. This ensures that even on networked filesystems the
	// data is actually removed even if there's someone still handling the data.
	RemoveRepository(context.Context, *RemoveRepositoryRequest) (*RemoveRepositoryResponse, error)
	// ReplicateRepository replicates data from a source repository to target repository. On the
	// target repository, this operation ensures synchronization of the following components:
	//
	// - Git config
	// - Git attributes
	// - Custom Git hooks,
	// - References and objects
	// - (Optional) Object deduplication network membership
	ReplicateRepository(context.Context, *ReplicateRepositoryRequest) (*ReplicateRepositoryResponse, error)
	// OptimizeRepository performs all maintenance tasks in a repository to keep
	// it in an efficient state. It cleans up stale data, repacks objects,
	// updates auxiliary caches like commit-graphs and packs references. The
	// optimizations performed are based on heuristics and will adapt to the
	// repository's size. This RPC call is designed as a black-box such that
	// Gitaly has complete control of the on-disk state of repositories.
	OptimizeRepository(context.Context, *OptimizeRepositoryRequest) (*OptimizeRepositoryResponse, error)
	// PruneUnreachableObjects will prune all objects which aren't reachable from
	// the repository's current set of references. Because pruning can only
	// happen for objects which aren't packed, you are required to first run
	// OptimizeRepository to explode any unreachable objects into loose objects.
	//
	// Furthermore, this RPC call has a grace period of 30 minutes: any
	// unreachable loose objects must not have been accessed or modified in the
	// last 30 minutes. This is a hard requirement to avoid repository corruption.
	//
	// to make proper use of this RPC you thus need to call OptimizeRepository,
	// wait 30 minutes, and then call PruneUnreachableObjects.
	PruneUnreachableObjects(context.Context, *PruneUnreachableObjectsRequest) (*PruneUnreachableObjectsResponse, error)
	// BackupRepository creates a full or incremental backup streamed directly to
	// object-storage. The backup is created synchronously. The destination must
	// be configured in config.backup.go_cloud_url
	BackupRepository(context.Context, *BackupRepositoryRequest) (*BackupRepositoryResponse, error)
	// RestoreRepository restores a backup streamed directly from object-storage.
	// The repository is restored synchronously. The source object-storage must
	// be configured in config.backup.go_cloud_url
	RestoreRepository(context.Context, *RestoreRepositoryRequest) (*RestoreRepositoryResponse, error)
	// GetFileAttributes queries given file attributes as specified in .gitattributes file
	GetFileAttributes(context.Context, *GetFileAttributesRequest) (*GetFileAttributesResponse, error)
	// FastExport runs git-fast-export on the repository, streaming the data back through the response
	FastExport(*FastExportRequest, grpc.ServerStreamingServer[FastExportResponse]) error
	// MigrateReferenceBackend allows migrating a repository between the different Git
	// reference backends. Transactions must be enabled.
	MigrateReferenceBackend(context.Context, *MigrateReferenceBackendRequest) (*MigrateReferenceBackendResponse, error)
	mustEmbedUnimplementedRepositoryServiceServer()
}

// UnimplementedRepositoryServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRepositoryServiceServer struct{}

func (UnimplementedRepositoryServiceServer) RepositoryExists(context.Context, *RepositoryExistsRequest) (*RepositoryExistsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepositoryExists not implemented")
}
func (UnimplementedRepositoryServiceServer) RepositorySize(context.Context, *RepositorySizeRequest) (*RepositorySizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepositorySize not implemented")
}
func (UnimplementedRepositoryServiceServer) RepositoryInfo(context.Context, *RepositoryInfoRequest) (*RepositoryInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RepositoryInfo not implemented")
}
func (UnimplementedRepositoryServiceServer) ObjectsSize(grpc.ClientStreamingServer[ObjectsSizeRequest, ObjectsSizeResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ObjectsSize not implemented")
}
func (UnimplementedRepositoryServiceServer) ObjectFormat(context.Context, *ObjectFormatRequest) (*ObjectFormatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ObjectFormat not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchRemote(context.Context, *FetchRemoteRequest) (*FetchRemoteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchRemote not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*CreateRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) GetArchive(*GetArchiveRequest, grpc.ServerStreamingServer[GetArchiveResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetArchive not implemented")
}
func (UnimplementedRepositoryServiceServer) HasLocalBranches(context.Context, *HasLocalBranchesRequest) (*HasLocalBranchesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HasLocalBranches not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchSourceBranch(context.Context, *FetchSourceBranchRequest) (*FetchSourceBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchSourceBranch not implemented")
}
func (UnimplementedRepositoryServiceServer) Fsck(context.Context, *FsckRequest) (*FsckResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Fsck not implemented")
}
func (UnimplementedRepositoryServiceServer) WriteRef(context.Context, *WriteRefRequest) (*WriteRefResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteRef not implemented")
}
func (UnimplementedRepositoryServiceServer) FindMergeBase(context.Context, *FindMergeBaseRequest) (*FindMergeBaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindMergeBase not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateFork(context.Context, *CreateForkRequest) (*CreateForkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFork not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromURL(context.Context, *CreateRepositoryFromURLRequest) (*CreateRepositoryFromURLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepositoryFromURL not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateBundle(*CreateBundleRequest, grpc.ServerStreamingServer[CreateBundleResponse]) error {
	return status.Errorf(codes.Unimplemented, "method CreateBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateBundleFromRefList(grpc.BidiStreamingServer[CreateBundleFromRefListRequest, CreateBundleFromRefListResponse]) error {
	return status.Errorf(codes.Unimplemented, "method CreateBundleFromRefList not implemented")
}
func (UnimplementedRepositoryServiceServer) GenerateBundleURI(context.Context, *GenerateBundleURIRequest) (*GenerateBundleURIResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateBundleURI not implemented")
}
func (UnimplementedRepositoryServiceServer) FetchBundle(grpc.ClientStreamingServer[FetchBundleRequest, FetchBundleResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FetchBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromBundle(grpc.ClientStreamingServer[CreateRepositoryFromBundleRequest, CreateRepositoryFromBundleResponse]) error {
	return status.Errorf(codes.Unimplemented, "method CreateRepositoryFromBundle not implemented")
}
func (UnimplementedRepositoryServiceServer) GetConfig(*GetConfigRequest, grpc.ServerStreamingServer[GetConfigResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (UnimplementedRepositoryServiceServer) FindLicense(context.Context, *FindLicenseRequest) (*FindLicenseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindLicense not implemented")
}
func (UnimplementedRepositoryServiceServer) GetInfoAttributes(*GetInfoAttributesRequest, grpc.ServerStreamingServer[GetInfoAttributesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetInfoAttributes not implemented")
}
func (UnimplementedRepositoryServiceServer) CalculateChecksum(context.Context, *CalculateChecksumRequest) (*CalculateChecksumResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateChecksum not implemented")
}
func (UnimplementedRepositoryServiceServer) GetSnapshot(*GetSnapshotRequest, grpc.ServerStreamingServer[GetSnapshotResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (UnimplementedRepositoryServiceServer) CreateRepositoryFromSnapshot(context.Context, *CreateRepositoryFromSnapshotRequest) (*CreateRepositoryFromSnapshotResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepositoryFromSnapshot not implemented")
}
func (UnimplementedRepositoryServiceServer) GetRawChanges(*GetRawChangesRequest, grpc.ServerStreamingServer[GetRawChangesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetRawChanges not implemented")
}
func (UnimplementedRepositoryServiceServer) SearchFilesByContent(*SearchFilesByContentRequest, grpc.ServerStreamingServer[SearchFilesByContentResponse]) error {
	return status.Errorf(codes.Unimplemented, "method SearchFilesByContent not implemented")
}
func (UnimplementedRepositoryServiceServer) SearchFilesByName(*SearchFilesByNameRequest, grpc.ServerStreamingServer[SearchFilesByNameResponse]) error {
	return status.Errorf(codes.Unimplemented, "method SearchFilesByName not implemented")
}
func (UnimplementedRepositoryServiceServer) RestoreCustomHooks(grpc.ClientStreamingServer[RestoreCustomHooksRequest, RestoreCustomHooksResponse]) error {
	return status.Errorf(codes.Unimplemented, "method RestoreCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) SetCustomHooks(grpc.ClientStreamingServer[SetCustomHooksRequest, SetCustomHooksResponse]) error {
	return status.Errorf(codes.Unimplemented, "method SetCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) BackupCustomHooks(*BackupCustomHooksRequest, grpc.ServerStreamingServer[BackupCustomHooksResponse]) error {
	return status.Errorf(codes.Unimplemented, "method BackupCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) GetCustomHooks(*GetCustomHooksRequest, grpc.ServerStreamingServer[GetCustomHooksResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetCustomHooks not implemented")
}
func (UnimplementedRepositoryServiceServer) GetObjectDirectorySize(context.Context, *GetObjectDirectorySizeRequest) (*GetObjectDirectorySizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObjectDirectorySize not implemented")
}
func (UnimplementedRepositoryServiceServer) RemoveRepository(context.Context, *RemoveRepositoryRequest) (*RemoveRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) ReplicateRepository(context.Context, *ReplicateRepositoryRequest) (*ReplicateRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicateRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) OptimizeRepository(context.Context, *OptimizeRepositoryRequest) (*OptimizeRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OptimizeRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) PruneUnreachableObjects(context.Context, *PruneUnreachableObjectsRequest) (*PruneUnreachableObjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PruneUnreachableObjects not implemented")
}
func (UnimplementedRepositoryServiceServer) BackupRepository(context.Context, *BackupRepositoryRequest) (*BackupRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BackupRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) RestoreRepository(context.Context, *RestoreRepositoryRequest) (*RestoreRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreRepository not implemented")
}
func (UnimplementedRepositoryServiceServer) GetFileAttributes(context.Context, *GetFileAttributesRequest) (*GetFileAttributesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFileAttributes not implemented")
}
func (UnimplementedRepositoryServiceServer) FastExport(*FastExportRequest, grpc.ServerStreamingServer[FastExportResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FastExport not implemented")
}
func (UnimplementedRepositoryServiceServer) MigrateReferenceBackend(context.Context, *MigrateReferenceBackendRequest) (*MigrateReferenceBackendResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MigrateReferenceBackend not implemented")
}
func (UnimplementedRepositoryServiceServer) mustEmbedUnimplementedRepositoryServiceServer() {}
func (UnimplementedRepositoryServiceServer) testEmbeddedByValue()                           {}

// UnsafeRepositoryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RepositoryServiceServer will
// result in compilation errors.
type UnsafeRepositoryServiceServer interface {
	mustEmbedUnimplementedRepositoryServiceServer()
}

func RegisterRepositoryServiceServer(s grpc.ServiceRegistrar, srv RepositoryServiceServer) {
	// If the following call pancis, it indicates UnimplementedRepositoryServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&RepositoryService_ServiceDesc, srv)
}

func _RepositoryService_RepositoryExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositoryExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepositoryExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_RepositoryExists_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepositoryExists(ctx, req.(*RepositoryExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RepositorySize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositorySizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepositorySize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_RepositorySize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepositorySize(ctx, req.(*RepositorySizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RepositoryInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositoryInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RepositoryInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_RepositoryInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RepositoryInfo(ctx, req.(*RepositoryInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_ObjectsSize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).ObjectsSize(&grpc.GenericServerStream[ObjectsSizeRequest, ObjectsSizeResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_ObjectsSizeServer = grpc.ClientStreamingServer[ObjectsSizeRequest, ObjectsSizeResponse]

func _RepositoryService_ObjectFormat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ObjectFormatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).ObjectFormat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_ObjectFormat_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).ObjectFormat(ctx, req.(*ObjectFormatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FetchRemote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchRemoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FetchRemote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_FetchRemote_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FetchRemote(ctx, req.(*FetchRemoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_CreateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetArchive_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetArchiveRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetArchive(m, &grpc.GenericServerStream[GetArchiveRequest, GetArchiveResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetArchiveServer = grpc.ServerStreamingServer[GetArchiveResponse]

func _RepositoryService_HasLocalBranches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasLocalBranchesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).HasLocalBranches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_HasLocalBranches_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).HasLocalBranches(ctx, req.(*HasLocalBranchesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FetchSourceBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchSourceBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FetchSourceBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_FetchSourceBranch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FetchSourceBranch(ctx, req.(*FetchSourceBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_Fsck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FsckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).Fsck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_Fsck_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).Fsck(ctx, req.(*FsckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_WriteRef_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteRefRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).WriteRef(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_WriteRef_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).WriteRef(ctx, req.(*WriteRefRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FindMergeBase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindMergeBaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FindMergeBase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_FindMergeBase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FindMergeBase(ctx, req.(*FindMergeBaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateFork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateForkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateFork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_CreateFork_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateFork(ctx, req.(*CreateForkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateRepositoryFromURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryFromURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepositoryFromURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_CreateRepositoryFromURL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepositoryFromURL(ctx, req.(*CreateRepositoryFromURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_CreateBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CreateBundleRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).CreateBundle(m, &grpc.GenericServerStream[CreateBundleRequest, CreateBundleResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_CreateBundleServer = grpc.ServerStreamingServer[CreateBundleResponse]

func _RepositoryService_CreateBundleFromRefList_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).CreateBundleFromRefList(&grpc.GenericServerStream[CreateBundleFromRefListRequest, CreateBundleFromRefListResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_CreateBundleFromRefListServer = grpc.BidiStreamingServer[CreateBundleFromRefListRequest, CreateBundleFromRefListResponse]

func _RepositoryService_GenerateBundleURI_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateBundleURIRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).GenerateBundleURI(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_GenerateBundleURI_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).GenerateBundleURI(ctx, req.(*GenerateBundleURIRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FetchBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).FetchBundle(&grpc.GenericServerStream[FetchBundleRequest, FetchBundleResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_FetchBundleServer = grpc.ClientStreamingServer[FetchBundleRequest, FetchBundleResponse]

func _RepositoryService_CreateRepositoryFromBundle_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).CreateRepositoryFromBundle(&grpc.GenericServerStream[CreateRepositoryFromBundleRequest, CreateRepositoryFromBundleResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_CreateRepositoryFromBundleServer = grpc.ClientStreamingServer[CreateRepositoryFromBundleRequest, CreateRepositoryFromBundleResponse]

func _RepositoryService_GetConfig_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetConfigRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetConfig(m, &grpc.GenericServerStream[GetConfigRequest, GetConfigResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetConfigServer = grpc.ServerStreamingServer[GetConfigResponse]

func _RepositoryService_FindLicense_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).FindLicense(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_FindLicense_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).FindLicense(ctx, req.(*FindLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetInfoAttributes_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetInfoAttributesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetInfoAttributes(m, &grpc.GenericServerStream[GetInfoAttributesRequest, GetInfoAttributesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetInfoAttributesServer = grpc.ServerStreamingServer[GetInfoAttributesResponse]

func _RepositoryService_CalculateChecksum_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateChecksumRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CalculateChecksum(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_CalculateChecksum_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CalculateChecksum(ctx, req.(*CalculateChecksumRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetSnapshot_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetSnapshotRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetSnapshot(m, &grpc.GenericServerStream[GetSnapshotRequest, GetSnapshotResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetSnapshotServer = grpc.ServerStreamingServer[GetSnapshotResponse]

func _RepositoryService_CreateRepositoryFromSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryFromSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).CreateRepositoryFromSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_CreateRepositoryFromSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).CreateRepositoryFromSnapshot(ctx, req.(*CreateRepositoryFromSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetRawChanges_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetRawChangesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetRawChanges(m, &grpc.GenericServerStream[GetRawChangesRequest, GetRawChangesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetRawChangesServer = grpc.ServerStreamingServer[GetRawChangesResponse]

func _RepositoryService_SearchFilesByContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SearchFilesByContentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).SearchFilesByContent(m, &grpc.GenericServerStream[SearchFilesByContentRequest, SearchFilesByContentResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_SearchFilesByContentServer = grpc.ServerStreamingServer[SearchFilesByContentResponse]

func _RepositoryService_SearchFilesByName_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SearchFilesByNameRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).SearchFilesByName(m, &grpc.GenericServerStream[SearchFilesByNameRequest, SearchFilesByNameResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_SearchFilesByNameServer = grpc.ServerStreamingServer[SearchFilesByNameResponse]

func _RepositoryService_RestoreCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).RestoreCustomHooks(&grpc.GenericServerStream[RestoreCustomHooksRequest, RestoreCustomHooksResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_RestoreCustomHooksServer = grpc.ClientStreamingServer[RestoreCustomHooksRequest, RestoreCustomHooksResponse]

func _RepositoryService_SetCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RepositoryServiceServer).SetCustomHooks(&grpc.GenericServerStream[SetCustomHooksRequest, SetCustomHooksResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_SetCustomHooksServer = grpc.ClientStreamingServer[SetCustomHooksRequest, SetCustomHooksResponse]

func _RepositoryService_BackupCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BackupCustomHooksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).BackupCustomHooks(m, &grpc.GenericServerStream[BackupCustomHooksRequest, BackupCustomHooksResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_BackupCustomHooksServer = grpc.ServerStreamingServer[BackupCustomHooksResponse]

func _RepositoryService_GetCustomHooks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetCustomHooksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).GetCustomHooks(m, &grpc.GenericServerStream[GetCustomHooksRequest, GetCustomHooksResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_GetCustomHooksServer = grpc.ServerStreamingServer[GetCustomHooksResponse]

func _RepositoryService_GetObjectDirectorySize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetObjectDirectorySizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).GetObjectDirectorySize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_GetObjectDirectorySize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).GetObjectDirectorySize(ctx, req.(*GetObjectDirectorySizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RemoveRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RemoveRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_RemoveRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RemoveRepository(ctx, req.(*RemoveRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_ReplicateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplicateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).ReplicateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_ReplicateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).ReplicateRepository(ctx, req.(*ReplicateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_OptimizeRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OptimizeRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).OptimizeRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_OptimizeRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).OptimizeRepository(ctx, req.(*OptimizeRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_PruneUnreachableObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PruneUnreachableObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).PruneUnreachableObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_PruneUnreachableObjects_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).PruneUnreachableObjects(ctx, req.(*PruneUnreachableObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_BackupRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).BackupRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_BackupRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).BackupRepository(ctx, req.(*BackupRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_RestoreRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).RestoreRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_RestoreRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).RestoreRepository(ctx, req.(*RestoreRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_GetFileAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFileAttributesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).GetFileAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_GetFileAttributes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).GetFileAttributes(ctx, req.(*GetFileAttributesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryService_FastExport_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FastExportRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RepositoryServiceServer).FastExport(m, &grpc.GenericServerStream[FastExportRequest, FastExportResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RepositoryService_FastExportServer = grpc.ServerStreamingServer[FastExportResponse]

func _RepositoryService_MigrateReferenceBackend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MigrateReferenceBackendRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryServiceServer).MigrateReferenceBackend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RepositoryService_MigrateReferenceBackend_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryServiceServer).MigrateReferenceBackend(ctx, req.(*MigrateReferenceBackendRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RepositoryService_ServiceDesc is the grpc.ServiceDesc for RepositoryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RepositoryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RepositoryService",
	HandlerType: (*RepositoryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RepositoryExists",
			Handler:    _RepositoryService_RepositoryExists_Handler,
		},
		{
			MethodName: "RepositorySize",
			Handler:    _RepositoryService_RepositorySize_Handler,
		},
		{
			MethodName: "RepositoryInfo",
			Handler:    _RepositoryService_RepositoryInfo_Handler,
		},
		{
			MethodName: "ObjectFormat",
			Handler:    _RepositoryService_ObjectFormat_Handler,
		},
		{
			MethodName: "FetchRemote",
			Handler:    _RepositoryService_FetchRemote_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _RepositoryService_CreateRepository_Handler,
		},
		{
			MethodName: "HasLocalBranches",
			Handler:    _RepositoryService_HasLocalBranches_Handler,
		},
		{
			MethodName: "FetchSourceBranch",
			Handler:    _RepositoryService_FetchSourceBranch_Handler,
		},
		{
			MethodName: "Fsck",
			Handler:    _RepositoryService_Fsck_Handler,
		},
		{
			MethodName: "WriteRef",
			Handler:    _RepositoryService_WriteRef_Handler,
		},
		{
			MethodName: "FindMergeBase",
			Handler:    _RepositoryService_FindMergeBase_Handler,
		},
		{
			MethodName: "CreateFork",
			Handler:    _RepositoryService_CreateFork_Handler,
		},
		{
			MethodName: "CreateRepositoryFromURL",
			Handler:    _RepositoryService_CreateRepositoryFromURL_Handler,
		},
		{
			MethodName: "GenerateBundleURI",
			Handler:    _RepositoryService_GenerateBundleURI_Handler,
		},
		{
			MethodName: "FindLicense",
			Handler:    _RepositoryService_FindLicense_Handler,
		},
		{
			MethodName: "CalculateChecksum",
			Handler:    _RepositoryService_CalculateChecksum_Handler,
		},
		{
			MethodName: "CreateRepositoryFromSnapshot",
			Handler:    _RepositoryService_CreateRepositoryFromSnapshot_Handler,
		},
		{
			MethodName: "GetObjectDirectorySize",
			Handler:    _RepositoryService_GetObjectDirectorySize_Handler,
		},
		{
			MethodName: "RemoveRepository",
			Handler:    _RepositoryService_RemoveRepository_Handler,
		},
		{
			MethodName: "ReplicateRepository",
			Handler:    _RepositoryService_ReplicateRepository_Handler,
		},
		{
			MethodName: "OptimizeRepository",
			Handler:    _RepositoryService_OptimizeRepository_Handler,
		},
		{
			MethodName: "PruneUnreachableObjects",
			Handler:    _RepositoryService_PruneUnreachableObjects_Handler,
		},
		{
			MethodName: "BackupRepository",
			Handler:    _RepositoryService_BackupRepository_Handler,
		},
		{
			MethodName: "RestoreRepository",
			Handler:    _RepositoryService_RestoreRepository_Handler,
		},
		{
			MethodName: "GetFileAttributes",
			Handler:    _RepositoryService_GetFileAttributes_Handler,
		},
		{
			MethodName: "MigrateReferenceBackend",
			Handler:    _RepositoryService_MigrateReferenceBackend_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ObjectsSize",
			Handler:       _RepositoryService_ObjectsSize_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "GetArchive",
			Handler:       _RepositoryService_GetArchive_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CreateBundle",
			Handler:       _RepositoryService_CreateBundle_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CreateBundleFromRefList",
			Handler:       _RepositoryService_CreateBundleFromRefList_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "FetchBundle",
			Handler:       _RepositoryService_FetchBundle_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "CreateRepositoryFromBundle",
			Handler:       _RepositoryService_CreateRepositoryFromBundle_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "GetConfig",
			Handler:       _RepositoryService_GetConfig_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetInfoAttributes",
			Handler:       _RepositoryService_GetInfoAttributes_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetSnapshot",
			Handler:       _RepositoryService_GetSnapshot_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetRawChanges",
			Handler:       _RepositoryService_GetRawChanges_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SearchFilesByContent",
			Handler:       _RepositoryService_SearchFilesByContent_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SearchFilesByName",
			Handler:       _RepositoryService_SearchFilesByName_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RestoreCustomHooks",
			Handler:       _RepositoryService_RestoreCustomHooks_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "SetCustomHooks",
			Handler:       _RepositoryService_SetCustomHooks_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "BackupCustomHooks",
			Handler:       _RepositoryService_BackupCustomHooks_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetCustomHooks",
			Handler:       _RepositoryService_GetCustomHooks_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FastExport",
			Handler:       _RepositoryService_FastExport_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "repository.proto",
}
