/* window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from window.vala, do not modify */

/* SPDX-FileCopyrightText: 2022-2026 Mahjongg Contributors*/
/* SPDX-License-Identifier: GPL-2.0-or-later*/

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAHJONGG_WINDOW (mahjongg_window_get_type ())
#define MAHJONGG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAHJONGG_WINDOW, MahjonggWindow))
#define MAHJONGG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAHJONGG_WINDOW, MahjonggWindowClass))
#define IS_MAHJONGG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAHJONGG_WINDOW))
#define IS_MAHJONGG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAHJONGG_WINDOW))
#define MAHJONGG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAHJONGG_WINDOW, MahjonggWindowClass))

typedef struct _MahjonggWindow MahjonggWindow;
typedef struct _MahjonggWindowClass MahjonggWindowClass;
typedef struct _MahjonggWindowPrivate MahjonggWindowPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_PAUSE_OVERLAY (pause_overlay_get_type ())
#define PAUSE_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAUSE_OVERLAY, PauseOverlay))
#define PAUSE_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAUSE_OVERLAY, PauseOverlayClass))
#define IS_PAUSE_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAUSE_OVERLAY))
#define IS_PAUSE_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAUSE_OVERLAY))
#define PAUSE_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAUSE_OVERLAY, PauseOverlayClass))

typedef struct _PauseOverlay PauseOverlay;
typedef struct _PauseOverlayClass PauseOverlayClass;
enum  {
	MAHJONGG_WINDOW_0_PROPERTY,
	MAHJONGG_WINDOW_COMPACT_PROPERTY,
	MAHJONGG_WINDOW_NUM_PROPERTIES
};
static GParamSpec* mahjongg_window_properties[MAHJONGG_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MAPS (maps_get_type ())
#define MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAPS, Maps))
#define MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAPS, MapsClass))
#define IS_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAPS))
#define IS_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAPS))
#define MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAPS, MapsClass))

typedef struct _Maps Maps;
typedef struct _MapsClass MapsClass;

#define MAPS_TYPE_ITERATOR (maps_iterator_get_type ())
#define MAPS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAPS_TYPE_ITERATOR, MapsIterator))
#define MAPS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAPS_TYPE_ITERATOR, MapsIteratorClass))
#define MAPS_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAPS_TYPE_ITERATOR))
#define MAPS_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAPS_TYPE_ITERATOR))
#define MAPS_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAPS_TYPE_ITERATOR, MapsIteratorClass))

typedef struct _MapsIterator MapsIterator;
typedef struct _MapsIteratorClass MapsIteratorClass;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
typedef struct _MapPrivate MapPrivate;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _maps_iterator_unref0(var) ((var == NULL) ? NULL : (var = (maps_iterator_unref (var), NULL)))

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _Block3Data Block3Data;

struct _MahjonggWindow {
	AdwApplicationWindow parent_instance;
	MahjonggWindowPrivate * priv;
};

struct _MahjonggWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _MahjonggWindowPrivate {
	AdwToolbarView* toolbar_view;
	AdwWindowTitle* title_widget;
	GtkMenuButton* menu_button;
	GtkButton* pause_button;
	GtkOverlay* overlay;
	GtkStack* stack;
	GSettings* settings;
	GameView* game_view;
	PauseOverlay* pause_overlay;
	gchar* theme;
	gboolean restore_game;
	guint unset_game_idle;
	gboolean _compact;
};

struct _Map {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	gint h_overhang;
	gint v_overhang;
};

struct _MapClass {
	GTypeClass parent_class;
	void (*finalize) (Map *self);
};

struct _Block3Data {
	int _ref_count_;
	MahjonggWindow* self;
	GameView* previous_game_view;
};

static gint MahjonggWindow_private_offset;
static gpointer mahjongg_window_parent_class = NULL;

VALA_EXTERN GType mahjongg_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MahjonggWindow, g_object_unref)
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN GType pause_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PauseOverlay, g_object_unref)
VALA_EXTERN gpointer maps_ref (gpointer instance);
VALA_EXTERN void maps_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_maps (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_maps (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_maps (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_maps (const GValue* value);
VALA_EXTERN GType maps_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Maps, maps_unref)
VALA_EXTERN MahjonggWindow* mahjongg_window_new (GtkApplication* application,
                                     GSettings* settings,
                                     Maps* maps);
VALA_EXTERN MahjonggWindow* mahjongg_window_construct (GType object_type,
                                           GtkApplication* application,
                                           GSettings* settings,
                                           Maps* maps);
VALA_EXTERN GameView* game_view_new (gboolean using_cairo);
VALA_EXTERN GameView* game_view_construct (GType object_type,
                               gboolean using_cairo);
VALA_EXTERN PauseOverlay* pause_overlay_new (void);
VALA_EXTERN PauseOverlay* pause_overlay_construct (GType object_type);
VALA_EXTERN gpointer maps_iterator_ref (gpointer instance);
VALA_EXTERN void maps_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* maps_param_spec_iterator (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void maps_value_set_iterator (GValue* value,
                              gpointer v_object);
VALA_EXTERN void maps_value_take_iterator (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer maps_value_get_iterator (const GValue* value);
VALA_EXTERN GType maps_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MapsIterator, maps_iterator_unref)
VALA_EXTERN MapsIterator* maps_iterator (Maps* self);
VALA_EXTERN gboolean maps_iterator_next (MapsIterator* self);
VALA_EXTERN gpointer map_ref (gpointer instance);
VALA_EXTERN void map_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_map (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags);
VALA_EXTERN void value_set_map (GValue* value,
                    gpointer v_object);
VALA_EXTERN void value_take_map (GValue* value,
                     gpointer v_object);
VALA_EXTERN gpointer value_get_map (const GValue* value);
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, map_unref)
VALA_EXTERN Map* maps_iterator_get (MapsIterator* self);
VALA_EXTERN gchar* maps_get_map_display_name (Maps* self,
                                  const gchar* score_name);
static void __lambda5_ (MahjonggWindow* self);
VALA_EXTERN gpointer game_ref (gpointer instance);
VALA_EXTERN void game_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_game (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_game (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_game (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_game (const GValue* value);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, game_unref)
VALA_EXTERN Game* game_view_get_game (GameView* self);
VALA_EXTERN void game_set_paused (Game* self,
                      gboolean value);
static void ___lambda5__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda6_ (MahjonggWindow* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda7_ (MahjonggWindow* self);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void mahjongg_window_conf_value_changed_cb (MahjonggWindow* self,
                                            GSettings* settings,
                                            const gchar* key);
static void _mahjongg_window_conf_value_changed_cb_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self);
static void mahjongg_window_update_theme (MahjonggWindow* self,
                                   GameView* previous_game_view);
VALA_EXTERN void mahjongg_window_new_game (MahjonggWindow* self,
                               Game* game,
                               gboolean rotate_map,
                               gboolean restore);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ___lambda8_ (Block3Data* _data3_);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* value);
VALA_EXTERN void game_view_set_theme (GameView* self,
                          const gchar* theme_path,
                          GameView* game_view,
                          const gchar* fallback_theme_path);
static gboolean ____lambda8__gsource_func (gpointer self);
static void mahjongg_window_moved_cb (MahjonggWindow* self);
static void _mahjongg_window_moved_cb_game_moved (Game* _sender,
                                           gpointer self);
static void mahjongg_window_paused_changed_cb (MahjonggWindow* self);
static void _mahjongg_window_paused_changed_cb_game_paused_changed (Game* _sender,
                                                             gpointer self);
static void mahjongg_window_tick_cb (MahjonggWindow* self);
static void _mahjongg_window_tick_cb_game_tick (Game* _sender,
                                         gpointer self);
VALA_EXTERN guint game_get_moves_left (Game* self);
VALA_EXTERN gboolean game_get_paused (Game* self);
VALA_EXTERN void pause_overlay_show (PauseOverlay* self,
                         gboolean resuming_game);
VALA_EXTERN void pause_overlay_hide (PauseOverlay* self);
VALA_EXTERN gdouble game_get_elapsed (Game* self);
VALA_EXTERN gboolean mahjongg_window_get_compact (MahjonggWindow* self);
VALA_EXTERN void mahjongg_window_set_compact (MahjonggWindow* self,
                                  gboolean value);
static void mahjongg_window_finalize (GObject * obj);
static GType mahjongg_window_get_type_once (void);
static void _vala_mahjongg_window_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_mahjongg_window_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
mahjongg_window_get_instance_private (MahjonggWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MahjonggWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda5_ (MahjonggWindow* self)
{
	PauseOverlay* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->pause_overlay;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GameView* _tmp3_;
		Game* _tmp4_;
		Game* _tmp5_;
		GtkMenuButton* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp3_ = self->priv->game_view;
		_tmp4_ = game_view_get_game (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->menu_button;
		_tmp7_ = gtk_menu_button_get_active (_tmp6_);
		_tmp8_ = _tmp7_;
		game_set_paused (_tmp5_, _tmp8_);
	}
}

static void
___lambda5__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda5_ ((MahjonggWindow*) self);
}

static void
__lambda6_ (MahjonggWindow* self)
{
	PauseOverlay* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->pause_overlay;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GameView* _tmp3_;
		Game* _tmp4_;
		Game* _tmp5_;
		AdwDialog* _tmp6_;
		AdwDialog* _tmp7_;
		_tmp3_ = self->priv->game_view;
		_tmp4_ = game_view_get_game (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = adw_application_window_get_visible_dialog ((AdwApplicationWindow*) self);
		_tmp7_ = _tmp6_;
		game_set_paused (_tmp5_, _tmp7_ != NULL);
	}
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((MahjonggWindow*) self);
}

static void
__lambda7_ (MahjonggWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_object_get ((GtkWindow*) self, "suspended", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GameView* _tmp2_;
		Game* _tmp3_;
		Game* _tmp4_;
		_tmp2_ = self->priv->game_view;
		_tmp3_ = game_view_get_game (_tmp2_);
		_tmp4_ = _tmp3_;
		game_set_paused (_tmp4_, TRUE);
	}
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ ((MahjonggWindow*) self);
}

static void
_mahjongg_window_conf_value_changed_cb_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self)
{
	mahjongg_window_conf_value_changed_cb ((MahjonggWindow*) self, _sender, key);
}

MahjonggWindow*
mahjongg_window_construct (GType object_type,
                           GtkApplication* application,
                           GSettings* settings,
                           Maps* maps)
{
	MahjonggWindow * self = NULL;
	GSettings* _tmp0_;
	gboolean using_cairo = FALSE;
	const gchar* _tmp1_;
	GtkStack* _tmp2_;
	GameView* _tmp3_;
	GameView* _tmp4_;
	GtkStack* _tmp5_;
	GameView* _tmp6_;
	GameView* _tmp7_;
	PauseOverlay* _tmp9_;
	GtkBuilder* menu_builder = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkBuilder* _tmp14_;
	GtkBuilder* _tmp15_;
	GMenuModel* menu_model = NULL;
	GtkBuilder* _tmp16_;
	GObject* _tmp17_;
	GMenu* layout_menu = NULL;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GMenu* _tmp20_;
	GtkMenuButton* _tmp37_;
	GMenuModel* _tmp38_;
	GtkMenuButton* _tmp39_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (maps != NULL, NULL);
	self = (MahjonggWindow*) g_object_new (object_type, "application", application, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_getenv ("GSK_RENDERER");
	using_cairo = g_strcmp0 (_tmp1_, "cairo") == 0;
	_tmp2_ = self->priv->stack;
	_tmp3_ = game_view_new (using_cairo);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	gtk_stack_add_named (_tmp2_, (GtkWidget*) _tmp4_, "primary");
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->stack;
	_tmp6_ = game_view_new (using_cairo);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_stack_add_named (_tmp5_, (GtkWidget*) _tmp7_, "secondary");
	_g_object_unref0 (_tmp7_);
	if (!using_cairo) {
		GtkStack* _tmp8_;
		_tmp8_ = self->priv->stack;
		gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "tile-filter");
	}
	_tmp9_ = pause_overlay_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->pause_overlay);
	self->priv->pause_overlay = _tmp9_;
	_tmp10_ = g_application_get_resource_base_path ((GApplication*) application);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "/ui/menu.ui", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_builder_new_from_resource (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	menu_builder = _tmp15_;
	_tmp16_ = menu_builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "menu");
	menu_model = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp17_) : NULL;
	_tmp18_ = menu_builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "layout_menu");
	layout_menu = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, g_menu_get_type ()) ? ((GMenu*) _tmp19_) : NULL;
	_tmp20_ = layout_menu;
	g_menu_remove_all (_tmp20_);
	{
		MapsIterator* _map_it = NULL;
		MapsIterator* _tmp21_;
		_tmp21_ = maps_iterator (maps);
		_map_it = _tmp21_;
		while (TRUE) {
			MapsIterator* _tmp22_;
			Map* map = NULL;
			MapsIterator* _tmp23_;
			Map* _tmp24_;
			gchar* menu_label = NULL;
			Map* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			GMenuItem* menu_item = NULL;
			const gchar* _tmp28_;
			GMenuItem* _tmp29_;
			GMenuItem* _tmp30_;
			Map* _tmp31_;
			const gchar* _tmp32_;
			GVariant* _tmp33_;
			GVariant* _tmp34_;
			GMenu* _tmp35_;
			GMenuItem* _tmp36_;
			_tmp22_ = _map_it;
			if (!maps_iterator_next (_tmp22_)) {
				break;
			}
			_tmp23_ = _map_it;
			_tmp24_ = maps_iterator_get (_tmp23_);
			map = _tmp24_;
			_tmp25_ = map;
			_tmp26_ = _tmp25_->score_name;
			_tmp27_ = maps_get_map_display_name (maps, _tmp26_);
			menu_label = _tmp27_;
			_tmp28_ = menu_label;
			_tmp29_ = g_menu_item_new (_tmp28_, NULL);
			menu_item = _tmp29_;
			_tmp30_ = menu_item;
			_tmp31_ = map;
			_tmp32_ = _tmp31_->name;
			_tmp33_ = g_variant_new_string (_tmp32_);
			g_variant_ref_sink (_tmp33_);
			_tmp34_ = _tmp33_;
			g_menu_item_set_action_and_target_value (_tmp30_, "app.layout", _tmp34_);
			_g_variant_unref0 (_tmp34_);
			_tmp35_ = layout_menu;
			_tmp36_ = menu_item;
			g_menu_append_item (_tmp35_, _tmp36_);
			_g_object_unref0 (menu_item);
			_g_free0 (menu_label);
		}
		_maps_iterator_unref0 (_map_it);
	}
	_tmp37_ = self->priv->menu_button;
	_tmp38_ = menu_model;
	gtk_menu_button_set_menu_model (_tmp37_, _tmp38_);
	if (g_str_has_suffix (APP_ID, ".Devel")) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	_tmp39_ = self->priv->menu_button;
	g_signal_connect_object ((GObject*) _tmp39_, "notify::active", (GCallback) ___lambda5__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::visible-dialog", (GCallback) ___lambda6__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::suspended", (GCallback) ___lambda7__g_object_notify, self, 0);
	g_settings_bind (settings, "window-width", (GObject*) self, "default-width", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "window-height", (GObject*) self, "default-height", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, "window-is-maximized", (GObject*) self, "maximized", G_SETTINGS_BIND_DEFAULT);
	g_signal_connect_object (settings, "changed", (GCallback) _mahjongg_window_conf_value_changed_cb_g_settings_changed, self, 0);
	mahjongg_window_update_theme (self, NULL);
	_g_object_unref0 (menu_builder);
	return self;
}

MahjonggWindow*
mahjongg_window_new (GtkApplication* application,
                     GSettings* settings,
                     Maps* maps)
{
	return mahjongg_window_construct (TYPE_MAHJONGG_WINDOW, application, settings, maps);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		MahjonggWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->previous_game_view);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
___lambda8_ (Block3Data* _data3_)
{
	MahjonggWindow* self;
	GameView* _tmp0_;
	GameView* _tmp1_;
	gboolean result;
	self = _data3_->self;
	self->priv->unset_game_idle = (guint) 0;
	_tmp0_ = _data3_->previous_game_view;
	game_view_set_game (_tmp0_, NULL);
	_tmp1_ = _data3_->previous_game_view;
	game_view_set_theme (_tmp1_, NULL, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
____lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda8_ (self);
	return result;
}

static void
_mahjongg_window_moved_cb_game_moved (Game* _sender,
                                      gpointer self)
{
	mahjongg_window_moved_cb ((MahjonggWindow*) self);
}

static void
_mahjongg_window_paused_changed_cb_game_paused_changed (Game* _sender,
                                                        gpointer self)
{
	mahjongg_window_paused_changed_cb ((MahjonggWindow*) self);
}

static void
_mahjongg_window_tick_cb_game_tick (Game* _sender,
                                    gpointer self)
{
	mahjongg_window_tick_cb ((MahjonggWindow*) self);
}

void
mahjongg_window_new_game (MahjonggWindow* self,
                          Game* game,
                          gboolean rotate_map,
                          gboolean restore)
{
	Block3Data* _data3_;
	GtkStackTransitionType transition_type = 0;
	GameView* _tmp0_;
	GameView* _tmp1_;
	const gchar* _tmp6_ = NULL;
	GtkStack* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* next_name = NULL;
	gchar* _tmp10_;
	GtkStack* _tmp11_;
	const gchar* _tmp12_;
	GtkWidget* _tmp13_;
	GameView* _tmp14_;
	GameView* _tmp15_;
	GameView* _tmp16_;
	GameView* _tmp17_;
	AdwDialog* _tmp18_;
	AdwDialog* _tmp19_;
	GtkStack* _tmp22_;
	GtkStack* _tmp23_;
	GameView* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	transition_type = GTK_STACK_TRANSITION_TYPE_NONE;
	_tmp0_ = self->priv->game_view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data3_->previous_game_view = _tmp1_;
	if (rotate_map) {
		GSettings* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->settings;
		_tmp3_ = g_settings_get_string (_tmp2_, "map-rotation");
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strcmp0 (_tmp4_, "single") != 0;
		_g_free0 (_tmp4_);
		if (_tmp5_) {
			transition_type = GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT;
		} else {
			transition_type = GTK_STACK_TRANSITION_TYPE_CROSSFADE;
		}
	}
	_tmp7_ = self->priv->stack;
	_tmp8_ = gtk_stack_get_visible_child_name (_tmp7_);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp9_, "primary") == 0) {
		_tmp6_ = "secondary";
	} else {
		_tmp6_ = "primary";
	}
	_tmp10_ = g_strdup (_tmp6_);
	next_name = _tmp10_;
	_tmp11_ = self->priv->stack;
	_tmp12_ = next_name;
	_tmp13_ = gtk_stack_get_child_by_name (_tmp11_, _tmp12_);
	_tmp14_ = _g_object_ref0 (IS_GAME_VIEW (_tmp13_) ? ((GameView*) _tmp13_) : NULL);
	_g_object_unref0 (self->priv->game_view);
	self->priv->game_view = _tmp14_;
	self->priv->restore_game = restore;
	_tmp15_ = _data3_->previous_game_view;
	mahjongg_window_update_theme (self, _tmp15_);
	_tmp16_ = _data3_->previous_game_view;
	if (_tmp16_ != NULL) {
		if (self->priv->unset_game_idle != ((guint) 0)) {
			g_source_remove (self->priv->unset_game_idle);
		}
		self->priv->unset_game_idle = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda8__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	}
	_tmp17_ = self->priv->game_view;
	game_view_set_game (_tmp17_, game);
	g_signal_connect_object (game, "moved", (GCallback) _mahjongg_window_moved_cb_game_moved, self, 0);
	g_signal_connect_object (game, "paused-changed", (GCallback) _mahjongg_window_paused_changed_cb_game_paused_changed, self, 0);
	g_signal_connect_object (game, "tick", (GCallback) _mahjongg_window_tick_cb_game_tick, self, 0);
	_tmp18_ = adw_application_window_get_visible_dialog ((AdwApplicationWindow*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		AdwDialog* _tmp20_;
		AdwDialog* _tmp21_;
		_tmp20_ = adw_application_window_get_visible_dialog ((AdwApplicationWindow*) self);
		_tmp21_ = _tmp20_;
		adw_dialog_force_close (_tmp21_);
	}
	_tmp22_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp22_, transition_type);
	_tmp23_ = self->priv->stack;
	_tmp24_ = self->priv->game_view;
	gtk_stack_set_visible_child (_tmp23_, (GtkWidget*) _tmp24_);
	_g_free0 (next_name);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
mahjongg_window_update_theme (MahjonggWindow* self,
                              GameView* previous_game_view)
{
	gint color_scheme = 0;
	GSettings* _tmp0_;
	gchar* new_theme = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	AdwStyleManager* style_manager = NULL;
	AdwStyleManager* _tmp3_;
	AdwStyleManager* _tmp4_;
	AdwStyleManager* _tmp5_;
	AdwColorScheme _tmp6_;
	AdwColorScheme _tmp7_;
	GameView* _tmp9_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp35_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	color_scheme = g_settings_get_enum (_tmp0_, "background-color");
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "tileset");
	new_theme = _tmp2_;
	_tmp3_ = adw_style_manager_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	style_manager = _tmp4_;
	_tmp5_ = style_manager;
	_tmp6_ = adw_style_manager_get_color_scheme (_tmp5_);
	_tmp7_ = _tmp6_;
	if (color_scheme != ((gint) _tmp7_)) {
		AdwStyleManager* _tmp8_;
		_tmp8_ = style_manager;
		adw_style_manager_set_color_scheme (_tmp8_, color_scheme);
	}
	_tmp9_ = self->priv->game_view;
	if (_tmp9_ != NULL) {
		gchar* path = NULL;
		GtkApplication* _tmp10_;
		GtkApplication* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* fallback_theme = NULL;
		GSettings* _tmp15_;
		GVariant* _tmp16_;
		GVariant* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GameView* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp10_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_application_get_resource_base_path ((GApplication*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "/themes/", NULL);
		path = _tmp14_;
		_tmp15_ = self->priv->settings;
		_tmp16_ = g_settings_get_default_value (_tmp15_, "tileset");
		_tmp17_ = _tmp16_;
		_tmp18_ = g_variant_get_string (_tmp17_, NULL);
		_tmp19_ = g_strdup (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_variant_unref0 (_tmp17_);
		fallback_theme = _tmp20_;
		_tmp21_ = self->priv->game_view;
		_tmp22_ = path;
		_tmp23_ = new_theme;
		_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = path;
		_tmp27_ = fallback_theme;
		_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		game_view_set_theme (_tmp21_, _tmp25_, previous_game_view, _tmp29_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp25_);
		_g_free0 (fallback_theme);
		_g_free0 (path);
	}
	_tmp30_ = self->priv->theme;
	_tmp31_ = new_theme;
	if (g_strcmp0 (_tmp30_, _tmp31_) == 0) {
		_g_object_unref0 (style_manager);
		_g_free0 (new_theme);
		return;
	}
	_tmp32_ = self->priv->theme;
	if (_tmp32_ != NULL) {
		AdwToolbarView* _tmp33_;
		const gchar* _tmp34_;
		_tmp33_ = self->priv->toolbar_view;
		_tmp34_ = self->priv->theme;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp33_, _tmp34_);
	}
	_tmp35_ = new_theme;
	if (_tmp35_ != NULL) {
		AdwToolbarView* _tmp36_;
		const gchar* _tmp37_;
		_tmp36_ = self->priv->toolbar_view;
		_tmp37_ = new_theme;
		gtk_widget_add_css_class ((GtkWidget*) _tmp36_, _tmp37_);
	}
	_tmp38_ = new_theme;
	_tmp39_ = g_strdup (_tmp38_);
	_g_free0 (self->priv->theme);
	self->priv->theme = _tmp39_;
	_g_object_unref0 (style_manager);
	_g_free0 (new_theme);
}

static void
mahjongg_window_conf_value_changed_cb (MahjonggWindow* self,
                                       GSettings* settings,
                                       const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "tileset") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, "background-color") == 0;
	}
	if (_tmp0_) {
		mahjongg_window_update_theme (self, NULL);
	}
}

static void
mahjongg_window_moved_cb (MahjonggWindow* self)
{
	AdwWindowTitle* _tmp0_;
	GameView* _tmp1_;
	Game* _tmp2_;
	Game* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title_widget;
	_tmp1_ = self->priv->game_view;
	_tmp2_ = game_view_get_game (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = game_get_moves_left (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (_ ("Moves Left: %2u"), _tmp5_);
	_tmp7_ = _tmp6_;
	adw_window_title_set_subtitle (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
}

static void
mahjongg_window_paused_changed_cb (MahjonggWindow* self)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GtkStack* _tmp19_;
	PauseOverlay* _tmp20_;
	GtkOverlay* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkButton* _tmp5_;
		GtkButton* _tmp6_;
		GtkStack* _tmp7_;
		gboolean _tmp8_ = FALSE;
		AdwDialog* _tmp9_;
		AdwDialog* _tmp10_;
		_tmp5_ = self->priv->pause_button;
		gtk_button_set_icon_name (_tmp5_, "media-playback-start-symbolic");
		_tmp6_ = self->priv->pause_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Resume Game"));
		_tmp7_ = self->priv->stack;
		gtk_widget_add_css_class ((GtkWidget*) _tmp7_, "dim-label");
		_tmp9_ = adw_application_window_get_visible_dialog ((AdwApplicationWindow*) self);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NULL) {
			GtkMenuButton* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = self->priv->menu_button;
			_tmp12_ = gtk_menu_button_get_active (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp8_ = !_tmp13_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GtkOverlay* _tmp14_;
			PauseOverlay* _tmp15_;
			PauseOverlay* _tmp16_;
			_tmp14_ = self->priv->overlay;
			_tmp15_ = self->priv->pause_overlay;
			gtk_overlay_add_overlay (_tmp14_, (GtkWidget*) _tmp15_);
			_tmp16_ = self->priv->pause_overlay;
			pause_overlay_show (_tmp16_, self->priv->restore_game);
		}
		self->priv->restore_game = FALSE;
		return;
	}
	_tmp17_ = self->priv->pause_button;
	gtk_button_set_icon_name (_tmp17_, "media-playback-pause-symbolic");
	_tmp18_ = self->priv->pause_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp18_, _ ("Pause Game"));
	_tmp19_ = self->priv->stack;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp19_, "dim-label");
	_tmp20_ = self->priv->pause_overlay;
	_tmp21_ = self->priv->overlay;
	if (gtk_widget_is_ancestor ((GtkWidget*) _tmp20_, (GtkWidget*) _tmp21_)) {
		GtkOverlay* _tmp22_;
		PauseOverlay* _tmp23_;
		PauseOverlay* _tmp24_;
		_tmp22_ = self->priv->overlay;
		_tmp23_ = self->priv->pause_overlay;
		gtk_overlay_remove_overlay (_tmp22_, (GtkWidget*) _tmp23_);
		_tmp24_ = self->priv->pause_overlay;
		pause_overlay_hide (_tmp24_);
	}
}

static void
mahjongg_window_tick_cb (MahjonggWindow* self)
{
	gchar* clock = NULL;
	gint elapsed = 0;
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gint hours = 0;
	gint minutes = 0;
	gint seconds = 0;
	AdwWindowTitle* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_elapsed (_tmp2_);
	_tmp4_ = _tmp3_;
	elapsed = (gint) _tmp4_;
	hours = elapsed / 3600;
	minutes = (elapsed - (hours * 3600)) / 60;
	seconds = (elapsed - (hours * 3600)) - (minutes * 60);
	if (hours > 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", hours, minutes, seconds);
		_g_free0 (clock);
		clock = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", minutes, seconds);
		_g_free0 (clock);
		clock = _tmp6_;
	}
	_tmp7_ = self->priv->title_widget;
	_tmp8_ = clock;
	adw_window_title_set_title (_tmp7_, _tmp8_);
	_g_free0 (clock);
}

gboolean
mahjongg_window_get_compact (MahjonggWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_compact;
	return result;
}

void
mahjongg_window_set_compact (MahjonggWindow* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_compact = value;
	if (!value) {
		gtk_widget_remove_css_class ((GtkWidget*) self, "compact");
		return;
	}
	gtk_widget_add_css_class ((GtkWidget*) self, "compact");
	g_object_notify_by_pspec ((GObject *) self, mahjongg_window_properties[MAHJONGG_WINDOW_COMPACT_PROPERTY]);
}

static void
mahjongg_window_class_init (MahjonggWindowClass * klass,
                            gpointer klass_data)
{
	mahjongg_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MahjonggWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mahjongg_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mahjongg_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = mahjongg_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAHJONGG_WINDOW_COMPACT_PROPERTY, mahjongg_window_properties[MAHJONGG_WINDOW_COMPACT_PROPERTY] = g_param_spec_boolean ("compact", "compact", "compact", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Mahjongg/ui/window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toolbar_view", FALSE, MahjonggWindow_private_offset + G_STRUCT_OFFSET (MahjonggWindowPrivate, toolbar_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_widget", FALSE, MahjonggWindow_private_offset + G_STRUCT_OFFSET (MahjonggWindowPrivate, title_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, MahjonggWindow_private_offset + G_STRUCT_OFFSET (MahjonggWindowPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_button", FALSE, MahjonggWindow_private_offset + G_STRUCT_OFFSET (MahjonggWindowPrivate, pause_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, MahjonggWindow_private_offset + G_STRUCT_OFFSET (MahjonggWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, MahjonggWindow_private_offset + G_STRUCT_OFFSET (MahjonggWindowPrivate, stack));
}

static void
mahjongg_window_instance_init (MahjonggWindow * self,
                               gpointer klass)
{
	self->priv = mahjongg_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
mahjongg_window_finalize (GObject * obj)
{
	MahjonggWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAHJONGG_WINDOW, MahjonggWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game_view);
	_g_object_unref0 (self->priv->pause_overlay);
	_g_free0 (self->priv->theme);
	G_OBJECT_CLASS (mahjongg_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
mahjongg_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MahjonggWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mahjongg_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MahjonggWindow), 0, (GInstanceInitFunc) mahjongg_window_instance_init, NULL };
	GType mahjongg_window_type_id;
	mahjongg_window_type_id = g_type_register_static (adw_application_window_get_type (), "MahjonggWindow", &g_define_type_info, 0);
	MahjonggWindow_private_offset = g_type_add_instance_private (mahjongg_window_type_id, sizeof (MahjonggWindowPrivate));
	return mahjongg_window_type_id;
}

GType
mahjongg_window_get_type (void)
{
	static gsize mahjongg_window_type_id__once = 0;
	if (g_once_init_enter (&mahjongg_window_type_id__once)) {
		GType mahjongg_window_type_id;
		mahjongg_window_type_id = mahjongg_window_get_type_once ();
		g_once_init_leave (&mahjongg_window_type_id__once, mahjongg_window_type_id);
	}
	return mahjongg_window_type_id__once;
}

static void
_vala_mahjongg_window_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	MahjonggWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAHJONGG_WINDOW, MahjonggWindow);
	switch (property_id) {
		case MAHJONGG_WINDOW_COMPACT_PROPERTY:
		g_value_set_boolean (value, mahjongg_window_get_compact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mahjongg_window_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	MahjonggWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAHJONGG_WINDOW, MahjonggWindow);
	switch (property_id) {
		case MAHJONGG_WINDOW_COMPACT_PROPERTY:
		mahjongg_window_set_compact (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

