/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_tag_share = R"doc(Adds tags from Input 1 onto Input 0's stream.

This block utilizes the GNU Radio runtime's tag propagation policy to transfer or share Input 1's tags to Input 0's stream. This is useful when a signal is detected via a correlate_access_code_bb or a threshold crossing from a complex_to_mag_squared block. The tag from that detection is on the alternate stream, either bytes or floats. Often there is further signal processing that should be done on the complex stream. This block allows the detection tags to be added to the complex stream to trigger downstream processing without the need of redundant trigger inputs on all subsequent blocks.

Constructor Specific Documentation:



Args:
    sizeof_io_item : The size of the Input 0/Output 0 stream type. Input 0 stream items will be directly copied to Output 0.
    sizeof_share_item : The size of the Input 1 (tag share) stream type. This stream type does not have to match the input/output stream type. Tags from Input 1's items will be combined with Input 0's item tags and outputted on Output 0.
    vlen : The vector size of the input and output stream items)doc";


static const char* __doc_gr_blocks_tag_share_tag_share = R"doc()doc";


static const char* __doc_gr_blocks_tag_share_make = R"doc(Adds tags from Input 1 onto Input 0's stream.

This block utilizes the GNU Radio runtime's tag propagation policy to transfer or share Input 1's tags to Input 0's stream. This is useful when a signal is detected via a correlate_access_code_bb or a threshold crossing from a complex_to_mag_squared block. The tag from that detection is on the alternate stream, either bytes or floats. Often there is further signal processing that should be done on the complex stream. This block allows the detection tags to be added to the complex stream to trigger downstream processing without the need of redundant trigger inputs on all subsequent blocks.

Constructor Specific Documentation:



Args:
    sizeof_io_item : The size of the Input 0/Output 0 stream type. Input 0 stream items will be directly copied to Output 0.
    sizeof_share_item : The size of the Input 1 (tag share) stream type. This stream type does not have to match the input/output stream type. Tags from Input 1's items will be combined with Input 0's item tags and outputted on Output 0.
    vlen : The vector size of the input and output stream items)doc";
