/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, network, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_network_tcp_sink = R"doc(This block provides a TCP Sink block that supports both client and server modes.

This block provides a TCP sink that supports both listening for inbound connections (server mode) and connecting to other applications (client mode) in order to send data from a GNU Radio flowgraph. The block supports both IPv4 and IPv6 with appropriate code determined by the address used. In server mode, if a client disconnects, the flowgraph will continue to execute. If/when a new client connection is established, data will then pick up with the current stream for transmission to the new client.

Constructor Specific Documentation:

Build a tcp_sink block.

Args:
    itemsize : 
    veclen : 
    host : 
    port : 
    sinkmode : )doc";


static const char* __doc_gr_network_tcp_sink_tcp_sink = R"doc()doc";


static const char* __doc_gr_network_tcp_sink_make = R"doc(This block provides a TCP Sink block that supports both client and server modes.

This block provides a TCP sink that supports both listening for inbound connections (server mode) and connecting to other applications (client mode) in order to send data from a GNU Radio flowgraph. The block supports both IPv4 and IPv6 with appropriate code determined by the address used. In server mode, if a client disconnects, the flowgraph will continue to execute. If/when a new client connection is established, data will then pick up with the current stream for transmission to the new client.

Constructor Specific Documentation:

Build a tcp_sink block.

Args:
    itemsize : 
    veclen : 
    host : 
    port : 
    sinkmode : )doc";
