/**************************************************************************/
/*  copy.glsl.gen.h                                                       */
/**************************************************************************/
/*                         This file is part of:                          */
/*                             GODOT ENGINE                               */
/*                        https://godotengine.org                         */
/**************************************************************************/
/* Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md). */
/* Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.                  */
/*                                                                        */
/* Permission is hereby granted, free of charge, to any person obtaining  */
/* a copy of this software and associated documentation files (the        */
/* "Software"), to deal in the Software without restriction, including    */
/* without limitation the rights to use, copy, modify, merge, publish,    */
/* distribute, sublicense, and/or sell copies of the Software, and to     */
/* permit persons to whom the Software is furnished to do so, subject to  */
/* the following conditions:                                              */
/*                                                                        */
/* The above copyright notice and this permission notice shall be         */
/* included in all copies or substantial portions of the Software.        */
/*                                                                        */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. */
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 */
/**************************************************************************/

/* THIS FILE IS GENERATED. EDITS WILL BE LOST. */

#pragma once

#include "servers/rendering/renderer_rd/shader_rd.h"

class CopyShaderRD : public ShaderRD {
public:
	CopyShaderRD() {
		static const char *_vertex_code = nullptr;
		static const char *_fragment_code = nullptr;
		static const char _compute_code[] = {
R"<!>(
#version 450

#VERSION_DEFINES


vec3 oct_to_vec3(vec2 e) {
	vec3 v = vec3(e.xy, 1.0 - abs(e.x) - abs(e.y));
	float t = max(-v.z, 0.0);
	v.xy += t * -sign(v.xy);
	return normalize(v);
}


vec3 oct_to_vec3_with_border(vec2 uv, float border_size) {
	
	uv = (uv - 0.5) * (2.0 / border_size);
	
	
	vec2 mask = step(vec2(1.0), abs(uv));
	uv = 2.0 * clamp(uv, -1.0, 1.0) - uv;
	uv = mix(uv, -uv, mask.yx);
	return oct_to_vec3(uv);
}

vec2 oct_wrap(vec2 v) {
	vec2 signVal;
	signVal.x = v.x >= 0.0 ? 1.0 : -1.0;
	signVal.y = v.y >= 0.0 ? 1.0 : -1.0;
	return (1.0 - abs(v.yx)) * signVal;
}

vec2 vec3_to_oct(vec3 n) {
	
	n /= (abs(n.x) + abs(n.y) + abs(n.z));
	n.xy = (n.z >= 0.0) ? n.xy : oct_wrap(n.xy);
	n.xy = n.xy * 0.5 + 0.5;
	return n.xy;
}



vec2 vec3_to_oct_with_border(vec3 n, vec2 border_size) {
	vec2 uv = vec3_to_oct(n);
	return uv * border_size.y + border_size.x;
}

float vec3_to_oct_lod(vec3 n_ddx, vec3 n_ddy, float pixel_size) {
	
	
	float pixel_size_sqr = 4.0 * pixel_size * pixel_size;
	float ddx = dot(n_ddx, n_ddx) / pixel_size_sqr;
	float ddy = dot(n_ddy, n_ddy) / pixel_size_sqr;
	float dd_sqr = max(ddx, ddy);
	return 0.25 * log2(dd_sqr + 1e-6f);
}

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

#define FLAG_HORIZONTAL (1 << 0)
#define FLAG_USE_BLUR_SECTION (1 << 1)
#define FLAG_USE_ORTHOGONAL_PROJECTION (1 << 2)
#define FLAG_DOF_NEAR_FIRST_TAP (1 << 3)
#define FLAG_GLOW_FIRST_PASS (1 << 4)
#define FLAG_FLIP_Y (1 << 5)
#define FLAG_FORCE_LUMINANCE (1 << 6)
#define FLAG_COPY_ALL_SOURCE (1 << 7)
#define FLAG_ALPHA_TO_ONE (1 << 8)
#define FLAG_SANITIZE_INF_NAN (1 << 9)

layout(push_constant, std430) uniform Params {
	ivec4 section;
	ivec2 target;
	uint flags;
	float luminance_multiplier;
	
	float glow_strength;
	float glow_bloom;
	float glow_hdr_threshold;
	float glow_hdr_scale;

	float glow_exposure;
	float glow_white;
	float glow_luminance_cap;
	float glow_auto_exposure_scale;
	
	float camera_z_far;
	float camera_z_near;
	
	vec2 octmap_border_size;

	vec4 set_color;
}
params;

#ifdef MODE_OCTMAP_ARRAY_TO_PANORAMA
layout(set = 0, binding = 0) uniform sampler2DArray source_color;
#elif defined(MODE_OCTMAP_TO_PANORAMA)
layout(set = 0, binding = 0) uniform sampler2D source_color;
#elif !defined(MODE_SET_COLOR)
layout(set = 0, binding = 0) uniform sampler2D source_color;
#endif

#ifdef GLOW_USE_AUTO_EXPOSURE
layout(set = 1, binding = 0) uniform sampler2D source_auto_exposure;
#endif

#if defined(MODE_LINEARIZE_DEPTH_COPY) || defined(MODE_SIMPLE_COPY_DEPTH)
layout(r32f, set = 3, binding = 0) uniform restrict writeonly image2D dest_buffer;
#elif defined(DST_IMAGE_8BIT)
layout(rgba8, set = 3, binding = 0) uniform restrict writeonly image2D dest_buffer;
#else
layout(rgba16f, set = 3, binding = 0) uniform restrict writeonly image2D dest_buffer;
#endif

#ifdef MODE_GAUSSIAN_BLUR
shared vec4 local_cache[256];
shared vec4 temp_cache[128];
#endif

void main() {
	
	ivec2 pos = ivec2(gl_GlobalInvocationID.xy);

#ifndef MODE_GAUSSIAN_BLUR 
	if (any(greaterThanEqual(pos, params.section.zw))) { 
		return;
	}
#endif

#ifdef MODE_MIPMAP

	ivec2 base_pos = (pos + params.section.xy) << 1;
	vec4 color = texelFetch(source_color, base_pos, 0);
	color += texelFetch(source_color, base_pos + ivec2(0, 1), 0);
	color += texelFetch(source_color, base_pos + ivec2(1, 0), 0);
	color += texelFetch(source_color, base_pos + ivec2(1, 1), 0);
	color /= 4.0;
	color = mix(color, vec4(100.0, 100.0, 100.0, 1.0), isinf(color));
	color = mix(color, vec4(100.0, 100.0, 100.0, 1.0), isnan(color));

	imageStore(dest_buffer, pos + params.target, color);
#endif

#ifdef MODE_GAUSSIAN_BLUR

	
	vec2 quad_center_uv = clamp(vec2(params.section.xy + gl_GlobalInvocationID.xy + gl_LocalInvocationID.xy - 3.5) / params.section.zw, vec2(0.5 / params.section.zw), vec2(1.0 - 1.5 / params.section.zw));
	uint dest_index = gl_LocalInvocationID.x * 2 + gl_LocalInvocationID.y * 2 * 16;

	local_cache[dest_index] = textureLod(source_color, quad_center_uv, 0);
	local_cache[dest_index + 1] = textureLod(source_color, quad_center_uv + vec2(1.0 / params.section.z, 0.0), 0);
	local_cache[dest_index + 16] = textureLod(source_color, quad_center_uv + vec2(0.0, 1.0 / params.section.w), 0);
	local_cache[dest_index + 16 + 1] = textureLod(source_color, quad_center_uv + vec2(1.0 / params.section.zw), 0);

#ifdef MODE_GLOW
	if (bool(params.flags & FLAG_GLOW_FIRST_PASS)) {
		
		vec3 tonemap_col = vec3(0.299, 0.587, 0.114) / max(params.glow_luminance_cap, 6.0);
		local_cache[dest_index] /= 1.0 + dot(local_cache[dest_index].rgb, tonemap_col);
		local_cache[dest_index + 1] /= 1.0 + dot(local_cache[dest_index + 1].rgb, tonemap_col);
		local_cache[dest_index + 16] /= 1.0 + dot(local_cache[dest_index + 16].rgb, tonemap_col);
		local_cache[dest_index + 16 + 1] /= 1.0 + dot(local_cache[dest_index + 16 + 1].rgb, tonemap_col);
	}
	const float kernel[5] = { 0.2024, 0.1790, 0.1240, 0.0672, 0.0285 };
#else
	
	const float kernel[4] = { 0.214607, 0.189879, 0.131514, 0.071303 };
#endif
	memoryBarrierShared();
	barrier();

	
	uint read_index = gl_LocalInvocationID.x + gl_LocalInvocationID.y * 32 + 4;
	vec4 color_top = vec4(0.0);
	color_top += local_cache[read_index] * kernel[0];
	color_top += local_cache[read_index + 1] * kernel[1];
	color_top += local_cache[read_index + 2] * kernel[2];
	color_top += local_cache[read_index + 3] * kernel[3];
	color_top += local_cache[read_index - 1] * kernel[1];
	color_top += local_cache[read_index - 2] * kernel[2];
	color_top += local_cache[read_index - 3] * kernel[3];
#ifdef MODE_GLOW
	color_top += local_cache[read_index + 4] * kernel[4];
	color_top += local_cache[read_index - 4] * kernel[4];
#endif 

	vec4 color_bottom = vec4(0.0);
	color_bottom += local_cache[read_index + 16] * kernel[0];
	color_bottom += local_cache[read_index + 1 + 16] * kernel[1];
	color_bottom += local_cache[read_index + 2 + 16] * kernel[2];
	color_bottom += local_cache[read_index + 3 + 16] * kernel[3];
	color_bottom += local_cache[read_index - 1 + 16] * kernel[1];
	color_bottom += local_cache[read_index - 2 + 16] * kernel[2];
	color_bottom += local_cache[read_index - 3 + 16] * kernel[3];
#ifdef MODE_GLOW
	color_bottom += local_cache[read_index + 4 + 16] * kernel[4];
	color_bottom += local_cache[read_index - 4 + 16] * kernel[4];
#endif 

	
	uint write_index = gl_LocalInvocationID.y * 2 + gl_LocalInvocationID.x * 16;

	temp_cache[write_index] = color_top;
	temp_cache[write_index + 1] = color_bottom;

	memoryBarrierShared();
	barrier();

	
	if (any(greaterThanEqual(pos, params.section.zw))) {
		return;
	}

	
	uint index = gl_LocalInvocationID.y + gl_LocalInvocationID.x * 16 + 4;
	vec4 color = vec4(0.0);

	color += temp_cache[index] * kernel[0];
	color += temp_cache[index + 1] * kernel[1];
	color += temp_cache[index + 2] * kernel[2];
	color += temp_cache[index + 3] * kernel[3];
	color += temp_cache[index - 1] * kernel[1];
	color += temp_cache[index - 2] * kernel[2];
	color += temp_cache[index - 3] * kernel[3];
#ifdef MODE_GLOW
	color += temp_cache[index + 4] * kernel[4];
	color += temp_cache[index - 4] * kernel[4];
#endif 

#ifdef MODE_GLOW
	if (bool(params.flags & FLAG_GLOW_FIRST_PASS)) {
		
		color /= 1.0 - dot(color.rgb, vec3(0.299, 0.587, 0.114) / max(params.glow_luminance_cap, 6.0));
	}

	color *= params.glow_strength;

	if (bool(params.flags & FLAG_GLOW_FIRST_PASS)) {
#ifdef GLOW_USE_AUTO_EXPOSURE

		color /= texelFetch(source_auto_exposure, ivec2(0, 0), 0).r / params.glow_auto_exposure_scale;
#endif
		color *= params.glow_exposure;

		float luminance = max(color.r, max(color.g, color.b));
		float feedback = max(smoothstep(params.glow_hdr_threshold, params.glow_hdr_threshold + params.glow_hdr_scale, luminance), params.glow_bloom);

		color = min(color * feedback, vec4(params.glow_luminance_cap));
	}
#endif 
	imageStore(dest_buffer, pos + params.target, color);

#endif 

#ifdef MODE_SIMPLE_COPY

	vec4 color;
	if (bool(params.flags & FLAG_COPY_ALL_SOURCE)) {
		vec2 uv = vec2(pos) / vec2(params.section.zw);
		if (bool(params.flags & FLAG_FLIP_Y)) {
			uv.y = 1.0 - uv.y;
		}
		color = textureLod(source_color, uv, 0.0);

	} else {
		color = texelFetch(source_color, pos + params.section.xy, 0);

		if (bool(params.flags & FLAG_FLIP_Y)) {
			pos.y = params.section.w - pos.y - 1;
		}
	}

	if (bool(params.flags & FLAG_FORCE_LUMINANCE)) {
		color.rgb = vec3(max(max(color.r, color.g), color.b));
	}

	if (bool(params.flags & FLAG_ALPHA_TO_ONE)) {
		color.a = 1.0;
	}

	if (bool(params.flags & FLAG_SANITIZE_INF_NAN)) {
		color = mix(color, vec4(100.0, 100.0, 100.0, 1.0), isinf(color));
		color = mix(color, vec4(100.0, 100.0, 100.0, 1.0), isnan(color));
	}

	imageStore(dest_buffer, pos + params.target, color);

#endif 

#ifdef MODE_SIMPLE_COPY_DEPTH

	vec4 color = texelFetch(source_color, pos + params.section.xy, 0);

	if (bool(params.flags & FLAG_FLIP_Y)) {
		pos.y = params.section.w - pos.y - 1;
	}

	imageStore(dest_buffer, pos + params.target, vec4(color.r));

#endif 

#ifdef MODE_LINEARIZE_DEPTH_COPY

	float depth = texelFetch(source_color, pos + params.section.xy, 0).r;
	depth = depth * 2.0 - 1.0;
	depth = 2.0 * params.camera_z_near * params.camera_z_far / (params.camera_z_far + params.camera_z_near - depth * (params.camera_z_far - params.camera_z_near));
	vec4 color = vec4(depth / params.camera_z_far);

	if (bool(params.flags & FLAG_FLIP_Y)) {
		pos.y = params.section.w - pos.y - 1;
	}

	imageStore(dest_buffer, pos + params.target, color);
#endif 

#if defined(MODE_OCTMAP_TO_PANORAMA) || defined(MODE_OCTMAP_ARRAY_TO_PANORAMA)

	const float PI = 3.14159265359;
	vec2 uv = vec2(pos) / vec2(params.section.zw);
	if (bool(params.flags & FLAG_FLIP_Y)) {
		uv.y = 1.0 - uv.y;
	}
	float phi = uv.x * 2.0 * PI;
	float theta = uv.y * PI;

	vec3 normal;
	normal.x = sin(phi) * sin(theta) * -1.0;
	normal.y = cos(theta);
	normal.z = cos(phi) * sin(theta) * -1.0;

#ifdef MODE_OCTMAP_TO_PANORAMA
	vec4 color = textureLod(source_color, vec3_to_oct_with_border(normal, params.octmap_border_size), params.camera_z_far); 
#else
	vec4 color = textureLod(source_color, vec3(vec3_to_oct_with_border(normal, params.octmap_border_size), params.camera_z_far), 0.0); 
#endif
	imageStore(dest_buffer, pos + params.target, color * params.luminance_multiplier);
#endif 

#ifdef MODE_SET_COLOR
	imageStore(dest_buffer, pos + params.target, params.set_color);
#endif
}
)<!>"
		};
		setup(_vertex_code, _fragment_code, _compute_code, "CopyShaderRD");
	}
};
