// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type SpanContext struct {
	TraceID    TraceID
	SpanID     SpanID
	TraceFlags uint32
	TraceState string
	Remote     bool
}

var (
	protoPoolSpanContext = sync.Pool{
		New: func() any {
			return &SpanContext{}
		},
	}
)

func NewSpanContext() *SpanContext {
	if !UseProtoPooling.IsEnabled() {
		return &SpanContext{}
	}
	return protoPoolSpanContext.Get().(*SpanContext)
}

func DeleteSpanContext(orig *SpanContext, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteTraceID(&orig.TraceID, false)
	DeleteSpanID(&orig.SpanID, false)

	orig.Reset()
	if nullable {
		protoPoolSpanContext.Put(orig)
	}
}

func CopySpanContext(dest, src *SpanContext) *SpanContext {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewSpanContext()
	}
	CopyTraceID(&dest.TraceID, &src.TraceID)

	CopySpanID(&dest.SpanID, &src.SpanID)

	dest.TraceFlags = src.TraceFlags

	dest.TraceState = src.TraceState

	dest.Remote = src.Remote

	return dest
}

func CopySpanContextSlice(dest, src []SpanContext) []SpanContext {
	var newDest []SpanContext
	if cap(dest) < len(src) {
		newDest = make([]SpanContext, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSpanContext(&dest[i], false)
		}
	}
	for i := range src {
		CopySpanContext(&newDest[i], &src[i])
	}
	return newDest
}

func CopySpanContextPtrSlice(dest, src []*SpanContext) []*SpanContext {
	var newDest []*SpanContext
	if cap(dest) < len(src) {
		newDest = make([]*SpanContext, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSpanContext()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSpanContext(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSpanContext()
		}
	}
	for i := range src {
		CopySpanContext(newDest[i], src[i])
	}
	return newDest
}

func (orig *SpanContext) Reset() {
	*orig = SpanContext{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *SpanContext) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if !orig.TraceID.IsEmpty() {
		dest.WriteObjectField("traceID")
		orig.TraceID.MarshalJSON(dest)
	}
	if !orig.SpanID.IsEmpty() {
		dest.WriteObjectField("spanID")
		orig.SpanID.MarshalJSON(dest)
	}
	if orig.TraceFlags != uint32(0) {
		dest.WriteObjectField("traceFlags")
		dest.WriteUint32(orig.TraceFlags)
	}
	if orig.TraceState != "" {
		dest.WriteObjectField("traceState")
		dest.WriteString(orig.TraceState)
	}
	if orig.Remote != false {
		dest.WriteObjectField("remote")
		dest.WriteBool(orig.Remote)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *SpanContext) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "traceID", "trace_id":

			orig.TraceID.UnmarshalJSON(iter)
		case "spanID", "span_id":

			orig.SpanID.UnmarshalJSON(iter)
		case "traceFlags", "trace_flags":
			orig.TraceFlags = iter.ReadUint32()
		case "traceState", "trace_state":
			orig.TraceState = iter.ReadString()
		case "remote":
			orig.Remote = iter.ReadBool()
		default:
			iter.Skip()
		}
	}
}

func (orig *SpanContext) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.TraceID.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = orig.SpanID.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.TraceFlags != 0 {
		n += 5
	}
	l = len(orig.TraceState)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Remote {
		n += 2
	}
	return n
}

func (orig *SpanContext) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.TraceID.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	l = orig.SpanID.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	if orig.TraceFlags != 0 {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.TraceFlags))
		pos--
		buf[pos] = 0x1d
	}
	l = len(orig.TraceState)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.TraceState)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x22
	}
	if orig.Remote {
		pos--
		if orig.Remote {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x28
	}
	return len(buf) - pos
}

func (orig *SpanContext) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceID", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.TraceID.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanID", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.SpanID.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceFlags", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.TraceFlags = uint32(num)

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceState", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.TraceState = string(buf[startPos:pos])

		case 5:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Remote", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Remote = num != 0
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestSpanContext() *SpanContext {
	orig := NewSpanContext()
	orig.TraceID = *GenTestTraceID()
	orig.SpanID = *GenTestSpanID()
	orig.TraceFlags = uint32(13)
	orig.TraceState = "test_tracestate"
	orig.Remote = true
	return orig
}

func GenTestSpanContextPtrSlice() []*SpanContext {
	orig := make([]*SpanContext, 5)
	orig[0] = NewSpanContext()
	orig[1] = GenTestSpanContext()
	orig[2] = NewSpanContext()
	orig[3] = GenTestSpanContext()
	orig[4] = NewSpanContext()
	return orig
}

func GenTestSpanContextSlice() []SpanContext {
	orig := make([]SpanContext, 5)
	orig[1] = *GenTestSpanContext()
	orig[3] = *GenTestSpanContext()
	return orig
}
