// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ScopeSpans is a collection of spans from a LibraryInstrumentation.
type ScopeSpans struct {
	SchemaUrl string
	Spans     []*Span
	Scope     InstrumentationScope
}

var (
	protoPoolScopeSpans = sync.Pool{
		New: func() any {
			return &ScopeSpans{}
		},
	}
)

func NewScopeSpans() *ScopeSpans {
	if !UseProtoPooling.IsEnabled() {
		return &ScopeSpans{}
	}
	return protoPoolScopeSpans.Get().(*ScopeSpans)
}

func DeleteScopeSpans(orig *ScopeSpans, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	DeleteInstrumentationScope(&orig.Scope, false)
	for i := range orig.Spans {
		DeleteSpan(orig.Spans[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolScopeSpans.Put(orig)
	}
}

func CopyScopeSpans(dest, src *ScopeSpans) *ScopeSpans {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewScopeSpans()
	}
	CopyInstrumentationScope(&dest.Scope, &src.Scope)

	dest.Spans = CopySpanPtrSlice(dest.Spans, src.Spans)

	dest.SchemaUrl = src.SchemaUrl

	return dest
}

func CopyScopeSpansSlice(dest, src []ScopeSpans) []ScopeSpans {
	var newDest []ScopeSpans
	if cap(dest) < len(src) {
		newDest = make([]ScopeSpans, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteScopeSpans(&dest[i], false)
		}
	}
	for i := range src {
		CopyScopeSpans(&newDest[i], &src[i])
	}
	return newDest
}

func CopyScopeSpansPtrSlice(dest, src []*ScopeSpans) []*ScopeSpans {
	var newDest []*ScopeSpans
	if cap(dest) < len(src) {
		newDest = make([]*ScopeSpans, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewScopeSpans()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteScopeSpans(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewScopeSpans()
		}
	}
	for i := range src {
		CopyScopeSpans(newDest[i], src[i])
	}
	return newDest
}

func (orig *ScopeSpans) Reset() {
	*orig = ScopeSpans{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ScopeSpans) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("scope")
	orig.Scope.MarshalJSON(dest)
	if len(orig.Spans) > 0 {
		dest.WriteObjectField("spans")
		dest.WriteArrayStart()
		orig.Spans[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Spans); i++ {
			dest.WriteMore()
			orig.Spans[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ScopeSpans) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "scope":

			orig.Scope.UnmarshalJSON(iter)
		case "spans":
			for iter.ReadArray() {
				orig.Spans = append(orig.Spans, NewSpan())
				orig.Spans[len(orig.Spans)-1].UnmarshalJSON(iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ScopeSpans) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.Scope.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Spans {
		l = orig.Spans[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}

	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ScopeSpans) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.Scope.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.Spans) - 1; i >= 0; i-- {
		l = orig.Spans[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func (orig *ScopeSpans) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Scope.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Spans = append(orig.Spans, NewSpan())
			err = orig.Spans[len(orig.Spans)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestScopeSpans() *ScopeSpans {
	orig := NewScopeSpans()
	orig.Scope = *GenTestInstrumentationScope()
	orig.Spans = []*Span{{}, GenTestSpan()}
	orig.SchemaUrl = "test_schemaurl"
	return orig
}

func GenTestScopeSpansPtrSlice() []*ScopeSpans {
	orig := make([]*ScopeSpans, 5)
	orig[0] = NewScopeSpans()
	orig[1] = GenTestScopeSpans()
	orig[2] = NewScopeSpans()
	orig[3] = GenTestScopeSpans()
	orig[4] = NewScopeSpans()
	return orig
}

func GenTestScopeSpansSlice() []ScopeSpans {
	orig := make([]ScopeSpans, 5)
	orig[1] = *GenTestScopeSpans()
	orig[3] = *GenTestScopeSpans()
	return orig
}
