{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Constructs t'GI.Gdk.Objects.Texture.Texture' objects from GL textures.
-- 
-- The operation is quite simple: Create a texture builder, set all the necessary
-- properties - keep in mind that the properties [GLTextureBuilder:context]("GI.Gdk.Objects.GLTextureBuilder#g:attr:context"),
-- [GLTextureBuilder:id]("GI.Gdk.Objects.GLTextureBuilder#g:attr:id"), [GLTextureBuilder:width]("GI.Gdk.Objects.GLTextureBuilder#g:attr:width"), and
-- [GLTextureBuilder:height]("GI.Gdk.Objects.GLTextureBuilder#g:attr:height") are mandatory - and then call
-- 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderBuild' to create the new texture.
-- 
-- @GdkGLTextureBuilder@ can be used for quick one-shot construction of
-- textures as well as kept around and reused to construct multiple textures.
-- 
-- /Since: 4.12/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.GLTextureBuilder
    ( 

-- * Exported types
    GLTextureBuilder(..)                    ,
    IsGLTextureBuilder                      ,
    toGLTextureBuilder                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [build]("GI.Gdk.Objects.GLTextureBuilder#g:method:build"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getColorState]("GI.Gdk.Objects.GLTextureBuilder#g:method:getColorState"), [getContext]("GI.Gdk.Objects.GLTextureBuilder#g:method:getContext"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFormat]("GI.Gdk.Objects.GLTextureBuilder#g:method:getFormat"), [getHasMipmap]("GI.Gdk.Objects.GLTextureBuilder#g:method:getHasMipmap"), [getHeight]("GI.Gdk.Objects.GLTextureBuilder#g:method:getHeight"), [getId]("GI.Gdk.Objects.GLTextureBuilder#g:method:getId"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSync]("GI.Gdk.Objects.GLTextureBuilder#g:method:getSync"), [getUpdateRegion]("GI.Gdk.Objects.GLTextureBuilder#g:method:getUpdateRegion"), [getUpdateTexture]("GI.Gdk.Objects.GLTextureBuilder#g:method:getUpdateTexture"), [getWidth]("GI.Gdk.Objects.GLTextureBuilder#g:method:getWidth").
-- 
-- ==== Setters
-- [setColorState]("GI.Gdk.Objects.GLTextureBuilder#g:method:setColorState"), [setContext]("GI.Gdk.Objects.GLTextureBuilder#g:method:setContext"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFormat]("GI.Gdk.Objects.GLTextureBuilder#g:method:setFormat"), [setHasMipmap]("GI.Gdk.Objects.GLTextureBuilder#g:method:setHasMipmap"), [setHeight]("GI.Gdk.Objects.GLTextureBuilder#g:method:setHeight"), [setId]("GI.Gdk.Objects.GLTextureBuilder#g:method:setId"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSync]("GI.Gdk.Objects.GLTextureBuilder#g:method:setSync"), [setUpdateRegion]("GI.Gdk.Objects.GLTextureBuilder#g:method:setUpdateRegion"), [setUpdateTexture]("GI.Gdk.Objects.GLTextureBuilder#g:method:setUpdateTexture"), [setWidth]("GI.Gdk.Objects.GLTextureBuilder#g:method:setWidth").

#if defined(ENABLE_OVERLOADING)
    ResolveGLTextureBuilderMethod           ,
#endif

-- ** build #method:build#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderBuildMethodInfo         ,
#endif
    gLTextureBuilderBuild                   ,


-- ** getColorState #method:getColorState#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetColorStateMethodInfo ,
#endif
    gLTextureBuilderGetColorState           ,


-- ** getContext #method:getContext#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetContextMethodInfo    ,
#endif
    gLTextureBuilderGetContext              ,


-- ** getFormat #method:getFormat#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetFormatMethodInfo     ,
#endif
    gLTextureBuilderGetFormat               ,


-- ** getHasMipmap #method:getHasMipmap#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetHasMipmapMethodInfo  ,
#endif
    gLTextureBuilderGetHasMipmap            ,


-- ** getHeight #method:getHeight#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetHeightMethodInfo     ,
#endif
    gLTextureBuilderGetHeight               ,


-- ** getId #method:getId#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetIdMethodInfo         ,
#endif
    gLTextureBuilderGetId                   ,


-- ** getSync #method:getSync#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetSyncMethodInfo       ,
#endif
    gLTextureBuilderGetSync                 ,


-- ** getUpdateRegion #method:getUpdateRegion#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetUpdateRegionMethodInfo,
#endif
    gLTextureBuilderGetUpdateRegion         ,


-- ** getUpdateTexture #method:getUpdateTexture#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetUpdateTextureMethodInfo,
#endif
    gLTextureBuilderGetUpdateTexture        ,


-- ** getWidth #method:getWidth#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderGetWidthMethodInfo      ,
#endif
    gLTextureBuilderGetWidth                ,


-- ** new #method:new#

    gLTextureBuilderNew                     ,


-- ** setColorState #method:setColorState#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetColorStateMethodInfo ,
#endif
    gLTextureBuilderSetColorState           ,


-- ** setContext #method:setContext#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetContextMethodInfo    ,
#endif
    gLTextureBuilderSetContext              ,


-- ** setFormat #method:setFormat#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetFormatMethodInfo     ,
#endif
    gLTextureBuilderSetFormat               ,


-- ** setHasMipmap #method:setHasMipmap#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetHasMipmapMethodInfo  ,
#endif
    gLTextureBuilderSetHasMipmap            ,


-- ** setHeight #method:setHeight#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetHeightMethodInfo     ,
#endif
    gLTextureBuilderSetHeight               ,


-- ** setId #method:setId#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetIdMethodInfo         ,
#endif
    gLTextureBuilderSetId                   ,


-- ** setSync #method:setSync#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetSyncMethodInfo       ,
#endif
    gLTextureBuilderSetSync                 ,


-- ** setUpdateRegion #method:setUpdateRegion#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetUpdateRegionMethodInfo,
#endif
    gLTextureBuilderSetUpdateRegion         ,


-- ** setUpdateTexture #method:setUpdateTexture#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetUpdateTextureMethodInfo,
#endif
    gLTextureBuilderSetUpdateTexture        ,


-- ** setWidth #method:setWidth#

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSetWidthMethodInfo      ,
#endif
    gLTextureBuilderSetWidth                ,




 -- * Properties


-- ** colorState #attr:colorState#
-- | The color state of the texture.
-- 
-- /Since: 4.16/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderColorStatePropertyInfo  ,
#endif
    constructGLTextureBuilderColorState     ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderColorState              ,
#endif
    getGLTextureBuilderColorState           ,
    setGLTextureBuilderColorState           ,


-- ** context #attr:context#
-- | The context owning the texture.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderContextPropertyInfo     ,
#endif
    clearGLTextureBuilderContext            ,
    constructGLTextureBuilderContext        ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderContext                 ,
#endif
    getGLTextureBuilderContext              ,
    setGLTextureBuilderContext              ,


-- ** format #attr:format#
-- | The format when downloading the texture.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderFormatPropertyInfo      ,
#endif
    constructGLTextureBuilderFormat         ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderFormat                  ,
#endif
    getGLTextureBuilderFormat               ,
    setGLTextureBuilderFormat               ,


-- ** hasMipmap #attr:hasMipmap#
-- | If the texture has a mipmap.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderHasMipmapPropertyInfo   ,
#endif
    constructGLTextureBuilderHasMipmap      ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderHasMipmap               ,
#endif
    getGLTextureBuilderHasMipmap            ,
    setGLTextureBuilderHasMipmap            ,


-- ** height #attr:height#
-- | The height of the texture.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderHeightPropertyInfo      ,
#endif
    constructGLTextureBuilderHeight         ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderHeight                  ,
#endif
    getGLTextureBuilderHeight               ,
    setGLTextureBuilderHeight               ,


-- ** id #attr:id#
-- | The texture ID to use.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderIdPropertyInfo          ,
#endif
    constructGLTextureBuilderId             ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderId                      ,
#endif
    getGLTextureBuilderId                   ,
    setGLTextureBuilderId                   ,


-- ** sync #attr:sync#
-- | An optional @GLSync@ object.
-- 
-- If this is set, GTK will wait on it before using the texture.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderSyncPropertyInfo        ,
#endif
    constructGLTextureBuilderSync           ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderSync                    ,
#endif
    getGLTextureBuilderSync                 ,
    setGLTextureBuilderSync                 ,


-- ** updateRegion #attr:updateRegion#
-- | The update region for [GLTextureBuilder:updateTexture]("GI.Gdk.Objects.GLTextureBuilder#g:attr:updateTexture").
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderUpdateRegionPropertyInfo,
#endif
    clearGLTextureBuilderUpdateRegion       ,
    constructGLTextureBuilderUpdateRegion   ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderUpdateRegion            ,
#endif
    getGLTextureBuilderUpdateRegion         ,
    setGLTextureBuilderUpdateRegion         ,


-- ** updateTexture #attr:updateTexture#
-- | The texture [GLTextureBuilder:updateRegion]("GI.Gdk.Objects.GLTextureBuilder#g:attr:updateRegion") is an update for.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderUpdateTexturePropertyInfo,
#endif
    clearGLTextureBuilderUpdateTexture      ,
    constructGLTextureBuilderUpdateTexture  ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderUpdateTexture           ,
#endif
    getGLTextureBuilderUpdateTexture        ,
    setGLTextureBuilderUpdateTexture        ,


-- ** width #attr:width#
-- | The width of the texture.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    GLTextureBuilderWidthPropertyInfo       ,
#endif
    constructGLTextureBuilderWidth          ,
#if defined(ENABLE_OVERLOADING)
    gLTextureBuilderWidth                   ,
#endif
    getGLTextureBuilderWidth                ,
    setGLTextureBuilderWidth                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState

#endif

-- | Memory-managed wrapper type.
newtype GLTextureBuilder = GLTextureBuilder (SP.ManagedPtr GLTextureBuilder)
    deriving (Eq)

instance SP.ManagedPtrNewtype GLTextureBuilder where
    toManagedPtr (GLTextureBuilder p) = p

foreign import ccall "gdk_gl_texture_builder_get_type"
    c_gdk_gl_texture_builder_get_type :: IO B.Types.GType

instance B.Types.TypedObject GLTextureBuilder where
    glibType = c_gdk_gl_texture_builder_get_type

instance B.Types.GObject GLTextureBuilder

-- | Type class for types which can be safely cast to t'GLTextureBuilder', for instance with `toGLTextureBuilder`.
class (SP.GObject o, O.IsDescendantOf GLTextureBuilder o) => IsGLTextureBuilder o
instance (SP.GObject o, O.IsDescendantOf GLTextureBuilder o) => IsGLTextureBuilder o

instance O.HasParentTypes GLTextureBuilder
type instance O.ParentTypes GLTextureBuilder = '[GObject.Object.Object]

-- | Cast to t'GLTextureBuilder', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGLTextureBuilder :: (MIO.MonadIO m, IsGLTextureBuilder o) => o -> m GLTextureBuilder
toGLTextureBuilder = MIO.liftIO . B.ManagedPtr.unsafeCastTo GLTextureBuilder

-- | Convert t'GLTextureBuilder' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GLTextureBuilder) where
    gvalueGType_ = c_gdk_gl_texture_builder_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GLTextureBuilder)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GLTextureBuilder)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GLTextureBuilder ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGLTextureBuilderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGLTextureBuilderMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGLTextureBuilderMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGLTextureBuilderMethod "build" o = GLTextureBuilderBuildMethodInfo
    ResolveGLTextureBuilderMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGLTextureBuilderMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGLTextureBuilderMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGLTextureBuilderMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGLTextureBuilderMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGLTextureBuilderMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGLTextureBuilderMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGLTextureBuilderMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGLTextureBuilderMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGLTextureBuilderMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGLTextureBuilderMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGLTextureBuilderMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGLTextureBuilderMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGLTextureBuilderMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGLTextureBuilderMethod "getColorState" o = GLTextureBuilderGetColorStateMethodInfo
    ResolveGLTextureBuilderMethod "getContext" o = GLTextureBuilderGetContextMethodInfo
    ResolveGLTextureBuilderMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGLTextureBuilderMethod "getFormat" o = GLTextureBuilderGetFormatMethodInfo
    ResolveGLTextureBuilderMethod "getHasMipmap" o = GLTextureBuilderGetHasMipmapMethodInfo
    ResolveGLTextureBuilderMethod "getHeight" o = GLTextureBuilderGetHeightMethodInfo
    ResolveGLTextureBuilderMethod "getId" o = GLTextureBuilderGetIdMethodInfo
    ResolveGLTextureBuilderMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGLTextureBuilderMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGLTextureBuilderMethod "getSync" o = GLTextureBuilderGetSyncMethodInfo
    ResolveGLTextureBuilderMethod "getUpdateRegion" o = GLTextureBuilderGetUpdateRegionMethodInfo
    ResolveGLTextureBuilderMethod "getUpdateTexture" o = GLTextureBuilderGetUpdateTextureMethodInfo
    ResolveGLTextureBuilderMethod "getWidth" o = GLTextureBuilderGetWidthMethodInfo
    ResolveGLTextureBuilderMethod "setColorState" o = GLTextureBuilderSetColorStateMethodInfo
    ResolveGLTextureBuilderMethod "setContext" o = GLTextureBuilderSetContextMethodInfo
    ResolveGLTextureBuilderMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGLTextureBuilderMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGLTextureBuilderMethod "setFormat" o = GLTextureBuilderSetFormatMethodInfo
    ResolveGLTextureBuilderMethod "setHasMipmap" o = GLTextureBuilderSetHasMipmapMethodInfo
    ResolveGLTextureBuilderMethod "setHeight" o = GLTextureBuilderSetHeightMethodInfo
    ResolveGLTextureBuilderMethod "setId" o = GLTextureBuilderSetIdMethodInfo
    ResolveGLTextureBuilderMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGLTextureBuilderMethod "setSync" o = GLTextureBuilderSetSyncMethodInfo
    ResolveGLTextureBuilderMethod "setUpdateRegion" o = GLTextureBuilderSetUpdateRegionMethodInfo
    ResolveGLTextureBuilderMethod "setUpdateTexture" o = GLTextureBuilderSetUpdateTextureMethodInfo
    ResolveGLTextureBuilderMethod "setWidth" o = GLTextureBuilderSetWidthMethodInfo
    ResolveGLTextureBuilderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGLTextureBuilderMethod t GLTextureBuilder, O.OverloadedMethod info GLTextureBuilder p) => OL.IsLabel t (GLTextureBuilder -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGLTextureBuilderMethod t GLTextureBuilder, O.OverloadedMethod info GLTextureBuilder p, R.HasField t GLTextureBuilder p) => R.HasField t GLTextureBuilder p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGLTextureBuilderMethod t GLTextureBuilder, O.OverloadedMethodInfo info GLTextureBuilder) => OL.IsLabel t (O.MethodProxy info GLTextureBuilder) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "color-state"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ColorState"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@color-state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #colorState
-- @
getGLTextureBuilderColorState :: (MonadIO m, IsGLTextureBuilder o) => o -> m Gdk.ColorState.ColorState
getGLTextureBuilderColorState obj = MIO.liftIO $ checkUnexpectedNothing "getGLTextureBuilderColorState" $ B.Properties.getObjectPropertyBoxed obj "color-state" Gdk.ColorState.ColorState

-- | Set the value of the “@color-state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #colorState 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderColorState :: (MonadIO m, IsGLTextureBuilder o) => o -> Gdk.ColorState.ColorState -> m ()
setGLTextureBuilderColorState obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "color-state" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@color-state@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderColorState :: (IsGLTextureBuilder o, MIO.MonadIO m) => Gdk.ColorState.ColorState -> m (GValueConstruct o)
constructGLTextureBuilderColorState val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "color-state" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderColorStatePropertyInfo
instance AttrInfo GLTextureBuilderColorStatePropertyInfo where
    type AttrAllowedOps GLTextureBuilderColorStatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint GLTextureBuilderColorStatePropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderColorStatePropertyInfo = (~) Gdk.ColorState.ColorState
    type AttrTransferTypeConstraint GLTextureBuilderColorStatePropertyInfo = (~) Gdk.ColorState.ColorState
    type AttrTransferType GLTextureBuilderColorStatePropertyInfo = Gdk.ColorState.ColorState
    type AttrGetType GLTextureBuilderColorStatePropertyInfo = Gdk.ColorState.ColorState
    type AttrLabel GLTextureBuilderColorStatePropertyInfo = "color-state"
    type AttrOrigin GLTextureBuilderColorStatePropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderColorState
    attrSet = setGLTextureBuilderColorState
    attrPut = setGLTextureBuilderColorState
    attrTransfer _ v = do
        return v
    attrConstruct = constructGLTextureBuilderColorState
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.colorState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:colorState"
        })
#endif

-- VVV Prop "context"
   -- Type: TInterface (Name {namespace = "Gdk", name = "GLContext"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@context@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #context
-- @
getGLTextureBuilderContext :: (MonadIO m, IsGLTextureBuilder o) => o -> m (Maybe Gdk.GLContext.GLContext)
getGLTextureBuilderContext obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "context" Gdk.GLContext.GLContext

-- | Set the value of the “@context@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #context 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderContext :: (MonadIO m, IsGLTextureBuilder o, Gdk.GLContext.IsGLContext a) => o -> a -> m ()
setGLTextureBuilderContext obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "context" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@context@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderContext :: (IsGLTextureBuilder o, MIO.MonadIO m, Gdk.GLContext.IsGLContext a) => a -> m (GValueConstruct o)
constructGLTextureBuilderContext val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "context" (P.Just val)

-- | Set the value of the “@context@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #context
-- @
clearGLTextureBuilderContext :: (MonadIO m, IsGLTextureBuilder o) => o -> m ()
clearGLTextureBuilderContext obj = liftIO $ B.Properties.setObjectPropertyObject obj "context" (Nothing :: Maybe Gdk.GLContext.GLContext)

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderContextPropertyInfo
instance AttrInfo GLTextureBuilderContextPropertyInfo where
    type AttrAllowedOps GLTextureBuilderContextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GLTextureBuilderContextPropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderContextPropertyInfo = Gdk.GLContext.IsGLContext
    type AttrTransferTypeConstraint GLTextureBuilderContextPropertyInfo = Gdk.GLContext.IsGLContext
    type AttrTransferType GLTextureBuilderContextPropertyInfo = Gdk.GLContext.GLContext
    type AttrGetType GLTextureBuilderContextPropertyInfo = (Maybe Gdk.GLContext.GLContext)
    type AttrLabel GLTextureBuilderContextPropertyInfo = "context"
    type AttrOrigin GLTextureBuilderContextPropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderContext
    attrSet = setGLTextureBuilderContext
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.GLContext.GLContext v
    attrConstruct = constructGLTextureBuilderContext
    attrClear = clearGLTextureBuilderContext
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.context"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:context"
        })
#endif

-- VVV Prop "format"
   -- Type: TInterface (Name {namespace = "Gdk", name = "MemoryFormat"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@format@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #format
-- @
getGLTextureBuilderFormat :: (MonadIO m, IsGLTextureBuilder o) => o -> m Gdk.Enums.MemoryFormat
getGLTextureBuilderFormat obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "format"

-- | Set the value of the “@format@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #format 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderFormat :: (MonadIO m, IsGLTextureBuilder o) => o -> Gdk.Enums.MemoryFormat -> m ()
setGLTextureBuilderFormat obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "format" val

-- | Construct a t'GValueConstruct' with valid value for the “@format@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderFormat :: (IsGLTextureBuilder o, MIO.MonadIO m) => Gdk.Enums.MemoryFormat -> m (GValueConstruct o)
constructGLTextureBuilderFormat val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "format" val

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderFormatPropertyInfo
instance AttrInfo GLTextureBuilderFormatPropertyInfo where
    type AttrAllowedOps GLTextureBuilderFormatPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint GLTextureBuilderFormatPropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderFormatPropertyInfo = (~) Gdk.Enums.MemoryFormat
    type AttrTransferTypeConstraint GLTextureBuilderFormatPropertyInfo = (~) Gdk.Enums.MemoryFormat
    type AttrTransferType GLTextureBuilderFormatPropertyInfo = Gdk.Enums.MemoryFormat
    type AttrGetType GLTextureBuilderFormatPropertyInfo = Gdk.Enums.MemoryFormat
    type AttrLabel GLTextureBuilderFormatPropertyInfo = "format"
    type AttrOrigin GLTextureBuilderFormatPropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderFormat
    attrSet = setGLTextureBuilderFormat
    attrPut = setGLTextureBuilderFormat
    attrTransfer _ v = do
        return v
    attrConstruct = constructGLTextureBuilderFormat
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.format"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:format"
        })
#endif

-- VVV Prop "has-mipmap"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@has-mipmap@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #hasMipmap
-- @
getGLTextureBuilderHasMipmap :: (MonadIO m, IsGLTextureBuilder o) => o -> m Bool
getGLTextureBuilderHasMipmap obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-mipmap"

-- | Set the value of the “@has-mipmap@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #hasMipmap 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderHasMipmap :: (MonadIO m, IsGLTextureBuilder o) => o -> Bool -> m ()
setGLTextureBuilderHasMipmap obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-mipmap" val

-- | Construct a t'GValueConstruct' with valid value for the “@has-mipmap@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderHasMipmap :: (IsGLTextureBuilder o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructGLTextureBuilderHasMipmap val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-mipmap" val

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderHasMipmapPropertyInfo
instance AttrInfo GLTextureBuilderHasMipmapPropertyInfo where
    type AttrAllowedOps GLTextureBuilderHasMipmapPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint GLTextureBuilderHasMipmapPropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderHasMipmapPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint GLTextureBuilderHasMipmapPropertyInfo = (~) Bool
    type AttrTransferType GLTextureBuilderHasMipmapPropertyInfo = Bool
    type AttrGetType GLTextureBuilderHasMipmapPropertyInfo = Bool
    type AttrLabel GLTextureBuilderHasMipmapPropertyInfo = "has-mipmap"
    type AttrOrigin GLTextureBuilderHasMipmapPropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderHasMipmap
    attrSet = setGLTextureBuilderHasMipmap
    attrPut = setGLTextureBuilderHasMipmap
    attrTransfer _ v = do
        return v
    attrConstruct = constructGLTextureBuilderHasMipmap
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.hasMipmap"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:hasMipmap"
        })
#endif

-- VVV Prop "height"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #height
-- @
getGLTextureBuilderHeight :: (MonadIO m, IsGLTextureBuilder o) => o -> m Int32
getGLTextureBuilderHeight obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "height"

-- | Set the value of the “@height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #height 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderHeight :: (MonadIO m, IsGLTextureBuilder o) => o -> Int32 -> m ()
setGLTextureBuilderHeight obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "height" val

-- | Construct a t'GValueConstruct' with valid value for the “@height@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderHeight :: (IsGLTextureBuilder o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructGLTextureBuilderHeight val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "height" val

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderHeightPropertyInfo
instance AttrInfo GLTextureBuilderHeightPropertyInfo where
    type AttrAllowedOps GLTextureBuilderHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint GLTextureBuilderHeightPropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderHeightPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint GLTextureBuilderHeightPropertyInfo = (~) Int32
    type AttrTransferType GLTextureBuilderHeightPropertyInfo = Int32
    type AttrGetType GLTextureBuilderHeightPropertyInfo = Int32
    type AttrLabel GLTextureBuilderHeightPropertyInfo = "height"
    type AttrOrigin GLTextureBuilderHeightPropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderHeight
    attrSet = setGLTextureBuilderHeight
    attrPut = setGLTextureBuilderHeight
    attrTransfer _ v = do
        return v
    attrConstruct = constructGLTextureBuilderHeight
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.height"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:height"
        })
#endif

-- VVV Prop "id"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #id
-- @
getGLTextureBuilderId :: (MonadIO m, IsGLTextureBuilder o) => o -> m Word32
getGLTextureBuilderId obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "id"

-- | Set the value of the “@id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #id 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderId :: (MonadIO m, IsGLTextureBuilder o) => o -> Word32 -> m ()
setGLTextureBuilderId obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "id" val

-- | Construct a t'GValueConstruct' with valid value for the “@id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderId :: (IsGLTextureBuilder o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructGLTextureBuilderId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "id" val

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderIdPropertyInfo
instance AttrInfo GLTextureBuilderIdPropertyInfo where
    type AttrAllowedOps GLTextureBuilderIdPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint GLTextureBuilderIdPropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderIdPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint GLTextureBuilderIdPropertyInfo = (~) Word32
    type AttrTransferType GLTextureBuilderIdPropertyInfo = Word32
    type AttrGetType GLTextureBuilderIdPropertyInfo = Word32
    type AttrLabel GLTextureBuilderIdPropertyInfo = "id"
    type AttrOrigin GLTextureBuilderIdPropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderId
    attrSet = setGLTextureBuilderId
    attrPut = setGLTextureBuilderId
    attrTransfer _ v = do
        return v
    attrConstruct = constructGLTextureBuilderId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.id"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:id"
        })
#endif

-- VVV Prop "sync"
   -- Type: TBasicType TPtr
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@sync@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #sync
-- @
getGLTextureBuilderSync :: (MonadIO m, IsGLTextureBuilder o) => o -> m (Ptr ())
getGLTextureBuilderSync obj = MIO.liftIO $ B.Properties.getObjectPropertyPtr obj "sync"

-- | Set the value of the “@sync@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #sync 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderSync :: (MonadIO m, IsGLTextureBuilder o) => o -> Ptr () -> m ()
setGLTextureBuilderSync obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyPtr obj "sync" val

-- | Construct a t'GValueConstruct' with valid value for the “@sync@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderSync :: (IsGLTextureBuilder o, MIO.MonadIO m) => Ptr () -> m (GValueConstruct o)
constructGLTextureBuilderSync val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyPtr "sync" val

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSyncPropertyInfo
instance AttrInfo GLTextureBuilderSyncPropertyInfo where
    type AttrAllowedOps GLTextureBuilderSyncPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint GLTextureBuilderSyncPropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderSyncPropertyInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint GLTextureBuilderSyncPropertyInfo = (~) (Ptr ())
    type AttrTransferType GLTextureBuilderSyncPropertyInfo = Ptr ()
    type AttrGetType GLTextureBuilderSyncPropertyInfo = (Ptr ())
    type AttrLabel GLTextureBuilderSyncPropertyInfo = "sync"
    type AttrOrigin GLTextureBuilderSyncPropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderSync
    attrSet = setGLTextureBuilderSync
    attrPut = setGLTextureBuilderSync
    attrTransfer _ v = do
        return v
    attrConstruct = constructGLTextureBuilderSync
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.sync"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:sync"
        })
#endif

-- VVV Prop "update-region"
   -- Type: TInterface (Name {namespace = "cairo", name = "Region"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@update-region@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #updateRegion
-- @
getGLTextureBuilderUpdateRegion :: (MonadIO m, IsGLTextureBuilder o) => o -> m (Maybe Cairo.Region.Region)
getGLTextureBuilderUpdateRegion obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "update-region" Cairo.Region.Region

-- | Set the value of the “@update-region@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #updateRegion 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderUpdateRegion :: (MonadIO m, IsGLTextureBuilder o) => o -> Cairo.Region.Region -> m ()
setGLTextureBuilderUpdateRegion obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "update-region" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@update-region@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderUpdateRegion :: (IsGLTextureBuilder o, MIO.MonadIO m) => Cairo.Region.Region -> m (GValueConstruct o)
constructGLTextureBuilderUpdateRegion val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "update-region" (P.Just val)

-- | Set the value of the “@update-region@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #updateRegion
-- @
clearGLTextureBuilderUpdateRegion :: (MonadIO m, IsGLTextureBuilder o) => o -> m ()
clearGLTextureBuilderUpdateRegion obj = liftIO $ B.Properties.setObjectPropertyBoxed obj "update-region" (Nothing :: Maybe Cairo.Region.Region)

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderUpdateRegionPropertyInfo
instance AttrInfo GLTextureBuilderUpdateRegionPropertyInfo where
    type AttrAllowedOps GLTextureBuilderUpdateRegionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GLTextureBuilderUpdateRegionPropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderUpdateRegionPropertyInfo = (~) Cairo.Region.Region
    type AttrTransferTypeConstraint GLTextureBuilderUpdateRegionPropertyInfo = (~) Cairo.Region.Region
    type AttrTransferType GLTextureBuilderUpdateRegionPropertyInfo = Cairo.Region.Region
    type AttrGetType GLTextureBuilderUpdateRegionPropertyInfo = (Maybe Cairo.Region.Region)
    type AttrLabel GLTextureBuilderUpdateRegionPropertyInfo = "update-region"
    type AttrOrigin GLTextureBuilderUpdateRegionPropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderUpdateRegion
    attrSet = setGLTextureBuilderUpdateRegion
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructGLTextureBuilderUpdateRegion
    attrClear = clearGLTextureBuilderUpdateRegion
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.updateRegion"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:updateRegion"
        })
#endif

-- VVV Prop "update-texture"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Texture"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@update-texture@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #updateTexture
-- @
getGLTextureBuilderUpdateTexture :: (MonadIO m, IsGLTextureBuilder o) => o -> m (Maybe Gdk.Texture.Texture)
getGLTextureBuilderUpdateTexture obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "update-texture" Gdk.Texture.Texture

-- | Set the value of the “@update-texture@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #updateTexture 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderUpdateTexture :: (MonadIO m, IsGLTextureBuilder o, Gdk.Texture.IsTexture a) => o -> a -> m ()
setGLTextureBuilderUpdateTexture obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "update-texture" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@update-texture@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderUpdateTexture :: (IsGLTextureBuilder o, MIO.MonadIO m, Gdk.Texture.IsTexture a) => a -> m (GValueConstruct o)
constructGLTextureBuilderUpdateTexture val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "update-texture" (P.Just val)

-- | Set the value of the “@update-texture@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #updateTexture
-- @
clearGLTextureBuilderUpdateTexture :: (MonadIO m, IsGLTextureBuilder o) => o -> m ()
clearGLTextureBuilderUpdateTexture obj = liftIO $ B.Properties.setObjectPropertyObject obj "update-texture" (Nothing :: Maybe Gdk.Texture.Texture)

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderUpdateTexturePropertyInfo
instance AttrInfo GLTextureBuilderUpdateTexturePropertyInfo where
    type AttrAllowedOps GLTextureBuilderUpdateTexturePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GLTextureBuilderUpdateTexturePropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderUpdateTexturePropertyInfo = Gdk.Texture.IsTexture
    type AttrTransferTypeConstraint GLTextureBuilderUpdateTexturePropertyInfo = Gdk.Texture.IsTexture
    type AttrTransferType GLTextureBuilderUpdateTexturePropertyInfo = Gdk.Texture.Texture
    type AttrGetType GLTextureBuilderUpdateTexturePropertyInfo = (Maybe Gdk.Texture.Texture)
    type AttrLabel GLTextureBuilderUpdateTexturePropertyInfo = "update-texture"
    type AttrOrigin GLTextureBuilderUpdateTexturePropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderUpdateTexture
    attrSet = setGLTextureBuilderUpdateTexture
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Texture.Texture v
    attrConstruct = constructGLTextureBuilderUpdateTexture
    attrClear = clearGLTextureBuilderUpdateTexture
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.updateTexture"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:updateTexture"
        })
#endif

-- VVV Prop "width"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLTextureBuilder #width
-- @
getGLTextureBuilderWidth :: (MonadIO m, IsGLTextureBuilder o) => o -> m Int32
getGLTextureBuilderWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "width"

-- | Set the value of the “@width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gLTextureBuilder [ #width 'Data.GI.Base.Attributes.:=' value ]
-- @
setGLTextureBuilderWidth :: (MonadIO m, IsGLTextureBuilder o) => o -> Int32 -> m ()
setGLTextureBuilderWidth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "width" val

-- | Construct a t'GValueConstruct' with valid value for the “@width@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLTextureBuilderWidth :: (IsGLTextureBuilder o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructGLTextureBuilderWidth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "width" val

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderWidthPropertyInfo
instance AttrInfo GLTextureBuilderWidthPropertyInfo where
    type AttrAllowedOps GLTextureBuilderWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint GLTextureBuilderWidthPropertyInfo = IsGLTextureBuilder
    type AttrSetTypeConstraint GLTextureBuilderWidthPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint GLTextureBuilderWidthPropertyInfo = (~) Int32
    type AttrTransferType GLTextureBuilderWidthPropertyInfo = Int32
    type AttrGetType GLTextureBuilderWidthPropertyInfo = Int32
    type AttrLabel GLTextureBuilderWidthPropertyInfo = "width"
    type AttrOrigin GLTextureBuilderWidthPropertyInfo = GLTextureBuilder
    attrGet = getGLTextureBuilderWidth
    attrSet = setGLTextureBuilderWidth
    attrPut = setGLTextureBuilderWidth
    attrTransfer _ v = do
        return v
    attrConstruct = constructGLTextureBuilderWidth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.width"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#g:attr:width"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GLTextureBuilder
type instance O.AttributeList GLTextureBuilder = GLTextureBuilderAttributeList
type GLTextureBuilderAttributeList = ('[ '("colorState", GLTextureBuilderColorStatePropertyInfo), '("context", GLTextureBuilderContextPropertyInfo), '("format", GLTextureBuilderFormatPropertyInfo), '("hasMipmap", GLTextureBuilderHasMipmapPropertyInfo), '("height", GLTextureBuilderHeightPropertyInfo), '("id", GLTextureBuilderIdPropertyInfo), '("sync", GLTextureBuilderSyncPropertyInfo), '("updateRegion", GLTextureBuilderUpdateRegionPropertyInfo), '("updateTexture", GLTextureBuilderUpdateTexturePropertyInfo), '("width", GLTextureBuilderWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
gLTextureBuilderColorState :: AttrLabelProxy "colorState"
gLTextureBuilderColorState = AttrLabelProxy

gLTextureBuilderContext :: AttrLabelProxy "context"
gLTextureBuilderContext = AttrLabelProxy

gLTextureBuilderFormat :: AttrLabelProxy "format"
gLTextureBuilderFormat = AttrLabelProxy

gLTextureBuilderHasMipmap :: AttrLabelProxy "hasMipmap"
gLTextureBuilderHasMipmap = AttrLabelProxy

gLTextureBuilderHeight :: AttrLabelProxy "height"
gLTextureBuilderHeight = AttrLabelProxy

gLTextureBuilderId :: AttrLabelProxy "id"
gLTextureBuilderId = AttrLabelProxy

gLTextureBuilderSync :: AttrLabelProxy "sync"
gLTextureBuilderSync = AttrLabelProxy

gLTextureBuilderUpdateRegion :: AttrLabelProxy "updateRegion"
gLTextureBuilderUpdateRegion = AttrLabelProxy

gLTextureBuilderUpdateTexture :: AttrLabelProxy "updateTexture"
gLTextureBuilderUpdateTexture = AttrLabelProxy

gLTextureBuilderWidth :: AttrLabelProxy "width"
gLTextureBuilderWidth = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GLTextureBuilder = GLTextureBuilderSignalList
type GLTextureBuilderSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GLTextureBuilder::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_new" gdk_gl_texture_builder_new :: 
    IO (Ptr GLTextureBuilder)

-- | Creates a new texture builder.
-- 
-- /Since: 4.12/
gLTextureBuilderNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GLTextureBuilder
    -- ^ __Returns:__ the new @GdkTextureBuilder@
gLTextureBuilderNew  = liftIO $ do
    result <- gdk_gl_texture_builder_new
    checkUnexpectedReturnNULL "gLTextureBuilderNew" result
    result' <- (wrapObject GLTextureBuilder) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GLTextureBuilder::build
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "destroy function to be called when the texture is\n  released"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to the destroy function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Texture" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_build" gdk_gl_texture_builder_build :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO (Ptr Gdk.Texture.Texture)

-- | Builds a new @GdkTexture@ with the values set up in the builder.
-- 
-- The @destroy@ function gets called when the returned texture gets released;
-- either when the texture is finalized or by an explicit call to
-- 'GI.Gdk.Objects.GLTexture.gLTextureRelease'. It should release all GL resources associated
-- with the texture, such as the [GLTextureBuilder:id]("GI.Gdk.Objects.GLTextureBuilder#g:attr:id") and the
-- [GLTextureBuilder:sync]("GI.Gdk.Objects.GLTextureBuilder#g:attr:sync").
-- 
-- Note that it is a programming error to call this function if any mandatory
-- property has not been set.
-- 
-- It is possible to call this function multiple times to create multiple textures,
-- possibly with changing properties in between.
-- 
-- /Since: 4.12/
gLTextureBuilderBuild ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Maybe (GLib.Callbacks.DestroyNotify)
    -- ^ /@destroy@/: destroy function to be called when the texture is
    --   released
    -> Ptr ()
    -- ^ /@data@/: user data to pass to the destroy function
    -> m Gdk.Texture.Texture
    -- ^ __Returns:__ a newly built @GdkTexture@
gLTextureBuilderBuild self destroy data_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeDestroy <- case destroy of
        Nothing -> return FP.nullFunPtr
        Just jDestroy -> do
            ptrdestroy <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jDestroy' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroy) jDestroy)
            poke ptrdestroy jDestroy'
            return jDestroy'
    result <- gdk_gl_texture_builder_build self' maybeDestroy data_
    checkUnexpectedReturnNULL "gLTextureBuilderBuild" result
    result' <- (wrapObject Gdk.Texture.Texture) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderBuildMethodInfo
instance (signature ~ (Maybe (GLib.Callbacks.DestroyNotify) -> Ptr () -> m Gdk.Texture.Texture), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderBuildMethodInfo a signature where
    overloadedMethod = gLTextureBuilderBuild

instance O.OverloadedMethodInfo GLTextureBuilderBuildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderBuild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderBuild"
        })


#endif

-- method GLTextureBuilder::get_color_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_color_state" gdk_gl_texture_builder_get_color_state :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO (Ptr Gdk.ColorState.ColorState)

-- | Gets the color state previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetColorState'.
-- 
-- /Since: 4.16/
gLTextureBuilderGetColorState ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m Gdk.ColorState.ColorState
    -- ^ __Returns:__ the color state
gLTextureBuilderGetColorState self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_color_state self'
    checkUnexpectedReturnNULL "gLTextureBuilderGetColorState" result
    result' <- (newBoxed Gdk.ColorState.ColorState) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetColorStateMethodInfo
instance (signature ~ (m Gdk.ColorState.ColorState), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetColorStateMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetColorState

instance O.OverloadedMethodInfo GLTextureBuilderGetColorStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetColorState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetColorState"
        })


#endif

-- method GLTextureBuilder::get_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GLContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_context" gdk_gl_texture_builder_get_context :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO (Ptr Gdk.GLContext.GLContext)

-- | Gets the context previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetContext' or
-- 'P.Nothing' if none was set.
-- 
-- /Since: 4.12/
gLTextureBuilderGetContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m (Maybe Gdk.GLContext.GLContext)
    -- ^ __Returns:__ The context
gLTextureBuilderGetContext self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_context self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.GLContext.GLContext) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetContextMethodInfo
instance (signature ~ (m (Maybe Gdk.GLContext.GLContext)), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetContextMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetContext

instance O.OverloadedMethodInfo GLTextureBuilderGetContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetContext"
        })


#endif

-- method GLTextureBuilder::get_format
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "MemoryFormat" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_format" gdk_gl_texture_builder_get_format :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO CUInt

-- | Gets the format previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetFormat'.
-- 
-- /Since: 4.12/
gLTextureBuilderGetFormat ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m Gdk.Enums.MemoryFormat
    -- ^ __Returns:__ The format
gLTextureBuilderGetFormat self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_format self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetFormatMethodInfo
instance (signature ~ (m Gdk.Enums.MemoryFormat), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetFormatMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetFormat

instance O.OverloadedMethodInfo GLTextureBuilderGetFormatMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetFormat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetFormat"
        })


#endif

-- method GLTextureBuilder::get_has_mipmap
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_has_mipmap" gdk_gl_texture_builder_get_has_mipmap :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO CInt

-- | Gets whether the texture has a mipmap.
-- 
-- /Since: 4.12/
gLTextureBuilderGetHasMipmap ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m Bool
    -- ^ __Returns:__ Whether the texture has a mipmap
gLTextureBuilderGetHasMipmap self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_has_mipmap self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetHasMipmapMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetHasMipmapMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetHasMipmap

instance O.OverloadedMethodInfo GLTextureBuilderGetHasMipmapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetHasMipmap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetHasMipmap"
        })


#endif

-- method GLTextureBuilder::get_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_height" gdk_gl_texture_builder_get_height :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO Int32

-- | Gets the height previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetHeight' or
-- 0 if the height wasn\'t set.
-- 
-- /Since: 4.12/
gLTextureBuilderGetHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m Int32
    -- ^ __Returns:__ The height
gLTextureBuilderGetHeight self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_height self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetHeightMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetHeightMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetHeight

instance O.OverloadedMethodInfo GLTextureBuilderGetHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetHeight"
        })


#endif

-- method GLTextureBuilder::get_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_id" gdk_gl_texture_builder_get_id :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO Word32

-- | Gets the texture id previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetId' or
-- 0 if the id wasn\'t set.
-- 
-- /Since: 4.12/
gLTextureBuilderGetId ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m Word32
    -- ^ __Returns:__ The id
gLTextureBuilderGetId self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_id self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetIdMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetIdMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetId

instance O.OverloadedMethodInfo GLTextureBuilderGetIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetId"
        })


#endif

-- method GLTextureBuilder::get_sync
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_sync" gdk_gl_texture_builder_get_sync :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO (Ptr ())

-- | Gets the @GLsync@ previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetSync'.
-- 
-- /Since: 4.12/
gLTextureBuilderGetSync ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m (Ptr ())
    -- ^ __Returns:__ the @GLSync@
gLTextureBuilderGetSync self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_sync self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetSyncMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetSyncMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetSync

instance O.OverloadedMethodInfo GLTextureBuilderGetSyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetSync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetSync"
        })


#endif

-- method GLTextureBuilder::get_update_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_update_region" gdk_gl_texture_builder_get_update_region :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO (Ptr Cairo.Region.Region)

-- | Gets the region previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetUpdateRegion' or
-- 'P.Nothing' if none was set.
-- 
-- /Since: 4.12/
gLTextureBuilderGetUpdateRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m (Maybe Cairo.Region.Region)
    -- ^ __Returns:__ The region
gLTextureBuilderGetUpdateRegion self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_update_region self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Cairo.Region.Region) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetUpdateRegionMethodInfo
instance (signature ~ (m (Maybe Cairo.Region.Region)), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetUpdateRegionMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetUpdateRegion

instance O.OverloadedMethodInfo GLTextureBuilderGetUpdateRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetUpdateRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetUpdateRegion"
        })


#endif

-- method GLTextureBuilder::get_update_texture
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Texture" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_update_texture" gdk_gl_texture_builder_get_update_texture :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO (Ptr Gdk.Texture.Texture)

-- | Gets the texture previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetUpdateTexture' or
-- 'P.Nothing' if none was set.
-- 
-- /Since: 4.12/
gLTextureBuilderGetUpdateTexture ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m (Maybe Gdk.Texture.Texture)
    -- ^ __Returns:__ The texture
gLTextureBuilderGetUpdateTexture self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_update_texture self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Texture.Texture) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetUpdateTextureMethodInfo
instance (signature ~ (m (Maybe Gdk.Texture.Texture)), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetUpdateTextureMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetUpdateTexture

instance O.OverloadedMethodInfo GLTextureBuilderGetUpdateTextureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetUpdateTexture",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetUpdateTexture"
        })


#endif

-- method GLTextureBuilder::get_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_get_width" gdk_gl_texture_builder_get_width :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    IO Int32

-- | Gets the width previously set via 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetWidth' or
-- 0 if the width wasn\'t set.
-- 
-- /Since: 4.12/
gLTextureBuilderGetWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> m Int32
    -- ^ __Returns:__ The width
gLTextureBuilderGetWidth self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_gl_texture_builder_get_width self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderGetWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderGetWidthMethodInfo a signature where
    overloadedMethod = gLTextureBuilderGetWidth

instance O.OverloadedMethodInfo GLTextureBuilderGetWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderGetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderGetWidth"
        })


#endif

-- method GLTextureBuilder::set_color_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_state"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkColorState`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_color_state" gdk_gl_texture_builder_set_color_state :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    Ptr Gdk.ColorState.ColorState ->        -- color_state : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    IO ()

-- | Sets the color state for the texture.
-- 
-- By default, the sRGB colorstate is used. If you don\'t know what
-- colorstates are, this is probably the right thing.
-- 
-- /Since: 4.16/
gLTextureBuilderSetColorState ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Gdk.ColorState.ColorState
    -- ^ /@colorState@/: a @GdkColorState@
    -> m ()
gLTextureBuilderSetColorState self colorState = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    colorState' <- unsafeManagedPtrGetPtr colorState
    gdk_gl_texture_builder_set_color_state self' colorState'
    touchManagedPtr self
    touchManagedPtr colorState
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetColorStateMethodInfo
instance (signature ~ (Gdk.ColorState.ColorState -> m ()), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderSetColorStateMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetColorState

instance O.OverloadedMethodInfo GLTextureBuilderSetColorStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetColorState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetColorState"
        })


#endif

-- method GLTextureBuilder::set_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The context the texture belongs to or %NULL to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_context" gdk_gl_texture_builder_set_context :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    Ptr Gdk.GLContext.GLContext ->          -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO ()

-- | Sets the context to be used for the texture. This is the context that owns
-- the texture.
-- 
-- The context must be set before calling 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderBuild'.
-- 
-- /Since: 4.12/
gLTextureBuilderSetContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a, Gdk.GLContext.IsGLContext b) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Maybe (b)
    -- ^ /@context@/: The context the texture belongs to or 'P.Nothing' to unset
    -> m ()
gLTextureBuilderSetContext self context = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrCastPtr jContext
            return jContext'
    gdk_gl_texture_builder_set_context self' maybeContext
    touchManagedPtr self
    whenJust context touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetContextMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsGLTextureBuilder a, Gdk.GLContext.IsGLContext b) => O.OverloadedMethod GLTextureBuilderSetContextMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetContext

instance O.OverloadedMethodInfo GLTextureBuilderSetContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetContext"
        })


#endif

-- method GLTextureBuilder::set_format
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "MemoryFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The texture's format"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_format" gdk_gl_texture_builder_set_format :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    CUInt ->                                -- format : TInterface (Name {namespace = "Gdk", name = "MemoryFormat"})
    IO ()

-- | Sets the format of the texture. The default is @GDK_MEMORY_R8G8B8A8_PREMULTIPLIED@.
-- 
-- The format is the preferred format the texture data should be downloaded to. The
-- format must be supported by the GL version of [GLTextureBuilder:context]("GI.Gdk.Objects.GLTextureBuilder#g:attr:context").
-- 
-- GDK\'s texture download code assumes that the format corresponds to the storage
-- parameters of the GL texture in an obvious way. For example, a format of
-- @GDK_MEMORY_R16G16B16A16_PREMULTIPLIED@ is expected to be stored as @GL_RGBA16@
-- texture, and @GDK_MEMORY_G8A8@ is expected to be stored as @GL_RG8@ texture.
-- 
-- Setting the right format is particularly useful when using high bit depth textures
-- to preserve the bit depth, to set the correct value for unpremultiplied textures
-- and to make sure opaque textures are treated as such.
-- 
-- Non-RGBA textures need to have swizzling parameters set up properly to be usable
-- in GSK\'s shaders.
-- 
-- /Since: 4.12/
gLTextureBuilderSetFormat ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Gdk.Enums.MemoryFormat
    -- ^ /@format@/: The texture\'s format
    -> m ()
gLTextureBuilderSetFormat self format = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let format' = (fromIntegral . fromEnum) format
    gdk_gl_texture_builder_set_format self' format'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetFormatMethodInfo
instance (signature ~ (Gdk.Enums.MemoryFormat -> m ()), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderSetFormatMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetFormat

instance O.OverloadedMethodInfo GLTextureBuilderSetFormatMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetFormat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetFormat"
        })


#endif

-- method GLTextureBuilder::set_has_mipmap
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_mipmap"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Whether the texture has a mipmap"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_has_mipmap" gdk_gl_texture_builder_set_has_mipmap :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    CInt ->                                 -- has_mipmap : TBasicType TBoolean
    IO ()

-- | Sets whether the texture has a mipmap. This allows the renderer and other users of the
-- generated texture to use a higher quality downscaling.
-- 
-- Typically, the @glGenerateMipmap@ function is used to generate a mimap.
-- 
-- /Since: 4.12/
gLTextureBuilderSetHasMipmap ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Bool
    -- ^ /@hasMipmap@/: Whether the texture has a mipmap
    -> m ()
gLTextureBuilderSetHasMipmap self hasMipmap = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let hasMipmap' = (P.fromIntegral . P.fromEnum) hasMipmap
    gdk_gl_texture_builder_set_has_mipmap self' hasMipmap'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetHasMipmapMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderSetHasMipmapMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetHasMipmap

instance O.OverloadedMethodInfo GLTextureBuilderSetHasMipmapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetHasMipmap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetHasMipmap"
        })


#endif

-- method GLTextureBuilder::set_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The texture's height or 0 to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_height" gdk_gl_texture_builder_set_height :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Sets the height of the texture.
-- 
-- The height must be set before calling 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderBuild'.
-- 
-- /Since: 4.12/
gLTextureBuilderSetHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Int32
    -- ^ /@height@/: The texture\'s height or 0 to unset
    -> m ()
gLTextureBuilderSetHeight self height = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_gl_texture_builder_set_height self' height
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetHeightMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderSetHeightMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetHeight

instance O.OverloadedMethodInfo GLTextureBuilderSetHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetHeight"
        })


#endif

-- method GLTextureBuilder::set_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The texture id to be used for creating the texture"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_id" gdk_gl_texture_builder_set_id :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    Word32 ->                               -- id : TBasicType TUInt
    IO ()

-- | Sets the texture id of the texture. The texture id must remain unmodified
-- until the texture was finalized. See 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderBuild'
-- for a longer discussion.
-- 
-- The id must be set before calling 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderBuild'.
-- 
-- /Since: 4.12/
gLTextureBuilderSetId ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Word32
    -- ^ /@id@/: The texture id to be used for creating the texture
    -> m ()
gLTextureBuilderSetId self id = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_gl_texture_builder_set_id self' id
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetIdMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderSetIdMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetId

instance O.OverloadedMethodInfo GLTextureBuilderSetIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetId"
        })


#endif

-- method GLTextureBuilder::set_sync
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sync"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the GLSync object" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_sync" gdk_gl_texture_builder_set_sync :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    Ptr () ->                               -- sync : TBasicType TPtr
    IO ()

-- | Sets the GLSync object to use for the texture.
-- 
-- GTK will wait on this object before using the created @GdkTexture@.
-- 
-- The @destroy@ function that is passed to 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderBuild'
-- is responsible for freeing the sync object when it is no longer needed.
-- The texture builder does not destroy it and it is the callers
-- responsibility to make sure it doesn\'t leak.
-- 
-- /Since: 4.12/
gLTextureBuilderSetSync ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Ptr ()
    -- ^ /@sync@/: the GLSync object
    -> m ()
gLTextureBuilderSetSync self sync = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_gl_texture_builder_set_sync self' sync
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetSyncMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderSetSyncMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetSync

instance O.OverloadedMethodInfo GLTextureBuilderSetSyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetSync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetSync"
        })


#endif

-- method GLTextureBuilder::set_update_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the region to update"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_update_region" gdk_gl_texture_builder_set_update_region :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO ()

-- | Sets the region to be updated by this texture. Together with
-- [GLTextureBuilder:updateTexture]("GI.Gdk.Objects.GLTextureBuilder#g:attr:updateTexture") this describes an
-- update of a previous texture.
-- 
-- When rendering animations of large textures, it is possible that
-- consecutive textures are only updating contents in parts of the texture.
-- It is then possible to describe this update via these two properties,
-- so that GTK can avoid rerendering parts that did not change.
-- 
-- An example would be a screen recording where only the mouse pointer moves.
-- 
-- /Since: 4.12/
gLTextureBuilderSetUpdateRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Maybe (Cairo.Region.Region)
    -- ^ /@region@/: the region to update
    -> m ()
gLTextureBuilderSetUpdateRegion self region = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeRegion <- case region of
        Nothing -> return FP.nullPtr
        Just jRegion -> do
            jRegion' <- unsafeManagedPtrGetPtr jRegion
            return jRegion'
    gdk_gl_texture_builder_set_update_region self' maybeRegion
    touchManagedPtr self
    whenJust region touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetUpdateRegionMethodInfo
instance (signature ~ (Maybe (Cairo.Region.Region) -> m ()), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderSetUpdateRegionMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetUpdateRegion

instance O.OverloadedMethodInfo GLTextureBuilderSetUpdateRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetUpdateRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetUpdateRegion"
        })


#endif

-- method GLTextureBuilder::set_update_texture
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "texture"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Texture" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the texture to update"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_update_texture" gdk_gl_texture_builder_set_update_texture :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    Ptr Gdk.Texture.Texture ->              -- texture : TInterface (Name {namespace = "Gdk", name = "Texture"})
    IO ()

-- | Sets the texture to be updated by this texture. See
-- 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetUpdateRegion' for an explanation.
-- 
-- /Since: 4.12/
gLTextureBuilderSetUpdateTexture ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a, Gdk.Texture.IsTexture b) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Maybe (b)
    -- ^ /@texture@/: the texture to update
    -> m ()
gLTextureBuilderSetUpdateTexture self texture = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeTexture <- case texture of
        Nothing -> return FP.nullPtr
        Just jTexture -> do
            jTexture' <- unsafeManagedPtrCastPtr jTexture
            return jTexture'
    gdk_gl_texture_builder_set_update_texture self' maybeTexture
    touchManagedPtr self
    whenJust texture touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetUpdateTextureMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsGLTextureBuilder a, Gdk.Texture.IsTexture b) => O.OverloadedMethod GLTextureBuilderSetUpdateTextureMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetUpdateTexture

instance O.OverloadedMethodInfo GLTextureBuilderSetUpdateTextureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetUpdateTexture",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetUpdateTexture"
        })


#endif

-- method GLTextureBuilder::set_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTextureBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLTextureBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The texture's width or 0 to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_builder_set_width" gdk_gl_texture_builder_set_width :: 
    Ptr GLTextureBuilder ->                 -- self : TInterface (Name {namespace = "Gdk", name = "GLTextureBuilder"})
    Int32 ->                                -- width : TBasicType TInt
    IO ()

-- | Sets the width of the texture.
-- 
-- The width must be set before calling 'GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderBuild'.
-- 
-- /Since: 4.12/
gLTextureBuilderSetWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTextureBuilder a) =>
    a
    -- ^ /@self@/: a @GdkGLTextureBuilder@
    -> Int32
    -- ^ /@width@/: The texture\'s width or 0 to unset
    -> m ()
gLTextureBuilderSetWidth self width = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_gl_texture_builder_set_width self' width
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureBuilderSetWidthMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGLTextureBuilder a) => O.OverloadedMethod GLTextureBuilderSetWidthMethodInfo a signature where
    overloadedMethod = gLTextureBuilderSetWidth

instance O.OverloadedMethodInfo GLTextureBuilderSetWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTextureBuilder.gLTextureBuilderSetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTextureBuilder.html#v:gLTextureBuilderSetWidth"
        })


#endif


