{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Contains information that is necessary to present a sovereign
-- window on screen.
-- 
-- The @GdkToplevelLayout@ struct is necessary for using
-- 'GI.Gdk.Interfaces.Toplevel.toplevelPresent'.
-- 
-- Toplevel surfaces are sovereign windows that can be presented
-- to the user in various states (maximized, on all workspaces,
-- etc).

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.ToplevelLayout
    ( 

-- * Exported types
    ToplevelLayout(..)                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.Gdk.Structs.ToplevelLayout#g:method:copy"), [equal]("GI.Gdk.Structs.ToplevelLayout#g:method:equal"), [ref]("GI.Gdk.Structs.ToplevelLayout#g:method:ref"), [unref]("GI.Gdk.Structs.ToplevelLayout#g:method:unref").
-- 
-- ==== Getters
-- [getFullscreen]("GI.Gdk.Structs.ToplevelLayout#g:method:getFullscreen"), [getFullscreenMonitor]("GI.Gdk.Structs.ToplevelLayout#g:method:getFullscreenMonitor"), [getMaximized]("GI.Gdk.Structs.ToplevelLayout#g:method:getMaximized"), [getResizable]("GI.Gdk.Structs.ToplevelLayout#g:method:getResizable").
-- 
-- ==== Setters
-- [setFullscreen]("GI.Gdk.Structs.ToplevelLayout#g:method:setFullscreen"), [setMaximized]("GI.Gdk.Structs.ToplevelLayout#g:method:setMaximized"), [setResizable]("GI.Gdk.Structs.ToplevelLayout#g:method:setResizable").

#if defined(ENABLE_OVERLOADING)
    ResolveToplevelLayoutMethod             ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutCopyMethodInfo            ,
#endif
    toplevelLayoutCopy                      ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutEqualMethodInfo           ,
#endif
    toplevelLayoutEqual                     ,


-- ** getFullscreen #method:getFullscreen#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutGetFullscreenMethodInfo   ,
#endif
    toplevelLayoutGetFullscreen             ,


-- ** getFullscreenMonitor #method:getFullscreenMonitor#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutGetFullscreenMonitorMethodInfo,
#endif
    toplevelLayoutGetFullscreenMonitor      ,


-- ** getMaximized #method:getMaximized#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutGetMaximizedMethodInfo    ,
#endif
    toplevelLayoutGetMaximized              ,


-- ** getResizable #method:getResizable#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutGetResizableMethodInfo    ,
#endif
    toplevelLayoutGetResizable              ,


-- ** new #method:new#

    toplevelLayoutNew                       ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutRefMethodInfo             ,
#endif
    toplevelLayoutRef                       ,


-- ** setFullscreen #method:setFullscreen#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutSetFullscreenMethodInfo   ,
#endif
    toplevelLayoutSetFullscreen             ,


-- ** setMaximized #method:setMaximized#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutSetMaximizedMethodInfo    ,
#endif
    toplevelLayoutSetMaximized              ,


-- ** setResizable #method:setResizable#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutSetResizableMethodInfo    ,
#endif
    toplevelLayoutSetResizable              ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    ToplevelLayoutUnrefMethodInfo           ,
#endif
    toplevelLayoutUnref                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor

#endif

-- | Memory-managed wrapper type.
newtype ToplevelLayout = ToplevelLayout (SP.ManagedPtr ToplevelLayout)
    deriving (Eq)

instance SP.ManagedPtrNewtype ToplevelLayout where
    toManagedPtr (ToplevelLayout p) = p

foreign import ccall "gdk_toplevel_layout_get_type" c_gdk_toplevel_layout_get_type :: 
    IO GType

type instance O.ParentTypes ToplevelLayout = '[]
instance O.HasParentTypes ToplevelLayout

instance B.Types.TypedObject ToplevelLayout where
    glibType = c_gdk_toplevel_layout_get_type

instance B.Types.GBoxed ToplevelLayout

-- | Convert t'ToplevelLayout' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ToplevelLayout) where
    gvalueGType_ = c_gdk_toplevel_layout_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ToplevelLayout)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ToplevelLayout)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ToplevelLayout ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ToplevelLayout
type instance O.AttributeList ToplevelLayout = ToplevelLayoutAttributeList
type ToplevelLayoutAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method ToplevelLayout::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_new" gdk_toplevel_layout_new :: 
    IO (Ptr ToplevelLayout)

-- | Create a toplevel layout description.
-- 
-- Used together with 'GI.Gdk.Interfaces.Toplevel.toplevelPresent' to describe
-- how a toplevel surface should be placed and behave on-screen.
-- 
-- The size is in ”application pixels”, not
-- ”device pixels” (see 'GI.Gdk.Objects.Surface.surfaceGetScale').
toplevelLayoutNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ToplevelLayout
    -- ^ __Returns:__ newly created instance of @GdkToplevelLayout@
toplevelLayoutNew  = liftIO $ do
    result <- gdk_toplevel_layout_new
    checkUnexpectedReturnNULL "toplevelLayoutNew" result
    result' <- (wrapBoxed ToplevelLayout) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ToplevelLayout::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_copy" gdk_toplevel_layout_copy :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    IO (Ptr ToplevelLayout)

-- | Create a new @GdkToplevelLayout@ and copy the contents of /@layout@/ into it.
toplevelLayoutCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> m ToplevelLayout
    -- ^ __Returns:__ a copy of /@layout@/.
toplevelLayoutCopy layout = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    result <- gdk_toplevel_layout_copy layout'
    checkUnexpectedReturnNULL "toplevelLayoutCopy" result
    result' <- (wrapBoxed ToplevelLayout) result
    touchManagedPtr layout
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutCopyMethodInfo
instance (signature ~ (m ToplevelLayout), MonadIO m) => O.OverloadedMethod ToplevelLayoutCopyMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutCopy

instance O.OverloadedMethodInfo ToplevelLayoutCopyMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutCopy"
        })


#endif

-- method ToplevelLayout::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "other"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another toplevel layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_equal" gdk_toplevel_layout_equal :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    Ptr ToplevelLayout ->                   -- other : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    IO CInt

-- | Check whether /@layout@/ and /@other@/ has identical layout properties.
toplevelLayoutEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> ToplevelLayout
    -- ^ /@other@/: another toplevel layout
    -> m Bool
    -- ^ __Returns:__ true if /@layout@/ and /@other@/ have identical layout properties,
    --   otherwise false.
toplevelLayoutEqual layout other = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    other' <- unsafeManagedPtrGetPtr other
    result <- gdk_toplevel_layout_equal layout' other'
    let result' = (/= 0) result
    touchManagedPtr layout
    touchManagedPtr other
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutEqualMethodInfo
instance (signature ~ (ToplevelLayout -> m Bool), MonadIO m) => O.OverloadedMethod ToplevelLayoutEqualMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutEqual

instance O.OverloadedMethodInfo ToplevelLayoutEqualMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutEqual"
        })


#endif

-- method ToplevelLayout::get_fullscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fullscreen"
--           , argType = TBasicType TBoolean
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store whether the toplevel should be fullscreen"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_get_fullscreen" gdk_toplevel_layout_get_fullscreen :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    Ptr CInt ->                             -- fullscreen : TBasicType TBoolean
    IO CInt

-- | If the layout specifies whether to the toplevel should go fullscreen,
-- the value pointed to by /@fullscreen@/ is set to true if it should go
-- fullscreen, or false, if it should go unfullscreen.
toplevelLayoutGetFullscreen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> m ((Bool, Bool))
    -- ^ __Returns:__ whether the /@layout@/ specifies the fullscreen state for the toplevel
toplevelLayoutGetFullscreen layout = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    fullscreen <- allocMem :: IO (Ptr CInt)
    result <- gdk_toplevel_layout_get_fullscreen layout' fullscreen
    let result' = (/= 0) result
    fullscreen' <- peek fullscreen
    let fullscreen'' = (/= 0) fullscreen'
    touchManagedPtr layout
    freeMem fullscreen
    return (result', fullscreen'')

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutGetFullscreenMethodInfo
instance (signature ~ (m ((Bool, Bool))), MonadIO m) => O.OverloadedMethod ToplevelLayoutGetFullscreenMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutGetFullscreen

instance O.OverloadedMethodInfo ToplevelLayoutGetFullscreenMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutGetFullscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutGetFullscreen"
        })


#endif

-- method ToplevelLayout::get_fullscreen_monitor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Monitor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_get_fullscreen_monitor" gdk_toplevel_layout_get_fullscreen_monitor :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    IO (Ptr Gdk.Monitor.Monitor)

-- | Returns the monitor that the layout is fullscreening
-- the surface on.
toplevelLayoutGetFullscreenMonitor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> m (Maybe Gdk.Monitor.Monitor)
    -- ^ __Returns:__ the monitor on which /@layout@/ fullscreens
toplevelLayoutGetFullscreenMonitor layout = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    result <- gdk_toplevel_layout_get_fullscreen_monitor layout'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Monitor.Monitor) result'
        return result''
    touchManagedPtr layout
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutGetFullscreenMonitorMethodInfo
instance (signature ~ (m (Maybe Gdk.Monitor.Monitor)), MonadIO m) => O.OverloadedMethod ToplevelLayoutGetFullscreenMonitorMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutGetFullscreenMonitor

instance O.OverloadedMethodInfo ToplevelLayoutGetFullscreenMonitorMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutGetFullscreenMonitor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutGetFullscreenMonitor"
        })


#endif

-- method ToplevelLayout::get_maximized
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximized"
--           , argType = TBasicType TBoolean
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "set to true if the toplevel should be maximized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_get_maximized" gdk_toplevel_layout_get_maximized :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    Ptr CInt ->                             -- maximized : TBasicType TBoolean
    IO CInt

-- | If the layout specifies whether to the toplevel should go maximized,
-- the value pointed to by /@maximized@/ is set to true if it should go
-- maximized, or false, if it should go unmaximized.
toplevelLayoutGetMaximized ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> m ((Bool, Bool))
    -- ^ __Returns:__ whether the /@layout@/ specifies the maximized state for the toplevel
toplevelLayoutGetMaximized layout = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    maximized <- allocMem :: IO (Ptr CInt)
    result <- gdk_toplevel_layout_get_maximized layout' maximized
    let result' = (/= 0) result
    maximized' <- peek maximized
    let maximized'' = (/= 0) maximized'
    touchManagedPtr layout
    freeMem maximized
    return (result', maximized'')

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutGetMaximizedMethodInfo
instance (signature ~ (m ((Bool, Bool))), MonadIO m) => O.OverloadedMethod ToplevelLayoutGetMaximizedMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutGetMaximized

instance O.OverloadedMethodInfo ToplevelLayoutGetMaximizedMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutGetMaximized",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutGetMaximized"
        })


#endif

-- method ToplevelLayout::get_resizable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_get_resizable" gdk_toplevel_layout_get_resizable :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    IO CInt

-- | Returns whether the layout should allow the user
-- to resize the surface.
toplevelLayoutGetResizable ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> m Bool
    -- ^ __Returns:__ true if the layout is resizable
toplevelLayoutGetResizable layout = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    result <- gdk_toplevel_layout_get_resizable layout'
    let result' = (/= 0) result
    touchManagedPtr layout
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutGetResizableMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod ToplevelLayoutGetResizableMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutGetResizable

instance O.OverloadedMethodInfo ToplevelLayoutGetResizableMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutGetResizable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutGetResizable"
        })


#endif

-- method ToplevelLayout::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_ref" gdk_toplevel_layout_ref :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    IO (Ptr ToplevelLayout)

-- | Increases the reference count of /@layout@/.
toplevelLayoutRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> m ToplevelLayout
    -- ^ __Returns:__ the same /@layout@/
toplevelLayoutRef layout = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    result <- gdk_toplevel_layout_ref layout'
    checkUnexpectedReturnNULL "toplevelLayoutRef" result
    result' <- (wrapBoxed ToplevelLayout) result
    touchManagedPtr layout
    return result'

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutRefMethodInfo
instance (signature ~ (m ToplevelLayout), MonadIO m) => O.OverloadedMethod ToplevelLayoutRefMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutRef

instance O.OverloadedMethodInfo ToplevelLayoutRefMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutRef"
        })


#endif

-- method ToplevelLayout::set_fullscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fullscreen"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to fullscreen the surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Monitor" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the monitor to fullscreen on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_set_fullscreen" gdk_toplevel_layout_set_fullscreen :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    CInt ->                                 -- fullscreen : TBasicType TBoolean
    Ptr Gdk.Monitor.Monitor ->              -- monitor : TInterface (Name {namespace = "Gdk", name = "Monitor"})
    IO ()

-- | Sets whether the layout should cause the surface
-- to be fullscreen when presented.
toplevelLayoutSetFullscreen ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Monitor.IsMonitor a) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> Bool
    -- ^ /@fullscreen@/: true to fullscreen the surface
    -> Maybe (a)
    -- ^ /@monitor@/: the monitor to fullscreen on
    -> m ()
toplevelLayoutSetFullscreen layout fullscreen monitor = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    let fullscreen' = (P.fromIntegral . P.fromEnum) fullscreen
    maybeMonitor <- case monitor of
        Nothing -> return FP.nullPtr
        Just jMonitor -> do
            jMonitor' <- unsafeManagedPtrCastPtr jMonitor
            return jMonitor'
    gdk_toplevel_layout_set_fullscreen layout' fullscreen' maybeMonitor
    touchManagedPtr layout
    whenJust monitor touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutSetFullscreenMethodInfo
instance (signature ~ (Bool -> Maybe (a) -> m ()), MonadIO m, Gdk.Monitor.IsMonitor a) => O.OverloadedMethod ToplevelLayoutSetFullscreenMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutSetFullscreen

instance O.OverloadedMethodInfo ToplevelLayoutSetFullscreenMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutSetFullscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutSetFullscreen"
        })


#endif

-- method ToplevelLayout::set_maximized
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximized"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to maximize" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_set_maximized" gdk_toplevel_layout_set_maximized :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    CInt ->                                 -- maximized : TBasicType TBoolean
    IO ()

-- | Sets whether the layout should cause the surface
-- to be maximized when presented.
toplevelLayoutSetMaximized ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> Bool
    -- ^ /@maximized@/: true to maximize
    -> m ()
toplevelLayoutSetMaximized layout maximized = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    let maximized' = (P.fromIntegral . P.fromEnum) maximized
    gdk_toplevel_layout_set_maximized layout' maximized'
    touchManagedPtr layout
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutSetMaximizedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod ToplevelLayoutSetMaximizedMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutSetMaximized

instance O.OverloadedMethodInfo ToplevelLayoutSetMaximizedMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutSetMaximized",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutSetMaximized"
        })


#endif

-- method ToplevelLayout::set_resizable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resizable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to allow resizing"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_set_resizable" gdk_toplevel_layout_set_resizable :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    CInt ->                                 -- resizable : TBasicType TBoolean
    IO ()

-- | Sets whether the layout should allow the user
-- to resize the surface after it has been presented.
toplevelLayoutSetResizable ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> Bool
    -- ^ /@resizable@/: true to allow resizing
    -> m ()
toplevelLayoutSetResizable layout resizable = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    let resizable' = (P.fromIntegral . P.fromEnum) resizable
    gdk_toplevel_layout_set_resizable layout' resizable'
    touchManagedPtr layout
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutSetResizableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod ToplevelLayoutSetResizableMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutSetResizable

instance O.OverloadedMethodInfo ToplevelLayoutSetResizableMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutSetResizable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutSetResizable"
        })


#endif

-- method ToplevelLayout::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ToplevelLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a toplevel layout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_toplevel_layout_unref" gdk_toplevel_layout_unref :: 
    Ptr ToplevelLayout ->                   -- layout : TInterface (Name {namespace = "Gdk", name = "ToplevelLayout"})
    IO ()

-- | Decreases the reference count of /@layout@/.
toplevelLayoutUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ToplevelLayout
    -- ^ /@layout@/: a toplevel layout
    -> m ()
toplevelLayoutUnref layout = liftIO $ do
    layout' <- unsafeManagedPtrGetPtr layout
    gdk_toplevel_layout_unref layout'
    touchManagedPtr layout
    return ()

#if defined(ENABLE_OVERLOADING)
data ToplevelLayoutUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ToplevelLayoutUnrefMethodInfo ToplevelLayout signature where
    overloadedMethod = toplevelLayoutUnref

instance O.OverloadedMethodInfo ToplevelLayoutUnrefMethodInfo ToplevelLayout where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ToplevelLayout.toplevelLayoutUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ToplevelLayout.html#v:toplevelLayoutUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveToplevelLayoutMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveToplevelLayoutMethod "copy" o = ToplevelLayoutCopyMethodInfo
    ResolveToplevelLayoutMethod "equal" o = ToplevelLayoutEqualMethodInfo
    ResolveToplevelLayoutMethod "ref" o = ToplevelLayoutRefMethodInfo
    ResolveToplevelLayoutMethod "unref" o = ToplevelLayoutUnrefMethodInfo
    ResolveToplevelLayoutMethod "getFullscreen" o = ToplevelLayoutGetFullscreenMethodInfo
    ResolveToplevelLayoutMethod "getFullscreenMonitor" o = ToplevelLayoutGetFullscreenMonitorMethodInfo
    ResolveToplevelLayoutMethod "getMaximized" o = ToplevelLayoutGetMaximizedMethodInfo
    ResolveToplevelLayoutMethod "getResizable" o = ToplevelLayoutGetResizableMethodInfo
    ResolveToplevelLayoutMethod "setFullscreen" o = ToplevelLayoutSetFullscreenMethodInfo
    ResolveToplevelLayoutMethod "setMaximized" o = ToplevelLayoutSetMaximizedMethodInfo
    ResolveToplevelLayoutMethod "setResizable" o = ToplevelLayoutSetResizableMethodInfo
    ResolveToplevelLayoutMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveToplevelLayoutMethod t ToplevelLayout, O.OverloadedMethod info ToplevelLayout p) => OL.IsLabel t (ToplevelLayout -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveToplevelLayoutMethod t ToplevelLayout, O.OverloadedMethod info ToplevelLayout p, R.HasField t ToplevelLayout p) => R.HasField t ToplevelLayout p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveToplevelLayoutMethod t ToplevelLayout, O.OverloadedMethodInfo info ToplevelLayout) => OL.IsLabel t (O.MethodProxy info ToplevelLayout) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


