

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Functions
    ( 

 -- * Methods


-- ** access #method:access#

    access                                  ,


-- ** alignedAlloc #method:alignedAlloc#

    alignedAlloc                            ,


-- ** alignedAlloc0 #method:alignedAlloc0#

    alignedAlloc0                           ,


-- ** alignedFree #method:alignedFree#

    alignedFree                             ,


-- ** alignedFreeSized #method:alignedFreeSized#

    alignedFreeSized                        ,


-- ** asciiDigitValue #method:asciiDigitValue#

    asciiDigitValue                         ,


-- ** asciiDtostr #method:asciiDtostr#

    asciiDtostr                             ,


-- ** asciiFormatd #method:asciiFormatd#

    asciiFormatd                            ,


-- ** asciiStrcasecmp #method:asciiStrcasecmp#

    asciiStrcasecmp                         ,


-- ** asciiStrdown #method:asciiStrdown#

    asciiStrdown                            ,


-- ** asciiStringToSigned #method:asciiStringToSigned#

    asciiStringToSigned                     ,


-- ** asciiStringToUnsigned #method:asciiStringToUnsigned#

    asciiStringToUnsigned                   ,


-- ** asciiStrncasecmp #method:asciiStrncasecmp#

    asciiStrncasecmp                        ,


-- ** asciiStrtod #method:asciiStrtod#

    asciiStrtod                             ,


-- ** asciiStrtoll #method:asciiStrtoll#

    asciiStrtoll                            ,


-- ** asciiStrtoull #method:asciiStrtoull#

    asciiStrtoull                           ,


-- ** asciiStrup #method:asciiStrup#

    asciiStrup                              ,


-- ** asciiTolower #method:asciiTolower#

    asciiTolower                            ,


-- ** asciiToupper #method:asciiToupper#

    asciiToupper                            ,


-- ** asciiXdigitValue #method:asciiXdigitValue#

    asciiXdigitValue                        ,


-- ** assertWarning #method:assertWarning#

    assertWarning                           ,


-- ** assertionMessage #method:assertionMessage#

    assertionMessage                        ,


-- ** assertionMessageCmpint #method:assertionMessageCmpint#

    assertionMessageCmpint                  ,


-- ** assertionMessageCmpstr #method:assertionMessageCmpstr#

    assertionMessageCmpstr                  ,


-- ** assertionMessageCmpstrv #method:assertionMessageCmpstrv#

    assertionMessageCmpstrv                 ,


-- ** assertionMessageError #method:assertionMessageError#

    assertionMessageError                   ,


-- ** atexit #method:atexit#

    atexit                                  ,


-- ** atomicIntAdd #method:atomicIntAdd#

    atomicIntAdd                            ,


-- ** atomicIntAnd #method:atomicIntAnd#

    atomicIntAnd                            ,


-- ** atomicIntCompareAndExchange #method:atomicIntCompareAndExchange#

    atomicIntCompareAndExchange             ,


-- ** atomicIntCompareAndExchangeFull #method:atomicIntCompareAndExchangeFull#

    atomicIntCompareAndExchangeFull         ,


-- ** atomicIntDecAndTest #method:atomicIntDecAndTest#

    atomicIntDecAndTest                     ,


-- ** atomicIntExchange #method:atomicIntExchange#

    atomicIntExchange                       ,


-- ** atomicIntExchangeAndAdd #method:atomicIntExchangeAndAdd#

    atomicIntExchangeAndAdd                 ,


-- ** atomicIntGet #method:atomicIntGet#

    atomicIntGet                            ,


-- ** atomicIntInc #method:atomicIntInc#

    atomicIntInc                            ,


-- ** atomicIntOr #method:atomicIntOr#

    atomicIntOr                             ,


-- ** atomicIntSet #method:atomicIntSet#

    atomicIntSet                            ,


-- ** atomicIntXor #method:atomicIntXor#

    atomicIntXor                            ,


-- ** atomicPointerAdd #method:atomicPointerAdd#

    atomicPointerAdd                        ,


-- ** atomicPointerAnd #method:atomicPointerAnd#

    atomicPointerAnd                        ,


-- ** atomicPointerCompareAndExchange #method:atomicPointerCompareAndExchange#

    atomicPointerCompareAndExchange         ,


-- ** atomicPointerCompareAndExchangeFull #method:atomicPointerCompareAndExchangeFull#

    atomicPointerCompareAndExchangeFull     ,


-- ** atomicPointerExchange #method:atomicPointerExchange#

    atomicPointerExchange                   ,


-- ** atomicPointerGet #method:atomicPointerGet#

    atomicPointerGet                        ,


-- ** atomicPointerOr #method:atomicPointerOr#

    atomicPointerOr                         ,


-- ** atomicPointerSet #method:atomicPointerSet#

    atomicPointerSet                        ,


-- ** atomicPointerXor #method:atomicPointerXor#

    atomicPointerXor                        ,


-- ** atomicRcBoxAcquire #method:atomicRcBoxAcquire#

    atomicRcBoxAcquire                      ,


-- ** atomicRcBoxAlloc #method:atomicRcBoxAlloc#

    atomicRcBoxAlloc                        ,


-- ** atomicRcBoxAlloc0 #method:atomicRcBoxAlloc0#

    atomicRcBoxAlloc0                       ,


-- ** atomicRcBoxDup #method:atomicRcBoxDup#

    atomicRcBoxDup                          ,


-- ** atomicRcBoxGetSize #method:atomicRcBoxGetSize#

    atomicRcBoxGetSize                      ,


-- ** atomicRcBoxRelease #method:atomicRcBoxRelease#

    atomicRcBoxRelease                      ,


-- ** atomicRcBoxReleaseFull #method:atomicRcBoxReleaseFull#

    atomicRcBoxReleaseFull                  ,


-- ** atomicRefCountCompare #method:atomicRefCountCompare#

    atomicRefCountCompare                   ,


-- ** atomicRefCountDec #method:atomicRefCountDec#

    atomicRefCountDec                       ,


-- ** atomicRefCountInc #method:atomicRefCountInc#

    atomicRefCountInc                       ,


-- ** atomicRefCountInit #method:atomicRefCountInit#

    atomicRefCountInit                      ,


-- ** base64Decode #method:base64Decode#

    base64Decode                            ,


-- ** base64DecodeInplace #method:base64DecodeInplace#

    base64DecodeInplace                     ,


-- ** base64Encode #method:base64Encode#

    base64Encode                            ,


-- ** basename #method:basename#

    basename                                ,


-- ** bitLock #method:bitLock#

    bitLock                                 ,


-- ** bitLockAndGet #method:bitLockAndGet#

    bitLockAndGet                           ,


-- ** bitNthLsf #method:bitNthLsf#

    bitNthLsf                               ,


-- ** bitNthMsf #method:bitNthMsf#

    bitNthMsf                               ,


-- ** bitStorage #method:bitStorage#

    bitStorage                              ,


-- ** bitTrylock #method:bitTrylock#

    bitTrylock                              ,


-- ** bitUnlock #method:bitUnlock#

    bitUnlock                               ,


-- ** bitUnlockAndSet #method:bitUnlockAndSet#

    bitUnlockAndSet                         ,


-- ** blowChunks #method:blowChunks#

    blowChunks                              ,


-- ** buildFilenamev #method:buildFilenamev#

    buildFilenamev                          ,


-- ** buildPathv #method:buildPathv#

    buildPathv                              ,


-- ** canonicalizeFilename #method:canonicalizeFilename#

    canonicalizeFilename                    ,


-- ** chdir #method:chdir#

    chdir                                   ,


-- ** checkVersion #method:checkVersion#

    checkVersion                            ,


-- ** childWatchAdd #method:childWatchAdd#

    childWatchAdd                           ,


-- ** childWatchSourceNew #method:childWatchSourceNew#

    childWatchSourceNew                     ,


-- ** chmod #method:chmod#

    chmod                                   ,


-- ** clearError #method:clearError#

    clearError                              ,


-- ** close #method:close#

    close                                   ,


-- ** closefrom #method:closefrom#

    closefrom                               ,


-- ** computeChecksumForBytes #method:computeChecksumForBytes#

    computeChecksumForBytes                 ,


-- ** computeChecksumForData #method:computeChecksumForData#

    computeChecksumForData                  ,


-- ** computeChecksumForString #method:computeChecksumForString#

    computeChecksumForString                ,


-- ** computeHmacForBytes #method:computeHmacForBytes#

    computeHmacForBytes                     ,


-- ** computeHmacForData #method:computeHmacForData#

    computeHmacForData                      ,


-- ** computeHmacForString #method:computeHmacForString#

    computeHmacForString                    ,


-- ** convert #method:convert#

    convert                                 ,


-- ** convertErrorQuark #method:convertErrorQuark#

    convertErrorQuark                       ,


-- ** convertWithFallback #method:convertWithFallback#

    convertWithFallback                     ,


-- ** creat #method:creat#

    creat                                   ,


-- ** datalistForeach #method:datalistForeach#

    datalistForeach                         ,


-- ** datalistGetData #method:datalistGetData#

    datalistGetData                         ,


-- ** datalistGetFlags #method:datalistGetFlags#

    datalistGetFlags                        ,


-- ** datalistIdGetData #method:datalistIdGetData#

    datalistIdGetData                       ,


-- ** datalistIdRemoveMultiple #method:datalistIdRemoveMultiple#

    datalistIdRemoveMultiple                ,


-- ** datalistSetFlags #method:datalistSetFlags#

    datalistSetFlags                        ,


-- ** datalistUnsetFlags #method:datalistUnsetFlags#

    datalistUnsetFlags                      ,


-- ** datasetDestroy #method:datasetDestroy#

    datasetDestroy                          ,


-- ** datasetForeach #method:datasetForeach#

    datasetForeach                          ,


-- ** datasetIdGetData #method:datasetIdGetData#

    datasetIdGetData                        ,


-- ** dcgettext #method:dcgettext#

    dcgettext                               ,


-- ** dgettext #method:dgettext#

    dgettext                                ,


-- ** directEqual #method:directEqual#

    directEqual                             ,


-- ** directHash #method:directHash#

    directHash                              ,


-- ** dngettext #method:dngettext#

    dngettext                               ,


-- ** doubleEqual #method:doubleEqual#

    doubleEqual                             ,


-- ** doubleHash #method:doubleHash#

    doubleHash                              ,


-- ** dpgettext #method:dpgettext#

    dpgettext                               ,


-- ** dpgettext2 #method:dpgettext2#

    dpgettext2                              ,


-- ** environGetenv #method:environGetenv#

    environGetenv                           ,


-- ** environSetenv #method:environSetenv#

    environSetenv                           ,


-- ** environUnsetenv #method:environUnsetenv#

    environUnsetenv                         ,


-- ** fdwalkSetCloexec #method:fdwalkSetCloexec#

    fdwalkSetCloexec                        ,


-- ** fileErrorFromErrno #method:fileErrorFromErrno#

    fileErrorFromErrno                      ,


-- ** fileErrorQuark #method:fileErrorQuark#

    fileErrorQuark                          ,


-- ** fileGetContents #method:fileGetContents#

    fileGetContents                         ,


-- ** fileOpenTmp #method:fileOpenTmp#

    fileOpenTmp                             ,


-- ** fileReadLink #method:fileReadLink#

    fileReadLink                            ,


-- ** fileSetContents #method:fileSetContents#

    fileSetContents                         ,


-- ** fileSetContentsFull #method:fileSetContentsFull#

    fileSetContentsFull                     ,


-- ** fileTest #method:fileTest#

    fileTest                                ,


-- ** filenameDisplayBasename #method:filenameDisplayBasename#

    filenameDisplayBasename                 ,


-- ** filenameDisplayName #method:filenameDisplayName#

    filenameDisplayName                     ,


-- ** filenameFromUri #method:filenameFromUri#

    filenameFromUri                         ,


-- ** filenameFromUtf8 #method:filenameFromUtf8#

    filenameFromUtf8                        ,


-- ** filenameToUri #method:filenameToUri#

    filenameToUri                           ,


-- ** filenameToUtf8 #method:filenameToUtf8#

    filenameToUtf8                          ,


-- ** findProgramInPath #method:findProgramInPath#

    findProgramInPath                       ,


-- ** fopen #method:fopen#

    fopen                                   ,


-- ** formatSize #method:formatSize#

    formatSize                              ,


-- ** formatSizeForDisplay #method:formatSizeForDisplay#

    formatSizeForDisplay                    ,


-- ** formatSizeFull #method:formatSizeFull#

    formatSizeFull                          ,


-- ** free #method:free#

    free                                    ,


-- ** freeSized #method:freeSized#

    freeSized                               ,


-- ** freopen #method:freopen#

    freopen                                 ,


-- ** fsync #method:fsync#

    fsync                                   ,


-- ** getApplicationName #method:getApplicationName#

    getApplicationName                      ,


-- ** getCharset #method:getCharset#

    getCharset                              ,


-- ** getCodeset #method:getCodeset#

    getCodeset                              ,


-- ** getConsoleCharset #method:getConsoleCharset#

    getConsoleCharset                       ,


-- ** getCurrentDir #method:getCurrentDir#

    getCurrentDir                           ,


-- ** getCurrentTime #method:getCurrentTime#

    getCurrentTime                          ,


-- ** getEnviron #method:getEnviron#

    getEnviron                              ,


-- ** getFilenameCharsets #method:getFilenameCharsets#

    getFilenameCharsets                     ,


-- ** getHomeDir #method:getHomeDir#

    getHomeDir                              ,


-- ** getHostName #method:getHostName#

    getHostName                             ,


-- ** getLanguageNames #method:getLanguageNames#

    getLanguageNames                        ,


-- ** getLanguageNamesWithCategory #method:getLanguageNamesWithCategory#

    getLanguageNamesWithCategory            ,


-- ** getLocaleVariants #method:getLocaleVariants#

    getLocaleVariants                       ,


-- ** getMonotonicTime #method:getMonotonicTime#

    getMonotonicTime                        ,


-- ** getNumProcessors #method:getNumProcessors#

    getNumProcessors                        ,


-- ** getOsInfo #method:getOsInfo#

    getOsInfo                               ,


-- ** getPrgname #method:getPrgname#

    getPrgname                              ,


-- ** getRealName #method:getRealName#

    getRealName                             ,


-- ** getRealTime #method:getRealTime#

    getRealTime                             ,


-- ** getSystemConfigDirs #method:getSystemConfigDirs#

    getSystemConfigDirs                     ,


-- ** getSystemDataDirs #method:getSystemDataDirs#

    getSystemDataDirs                       ,


-- ** getTmpDir #method:getTmpDir#

    getTmpDir                               ,


-- ** getUserCacheDir #method:getUserCacheDir#

    getUserCacheDir                         ,


-- ** getUserConfigDir #method:getUserConfigDir#

    getUserConfigDir                        ,


-- ** getUserDataDir #method:getUserDataDir#

    getUserDataDir                          ,


-- ** getUserName #method:getUserName#

    getUserName                             ,


-- ** getUserRuntimeDir #method:getUserRuntimeDir#

    getUserRuntimeDir                       ,


-- ** getUserSpecialDir #method:getUserSpecialDir#

    getUserSpecialDir                       ,


-- ** getUserStateDir #method:getUserStateDir#

    getUserStateDir                         ,


-- ** getenv #method:getenv#

    getenv                                  ,


-- ** hostnameIsAsciiEncoded #method:hostnameIsAsciiEncoded#

    hostnameIsAsciiEncoded                  ,


-- ** hostnameIsIpAddress #method:hostnameIsIpAddress#

    hostnameIsIpAddress                     ,


-- ** hostnameIsNonAscii #method:hostnameIsNonAscii#

    hostnameIsNonAscii                      ,


-- ** hostnameToAscii #method:hostnameToAscii#

    hostnameToAscii                         ,


-- ** hostnameToUnicode #method:hostnameToUnicode#

    hostnameToUnicode                       ,


-- ** idleAdd #method:idleAdd#

    idleAdd                                 ,


-- ** idleRemoveByData #method:idleRemoveByData#

    idleRemoveByData                        ,


-- ** idleSourceNew #method:idleSourceNew#

    idleSourceNew                           ,


-- ** int64Equal #method:int64Equal#

    int64Equal                              ,


-- ** int64Hash #method:int64Hash#

    int64Hash                               ,


-- ** intEqual #method:intEqual#

    intEqual                                ,


-- ** intHash #method:intHash#

    intHash                                 ,


-- ** internStaticString #method:internStaticString#

    internStaticString                      ,


-- ** internString #method:internString#

    internString                            ,


-- ** ioAddWatch #method:ioAddWatch#

    ioAddWatch                              ,


-- ** ioCreateWatch #method:ioCreateWatch#

    ioCreateWatch                           ,


-- ** listenv #method:listenv#

    listenv                                 ,


-- ** localeFromUtf8 #method:localeFromUtf8#

    localeFromUtf8                          ,


-- ** localeToUtf8 #method:localeToUtf8#

    localeToUtf8                            ,


-- ** logDefaultHandler #method:logDefaultHandler#

    logDefaultHandler                       ,


-- ** logGetAlwaysFatal #method:logGetAlwaysFatal#

    logGetAlwaysFatal                       ,


-- ** logGetDebugEnabled #method:logGetDebugEnabled#

    logGetDebugEnabled                      ,


-- ** logRemoveHandler #method:logRemoveHandler#

    logRemoveHandler                        ,


-- ** logSetAlwaysFatal #method:logSetAlwaysFatal#

    logSetAlwaysFatal                       ,


-- ** logSetDebugEnabled #method:logSetDebugEnabled#

    logSetDebugEnabled                      ,


-- ** logSetFatalMask #method:logSetFatalMask#

    logSetFatalMask                         ,


-- ** logSetHandler #method:logSetHandler#

    logSetHandler                           ,


-- ** logSetWriterFunc #method:logSetWriterFunc#

    logSetWriterFunc                        ,


-- ** logStructuredArray #method:logStructuredArray#

    logStructuredArray                      ,


-- ** logVariant #method:logVariant#

    logVariant                              ,


-- ** logWriterDefault #method:logWriterDefault#

    logWriterDefault                        ,


-- ** logWriterDefaultSetDebugDomains #method:logWriterDefaultSetDebugDomains#

    logWriterDefaultSetDebugDomains         ,


-- ** logWriterDefaultSetUseStderr #method:logWriterDefaultSetUseStderr#

    logWriterDefaultSetUseStderr            ,


-- ** logWriterDefaultWouldDrop #method:logWriterDefaultWouldDrop#

    logWriterDefaultWouldDrop               ,


-- ** logWriterFormatFields #method:logWriterFormatFields#

    logWriterFormatFields                   ,


-- ** logWriterIsJournald #method:logWriterIsJournald#

    logWriterIsJournald                     ,


-- ** logWriterJournald #method:logWriterJournald#

    logWriterJournald                       ,


-- ** logWriterStandardStreams #method:logWriterStandardStreams#

    logWriterStandardStreams                ,


-- ** logWriterSupportsColor #method:logWriterSupportsColor#

    logWriterSupportsColor                  ,


-- ** logWriterSyslog #method:logWriterSyslog#

    logWriterSyslog                         ,


-- ** lstat #method:lstat#

    lstat                                   ,


-- ** mainCurrentSource #method:mainCurrentSource#

    mainCurrentSource                       ,


-- ** mainDepth #method:mainDepth#

    mainDepth                               ,


-- ** malloc #method:malloc#

    malloc                                  ,


-- ** malloc0 #method:malloc0#

    malloc0                                 ,


-- ** malloc0N #method:malloc0N#

    malloc0N                                ,


-- ** mallocN #method:mallocN#

    mallocN                                 ,


-- ** markupErrorQuark #method:markupErrorQuark#

    markupErrorQuark                        ,


-- ** markupEscapeText #method:markupEscapeText#

    markupEscapeText                        ,


-- ** memIsSystemMalloc #method:memIsSystemMalloc#

    memIsSystemMalloc                       ,


-- ** memProfile #method:memProfile#

    memProfile                              ,


-- ** memSetVtable #method:memSetVtable#

    memSetVtable                            ,


-- ** memdup #method:memdup#

    memdup                                  ,


-- ** memdup2 #method:memdup2#

    memdup2                                 ,


-- ** mkdir #method:mkdir#

    mkdir                                   ,


-- ** mkdirWithParents #method:mkdirWithParents#

    mkdirWithParents                        ,


-- ** nullifyPointer #method:nullifyPointer#

    nullifyPointer                          ,


-- ** numberParserErrorQuark #method:numberParserErrorQuark#

    numberParserErrorQuark                  ,


-- ** onErrorQuery #method:onErrorQuery#

    onErrorQuery                            ,


-- ** onErrorStackTrace #method:onErrorStackTrace#

    onErrorStackTrace                       ,


-- ** open #method:open#

    open                                    ,


-- ** optionErrorQuark #method:optionErrorQuark#

    optionErrorQuark                        ,


-- ** parseDebugString #method:parseDebugString#

    parseDebugString                        ,


-- ** pathGetBasename #method:pathGetBasename#

    pathGetBasename                         ,


-- ** pathGetDirname #method:pathGetDirname#

    pathGetDirname                          ,


-- ** pathIsAbsolute #method:pathIsAbsolute#

    pathIsAbsolute                          ,


-- ** pathSkipRoot #method:pathSkipRoot#

    pathSkipRoot                            ,


-- ** patternMatchSimple #method:patternMatchSimple#

    patternMatchSimple                      ,


-- ** pointerBitLock #method:pointerBitLock#

    pointerBitLock                          ,


-- ** pointerBitLockAndGet #method:pointerBitLockAndGet#

    pointerBitLockAndGet                    ,


-- ** pointerBitLockMaskPtr #method:pointerBitLockMaskPtr#

    pointerBitLockMaskPtr                   ,


-- ** pointerBitTrylock #method:pointerBitTrylock#

    pointerBitTrylock                       ,


-- ** pointerBitUnlock #method:pointerBitUnlock#

    pointerBitUnlock                        ,


-- ** pointerBitUnlockAndSet #method:pointerBitUnlockAndSet#

    pointerBitUnlockAndSet                  ,


-- ** poll #method:poll#

    poll                                    ,


-- ** prefixErrorLiteral #method:prefixErrorLiteral#

    prefixErrorLiteral                      ,


-- ** propagateError #method:propagateError#

    propagateError                          ,


-- ** qsortWithData #method:qsortWithData#

    qsortWithData                           ,


-- ** quarkFromStaticString #method:quarkFromStaticString#

    quarkFromStaticString                   ,


-- ** quarkFromString #method:quarkFromString#

    quarkFromString                         ,


-- ** quarkToString #method:quarkToString#

    quarkToString                           ,


-- ** quarkTryString #method:quarkTryString#

    quarkTryString                          ,


-- ** randomDouble #method:randomDouble#

    randomDouble                            ,


-- ** randomDoubleRange #method:randomDoubleRange#

    randomDoubleRange                       ,


-- ** randomInt #method:randomInt#

    randomInt                               ,


-- ** randomIntRange #method:randomIntRange#

    randomIntRange                          ,


-- ** randomSetSeed #method:randomSetSeed#

    randomSetSeed                           ,


-- ** rcBoxAcquire #method:rcBoxAcquire#

    rcBoxAcquire                            ,


-- ** rcBoxAlloc #method:rcBoxAlloc#

    rcBoxAlloc                              ,


-- ** rcBoxAlloc0 #method:rcBoxAlloc0#

    rcBoxAlloc0                             ,


-- ** rcBoxDup #method:rcBoxDup#

    rcBoxDup                                ,


-- ** rcBoxGetSize #method:rcBoxGetSize#

    rcBoxGetSize                            ,


-- ** rcBoxRelease #method:rcBoxRelease#

    rcBoxRelease                            ,


-- ** rcBoxReleaseFull #method:rcBoxReleaseFull#

    rcBoxReleaseFull                        ,


-- ** realloc #method:realloc#

    realloc                                 ,


-- ** reallocN #method:reallocN#

    reallocN                                ,


-- ** refCountCompare #method:refCountCompare#

    refCountCompare                         ,


-- ** refCountDec #method:refCountDec#

    refCountDec                             ,


-- ** refCountInc #method:refCountInc#

    refCountInc                             ,


-- ** refCountInit #method:refCountInit#

    refCountInit                            ,


-- ** refStringAcquire #method:refStringAcquire#

    refStringAcquire                        ,


-- ** refStringEqual #method:refStringEqual#

    refStringEqual                          ,


-- ** refStringLength #method:refStringLength#

    refStringLength                         ,


-- ** refStringNew #method:refStringNew#

    refStringNew                            ,


-- ** refStringNewIntern #method:refStringNewIntern#

    refStringNewIntern                      ,


-- ** refStringNewLen #method:refStringNewLen#

    refStringNewLen                         ,


-- ** refStringRelease #method:refStringRelease#

    refStringRelease                        ,


-- ** reloadUserSpecialDirsCache #method:reloadUserSpecialDirsCache#

    reloadUserSpecialDirsCache              ,


-- ** remove #method:remove#

    remove                                  ,


-- ** rename #method:rename#

    rename                                  ,


-- ** rmdir #method:rmdir#

    rmdir                                   ,


-- ** setApplicationName #method:setApplicationName#

    setApplicationName                      ,


-- ** setErrorLiteral #method:setErrorLiteral#

    setErrorLiteral                         ,


-- ** setPrgname #method:setPrgname#

    setPrgname                              ,


-- ** setenv #method:setenv#

    setenv                                  ,


-- ** shellErrorQuark #method:shellErrorQuark#

    shellErrorQuark                         ,


-- ** shellParseArgv #method:shellParseArgv#

    shellParseArgv                          ,


-- ** shellQuote #method:shellQuote#

    shellQuote                              ,


-- ** shellUnquote #method:shellUnquote#

    shellUnquote                            ,


-- ** sliceAlloc #method:sliceAlloc#

    sliceAlloc                              ,


-- ** sliceAlloc0 #method:sliceAlloc0#

    sliceAlloc0                             ,


-- ** sliceCopy #method:sliceCopy#

    sliceCopy                               ,


-- ** sliceFree1 #method:sliceFree1#

    sliceFree1                              ,


-- ** sliceFreeChainWithOffset #method:sliceFreeChainWithOffset#

    sliceFreeChainWithOffset                ,


-- ** sliceGetConfig #method:sliceGetConfig#

    sliceGetConfig                          ,


-- ** sliceGetConfigState #method:sliceGetConfigState#

    sliceGetConfigState                     ,


-- ** sliceSetConfig #method:sliceSetConfig#

    sliceSetConfig                          ,


-- ** spacedPrimesClosest #method:spacedPrimesClosest#

    spacedPrimesClosest                     ,


-- ** spawnAsync #method:spawnAsync#

    spawnAsync                              ,


-- ** spawnAsyncWithFds #method:spawnAsyncWithFds#

    spawnAsyncWithFds                       ,


-- ** spawnAsyncWithPipes #method:spawnAsyncWithPipes#

    spawnAsyncWithPipes                     ,


-- ** spawnAsyncWithPipesAndFds #method:spawnAsyncWithPipesAndFds#

    spawnAsyncWithPipesAndFds               ,


-- ** spawnCheckExitStatus #method:spawnCheckExitStatus#

    spawnCheckExitStatus                    ,


-- ** spawnCheckWaitStatus #method:spawnCheckWaitStatus#

    spawnCheckWaitStatus                    ,


-- ** spawnClosePid #method:spawnClosePid#

    spawnClosePid                           ,


-- ** spawnCommandLineAsync #method:spawnCommandLineAsync#

    spawnCommandLineAsync                   ,


-- ** spawnCommandLineSync #method:spawnCommandLineSync#

    spawnCommandLineSync                    ,


-- ** spawnErrorQuark #method:spawnErrorQuark#

    spawnErrorQuark                         ,


-- ** spawnExitErrorQuark #method:spawnExitErrorQuark#

    spawnExitErrorQuark                     ,


-- ** spawnSync #method:spawnSync#

    spawnSync                               ,


-- ** stat #method:stat#

    stat                                    ,


-- ** stpcpy #method:stpcpy#

    stpcpy                                  ,


-- ** strEqual #method:strEqual#

    strEqual                                ,


-- ** strHasPrefix #method:strHasPrefix#

    strHasPrefix                            ,


-- ** strHasSuffix #method:strHasSuffix#

    strHasSuffix                            ,


-- ** strHash #method:strHash#

    strHash                                 ,


-- ** strIsAscii #method:strIsAscii#

    strIsAscii                              ,


-- ** strMatchString #method:strMatchString#

    strMatchString                          ,


-- ** strToAscii #method:strToAscii#

    strToAscii                              ,


-- ** strTokenizeAndFold #method:strTokenizeAndFold#

    strTokenizeAndFold                      ,


-- ** strcanon #method:strcanon#

    strcanon                                ,


-- ** strcasecmp #method:strcasecmp#

    strcasecmp                              ,


-- ** strchomp #method:strchomp#

    strchomp                                ,


-- ** strchug #method:strchug#

    strchug                                 ,


-- ** strcmp0 #method:strcmp0#

    strcmp0                                 ,


-- ** strcompress #method:strcompress#

    strcompress                             ,


-- ** strdelimit #method:strdelimit#

    strdelimit                              ,


-- ** strdown #method:strdown#

    strdown                                 ,


-- ** strdup #method:strdup#

    strdup                                  ,


-- ** strdupv #method:strdupv#

    strdupv                                 ,


-- ** strerror #method:strerror#

    strerror                                ,


-- ** strescape #method:strescape#

    strescape                               ,


-- ** strfreev #method:strfreev#

    strfreev                                ,


-- ** stripContext #method:stripContext#

    stripContext                            ,


-- ** strjoinv #method:strjoinv#

    strjoinv                                ,


-- ** strlcat #method:strlcat#

    strlcat                                 ,


-- ** strlcpy #method:strlcpy#

    strlcpy                                 ,


-- ** strncasecmp #method:strncasecmp#

    strncasecmp                             ,


-- ** strndup #method:strndup#

    strndup                                 ,


-- ** strnfill #method:strnfill#

    strnfill                                ,


-- ** strreverse #method:strreverse#

    strreverse                              ,


-- ** strrstr #method:strrstr#

    strrstr                                 ,


-- ** strrstrLen #method:strrstrLen#

    strrstrLen                              ,


-- ** strsignal #method:strsignal#

    strsignal                               ,


-- ** strsplit #method:strsplit#

    strsplit                                ,


-- ** strsplitSet #method:strsplitSet#

    strsplitSet                             ,


-- ** strstrLen #method:strstrLen#

    strstrLen                               ,


-- ** strtod #method:strtod#

    strtod                                  ,


-- ** strup #method:strup#

    strup                                   ,


-- ** strvContains #method:strvContains#

    strvContains                            ,


-- ** strvEqual #method:strvEqual#

    strvEqual                               ,


-- ** strvGetType #method:strvGetType#

    strvGetType                             ,


-- ** strvLength #method:strvLength#

    strvLength                              ,


-- ** testAddDataFunc #method:testAddDataFunc#

    testAddDataFunc                         ,


-- ** testAddFunc #method:testAddFunc#

    testAddFunc                             ,


-- ** testAssertExpectedMessagesInternal #method:testAssertExpectedMessagesInternal#

    testAssertExpectedMessagesInternal      ,


-- ** testBug #method:testBug#

    testBug                                 ,


-- ** testBugBase #method:testBugBase#

    testBugBase                             ,


-- ** testDisableCrashReporting #method:testDisableCrashReporting#

    testDisableCrashReporting               ,


-- ** testExpectMessage #method:testExpectMessage#

    testExpectMessage                       ,


-- ** testFail #method:testFail#

    testFail                                ,


-- ** testFailed #method:testFailed#

    testFailed                              ,


-- ** testGetDir #method:testGetDir#

    testGetDir                              ,


-- ** testGetPath #method:testGetPath#

    testGetPath                             ,


-- ** testIncomplete #method:testIncomplete#

    testIncomplete                          ,


-- ** testLogTypeName #method:testLogTypeName#

    testLogTypeName                         ,


-- ** testQueueDestroy #method:testQueueDestroy#

    testQueueDestroy                        ,


-- ** testQueueFree #method:testQueueFree#

    testQueueFree                           ,


-- ** testRandDouble #method:testRandDouble#

    testRandDouble                          ,


-- ** testRandDoubleRange #method:testRandDoubleRange#

    testRandDoubleRange                     ,


-- ** testRandInt #method:testRandInt#

    testRandInt                             ,


-- ** testRandIntRange #method:testRandIntRange#

    testRandIntRange                        ,


-- ** testRun #method:testRun#

    testRun                                 ,


-- ** testRunSuite #method:testRunSuite#

    testRunSuite                            ,


-- ** testSetNonfatalAssertions #method:testSetNonfatalAssertions#

    testSetNonfatalAssertions               ,


-- ** testSkip #method:testSkip#

    testSkip                                ,


-- ** testSubprocess #method:testSubprocess#

    testSubprocess                          ,


-- ** testSummary #method:testSummary#

    testSummary                             ,


-- ** testTimerElapsed #method:testTimerElapsed#

    testTimerElapsed                        ,


-- ** testTimerLast #method:testTimerLast#

    testTimerLast                           ,


-- ** testTimerStart #method:testTimerStart#

    testTimerStart                          ,


-- ** testTrapAssertions #method:testTrapAssertions#

    testTrapAssertions                      ,


-- ** testTrapFork #method:testTrapFork#

    testTrapFork                            ,


-- ** testTrapHasPassed #method:testTrapHasPassed#

    testTrapHasPassed                       ,


-- ** testTrapReachedTimeout #method:testTrapReachedTimeout#

    testTrapReachedTimeout                  ,


-- ** testTrapSubprocess #method:testTrapSubprocess#

    testTrapSubprocess                      ,


-- ** testTrapSubprocessWithEnvp #method:testTrapSubprocessWithEnvp#

    testTrapSubprocessWithEnvp              ,


-- ** timeoutAdd #method:timeoutAdd#

    timeoutAdd                              ,


-- ** timeoutAddSeconds #method:timeoutAddSeconds#

    timeoutAddSeconds                       ,


-- ** timeoutSourceNew #method:timeoutSourceNew#

    timeoutSourceNew                        ,


-- ** timeoutSourceNewSeconds #method:timeoutSourceNewSeconds#

    timeoutSourceNewSeconds                 ,


-- ** tryMalloc #method:tryMalloc#

    tryMalloc                               ,


-- ** tryMalloc0 #method:tryMalloc0#

    tryMalloc0                              ,


-- ** tryMalloc0N #method:tryMalloc0N#

    tryMalloc0N                             ,


-- ** tryMallocN #method:tryMallocN#

    tryMallocN                              ,


-- ** tryRealloc #method:tryRealloc#

    tryRealloc                              ,


-- ** tryReallocN #method:tryReallocN#

    tryReallocN                             ,


-- ** ucs4ToUtf16 #method:ucs4ToUtf16#

    ucs4ToUtf16                             ,


-- ** ucs4ToUtf8 #method:ucs4ToUtf8#

    ucs4ToUtf8                              ,


-- ** unicharBreakType #method:unicharBreakType#

    unicharBreakType                        ,


-- ** unicharCombiningClass #method:unicharCombiningClass#

    unicharCombiningClass                   ,


-- ** unicharCompose #method:unicharCompose#

    unicharCompose                          ,


-- ** unicharDecompose #method:unicharDecompose#

    unicharDecompose                        ,


-- ** unicharDigitValue #method:unicharDigitValue#

    unicharDigitValue                       ,


-- ** unicharGetMirrorChar #method:unicharGetMirrorChar#

    unicharGetMirrorChar                    ,


-- ** unicharGetScript #method:unicharGetScript#

    unicharGetScript                        ,


-- ** unicharIsalnum #method:unicharIsalnum#

    unicharIsalnum                          ,


-- ** unicharIsalpha #method:unicharIsalpha#

    unicharIsalpha                          ,


-- ** unicharIscntrl #method:unicharIscntrl#

    unicharIscntrl                          ,


-- ** unicharIsdefined #method:unicharIsdefined#

    unicharIsdefined                        ,


-- ** unicharIsdigit #method:unicharIsdigit#

    unicharIsdigit                          ,


-- ** unicharIsgraph #method:unicharIsgraph#

    unicharIsgraph                          ,


-- ** unicharIslower #method:unicharIslower#

    unicharIslower                          ,


-- ** unicharIsmark #method:unicharIsmark#

    unicharIsmark                           ,


-- ** unicharIsprint #method:unicharIsprint#

    unicharIsprint                          ,


-- ** unicharIspunct #method:unicharIspunct#

    unicharIspunct                          ,


-- ** unicharIsspace #method:unicharIsspace#

    unicharIsspace                          ,


-- ** unicharIstitle #method:unicharIstitle#

    unicharIstitle                          ,


-- ** unicharIsupper #method:unicharIsupper#

    unicharIsupper                          ,


-- ** unicharIswide #method:unicharIswide#

    unicharIswide                           ,


-- ** unicharIswideCjk #method:unicharIswideCjk#

    unicharIswideCjk                        ,


-- ** unicharIsxdigit #method:unicharIsxdigit#

    unicharIsxdigit                         ,


-- ** unicharIszerowidth #method:unicharIszerowidth#

    unicharIszerowidth                      ,


-- ** unicharTolower #method:unicharTolower#

    unicharTolower                          ,


-- ** unicharTotitle #method:unicharTotitle#

    unicharTotitle                          ,


-- ** unicharToupper #method:unicharToupper#

    unicharToupper                          ,


-- ** unicharType #method:unicharType#

    unicharType                             ,


-- ** unicharValidate #method:unicharValidate#

    unicharValidate                         ,


-- ** unicharXdigitValue #method:unicharXdigitValue#

    unicharXdigitValue                      ,


-- ** unicodeCanonicalDecomposition #method:unicodeCanonicalDecomposition#

    unicodeCanonicalDecomposition           ,


-- ** unicodeCanonicalOrdering #method:unicodeCanonicalOrdering#

    unicodeCanonicalOrdering                ,


-- ** unixErrorQuark #method:unixErrorQuark#

    unixErrorQuark                          ,


-- ** unixFdAddFull #method:unixFdAddFull#

    unixFdAddFull                           ,


-- ** unixFdSourceNew #method:unixFdSourceNew#

    unixFdSourceNew                         ,


-- ** unixGetPasswdEntry #method:unixGetPasswdEntry#

    unixGetPasswdEntry                      ,


-- ** unixOpenPipe #method:unixOpenPipe#

    unixOpenPipe                            ,


-- ** unixSetFdNonblocking #method:unixSetFdNonblocking#

    unixSetFdNonblocking                    ,


-- ** unixSignalAdd #method:unixSignalAdd#

    unixSignalAdd                           ,


-- ** unixSignalSourceNew #method:unixSignalSourceNew#

    unixSignalSourceNew                     ,


-- ** unlink #method:unlink#

    unlink                                  ,


-- ** unsetenv #method:unsetenv#

    unsetenv                                ,


-- ** usleep #method:usleep#

    usleep                                  ,


-- ** utf16ToUcs4 #method:utf16ToUcs4#

    utf16ToUcs4                             ,


-- ** utf16ToUtf8 #method:utf16ToUtf8#

    utf16ToUtf8                             ,


-- ** utf8Casefold #method:utf8Casefold#

    utf8Casefold                            ,


-- ** utf8Collate #method:utf8Collate#

    utf8Collate                             ,


-- ** utf8CollateKey #method:utf8CollateKey#

    utf8CollateKey                          ,


-- ** utf8CollateKeyForFilename #method:utf8CollateKeyForFilename#

    utf8CollateKeyForFilename               ,


-- ** utf8FindNextChar #method:utf8FindNextChar#

    utf8FindNextChar                        ,


-- ** utf8FindPrevChar #method:utf8FindPrevChar#

    utf8FindPrevChar                        ,


-- ** utf8GetChar #method:utf8GetChar#

    utf8GetChar                             ,


-- ** utf8GetCharValidated #method:utf8GetCharValidated#

    utf8GetCharValidated                    ,


-- ** utf8MakeValid #method:utf8MakeValid#

    utf8MakeValid                           ,


-- ** utf8Normalize #method:utf8Normalize#

    utf8Normalize                           ,


-- ** utf8OffsetToPointer #method:utf8OffsetToPointer#

    utf8OffsetToPointer                     ,


-- ** utf8PointerToOffset #method:utf8PointerToOffset#

    utf8PointerToOffset                     ,


-- ** utf8PrevChar #method:utf8PrevChar#

    utf8PrevChar                            ,


-- ** utf8Strchr #method:utf8Strchr#

    utf8Strchr                              ,


-- ** utf8Strdown #method:utf8Strdown#

    utf8Strdown                             ,


-- ** utf8Strlen #method:utf8Strlen#

    utf8Strlen                              ,


-- ** utf8Strncpy #method:utf8Strncpy#

    utf8Strncpy                             ,


-- ** utf8Strrchr #method:utf8Strrchr#

    utf8Strrchr                             ,


-- ** utf8Strreverse #method:utf8Strreverse#

    utf8Strreverse                          ,


-- ** utf8Strup #method:utf8Strup#

    utf8Strup                               ,


-- ** utf8Substring #method:utf8Substring#

    utf8Substring                           ,


-- ** utf8ToUcs4 #method:utf8ToUcs4#

    utf8ToUcs4                              ,


-- ** utf8ToUcs4Fast #method:utf8ToUcs4Fast#

    utf8ToUcs4Fast                          ,


-- ** utf8ToUtf16 #method:utf8ToUtf16#

    utf8ToUtf16                             ,


-- ** utf8TruncateMiddle #method:utf8TruncateMiddle#

    utf8TruncateMiddle                      ,


-- ** utf8Validate #method:utf8Validate#

    utf8Validate                            ,


-- ** utf8ValidateLen #method:utf8ValidateLen#

    utf8ValidateLen                         ,


-- ** utime #method:utime#

    utime                                   ,


-- ** uuidStringIsValid #method:uuidStringIsValid#

    uuidStringIsValid                       ,


-- ** uuidStringRandom #method:uuidStringRandom#

    uuidStringRandom                        ,


-- ** variantGetGtype #method:variantGetGtype#

    variantGetGtype                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Bytes as GLib.Bytes
import {-# SOURCE #-} qualified GI.GLib.Structs.Cond as GLib.Cond
import {-# SOURCE #-} qualified GI.GLib.Structs.Data as GLib.Data
import {-# SOURCE #-} qualified GI.GLib.Structs.DebugKey as GLib.DebugKey
import {-# SOURCE #-} qualified GI.GLib.Structs.IOChannel as GLib.IOChannel
import {-# SOURCE #-} qualified GI.GLib.Structs.LogField as GLib.LogField
import {-# SOURCE #-} qualified GI.GLib.Structs.MainContext as GLib.MainContext
import {-# SOURCE #-} qualified GI.GLib.Structs.MemVTable as GLib.MemVTable
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.Source as GLib.Source
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceCallbackFuncs as GLib.SourceCallbackFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceFuncs as GLib.SourceFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.StatBuf as GLib.StatBuf
import {-# SOURCE #-} qualified GI.GLib.Structs.TestCase as GLib.TestCase
import {-# SOURCE #-} qualified GI.GLib.Structs.TestSuite as GLib.TestSuite
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import {-# SOURCE #-} qualified GI.GLib.Unions.Mutex as GLib.Mutex

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Bytes as GLib.Bytes
import {-# SOURCE #-} qualified GI.GLib.Structs.Data as GLib.Data
import {-# SOURCE #-} qualified GI.GLib.Structs.DebugKey as GLib.DebugKey
import {-# SOURCE #-} qualified GI.GLib.Structs.IOChannel as GLib.IOChannel
import {-# SOURCE #-} qualified GI.GLib.Structs.LogField as GLib.LogField
import {-# SOURCE #-} qualified GI.GLib.Structs.MemVTable as GLib.MemVTable
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.Source as GLib.Source
import {-# SOURCE #-} qualified GI.GLib.Structs.StatBuf as GLib.StatBuf
import {-# SOURCE #-} qualified GI.GLib.Structs.TestSuite as GLib.TestSuite
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal

#endif

-- function variant_get_gtype
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_get_gtype" g_variant_get_gtype :: 
    IO CGType

-- | /No description available in the introspection data./
variantGetGtype ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GType
variantGetGtype  = liftIO $ do
    result <- g_variant_get_gtype
    let result' = GType result
    return result'


-- function uuid_string_random
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_uuid_string_random" g_uuid_string_random :: 
    IO CString

-- | Generates a random UUID (RFC 4122 version 4) as a string. It has the same
-- randomness guarantees as t'GI.GLib.Structs.Rand.Rand', so must not be used for cryptographic
-- purposes such as key generation, nonces, salts or one-time pads.
-- 
-- /Since: 2.52/
uuidStringRandom ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ A string that should be freed with 'GI.GLib.Functions.free'.
uuidStringRandom  = liftIO $ do
    result <- g_uuid_string_random
    checkUnexpectedReturnNULL "uuidStringRandom" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function uuid_string_is_valid
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string representing a UUID"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_uuid_string_is_valid" g_uuid_string_is_valid :: 
    CString ->                              -- str : TBasicType TUTF8
    IO CInt

-- | Parses the string /@str@/ and verify if it is a UUID.
-- 
-- The function accepts the following syntax:
-- 
-- * simple forms (e.g. @f81d4fae-7dec-11d0-a765-00a0c91e6bf6@)
-- 
-- 
-- Note that hyphens are required within the UUID string itself,
-- as per the aforementioned RFC.
-- 
-- /Since: 2.52/
uuidStringIsValid ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a string representing a UUID
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@str@/ is a valid UUID, 'P.False' otherwise.
uuidStringIsValid str = liftIO $ do
    str' <- textToCString str
    result <- g_uuid_string_is_valid str'
    let result' = (/= 0) result
    freeMem str'
    return result'


-- function utime
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "utb"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a struct utimbuf."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_utime" g_utime :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr () ->                               -- utb : TBasicType TPtr
    IO Int32

-- | A wrapper for the POSIX @/utime()/@ function. The @/utime()/@ function
-- sets the access and modification timestamps of a file.
-- 
-- See your C library manual for more details about how @/utime()/@ works
-- on your system.
-- 
-- /Since: 2.18/
utime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> Ptr ()
    -- ^ /@utb@/: a pointer to a struct utimbuf.
    -> m Int32
    -- ^ __Returns:__ 0 if the operation was successful, -1 if an error occurred
utime filename utb = liftIO $ do
    filename' <- stringToCString filename
    result <- g_utime filename' utb
    freeMem filename'
    return result


-- function utf8_validate_len
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to character data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_len"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "max bytes to validate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TCArray True (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for end of valid data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "max_len"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "max bytes to validate"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_validate_len" g_utf8_validate_len :: 
    Ptr Word8 ->                            -- str : TCArray False (-1) 1 (TBasicType TUInt8)
    FCT.CSize ->                            -- max_len : TBasicType TSize
    Ptr (Ptr Word8) ->                      -- end : TCArray True (-1) (-1) (TBasicType TUInt8)
    IO CInt

-- | Validates UTF-8 encoded text.
-- 
-- As with 'GI.GLib.Functions.utf8Validate', but /@maxLen@/ must be set, and hence this
-- function will always return @FALSE@ if any of the bytes of /@str@/ are nul.
-- 
-- /Since: 2.60/
utf8ValidateLen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ByteString
    -- ^ /@str@/: a pointer to character data
    -> m ((Bool, ByteString))
    -- ^ __Returns:__ @TRUE@ if the text was valid UTF-8
utf8ValidateLen str = liftIO $ do
    let maxLen = fromIntegral $ B.length str
    str' <- packByteString str
    end <- callocMem :: IO (Ptr (Ptr Word8))
    result <- g_utf8_validate_len str' maxLen end
    let result' = (/= 0) result
    end' <- peek end
    end'' <- unpackZeroTerminatedByteString end'
    freeMem str'
    freeMem end
    return (result', end'')


-- function utf8_validate
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to character data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "max bytes to validate, or `-1` to go until nul"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TCArray True (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for end of valid data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "max_len"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "max bytes to validate, or `-1` to go until nul"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_validate" g_utf8_validate :: 
    Ptr Word8 ->                            -- str : TCArray False (-1) 1 (TBasicType TUInt8)
    DI.Int64 ->                             -- max_len : TBasicType TSSize
    Ptr (Ptr Word8) ->                      -- end : TCArray True (-1) (-1) (TBasicType TUInt8)
    IO CInt

-- | Validates UTF-8 encoded text.
-- 
-- /@str@/ is the text to validate; if /@str@/ is nul-terminated, then /@maxLen@/ can be
-- @-1@, otherwise /@maxLen@/ should be the number of bytes to validate.
-- 
-- If /@end@/ is non-@NULL@, then the end of the valid range will be stored there.
-- This is the first byte of the first invalid character if some bytes were
-- invalid, or the end of the text being validated otherwise — either the
-- trailing nul byte, or the first byte beyond /@maxLen@/ (if it’s positive).
-- 
-- Note that @g_utf8_validate()@ returns @FALSE@ if /@maxLen@/ is  positive and
-- any of the /@maxLen@/ bytes are nul.
-- 
-- Returns @TRUE@ if all of /@str@/ was valid. Many GLib and GTK
-- routines require valid UTF-8 as input; so data read from a file
-- or the network should be checked with @g_utf8_validate()@ before
-- doing anything else with it.
utf8Validate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ByteString
    -- ^ /@str@/: a pointer to character data
    -> m ((Bool, ByteString))
    -- ^ __Returns:__ @TRUE@ if the text was valid UTF-8
utf8Validate str = liftIO $ do
    let maxLen = fromIntegral $ B.length str
    str' <- packByteString str
    end <- callocMem :: IO (Ptr (Ptr Word8))
    result <- g_utf8_validate str' maxLen end
    let result' = (/= 0) result
    end' <- peek end
    end'' <- unpackZeroTerminatedByteString end'
    freeMem str'
    freeMem end
    return (result', end'')


-- function utf8_truncate_middle
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a nul-terminated UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "truncate_length"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new size of @string, in characters, including the ellipsis character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_truncate_middle" g_utf8_truncate_middle :: 
    CString ->                              -- string : TBasicType TUTF8
    FCT.CSize ->                            -- truncate_length : TBasicType TSize
    IO CString

-- | Cuts off the middle of the string, preserving half of /@truncateLength@/
-- characters at the beginning and half at the end.
-- 
-- If /@string@/ is already short enough, this returns a copy of /@string@/.
-- If /@truncateLength@/ is @0@, an empty string is returned.
-- 
-- /Since: 2.78/
utf8TruncateMiddle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: a nul-terminated UTF-8 encoded string
    -> FCT.CSize
    -- ^ /@truncateLength@/: the new size of /@string@/, in characters, including the ellipsis character
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated copy of /@string@/ ellipsized in the middle
utf8TruncateMiddle string truncateLength = liftIO $ do
    string' <- textToCString string
    result <- g_utf8_truncate_middle string' truncateLength
    checkUnexpectedReturnNULL "utf8TruncateMiddle" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    return result'


-- function utf8_to_utf16
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length (number of bytes) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "items_read"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number of bytes read, or\n  `NULL`. If `NULL`, then [error@GLib.ConvertError.PARTIAL_INPUT] will\n  be returned in case @str contains a trailing partial character. If\n  an error occurs then the index of the invalid input is stored here."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "items_written"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number\n  of `gunichar2` written, or `NULL`. The value stored here does not include\n  the trailing nul."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt16)
-- throws : True
-- Skip return : False

foreign import ccall "g_utf8_to_utf16" g_utf8_to_utf16 :: 
    CString ->                              -- str : TBasicType TUTF8
    FCT.CLong ->                            -- len : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_read : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_written : TBasicType TLong
    Ptr (Ptr GError) ->                     -- error
    IO Word16

-- | Convert a string from UTF-8 to UTF-16.
-- 
-- A nul character (U+0000) will be added to the result after the converted text.
utf8ToUtf16 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> FCT.CLong
    -- ^ /@len@/: the maximum length (number of bytes) of /@str@/ to use.
    --   If /@len@/ is negative, then the string is nul-terminated.
    -> m ((Word16, FCT.CLong, FCT.CLong))
    -- ^ __Returns:__ a pointer to a newly allocated UTF-16 string.
    --   This value must be freed with 'GI.GLib.Functions.free'. /(Can throw 'Data.GI.Base.GError.GError')/
utf8ToUtf16 str len = liftIO $ do
    str' <- textToCString str
    itemsRead <- allocMem :: IO (Ptr FCT.CLong)
    itemsWritten <- allocMem :: IO (Ptr FCT.CLong)
    onException (do
        result <- propagateGError $ g_utf8_to_utf16 str' len itemsRead itemsWritten
        itemsRead' <- peek itemsRead
        itemsWritten' <- peek itemsWritten
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
        return (result, itemsRead', itemsWritten')
     ) (do
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
     )


-- function utf8_to_ucs4_fast
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length of @str to use, in bytes. If @len is negative,\n  then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "items_written"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the\n  number of characters in the result, or `NULL`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUniChar)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_to_ucs4_fast" g_utf8_to_ucs4_fast :: 
    CString ->                              -- str : TBasicType TUTF8
    FCT.CLong ->                            -- len : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_written : TBasicType TLong
    IO CInt

-- | Convert a string from UTF-8 to a 32-bit fixed width
-- representation as UCS-4, assuming valid UTF-8 input.
-- 
-- This function is roughly twice as fast as 'GI.GLib.Functions.utf8ToUcs4'
-- but does no error checking on the input. A trailing nul character (U+0000)
-- will be added to the string after the converted text.
utf8ToUcs4Fast ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> FCT.CLong
    -- ^ /@len@/: the maximum length of /@str@/ to use, in bytes. If /@len@/ is negative,
    --   then the string is nul-terminated.
    -> m ((Char, FCT.CLong))
    -- ^ __Returns:__ a pointer to a newly allocated UCS-4 string.
    --   This value must be freed with 'GI.GLib.Functions.free'.
utf8ToUcs4Fast str len = liftIO $ do
    str' <- textToCString str
    itemsWritten <- allocMem :: IO (Ptr FCT.CLong)
    result <- g_utf8_to_ucs4_fast str' len itemsWritten
    let result' = (chr . fromIntegral) result
    itemsWritten' <- peek itemsWritten
    freeMem str'
    freeMem itemsWritten
    return (result', itemsWritten')


-- function utf8_to_ucs4
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length of @str to use, in bytes. If @len is negative,\n  then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "items_read"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number of\n bytes read, or `NULL`.\n  If `NULL`, then %G_CONVERT_ERROR_PARTIAL_INPUT will be\n  returned in case @str contains a trailing partial\n  character. If an error occurs then the index of the\n  invalid input is stored here."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "items_written"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number\n  of characters written or `NULL`. The value here stored does not include\n  the trailing nul character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUniChar)
-- throws : True
-- Skip return : False

foreign import ccall "g_utf8_to_ucs4" g_utf8_to_ucs4 :: 
    CString ->                              -- str : TBasicType TUTF8
    FCT.CLong ->                            -- len : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_read : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_written : TBasicType TLong
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Convert a string from UTF-8 to a 32-bit fixed width representation as UCS-4.
-- 
-- A trailing nul character (U+0000) will be added to the string after the
-- converted text.
utf8ToUcs4 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> FCT.CLong
    -- ^ /@len@/: the maximum length of /@str@/ to use, in bytes. If /@len@/ is negative,
    --   then the string is nul-terminated.
    -> m ((Char, FCT.CLong, FCT.CLong))
    -- ^ __Returns:__ a pointer to a newly allocated UCS-4 string.
    --   This value must be freed with 'GI.GLib.Functions.free'. /(Can throw 'Data.GI.Base.GError.GError')/
utf8ToUcs4 str len = liftIO $ do
    str' <- textToCString str
    itemsRead <- allocMem :: IO (Ptr FCT.CLong)
    itemsWritten <- allocMem :: IO (Ptr FCT.CLong)
    onException (do
        result <- propagateGError $ g_utf8_to_ucs4 str' len itemsRead itemsWritten
        let result' = (chr . fromIntegral) result
        itemsRead' <- peek itemsRead
        itemsWritten' <- peek itemsWritten
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
        return (result', itemsRead', itemsWritten')
     ) (do
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
     )


-- function utf8_substring
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start_pos"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a character offset within @str"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end_pos"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "another character offset within @str,\n  or `-1` to indicate the end of the string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_substring" g_utf8_substring :: 
    CString ->                              -- str : TBasicType TUTF8
    FCT.CLong ->                            -- start_pos : TBasicType TLong
    FCT.CLong ->                            -- end_pos : TBasicType TLong
    IO CString

-- | Copies a substring out of a UTF-8 encoded string.
-- The substring will contain /@endPos@/ - /@startPos@/ characters.
-- 
-- Since GLib 2.72, @-1@ can be passed to /@endPos@/ to indicate the
-- end of the string.
-- 
-- /Since: 2.30/
utf8Substring ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> FCT.CLong
    -- ^ /@startPos@/: a character offset within /@str@/
    -> FCT.CLong
    -- ^ /@endPos@/: another character offset within /@str@/,
    --   or @-1@ to indicate the end of the string
    -> m T.Text
    -- ^ __Returns:__ a newly allocated copy of the requested
    --   substring. Free with 'GI.GLib.Functions.free' when no longer needed.
utf8Substring str startPos endPos = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_substring str' startPos endPos
    checkUnexpectedReturnNULL "utf8Substring" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function utf8_strup
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "length of @str, in bytes, or -1 if @str is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_strup" g_utf8_strup :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    IO CString

-- | Converts all Unicode characters in the string that have a case
-- to uppercase. The exact manner that this is done depends
-- on the current locale, and may result in the number of
-- characters in the string increasing. (For instance, the
-- German ess-zet will be changed to SS.)
utf8Strup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> DI.Int64
    -- ^ /@len@/: length of /@str@/, in bytes, or -1 if /@str@/ is nul-terminated.
    -> m T.Text
    -- ^ __Returns:__ a newly allocated string, with all characters
    --    converted to uppercase.
utf8Strup str len = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_strup str' len
    checkUnexpectedReturnNULL "utf8Strup" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function utf8_strreverse
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length of @str to use, in bytes. If @len is negative,\n  then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_strreverse" g_utf8_strreverse :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    IO CString

-- | Reverses a UTF-8 string.
-- 
-- /@str@/ must be valid UTF-8 encoded text. (Use 'GI.GLib.Functions.utf8Validate' on all
-- text before trying to use UTF-8 utility functions with it.)
-- 
-- This function is intended for programmatic uses of reversed strings.
-- It pays no attention to decomposed characters, combining marks, byte
-- order marks, directional indicators (LRM, LRO, etc) and similar
-- characters which might need special handling when reversing a string
-- for display purposes.
-- 
-- Note that unlike 'GI.GLib.Functions.strreverse', this function returns
-- newly-allocated memory, which should be freed with 'GI.GLib.Functions.free' when
-- no longer needed.
-- 
-- /Since: 2.2/
utf8Strreverse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> DI.Int64
    -- ^ /@len@/: the maximum length of /@str@/ to use, in bytes. If /@len@/ is negative,
    --   then the string is nul-terminated.
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated string which is the reverse of /@str@/
utf8Strreverse str len = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_strreverse str' len
    checkUnexpectedReturnNULL "utf8Strreverse" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function utf8_strrchr
-- Args: [ Arg
--           { argCName = "p"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a nul-terminated UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum length of @p"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_strrchr" g_utf8_strrchr :: 
    CString ->                              -- p : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    CInt ->                                 -- c : TBasicType TUniChar
    IO CString

-- | Find the rightmost occurrence of the given Unicode character
-- in a UTF-8 encoded string, while limiting the search to /@len@/ bytes.
-- 
-- If /@len@/ is @-1@, allow unbounded search.
utf8Strrchr ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@p@/: a nul-terminated UTF-8 encoded string
    -> DI.Int64
    -- ^ /@len@/: the maximum length of /@p@/
    -> Char
    -- ^ /@c@/: a Unicode character
    -> m (Maybe T.Text)
    -- ^ __Returns:__ @NULL@ if the string does not contain
    --   the character, otherwise, a pointer to the start of the rightmost
    --   occurrence of the character in the string.
utf8Strrchr p len c = liftIO $ do
    p' <- textToCString p
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_utf8_strrchr p' len c'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    freeMem p'
    return maybeResult


-- function utf8_strncpy
-- Args: [ Arg
--           { argCName = "dest"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "buffer to fill with characters from @src"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "character count" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_strncpy" g_utf8_strncpy :: 
    CString ->                              -- dest : TBasicType TUTF8
    CString ->                              -- src : TBasicType TUTF8
    FCT.CSize ->                            -- n : TBasicType TSize
    IO CString

-- | Like the standard C <http://developer.gnome.org/glib/stable/man:strncpy `strncpy()`> function, but copies a given
-- number of characters instead of a given number of bytes.
-- 
-- The /@src@/ string must be valid UTF-8 encoded text. (Use
-- 'GI.GLib.Functions.utf8Validate' on all text before trying to use UTF-8 utility
-- functions with it.)
-- 
-- Note you must ensure /@dest@/ is at least 4 * /@n@/ + 1 to fit the
-- largest possible UTF-8 characters
utf8Strncpy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@dest@/: buffer to fill with characters from /@src@/
    -> T.Text
    -- ^ /@src@/: UTF-8 encoded string
    -> FCT.CSize
    -- ^ /@n@/: character count
    -> m T.Text
    -- ^ __Returns:__ /@dest@/
utf8Strncpy dest src n = liftIO $ do
    dest' <- textToCString dest
    src' <- textToCString src
    result <- g_utf8_strncpy dest' src' n
    checkUnexpectedReturnNULL "utf8Strncpy" result
    result' <- cstringToText result
    freeMem dest'
    freeMem src'
    return result'


-- function utf8_strlen
-- Args: [ Arg
--           { argCName = "p"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to the start of a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum number of bytes to examine. If @max\n  is less than 0, then the string is assumed to be\n  nul-terminated. If @max is 0, @p will not be examined and\n  may be `NULL`. If @max is greater than 0, up to @max\n  bytes are examined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_strlen" g_utf8_strlen :: 
    CString ->                              -- p : TBasicType TUTF8
    DI.Int64 ->                             -- max : TBasicType TSSize
    IO FCT.CLong

-- | Computes the length of the string in characters, not including
-- the terminating nul character. If the /@max@/’th byte falls in the
-- middle of a character, the last (partial) character is not counted.
utf8Strlen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@p@/: pointer to the start of a UTF-8 encoded string
    -> DI.Int64
    -- ^ /@max@/: the maximum number of bytes to examine. If /@max@/
    --   is less than 0, then the string is assumed to be
    --   nul-terminated. If /@max@/ is 0, /@p@/ will not be examined and
    --   may be @NULL@. If /@max@/ is greater than 0, up to /@max@/
    --   bytes are examined
    -> m FCT.CLong
    -- ^ __Returns:__ the length of the string in characters
utf8Strlen p max = liftIO $ do
    p' <- textToCString p
    result <- g_utf8_strlen p' max
    freeMem p'
    return result


-- function utf8_strdown
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "length of @str, in bytes, or -1 if @str is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_strdown" g_utf8_strdown :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    IO CString

-- | Converts all Unicode characters in the string that have a case
-- to lowercase. The exact manner that this is done depends
-- on the current locale, and may result in the number of
-- characters in the string changing.
utf8Strdown ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> DI.Int64
    -- ^ /@len@/: length of /@str@/, in bytes, or -1 if /@str@/ is nul-terminated.
    -> m T.Text
    -- ^ __Returns:__ a newly allocated string, with all characters
    --    converted to lowercase.
utf8Strdown str len = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_strdown str' len
    checkUnexpectedReturnNULL "utf8Strdown" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function utf8_strchr
-- Args: [ Arg
--           { argCName = "p"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a nul-terminated UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum length of @p"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_strchr" g_utf8_strchr :: 
    CString ->                              -- p : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    CInt ->                                 -- c : TBasicType TUniChar
    IO CString

-- | Finds the leftmost occurrence of the given Unicode character
-- in a UTF-8 encoded string, while limiting the search to /@len@/ bytes.
-- 
-- If /@len@/ is @-1@, allow unbounded search.
utf8Strchr ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@p@/: a nul-terminated UTF-8 encoded string
    -> DI.Int64
    -- ^ /@len@/: the maximum length of /@p@/
    -> Char
    -- ^ /@c@/: a Unicode character
    -> m (Maybe T.Text)
    -- ^ __Returns:__ @NULL@ if the string does not contain
    --   the character, otherwise, a pointer to the start of the leftmost occurrence
    --   of the character in the string.
utf8Strchr p len c = liftIO $ do
    p' <- textToCString p
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_utf8_strchr p' len c'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    freeMem p'
    return maybeResult


-- function utf8_prev_char
-- Args: [ Arg
--           { argCName = "p"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a pointer to a position within a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_prev_char" g_utf8_prev_char :: 
    CString ->                              -- p : TBasicType TUTF8
    IO CString

-- | Finds the previous UTF-8 character in the string before /@p@/.
-- 
-- /@p@/ does not have to be at the beginning of a UTF-8 character. No check
-- is made to see if the character found is actually valid other than
-- it starts with an appropriate byte. If /@p@/ might be the first
-- character of the string, you must use 'GI.GLib.Functions.utf8FindPrevChar'
-- instead.
utf8PrevChar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@p@/: a pointer to a position within a UTF-8 encoded string
    -> m T.Text
    -- ^ __Returns:__ a pointer to the found character
utf8PrevChar p = liftIO $ do
    p' <- textToCString p
    result <- g_utf8_prev_char p'
    checkUnexpectedReturnNULL "utf8PrevChar" result
    result' <- cstringToText result
    freeMem p'
    return result'


-- function utf8_pointer_to_offset
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a position within @str"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TLong)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_pointer_to_offset" g_utf8_pointer_to_offset :: 
    CString ->                              -- str : TBasicType TUTF8
    CString ->                              -- pos : TBasicType TUTF8
    IO FCT.CLong

-- | Converts from a pointer to position within a string to an integer
-- character offset.
-- 
-- Since 2.10, this function allows /@pos@/ to be before /@str@/, and returns
-- a negative offset in this case.
utf8PointerToOffset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> T.Text
    -- ^ /@pos@/: a pointer to a position within /@str@/
    -> m FCT.CLong
    -- ^ __Returns:__ the resulting character offset
utf8PointerToOffset str pos = liftIO $ do
    str' <- textToCString str
    pos' <- textToCString pos
    result <- g_utf8_pointer_to_offset str' pos'
    freeMem str'
    freeMem pos'
    return result


-- function utf8_offset_to_pointer
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a character offset within @str"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_offset_to_pointer" g_utf8_offset_to_pointer :: 
    CString ->                              -- str : TBasicType TUTF8
    FCT.CLong ->                            -- offset : TBasicType TLong
    IO CString

-- | Converts from an integer character offset to a pointer to a position
-- within the string.
-- 
-- Since 2.10, this function allows to pass a negative /@offset@/ to
-- step backwards. It is usually worth stepping backwards from the end
-- instead of forwards if /@offset@/ is in the last fourth of the string,
-- since moving forward is about 3 times faster than moving backward.
-- 
-- Note that this function doesn’t abort when reaching the end of /@str@/.
-- Therefore you should be sure that /@offset@/ is within string boundaries
-- before calling that function. Call 'GI.GLib.Functions.utf8Strlen' when unsure.
-- This limitation exists as this function is called frequently during
-- text rendering and therefore has to be as fast as possible.
utf8OffsetToPointer ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> FCT.CLong
    -- ^ /@offset@/: a character offset within /@str@/
    -> m T.Text
    -- ^ __Returns:__ the resulting pointer
utf8OffsetToPointer str offset = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_offset_to_pointer str' offset
    checkUnexpectedReturnNULL "utf8OffsetToPointer" result
    result' <- cstringToText result
    freeMem str'
    return result'


-- function utf8_normalize
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "length of @str, in bytes, or -1 if @str is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "NormalizeMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type of normalization to perform."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_normalize" g_utf8_normalize :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    CUInt ->                                -- mode : TInterface (Name {namespace = "GLib", name = "NormalizeMode"})
    IO CString

-- | Converts a string into canonical form, standardizing
-- such issues as whether a character with an accent
-- is represented as a base character and combining
-- accent or as a single precomposed character. The
-- string has to be valid UTF-8, otherwise 'P.Nothing' is
-- returned. You should generally call 'GI.GLib.Functions.utf8Normalize'
-- before comparing two Unicode strings.
-- 
-- The normalization mode 'GI.GLib.Enums.NormalizeModeDefault' only
-- standardizes differences that do not affect the
-- text content, such as the above-mentioned accent
-- representation. 'GI.GLib.Enums.NormalizeModeAll' also standardizes
-- the \"compatibility\" characters in Unicode, such
-- as SUPERSCRIPT THREE to the standard forms
-- (in this case DIGIT THREE). Formatting information
-- may be lost but for most text operations such
-- characters should be considered the same.
-- 
-- 'GI.GLib.Enums.NormalizeModeDefaultCompose' and 'GI.GLib.Enums.NormalizeModeAllCompose'
-- are like 'GI.GLib.Enums.NormalizeModeDefault' and 'GI.GLib.Enums.NormalizeModeAll',
-- but returned a result with composed forms rather
-- than a maximally decomposed form. This is often
-- useful if you intend to convert the string to
-- a legacy encoding or pass it to a system with
-- less capable Unicode handling.
utf8Normalize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string.
    -> DI.Int64
    -- ^ /@len@/: length of /@str@/, in bytes, or -1 if /@str@/ is nul-terminated.
    -> GLib.Enums.NormalizeMode
    -- ^ /@mode@/: the type of normalization to perform.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a newly allocated string, that
    --   is the normalized form of /@str@/, or 'P.Nothing' if /@str@/
    --   is not valid UTF-8.
utf8Normalize str len mode = liftIO $ do
    str' <- textToCString str
    let mode' = (fromIntegral . fromEnum) mode
    result <- g_utf8_normalize str' len mode'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem str'
    return maybeResult


-- function utf8_make_valid
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to coerce into UTF-8"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length of @str to use, in bytes. If @len is negative,\n  then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_make_valid" g_utf8_make_valid :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    IO CString

-- | If the provided string is valid UTF-8, return a copy of it. If not,
-- return a copy in which bytes that could not be interpreted as valid Unicode
-- are replaced with the Unicode replacement character (U+FFFD).
-- 
-- For example, this is an appropriate function to use if you have received
-- a string that was incorrectly declared to be UTF-8, and you need a valid
-- UTF-8 version of it that can be logged or displayed to the user, with the
-- assumption that it is close enough to ASCII or UTF-8 to be mostly
-- readable as-is.
-- 
-- /Since: 2.52/
utf8MakeValid ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: string to coerce into UTF-8
    -> DI.Int64
    -- ^ /@len@/: the maximum length of /@str@/ to use, in bytes. If /@len@/ is negative,
    --   then the string is nul-terminated.
    -> m T.Text
    -- ^ __Returns:__ a valid UTF-8 string whose content resembles /@str@/
utf8MakeValid str len = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_make_valid str' len
    checkUnexpectedReturnNULL "utf8MakeValid" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function utf8_get_char_validated
-- Args: [ Arg
--           { argCName = "p"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a pointer to Unicode character encoded as UTF-8"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum number of bytes to read, or `-1` if @p is nul-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUniChar)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_get_char_validated" g_utf8_get_char_validated :: 
    CString ->                              -- p : TBasicType TUTF8
    DI.Int64 ->                             -- max_len : TBasicType TSSize
    IO CInt

-- | Convert a sequence of bytes encoded as UTF-8 to a Unicode character.
-- 
-- This function checks for incomplete characters, for invalid characters
-- such as characters that are out of the range of Unicode, and for
-- overlong encodings of valid characters.
-- 
-- Note that 'GI.GLib.Functions.utf8GetCharValidated' returns @(gunichar)-2@ if
-- /@maxLen@/ is positive and any of the bytes in the first UTF-8 character
-- sequence are nul.
utf8GetCharValidated ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@p@/: a pointer to Unicode character encoded as UTF-8
    -> DI.Int64
    -- ^ /@maxLen@/: the maximum number of bytes to read, or @-1@ if /@p@/ is nul-terminated
    -> m Char
    -- ^ __Returns:__ the resulting character. If /@p@/ points to a partial
    --   sequence at the end of a string that could begin a valid
    --   character (or if /@maxLen@/ is zero), returns @(gunichar)-2@;
    --   otherwise, if /@p@/ does not point to a valid UTF-8 encoded
    --   Unicode character, returns @(gunichar)-1@.
utf8GetCharValidated p maxLen = liftIO $ do
    p' <- textToCString p
    result <- g_utf8_get_char_validated p' maxLen
    let result' = (chr . fromIntegral) result
    freeMem p'
    return result'


-- function utf8_get_char
-- Args: [ Arg
--           { argCName = "p"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a pointer to Unicode character encoded as UTF-8"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUniChar)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_get_char" g_utf8_get_char :: 
    CString ->                              -- p : TBasicType TUTF8
    IO CInt

-- | Converts a sequence of bytes encoded as UTF-8 to a Unicode character.
-- 
-- If /@p@/ does not point to a valid UTF-8 encoded character, results
-- are undefined. If you are not sure that the bytes are complete
-- valid Unicode characters, you should use 'GI.GLib.Functions.utf8GetCharValidated'
-- instead.
utf8GetChar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@p@/: a pointer to Unicode character encoded as UTF-8
    -> m Char
    -- ^ __Returns:__ the resulting character
utf8GetChar p = liftIO $ do
    p' <- textToCString p
    result <- g_utf8_get_char p'
    let result' = (chr . fromIntegral) result
    freeMem p'
    return result'


-- function utf8_find_prev_char
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to the beginning of a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer to some position within @str"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_find_prev_char" g_utf8_find_prev_char :: 
    CString ->                              -- str : TBasicType TUTF8
    CString ->                              -- p : TBasicType TUTF8
    IO CString

-- | Given a position /@p@/ with a UTF-8 encoded string /@str@/, find the start
-- of the previous UTF-8 character starting before /@p@/. Returns @NULL@ if no
-- UTF-8 characters are present in /@str@/ before /@p@/.
-- 
-- /@p@/ does not have to be at the beginning of a UTF-8 character. No check
-- is made to see if the character found is actually valid other than
-- it starts with an appropriate byte.
utf8FindPrevChar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: pointer to the beginning of a UTF-8 encoded string
    -> T.Text
    -- ^ /@p@/: pointer to some position within /@str@/
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a pointer to the found character
utf8FindPrevChar str p = liftIO $ do
    str' <- textToCString str
    p' <- textToCString p
    result <- g_utf8_find_prev_char str' p'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    freeMem str'
    freeMem p'
    return maybeResult


-- function utf8_find_next_char
-- Args: [ Arg
--           { argCName = "p"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a pointer to a position within a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to the byte following the end of the string,\n    or `NULL` to indicate that the string is nul-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_find_next_char" g_utf8_find_next_char :: 
    CString ->                              -- p : TBasicType TUTF8
    CString ->                              -- end : TBasicType TUTF8
    IO CString

-- | Finds the start of the next UTF-8 character in the string after /@p@/.
-- 
-- /@p@/ does not have to be at the beginning of a UTF-8 character. No check
-- is made to see if the character found is actually valid other than
-- it starts with an appropriate byte.
-- 
-- If /@end@/ is @NULL@, the return value will never be @NULL@: if the end of the
-- string is reached, a pointer to the terminating nul byte is returned. If
-- /@end@/ is non-@NULL@, the return value will be @NULL@ if the end of the string
-- is reached.
utf8FindNextChar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@p@/: a pointer to a position within a UTF-8 encoded string
    -> Maybe (T.Text)
    -- ^ /@end@/: a pointer to the byte following the end of the string,
    --     or @NULL@ to indicate that the string is nul-terminated
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a pointer to the found character or @NULL@ if /@end@/ is
    --    set and is reached
utf8FindNextChar p end = liftIO $ do
    p' <- textToCString p
    maybeEnd <- case end of
        Nothing -> return FP.nullPtr
        Just jEnd -> do
            jEnd' <- textToCString jEnd
            return jEnd'
    result <- g_utf8_find_next_char p' maybeEnd
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    freeMem p'
    freeMem maybeEnd
    return maybeResult


-- function utf8_collate_key_for_filename
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "length of @str, in bytes, or -1 if @str is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_collate_key_for_filename" g_utf8_collate_key_for_filename :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    IO CString

-- | Converts a string into a collation key that can be compared
-- with other collation keys produced by the same function using @/strcmp()/@.
-- 
-- In order to sort filenames correctly, this function treats the dot \'.\'
-- as a special case. Most dictionary orderings seem to consider it
-- insignificant, thus producing the ordering \"event.c\" \"eventgenerator.c\"
-- \"event.h\" instead of \"event.c\" \"event.h\" \"eventgenerator.c\". Also, we
-- would like to treat numbers intelligently so that \"file1\" \"file10\" \"file5\"
-- is sorted as \"file1\" \"file5\" \"file10\".
-- 
-- Note that this function depends on the <http://developer.gnome.org/glib/stable/running.html#locale current locale>.
-- 
-- Note that the returned string is not guaranteed to be in any
-- encoding, especially UTF-8. The returned value is meant to be
-- used only for comparisons.
-- 
-- /Since: 2.8/
utf8CollateKeyForFilename ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string.
    -> DI.Int64
    -- ^ /@len@/: length of /@str@/, in bytes, or -1 if /@str@/ is nul-terminated.
    -> m [Char]
    -- ^ __Returns:__ a newly allocated string.
    --   The contents of the string are only meant to be used when sorting.
    --   This string should be freed with 'GI.GLib.Functions.free' when you are done with it.
utf8CollateKeyForFilename str len = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_collate_key_for_filename str' len
    checkUnexpectedReturnNULL "utf8CollateKeyForFilename" result
    result' <- cstringToString result
    freeMem result
    freeMem str'
    return result'


-- function utf8_collate_key
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "length of @str, in bytes, or -1 if @str is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_collate_key" g_utf8_collate_key :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    IO CString

-- | Converts a string into a collation key that can be compared
-- with other collation keys produced by the same function using
-- @/strcmp()/@.
-- 
-- The results of comparing the collation keys of two strings
-- with @/strcmp()/@ will always be the same as comparing the two
-- original keys with 'GI.GLib.Functions.utf8Collate'.
-- 
-- Note that this function depends on the <http://developer.gnome.org/glib/stable/running.html#locale current locale>.
-- 
-- Note that the returned string is not guaranteed to be in any
-- encoding, especially UTF-8. The returned value is meant to be
-- used only for comparisons.
utf8CollateKey ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string.
    -> DI.Int64
    -- ^ /@len@/: length of /@str@/, in bytes, or -1 if /@str@/ is nul-terminated.
    -> m [Char]
    -- ^ __Returns:__ a newly allocated string.
    --   The contents of the string are only meant to be used when sorting.
    --   This string should be freed with 'GI.GLib.Functions.free' when you are done with it.
utf8CollateKey str len = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_collate_key str' len
    checkUnexpectedReturnNULL "utf8CollateKey" result
    result' <- cstringToString result
    freeMem result
    freeMem str'
    return result'


-- function utf8_collate
-- Args: [ Arg
--           { argCName = "str1"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str2"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_collate" g_utf8_collate :: 
    CString ->                              -- str1 : TBasicType TUTF8
    CString ->                              -- str2 : TBasicType TUTF8
    IO Int32

-- | Compares two strings for ordering using the linguistically
-- correct rules for the <http://developer.gnome.org/glib/stable/running.html#locale current locale>.
-- When sorting a large number of strings, it will be significantly
-- faster to obtain collation keys with 'GI.GLib.Functions.utf8CollateKey' and
-- compare the keys with @/strcmp()/@ when sorting instead of sorting
-- the original strings.
-- 
-- If the two strings are not comparable due to being in different collation
-- sequences, the result is undefined. This can happen if the strings are in
-- different language scripts, for example.
utf8Collate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str1@/: a UTF-8 encoded string
    -> T.Text
    -- ^ /@str2@/: a UTF-8 encoded string
    -> m Int32
    -- ^ __Returns:__ \< 0 if /@str1@/ compares before /@str2@/,
    --   0 if they compare equal, > 0 if /@str1@/ compares after /@str2@/.
utf8Collate str1 str2 = liftIO $ do
    str1' <- textToCString str1
    str2' <- textToCString str2
    result <- g_utf8_collate str1' str2'
    freeMem str1'
    freeMem str2'
    return result


-- function utf8_casefold
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "length of @str, in bytes, or -1 if @str is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_utf8_casefold" g_utf8_casefold :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    IO CString

-- | Converts a string into a form that is independent of case. The
-- result will not correspond to any particular case, but can be
-- compared for equality or ordered with the results of calling
-- 'GI.GLib.Functions.utf8Casefold' on other strings.
-- 
-- Note that calling 'GI.GLib.Functions.utf8Casefold' followed by 'GI.GLib.Functions.utf8Collate' is
-- only an approximation to the correct linguistic case insensitive
-- ordering, though it is a fairly good one. Getting this exactly
-- right would require a more sophisticated collation function that
-- takes case sensitivity into account. GLib does not currently
-- provide such a function.
utf8Casefold ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 encoded string
    -> DI.Int64
    -- ^ /@len@/: length of /@str@/, in bytes, or -1 if /@str@/ is nul-terminated.
    -> m T.Text
    -- ^ __Returns:__ a newly allocated string, that is a
    --   case independent form of /@str@/.
utf8Casefold str len = liftIO $ do
    str' <- textToCString str
    result <- g_utf8_casefold str' len
    checkUnexpectedReturnNULL "utf8Casefold" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function utf16_to_utf8
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt16)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-16 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length (number of #gunichar2) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "items_read"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number of words read, or\n  `NULL`. If `NULL`, then [error@GLib.ConvertError.PARTIAL_INPUT] will\n  be returned in case @str contains a trailing partial character. If\n  an error occurs then the index of the invalid input is stored here.\n  It\8217s guaranteed to be non-negative."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "items_written"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number\n  of bytes written, or `NULL`. The value stored here does not include the\n  trailing nul byte. It\8217s guaranteed to be non-negative."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TLong
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "the maximum length (number of #gunichar2) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUTF8)
-- throws : True
-- Skip return : False

foreign import ccall "g_utf16_to_utf8" g_utf16_to_utf8 :: 
    Ptr Word16 ->                           -- str : TCArray False (-1) 1 (TBasicType TUInt16)
    FCT.CLong ->                            -- len : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_read : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_written : TBasicType TLong
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Convert a string from UTF-16 to UTF-8.
-- 
-- The result will be terminated with a nul byte.
-- 
-- Note that the input is expected to be already in native endianness,
-- an initial byte-order-mark character is not handled specially.
-- 'GI.GLib.Functions.convert' can be used to convert a byte buffer of UTF-16 data of
-- ambiguous endianness.
-- 
-- Further note that this function does not validate the result
-- string; it may (for example) include embedded nul characters. The only
-- validation done by this function is to ensure that the input can
-- be correctly interpreted as UTF-16, i.e. it doesn’t contain
-- unpaired surrogates or partial character sequences.
utf16ToUtf8 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Word16]
    -- ^ /@str@/: a UTF-16 encoded string
    -> m ((T.Text, FCT.CLong, FCT.CLong))
    -- ^ __Returns:__ a pointer to a newly allocated UTF-8 string.
    --   This value must be freed with 'GI.GLib.Functions.free'. /(Can throw 'Data.GI.Base.GError.GError')/
utf16ToUtf8 str = liftIO $ do
    let len = fromIntegral $ P.length str
    str' <- packStorableArray str
    itemsRead <- allocMem :: IO (Ptr FCT.CLong)
    itemsWritten <- allocMem :: IO (Ptr FCT.CLong)
    onException (do
        result <- propagateGError $ g_utf16_to_utf8 str' len itemsRead itemsWritten
        checkUnexpectedReturnNULL "utf16ToUtf8" result
        result' <- cstringToText result
        freeMem result
        itemsRead' <- peek itemsRead
        itemsWritten' <- peek itemsWritten
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
        return (result', itemsRead', itemsWritten')
     ) (do
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
     )


-- function utf16_to_ucs4
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt16)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-16 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length (number of #gunichar2) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "items_read"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number of words read, or\n  `NULL`. If `NULL`, then [error@GLib.ConvertError.PARTIAL_INPUT] will be\n  returned in case @str contains a trailing partial character. If\n  an error occurs then the index of the invalid input is stored here."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "items_written"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number\n  of characters written, or `NULL`. The value stored here does not include\n  the trailing nul character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TLong
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "the maximum length (number of #gunichar2) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUniChar)
-- throws : True
-- Skip return : False

foreign import ccall "g_utf16_to_ucs4" g_utf16_to_ucs4 :: 
    Ptr Word16 ->                           -- str : TCArray False (-1) 1 (TBasicType TUInt16)
    FCT.CLong ->                            -- len : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_read : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_written : TBasicType TLong
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Convert a string from UTF-16 to UCS-4.
-- 
-- The result will be nul-terminated.
utf16ToUcs4 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Word16]
    -- ^ /@str@/: a UTF-16 encoded string
    -> m ((Char, FCT.CLong, FCT.CLong))
    -- ^ __Returns:__ a pointer to a newly allocated UCS-4 string.
    --   This value must be freed with 'GI.GLib.Functions.free'. /(Can throw 'Data.GI.Base.GError.GError')/
utf16ToUcs4 str = liftIO $ do
    let len = fromIntegral $ P.length str
    str' <- packStorableArray str
    itemsRead <- allocMem :: IO (Ptr FCT.CLong)
    itemsWritten <- allocMem :: IO (Ptr FCT.CLong)
    onException (do
        result <- propagateGError $ g_utf16_to_ucs4 str' len itemsRead itemsWritten
        let result' = (chr . fromIntegral) result
        itemsRead' <- peek itemsRead
        itemsWritten' <- peek itemsWritten
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
        return (result', itemsRead', itemsWritten')
     ) (do
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
     )


-- function usleep
-- Args: [ Arg
--           { argCName = "microseconds"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of microseconds to pause"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_usleep" g_usleep :: 
    FCT.CULong ->                           -- microseconds : TBasicType TULong
    IO ()

-- | Pauses the current thread for the given number of microseconds.
-- 
-- There are 1 million microseconds per second (represented by the
-- 'GI.GLib.Constants.USEC_PER_SEC' macro). 'GI.GLib.Functions.usleep' may have limited precision,
-- depending on hardware and operating system; don\'t rely on the exact
-- length of the sleep.
usleep ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CULong
    -- ^ /@microseconds@/: number of microseconds to pause
    -> m ()
usleep microseconds = liftIO $ do
    g_usleep microseconds
    return ()


-- function unsetenv
-- Args: [ Arg
--           { argCName = "variable"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the environment variable to remove, must\n    not contain '='"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_unsetenv" g_unsetenv :: 
    CString ->                              -- variable : TBasicType TFileName
    IO ()

-- | Removes an environment variable from the environment.
-- 
-- Note that on some systems, when variables are overwritten, the
-- memory used for the previous variables and its value isn\'t reclaimed.
-- 
-- You should be mindful of the fact that environment variable handling
-- in UNIX is not thread-safe, and your program may crash if one thread
-- calls 'GI.GLib.Functions.unsetenv' while another thread is calling @/getenv()/@. (And note
-- that many functions, such as @/gettext()/@, call @/getenv()/@ internally.) This
-- function is only safe to use at the very start of your program, before
-- creating any other threads (or creating objects that create worker
-- threads of their own).
-- 
-- If you need to set up the environment for a child process, you can
-- use 'GI.GLib.Functions.getEnviron' to get an environment array, modify that with
-- 'GI.GLib.Functions.environSetenv' and 'GI.GLib.Functions.environUnsetenv', and then pass that
-- array directly to @/execvpe()/@, 'GI.GLib.Functions.spawnAsync', or the like.
-- 
-- /Since: 2.4/
unsetenv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@variable@/: the environment variable to remove, must
    --     not contain \'=\'
    -> m ()
unsetenv variable = liftIO $ do
    variable' <- stringToCString variable
    g_unsetenv variable'
    freeMem variable'
    return ()


-- function unlink
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unlink" g_unlink :: 
    CString ->                              -- filename : TBasicType TFileName
    IO Int32

-- | A wrapper for the POSIX @/unlink()/@ function. The @/unlink()/@ function
-- deletes a name from the filesystem. If this was the last link to the
-- file and no processes have it opened, the diskspace occupied by the
-- file is freed.
-- 
-- See your C library manual for more details about @/unlink()/@. Note
-- that on Windows, it is in general not possible to delete files that
-- are open to some process, or mapped into memory.
-- 
-- /Since: 2.6/
unlink ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> m Int32
    -- ^ __Returns:__ 0 if the name was successfully deleted, -1 if an error
    --    occurred
unlink filename = liftIO $ do
    filename' <- stringToCString filename
    result <- g_unlink filename'
    freeMem filename'
    return result


-- function unix_signal_source_new
-- Args: [ Arg
--           { argCName = "signum"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A signal number" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_signal_source_new" g_unix_signal_source_new :: 
    Int32 ->                                -- signum : TBasicType TInt
    IO (Ptr GLib.Source.Source)

-- | Create a t'GI.GLib.Structs.Source.Source' that will be dispatched upon delivery of the UNIX
-- signal /@signum@/.  In GLib versions before 2.36, only @SIGHUP@, @SIGINT@,
-- @SIGTERM@ can be monitored.  In GLib 2.36, @SIGUSR1@ and @SIGUSR2@
-- were added. In GLib 2.54, @SIGWINCH@ was added.
-- 
-- Note that unlike the UNIX default, all sources which have created a
-- watch will be dispatched, regardless of which underlying thread
-- invoked 'GI.GLib.Functions.unixSignalSourceNew'.
-- 
-- For example, an effective use of this function is to handle @SIGTERM@
-- cleanly; flushing any outstanding files, and then calling
-- 'GI.GLib.Structs.MainLoop.mainLoopQuit'.  It is not safe to do any of this from a regular
-- UNIX signal handler; such a handler may be invoked while @/malloc()/@ or
-- another library function is running, causing reentrancy issues if the
-- handler attempts to use those functions.  None of the GLib\/GObject
-- API is safe against this kind of reentrancy.
-- 
-- The interaction of this source when combined with native UNIX
-- functions like @/sigprocmask()/@ is not defined.
-- 
-- The source will not initially be associated with any t'GI.GLib.Structs.MainContext.MainContext'
-- and must be added to one with 'GI.GLib.Structs.Source.sourceAttach' before it will be
-- executed.
-- 
-- /Since: 2.30/
unixSignalSourceNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@signum@/: A signal number
    -> m GLib.Source.Source
    -- ^ __Returns:__ A newly created t'GI.GLib.Structs.Source.Source'
unixSignalSourceNew signum = liftIO $ do
    result <- g_unix_signal_source_new signum
    checkUnexpectedReturnNULL "unixSignalSourceNew" result
    result' <- (wrapBoxed GLib.Source.Source) result
    return result'


-- function unix_signal_add
-- Args: [ Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the signal source. Typically this will be in\n           the range between %G_PRIORITY_DEFAULT and %G_PRIORITY_HIGH."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signum"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Signal number" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Callback" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Data for @handler" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GDestroyNotify for @handler"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_signal_add_full" g_unix_signal_add_full :: 
    Int32 ->                                -- priority : TBasicType TInt
    Int32 ->                                -- signum : TBasicType TInt
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- handler : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | A convenience function for 'GI.GLib.Functions.unixSignalSourceNew', which
-- attaches to the default t'GI.GLib.Structs.MainContext.MainContext'.  You can remove the watch
-- using 'GI.GLib.Functions.sourceRemove'.
-- 
-- /Since: 2.30/
unixSignalAdd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@priority@/: the priority of the signal source. Typically this will be in
    --            the range between 'GI.GLib.Constants.PRIORITY_DEFAULT' and 'GI.GLib.Constants.PRIORITY_HIGH'.
    -> Int32
    -- ^ /@signum@/: Signal number
    -> GLib.Callbacks.SourceFunc
    -- ^ /@handler@/: Callback
    -> m Word32
    -- ^ __Returns:__ An ID (greater than 0) for the event source
unixSignalAdd priority signum handler = liftIO $ do
    handler' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc handler))
    let userData = castFunPtrToPtr handler'
    let notify = SP.safeFreeFunPtrPtr
    result <- g_unix_signal_add_full priority signum handler' userData notify
    return result


-- function unix_set_fd_nonblocking
-- Args: [ Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A file descriptor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nonblock"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "If %TRUE, set the descriptor to be non-blocking"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_set_fd_nonblocking" g_unix_set_fd_nonblocking :: 
    Int32 ->                                -- fd : TBasicType TInt
    CInt ->                                 -- nonblock : TBasicType TBoolean
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Control the non-blocking state of the given file descriptor,
-- according to /@nonblock@/. On most systems this uses @/O_NONBLOCK/@, but
-- on some older ones may use @/O_NDELAY/@.
-- 
-- /Since: 2.30/
unixSetFdNonblocking ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@fd@/: A file descriptor
    -> Bool
    -- ^ /@nonblock@/: If 'P.True', set the descriptor to be non-blocking
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
unixSetFdNonblocking fd nonblock = liftIO $ do
    let nonblock' = (P.fromIntegral . P.fromEnum) nonblock
    onException (do
        _ <- propagateGError $ g_unix_set_fd_nonblocking fd nonblock'
        return ()
     ) (do
        return ()
     )


-- function unix_open_pipe
-- Args: [ Arg
--           { argCName = "fds"
--           , argType = TCArray False 2 (-1) (TBasicType TInt)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Array of two integers"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Bitfield of file descriptor flags, as for fcntl()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_open_pipe" g_unix_open_pipe :: 
    Ptr Int32 ->                            -- fds : TCArray False 2 (-1) (TBasicType TInt)
    Int32 ->                                -- flags : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Similar to the UNIX @/pipe()/@ call, but on modern systems like Linux
-- uses the @/pipe2()/@ system call, which atomically creates a pipe with
-- the configured flags.
-- 
-- As of GLib 2.78, the supported flags are @O_CLOEXEC@\/@FD_CLOEXEC@ (see below)
-- and @O_NONBLOCK@. Prior to GLib 2.78, only @FD_CLOEXEC@ was supported — if
-- you wanted to configure @O_NONBLOCK@ then that had to be done separately with
-- @fcntl()@.
-- 
-- Since GLib 2.80, the constants 'GI.GLib.Enums.UnixPipeEndRead' and
-- 'GI.GLib.Enums.UnixPipeEndWrite' can be used as mnemonic indexes in /@fds@/.
-- 
-- It is a programmer error to call this function with unsupported flags, and a
-- critical warning will be raised.
-- 
-- As of GLib 2.78, it is preferred to pass @O_CLOEXEC@ in, rather than
-- @FD_CLOEXEC@, as that matches the underlying @pipe()@ API more closely. Prior
-- to 2.78, only @FD_CLOEXEC@ was supported. Support for @FD_CLOEXEC@ may be
-- deprecated and removed in future.
-- 
-- /Since: 2.30/
unixOpenPipe ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Int32]
    -- ^ /@fds@/: Array of two integers
    -> Int32
    -- ^ /@flags@/: Bitfield of file descriptor flags, as for @/fcntl()/@
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
unixOpenPipe fds flags = liftIO $ do
    fds' <- packStorableArray fds
    onException (do
        _ <- propagateGError $ g_unix_open_pipe fds' flags
        freeMem fds'
        return ()
     ) (do
        freeMem fds'
     )


-- function unix_get_passwd_entry
-- Args: [ Arg
--           { argCName = "user_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the username to get the passwd file entry for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_get_passwd_entry" g_unix_get_passwd_entry :: 
    CString ->                              -- user_name : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr ())

-- | Get the @passwd@ file entry for the given /@userName@/ using @getpwnam_r()@.
-- This can fail if the given /@userName@/ doesn’t exist.
-- 
-- The returned @struct passwd@ has been allocated using 'GI.GLib.Functions.malloc' and should
-- be freed using 'GI.GLib.Functions.free'. The strings referenced by the returned struct are
-- included in the same allocation, so are valid until the @struct passwd@ is
-- freed.
-- 
-- This function is safe to call from multiple threads concurrently.
-- 
-- You will need to include @pwd.h@ to get the definition of @struct passwd@.
-- 
-- /Since: 2.64/
unixGetPasswdEntry ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@userName@/: the username to get the passwd file entry for
    -> m (Ptr ())
    -- ^ __Returns:__ passwd entry, or 'P.Nothing' on error; free the returned
    --    value with 'GI.GLib.Functions.free' /(Can throw 'Data.GI.Base.GError.GError')/
unixGetPasswdEntry userName = liftIO $ do
    userName' <- textToCString userName
    onException (do
        result <- propagateGError $ g_unix_get_passwd_entry userName'
        freeMem userName'
        return result
     ) (do
        freeMem userName'
     )


-- function unix_fd_source_new
-- Args: [ Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file descriptor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "I/O conditions to watch for on @fd"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_fd_source_new" g_unix_fd_source_new :: 
    Int32 ->                                -- fd : TBasicType TInt
    CUInt ->                                -- condition : TInterface (Name {namespace = "GLib", name = "IOCondition"})
    IO (Ptr GLib.Source.Source)

-- | Creates a t'GI.GLib.Structs.Source.Source' to watch for a particular I\/O condition on a file
-- descriptor.
-- 
-- The source will never close the /@fd@/ — you must do it yourself.
-- 
-- Any callback attached to the returned t'GI.GLib.Structs.Source.Source' must have type
-- t'GI.GLib.Callbacks.UnixFDSourceFunc'.
-- 
-- /Since: 2.36/
unixFdSourceNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@fd@/: a file descriptor
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: I\/O conditions to watch for on /@fd@/
    -> m GLib.Source.Source
    -- ^ __Returns:__ the newly created t'GI.GLib.Structs.Source.Source'
unixFdSourceNew fd condition = liftIO $ do
    let condition' = gflagsToWord condition
    result <- g_unix_fd_source_new fd condition'
    checkUnexpectedReturnNULL "unixFdSourceNew" result
    result' <- (wrapBoxed GLib.Source.Source) result
    return result'


-- function unix_fd_add_full
-- Args: [ Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the priority of the source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file descriptor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "IO conditions to watch for on @fd"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "function"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "UnixFDSourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixFDSourceFunc"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 4
--           , argDestroy = 5
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to call when the idle is removed, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_fd_add_full" g_unix_fd_add_full :: 
    Int32 ->                                -- priority : TBasicType TInt
    Int32 ->                                -- fd : TBasicType TInt
    CUInt ->                                -- condition : TInterface (Name {namespace = "GLib", name = "IOCondition"})
    FunPtr GLib.Callbacks.C_UnixFDSourceFunc -> -- function : TInterface (Name {namespace = "GLib", name = "UnixFDSourceFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Sets a function to be called when the IO condition, as specified by
-- /@condition@/ becomes true for /@fd@/.
-- 
-- This is the same as @/g_unix_fd_add()/@, except that it allows you to
-- specify a non-default priority and a provide a t'GI.GLib.Callbacks.DestroyNotify' for
-- /@userData@/.
-- 
-- /Since: 2.36/
unixFdAddFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@priority@/: the priority of the source
    -> Int32
    -- ^ /@fd@/: a file descriptor
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: IO conditions to watch for on /@fd@/
    -> GLib.Callbacks.UnixFDSourceFunc
    -- ^ /@function@/: a t'GI.GLib.Callbacks.UnixFDSourceFunc'
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) of the event source
unixFdAddFull priority fd condition function = liftIO $ do
    let condition' = gflagsToWord condition
    function' <- GLib.Callbacks.mk_UnixFDSourceFunc (GLib.Callbacks.wrap_UnixFDSourceFunc Nothing (GLib.Callbacks.drop_closures_UnixFDSourceFunc function))
    let userData = castFunPtrToPtr function'
    let notify = SP.safeFreeFunPtrPtr
    result <- g_unix_fd_add_full priority fd condition' function' userData notify
    return result


-- function unix_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_error_quark" g_unix_error_quark :: 
    IO Word32

-- | /No description available in the introspection data./
unixErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
unixErrorQuark  = liftIO $ do
    result <- g_unix_error_quark
    return result


-- function unicode_canonical_ordering
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TCArray False (-1) 1 (TBasicType TUniChar)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UCS-4 encoded string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum length of @string to use."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the maximum length of @string to use."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_unicode_canonical_ordering" g_unicode_canonical_ordering :: 
    Ptr CInt ->                             -- string : TCArray False (-1) 1 (TBasicType TUniChar)
    FCT.CSize ->                            -- len : TBasicType TSize
    IO ()

-- | Computes the canonical ordering of a string in-place.
-- This rearranges decomposed characters in the string
-- according to their combining classes.  See the Unicode
-- manual for more information.
unicodeCanonicalOrdering ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@string@/: a UCS-4 encoded string.
    -> m ()
unicodeCanonicalOrdering string = liftIO $ do
    let len = fromIntegral $ P.length string
    string' <- (packMapStorableArray (P.fromIntegral . SP.ord)) string
    g_unicode_canonical_ordering string' len
    freeMem string'
    return ()


-- function unicode_canonical_decomposition
-- Args: [ Arg
--           { argCName = "ch"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result_len"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store the length of the return value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUniChar)
-- throws : False
-- Skip return : False

foreign import ccall "g_unicode_canonical_decomposition" g_unicode_canonical_decomposition :: 
    CInt ->                                 -- ch : TBasicType TUniChar
    FCT.CSize ->                            -- result_len : TBasicType TSize
    IO CInt

{-# DEPRECATED unicodeCanonicalDecomposition ["(Since version 2.30)","Use the more flexible @/g_unichar_fully_decompose()/@","  instead."] #-}
-- | Computes the canonical decomposition of a Unicode character.
unicodeCanonicalDecomposition ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@ch@/: a Unicode character.
    -> FCT.CSize
    -- ^ /@resultLen@/: location to store the length of the return value.
    -> m Char
    -- ^ __Returns:__ a newly allocated string of Unicode characters.
    --   /@resultLen@/ is set to the resulting length of the string.
unicodeCanonicalDecomposition ch resultLen = liftIO $ do
    let ch' = (P.fromIntegral . SP.ord) ch
    result <- g_unicode_canonical_decomposition ch' resultLen
    let result' = (chr . fromIntegral) result
    return result'


-- function unichar_xdigit_value
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_xdigit_value" g_unichar_xdigit_value :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO Int32

-- | Determines the numeric value of a character as a hexadecimal
-- digit.
unicharXdigitValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Int32
    -- ^ __Returns:__ If /@c@/ is a hex digit (according to
    -- 'GI.GLib.Functions.unicharIsxdigit'), its numeric value. Otherwise, -1.
unicharXdigitValue c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_xdigit_value c'
    return result


-- function unichar_validate
-- Args: [ Arg
--           { argCName = "ch"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_validate" g_unichar_validate :: 
    CInt ->                                 -- ch : TBasicType TUniChar
    IO CInt

-- | Checks whether /@ch@/ is a valid Unicode character.
-- 
-- Some possible integer values of /@ch@/ will not be valid. U+0000 is considered a
-- valid character, though it’s normally a string terminator.
unicharValidate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@ch@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if /@ch@/ is a valid Unicode character
unicharValidate ch = liftIO $ do
    let ch' = (P.fromIntegral . SP.ord) ch
    result <- g_unichar_validate ch'
    let result' = (/= 0) result
    return result'


-- function unichar_type
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "UnicodeType" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_type" g_unichar_type :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CUInt

-- | Classifies a Unicode character by type.
unicharType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m GLib.Enums.UnicodeType
    -- ^ __Returns:__ the type of the character.
unicharType c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_type c'
    let result' = (toEnum . fromIntegral) result
    return result'


-- function unichar_toupper
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUniChar)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_toupper" g_unichar_toupper :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Converts a character to uppercase.
unicharToupper ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Char
    -- ^ __Returns:__ the result of converting /@c@/ to uppercase.
    --               If /@c@/ is not a lowercase or titlecase character,
    --               or has no upper case equivalent /@c@/ is returned unchanged.
unicharToupper c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_toupper c'
    let result' = (chr . fromIntegral) result
    return result'


-- function unichar_totitle
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUniChar)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_totitle" g_unichar_totitle :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Converts a character to the titlecase.
unicharTotitle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Char
    -- ^ __Returns:__ the result of converting /@c@/ to titlecase.
    --               If /@c@/ is not an uppercase or lowercase character,
    --               /@c@/ is returned unchanged.
unicharTotitle c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_totitle c'
    let result' = (chr . fromIntegral) result
    return result'


-- function unichar_tolower
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUniChar)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_tolower" g_unichar_tolower :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Converts a character to lower case.
unicharTolower ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character.
    -> m Char
    -- ^ __Returns:__ the result of converting /@c@/ to lower case.
    --               If /@c@/ is not an upperlower or titlecase character,
    --               or has no lowercase equivalent /@c@/ is returned unchanged.
unicharTolower c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_tolower c'
    let result' = (chr . fromIntegral) result
    return result'


-- function unichar_to_utf8
-- XXX Could not generate function unichar_to_utf8

-- Not implemented: Don't know how to allocate "outbuf" of type TBasicType TUTF8

-- function unichar_iszerowidth
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_iszerowidth" g_unichar_iszerowidth :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines if a given character typically takes zero width when rendered.
-- The return value is 'P.True' for all non-spacing and enclosing marks
-- (e.g., combining accents), format characters, zero-width
-- space, but not U+00AD SOFT HYPHEN.
-- 
-- A typical use of this function is with one of 'GI.GLib.Functions.unicharIswide' or
-- 'GI.GLib.Functions.unicharIswideCjk' to determine the number of cells a string occupies
-- when displayed on a grid display (terminals).  However, note that not all
-- terminals support zero-width rendering of zero-width marks.
-- 
-- /Since: 2.14/
unicharIszerowidth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the character has zero width
unicharIszerowidth c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_iszerowidth c'
    let result' = (/= 0) result
    return result'


-- function unichar_isxdigit
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isxdigit" g_unichar_isxdigit :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines if a character is a hexadecimal digit.
unicharIsxdigit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the character is a hexadecimal digit
unicharIsxdigit c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isxdigit c'
    let result' = (/= 0) result
    return result'


-- function unichar_iswide_cjk
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_iswide_cjk" g_unichar_iswide_cjk :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines if a character is typically rendered in a double-width
-- cell under legacy East Asian locales.  If a character is wide according to
-- 'GI.GLib.Functions.unicharIswide', then it is also reported wide with this function, but
-- the converse is not necessarily true. See the
-- <http://www.unicode.org/reports/tr11/ Unicode Standard Annex #11>
-- for details.
-- 
-- If a character passes the 'GI.GLib.Functions.unicharIswide' test then it will also pass
-- this test, but not the other way around.  Note that some characters may
-- pass both this test and 'GI.GLib.Functions.unicharIszerowidth'.
-- 
-- /Since: 2.12/
unicharIswideCjk ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the character is wide in legacy East Asian locales
unicharIswideCjk c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_iswide_cjk c'
    let result' = (/= 0) result
    return result'


-- function unichar_iswide
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_iswide" g_unichar_iswide :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines if a character is typically rendered in a double-width
-- cell.
unicharIswide ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the character is wide
unicharIswide c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_iswide c'
    let result' = (/= 0) result
    return result'


-- function unichar_isupper
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isupper" g_unichar_isupper :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines if a character is uppercase.
unicharIsupper ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is an uppercase character
unicharIsupper c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isupper c'
    let result' = (/= 0) result
    return result'


-- function unichar_istitle
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_istitle" g_unichar_istitle :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines if a character is titlecase. Some characters in
-- Unicode which are composites, such as the DZ digraph
-- have three case variants instead of just two. The titlecase
-- form is used at the beginning of a word where only the
-- first letter is capitalized. The titlecase form of the DZ
-- digraph is U+01F2 LATIN CAPITAL LETTTER D WITH SMALL LETTER Z.
unicharIstitle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the character is titlecase
unicharIstitle c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_istitle c'
    let result' = (/= 0) result
    return result'


-- function unichar_isspace
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isspace" g_unichar_isspace :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is a space, tab, or line separator
-- (newline, carriage return, etc.).  Given some UTF-8 text, obtain a
-- character value with 'GI.GLib.Functions.utf8GetChar'.
-- 
-- (Note: don\'t use this to do word breaking; you have to use
-- Pango or equivalent to get word breaking right, the algorithm
-- is fairly complex.)
unicharIsspace ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is a space character
unicharIsspace c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isspace c'
    let result' = (/= 0) result
    return result'


-- function unichar_ispunct
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_ispunct" g_unichar_ispunct :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is punctuation or a symbol.
-- Given some UTF-8 text, obtain a character value with
-- 'GI.GLib.Functions.utf8GetChar'.
unicharIspunct ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is a punctuation or symbol character
unicharIspunct c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_ispunct c'
    let result' = (/= 0) result
    return result'


-- function unichar_isprint
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isprint" g_unichar_isprint :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is printable.
-- Unlike 'GI.GLib.Functions.unicharIsgraph', returns 'P.True' for spaces.
-- Given some UTF-8 text, obtain a character value with
-- 'GI.GLib.Functions.utf8GetChar'.
unicharIsprint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is printable
unicharIsprint c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isprint c'
    let result' = (/= 0) result
    return result'


-- function unichar_ismark
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_ismark" g_unichar_ismark :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is a mark (non-spacing mark,
-- combining mark, or enclosing mark in Unicode speak).
-- Given some UTF-8 text, obtain a character value
-- with 'GI.GLib.Functions.utf8GetChar'.
-- 
-- Note: in most cases where isalpha characters are allowed,
-- ismark characters should be allowed to as they are essential
-- for writing most European languages as well as many non-Latin
-- scripts.
-- 
-- /Since: 2.14/
unicharIsmark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is a mark character
unicharIsmark c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_ismark c'
    let result' = (/= 0) result
    return result'


-- function unichar_islower
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_islower" g_unichar_islower :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is a lowercase letter.
-- Given some UTF-8 text, obtain a character value with
-- 'GI.GLib.Functions.utf8GetChar'.
unicharIslower ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is a lowercase letter
unicharIslower c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_islower c'
    let result' = (/= 0) result
    return result'


-- function unichar_isgraph
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isgraph" g_unichar_isgraph :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is printable and not a space
-- (returns 'P.False' for control characters, format characters, and
-- spaces). 'GI.GLib.Functions.unicharIsprint' is similar, but returns 'P.True' for
-- spaces. Given some UTF-8 text, obtain a character value with
-- 'GI.GLib.Functions.utf8GetChar'.
unicharIsgraph ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is printable unless it\'s a space
unicharIsgraph c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isgraph c'
    let result' = (/= 0) result
    return result'


-- function unichar_isdigit
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isdigit" g_unichar_isdigit :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is numeric (i.e. a digit).  This
-- covers ASCII 0-9 and also digits in other languages\/scripts.  Given
-- some UTF-8 text, obtain a character value with 'GI.GLib.Functions.utf8GetChar'.
unicharIsdigit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is a digit
unicharIsdigit c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isdigit c'
    let result' = (/= 0) result
    return result'


-- function unichar_isdefined
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isdefined" g_unichar_isdefined :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines if a given character is assigned in the Unicode
-- standard.
unicharIsdefined ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the character has an assigned value
unicharIsdefined c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isdefined c'
    let result' = (/= 0) result
    return result'


-- function unichar_iscntrl
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_iscntrl" g_unichar_iscntrl :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is a control character.
-- Given some UTF-8 text, obtain a character value with
-- 'GI.GLib.Functions.utf8GetChar'.
unicharIscntrl ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is a control character
unicharIscntrl c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_iscntrl c'
    let result' = (/= 0) result
    return result'


-- function unichar_isalpha
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isalpha" g_unichar_isalpha :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is alphabetic (i.e. a letter).
-- Given some UTF-8 text, obtain a character value with
-- 'GI.GLib.Functions.utf8GetChar'.
unicharIsalpha ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is an alphabetic character
unicharIsalpha c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isalpha c'
    let result' = (/= 0) result
    return result'


-- function unichar_isalnum
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_isalnum" g_unichar_isalnum :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CInt

-- | Determines whether a character is alphanumeric.
-- Given some UTF-8 text, obtain a character value
-- with 'GI.GLib.Functions.utf8GetChar'.
unicharIsalnum ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@c@/ is an alphanumeric character
unicharIsalnum c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_isalnum c'
    let result' = (/= 0) result
    return result'


-- function unichar_get_script
-- Args: [ Arg
--           { argCName = "ch"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "UnicodeScript" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_get_script" g_unichar_get_script :: 
    CInt ->                                 -- ch : TBasicType TUniChar
    IO CInt

-- | Looks up the t'GI.GLib.Enums.UnicodeScript' for a particular character (as defined
-- by Unicode Standard Annex #24). No check is made for /@ch@/ being a
-- valid Unicode character; if you pass in invalid character, the
-- result is undefined.
-- 
-- This function is equivalent to @/pango_script_for_unichar()/@ and the
-- two are interchangeable.
-- 
-- /Since: 2.14/
unicharGetScript ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@ch@/: a Unicode character
    -> m GLib.Enums.UnicodeScript
    -- ^ __Returns:__ the t'GI.GLib.Enums.UnicodeScript' for the character.
unicharGetScript ch = liftIO $ do
    let ch' = (P.fromIntegral . SP.ord) ch
    result <- g_unichar_get_script ch'
    let result' = (toEnum . fromIntegral) result
    return result'


-- function unichar_get_mirror_char
-- Args: [ Arg
--           { argCName = "ch"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mirrored_ch"
--           , argType = TBasicType TUniChar
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the mirrored character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_get_mirror_char" g_unichar_get_mirror_char :: 
    CInt ->                                 -- ch : TBasicType TUniChar
    Ptr CInt ->                             -- mirrored_ch : TBasicType TUniChar
    IO CInt

-- | In Unicode, some characters are \"mirrored\". This means that their
-- images are mirrored horizontally in text that is laid out from right
-- to left. For instance, \"(\" would become its mirror image, \")\", in
-- right-to-left text.
-- 
-- If /@ch@/ has the Unicode mirrored property and there is another unicode
-- character that typically has a glyph that is the mirror image of /@ch@/\'s
-- glyph and /@mirroredCh@/ is set, it puts that character in the address
-- pointed to by /@mirroredCh@/.  Otherwise the original character is put.
-- 
-- /Since: 2.4/
unicharGetMirrorChar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@ch@/: a Unicode character
    -> m ((Bool, Char))
    -- ^ __Returns:__ 'P.True' if /@ch@/ has a mirrored character, 'P.False' otherwise
unicharGetMirrorChar ch = liftIO $ do
    let ch' = (P.fromIntegral . SP.ord) ch
    mirroredCh <- allocMem :: IO (Ptr CInt)
    result <- g_unichar_get_mirror_char ch' mirroredCh
    let result' = (/= 0) result
    mirroredCh' <- peek mirroredCh
    let mirroredCh'' = (chr . fromIntegral) mirroredCh'
    freeMem mirroredCh
    return (result', mirroredCh'')


-- function unichar_digit_value
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_digit_value" g_unichar_digit_value :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO Int32

-- | Determines the numeric value of a character as a decimal
-- digit.
unicharDigitValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m Int32
    -- ^ __Returns:__ If /@c@/ is a decimal digit (according to
    -- 'GI.GLib.Functions.unicharIsdigit'), its numeric value. Otherwise, -1.
unicharDigitValue c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_digit_value c'
    return result


-- function unichar_decompose
-- Args: [ Arg
--           { argCName = "ch"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "a"
--           , argType = TBasicType TUniChar
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the first component of @ch"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TUniChar
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the second component of @ch"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_decompose" g_unichar_decompose :: 
    CInt ->                                 -- ch : TBasicType TUniChar
    Ptr CInt ->                             -- a : TBasicType TUniChar
    Ptr CInt ->                             -- b : TBasicType TUniChar
    IO CInt

-- | Performs a single decomposition step of the
-- Unicode canonical decomposition algorithm.
-- 
-- This function does not include compatibility
-- decompositions. It does, however, include algorithmic
-- Hangul Jamo decomposition, as well as \'singleton\'
-- decompositions which replace a character by a single
-- other character. In the case of singletons @*b@ will
-- be set to zero.
-- 
-- If /@ch@/ is not decomposable, @*a@ is set to /@ch@/ and @*b@
-- is set to zero.
-- 
-- Note that the way Unicode decomposition pairs are
-- defined, it is guaranteed that /@b@/ would not decompose
-- further, but /@a@/ may itself decompose.  To get the full
-- canonical decomposition for /@ch@/, one would need to
-- recursively call this function on /@a@/.  Or use
-- @/g_unichar_fully_decompose()/@.
-- 
-- See
-- <http://unicode.org/reports/tr15/ UAX#15>
-- for details.
-- 
-- /Since: 2.30/
unicharDecompose ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@ch@/: a Unicode character
    -> m ((Bool, Char, Char))
    -- ^ __Returns:__ 'P.True' if the character could be decomposed
unicharDecompose ch = liftIO $ do
    let ch' = (P.fromIntegral . SP.ord) ch
    a <- allocMem :: IO (Ptr CInt)
    b <- allocMem :: IO (Ptr CInt)
    result <- g_unichar_decompose ch' a b
    let result' = (/= 0) result
    a' <- peek a
    let a'' = (chr . fromIntegral) a'
    b' <- peek b
    let b'' = (chr . fromIntegral) b'
    freeMem a
    freeMem b
    return (result', a'', b'')


-- function unichar_compose
-- Args: [ Arg
--           { argCName = "a"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ch"
--           , argType = TBasicType TUniChar
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the composed character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_compose" g_unichar_compose :: 
    CInt ->                                 -- a : TBasicType TUniChar
    CInt ->                                 -- b : TBasicType TUniChar
    Ptr CInt ->                             -- ch : TBasicType TUniChar
    IO CInt

-- | Performs a single composition step of the
-- Unicode canonical composition algorithm.
-- 
-- This function includes algorithmic Hangul Jamo composition,
-- but it is not exactly the inverse of 'GI.GLib.Functions.unicharDecompose'.
-- No composition can have either of /@a@/ or /@b@/ equal to zero.
-- To be precise, this function composes if and only if
-- there exists a Primary Composite P which is canonically
-- equivalent to the sequence \</@a@/,/@b@/>.  See the Unicode
-- Standard for the definition of Primary Composite.
-- 
-- If /@a@/ and /@b@/ do not compose a new character, /@ch@/ is set to zero.
-- 
-- See
-- <http://unicode.org/reports/tr15/ UAX#15>
-- for details.
-- 
-- /Since: 2.30/
unicharCompose ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@a@/: a Unicode character
    -> Char
    -- ^ /@b@/: a Unicode character
    -> m ((Bool, Char))
    -- ^ __Returns:__ 'P.True' if the characters could be composed
unicharCompose a b = liftIO $ do
    let a' = (P.fromIntegral . SP.ord) a
    let b' = (P.fromIntegral . SP.ord) b
    ch <- allocMem :: IO (Ptr CInt)
    result <- g_unichar_compose a' b' ch
    let result' = (/= 0) result
    ch' <- peek ch
    let ch'' = (chr . fromIntegral) ch'
    freeMem ch
    return (result', ch'')


-- function unichar_combining_class
-- Args: [ Arg
--           { argCName = "uc"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_combining_class" g_unichar_combining_class :: 
    CInt ->                                 -- uc : TBasicType TUniChar
    IO Int32

-- | Determines the canonical combining class of a Unicode character.
-- 
-- /Since: 2.14/
unicharCombiningClass ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@uc@/: a Unicode character
    -> m Int32
    -- ^ __Returns:__ the combining class of the character
unicharCombiningClass uc = liftIO $ do
    let uc' = (P.fromIntegral . SP.ord) uc
    result <- g_unichar_combining_class uc'
    return result


-- function unichar_break_type
-- Args: [ Arg
--           { argCName = "c"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Unicode character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GLib" , name = "UnicodeBreakType" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unichar_break_type" g_unichar_break_type :: 
    CInt ->                                 -- c : TBasicType TUniChar
    IO CUInt

-- | Determines the break type of /@c@/. /@c@/ should be a Unicode character
-- (to derive a character from UTF-8 encoded text, use
-- 'GI.GLib.Functions.utf8GetChar'). The break type is used to find word and line
-- breaks (\"text boundaries\"), Pango implements the Unicode boundary
-- resolution algorithms and normally you would use a function such
-- as @/pango_break()/@ instead of caring about break types yourself.
unicharBreakType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Char
    -- ^ /@c@/: a Unicode character
    -> m GLib.Enums.UnicodeBreakType
    -- ^ __Returns:__ the break type of /@c@/
unicharBreakType c = liftIO $ do
    let c' = (P.fromIntegral . SP.ord) c
    result <- g_unichar_break_type c'
    let result' = (toEnum . fromIntegral) result
    return result'


-- function ucs4_to_utf8
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TCArray False (-1) 1 (TBasicType TUniChar)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UCS-4 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length (number of characters) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "items_read"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store number of\n  characters read, or `NULL`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "items_written"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number\n  of bytes written or `NULL`. The value here stored does not include the\n  trailing nul byte."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TLong
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "the maximum length (number of characters) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUTF8)
-- throws : True
-- Skip return : False

foreign import ccall "g_ucs4_to_utf8" g_ucs4_to_utf8 :: 
    Ptr CInt ->                             -- str : TCArray False (-1) 1 (TBasicType TUniChar)
    FCT.CLong ->                            -- len : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_read : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_written : TBasicType TLong
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Convert a string from a 32-bit fixed width representation as UCS-4.
-- to UTF-8.
-- 
-- The result will be terminated with a nul byte.
ucs4ToUtf8 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@str@/: a UCS-4 encoded string
    -> m ((T.Text, FCT.CLong, FCT.CLong))
    -- ^ __Returns:__ a pointer to a newly allocated UTF-8 string.
    --   This value must be freed with 'GI.GLib.Functions.free'. If an error occurs,
    --   /@itemsRead@/ will be set to the position of the first invalid input
    --   character. /(Can throw 'Data.GI.Base.GError.GError')/
ucs4ToUtf8 str = liftIO $ do
    let len = fromIntegral $ P.length str
    str' <- (packMapStorableArray (P.fromIntegral . SP.ord)) str
    itemsRead <- allocMem :: IO (Ptr FCT.CLong)
    itemsWritten <- allocMem :: IO (Ptr FCT.CLong)
    onException (do
        result <- propagateGError $ g_ucs4_to_utf8 str' len itemsRead itemsWritten
        checkUnexpectedReturnNULL "ucs4ToUtf8" result
        result' <- cstringToText result
        freeMem result
        itemsRead' <- peek itemsRead
        itemsWritten' <- peek itemsWritten
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
        return (result', itemsRead', itemsWritten')
     ) (do
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
     )


-- function ucs4_to_utf16
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TCArray False (-1) 1 (TBasicType TUniChar)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UCS-4 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length (number of characters) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "items_read"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number of\n  bytes read, or `NULL`. If an error occurs then the index of the invalid\n  input is stored here."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "items_written"
--           , argType = TBasicType TLong
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store number\n  of `gunichar2` written, or `NULL`. The value stored here does not include\n  the trailing nul."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TLong
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "the maximum length (number of characters) of @str to use.\n  If @len is negative, then the string is nul-terminated."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUInt16)
-- throws : True
-- Skip return : False

foreign import ccall "g_ucs4_to_utf16" g_ucs4_to_utf16 :: 
    Ptr CInt ->                             -- str : TCArray False (-1) 1 (TBasicType TUniChar)
    FCT.CLong ->                            -- len : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_read : TBasicType TLong
    Ptr FCT.CLong ->                        -- items_written : TBasicType TLong
    Ptr (Ptr GError) ->                     -- error
    IO Word16

-- | Convert a string from UCS-4 to UTF-16.
-- 
-- A nul character (U+0000) will be added to the result after the converted text.
ucs4ToUtf16 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@str@/: a UCS-4 encoded string
    -> m ((Word16, FCT.CLong, FCT.CLong))
    -- ^ __Returns:__ a pointer to a newly allocated UTF-16 string.
    --   This value must be freed with 'GI.GLib.Functions.free'. /(Can throw 'Data.GI.Base.GError.GError')/
ucs4ToUtf16 str = liftIO $ do
    let len = fromIntegral $ P.length str
    str' <- (packMapStorableArray (P.fromIntegral . SP.ord)) str
    itemsRead <- allocMem :: IO (Ptr FCT.CLong)
    itemsWritten <- allocMem :: IO (Ptr FCT.CLong)
    onException (do
        result <- propagateGError $ g_ucs4_to_utf16 str' len itemsRead itemsWritten
        itemsRead' <- peek itemsRead
        itemsWritten' <- peek itemsWritten
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
        return (result, itemsRead', itemsWritten')
     ) (do
        freeMem str'
        freeMem itemsRead
        freeMem itemsWritten
     )


-- function try_realloc_n
-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "previously-allocated memory, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_blocks"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of blocks to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_block_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of each block in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_try_realloc_n" g_try_realloc_n :: 
    Ptr () ->                               -- mem : TBasicType TPtr
    FCT.CSize ->                            -- n_blocks : TBasicType TSize
    FCT.CSize ->                            -- n_block_bytes : TBasicType TSize
    IO (Ptr ())

-- | This function is similar to 'GI.GLib.Functions.tryRealloc', allocating (/@nBlocks@/ * /@nBlockBytes@/) bytes,
-- but care is taken to detect possible overflow during multiplication.
-- 
-- /Since: 2.24/
tryReallocN ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@mem@/: previously-allocated memory, or 'P.Nothing'.
    -> FCT.CSize
    -- ^ /@nBlocks@/: the number of blocks to allocate
    -> FCT.CSize
    -- ^ /@nBlockBytes@/: the size of each block in bytes
    -> m (Ptr ())
    -- ^ __Returns:__ the allocated memory, or 'P.Nothing'.
tryReallocN mem nBlocks nBlockBytes = liftIO $ do
    result <- g_try_realloc_n mem nBlocks nBlockBytes
    return result


-- function try_realloc
-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "previously-allocated memory, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of bytes to allocate."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_try_realloc" g_try_realloc :: 
    Ptr () ->                               -- mem : TBasicType TPtr
    FCT.CSize ->                            -- n_bytes : TBasicType TSize
    IO (Ptr ())

-- | Attempts to realloc /@mem@/ to a new size, /@nBytes@/, and returns 'P.Nothing'
-- on failure. Contrast with 'GI.GLib.Functions.realloc', which aborts the program
-- on failure.
-- 
-- If /@mem@/ is 'P.Nothing', behaves the same as 'GI.GLib.Functions.tryMalloc'.
tryRealloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@mem@/: previously-allocated memory, or 'P.Nothing'.
    -> FCT.CSize
    -- ^ /@nBytes@/: number of bytes to allocate.
    -> m (Ptr ())
    -- ^ __Returns:__ the allocated memory, or 'P.Nothing'.
tryRealloc mem nBytes = liftIO $ do
    result <- g_try_realloc mem nBytes
    return result


-- function try_malloc_n
-- Args: [ Arg
--           { argCName = "n_blocks"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of blocks to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_block_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of each block in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_try_malloc_n" g_try_malloc_n :: 
    FCT.CSize ->                            -- n_blocks : TBasicType TSize
    FCT.CSize ->                            -- n_block_bytes : TBasicType TSize
    IO (Ptr ())

-- | This function is similar to 'GI.GLib.Functions.tryMalloc', allocating (/@nBlocks@/ * /@nBlockBytes@/) bytes,
-- but care is taken to detect possible overflow during multiplication.
-- 
-- /Since: 2.24/
tryMallocN ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@nBlocks@/: the number of blocks to allocate
    -> FCT.CSize
    -- ^ /@nBlockBytes@/: the size of each block in bytes
    -> m (Ptr ())
    -- ^ __Returns:__ the allocated memory, or 'P.Nothing'.
tryMallocN nBlocks nBlockBytes = liftIO $ do
    result <- g_try_malloc_n nBlocks nBlockBytes
    return result


-- function try_malloc0_n
-- Args: [ Arg
--           { argCName = "n_blocks"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of blocks to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_block_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of each block in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_try_malloc0_n" g_try_malloc0_n :: 
    FCT.CSize ->                            -- n_blocks : TBasicType TSize
    FCT.CSize ->                            -- n_block_bytes : TBasicType TSize
    IO (Ptr ())

-- | This function is similar to 'GI.GLib.Functions.tryMalloc0', allocating (/@nBlocks@/ * /@nBlockBytes@/) bytes,
-- but care is taken to detect possible overflow during multiplication.
-- 
-- /Since: 2.24/
tryMalloc0N ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@nBlocks@/: the number of blocks to allocate
    -> FCT.CSize
    -- ^ /@nBlockBytes@/: the size of each block in bytes
    -> m (Ptr ())
    -- ^ __Returns:__ the allocated memory, or 'P.Nothing'
tryMalloc0N nBlocks nBlockBytes = liftIO $ do
    result <- g_try_malloc0_n nBlocks nBlockBytes
    return result


-- function try_malloc0
-- Args: [ Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of bytes to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_try_malloc0" g_try_malloc0 :: 
    FCT.CSize ->                            -- n_bytes : TBasicType TSize
    IO (Ptr ())

-- | Attempts to allocate /@nBytes@/, initialized to 0\'s, and returns 'P.Nothing' on
-- failure. Contrast with 'GI.GLib.Functions.malloc0', which aborts the program on failure.
-- 
-- /Since: 2.8/
tryMalloc0 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@nBytes@/: number of bytes to allocate
    -> m (Ptr ())
    -- ^ __Returns:__ the allocated memory, or 'P.Nothing'
tryMalloc0 nBytes = liftIO $ do
    result <- g_try_malloc0 nBytes
    return result


-- function try_malloc
-- Args: [ Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of bytes to allocate."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_try_malloc" g_try_malloc :: 
    FCT.CSize ->                            -- n_bytes : TBasicType TSize
    IO (Ptr ())

-- | Attempts to allocate /@nBytes@/, and returns 'P.Nothing' on failure.
-- Contrast with 'GI.GLib.Functions.malloc', which aborts the program on failure.
tryMalloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@nBytes@/: number of bytes to allocate.
    -> m (Ptr ())
    -- ^ __Returns:__ the allocated memory, or 'P.Nothing'.
tryMalloc nBytes = liftIO $ do
    result <- g_try_malloc nBytes
    return result


-- function timeout_source_new_seconds
-- Args: [ Arg
--           { argCName = "interval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timeout interval in seconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_timeout_source_new_seconds" g_timeout_source_new_seconds :: 
    Word32 ->                               -- interval : TBasicType TUInt
    IO (Ptr GLib.Source.Source)

-- | Creates a new timeout source.
-- 
-- The source will not initially be associated with any
-- t'GI.GLib.Structs.MainContext.MainContext' and must be added to one with
-- 'GI.GLib.Structs.Source.sourceAttach' before it will be executed.
-- 
-- The scheduling granularity\/accuracy of this timeout source will be
-- in seconds.
-- 
-- The interval given is in terms of monotonic time, not wall clock time.
-- See 'GI.GLib.Functions.getMonotonicTime'.
-- 
-- /Since: 2.14/
timeoutSourceNewSeconds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@interval@/: the timeout interval in seconds
    -> m GLib.Source.Source
    -- ^ __Returns:__ the newly-created timeout source
timeoutSourceNewSeconds interval = liftIO $ do
    result <- g_timeout_source_new_seconds interval
    checkUnexpectedReturnNULL "timeoutSourceNewSeconds" result
    result' <- (wrapBoxed GLib.Source.Source) result
    return result'


-- function timeout_source_new
-- Args: [ Arg
--           { argCName = "interval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timeout interval in milliseconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_timeout_source_new" g_timeout_source_new :: 
    Word32 ->                               -- interval : TBasicType TUInt
    IO (Ptr GLib.Source.Source)

-- | Creates a new timeout source.
-- 
-- The source will not initially be associated with any t'GI.GLib.Structs.MainContext.MainContext'
-- and must be added to one with 'GI.GLib.Structs.Source.sourceAttach' before it will be
-- executed.
-- 
-- The interval given is in terms of monotonic time, not wall clock
-- time.  See 'GI.GLib.Functions.getMonotonicTime'.
timeoutSourceNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@interval@/: the timeout interval in milliseconds
    -> m GLib.Source.Source
    -- ^ __Returns:__ the newly-created timeout source
timeoutSourceNew interval = liftIO $ do
    result <- g_timeout_source_new interval
    checkUnexpectedReturnNULL "timeoutSourceNew" result
    result' <- (wrapBoxed GLib.Source.Source) result
    return result'


-- function timeout_add_seconds
-- Args: [ Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the timeout source; typically this will be in\n  the range between [const@GLib.PRIORITY_DEFAULT] and\n  [const@GLib.PRIORITY_HIGH]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the time between calls to the function, in seconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "function"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call when the timeout is removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_timeout_add_seconds_full" g_timeout_add_seconds_full :: 
    Int32 ->                                -- priority : TBasicType TInt
    Word32 ->                               -- interval : TBasicType TUInt
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- function : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Sets a function to be called at regular intervals, with /@priority@/.
-- 
-- The function is called repeatedly until it returns [const/@gLib@/.SOURCE_REMOVE],
-- at which point the timeout is automatically destroyed and
-- the function will not be called again.
-- 
-- Unlike 'GI.GLib.Functions.timeoutAdd', this function operates at whole second
-- granularity. The initial starting point of the timer is determined by the
-- implementation and the implementation is expected to group multiple timers
-- together so that they fire all at the same time. To allow this grouping,
-- the /@interval@/ to the first timer is rounded and can deviate up to one second
-- from the specified interval. Subsequent timer iterations will generally run
-- at the specified interval.
-- 
-- Note that timeout functions may be delayed, due to the processing of other
-- event sources. Thus they should not be relied on for precise timing.
-- After each call to the timeout function, the time of the next
-- timeout is recalculated based on the current time and the given /@interval@/
-- 
-- See <http://developer.gnome.org/glib/stable/main-loop.html#memory-management-of-sources main loop memory management> for details
-- on how to handle the return value and memory management of /@data@/.
-- 
-- If you want timing more precise than whole seconds, use
-- 'GI.GLib.Functions.timeoutAdd' instead.
-- 
-- The grouping of timers to fire at the same time results in a more power
-- and CPU efficient behavior so if your timer is in multiples of seconds
-- and you don’t require the first timer exactly one second from now, the
-- use of 'GI.GLib.Functions.timeoutAddSeconds' is preferred over
-- 'GI.GLib.Functions.timeoutAdd'.
-- 
-- This internally creates a main loop source using
-- 'GI.GLib.Functions.timeoutSourceNewSeconds' and attaches it to the main loop
-- context using 'GI.GLib.Structs.Source.sourceAttach'. You can do these steps manually
-- if you need greater control.
-- 
-- It is safe to call this function from any thread.
-- 
-- The interval given is in terms of monotonic time, not wall clock
-- time. See 'GI.GLib.Functions.getMonotonicTime'.
-- 
-- /Since: 2.14/
timeoutAddSeconds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@priority@/: the priority of the timeout source; typically this will be in
    --   the range between [const/@gLib@/.PRIORITY_DEFAULT] and
    --   [const/@gLib@/.PRIORITY_HIGH]
    -> Word32
    -- ^ /@interval@/: the time between calls to the function, in seconds
    -> GLib.Callbacks.SourceFunc
    -- ^ /@function@/: function to call
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) of the event source
timeoutAddSeconds priority interval function = liftIO $ do
    function' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc function))
    let data_ = castFunPtrToPtr function'
    let notify = SP.safeFreeFunPtrPtr
    result <- g_timeout_add_seconds_full priority interval function' data_ notify
    return result


-- function timeout_add
-- Args: [ Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the timeout source; typically this will be in\n  the range between [const@GLib.PRIORITY_DEFAULT] and\n  [const@GLib.PRIORITY_HIGH]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the time between calls to the function, in milliseconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "function"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call when the timeout is removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_timeout_add_full" g_timeout_add_full :: 
    Int32 ->                                -- priority : TBasicType TInt
    Word32 ->                               -- interval : TBasicType TUInt
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- function : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Sets a function to be called at regular intervals, with the given
-- priority.
-- 
-- The function is called repeatedly until it returns
-- [const/@gLib@/.SOURCE_REMOVE], at which point the timeout is automatically
-- destroyed and
-- the function will not be called again.  The /@notify@/ function is
-- called when the timeout is destroyed.  The first call to the
-- function will be at the end of the first /@interval@/.
-- 
-- Note that timeout functions may be delayed, due to the processing of other
-- event sources. Thus they should not be relied on for precise timing.
-- After each call to the timeout function, the time of the next
-- timeout is recalculated based on the current time and the given interval
-- (it does not try to ‘catch up’ time lost in delays).
-- 
-- See <http://developer.gnome.org/glib/stable/main-loop.html#memory-management-of-sources main loop memory management> for details
-- on how to handle the return value and memory management of /@data@/.
-- 
-- This internally creates a main loop source using
-- 'GI.GLib.Functions.timeoutSourceNew' and attaches it to the global
-- t'GI.GLib.Structs.MainContext.MainContext' using 'GI.GLib.Structs.Source.sourceAttach', so the callback
-- will be invoked in whichever thread is running that main context. You can do
-- these steps manually if you need greater control or to use a custom main
-- context.
-- 
-- The interval given is in terms of monotonic time, not wall clock time.
-- See 'GI.GLib.Functions.getMonotonicTime'.
timeoutAdd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@priority@/: the priority of the timeout source; typically this will be in
    --   the range between [const/@gLib@/.PRIORITY_DEFAULT] and
    --   [const/@gLib@/.PRIORITY_HIGH]
    -> Word32
    -- ^ /@interval@/: the time between calls to the function, in milliseconds
    -> GLib.Callbacks.SourceFunc
    -- ^ /@function@/: function to call
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) of the event source
timeoutAdd priority interval function = liftIO $ do
    function' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc function))
    let data_ = castFunPtrToPtr function'
    let notify = SP.safeFreeFunPtrPtr
    result <- g_timeout_add_full priority interval function' data_ notify
    return result


-- function test_trap_subprocess_with_envp
-- Args: [ Arg
--           { argCName = "test_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "test to run in a subprocess"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "environment\n  to run the test in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "usec_timeout"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "timeout for the subprocess test in microseconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "test_flags"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "TestSubprocessFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags to modify subprocess behaviour"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_trap_subprocess_with_envp" g_test_trap_subprocess_with_envp :: 
    CString ->                              -- test_path : TBasicType TUTF8
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TFileName)
    Word64 ->                               -- usec_timeout : TBasicType TUInt64
    CUInt ->                                -- test_flags : TInterface (Name {namespace = "GLib", name = "TestSubprocessFlags"})
    IO ()

-- | Respawns the test program to run only /@testPath@/ in a subprocess with
-- a given environment.
-- 
-- This can be used for a test case that might not return, or that
-- might abort.
-- 
-- If /@testPath@/ is @NULL@ then the same test is re-run in a subprocess.
-- You can use 'GI.GLib.Functions.testSubprocess' to determine whether the test
-- is in a subprocess or not.
-- 
-- /@testPath@/ can also be the name of the parent test, followed by
-- \"@\/subprocess\/@\" and then a name for the specific subtest (or just
-- ending with \"@\/subprocess@\" if the test only has one child test);
-- tests with names of this form will automatically be skipped in the
-- parent process.
-- 
-- If /@envp@/ is @NULL@, the parent process’ environment will be inherited.
-- 
-- If /@usecTimeout@/ is non-0, the test subprocess is aborted and
-- considered failing if its run time exceeds it.
-- 
-- The subprocess behavior can be configured with [flags/@gLib@/.TestSubprocessFlags]
-- flags.
-- 
-- You can use methods such as @/GLib.test_trap_assert_passed/@,
-- @/GLib.test_trap_assert_failed/@, and @/GLib.test_trap_assert_stderr/@ to
-- check the results of the subprocess. (But note that
-- @/GLib.test_trap_assert_stdout/@ and @/GLib.test_trap_assert_stderr/@
-- cannot be used if /@testFlags@/ specifies that the child should
-- inherit the parent stdout\/stderr.)
-- 
-- If your @main ()@ needs to behave differently in the subprocess, you can
-- call 'GI.GLib.Functions.testSubprocess' (after calling @/GLib.test_init/@)
-- to see whether you are in a subprocess.
-- 
-- Internally, this function tracks the child process using
-- 'GI.GLib.Functions.childWatchSourceNew', so your process must not ignore
-- @SIGCHLD@, and must not attempt to watch or wait for the child process
-- via another mechanism.
-- 
-- The following example tests that calling @my_object_new(1000000)@ will
-- abort with an error message.
-- 
-- 
-- === /c code/
-- >  static void
-- >  test_create_large_object (void)
-- >  {
-- >    if (g_test_subprocess ())
-- >      {
-- >        my_object_new (1000000);
-- >        return;
-- >      }
-- >
-- >    // Reruns this same test in a subprocess
-- >    g_test_trap_subprocess (NULL, 0, G_TEST_SUBPROCESS_DEFAULT);
-- >    g_test_trap_assert_failed ();
-- >    g_test_trap_assert_stderr ("*ERROR*too large*");
-- >  }
-- >
-- >  static void
-- >  test_different_username (void)
-- >  {
-- >    if (g_test_subprocess ())
-- >      {
-- >        // Code under test goes here
-- >        g_message ("Username is now simulated as %s", g_getenv ("USER"));
-- >        return;
-- >      }
-- >
-- >    // Reruns this same test in a subprocess
-- >    g_auto(GStrv) envp = g_get_environ ();
-- >    envp = g_environ_setenv (g_steal_pointer (&envp), "USER", "charlie", TRUE);
-- >    g_test_trap_subprocess_with_envp (NULL, envp, 0, G_TEST_SUBPROCESS_DEFAULT);
-- >    g_test_trap_assert_passed ();
-- >    g_test_trap_assert_stdout ("Username is now simulated as charlie");
-- >  }
-- >
-- >  int
-- >  main (int argc, char **argv)
-- >  {
-- >    g_test_init (&argc, &argv, NULL);
-- >
-- >    g_test_add_func ("/myobject/create-large-object",
-- >                     test_create_large_object);
-- >    g_test_add_func ("/myobject/different-username",
-- >                     test_different_username);
-- >    return g_test_run ();
-- >  }
-- 
-- 
-- /Since: 2.80/
testTrapSubprocessWithEnvp ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@testPath@/: test to run in a subprocess
    -> Maybe ([[Char]])
    -- ^ /@envp@/: environment
    --   to run the test in
    -> Word64
    -- ^ /@usecTimeout@/: timeout for the subprocess test in microseconds
    -> [GLib.Flags.TestSubprocessFlags]
    -- ^ /@testFlags@/: flags to modify subprocess behaviour
    -> m ()
testTrapSubprocessWithEnvp testPath envp usecTimeout testFlags = liftIO $ do
    maybeTestPath <- case testPath of
        Nothing -> return FP.nullPtr
        Just jTestPath -> do
            jTestPath' <- textToCString jTestPath
            return jTestPath'
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedFileNameArray jEnvp
            return jEnvp'
    let testFlags' = gflagsToWord testFlags
    g_test_trap_subprocess_with_envp maybeTestPath maybeEnvp usecTimeout testFlags'
    freeMem maybeTestPath
    mapZeroTerminatedCArray freeMem maybeEnvp
    freeMem maybeEnvp
    return ()


-- function test_trap_subprocess
-- Args: [ Arg
--           { argCName = "test_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "test to run in a subprocess"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "usec_timeout"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "timeout for the subprocess test in microseconds."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "test_flags"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "TestSubprocessFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags to modify subprocess behaviour"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_trap_subprocess" g_test_trap_subprocess :: 
    CString ->                              -- test_path : TBasicType TUTF8
    Word64 ->                               -- usec_timeout : TBasicType TUInt64
    CUInt ->                                -- test_flags : TInterface (Name {namespace = "GLib", name = "TestSubprocessFlags"})
    IO ()

-- | Respawns the test program to run only /@testPath@/ in a subprocess.
-- 
-- This is equivalent to calling 'GI.GLib.Functions.testTrapSubprocessWithEnvp'
-- with @envp@ set to @NULL@. See the documentation for that function
-- for full details.
-- 
-- /Since: 2.38/
testTrapSubprocess ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@testPath@/: test to run in a subprocess
    -> Word64
    -- ^ /@usecTimeout@/: timeout for the subprocess test in microseconds.
    -> [GLib.Flags.TestSubprocessFlags]
    -- ^ /@testFlags@/: flags to modify subprocess behaviour
    -> m ()
testTrapSubprocess testPath usecTimeout testFlags = liftIO $ do
    maybeTestPath <- case testPath of
        Nothing -> return FP.nullPtr
        Just jTestPath -> do
            jTestPath' <- textToCString jTestPath
            return jTestPath'
    let testFlags' = gflagsToWord testFlags
    g_test_trap_subprocess maybeTestPath usecTimeout testFlags'
    freeMem maybeTestPath
    return ()


-- function test_trap_reached_timeout
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_trap_reached_timeout" g_test_trap_reached_timeout :: 
    IO CInt

-- | Checks the result of the last 'GI.GLib.Functions.testTrapSubprocess' call.
-- 
-- /Since: 2.16/
testTrapReachedTimeout ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ true if the last test subprocess got killed due to a timeout
testTrapReachedTimeout  = liftIO $ do
    result <- g_test_trap_reached_timeout
    let result' = (/= 0) result
    return result'


-- function test_trap_has_passed
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_trap_has_passed" g_test_trap_has_passed :: 
    IO CInt

-- | Checks the result of the last 'GI.GLib.Functions.testTrapSubprocess' call.
-- 
-- /Since: 2.16/
testTrapHasPassed ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ true if the last test subprocess terminated successfully
testTrapHasPassed  = liftIO $ do
    result <- g_test_trap_has_passed
    let result' = (/= 0) result
    return result'


-- function test_trap_fork
-- Args: [ Arg
--           { argCName = "usec_timeout"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "timeout for the forked test in microseconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "test_trap_flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestTrapFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags to modify forking behaviour"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_trap_fork" g_test_trap_fork :: 
    Word64 ->                               -- usec_timeout : TBasicType TUInt64
    CUInt ->                                -- test_trap_flags : TInterface (Name {namespace = "GLib", name = "TestTrapFlags"})
    IO CInt

{-# DEPRECATED testTrapFork ["This function is implemented only on Unix platforms,","is not always reliable due to problems inherent in fork-without-exec","and doesn\\'t set close-on-exec flag on its file descriptors.","Use func/@gLib@/.test_trap_subprocess] instead."] #-}
-- | Forks the current test program to execute a test case that might
-- not return or that might abort.
-- 
-- If /@usecTimeout@/ is non-0, the forked test case is aborted and
-- considered failing if its run time exceeds it.
-- 
-- The forking behavior can be configured with [flags/@gLib@/.TestTrapFlags]
-- flags.
-- 
-- In the following example, the test code forks, the forked child
-- process produces some sample output and exits successfully.
-- The forking parent process then asserts successful child program
-- termination and validates child program outputs.
-- 
-- 
-- === /c code/
-- >  static void
-- >  test_fork_patterns (void)
-- >  {
-- >    if (g_test_trap_fork (0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR))
-- >      {
-- >        g_print ("some stdout text: somagic17
-- >");
-- >        g_printerr ("some stderr text: semagic43
-- >");
-- >        exit (0); // successful test run
-- >      }
-- >    g_test_trap_assert_passed ();
-- >    g_test_trap_assert_stdout ("*somagic17*");
-- >    g_test_trap_assert_stderr ("*semagic43*");
-- >  }
-- 
-- 
-- /Since: 2.16/
testTrapFork ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word64
    -- ^ /@usecTimeout@/: timeout for the forked test in microseconds
    -> [GLib.Flags.TestTrapFlags]
    -- ^ /@testTrapFlags@/: flags to modify forking behaviour
    -> m Bool
    -- ^ __Returns:__ true for the forked child and false for the executing parent process.
testTrapFork usecTimeout testTrapFlags = liftIO $ do
    let testTrapFlags' = gflagsToWord testTrapFlags
    result <- g_test_trap_fork usecTimeout testTrapFlags'
    let result' = (/= 0) result
    return result'


-- function test_trap_assertions
-- Args: [ Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "assertion_flags"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pattern"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_trap_assertions" g_test_trap_assertions :: 
    CString ->                              -- domain : TBasicType TUTF8
    CString ->                              -- file : TBasicType TUTF8
    Int32 ->                                -- line : TBasicType TInt
    CString ->                              -- func : TBasicType TUTF8
    Word64 ->                               -- assertion_flags : TBasicType TUInt64
    CString ->                              -- pattern : TBasicType TUTF8
    IO ()

-- | /No description available in the introspection data./
testTrapAssertions ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -> T.Text
    -> Int32
    -> T.Text
    -> Word64
    -> T.Text
    -> m ()
testTrapAssertions domain file line func assertionFlags pattern = liftIO $ do
    domain' <- textToCString domain
    file' <- textToCString file
    func' <- textToCString func
    pattern' <- textToCString pattern
    g_test_trap_assertions domain' file' line func' assertionFlags pattern'
    freeMem domain'
    freeMem file'
    freeMem func'
    freeMem pattern'
    return ()


-- function test_timer_start
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_timer_start" g_test_timer_start :: 
    IO ()

-- | Starts a timing test.
-- 
-- Call 'GI.GLib.Functions.testTimerElapsed' when the task is supposed
-- to be done. Call this function again to restart the timer.
-- 
-- /Since: 2.16/
testTimerStart ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
testTimerStart  = liftIO $ do
    g_test_timer_start
    return ()


-- function test_timer_last
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_timer_last" g_test_timer_last :: 
    IO CDouble

-- | Reports the last result of 'GI.GLib.Functions.testTimerElapsed'.
-- 
-- /Since: 2.16/
testTimerLast ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Double
    -- ^ __Returns:__ the last result of 'GI.GLib.Functions.testTimerElapsed'
testTimerLast  = liftIO $ do
    result <- g_test_timer_last
    let result' = realToFrac result
    return result'


-- function test_timer_elapsed
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_timer_elapsed" g_test_timer_elapsed :: 
    IO CDouble

-- | Gets the number of seconds since the last start of the timer with
-- 'GI.GLib.Functions.testTimerStart'.
-- 
-- /Since: 2.16/
testTimerElapsed ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Double
    -- ^ __Returns:__ the time since the last start of the timer in seconds
testTimerElapsed  = liftIO $ do
    result <- g_test_timer_elapsed
    let result' = realToFrac result
    return result'


-- function test_summary
-- Args: [ Arg
--           { argCName = "summary"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "summary of the test purpose"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_summary" g_test_summary :: 
    CString ->                              -- summary : TBasicType TUTF8
    IO ()

-- | Sets the summary for a test.
-- 
-- This may be included in test report output, and is useful documentation for
-- anyone reading the source code or modifying a test in future. It must be a
-- single line, and it should summarise what the test checks, and how.
-- 
-- This should be called at the top of a test function.
-- 
-- For example:
-- 
-- 
-- === /c code/
-- >static void
-- >test_array_sort (void)
-- >{
-- >  g_test_summary ("Test my_array_sort() sorts the array correctly and stably, "
-- >                  "including testing zero length and one-element arrays.");
-- >
-- >  // ...
-- >}
-- 
-- 
-- See also 'GI.GLib.Functions.testBug'.
-- 
-- /Since: 2.62/
testSummary ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@summary@/: summary of the test purpose
    -> m ()
testSummary summary = liftIO $ do
    summary' <- textToCString summary
    g_test_summary summary'
    freeMem summary'
    return ()


-- function test_subprocess
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_subprocess" g_test_subprocess :: 
    IO CInt

-- | Returns true if the test program is running under 'GI.GLib.Functions.testTrapSubprocess'.
-- 
-- /Since: 2.38/
testSubprocess ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ true if the test program is running under 'GI.GLib.Functions.testTrapSubprocess'
testSubprocess  = liftIO $ do
    result <- g_test_subprocess
    let result' = (/= 0) result
    return result'


-- function test_skip
-- Args: [ Arg
--           { argCName = "msg"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "explanation" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_skip" g_test_skip :: 
    CString ->                              -- msg : TBasicType TUTF8
    IO ()

-- | Indicates that a test was skipped.
-- 
-- Calling this function will not stop the test from running, you
-- need to return from the test function yourself. So you can
-- produce additional diagnostic messages or even continue running
-- the test.
-- 
-- If not called from inside a test, this function does nothing.
-- 
-- /Since: 2.38/
testSkip ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@msg@/: explanation
    -> m ()
testSkip msg = liftIO $ do
    maybeMsg <- case msg of
        Nothing -> return FP.nullPtr
        Just jMsg -> do
            jMsg' <- textToCString jMsg
            return jMsg'
    g_test_skip maybeMsg
    freeMem maybeMsg
    return ()


-- function test_set_nonfatal_assertions
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_set_nonfatal_assertions" g_test_set_nonfatal_assertions :: 
    IO ()

-- | Changes the behaviour of the various assertion macros.
-- 
-- The @g_assert_*()@ macros, @g_test_assert_expected_messages()@
-- and the various @g_test_trap_assert_*()@ macros are changed
-- to not abort to program.
-- 
-- Instead, they will call 'GI.GLib.Functions.testFail' and continue.
-- (This also changes the behavior of 'GI.GLib.Functions.testFail' so that
-- it will not cause the test program to abort after completing
-- the failed test.)
-- 
-- Note that the @/GLib.assert_not_reached/@ and @/GLib.assert/@
-- macros are not affected by this.
-- 
-- This function can only be called after @/GLib.test_init/@.
-- 
-- /Since: 2.38/
testSetNonfatalAssertions ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
testSetNonfatalAssertions  = liftIO $ do
    g_test_set_nonfatal_assertions
    return ()


-- function test_run_suite
-- Args: [ Arg
--           { argCName = "suite"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestSuite" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a test suite" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_run_suite" g_test_run_suite :: 
    Ptr GLib.TestSuite.TestSuite ->         -- suite : TInterface (Name {namespace = "GLib", name = "TestSuite"})
    IO Int32

-- | Executes the tests within /@suite@/ and all nested test suites.
-- 
-- The test suites to be executed are filtered according to
-- test path arguments (@-p testpath@ and @-s testpath@) as parsed by
-- @/GLib.test_init/@. See the 'GI.GLib.Functions.testRun' documentation
-- for more information on the order that tests are run in.
-- 
-- 'GI.GLib.Functions.testRunSuite' or 'GI.GLib.Functions.testRun' may only be
-- called once in a program.
-- 
-- /Since: 2.16/
testRunSuite ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.TestSuite.TestSuite
    -- ^ /@suite@/: a test suite
    -> m Int32
    -- ^ __Returns:__ 0 on success
testRunSuite suite = liftIO $ do
    suite' <- unsafeManagedPtrGetPtr suite
    result <- g_test_run_suite suite'
    touchManagedPtr suite
    return result


-- function test_run
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_run" g_test_run :: 
    IO Int32

-- | Runs all tests under the toplevel suite.
-- 
-- The toplevel suite can be retrieved with @/GLib.test_get_root/@.
-- 
-- Similar to 'GI.GLib.Functions.testRunSuite', the test cases to be run are
-- filtered according to test path arguments (@-p testpath@ and @-s testpath@)
-- as parsed by @/GLib.test_init/@. 'GI.GLib.Functions.testRunSuite' or
-- 'GI.GLib.Functions.testRun' may only be called once in a program.
-- 
-- In general, the tests and sub-suites within each suite are run in
-- the order in which they are defined. However, note that prior to
-- GLib 2.36, there was a bug in the @g_test_add_*@
-- functions which caused them to create multiple suites with the same
-- name, meaning that if you created tests \"\/foo\/simple\",
-- \"\/bar\/simple\", and \"\/foo\/using-bar\" in that order, they would get
-- run in that order (since 'GI.GLib.Functions.testRun' would run the first \"\/foo\"
-- suite, then the \"\/bar\" suite, then the second \"\/foo\" suite). As of
-- 2.36, this bug is fixed, and adding the tests in that order would
-- result in a running order of \"\/foo\/simple\", \"\/foo\/using-bar\",
-- \"\/bar\/simple\". If this new ordering is sub-optimal (because it puts
-- more-complicated tests before simpler ones, making it harder to
-- figure out exactly what has failed), you can fix it by changing the
-- test paths to group tests by suite in a way that will result in the
-- desired running order. Eg, \"\/simple\/foo\", \"\/simple\/bar\",
-- \"\/complex\/foo-using-bar\".
-- 
-- However, you should never make the actual result of a test depend
-- on the order that tests are run in. If you need to ensure that some
-- particular code runs before or after a given test case, use
-- @/GLib.test_add/@, which lets you specify setup and teardown functions.
-- 
-- If all tests are skipped or marked as incomplete (expected failures),
-- this function will return 0 if producing TAP output, or 77 (treated
-- as \"skip test\" by Automake) otherwise.
-- 
-- /Since: 2.16/
testRun ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ 0 on success, 1 on failure (assuming it returns at all),
    --   0 or 77 if all tests were skipped or marked as incomplete
testRun  = liftIO $ do
    result <- g_test_run
    return result


-- function test_rand_int_range
-- Args: [ Arg
--           { argCName = "begin"
--           , argType = TBasicType TInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the minimum value returned by this function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the smallest value not to be returned by this function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_rand_int_range" g_test_rand_int_range :: 
    Int32 ->                                -- begin : TBasicType TInt32
    Int32 ->                                -- end : TBasicType TInt32
    IO Int32

-- | Gets a reproducible random integer number out of a specified range.
-- 
-- See 'GI.GLib.Functions.testRandInt' for details on test case random numbers.
-- 
-- /Since: 2.16/
testRandIntRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@begin@/: the minimum value returned by this function
    -> Int32
    -- ^ /@end@/: the smallest value not to be returned by this function
    -> m Int32
    -- ^ __Returns:__ a number with /@begin@/ \<= number \< /@end@/
testRandIntRange begin end = liftIO $ do
    result <- g_test_rand_int_range begin end
    return result


-- function test_rand_int
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_rand_int" g_test_rand_int :: 
    IO Int32

-- | Gets a reproducible random integer number.
-- 
-- The random numbers generated by the g_test_rand_*() family of functions
-- change with every new test program start, unless the --seed option is
-- given when starting test programs.
-- 
-- For individual test cases however, the random number generator is
-- reseeded, to avoid dependencies between tests and to make --seed
-- effective for all test cases.
-- 
-- /Since: 2.16/
testRandInt ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ a random number from the seeded random number generator
testRandInt  = liftIO $ do
    result <- g_test_rand_int
    return result


-- function test_rand_double_range
-- Args: [ Arg
--           { argCName = "range_start"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the minimum value returned by this function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "range_end"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the minimum value not returned by this function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_rand_double_range" g_test_rand_double_range :: 
    CDouble ->                              -- range_start : TBasicType TDouble
    CDouble ->                              -- range_end : TBasicType TDouble
    IO CDouble

-- | Gets a reproducible random floating point number out of a specified range.
-- 
-- See 'GI.GLib.Functions.testRandInt' for details on test case random numbers.
-- 
-- /Since: 2.16/
testRandDoubleRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Double
    -- ^ /@rangeStart@/: the minimum value returned by this function
    -> Double
    -- ^ /@rangeEnd@/: the minimum value not returned by this function
    -> m Double
    -- ^ __Returns:__ a number with /@rangeStart@/ \<= number \< /@rangeEnd@/
testRandDoubleRange rangeStart rangeEnd = liftIO $ do
    let rangeStart' = realToFrac rangeStart
    let rangeEnd' = realToFrac rangeEnd
    result <- g_test_rand_double_range rangeStart' rangeEnd'
    let result' = realToFrac result
    return result'


-- function test_rand_double
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_rand_double" g_test_rand_double :: 
    IO CDouble

-- | Gets a reproducible random floating point number.
-- 
-- See 'GI.GLib.Functions.testRandInt' for details on test case random numbers.
-- 
-- /Since: 2.16/
testRandDouble ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Double
    -- ^ __Returns:__ a random number from the seeded random number generator
testRandDouble  = liftIO $ do
    result <- g_test_rand_double
    let result' = realToFrac result
    return result'


-- function test_queue_free
-- Args: [ Arg
--           { argCName = "gfree_pointer"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the pointer to be stored"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_queue_free" g_test_queue_free :: 
    Ptr () ->                               -- gfree_pointer : TBasicType TPtr
    IO ()

-- | Enqueues a pointer to be released with 'GI.GLib.Functions.free'
-- during the next teardown phase.
-- 
-- This is equivalent to calling 'GI.GLib.Functions.testQueueDestroy'
-- with a destroy callback of 'GI.GLib.Functions.free'.
-- 
-- /Since: 2.16/
testQueueFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@gfreePointer@/: the pointer to be stored
    -> m ()
testQueueFree gfreePointer = liftIO $ do
    g_test_queue_free gfreePointer
    return ()


-- function test_queue_destroy
-- Args: [ Arg
--           { argCName = "destroy_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy callback for teardown phase"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy callback data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_queue_destroy" g_test_queue_destroy :: 
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    Ptr () ->                               -- destroy_data : TBasicType TPtr
    IO ()

-- | Enqueues a callback /@destroyFunc@/ to be executed during the next test case
-- teardown phase.
-- 
-- This is most useful to auto destroy allocated test resources at the end
-- of a test run. Resources are released in reverse queue order, that means
-- enqueueing callback @A@ before callback @B@ will cause @B()@ to be called
-- before @A()@ during teardown.
-- 
-- /Since: 2.16/
testQueueDestroy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Callbacks.DestroyNotify
    -- ^ /@destroyFunc@/: destroy callback for teardown phase
    -> Ptr ()
    -- ^ /@destroyData@/: destroy callback data
    -> m ()
testQueueDestroy destroyFunc destroyData = liftIO $ do
    ptrdestroyFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
    destroyFunc' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroyFunc) destroyFunc)
    poke ptrdestroyFunc destroyFunc'
    g_test_queue_destroy destroyFunc' destroyData
    return ()


-- function test_log_type_name
-- Args: [ Arg
--           { argCName = "log_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestLogType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_log_type_name" g_test_log_type_name :: 
    CUInt ->                                -- log_type : TInterface (Name {namespace = "GLib", name = "TestLogType"})
    IO CString

-- | /No description available in the introspection data./
testLogTypeName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.TestLogType
    -> m T.Text
testLogTypeName logType = liftIO $ do
    let logType' = (fromIntegral . fromEnum) logType
    result <- g_test_log_type_name logType'
    checkUnexpectedReturnNULL "testLogTypeName" result
    result' <- cstringToText result
    return result'


-- function test_incomplete
-- Args: [ Arg
--           { argCName = "msg"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "explanation" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_incomplete" g_test_incomplete :: 
    CString ->                              -- msg : TBasicType TUTF8
    IO ()

-- | Indicates that a test failed because of some incomplete
-- functionality.
-- 
-- This function can be called multiple times from the same test.
-- 
-- Calling this function will not stop the test from running, you
-- need to return from the test function yourself. So you can
-- produce additional diagnostic messages or even continue running
-- the test.
-- 
-- If not called from inside a test, this function does nothing.
-- 
-- /Since: 2.38/
testIncomplete ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@msg@/: explanation
    -> m ()
testIncomplete msg = liftIO $ do
    maybeMsg <- case msg of
        Nothing -> return FP.nullPtr
        Just jMsg -> do
            jMsg' <- textToCString jMsg
            return jMsg'
    g_test_incomplete maybeMsg
    freeMem maybeMsg
    return ()


-- function test_get_path
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_get_path" g_test_get_path :: 
    IO CString

-- | Gets the test path for the test currently being run.
-- 
-- In essence, it will be the same string passed as the first argument
-- to e.g. @/GLib.test_add/@ when the test was added.
-- 
-- This function returns a valid string only within a test function.
-- 
-- Note that this is a test path, not a file system path.
-- 
-- /Since: 2.68/
testGetPath ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ the test path for the test currently being run
testGetPath  = liftIO $ do
    result <- g_test_get_path
    checkUnexpectedReturnNULL "testGetPath" result
    result' <- cstringToText result
    return result'


-- function test_get_dir
-- Args: [ Arg
--           { argCName = "file_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestFileType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type of file (built vs. distributed)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_get_dir" g_test_get_dir :: 
    CUInt ->                                -- file_type : TInterface (Name {namespace = "GLib", name = "TestFileType"})
    IO CString

-- | Gets the pathname of the directory containing test files of the type
-- specified by /@fileType@/.
-- 
-- This is approximately the same as calling @g_test_build_filename(\".\")@,
-- but you don\'t need to free the return value.
-- 
-- /Since: 2.38/
testGetDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.TestFileType
    -- ^ /@fileType@/: the type of file (built vs. distributed)
    -> m [Char]
    -- ^ __Returns:__ the path of the directory, owned by GLib
testGetDir fileType = liftIO $ do
    let fileType' = (fromIntegral . fromEnum) fileType
    result <- g_test_get_dir fileType'
    checkUnexpectedReturnNULL "testGetDir" result
    result' <- cstringToString result
    return result'


-- function test_failed
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_test_failed" g_test_failed :: 
    IO CInt

-- | Returns whether a test has already failed.
-- 
-- This will be the case when 'GI.GLib.Functions.testFail',
-- 'GI.GLib.Functions.testIncomplete' or 'GI.GLib.Functions.testSkip' have
-- been called, but also if an assertion has failed.
-- 
-- This can be useful to return early from a test if
-- continuing after a failed assertion might be harmful.
-- 
-- The return value of this function is only meaningful
-- if it is called from inside a test function.
-- 
-- /Since: 2.38/
testFailed ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ true if the test has failed
testFailed  = liftIO $ do
    result <- g_test_failed
    let result' = (/= 0) result
    return result'


-- function test_fail
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_fail" g_test_fail :: 
    IO ()

-- | Indicates that a test failed.
-- 
-- This function can be called multiple times from the same test.
-- You can use this function if your test failed in a recoverable way.
-- 
-- Do not use this function if the failure of a test could cause
-- other tests to malfunction.
-- 
-- Calling this function will not stop the test from running, you
-- need to return from the test function yourself. So you can
-- produce additional diagnostic messages or even continue running
-- the test.
-- 
-- If not called from inside a test, this function does nothing.
-- 
-- Note that unlike 'GI.GLib.Functions.testSkip' and 'GI.GLib.Functions.testIncomplete',
-- this function does not log a message alongside the test failure.
-- If details of the test failure are available, either log them with
-- @/GLib.test_message/@ before 'GI.GLib.Functions.testFail', or use
-- @/GLib.test_fail_printf/@ instead.
-- 
-- /Since: 2.30/
testFail ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
testFail  = liftIO $ do
    g_test_fail
    return ()


-- function test_expect_message
-- Args: [ Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the log domain of the message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the log level of the message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pattern"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a glob-style pattern (see [type@GLib.PatternSpec])"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_expect_message" g_test_expect_message :: 
    CString ->                              -- log_domain : TBasicType TUTF8
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    CString ->                              -- pattern : TBasicType TUTF8
    IO ()

-- | Indicates that a message with the given /@logDomain@/ and /@logLevel@/,
-- with text matching /@pattern@/, is expected to be logged.
-- 
-- When this message is logged, it will not be printed, and the test case will
-- not abort.
-- 
-- This API may only be used with the old logging API (@/GLib.log/@ without
-- @G_LOG_USE_STRUCTURED@ defined). It will not work with the structured logging
-- API. See <http://developer.gnome.org/glib/stable/logging.html#testing-for-messages Testing for Messages>.
-- 
-- Use @/GLib.test_assert_expected_messages/@ to assert that all
-- previously-expected messages have been seen and suppressed.
-- 
-- You can call this multiple times in a row, if multiple messages are
-- expected as a result of a single call. (The messages must appear in
-- the same order as the calls to 'GI.GLib.Functions.testExpectMessage'.)
-- 
-- For example:
-- 
-- 
-- === /c code/
-- >// g_main_context_push_thread_default() should fail if the
-- >// context is already owned by another thread.
-- >g_test_expect_message (G_LOG_DOMAIN,
-- >                       G_LOG_LEVEL_CRITICAL,
-- >                       "assertion*acquired_context*failed");
-- >g_main_context_push_thread_default (bad_context);
-- >g_test_assert_expected_messages ();
-- 
-- 
-- Note that you cannot use this to test @/GLib.error/@ messages, since
-- @/GLib.error/@ intentionally never returns even if the program doesn’t
-- abort; use 'GI.GLib.Functions.testTrapSubprocess' in this case.
-- 
-- If messages at [flags/@gLib@/.LogLevelFlags.LEVEL_DEBUG] are emitted, but not explicitly
-- expected via 'GI.GLib.Functions.testExpectMessage' then they will be ignored.
-- 
-- /Since: 2.34/
testExpectMessage ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@logDomain@/: the log domain of the message
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: the log level of the message
    -> T.Text
    -- ^ /@pattern@/: a glob-style pattern (see [type/@gLib@/.PatternSpec])
    -> m ()
testExpectMessage logDomain logLevel pattern = liftIO $ do
    maybeLogDomain <- case logDomain of
        Nothing -> return FP.nullPtr
        Just jLogDomain -> do
            jLogDomain' <- textToCString jLogDomain
            return jLogDomain'
    let logLevel' = gflagsToWord logLevel
    pattern' <- textToCString pattern
    g_test_expect_message maybeLogDomain logLevel' pattern'
    freeMem maybeLogDomain
    freeMem pattern'
    return ()


-- function test_disable_crash_reporting
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_disable_crash_reporting" g_test_disable_crash_reporting :: 
    IO ()

-- | Attempts to disable system crash reporting infrastructure.
-- 
-- This function should be called before exercising code paths that are
-- expected or intended to crash, to avoid wasting resources in system-wide
-- crash collection infrastructure such as systemd-coredump or abrt.
-- 
-- /Since: 2.78/
testDisableCrashReporting ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
testDisableCrashReporting  = liftIO $ do
    g_test_disable_crash_reporting
    return ()


-- function test_bug_base
-- Args: [ Arg
--           { argCName = "uri_pattern"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the base pattern for bug URIs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_bug_base" g_test_bug_base :: 
    CString ->                              -- uri_pattern : TBasicType TUTF8
    IO ()

-- | Specifies the base URI for bug reports.
-- 
-- The base URI is used to construct bug report messages for
-- @/GLib.test_message/@ when 'GI.GLib.Functions.testBug' is called.
-- Calling this function outside of a test case sets the
-- default base URI for all test cases. Calling it from within
-- a test case changes the base URI for the scope of the test
-- case only.
-- Bug URIs are constructed by appending a bug specific URI
-- portion to /@uriPattern@/, or by replacing the special string
-- @%s@ within /@uriPattern@/ if that is present.
-- 
-- If 'GI.GLib.Functions.testBugBase' is not called, bug URIs are formed
-- solely from the value provided by 'GI.GLib.Functions.testBug'.
-- 
-- /Since: 2.16/
testBugBase ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@uriPattern@/: the base pattern for bug URIs
    -> m ()
testBugBase uriPattern = liftIO $ do
    uriPattern' <- textToCString uriPattern
    g_test_bug_base uriPattern'
    freeMem uriPattern'
    return ()


-- function test_bug
-- Args: [ Arg
--           { argCName = "bug_uri_snippet"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Bug specific bug tracker URI or URI portion."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_bug" g_test_bug :: 
    CString ->                              -- bug_uri_snippet : TBasicType TUTF8
    IO ()

-- | Adds a message to test reports that associates a bug URI with a test case.
-- 
-- Bug URIs are constructed from a base URI set with 'GI.GLib.Functions.testBugBase'
-- and /@bugUriSnippet@/. If 'GI.GLib.Functions.testBugBase' has not been called, it is
-- assumed to be the empty string, so a full URI can be provided to
-- 'GI.GLib.Functions.testBug' instead.
-- 
-- See also 'GI.GLib.Functions.testSummary'.
-- 
-- Since GLib 2.70, the base URI is not prepended to /@bugUriSnippet@/
-- if it is already a valid URI.
-- 
-- /Since: 2.16/
testBug ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@bugUriSnippet@/: Bug specific bug tracker URI or URI portion.
    -> m ()
testBug bugUriSnippet = liftIO $ do
    bugUriSnippet' <- textToCString bugUriSnippet
    g_test_bug bugUriSnippet'
    freeMem bugUriSnippet'
    return ()


-- function test_assert_expected_messages_internal
-- Args: [ Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_assert_expected_messages_internal" g_test_assert_expected_messages_internal :: 
    CString ->                              -- domain : TBasicType TUTF8
    CString ->                              -- file : TBasicType TUTF8
    Int32 ->                                -- line : TBasicType TInt
    CString ->                              -- func : TBasicType TUTF8
    IO ()

-- | /No description available in the introspection data./
testAssertExpectedMessagesInternal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -> T.Text
    -> Int32
    -> T.Text
    -> m ()
testAssertExpectedMessagesInternal domain file line func = liftIO $ do
    domain' <- textToCString domain
    file' <- textToCString file
    func' <- textToCString func
    g_test_assert_expected_messages_internal domain' file' line func'
    freeMem domain'
    freeMem file'
    freeMem func'
    return ()


-- function test_add_func
-- Args: [ Arg
--           { argCName = "testpath"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a /-separated name for the test"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "test_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the test function to invoke for this test"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_add_func" g_test_add_func :: 
    CString ->                              -- testpath : TBasicType TUTF8
    FunPtr GLib.Callbacks.C_TestFunc ->     -- test_func : TInterface (Name {namespace = "GLib", name = "TestFunc"})
    IO ()

-- | Creates a new test case.
-- 
-- This function is similar to @/GLib.test_create_case/@.
-- However the test is assumed to use no fixture, and test suites are
-- automatically created on the fly and added to the root fixture,
-- based on the \/-separated portions of /@testpath@/.
-- 
-- If /@testpath@/ includes the component \"subprocess\" anywhere in it,
-- the test will be skipped by default, and only run if explicitly
-- required via the @-p@ command-line option or 'GI.GLib.Functions.testTrapSubprocess'.
-- 
-- No component of /@testpath@/ may start with a dot (@.@) if the
-- [const/@gLib@/.TEST_OPTION_ISOLATE_DIRS] option is being used; and
-- it is recommended to do so even if it isn’t.
-- 
-- /Since: 2.16/
testAddFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@testpath@/: a \/-separated name for the test
    -> GLib.Callbacks.TestFunc
    -- ^ /@testFunc@/: the test function to invoke for this test
    -> m ()
testAddFunc testpath testFunc = liftIO $ do
    testpath' <- textToCString testpath
    ptrtestFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_TestFunc))
    testFunc' <- GLib.Callbacks.mk_TestFunc (GLib.Callbacks.wrap_TestFunc (Just ptrtestFunc) testFunc)
    poke ptrtestFunc testFunc'
    g_test_add_func testpath' testFunc'
    freeMem testpath'
    return ()


-- function test_add_data_func
-- Args: [ Arg
--           { argCName = "testpath"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a /-separated name for the test"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "test_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data for the @test_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "test_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the test function to invoke for this test"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_add_data_func" g_test_add_data_func :: 
    CString ->                              -- testpath : TBasicType TUTF8
    Ptr () ->                               -- test_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_TestDataFunc -> -- test_func : TInterface (Name {namespace = "GLib", name = "TestDataFunc"})
    IO ()

-- | Creates a new test case.
-- 
-- This function is similar to @/GLib.test_create_case/@.
-- However the test is assumed to use no fixture, and test suites are
-- automatically created on the fly and added to the root fixture,
-- based on the \/-separated portions of /@testpath@/. The /@testData@/
-- argument will be passed as first argument to /@testFunc@/.
-- 
-- If /@testpath@/ includes the component \"subprocess\" anywhere in it,
-- the test will be skipped by default, and only run if explicitly
-- required via the @-p@ command-line option or 'GI.GLib.Functions.testTrapSubprocess'.
-- 
-- No component of /@testpath@/ may start with a dot (@.@) if the
-- [const/@gLib@/.TEST_OPTION_ISOLATE_DIRS] option is being used;
-- and it is recommended to do so even if it isn’t.
-- 
-- /Since: 2.16/
testAddDataFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@testpath@/: a \/-separated name for the test
    -> Ptr ()
    -- ^ /@testData@/: data for the /@testFunc@/
    -> GLib.Callbacks.TestDataFunc
    -- ^ /@testFunc@/: the test function to invoke for this test
    -> m ()
testAddDataFunc testpath testData testFunc = liftIO $ do
    testpath' <- textToCString testpath
    ptrtestFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_TestDataFunc))
    testFunc' <- GLib.Callbacks.mk_TestDataFunc (GLib.Callbacks.wrap_TestDataFunc (Just ptrtestFunc) (GLib.Callbacks.drop_closures_TestDataFunc testFunc))
    poke ptrtestFunc testFunc'
    g_test_add_data_func testpath' testData testFunc'
    freeMem testpath'
    return ()


-- function strv_length
-- Args: [ Arg
--           { argCName = "str_array"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of strings"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_length" g_strv_length :: 
    Ptr CString ->                          -- str_array : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO Word32

-- | Returns the length of an array of strings. /@strArray@/ must not be @NULL@.
-- 
-- /Since: 2.6/
strvLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [T.Text]
    -- ^ /@strArray@/: an array of strings
    -> m Word32
    -- ^ __Returns:__ length of /@strArray@/
strvLength strArray = liftIO $ do
    strArray' <- packZeroTerminatedUTF8CArray strArray
    result <- g_strv_length strArray'
    mapZeroTerminatedCArray freeMem strArray'
    freeMem strArray'
    return result


-- function strv_get_type
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_get_type" g_strv_get_type :: 
    IO CGType

-- | /No description available in the introspection data./
strvGetType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GType
strvGetType  = liftIO $ do
    result <- g_strv_get_type
    let result' = GType result
    return result'


-- function strv_equal
-- Args: [ Arg
--           { argCName = "strv1"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of strings to compare to @strv2"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "strv2"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of strings to compare to @strv1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_equal" g_strv_equal :: 
    Ptr CString ->                          -- strv1 : TCArray True (-1) (-1) (TBasicType TUTF8)
    Ptr CString ->                          -- strv2 : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO CInt

-- | Checks if two arrays of strings contain exactly the same elements in
-- exactly the same order.
-- 
-- Elements are compared using 'GI.GLib.Functions.strEqual'. To match independently
-- of order, sort the arrays first (using 'GI.GLib.Functions.qsortWithData'
-- or similar).
-- 
-- Two empty arrays are considered equal. Neither /@strv1@/ nor /@strv2@/ may be
-- @NULL@.
-- 
-- /Since: 2.60/
strvEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [T.Text]
    -- ^ /@strv1@/: an array of strings to compare to /@strv2@/
    -> [T.Text]
    -- ^ /@strv2@/: an array of strings to compare to /@strv1@/
    -> m Bool
    -- ^ __Returns:__ true if /@strv1@/ and /@strv2@/ are equal
strvEqual strv1 strv2 = liftIO $ do
    strv1' <- packZeroTerminatedUTF8CArray strv1
    strv2' <- packZeroTerminatedUTF8CArray strv2
    result <- g_strv_equal strv1' strv2'
    let result' = (/= 0) result
    mapZeroTerminatedCArray freeMem strv1'
    freeMem strv1'
    mapZeroTerminatedCArray freeMem strv2'
    freeMem strv2'
    return result'


-- function strv_contains
-- Args: [ Arg
--           { argCName = "strv"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of strings to search in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to search for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_contains" g_strv_contains :: 
    Ptr CString ->                          -- strv : TCArray True (-1) (-1) (TBasicType TUTF8)
    CString ->                              -- str : TBasicType TUTF8
    IO CInt

-- | Checks if an array of strings contains the string /@str@/ according to
-- 'GI.GLib.Functions.strEqual'. /@strv@/ must not be @NULL@.
-- 
-- /Since: 2.44/
strvContains ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [T.Text]
    -- ^ /@strv@/: an array of strings to search in
    -> T.Text
    -- ^ /@str@/: the string to search for
    -> m Bool
    -- ^ __Returns:__ true if /@str@/ is an element of /@strv@/
strvContains strv str = liftIO $ do
    strv' <- packZeroTerminatedUTF8CArray strv
    str' <- textToCString str
    result <- g_strv_contains strv' str'
    let result' = (/= 0) result
    mapZeroTerminatedCArray freeMem strv'
    freeMem strv'
    freeMem str'
    return result'


-- function strup
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to convert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strup" g_strup :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

{-# DEPRECATED strup ["(Since version 2.2)","This function is totally broken for the reasons discussed","  in the 'GI.GLib.Functions.strncasecmp' docs \8212 use 'GI.GLib.Functions.asciiStrup' or","  'GI.GLib.Functions.utf8Strup' instead."] #-}
-- | Converts a string to upper case.
strup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: the string to convert
    -> m T.Text
    -- ^ __Returns:__ the string
strup string = liftIO $ do
    string' <- textToCString string
    result <- g_strup string'
    checkUnexpectedReturnNULL "strup" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    return result'


-- function strtod
-- Args: [ Arg
--           { argCName = "nptr"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to convert to a numeric value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "endptr"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if non-`NULL`, it returns the\n  character after the last character used in the conversion"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "g_strtod" g_strtod :: 
    CString ->                              -- nptr : TBasicType TUTF8
    Ptr CString ->                          -- endptr : TBasicType TUTF8
    IO CDouble

-- | Converts a string to a floating point value.
-- 
-- It calls the standard @strtod()@ function to handle the conversion, but
-- if the string is not completely converted it attempts the conversion
-- again with 'GI.GLib.Functions.asciiStrtod', and returns the best match.
-- 
-- This function should seldom be used. The normal situation when reading
-- numbers not for human consumption is to use 'GI.GLib.Functions.asciiStrtod'. Only when
-- you know that you must expect both locale formatted and C formatted numbers
-- should you use this. Make sure that you don\'t pass strings such as comma
-- separated lists of values, since the commas may be interpreted as a decimal
-- point in some locales, causing unexpected results.
strtod ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@nptr@/: the string to convert to a numeric value
    -> m ((Double, T.Text))
    -- ^ __Returns:__ the converted value
strtod nptr = liftIO $ do
    nptr' <- textToCString nptr
    endptr <- callocMem :: IO (Ptr CString)
    result <- g_strtod nptr' endptr
    let result' = realToFrac result
    endptr' <- peek endptr
    endptr'' <- cstringToText endptr'
    freeMem nptr'
    freeMem endptr
    return (result', endptr'')


-- function strstr_len
-- Args: [ Arg
--           { argCName = "haystack"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to search in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "haystack_len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length of @haystack in bytes, or `-1` to\n  search it entirely"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "needle"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to search for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strstr_len" g_strstr_len :: 
    CString ->                              -- haystack : TBasicType TUTF8
    DI.Int64 ->                             -- haystack_len : TBasicType TSSize
    CString ->                              -- needle : TBasicType TUTF8
    IO CString

-- | Searches the string /@haystack@/ for the first occurrence
-- of the string /@needle@/, limiting the length of the search
-- to /@haystackLen@/ or a nul terminator byte (whichever is reached first).
-- 
-- A length of @-1@ can be used to mean “search the entire string”, like
-- @strstr()@.
-- 
-- The fact that this function returns @gchar *@ rather than @const gchar *@ is
-- a historical artifact.
strstrLen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@haystack@/: a string to search in
    -> DI.Int64
    -- ^ /@haystackLen@/: the maximum length of /@haystack@/ in bytes, or @-1@ to
    --   search it entirely
    -> T.Text
    -- ^ /@needle@/: the string to search for
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a pointer to the found occurrence, or
    --    @NULL@ if not found
strstrLen haystack haystackLen needle = liftIO $ do
    haystack' <- textToCString haystack
    needle' <- textToCString needle
    result <- g_strstr_len haystack' haystackLen needle'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    freeMem haystack'
    freeMem needle'
    return maybeResult


-- function strsplit_set
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to split" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delimiters"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string containing characters that are used to split the\n  string. Can be empty, which will result in no string splitting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_tokens"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum number of tokens to split @string into.\n  If this is less than 1, the string is split completely"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_strsplit_set" g_strsplit_set :: 
    CString ->                              -- string : TBasicType TUTF8
    CString ->                              -- delimiters : TBasicType TUTF8
    Int32 ->                                -- max_tokens : TBasicType TInt
    IO (Ptr CString)

-- | Splits /@string@/ into a number of tokens not containing any of the characters
-- in /@delimiters@/. A token is the (possibly empty) longest string that does not
-- contain any of the characters in /@delimiters@/. If /@maxTokens@/ is reached, the
-- remainder is appended to the last token.
-- 
-- For example, the result of g_strsplit_set (\"abc:def\/ghi\", \":\/\", -1) is an
-- array containing the three strings \"abc\", \"def\", and \"ghi\".
-- 
-- The result of g_strsplit_set (\":def\/ghi:\", \":\/\", -1) is an array containing
-- the four strings \"\", \"def\", \"ghi\", and \"\".
-- 
-- As a special case, the result of splitting the empty string \"\" is an empty
-- array, not an array containing a single string. The reason for this
-- special case is that being able to represent an empty array is typically
-- more useful than consistent handling of empty elements. If you do need
-- to represent empty elements, you\'ll need to check for the empty string
-- before calling @g_strsplit_set()@.
-- 
-- Note that this function works on bytes not characters, so it can\'t be used
-- to delimit UTF-8 strings for anything but ASCII characters.
-- 
-- /Since: 2.4/
strsplitSet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: a string to split
    -> T.Text
    -- ^ /@delimiters@/: a string containing characters that are used to split the
    --   string. Can be empty, which will result in no string splitting
    -> Int32
    -- ^ /@maxTokens@/: the maximum number of tokens to split /@string@/ into.
    --   If this is less than 1, the string is split completely
    -> m [T.Text]
    -- ^ __Returns:__ a newly-allocated array of strings. Use
    --   'GI.GLib.Functions.strfreev' to free it.
strsplitSet string delimiters maxTokens = liftIO $ do
    string' <- textToCString string
    delimiters' <- textToCString delimiters
    result <- g_strsplit_set string' delimiters' maxTokens
    checkUnexpectedReturnNULL "strsplitSet" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    freeMem string'
    freeMem delimiters'
    return result'


-- function strsplit
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to split" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delimiter"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string which specifies the places at which to split\n  the string. The delimiter is not included in any of the resulting\n  strings, unless @max_tokens is reached."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_tokens"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum number of pieces to split @string into\n  If this is less than 1, the string is split completely"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_strsplit" g_strsplit :: 
    CString ->                              -- string : TBasicType TUTF8
    CString ->                              -- delimiter : TBasicType TUTF8
    Int32 ->                                -- max_tokens : TBasicType TInt
    IO (Ptr CString)

-- | Splits a string into a maximum of /@maxTokens@/ pieces, using the given
-- /@delimiter@/. If /@maxTokens@/ is reached, the remainder of /@string@/ is
-- appended to the last token.
-- 
-- As an example, the result of @g_strsplit (\":a:bc::d:\", \":\", -1)@ is an array
-- containing the six strings \"\", \"a\", \"bc\", \"\", \"d\" and \"\".
-- 
-- As a special case, the result of splitting the empty string \"\" is an empty
-- array, not an array containing a single string. The reason for this
-- special case is that being able to represent an empty array is typically
-- more useful than consistent handling of empty elements. If you do need
-- to represent empty elements, you\'ll need to check for the empty string
-- before calling @g_strsplit()@.
strsplit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: a string to split
    -> T.Text
    -- ^ /@delimiter@/: a string which specifies the places at which to split
    --   the string. The delimiter is not included in any of the resulting
    --   strings, unless /@maxTokens@/ is reached.
    -> Int32
    -- ^ /@maxTokens@/: the maximum number of pieces to split /@string@/ into
    --   If this is less than 1, the string is split completely
    -> m [T.Text]
    -- ^ __Returns:__ a newly-allocated array of strings, freed with
    --   'GI.GLib.Functions.strfreev'
strsplit string delimiter maxTokens = liftIO $ do
    string' <- textToCString string
    delimiter' <- textToCString delimiter
    result <- g_strsplit string' delimiter' maxTokens
    checkUnexpectedReturnNULL "strsplit" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    freeMem string'
    freeMem delimiter'
    return result'


-- function strsignal
-- Args: [ Arg
--           { argCName = "signum"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the signal number. See the `signal` documentation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strsignal" g_strsignal :: 
    Int32 ->                                -- signum : TBasicType TInt
    IO CString

-- | Returns a string describing the given signal, e.g. \"Segmentation fault\".
-- If the signal is unknown, it returns “unknown signal (\<signum\\>)”.
-- 
-- You should use this function in preference to @strsignal()@, because it
-- returns a string in UTF-8 encoding, and since not all platforms support
-- the @strsignal()@ function.
strsignal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@signum@/: the signal number. See the @signal@ documentation
    -> m T.Text
    -- ^ __Returns:__ the string describing the signal
strsignal signum = liftIO $ do
    result <- g_strsignal signum
    checkUnexpectedReturnNULL "strsignal" result
    result' <- cstringToText result
    return result'


-- function strrstr_len
-- Args: [ Arg
--           { argCName = "haystack"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to search in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "haystack_len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum length of @haystack in bytes. A length of `-1`\n  can be used to mean \"search the entire string\", like [func@GLib.strrstr]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "needle"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to search for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strrstr_len" g_strrstr_len :: 
    CString ->                              -- haystack : TBasicType TUTF8
    DI.Int64 ->                             -- haystack_len : TBasicType TSSize
    CString ->                              -- needle : TBasicType TUTF8
    IO CString

-- | Searches the string /@haystack@/ for the last occurrence
-- of the string /@needle@/, limiting the length of the search
-- to /@haystackLen@/.
-- 
-- The fact that this function returns @gchar *@ rather than @const gchar *@ is
-- a historical artifact.
strrstrLen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@haystack@/: a string to search in
    -> DI.Int64
    -- ^ /@haystackLen@/: the maximum length of /@haystack@/ in bytes. A length of @-1@
    --   can be used to mean \"search the entire string\", like 'GI.GLib.Functions.strrstr'
    -> T.Text
    -- ^ /@needle@/: the string to search for
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a pointer to the found occurrence, or
    --    @NULL@ if not found
strrstrLen haystack haystackLen needle = liftIO $ do
    haystack' <- textToCString haystack
    needle' <- textToCString needle
    result <- g_strrstr_len haystack' haystackLen needle'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    freeMem haystack'
    freeMem needle'
    return maybeResult


-- function strrstr
-- Args: [ Arg
--           { argCName = "haystack"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to search in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "needle"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to search for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strrstr" g_strrstr :: 
    CString ->                              -- haystack : TBasicType TUTF8
    CString ->                              -- needle : TBasicType TUTF8
    IO CString

-- | Searches the string /@haystack@/ for the last occurrence
-- of the string /@needle@/.
-- 
-- The fact that this function returns @gchar *@ rather than @const gchar *@ is
-- a historical artifact.
strrstr ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@haystack@/: a string to search in
    -> T.Text
    -- ^ /@needle@/: the string to search for
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a pointer to the found occurrence, or
    --    @NULL@ if not found
strrstr haystack needle = liftIO $ do
    haystack' <- textToCString haystack
    needle' <- textToCString needle
    result <- g_strrstr haystack' needle'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    freeMem haystack'
    freeMem needle'
    return maybeResult


-- function strreverse
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to reverse"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strreverse" g_strreverse :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

-- | Reverses all of the bytes in a string. For example,
-- @g_strreverse (\"abcdef\")@ will result in \"fedcba\".
-- 
-- Note that @g_strreverse()@ doesn\'t work on UTF-8 strings
-- containing multibyte characters. For that purpose, use
-- 'GI.GLib.Functions.utf8Strreverse'.
strreverse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: the string to reverse
    -> m T.Text
    -- ^ __Returns:__ the /@string@/, reversed in place
strreverse string = liftIO $ do
    string' <- textToCString string
    result <- g_strreverse string'
    checkUnexpectedReturnNULL "strreverse" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    return result'


-- function strnfill
-- Args: [ Arg
--           { argCName = "length"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of the new string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fill_char"
--           , argType = TBasicType TInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the byte to fill the string with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strnfill" g_strnfill :: 
    FCT.CSize ->                            -- length : TBasicType TSize
    Int8 ->                                 -- fill_char : TBasicType TInt8
    IO CString

-- | Creates a new string /@length@/ bytes long filled with /@fillChar@/.
strnfill ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@length@/: the length of the new string
    -> Int8
    -- ^ /@fillChar@/: the byte to fill the string with
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated string filled with /@fillChar@/
strnfill length_ fillChar = liftIO $ do
    result <- g_strnfill length_ fillChar
    checkUnexpectedReturnNULL "strnfill" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function strndup
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to duplicate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum number of bytes to copy from @str"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strndup" g_strndup :: 
    CString ->                              -- str : TBasicType TUTF8
    FCT.CSize ->                            -- n : TBasicType TSize
    IO CString

-- | Duplicates the first /@n@/ bytes of a string, returning a newly-allocated
-- buffer /@n@/ + 1 bytes long which will always be nul-terminated. If /@str@/
-- is less than /@n@/ bytes long the buffer is padded with nuls. If /@str@/ is
-- @NULL@ it returns @NULL@.
-- 
-- To copy a number of characters from a UTF-8 encoded string,
-- use 'GI.GLib.Functions.utf8Strncpy' instead.
strndup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@str@/: the string to duplicate
    -> FCT.CSize
    -- ^ /@n@/: the maximum number of bytes to copy from /@str@/
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a newly-allocated buffer containing the first
    --    /@n@/ bytes of /@str@/
strndup str n = liftIO $ do
    maybeStr <- case str of
        Nothing -> return FP.nullPtr
        Just jStr -> do
            jStr' <- textToCString jStr
            return jStr'
    result <- g_strndup maybeStr n
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem maybeStr
    return maybeResult


-- function strncasecmp
-- Args: [ Arg
--           { argCName = "s1"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to compare with @s2"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "s2"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to compare with @s1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum number of characters to compare"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_strncasecmp" g_strncasecmp :: 
    CString ->                              -- s1 : TBasicType TUTF8
    CString ->                              -- s2 : TBasicType TUTF8
    Word32 ->                               -- n : TBasicType TUInt
    IO Int32

{-# DEPRECATED strncasecmp ["(Since version 2.2)","The problem with @g_strncasecmp()@ is that it does","  the comparison by calling @toupper()@\\/@tolower()@. These functions","  are locale-specific and operate on single bytes. However, it is","  impossible to handle things correctly from an internationalization","  standpoint by operating on bytes, since characters may be multibyte.","  Thus @g_strncasecmp()@ is broken if your string is guaranteed to be","  ASCII, since it is locale-sensitive, and it\\'s broken if your string","  is localized, since it doesn\\'t work on many encodings at all,","  including UTF-8, EUC-JP, etc.","","  There are therefore two replacement techniques: 'GI.GLib.Functions.asciiStrncasecmp',","  which only works on ASCII and is not locale-sensitive, and","  'GI.GLib.Functions.utf8Casefold' followed by @strcmp()@ on the resulting strings,","  which is good for case-insensitive sorting of UTF-8."] #-}
-- | A case-insensitive string comparison, corresponding to the standard
-- @strncasecmp()@ function on platforms which support it. It is similar
-- to 'GI.GLib.Functions.strcasecmp' except it only compares the first /@n@/ characters of
-- the strings.
strncasecmp ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@s1@/: string to compare with /@s2@/
    -> T.Text
    -- ^ /@s2@/: string to compare with /@s1@/
    -> Word32
    -- ^ /@n@/: the maximum number of characters to compare
    -> m Int32
    -- ^ __Returns:__ 0 if the strings match, a negative value if /@s1@/ \< /@s2@/,
    --   or a positive value if /@s1@/ > /@s2@/
strncasecmp s1 s2 n = liftIO $ do
    s1' <- textToCString s1
    s2' <- textToCString s2
    result <- g_strncasecmp s1' s2' n
    freeMem s1'
    freeMem s2'
    return result


-- function strlcpy
-- Args: [ Arg
--           { argCName = "dest"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destination buffer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "source buffer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of @dest in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_strlcpy" g_strlcpy :: 
    CString ->                              -- dest : TBasicType TUTF8
    CString ->                              -- src : TBasicType TUTF8
    FCT.CSize ->                            -- dest_size : TBasicType TSize
    IO FCT.CSize

-- | Portability wrapper that calls @strlcpy()@ on systems which have it,
-- and emulates @strlcpy()@ otherwise. Copies /@src@/ to /@dest@/; /@dest@/ is
-- guaranteed to be nul-terminated; /@src@/ must be nul-terminated;
-- /@destSize@/ is the buffer size, not the number of bytes to copy.
-- 
-- At most /@destSize@/ - 1 characters will be copied. Always nul-terminates
-- (unless /@destSize@/ is 0). This function does not allocate memory. Unlike
-- @strncpy()@, this function doesn\'t pad /@dest@/ (so it\'s often faster). It
-- returns the size of the attempted result, @strlen (src)@, so if
-- /@retval@/ >= /@destSize@/, truncation occurred.
-- 
-- Caveat: @strlcpy()@ is supposedly more secure than @strcpy()@ or @strncpy()@,
-- but if you really want to avoid screwups, 'GI.GLib.Functions.strdup' is an even better
-- idea.
strlcpy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@dest@/: destination buffer
    -> T.Text
    -- ^ /@src@/: source buffer
    -> FCT.CSize
    -- ^ /@destSize@/: length of /@dest@/ in bytes
    -> m FCT.CSize
    -- ^ __Returns:__ length of /@src@/
strlcpy dest src destSize = liftIO $ do
    dest' <- textToCString dest
    src' <- textToCString src
    result <- g_strlcpy dest' src' destSize
    freeMem dest'
    freeMem src'
    return result


-- function strlcat
-- Args: [ Arg
--           { argCName = "dest"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "destination buffer, already containing one nul-terminated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "source buffer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "length of @dest buffer in bytes (not length of existing string\n  inside @dest)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_strlcat" g_strlcat :: 
    CString ->                              -- dest : TBasicType TUTF8
    CString ->                              -- src : TBasicType TUTF8
    FCT.CSize ->                            -- dest_size : TBasicType TSize
    IO FCT.CSize

-- | Portability wrapper that calls @strlcat()@ on systems which have it,
-- and emulates it otherwise. Appends nul-terminated /@src@/ string to /@dest@/,
-- guaranteeing nul-termination for /@dest@/. The total size of /@dest@/ won\'t
-- exceed /@destSize@/.
-- 
-- At most /@destSize@/ - 1 characters will be copied. Unlike @strncat()@,
-- /@destSize@/ is the full size of dest, not the space left over. This
-- function does not allocate memory. It always nul-terminates (unless
-- /@destSize@/ == 0 or there were no nul characters in the /@destSize@/
-- characters of dest to start with).
-- 
-- Caveat: this is supposedly a more secure alternative to @strcat()@ or
-- @strncat()@, but for real security @/GLib.strconcat/@ is harder to mess up.
strlcat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@dest@/: destination buffer, already containing one nul-terminated string
    -> T.Text
    -- ^ /@src@/: source buffer
    -> FCT.CSize
    -- ^ /@destSize@/: length of /@dest@/ buffer in bytes (not length of existing string
    --   inside /@dest@/)
    -> m FCT.CSize
    -- ^ __Returns:__ size of attempted result, which is @MIN (dest_size, strlen
    --   (original dest)) + strlen (src)@, so if /@retval@/ >= /@destSize@/,
    --   truncation occurred
strlcat dest src destSize = liftIO $ do
    dest' <- textToCString dest
    src' <- textToCString src
    result <- g_strlcat dest' src' destSize
    freeMem dest'
    freeMem src'
    return result


-- function strjoinv
-- Args: [ Arg
--           { argCName = "separator"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a string to insert between each of the strings"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str_array"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of strings to join"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strjoinv" g_strjoinv :: 
    CString ->                              -- separator : TBasicType TUTF8
    Ptr CString ->                          -- str_array : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO CString

-- | Joins an array of strings together to form one long string, with the
-- optional /@separator@/ inserted between each of them.
-- 
-- If /@strArray@/ has no items, the return value will be an
-- empty string. If /@strArray@/ contains a single item, /@separator@/ will not
-- appear in the resulting string.
strjoinv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@separator@/: a string to insert between each of the strings
    -> [T.Text]
    -- ^ /@strArray@/: an array of strings to join
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated string containing all of the strings joined
    --   together, with /@separator@/ between them
strjoinv separator strArray = liftIO $ do
    maybeSeparator <- case separator of
        Nothing -> return FP.nullPtr
        Just jSeparator -> do
            jSeparator' <- textToCString jSeparator
            return jSeparator'
    strArray' <- packZeroTerminatedUTF8CArray strArray
    result <- g_strjoinv maybeSeparator strArray'
    checkUnexpectedReturnNULL "strjoinv" result
    result' <- cstringToText result
    freeMem result
    freeMem maybeSeparator
    mapZeroTerminatedCArray freeMem strArray'
    freeMem strArray'
    return result'


-- function strip_context
-- Args: [ Arg
--           { argCName = "msgid"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "msgval"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strip_context" g_strip_context :: 
    CString ->                              -- msgid : TBasicType TUTF8
    CString ->                              -- msgval : TBasicType TUTF8
    IO CString

-- | An auxiliary function for @/gettext()/@ support (see @/Q_()/@).
-- 
-- /Since: 2.4/
stripContext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@msgid@/: a string
    -> T.Text
    -- ^ /@msgval@/: another string
    -> m T.Text
    -- ^ __Returns:__ /@msgval@/, unless /@msgval@/ is identical to /@msgid@/
    --     and contains a \'|\' character, in which case a pointer to
    --     the substring of msgid after the first \'|\' character is returned.
stripContext msgid msgval = liftIO $ do
    msgid' <- textToCString msgid
    msgval' <- textToCString msgval
    result <- g_strip_context msgid' msgval'
    checkUnexpectedReturnNULL "stripContext" result
    result' <- cstringToText result
    freeMem msgid'
    freeMem msgval'
    return result'


-- function strfreev
-- Args: [ Arg
--           { argCName = "str_array"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an\n  array of strings to free"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_strfreev" g_strfreev :: 
    Ptr CString ->                          -- str_array : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Frees an array of strings, as well as each string it contains.
-- 
-- If /@strArray@/ is @NULL@, this function simply returns.
strfreev ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([T.Text])
    -- ^ /@strArray@/: an
    --   array of strings to free
    -> m ()
strfreev strArray = liftIO $ do
    maybeStrArray <- case strArray of
        Nothing -> return FP.nullPtr
        Just jStrArray -> do
            jStrArray' <- packZeroTerminatedUTF8CArray jStrArray
            return jStrArray'
    g_strfreev maybeStrArray
    return ()


-- function strescape
-- Args: [ Arg
--           { argCName = "source"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to escape" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "exceptions"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a string of characters not to escape in @source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strescape" g_strescape :: 
    CString ->                              -- source : TBasicType TUTF8
    CString ->                              -- exceptions : TBasicType TUTF8
    IO CString

-- | It replaces the following special characters in the string /@source@/
-- with their corresponding C escape sequence:
-- 
-- | Symbol                                                                      | Escape |
-- |-----------------------------------------------------------------------------|--------|
-- | <https://en.wikipedia.org/wiki/Backspace U+0008 Backspace>                 | @\\b@   |
-- | <https://en.wikipedia.org/wiki/Form_feed U+000C Form Feed>                 | @\\f@   |
-- | <https://en.wikipedia.org/wiki/Newline U+000A Line Feed>                   | @\\n@   |
-- | <https://en.wikipedia.org/wiki/Carriage_return U+000D Carriage Return>     | @\\r@   |
-- | <https://en.wikipedia.org/wiki/Tab_character U+0009 Horizontal Tabulation> | @\\t@   |
-- | <https://en.wikipedia.org/wiki/Vertical_Tab U+000B Vertical Tabulation>    | @\\v@   |
-- 
-- It also inserts a backslash (@\\@) before any backslash or a double quote (@\"@).
-- Additionally all characters in the range 0x01-0x1F (everything
-- below SPACE) and in the range 0x7F-0xFF (all non-ASCII chars) are
-- replaced with a backslash followed by their octal representation.
-- Characters supplied in /@exceptions@/ are not escaped.
-- 
-- 'GI.GLib.Functions.strcompress' does the reverse conversion.
strescape ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@source@/: a string to escape
    -> Maybe (T.Text)
    -- ^ /@exceptions@/: a string of characters not to escape in /@source@/
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated copy of /@source@/ with special characters escaped
strescape source exceptions = liftIO $ do
    source' <- textToCString source
    maybeExceptions <- case exceptions of
        Nothing -> return FP.nullPtr
        Just jExceptions -> do
            jExceptions' <- textToCString jExceptions
            return jExceptions'
    result <- g_strescape source' maybeExceptions
    checkUnexpectedReturnNULL "strescape" result
    result' <- cstringToText result
    freeMem result
    freeMem source'
    freeMem maybeExceptions
    return result'


-- function strerror
-- Args: [ Arg
--           { argCName = "errnum"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the system error number. See the standard C `errno` documentation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strerror" g_strerror :: 
    Int32 ->                                -- errnum : TBasicType TInt
    IO CString

-- | Returns a string corresponding to the given error code, e.g. \"no
-- such process\".
-- 
-- Unlike @strerror()@, this always returns a string in
-- UTF-8 encoding, and the pointer is guaranteed to remain valid for
-- the lifetime of the process. If the error code is unknown, it returns a
-- string like “Unknown error \<code\\>”.
-- 
-- Note that the string may be translated according to the current locale.
-- 
-- The value of @errno@ will not be changed by this function. However, it may
-- be changed by intermediate function calls, so you should save its value
-- as soon as the call returns:
-- 
-- === /C code/
-- >int saved_errno;
-- >
-- >ret = read (blah);
-- >saved_errno = errno;
-- >
-- >g_strerror (saved_errno);
strerror ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@errnum@/: the system error number. See the standard C @errno@ documentation
    -> m T.Text
    -- ^ __Returns:__ the string describing the error code
strerror errnum = liftIO $ do
    result <- g_strerror errnum
    checkUnexpectedReturnNULL "strerror" result
    result' <- cstringToText result
    return result'


-- function strdupv
-- Args: [ Arg
--           { argCName = "str_array"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of strings to copy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_strdupv" g_strdupv :: 
    Ptr CString ->                          -- str_array : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr CString)

-- | Copies an array of strings. The copy is a deep copy; each string is also
-- copied.
-- 
-- If called on a @NULL@ value, @g_strdupv()@ simply returns @NULL@.
strdupv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([T.Text])
    -- ^ /@strArray@/: an array of strings to copy
    -> m (Maybe [T.Text])
    -- ^ __Returns:__ a
    --   newly-allocated array of strings. Use 'GI.GLib.Functions.strfreev' to free it.
strdupv strArray = liftIO $ do
    maybeStrArray <- case strArray of
        Nothing -> return FP.nullPtr
        Just jStrArray -> do
            jStrArray' <- packZeroTerminatedUTF8CArray jStrArray
            return jStrArray'
    result <- g_strdupv maybeStrArray
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedUTF8CArray result'
        mapZeroTerminatedCArray freeMem result'
        freeMem result'
        return result''
    mapZeroTerminatedCArray freeMem maybeStrArray
    freeMem maybeStrArray
    return maybeResult


-- function strdup
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to duplicate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strdup" g_strdup :: 
    CString ->                              -- str : TBasicType TUTF8
    IO CString

-- | Duplicates a string. If /@str@/ is @NULL@ it returns @NULL@.
strdup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@str@/: the string to duplicate
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated copy of /@str@/
strdup str = liftIO $ do
    maybeStr <- case str of
        Nothing -> return FP.nullPtr
        Just jStr -> do
            jStr' <- textToCString jStr
            return jStr'
    result <- g_strdup maybeStr
    checkUnexpectedReturnNULL "strdup" result
    result' <- cstringToText result
    freeMem result
    freeMem maybeStr
    return result'


-- function strdown
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to convert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strdown" g_strdown :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

{-# DEPRECATED strdown ["(Since version 2.2)","This function is totally broken for the reasons discussed","  in the 'GI.GLib.Functions.strncasecmp' docs \8212 use 'GI.GLib.Functions.asciiStrdown' or","  'GI.GLib.Functions.utf8Strdown' instead."] #-}
-- | Converts a string to lower case.
strdown ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: the string to convert
    -> m T.Text
    -- ^ __Returns:__ the string
strdown string = liftIO $ do
    string' <- textToCString string
    result <- g_strdown string'
    checkUnexpectedReturnNULL "strdown" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    return result'


-- function strdelimit
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to convert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delimiters"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string containing the current delimiters, or\n  `NULL` to use the standard delimiters defined in [const@GLib.STR_DELIMITERS]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "new_delimiter"
--           , argType = TBasicType TInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new delimiter character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strdelimit" g_strdelimit :: 
    CString ->                              -- string : TBasicType TUTF8
    CString ->                              -- delimiters : TBasicType TUTF8
    Int8 ->                                 -- new_delimiter : TBasicType TInt8
    IO CString

-- | Converts any delimiter characters in /@string@/ to /@newDelimiter@/.
-- 
-- Any characters in /@string@/ which are found in /@delimiters@/ are
-- changed to the /@newDelimiter@/ character. Modifies /@string@/ in place,
-- and returns /@string@/ itself, not a copy.
-- 
-- The return value is to allow nesting such as:
-- 
-- === /C code/
-- >g_ascii_strup (g_strdelimit (str, "abc", '?'))
-- 
-- 
-- In order to modify a copy, you may use 'GI.GLib.Functions.strdup':
-- 
-- === /C code/
-- >reformatted = g_strdelimit (g_strdup (const_str), "abc", '?');
-- >…
-- >g_free (reformatted);
strdelimit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: the string to convert
    -> Maybe (T.Text)
    -- ^ /@delimiters@/: a string containing the current delimiters, or
    --   @NULL@ to use the standard delimiters defined in [const/@gLib@/.STR_DELIMITERS]
    -> Int8
    -- ^ /@newDelimiter@/: the new delimiter character
    -> m T.Text
    -- ^ __Returns:__ the modified /@string@/
strdelimit string delimiters newDelimiter = liftIO $ do
    string' <- textToCString string
    maybeDelimiters <- case delimiters of
        Nothing -> return FP.nullPtr
        Just jDelimiters -> do
            jDelimiters' <- textToCString jDelimiters
            return jDelimiters'
    result <- g_strdelimit string' maybeDelimiters newDelimiter
    checkUnexpectedReturnNULL "strdelimit" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    freeMem maybeDelimiters
    return result'


-- function strcompress
-- Args: [ Arg
--           { argCName = "source"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to compress"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strcompress" g_strcompress :: 
    CString ->                              -- source : TBasicType TUTF8
    IO CString

-- | Makes a copy of a string replacing C string-style escape
-- sequences with their one byte equivalent:
-- 
-- * @\\b@ → <https://en.wikipedia.org/wiki/Backspace U+0008 Backspace>
-- * @\\f@ → <https://en.wikipedia.org/wiki/Form_feed U+000C Form Feed>
-- * @\\n@ → <https://en.wikipedia.org/wiki/Newline U+000A Line Feed>
-- * @\\r@ → <https://en.wikipedia.org/wiki/Carriage_return U+000D Carriage Return>
-- * @\\t@ → <https://en.wikipedia.org/wiki/Tab_character U+0009 Horizontal Tabulation>
-- * @\\v@ → <https://en.wikipedia.org/wiki/Vertical_Tab U+000B Vertical Tabulation>
-- * @\\@ followed by one to three octal digits → the numeric value (mod 255)
-- * @\\@ followed by any other character → the character as is.
--   For example, @\\\\@ will turn into a backslash (@\\@) and @\\\"@ into a double quote (@\"@).
-- 
-- 
-- 'GI.GLib.Functions.strescape' does the reverse conversion.
strcompress ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@source@/: a string to compress
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated copy of /@source@/ with all escaped
    --   character compressed
strcompress source = liftIO $ do
    source' <- textToCString source
    result <- g_strcompress source'
    checkUnexpectedReturnNULL "strcompress" result
    result' <- cstringToText result
    freeMem result
    freeMem source'
    return result'


-- function strcmp0
-- Args: [ Arg
--           { argCName = "str1"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str2"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_strcmp0" g_strcmp0 :: 
    CString ->                              -- str1 : TBasicType TUTF8
    CString ->                              -- str2 : TBasicType TUTF8
    IO Int32

-- | Compares /@str1@/ and /@str2@/ like @strcmp()@.
-- 
-- Handles @NULL@ gracefully by sorting it before non-@NULL@ strings.
-- Comparing two @NULL@ pointers returns 0.
-- 
-- /Since: 2.16/
strcmp0 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@str1@/: a string
    -> Maybe (T.Text)
    -- ^ /@str2@/: another string
    -> m Int32
    -- ^ __Returns:__ an integer less than, equal to, or greater than zero,
    --   if /@str1@/ is \<, == or > than /@str2@/
strcmp0 str1 str2 = liftIO $ do
    maybeStr1 <- case str1 of
        Nothing -> return FP.nullPtr
        Just jStr1 -> do
            jStr1' <- textToCString jStr1
            return jStr1'
    maybeStr2 <- case str2 of
        Nothing -> return FP.nullPtr
        Just jStr2 -> do
            jStr2' <- textToCString jStr2
            return jStr2'
    result <- g_strcmp0 maybeStr1 maybeStr2
    freeMem maybeStr1
    freeMem maybeStr2
    return result


-- function strchug
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a string to remove the leading whitespace from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strchug" g_strchug :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

-- | Removes leading whitespace from a string, by moving the rest
-- of the characters forward.
-- 
-- This function doesn\'t allocate or reallocate any memory;
-- it modifies /@string@/ in place. Therefore, it cannot be used on
-- statically allocated strings.
-- 
-- The pointer to /@string@/ is returned to allow the nesting of functions.
-- 
-- Also see 'GI.GLib.Functions.strchomp' and @/GLib.strstrip/@.
strchug ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: a string to remove the leading whitespace from
    -> m T.Text
    -- ^ __Returns:__ the modified /@string@/
strchug string = liftIO $ do
    string' <- textToCString string
    result <- g_strchug string'
    checkUnexpectedReturnNULL "strchug" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    return result'


-- function strchomp
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a string to remove the trailing whitespace from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strchomp" g_strchomp :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

-- | Removes trailing whitespace from a string.
-- 
-- This function doesn\'t allocate or reallocate any memory;
-- it modifies /@string@/ in place. Therefore, it cannot be used
-- on statically allocated strings.
-- 
-- The pointer to /@string@/ is returned to allow the nesting of functions.
-- 
-- Also see 'GI.GLib.Functions.strchug' and @/GLib.strstrip/@.
strchomp ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: a string to remove the trailing whitespace from
    -> m T.Text
    -- ^ __Returns:__ the modified /@string@/
strchomp string = liftIO $ do
    string' <- textToCString string
    result <- g_strchomp string'
    checkUnexpectedReturnNULL "strchomp" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    return result'


-- function strcasecmp
-- Args: [ Arg
--           { argCName = "s1"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to compare with @s2"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "s2"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to compare with @s1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_strcasecmp" g_strcasecmp :: 
    CString ->                              -- s1 : TBasicType TUTF8
    CString ->                              -- s2 : TBasicType TUTF8
    IO Int32

{-# DEPRECATED strcasecmp ["(Since version 2.2)","See 'GI.GLib.Functions.strncasecmp' for a discussion of why this","  function is deprecated and how to replace it."] #-}
-- | A case-insensitive string comparison, corresponding to the standard
-- @strcasecmp()@ function on platforms which support it.
strcasecmp ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@s1@/: string to compare with /@s2@/
    -> T.Text
    -- ^ /@s2@/: string to compare with /@s1@/
    -> m Int32
    -- ^ __Returns:__ 0 if the strings match, a negative value if /@s1@/ \< /@s2@/,
    --   or a positive value if /@s1@/ > /@s2@/
strcasecmp s1 s2 = liftIO $ do
    s1' <- textToCString s1
    s2' <- textToCString s2
    result <- g_strcasecmp s1' s2'
    freeMem s1'
    freeMem s2'
    return result


-- function strcanon
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a nul-terminated array of bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "valid_chars"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bytes permitted in @string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "substitutor"
--           , argType = TBasicType TInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "replacement character for disallowed bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strcanon" g_strcanon :: 
    CString ->                              -- string : TBasicType TUTF8
    CString ->                              -- valid_chars : TBasicType TUTF8
    Int8 ->                                 -- substitutor : TBasicType TInt8
    IO CString

-- | For each character in /@string@/, if the character is not in /@validChars@/,
-- replaces the character with /@substitutor@/.
-- 
-- Modifies /@string@/ in place, and return /@string@/ itself, not a copy. The
-- return value is to allow nesting such as:
-- 
-- === /C code/
-- >g_ascii_strup (g_strcanon (str, "abc", '?'))
-- 
-- 
-- In order to modify a copy, you may use 'GI.GLib.Functions.strdup':
-- 
-- === /C code/
-- >reformatted = g_strcanon (g_strdup (const_str), "abc", '?');
-- >…
-- >g_free (reformatted);
strcanon ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: a nul-terminated array of bytes
    -> T.Text
    -- ^ /@validChars@/: bytes permitted in /@string@/
    -> Int8
    -- ^ /@substitutor@/: replacement character for disallowed bytes
    -> m T.Text
    -- ^ __Returns:__ the modified /@string@/
strcanon string validChars substitutor = liftIO $ do
    string' <- textToCString string
    validChars' <- textToCString validChars
    result <- g_strcanon string' validChars' substitutor
    checkUnexpectedReturnNULL "strcanon" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    freeMem validChars'
    return result'


-- function str_tokenize_and_fold
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to tokenize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "translit_locale"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the language code (like 'de' or\n  'en_GB') from which @string originates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ascii_alternates"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "\n  a return location for ASCII alternates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_str_tokenize_and_fold" g_str_tokenize_and_fold :: 
    CString ->                              -- string : TBasicType TUTF8
    CString ->                              -- translit_locale : TBasicType TUTF8
    Ptr (Ptr CString) ->                    -- ascii_alternates : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr CString)

-- | Tokenizes /@string@/ and performs folding on each token.
-- 
-- A token is a non-empty sequence of alphanumeric characters in the
-- source string, separated by non-alphanumeric characters.  An
-- \"alphanumeric\" character for this purpose is one that matches
-- 'GI.GLib.Functions.unicharIsalnum' or 'GI.GLib.Functions.unicharIsmark'.
-- 
-- Each token is then (Unicode) normalised and case-folded.  If
-- /@asciiAlternates@/ is non-@NULL@ and some of the returned tokens
-- contain non-ASCII characters, ASCII alternatives will be generated.
-- 
-- The number of ASCII alternatives that are generated and the method
-- for doing so is unspecified, but /@translitLocale@/ (if specified) may
-- improve the transliteration if the language of the source string is
-- known.
-- 
-- /Since: 2.40/
strTokenizeAndFold ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: a string to tokenize
    -> Maybe (T.Text)
    -- ^ /@translitLocale@/: the language code (like \'de\' or
    --   \'en_GB\') from which /@string@/ originates
    -> m (([T.Text], [T.Text]))
    -- ^ __Returns:__ the folded tokens
strTokenizeAndFold string translitLocale = liftIO $ do
    string' <- textToCString string
    maybeTranslitLocale <- case translitLocale of
        Nothing -> return FP.nullPtr
        Just jTranslitLocale -> do
            jTranslitLocale' <- textToCString jTranslitLocale
            return jTranslitLocale'
    asciiAlternates <- callocMem :: IO (Ptr (Ptr CString))
    result <- g_str_tokenize_and_fold string' maybeTranslitLocale asciiAlternates
    checkUnexpectedReturnNULL "strTokenizeAndFold" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    asciiAlternates' <- peek asciiAlternates
    asciiAlternates'' <- unpackZeroTerminatedUTF8CArray asciiAlternates'
    mapZeroTerminatedCArray freeMem asciiAlternates'
    freeMem asciiAlternates'
    freeMem string'
    freeMem maybeTranslitLocale
    freeMem asciiAlternates
    return (result', asciiAlternates'')


-- function str_to_ascii
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string, in UTF-8" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "from_locale"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the source locale, if known"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_str_to_ascii" g_str_to_ascii :: 
    CString ->                              -- str : TBasicType TUTF8
    CString ->                              -- from_locale : TBasicType TUTF8
    IO CString

-- | Transliterate /@str@/ to plain ASCII.
-- 
-- For best results, /@str@/ should be in composed normalised form.
-- 
-- This function performs a reasonably good set of character
-- replacements.  The particular set of replacements that is done may
-- change by version or even by runtime environment.
-- 
-- If the source language of /@str@/ is known, it can used to improve the
-- accuracy of the translation by passing it as /@fromLocale@/.  It should
-- be a valid POSIX locale string (of the form
-- @language[_territory][.codeset][\@modifier]@).
-- 
-- If /@fromLocale@/ is 'P.Nothing' then the current locale is used.
-- 
-- If you want to do translation for no specific locale, and you want it
-- to be done independently of the currently locale, specify @\"C\"@ for
-- /@fromLocale@/.
-- 
-- /Since: 2.40/
strToAscii ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a string, in UTF-8
    -> Maybe (T.Text)
    -- ^ /@fromLocale@/: the source locale, if known
    -> m T.Text
    -- ^ __Returns:__ a string in plain ASCII
strToAscii str fromLocale = liftIO $ do
    str' <- textToCString str
    maybeFromLocale <- case fromLocale of
        Nothing -> return FP.nullPtr
        Just jFromLocale -> do
            jFromLocale' <- textToCString jFromLocale
            return jFromLocale'
    result <- g_str_to_ascii str' maybeFromLocale
    checkUnexpectedReturnNULL "strToAscii" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    freeMem maybeFromLocale
    return result'


-- function str_match_string
-- Args: [ Arg
--           { argCName = "search_term"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the search term from the user"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "potential_hit"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text that may be a hit"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accept_alternates"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "if true, ASCII alternates are accepted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_str_match_string" g_str_match_string :: 
    CString ->                              -- search_term : TBasicType TUTF8
    CString ->                              -- potential_hit : TBasicType TUTF8
    CInt ->                                 -- accept_alternates : TBasicType TBoolean
    IO CInt

-- | Checks if a search conducted for /@searchTerm@/ should match
-- /@potentialHit@/.
-- 
-- This function calls 'GI.GLib.Functions.strTokenizeAndFold' on both
-- /@searchTerm@/ and /@potentialHit@/. ASCII alternates are never taken
-- for /@searchTerm@/ but will be taken for /@potentialHit@/ according to
-- the value of /@acceptAlternates@/.
-- 
-- A hit occurs when each folded token in /@searchTerm@/ is a prefix of a
-- folded token from /@potentialHit@/.
-- 
-- Depending on how you\'re performing the search, it will typically be
-- faster to call @g_str_tokenize_and_fold()@ on each string in
-- your corpus and build an index on the returned folded tokens, then
-- call @g_str_tokenize_and_fold()@ on the search term and
-- perform lookups into that index.
-- 
-- As some examples, searching for ‘fred’ would match the potential hit
-- ‘Smith, Fred’ and also ‘Frédéric’.  Searching for ‘Fréd’ would match
-- ‘Frédéric’ but not ‘Frederic’ (due to the one-directional nature of
-- accent matching).  Searching ‘fo’ would match ‘Foo’ and ‘Bar Foo
-- Baz’, but not ‘SFO’ (because no word has ‘fo’ as a prefix).
-- 
-- /Since: 2.40/
strMatchString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@searchTerm@/: the search term from the user
    -> T.Text
    -- ^ /@potentialHit@/: the text that may be a hit
    -> Bool
    -- ^ /@acceptAlternates@/: if true, ASCII alternates are accepted
    -> m Bool
    -- ^ __Returns:__ true if /@potentialHit@/ is a hit
strMatchString searchTerm potentialHit acceptAlternates = liftIO $ do
    searchTerm' <- textToCString searchTerm
    potentialHit' <- textToCString potentialHit
    let acceptAlternates' = (P.fromIntegral . P.fromEnum) acceptAlternates
    result <- g_str_match_string searchTerm' potentialHit' acceptAlternates'
    let result' = (/= 0) result
    freeMem searchTerm'
    freeMem potentialHit'
    return result'


-- function str_is_ascii
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_str_is_ascii" g_str_is_ascii :: 
    CString ->                              -- str : TBasicType TUTF8
    IO CInt

-- | Determines if a string is pure ASCII. A string is pure ASCII if it
-- contains no bytes with the high bit set.
-- 
-- /Since: 2.40/
strIsAscii ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a string
    -> m Bool
    -- ^ __Returns:__ true if /@str@/ is ASCII
strIsAscii str = liftIO $ do
    str' <- textToCString str
    result <- g_str_is_ascii str'
    let result' = (/= 0) result
    freeMem str'
    return result'


-- function str_hash
-- Args: [ Arg
--           { argCName = "v"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string key" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_str_hash" g_str_hash :: 
    Ptr () ->                               -- v : TBasicType TPtr
    IO Word32

-- | Converts a string to a hash value.
-- 
-- This function implements the widely used \"djb\" hash apparently
-- posted by Daniel Bernstein to comp.lang.c some time ago.  The 32
-- bit unsigned hash value starts at 5381 and for each byte \'c\' in
-- the string, is updated: @hash = hash * 33 + c@. This function
-- uses the signed value of each byte.
-- 
-- It can be passed to @/g_hash_table_new()/@ as the /@hashFunc@/ parameter,
-- when using non-'P.Nothing' strings as keys in a t'GI.GLib.Structs.HashTable.HashTable'.
-- 
-- Note that this function may not be a perfect fit for all use cases.
-- For example, it produces some hash collisions with strings as short
-- as 2.
strHash ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@v@/: a string key
    -> m Word32
    -- ^ __Returns:__ a hash value corresponding to the key
strHash v = liftIO $ do
    result <- g_str_hash v
    return result


-- function str_has_suffix
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to look in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "suffix"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the suffix to look for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_str_has_suffix" g_str_has_suffix :: 
    CString ->                              -- str : TBasicType TUTF8
    CString ->                              -- suffix : TBasicType TUTF8
    IO CInt

-- | Looks whether a string ends with /@suffix@/.
-- 
-- /Since: 2.2/
strHasSuffix ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a string to look in
    -> T.Text
    -- ^ /@suffix@/: the suffix to look for
    -> m Bool
    -- ^ __Returns:__ true if /@str@/ ends with /@suffix@/, false otherwise
strHasSuffix str suffix = liftIO $ do
    str' <- textToCString str
    suffix' <- textToCString suffix
    result <- g_str_has_suffix str' suffix'
    let result' = (/= 0) result
    freeMem str'
    freeMem suffix'
    return result'


-- function str_has_prefix
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to look in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "prefix"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the prefix to look for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_str_has_prefix" g_str_has_prefix :: 
    CString ->                              -- str : TBasicType TUTF8
    CString ->                              -- prefix : TBasicType TUTF8
    IO CInt

-- | Looks whether the string /@str@/ begins with /@prefix@/.
-- 
-- /Since: 2.2/
strHasPrefix ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a string to look in
    -> T.Text
    -- ^ /@prefix@/: the prefix to look for
    -> m Bool
    -- ^ __Returns:__ true if /@str@/ begins with /@prefix@/, false otherwise
strHasPrefix str prefix = liftIO $ do
    str' <- textToCString str
    prefix' <- textToCString prefix
    result <- g_str_has_prefix str' prefix'
    let result' = (/= 0) result
    freeMem str'
    freeMem prefix'
    return result'


-- function str_equal
-- Args: [ Arg
--           { argCName = "v1"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "v2"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key to compare with @v1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_str_equal" g_str_equal :: 
    Ptr () ->                               -- v1 : TBasicType TPtr
    Ptr () ->                               -- v2 : TBasicType TPtr
    IO CInt

-- | Compares two strings for byte-by-byte equality and returns 'P.True'
-- if they are equal. It can be passed to @/g_hash_table_new()/@ as the
-- /@keyEqualFunc@/ parameter, when using non-'P.Nothing' strings as keys in a
-- t'GI.GLib.Structs.HashTable.HashTable'.
-- 
-- This function is typically used for hash table comparisons, but can be used
-- for general purpose comparisons of non-'P.Nothing' strings. For a 'P.Nothing'-safe string
-- comparison function, see 'GI.GLib.Functions.strcmp0'.
strEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@v1@/: a key
    -> Ptr ()
    -- ^ /@v2@/: a key to compare with /@v1@/
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the two keys match
strEqual v1 v2 = liftIO $ do
    result <- g_str_equal v1 v2
    let result' = (/= 0) result
    return result'


-- function stpcpy
-- Args: [ Arg
--           { argCName = "dest"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destination buffer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "source string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_stpcpy" g_stpcpy :: 
    CString ->                              -- dest : TBasicType TUTF8
    CString ->                              -- src : TBasicType TUTF8
    IO CString

-- | Copies a nul-terminated string into the destination buffer, including
-- the trailing nul byte, and returns a pointer to the trailing nul byte
-- in @dest@.  The return value is useful for concatenating multiple
-- strings without having to repeatedly scan for the end.
stpcpy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@dest@/: destination buffer
    -> T.Text
    -- ^ /@src@/: source string
    -> m T.Text
    -- ^ __Returns:__ a pointer to the trailing nul byte in @dest@
stpcpy dest src = liftIO $ do
    dest' <- textToCString dest
    src' <- textToCString src
    result <- g_stpcpy dest' src'
    checkUnexpectedReturnNULL "stpcpy" result
    result' <- cstringToText result
    freeMem result
    freeMem dest'
    freeMem src'
    return result'


-- function stat
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buf"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StatBuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to a stat struct, which will be filled with the file\n    information"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_stat" g_stat :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr GLib.StatBuf.StatBuf ->             -- buf : TInterface (Name {namespace = "GLib", name = "StatBuf"})
    IO Int32

-- | A wrapper for the POSIX @/stat()/@ function. The @/stat()/@ function
-- returns information about a file. On Windows the @/stat()/@ function in
-- the C library checks only the FAT-style READONLY attribute and does
-- not look at the ACL at all. Thus on Windows the protection bits in
-- the /@stMode@/ field are a fabrication of little use.
-- 
-- On Windows the Microsoft C libraries have several variants of the
-- stat struct and @/stat()/@ function with names like @/_stat()/@, @/_stat32()/@,
-- @/_stat32i64()/@ and @/_stat64i32()/@. The one used here is for 32-bit code
-- the one with 32-bit size and time fields, specifically called @/_stat32()/@.
-- 
-- In Microsoft\'s compiler, by default struct stat means one with
-- 64-bit time fields while in MinGW struct stat is the legacy one
-- with 32-bit fields. To hopefully clear up this messs, the gstdio.h
-- header defines a type t'GI.GLib.Structs.StatBuf.StatBuf' which is the appropriate struct type
-- depending on the platform and\/or compiler being used. On POSIX it
-- is just struct stat, but note that even on POSIX platforms, @/stat()/@
-- might be a macro.
-- 
-- See your C library manual for more details about @/stat()/@.
-- 
-- /Since: 2.6/
stat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> GLib.StatBuf.StatBuf
    -- ^ /@buf@/: a pointer to a stat struct, which will be filled with the file
    --     information
    -> m Int32
    -- ^ __Returns:__ 0 if the information was successfully retrieved,
    --     -1 if an error occurred
stat filename buf = liftIO $ do
    filename' <- stringToCString filename
    buf' <- unsafeManagedPtrGetPtr buf
    result <- g_stat filename' buf'
    touchManagedPtr buf
    freeMem filename'
    return result


-- function spawn_sync
-- Args: [ Arg
--           { argCName = "working_directory"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's current working\n    directory, or %NULL to inherit parent's"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n    child's argument vector, which must be non-empty and %NULL-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "\n    child's environment, or %NULL to inherit parent's"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SpawnFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags from #GSpawnFlags"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_setup"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SpawnChildSetupFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to run\n    in the child just before `exec()`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for @child_setup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "standard_output"
--           , argType = TCArray True (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for child output, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "standard_error"
--           , argType = TCArray True (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for child error messages, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "wait_status"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for child wait status, as returned by waitpid(), or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_sync" g_spawn_sync :: 
    CString ->                              -- working_directory : TBasicType TFileName
    Ptr CString ->                          -- argv : TCArray True (-1) (-1) (TBasicType TFileName)
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TFileName)
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "SpawnFlags"})
    FunPtr GLib.Callbacks.C_SpawnChildSetupFunc -> -- child_setup : TInterface (Name {namespace = "GLib", name = "SpawnChildSetupFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    Ptr (Ptr Word8) ->                      -- standard_output : TCArray True (-1) (-1) (TBasicType TUInt8)
    Ptr (Ptr Word8) ->                      -- standard_error : TCArray True (-1) (-1) (TBasicType TUInt8)
    Ptr Int32 ->                            -- wait_status : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Executes a child synchronously (waits for the child to exit before returning).
-- 
-- All output from the child is stored in /@standardOutput@/ and /@standardError@/,
-- if those parameters are non-'P.Nothing'. Note that you must set the
-- 'GI.GLib.Flags.SpawnFlagsStdoutToDevNull' and 'GI.GLib.Flags.SpawnFlagsStderrToDevNull' flags when
-- passing 'P.Nothing' for /@standardOutput@/ and /@standardError@/.
-- 
-- If /@waitStatus@/ is non-'P.Nothing', the platform-specific status of
-- the child is stored there; see the documentation of
-- 'GI.GLib.Functions.spawnCheckWaitStatus' for how to use and interpret this.
-- On Unix platforms, note that it is usually not equal
-- to the integer passed to @exit()@ or returned from @main()@.
-- 
-- Note that it is invalid to pass 'GI.GLib.Flags.SpawnFlagsDoNotReapChild' in
-- /@flags@/, and on POSIX platforms, the same restrictions as for
-- 'GI.GLib.Functions.childWatchSourceNew' apply.
-- 
-- If an error occurs, no data is returned in /@standardOutput@/,
-- /@standardError@/, or /@waitStatus@/.
-- 
-- This function calls 'GI.GLib.Functions.spawnAsyncWithPipes' internally; see that
-- function for full details on the other parameters and details on
-- how these functions work on Windows.
spawnSync ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@workingDirectory@/: child\'s current working
    --     directory, or 'P.Nothing' to inherit parent\'s
    -> [[Char]]
    -- ^ /@argv@/: 
    --     child\'s argument vector, which must be non-empty and 'P.Nothing'-terminated
    -> Maybe ([[Char]])
    -- ^ /@envp@/: 
    --     child\'s environment, or 'P.Nothing' to inherit parent\'s
    -> [GLib.Flags.SpawnFlags]
    -- ^ /@flags@/: flags from t'GI.GLib.Flags.SpawnFlags'
    -> Maybe (GLib.Callbacks.SpawnChildSetupFunc)
    -- ^ /@childSetup@/: function to run
    --     in the child just before @exec()@
    -> m ((ByteString, ByteString, Int32))
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnSync workingDirectory argv envp flags childSetup = liftIO $ do
    maybeWorkingDirectory <- case workingDirectory of
        Nothing -> return FP.nullPtr
        Just jWorkingDirectory -> do
            jWorkingDirectory' <- stringToCString jWorkingDirectory
            return jWorkingDirectory'
    argv' <- packZeroTerminatedFileNameArray argv
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedFileNameArray jEnvp
            return jEnvp'
    let flags' = gflagsToWord flags
    maybeChildSetup <- case childSetup of
        Nothing -> return FP.nullFunPtr
        Just jChildSetup -> do
            jChildSetup' <- GLib.Callbacks.mk_SpawnChildSetupFunc (GLib.Callbacks.wrap_SpawnChildSetupFunc Nothing jChildSetup)
            return jChildSetup'
    standardOutput <- callocMem :: IO (Ptr (Ptr Word8))
    standardError <- callocMem :: IO (Ptr (Ptr Word8))
    waitStatus <- allocMem :: IO (Ptr Int32)
    let userData = nullPtr
    onException (do
        _ <- propagateGError $ g_spawn_sync maybeWorkingDirectory argv' maybeEnvp flags' maybeChildSetup userData standardOutput standardError waitStatus
        standardOutput' <- peek standardOutput
        standardOutput'' <- unpackZeroTerminatedByteString standardOutput'
        freeMem standardOutput'
        standardError' <- peek standardError
        standardError'' <- unpackZeroTerminatedByteString standardError'
        freeMem standardError'
        waitStatus' <- peek waitStatus
        safeFreeFunPtr $ castFunPtrToPtr maybeChildSetup
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem standardOutput
        freeMem standardError
        freeMem waitStatus
        return (standardOutput'', standardError'', waitStatus')
     ) (do
        safeFreeFunPtr $ castFunPtrToPtr maybeChildSetup
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem standardOutput
        freeMem standardError
        freeMem waitStatus
     )


-- function spawn_exit_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_spawn_exit_error_quark" g_spawn_exit_error_quark :: 
    IO Word32

-- | /No description available in the introspection data./
spawnExitErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
spawnExitErrorQuark  = liftIO $ do
    result <- g_spawn_exit_error_quark
    return result


-- function spawn_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_spawn_error_quark" g_spawn_error_quark :: 
    IO Word32

-- | /No description available in the introspection data./
spawnErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
spawnErrorQuark  = liftIO $ do
    result <- g_spawn_error_quark
    return result


-- function spawn_command_line_sync
-- Args: [ Arg
--           { argCName = "command_line"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a command line" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "standard_output"
--           , argType = TCArray True (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for child output"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "standard_error"
--           , argType = TCArray True (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for child errors"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "wait_status"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for child wait status, as returned by waitpid()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_command_line_sync" g_spawn_command_line_sync :: 
    CString ->                              -- command_line : TBasicType TFileName
    Ptr (Ptr Word8) ->                      -- standard_output : TCArray True (-1) (-1) (TBasicType TUInt8)
    Ptr (Ptr Word8) ->                      -- standard_error : TCArray True (-1) (-1) (TBasicType TUInt8)
    Ptr Int32 ->                            -- wait_status : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | A simple version of 'GI.GLib.Functions.spawnSync' with little-used parameters
-- removed, taking a command line instead of an argument vector.
-- 
-- See 'GI.GLib.Functions.spawnSync' for full details.
-- 
-- The /@commandLine@/ argument will be parsed by 'GI.GLib.Functions.shellParseArgv'.
-- 
-- Unlike 'GI.GLib.Functions.spawnSync', the 'GI.GLib.Flags.SpawnFlagsSearchPath' flag is enabled.
-- Note that 'GI.GLib.Flags.SpawnFlagsSearchPath' can have security implications, so
-- consider using 'GI.GLib.Functions.spawnSync' directly if appropriate.
-- 
-- Possible errors are those from 'GI.GLib.Functions.spawnSync' and those
-- from 'GI.GLib.Functions.shellParseArgv'.
-- 
-- If /@waitStatus@/ is non-'P.Nothing', the platform-specific status of
-- the child is stored there; see the documentation of
-- 'GI.GLib.Functions.spawnCheckWaitStatus' for how to use and interpret this.
-- On Unix platforms, note that it is usually not equal
-- to the integer passed to @exit()@ or returned from @main()@.
-- 
-- On Windows, please note the implications of 'GI.GLib.Functions.shellParseArgv'
-- parsing /@commandLine@/. Parsing is done according to Unix shell rules, not
-- Windows command interpreter rules.
-- Space is a separator, and backslashes are
-- special. Thus you cannot simply pass a /@commandLine@/ containing
-- canonical Windows paths, like \"c:\\program files\\app\\app.exe\", as
-- the backslashes will be eaten, and the space will act as a
-- separator. You need to enclose such paths with single quotes, like
-- \"\'c:\\program files\\app\\app.exe\' \'e:\\folder\\argument.txt\'\".
spawnCommandLineSync ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@commandLine@/: a command line
    -> m ((ByteString, ByteString, Int32))
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnCommandLineSync commandLine = liftIO $ do
    commandLine' <- stringToCString commandLine
    standardOutput <- callocMem :: IO (Ptr (Ptr Word8))
    standardError <- callocMem :: IO (Ptr (Ptr Word8))
    waitStatus <- allocMem :: IO (Ptr Int32)
    onException (do
        _ <- propagateGError $ g_spawn_command_line_sync commandLine' standardOutput standardError waitStatus
        standardOutput' <- peek standardOutput
        standardOutput'' <- unpackZeroTerminatedByteString standardOutput'
        freeMem standardOutput'
        standardError' <- peek standardError
        standardError'' <- unpackZeroTerminatedByteString standardError'
        freeMem standardError'
        waitStatus' <- peek waitStatus
        freeMem commandLine'
        freeMem standardOutput
        freeMem standardError
        freeMem waitStatus
        return (standardOutput'', standardError'', waitStatus')
     ) (do
        freeMem commandLine'
        freeMem standardOutput
        freeMem standardError
        freeMem waitStatus
     )


-- function spawn_command_line_async
-- Args: [ Arg
--           { argCName = "command_line"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a command line" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_command_line_async" g_spawn_command_line_async :: 
    CString ->                              -- command_line : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | A simple version of 'GI.GLib.Functions.spawnAsync' that parses a command line with
-- 'GI.GLib.Functions.shellParseArgv' and passes it to 'GI.GLib.Functions.spawnAsync'.
-- 
-- Runs a command line in the background. Unlike 'GI.GLib.Functions.spawnAsync', the
-- 'GI.GLib.Flags.SpawnFlagsSearchPath' flag is enabled, other flags are not. Note
-- that 'GI.GLib.Flags.SpawnFlagsSearchPath' can have security implications, so
-- consider using 'GI.GLib.Functions.spawnAsync' directly if appropriate. Possible
-- errors are those from 'GI.GLib.Functions.shellParseArgv' and 'GI.GLib.Functions.spawnAsync'.
-- 
-- The same concerns on Windows apply as for 'GI.GLib.Functions.spawnCommandLineSync'.
spawnCommandLineAsync ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@commandLine@/: a command line
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnCommandLineAsync commandLine = liftIO $ do
    commandLine' <- stringToCString commandLine
    onException (do
        _ <- propagateGError $ g_spawn_command_line_async commandLine'
        freeMem commandLine'
        return ()
     ) (do
        freeMem commandLine'
     )


-- function spawn_close_pid
-- Args: [ Arg
--           { argCName = "pid"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The process reference to close"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_spawn_close_pid" g_spawn_close_pid :: 
    Int32 ->                                -- pid : TBasicType TInt
    IO ()

-- | On some platforms, notably Windows, the @/GPid/@ type represents a resource
-- which must be closed to prevent resource leaking. 'GI.GLib.Functions.spawnClosePid'
-- is provided for this purpose. It should be used on all platforms, even
-- though it doesn\'t do anything under UNIX.
spawnClosePid ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@pid@/: The process reference to close
    -> m ()
spawnClosePid pid = liftIO $ do
    g_spawn_close_pid pid
    return ()


-- function spawn_check_wait_status
-- Args: [ Arg
--           { argCName = "wait_status"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A platform-specific wait status as returned from g_spawn_sync()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_check_wait_status" g_spawn_check_wait_status :: 
    Int32 ->                                -- wait_status : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Set /@error@/ if /@waitStatus@/ indicates the child exited abnormally
-- (e.g. with a nonzero exit code, or via a fatal signal).
-- 
-- The 'GI.GLib.Functions.spawnSync' and @/g_child_watch_add()/@ family of APIs return the
-- status of subprocesses encoded in a platform-specific way.
-- On Unix, this is guaranteed to be in the same format @/waitpid()/@ returns,
-- and on Windows it is guaranteed to be the result of @/GetExitCodeProcess()/@.
-- 
-- Prior to the introduction of this function in GLib 2.34, interpreting
-- /@waitStatus@/ required use of platform-specific APIs, which is problematic
-- for software using GLib as a cross-platform layer.
-- 
-- Additionally, many programs simply want to determine whether or not
-- the child exited successfully, and either propagate a t'GError' or
-- print a message to standard error. In that common case, this function
-- can be used. Note that the error message in /@error@/ will contain
-- human-readable information about the wait status.
-- 
-- The /@domain@/ and /@code@/ of /@error@/ have special semantics in the case
-- where the process has an \"exit code\", as opposed to being killed by
-- a signal. On Unix, this happens if @/WIFEXITED()/@ would be true of
-- /@waitStatus@/. On Windows, it is always the case.
-- 
-- The special semantics are that the actual exit code will be the
-- code set in /@error@/, and the domain will be @/G_SPAWN_EXIT_ERROR/@.
-- This allows you to differentiate between different exit codes.
-- 
-- If the process was terminated by some means other than an exit
-- status (for example if it was killed by a signal), the domain will be
-- @/G_SPAWN_ERROR/@ and the code will be 'GI.GLib.Enums.SpawnErrorFailed'.
-- 
-- This function just offers convenience; you can of course also check
-- the available platform via a macro such as @/G_OS_UNIX/@, and use
-- @/WIFEXITED()/@ and @/WEXITSTATUS()/@ on /@waitStatus@/ directly. Do not attempt
-- to scan or parse the error message string; it may be translated and\/or
-- change in future versions of GLib.
-- 
-- Prior to version 2.70, 'GI.GLib.Functions.spawnCheckExitStatus' provides the same
-- functionality, although under a misleading name.
-- 
-- /Since: 2.70/
spawnCheckWaitStatus ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@waitStatus@/: A platform-specific wait status as returned from 'GI.GLib.Functions.spawnSync'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnCheckWaitStatus waitStatus = liftIO $ do
    onException (do
        _ <- propagateGError $ g_spawn_check_wait_status waitStatus
        return ()
     ) (do
        return ()
     )


-- function spawn_check_exit_status
-- Args: [ Arg
--           { argCName = "wait_status"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A status as returned from g_spawn_sync()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_check_exit_status" g_spawn_check_exit_status :: 
    Int32 ->                                -- wait_status : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED spawnCheckExitStatus ["(Since version 2.70)","Use 'GI.GLib.Functions.spawnCheckWaitStatus' instead, and check whether your code is conflating wait and exit statuses."] #-}
-- | An old name for 'GI.GLib.Functions.spawnCheckWaitStatus', deprecated because its
-- name is misleading.
-- 
-- Despite the name of the function, /@waitStatus@/ must be the wait status
-- as returned by 'GI.GLib.Functions.spawnSync', @/g_subprocess_get_status()/@, @waitpid()@,
-- etc. On Unix platforms, it is incorrect for it to be the exit status
-- as passed to @exit()@ or returned by @/g_subprocess_get_exit_status()/@ or
-- @WEXITSTATUS()@.
-- 
-- /Since: 2.34/
spawnCheckExitStatus ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@waitStatus@/: A status as returned from 'GI.GLib.Functions.spawnSync'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnCheckExitStatus waitStatus = liftIO $ do
    onException (do
        _ <- propagateGError $ g_spawn_check_exit_status waitStatus
        return ()
     ) (do
        return ()
     )


-- function spawn_async_with_pipes_and_fds
-- Args: [ Arg
--           { argCName = "working_directory"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's current working\n    directory, or %NULL to inherit parent's, in the GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's argument\n    vector, in the GLib file name encoding; it must be non-empty and %NULL-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n    child's environment, or %NULL to inherit parent's, in the GLib file\n    name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SpawnFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags from #GSpawnFlags"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_setup"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SpawnChildSetupFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to run\n    in the child just before `exec()`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for @child_setup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stdin_fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "file descriptor to use for child's stdin, or `-1`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stdout_fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "file descriptor to use for child's stdout, or `-1`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stderr_fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "file descriptor to use for child's stderr, or `-1`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_fds"
--           , argType = TCArray False (-1) 11 (TBasicType TInt)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "array of FDs from the parent\n   process to make available in the child process"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target_fds"
--           , argType = TCArray False (-1) 11 (TBasicType TInt)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "array of FDs to remap\n   @source_fds to in the child process"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fds"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of FDs in @source_fds and @target_fds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_pid_out"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for child process ID, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "stdin_pipe_out"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for file descriptor to write to child's stdin, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "stdout_pipe_out"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for file descriptor to read child's stdout, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "stderr_pipe_out"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for file descriptor to read child's stderr, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fds"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of FDs in @source_fds and @target_fds"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          , Arg
--              { argCName = "n_fds"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of FDs in @source_fds and @target_fds"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_async_with_pipes_and_fds" g_spawn_async_with_pipes_and_fds :: 
    CString ->                              -- working_directory : TBasicType TFileName
    Ptr CString ->                          -- argv : TCArray True (-1) (-1) (TBasicType TFileName)
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TFileName)
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "SpawnFlags"})
    FunPtr GLib.Callbacks.C_SpawnChildSetupFunc -> -- child_setup : TInterface (Name {namespace = "GLib", name = "SpawnChildSetupFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    Int32 ->                                -- stdin_fd : TBasicType TInt
    Int32 ->                                -- stdout_fd : TBasicType TInt
    Int32 ->                                -- stderr_fd : TBasicType TInt
    Ptr Int32 ->                            -- source_fds : TCArray False (-1) 11 (TBasicType TInt)
    Ptr Int32 ->                            -- target_fds : TCArray False (-1) 11 (TBasicType TInt)
    FCT.CSize ->                            -- n_fds : TBasicType TSize
    Ptr Int32 ->                            -- child_pid_out : TBasicType TInt
    Ptr Int32 ->                            -- stdin_pipe_out : TBasicType TInt
    Ptr Int32 ->                            -- stdout_pipe_out : TBasicType TInt
    Ptr Int32 ->                            -- stderr_pipe_out : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Executes a child program asynchronously (your program will not
-- block waiting for the child to exit).
-- 
-- The child program is specified by the only argument that must be
-- provided, /@argv@/. /@argv@/ should be a 'P.Nothing'-terminated array of strings,
-- to be passed as the argument vector for the child. The first string
-- in /@argv@/ is of course the name of the program to execute. By default,
-- the name of the program must be a full path. If /@flags@/ contains the
-- 'GI.GLib.Flags.SpawnFlagsSearchPath' flag, the @PATH@ environment variable is used to
-- search for the executable. If /@flags@/ contains the
-- 'GI.GLib.Flags.SpawnFlagsSearchPathFromEnvp' flag, the @PATH@ variable from /@envp@/
-- is used to search for the executable. If both the
-- 'GI.GLib.Flags.SpawnFlagsSearchPath' and 'GI.GLib.Flags.SpawnFlagsSearchPathFromEnvp' flags are
-- set, the @PATH@ variable from /@envp@/ takes precedence over the
-- environment variable.
-- 
-- If the program name is not a full path and 'GI.GLib.Flags.SpawnFlagsSearchPath' flag
-- is not used, then the program will be run from the current directory
-- (or /@workingDirectory@/, if specified); this might be unexpected or even
-- dangerous in some cases when the current directory is world-writable.
-- 
-- On Windows, note that all the string or string vector arguments to
-- this function and the other @g_spawn*()@ functions are in UTF-8, the
-- GLib file name encoding. Unicode characters that are not part of
-- the system codepage passed in these arguments will be correctly
-- available in the spawned program only if it uses wide character API
-- to retrieve its command line. For C programs built with Microsoft\'s
-- tools it is enough to make the program have a @wmain()@ instead of
-- @main()@. @wmain()@ has a wide character argument vector as parameter.
-- 
-- At least currently, mingw doesn\'t support @wmain()@, so if you use
-- mingw to develop the spawned program, it should call
-- @/g_win32_get_command_line()/@ to get arguments in UTF-8.
-- 
-- On Windows the low-level child process creation API @CreateProcess()@
-- doesn\'t use argument vectors, but a command line. The C runtime
-- library\'s @spawn*()@ family of functions (which 'GI.GLib.Functions.spawnAsyncWithPipes'
-- eventually calls) paste the argument vector elements together into
-- a command line, and the C runtime startup code does a corresponding
-- reconstruction of an argument vector from the command line, to be
-- passed to @main()@. Complications arise when you have argument vector
-- elements that contain spaces or double quotes. The @spawn*()@ functions
-- don\'t do any quoting or escaping, but on the other hand the startup
-- code does do unquoting and unescaping in order to enable receiving
-- arguments with embedded spaces or double quotes. To work around this
-- asymmetry, 'GI.GLib.Functions.spawnAsyncWithPipes' will do quoting and escaping on
-- argument vector elements that need it before calling the C runtime
-- @spawn()@ function.
-- 
-- The returned /@childPid@/ on Windows is a handle to the child
-- process, not its identifier. Process handles and process
-- identifiers are different concepts on Windows.
-- 
-- /@envp@/ is a 'P.Nothing'-terminated array of strings, where each string
-- has the form @KEY=VALUE@. This will become the child\'s environment.
-- If /@envp@/ is 'P.Nothing', the child inherits its parent\'s environment.
-- 
-- /@flags@/ should be the bitwise OR of any flags you want to affect the
-- function\'s behaviour. The 'GI.GLib.Flags.SpawnFlagsDoNotReapChild' means that the
-- child will not automatically be reaped; you must use a child watch
-- (@/g_child_watch_add()/@) to be notified about the death of the child process,
-- otherwise it will stay around as a zombie process until this process exits.
-- Eventually you must call 'GI.GLib.Functions.spawnClosePid' on the /@childPid@/, in order to
-- free resources which may be associated with the child process. (On Unix,
-- using a child watch is equivalent to calling @/waitpid()/@ or handling
-- the @SIGCHLD@ signal manually. On Windows, calling 'GI.GLib.Functions.spawnClosePid'
-- is equivalent to calling @CloseHandle()@ on the process handle returned
-- in /@childPid@/). See @/g_child_watch_add()/@.
-- 
-- Open UNIX file descriptors marked as @FD_CLOEXEC@ will be automatically
-- closed in the child process. 'GI.GLib.Flags.SpawnFlagsLeaveDescriptorsOpen' means that
-- other open file descriptors will be inherited by the child; otherwise all
-- descriptors except stdin\/stdout\/stderr will be closed before calling @exec()@
-- in the child. 'GI.GLib.Flags.SpawnFlagsSearchPath' means that /@argv@/[0] need not be an
-- absolute path, it will be looked for in the @PATH@ environment
-- variable. 'GI.GLib.Flags.SpawnFlagsSearchPathFromEnvp' means need not be an
-- absolute path, it will be looked for in the @PATH@ variable from
-- /@envp@/. If both 'GI.GLib.Flags.SpawnFlagsSearchPath' and 'GI.GLib.Flags.SpawnFlagsSearchPathFromEnvp'
-- are used, the value from /@envp@/ takes precedence over the environment.
-- 
-- 'GI.GLib.Flags.SpawnFlagsChildInheritsStdin' means that the child will inherit the parent\'s
-- standard input (by default, the child\'s standard input is attached to
-- @\/dev\/null@). 'GI.GLib.Flags.SpawnFlagsStdinFromDevNull' explicitly imposes the default
-- behavior. Both flags cannot be enabled at the same time and, in both cases,
-- the /@stdinPipeOut@/ argument is ignored.
-- 
-- 'GI.GLib.Flags.SpawnFlagsStdoutToDevNull' means that the child\'s standard output
-- will be discarded (by default, it goes to the same location as the parent\'s
-- standard output). 'GI.GLib.Flags.SpawnFlagsChildInheritsStdout' explicitly imposes the
-- default behavior. Both flags cannot be enabled at the same time and, in
-- both cases, the /@stdoutPipeOut@/ argument is ignored.
-- 
-- 'GI.GLib.Flags.SpawnFlagsStderrToDevNull' means that the child\'s standard error
-- will be discarded (by default, it goes to the same location as the parent\'s
-- standard error). 'GI.GLib.Flags.SpawnFlagsChildInheritsStderr' explicitly imposes the
-- default behavior. Both flags cannot be enabled at the same time and, in
-- both cases, the /@stderrPipeOut@/ argument is ignored.
-- 
-- It is valid to pass the same FD in multiple parameters (e.g. you can pass
-- a single FD for both /@stdoutFd@/ and /@stderrFd@/, and include it in
-- /@sourceFds@/ too).
-- 
-- /@sourceFds@/ and /@targetFds@/ allow zero or more FDs from this process to be
-- remapped to different FDs in the spawned process. If /@nFds@/ is greater than
-- zero, /@sourceFds@/ and /@targetFds@/ must both be non-'P.Nothing' and the same length.
-- Each FD in /@sourceFds@/ is remapped to the FD number at the same index in
-- /@targetFds@/. The source and target FD may be equal to simply propagate an FD
-- to the spawned process. FD remappings are processed after standard FDs, so
-- any target FDs which equal /@stdinFd@/, /@stdoutFd@/ or /@stderrFd@/ will overwrite
-- them in the spawned process.
-- 
-- /@sourceFds@/ is supported on Windows since 2.72.
-- 
-- 'GI.GLib.Flags.SpawnFlagsFileAndArgvZero' means that the first element of /@argv@/ is
-- the file to execute, while the remaining elements are the actual
-- argument vector to pass to the file. Normally 'GI.GLib.Functions.spawnAsyncWithPipes'
-- uses /@argv@/[0] as the file to execute, and passes all of /@argv@/ to the child.
-- 
-- /@childSetup@/ and /@userData@/ are a function and user data. On POSIX
-- platforms, the function is called in the child after GLib has
-- performed all the setup it plans to perform (including creating
-- pipes, closing file descriptors, etc.) but before calling @exec()@.
-- That is, /@childSetup@/ is called just before calling @exec()@ in the
-- child. Obviously actions taken in this function will only affect
-- the child, not the parent.
-- 
-- On Windows, there is no separate @fork()@ and @exec()@ functionality.
-- Child processes are created and run with a single API call,
-- @CreateProcess()@. There is no sensible thing /@childSetup@/
-- could be used for on Windows so it is ignored and not called.
-- 
-- If non-'P.Nothing', /@childPid@/ will on Unix be filled with the child\'s
-- process ID. You can use the process ID to send signals to the child,
-- or to use @/g_child_watch_add()/@ (or @waitpid()@) if you specified the
-- 'GI.GLib.Flags.SpawnFlagsDoNotReapChild' flag. On Windows, /@childPid@/ will be
-- filled with a handle to the child process only if you specified the
-- 'GI.GLib.Flags.SpawnFlagsDoNotReapChild' flag. You can then access the child
-- process using the Win32 API, for example wait for its termination
-- with the @WaitFor*()@ functions, or examine its exit code with
-- @GetExitCodeProcess()@. You should close the handle with @CloseHandle()@
-- or 'GI.GLib.Functions.spawnClosePid' when you no longer need it.
-- 
-- If non-'P.Nothing', the /@stdinPipeOut@/, /@stdoutPipeOut@/, /@stderrPipeOut@/
-- locations will be filled with file descriptors for writing to the child\'s
-- standard input or reading from its standard output or standard error.
-- The caller of 'GI.GLib.Functions.spawnAsyncWithPipes' must close these file descriptors
-- when they are no longer in use. If these parameters are 'P.Nothing', the
-- corresponding pipe won\'t be created.
-- 
-- If /@stdinPipeOut@/ is 'P.Nothing', the child\'s standard input is attached to
-- @\/dev\/null@ unless 'GI.GLib.Flags.SpawnFlagsChildInheritsStdin' is set.
-- 
-- If /@stderrPipeOut@/ is NULL, the child\'s standard error goes to the same
-- location as the parent\'s standard error unless 'GI.GLib.Flags.SpawnFlagsStderrToDevNull'
-- is set.
-- 
-- If /@stdoutPipeOut@/ is NULL, the child\'s standard output goes to the same
-- location as the parent\'s standard output unless 'GI.GLib.Flags.SpawnFlagsStdoutToDevNull'
-- is set.
-- 
-- /@error@/ can be 'P.Nothing' to ignore errors, or non-'P.Nothing' to report errors.
-- If an error is set, the function returns 'P.False'. Errors are reported
-- even if they occur in the child (for example if the executable in
-- @\@argv[0]@ is not found). Typically the @message@ field of returned
-- errors should be displayed to users. Possible errors are those from
-- the @/G_SPAWN_ERROR/@ domain.
-- 
-- If an error occurs, /@childPid@/, /@stdinPipeOut@/, /@stdoutPipeOut@/,
-- and /@stderrPipeOut@/ will not be filled with valid values.
-- 
-- If /@childPid@/ is not 'P.Nothing' and an error does not occur then the returned
-- process reference must be closed using 'GI.GLib.Functions.spawnClosePid'.
-- 
-- On modern UNIX platforms, GLib can use an efficient process launching
-- codepath driven internally by @posix_spawn()@. This has the advantage of
-- avoiding the fork-time performance costs of cloning the parent process
-- address space, and avoiding associated memory overcommit checks that are
-- not relevant in the context of immediately executing a distinct process.
-- This optimized codepath will be used provided that the following conditions
-- are met:
-- 
-- 1. 'GI.GLib.Flags.SpawnFlagsDoNotReapChild' is set
-- 
-- 2. 'GI.GLib.Flags.SpawnFlagsLeaveDescriptorsOpen' is set
-- 
-- 3. 'GI.GLib.Flags.SpawnFlagsSearchPathFromEnvp' is not set
-- 
-- 4. /@workingDirectory@/ is 'P.Nothing'
-- 
-- 5. /@childSetup@/ is 'P.Nothing'
-- 
-- 6. The program is of a recognised binary format, or has a shebang.
--    Otherwise, GLib will have to execute the program through the
--    shell, which is not done using the optimized codepath.
-- 
-- 
-- 
-- If you are writing a GTK application, and the program you are spawning is a
-- graphical application too, then to ensure that the spawned program opens its
-- windows on the right screen, you may want to use @/GdkAppLaunchContext/@,
-- @/GAppLaunchContext/@, or set the @DISPLAY@ environment variable.
-- 
-- /Since: 2.68/
spawnAsyncWithPipesAndFds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@workingDirectory@/: child\'s current working
    --     directory, or 'P.Nothing' to inherit parent\'s, in the GLib file name encoding
    -> [[Char]]
    -- ^ /@argv@/: child\'s argument
    --     vector, in the GLib file name encoding; it must be non-empty and 'P.Nothing'-terminated
    -> Maybe ([[Char]])
    -- ^ /@envp@/: 
    --     child\'s environment, or 'P.Nothing' to inherit parent\'s, in the GLib file
    --     name encoding
    -> [GLib.Flags.SpawnFlags]
    -- ^ /@flags@/: flags from t'GI.GLib.Flags.SpawnFlags'
    -> Maybe (GLib.Callbacks.SpawnChildSetupFunc)
    -- ^ /@childSetup@/: function to run
    --     in the child just before @exec()@
    -> Int32
    -- ^ /@stdinFd@/: file descriptor to use for child\'s stdin, or @-1@
    -> Int32
    -- ^ /@stdoutFd@/: file descriptor to use for child\'s stdout, or @-1@
    -> Int32
    -- ^ /@stderrFd@/: file descriptor to use for child\'s stderr, or @-1@
    -> Maybe ([Int32])
    -- ^ /@sourceFds@/: array of FDs from the parent
    --    process to make available in the child process
    -> Maybe ([Int32])
    -- ^ /@targetFds@/: array of FDs to remap
    --    /@sourceFds@/ to in the child process
    -> m ((Int32, Int32, Int32, Int32))
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnAsyncWithPipesAndFds workingDirectory argv envp flags childSetup stdinFd stdoutFd stderrFd sourceFds targetFds = liftIO $ do
    let nFds = case targetFds of
            Nothing -> 0
            Just jTargetFds -> fromIntegral $ P.length jTargetFds
    let sourceFds_expected_length_ = case sourceFds of
            Nothing -> 0
            Just jSourceFds -> fromIntegral $ P.length jSourceFds
    when (sourceFds_expected_length_ /= nFds) $
        error "GLib.spawnAsyncWithPipesAndFds : length of 'sourceFds' does not agree with that of 'targetFds'."
    maybeWorkingDirectory <- case workingDirectory of
        Nothing -> return FP.nullPtr
        Just jWorkingDirectory -> do
            jWorkingDirectory' <- stringToCString jWorkingDirectory
            return jWorkingDirectory'
    argv' <- packZeroTerminatedFileNameArray argv
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedFileNameArray jEnvp
            return jEnvp'
    let flags' = gflagsToWord flags
    maybeChildSetup <- case childSetup of
        Nothing -> return FP.nullFunPtr
        Just jChildSetup -> do
            ptrchildSetup <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_SpawnChildSetupFunc))
            jChildSetup' <- GLib.Callbacks.mk_SpawnChildSetupFunc (GLib.Callbacks.wrap_SpawnChildSetupFunc (Just ptrchildSetup) jChildSetup)
            poke ptrchildSetup jChildSetup'
            return jChildSetup'
    maybeSourceFds <- case sourceFds of
        Nothing -> return FP.nullPtr
        Just jSourceFds -> do
            jSourceFds' <- packStorableArray jSourceFds
            return jSourceFds'
    maybeTargetFds <- case targetFds of
        Nothing -> return FP.nullPtr
        Just jTargetFds -> do
            jTargetFds' <- packStorableArray jTargetFds
            return jTargetFds'
    childPidOut <- allocMem :: IO (Ptr Int32)
    stdinPipeOut <- allocMem :: IO (Ptr Int32)
    stdoutPipeOut <- allocMem :: IO (Ptr Int32)
    stderrPipeOut <- allocMem :: IO (Ptr Int32)
    let userData = nullPtr
    onException (do
        _ <- propagateGError $ g_spawn_async_with_pipes_and_fds maybeWorkingDirectory argv' maybeEnvp flags' maybeChildSetup userData stdinFd stdoutFd stderrFd maybeSourceFds maybeTargetFds nFds childPidOut stdinPipeOut stdoutPipeOut stderrPipeOut
        childPidOut' <- peek childPidOut
        stdinPipeOut' <- peek stdinPipeOut
        stdoutPipeOut' <- peek stdoutPipeOut
        stderrPipeOut' <- peek stderrPipeOut
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem maybeSourceFds
        freeMem maybeTargetFds
        freeMem childPidOut
        freeMem stdinPipeOut
        freeMem stdoutPipeOut
        freeMem stderrPipeOut
        return (childPidOut', stdinPipeOut', stdoutPipeOut', stderrPipeOut')
     ) (do
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem maybeSourceFds
        freeMem maybeTargetFds
        freeMem childPidOut
        freeMem stdinPipeOut
        freeMem stdoutPipeOut
        freeMem stderrPipeOut
     )


-- function spawn_async_with_pipes
-- Args: [ Arg
--           { argCName = "working_directory"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's current working\n    directory, or %NULL to inherit parent's, in the GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's argument\n    vector, in the GLib file name encoding; it must be non-empty and %NULL-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n    child's environment, or %NULL to inherit parent's, in the GLib file\n    name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SpawnFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags from #GSpawnFlags"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_setup"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SpawnChildSetupFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to run\n    in the child just before `exec()`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for @child_setup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_pid"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for child process ID, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "standard_input"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for file descriptor to write to child's stdin, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "standard_output"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for file descriptor to read child's stdout, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "standard_error"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for file descriptor to read child's stderr, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_async_with_pipes" g_spawn_async_with_pipes :: 
    CString ->                              -- working_directory : TBasicType TFileName
    Ptr CString ->                          -- argv : TCArray True (-1) (-1) (TBasicType TFileName)
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TFileName)
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "SpawnFlags"})
    FunPtr GLib.Callbacks.C_SpawnChildSetupFunc -> -- child_setup : TInterface (Name {namespace = "GLib", name = "SpawnChildSetupFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    Ptr Int32 ->                            -- child_pid : TBasicType TInt
    Ptr Int32 ->                            -- standard_input : TBasicType TInt
    Ptr Int32 ->                            -- standard_output : TBasicType TInt
    Ptr Int32 ->                            -- standard_error : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Identical to 'GI.GLib.Functions.spawnAsyncWithPipesAndFds' but with @n_fds@ set to zero,
-- so no FD assignments are used.
spawnAsyncWithPipes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@workingDirectory@/: child\'s current working
    --     directory, or 'P.Nothing' to inherit parent\'s, in the GLib file name encoding
    -> [[Char]]
    -- ^ /@argv@/: child\'s argument
    --     vector, in the GLib file name encoding; it must be non-empty and 'P.Nothing'-terminated
    -> Maybe ([[Char]])
    -- ^ /@envp@/: 
    --     child\'s environment, or 'P.Nothing' to inherit parent\'s, in the GLib file
    --     name encoding
    -> [GLib.Flags.SpawnFlags]
    -- ^ /@flags@/: flags from t'GI.GLib.Flags.SpawnFlags'
    -> Maybe (GLib.Callbacks.SpawnChildSetupFunc)
    -- ^ /@childSetup@/: function to run
    --     in the child just before @exec()@
    -> m ((Int32, Int32, Int32, Int32))
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnAsyncWithPipes workingDirectory argv envp flags childSetup = liftIO $ do
    maybeWorkingDirectory <- case workingDirectory of
        Nothing -> return FP.nullPtr
        Just jWorkingDirectory -> do
            jWorkingDirectory' <- stringToCString jWorkingDirectory
            return jWorkingDirectory'
    argv' <- packZeroTerminatedFileNameArray argv
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedFileNameArray jEnvp
            return jEnvp'
    let flags' = gflagsToWord flags
    maybeChildSetup <- case childSetup of
        Nothing -> return FP.nullFunPtr
        Just jChildSetup -> do
            ptrchildSetup <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_SpawnChildSetupFunc))
            jChildSetup' <- GLib.Callbacks.mk_SpawnChildSetupFunc (GLib.Callbacks.wrap_SpawnChildSetupFunc (Just ptrchildSetup) jChildSetup)
            poke ptrchildSetup jChildSetup'
            return jChildSetup'
    childPid <- allocMem :: IO (Ptr Int32)
    standardInput <- allocMem :: IO (Ptr Int32)
    standardOutput <- allocMem :: IO (Ptr Int32)
    standardError <- allocMem :: IO (Ptr Int32)
    let userData = nullPtr
    onException (do
        _ <- propagateGError $ g_spawn_async_with_pipes maybeWorkingDirectory argv' maybeEnvp flags' maybeChildSetup userData childPid standardInput standardOutput standardError
        childPid' <- peek childPid
        standardInput' <- peek standardInput
        standardOutput' <- peek standardOutput
        standardError' <- peek standardError
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem childPid
        freeMem standardInput
        freeMem standardOutput
        freeMem standardError
        return (childPid', standardInput', standardOutput', standardError')
     ) (do
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem childPid
        freeMem standardInput
        freeMem standardOutput
        freeMem standardError
     )


-- function spawn_async_with_fds
-- Args: [ Arg
--           { argCName = "working_directory"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's current working directory, or %NULL to inherit parent's, in the GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's argument vector, in the GLib file name encoding;\n  it must be non-empty and %NULL-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's environment, or %NULL to inherit parent's, in the GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SpawnFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags from #GSpawnFlags"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_setup"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SpawnChildSetupFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to run\n  in the child just before `exec()`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for @child_setup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_pid"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for child process ID, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "stdin_fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "file descriptor to use for child's stdin, or `-1`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stdout_fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "file descriptor to use for child's stdout, or `-1`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stderr_fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "file descriptor to use for child's stderr, or `-1`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_async_with_fds" g_spawn_async_with_fds :: 
    CString ->                              -- working_directory : TBasicType TFileName
    Ptr CString ->                          -- argv : TCArray True (-1) (-1) (TBasicType TUTF8)
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TUTF8)
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "SpawnFlags"})
    FunPtr GLib.Callbacks.C_SpawnChildSetupFunc -> -- child_setup : TInterface (Name {namespace = "GLib", name = "SpawnChildSetupFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    Ptr Int32 ->                            -- child_pid : TBasicType TInt
    Int32 ->                                -- stdin_fd : TBasicType TInt
    Int32 ->                                -- stdout_fd : TBasicType TInt
    Int32 ->                                -- stderr_fd : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Executes a child program asynchronously.
-- 
-- Identical to 'GI.GLib.Functions.spawnAsyncWithPipesAndFds' but with @n_fds@ set to zero,
-- so no FD assignments are used.
-- 
-- /Since: 2.58/
spawnAsyncWithFds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@workingDirectory@/: child\'s current working directory, or 'P.Nothing' to inherit parent\'s, in the GLib file name encoding
    -> [T.Text]
    -- ^ /@argv@/: child\'s argument vector, in the GLib file name encoding;
    --   it must be non-empty and 'P.Nothing'-terminated
    -> Maybe ([T.Text])
    -- ^ /@envp@/: child\'s environment, or 'P.Nothing' to inherit parent\'s, in the GLib file name encoding
    -> [GLib.Flags.SpawnFlags]
    -- ^ /@flags@/: flags from t'GI.GLib.Flags.SpawnFlags'
    -> Maybe (GLib.Callbacks.SpawnChildSetupFunc)
    -- ^ /@childSetup@/: function to run
    --   in the child just before @exec()@
    -> Int32
    -- ^ /@stdinFd@/: file descriptor to use for child\'s stdin, or @-1@
    -> Int32
    -- ^ /@stdoutFd@/: file descriptor to use for child\'s stdout, or @-1@
    -> Int32
    -- ^ /@stderrFd@/: file descriptor to use for child\'s stderr, or @-1@
    -> m (Int32)
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnAsyncWithFds workingDirectory argv envp flags childSetup stdinFd stdoutFd stderrFd = liftIO $ do
    maybeWorkingDirectory <- case workingDirectory of
        Nothing -> return FP.nullPtr
        Just jWorkingDirectory -> do
            jWorkingDirectory' <- stringToCString jWorkingDirectory
            return jWorkingDirectory'
    argv' <- packZeroTerminatedUTF8CArray argv
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedUTF8CArray jEnvp
            return jEnvp'
    let flags' = gflagsToWord flags
    maybeChildSetup <- case childSetup of
        Nothing -> return FP.nullFunPtr
        Just jChildSetup -> do
            ptrchildSetup <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_SpawnChildSetupFunc))
            jChildSetup' <- GLib.Callbacks.mk_SpawnChildSetupFunc (GLib.Callbacks.wrap_SpawnChildSetupFunc (Just ptrchildSetup) jChildSetup)
            poke ptrchildSetup jChildSetup'
            return jChildSetup'
    childPid <- allocMem :: IO (Ptr Int32)
    let userData = nullPtr
    onException (do
        _ <- propagateGError $ g_spawn_async_with_fds maybeWorkingDirectory argv' maybeEnvp flags' maybeChildSetup userData childPid stdinFd stdoutFd stderrFd
        childPid' <- peek childPid
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem childPid
        return childPid'
     ) (do
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem childPid
     )


-- function spawn_async
-- Args: [ Arg
--           { argCName = "working_directory"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "child's current working\n    directory, or %NULL to inherit parent's"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "\n    child's argument vector"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "\n    child's environment, or %NULL to inherit parent's"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SpawnFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags from #GSpawnFlags"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_setup"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SpawnChildSetupFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to run\n    in the child just before `exec()`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for @child_setup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_pid"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for child process reference, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_spawn_async" g_spawn_async :: 
    CString ->                              -- working_directory : TBasicType TFileName
    Ptr CString ->                          -- argv : TCArray True (-1) (-1) (TBasicType TFileName)
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TFileName)
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "SpawnFlags"})
    FunPtr GLib.Callbacks.C_SpawnChildSetupFunc -> -- child_setup : TInterface (Name {namespace = "GLib", name = "SpawnChildSetupFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    Ptr Int32 ->                            -- child_pid : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Executes a child program asynchronously.
-- 
-- See 'GI.GLib.Functions.spawnAsyncWithPipesAndFds' for a full description; this function
-- simply calls the 'GI.GLib.Functions.spawnAsyncWithPipes' without any pipes, which in turn
-- calls 'GI.GLib.Functions.spawnAsyncWithPipesAndFds'.
-- 
-- You should call 'GI.GLib.Functions.spawnClosePid' on the returned child process
-- reference when you don\'t need it any more.
-- 
-- If you are writing a GTK application, and the program you are spawning is a
-- graphical application too, then to ensure that the spawned program opens its
-- windows on the right screen, you may want to use @/GdkAppLaunchContext/@,
-- @/GAppLaunchContext/@, or set the @/DISPLAY/@ environment variable.
-- 
-- Note that the returned /@childPid@/ on Windows is a handle to the child
-- process and not its identifier. Process handles and process identifiers
-- are different concepts on Windows.
spawnAsync ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@workingDirectory@/: child\'s current working
    --     directory, or 'P.Nothing' to inherit parent\'s
    -> [[Char]]
    -- ^ /@argv@/: 
    --     child\'s argument vector
    -> Maybe ([[Char]])
    -- ^ /@envp@/: 
    --     child\'s environment, or 'P.Nothing' to inherit parent\'s
    -> [GLib.Flags.SpawnFlags]
    -- ^ /@flags@/: flags from t'GI.GLib.Flags.SpawnFlags'
    -> Maybe (GLib.Callbacks.SpawnChildSetupFunc)
    -- ^ /@childSetup@/: function to run
    --     in the child just before @exec()@
    -> m (Int32)
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
spawnAsync workingDirectory argv envp flags childSetup = liftIO $ do
    maybeWorkingDirectory <- case workingDirectory of
        Nothing -> return FP.nullPtr
        Just jWorkingDirectory -> do
            jWorkingDirectory' <- stringToCString jWorkingDirectory
            return jWorkingDirectory'
    argv' <- packZeroTerminatedFileNameArray argv
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedFileNameArray jEnvp
            return jEnvp'
    let flags' = gflagsToWord flags
    maybeChildSetup <- case childSetup of
        Nothing -> return FP.nullFunPtr
        Just jChildSetup -> do
            ptrchildSetup <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_SpawnChildSetupFunc))
            jChildSetup' <- GLib.Callbacks.mk_SpawnChildSetupFunc (GLib.Callbacks.wrap_SpawnChildSetupFunc (Just ptrchildSetup) jChildSetup)
            poke ptrchildSetup jChildSetup'
            return jChildSetup'
    childPid <- allocMem :: IO (Ptr Int32)
    let userData = nullPtr
    onException (do
        _ <- propagateGError $ g_spawn_async maybeWorkingDirectory argv' maybeEnvp flags' maybeChildSetup userData childPid
        childPid' <- peek childPid
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem childPid
        return childPid'
     ) (do
        freeMem maybeWorkingDirectory
        mapZeroTerminatedCArray freeMem argv'
        freeMem argv'
        mapZeroTerminatedCArray freeMem maybeEnvp
        freeMem maybeEnvp
        freeMem childPid
     )


-- function spaced_primes_closest
-- Args: [ Arg
--           { argCName = "num"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #guint" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_spaced_primes_closest" g_spaced_primes_closest :: 
    Word32 ->                               -- num : TBasicType TUInt
    IO Word32

-- | Gets the smallest prime number from a built-in array of primes which
-- is larger than /@num@/. This is used within GLib to calculate the optimum
-- size of a t'GI.GLib.Structs.HashTable.HashTable'.
-- 
-- The built-in array of primes ranges from 11 to 13845163 such that
-- each prime is approximately 1.5-2 times the previous prime.
spacedPrimesClosest ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@num@/: a @/guint/@
    -> m Word32
    -- ^ __Returns:__ the smallest prime number from a built-in array of primes
    --     which is larger than /@num@/
spacedPrimesClosest num = liftIO $ do
    result <- g_spaced_primes_closest num
    return result


-- function slice_set_config
-- Args: [ Arg
--           { argCName = "ckey"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SliceConfig" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_slice_set_config" g_slice_set_config :: 
    CUInt ->                                -- ckey : TInterface (Name {namespace = "GLib", name = "SliceConfig"})
    Int64 ->                                -- value : TBasicType TInt64
    IO ()

-- | /No description available in the introspection data./
sliceSetConfig ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.SliceConfig
    -> Int64
    -> m ()
sliceSetConfig ckey value = liftIO $ do
    let ckey' = (fromIntegral . fromEnum) ckey
    g_slice_set_config ckey' value
    return ()


-- function slice_get_config_state
-- Args: [ Arg
--           { argCName = "ckey"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SliceConfig" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "address"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_values"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "g_slice_get_config_state" g_slice_get_config_state :: 
    CUInt ->                                -- ckey : TInterface (Name {namespace = "GLib", name = "SliceConfig"})
    Int64 ->                                -- address : TBasicType TInt64
    Word32 ->                               -- n_values : TBasicType TUInt
    IO Int64

-- | /No description available in the introspection data./
sliceGetConfigState ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.SliceConfig
    -> Int64
    -> Word32
    -> m Int64
sliceGetConfigState ckey address nValues = liftIO $ do
    let ckey' = (fromIntegral . fromEnum) ckey
    result <- g_slice_get_config_state ckey' address nValues
    return result


-- function slice_get_config
-- Args: [ Arg
--           { argCName = "ckey"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SliceConfig" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "g_slice_get_config" g_slice_get_config :: 
    CUInt ->                                -- ckey : TInterface (Name {namespace = "GLib", name = "SliceConfig"})
    IO Int64

-- | /No description available in the introspection data./
sliceGetConfig ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.SliceConfig
    -> m Int64
sliceGetConfig ckey = liftIO $ do
    let ckey' = (fromIntegral . fromEnum) ckey
    result <- g_slice_get_config ckey'
    return result


-- function slice_free_chain_with_offset
-- Args: [ Arg
--           { argCName = "block_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of the blocks"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mem_chain"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to the first block of the chain"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "next_offset"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the offset of the @next field in the blocks"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_slice_free_chain_with_offset" g_slice_free_chain_with_offset :: 
    FCT.CSize ->                            -- block_size : TBasicType TSize
    Ptr () ->                               -- mem_chain : TBasicType TPtr
    FCT.CSize ->                            -- next_offset : TBasicType TSize
    IO ()

-- | Frees a linked list of memory blocks of structure type /@type@/.
-- 
-- The memory blocks must be equal-sized, allocated via
-- 'GI.GLib.Functions.sliceAlloc' or 'GI.GLib.Functions.sliceAlloc0' and linked together by a
-- /@next@/ pointer (similar to t'GI.GLib.Structs.SList.SList'). The offset of the /@next@/
-- field in each block is passed as third argument.
-- Note that the exact release behaviour can be changed with the
-- <http://developer.gnome.org/glib/stable/running.html#environment-variables `G_DEBUG=gc-friendly`> environment variable.
-- 
-- If /@memChain@/ is 'P.Nothing', this function does nothing.
-- 
-- Since GLib 2.76 this always uses the system @/free_sized()/@ implementation
-- internally.
-- 
-- /Since: 2.10/
sliceFreeChainWithOffset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@blockSize@/: the size of the blocks
    -> Ptr ()
    -- ^ /@memChain@/: a pointer to the first block of the chain
    -> FCT.CSize
    -- ^ /@nextOffset@/: the offset of the /@next@/ field in the blocks
    -> m ()
sliceFreeChainWithOffset blockSize memChain nextOffset = liftIO $ do
    g_slice_free_chain_with_offset blockSize memChain nextOffset
    return ()


-- function slice_free1
-- Args: [ Arg
--           { argCName = "block_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of the block"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mem_block"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to the block to free"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_slice_free1" g_slice_free1 :: 
    FCT.CSize ->                            -- block_size : TBasicType TSize
    Ptr () ->                               -- mem_block : TBasicType TPtr
    IO ()

-- | Frees a block of memory.
-- 
-- The memory must have been allocated via 'GI.GLib.Functions.sliceAlloc' or
-- 'GI.GLib.Functions.sliceAlloc0' and the /@blockSize@/ has to match the size
-- specified upon allocation. Note that the exact release behaviour
-- can be changed with the <http://developer.gnome.org/glib/stable/running.html#environment-variables `G_DEBUG=gc-friendly`> environment
-- variable.
-- 
-- If /@memBlock@/ is 'P.Nothing', this function does nothing.
-- 
-- Since GLib 2.76 this always uses the system @/free_sized()/@ implementation
-- internally.
-- 
-- /Since: 2.10/
sliceFree1 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@blockSize@/: the size of the block
    -> Ptr ()
    -- ^ /@memBlock@/: a pointer to the block to free
    -> m ()
sliceFree1 blockSize memBlock = liftIO $ do
    g_slice_free1 blockSize memBlock
    return ()


-- function slice_copy
-- Args: [ Arg
--           { argCName = "block_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mem_block"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_slice_copy" g_slice_copy :: 
    FCT.CSize ->                            -- block_size : TBasicType TSize
    Ptr () ->                               -- mem_block : TBasicType TPtr
    IO (Ptr ())

-- | Allocates a block of memory from the slice allocator
-- and copies /@blockSize@/ bytes into it from /@memBlock@/.
-- 
-- /@memBlock@/ must be non-'P.Nothing' if /@blockSize@/ is non-zero.
-- 
-- Since GLib 2.76 this always uses the system @/malloc()/@ implementation
-- internally.
-- 
-- /Since: 2.14/
sliceCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@blockSize@/: the number of bytes to allocate
    -> Ptr ()
    -- ^ /@memBlock@/: the memory to copy
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated memory block,
    --    which will be 'P.Nothing' if and only if /@memSize@/ is 0
sliceCopy blockSize memBlock = liftIO $ do
    result <- g_slice_copy blockSize memBlock
    return result


-- function slice_alloc0
-- Args: [ Arg
--           { argCName = "block_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_slice_alloc0" g_slice_alloc0 :: 
    FCT.CSize ->                            -- block_size : TBasicType TSize
    IO (Ptr ())

-- | Allocates a block of memory via 'GI.GLib.Functions.sliceAlloc' and initializes
-- the returned memory to 0.
-- 
-- Since GLib 2.76 this always uses the system @/malloc()/@ implementation
-- internally.
-- 
-- /Since: 2.10/
sliceAlloc0 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@blockSize@/: the number of bytes to allocate
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated block, which will be 'P.Nothing'
    --    if and only if /@memSize@/ is 0
sliceAlloc0 blockSize = liftIO $ do
    result <- g_slice_alloc0 blockSize
    return result


-- function slice_alloc
-- Args: [ Arg
--           { argCName = "block_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_slice_alloc" g_slice_alloc :: 
    FCT.CSize ->                            -- block_size : TBasicType TSize
    IO (Ptr ())

-- | Allocates a block of memory from the libc allocator.
-- 
-- The block address handed out can be expected to be aligned
-- to at least @1 * sizeof (void*)@.
-- 
-- Since GLib 2.76 this always uses the system @/malloc()/@ implementation
-- internally.
-- 
-- /Since: 2.10/
sliceAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@blockSize@/: the number of bytes to allocate
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated memory block, which will
    --   be 'P.Nothing' if and only if /@memSize@/ is 0
sliceAlloc blockSize = liftIO $ do
    result <- g_slice_alloc blockSize
    return result


-- function shell_unquote
-- Args: [ Arg
--           { argCName = "quoted_string"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "shell-quoted string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : True
-- Skip return : False

foreign import ccall "g_shell_unquote" g_shell_unquote :: 
    CString ->                              -- quoted_string : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Unquotes a string as the shell (\/bin\/sh) would.
-- 
-- This function only handles quotes; if a string contains file globs,
-- arithmetic operators, variables, backticks, redirections, or other
-- special-to-the-shell features, the result will be different from the
-- result a real shell would produce (the variables, backticks, etc.
-- will be passed through literally instead of being expanded).
-- 
-- This function is guaranteed to succeed if applied to the result of
-- 'GI.GLib.Functions.shellQuote'. If it fails, it returns 'P.Nothing' and sets the
-- error.
-- 
-- The /@quotedString@/ need not actually contain quoted or escaped text;
-- 'GI.GLib.Functions.shellUnquote' simply goes through the string and unquotes\/unescapes
-- anything that the shell would. Both single and double quotes are
-- handled, as are escapes including escaped newlines.
-- 
-- The return value must be freed with 'GI.GLib.Functions.free'.
-- 
-- Possible errors are in the @/G_SHELL_ERROR/@ domain.
-- 
-- Shell quoting rules are a bit strange. Single quotes preserve the
-- literal string exactly. escape sequences are not allowed; not even
-- @\\\'@ - if you want a @\'@ in the quoted text, you have to do something
-- like @\'foo\'\\\'\'bar\'@. Double quotes allow @$@, \`\`@, @\"@, @\`, and
-- newline to be escaped with backslash. Otherwise double quotes
-- preserve things literally.
shellUnquote ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@quotedString@/: shell-quoted string
    -> m [Char]
    -- ^ __Returns:__ an unquoted string /(Can throw 'Data.GI.Base.GError.GError')/
shellUnquote quotedString = liftIO $ do
    quotedString' <- stringToCString quotedString
    onException (do
        result <- propagateGError $ g_shell_unquote quotedString'
        checkUnexpectedReturnNULL "shellUnquote" result
        result' <- cstringToString result
        freeMem result
        freeMem quotedString'
        return result'
     ) (do
        freeMem quotedString'
     )


-- function shell_quote
-- Args: [ Arg
--           { argCName = "unquoted_string"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a literal string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_shell_quote" g_shell_quote :: 
    CString ->                              -- unquoted_string : TBasicType TFileName
    IO CString

-- | Quotes a string so that the shell (\/bin\/sh) will interpret the
-- quoted string to mean /@unquotedString@/.
-- 
-- If you pass a filename to the shell, for example, you should first
-- quote it with this function.
-- 
-- The return value must be freed with 'GI.GLib.Functions.free'.
-- 
-- The quoting style used is undefined (single or double quotes may be
-- used).
shellQuote ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@unquotedString@/: a literal string
    -> m [Char]
    -- ^ __Returns:__ quoted string
shellQuote unquotedString = liftIO $ do
    unquotedString' <- stringToCString unquotedString
    result <- g_shell_quote unquotedString'
    checkUnexpectedReturnNULL "shellQuote" result
    result' <- cstringToString result
    freeMem result
    freeMem unquotedString'
    return result'


-- function shell_parse_argv
-- Args: [ Arg
--           { argCName = "command_line"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "command line to parse"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "argcp"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for number of args"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "argvp"
--           , argType = TCArray True (-1) 1 (TBasicType TFileName)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "\n  return location for array of args"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_shell_parse_argv" g_shell_parse_argv :: 
    CString ->                              -- command_line : TBasicType TFileName
    Ptr Int32 ->                            -- argcp : TBasicType TInt
    Ptr (Ptr CString) ->                    -- argvp : TCArray True (-1) 1 (TBasicType TFileName)
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Parses a command line into an argument vector, in much the same way
-- the shell would, but without many of the expansions the shell would
-- perform (variable expansion, globs, operators, filename expansion,
-- etc. are not supported).
-- 
-- The results are defined to be the same as those you would get from
-- a UNIX98 @\/bin\/sh@, as long as the input contains none of the
-- unsupported shell expansions. If the input does contain such expansions,
-- they are passed through literally.
-- 
-- Possible errors are those from the @/G_SHELL_ERROR/@ domain.
-- 
-- In particular, if /@commandLine@/ is an empty string (or a string containing
-- only whitespace), 'GI.GLib.Enums.ShellErrorEmptyString' will be returned. It’s
-- guaranteed that /@argvp@/ will be a non-empty array if this function returns
-- successfully.
-- 
-- Free the returned vector with 'GI.GLib.Functions.strfreev'.
shellParseArgv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@commandLine@/: command line to parse
    -> m ((Int32, [[Char]]))
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
shellParseArgv commandLine = liftIO $ do
    commandLine' <- stringToCString commandLine
    argcp <- allocMem :: IO (Ptr Int32)
    argvp <- callocMem :: IO (Ptr (Ptr CString))
    onException (do
        _ <- propagateGError $ g_shell_parse_argv commandLine' argcp argvp
        argcp' <- peek argcp
        argvp' <- peek argvp
        argvp'' <- unpackZeroTerminatedFileNameArray argvp'
        mapZeroTerminatedCArray freeMem argvp'
        freeMem argvp'
        freeMem commandLine'
        freeMem argcp
        freeMem argvp
        return (argcp', argvp'')
     ) (do
        freeMem commandLine'
        freeMem argcp
        freeMem argvp
     )


-- function shell_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_shell_error_quark" g_shell_error_quark :: 
    IO Word32

-- | /No description available in the introspection data./
shellErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
shellErrorQuark  = liftIO $ do
    result <- g_shell_error_quark
    return result


-- function setenv
-- Args: [ Arg
--           { argCName = "variable"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the environment variable to set, must not\n    contain '='."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value for to set the variable to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "overwrite"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to change the variable if it already exists."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_setenv" g_setenv :: 
    CString ->                              -- variable : TBasicType TFileName
    CString ->                              -- value : TBasicType TFileName
    CInt ->                                 -- overwrite : TBasicType TBoolean
    IO CInt

-- | Sets an environment variable. On UNIX, both the variable\'s name and
-- value can be arbitrary byte strings, except that the variable\'s name
-- cannot contain \'=\'. On Windows, they should be in UTF-8.
-- 
-- Note that on some systems, when variables are overwritten, the memory
-- used for the previous variables and its value isn\'t reclaimed.
-- 
-- You should be mindful of the fact that environment variable handling
-- in UNIX is not thread-safe, and your program may crash if one thread
-- calls 'GI.GLib.Functions.setenv' while another thread is calling @/getenv()/@. (And note
-- that many functions, such as @/gettext()/@, call @/getenv()/@ internally.)
-- This function is only safe to use at the very start of your program,
-- before creating any other threads (or creating objects that create
-- worker threads of their own).
-- 
-- If you need to set up the environment for a child process, you can
-- use 'GI.GLib.Functions.getEnviron' to get an environment array, modify that with
-- 'GI.GLib.Functions.environSetenv' and 'GI.GLib.Functions.environUnsetenv', and then pass that
-- array directly to @/execvpe()/@, 'GI.GLib.Functions.spawnAsync', or the like.
-- 
-- /Since: 2.4/
setenv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@variable@/: the environment variable to set, must not
    --     contain \'=\'.
    -> [Char]
    -- ^ /@value@/: the value for to set the variable to.
    -> Bool
    -- ^ /@overwrite@/: whether to change the variable if it already exists.
    -> m Bool
    -- ^ __Returns:__ 'P.False' if the environment variable couldn\'t be set.
setenv variable value overwrite = liftIO $ do
    variable' <- stringToCString variable
    value' <- stringToCString value
    let overwrite' = (P.fromIntegral . P.fromEnum) overwrite
    result <- g_setenv variable' value' overwrite'
    let result' = (/= 0) result
    freeMem variable'
    freeMem value'
    return result'


-- function set_prgname
-- Args: [ Arg
--           { argCName = "prgname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the program."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_set_prgname" g_set_prgname :: 
    CString ->                              -- prgname : TBasicType TUTF8
    IO ()

-- | Sets the name of the program. This name should not be localized,
-- in contrast to 'GI.GLib.Functions.setApplicationName'.
-- 
-- If you are using @/GApplication/@ the program name is set in
-- @/g_application_run()/@. In case of GDK or GTK it is set in
-- @/gdk_init()/@, which is called by @/gtk_init()/@ and the
-- @/GtkApplication::startup/@ handler. By default, the program name is
-- found by taking the last component of /@argv@/[0].
-- 
-- Since GLib 2.72, this function can be called multiple times
-- and is fully thread safe. Prior to GLib 2.72, this function
-- could only be called once per process.
-- 
-- See the <https://docs.gtk.org/gtk4/migrating-3to4.html#set-a-proper-application-id GTK documentation>
-- for requirements on integrating 'GI.GLib.Functions.setPrgname' with GTK applications.
setPrgname ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@prgname@/: the name of the program.
    -> m ()
setPrgname prgname = liftIO $ do
    prgname' <- textToCString prgname
    g_set_prgname prgname'
    freeMem prgname'
    return ()


-- function set_error_literal
-- Args: [ Arg
--           { argCName = "err"
--           , argType = TError
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a return location for a #GError"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "domain"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "error domain" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "code"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "error code" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "error message" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_set_error_literal" g_set_error_literal :: 
    Ptr (Ptr GError) ->                     -- err : TError
    Word32 ->                               -- domain : TBasicType TUInt32
    Int32 ->                                -- code : TBasicType TInt
    CString ->                              -- message : TBasicType TUTF8
    IO ()

-- | Does nothing if /@err@/ is 'P.Nothing'; if /@err@/ is non-'P.Nothing', then @*err@
-- must be 'P.Nothing'. A new t'GError' is created and assigned to @*err@.
-- Unlike @/g_set_error()/@, /@message@/ is not a @/printf()/@-style format string.
-- Use this function if /@message@/ contains text you don\'t have control over,
-- that could include @/printf()/@ escape sequences.
-- 
-- /Since: 2.18/
setErrorLiteral ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@domain@/: error domain
    -> Int32
    -- ^ /@code@/: error code
    -> T.Text
    -- ^ /@message@/: error message
    -> m (GError)
setErrorLiteral domain code message = liftIO $ do
    err <- callocMem :: IO (Ptr (Ptr GError))
    message' <- textToCString message
    g_set_error_literal err domain code message'
    err' <- peek err
    err'' <- (wrapBoxed GError) err'
    freeMem err
    freeMem message'
    return err''


-- function set_application_name
-- Args: [ Arg
--           { argCName = "application_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "localized name of the application"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_set_application_name" g_set_application_name :: 
    CString ->                              -- application_name : TBasicType TUTF8
    IO ()

-- | Sets a human-readable name for the application. This name should be
-- localized if possible, and is intended for display to the user.
-- Contrast with 'GI.GLib.Functions.setPrgname', which sets a non-localized name.
-- 'GI.GLib.Functions.setPrgname' will be called automatically by @/gtk_init()/@,
-- but 'GI.GLib.Functions.setApplicationName' will not.
-- 
-- Note that for thread safety reasons, this function can only
-- be called once.
-- 
-- The application name will be used in contexts such as error messages,
-- or when displaying an application\'s name in the task list.
-- 
-- /Since: 2.2/
setApplicationName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@applicationName@/: localized name of the application
    -> m ()
setApplicationName applicationName = liftIO $ do
    applicationName' <- textToCString applicationName
    g_set_application_name applicationName'
    freeMem applicationName'
    return ()


-- function rmdir
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_rmdir" g_rmdir :: 
    CString ->                              -- filename : TBasicType TFileName
    IO Int32

-- | A wrapper for the POSIX @/rmdir()/@ function. The @/rmdir()/@ function
-- deletes a directory from the filesystem.
-- 
-- See your C library manual for more details about how @/rmdir()/@ works
-- on your system.
-- 
-- /Since: 2.6/
rmdir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> m Int32
    -- ^ __Returns:__ 0 if the directory was successfully removed, -1 if an error
    --    occurred
rmdir filename = liftIO $ do
    filename' <- stringToCString filename
    result <- g_rmdir filename'
    freeMem filename'
    return result


-- function rename
-- Args: [ Arg
--           { argCName = "oldfilename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "newfilename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pathname in the GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_rename" g_rename :: 
    CString ->                              -- oldfilename : TBasicType TFileName
    CString ->                              -- newfilename : TBasicType TFileName
    IO Int32

-- | A wrapper for the POSIX @/rename()/@ function. The @/rename()/@ function
-- renames a file, moving it between directories if required.
-- 
-- See your C library manual for more details about how @/rename()/@ works
-- on your system. It is not possible in general on Windows to rename
-- a file that is open to some process.
-- 
-- /Since: 2.6/
rename ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@oldfilename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> [Char]
    -- ^ /@newfilename@/: a pathname in the GLib file name encoding
    -> m Int32
    -- ^ __Returns:__ 0 if the renaming succeeded, -1 if an error occurred
rename oldfilename newfilename = liftIO $ do
    oldfilename' <- stringToCString oldfilename
    newfilename' <- stringToCString newfilename
    result <- g_rename oldfilename' newfilename'
    freeMem oldfilename'
    freeMem newfilename'
    return result


-- function remove
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_remove" g_remove :: 
    CString ->                              -- filename : TBasicType TFileName
    IO Int32

-- | A wrapper for the POSIX @/remove()/@ function. The @/remove()/@ function
-- deletes a name from the filesystem.
-- 
-- See your C library manual for more details about how @/remove()/@ works
-- on your system. On Unix, @/remove()/@ removes also directories, as it
-- calls @/unlink()/@ for files and @/rmdir()/@ for directories. On Windows,
-- although @/remove()/@ in the C library only works for files, this
-- function tries first @/remove()/@ and then if that fails @/rmdir()/@, and
-- thus works for both files and directories. Note however, that on
-- Windows, it is in general not possible to remove a file that is
-- open to some process, or mapped into memory.
-- 
-- If this function fails on Windows you can\'t infer too much from the
-- errno value. @/rmdir()/@ is tried regardless of what caused @/remove()/@ to
-- fail. Any errno value set by @/remove()/@ will be overwritten by that
-- set by @/rmdir()/@.
-- 
-- /Since: 2.6/
remove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> m Int32
    -- ^ __Returns:__ 0 if the file was successfully removed, -1 if an error
    --    occurred
remove filename = liftIO $ do
    filename' <- stringToCString filename
    result <- g_remove filename'
    freeMem filename'
    return result


-- function reload_user_special_dirs_cache
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_reload_user_special_dirs_cache" g_reload_user_special_dirs_cache :: 
    IO ()

-- | Resets the cache used for 'GI.GLib.Functions.getUserSpecialDir', so
-- that the latest on-disk version is used. Call this only
-- if you just changed the data on disk yourself.
-- 
-- Due to thread safety issues this may cause leaking of strings
-- that were previously returned from 'GI.GLib.Functions.getUserSpecialDir'
-- that can\'t be freed. We ensure to only leak the data for
-- the directories that actually changed value though.
-- 
-- /Since: 2.22/
reloadUserSpecialDirsCache ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
reloadUserSpecialDirsCache  = liftIO $ do
    g_reload_user_special_dirs_cache
    return ()


-- function ref_string_release
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a reference counted string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_string_release" g_ref_string_release :: 
    CString ->                              -- str : TBasicType TUTF8
    IO ()

-- | Releases a reference on a string; if it was the last reference, the
-- resources allocated by the string are freed as well.
-- 
-- /Since: 2.58/
refStringRelease ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a reference counted string
    -> m ()
refStringRelease str = liftIO $ do
    str' <- textToCString str
    g_ref_string_release str'
    freeMem str'
    return ()


-- function ref_string_new_len
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "length of @str to use, or -1 if @str is nul-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_string_new_len" g_ref_string_new_len :: 
    CString ->                              -- str : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    IO CString

-- | Creates a new reference counted string and copies the contents of /@str@/
-- into it, up to /@len@/ bytes.
-- 
-- Since this function does not stop at nul bytes, it is the caller\'s
-- responsibility to ensure that /@str@/ has at least /@len@/ addressable bytes.
-- 
-- /Since: 2.58/
refStringNewLen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a string
    -> DI.Int64
    -- ^ /@len@/: length of /@str@/ to use, or -1 if /@str@/ is nul-terminated
    -> m T.Text
    -- ^ __Returns:__ the newly created reference counted string
refStringNewLen str len = liftIO $ do
    str' <- textToCString str
    result <- g_ref_string_new_len str' len
    checkUnexpectedReturnNULL "refStringNewLen" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function ref_string_new_intern
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a NUL-terminated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_string_new_intern" g_ref_string_new_intern :: 
    CString ->                              -- str : TBasicType TUTF8
    IO CString

-- | Creates a new reference counted string and copies the content of /@str@/
-- into it.
-- 
-- If you call this function multiple times with the same /@str@/, or with
-- the same contents of /@str@/, it will return a new reference, instead of
-- creating a new string.
-- 
-- /Since: 2.58/
refStringNewIntern ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a NUL-terminated string
    -> m T.Text
    -- ^ __Returns:__ the newly created reference
    --   counted string, or a new reference to an existing string
refStringNewIntern str = liftIO $ do
    str' <- textToCString str
    result <- g_ref_string_new_intern str'
    checkUnexpectedReturnNULL "refStringNewIntern" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function ref_string_new
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a NUL-terminated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_string_new" g_ref_string_new :: 
    CString ->                              -- str : TBasicType TUTF8
    IO CString

-- | Creates a new reference counted string and copies the contents of /@str@/
-- into it.
-- 
-- /Since: 2.58/
refStringNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a NUL-terminated string
    -> m T.Text
    -- ^ __Returns:__ the newly created reference counted string
refStringNew str = liftIO $ do
    str' <- textToCString str
    result <- g_ref_string_new str'
    checkUnexpectedReturnNULL "refStringNew" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function ref_string_length
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a reference counted string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_string_length" g_ref_string_length :: 
    CString ->                              -- str : TBasicType TUTF8
    IO FCT.CSize

-- | Retrieves the length of /@str@/.
-- 
-- /Since: 2.58/
refStringLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a reference counted string
    -> m FCT.CSize
    -- ^ __Returns:__ the length of the given string, in bytes
refStringLength str = liftIO $ do
    str' <- textToCString str
    result <- g_ref_string_length str'
    freeMem str'
    return result


-- function ref_string_equal
-- Args: [ Arg
--           { argCName = "str1"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a reference counted string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str2"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a reference counted string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_string_equal" g_ref_string_equal :: 
    CString ->                              -- str1 : TBasicType TUTF8
    CString ->                              -- str2 : TBasicType TUTF8
    IO CInt

-- | Compares two ref-counted strings for byte-by-byte equality.
-- 
-- It can be passed to t'GHashTable'.@/new/@() as the key equality function,
-- and behaves exactly the same as 'GI.GLib.Functions.strEqual' (or @strcmp()@), but
-- can return slightly faster as it can check the string lengths before checking
-- all the bytes.
-- 
-- /Since: 2.84/
refStringEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str1@/: a reference counted string
    -> T.Text
    -- ^ /@str2@/: a reference counted string
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the strings are equal, otherwise @FALSE@
refStringEqual str1 str2 = liftIO $ do
    str1' <- textToCString str1
    str2' <- textToCString str2
    result <- g_ref_string_equal str1' str2'
    let result' = (/= 0) result
    freeMem str1'
    freeMem str2'
    return result'


-- function ref_string_acquire
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a reference counted string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_string_acquire" g_ref_string_acquire :: 
    CString ->                              -- str : TBasicType TUTF8
    IO CString

-- | Acquires a reference on a string.
-- 
-- /Since: 2.58/
refStringAcquire ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a reference counted string
    -> m T.Text
    -- ^ __Returns:__ the given string, with its reference count increased
refStringAcquire str = liftIO $ do
    str' <- textToCString str
    result <- g_ref_string_acquire str'
    checkUnexpectedReturnNULL "refStringAcquire" result
    result' <- cstringToText result
    freeMem result
    freeMem str'
    return result'


-- function ref_count_init
-- Args: [ Arg
--           { argCName = "rc"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the address of a reference count variable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_count_init" g_ref_count_init :: 
    Ptr Int32 ->                            -- rc : TBasicType TInt
    IO ()

-- | Initializes a reference count variable to 1.
-- 
-- /Since: 2.58/
refCountInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Int32)
refCountInit  = liftIO $ do
    rc <- allocMem :: IO (Ptr Int32)
    g_ref_count_init rc
    rc' <- peek rc
    freeMem rc
    return rc'


-- function ref_count_inc
-- Args: [ Arg
--           { argCName = "rc"
--           , argType = TBasicType TInt
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the address of a reference count variable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_count_inc" g_ref_count_inc :: 
    Ptr Int32 ->                            -- rc : TBasicType TInt
    IO ()

-- | Increases the reference count.
-- 
-- /Since: 2.58/
refCountInc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@rc@/: the address of a reference count variable
    -> m (Int32)
refCountInc rc = liftIO $ do
    rc' <- allocMem :: IO (Ptr Int32)
    poke rc' rc
    g_ref_count_inc rc'
    rc'' <- peek rc'
    freeMem rc'
    return rc''


-- function ref_count_dec
-- Args: [ Arg
--           { argCName = "rc"
--           , argType = TBasicType TInt
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the address of a reference count variable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_count_dec" g_ref_count_dec :: 
    Ptr Int32 ->                            -- rc : TBasicType TInt
    IO CInt

-- | Decreases the reference count.
-- 
-- If 'P.True' is returned, the reference count reached 0. After this point, /@rc@/
-- is an undefined state and must be reinitialized with
-- 'GI.GLib.Functions.refCountInit' to be used again.
-- 
-- /Since: 2.58/
refCountDec ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@rc@/: the address of a reference count variable
    -> m ((Bool, Int32))
    -- ^ __Returns:__ 'P.True' if the reference count reached 0, and 'P.False' otherwise
refCountDec rc = liftIO $ do
    rc' <- allocMem :: IO (Ptr Int32)
    poke rc' rc
    result <- g_ref_count_dec rc'
    let result' = (/= 0) result
    rc'' <- peek rc'
    freeMem rc'
    return (result', rc'')


-- function ref_count_compare
-- Args: [ Arg
--           { argCName = "rc"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the address of a reference count variable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "val"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to compare"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_ref_count_compare" g_ref_count_compare :: 
    Int32 ->                                -- rc : TBasicType TInt
    Int32 ->                                -- val : TBasicType TInt
    IO CInt

-- | Compares the current value of /@rc@/ with /@val@/.
-- 
-- /Since: 2.58/
refCountCompare ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@rc@/: the address of a reference count variable
    -> Int32
    -- ^ /@val@/: the value to compare
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the reference count is the same
    --   as the given value
refCountCompare rc val = liftIO $ do
    result <- g_ref_count_compare rc val
    let result' = (/= 0) result
    return result'


-- function realloc_n
-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory to reallocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_blocks"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of blocks to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_block_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of each block in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_realloc_n" g_realloc_n :: 
    Ptr () ->                               -- mem : TBasicType TPtr
    FCT.CSize ->                            -- n_blocks : TBasicType TSize
    FCT.CSize ->                            -- n_block_bytes : TBasicType TSize
    IO (Ptr ())

-- | This function is similar to 'GI.GLib.Functions.realloc', allocating (/@nBlocks@/ * /@nBlockBytes@/) bytes,
-- but care is taken to detect possible overflow during multiplication.
-- 
-- If the allocation fails (because the system is out of memory),
-- the program is terminated.
-- 
-- /Since: 2.24/
reallocN ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@mem@/: the memory to reallocate
    -> FCT.CSize
    -- ^ /@nBlocks@/: the number of blocks to allocate
    -> FCT.CSize
    -- ^ /@nBlockBytes@/: the size of each block in bytes
    -> m (Ptr ())
    -- ^ __Returns:__ the new address of the allocated memory
reallocN mem nBlocks nBlockBytes = liftIO $ do
    result <- g_realloc_n mem nBlocks nBlockBytes
    return result


-- function realloc
-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory to reallocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new size of the memory in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_realloc" g_realloc :: 
    Ptr () ->                               -- mem : TBasicType TPtr
    FCT.CSize ->                            -- n_bytes : TBasicType TSize
    IO (Ptr ())

-- | Reallocates the memory pointed to by /@mem@/, so that it now has space for
-- /@nBytes@/ bytes of memory. It returns the new address of the memory, which may
-- have been moved. /@mem@/ may be 'P.Nothing', in which case it\'s considered to
-- have zero-length. /@nBytes@/ may be 0, in which case 'P.Nothing' will be returned
-- and /@mem@/ will be freed unless it is 'P.Nothing'.
-- 
-- If the allocation fails (because the system is out of memory),
-- the program is terminated.
realloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@mem@/: the memory to reallocate
    -> FCT.CSize
    -- ^ /@nBytes@/: new size of the memory in bytes
    -> m (Ptr ())
    -- ^ __Returns:__ the new address of the allocated memory
realloc mem nBytes = liftIO $ do
    result <- g_realloc mem nBytes
    return result


-- function rc_box_release_full
-- Args: [ Arg
--           { argCName = "mem_block"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to reference counted data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "clear_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a function to call when clearing the data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_rc_box_release_full" g_rc_box_release_full :: 
    Ptr () ->                               -- mem_block : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- clear_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Releases a reference on the data pointed by /@memBlock@/.
-- 
-- If the reference was the last one, it will call /@clearFunc@/
-- to clear the contents of /@memBlock@/, and then will free the
-- resources allocated for /@memBlock@/.
-- 
-- /Since: 2.58/
rcBoxReleaseFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@memBlock@/: a pointer to reference counted data
    -> GLib.Callbacks.DestroyNotify
    -- ^ /@clearFunc@/: a function to call when clearing the data
    -> m ()
rcBoxReleaseFull memBlock clearFunc = liftIO $ do
    ptrclearFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
    clearFunc' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrclearFunc) clearFunc)
    poke ptrclearFunc clearFunc'
    g_rc_box_release_full memBlock clearFunc'
    return ()


-- function rc_box_release
-- Args: [ Arg
--           { argCName = "mem_block"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to reference counted data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_rc_box_release" g_rc_box_release :: 
    Ptr () ->                               -- mem_block : TBasicType TPtr
    IO ()

-- | Releases a reference on the data pointed by /@memBlock@/.
-- 
-- If the reference was the last one, it will free the
-- resources allocated for /@memBlock@/.
-- 
-- /Since: 2.58/
rcBoxRelease ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@memBlock@/: a pointer to reference counted data
    -> m ()
rcBoxRelease memBlock = liftIO $ do
    g_rc_box_release memBlock
    return ()


-- function rc_box_get_size
-- Args: [ Arg
--           { argCName = "mem_block"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to reference counted data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_rc_box_get_size" g_rc_box_get_size :: 
    Ptr () ->                               -- mem_block : TBasicType TPtr
    IO FCT.CSize

-- | Retrieves the size of the reference counted data pointed by /@memBlock@/.
-- 
-- /Since: 2.58/
rcBoxGetSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@memBlock@/: a pointer to reference counted data
    -> m FCT.CSize
    -- ^ __Returns:__ the size of the data, in bytes
rcBoxGetSize memBlock = liftIO $ do
    result <- g_rc_box_get_size memBlock
    return result


-- function rc_box_dup
-- Args: [ Arg
--           { argCName = "block_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of bytes to copy, must be greater than 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mem_block"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_rc_box_dup" g_rc_box_dup :: 
    FCT.CSize ->                            -- block_size : TBasicType TSize
    Ptr () ->                               -- mem_block : TBasicType TPtr
    IO (Ptr ())

-- | Allocates a new block of data with reference counting
-- semantics, and copies /@blockSize@/ bytes of /@memBlock@/
-- into it.
-- 
-- /Since: 2.58/
rcBoxDup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@blockSize@/: the number of bytes to copy, must be greater than 0
    -> Ptr ()
    -- ^ /@memBlock@/: the memory to copy
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated
    --   memory
rcBoxDup blockSize memBlock = liftIO $ do
    result <- g_rc_box_dup blockSize memBlock
    return result


-- function rc_box_alloc0
-- Args: [ Arg
--           { argCName = "block_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the size of the allocation, must be greater than 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_rc_box_alloc0" g_rc_box_alloc0 :: 
    FCT.CSize ->                            -- block_size : TBasicType TSize
    IO (Ptr ())

-- | Allocates /@blockSize@/ bytes of memory, and adds reference
-- counting semantics to it.
-- 
-- The contents of the returned data is set to zero.
-- 
-- The data will be freed when its reference count drops to
-- zero.
-- 
-- The allocated data is guaranteed to be suitably aligned for any
-- built-in type.
-- 
-- /Since: 2.58/
rcBoxAlloc0 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@blockSize@/: the size of the allocation, must be greater than 0
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated memory
rcBoxAlloc0 blockSize = liftIO $ do
    result <- g_rc_box_alloc0 blockSize
    return result


-- function rc_box_alloc
-- Args: [ Arg
--           { argCName = "block_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the size of the allocation, must be greater than 0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_rc_box_alloc" g_rc_box_alloc :: 
    FCT.CSize ->                            -- block_size : TBasicType TSize
    IO (Ptr ())

-- | Allocates /@blockSize@/ bytes of memory, and adds reference
-- counting semantics to it.
-- 
-- The data will be freed when its reference count drops to
-- zero.
-- 
-- The allocated data is guaranteed to be suitably aligned for any
-- built-in type.
-- 
-- /Since: 2.58/
rcBoxAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@blockSize@/: the size of the allocation, must be greater than 0
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated memory
rcBoxAlloc blockSize = liftIO $ do
    result <- g_rc_box_alloc blockSize
    return result


-- function rc_box_acquire
-- Args: [ Arg
--           { argCName = "mem_block"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to reference counted data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_rc_box_acquire" g_rc_box_acquire :: 
    Ptr () ->                               -- mem_block : TBasicType TPtr
    IO (Ptr ())

-- | Acquires a reference on the data pointed by /@memBlock@/.
-- 
-- /Since: 2.58/
rcBoxAcquire ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@memBlock@/: a pointer to reference counted data
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the data,
    --   with its reference count increased
rcBoxAcquire memBlock = liftIO $ do
    result <- g_rc_box_acquire memBlock
    return result


-- function random_set_seed
-- Args: [ Arg
--           { argCName = "seed"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a value to reinitialize the global random number generator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_random_set_seed" g_random_set_seed :: 
    Word32 ->                               -- seed : TBasicType TUInt32
    IO ()

-- | Sets the seed for the global random number generator, which is used
-- by the g_random_* functions, to /@seed@/.
randomSetSeed ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@seed@/: a value to reinitialize the global random number generator
    -> m ()
randomSetSeed seed = liftIO $ do
    g_random_set_seed seed
    return ()


-- function random_int_range
-- Args: [ Arg
--           { argCName = "begin"
--           , argType = TBasicType TInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "lower closed bound of the interval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "upper open bound of the interval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_random_int_range" g_random_int_range :: 
    Int32 ->                                -- begin : TBasicType TInt32
    Int32 ->                                -- end : TBasicType TInt32
    IO Int32

-- | Returns a random @/gint32/@ equally distributed over the range
-- [/@begin@/../@end@/-1].
randomIntRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@begin@/: lower closed bound of the interval
    -> Int32
    -- ^ /@end@/: upper open bound of the interval
    -> m Int32
    -- ^ __Returns:__ a random number
randomIntRange begin end = liftIO $ do
    result <- g_random_int_range begin end
    return result


-- function random_int
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_random_int" g_random_int :: 
    IO Word32

-- | Return a random @/guint32/@ equally distributed over the range
-- [0..2^32-1].
randomInt ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ a random number
randomInt  = liftIO $ do
    result <- g_random_int
    return result


-- function random_double_range
-- Args: [ Arg
--           { argCName = "begin"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "lower closed bound of the interval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "upper open bound of the interval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "g_random_double_range" g_random_double_range :: 
    CDouble ->                              -- begin : TBasicType TDouble
    CDouble ->                              -- end : TBasicType TDouble
    IO CDouble

-- | Returns a random @/gdouble/@ equally distributed over the range
-- [/@begin@/../@end@/).
randomDoubleRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Double
    -- ^ /@begin@/: lower closed bound of the interval
    -> Double
    -- ^ /@end@/: upper open bound of the interval
    -> m Double
    -- ^ __Returns:__ a random number
randomDoubleRange begin end = liftIO $ do
    let begin' = realToFrac begin
    let end' = realToFrac end
    result <- g_random_double_range begin' end'
    let result' = realToFrac result
    return result'


-- function random_double
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "g_random_double" g_random_double :: 
    IO CDouble

-- | Returns a random @/gdouble/@ equally distributed over the range [0..1).
randomDouble ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Double
    -- ^ __Returns:__ a random number
randomDouble  = liftIO $ do
    result <- g_random_double
    let result' = realToFrac result
    return result'


-- function quark_try_string
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_quark_try_string" g_quark_try_string :: 
    CString ->                              -- string : TBasicType TUTF8
    IO Word32

-- | Gets the @/GQuark/@ associated with the given string, or 0 if string is
-- 'P.Nothing' or it has no associated @/GQuark/@.
-- 
-- If you want the GQuark to be created if it doesn\'t already exist,
-- use 'GI.GLib.Functions.quarkFromString' or 'GI.GLib.Functions.quarkFromStaticString'.
-- 
-- This function must not be used before library constructors have finished
-- running.
quarkTryString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@string@/: a string
    -> m Word32
    -- ^ __Returns:__ the @/GQuark/@ associated with the string, or 0 if /@string@/ is
    --     'P.Nothing' or there is no @/GQuark/@ associated with it
quarkTryString string = liftIO $ do
    maybeString <- case string of
        Nothing -> return FP.nullPtr
        Just jString -> do
            jString' <- textToCString jString
            return jString'
    result <- g_quark_try_string maybeString
    freeMem maybeString
    return result


-- function quark_to_string
-- Args: [ Arg
--           { argCName = "quark"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQuark." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_quark_to_string" g_quark_to_string :: 
    Word32 ->                               -- quark : TBasicType TUInt32
    IO CString

-- | Gets the string associated with the given @/GQuark/@.
quarkToString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@quark@/: a @/GQuark/@.
    -> m T.Text
    -- ^ __Returns:__ the string associated with the @/GQuark/@
quarkToString quark = liftIO $ do
    result <- g_quark_to_string quark
    checkUnexpectedReturnNULL "quarkToString" result
    result' <- cstringToText result
    return result'


-- function quark_from_string
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_quark_from_string" g_quark_from_string :: 
    CString ->                              -- string : TBasicType TUTF8
    IO Word32

-- | Gets the @/GQuark/@ identifying the given string. If the string does
-- not currently have an associated @/GQuark/@, a new @/GQuark/@ is created,
-- using a copy of the string.
-- 
-- This function must not be used before library constructors have finished
-- running. In particular, this means it cannot be used to initialize global
-- variables in C++.
quarkFromString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@string@/: a string
    -> m Word32
    -- ^ __Returns:__ the @/GQuark/@ identifying the string, or 0 if /@string@/ is 'P.Nothing'
quarkFromString string = liftIO $ do
    maybeString <- case string of
        Nothing -> return FP.nullPtr
        Just jString -> do
            jString' <- textToCString jString
            return jString'
    result <- g_quark_from_string maybeString
    freeMem maybeString
    return result


-- function quark_from_static_string
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_quark_from_static_string" g_quark_from_static_string :: 
    CString ->                              -- string : TBasicType TUTF8
    IO Word32

-- | Gets the @/GQuark/@ identifying the given (static) string. If the
-- string does not currently have an associated @/GQuark/@, a new @/GQuark/@
-- is created, linked to the given string.
-- 
-- Note that this function is identical to 'GI.GLib.Functions.quarkFromString' except
-- that if a new @/GQuark/@ is created the string itself is used rather
-- than a copy. This saves memory, but can only be used if the string
-- will continue to exist until the program terminates. It can be used
-- with statically allocated strings in the main program, but not with
-- statically allocated memory in dynamically loaded modules, if you
-- expect to ever unload the module again (e.g. do not use this
-- function in GTK theme engines).
-- 
-- This function must not be used before library constructors have finished
-- running. In particular, this means it cannot be used to initialize global
-- variables in C++.
quarkFromStaticString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@string@/: a string
    -> m Word32
    -- ^ __Returns:__ the @/GQuark/@ identifying the string, or 0 if /@string@/ is 'P.Nothing'
quarkFromStaticString string = liftIO $ do
    maybeString <- case string of
        Nothing -> return FP.nullPtr
        Just jString -> do
            jString' <- textToCString jString
            return jString'
    result <- g_quark_from_static_string maybeString
    freeMem maybeString
    return result


-- function qsort_with_data
-- Args: [ Arg
--           { argCName = "pbase"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "start of array to sort"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "total_elems"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "elements in the array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "size of each element"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "compare_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to compare elements"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @compare_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_qsort_with_data" g_qsort_with_data :: 
    Ptr () ->                               -- pbase : TBasicType TPtr
    Int32 ->                                -- total_elems : TBasicType TInt
    FCT.CSize ->                            -- size : TBasicType TSize
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- compare_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

{-# DEPRECATED qsortWithData ["(Since version 2.82)","@total_elems@ is too small to represent larger arrays; use","  @/GLib.sort_array/@ instead"] #-}
-- | This is just like the standard C <http://developer.gnome.org/glib/stable/man:qsort(3 `qsort()`>) function, but
-- the comparison routine accepts a user data argument
-- (like <http://developer.gnome.org/glib/stable/man:qsort_r(3 `qsort_r()`>)).
-- 
-- Unlike @qsort()@, this is guaranteed to be a stable sort (since GLib 2.32).
qsortWithData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@pbase@/: start of array to sort
    -> Int32
    -- ^ /@totalElems@/: elements in the array
    -> FCT.CSize
    -- ^ /@size@/: size of each element
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@compareFunc@/: function to compare elements
    -> m ()
qsortWithData pbase totalElems size compareFunc = liftIO $ do
    compareFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc compareFunc))
    let userData = nullPtr
    g_qsort_with_data pbase totalElems size compareFunc' userData
    safeFreeFunPtr $ castFunPtrToPtr compareFunc'
    return ()


-- function propagate_error
-- Args: [ Arg
--           { argCName = "dest"
--           , argType = TError
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "error return location"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "src"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "error to move into the return location"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_propagate_error" g_propagate_error :: 
    Ptr (Ptr GError) ->                     -- dest : TError
    Ptr GError ->                           -- src : TError
    IO ()

-- | If /@dest@/ is 'P.Nothing', free /@src@/; otherwise, moves /@src@/ into @*dest@.
-- The error variable /@dest@/ points to must be 'P.Nothing'.
-- 
-- /@src@/ must be non-'P.Nothing'.
-- 
-- Note that /@src@/ is no longer valid after this call. If you want
-- to keep using the same GError*, you need to set it to 'P.Nothing'
-- after calling this function on it.
propagateError ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GError
    -- ^ /@src@/: error to move into the return location
    -> m ((Maybe GError))
propagateError src = liftIO $ do
    dest <- callocMem :: IO (Ptr (Ptr GError))
    src' <- B.ManagedPtr.disownBoxed src
    g_propagate_error dest src'
    dest' <- peek dest
    maybeDest' <- convertIfNonNull dest' $ \dest'' -> do
        dest''' <- (wrapBoxed GError) dest''
        return dest'''
    touchManagedPtr src
    freeMem dest
    return maybeDest'


-- function prefix_error_literal
-- Args: [ Arg
--           { argCName = "err"
--           , argType = TError
--           , direction = DirectionInout
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a return location for a #GError, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "prefix"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to prefix @err with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_prefix_error_literal" g_prefix_error_literal :: 
    Ptr (Ptr GError) ->                     -- err : TError
    CString ->                              -- prefix : TBasicType TUTF8
    IO ()

-- | Prefixes /@prefix@/ to an existing error message. If /@err@/ or @*err@ is
-- 'P.Nothing' (i.e.: no error variable) then do nothing.
-- 
-- /Since: 2.70/
prefixErrorLiteral ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (GError)
    -- ^ /@err@/: a return location for a t'GError', or 'P.Nothing'
    -> T.Text
    -- ^ /@prefix@/: string to prefix /@err@/ with
    -> m ((Maybe GError))
prefixErrorLiteral err prefix = liftIO $ do
    maybeErr <- case err of
        Nothing -> return FP.nullPtr
        Just jErr -> do
            jErr' <- B.ManagedPtr.disownBoxed jErr
            return jErr'
    maybeErr' <- allocMem :: IO (Ptr (Ptr GError))
    poke maybeErr' maybeErr
    prefix' <- textToCString prefix
    g_prefix_error_literal maybeErr' prefix'
    maybeErr'' <- peek maybeErr'
    maybeMaybeErr'' <- convertIfNonNull maybeErr'' $ \maybeErr''' -> do
        maybeErr'''' <- (wrapBoxed GError) maybeErr'''
        return maybeErr''''
    whenJust err touchManagedPtr
    freeMem maybeErr'
    freeMem prefix'
    return maybeMaybeErr''


-- function poll
-- Args: [ Arg
--           { argCName = "fds"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "PollFD" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "file descriptors to poll"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nfds"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of file descriptors in @fds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timeout"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "amount of time to wait, in milliseconds, or -1 to wait forever"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_poll" g_poll :: 
    Ptr GLib.PollFD.PollFD ->               -- fds : TInterface (Name {namespace = "GLib", name = "PollFD"})
    Word32 ->                               -- nfds : TBasicType TUInt
    Int32 ->                                -- timeout : TBasicType TInt
    IO Int32

-- | Polls /@fds@/, as with the @/poll()/@ system call, but portably. (On
-- systems that don\'t have @/poll()/@, it is emulated using @/select()/@.)
-- This is used internally by t'GI.GLib.Structs.MainContext.MainContext', but it can be called
-- directly if you need to block until a file descriptor is ready, but
-- don\'t want to run the full main loop.
-- 
-- Each element of /@fds@/ is a t'GI.GLib.Structs.PollFD.PollFD' describing a single file
-- descriptor to poll. The /@fd@/ field indicates the file descriptor,
-- and the /@events@/ field indicates the events to poll for. On return,
-- the /@revents@/ fields will be filled with the events that actually
-- occurred.
-- 
-- On POSIX systems, the file descriptors in /@fds@/ can be any sort of
-- file descriptor, but the situation is much more complicated on
-- Windows. If you need to use 'GI.GLib.Functions.poll' in code that has to run on
-- Windows, the easiest solution is to construct all of your
-- @/GPollFDs/@ with @/g_io_channel_win32_make_pollfd()/@.
-- 
-- /Since: 2.20/
poll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.PollFD.PollFD
    -- ^ /@fds@/: file descriptors to poll
    -> Word32
    -- ^ /@nfds@/: the number of file descriptors in /@fds@/
    -> Int32
    -- ^ /@timeout@/: amount of time to wait, in milliseconds, or -1 to wait forever
    -> m Int32
    -- ^ __Returns:__ the number of entries in /@fds@/ whose /@revents@/ fields
    -- were filled in, or 0 if the operation timed out, or -1 on error or
    -- if the call was interrupted.
poll fds nfds timeout = liftIO $ do
    fds' <- unsafeManagedPtrGetPtr fds
    result <- g_poll fds' nfds timeout
    touchManagedPtr fds
    return result


-- function pointer_bit_unlock_and_set
-- Args: [ Arg
--           { argCName = "address"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gpointer-sized value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lock_bit"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bit value between 0 and 31"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ptr"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new pointer value to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "preserve_mask"
--           , argType = TBasicType TUIntPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if non-zero, those bits of the current pointer in @address\n  are preserved.\n  Note that the @lock_bit bit will be always unset regardless of\n  @ptr, @preserve_mask and the currently set value in @address."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_pointer_bit_unlock_and_set" g_pointer_bit_unlock_and_set :: 
    Ptr () ->                               -- address : TBasicType TPtr
    Word32 ->                               -- lock_bit : TBasicType TUInt
    Ptr () ->                               -- ptr : TBasicType TPtr
    CUIntPtr ->                             -- preserve_mask : TBasicType TUIntPtr
    IO ()

-- | This is equivalent to 'GI.GLib.Functions.pointerBitUnlock' and atomically setting
-- the pointer value.
-- 
-- Note that the lock bit will be cleared from the pointer. If the unlocked
-- pointer that was set is not identical to /@ptr@/, an assertion fails. In other
-- words, /@ptr@/ must have /@lockBit@/ unset. This also means, you usually can
-- only use this on the lowest bits.
-- 
-- /Since: 2.80/
pointerBitUnlockAndSet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@address@/: a pointer to a @/gpointer/@-sized value
    -> Word32
    -- ^ /@lockBit@/: a bit value between 0 and 31
    -> Ptr ()
    -- ^ /@ptr@/: the new pointer value to set
    -> CUIntPtr
    -- ^ /@preserveMask@/: if non-zero, those bits of the current pointer in /@address@/
    --   are preserved.
    --   Note that the /@lockBit@/ bit will be always unset regardless of
    --   /@ptr@/, /@preserveMask@/ and the currently set value in /@address@/.
    -> m ()
pointerBitUnlockAndSet address lockBit ptr preserveMask = liftIO $ do
    g_pointer_bit_unlock_and_set address lockBit ptr preserveMask
    return ()


-- function pointer_bit_unlock
-- Args: [ Arg
--           { argCName = "address"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gpointer-sized value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lock_bit"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bit value between 0 and 31"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_pointer_bit_unlock" g_pointer_bit_unlock :: 
    Ptr () ->                               -- address : TBasicType TPtr
    Int32 ->                                -- lock_bit : TBasicType TInt
    IO ()

-- | This is equivalent to g_bit_unlock, but working on pointers (or other
-- pointer-sized values).
-- 
-- For portability reasons, you may only lock on the bottom 32 bits of
-- the pointer.
-- 
-- While /@address@/ has a @volatile@ qualifier, this is a historical
-- artifact and the argument passed to it should not be @volatile@.
-- 
-- /Since: 2.30/
pointerBitUnlock ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@address@/: a pointer to a @/gpointer/@-sized value
    -> Int32
    -- ^ /@lockBit@/: a bit value between 0 and 31
    -> m ()
pointerBitUnlock address lockBit = liftIO $ do
    g_pointer_bit_unlock address lockBit
    return ()


-- function pointer_bit_trylock
-- Args: [ Arg
--           { argCName = "address"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gpointer-sized value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lock_bit"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bit value between 0 and 31"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_pointer_bit_trylock" g_pointer_bit_trylock :: 
    Ptr () ->                               -- address : TBasicType TPtr
    Int32 ->                                -- lock_bit : TBasicType TInt
    IO CInt

-- | This is equivalent to 'GI.GLib.Functions.bitTrylock', but working on pointers (or
-- other pointer-sized values).
-- 
-- For portability reasons, you may only lock on the bottom 32 bits of
-- the pointer.
-- 
-- While /@address@/ has a @volatile@ qualifier, this is a historical
-- artifact and the argument passed to it should not be @volatile@.
-- 
-- /Since: 2.30/
pointerBitTrylock ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@address@/: a pointer to a @/gpointer/@-sized value
    -> Int32
    -- ^ /@lockBit@/: a bit value between 0 and 31
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the lock was acquired
pointerBitTrylock address lockBit = liftIO $ do
    result <- g_pointer_bit_trylock address lockBit
    let result' = (/= 0) result
    return result'


-- function pointer_bit_lock_mask_ptr
-- Args: [ Arg
--           { argCName = "ptr"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the pointer to mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lock_bit"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the bit to set/clear. If set to `G_MAXUINT`, the\n  lockbit is taken from @preserve_ptr or @ptr (depending on @preserve_mask)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "set"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether to set (lock) the bit or unset (unlock). This\n  has no effect, if @lock_bit is set to `G_MAXUINT`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "preserve_mask"
--           , argType = TBasicType TUIntPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if non-zero, a bit-mask for @preserve_ptr. The\n  @preserve_mask bits from @preserve_ptr are set in the result.\n  Note that the @lock_bit bit will be always set according to @set,\n  regardless of @preserve_mask and @preserve_ptr (unless @lock_bit is\n  `G_MAXUINT`)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "preserve_ptr"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if @preserve_mask is non-zero, the bits\n  from this pointer are set in the result."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_pointer_bit_lock_mask_ptr" g_pointer_bit_lock_mask_ptr :: 
    Ptr () ->                               -- ptr : TBasicType TPtr
    Word32 ->                               -- lock_bit : TBasicType TUInt
    CInt ->                                 -- set : TBasicType TBoolean
    CUIntPtr ->                             -- preserve_mask : TBasicType TUIntPtr
    Ptr () ->                               -- preserve_ptr : TBasicType TPtr
    IO (Ptr ())

-- | This mangles /@ptr@/ as 'GI.GLib.Functions.pointerBitLock' and 'GI.GLib.Functions.pointerBitUnlock'
-- do.
-- 
-- /Since: 2.80/
pointerBitLockMaskPtr ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@ptr@/: the pointer to mask
    -> Word32
    -- ^ /@lockBit@/: the bit to set\/clear. If set to @G_MAXUINT@, the
    --   lockbit is taken from /@preservePtr@/ or /@ptr@/ (depending on /@preserveMask@/).
    -> Bool
    -- ^ /@set@/: whether to set (lock) the bit or unset (unlock). This
    --   has no effect, if /@lockBit@/ is set to @G_MAXUINT@.
    -> CUIntPtr
    -- ^ /@preserveMask@/: if non-zero, a bit-mask for /@preservePtr@/. The
    --   /@preserveMask@/ bits from /@preservePtr@/ are set in the result.
    --   Note that the /@lockBit@/ bit will be always set according to /@set@/,
    --   regardless of /@preserveMask@/ and /@preservePtr@/ (unless /@lockBit@/ is
    --   @G_MAXUINT@).
    -> Ptr ()
    -- ^ /@preservePtr@/: if /@preserveMask@/ is non-zero, the bits
    --   from this pointer are set in the result.
    -> m (Ptr ())
    -- ^ __Returns:__ the mangled pointer.
pointerBitLockMaskPtr ptr lockBit set preserveMask preservePtr = liftIO $ do
    let set' = (P.fromIntegral . P.fromEnum) set
    result <- g_pointer_bit_lock_mask_ptr ptr lockBit set' preserveMask preservePtr
    return result


-- function pointer_bit_lock_and_get
-- Args: [ Arg
--           { argCName = "address"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gpointer-sized value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lock_bit"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bit value between 0 and 31"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_ptr"
--           , argType = TBasicType TUIntPtr
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "returns the set pointer atomically.\n  This is the value after setting the lock, it thus always has the\n  lock bit set, while previously @address had the lockbit unset.\n  You may also use g_pointer_bit_lock_mask_ptr() to clear the lock bit."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_pointer_bit_lock_and_get" g_pointer_bit_lock_and_get :: 
    Ptr () ->                               -- address : TBasicType TPtr
    Word32 ->                               -- lock_bit : TBasicType TUInt
    Ptr CUIntPtr ->                         -- out_ptr : TBasicType TUIntPtr
    IO ()

-- | This is equivalent to g_bit_lock, but working on pointers (or other
-- pointer-sized values).
-- 
-- For portability reasons, you may only lock on the bottom 32 bits of
-- the pointer.
-- 
-- /Since: 2.80/
pointerBitLockAndGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@address@/: a pointer to a @/gpointer/@-sized value
    -> Word32
    -- ^ /@lockBit@/: a bit value between 0 and 31
    -> m (CUIntPtr)
pointerBitLockAndGet address lockBit = liftIO $ do
    outPtr <- allocMem :: IO (Ptr CUIntPtr)
    g_pointer_bit_lock_and_get address lockBit outPtr
    outPtr' <- peek outPtr
    freeMem outPtr
    return outPtr'


-- function pointer_bit_lock
-- Args: [ Arg
--           { argCName = "address"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gpointer-sized value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lock_bit"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bit value between 0 and 31"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_pointer_bit_lock" g_pointer_bit_lock :: 
    Ptr () ->                               -- address : TBasicType TPtr
    Int32 ->                                -- lock_bit : TBasicType TInt
    IO ()

-- | This is equivalent to g_bit_lock, but working on pointers (or other
-- pointer-sized values).
-- 
-- For portability reasons, you may only lock on the bottom 32 bits of
-- the pointer.
-- 
-- While /@address@/ has a @volatile@ qualifier, this is a historical
-- artifact and the argument passed to it should not be @volatile@.
-- 
-- /Since: 2.30/
pointerBitLock ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@address@/: a pointer to a @/gpointer/@-sized value
    -> Int32
    -- ^ /@lockBit@/: a bit value between 0 and 31
    -> m ()
pointerBitLock address lockBit = liftIO $ do
    g_pointer_bit_lock address lockBit
    return ()


-- function pattern_match_simple
-- Args: [ Arg
--           { argCName = "pattern"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the UTF-8 encoded pattern"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the UTF-8 encoded string to match"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_pattern_match_simple" g_pattern_match_simple :: 
    CString ->                              -- pattern : TBasicType TUTF8
    CString ->                              -- string : TBasicType TUTF8
    IO CInt

-- | Matches a string against a pattern given as a string.
-- 
-- If this
-- function is to be called in a loop, it’s more efficient to compile
-- the pattern once with 'GI.GLib.Structs.PatternSpec.patternSpecNew' and call
-- 'GI.GLib.Structs.PatternSpec.patternSpecMatchString' repeatedly.
patternMatchSimple ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@pattern@/: the UTF-8 encoded pattern
    -> T.Text
    -- ^ /@string@/: the UTF-8 encoded string to match
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@string@/ matches /@pspec@/
patternMatchSimple pattern string = liftIO $ do
    pattern' <- textToCString pattern
    string' <- textToCString string
    result <- g_pattern_match_simple pattern' string'
    let result' = (/= 0) result
    freeMem pattern'
    freeMem string'
    return result'


-- function path_skip_root
-- Args: [ Arg
--           { argCName = "file_name"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_path_skip_root" g_path_skip_root :: 
    CString ->                              -- file_name : TBasicType TFileName
    IO CString

-- | Returns a pointer into /@fileName@/ after the root component,
-- i.e. after the \"\/\" in UNIX or \"C:\\\" under Windows. If /@fileName@/
-- is not an absolute path it returns 'P.Nothing'.
pathSkipRoot ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@fileName@/: a file name
    -> m (Maybe [Char])
    -- ^ __Returns:__ a pointer into /@fileName@/ after the
    --     root component
pathSkipRoot fileName = liftIO $ do
    fileName' <- stringToCString fileName
    result <- g_path_skip_root fileName'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToString result'
        return result''
    freeMem fileName'
    return maybeResult


-- function path_is_absolute
-- Args: [ Arg
--           { argCName = "file_name"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_path_is_absolute" g_path_is_absolute :: 
    CString ->                              -- file_name : TBasicType TFileName
    IO CInt

-- | Returns 'P.True' if the given /@fileName@/ is an absolute file name.
-- Note that this is a somewhat vague concept on Windows.
-- 
-- On POSIX systems, an absolute file name is well-defined. It always
-- starts from the single root directory. For example \"\/usr\/local\".
-- 
-- On Windows, the concepts of current drive and drive-specific
-- current directory introduce vagueness. This function interprets as
-- an absolute file name one that either begins with a directory
-- separator such as \"\\Users\\tml\" or begins with the root on a drive,
-- for example \"C:\\Windows\". The first case also includes UNC paths
-- such as \"\\\\myserver\\docs\\foo\". In all cases, either slashes or
-- backslashes are accepted.
-- 
-- Note that a file name relative to the current drive root does not
-- truly specify a file uniquely over time and across processes, as
-- the current drive is a per-process value and can be changed.
-- 
-- File names relative the current directory on some specific drive,
-- such as \"D:foo\/bar\", are not interpreted as absolute by this
-- function, but they obviously are not relative to the normal current
-- directory as returned by @/getcwd()/@ or 'GI.GLib.Functions.getCurrentDir'
-- either. Such paths should be avoided, or need to be handled using
-- Windows-specific code.
pathIsAbsolute ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@fileName@/: a file name
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@fileName@/ is absolute
pathIsAbsolute fileName = liftIO $ do
    fileName' <- stringToCString fileName
    result <- g_path_is_absolute fileName'
    let result' = (/= 0) result
    freeMem fileName'
    return result'


-- function path_get_dirname
-- Args: [ Arg
--           { argCName = "file_name"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the file"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_path_get_dirname" g_path_get_dirname :: 
    CString ->                              -- file_name : TBasicType TFileName
    IO CString

-- | Gets the directory components of a file name. For example, the directory
-- component of @\/usr\/bin\/test@ is @\/usr\/bin@. The directory component of @\/@
-- is @\/@.
-- 
-- If the file name has no directory components \".\" is returned.
-- The returned string should be freed when no longer needed.
pathGetDirname ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@fileName@/: the name of the file
    -> m [Char]
    -- ^ __Returns:__ the directory components of the file
pathGetDirname fileName = liftIO $ do
    fileName' <- stringToCString fileName
    result <- g_path_get_dirname fileName'
    checkUnexpectedReturnNULL "pathGetDirname" result
    result' <- cstringToString result
    freeMem result
    freeMem fileName'
    return result'


-- function path_get_basename
-- Args: [ Arg
--           { argCName = "file_name"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the file"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_path_get_basename" g_path_get_basename :: 
    CString ->                              -- file_name : TBasicType TFileName
    IO CString

-- | Gets the last component of the filename.
-- 
-- If /@fileName@/ ends with a directory separator it gets the component
-- before the last slash. If /@fileName@/ consists only of directory
-- separators (and on Windows, possibly a drive letter), a single
-- separator is returned. If /@fileName@/ is empty, it gets \".\".
pathGetBasename ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@fileName@/: the name of the file
    -> m [Char]
    -- ^ __Returns:__ a newly allocated string
    --   containing the last component of the filename
pathGetBasename fileName = liftIO $ do
    fileName' <- stringToCString fileName
    result <- g_path_get_basename fileName'
    checkUnexpectedReturnNULL "pathGetBasename" result
    result' <- cstringToString result
    freeMem result
    freeMem fileName'
    return result'


-- function parse_debug_string
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a list of debug options separated by colons, spaces, or\ncommas, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keys"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "GLib" , name = "DebugKey" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "pointer to an array of #GDebugKey which associate\n    strings with bit flags."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nkeys"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of #GDebugKeys in the array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "nkeys"
--              , argType = TBasicType TUInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of #GDebugKeys in the array."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_parse_debug_string" g_parse_debug_string :: 
    CString ->                              -- string : TBasicType TUTF8
    Ptr GLib.DebugKey.DebugKey ->           -- keys : TCArray False (-1) 2 (TInterface (Name {namespace = "GLib", name = "DebugKey"}))
    Word32 ->                               -- nkeys : TBasicType TUInt
    IO Word32

-- | Parses a string containing debugging options
-- into a @/guint/@ containing bit flags. This is used
-- within GDK and GTK to parse the debug options passed on the
-- command line or through environment variables.
-- 
-- If /@string@/ is equal to \"all\", all flags are set. Any flags
-- specified along with \"all\" in /@string@/ are inverted; thus,
-- \"all,foo,bar\" or \"foo,bar,all\" sets all flags except those
-- corresponding to \"foo\" and \"bar\".
-- 
-- If /@string@/ is equal to \"help\", all the available keys in /@keys@/
-- are printed out to standard error.
parseDebugString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@string@/: a list of debug options separated by colons, spaces, or
    -- commas, or 'P.Nothing'.
    -> [GLib.DebugKey.DebugKey]
    -- ^ /@keys@/: pointer to an array of t'GI.GLib.Structs.DebugKey.DebugKey' which associate
    --     strings with bit flags.
    -> m Word32
    -- ^ __Returns:__ the combined set of bit flags.
parseDebugString string keys = liftIO $ do
    let nkeys = fromIntegral $ P.length keys
    maybeString <- case string of
        Nothing -> return FP.nullPtr
        Just jString -> do
            jString' <- textToCString jString
            return jString'
    keys' <- mapM unsafeManagedPtrGetPtr keys
    keys'' <- packBlockArray 16 keys'
    result <- g_parse_debug_string maybeString keys'' nkeys
    mapM_ touchManagedPtr keys
    freeMem maybeString
    freeMem keys''
    return result


-- function option_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_option_error_quark" g_option_error_quark :: 
    IO Word32

-- | /No description available in the introspection data./
optionErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
optionErrorQuark  = liftIO $ do
    result <- g_option_error_quark
    return result


-- function open
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "as in open()" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "as in open()" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_open" g_open :: 
    CString ->                              -- filename : TBasicType TFileName
    Int32 ->                                -- flags : TBasicType TInt
    Int32 ->                                -- mode : TBasicType TInt
    IO Int32

-- | A wrapper for the POSIX @/open()/@ function. The @/open()/@ function is
-- used to convert a pathname into a file descriptor.
-- 
-- On POSIX systems file descriptors are implemented by the operating
-- system. On Windows, it\'s the C library that implements @/open()/@ and
-- file descriptors. The actual Win32 API for opening files is quite
-- different, see MSDN documentation for @/CreateFile()/@. The Win32 API
-- uses file handles, which are more randomish integers, not small
-- integers like file descriptors.
-- 
-- Because file descriptors are specific to the C library on Windows,
-- the file descriptor returned by this function makes sense only to
-- functions in the same C library. Thus if the GLib-using code uses a
-- different C library than GLib does, the file descriptor returned by
-- this function cannot be passed to C library functions like @/write()/@
-- or @/read()/@.
-- 
-- See your C library manual for more details about @/open()/@.
-- 
-- /Since: 2.6/
open ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> Int32
    -- ^ /@flags@/: as in @/open()/@
    -> Int32
    -- ^ /@mode@/: as in @/open()/@
    -> m Int32
    -- ^ __Returns:__ a new file descriptor, or -1 if an error occurred.
    --     The return value can be used exactly like the return value
    --     from @/open()/@.
open filename flags mode = liftIO $ do
    filename' <- stringToCString filename
    result <- g_open filename' flags mode
    freeMem filename'
    return result


-- function on_error_stack_trace
-- Args: [ Arg
--           { argCName = "prg_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the program name, needed by gdb for the\n  \"[S]tack trace\" option, or `NULL` to use a default string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_on_error_stack_trace" g_on_error_stack_trace :: 
    CString ->                              -- prg_name : TBasicType TUTF8
    IO ()

-- | Invokes gdb, which attaches to the current process and shows a
-- stack trace. Called by 'GI.GLib.Functions.onErrorQuery' when the \"[S]tack trace\"
-- option is selected. You can get the current process\'s program name
-- with 'GI.GLib.Functions.getPrgname', assuming that you have called @/gtk_init()/@ or
-- @/gdk_init()/@.
-- 
-- This function may cause different actions on non-UNIX platforms.
-- 
-- When running on Windows, this function is *not* called by
-- 'GI.GLib.Functions.onErrorQuery'. If called directly, it will raise an
-- exception, which will crash the program. If the @G_DEBUGGER@ environment
-- variable is set, a debugger will be invoked to attach and
-- handle that exception (see <http://developer.gnome.org/glib/stable/running.html Running GLib Applications>).
onErrorStackTrace ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@prgName@/: the program name, needed by gdb for the
    --   \"[S]tack trace\" option, or @NULL@ to use a default string
    -> m ()
onErrorStackTrace prgName = liftIO $ do
    maybePrgName <- case prgName of
        Nothing -> return FP.nullPtr
        Just jPrgName -> do
            jPrgName' <- textToCString jPrgName
            return jPrgName'
    g_on_error_stack_trace maybePrgName
    freeMem maybePrgName
    return ()


-- function on_error_query
-- Args: [ Arg
--           { argCName = "prg_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the program name, needed by gdb for the \"[S]tack trace\"\n    option. If @prg_name is %NULL, g_get_prgname() is called to get\n    the program name (which will work correctly if gdk_init() or\n    gtk_init() has been called)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_on_error_query" g_on_error_query :: 
    CString ->                              -- prg_name : TBasicType TUTF8
    IO ()

-- | Prompts the user with
-- @[E]xit, [H]alt, show [S]tack trace or [P]roceed@.
-- This function is intended to be used for debugging use only.
-- The following example shows how it can be used together with
-- the @/g_log()/@ functions.
-- 
-- 
-- === /C code/
-- >
-- >#include <glib.h>
-- >
-- >static void
-- >log_handler (const gchar   *log_domain,
-- >             GLogLevelFlags log_level,
-- >             const gchar   *message,
-- >             gpointer       user_data)
-- >{
-- >  g_log_default_handler (log_domain, log_level, message, user_data);
-- >
-- >  g_on_error_query (MY_PROGRAM_NAME);
-- >}
-- >
-- >int
-- >main (int argc, char *argv[])
-- >{
-- >  g_log_set_handler (MY_LOG_DOMAIN,
-- >                     G_LOG_LEVEL_WARNING |
-- >                     G_LOG_LEVEL_ERROR |
-- >                     G_LOG_LEVEL_CRITICAL,
-- >                     log_handler,
-- >                     NULL);
-- >  ...
-- 
-- 
-- If \"[E]xit\" is selected, the application terminates with a call
-- to _exit(0).
-- 
-- If \"[S]tack\" trace is selected, 'GI.GLib.Functions.onErrorStackTrace' is called.
-- This invokes gdb, which attaches to the current process and shows
-- a stack trace. The prompt is then shown again.
-- 
-- If \"[P]roceed\" is selected, the function returns.
-- 
-- This function may cause different actions on non-UNIX platforms.
-- 
-- On Windows consider using the @G_DEBUGGER@ environment
-- variable (see <http://developer.gnome.org/glib/stable/running.html Running GLib Applications>) and
-- calling 'GI.GLib.Functions.onErrorStackTrace' instead.
onErrorQuery ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@prgName@/: the program name, needed by gdb for the \"[S]tack trace\"
    --     option. If /@prgName@/ is 'P.Nothing', 'GI.GLib.Functions.getPrgname' is called to get
    --     the program name (which will work correctly if @/gdk_init()/@ or
    --     @/gtk_init()/@ has been called)
    -> m ()
onErrorQuery prgName = liftIO $ do
    prgName' <- textToCString prgName
    g_on_error_query prgName'
    freeMem prgName'
    return ()


-- function number_parser_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_number_parser_error_quark" g_number_parser_error_quark :: 
    IO Word32

-- | /No description available in the introspection data./
numberParserErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
numberParserErrorQuark  = liftIO $ do
    result <- g_number_parser_error_quark
    return result


-- function nullify_pointer
-- Args: [ Arg
--           { argCName = "nullify_location"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory address of the pointer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_nullify_pointer" g_nullify_pointer :: 
    Ptr () ->                               -- nullify_location : TBasicType TPtr
    IO ()

-- | Set the pointer at the specified location to 'P.Nothing'.
nullifyPointer ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@nullifyLocation@/: the memory address of the pointer.
    -> m ()
nullifyPointer nullifyLocation = liftIO $ do
    g_nullify_pointer nullifyLocation
    return ()


-- function mkdir_with_parents
-- Args: [ Arg
--           { argCName = "pathname"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pathname in the GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "permissions to use for newly created directories"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_mkdir_with_parents" g_mkdir_with_parents :: 
    CString ->                              -- pathname : TBasicType TFileName
    Int32 ->                                -- mode : TBasicType TInt
    IO Int32

-- | Create a directory if it doesn\'t already exist. Create intermediate
-- parent directories as needed, too.
-- 
-- /Since: 2.8/
mkdirWithParents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@pathname@/: a pathname in the GLib file name encoding
    -> Int32
    -- ^ /@mode@/: permissions to use for newly created directories
    -> m Int32
    -- ^ __Returns:__ 0 if the directory already exists, or was successfully
    -- created. Returns -1 if an error occurred, with errno set.
mkdirWithParents pathname mode = liftIO $ do
    pathname' <- stringToCString pathname
    result <- g_mkdir_with_parents pathname' mode
    freeMem pathname'
    return result


-- function mkdir
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "permissions to use for the newly created directory"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_mkdir" g_mkdir :: 
    CString ->                              -- filename : TBasicType TFileName
    Int32 ->                                -- mode : TBasicType TInt
    IO Int32

-- | A wrapper for the POSIX @/mkdir()/@ function. The @/mkdir()/@ function
-- attempts to create a directory with the given name and permissions.
-- The mode argument is ignored on Windows.
-- 
-- See your C library manual for more details about @/mkdir()/@.
-- 
-- /Since: 2.6/
mkdir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> Int32
    -- ^ /@mode@/: permissions to use for the newly created directory
    -> m Int32
    -- ^ __Returns:__ 0 if the directory was successfully created, -1 if an error
    --    occurred
mkdir filename mode = liftIO $ do
    filename' <- stringToCString filename
    result <- g_mkdir filename' mode
    freeMem filename'
    return result


-- function memdup2
-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "byte_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to copy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_memdup2" g_memdup2 :: 
    Ptr () ->                               -- mem : TBasicType TPtr
    FCT.CSize ->                            -- byte_size : TBasicType TSize
    IO (Ptr ())

-- | Allocates /@byteSize@/ bytes of memory, and copies /@byteSize@/ bytes into it
-- from /@mem@/. If /@mem@/ is @NULL@ it returns @NULL@.
-- 
-- This replaces 'GI.GLib.Functions.memdup', which was prone to integer overflows when
-- converting the argument from a @gsize@ to a @guint@.
-- 
-- /Since: 2.68/
memdup2 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@mem@/: the memory to copy
    -> FCT.CSize
    -- ^ /@byteSize@/: the number of bytes to copy
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the newly-allocated copy of the memory
memdup2 mem byteSize = liftIO $ do
    result <- g_memdup2 mem byteSize
    return result


-- function memdup
-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "byte_size"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to copy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_memdup" g_memdup :: 
    Ptr () ->                               -- mem : TBasicType TPtr
    Word32 ->                               -- byte_size : TBasicType TUInt
    IO (Ptr ())

{-# DEPRECATED memdup ["(Since version 2.68)","Use 'GI.GLib.Functions.memdup2' instead, as it accepts a gsize argument","  for /@byteSize@/, avoiding the possibility of overflow in a @gsize@ \8594 @guint@","  conversion"] #-}
-- | Allocates /@byteSize@/ bytes of memory, and copies /@byteSize@/ bytes into it
-- from /@mem@/. If /@mem@/ is @NULL@ it returns @NULL@.
memdup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@mem@/: the memory to copy
    -> Word32
    -- ^ /@byteSize@/: the number of bytes to copy
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the newly-allocated copy of the memory
memdup mem byteSize = liftIO $ do
    result <- g_memdup mem byteSize
    return result


-- function mem_set_vtable
-- Args: [ Arg
--           { argCName = "vtable"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MemVTable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "table of memory allocation routines."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mem_set_vtable" g_mem_set_vtable :: 
    Ptr GLib.MemVTable.MemVTable ->         -- vtable : TInterface (Name {namespace = "GLib", name = "MemVTable"})
    IO ()

{-# DEPRECATED memSetVtable ["(Since version 2.46)","This function now does nothing. Use other memory","profiling tools instead"] #-}
-- | This function used to let you override the memory allocation function.
-- However, its use was incompatible with the use of global constructors
-- in GLib and GIO, because those use the GLib allocators before main is
-- reached. Therefore this function is now deprecated and is just a stub.
memSetVtable ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.MemVTable.MemVTable
    -- ^ /@vtable@/: table of memory allocation routines.
    -> m ()
memSetVtable vtable = liftIO $ do
    vtable' <- unsafeManagedPtrGetPtr vtable
    g_mem_set_vtable vtable'
    touchManagedPtr vtable
    return ()


-- function mem_profile
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mem_profile" g_mem_profile :: 
    IO ()

{-# DEPRECATED memProfile ["(Since version 2.46)","Use other memory profiling tools instead"] #-}
-- | GLib used to support some tools for memory profiling, but this
-- no longer works. There are many other useful tools for memory
-- profiling these days which can be used instead.
memProfile ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
memProfile  = liftIO $ do
    g_mem_profile
    return ()


-- function mem_is_system_malloc
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_mem_is_system_malloc" g_mem_is_system_malloc :: 
    IO CInt

{-# DEPRECATED memIsSystemMalloc ["(Since version 2.46)","GLib always uses the system malloc, so this function always","returns 'P.True'."] #-}
-- | Checks whether the allocator used by 'GI.GLib.Functions.malloc' is the system\'s
-- malloc implementation. If it returns 'P.True' memory allocated with
-- @/malloc()/@ can be used interchangeably with memory allocated using 'GI.GLib.Functions.malloc'.
-- This function is useful for avoiding an extra copy of allocated memory returned
-- by a non-GLib-based API.
memIsSystemMalloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ if 'P.True', @/malloc()/@ and 'GI.GLib.Functions.malloc' can be mixed.
memIsSystemMalloc  = liftIO $ do
    result <- g_mem_is_system_malloc
    let result' = (/= 0) result
    return result'


-- function markup_escape_text
-- Args: [ Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "some valid UTF-8 text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "length of @text in bytes, or -1 if the text is nul-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_escape_text" g_markup_escape_text :: 
    CString ->                              -- text : TBasicType TUTF8
    DI.Int64 ->                             -- length : TBasicType TSSize
    IO CString

-- | Escapes text so that the markup parser will parse it verbatim.
-- Less than, greater than, ampersand, etc. are replaced with the
-- corresponding entities. This function would typically be used
-- when writing out a file to be parsed with the markup parser.
-- 
-- Note that this function doesn\'t protect whitespace and line endings
-- from being processed according to the XML rules for normalization
-- of line endings and attribute values.
-- 
-- Note also that this function will produce character references in
-- the range of &@/x1/@; ... &@/x1f/@; for all control sequences
-- except for tabstop, newline and carriage return.  The character
-- references in this range are not valid XML 1.0, but they are
-- valid XML 1.1 and will be accepted by the GMarkup parser.
markupEscapeText ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@text@/: some valid UTF-8 text
    -> DI.Int64
    -- ^ /@length@/: length of /@text@/ in bytes, or -1 if the text is nul-terminated
    -> m T.Text
    -- ^ __Returns:__ a newly allocated string with the escaped text
markupEscapeText text length_ = liftIO $ do
    text' <- textToCString text
    result <- g_markup_escape_text text' length_
    checkUnexpectedReturnNULL "markupEscapeText" result
    result' <- cstringToText result
    freeMem result
    freeMem text'
    return result'


-- function markup_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_markup_error_quark" g_markup_error_quark :: 
    IO Word32

-- | /No description available in the introspection data./
markupErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
markupErrorQuark  = liftIO $ do
    result <- g_markup_error_quark
    return result


-- function malloc_n
-- Args: [ Arg
--           { argCName = "n_blocks"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of blocks to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_block_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of each block in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_malloc_n" g_malloc_n :: 
    FCT.CSize ->                            -- n_blocks : TBasicType TSize
    FCT.CSize ->                            -- n_block_bytes : TBasicType TSize
    IO (Ptr ())

-- | This function is similar to 'GI.GLib.Functions.malloc', allocating (/@nBlocks@/ * /@nBlockBytes@/) bytes,
-- but care is taken to detect possible overflow during multiplication.
-- 
-- If the allocation fails (because the system is out of memory),
-- the program is terminated.
-- 
-- /Since: 2.24/
mallocN ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@nBlocks@/: the number of blocks to allocate
    -> FCT.CSize
    -- ^ /@nBlockBytes@/: the size of each block in bytes
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated memory
mallocN nBlocks nBlockBytes = liftIO $ do
    result <- g_malloc_n nBlocks nBlockBytes
    return result


-- function malloc0_n
-- Args: [ Arg
--           { argCName = "n_blocks"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of blocks to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_block_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of each block in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_malloc0_n" g_malloc0_n :: 
    FCT.CSize ->                            -- n_blocks : TBasicType TSize
    FCT.CSize ->                            -- n_block_bytes : TBasicType TSize
    IO (Ptr ())

-- | This function is similar to 'GI.GLib.Functions.malloc0', allocating (/@nBlocks@/ * /@nBlockBytes@/) bytes,
-- but care is taken to detect possible overflow during multiplication.
-- 
-- If the allocation fails (because the system is out of memory),
-- the program is terminated.
-- 
-- /Since: 2.24/
malloc0N ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@nBlocks@/: the number of blocks to allocate
    -> FCT.CSize
    -- ^ /@nBlockBytes@/: the size of each block in bytes
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated memory
malloc0N nBlocks nBlockBytes = liftIO $ do
    result <- g_malloc0_n nBlocks nBlockBytes
    return result


-- function malloc0
-- Args: [ Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_malloc0" g_malloc0 :: 
    FCT.CSize ->                            -- n_bytes : TBasicType TSize
    IO (Ptr ())

-- | Allocates /@nBytes@/ bytes of memory, initialized to 0\'s.
-- If /@nBytes@/ is 0 it returns 'P.Nothing'.
-- 
-- If the allocation fails (because the system is out of memory),
-- the program is terminated.
malloc0 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@nBytes@/: the number of bytes to allocate
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated memory
malloc0 nBytes = liftIO $ do
    result <- g_malloc0 nBytes
    return result


-- function malloc
-- Args: [ Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to allocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_malloc" g_malloc :: 
    FCT.CSize ->                            -- n_bytes : TBasicType TSize
    IO (Ptr ())

-- | Allocates /@nBytes@/ bytes of memory.
-- If /@nBytes@/ is 0 it returns 'P.Nothing'.
-- 
-- If the allocation fails (because the system is out of memory),
-- the program is terminated.
malloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FCT.CSize
    -- ^ /@nBytes@/: the number of bytes to allocate
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the allocated memory
malloc nBytes = liftIO $ do
    result <- g_malloc nBytes
    return result


-- function main_depth
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_depth" g_main_depth :: 
    IO Int32

-- | Returns the depth of the stack of calls to
-- 'GI.GLib.Structs.MainContext.mainContextDispatch' on any t'GI.GLib.Structs.MainContext.MainContext' in the current thread.
-- 
-- That is, when called from the top level, it gives @0@. When
-- called from within a callback from 'GI.GLib.Structs.MainContext.mainContextIteration'
-- (or 'GI.GLib.Structs.MainLoop.mainLoopRun', etc.) it returns @1@. When called from within
-- a callback to a recursive call to 'GI.GLib.Structs.MainContext.mainContextIteration',
-- it returns @2@. And so forth.
-- 
-- This function is useful in a situation like the following:
-- Imagine an extremely simple ‘garbage collected’ system.
-- 
-- 
-- === /c code/
-- >static GList *free_list;
-- >
-- >gpointer
-- >allocate_memory (gsize size)
-- >{
-- >  gpointer result = g_malloc (size);
-- >  free_list = g_list_prepend (free_list, result);
-- >  return result;
-- >}
-- >
-- >void
-- >free_allocated_memory (void)
-- >{
-- >  GList *l;
-- >  for (l = free_list; l; l = l->next);
-- >    g_free (l->data);
-- >  g_list_free (free_list);
-- >  free_list = NULL;
-- > }
-- >
-- >[...]
-- >
-- >while (TRUE);
-- > {
-- >   g_main_context_iteration (NULL, TRUE);
-- >   free_allocated_memory();
-- >  }
-- 
-- 
-- This works from an application, however, if you want to do the same
-- thing from a library, it gets more difficult, since you no longer
-- control the main loop. You might think you can simply use an idle
-- function to make the call to @free_allocated_memory()@, but that
-- doesn’t work, since the idle function could be called from a
-- recursive callback. This can be fixed by using 'GI.GLib.Functions.mainDepth'
-- 
-- 
-- === /c code/
-- >gpointer
-- >allocate_memory (gsize size)
-- >{
-- >  FreeListBlock *block = g_new (FreeListBlock, 1);
-- >  block->mem = g_malloc (size);
-- >  block->depth = g_main_depth ();
-- >  free_list = g_list_prepend (free_list, block);
-- >  return block->mem;
-- >}
-- >
-- >void
-- >free_allocated_memory (void)
-- >{
-- >  GList *l;
-- >  
-- >  int depth = g_main_depth ();
-- >  for (l = free_list; l; );
-- >    {
-- >      GList *next = l->next;
-- >      FreeListBlock *block = l->data;
-- >      if (block->depth > depth)
-- >        {
-- >          g_free (block->mem);
-- >          g_free (block);
-- >          free_list = g_list_delete_link (free_list, l);
-- >        }
-- >              
-- >      l = next;
-- >    }
-- >  }
-- 
-- 
-- There is a temptation to use 'GI.GLib.Functions.mainDepth' to solve
-- problems with reentrancy. For instance, while waiting for data
-- to be received from the network in response to a menu item,
-- the menu item might be selected again. It might seem that
-- one could make the menu item’s callback return immediately
-- and do nothing if 'GI.GLib.Functions.mainDepth' returns a value greater than 1.
-- However, this should be avoided since the user then sees selecting
-- the menu item do nothing. Furthermore, you’ll find yourself adding
-- these checks all over your code, since there are doubtless many,
-- many things that the user could do. Instead, you can use the
-- following techniques:
-- 
-- 1. Use @gtk_widget_set_sensitive()@ or modal dialogs to prevent
--    the user from interacting with elements while the main
--    loop is recursing.
-- 
-- 2. Avoid main loop recursion in situations where you can’t handle
--    arbitrary  callbacks. Instead, structure your code so that you
--    simply return to the main loop and then get called again when
--    there is more work to do.
-- 
mainDepth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ the main loop recursion level in the current thread
mainDepth  = liftIO $ do
    result <- g_main_depth
    return result


-- function main_current_source
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_current_source" g_main_current_source :: 
    IO (Ptr GLib.Source.Source)

-- | Returns the currently firing source for this thread.
-- 
-- /Since: 2.12/
mainCurrentSource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe GLib.Source.Source)
    -- ^ __Returns:__ the currently firing source, or @NULL@
    --   if none is firing
mainCurrentSource  = liftIO $ do
    result <- g_main_current_source
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed GLib.Source.Source) result'
        return result''
    return maybeResult


-- function lstat
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buf"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StatBuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to a stat struct, which will be filled with the file\n    information"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_lstat" g_lstat :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr GLib.StatBuf.StatBuf ->             -- buf : TInterface (Name {namespace = "GLib", name = "StatBuf"})
    IO Int32

-- | A wrapper for the POSIX @/lstat()/@ function. The @/lstat()/@ function is
-- like @/stat()/@ except that in the case of symbolic links, it returns
-- information about the symbolic link itself and not the file that it
-- refers to. If the system does not support symbolic links 'GI.GLib.Functions.lstat'
-- is identical to 'GI.GLib.Functions.stat'.
-- 
-- See your C library manual for more details about @/lstat()/@.
-- 
-- /Since: 2.6/
lstat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> GLib.StatBuf.StatBuf
    -- ^ /@buf@/: a pointer to a stat struct, which will be filled with the file
    --     information
    -> m Int32
    -- ^ __Returns:__ 0 if the information was successfully retrieved,
    --     -1 if an error occurred
lstat filename buf = liftIO $ do
    filename' <- stringToCString filename
    buf' <- unsafeManagedPtrGetPtr buf
    result <- g_lstat filename' buf'
    touchManagedPtr buf
    freeMem filename'
    return result


-- function log_writer_syslog
-- Args: [ Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "log level, either from [type@GLib.LogLevelFlags], or a user-defined\n   level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fields"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "GLib" , name = "LogField" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "key\8211value pairs of structured data forming\n   the log message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fields"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of elements in the @fields array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to [func@GLib.log_set_writer_func]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fields"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of elements in the @fields array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "LogWriterOutput" })
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_syslog" g_log_writer_syslog :: 
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    Ptr GLib.LogField.LogField ->           -- fields : TCArray False (-1) 2 (TInterface (Name {namespace = "GLib", name = "LogField"}))
    FCT.CSize ->                            -- n_fields : TBasicType TSize
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO CUInt

-- | Format a structured log message and send it to the syslog daemon. Only fields
-- which are understood by this function are included in the formatted string
-- which is printed.
-- 
-- Log facility will be defined via the SYSLOG_FACILITY field and accepts the following
-- values: \"auth\", \"daemon\", and \"user\". If SYSLOG_FACILITY is not specified, LOG_USER
-- facility will be used.
-- 
-- This is suitable for use as a [type/@gLib@/.LogWriterFunc].
-- 
-- If syslog is not supported, this function is still defined, but will always
-- return 'GI.GLib.Enums.LogWriterOutputUnhandled'.
-- 
-- /Since: 2.80/
logWriterSyslog ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level, either from [type/@gLib@/.LogLevelFlags], or a user-defined
    --    level
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: key–value pairs of structured data forming
    --    the log message
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.logSetWriterFunc'
    -> m GLib.Enums.LogWriterOutput
    -- ^ __Returns:__ 'GI.GLib.Enums.LogWriterOutputHandled' on success, 'GI.GLib.Enums.LogWriterOutputUnhandled' otherwise
logWriterSyslog logLevel fields userData = liftIO $ do
    let nFields = fromIntegral $ P.length fields
    let logLevel' = gflagsToWord logLevel
    fields' <- mapM unsafeManagedPtrGetPtr fields
    fields'' <- packBlockArray 24 fields'
    result <- g_log_writer_syslog logLevel' fields'' nFields userData
    let result' = (toEnum . fromIntegral) result
    mapM_ touchManagedPtr fields
    freeMem fields''
    return result'


-- function log_writer_supports_color
-- Args: [ Arg
--           { argCName = "output_fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "output file descriptor to check"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_supports_color" g_log_writer_supports_color :: 
    Int32 ->                                -- output_fd : TBasicType TInt
    IO CInt

-- | Check whether the given /@outputFd@/ file descriptor supports
-- <https://en.wikipedia.org/wiki/ANSI_escape_code ANSI color escape sequences>.
-- 
-- If so, they can safely be used when formatting log messages.
-- 
-- /Since: 2.50/
logWriterSupportsColor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@outputFd@/: output file descriptor to check
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if ANSI color escapes are supported, @FALSE@ otherwise
logWriterSupportsColor outputFd = liftIO $ do
    result <- g_log_writer_supports_color outputFd
    let result' = (/= 0) result
    return result'


-- function log_writer_standard_streams
-- Args: [ Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "log level, either from [type@GLib.LogLevelFlags], or a user-defined\n   level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fields"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "GLib" , name = "LogField" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "key\8211value pairs of structured data forming\n   the log message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fields"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of elements in the @fields array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to [func@GLib.log_set_writer_func]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fields"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of elements in the @fields array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "LogWriterOutput" })
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_standard_streams" g_log_writer_standard_streams :: 
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    Ptr GLib.LogField.LogField ->           -- fields : TCArray False (-1) 2 (TInterface (Name {namespace = "GLib", name = "LogField"}))
    FCT.CSize ->                            -- n_fields : TBasicType TSize
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO CUInt

-- | Format a structured log message and print it to either @stdout@ or @stderr@,
-- depending on its log level.
-- 
-- [flags/@gLib@/.LogLevelFlags.LEVEL_INFO] and [flags/@gLib@/.LogLevelFlags.LEVEL_DEBUG] messages
-- are sent to @stdout@, or to @stderr@ if requested by
-- 'GI.GLib.Functions.logWriterDefaultSetUseStderr';
-- all other log levels are sent to @stderr@. Only fields
-- which are understood by this function are included in the formatted string
-- which is printed.
-- 
-- If the output stream supports
-- <https://en.wikipedia.org/wiki/ANSI_escape_code ANSI color escape sequences>,
-- they will be used in the output.
-- 
-- A trailing new-line character is added to the log message when it is printed.
-- 
-- This is suitable for use as a [type/@gLib@/.LogWriterFunc].
-- 
-- /Since: 2.50/
logWriterStandardStreams ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level, either from [type/@gLib@/.LogLevelFlags], or a user-defined
    --    level
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: key–value pairs of structured data forming
    --    the log message
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.logSetWriterFunc'
    -> m GLib.Enums.LogWriterOutput
    -- ^ __Returns:__ 'GI.GLib.Enums.LogWriterOutputHandled' on success,
    --   'GI.GLib.Enums.LogWriterOutputUnhandled' otherwise
logWriterStandardStreams logLevel fields userData = liftIO $ do
    let nFields = fromIntegral $ P.length fields
    let logLevel' = gflagsToWord logLevel
    fields' <- mapM unsafeManagedPtrGetPtr fields
    fields'' <- packBlockArray 24 fields'
    result <- g_log_writer_standard_streams logLevel' fields'' nFields userData
    let result' = (toEnum . fromIntegral) result
    mapM_ touchManagedPtr fields
    freeMem fields''
    return result'


-- function log_writer_journald
-- Args: [ Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "log level, either from [type@GLib.LogLevelFlags], or a user-defined\n   level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fields"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "GLib" , name = "LogField" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "key\8211value pairs of structured data forming\n   the log message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fields"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of elements in the @fields array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to [func@GLib.log_set_writer_func]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fields"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of elements in the @fields array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "LogWriterOutput" })
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_journald" g_log_writer_journald :: 
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    Ptr GLib.LogField.LogField ->           -- fields : TCArray False (-1) 2 (TInterface (Name {namespace = "GLib", name = "LogField"}))
    FCT.CSize ->                            -- n_fields : TBasicType TSize
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO CUInt

-- | Format a structured log message and send it to the systemd journal as a set
-- of key–value pairs.
-- 
-- All fields are sent to the journal, but if a field has
-- length zero (indicating program-specific data) then only its key will be
-- sent.
-- 
-- This is suitable for use as a [type/@gLib@/.LogWriterFunc].
-- 
-- If GLib has been compiled without systemd support, this function is still
-- defined, but will always return 'GI.GLib.Enums.LogWriterOutputUnhandled'.
-- 
-- /Since: 2.50/
logWriterJournald ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level, either from [type/@gLib@/.LogLevelFlags], or a user-defined
    --    level
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: key–value pairs of structured data forming
    --    the log message
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.logSetWriterFunc'
    -> m GLib.Enums.LogWriterOutput
    -- ^ __Returns:__ 'GI.GLib.Enums.LogWriterOutputHandled' on success, 'GI.GLib.Enums.LogWriterOutputUnhandled' otherwise
logWriterJournald logLevel fields userData = liftIO $ do
    let nFields = fromIntegral $ P.length fields
    let logLevel' = gflagsToWord logLevel
    fields' <- mapM unsafeManagedPtrGetPtr fields
    fields'' <- packBlockArray 24 fields'
    result <- g_log_writer_journald logLevel' fields'' nFields userData
    let result' = (toEnum . fromIntegral) result
    mapM_ touchManagedPtr fields
    freeMem fields''
    return result'


-- function log_writer_is_journald
-- Args: [ Arg
--           { argCName = "output_fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "output file descriptor to check"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_is_journald" g_log_writer_is_journald :: 
    Int32 ->                                -- output_fd : TBasicType TInt
    IO CInt

-- | Check whether the given /@outputFd@/ file descriptor is a connection to the
-- systemd journal, or something else (like a log file or @stdout@ or
-- @stderr@).
-- 
-- Invalid file descriptors are accepted and return @FALSE@, which allows for
-- the following construct without needing any additional error handling:
-- 
-- === /c code/
-- >is_journald = g_log_writer_is_journald (fileno (stderr));
-- 
-- 
-- /Since: 2.50/
logWriterIsJournald ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@outputFd@/: output file descriptor to check
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if /@outputFd@/ points to the journal, @FALSE@ otherwise
logWriterIsJournald outputFd = liftIO $ do
    result <- g_log_writer_is_journald outputFd
    let result' = (/= 0) result
    return result'


-- function log_writer_format_fields
-- Args: [ Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "log level, either from [type@GLib.LogLevelFlags], or a user-defined\n   level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fields"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "GLib" , name = "LogField" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "key\8211value pairs of structured data forming\n   the log message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fields"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of elements in the @fields array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_color"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "`TRUE` to use\n  [ANSI color escape sequences](https://en.wikipedia.org/wiki/ANSI_escape_code)\n  when formatting the message, `FALSE` to not"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fields"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of elements in the @fields array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_format_fields" g_log_writer_format_fields :: 
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    Ptr GLib.LogField.LogField ->           -- fields : TCArray False (-1) 2 (TInterface (Name {namespace = "GLib", name = "LogField"}))
    FCT.CSize ->                            -- n_fields : TBasicType TSize
    CInt ->                                 -- use_color : TBasicType TBoolean
    IO CString

-- | Format a structured log message as a string suitable for outputting to the
-- terminal (or elsewhere).
-- 
-- This will include the values of all fields it knows
-- how to interpret, which includes @MESSAGE@ and @GLIB_DOMAIN@ (see the
-- documentation for @/GLib.log_structured/@). It does not include values from
-- unknown fields.
-- 
-- The returned string does __not__ have a trailing new-line character. It is
-- encoded in the character set of the current locale, which is not necessarily
-- UTF-8.
-- 
-- /Since: 2.50/
logWriterFormatFields ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level, either from [type/@gLib@/.LogLevelFlags], or a user-defined
    --    level
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: key–value pairs of structured data forming
    --    the log message
    -> Bool
    -- ^ /@useColor@/: @TRUE@ to use
    --   <https://en.wikipedia.org/wiki/ANSI_escape_code ANSI color escape sequences>
    --   when formatting the message, @FALSE@ to not
    -> m T.Text
    -- ^ __Returns:__ string containing the formatted log message, in
    --    the character set of the current locale
logWriterFormatFields logLevel fields useColor = liftIO $ do
    let nFields = fromIntegral $ P.length fields
    let logLevel' = gflagsToWord logLevel
    fields' <- mapM unsafeManagedPtrGetPtr fields
    fields'' <- packBlockArray 24 fields'
    let useColor' = (P.fromIntegral . P.fromEnum) useColor
    result <- g_log_writer_format_fields logLevel' fields'' nFields useColor'
    checkUnexpectedReturnNULL "logWriterFormatFields" result
    result' <- cstringToText result
    freeMem result
    mapM_ touchManagedPtr fields
    freeMem fields''
    return result'


-- function log_writer_default_would_drop
-- Args: [ Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "log level, either from [type@GLib.LogLevelFlags], or a user-defined\n   level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "log domain" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_default_would_drop" g_log_writer_default_would_drop :: 
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    CString ->                              -- log_domain : TBasicType TUTF8
    IO CInt

-- | Check whether 'GI.GLib.Functions.logWriterDefault' and 'GI.GLib.Functions.logDefaultHandler' would
-- ignore a message with the given domain and level.
-- 
-- As with 'GI.GLib.Functions.logDefaultHandler', this function drops debug and informational
-- messages unless their log domain (or @all@) is listed in the space-separated
-- @G_MESSAGES_DEBUG@ environment variable, or @DEBUG_INVOCATION=1@ is set in
-- the environment, or by 'GI.GLib.Functions.logWriterDefaultSetDebugDomains'.
-- 
-- This can be used when implementing log writers with the same filtering
-- behaviour as the default, but a different destination or output format:
-- 
-- 
-- === /c code/
-- >if (g_log_writer_default_would_drop (log_level, log_domain))
-- >  return G_LOG_WRITER_HANDLED;
-- >]|
-- >
-- >or to skip an expensive computation if it is only needed for a debugging
-- >message, and `G_MESSAGES_DEBUG` and `DEBUG_INVOCATION` are not set:
-- c
-- if (!g_log_writer_default_would_drop (G_LOG_LEVEL_DEBUG, G_LOG_DOMAIN))
--   {
--     g_autofree gchar *result = expensive_computation (my_object);
-- 
--     g_debug (\"my_object result: @/s/@\", result);
--   }
-- \`\`\`
-- 
-- /Since: 2.68/
logWriterDefaultWouldDrop ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level, either from [type/@gLib@/.LogLevelFlags], or a user-defined
    --    level
    -> Maybe (T.Text)
    -- ^ /@logDomain@/: log domain
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the log message would be dropped by GLib’s
    --   default log handlers
logWriterDefaultWouldDrop logLevel logDomain = liftIO $ do
    let logLevel' = gflagsToWord logLevel
    maybeLogDomain <- case logDomain of
        Nothing -> return FP.nullPtr
        Just jLogDomain -> do
            jLogDomain' <- textToCString jLogDomain
            return jLogDomain'
    result <- g_log_writer_default_would_drop logLevel' maybeLogDomain
    let result' = (/= 0) result
    freeMem maybeLogDomain
    return result'


-- function log_writer_default_set_use_stderr
-- Args: [ Arg
--           { argCName = "use_stderr"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "If `TRUE`, use `stderr` for log messages that would\n normally have appeared on `stdout`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_default_set_use_stderr" g_log_writer_default_set_use_stderr :: 
    CInt ->                                 -- use_stderr : TBasicType TBoolean
    IO ()

-- | Configure whether the built-in log functions will output all log messages to
-- @stderr@.
-- 
-- The built-in log functions are 'GI.GLib.Functions.logDefaultHandler' for the
-- old-style API, and both 'GI.GLib.Functions.logWriterDefault' and
-- 'GI.GLib.Functions.logWriterStandardStreams' for the structured API.
-- 
-- By default, log messages of levels [flags/@gLib@/.LogLevelFlags.LEVEL_INFO] and
-- [flags/@gLib@/.LogLevelFlags.LEVEL_DEBUG] are sent to @stdout@, and other log messages are
-- sent to @stderr@. This is problematic for applications that intend
-- to reserve @stdout@ for structured output such as JSON or XML.
-- 
-- This function sets global state. It is not thread-aware, and should be
-- called at the very start of a program, before creating any other threads
-- or creating objects that could create worker threads of their own.
-- 
-- /Since: 2.68/
logWriterDefaultSetUseStderr ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Bool
    -- ^ /@useStderr@/: If @TRUE@, use @stderr@ for log messages that would
    --  normally have appeared on @stdout@
    -> m ()
logWriterDefaultSetUseStderr useStderr = liftIO $ do
    let useStderr' = (P.fromIntegral . P.fromEnum) useStderr
    g_log_writer_default_set_use_stderr useStderr'
    return ()


-- function log_writer_default_set_debug_domains
-- Args: [ Arg
--           { argCName = "domains"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "`NULL`-terminated array with domains to be printed.\n  `NULL` or an array with no values means none. Array with a single value `\"all\"` means all."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_default_set_debug_domains" g_log_writer_default_set_debug_domains :: 
    CString ->                              -- domains : TBasicType TUTF8
    IO ()

-- | Reset the list of domains to be logged, that might be initially set by the
-- @G_MESSAGES_DEBUG@ or @DEBUG_INVOCATION@ environment variables.
-- 
-- This function is thread-safe.
-- 
-- /Since: 2.80/
logWriterDefaultSetDebugDomains ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@domains@/: @NULL@-terminated array with domains to be printed.
    --   @NULL@ or an array with no values means none. Array with a single value @\"all\"@ means all.
    -> m ()
logWriterDefaultSetDebugDomains domains = liftIO $ do
    maybeDomains <- case domains of
        Nothing -> return FP.nullPtr
        Just jDomains -> do
            jDomains' <- textToCString jDomains
            return jDomains'
    g_log_writer_default_set_debug_domains maybeDomains
    freeMem maybeDomains
    return ()


-- function log_writer_default
-- Args: [ Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "log level, either from [type@GLib.LogLevelFlags], or a user-defined\n   level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fields"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "GLib" , name = "LogField" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "key\8211value pairs of structured data forming\n   the log message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fields"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of elements in the @fields array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to [func@GLib.log_set_writer_func]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fields"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of elements in the @fields array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "LogWriterOutput" })
-- throws : False
-- Skip return : False

foreign import ccall "g_log_writer_default" g_log_writer_default :: 
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    Ptr GLib.LogField.LogField ->           -- fields : TCArray False (-1) 2 (TInterface (Name {namespace = "GLib", name = "LogField"}))
    FCT.CSize ->                            -- n_fields : TBasicType TSize
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO CUInt

-- | Format a structured log message and output it to the default log destination
-- for the platform.
-- 
-- On Linux, this is typically the systemd journal, falling
-- back to @stdout@ or @stderr@ if running from the terminal or if output is
-- being redirected to a file.
-- 
-- Support for other platform-specific logging mechanisms may be added in
-- future. Distributors of GLib may modify this function to impose their own
-- (documented) platform-specific log writing policies.
-- 
-- This is suitable for use as a [type/@gLib@/.LogWriterFunc], and is the default writer used
-- if no other is set using 'GI.GLib.Functions.logSetWriterFunc'.
-- 
-- As with 'GI.GLib.Functions.logDefaultHandler', this function drops debug and informational
-- messages unless their log domain (or @all@) is listed in the space-separated
-- @G_MESSAGES_DEBUG@ environment variable, or @DEBUG_INVOCATION=1@ is set in
-- the environment, or set at runtime by 'GI.GLib.Functions.logWriterDefaultSetDebugDomains'.
-- 
-- 'GI.GLib.Functions.logWriterDefault' uses the mask set by 'GI.GLib.Functions.logSetAlwaysFatal' to
-- determine which messages are fatal. When using a custom writer function instead it is
-- up to the writer function to determine which log messages are fatal.
-- 
-- /Since: 2.50/
logWriterDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level, either from [type/@gLib@/.LogLevelFlags], or a user-defined
    --    level
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: key–value pairs of structured data forming
    --    the log message
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.logSetWriterFunc'
    -> m GLib.Enums.LogWriterOutput
    -- ^ __Returns:__ 'GI.GLib.Enums.LogWriterOutputHandled' on success,
    --   'GI.GLib.Enums.LogWriterOutputUnhandled' otherwise
logWriterDefault logLevel fields userData = liftIO $ do
    let nFields = fromIntegral $ P.length fields
    let logLevel' = gflagsToWord logLevel
    fields' <- mapM unsafeManagedPtrGetPtr fields
    fields'' <- packBlockArray 24 fields'
    result <- g_log_writer_default logLevel' fields'' nFields userData
    let result' = (toEnum . fromIntegral) result
    mapM_ touchManagedPtr fields
    freeMem fields''
    return result'


-- function log_variant
-- Args: [ Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "log domain, usually `G_LOG_DOMAIN`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "log level, either from [type@GLib.LogLevelFlags], or a user-defined\n   level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fields"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a dictionary ([type@GLib.Variant] of the type `G_VARIANT_TYPE_VARDICT`)\ncontaining the key-value pairs of message data."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_log_variant" g_log_variant :: 
    CString ->                              -- log_domain : TBasicType TUTF8
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    Ptr GVariant ->                         -- fields : TVariant
    IO ()

-- | Log a message with structured data, accepting the data within a [type/@gLib@/.Variant].
-- 
-- This version is especially useful for use in other languages, via introspection.
-- 
-- The only mandatory item in the /@fields@/ dictionary is the @\"MESSAGE\"@ which must
-- contain the text shown to the user.
-- 
-- The values in the /@fields@/ dictionary are likely to be of type @G_VARIANT_TYPE_STRING@.
-- Array of bytes (@G_VARIANT_TYPE_BYTESTRING@) is also
-- supported. In this case the message is handled as binary and will be forwarded
-- to the log writer as such. The size of the array should not be higher than
-- @G_MAXSSIZE@. Otherwise it will be truncated to this size. For other types
-- 'GI.GLib.Structs.Variant.variantPrint' will be used to convert the value into a string.
-- 
-- For more details on its usage and about the parameters, see @/GLib.log_structured/@.
-- 
-- /Since: 2.50/
logVariant ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@logDomain@/: log domain, usually @G_LOG_DOMAIN@
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level, either from [type/@gLib@/.LogLevelFlags], or a user-defined
    --    level
    -> GVariant
    -- ^ /@fields@/: a dictionary ([type/@gLib@/.Variant] of the type @G_VARIANT_TYPE_VARDICT@)
    -- containing the key-value pairs of message data.
    -> m ()
logVariant logDomain logLevel fields = liftIO $ do
    maybeLogDomain <- case logDomain of
        Nothing -> return FP.nullPtr
        Just jLogDomain -> do
            jLogDomain' <- textToCString jLogDomain
            return jLogDomain'
    let logLevel' = gflagsToWord logLevel
    fields' <- unsafeManagedPtrGetPtr fields
    g_log_variant maybeLogDomain logLevel' fields'
    touchManagedPtr fields
    freeMem maybeLogDomain
    return ()


-- function log_structured_array
-- Args: [ Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "log level, either from [type@GLib.LogLevelFlags], or a user-defined\n   level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fields"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "GLib" , name = "LogField" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "key\8211value pairs of structured data to add\n   to the log message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fields"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of elements in the @fields array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fields"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of elements in the @fields array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_log_structured_array" g_log_structured_array :: 
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    Ptr GLib.LogField.LogField ->           -- fields : TCArray False (-1) 2 (TInterface (Name {namespace = "GLib", name = "LogField"}))
    FCT.CSize ->                            -- n_fields : TBasicType TSize
    IO ()

-- | Log a message with structured data.
-- 
-- The message will be passed through to the log writer set by the application
-- using 'GI.GLib.Functions.logSetWriterFunc'. If the
-- message is fatal (i.e. its log level is [flags/@gLib@/.LogLevelFlags.LEVEL_ERROR]), the program will
-- be aborted at the end of this function.
-- 
-- See @/GLib.log_structured/@ for more documentation.
-- 
-- This assumes that /@logLevel@/ is already present in /@fields@/ (typically as the
-- @PRIORITY@ field).
-- 
-- /Since: 2.50/
logStructuredArray ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level, either from [type/@gLib@/.LogLevelFlags], or a user-defined
    --    level
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: key–value pairs of structured data to add
    --    to the log message
    -> m ()
logStructuredArray logLevel fields = liftIO $ do
    let nFields = fromIntegral $ P.length fields
    let logLevel' = gflagsToWord logLevel
    fields' <- mapM unsafeManagedPtrGetPtr fields
    fields'' <- packBlockArray 24 fields'
    g_log_structured_array logLevel' fields'' nFields
    mapM_ touchManagedPtr fields
    freeMem fields''
    return ()


-- function log_set_writer_func
-- Args: [ Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogWriterFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "log writer function, which must not be `NULL`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 1
--           , argDestroy = 2
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data_free"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "function to free @user_data once it\8217s\n   finished with, if non-`NULL`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_log_set_writer_func" g_log_set_writer_func :: 
    FunPtr GLib.Callbacks.C_LogWriterFunc -> -- func : TInterface (Name {namespace = "GLib", name = "LogWriterFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- user_data_free : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Set a writer function which will be called to format and write out each log
-- message.
-- 
-- Each program should set a writer function, or the default writer
-- ('GI.GLib.Functions.logWriterDefault') will be used.
-- 
-- Libraries __must not__ call this function — only programs are allowed to
-- install a writer function, as there must be a single, central point where
-- log messages are formatted and outputted.
-- 
-- There can only be one writer function. It is an error to set more than one.
-- 
-- /Since: 2.50/
logSetWriterFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Callbacks.LogWriterFunc
    -- ^ /@func@/: log writer function, which must not be @NULL@
    -> m ()
logSetWriterFunc func = liftIO $ do
    func' <- GLib.Callbacks.mk_LogWriterFunc (GLib.Callbacks.wrap_LogWriterFunc Nothing (GLib.Callbacks.drop_closures_LogWriterFunc func))
    let userData = castFunPtrToPtr func'
    let userDataFree = SP.safeFreeFunPtrPtr
    g_log_set_writer_func func' userData userDataFree
    return ()


-- function log_set_handler
-- Args: [ Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the log domain\n  application domain"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_levels"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the log levels to apply the log handler for.\n  To handle fatal and recursive messages as well, combine\n  the log levels with the [flags@GLib.LogLevelFlags.FLAG_FATAL] and\n  [flags@GLib.LogLevelFlags.FLAG_RECURSION] bit flags."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the log handler function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to the log handler"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @user_data, or `NULL`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_log_set_handler_full" g_log_set_handler_full :: 
    CString ->                              -- log_domain : TBasicType TUTF8
    CInt ->                                 -- log_levels : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    FunPtr GLib.Callbacks.C_LogFunc ->      -- log_func : TInterface (Name {namespace = "GLib", name = "LogFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Like 'GI.GLib.Functions.logSetHandler', but takes a destroy notify for the /@userData@/.
-- 
-- This has no effect if structured logging is enabled; see
-- <http://developer.gnome.org/glib/stable/logging.html#using-structured-logging Using Structured Logging>.
-- 
-- The @log_domain@ parameter can be set to @NULL@ or an empty string to use the default
-- application domain.
-- 
-- /Since: 2.46/
logSetHandler ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@logDomain@/: the log domain
    --   application domain
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevels@/: the log levels to apply the log handler for.
    --   To handle fatal and recursive messages as well, combine
    --   the log levels with the [flags/@gLib@/.LogLevelFlags.FLAG_FATAL] and
    --   [flags/@gLib@/.LogLevelFlags.FLAG_RECURSION] bit flags.
    -> GLib.Callbacks.LogFunc
    -- ^ /@logFunc@/: the log handler function
    -> m Word32
    -- ^ __Returns:__ the ID of the new handler
logSetHandler logDomain logLevels logFunc = liftIO $ do
    maybeLogDomain <- case logDomain of
        Nothing -> return FP.nullPtr
        Just jLogDomain -> do
            jLogDomain' <- textToCString jLogDomain
            return jLogDomain'
    let logLevels' = gflagsToWord logLevels
    logFunc' <- GLib.Callbacks.mk_LogFunc (GLib.Callbacks.wrap_LogFunc Nothing (GLib.Callbacks.drop_closures_LogFunc logFunc))
    let userData = castFunPtrToPtr logFunc'
    let destroy = SP.safeFreeFunPtrPtr
    result <- g_log_set_handler_full maybeLogDomain logLevels' logFunc' userData destroy
    freeMem maybeLogDomain
    return result


-- function log_set_fatal_mask
-- Args: [ Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the log domain" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fatal_mask"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new fatal mask" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "LogLevelFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_log_set_fatal_mask" g_log_set_fatal_mask :: 
    CString ->                              -- log_domain : TBasicType TUTF8
    CInt ->                                 -- fatal_mask : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    IO CInt

-- | Sets the log levels which are fatal in the given domain.
-- 
-- [flags/@gLib@/.LogLevelFlags.LEVEL_ERROR] is always fatal.
-- 
-- This has no effect on structured log messages (using @/GLib.log_structured/@ or
-- 'GI.GLib.Functions.logStructuredArray'). To change the fatal behaviour for specific log
-- messages, programs must install a custom log writer function using
-- 'GI.GLib.Functions.logSetWriterFunc'. See
-- <http://developer.gnome.org/glib/stable/logging.html#using-structured-logging Using Structured Logging>.
-- 
-- This function is mostly intended to be used with
-- [flags/@gLib@/.LogLevelFlags.LEVEL_CRITICAL].  You should typically not set
-- [flags/@gLib@/.LogLevelFlags.LEVEL_WARNING], [flags/@gLib@/.LogLevelFlags.LEVEL_MESSAGE], [flags/@gLib@/.LogLevelFlags.LEVEL_INFO] or
-- [flags/@gLib@/.LogLevelFlags.LEVEL_DEBUG] as fatal except inside of test programs.
logSetFatalMask ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@logDomain@/: the log domain
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@fatalMask@/: the new fatal mask
    -> m [GLib.Flags.LogLevelFlags]
    -- ^ __Returns:__ the old fatal mask for the log domain
logSetFatalMask logDomain fatalMask = liftIO $ do
    logDomain' <- textToCString logDomain
    let fatalMask' = gflagsToWord fatalMask
    result <- g_log_set_fatal_mask logDomain' fatalMask'
    let result' = wordToGFlags result
    freeMem logDomain'
    return result'


-- function log_set_debug_enabled
-- Args: [ Arg
--           { argCName = "enabled"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "`TRUE` to enable debug output, `FALSE` otherwise"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_log_set_debug_enabled" g_log_set_debug_enabled :: 
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()

-- | Enable or disable debug output from the GLib logging system for all domains.
-- 
-- This value interacts disjunctively with @G_MESSAGES_DEBUG@, @DEBUG_INVOCATION@ and
-- 'GI.GLib.Functions.logWriterDefaultSetDebugDomains' — if any of them would allow
-- a debug message to be outputted, it will be.
-- 
-- Note that this should not be used from within library code to enable debug
-- output — it is intended for external use.
-- 
-- /Since: 2.72/
logSetDebugEnabled ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Bool
    -- ^ /@enabled@/: @TRUE@ to enable debug output, @FALSE@ otherwise
    -> m ()
logSetDebugEnabled enabled = liftIO $ do
    let enabled' = (P.fromIntegral . P.fromEnum) enabled
    g_log_set_debug_enabled enabled'
    return ()


-- function log_set_always_fatal
-- Args: [ Arg
--           { argCName = "fatal_mask"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the mask containing bits set for each level of error which is\n  to be fatal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "LogLevelFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_log_set_always_fatal" g_log_set_always_fatal :: 
    CInt ->                                 -- fatal_mask : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    IO CInt

-- | Sets the message levels which are always fatal, in any log domain.
-- 
-- When a message with any of these levels is logged the program terminates.
-- You can only set the levels defined by GLib to be fatal.
-- [flags/@gLib@/.LogLevelFlags.LEVEL_ERROR] is always fatal.
-- 
-- You can also make some message levels fatal at runtime by setting
-- the @G_DEBUG@ environment variable (see
-- <http://developer.gnome.org/glib/stable/running.html Running GLib Applications>).
-- 
-- Libraries should not call this function, as it affects all messages logged
-- by a process, including those from other libraries.
-- 
-- Structured log messages (using @/GLib.log_structured/@ and
-- 'GI.GLib.Functions.logStructuredArray') are fatal only if the default log writer is used;
-- otherwise it is up to the writer function to determine which log messages
-- are fatal. See <http://developer.gnome.org/glib/stable/logging.html#using-structured-logging Using Structured Logging>.
logSetAlwaysFatal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.LogLevelFlags]
    -- ^ /@fatalMask@/: the mask containing bits set for each level of error which is
    --   to be fatal
    -> m [GLib.Flags.LogLevelFlags]
    -- ^ __Returns:__ the old fatal mask
logSetAlwaysFatal fatalMask = liftIO $ do
    let fatalMask' = gflagsToWord fatalMask
    result <- g_log_set_always_fatal fatalMask'
    let result' = wordToGFlags result
    return result'


-- function log_remove_handler
-- Args: [ Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the log domain" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the ID of the handler, which was returned\n  in [func@GLib.log_set_handler]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_log_remove_handler" g_log_remove_handler :: 
    CString ->                              -- log_domain : TBasicType TUTF8
    Word32 ->                               -- handler_id : TBasicType TUInt
    IO ()

-- | Removes the log handler.
-- 
-- This has no effect if structured logging is enabled; see
-- <http://developer.gnome.org/glib/stable/logging.html#using-structured-logging Using Structured Logging>.
logRemoveHandler ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@logDomain@/: the log domain
    -> Word32
    -- ^ /@handlerId@/: the ID of the handler, which was returned
    --   in 'GI.GLib.Functions.logSetHandler'
    -> m ()
logRemoveHandler logDomain handlerId = liftIO $ do
    logDomain' <- textToCString logDomain
    g_log_remove_handler logDomain' handlerId
    freeMem logDomain'
    return ()


-- function log_get_debug_enabled
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_log_get_debug_enabled" g_log_get_debug_enabled :: 
    IO CInt

-- | Return whether debug output from the GLib logging system is enabled.
-- 
-- Note that this should not be used to conditionalise calls to @/GLib.debug/@ or
-- other logging functions; it should only be used from [type/@gLib@/.LogWriterFunc]
-- implementations.
-- 
-- Note also that the value of this does not depend on @G_MESSAGES_DEBUG@, nor
-- @DEBUG_INVOCATION@, nor 'GI.GLib.Functions.logWriterDefaultSetDebugDomains'; see
-- the docs for 'GI.GLib.Functions.logSetDebugEnabled'.
-- 
-- /Since: 2.72/
logGetDebugEnabled ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ @TRUE@ if debug output is enabled, @FALSE@ otherwise
logGetDebugEnabled  = liftIO $ do
    result <- g_log_get_debug_enabled
    let result' = (/= 0) result
    return result'


-- function log_get_always_fatal
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "LogLevelFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_log_get_always_fatal" g_log_get_always_fatal :: 
    IO CInt

-- | Gets the current fatal mask.
-- 
-- This is mostly used by custom log writers to make fatal messages
-- (@fatal-warnings@, @fatal-criticals@) work as expected, when using the
-- @G_DEBUG@ environment variable (see <http://developer.gnome.org/glib/stable/running.html Running GLib Applications>).
-- 
-- An example usage is shown below:
-- 
-- 
-- === /c code/
-- >static GLogWriterOutput
-- >my_custom_log_writer_fn (GLogLevelFlags log_level,
-- >                         const GLogField *fields,
-- >                         gsize n_fields,
-- >                         gpointer user_data)
-- >{
-- >
-- >   // abort if the message was fatal
-- >   if (log_level & g_log_get_always_fatal ())
-- >     g_abort ();
-- >
-- >   // custom log handling code
-- >   ...
-- >   ...
-- >
-- >   // success
-- >   return G_LOG_WRITER_HANDLED;
-- >}
-- 
-- 
-- /Since: 2.86/
logGetAlwaysFatal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [GLib.Flags.LogLevelFlags]
    -- ^ __Returns:__ the current fatal mask
logGetAlwaysFatal  = liftIO $ do
    result <- g_log_get_always_fatal
    let result' = wordToGFlags result
    return result'


-- function log_default_handler
-- Args: [ Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the log domain of the message, or `NULL` for the\n  default `\"\"` application domain"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the level of the message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the message" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unused_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "data passed from [func@GLib.log] which is unused"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_log_default_handler" g_log_default_handler :: 
    CString ->                              -- log_domain : TBasicType TUTF8
    CInt ->                                 -- log_level : TInterface (Name {namespace = "GLib", name = "LogLevelFlags"})
    CString ->                              -- message : TBasicType TUTF8
    Ptr () ->                               -- unused_data : TBasicType TPtr
    IO ()

-- | The default log handler set up by GLib; @/GLib.log_set_default_handler/@
-- allows to install an alternate default log handler.
-- 
-- This is used if no log handler has been set for the particular log
-- domain and log level combination. It outputs the message to @stderr@
-- or @stdout@ and if the log level is fatal it calls @/GLib.BREAKPOINT/@. It automatically
-- prints a new-line character after the message, so one does not need to be
-- manually included in /@message@/.
-- 
-- The behavior of this log handler can be influenced by a number of
-- environment variables:
-- 
-- * @G_MESSAGES_PREFIXED@: A @:@-separated list of log levels for which
--   messages should be prefixed by the program name and PID of the
--   application.
-- * @G_MESSAGES_DEBUG@: A space-separated list of log domains for
--   which debug and informational messages are printed. By default
--   these messages are not printed. If you need to set the allowed
--   domains at runtime, use 'GI.GLib.Functions.logWriterDefaultSetDebugDomains'.
-- * @DEBUG_INVOCATION@: If set to @1@, this is equivalent to
--   @G_MESSAGES_DEBUG=all@. @DEBUG_INVOCATION@ is a standard environment
--   variable set by systemd to prompt debug output. (Since: 2.84)
-- 
-- 
-- @stderr@ is used for levels [flags/@gLib@/.LogLevelFlags.LEVEL_ERROR],
-- [flags/@gLib@/.LogLevelFlags.LEVEL_CRITICAL], [flags/@gLib@/.LogLevelFlags.LEVEL_WARNING] and
-- [flags/@gLib@/.LogLevelFlags.LEVEL_MESSAGE]. @stdout@ is used for
-- the rest, unless @stderr@ was requested by
-- 'GI.GLib.Functions.logWriterDefaultSetUseStderr'.
-- 
-- This has no effect if structured logging is enabled; see
-- <http://developer.gnome.org/glib/stable/logging.html#using-structured-logging Using Structured Logging>.
logDefaultHandler ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@logDomain@/: the log domain of the message, or @NULL@ for the
    --   default @\"\"@ application domain
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: the level of the message
    -> Maybe (T.Text)
    -- ^ /@message@/: the message
    -> Ptr ()
    -- ^ /@unusedData@/: data passed from @/GLib.log/@ which is unused
    -> m ()
logDefaultHandler logDomain logLevel message unusedData = liftIO $ do
    maybeLogDomain <- case logDomain of
        Nothing -> return FP.nullPtr
        Just jLogDomain -> do
            jLogDomain' <- textToCString jLogDomain
            return jLogDomain'
    let logLevel' = gflagsToWord logLevel
    maybeMessage <- case message of
        Nothing -> return FP.nullPtr
        Just jMessage -> do
            jMessage' <- textToCString jMessage
            return jMessage'
    g_log_default_handler maybeLogDomain logLevel' maybeMessage unusedData
    freeMem maybeLogDomain
    freeMem maybeMessage
    return ()


-- function locale_to_utf8
-- Args: [ Arg
--           { argCName = "opsysstring"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string in the\n                encoding of the current locale. On Windows\n                this means the system codepage."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the length of the string, or -1 if the string is\n                nul-terminated (Note that some encodings may allow nul\n                bytes to occur inside strings. In that case, using -1\n                for the @len parameter is unsafe)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes_read"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the number of bytes in the\n                input string that were successfully converted, or %NULL.\n                Even if the conversion was successful, this may be\n                less than @len if there were partial characters\n                at the end of the input. If the error\n                %G_CONVERT_ERROR_ILLEGAL_SEQUENCE occurs, the value\n                stored will be the byte offset after the last valid\n                input sequence."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "bytes_written"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the number of bytes stored in the output\n                buffer (not including the terminating nul)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "the length of the string, or -1 if the string is\n                nul-terminated (Note that some encodings may allow nul\n                bytes to occur inside strings. In that case, using -1\n                for the @len parameter is unsafe)"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUTF8)
-- throws : True
-- Skip return : False

foreign import ccall "g_locale_to_utf8" g_locale_to_utf8 :: 
    Ptr Word8 ->                            -- opsysstring : TCArray False (-1) 1 (TBasicType TUInt8)
    DI.Int64 ->                             -- len : TBasicType TSSize
    Ptr FCT.CSize ->                        -- bytes_read : TBasicType TSize
    Ptr FCT.CSize ->                        -- bytes_written : TBasicType TSize
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Converts a string which is in the encoding used for strings by
-- the C runtime (usually the same as that used by the operating
-- system) in the <http://developer.gnome.org/glib/stable/running.html#locale current locale> into a UTF-8 string.
-- 
-- If the source encoding is not UTF-8 and the conversion output contains a
-- nul character, the error 'GI.GLib.Enums.ConvertErrorEmbeddedNul' is set and the
-- function returns 'P.Nothing'.
-- If the source encoding is UTF-8, an embedded nul character is treated with
-- the 'GI.GLib.Enums.ConvertErrorIllegalSequence' error for backward compatibility with
-- earlier versions of this library. Use 'GI.GLib.Functions.convert' to produce output that
-- may contain embedded nul characters.
localeToUtf8 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ByteString
    -- ^ /@opsysstring@/: a string in the
    --                 encoding of the current locale. On Windows
    --                 this means the system codepage.
    -> m ((T.Text, FCT.CSize, FCT.CSize))
    -- ^ __Returns:__ The converted string, or 'P.Nothing' on an error. /(Can throw 'Data.GI.Base.GError.GError')/
localeToUtf8 opsysstring = liftIO $ do
    let len = fromIntegral $ B.length opsysstring
    opsysstring' <- packByteString opsysstring
    bytesRead <- allocMem :: IO (Ptr FCT.CSize)
    bytesWritten <- allocMem :: IO (Ptr FCT.CSize)
    onException (do
        result <- propagateGError $ g_locale_to_utf8 opsysstring' len bytesRead bytesWritten
        checkUnexpectedReturnNULL "localeToUtf8" result
        result' <- cstringToText result
        freeMem result
        bytesRead' <- peek bytesRead
        bytesWritten' <- peek bytesWritten
        freeMem opsysstring'
        freeMem bytesRead
        freeMem bytesWritten
        return (result', bytesRead', bytesWritten')
     ) (do
        freeMem opsysstring'
        freeMem bytesRead
        freeMem bytesWritten
     )


-- function locale_from_utf8
-- Args: [ Arg
--           { argCName = "utf8string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the length of the string, or -1 if the string is\n                nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes_read"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the number of bytes in the\n                input string that were successfully converted, or %NULL.\n                Even if the conversion was successful, this may be\n                less than @len if there were partial characters\n                at the end of the input. If the error\n                %G_CONVERT_ERROR_ILLEGAL_SEQUENCE occurs, the value\n                stored will be the byte offset after the last valid\n                input sequence."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "bytes_written"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the number of bytes stored in the output\n                buffer (not including the terminating nul)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "bytes_written"
--              , argType = TBasicType TSize
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "the number of bytes stored in the output\n                buffer (not including the terminating nul)."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 3 (TBasicType TUInt8))
-- throws : True
-- Skip return : False

foreign import ccall "g_locale_from_utf8" g_locale_from_utf8 :: 
    CString ->                              -- utf8string : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    Ptr FCT.CSize ->                        -- bytes_read : TBasicType TSize
    Ptr FCT.CSize ->                        -- bytes_written : TBasicType TSize
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Word8)

-- | Converts a string from UTF-8 to the encoding used for strings by
-- the C runtime (usually the same as that used by the operating
-- system) in the <http://developer.gnome.org/glib/stable/running.html#locale current locale>.
-- On Windows this means the system codepage.
-- 
-- The input string shall not contain nul characters even if the /@len@/
-- argument is positive. A nul character found inside the string will result
-- in error 'GI.GLib.Enums.ConvertErrorIllegalSequence'. Use 'GI.GLib.Functions.convert' to convert
-- input that may contain embedded nul characters.
localeFromUtf8 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@utf8string@/: a UTF-8 encoded string
    -> DI.Int64
    -- ^ /@len@/: the length of the string, or -1 if the string is
    --                 nul-terminated.
    -> m ((ByteString, FCT.CSize))
    -- ^ __Returns:__ 
    --          A newly-allocated buffer containing the converted string,
    --          or 'P.Nothing' on an error, and error will be set. /(Can throw 'Data.GI.Base.GError.GError')/
localeFromUtf8 utf8string len = liftIO $ do
    utf8string' <- textToCString utf8string
    bytesRead <- allocMem :: IO (Ptr FCT.CSize)
    bytesWritten <- allocMem :: IO (Ptr FCT.CSize)
    onException (do
        result <- propagateGError $ g_locale_from_utf8 utf8string' len bytesRead bytesWritten
        bytesWritten' <- peek bytesWritten
        checkUnexpectedReturnNULL "localeFromUtf8" result
        result' <- (unpackByteStringWithLength bytesWritten') result
        freeMem result
        bytesRead' <- peek bytesRead
        freeMem utf8string'
        freeMem bytesRead
        freeMem bytesWritten
        return (result', bytesRead')
     ) (do
        freeMem utf8string'
        freeMem bytesRead
        freeMem bytesWritten
     )


-- function listenv
-- Args: []
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TFileName))
-- throws : False
-- Skip return : False

foreign import ccall "g_listenv" g_listenv :: 
    IO (Ptr CString)

-- | Gets the names of all variables set in the environment.
-- 
-- Programs that want to be portable to Windows should typically use
-- this function and 'GI.GLib.Functions.getenv' instead of using the environ array
-- from the C library directly. On Windows, the strings in the environ
-- array are in system codepage encoding, while in most of the typical
-- use cases for environment variables in GLib-using programs you want
-- the UTF-8 encoding that this function and 'GI.GLib.Functions.getenv' provide.
-- 
-- /Since: 2.8/
listenv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [[Char]]
    -- ^ __Returns:__ 
    --     a 'P.Nothing'-terminated list of strings which must be freed with
    --     'GI.GLib.Functions.strfreev'.
listenv  = liftIO $ do
    result <- g_listenv
    checkUnexpectedReturnNULL "listenv" result
    result' <- unpackZeroTerminatedFileNameArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    return result'


-- function io_create_watch
-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOChannel to watch"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "conditions to watch for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_io_create_watch" g_io_create_watch :: 
    Ptr GLib.IOChannel.IOChannel ->         -- channel : TInterface (Name {namespace = "GLib", name = "IOChannel"})
    CUInt ->                                -- condition : TInterface (Name {namespace = "GLib", name = "IOCondition"})
    IO (Ptr GLib.Source.Source)

-- | Creates a t'GI.GLib.Structs.Source.Source' that\'s dispatched when /@condition@/ is met for the
-- given /@channel@/. For example, if condition is 'GI.GLib.Flags.IOConditionIn', the source will
-- be dispatched when there\'s data available for reading.
-- 
-- The callback function invoked by the t'GI.GLib.Structs.Source.Source' should be added with
-- 'GI.GLib.Structs.Source.sourceSetCallback', but it has type t'GI.GLib.Callbacks.IOFunc' (not t'GI.GLib.Callbacks.SourceFunc').
-- 
-- @/g_io_add_watch()/@ is a simpler interface to this same functionality, for
-- the case where you want to add the source to the default main loop context
-- at the default priority.
-- 
-- On Windows, polling a t'GI.GLib.Structs.Source.Source' created to watch a channel for a socket
-- puts the socket in non-blocking mode. This is a side-effect of the
-- implementation and unavoidable.
ioCreateWatch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.IOChannel.IOChannel
    -- ^ /@channel@/: a t'GI.GLib.Structs.IOChannel.IOChannel' to watch
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: conditions to watch for
    -> m GLib.Source.Source
    -- ^ __Returns:__ a new t'GI.GLib.Structs.Source.Source'
ioCreateWatch channel condition = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    let condition' = gflagsToWord condition
    result <- g_io_create_watch channel' condition'
    checkUnexpectedReturnNULL "ioCreateWatch" result
    result' <- (wrapBoxed GLib.Source.Source) result
    touchManagedPtr channel
    return result'


-- function io_add_watch
-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOChannel" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the priority of the #GIOChannel source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the condition to watch for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function to call when the condition is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 4
--           , argDestroy = 5
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function to call when the source is removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_io_add_watch_full" g_io_add_watch_full :: 
    Ptr GLib.IOChannel.IOChannel ->         -- channel : TInterface (Name {namespace = "GLib", name = "IOChannel"})
    Int32 ->                                -- priority : TBasicType TInt
    CUInt ->                                -- condition : TInterface (Name {namespace = "GLib", name = "IOCondition"})
    FunPtr GLib.Callbacks.C_IOFunc ->       -- func : TInterface (Name {namespace = "GLib", name = "IOFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Adds the t'GI.GLib.Structs.IOChannel.IOChannel' into the default main loop context
-- with the given priority.
-- 
-- This internally creates a main loop source using 'GI.GLib.Functions.ioCreateWatch'
-- and attaches it to the main loop context with 'GI.GLib.Structs.Source.sourceAttach'.
-- You can do these steps manually if you need greater control.
ioAddWatch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.IOChannel.IOChannel
    -- ^ /@channel@/: a t'GI.GLib.Structs.IOChannel.IOChannel'
    -> Int32
    -- ^ /@priority@/: the priority of the t'GI.GLib.Structs.IOChannel.IOChannel' source
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the condition to watch for
    -> GLib.Callbacks.IOFunc
    -- ^ /@func@/: the function to call when the condition is satisfied
    -> m Word32
    -- ^ __Returns:__ the event source id
ioAddWatch channel priority condition func = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    let condition' = gflagsToWord condition
    func' <- GLib.Callbacks.mk_IOFunc (GLib.Callbacks.wrap_IOFunc Nothing func)
    let userData = castFunPtrToPtr func'
    let notify = SP.safeFreeFunPtrPtr
    result <- g_io_add_watch_full channel' priority condition' func' userData notify
    touchManagedPtr channel
    return result


-- function intern_string
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_intern_string" g_intern_string :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

-- | Returns a canonical representation for /@string@/. Interned strings
-- can be compared for equality by comparing the pointers, instead of
-- using @/strcmp()/@.
-- 
-- This function must not be used before library constructors have finished
-- running. In particular, this means it cannot be used to initialize global
-- variables in C++.
-- 
-- /Since: 2.10/
internString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@string@/: a string
    -> m T.Text
    -- ^ __Returns:__ a canonical representation for the string
internString string = liftIO $ do
    maybeString <- case string of
        Nothing -> return FP.nullPtr
        Just jString -> do
            jString' <- textToCString jString
            return jString'
    result <- g_intern_string maybeString
    checkUnexpectedReturnNULL "internString" result
    result' <- cstringToText result
    freeMem maybeString
    return result'


-- function intern_static_string
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a static string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_intern_static_string" g_intern_static_string :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

-- | Returns a canonical representation for /@string@/. Interned strings
-- can be compared for equality by comparing the pointers, instead of
-- using @/strcmp()/@. 'GI.GLib.Functions.internStaticString' does not copy the string,
-- therefore /@string@/ must not be freed or modified.
-- 
-- This function must not be used before library constructors have finished
-- running. In particular, this means it cannot be used to initialize global
-- variables in C++.
-- 
-- /Since: 2.10/
internStaticString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@string@/: a static string
    -> m T.Text
    -- ^ __Returns:__ a canonical representation for the string
internStaticString string = liftIO $ do
    maybeString <- case string of
        Nothing -> return FP.nullPtr
        Just jString -> do
            jString' <- textToCString jString
            return jString'
    result <- g_intern_static_string maybeString
    checkUnexpectedReturnNULL "internStaticString" result
    result' <- cstringToText result
    freeMem maybeString
    return result'


-- function int_hash
-- Args: [ Arg
--           { argCName = "v"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gint key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_int_hash" g_int_hash :: 
    Ptr () ->                               -- v : TBasicType TPtr
    IO Word32

-- | Converts a pointer to a @/gint/@ to a hash value.
-- It can be passed to @/g_hash_table_new()/@ as the /@hashFunc@/ parameter,
-- when using non-'P.Nothing' pointers to integer values as keys in a t'GI.GLib.Structs.HashTable.HashTable'.
-- 
-- Note that this function acts on pointers to @/gint/@, not on @/gint/@
-- directly: if your hash table\'s keys are of the form
-- @GINT_TO_POINTER (n)@, use 'GI.GLib.Functions.directHash' instead.
intHash ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@v@/: a pointer to a @/gint/@ key
    -> m Word32
    -- ^ __Returns:__ a hash value corresponding to the key.
intHash v = liftIO $ do
    result <- g_int_hash v
    return result


-- function int_equal
-- Args: [ Arg
--           { argCName = "v1"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gint key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "v2"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gint key to compare with @v1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_int_equal" g_int_equal :: 
    Ptr () ->                               -- v1 : TBasicType TPtr
    Ptr () ->                               -- v2 : TBasicType TPtr
    IO CInt

-- | Compares the two @/gint/@ values being pointed to and returns
-- 'P.True' if they are equal.
-- It can be passed to @/g_hash_table_new()/@ as the /@keyEqualFunc@/
-- parameter, when using non-'P.Nothing' pointers to integers as keys in a
-- t'GI.GLib.Structs.HashTable.HashTable'.
-- 
-- Note that this function acts on pointers to @/gint/@, not on @/gint/@
-- directly: if your hash table\'s keys are of the form
-- @GINT_TO_POINTER (n)@, use 'GI.GLib.Functions.directEqual' instead.
intEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@v1@/: a pointer to a @/gint/@ key
    -> Ptr ()
    -- ^ /@v2@/: a pointer to a @/gint/@ key to compare with /@v1@/
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the two keys match.
intEqual v1 v2 = liftIO $ do
    result <- g_int_equal v1 v2
    let result' = (/= 0) result
    return result'


-- function int64_hash
-- Args: [ Arg
--           { argCName = "v"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gint64 key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_int64_hash" g_int64_hash :: 
    Ptr () ->                               -- v : TBasicType TPtr
    IO Word32

-- | Converts a pointer to a @/gint64/@ to a hash value.
-- 
-- It can be passed to @/g_hash_table_new()/@ as the /@hashFunc@/ parameter,
-- when using non-'P.Nothing' pointers to 64-bit integer values as keys in a
-- t'GI.GLib.Structs.HashTable.HashTable'.
-- 
-- /Since: 2.22/
int64Hash ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@v@/: a pointer to a @/gint64/@ key
    -> m Word32
    -- ^ __Returns:__ a hash value corresponding to the key.
int64Hash v = liftIO $ do
    result <- g_int64_hash v
    return result


-- function int64_equal
-- Args: [ Arg
--           { argCName = "v1"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a #gint64 key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "v2"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a pointer to a #gint64 key to compare with @v1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_int64_equal" g_int64_equal :: 
    Ptr () ->                               -- v1 : TBasicType TPtr
    Ptr () ->                               -- v2 : TBasicType TPtr
    IO CInt

-- | Compares the two @/gint64/@ values being pointed to and returns
-- 'P.True' if they are equal.
-- It can be passed to @/g_hash_table_new()/@ as the /@keyEqualFunc@/
-- parameter, when using non-'P.Nothing' pointers to 64-bit integers as keys in a
-- t'GI.GLib.Structs.HashTable.HashTable'.
-- 
-- /Since: 2.22/
int64Equal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@v1@/: a pointer to a @/gint64/@ key
    -> Ptr ()
    -- ^ /@v2@/: a pointer to a @/gint64/@ key to compare with /@v1@/
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the two keys match.
int64Equal v1 v2 = liftIO $ do
    result <- g_int64_equal v1 v2
    let result' = (/= 0) result
    return result'


-- function idle_source_new
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_idle_source_new" g_idle_source_new :: 
    IO (Ptr GLib.Source.Source)

-- | Creates a new idle source.
-- 
-- The source will not initially be associated with any
-- t'GI.GLib.Structs.MainContext.MainContext' and must be added to one with
-- 'GI.GLib.Structs.Source.sourceAttach' before it will be executed. Note that the
-- default priority for idle sources is [const/@gLib@/.PRIORITY_DEFAULT_IDLE], as
-- compared to other sources which have a default priority of
-- [const/@gLib@/.PRIORITY_DEFAULT].
idleSourceNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GLib.Source.Source
    -- ^ __Returns:__ the newly-created idle source
idleSourceNew  = liftIO $ do
    result <- g_idle_source_new
    checkUnexpectedReturnNULL "idleSourceNew" result
    result' <- (wrapBoxed GLib.Source.Source) result
    return result'


-- function idle_remove_by_data
-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data for the idle source\8217s callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_idle_remove_by_data" g_idle_remove_by_data :: 
    Ptr () ->                               -- data : TBasicType TPtr
    IO CInt

-- | Removes the idle function with the given data.
idleRemoveByData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@data@/: the data for the idle source’s callback.
    -> m Bool
    -- ^ __Returns:__ true if an idle source was found and removed, false otherwise
idleRemoveByData data_ = liftIO $ do
    result <- g_idle_remove_by_data data_
    let result' = (/= 0) result
    return result'


-- function idle_add
-- Args: [ Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the idle source; typically this will be in the\n  range between [const@GLib.PRIORITY_DEFAULT_IDLE] and\n  [const@GLib.PRIORITY_HIGH_IDLE]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "function"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call when the idle is removed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_idle_add_full" g_idle_add_full :: 
    Int32 ->                                -- priority : TBasicType TInt
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- function : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Adds a function to be called whenever there are no higher priority
-- events pending.
-- 
-- If the function returns [const/@gLib@/.SOURCE_REMOVE] it is automatically
-- removed from the list of event sources and will not be called again.
-- 
-- See <http://developer.gnome.org/glib/stable/main-loop.html#memory-management-of-sources main loop memory management> for details
-- on how to handle the return value and memory management of /@data@/.
-- 
-- This internally creates a main loop source using 'GI.GLib.Functions.idleSourceNew'
-- and attaches it to the global t'GI.GLib.Structs.MainContext.MainContext' using
-- 'GI.GLib.Structs.Source.sourceAttach', so the callback will be invoked in whichever
-- thread is running that main context. You can do these steps manually if you
-- need greater control or to use a custom main context.
idleAdd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@priority@/: the priority of the idle source; typically this will be in the
    --   range between [const/@gLib@/.PRIORITY_DEFAULT_IDLE] and
    --   [const/@gLib@/.PRIORITY_HIGH_IDLE]
    -> GLib.Callbacks.SourceFunc
    -- ^ /@function@/: function to call
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) of the event source
idleAdd priority function = liftIO $ do
    function' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc function))
    let data_ = castFunPtrToPtr function'
    let notify = SP.safeFreeFunPtrPtr
    result <- g_idle_add_full priority function' data_ notify
    return result


-- function hostname_to_unicode
-- Args: [ Arg
--           { argCName = "hostname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid UTF-8 or ASCII hostname"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_hostname_to_unicode" g_hostname_to_unicode :: 
    CString ->                              -- hostname : TBasicType TUTF8
    IO CString

-- | Converts /@hostname@/ to its canonical presentation form; a UTF-8
-- string in Unicode normalization form C, containing no uppercase
-- letters, no forbidden characters, and no ASCII-encoded segments,
-- and not ending with a trailing dot.
-- 
-- Of course if /@hostname@/ is not an internationalized hostname, then
-- the canonical presentation form will be entirely ASCII.
-- 
-- /Since: 2.22/
hostnameToUnicode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@hostname@/: a valid UTF-8 or ASCII hostname
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a UTF-8 hostname, which must be freed,
    --    or 'P.Nothing' if /@hostname@/ is in some way invalid.
hostnameToUnicode hostname = liftIO $ do
    hostname' <- textToCString hostname
    result <- g_hostname_to_unicode hostname'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem hostname'
    return maybeResult


-- function hostname_to_ascii
-- Args: [ Arg
--           { argCName = "hostname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid UTF-8 or ASCII hostname"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_hostname_to_ascii" g_hostname_to_ascii :: 
    CString ->                              -- hostname : TBasicType TUTF8
    IO CString

-- | Converts /@hostname@/ to its canonical ASCII form; an ASCII-only
-- string containing no uppercase letters and not ending with a
-- trailing dot.
-- 
-- /Since: 2.22/
hostnameToAscii ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@hostname@/: a valid UTF-8 or ASCII hostname
    -> m (Maybe T.Text)
    -- ^ __Returns:__ an ASCII hostname, which must be freed,
    --    or 'P.Nothing' if /@hostname@/ is in some way invalid.
hostnameToAscii hostname = liftIO $ do
    hostname' <- textToCString hostname
    result <- g_hostname_to_ascii hostname'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem hostname'
    return maybeResult


-- function hostname_is_non_ascii
-- Args: [ Arg
--           { argCName = "hostname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a hostname" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_hostname_is_non_ascii" g_hostname_is_non_ascii :: 
    CString ->                              -- hostname : TBasicType TUTF8
    IO CInt

-- | Tests if /@hostname@/ contains Unicode characters. If this returns
-- 'P.True', you need to encode the hostname with 'GI.GLib.Functions.hostnameToAscii'
-- before using it in non-IDN-aware contexts.
-- 
-- Note that a hostname might contain a mix of encoded and unencoded
-- segments, and so it is possible for 'GI.GLib.Functions.hostnameIsNonAscii' and
-- 'GI.GLib.Functions.hostnameIsAsciiEncoded' to both return 'P.True' for a name.
-- 
-- /Since: 2.22/
hostnameIsNonAscii ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@hostname@/: a hostname
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@hostname@/ contains any non-ASCII characters
hostnameIsNonAscii hostname = liftIO $ do
    hostname' <- textToCString hostname
    result <- g_hostname_is_non_ascii hostname'
    let result' = (/= 0) result
    freeMem hostname'
    return result'


-- function hostname_is_ip_address
-- Args: [ Arg
--           { argCName = "hostname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a hostname (or IP address in string form)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_hostname_is_ip_address" g_hostname_is_ip_address :: 
    CString ->                              -- hostname : TBasicType TUTF8
    IO CInt

-- | Tests if /@hostname@/ is the string form of an IPv4 or IPv6 address.
-- (Eg, \"192.168.0.1\".)
-- 
-- Since 2.66, IPv6 addresses with a zone-id are accepted (RFC6874).
-- 
-- /Since: 2.22/
hostnameIsIpAddress ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@hostname@/: a hostname (or IP address in string form)
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@hostname@/ is an IP address
hostnameIsIpAddress hostname = liftIO $ do
    hostname' <- textToCString hostname
    result <- g_hostname_is_ip_address hostname'
    let result' = (/= 0) result
    freeMem hostname'
    return result'


-- function hostname_is_ascii_encoded
-- Args: [ Arg
--           { argCName = "hostname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a hostname" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_hostname_is_ascii_encoded" g_hostname_is_ascii_encoded :: 
    CString ->                              -- hostname : TBasicType TUTF8
    IO CInt

-- | Tests if /@hostname@/ contains segments with an ASCII-compatible
-- encoding of an Internationalized Domain Name. If this returns
-- 'P.True', you should decode the hostname with 'GI.GLib.Functions.hostnameToUnicode'
-- before displaying it to the user.
-- 
-- Note that a hostname might contain a mix of encoded and unencoded
-- segments, and so it is possible for 'GI.GLib.Functions.hostnameIsNonAscii' and
-- 'GI.GLib.Functions.hostnameIsAsciiEncoded' to both return 'P.True' for a name.
-- 
-- /Since: 2.22/
hostnameIsAsciiEncoded ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@hostname@/: a hostname
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@hostname@/ contains any ASCII-encoded
    -- segments.
hostnameIsAsciiEncoded hostname = liftIO $ do
    hostname' <- textToCString hostname
    result <- g_hostname_is_ascii_encoded hostname'
    let result' = (/= 0) result
    freeMem hostname'
    return result'


-- function getenv
-- Args: [ Arg
--           { argCName = "variable"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the environment variable to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_getenv" g_getenv :: 
    CString ->                              -- variable : TBasicType TFileName
    IO CString

-- | Returns the value of an environment variable.
-- 
-- On UNIX, the name and value are byte strings which might or might not
-- be in some consistent character set and encoding. On Windows, they are
-- in UTF-8.
-- On Windows, in case the environment variable\'s value contains
-- references to other environment variables, they are expanded.
getenv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@variable@/: the environment variable to get
    -> m (Maybe [Char])
    -- ^ __Returns:__ the value of the environment variable, or 'P.Nothing' if
    --     the environment variable is not found. The returned string
    --     may be overwritten by the next call to 'GI.GLib.Functions.getenv', 'GI.GLib.Functions.setenv'
    --     or 'GI.GLib.Functions.unsetenv'.
getenv variable = liftIO $ do
    variable' <- stringToCString variable
    result <- g_getenv variable'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToString result'
        return result''
    freeMem variable'
    return maybeResult


-- function get_user_state_dir
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_user_state_dir" g_get_user_state_dir :: 
    IO CString

-- | Returns a base directory in which to store state files specific to
-- particular user.
-- 
-- On UNIX platforms this is determined using the mechanisms described
-- in the
-- <http://www.freedesktop.org/Standards/basedir-spec XDG Base Directory Specification>.
-- In this case the directory retrieved will be @XDG_STATE_HOME@.
-- 
-- On Windows it follows XDG Base Directory Specification if @XDG_STATE_HOME@ is defined.
-- If @XDG_STATE_HOME@ is undefined, the folder to use for local (as opposed
-- to roaming) application data is used instead. See the
-- <https://docs.microsoft.com/en-us/windows/win32/shell/knownfolderid documentation for `FOLDERID_LocalAppData`>.
-- Note that in this case on Windows it will be the same
-- as what 'GI.GLib.Functions.getUserDataDir' returns.
-- 
-- The return value is cached and modifying it at runtime is not supported, as
-- it’s not thread-safe to modify environment variables at runtime.
-- 
-- /Since: 2.72/
getUserStateDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ a string owned by GLib that
    --   must not be modified or freed.
getUserStateDir  = liftIO $ do
    result <- g_get_user_state_dir
    checkUnexpectedReturnNULL "getUserStateDir" result
    result' <- cstringToString result
    return result'


-- function get_user_special_dir
-- Args: [ Arg
--           { argCName = "directory"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "UserDirectory" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the logical id of special directory"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_user_special_dir" g_get_user_special_dir :: 
    CUInt ->                                -- directory : TInterface (Name {namespace = "GLib", name = "UserDirectory"})
    IO CString

-- | Returns the full path of a special directory using its logical id.
-- 
-- On UNIX this is done using the XDG special user directories.
-- For compatibility with existing practise, 'GI.GLib.Enums.UserDirectoryDirectoryDesktop'
-- falls back to @$HOME\/Desktop@ when XDG special user directories have
-- not been set up.
-- 
-- Depending on the platform, the user might be able to change the path
-- of the special directory without requiring the session to restart; GLib
-- will not reflect any change once the special directories are loaded.
-- 
-- /Since: 2.14/
getUserSpecialDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.UserDirectory
    -- ^ /@directory@/: the logical id of special directory
    -> m (Maybe [Char])
    -- ^ __Returns:__ the path to the specified special
    --   directory, or 'P.Nothing' if the logical id was not found. The returned string is
    --   owned by GLib and should not be modified or freed.
getUserSpecialDir directory = liftIO $ do
    let directory' = (fromIntegral . fromEnum) directory
    result <- g_get_user_special_dir directory'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToString result'
        return result''
    return maybeResult


-- function get_user_runtime_dir
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_user_runtime_dir" g_get_user_runtime_dir :: 
    IO CString

-- | Returns a directory that is unique to the current user on the local
-- system.
-- 
-- This is determined using the mechanisms described
-- in the
-- <http://www.freedesktop.org/Standards/basedir-spec XDG Base Directory Specification>.
-- This is the directory
-- specified in the @XDG_RUNTIME_DIR@ environment variable.
-- In the case that this variable is not set, we return the value of
-- 'GI.GLib.Functions.getUserCacheDir', after verifying that it exists.
-- 
-- The return value is cached and modifying it at runtime is not supported, as
-- it’s not thread-safe to modify environment variables at runtime.
-- 
-- /Since: 2.28/
getUserRuntimeDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ a string owned by GLib that must not be
    --     modified or freed.
getUserRuntimeDir  = liftIO $ do
    result <- g_get_user_runtime_dir
    checkUnexpectedReturnNULL "getUserRuntimeDir" result
    result' <- cstringToString result
    return result'


-- function get_user_name
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_user_name" g_get_user_name :: 
    IO CString

-- | Gets the user name of the current user. The encoding of the returned
-- string is system-defined. On UNIX, it might be the preferred file name
-- encoding, or something else, and there is no guarantee that it is even
-- consistent on a machine. On Windows, it is always UTF-8.
getUserName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ the user name of the current user.
getUserName  = liftIO $ do
    result <- g_get_user_name
    checkUnexpectedReturnNULL "getUserName" result
    result' <- cstringToString result
    return result'


-- function get_user_data_dir
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_user_data_dir" g_get_user_data_dir :: 
    IO CString

-- | Returns a base directory in which to access application data such
-- as icons that is customized for a particular user.
-- 
-- On UNIX platforms this is determined using the mechanisms described
-- in the
-- <http://www.freedesktop.org/Standards/basedir-spec XDG Base Directory Specification>.
-- In this case the directory retrieved will be @XDG_DATA_HOME@.
-- 
-- On Windows it follows XDG Base Directory Specification if @XDG_DATA_HOME@
-- is defined. If @XDG_DATA_HOME@ is undefined, the folder to use for local (as
-- opposed to roaming) application data is used instead. See the
-- <https://docs.microsoft.com/en-us/windows/win32/shell/knownfolderid documentation for `FOLDERID_LocalAppData`>.
-- Note that in this case on Windows it will be the same
-- as what 'GI.GLib.Functions.getUserConfigDir' returns.
-- 
-- The return value is cached and modifying it at runtime is not supported, as
-- it’s not thread-safe to modify environment variables at runtime.
-- 
-- /Since: 2.6/
getUserDataDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ a string owned by GLib that must
    --   not be modified or freed.
getUserDataDir  = liftIO $ do
    result <- g_get_user_data_dir
    checkUnexpectedReturnNULL "getUserDataDir" result
    result' <- cstringToString result
    return result'


-- function get_user_config_dir
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_user_config_dir" g_get_user_config_dir :: 
    IO CString

-- | Returns a base directory in which to store user-specific application
-- configuration information such as user preferences and settings.
-- 
-- On UNIX platforms this is determined using the mechanisms described
-- in the
-- <http://www.freedesktop.org/Standards/basedir-spec XDG Base Directory Specification>.
-- In this case the directory retrieved will be @XDG_CONFIG_HOME@.
-- 
-- On Windows it follows XDG Base Directory Specification if @XDG_CONFIG_HOME@ is defined.
-- If @XDG_CONFIG_HOME@ is undefined, the folder to use for local (as opposed
-- to roaming) application data is used instead. See the
-- <https://docs.microsoft.com/en-us/windows/win32/shell/knownfolderid documentation for `FOLDERID_LocalAppData`>.
-- Note that in this case on Windows it will be  the same
-- as what 'GI.GLib.Functions.getUserDataDir' returns.
-- 
-- The return value is cached and modifying it at runtime is not supported, as
-- it’s not thread-safe to modify environment variables at runtime.
-- 
-- /Since: 2.6/
getUserConfigDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ a string owned by GLib that
    --   must not be modified or freed.
getUserConfigDir  = liftIO $ do
    result <- g_get_user_config_dir
    checkUnexpectedReturnNULL "getUserConfigDir" result
    result' <- cstringToString result
    return result'


-- function get_user_cache_dir
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_user_cache_dir" g_get_user_cache_dir :: 
    IO CString

-- | Returns a base directory in which to store non-essential, cached
-- data specific to particular user.
-- 
-- On UNIX platforms this is determined using the mechanisms described
-- in the
-- <http://www.freedesktop.org/Standards/basedir-spec XDG Base Directory Specification>.
-- In this case the directory retrieved will be @XDG_CACHE_HOME@.
-- 
-- On Windows it follows XDG Base Directory Specification if @XDG_CACHE_HOME@ is defined.
-- If @XDG_CACHE_HOME@ is undefined, the directory that serves as a common
-- repository for temporary Internet files is used instead. A typical path is
-- @C:\\Documents and Settings\\username\\Local Settings\\Temporary Internet Files@.
-- See the <https://docs.microsoft.com/en-us/windows/win32/shell/knownfolderid documentation for `FOLDERID_InternetCache`>.
-- 
-- The return value is cached and modifying it at runtime is not supported, as
-- it’s not thread-safe to modify environment variables at runtime.
-- 
-- /Since: 2.6/
getUserCacheDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ a string owned by GLib that
    --   must not be modified or freed.
getUserCacheDir  = liftIO $ do
    result <- g_get_user_cache_dir
    checkUnexpectedReturnNULL "getUserCacheDir" result
    result' <- cstringToString result
    return result'


-- function get_tmp_dir
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_tmp_dir" g_get_tmp_dir :: 
    IO CString

-- | Gets the directory to use for temporary files.
-- 
-- On UNIX, this is taken from the @TMPDIR@ environment variable.
-- If the variable is not set, @P_tmpdir@ is
-- used, as defined by the system C library. Failing that, a
-- hard-coded default of \"\/tmp\" is returned.
-- 
-- On Windows, the @TEMP@ environment variable is used, with the
-- root directory of the Windows installation (eg: \"C:\\\") used
-- as a default.
-- 
-- The encoding of the returned string is system-defined. On Windows,
-- it is always UTF-8. The return value is never 'P.Nothing' or the empty
-- string.
getTmpDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ the directory to use for temporary files.
getTmpDir  = liftIO $ do
    result <- g_get_tmp_dir
    checkUnexpectedReturnNULL "getTmpDir" result
    result' <- cstringToString result
    return result'


-- function get_system_data_dirs
-- Args: []
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TFileName))
-- throws : False
-- Skip return : False

foreign import ccall "g_get_system_data_dirs" g_get_system_data_dirs :: 
    IO (Ptr CString)

-- | Returns an ordered list of base directories in which to access
-- system-wide application data.
-- 
-- On UNIX platforms this is determined using the mechanisms described
-- in the
-- <http://www.freedesktop.org/Standards/basedir-spec XDG Base Directory Specification>
-- In this case the list of directories retrieved will be @XDG_DATA_DIRS@.
-- 
-- On Windows it follows XDG Base Directory Specification if @XDG_DATA_DIRS@ is defined.
-- If @XDG_DATA_DIRS@ is undefined,
-- the first elements in the list are the Application Data
-- and Documents folders for All Users. (These can be determined only
-- on Windows 2000 or later and are not present in the list on other
-- Windows versions.) See documentation for FOLDERID_ProgramData and
-- FOLDERID_PublicDocuments.
-- 
-- Then follows the \"share\" subfolder in the installation folder for
-- the package containing the DLL that calls this function, if it can
-- be determined.
-- 
-- Finally the list contains the \"share\" subfolder in the installation
-- folder for GLib, and in the installation folder for the package the
-- application\'s .exe file belongs to.
-- 
-- The installation folders above are determined by looking up the
-- folder where the module (DLL or EXE) in question is located. If the
-- folder\'s name is \"bin\", its parent is used, otherwise the folder
-- itself.
-- 
-- Note that on Windows the returned list can vary depending on where
-- this function is called.
-- 
-- The return value is cached and modifying it at runtime is not supported, as
-- it’s not thread-safe to modify environment variables at runtime.
-- 
-- /Since: 2.6/
getSystemDataDirs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [[Char]]
    -- ^ __Returns:__ 
    --     a 'P.Nothing'-terminated array of strings owned by GLib that must not be
    --     modified or freed.
getSystemDataDirs  = liftIO $ do
    result <- g_get_system_data_dirs
    checkUnexpectedReturnNULL "getSystemDataDirs" result
    result' <- unpackZeroTerminatedFileNameArray result
    return result'


-- function get_system_config_dirs
-- Args: []
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TFileName))
-- throws : False
-- Skip return : False

foreign import ccall "g_get_system_config_dirs" g_get_system_config_dirs :: 
    IO (Ptr CString)

-- | Returns an ordered list of base directories in which to access
-- system-wide configuration information.
-- 
-- On UNIX platforms this is determined using the mechanisms described
-- in the
-- <http://www.freedesktop.org/Standards/basedir-spec XDG Base Directory Specification>.
-- In this case the list of directories retrieved will be @XDG_CONFIG_DIRS@.
-- 
-- On Windows it follows XDG Base Directory Specification if @XDG_CONFIG_DIRS@ is defined.
-- If @XDG_CONFIG_DIRS@ is undefined, the directory that contains application
-- data for all users is used instead. A typical path is
-- @C:\\Documents and Settings\\All Users\\Application Data@.
-- This folder is used for application data
-- that is not user specific. For example, an application can store
-- a spell-check dictionary, a database of clip art, or a log file in the
-- FOLDERID_ProgramData folder. This information will not roam and is available
-- to anyone using the computer.
-- 
-- The return value is cached and modifying it at runtime is not supported, as
-- it’s not thread-safe to modify environment variables at runtime.
-- 
-- /Since: 2.6/
getSystemConfigDirs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [[Char]]
    -- ^ __Returns:__ 
    --     a 'P.Nothing'-terminated array of strings owned by GLib that must not be
    --     modified or freed.
getSystemConfigDirs  = liftIO $ do
    result <- g_get_system_config_dirs
    checkUnexpectedReturnNULL "getSystemConfigDirs" result
    result' <- unpackZeroTerminatedFileNameArray result
    return result'


-- function get_real_time
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_real_time" g_get_real_time :: 
    IO Int64

-- | Queries the system wall-clock time.
-- 
-- This is equivalent to the UNIX <http://developer.gnome.org/glib/stable/man:gettimeofday(2 `gettimeofday()`>)
-- function, but portable.
-- 
-- You should only use this call if you are actually interested in the real
-- wall-clock time. 'GI.GLib.Functions.getMonotonicTime' is probably more useful for
-- measuring intervals.
-- 
-- /Since: 2.28/
getRealTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int64
    -- ^ __Returns:__ the number of microseconds since
    --   <https://en.wikipedia.org/wiki/Unix_time January 1, 1970 UTC>
getRealTime  = liftIO $ do
    result <- g_get_real_time
    return result


-- function get_real_name
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_real_name" g_get_real_name :: 
    IO CString

-- | Gets the real name of the user. This usually comes from the user\'s
-- entry in the @passwd@ file. The encoding of the returned string is
-- system-defined. (On Windows, it is, however, always UTF-8.) If the
-- real user name cannot be determined, the string \"Unknown\" is
-- returned.
getRealName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ the user\'s real name.
getRealName  = liftIO $ do
    result <- g_get_real_name
    checkUnexpectedReturnNULL "getRealName" result
    result' <- cstringToString result
    return result'


-- function get_prgname
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_prgname" g_get_prgname :: 
    IO CString

-- | Gets the name of the program. This name should not be localized,
-- in contrast to 'GI.GLib.Functions.getApplicationName'.
-- 
-- If you are using @/GApplication/@ the program name is set in
-- @/g_application_run()/@. In case of GDK or GTK it is set in
-- @/gdk_init()/@, which is called by @/gtk_init()/@ and the
-- @/GtkApplication::startup/@ handler. The program name is found by
-- taking the last component of /@argv@/[0].
getPrgname ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe T.Text)
    -- ^ __Returns:__ the name of the program,
    --   or 'P.Nothing' if it has not been set yet. The returned string belongs
    --   to GLib and must not be modified or freed.
getPrgname  = liftIO $ do
    result <- g_get_prgname
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult


-- function get_os_info
-- Args: [ Arg
--           { argCName = "key_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a key for the OS info being requested, for example %G_OS_INFO_KEY_NAME."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_os_info" g_get_os_info :: 
    CString ->                              -- key_name : TBasicType TUTF8
    IO CString

-- | Get information about the operating system.
-- 
-- On Linux this comes from the @\/etc\/os-release@ file. On other systems, it may
-- come from a variety of sources. You can either use the standard key names
-- like @/G_OS_INFO_KEY_NAME/@ or pass any UTF-8 string key name. For example,
-- @\/etc\/os-release@ provides a number of other less commonly used values that may
-- be useful. No key is guaranteed to be provided, so the caller should always
-- check if the result is 'P.Nothing'.
-- 
-- /Since: 2.64/
getOsInfo ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@keyName@/: a key for the OS info being requested, for example @/G_OS_INFO_KEY_NAME/@.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The associated value for the requested key or 'P.Nothing' if
    --   this information is not provided.
getOsInfo keyName = liftIO $ do
    keyName' <- textToCString keyName
    result <- g_get_os_info keyName'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem keyName'
    return maybeResult


-- function get_num_processors
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_num_processors" g_get_num_processors :: 
    IO Word32

-- | Determine the approximate number of threads that the system will
-- schedule simultaneously for this process.  This is intended to be
-- used as a parameter to @/g_thread_pool_new()/@ for CPU bound tasks and
-- similar cases.
-- 
-- /Since: 2.36/
getNumProcessors ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ Number of schedulable threads, always greater than 0
getNumProcessors  = liftIO $ do
    result <- g_get_num_processors
    return result


-- function get_monotonic_time
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_monotonic_time" g_get_monotonic_time :: 
    IO Int64

-- | Queries the system monotonic time.
-- 
-- The monotonic clock will always increase and doesn’t suffer
-- discontinuities when the user (or NTP) changes the system time.  It
-- may or may not continue to tick during times where the machine is
-- suspended.
-- 
-- We try to use the clock that corresponds as closely as possible to
-- the passage of time as measured by system calls such as
-- <http://developer.gnome.org/glib/stable/man:poll(2 `poll()`>) but it
-- may not always be possible to do this.
-- 
-- /Since: 2.28/
getMonotonicTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int64
    -- ^ __Returns:__ the monotonic time, in microseconds
getMonotonicTime  = liftIO $ do
    result <- g_get_monotonic_time
    return result


-- function get_locale_variants
-- Args: [ Arg
--           { argCName = "locale"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a locale identifier"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_get_locale_variants" g_get_locale_variants :: 
    CString ->                              -- locale : TBasicType TUTF8
    IO (Ptr CString)

-- | Returns a list of derived variants of /@locale@/, which can be used to
-- e.g. construct locale-dependent filenames or search paths. The returned
-- list is sorted from most desirable to least desirable.
-- This function handles territory, charset and extra locale modifiers. See
-- <http://developer.gnome.org/glib/stable/man:setlocale `setlocale(3)`> for information about locales and their format.
-- 
-- /@locale@/ itself is guaranteed to be returned in the output.
-- 
-- For example, if /@locale@/ is @fr_BE@, then the returned list
-- is @fr_BE@, @fr@. If /@locale@/ is @en_GB.UTF-8\@euro@, then the returned list
-- is @en_GB.UTF-8\@euro@, @en_GB.UTF-8@, @en_GB\@euro@, @en_GB@, @en.UTF-8\@euro@,
-- @en.UTF-8@, @en\@euro@, @en@.
-- 
-- If you need the list of variants for the current locale,
-- use 'GI.GLib.Functions.getLanguageNames'.
-- 
-- /Since: 2.28/
getLocaleVariants ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@locale@/: a locale identifier
    -> m [T.Text]
    -- ^ __Returns:__ a newly
    --   allocated array of newly allocated strings with the locale variants. Free with
    --   'GI.GLib.Functions.strfreev'.
getLocaleVariants locale = liftIO $ do
    locale' <- textToCString locale
    result <- g_get_locale_variants locale'
    checkUnexpectedReturnNULL "getLocaleVariants" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    freeMem locale'
    return result'


-- function get_language_names_with_category
-- Args: [ Arg
--           { argCName = "category_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a locale category name"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_get_language_names_with_category" g_get_language_names_with_category :: 
    CString ->                              -- category_name : TBasicType TUTF8
    IO (Ptr CString)

-- | Computes a list of applicable locale names with a locale category name,
-- which can be used to construct the fallback locale-dependent filenames
-- or search paths. The returned list is sorted from most desirable to
-- least desirable and always contains the default locale \"C\".
-- 
-- This function consults the environment variables @LANGUAGE@, @LC_ALL@,
-- /@categoryName@/, and @LANG@ to find the list of locales specified by the
-- user.
-- 
-- 'GI.GLib.Functions.getLanguageNames' returns g_get_language_names_with_category(\"LC_MESSAGES\").
-- 
-- /Since: 2.58/
getLanguageNamesWithCategory ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@categoryName@/: a locale category name
    -> m [T.Text]
    -- ^ __Returns:__ a 'P.Nothing'-terminated array of strings owned by
    --    the thread g_get_language_names_with_category was called from.
    --    It must not be modified or freed. It must be copied if planned to be used in another thread.
getLanguageNamesWithCategory categoryName = liftIO $ do
    categoryName' <- textToCString categoryName
    result <- g_get_language_names_with_category categoryName'
    checkUnexpectedReturnNULL "getLanguageNamesWithCategory" result
    result' <- unpackZeroTerminatedUTF8CArray result
    freeMem categoryName'
    return result'


-- function get_language_names
-- Args: []
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_get_language_names" g_get_language_names :: 
    IO (Ptr CString)

-- | Computes a list of applicable locale names, which can be used to
-- e.g. construct locale-dependent filenames or search paths. The returned
-- list is sorted from most desirable to least desirable and always contains
-- the default locale \"C\".
-- 
-- For example, if LANGUAGE=de:en_US, then the returned list is
-- \"de\", \"en_US\", \"en\", \"C\".
-- 
-- This function consults the environment variables @LANGUAGE@, @LC_ALL@,
-- @LC_MESSAGES@ and @LANG@ to find the list of locales specified by the
-- user.
-- 
-- /Since: 2.6/
getLanguageNames ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [T.Text]
    -- ^ __Returns:__ a 'P.Nothing'-terminated array of strings owned by GLib
    --    that must not be modified or freed.
getLanguageNames  = liftIO $ do
    result <- g_get_language_names
    checkUnexpectedReturnNULL "getLanguageNames" result
    result' <- unpackZeroTerminatedUTF8CArray result
    return result'


-- function get_host_name
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_host_name" g_get_host_name :: 
    IO CString

-- | Return a name for the machine.
-- 
-- The returned name is not necessarily a fully-qualified domain name,
-- or even present in DNS or some other name service at all. It need
-- not even be unique on your local network or site, but usually it
-- is. Callers should not rely on the return value having any specific
-- properties like uniqueness for security purposes. Even if the name
-- of the machine is changed while an application is running, the
-- return value from this function does not change. The returned
-- string is owned by GLib and should not be modified or freed. If no
-- name can be determined, a default fixed string \"localhost\" is
-- returned.
-- 
-- The encoding of the returned string is UTF-8.
-- 
-- /Since: 2.8/
getHostName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ the host name of the machine.
getHostName  = liftIO $ do
    result <- g_get_host_name
    checkUnexpectedReturnNULL "getHostName" result
    result' <- cstringToText result
    return result'


-- function get_home_dir
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_home_dir" g_get_home_dir :: 
    IO CString

-- | Gets the current user\'s home directory.
-- 
-- As with most UNIX tools, this function will return the value of the
-- @HOME@ environment variable if it is set to an existing absolute path
-- name, falling back to the @passwd@ file in the case that it is unset.
-- 
-- If the path given in @HOME@ is non-absolute, does not exist, or is
-- not a directory, the result is undefined.
-- 
-- Before version 2.36 this function would ignore the @HOME@ environment
-- variable, taking the value from the @passwd@ database instead. This was
-- changed to increase the compatibility of GLib with other programs (and
-- the XDG basedir specification) and to increase testability of programs
-- based on GLib (by making it easier to run them from test frameworks).
-- 
-- If your program has a strong requirement for either the new or the
-- old behaviour (and if you don\'t wish to increase your GLib
-- dependency to ensure that the new behaviour is in effect) then you
-- should either directly check the @HOME@ environment variable yourself
-- or unset it before calling any functions in GLib.
getHomeDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ the current user\'s home directory
getHomeDir  = liftIO $ do
    result <- g_get_home_dir
    checkUnexpectedReturnNULL "getHomeDir" result
    result' <- cstringToString result
    return result'


-- function get_filename_charsets
-- Args: [ Arg
--           { argCName = "filename_charsets"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n   return location for the %NULL-terminated list of encoding names"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_filename_charsets" g_get_filename_charsets :: 
    Ptr (Ptr CString) ->                    -- filename_charsets : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO CInt

-- | Determines the preferred character sets used for filenames.
-- The first character set from the /@charsets@/ is the filename encoding, the
-- subsequent character sets are used when trying to generate a displayable
-- representation of a filename, see 'GI.GLib.Functions.filenameDisplayName'.
-- 
-- On Unix, the character sets are determined by consulting the
-- environment variables @G_FILENAME_ENCODING@ and @G_BROKEN_FILENAMES@.
-- On Windows, the character set used in the GLib API is always UTF-8
-- and said environment variables have no effect.
-- 
-- @G_FILENAME_ENCODING@ may be set to a comma-separated list of
-- character set names. The special token @\@locale@ is taken to mean the
-- character set for the <http://developer.gnome.org/glib/stable/running.html#locale current locale>.
-- If @G_FILENAME_ENCODING@ is not set, but @G_BROKEN_FILENAMES@ is,
-- the character set of the current locale is taken as the filename
-- encoding. If neither environment variable  is set, UTF-8 is taken
-- as the filename encoding, but the character set of the current locale
-- is also put in the list of encodings.
-- 
-- The returned /@charsets@/ belong to GLib and must not be freed.
-- 
-- Note that on Unix, regardless of the locale character set or
-- @G_FILENAME_ENCODING@ value, the actual file names present
-- on a system might be in any random encoding or just gibberish.
-- 
-- /Since: 2.6/
getFilenameCharsets ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ((Bool, [T.Text]))
    -- ^ __Returns:__ 'P.True' if the filename encoding is UTF-8.
getFilenameCharsets  = liftIO $ do
    filenameCharsets <- callocMem :: IO (Ptr (Ptr CString))
    result <- g_get_filename_charsets filenameCharsets
    let result' = (/= 0) result
    filenameCharsets' <- peek filenameCharsets
    filenameCharsets'' <- unpackZeroTerminatedUTF8CArray filenameCharsets'
    freeMem filenameCharsets
    return (result', filenameCharsets'')


-- function get_environ
-- Args: []
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TFileName))
-- throws : False
-- Skip return : False

foreign import ccall "g_get_environ" g_get_environ :: 
    IO (Ptr CString)

-- | Gets the list of environment variables for the current process.
-- 
-- The list is 'P.Nothing' terminated and each item in the list is of the
-- form \'NAME=VALUE\'.
-- 
-- This is equivalent to direct access to the \'environ\' global variable,
-- except portable.
-- 
-- The return value is freshly allocated and it should be freed with
-- 'GI.GLib.Functions.strfreev' when it is no longer needed.
-- 
-- /Since: 2.28/
getEnviron ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [[Char]]
    -- ^ __Returns:__ 
    --     the list of environment variables
getEnviron  = liftIO $ do
    result <- g_get_environ
    checkUnexpectedReturnNULL "getEnviron" result
    result' <- unpackZeroTerminatedFileNameArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    return result'


-- function get_current_time
-- Args: [ Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TimeVal" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "[struct@GLib.TimeVal] structure in which to store current time"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_get_current_time" g_get_current_time :: 
    Ptr GLib.TimeVal.TimeVal ->             -- result : TInterface (Name {namespace = "GLib", name = "TimeVal"})
    IO ()

{-# DEPRECATED getCurrentTime ["(Since version 2.62)","t'GI.GLib.Structs.TimeVal.TimeVal' is not year-2038-safe. Use","   'GI.GLib.Functions.getRealTime' instead."] #-}
-- | Queries the system wall-clock time.
-- 
-- This is equivalent to the UNIX <http://developer.gnome.org/glib/stable/man:gettimeofday(2 `gettimeofday()`>)
-- function, but portable.
-- 
-- You may find 'GI.GLib.Functions.getRealTime' to be more convenient.
getCurrentTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.TimeVal.TimeVal
    -- ^ /@result@/: t'GI.GLib.Structs.TimeVal.TimeVal' structure in which to store current time
    -> m ()
getCurrentTime result_ = liftIO $ do
    result_' <- unsafeManagedPtrGetPtr result_
    g_get_current_time result_'
    touchManagedPtr result_
    return ()


-- function get_current_dir
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_current_dir" g_get_current_dir :: 
    IO CString

-- | Gets the current directory.
-- 
-- The returned string should be freed when no longer needed.
-- The encoding of the returned string is system defined.
-- On Windows, it is always UTF-8.
-- 
-- Since GLib 2.40, this function will return the value of the \"PWD\"
-- environment variable if it is set and it happens to be the same as
-- the current directory.  This can make a difference in the case that
-- the current directory is the target of a symbolic link.
getCurrentDir ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Char]
    -- ^ __Returns:__ the current directory
getCurrentDir  = liftIO $ do
    result <- g_get_current_dir
    checkUnexpectedReturnNULL "getCurrentDir" result
    result' <- cstringToString result
    freeMem result
    return result'


-- function get_console_charset
-- Args: [ Arg
--           { argCName = "charset"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for character set\n  name, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_console_charset" g_get_console_charset :: 
    Ptr CString ->                          -- charset : TBasicType TUTF8
    IO CInt

-- | Obtains the character set used by the console attached to the process,
-- which is suitable for printing output to the terminal.
-- 
-- Usually this matches the result returned by 'GI.GLib.Functions.getCharset', but in
-- environments where the locale\'s character set does not match the encoding
-- of the console this function tries to guess a more suitable value instead.
-- 
-- On Windows the character set returned by this function is the
-- output code page used by the console associated with the calling process.
-- If the codepage can\'t be determined (for example because there is no
-- console attached) UTF-8 is assumed.
-- 
-- The return value is 'P.True' if the locale\'s encoding is UTF-8, in that
-- case you can perhaps avoid calling 'GI.GLib.Functions.convert'.
-- 
-- The string returned in /@charset@/ is not allocated, and should not be
-- freed.
-- 
-- /Since: 2.62/
getConsoleCharset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ((Bool, T.Text))
    -- ^ __Returns:__ 'P.True' if the returned charset is UTF-8
getConsoleCharset  = liftIO $ do
    charset <- callocMem :: IO (Ptr CString)
    result <- g_get_console_charset charset
    let result' = (/= 0) result
    charset' <- peek charset
    charset'' <- cstringToText charset'
    freeMem charset
    return (result', charset'')


-- function get_codeset
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_codeset" g_get_codeset :: 
    IO CString

-- | Gets the character set for the current locale.
getCodeset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ a newly allocated string containing the name
    --     of the character set. This string must be freed with 'GI.GLib.Functions.free'.
getCodeset  = liftIO $ do
    result <- g_get_codeset
    checkUnexpectedReturnNULL "getCodeset" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function get_charset
-- Args: [ Arg
--           { argCName = "charset"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for character set\n  name, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_charset" g_get_charset :: 
    Ptr CString ->                          -- charset : TBasicType TUTF8
    IO CInt

-- | Obtains the character set for the <http://developer.gnome.org/glib/stable/running.html#locale current locale>;
-- you might use this character set as an argument to 'GI.GLib.Functions.convert', to convert
-- from the current locale\'s encoding to some other encoding. (Frequently
-- 'GI.GLib.Functions.localeToUtf8' and 'GI.GLib.Functions.localeFromUtf8' are nice shortcuts, though.)
-- 
-- On Windows the character set returned by this function is the
-- so-called system default ANSI code-page. That is the character set
-- used by the \"narrow\" versions of C library and Win32 functions that
-- handle file names. It might be different from the character set
-- used by the C library\'s current locale.
-- 
-- On Linux, the character set is found by consulting @/nl_langinfo()/@ if
-- available. If not, the environment variables @LC_ALL@, @LC_CTYPE@, @LANG@
-- and @CHARSET@ are queried in order. @/nl_langinfo()/@ returns the C locale if
-- no locale has been loaded by @/setlocale()/@.
-- 
-- The return value is 'P.True' if the locale\'s encoding is UTF-8, in that
-- case you can perhaps avoid calling 'GI.GLib.Functions.convert'.
-- 
-- The string returned in /@charset@/ is not allocated, and should not be
-- freed.
getCharset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ((Bool, T.Text))
    -- ^ __Returns:__ 'P.True' if the returned charset is UTF-8
getCharset  = liftIO $ do
    charset <- callocMem :: IO (Ptr CString)
    result <- g_get_charset charset
    let result' = (/= 0) result
    charset' <- peek charset
    charset'' <- cstringToText charset'
    freeMem charset
    return (result', charset'')


-- function get_application_name
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_get_application_name" g_get_application_name :: 
    IO CString

-- | Gets a human-readable name for the application, as set by
-- 'GI.GLib.Functions.setApplicationName'. This name should be localized if
-- possible, and is intended for display to the user.  Contrast with
-- 'GI.GLib.Functions.getPrgname', which gets a non-localized name. If
-- 'GI.GLib.Functions.setApplicationName' has not been called, returns the result of
-- 'GI.GLib.Functions.getPrgname' (which may be 'P.Nothing' if 'GI.GLib.Functions.setPrgname' has also not
-- been called).
-- 
-- /Since: 2.2/
getApplicationName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe T.Text)
    -- ^ __Returns:__ human-readable application
    --   name. May return 'P.Nothing'
getApplicationName  = liftIO $ do
    result <- g_get_application_name
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult


-- function fsync
-- Args: [ Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file descriptor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_fsync" g_fsync :: 
    Int32 ->                                -- fd : TBasicType TInt
    IO Int32

-- | A wrapper for the POSIX @fsync()@ function. On Windows, @_commit()@ will be
-- used. On macOS, @fcntl(F_FULLFSYNC)@ will be used.
-- The @fsync()@ function is used to synchronize a file\'s in-core
-- state with that of the disk.
-- 
-- This wrapper will handle retrying on @EINTR@.
-- 
-- See the C library manual for more details about @/fsync()/@.
-- 
-- /Since: 2.64/
fsync ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@fd@/: a file descriptor
    -> m Int32
    -- ^ __Returns:__ 0 on success, or -1 if an error occurred.
    -- The return value can be used exactly like the return value from @/fsync()/@.
fsync fd = liftIO $ do
    result <- g_fsync fd
    return result


-- function freopen
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string describing the mode in which the file should be  opened"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stream"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "an existing stream which will be reused, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_freopen" g_freopen :: 
    CString ->                              -- filename : TBasicType TFileName
    CString ->                              -- mode : TBasicType TUTF8
    Ptr () ->                               -- stream : TBasicType TPtr
    IO (Ptr ())

-- | A wrapper for the POSIX @/freopen()/@ function. The @/freopen()/@ function
-- opens a file and associates it with an existing stream.
-- 
-- See your C library manual for more details about @/freopen()/@.
-- 
-- Since GLib 2.86, the @e@ option is supported in /@mode@/ on all platforms. See
-- the documentation for 'GI.GLib.Functions.fopen' for more details.
-- 
-- /Since: 2.6/
freopen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> T.Text
    -- ^ /@mode@/: a string describing the mode in which the file should be  opened
    -> Ptr ()
    -- ^ /@stream@/: an existing stream which will be reused, or 'P.Nothing'
    -> m (Ptr ())
    -- ^ __Returns:__ A FILE* if the file was successfully opened, or 'P.Nothing' if
    --     an error occurred.
freopen filename mode stream = liftIO $ do
    filename' <- stringToCString filename
    mode' <- textToCString mode
    result <- g_freopen filename' mode' stream
    freeMem filename'
    freeMem mode'
    return result


-- function free_sized
-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory to free" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "size of @mem, in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_free_sized" g_free_sized :: 
    Ptr () ->                               -- mem : TBasicType TPtr
    FCT.CSize ->                            -- size : TBasicType TSize
    IO ()

-- | Frees the memory pointed to by /@mem@/, assuming it is has the given /@size@/.
-- 
-- If /@mem@/ is 'P.Nothing' this is a no-op (and /@size@/ is ignored).
-- 
-- It is an error if /@size@/ doesn’t match the size passed when /@mem@/ was
-- allocated. /@size@/ is passed to this function to allow optimizations in the
-- allocator. If you don’t know the allocation size, use 'GI.GLib.Functions.free' instead.
-- 
-- In case a GCC compatible compiler is used, this function may be used
-- automatically via 'GI.GLib.Functions.free' if the allocated size is known at compile time,
-- since GLib 2.78.
-- 
-- /Since: 2.76/
freeSized ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@mem@/: the memory to free
    -> FCT.CSize
    -- ^ /@size@/: size of /@mem@/, in bytes
    -> m ()
freeSized mem size = liftIO $ do
    g_free_sized mem size
    return ()


-- function free
-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the memory to free" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_free" g_free :: 
    Ptr () ->                               -- mem : TBasicType TPtr
    IO ()

-- | Frees the memory pointed to by /@mem@/.
-- 
-- If you know the allocated size of /@mem@/, calling 'GI.GLib.Functions.freeSized' may be faster,
-- depending on the libc implementation in use.
-- 
-- Starting from GLib 2.78, this may happen automatically in case a GCC
-- compatible compiler is used with some optimization level and the allocated
-- size is known at compile time (see <https://gcc.gnu.org/onlinedocs/gcc/Object-Size-Checking.html documentation of
-- `__builtin_object_size()`>
-- to understand its caveats).
-- 
-- If /@mem@/ is 'P.Nothing' it simply returns, so there is no need to check /@mem@/
-- against 'P.Nothing' before calling this function.
free ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@mem@/: the memory to free
    -> m ()
free mem = liftIO $ do
    g_free mem
    return ()


-- function format_size_full
-- Args: [ Arg
--           { argCName = "size"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a size in bytes" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "FormatSizeFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GFormatSizeFlags to modify the output"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_format_size_full" g_format_size_full :: 
    Word64 ->                               -- size : TBasicType TUInt64
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "FormatSizeFlags"})
    IO CString

-- | Formats a size.
-- 
-- This function is similar to 'GI.GLib.Functions.formatSize' but allows for flags
-- that modify the output. See t'GI.GLib.Flags.FormatSizeFlags'.
-- 
-- /Since: 2.30/
formatSizeFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word64
    -- ^ /@size@/: a size in bytes
    -> [GLib.Flags.FormatSizeFlags]
    -- ^ /@flags@/: t'GI.GLib.Flags.FormatSizeFlags' to modify the output
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated formatted string
    --   containing a human readable file size
formatSizeFull size flags = liftIO $ do
    let flags' = gflagsToWord flags
    result <- g_format_size_full size flags'
    checkUnexpectedReturnNULL "formatSizeFull" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function format_size_for_display
-- Args: [ Arg
--           { argCName = "size"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a size in bytes" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_format_size_for_display" g_format_size_for_display :: 
    Int64 ->                                -- size : TBasicType TInt64
    IO CString

{-# DEPRECATED formatSizeForDisplay ["(Since version 2.30)","This function is broken due to its use of SI","    suffixes to denote IEC units. Use 'GI.GLib.Functions.formatSize' instead."] #-}
-- | Formats a size (for example the size of a file) into a human
-- readable string. Sizes are rounded to the nearest size prefix
-- (KB, MB, GB) and are displayed rounded to the nearest tenth.
-- E.g. the file size 3292528 bytes will be converted into the
-- string \"3.1 MB\".
-- 
-- The prefix units base is 1024 (i.e. 1 KB is 1024 bytes).
-- 
-- This string should be freed with 'GI.GLib.Functions.free' when not needed any longer.
-- 
-- /Since: 2.16/
formatSizeForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int64
    -- ^ /@size@/: a size in bytes
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated formatted string
    --   containing a human readable file size
formatSizeForDisplay size = liftIO $ do
    result <- g_format_size_for_display size
    checkUnexpectedReturnNULL "formatSizeForDisplay" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function format_size
-- Args: [ Arg
--           { argCName = "size"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a size in bytes" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_format_size" g_format_size :: 
    Word64 ->                               -- size : TBasicType TUInt64
    IO CString

-- | Formats a size (for example the size of a file) into a human readable
-- string.  Sizes are rounded to the nearest size prefix (kB, MB, GB)
-- and are displayed rounded to the nearest tenth. E.g. the file size
-- 3292528 bytes will be converted into the string \"3.2 MB\". The returned string
-- is UTF-8, and may use a non-breaking space to separate the number and units,
-- to ensure they aren’t separated when line wrapped.
-- 
-- The prefix units base is 1000 (i.e. 1 kB is 1000 bytes).
-- 
-- This string should be freed with 'GI.GLib.Functions.free' when not needed any longer.
-- 
-- See 'GI.GLib.Functions.formatSizeFull' for more options about how the size might be
-- formatted.
-- 
-- /Since: 2.30/
formatSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word64
    -- ^ /@size@/: a size in bytes
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated formatted string containing
    --   a human readable file size
formatSize size = liftIO $ do
    result <- g_format_size size
    checkUnexpectedReturnNULL "formatSize" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function fopen
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pathname in the GLib file name encoding\n    (UTF-8 on Windows)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string describing the mode in which the file should be opened"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_fopen" g_fopen :: 
    CString ->                              -- filename : TBasicType TFileName
    CString ->                              -- mode : TBasicType TUTF8
    IO (Ptr ())

-- | A wrapper for the stdio @fopen()@ function. The @fopen()@ function
-- opens a file and associates a new stream with it.
-- 
-- Because file descriptors are specific to the C library on Windows,
-- and a file descriptor is part of the @FILE@ struct, the @FILE*@ returned
-- by this function makes sense only to functions in the same C library.
-- Thus if the GLib-using code uses a different C library than GLib does,
-- the FILE* returned by this function cannot be passed to C library
-- functions like @fprintf()@ or @fread()@.
-- 
-- See your C library manual for more details about @fopen()@.
-- 
-- As @close()@ and @fclose()@ are part of the C library, this implies that it is
-- currently impossible to close a file if the application C library and the C library
-- used by GLib are different. Convenience functions like 'GI.GLib.Functions.fileSetContentsFull'
-- avoid this problem.
-- 
-- Since GLib 2.86, the @e@ option is supported in /@mode@/ on all platforms. On
-- Unix platforms it will set @O_CLOEXEC@ on the opened file descriptor. On
-- Windows platforms it will be converted to the
-- <https://learn.microsoft.com/en-us/cpp/c-runtime-library/reference/fopen-wfopen?view=msvc-170 `N` modifier>.
-- It is recommended to set @e@ unconditionally, unless you know the returned
-- file should be shared between this process and a new fork.
-- 
-- /Since: 2.6/
fopen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname in the GLib file name encoding
    --     (UTF-8 on Windows)
    -> T.Text
    -- ^ /@mode@/: a string describing the mode in which the file should be opened
    -> m (Ptr ())
    -- ^ __Returns:__ A @FILE*@ if the file was successfully opened, or 'P.Nothing' if
    --     an error occurred
fopen filename mode = liftIO $ do
    filename' <- stringToCString filename
    mode' <- textToCString mode
    result <- g_fopen filename' mode'
    freeMem filename'
    freeMem mode'
    return result


-- function find_program_in_path
-- Args: [ Arg
--           { argCName = "program"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a program name in the GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_find_program_in_path" g_find_program_in_path :: 
    CString ->                              -- program : TBasicType TFileName
    IO CString

-- | Locates the first executable named /@program@/ in the user\'s path, in the
-- same way that @/execvp()/@ would locate it. Returns an allocated string
-- with the absolute path name, or 'P.Nothing' if the program is not found in
-- the path. If /@program@/ is already an absolute path, returns a copy of
-- /@program@/ if /@program@/ exists and is executable, and 'P.Nothing' otherwise.
--  
-- On Windows, if /@program@/ does not have a file type suffix, tries
-- with the suffixes .exe, .cmd, .bat and .com, and the suffixes in
-- the @PATHEXT@ environment variable.
-- 
-- On Windows, it looks for the file in the same way as @/CreateProcess()/@
-- would. This means first in the directory where the executing
-- program was loaded from, then in the current directory, then in the
-- Windows 32-bit system directory, then in the Windows directory, and
-- finally in the directories in the @PATH@ environment variable. If
-- the program is found, the return value contains the full name
-- including the type suffix.
findProgramInPath ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@program@/: a program name in the GLib file name encoding
    -> m (Maybe [Char])
    -- ^ __Returns:__ a newly-allocated
    --   string with the absolute path, or 'P.Nothing'
findProgramInPath program = liftIO $ do
    program' <- stringToCString program
    result <- g_find_program_in_path program'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToString result'
        freeMem result'
        return result''
    freeMem program'
    return maybeResult


-- function filename_to_utf8
-- Args: [ Arg
--           { argCName = "opsysstring"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string in the encoding for filenames"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the length of the string, or -1 if the string is\n                nul-terminated (Note that some encodings may allow nul\n                bytes to occur inside strings. In that case, using -1\n                for the @len parameter is unsafe)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes_read"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the number of bytes in the\n                input string that were successfully converted, or %NULL.\n                Even if the conversion was successful, this may be\n                less than @len if there were partial characters\n                at the end of the input. If the error\n                %G_CONVERT_ERROR_ILLEGAL_SEQUENCE occurs, the value\n                stored will be the byte offset after the last valid\n                input sequence."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "bytes_written"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the number of bytes stored in the output\n                buffer (not including the terminating nul)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : True
-- Skip return : False

foreign import ccall "g_filename_to_utf8" g_filename_to_utf8 :: 
    CString ->                              -- opsysstring : TBasicType TFileName
    DI.Int64 ->                             -- len : TBasicType TSSize
    Ptr FCT.CSize ->                        -- bytes_read : TBasicType TSize
    Ptr FCT.CSize ->                        -- bytes_written : TBasicType TSize
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Converts a string which is in the encoding used by GLib for
-- filenames into a UTF-8 string. Note that on Windows GLib uses UTF-8
-- for filenames; on other platforms, this function indirectly depends on
-- the <http://developer.gnome.org/glib/stable/running.html#locale current locale>.
-- 
-- The input string shall not contain nul characters even if the /@len@/
-- argument is positive. A nul character found inside the string will result
-- in error 'GI.GLib.Enums.ConvertErrorIllegalSequence'.
-- If the source encoding is not UTF-8 and the conversion output contains a
-- nul character, the error 'GI.GLib.Enums.ConvertErrorEmbeddedNul' is set and the
-- function returns 'P.Nothing'. Use 'GI.GLib.Functions.convert' to produce output that
-- may contain embedded nul characters.
filenameToUtf8 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@opsysstring@/: a string in the encoding for filenames
    -> DI.Int64
    -- ^ /@len@/: the length of the string, or -1 if the string is
    --                 nul-terminated (Note that some encodings may allow nul
    --                 bytes to occur inside strings. In that case, using -1
    --                 for the /@len@/ parameter is unsafe)
    -> m ((T.Text, FCT.CSize, FCT.CSize))
    -- ^ __Returns:__ The converted string, or 'P.Nothing' on an error. /(Can throw 'Data.GI.Base.GError.GError')/
filenameToUtf8 opsysstring len = liftIO $ do
    opsysstring' <- stringToCString opsysstring
    bytesRead <- allocMem :: IO (Ptr FCT.CSize)
    bytesWritten <- allocMem :: IO (Ptr FCT.CSize)
    onException (do
        result <- propagateGError $ g_filename_to_utf8 opsysstring' len bytesRead bytesWritten
        checkUnexpectedReturnNULL "filenameToUtf8" result
        result' <- cstringToText result
        freeMem result
        bytesRead' <- peek bytesRead
        bytesWritten' <- peek bytesWritten
        freeMem opsysstring'
        freeMem bytesRead
        freeMem bytesWritten
        return (result', bytesRead', bytesWritten')
     ) (do
        freeMem opsysstring'
        freeMem bytesRead
        freeMem bytesWritten
     )


-- function filename_to_uri
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an absolute filename specified in the GLib file\n    name encoding, which is the on-disk file name bytes on Unix, and UTF-8\n    on Windows"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hostname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A UTF-8 encoded hostname, or %NULL for none."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : True
-- Skip return : False

foreign import ccall "g_filename_to_uri" g_filename_to_uri :: 
    CString ->                              -- filename : TBasicType TFileName
    CString ->                              -- hostname : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Converts an absolute filename to an escaped ASCII-encoded URI, with the path
-- component following Section 3.3. of RFC 2396.
filenameToUri ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: an absolute filename specified in the GLib file
    --     name encoding, which is the on-disk file name bytes on Unix, and UTF-8
    --     on Windows
    -> Maybe (T.Text)
    -- ^ /@hostname@/: A UTF-8 encoded hostname, or 'P.Nothing' for none.
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated string holding the resulting
    --               URI, or 'P.Nothing' on an error. /(Can throw 'Data.GI.Base.GError.GError')/
filenameToUri filename hostname = liftIO $ do
    filename' <- stringToCString filename
    maybeHostname <- case hostname of
        Nothing -> return FP.nullPtr
        Just jHostname -> do
            jHostname' <- textToCString jHostname
            return jHostname'
    onException (do
        result <- propagateGError $ g_filename_to_uri filename' maybeHostname
        checkUnexpectedReturnNULL "filenameToUri" result
        result' <- cstringToText result
        freeMem result
        freeMem filename'
        freeMem maybeHostname
        return result'
     ) (do
        freeMem filename'
        freeMem maybeHostname
     )


-- function filename_from_utf8
-- Args: [ Arg
--           { argCName = "utf8string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 encoded string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the length of the string, or -1 if the string is\n                nul-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes_read"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the number of bytes in\n                the input string that were successfully converted, or %NULL.\n                Even if the conversion was successful, this may be\n                less than @len if there were partial characters\n                at the end of the input. If the error\n                %G_CONVERT_ERROR_ILLEGAL_SEQUENCE occurs, the value\n                stored will be the byte offset after the last valid\n                input sequence."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "bytes_written"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the number of bytes stored in\n                the output buffer (not including the terminating nul)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : True
-- Skip return : False

foreign import ccall "g_filename_from_utf8" g_filename_from_utf8 :: 
    CString ->                              -- utf8string : TBasicType TUTF8
    DI.Int64 ->                             -- len : TBasicType TSSize
    Ptr FCT.CSize ->                        -- bytes_read : TBasicType TSize
    Ptr FCT.CSize ->                        -- bytes_written : TBasicType TSize
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Converts a string from UTF-8 to the encoding GLib uses for
-- filenames. Note that on Windows GLib uses UTF-8 for filenames;
-- on other platforms, this function indirectly depends on the
-- <http://developer.gnome.org/glib/stable/running.html#locale current locale>.
-- 
-- The input string shall not contain nul characters even if the /@len@/
-- argument is positive. A nul character found inside the string will result
-- in error 'GI.GLib.Enums.ConvertErrorIllegalSequence'. If the filename encoding is
-- not UTF-8 and the conversion output contains a nul character, the error
-- 'GI.GLib.Enums.ConvertErrorEmbeddedNul' is set and the function returns 'P.Nothing'.
filenameFromUtf8 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@utf8string@/: a UTF-8 encoded string.
    -> DI.Int64
    -- ^ /@len@/: the length of the string, or -1 if the string is
    --                 nul-terminated.
    -> m (([Char], FCT.CSize, FCT.CSize))
    -- ^ __Returns:__ 
    --               The converted string, or 'P.Nothing' on an error. /(Can throw 'Data.GI.Base.GError.GError')/
filenameFromUtf8 utf8string len = liftIO $ do
    utf8string' <- textToCString utf8string
    bytesRead <- allocMem :: IO (Ptr FCT.CSize)
    bytesWritten <- allocMem :: IO (Ptr FCT.CSize)
    onException (do
        result <- propagateGError $ g_filename_from_utf8 utf8string' len bytesRead bytesWritten
        checkUnexpectedReturnNULL "filenameFromUtf8" result
        result' <- cstringToString result
        freeMem result
        bytesRead' <- peek bytesRead
        bytesWritten' <- peek bytesWritten
        freeMem utf8string'
        freeMem bytesRead
        freeMem bytesWritten
        return (result', bytesRead', bytesWritten')
     ) (do
        freeMem utf8string'
        freeMem bytesRead
        freeMem bytesWritten
     )


-- function filename_from_uri
-- Args: [ Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a uri describing a filename (escaped, encoded in ASCII)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hostname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Location to store hostname for the URI.\n           If there is no hostname in the URI, %NULL will be\n           stored in this location."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : True
-- Skip return : False

foreign import ccall "g_filename_from_uri" g_filename_from_uri :: 
    CString ->                              -- uri : TBasicType TUTF8
    Ptr CString ->                          -- hostname : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Converts an escaped ASCII-encoded URI to a local filename in the
-- encoding used for filenames.
-- 
-- Since GLib 2.78, the query string and fragment can be present in the URI,
-- but are not part of the resulting filename.
-- We take inspiration from https:\/\/url.spec.whatwg.org\/@/file/@-state,
-- but we don\'t support the entire standard.
filenameFromUri ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@uri@/: a uri describing a filename (escaped, encoded in ASCII).
    -> m (([Char], Maybe T.Text))
    -- ^ __Returns:__ a newly-allocated string holding
    --               the resulting filename, or 'P.Nothing' on an error. /(Can throw 'Data.GI.Base.GError.GError')/
filenameFromUri uri = liftIO $ do
    uri' <- textToCString uri
    hostname <- callocMem :: IO (Ptr CString)
    onException (do
        result <- propagateGError $ g_filename_from_uri uri' hostname
        checkUnexpectedReturnNULL "filenameFromUri" result
        result' <- cstringToString result
        freeMem result
        hostname' <- peek hostname
        maybeHostname' <- convertIfNonNull hostname' $ \hostname'' -> do
            hostname''' <- cstringToText hostname''
            return hostname'''
        freeMem hostname'
        freeMem uri'
        freeMem hostname
        return (result', maybeHostname')
     ) (do
        freeMem uri'
        freeMem hostname
     )


-- function filename_display_name
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a pathname hopefully in the\n    GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_filename_display_name" g_filename_display_name :: 
    CString ->                              -- filename : TBasicType TFileName
    IO CString

-- | Converts a filename into a valid UTF-8 string. The conversion is
-- not necessarily reversible, so you should keep the original around
-- and use the return value of this function only for display purposes.
-- Unlike 'GI.GLib.Functions.filenameToUtf8', the result is guaranteed to be non-'P.Nothing'
-- even if the filename actually isn\'t in the GLib file name encoding.
-- 
-- If GLib cannot make sense of the encoding of /@filename@/, as a last resort it
-- replaces unknown characters with U+FFFD, the Unicode replacement character.
-- You can search the result for the UTF-8 encoding of this character (which is
-- \"\\357\\277\\275\" in octal notation) to find out if /@filename@/ was in an invalid
-- encoding.
-- 
-- If you know the whole pathname of the file you should use
-- 'GI.GLib.Functions.filenameDisplayBasename', since that allows location-based
-- translation of filenames.
-- 
-- /Since: 2.6/
filenameDisplayName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a pathname hopefully in the
    --     GLib file name encoding
    -> m T.Text
    -- ^ __Returns:__ a newly allocated string containing
    --   a rendition of the filename in valid UTF-8
filenameDisplayName filename = liftIO $ do
    filename' <- stringToCString filename
    result <- g_filename_display_name filename'
    checkUnexpectedReturnNULL "filenameDisplayName" result
    result' <- cstringToText result
    freeMem result
    freeMem filename'
    return result'


-- function filename_display_basename
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "an absolute pathname in the\n    GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_filename_display_basename" g_filename_display_basename :: 
    CString ->                              -- filename : TBasicType TFileName
    IO CString

-- | Returns the display basename for the particular filename, guaranteed
-- to be valid UTF-8. The display name might not be identical to the filename,
-- for instance there might be problems converting it to UTF-8, and some files
-- can be translated in the display.
-- 
-- If GLib cannot make sense of the encoding of /@filename@/, as a last resort it
-- replaces unknown characters with U+FFFD, the Unicode replacement character.
-- You can search the result for the UTF-8 encoding of this character (which is
-- \"\\357\\277\\275\" in octal notation) to find out if /@filename@/ was in an invalid
-- encoding.
-- 
-- You must pass the whole absolute pathname to this functions so that
-- translation of well known locations can be done.
-- 
-- This function is preferred over 'GI.GLib.Functions.filenameDisplayName' if you know the
-- whole path, as it allows translation.
-- 
-- /Since: 2.6/
filenameDisplayBasename ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: an absolute pathname in the
    --     GLib file name encoding
    -> m T.Text
    -- ^ __Returns:__ a newly allocated string containing
    --   a rendition of the basename of the filename in valid UTF-8
filenameDisplayBasename filename = liftIO $ do
    filename' <- stringToCString filename
    result <- g_filename_display_basename filename'
    checkUnexpectedReturnNULL "filenameDisplayBasename" result
    result' <- cstringToText result
    freeMem result
    freeMem filename'
    return result'


-- function file_test
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a filename to test in the\n    GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "test"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "FileTest" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bitfield of #GFileTest flags"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_file_test" g_file_test :: 
    CString ->                              -- filename : TBasicType TFileName
    CUInt ->                                -- test : TInterface (Name {namespace = "GLib", name = "FileTest"})
    IO CInt

-- | Returns 'P.True' if any of the tests in the bitfield /@test@/ are
-- 'P.True'. For example, @(G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)@
-- will return 'P.True' if the file exists; the check whether it\'s a
-- directory doesn\'t matter since the existence test is 'P.True'. With
-- the current set of available tests, there\'s no point passing in
-- more than one test at a time.
-- 
-- Apart from 'GI.GLib.Flags.FileTestIsSymlink' all tests follow symbolic links,
-- so for a symbolic link to a regular file 'GI.GLib.Functions.fileTest' will return
-- 'P.True' for both 'GI.GLib.Flags.FileTestIsSymlink' and 'GI.GLib.Flags.FileTestIsRegular'.
-- 
-- Note, that for a dangling symbolic link 'GI.GLib.Functions.fileTest' will return
-- 'P.True' for 'GI.GLib.Flags.FileTestIsSymlink' and 'P.False' for all other flags.
-- 
-- You should never use 'GI.GLib.Functions.fileTest' to test whether it is safe
-- to perform an operation, because there is always the possibility
-- of the condition changing before you actually perform the operation,
-- see <https://en.wikipedia.org/wiki/Time-of-check_to_time-of-use TOCTOU>.
-- 
-- For example, you might think you could use 'GI.GLib.Flags.FileTestIsSymlink'
-- to know whether it is safe to write to a file without being
-- tricked into writing into a different location. It doesn\'t work!
-- 
-- 
-- === /C code/
-- >
-- > // DON'T DO THIS
-- > if (!g_file_test (filename, G_FILE_TEST_IS_SYMLINK))
-- >   {
-- >     fd = g_open (filename, O_WRONLY);
-- >     // write to fd
-- >   }
-- >
-- > // DO THIS INSTEAD
-- > fd = g_open (filename, O_WRONLY | O_NOFOLLOW | O_CLOEXEC);
-- > if (fd == -1)
-- >   {
-- >     // check error
-- >     if (errno == ELOOP)
-- >       // file is a symlink and can be ignored
-- >     else
-- >       // handle errors as before
-- >   }
-- > else
-- >   {
-- >     // write to fd
-- >   }
-- 
-- 
-- Another thing to note is that 'GI.GLib.Flags.FileTestExists' and
-- 'GI.GLib.Flags.FileTestIsExecutable' are implemented using the @/access()/@
-- system call. This usually doesn\'t matter, but if your program
-- is setuid or setgid it means that these tests will give you
-- the answer for the real user ID and group ID, rather than the
-- effective user ID and group ID.
-- 
-- On Windows, there are no symlinks, so testing for
-- 'GI.GLib.Flags.FileTestIsSymlink' will always return 'P.False'. Testing for
-- 'GI.GLib.Flags.FileTestIsExecutable' will just check that the file exists and
-- its name indicates that it is executable, checking for well-known
-- extensions and those listed in the @PATHEXT@ environment variable.
fileTest ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: a filename to test in the
    --     GLib file name encoding
    -> [GLib.Flags.FileTest]
    -- ^ /@test@/: bitfield of t'GI.GLib.Flags.FileTest' flags
    -> m Bool
    -- ^ __Returns:__ whether a test was 'P.True'
fileTest filename test = liftIO $ do
    filename' <- stringToCString filename
    let test' = gflagsToWord test
    result <- g_file_test filename' test'
    let result' = (/= 0) result
    freeMem filename'
    return result'


-- function file_set_contents_full
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "name of a file to write @contents to, in the GLib file name\n  encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "contents"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to write to the file"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "length of @contents, or -1 if @contents is a nul-terminated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "FileSetContentsFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "flags controlling the safety vs speed of the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "file mode, as passed to `open()`; typically this will be `0666`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "length of @contents, or -1 if @contents is a nul-terminated string"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_file_set_contents_full" g_file_set_contents_full :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr Word8 ->                            -- contents : TCArray False (-1) 2 (TBasicType TUInt8)
    DI.Int64 ->                             -- length : TBasicType TSSize
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "FileSetContentsFlags"})
    Int32 ->                                -- mode : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Writes all of /@contents@/ to a file named /@filename@/, with good error checking.
-- If a file called /@filename@/ already exists it will be overwritten.
-- 
-- /@flags@/ control the properties of the write operation: whether it’s atomic,
-- and what the tradeoff is between returning quickly or being resilient to
-- system crashes.
-- 
-- As this function performs file I\/O, it is recommended to not call it anywhere
-- where blocking would cause problems, such as in the main loop of a graphical
-- application. In particular, if /@flags@/ has any value other than
-- 'GI.GLib.Flags.FileSetContentsFlagsNone' then this function may call @fsync()@.
-- 
-- If 'GI.GLib.Flags.FileSetContentsFlagsConsistent' is set in /@flags@/, the operation is atomic
-- in the sense that it is first written to a temporary file which is then
-- renamed to the final name.
-- 
-- Notes:
-- 
-- * On UNIX, if /@filename@/ already exists hard links to /@filename@/ will break.
--   Also since the file is recreated, existing permissions, access control
--   lists, metadata etc. may be lost. If /@filename@/ is a symbolic link,
--   the link itself will be replaced, not the linked file.
-- * On UNIX, if /@filename@/ already exists and is non-empty, and if the system
--   supports it (via a journalling filesystem or equivalent), and if
--   'GI.GLib.Flags.FileSetContentsFlagsConsistent' is set in /@flags@/, the @fsync()@ call (or
--   equivalent) will be used to ensure atomic replacement: /@filename@/
--   will contain either its old contents or /@contents@/, even in the face of
--   system power loss, the disk being unsafely removed, etc.
-- * On UNIX, if /@filename@/ does not already exist or is empty, there is a
--   possibility that system power loss etc. after calling this function will
--   leave /@filename@/ empty or full of NUL bytes, depending on the underlying
--   filesystem, unless 'GI.GLib.Flags.FileSetContentsFlagsDurable' and
--   'GI.GLib.Flags.FileSetContentsFlagsConsistent' are set in /@flags@/.
-- * On Windows renaming a file will not remove an existing file with the
--   new name, so on Windows there is a race condition between the existing
--   file being removed and the temporary file being renamed.
-- * On Windows there is no way to remove a file that is open to some
--   process, or mapped into memory. Thus, this function will fail if
--   /@filename@/ already exists and is open.
-- 
-- 
-- If the call was successful, it returns 'P.True'. If the call was not successful,
-- it returns 'P.False' and sets /@error@/. The error domain is @/G_FILE_ERROR/@.
-- Possible error codes are those in the t'GI.GLib.Enums.FileError' enumeration.
-- 
-- Note that the name for the temporary file is constructed by appending up
-- to 7 characters to /@filename@/.
-- 
-- If the file didn’t exist before and is created, it will be given the
-- permissions from /@mode@/. Otherwise, the permissions of the existing file will
-- remain unchanged.
-- 
-- /Since: 2.66/
fileSetContentsFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: name of a file to write /@contents@/ to, in the GLib file name
    --   encoding
    -> ByteString
    -- ^ /@contents@/: string to write to the file
    -> [GLib.Flags.FileSetContentsFlags]
    -- ^ /@flags@/: flags controlling the safety vs speed of the operation
    -> Int32
    -- ^ /@mode@/: file mode, as passed to @open()@; typically this will be @0666@
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileSetContentsFull filename contents flags mode = liftIO $ do
    let length_ = fromIntegral $ B.length contents
    filename' <- stringToCString filename
    contents' <- packByteString contents
    let flags' = gflagsToWord flags
    onException (do
        _ <- propagateGError $ g_file_set_contents_full filename' contents' length_ flags' mode
        freeMem filename'
        freeMem contents'
        return ()
     ) (do
        freeMem filename'
        freeMem contents'
     )


-- function file_set_contents
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "name of a file to write @contents to, in the GLib file name\n  encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "contents"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to write to the file"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "length of @contents, or -1 if @contents is a nul-terminated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "length of @contents, or -1 if @contents is a nul-terminated string"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_file_set_contents" g_file_set_contents :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr Word8 ->                            -- contents : TCArray False (-1) 2 (TBasicType TUInt8)
    DI.Int64 ->                             -- length : TBasicType TSSize
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Writes all of /@contents@/ to a file named /@filename@/. This is a convenience
-- wrapper around calling 'GI.GLib.Functions.fileSetContentsFull' with @flags@ set to
-- @G_FILE_SET_CONTENTS_CONSISTENT | G_FILE_SET_CONTENTS_ONLY_EXISTING@ and
-- @mode@ set to @0666@.
-- 
-- /Since: 2.8/
fileSetContents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: name of a file to write /@contents@/ to, in the GLib file name
    --   encoding
    -> ByteString
    -- ^ /@contents@/: string to write to the file
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileSetContents filename contents = liftIO $ do
    let length_ = fromIntegral $ B.length contents
    filename' <- stringToCString filename
    contents' <- packByteString contents
    onException (do
        _ <- propagateGError $ g_file_set_contents filename' contents' length_
        freeMem filename'
        freeMem contents'
        return ()
     ) (do
        freeMem filename'
        freeMem contents'
     )


-- function file_read_link
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the symbolic link" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : True
-- Skip return : False

foreign import ccall "g_file_read_link" g_file_read_link :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Reads the contents of the symbolic link /@filename@/ like the POSIX
-- @readlink()@ function.
-- 
-- The returned string is in the encoding used for filenames. Use
-- 'GI.GLib.Functions.filenameToUtf8' to convert it to UTF-8.
-- 
-- The returned string may also be a relative path. Use @/g_build_filename()/@
-- to convert it to an absolute path:
-- 
-- 
-- === /C code/
-- >
-- >g_autoptr(GError) local_error = NULL;
-- >g_autofree gchar *link_target = g_file_read_link ("/etc/localtime", &local_error);
-- >
-- >if (local_error != NULL)
-- >  g_error ("Error reading link: %s", local_error->message);
-- >
-- >if (!g_path_is_absolute (link_target))
-- >  {
-- >    g_autofree gchar *absolute_link_target = g_build_filename ("/etc", link_target, NULL);
-- >    g_free (link_target);
-- >    link_target = g_steal_pointer (&absolute_link_target);
-- >  }
-- 
-- 
-- /Since: 2.4/
fileReadLink ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: the symbolic link
    -> m [Char]
    -- ^ __Returns:__ A newly-allocated string with
    --   the contents of the symbolic link, or 'P.Nothing' if an error occurred. /(Can throw 'Data.GI.Base.GError.GError')/
fileReadLink filename = liftIO $ do
    filename' <- stringToCString filename
    onException (do
        result <- propagateGError $ g_file_read_link filename'
        checkUnexpectedReturnNULL "fileReadLink" result
        result' <- cstringToString result
        freeMem result
        freeMem filename'
        return result'
     ) (do
        freeMem filename'
     )


-- function file_open_tmp
-- Args: [ Arg
--           { argCName = "tmpl"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Template for file name, as in\n  g_mkstemp(), basename only, or %NULL for a default template"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_used"
--           , argType = TBasicType TFileName
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store actual name used,\n  or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : True
-- Skip return : False

foreign import ccall "g_file_open_tmp" g_file_open_tmp :: 
    CString ->                              -- tmpl : TBasicType TFileName
    Ptr CString ->                          -- name_used : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO Int32

-- | Opens a file for writing in the preferred directory for temporary
-- files (as returned by 'GI.GLib.Functions.getTmpDir').
-- 
-- /@tmpl@/ should be a string in the GLib file name encoding containing
-- a sequence of six \'X\' characters, as the parameter to @/g_mkstemp()/@.
-- However, unlike these functions, the template should only be a
-- basename, no directory components are allowed. If template is
-- 'P.Nothing', a default template is used.
-- 
-- Note that in contrast to @/g_mkstemp()/@ (and @/mkstemp()/@) /@tmpl@/ is not
-- modified, and might thus be a read-only literal string.
-- 
-- Upon success, and if /@nameUsed@/ is non-'P.Nothing', the actual name used
-- is returned in /@nameUsed@/. This string should be freed with 'GI.GLib.Functions.free'
-- when not needed any longer. The returned name is in the GLib file
-- name encoding.
fileOpenTmp ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@tmpl@/: Template for file name, as in
    --   @/g_mkstemp()/@, basename only, or 'P.Nothing' for a default template
    -> m ((Int32, [Char]))
    -- ^ __Returns:__ A file handle (as from @/open()/@) to the file opened for
    --   reading and writing. The file is opened in binary mode on platforms
    --   where there is a difference. The file handle should be closed with
    --   @/close()/@. In case of errors, -1 is returned and /@error@/ will be set. /(Can throw 'Data.GI.Base.GError.GError')/
fileOpenTmp tmpl = liftIO $ do
    maybeTmpl <- case tmpl of
        Nothing -> return FP.nullPtr
        Just jTmpl -> do
            jTmpl' <- stringToCString jTmpl
            return jTmpl'
    nameUsed <- callocMem :: IO (Ptr CString)
    onException (do
        result <- propagateGError $ g_file_open_tmp maybeTmpl nameUsed
        nameUsed' <- peek nameUsed
        nameUsed'' <- cstringToString nameUsed'
        freeMem nameUsed'
        freeMem maybeTmpl
        freeMem nameUsed
        return (result, nameUsed'')
     ) (do
        freeMem maybeTmpl
        freeMem nameUsed
     )


-- function file_get_contents
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "name of a file to read contents from, in the GLib file name encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "contents"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store an allocated string, use g_free() to free\n    the returned string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store length in bytes of the contents, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TSize
--              , direction = DirectionOut
--              , mayBeNull = True
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "location to store length in bytes of the contents, or %NULL"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_file_get_contents" g_file_get_contents :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr (Ptr Word8) ->                      -- contents : TCArray False (-1) 2 (TBasicType TUInt8)
    Ptr FCT.CSize ->                        -- length : TBasicType TSize
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Reads an entire file into allocated memory, with good error
-- checking.
-- 
-- If the call was successful, it returns 'P.True' and sets /@contents@/ to the file
-- contents and /@length@/ to the length of the file contents in bytes. The string
-- stored in /@contents@/ will be nul-terminated, so for text files you can pass
-- 'P.Nothing' for the /@length@/ argument. If the call was not successful, it returns
-- 'P.False' and sets /@error@/. The error domain is @/G_FILE_ERROR/@. Possible error
-- codes are those in the t'GI.GLib.Enums.FileError' enumeration. In the error case,
-- /@contents@/ is set to 'P.Nothing' and /@length@/ is set to zero.
fileGetContents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: name of a file to read contents from, in the GLib file name encoding
    -> m (ByteString)
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
fileGetContents filename = liftIO $ do
    filename' <- stringToCString filename
    contents <- callocMem :: IO (Ptr (Ptr Word8))
    length_ <- allocMem :: IO (Ptr FCT.CSize)
    onException (do
        _ <- propagateGError $ g_file_get_contents filename' contents length_
        length_' <- peek length_
        contents' <- peek contents
        contents'' <- (unpackByteStringWithLength length_') contents'
        freeMem contents'
        freeMem filename'
        freeMem contents
        freeMem length_
        return contents''
     ) (do
        freeMem filename'
        freeMem contents
        freeMem length_
     )


-- function file_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_file_error_quark" g_file_error_quark :: 
    IO Word32

-- | /No description available in the introspection data./
fileErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
fileErrorQuark  = liftIO $ do
    result <- g_file_error_quark
    return result


-- function file_error_from_errno
-- Args: [ Arg
--           { argCName = "err_no"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an \"errno\" value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "FileError" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_error_from_errno" g_file_error_from_errno :: 
    Int32 ->                                -- err_no : TBasicType TInt
    IO CUInt

-- | Gets a t'GI.GLib.Enums.FileError' constant based on the passed-in /@errNo@/.
-- 
-- For example, if you pass in @EEXIST@ this function returns
-- 'GI.GLib.Enums.FileErrorExist'. Unlike @errno@ values, you can portably
-- assume that all t'GI.GLib.Enums.FileError' values will exist.
-- 
-- Normally a t'GI.GLib.Enums.FileError' value goes into a t'GError' returned
-- from a function that manipulates files. So you would use
-- 'GI.GLib.Functions.fileErrorFromErrno' when constructing a t'GError'.
fileErrorFromErrno ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@errNo@/: an \"errno\" value
    -> m GLib.Enums.FileError
    -- ^ __Returns:__ t'GI.GLib.Enums.FileError' corresponding to the given /@errNo@/
fileErrorFromErrno errNo = liftIO $ do
    result <- g_file_error_from_errno errNo
    let result' = (toEnum . fromIntegral) result
    return result'


-- function fdwalk_set_cloexec
-- Args: [ Arg
--           { argCName = "lowfd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Minimum fd to act on, which must be non-negative"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_fdwalk_set_cloexec" g_fdwalk_set_cloexec :: 
    Int32 ->                                -- lowfd : TBasicType TInt
    IO Int32

-- | Mark every file descriptor equal to or greater than /@lowfd@/ to be closed
-- at the next @execve()@ or similar, as if via the @FD_CLOEXEC@ flag.
-- 
-- Typically /@lowfd@/ will be 3, to leave standard input, standard output
-- and standard error open after exec.
-- 
-- This is the same as Linux @close_range (lowfd, ~0U, CLOSE_RANGE_CLOEXEC)@,
-- but portable to other OSs and to older versions of Linux.
-- 
-- This function is async-signal safe, making it safe to call from a
-- signal handler or a [callback/@gLib@/.SpawnChildSetupFunc], as long as /@lowfd@/ is
-- non-negative.
-- See <http://developer.gnome.org/glib/stable/man:signal(7 `signal(7)`>) and
-- <http://developer.gnome.org/glib/stable/man:signal-safety(7 `signal-safety(7)`>) for more details.
-- 
-- /Since: 2.80/
fdwalkSetCloexec ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@lowfd@/: Minimum fd to act on, which must be non-negative
    -> m Int32
    -- ^ __Returns:__ 0 on success, -1 with errno set on error
fdwalkSetCloexec lowfd = liftIO $ do
    result <- g_fdwalk_set_cloexec lowfd
    return result


-- function environ_unsetenv
-- Args: [ Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n    an environment list that can be freed using g_strfreev() (e.g., as\n    returned from g_get_environ()), or %NULL for an empty environment list"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "variable"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the environment variable to remove, must not\n    contain '='"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TFileName))
-- throws : False
-- Skip return : False

foreign import ccall "g_environ_unsetenv" g_environ_unsetenv :: 
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TFileName)
    CString ->                              -- variable : TBasicType TFileName
    IO (Ptr CString)

-- | Removes the environment variable /@variable@/ from the provided
-- environment /@envp@/.
-- 
-- /Since: 2.32/
environUnsetenv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([[Char]])
    -- ^ /@envp@/: 
    --     an environment list that can be freed using 'GI.GLib.Functions.strfreev' (e.g., as
    --     returned from 'GI.GLib.Functions.getEnviron'), or 'P.Nothing' for an empty environment list
    -> [Char]
    -- ^ /@variable@/: the environment variable to remove, must not
    --     contain \'=\'
    -> m [[Char]]
    -- ^ __Returns:__ 
    --     the updated environment list. Free it using 'GI.GLib.Functions.strfreev'.
environUnsetenv envp variable = liftIO $ do
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedFileNameArray jEnvp
            return jEnvp'
    variable' <- stringToCString variable
    result <- g_environ_unsetenv maybeEnvp variable'
    checkUnexpectedReturnNULL "environUnsetenv" result
    result' <- unpackZeroTerminatedFileNameArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    freeMem variable'
    return result'


-- function environ_setenv
-- Args: [ Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n    an environment list that can be freed using g_strfreev() (e.g., as\n    returned from g_get_environ()), or %NULL for an empty\n    environment list"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "variable"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the environment variable to set, must not\n    contain '='"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value for to set the variable to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "overwrite"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to change the variable if it already exists"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TFileName))
-- throws : False
-- Skip return : False

foreign import ccall "g_environ_setenv" g_environ_setenv :: 
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TFileName)
    CString ->                              -- variable : TBasicType TFileName
    CString ->                              -- value : TBasicType TFileName
    CInt ->                                 -- overwrite : TBasicType TBoolean
    IO (Ptr CString)

-- | Sets the environment variable /@variable@/ in the provided list
-- /@envp@/ to /@value@/.
-- 
-- /Since: 2.32/
environSetenv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([[Char]])
    -- ^ /@envp@/: 
    --     an environment list that can be freed using 'GI.GLib.Functions.strfreev' (e.g., as
    --     returned from 'GI.GLib.Functions.getEnviron'), or 'P.Nothing' for an empty
    --     environment list
    -> [Char]
    -- ^ /@variable@/: the environment variable to set, must not
    --     contain \'=\'
    -> [Char]
    -- ^ /@value@/: the value for to set the variable to
    -> Bool
    -- ^ /@overwrite@/: whether to change the variable if it already exists
    -> m [[Char]]
    -- ^ __Returns:__ 
    --     the updated environment list. Free it using 'GI.GLib.Functions.strfreev'.
environSetenv envp variable value overwrite = liftIO $ do
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedFileNameArray jEnvp
            return jEnvp'
    variable' <- stringToCString variable
    value' <- stringToCString value
    let overwrite' = (P.fromIntegral . P.fromEnum) overwrite
    result <- g_environ_setenv maybeEnvp variable' value' overwrite'
    checkUnexpectedReturnNULL "environSetenv" result
    result' <- unpackZeroTerminatedFileNameArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    freeMem variable'
    freeMem value'
    return result'


-- function environ_getenv
-- Args: [ Arg
--           { argCName = "envp"
--           , argType = TCArray True (-1) (-1) (TBasicType TFileName)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n    an environment list (eg, as returned from g_get_environ()), or %NULL\n    for an empty environment list"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variable"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the environment variable to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_environ_getenv" g_environ_getenv :: 
    Ptr CString ->                          -- envp : TCArray True (-1) (-1) (TBasicType TFileName)
    CString ->                              -- variable : TBasicType TFileName
    IO CString

-- | Returns the value of the environment variable /@variable@/ in the
-- provided list /@envp@/.
-- 
-- /Since: 2.32/
environGetenv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([[Char]])
    -- ^ /@envp@/: 
    --     an environment list (eg, as returned from 'GI.GLib.Functions.getEnviron'), or 'P.Nothing'
    --     for an empty environment list
    -> [Char]
    -- ^ /@variable@/: the environment variable to get
    -> m (Maybe [Char])
    -- ^ __Returns:__ the value of the environment variable, or 'P.Nothing' if
    --     the environment variable is not set in /@envp@/. The returned
    --     string is owned by /@envp@/, and will be freed if /@variable@/ is
    --     set or unset again.
environGetenv envp variable = liftIO $ do
    maybeEnvp <- case envp of
        Nothing -> return FP.nullPtr
        Just jEnvp -> do
            jEnvp' <- packZeroTerminatedFileNameArray jEnvp
            return jEnvp'
    variable' <- stringToCString variable
    result <- g_environ_getenv maybeEnvp variable'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToString result'
        return result''
    mapZeroTerminatedCArray freeMem maybeEnvp
    freeMem maybeEnvp
    freeMem variable'
    return maybeResult


-- function dpgettext2
-- Args: [ Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the translation domain to use, or %NULL to use\n  the domain set with textdomain()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the message context"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "msgid"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the message" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_dpgettext2" g_dpgettext2 :: 
    CString ->                              -- domain : TBasicType TUTF8
    CString ->                              -- context : TBasicType TUTF8
    CString ->                              -- msgid : TBasicType TUTF8
    IO CString

-- | This function is a variant of 'GI.GLib.Functions.dgettext' which supports
-- a disambiguating message context. GNU gettext uses the
-- \'\\004\' character to separate the message context and
-- message id in /@msgctxtid@/.
-- 
-- This uses 'GI.GLib.Functions.dgettext' internally. See that functions for differences
-- with @/dgettext()/@ proper.
-- 
-- This function differs from @/C_()/@ in that it is not a macro and
-- thus you may use non-string-literals as context and msgid arguments.
-- 
-- /Since: 2.18/
dpgettext2 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@domain@/: the translation domain to use, or 'P.Nothing' to use
    --   the domain set with @/textdomain()/@
    -> T.Text
    -- ^ /@context@/: the message context
    -> T.Text
    -- ^ /@msgid@/: the message
    -> m T.Text
    -- ^ __Returns:__ The translated string
dpgettext2 domain context msgid = liftIO $ do
    maybeDomain <- case domain of
        Nothing -> return FP.nullPtr
        Just jDomain -> do
            jDomain' <- textToCString jDomain
            return jDomain'
    context' <- textToCString context
    msgid' <- textToCString msgid
    result <- g_dpgettext2 maybeDomain context' msgid'
    checkUnexpectedReturnNULL "dpgettext2" result
    result' <- cstringToText result
    freeMem maybeDomain
    freeMem context'
    freeMem msgid'
    return result'


-- function dpgettext
-- Args: [ Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the translation domain to use, or %NULL to use\n  the domain set with textdomain()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "msgctxtid"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a combined message context and message id, separated\n  by a \\004 character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "msgidoffset"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the offset of the message id in @msgctxid"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_dpgettext" g_dpgettext :: 
    CString ->                              -- domain : TBasicType TUTF8
    CString ->                              -- msgctxtid : TBasicType TUTF8
    FCT.CSize ->                            -- msgidoffset : TBasicType TSize
    IO CString

-- | This function is a variant of 'GI.GLib.Functions.dgettext' which supports
-- a disambiguating message cont