{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The base class for objects that are meant to hold layout properties.
-- 
-- If a @GtkLayoutManager@ has per-child properties, like their packing type,
-- or the horizontal and vertical span, or the icon name, then the layout
-- manager should use a @GtkLayoutChild@ implementation to store those properties.
-- 
-- A @GtkLayoutChild@ instance is only ever valid while a widget is part
-- of a layout.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.LayoutChild
    ( 

-- * Exported types
    LayoutChild(..)                         ,
    IsLayoutChild                           ,
    toLayoutChild                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChildWidget]("GI.Gtk.Objects.LayoutChild#g:method:getChildWidget"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLayoutManager]("GI.Gtk.Objects.LayoutChild#g:method:getLayoutManager"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveLayoutChildMethod                ,
#endif

-- ** getChildWidget #method:getChildWidget#

#if defined(ENABLE_OVERLOADING)
    LayoutChildGetChildWidgetMethodInfo     ,
#endif
    layoutChildGetChildWidget               ,


-- ** getLayoutManager #method:getLayoutManager#

#if defined(ENABLE_OVERLOADING)
    LayoutChildGetLayoutManagerMethodInfo   ,
#endif
    layoutChildGetLayoutManager             ,




 -- * Properties


-- ** childWidget #attr:childWidget#
-- | The widget that is associated to the @GtkLayoutChild@ instance.

#if defined(ENABLE_OVERLOADING)
    LayoutChildChildWidgetPropertyInfo      ,
#endif
    constructLayoutChildChildWidget         ,
    getLayoutChildChildWidget               ,
#if defined(ENABLE_OVERLOADING)
    layoutChildChildWidget                  ,
#endif


-- ** layoutManager #attr:layoutManager#
-- | The layout manager that created the @GtkLayoutChild@ instance.

#if defined(ENABLE_OVERLOADING)
    LayoutChildLayoutManagerPropertyInfo    ,
#endif
    constructLayoutChildLayoutManager       ,
    getLayoutChildLayoutManager             ,
#if defined(ENABLE_OVERLOADING)
    layoutChildLayoutManager                ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype LayoutChild = LayoutChild (SP.ManagedPtr LayoutChild)
    deriving (Eq)

instance SP.ManagedPtrNewtype LayoutChild where
    toManagedPtr (LayoutChild p) = p

foreign import ccall "gtk_layout_child_get_type"
    c_gtk_layout_child_get_type :: IO B.Types.GType

instance B.Types.TypedObject LayoutChild where
    glibType = c_gtk_layout_child_get_type

instance B.Types.GObject LayoutChild

-- | Type class for types which can be safely cast to t'LayoutChild', for instance with `toLayoutChild`.
class (SP.GObject o, O.IsDescendantOf LayoutChild o) => IsLayoutChild o
instance (SP.GObject o, O.IsDescendantOf LayoutChild o) => IsLayoutChild o

instance O.HasParentTypes LayoutChild
type instance O.ParentTypes LayoutChild = '[GObject.Object.Object]

-- | Cast to t'LayoutChild', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toLayoutChild :: (MIO.MonadIO m, IsLayoutChild o) => o -> m LayoutChild
toLayoutChild = MIO.liftIO . B.ManagedPtr.unsafeCastTo LayoutChild

-- | Convert t'LayoutChild' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe LayoutChild) where
    gvalueGType_ = c_gtk_layout_child_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr LayoutChild)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr LayoutChild)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject LayoutChild ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveLayoutChildMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveLayoutChildMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveLayoutChildMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveLayoutChildMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveLayoutChildMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveLayoutChildMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveLayoutChildMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveLayoutChildMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveLayoutChildMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveLayoutChildMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveLayoutChildMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveLayoutChildMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveLayoutChildMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveLayoutChildMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveLayoutChildMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveLayoutChildMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveLayoutChildMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveLayoutChildMethod "getChildWidget" o = LayoutChildGetChildWidgetMethodInfo
    ResolveLayoutChildMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveLayoutChildMethod "getLayoutManager" o = LayoutChildGetLayoutManagerMethodInfo
    ResolveLayoutChildMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveLayoutChildMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveLayoutChildMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveLayoutChildMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveLayoutChildMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveLayoutChildMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveLayoutChildMethod t LayoutChild, O.OverloadedMethod info LayoutChild p) => OL.IsLabel t (LayoutChild -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveLayoutChildMethod t LayoutChild, O.OverloadedMethod info LayoutChild p, R.HasField t LayoutChild p) => R.HasField t LayoutChild p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveLayoutChildMethod t LayoutChild, O.OverloadedMethodInfo info LayoutChild) => OL.IsLabel t (O.MethodProxy info LayoutChild) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@child-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' layoutChild #childWidget
-- @
getLayoutChildChildWidget :: (MonadIO m, IsLayoutChild o) => o -> m Gtk.Widget.Widget
getLayoutChildChildWidget obj = MIO.liftIO $ checkUnexpectedNothing "getLayoutChildChildWidget" $ B.Properties.getObjectPropertyObject obj "child-widget" Gtk.Widget.Widget

-- | Construct a t'GValueConstruct' with valid value for the “@child-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructLayoutChildChildWidget :: (IsLayoutChild o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructLayoutChildChildWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child-widget" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data LayoutChildChildWidgetPropertyInfo
instance AttrInfo LayoutChildChildWidgetPropertyInfo where
    type AttrAllowedOps LayoutChildChildWidgetPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint LayoutChildChildWidgetPropertyInfo = IsLayoutChild
    type AttrSetTypeConstraint LayoutChildChildWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint LayoutChildChildWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType LayoutChildChildWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType LayoutChildChildWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrLabel LayoutChildChildWidgetPropertyInfo = "child-widget"
    type AttrOrigin LayoutChildChildWidgetPropertyInfo = LayoutChild
    attrGet = getLayoutChildChildWidget
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructLayoutChildChildWidget
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LayoutChild.childWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-LayoutChild.html#g:attr:childWidget"
        })
#endif

-- VVV Prop "layout-manager"
   -- Type: TInterface (Name {namespace = "Gtk", name = "LayoutManager"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@layout-manager@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' layoutChild #layoutManager
-- @
getLayoutChildLayoutManager :: (MonadIO m, IsLayoutChild o) => o -> m Gtk.LayoutManager.LayoutManager
getLayoutChildLayoutManager obj = MIO.liftIO $ checkUnexpectedNothing "getLayoutChildLayoutManager" $ B.Properties.getObjectPropertyObject obj "layout-manager" Gtk.LayoutManager.LayoutManager

-- | Construct a t'GValueConstruct' with valid value for the “@layout-manager@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructLayoutChildLayoutManager :: (IsLayoutChild o, MIO.MonadIO m, Gtk.LayoutManager.IsLayoutManager a) => a -> m (GValueConstruct o)
constructLayoutChildLayoutManager val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "layout-manager" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data LayoutChildLayoutManagerPropertyInfo
instance AttrInfo LayoutChildLayoutManagerPropertyInfo where
    type AttrAllowedOps LayoutChildLayoutManagerPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint LayoutChildLayoutManagerPropertyInfo = IsLayoutChild
    type AttrSetTypeConstraint LayoutChildLayoutManagerPropertyInfo = Gtk.LayoutManager.IsLayoutManager
    type AttrTransferTypeConstraint LayoutChildLayoutManagerPropertyInfo = Gtk.LayoutManager.IsLayoutManager
    type AttrTransferType LayoutChildLayoutManagerPropertyInfo = Gtk.LayoutManager.LayoutManager
    type AttrGetType LayoutChildLayoutManagerPropertyInfo = Gtk.LayoutManager.LayoutManager
    type AttrLabel LayoutChildLayoutManagerPropertyInfo = "layout-manager"
    type AttrOrigin LayoutChildLayoutManagerPropertyInfo = LayoutChild
    attrGet = getLayoutChildLayoutManager
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.LayoutManager.LayoutManager v
    attrConstruct = constructLayoutChildLayoutManager
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LayoutChild.layoutManager"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-LayoutChild.html#g:attr:layoutManager"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList LayoutChild
type instance O.AttributeList LayoutChild = LayoutChildAttributeList
type LayoutChildAttributeList = ('[ '("childWidget", LayoutChildChildWidgetPropertyInfo), '("layoutManager", LayoutChildLayoutManagerPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
layoutChildChildWidget :: AttrLabelProxy "childWidget"
layoutChildChildWidget = AttrLabelProxy

layoutChildLayoutManager :: AttrLabelProxy "layoutManager"
layoutChildLayoutManager = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList LayoutChild = LayoutChildSignalList
type LayoutChildSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method LayoutChild::get_child_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout_child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LayoutChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLayoutChild`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_layout_child_get_child_widget" gtk_layout_child_get_child_widget :: 
    Ptr LayoutChild ->                      -- layout_child : TInterface (Name {namespace = "Gtk", name = "LayoutChild"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the @GtkWidget@ associated to the given /@layoutChild@/.
layoutChildGetChildWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsLayoutChild a) =>
    a
    -- ^ /@layoutChild@/: a @GtkLayoutChild@
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ a @GtkWidget@
layoutChildGetChildWidget layoutChild = liftIO $ do
    layoutChild' <- unsafeManagedPtrCastPtr layoutChild
    result <- gtk_layout_child_get_child_widget layoutChild'
    checkUnexpectedReturnNULL "layoutChildGetChildWidget" result
    result' <- (newObject Gtk.Widget.Widget) result
    touchManagedPtr layoutChild
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutChildGetChildWidgetMethodInfo
instance (signature ~ (m Gtk.Widget.Widget), MonadIO m, IsLayoutChild a) => O.OverloadedMethod LayoutChildGetChildWidgetMethodInfo a signature where
    overloadedMethod = layoutChildGetChildWidget

instance O.OverloadedMethodInfo LayoutChildGetChildWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LayoutChild.layoutChildGetChildWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-LayoutChild.html#v:layoutChildGetChildWidget"
        })


#endif

-- method LayoutChild::get_layout_manager
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "layout_child"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "LayoutChild" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkLayoutChild`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "LayoutManager" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_layout_child_get_layout_manager" gtk_layout_child_get_layout_manager :: 
    Ptr LayoutChild ->                      -- layout_child : TInterface (Name {namespace = "Gtk", name = "LayoutChild"})
    IO (Ptr Gtk.LayoutManager.LayoutManager)

-- | Retrieves the @GtkLayoutManager@ instance that created the
-- given /@layoutChild@/.
layoutChildGetLayoutManager ::
    (B.CallStack.HasCallStack, MonadIO m, IsLayoutChild a) =>
    a
    -- ^ /@layoutChild@/: a @GtkLayoutChild@
    -> m Gtk.LayoutManager.LayoutManager
    -- ^ __Returns:__ a @GtkLayoutManager@
layoutChildGetLayoutManager layoutChild = liftIO $ do
    layoutChild' <- unsafeManagedPtrCastPtr layoutChild
    result <- gtk_layout_child_get_layout_manager layoutChild'
    checkUnexpectedReturnNULL "layoutChildGetLayoutManager" result
    result' <- (newObject Gtk.LayoutManager.LayoutManager) result
    touchManagedPtr layoutChild
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutChildGetLayoutManagerMethodInfo
instance (signature ~ (m Gtk.LayoutManager.LayoutManager), MonadIO m, IsLayoutChild a) => O.OverloadedMethod LayoutChildGetLayoutManagerMethodInfo a signature where
    overloadedMethod = layoutChildGetLayoutManager

instance O.OverloadedMethodInfo LayoutChildGetLayoutManagerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.LayoutChild.layoutChildGetLayoutManager",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-LayoutChild.html#v:layoutChildGetLayoutManager"
        })


#endif


