//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/overload/v3/overload.proto

package overloadv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ResourceMonitor with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ResourceMonitor) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ResourceMonitor with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ResourceMonitorMultiError, or nil if none found.
func (m *ResourceMonitor) ValidateAll() error {
	return m.validate(true)
}

func (m *ResourceMonitor) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := ResourceMonitorValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *ResourceMonitor_TypedConfig:
		if v == nil {
			err := ResourceMonitorValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ResourceMonitorValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ResourceMonitorValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ResourceMonitorValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ResourceMonitorMultiError(errors)
	}

	return nil
}

// ResourceMonitorMultiError is an error wrapping multiple validation errors
// returned by ResourceMonitor.ValidateAll() if the designated constraints
// aren't met.
type ResourceMonitorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ResourceMonitorMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ResourceMonitorMultiError) AllErrors() []error { return m }

// ResourceMonitorValidationError is the validation error returned by
// ResourceMonitor.Validate if the designated constraints aren't met.
type ResourceMonitorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResourceMonitorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResourceMonitorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResourceMonitorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResourceMonitorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResourceMonitorValidationError) ErrorName() string { return "ResourceMonitorValidationError" }

// Error satisfies the builtin error interface
func (e ResourceMonitorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResourceMonitor.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResourceMonitorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResourceMonitorValidationError{}

// Validate checks the field values on ThresholdTrigger with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ThresholdTrigger) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ThresholdTrigger with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ThresholdTriggerMultiError, or nil if none found.
func (m *ThresholdTrigger) ValidateAll() error {
	return m.validate(true)
}

func (m *ThresholdTrigger) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if val := m.GetValue(); val < 0 || val > 1 {
		err := ThresholdTriggerValidationError{
			field:  "Value",
			reason: "value must be inside range [0, 1]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ThresholdTriggerMultiError(errors)
	}

	return nil
}

// ThresholdTriggerMultiError is an error wrapping multiple validation errors
// returned by ThresholdTrigger.ValidateAll() if the designated constraints
// aren't met.
type ThresholdTriggerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ThresholdTriggerMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ThresholdTriggerMultiError) AllErrors() []error { return m }

// ThresholdTriggerValidationError is the validation error returned by
// ThresholdTrigger.Validate if the designated constraints aren't met.
type ThresholdTriggerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ThresholdTriggerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ThresholdTriggerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ThresholdTriggerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ThresholdTriggerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ThresholdTriggerValidationError) ErrorName() string { return "ThresholdTriggerValidationError" }

// Error satisfies the builtin error interface
func (e ThresholdTriggerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sThresholdTrigger.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ThresholdTriggerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ThresholdTriggerValidationError{}

// Validate checks the field values on ScaledTrigger with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ScaledTrigger) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ScaledTrigger with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ScaledTriggerMultiError, or
// nil if none found.
func (m *ScaledTrigger) ValidateAll() error {
	return m.validate(true)
}

func (m *ScaledTrigger) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if val := m.GetScalingThreshold(); val < 0 || val > 1 {
		err := ScaledTriggerValidationError{
			field:  "ScalingThreshold",
			reason: "value must be inside range [0, 1]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if val := m.GetSaturationThreshold(); val < 0 || val > 1 {
		err := ScaledTriggerValidationError{
			field:  "SaturationThreshold",
			reason: "value must be inside range [0, 1]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ScaledTriggerMultiError(errors)
	}

	return nil
}

// ScaledTriggerMultiError is an error wrapping multiple validation errors
// returned by ScaledTrigger.ValidateAll() if the designated constraints
// aren't met.
type ScaledTriggerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScaledTriggerMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScaledTriggerMultiError) AllErrors() []error { return m }

// ScaledTriggerValidationError is the validation error returned by
// ScaledTrigger.Validate if the designated constraints aren't met.
type ScaledTriggerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScaledTriggerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScaledTriggerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScaledTriggerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScaledTriggerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScaledTriggerValidationError) ErrorName() string { return "ScaledTriggerValidationError" }

// Error satisfies the builtin error interface
func (e ScaledTriggerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScaledTrigger.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScaledTriggerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScaledTriggerValidationError{}

// Validate checks the field values on Trigger with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Trigger) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Trigger with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in TriggerMultiError, or nil if none found.
func (m *Trigger) ValidateAll() error {
	return m.validate(true)
}

func (m *Trigger) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := TriggerValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	oneofTriggerOneofPresent := false
	switch v := m.TriggerOneof.(type) {
	case *Trigger_Threshold:
		if v == nil {
			err := TriggerValidationError{
				field:  "TriggerOneof",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTriggerOneofPresent = true

		if all {
			switch v := interface{}(m.GetThreshold()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TriggerValidationError{
						field:  "Threshold",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TriggerValidationError{
						field:  "Threshold",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetThreshold()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TriggerValidationError{
					field:  "Threshold",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Trigger_Scaled:
		if v == nil {
			err := TriggerValidationError{
				field:  "TriggerOneof",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofTriggerOneofPresent = true

		if all {
			switch v := interface{}(m.GetScaled()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TriggerValidationError{
						field:  "Scaled",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TriggerValidationError{
						field:  "Scaled",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetScaled()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TriggerValidationError{
					field:  "Scaled",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofTriggerOneofPresent {
		err := TriggerValidationError{
			field:  "TriggerOneof",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return TriggerMultiError(errors)
	}

	return nil
}

// TriggerMultiError is an error wrapping multiple validation errors returned
// by Trigger.ValidateAll() if the designated constraints aren't met.
type TriggerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TriggerMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TriggerMultiError) AllErrors() []error { return m }

// TriggerValidationError is the validation error returned by Trigger.Validate
// if the designated constraints aren't met.
type TriggerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TriggerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TriggerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TriggerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TriggerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TriggerValidationError) ErrorName() string { return "TriggerValidationError" }

// Error satisfies the builtin error interface
func (e TriggerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTrigger.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TriggerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TriggerValidationError{}

// Validate checks the field values on ScaleTimersOverloadActionConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ScaleTimersOverloadActionConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ScaleTimersOverloadActionConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// ScaleTimersOverloadActionConfigMultiError, or nil if none found.
func (m *ScaleTimersOverloadActionConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *ScaleTimersOverloadActionConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTimerScaleFactors()) < 1 {
		err := ScaleTimersOverloadActionConfigValidationError{
			field:  "TimerScaleFactors",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTimerScaleFactors() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScaleTimersOverloadActionConfigValidationError{
						field:  fmt.Sprintf("TimerScaleFactors[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScaleTimersOverloadActionConfigValidationError{
						field:  fmt.Sprintf("TimerScaleFactors[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScaleTimersOverloadActionConfigValidationError{
					field:  fmt.Sprintf("TimerScaleFactors[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ScaleTimersOverloadActionConfigMultiError(errors)
	}

	return nil
}

// ScaleTimersOverloadActionConfigMultiError is an error wrapping multiple
// validation errors returned by ScaleTimersOverloadActionConfig.ValidateAll()
// if the designated constraints aren't met.
type ScaleTimersOverloadActionConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScaleTimersOverloadActionConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScaleTimersOverloadActionConfigMultiError) AllErrors() []error { return m }

// ScaleTimersOverloadActionConfigValidationError is the validation error
// returned by ScaleTimersOverloadActionConfig.Validate if the designated
// constraints aren't met.
type ScaleTimersOverloadActionConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScaleTimersOverloadActionConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScaleTimersOverloadActionConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScaleTimersOverloadActionConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScaleTimersOverloadActionConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScaleTimersOverloadActionConfigValidationError) ErrorName() string {
	return "ScaleTimersOverloadActionConfigValidationError"
}

// Error satisfies the builtin error interface
func (e ScaleTimersOverloadActionConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScaleTimersOverloadActionConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScaleTimersOverloadActionConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScaleTimersOverloadActionConfigValidationError{}

// Validate checks the field values on OverloadAction with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *OverloadAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on OverloadAction with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in OverloadActionMultiError,
// or nil if none found.
func (m *OverloadAction) ValidateAll() error {
	return m.validate(true)
}

func (m *OverloadAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := OverloadActionValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetTriggers()) < 1 {
		err := OverloadActionValidationError{
			field:  "Triggers",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTriggers() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, OverloadActionValidationError{
						field:  fmt.Sprintf("Triggers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, OverloadActionValidationError{
						field:  fmt.Sprintf("Triggers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OverloadActionValidationError{
					field:  fmt.Sprintf("Triggers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetTypedConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OverloadActionValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OverloadActionValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OverloadActionValidationError{
				field:  "TypedConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return OverloadActionMultiError(errors)
	}

	return nil
}

// OverloadActionMultiError is an error wrapping multiple validation errors
// returned by OverloadAction.ValidateAll() if the designated constraints
// aren't met.
type OverloadActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OverloadActionMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OverloadActionMultiError) AllErrors() []error { return m }

// OverloadActionValidationError is the validation error returned by
// OverloadAction.Validate if the designated constraints aren't met.
type OverloadActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OverloadActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OverloadActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OverloadActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OverloadActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OverloadActionValidationError) ErrorName() string { return "OverloadActionValidationError" }

// Error satisfies the builtin error interface
func (e OverloadActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOverloadAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OverloadActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OverloadActionValidationError{}

// Validate checks the field values on LoadShedPoint with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *LoadShedPoint) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LoadShedPoint with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LoadShedPointMultiError, or
// nil if none found.
func (m *LoadShedPoint) ValidateAll() error {
	return m.validate(true)
}

func (m *LoadShedPoint) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := LoadShedPointValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetTriggers()) < 1 {
		err := LoadShedPointValidationError{
			field:  "Triggers",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTriggers() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LoadShedPointValidationError{
						field:  fmt.Sprintf("Triggers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LoadShedPointValidationError{
						field:  fmt.Sprintf("Triggers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LoadShedPointValidationError{
					field:  fmt.Sprintf("Triggers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return LoadShedPointMultiError(errors)
	}

	return nil
}

// LoadShedPointMultiError is an error wrapping multiple validation errors
// returned by LoadShedPoint.ValidateAll() if the designated constraints
// aren't met.
type LoadShedPointMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LoadShedPointMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LoadShedPointMultiError) AllErrors() []error { return m }

// LoadShedPointValidationError is the validation error returned by
// LoadShedPoint.Validate if the designated constraints aren't met.
type LoadShedPointValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoadShedPointValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoadShedPointValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoadShedPointValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoadShedPointValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoadShedPointValidationError) ErrorName() string { return "LoadShedPointValidationError" }

// Error satisfies the builtin error interface
func (e LoadShedPointValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoadShedPoint.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoadShedPointValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoadShedPointValidationError{}

// Validate checks the field values on BufferFactoryConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *BufferFactoryConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BufferFactoryConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BufferFactoryConfigMultiError, or nil if none found.
func (m *BufferFactoryConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *BufferFactoryConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if val := m.GetMinimumAccountToTrackPowerOfTwo(); val < 10 || val > 56 {
		err := BufferFactoryConfigValidationError{
			field:  "MinimumAccountToTrackPowerOfTwo",
			reason: "value must be inside range [10, 56]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return BufferFactoryConfigMultiError(errors)
	}

	return nil
}

// BufferFactoryConfigMultiError is an error wrapping multiple validation
// errors returned by BufferFactoryConfig.ValidateAll() if the designated
// constraints aren't met.
type BufferFactoryConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BufferFactoryConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BufferFactoryConfigMultiError) AllErrors() []error { return m }

// BufferFactoryConfigValidationError is the validation error returned by
// BufferFactoryConfig.Validate if the designated constraints aren't met.
type BufferFactoryConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BufferFactoryConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BufferFactoryConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BufferFactoryConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BufferFactoryConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BufferFactoryConfigValidationError) ErrorName() string {
	return "BufferFactoryConfigValidationError"
}

// Error satisfies the builtin error interface
func (e BufferFactoryConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBufferFactoryConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BufferFactoryConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BufferFactoryConfigValidationError{}

// Validate checks the field values on OverloadManager with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *OverloadManager) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on OverloadManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// OverloadManagerMultiError, or nil if none found.
func (m *OverloadManager) ValidateAll() error {
	return m.validate(true)
}

func (m *OverloadManager) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetRefreshInterval()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OverloadManagerValidationError{
					field:  "RefreshInterval",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OverloadManagerValidationError{
					field:  "RefreshInterval",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRefreshInterval()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OverloadManagerValidationError{
				field:  "RefreshInterval",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetResourceMonitors()) < 1 {
		err := OverloadManagerValidationError{
			field:  "ResourceMonitors",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetResourceMonitors() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, OverloadManagerValidationError{
						field:  fmt.Sprintf("ResourceMonitors[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, OverloadManagerValidationError{
						field:  fmt.Sprintf("ResourceMonitors[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OverloadManagerValidationError{
					field:  fmt.Sprintf("ResourceMonitors[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetActions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, OverloadManagerValidationError{
						field:  fmt.Sprintf("Actions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, OverloadManagerValidationError{
						field:  fmt.Sprintf("Actions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OverloadManagerValidationError{
					field:  fmt.Sprintf("Actions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetLoadshedPoints() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, OverloadManagerValidationError{
						field:  fmt.Sprintf("LoadshedPoints[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, OverloadManagerValidationError{
						field:  fmt.Sprintf("LoadshedPoints[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OverloadManagerValidationError{
					field:  fmt.Sprintf("LoadshedPoints[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetBufferFactoryConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, OverloadManagerValidationError{
					field:  "BufferFactoryConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, OverloadManagerValidationError{
					field:  "BufferFactoryConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBufferFactoryConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return OverloadManagerValidationError{
				field:  "BufferFactoryConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return OverloadManagerMultiError(errors)
	}

	return nil
}

// OverloadManagerMultiError is an error wrapping multiple validation errors
// returned by OverloadManager.ValidateAll() if the designated constraints
// aren't met.
type OverloadManagerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m OverloadManagerMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m OverloadManagerMultiError) AllErrors() []error { return m }

// OverloadManagerValidationError is the validation error returned by
// OverloadManager.Validate if the designated constraints aren't met.
type OverloadManagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e OverloadManagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e OverloadManagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e OverloadManagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e OverloadManagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e OverloadManagerValidationError) ErrorName() string { return "OverloadManagerValidationError" }

// Error satisfies the builtin error interface
func (e OverloadManagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOverloadManager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = OverloadManagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = OverloadManagerValidationError{}

// Validate checks the field values on
// ScaleTimersOverloadActionConfig_ScaleTimer with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ScaleTimersOverloadActionConfig_ScaleTimer) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// ScaleTimersOverloadActionConfig_ScaleTimer with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// ScaleTimersOverloadActionConfig_ScaleTimerMultiError, or nil if none found.
func (m *ScaleTimersOverloadActionConfig_ScaleTimer) ValidateAll() error {
	return m.validate(true)
}

func (m *ScaleTimersOverloadActionConfig_ScaleTimer) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := _ScaleTimersOverloadActionConfig_ScaleTimer_Timer_NotInLookup[m.GetTimer()]; ok {
		err := ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
			field:  "Timer",
			reason: "value must not be in list [UNSPECIFIED]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := ScaleTimersOverloadActionConfig_TimerType_name[int32(m.GetTimer())]; !ok {
		err := ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
			field:  "Timer",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	oneofOverloadAdjustPresent := false
	switch v := m.OverloadAdjust.(type) {
	case *ScaleTimersOverloadActionConfig_ScaleTimer_MinTimeout:
		if v == nil {
			err := ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
				field:  "OverloadAdjust",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofOverloadAdjustPresent = true

		if all {
			switch v := interface{}(m.GetMinTimeout()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
						field:  "MinTimeout",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
						field:  "MinTimeout",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetMinTimeout()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
					field:  "MinTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ScaleTimersOverloadActionConfig_ScaleTimer_MinScale:
		if v == nil {
			err := ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
				field:  "OverloadAdjust",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofOverloadAdjustPresent = true

		if all {
			switch v := interface{}(m.GetMinScale()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
						field:  "MinScale",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
						field:  "MinScale",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetMinScale()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
					field:  "MinScale",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofOverloadAdjustPresent {
		err := ScaleTimersOverloadActionConfig_ScaleTimerValidationError{
			field:  "OverloadAdjust",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ScaleTimersOverloadActionConfig_ScaleTimerMultiError(errors)
	}

	return nil
}

// ScaleTimersOverloadActionConfig_ScaleTimerMultiError is an error wrapping
// multiple validation errors returned by
// ScaleTimersOverloadActionConfig_ScaleTimer.ValidateAll() if the designated
// constraints aren't met.
type ScaleTimersOverloadActionConfig_ScaleTimerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ScaleTimersOverloadActionConfig_ScaleTimerMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ScaleTimersOverloadActionConfig_ScaleTimerMultiError) AllErrors() []error { return m }

// ScaleTimersOverloadActionConfig_ScaleTimerValidationError is the validation
// error returned by ScaleTimersOverloadActionConfig_ScaleTimer.Validate if
// the designated constraints aren't met.
type ScaleTimersOverloadActionConfig_ScaleTimerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ScaleTimersOverloadActionConfig_ScaleTimerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ScaleTimersOverloadActionConfig_ScaleTimerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ScaleTimersOverloadActionConfig_ScaleTimerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ScaleTimersOverloadActionConfig_ScaleTimerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ScaleTimersOverloadActionConfig_ScaleTimerValidationError) ErrorName() string {
	return "ScaleTimersOverloadActionConfig_ScaleTimerValidationError"
}

// Error satisfies the builtin error interface
func (e ScaleTimersOverloadActionConfig_ScaleTimerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sScaleTimersOverloadActionConfig_ScaleTimer.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ScaleTimersOverloadActionConfig_ScaleTimerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ScaleTimersOverloadActionConfig_ScaleTimerValidationError{}

var _ScaleTimersOverloadActionConfig_ScaleTimer_Timer_NotInLookup = map[ScaleTimersOverloadActionConfig_TimerType]struct{}{
	0: {},
}
