#ifndef ITKFastMarchingBaseSwigInterface_h
#define ITKFastMarchingBaseSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkNodePair.h"
#include "itkLevelSetNode.h"
#include "itkVectorContainer.h"
#include "itkFastMarchingBase.h"

using itkVectorContainerUILSNSC2 = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed char,2 > >;
using itkVectorContainerUILSNSC2_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed char,2 > >::Pointer;
using itkVectorContainerULNPI2SC = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, signed char > >;
using itkVectorContainerULNPI2SC_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, signed char > >::Pointer;
using itkVectorContainerUILSNSS2 = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed short,2 > >;
using itkVectorContainerUILSNSS2_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed short,2 > >::Pointer;
using itkVectorContainerULNPI2SS = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, signed short > >;
using itkVectorContainerULNPI2SS_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, signed short > >::Pointer;
using itkVectorContainerUILSNUC2 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned char,2 > >;
using itkVectorContainerUILSNUC2_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned char,2 > >::Pointer;
using itkVectorContainerULNPI2UC = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, unsigned char > >;
using itkVectorContainerULNPI2UC_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, unsigned char > >::Pointer;
using itkVectorContainerUILSNULL2 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned long long,2 > >;
using itkVectorContainerUILSNULL2_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned long long,2 > >::Pointer;
using itkVectorContainerULNPI2ULL = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, unsigned long long > >;
using itkVectorContainerULNPI2ULL_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, unsigned long long > >::Pointer;
using itkVectorContainerUILSNUS2 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned short,2 > >;
using itkVectorContainerUILSNUS2_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned short,2 > >::Pointer;
using itkVectorContainerULNPI2US = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, unsigned short > >;
using itkVectorContainerULNPI2US_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, unsigned short > >::Pointer;
using itkVectorContainerUILSNF2 = itk::VectorContainer< unsigned int,itk::LevelSetNode< float,2 > >;
using itkVectorContainerUILSNF2_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< float,2 > >::Pointer;
using itkVectorContainerULNPI2F = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, float > >;
using itkVectorContainerULNPI2F_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, float > >::Pointer;
using itkVectorContainerUILSND2 = itk::VectorContainer< unsigned int,itk::LevelSetNode< double,2 > >;
using itkVectorContainerUILSND2_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< double,2 > >::Pointer;
using itkVectorContainerULNPI2D = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, double > >;
using itkVectorContainerULNPI2D_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<2>, double > >::Pointer;
using itkVectorContainerUILSNSC3 = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed char,3 > >;
using itkVectorContainerUILSNSC3_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed char,3 > >::Pointer;
using itkVectorContainerULNPI3SC = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, signed char > >;
using itkVectorContainerULNPI3SC_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, signed char > >::Pointer;
using itkVectorContainerUILSNSS3 = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed short,3 > >;
using itkVectorContainerUILSNSS3_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed short,3 > >::Pointer;
using itkVectorContainerULNPI3SS = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, signed short > >;
using itkVectorContainerULNPI3SS_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, signed short > >::Pointer;
using itkVectorContainerUILSNUC3 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned char,3 > >;
using itkVectorContainerUILSNUC3_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned char,3 > >::Pointer;
using itkVectorContainerULNPI3UC = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, unsigned char > >;
using itkVectorContainerULNPI3UC_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, unsigned char > >::Pointer;
using itkVectorContainerUILSNULL3 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned long long,3 > >;
using itkVectorContainerUILSNULL3_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned long long,3 > >::Pointer;
using itkVectorContainerULNPI3ULL = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, unsigned long long > >;
using itkVectorContainerULNPI3ULL_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, unsigned long long > >::Pointer;
using itkVectorContainerUILSNUS3 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned short,3 > >;
using itkVectorContainerUILSNUS3_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned short,3 > >::Pointer;
using itkVectorContainerULNPI3US = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, unsigned short > >;
using itkVectorContainerULNPI3US_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, unsigned short > >::Pointer;
using itkVectorContainerUILSNF3 = itk::VectorContainer< unsigned int,itk::LevelSetNode< float,3 > >;
using itkVectorContainerUILSNF3_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< float,3 > >::Pointer;
using itkVectorContainerULNPI3F = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, float > >;
using itkVectorContainerULNPI3F_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, float > >::Pointer;
using itkVectorContainerUILSND3 = itk::VectorContainer< unsigned int,itk::LevelSetNode< double,3 > >;
using itkVectorContainerUILSND3_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< double,3 > >::Pointer;
using itkVectorContainerULNPI3D = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, double > >;
using itkVectorContainerULNPI3D_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<3>, double > >::Pointer;
using itkVectorContainerUILSNSC4 = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed char,4 > >;
using itkVectorContainerUILSNSC4_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed char,4 > >::Pointer;
using itkVectorContainerULNPI4SC = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, signed char > >;
using itkVectorContainerULNPI4SC_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, signed char > >::Pointer;
using itkVectorContainerUILSNSS4 = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed short,4 > >;
using itkVectorContainerUILSNSS4_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< signed short,4 > >::Pointer;
using itkVectorContainerULNPI4SS = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, signed short > >;
using itkVectorContainerULNPI4SS_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, signed short > >::Pointer;
using itkVectorContainerUILSNUC4 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned char,4 > >;
using itkVectorContainerUILSNUC4_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned char,4 > >::Pointer;
using itkVectorContainerULNPI4UC = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, unsigned char > >;
using itkVectorContainerULNPI4UC_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, unsigned char > >::Pointer;
using itkVectorContainerUILSNULL4 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned long long,4 > >;
using itkVectorContainerUILSNULL4_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned long long,4 > >::Pointer;
using itkVectorContainerULNPI4ULL = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, unsigned long long > >;
using itkVectorContainerULNPI4ULL_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, unsigned long long > >::Pointer;
using itkVectorContainerUILSNUS4 = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned short,4 > >;
using itkVectorContainerUILSNUS4_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< unsigned short,4 > >::Pointer;
using itkVectorContainerULNPI4US = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, unsigned short > >;
using itkVectorContainerULNPI4US_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, unsigned short > >::Pointer;
using itkVectorContainerUILSNF4 = itk::VectorContainer< unsigned int,itk::LevelSetNode< float,4 > >;
using itkVectorContainerUILSNF4_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< float,4 > >::Pointer;
using itkVectorContainerULNPI4F = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, float > >;
using itkVectorContainerULNPI4F_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, float > >::Pointer;
using itkVectorContainerUILSND4 = itk::VectorContainer< unsigned int,itk::LevelSetNode< double,4 > >;
using itkVectorContainerUILSND4_Pointer = itk::VectorContainer< unsigned int,itk::LevelSetNode< double,4 > >::Pointer;
using itkVectorContainerULNPI4D = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, double > >;
using itkVectorContainerULNPI4D_Pointer = itk::VectorContainer< unsigned long, itk::NodePair< itk::Index<4>, double > >::Pointer;
using itkFastMarchingTraitsEnums = itk::FastMarchingTraitsEnums;
using itkFastMarchingBaseIF2IF2 = itk::FastMarchingBase< itk::Image< float,2 >, itk::Image< float,2 > >;
using itkFastMarchingBaseIF2IF2_Pointer = itk::FastMarchingBase< itk::Image< float,2 >, itk::Image< float,2 > >::Pointer;
using itkFastMarchingBaseIF3IF3 = itk::FastMarchingBase< itk::Image< float,3 >, itk::Image< float,3 > >;
using itkFastMarchingBaseIF3IF3_Pointer = itk::FastMarchingBase< itk::Image< float,3 >, itk::Image< float,3 > >::Pointer;
using itkFastMarchingBaseIF4IF4 = itk::FastMarchingBase< itk::Image< float,4 >, itk::Image< float,4 > >;
using itkFastMarchingBaseIF4IF4_Pointer = itk::FastMarchingBase< itk::Image< float,4 >, itk::Image< float,4 > >::Pointer;
using itkFastMarchingBaseID2ID2 = itk::FastMarchingBase< itk::Image< double,2 >, itk::Image< double,2 > >;
using itkFastMarchingBaseID2ID2_Pointer = itk::FastMarchingBase< itk::Image< double,2 >, itk::Image< double,2 > >::Pointer;
using itkFastMarchingBaseID3ID3 = itk::FastMarchingBase< itk::Image< double,3 >, itk::Image< double,3 > >;
using itkFastMarchingBaseID3ID3_Pointer = itk::FastMarchingBase< itk::Image< double,3 >, itk::Image< double,3 > >::Pointer;
using itkFastMarchingBaseID4ID4 = itk::FastMarchingBase< itk::Image< double,4 >, itk::Image< double,4 > >;
using itkFastMarchingBaseID4ID4_Pointer = itk::FastMarchingBase< itk::Image< double,4 >, itk::Image< double,4 > >::Pointer;


#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "ITKFastMarchingBaseSwigInterface.h"
#include "itkImageToImageFilterASwigInterface.h"
#include "itkNodePairSwigInterface.h"
#include "itkIndexSwigInterface.h"
#include "itkLevelSetNodeSwigInterface.h"
#include "itkFastMarchingStoppingCriterionBaseSwigInterface.h"
#endif
