#ifndef itkMeshBaseSwigInterface_h
#define itkMeshBaseSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkDefaultStaticMeshTraits.h"
#include "itkDefaultDynamicMeshTraits.h"
#include "itkMesh.h"
#include "itkCellInterface.h"
#include "itkMapContainer.h"
#include "itkVectorContainer.h"
#include "itkCellInterfaceVisitor.h"

using itkMeshSC2 = itk::Mesh< signed char,2 >;
using itkMeshSC2_Pointer = itk::Mesh< signed char,2 >::Pointer;
using itkMeshSS2 = itk::Mesh< signed short,2 >;
using itkMeshSS2_Pointer = itk::Mesh< signed short,2 >::Pointer;
using itkMeshUC2 = itk::Mesh< unsigned char,2 >;
using itkMeshUC2_Pointer = itk::Mesh< unsigned char,2 >::Pointer;
using itkMeshULL2 = itk::Mesh< unsigned long long,2 >;
using itkMeshULL2_Pointer = itk::Mesh< unsigned long long,2 >::Pointer;
using itkMeshUS2 = itk::Mesh< unsigned short,2 >;
using itkMeshUS2_Pointer = itk::Mesh< unsigned short,2 >::Pointer;
using itkMeshF2 = itk::Mesh< float,2 >;
using itkMeshF2_Pointer = itk::Mesh< float,2 >::Pointer;
using itkMeshD2 = itk::Mesh< double,2 >;
using itkMeshD2_Pointer = itk::Mesh< double,2 >::Pointer;
using itkMeshAD2 = itk::Mesh< itk::Array<double>,2 >;
using itkMeshAD2_Pointer = itk::Mesh< itk::Array<double>,2 >::Pointer;
using itkMeshSC3 = itk::Mesh< signed char,3 >;
using itkMeshSC3_Pointer = itk::Mesh< signed char,3 >::Pointer;
using itkMeshSS3 = itk::Mesh< signed short,3 >;
using itkMeshSS3_Pointer = itk::Mesh< signed short,3 >::Pointer;
using itkMeshUC3 = itk::Mesh< unsigned char,3 >;
using itkMeshUC3_Pointer = itk::Mesh< unsigned char,3 >::Pointer;
using itkMeshULL3 = itk::Mesh< unsigned long long,3 >;
using itkMeshULL3_Pointer = itk::Mesh< unsigned long long,3 >::Pointer;
using itkMeshUS3 = itk::Mesh< unsigned short,3 >;
using itkMeshUS3_Pointer = itk::Mesh< unsigned short,3 >::Pointer;
using itkMeshF3 = itk::Mesh< float,3 >;
using itkMeshF3_Pointer = itk::Mesh< float,3 >::Pointer;
using itkMeshD3 = itk::Mesh< double,3 >;
using itkMeshD3_Pointer = itk::Mesh< double,3 >::Pointer;
using itkMeshAD3 = itk::Mesh< itk::Array<double>,3 >;
using itkMeshAD3_Pointer = itk::Mesh< itk::Array<double>,3 >::Pointer;
using itkMeshSC4 = itk::Mesh< signed char,4 >;
using itkMeshSC4_Pointer = itk::Mesh< signed char,4 >::Pointer;
using itkMeshSS4 = itk::Mesh< signed short,4 >;
using itkMeshSS4_Pointer = itk::Mesh< signed short,4 >::Pointer;
using itkMeshUC4 = itk::Mesh< unsigned char,4 >;
using itkMeshUC4_Pointer = itk::Mesh< unsigned char,4 >::Pointer;
using itkMeshULL4 = itk::Mesh< unsigned long long,4 >;
using itkMeshULL4_Pointer = itk::Mesh< unsigned long long,4 >::Pointer;
using itkMeshUS4 = itk::Mesh< unsigned short,4 >;
using itkMeshUS4_Pointer = itk::Mesh< unsigned short,4 >::Pointer;
using itkMeshF4 = itk::Mesh< float,4 >;
using itkMeshF4_Pointer = itk::Mesh< float,4 >::Pointer;
using itkMeshD4 = itk::Mesh< double,4 >;
using itkMeshD4_Pointer = itk::Mesh< double,4 >::Pointer;
using itkMeshAD4 = itk::Mesh< itk::Array<double>,4 >;
using itkMeshAD4_Pointer = itk::Mesh< itk::Array<double>,4 >::Pointer;
using itkCellTraitsInfo2FFULULULPF2MCULPF2 = itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >;
using itkCellTraitsInfo2FFULULULPF2VCULPF2 = itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >;
using itkCellTraitsInfo3FFULULULPF3MCULPF3 = itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >;
using itkCellTraitsInfo3FFULULULPF3VCULPF3 = itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >;
using itkCellTraitsInfo4FFULULULPF4MCULPF4 = itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >;
using itkCellTraitsInfo4FFULULULPF4VCULPF4 = itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >;
using itkCellInterfaceSCCTI2FFULULULPF2MCULPF2 = itk::CellInterface< signed char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceSCCTI2FFULULULPF2MCULPF2_AutoPointer = itk::CellInterface< signed char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSCCTI2FFULULULPF2VCULPF2 = itk::CellInterface< signed char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceSCCTI2FFULULULPF2VCULPF2_AutoPointer = itk::CellInterface< signed char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSSCTI2FFULULULPF2MCULPF2 = itk::CellInterface< signed short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceSSCTI2FFULULULPF2MCULPF2_AutoPointer = itk::CellInterface< signed short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSSCTI2FFULULULPF2VCULPF2 = itk::CellInterface< signed short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceSSCTI2FFULULULPF2VCULPF2_AutoPointer = itk::CellInterface< signed short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUCCTI2FFULULULPF2MCULPF2 = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceUCCTI2FFULULULPF2MCULPF2_AutoPointer = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUCCTI2FFULULULPF2VCULPF2 = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceUCCTI2FFULULULPF2VCULPF2_AutoPointer = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceULLCTI2FFULULULPF2MCULPF2 = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceULLCTI2FFULULULPF2MCULPF2_AutoPointer = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceULLCTI2FFULULULPF2VCULPF2 = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceULLCTI2FFULULULPF2VCULPF2_AutoPointer = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUSCTI2FFULULULPF2MCULPF2 = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceUSCTI2FFULULULPF2MCULPF2_AutoPointer = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUSCTI2FFULULULPF2VCULPF2 = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceUSCTI2FFULULULPF2VCULPF2_AutoPointer = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceFCTI2FFULULULPF2MCULPF2 = itk::CellInterface< float,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceFCTI2FFULULULPF2MCULPF2_AutoPointer = itk::CellInterface< float,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceFCTI2FFULULULPF2VCULPF2 = itk::CellInterface< float,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceFCTI2FFULULULPF2VCULPF2_AutoPointer = itk::CellInterface< float,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceDCTI2FFULULULPF2MCULPF2 = itk::CellInterface< double,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceDCTI2FFULULULPF2MCULPF2_AutoPointer = itk::CellInterface< double,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceDCTI2FFULULULPF2VCULPF2 = itk::CellInterface< double,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceDCTI2FFULULULPF2VCULPF2_AutoPointer = itk::CellInterface< double,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceADCTI2FFULULULPF2VCULPF2 = itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >;
using itkCellInterfaceADCTI2FFULULULPF2VCULPF2_AutoPointer = itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSCCTI3FFULULULPF3MCULPF3 = itk::CellInterface< signed char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceSCCTI3FFULULULPF3MCULPF3_AutoPointer = itk::CellInterface< signed char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSCCTI3FFULULULPF3VCULPF3 = itk::CellInterface< signed char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceSCCTI3FFULULULPF3VCULPF3_AutoPointer = itk::CellInterface< signed char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSSCTI3FFULULULPF3MCULPF3 = itk::CellInterface< signed short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceSSCTI3FFULULULPF3MCULPF3_AutoPointer = itk::CellInterface< signed short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSSCTI3FFULULULPF3VCULPF3 = itk::CellInterface< signed short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceSSCTI3FFULULULPF3VCULPF3_AutoPointer = itk::CellInterface< signed short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUCCTI3FFULULULPF3MCULPF3 = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceUCCTI3FFULULULPF3MCULPF3_AutoPointer = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUCCTI3FFULULULPF3VCULPF3 = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceUCCTI3FFULULULPF3VCULPF3_AutoPointer = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceULLCTI3FFULULULPF3MCULPF3 = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceULLCTI3FFULULULPF3MCULPF3_AutoPointer = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceULLCTI3FFULULULPF3VCULPF3 = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceULLCTI3FFULULULPF3VCULPF3_AutoPointer = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUSCTI3FFULULULPF3MCULPF3 = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceUSCTI3FFULULULPF3MCULPF3_AutoPointer = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUSCTI3FFULULULPF3VCULPF3 = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceUSCTI3FFULULULPF3VCULPF3_AutoPointer = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceFCTI3FFULULULPF3MCULPF3 = itk::CellInterface< float,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceFCTI3FFULULULPF3MCULPF3_AutoPointer = itk::CellInterface< float,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceFCTI3FFULULULPF3VCULPF3 = itk::CellInterface< float,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceFCTI3FFULULULPF3VCULPF3_AutoPointer = itk::CellInterface< float,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceDCTI3FFULULULPF3MCULPF3 = itk::CellInterface< double,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceDCTI3FFULULULPF3MCULPF3_AutoPointer = itk::CellInterface< double,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceDCTI3FFULULULPF3VCULPF3 = itk::CellInterface< double,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceDCTI3FFULULULPF3VCULPF3_AutoPointer = itk::CellInterface< double,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceADCTI3FFULULULPF3VCULPF3 = itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >;
using itkCellInterfaceADCTI3FFULULULPF3VCULPF3_AutoPointer = itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSCCTI4FFULULULPF4MCULPF4 = itk::CellInterface< signed char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceSCCTI4FFULULULPF4MCULPF4_AutoPointer = itk::CellInterface< signed char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSCCTI4FFULULULPF4VCULPF4 = itk::CellInterface< signed char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceSCCTI4FFULULULPF4VCULPF4_AutoPointer = itk::CellInterface< signed char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSSCTI4FFULULULPF4MCULPF4 = itk::CellInterface< signed short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceSSCTI4FFULULULPF4MCULPF4_AutoPointer = itk::CellInterface< signed short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceSSCTI4FFULULULPF4VCULPF4 = itk::CellInterface< signed short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceSSCTI4FFULULULPF4VCULPF4_AutoPointer = itk::CellInterface< signed short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUCCTI4FFULULULPF4MCULPF4 = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceUCCTI4FFULULULPF4MCULPF4_AutoPointer = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUCCTI4FFULULULPF4VCULPF4 = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceUCCTI4FFULULULPF4VCULPF4_AutoPointer = itk::CellInterface< unsigned char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceULLCTI4FFULULULPF4MCULPF4 = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceULLCTI4FFULULULPF4MCULPF4_AutoPointer = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceULLCTI4FFULULULPF4VCULPF4 = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceULLCTI4FFULULULPF4VCULPF4_AutoPointer = itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUSCTI4FFULULULPF4MCULPF4 = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceUSCTI4FFULULULPF4MCULPF4_AutoPointer = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceUSCTI4FFULULULPF4VCULPF4 = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceUSCTI4FFULULULPF4VCULPF4_AutoPointer = itk::CellInterface< unsigned short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceFCTI4FFULULULPF4MCULPF4 = itk::CellInterface< float,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceFCTI4FFULULULPF4MCULPF4_AutoPointer = itk::CellInterface< float,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceFCTI4FFULULULPF4VCULPF4 = itk::CellInterface< float,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceFCTI4FFULULULPF4VCULPF4_AutoPointer = itk::CellInterface< float,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceDCTI4FFULULULPF4MCULPF4 = itk::CellInterface< double,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceDCTI4FFULULULPF4MCULPF4_AutoPointer = itk::CellInterface< double,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceDCTI4FFULULULPF4VCULPF4 = itk::CellInterface< double,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceDCTI4FFULULULPF4VCULPF4_AutoPointer = itk::CellInterface< double,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkCellInterfaceADCTI4FFULULULPF4VCULPF4 = itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >;
using itkCellInterfaceADCTI4FFULULULPF4VCULPF4_AutoPointer = itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > >::SelfAutoPointer;
using itkMapContainerULCISCCTI2FFULULULPF2MCULPF2 = itk::MapContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCISCCTI2FFULULULPF2MCULPF2_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCISSCTI2FFULULULPF2MCULPF2 = itk::MapContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCISSCTI2FFULULULPF2MCULPF2_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIUCCTI2FFULULULPF2MCULPF2 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIUCCTI2FFULULULPF2MCULPF2_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIULLCTI2FFULULULPF2MCULPF2 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIULLCTI2FFULULULPF2MCULPF2_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIUSCTI2FFULULULPF2MCULPF2 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIUSCTI2FFULULULPF2MCULPF2_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIFCTI2FFULULULPF2MCULPF2 = itk::MapContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIFCTI2FFULULULPF2MCULPF2_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIDCTI2FFULULULPF2MCULPF2 = itk::MapContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIDCTI2FFULULULPF2MCULPF2_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCISCCTI3FFULULULPF3MCULPF3 = itk::MapContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCISCCTI3FFULULULPF3MCULPF3_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCISSCTI3FFULULULPF3MCULPF3 = itk::MapContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCISSCTI3FFULULULPF3MCULPF3_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIUCCTI3FFULULULPF3MCULPF3 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIUCCTI3FFULULULPF3MCULPF3_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIULLCTI3FFULULULPF3MCULPF3 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIULLCTI3FFULULULPF3MCULPF3_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIUSCTI3FFULULULPF3MCULPF3 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIUSCTI3FFULULULPF3MCULPF3_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIFCTI3FFULULULPF3MCULPF3 = itk::MapContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIFCTI3FFULULULPF3MCULPF3_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIDCTI3FFULULULPF3MCULPF3 = itk::MapContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIDCTI3FFULULULPF3MCULPF3_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCISCCTI4FFULULULPF4MCULPF4 = itk::MapContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCISCCTI4FFULULULPF4MCULPF4_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCISSCTI4FFULULULPF4MCULPF4 = itk::MapContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCISSCTI4FFULULULPF4MCULPF4_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIUCCTI4FFULULULPF4MCULPF4 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIUCCTI4FFULULULPF4MCULPF4_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIULLCTI4FFULULULPF4MCULPF4 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIULLCTI4FFULULULPF4MCULPF4_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIUSCTI4FFULULULPF4MCULPF4 = itk::MapContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIUSCTI4FFULULULPF4MCULPF4_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIFCTI4FFULULULPF4MCULPF4 = itk::MapContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIFCTI4FFULULULPF4MCULPF4_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkMapContainerULCIDCTI4FFULULULPF4MCULPF4 = itk::MapContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkMapContainerULCIDCTI4FFULULULPF4MCULPF4_Pointer = itk::MapContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCISCCTI2FFULULULPF2VCULPF2 = itk::VectorContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCISCCTI2FFULULULPF2VCULPF2_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCISSCTI2FFULULULPF2VCULPF2 = itk::VectorContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCISSCTI2FFULULULPF2VCULPF2_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIUCCTI2FFULULULPF2VCULPF2 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIUCCTI2FFULULULPF2VCULPF2_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIULLCTI2FFULULULPF2VCULPF2 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIULLCTI2FFULULULPF2VCULPF2_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIUSCTI2FFULULULPF2VCULPF2 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIUSCTI2FFULULULPF2VCULPF2_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIFCTI2FFULULULPF2VCULPF2 = itk::VectorContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIFCTI2FFULULULPF2VCULPF2_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIDCTI2FFULULULPF2VCULPF2 = itk::VectorContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIDCTI2FFULULULPF2VCULPF2_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIADCTI2FFULULULPF2VCULPF2 = itk::VectorContainer< unsigned long, itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIADCTI2FFULULULPF2VCULPF2_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::VectorContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCISCCTI3FFULULULPF3VCULPF3 = itk::VectorContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCISCCTI3FFULULULPF3VCULPF3_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCISSCTI3FFULULULPF3VCULPF3 = itk::VectorContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCISSCTI3FFULULULPF3VCULPF3_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIUCCTI3FFULULULPF3VCULPF3 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIUCCTI3FFULULULPF3VCULPF3_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIULLCTI3FFULULULPF3VCULPF3 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIULLCTI3FFULULULPF3VCULPF3_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIUSCTI3FFULULULPF3VCULPF3 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIUSCTI3FFULULULPF3VCULPF3_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIFCTI3FFULULULPF3VCULPF3 = itk::VectorContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIFCTI3FFULULULPF3VCULPF3_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIDCTI3FFULULULPF3VCULPF3 = itk::VectorContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIDCTI3FFULULULPF3VCULPF3_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIADCTI3FFULULULPF3VCULPF3 = itk::VectorContainer< unsigned long, itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIADCTI3FFULULULPF3VCULPF3_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::VectorContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCISCCTI4FFULULULPF4VCULPF4 = itk::VectorContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCISCCTI4FFULULULPF4VCULPF4_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< signed char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCISSCTI4FFULULULPF4VCULPF4 = itk::VectorContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCISSCTI4FFULULULPF4VCULPF4_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< signed short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIUCCTI4FFULULULPF4VCULPF4 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIUCCTI4FFULULULPF4VCULPF4_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned char,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIULLCTI4FFULULULPF4VCULPF4 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIULLCTI4FFULULULPF4VCULPF4_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned long long,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIUSCTI4FFULULULPF4VCULPF4 = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIUSCTI4FFULULULPF4VCULPF4_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< unsigned short,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIFCTI4FFULULULPF4VCULPF4 = itk::VectorContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIFCTI4FFULULULPF4VCULPF4_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< float,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIDCTI4FFULULULPF4VCULPF4 = itk::VectorContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIDCTI4FFULULULPF4VCULPF4_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< double,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkVectorContainerULCIADCTI4FFULULULPF4VCULPF4 = itk::VectorContainer< unsigned long, itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >;
using itkVectorContainerULCIADCTI4FFULULULPF4VCULPF4_Pointer = itk::VectorContainer< unsigned long, itk::CellInterface< itk::Array< double >,itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::VectorContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > > > * >::Pointer;
using itkCellInterfaceVisitorSCCTI2FFULULULPF2MCULPF2 = itk::CellInterfaceVisitor< signed char, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorSCCTI2FFULULULPF2MCULPF2_Pointer = itk::CellInterfaceVisitor< signed char, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorSSCTI2FFULULULPF2MCULPF2 = itk::CellInterfaceVisitor< signed short, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorSSCTI2FFULULULPF2MCULPF2_Pointer = itk::CellInterfaceVisitor< signed short, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorUCCTI2FFULULULPF2MCULPF2 = itk::CellInterfaceVisitor< unsigned char, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorUCCTI2FFULULULPF2MCULPF2_Pointer = itk::CellInterfaceVisitor< unsigned char, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorULLCTI2FFULULULPF2MCULPF2 = itk::CellInterfaceVisitor< unsigned long long, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorULLCTI2FFULULULPF2MCULPF2_Pointer = itk::CellInterfaceVisitor< unsigned long long, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorUSCTI2FFULULULPF2MCULPF2 = itk::CellInterfaceVisitor< unsigned short, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorUSCTI2FFULULULPF2MCULPF2_Pointer = itk::CellInterfaceVisitor< unsigned short, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorFCTI2FFULULULPF2MCULPF2 = itk::CellInterfaceVisitor< float, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorFCTI2FFULULULPF2MCULPF2_Pointer = itk::CellInterfaceVisitor< float, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorDCTI2FFULULULPF2MCULPF2 = itk::CellInterfaceVisitor< double, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorDCTI2FFULULULPF2MCULPF2_Pointer = itk::CellInterfaceVisitor< double, itk::CellTraitsInfo< 2,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,2 >,itk::MapContainer< unsigned long,itk::Point< float,2 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorSCCTI3FFULULULPF3MCULPF3 = itk::CellInterfaceVisitor< signed char, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorSCCTI3FFULULULPF3MCULPF3_Pointer = itk::CellInterfaceVisitor< signed char, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorSSCTI3FFULULULPF3MCULPF3 = itk::CellInterfaceVisitor< signed short, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorSSCTI3FFULULULPF3MCULPF3_Pointer = itk::CellInterfaceVisitor< signed short, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorUCCTI3FFULULULPF3MCULPF3 = itk::CellInterfaceVisitor< unsigned char, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorUCCTI3FFULULULPF3MCULPF3_Pointer = itk::CellInterfaceVisitor< unsigned char, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorULLCTI3FFULULULPF3MCULPF3 = itk::CellInterfaceVisitor< unsigned long long, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorULLCTI3FFULULULPF3MCULPF3_Pointer = itk::CellInterfaceVisitor< unsigned long long, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorUSCTI3FFULULULPF3MCULPF3 = itk::CellInterfaceVisitor< unsigned short, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorUSCTI3FFULULULPF3MCULPF3_Pointer = itk::CellInterfaceVisitor< unsigned short, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorFCTI3FFULULULPF3MCULPF3 = itk::CellInterfaceVisitor< float, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorFCTI3FFULULULPF3MCULPF3_Pointer = itk::CellInterfaceVisitor< float, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorDCTI3FFULULULPF3MCULPF3 = itk::CellInterfaceVisitor< double, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorDCTI3FFULULULPF3MCULPF3_Pointer = itk::CellInterfaceVisitor< double, itk::CellTraitsInfo< 3,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,3 >,itk::MapContainer< unsigned long,itk::Point< float,3 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorSCCTI4FFULULULPF4MCULPF4 = itk::CellInterfaceVisitor< signed char, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorSCCTI4FFULULULPF4MCULPF4_Pointer = itk::CellInterfaceVisitor< signed char, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorSSCTI4FFULULULPF4MCULPF4 = itk::CellInterfaceVisitor< signed short, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorSSCTI4FFULULULPF4MCULPF4_Pointer = itk::CellInterfaceVisitor< signed short, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorUCCTI4FFULULULPF4MCULPF4 = itk::CellInterfaceVisitor< unsigned char, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorUCCTI4FFULULULPF4MCULPF4_Pointer = itk::CellInterfaceVisitor< unsigned char, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorULLCTI4FFULULULPF4MCULPF4 = itk::CellInterfaceVisitor< unsigned long long, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorULLCTI4FFULULULPF4MCULPF4_Pointer = itk::CellInterfaceVisitor< unsigned long long, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorUSCTI4FFULULULPF4MCULPF4 = itk::CellInterfaceVisitor< unsigned short, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorUSCTI4FFULULULPF4MCULPF4_Pointer = itk::CellInterfaceVisitor< unsigned short, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorFCTI4FFULULULPF4MCULPF4 = itk::CellInterfaceVisitor< float, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorFCTI4FFULULULPF4MCULPF4_Pointer = itk::CellInterfaceVisitor< float, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >::Pointer;
using itkCellInterfaceVisitorDCTI4FFULULULPF4MCULPF4 = itk::CellInterfaceVisitor< double, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >;
using itkCellInterfaceVisitorDCTI4FFULULULPF4MCULPF4_Pointer = itk::CellInterfaceVisitor< double, itk::CellTraitsInfo< 4,float,float,unsigned long,unsigned long,unsigned long,itk::Point< float,4 >,itk::MapContainer< unsigned long,itk::Point< float,4 > >, std::set< unsigned long > >  >::Pointer;


#include "ITKCommonBaseSwigInterface.h"
#include "itkArraySwigInterface.h"
#include "itkMeshBaseSwigInterface.h"
#include "itkVectorContainerSwigInterface.h"
#include "itkMapContainerSwigInterface.h"
#include "itkPointSetSwigInterface.h"
#include "itkBoundingBoxSwigInterface.h"
#endif
