
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kaboutlicense_wrapper.h"

// Argument includes
#include <QString>
#include <kaboutdata.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAboutLicense_Type = nullptr;
static PyTypeObject *Sbk_KAboutLicense_TypeF(void)
{
    return _Sbk_KAboutLicense_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAboutLicense_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAboutLicense >()))
        return -1;

    ::KAboutLicense *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KAboutLicense", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KAboutLicense::KAboutLicense()
    // 1: KAboutLicense::KAboutLicense(KAboutLicense)
    if (numArgs == 0) {
        overloadId = 0; // KAboutLicense()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KAboutLicense(KAboutLicense)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KAboutLicense()
        {

            // KAboutLicense()
            cptr = new ::KAboutLicense();
            break;
        }
        case 1: // KAboutLicense(const KAboutLicense &other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KAboutLicense cppArg0_local;
            ::KAboutLicense *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutLicense(KAboutLicense)
                cptr = new ::KAboutLicense(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KAboutLicense >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KAboutLicenseFunc_byKeyword(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KAboutLicense::byKeyword(QString)->KAboutLicense
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // byKeyword(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "byKeyword", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // byKeyword(QString)
            KAboutLicense cppResult = ::KAboutLicense::byKeyword(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutLicenseFunc_key(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutLicense *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // key()const
        KAboutLicense::LicenseKey cppResult = const_cast<const ::KAboutLicense *>(cppSelf)->key();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutLicenseFunc_name(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutLicense *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "name", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]);

    if (PyArg_ParseTuple(args, "|O:name", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAboutLicense::name(KAboutLicense::NameFormat=)const->QString
    if (numArgs == 0) {
        overloadId = 0; // name(KAboutLicense::NameFormat)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_NameFormat_IDX])))->converter, (pyArgs[0])))) {
        overloadId = 0; // name(KAboutLicense::NameFormat)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "name", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"formatName", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_NameFormat_IDX])))->converter, (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "name", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]);
            }
        }
        ::KAboutLicense::NameFormat cppArg0(KAboutLicense::NameFormat::ShortName);
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // name(KAboutLicense::NameFormat)const
            QString cppResult = const_cast<const ::KAboutLicense *>(cppSelf)->name(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutLicenseFunc_spdx(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutLicense *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // spdx()const
        QString cppResult = const_cast<const ::KAboutLicense *>(cppSelf)->spdx();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutLicenseFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutLicense *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // text()const
        QString cppResult = const_cast<const ::KAboutLicense *>(cppSelf)->text();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutLicense__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KAboutLicense *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KAboutLicense_PropertyStrings[] = {
    "key:",
    "name:",
    "spdx:",
    "text:",
    nullptr // Sentinel
};

static const char *Sbk_KAboutLicense_EnumFlagInfo[] = {
    "LicenseKey:IntEnum",
    "NameFormat:IntEnum",
    "VersionRestriction:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAboutLicense_methods[] = {
    {"byKeyword", reinterpret_cast<PyCFunction>(Sbk_KAboutLicenseFunc_byKeyword), METH_O|METH_STATIC, nullptr},
    {"key", reinterpret_cast<PyCFunction>(Sbk_KAboutLicenseFunc_key), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KAboutLicenseFunc_name), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"spdx", reinterpret_cast<PyCFunction>(Sbk_KAboutLicenseFunc_spdx), METH_NOARGS, nullptr},
    {"text", reinterpret_cast<PyCFunction>(Sbk_KAboutLicenseFunc_text), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KAboutLicense__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KAboutLicense_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAboutLicense_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAboutLicense_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAboutLicense_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAboutLicense_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAboutLicense_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAboutLicense_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAboutLicense_spec = {
    "1:KCoreAddons.KAboutLicense",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAboutLicense_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KAboutLicense_LicenseKey(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KAboutLicense::LicenseKey>(Shiboken::Enum::getValue(pyIn));
    switch (value) {
    case KAboutLicense::LicenseKey::BSDL:
        Shiboken::Warnings::warnDeprecatedEnumValue("KAboutLicense::LicenseKey", "BSDL");
        break;
    default:
        break;
    }
    *reinterpret_cast<::KAboutLicense::LicenseKey *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KAboutLicense_LicenseKey_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))
        return Enum_PythonToCpp_KAboutLicense_LicenseKey;
    return {};
}

static PyObject *KAboutLicense_LicenseKey_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KAboutLicense::LicenseKey>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KAboutLicense::LicenseKey *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KAboutLicense_NameFormat(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KAboutLicense::NameFormat>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KAboutLicense::NameFormat *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KAboutLicense_NameFormat_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_NameFormat_IDX])))
        return Enum_PythonToCpp_KAboutLicense_NameFormat;
    return {};
}

static PyObject *KAboutLicense_NameFormat_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KAboutLicense::NameFormat>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KAboutLicense::NameFormat *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KAboutLicense_VersionRestriction(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KAboutLicense::VersionRestriction>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KAboutLicense::VersionRestriction *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KAboutLicense_VersionRestriction_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_VersionRestriction_IDX])))
        return Enum_PythonToCpp_KAboutLicense_VersionRestriction;
    return {};
}

static PyObject *KAboutLicense_VersionRestriction_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KAboutLicense::VersionRestriction>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KAboutLicense::VersionRestriction *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAboutLicense_PythonToCpp_KAboutLicense_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAboutLicense_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAboutLicense_PythonToCpp_KAboutLicense_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutLicense_TypeF()))
        return KAboutLicense_PythonToCpp_KAboutLicense_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAboutLicense_PTR_CppToPython_KAboutLicense(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KAboutLicense_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KAboutLicense_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KAboutLicense_COPY_CppToPython_KAboutLicense(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KAboutLicense *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KAboutLicense_TypeF(), new ::KAboutLicense(*source), true, true);
}

// Python to C++ copy conversion.
static void KAboutLicense_PythonToCpp_KAboutLicense_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KAboutLicense *>(cppOut) = *reinterpret_cast< ::KAboutLicense *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KAboutLicense_PythonToCpp_KAboutLicense_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutLicense_TypeF()))
        return KAboutLicense_PythonToCpp_KAboutLicense_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAboutLicense_SignatureStrings[] = {
    "1:KCoreAddons.KAboutLicense(self,*:KeywordOnly=None,name:QString=None,text:QString=None,key:KCoreAddons.KAboutLicense.LicenseKey=None,spdx:QString=None)",
    "0:KCoreAddons.KAboutLicense(self,other:KCoreAddons.KAboutLicense,*:KeywordOnly=None,name:QString=None,text:QString=None,key:KCoreAddons.KAboutLicense.LicenseKey=None,spdx:QString=None)",
    "KCoreAddons.KAboutLicense.byKeyword(keyword:QString)->KCoreAddons.KAboutLicense",
    "KCoreAddons.KAboutLicense.key(self)->KCoreAddons.KAboutLicense.LicenseKey",
    "KCoreAddons.KAboutLicense.name(self,formatName:KCoreAddons.KAboutLicense.NameFormat=KAboutLicense.NameFormat.ShortName)->QString",
    "KCoreAddons.KAboutLicense.spdx(self)->QString",
    "KCoreAddons.KAboutLicense.text(self)->QString",
    "KCoreAddons.KAboutLicense.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t KAboutLicense_SignatureByteSize = 209;
static constexpr uint8_t KAboutLicense_SignatureBytes[209] = {
    0x78, 0xda, 0xc5, 0x91, 0xcd, 0x0a, 0x83, 0x30, 0x10, 0x84, 0xef, 0x3e, 0x89, 0x16, 0x2b, 0xed,
    0x55, 0xb0, 0x20, 0x85, 0x5e, 0x2c, 0x96, 0xe2, 0x03, 0x04, 0x35, 0xdb, 0x2a, 0x6a, 0x56, 0x62,
    0x4a, 0xcd, 0xdb, 0x37, 0xf1, 0x07, 0xea, 0x21, 0xda, 0x5b, 0x4f, 0x4b, 0x36, 0xf3, 0x0d, 0x93,
    0xc9, 0xd1, 0x8f, 0xce, 0xc8, 0x21, 0xa4, 0x14, 0x59, 0xe7, 0x45, 0x61, 0x86, 0x2f, 0x71, 0x2d,
    0x73, 0x60, 0x1d, 0xd8, 0x1d, 0xd4, 0x0f, 0x77, 0xe7, 0x47, 0x20, 0xdf, 0xc8, 0xe9, 0x8d, 0xd5,
    0x32, 0x88, 0x91, 0x81, 0xcb, 0xd2, 0x06, 0xfc, 0x7b, 0x22, 0x78, 0xc9, 0x9e, 0xe3, 0x46, 0x40,
    0x2f, 0x96, 0x9b, 0x0a, 0xa4, 0xd9, 0xd9, 0x9b, 0xa6, 0x72, 0x1e, 0xd5, 0x5d, 0x4b, 0xfb, 0x05,
    0xef, 0x58, 0x87, 0xad, 0x60, 0x28, 0x0a, 0xe0, 0x66, 0xd1, 0xdf, 0x82, 0x9b, 0xe1, 0x4c, 0x4e,
    0x89, 0xec, 0x6a, 0x9c, 0x33, 0xe9, 0xec, 0x4f, 0x46, 0x6a, 0xc5, 0x4f, 0xb9, 0x0c, 0x55, 0xac,
    0xe1, 0x5f, 0x89, 0x57, 0x9c, 0x74, 0x31, 0x63, 0xab, 0x0f, 0xe4, 0x4d, 0x2a, 0x62, 0x5d, 0x94,
    0x59, 0xae, 0xaf, 0x2f, 0x83, 0x30, 0x30, 0x5d, 0x78, 0x49, 0x81, 0x7c, 0xf0, 0x51, 0xe9, 0xa6,
    0x67, 0xae, 0x04, 0xd0, 0x3d, 0xce, 0x6f, 0xd9, 0x56, 0xeb, 0x5f, 0xfb, 0x5d, 0x4d, 0x48, 0x8e,
    0xad, 0x24, 0x64, 0x26, 0x84, 0x6c, 0x15, 0xe0, 0x91, 0x44, 0x1d, 0xad, 0x0f, 0xd1, 0xd8, 0x18,
    0x4e
};
#endif

PyTypeObject *init_KAboutLicense(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX].type;

    Shiboken::AutoDecRef Sbk_KAboutLicense_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KAboutLicense_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAboutLicense",
        "KAboutLicense",
        &Sbk_KAboutLicense_spec,
        &Shiboken::callCppDestructor< ::KAboutLicense >,
        Sbk_KAboutLicense_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KAboutLicense_Type; // references _Sbk_KAboutLicense_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAboutLicense_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAboutLicense_SignatureBytes, KAboutLicense_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAboutLicense_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAboutLicense_PythonToCpp_KAboutLicense_PTR,
        is_KAboutLicense_PythonToCpp_KAboutLicense_PTR_Convertible,
        KAboutLicense_PTR_CppToPython_KAboutLicense,
        KAboutLicense_COPY_CppToPython_KAboutLicense);

    Shiboken::Conversions::registerConverterName(converter, "KAboutLicense");
    Shiboken::Conversions::registerConverterName(converter, "KAboutLicense*");
    Shiboken::Conversions::registerConverterName(converter, "KAboutLicense&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAboutLicense).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KAboutLicense_PythonToCpp_KAboutLicense_COPY,
        is_KAboutLicense_PythonToCpp_KAboutLicense_COPY_Convertible);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KAboutLicense_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'LicenseKey'.
    const char *LicenseKey_Initializer[] = {
        "Custom",
        "File",
        "Unknown",
        "GPL",
        "GPL_V2",
        "LGPL",
        "LGPL_V2",
        "BSDL",
        "BSD_2_Clause",
        "Artistic",
        "GPL_V3",
        "LGPL_V3",
        "LGPL_V2_1",
        "MIT",
        "ODbL_V1",
        "Apache_V2",
        "FTL",
        "BSL_V1",
        "BSD_3_Clause",
        "CC0_V1",
        "MPL_V2",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t LicenseKey_InitializerValues[] = {
        int8_t(KAboutLicense::LicenseKey::Custom),       // -0x02 -2
        int8_t(KAboutLicense::LicenseKey::File),         // -0x01 -1
        int8_t(KAboutLicense::LicenseKey::Unknown),      //  0x00  0
        int8_t(KAboutLicense::LicenseKey::GPL),          //  0x01  1
        int8_t(KAboutLicense::LicenseKey::GPL_V2),       //  0x01  1
        int8_t(KAboutLicense::LicenseKey::LGPL),         //  0x02  2
        int8_t(KAboutLicense::LicenseKey::LGPL_V2),      //  0x02  2
        int8_t(KAboutLicense::LicenseKey::BSDL),         //  0x03  3
        int8_t(KAboutLicense::LicenseKey::BSD_2_Clause), //  0x03  3
        int8_t(KAboutLicense::LicenseKey::Artistic),     //  0x04  4
        int8_t(KAboutLicense::LicenseKey::GPL_V3),       //  0x05  5
        int8_t(KAboutLicense::LicenseKey::LGPL_V3),      //  0x06  6
        int8_t(KAboutLicense::LicenseKey::LGPL_V2_1),    //  0x07  7
        int8_t(KAboutLicense::LicenseKey::MIT),          //  0x08  8
        int8_t(KAboutLicense::LicenseKey::ODbL_V1),      //  0x09  9
        int8_t(KAboutLicense::LicenseKey::Apache_V2),    //  0x0a  10
        int8_t(KAboutLicense::LicenseKey::FTL),          //  0x0b  11
        int8_t(KAboutLicense::LicenseKey::BSL_V1),       //  0x0c  12
        int8_t(KAboutLicense::LicenseKey::BSD_3_Clause), //  0x0d  13
        int8_t(KAboutLicense::LicenseKey::CC0_V1),       //  0x0e  14
        int8_t(KAboutLicense::LicenseKey::MPL_V2)        //  0x0f  15
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KAboutLicense_TypeF(),
        "1:KCoreAddons.KAboutLicense.LicenseKey",
        LicenseKey_Initializer, LicenseKey_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX].type = EType;
    // Register converter for enum 'KAboutLicense::LicenseKey'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KAboutLicense_LicenseKey_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KAboutLicense_LicenseKey,
            is_Enum_PythonToCpp_KAboutLicense_LicenseKey_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KAboutLicense::LicenseKey");
        Shiboken::Conversions::registerConverterAlias(converter, "LicenseKey");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'LicenseKey' enum.

    // Initialization of enum 'NameFormat'.
    const char *NameFormat_Initializer[] = {
        "ShortName",
        "FullName",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t NameFormat_InitializerValues[] = {
        uint8_t(KAboutLicense::NameFormat::ShortName), //  0x00  0
        uint8_t(KAboutLicense::NameFormat::FullName)   //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KAboutLicense_TypeF(),
        "1:KCoreAddons.KAboutLicense.NameFormat",
        NameFormat_Initializer, NameFormat_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_NameFormat_IDX].type = EType;
    // Register converter for enum 'KAboutLicense::NameFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KAboutLicense_NameFormat_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KAboutLicense_NameFormat,
            is_Enum_PythonToCpp_KAboutLicense_NameFormat_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KAboutLicense::NameFormat");
        Shiboken::Conversions::registerConverterAlias(converter, "NameFormat");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'NameFormat' enum.

    // Initialization of enum 'VersionRestriction'.
    const char *VersionRestriction_Initializer[] = {
        "OnlyThisVersion",
        "OrLaterVersions",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t VersionRestriction_InitializerValues[] = {
        uint8_t(KAboutLicense::VersionRestriction::OnlyThisVersion), //  0x00  0
        uint8_t(KAboutLicense::VersionRestriction::OrLaterVersions)  //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KAboutLicense_TypeF(),
        "1:KCoreAddons.KAboutLicense.VersionRestriction",
        VersionRestriction_Initializer, VersionRestriction_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_VersionRestriction_IDX].type = EType;
    // Register converter for enum 'KAboutLicense::VersionRestriction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KAboutLicense_VersionRestriction_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KAboutLicense_VersionRestriction,
            is_Enum_PythonToCpp_KAboutLicense_VersionRestriction_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KAboutLicense::VersionRestriction");
        Shiboken::Conversions::registerConverterAlias(converter, "VersionRestriction");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'VersionRestriction' enum.

    qRegisterMetaType< ::KAboutLicense >("KAboutLicense");
    qRegisterMetaType< ::KAboutLicense::LicenseKey >("KAboutLicense::LicenseKey");
    qRegisterMetaType< ::KAboutLicense::NameFormat >("KAboutLicense::NameFormat");
    qRegisterMetaType< ::KAboutLicense::VersionRestriction >("KAboutLicense::VersionRestriction");

    return pyType;
}
