
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kfuzzymatcher_result_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

using namespace KFuzzyMatcher;

extern "C" {
static PyTypeObject *_Sbk_KFuzzyMatcher_Result_Type = nullptr;
static PyTypeObject *Sbk_KFuzzyMatcher_Result_TypeF(void)
{
    return _Sbk_KFuzzyMatcher_Result_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KFuzzyMatcher_Result_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KFuzzyMatcher::Result >()))
        return -1;

    ::KFuzzyMatcher::Result *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "Result", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Result::Result()
    // 1: Result::Result(KFuzzyMatcher::Result)
    if (numArgs == 0) {
        overloadId = 0; // Result()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Result(KFuzzyMatcher::Result)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Result()
        {

            // Result()
            cptr = new ::KFuzzyMatcher::Result();
            break;
        }
        case 1: // Result(const KFuzzyMatcher::Result &Result)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KFuzzyMatcher::Result cppArg0_local;
            ::KFuzzyMatcher::Result *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // Result(KFuzzyMatcher::Result)
                cptr = new ::KFuzzyMatcher::Result(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KFuzzyMatcher::Result >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KFuzzyMatcher_Result__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KFuzzyMatcher::Result *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KFuzzyMatcher_Result_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFuzzyMatcher_Result_methods[] = {
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KFuzzyMatcher_Result__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_KFuzzyMatcher_Result_get_score(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFuzzyMatcher::Result *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->score;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_KFuzzyMatcher_Result_set_score(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::KFuzzyMatcher::Result *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("score");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("score", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->score;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->score = cppOut_local;

    return 0;
}

static PyObject *Sbk_KFuzzyMatcher_Result_get_matched(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFuzzyMatcher::Result *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->matched;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_KFuzzyMatcher_Result_set_matched(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::KFuzzyMatcher::Result *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("matched");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("matched", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->matched;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->matched = cppOut_local;

    return 0;
}

// Getters and Setters for Result
static PyGetSetDef Sbk_KFuzzyMatcher_Result_getsetlist[] = {
    {"score", Sbk_KFuzzyMatcher_Result_get_score, Sbk_KFuzzyMatcher_Result_set_score, "int", nullptr},
    {"matched", Sbk_KFuzzyMatcher_Result_get_matched, Sbk_KFuzzyMatcher_Result_set_matched, "bool", nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KFuzzyMatcher_Result_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFuzzyMatcher_Result_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFuzzyMatcher_Result_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Result_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Result_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Result_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Result_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Result_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFuzzyMatcher_Result_spec = {
    "1:KCoreAddons.KFuzzyMatcher.Result",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFuzzyMatcher_Result_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Result_PythonToCpp_Result_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KFuzzyMatcher_Result_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Result_PythonToCpp_Result_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KFuzzyMatcher_Result_TypeF()))
        return Result_PythonToCpp_Result_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Result_PTR_CppToPython_Result(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KFuzzyMatcher_Result_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KFuzzyMatcher_Result_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *Result_COPY_CppToPython_Result(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KFuzzyMatcher::Result *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KFuzzyMatcher_Result_TypeF(), new ::KFuzzyMatcher::Result(*source), true, true);
}

// Python to C++ copy conversion.
static void Result_PythonToCpp_Result_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KFuzzyMatcher::Result *>(cppOut) = *reinterpret_cast< ::KFuzzyMatcher::Result *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Result_PythonToCpp_Result_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KFuzzyMatcher_Result_TypeF()))
        return Result_PythonToCpp_Result_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KFuzzyMatcher_Result_SignatureStrings[] = {
    "1:KCoreAddons.KFuzzyMatcher.Result(self)",
    "0:KCoreAddons.KFuzzyMatcher.Result(self,Result:KCoreAddons.KFuzzyMatcher.Result)",
    "KCoreAddons.KFuzzyMatcher.Result.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t KFuzzyMatcher_Result_SignatureByteSize = 86;
static constexpr uint8_t KFuzzyMatcher_Result_SignatureBytes[86] = {
    0x78, 0xda, 0x33, 0xb4, 0xf2, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6,
    0xf3, 0x76, 0x2b, 0xad, 0xaa, 0xaa, 0xf4, 0x4d, 0x2c, 0x49, 0xce, 0x48, 0x2d, 0xd2, 0x0b, 0x4a,
    0x2d, 0x2e, 0xcd, 0x29, 0xd1, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4, 0x32, 0x20, 0x4e, 0xa1, 0x0e,
    0x84, 0x4d, 0x50, 0xb1, 0x26, 0x17, 0x21, 0x15, 0x7a, 0xf1, 0xf1, 0xc9, 0xf9, 0x05, 0x95, 0xf1,
    0xf1, 0x10, 0x07, 0xe8, 0xda, 0x95, 0x54, 0x16, 0x64, 0xe6, 0xa5, 0xeb, 0xc5, 0x07, 0x03, 0xb9,
    0x5c, 0x00, 0x41, 0xb7, 0x43, 0x48
};
#endif

PyTypeObject *init_KFuzzyMatcher_Result(PyObject *enclosingClass)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX].type;

    Shiboken::AutoDecRef Sbk_KFuzzyMatcher_Result_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KFuzzyMatcher_Result_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Result",
        "KFuzzyMatcher::Result",
        &Sbk_KFuzzyMatcher_Result_spec,
        &Shiboken::callCppDestructor< ::KFuzzyMatcher::Result >,
        Sbk_KFuzzyMatcher_Result_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KFuzzyMatcher_Result_Type; // references _Sbk_KFuzzyMatcher_Result_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KFuzzyMatcher_Result_SignatureStrings);
#else
    InitSignatureBytes(pyType, KFuzzyMatcher_Result_SignatureBytes, KFuzzyMatcher_Result_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFuzzyMatcher_Result_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Result_PythonToCpp_Result_PTR,
        is_Result_PythonToCpp_Result_PTR_Convertible,
        Result_PTR_CppToPython_Result,
        Result_COPY_CppToPython_Result);

    Shiboken::Conversions::registerConverterName(converter, "KFuzzyMatcher::Result");
    Shiboken::Conversions::registerConverterName(converter, "KFuzzyMatcher::Result*");
    Shiboken::Conversions::registerConverterName(converter, "KFuzzyMatcher::Result&");
    Shiboken::Conversions::registerConverterAlias(converter, "Result");
    Shiboken::Conversions::registerConverterAlias(converter, "Result*");
    Shiboken::Conversions::registerConverterAlias(converter, "Result&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KFuzzyMatcher::Result).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Result_PythonToCpp_Result_COPY,
        is_Result_PythonToCpp_Result_COPY_Convertible);

    qRegisterMetaType< ::KFuzzyMatcher::Result >("Result");
    qRegisterMetaType< ::KFuzzyMatcher::Result >("KFuzzyMatcher::Result");

    return pyType;
}
