#ifndef SBK_KDIALOGJOBUIDELEGATEWRAPPER_H
#define SBK_KDIALOGJOBUIDELEGATEWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kdialogjobuidelegate.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KDialogJobUiDelegateWrapper : public KDialogJobUiDelegate
{
public:
    KDialogJobUiDelegateWrapper();
    KDialogJobUiDelegateWrapper(::QFlags<KJobUiDelegate::Flag> flags, ::QWidget * window);
    KDialogJobUiDelegateWrapper(const KDialogJobUiDelegateWrapper &) = delete;
    KDialogJobUiDelegateWrapper& operator=(const KDialogJobUiDelegateWrapper &) = delete;
    KDialogJobUiDelegateWrapper(KDialogJobUiDelegateWrapper &&) = delete;
    KDialogJobUiDelegateWrapper& operator=(KDialogJobUiDelegateWrapper &&) = delete;
    ~KDialogJobUiDelegateWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool setJob(::KJob * job) override;
    void setWindow(::QWidget * window) override;
    static void sbk_o_setWindow(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWidget * window);
    void showErrorMessage() override;
    void slotWarning(::KJob * job, const ::QString & message) override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 11> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KDIALOGJOBUIDELEGATEWRAPPER_H
