/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// WindowsSecurityContextOptionsApplyConfiguration represents a declarative configuration of the WindowsSecurityContextOptions type for use
// with apply.
//
// WindowsSecurityContextOptions contain Windows-specific options and credentials.
type WindowsSecurityContextOptionsApplyConfiguration struct {
	// GMSACredentialSpecName is the name of the GMSA credential spec to use.
	GMSACredentialSpecName *string `json:"gmsaCredentialSpecName,omitempty"`
	// GMSACredentialSpec is where the GMSA admission webhook
	// (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the
	// GMSA credential spec named by the GMSACredentialSpecName field.
	GMSACredentialSpec *string `json:"gmsaCredentialSpec,omitempty"`
	// The UserName in Windows to run the entrypoint of the container process.
	// Defaults to the user specified in image metadata if unspecified.
	// May also be set in PodSecurityContext. If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes precedence.
	RunAsUserName *string `json:"runAsUserName,omitempty"`
	// HostProcess determines if a container should be run as a 'Host Process' container.
	// All of a Pod's containers must have the same effective HostProcess value
	// (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers).
	// In addition, if HostProcess is true then HostNetwork must also be set to true.
	HostProcess *bool `json:"hostProcess,omitempty"`
}

// WindowsSecurityContextOptionsApplyConfiguration constructs a declarative configuration of the WindowsSecurityContextOptions type for use with
// apply.
func WindowsSecurityContextOptions() *WindowsSecurityContextOptionsApplyConfiguration {
	return &WindowsSecurityContextOptionsApplyConfiguration{}
}

// WithGMSACredentialSpecName sets the GMSACredentialSpecName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GMSACredentialSpecName field is set to the value of the last call.
func (b *WindowsSecurityContextOptionsApplyConfiguration) WithGMSACredentialSpecName(value string) *WindowsSecurityContextOptionsApplyConfiguration {
	b.GMSACredentialSpecName = &value
	return b
}

// WithGMSACredentialSpec sets the GMSACredentialSpec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GMSACredentialSpec field is set to the value of the last call.
func (b *WindowsSecurityContextOptionsApplyConfiguration) WithGMSACredentialSpec(value string) *WindowsSecurityContextOptionsApplyConfiguration {
	b.GMSACredentialSpec = &value
	return b
}

// WithRunAsUserName sets the RunAsUserName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RunAsUserName field is set to the value of the last call.
func (b *WindowsSecurityContextOptionsApplyConfiguration) WithRunAsUserName(value string) *WindowsSecurityContextOptionsApplyConfiguration {
	b.RunAsUserName = &value
	return b
}

// WithHostProcess sets the HostProcess field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HostProcess field is set to the value of the last call.
func (b *WindowsSecurityContextOptionsApplyConfiguration) WithHostProcess(value bool) *WindowsSecurityContextOptionsApplyConfiguration {
	b.HostProcess = &value
	return b
}
