
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmessagebox_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <kguiitem.h>
#include <kmessagebox.h>
#include <kmessageboxnotifyinterface.h>
#include <qdialog.h>
#include <qdialogbuttonbox.h>
#include <qicon.h>
#include <qmessagebox.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMessageBox_Type = nullptr;
static PyTypeObject *Sbk_KMessageBox_TypeF(void)
{
    return _Sbk_KMessageBox_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KMessageBox_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KMessageBox");
    return -1;
}

static PyObject *Sbk_KMessageBoxFunc_createKMessageBox(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[10];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 8, 10));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "createKMessageBox", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOOOO:createKMessageBox", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::createKMessageBox(QDialog*,QDialogButtonBox*,QMessageBox::Icon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,const QString&=)->QDialogButtonBox::StandardButton
    // 1: static KMessageBox::createKMessageBox(QDialog*,QDialogButtonBox*,QIcon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,const QString&=,QMessageBox::Icon=)->QDialogButtonBox::StandardButton
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialogButtonBox_IDX]), (pyArgs[1])))) {
        if (numArgs >= 8
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[4])))
            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[6])))
            && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
            if (numArgs == 8) {
                overloadId = 1; // createKMessageBox(QDialog*,QDialogButtonBox*,QIcon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,QString,QMessageBox::Icon)
            } else if (numArgs >= 9
                && (pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[8])))) {
                if (numArgs == 9) {
                    overloadId = 1; // createKMessageBox(QDialog*,QDialogButtonBox*,QIcon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,QString,QMessageBox::Icon)
                } else if (numArgs >= 10
                    && (pythonToCpp[9] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMessageBox_Icon_IDX])))->converter, (pyArgs[9])))) {
                    overloadId = 1; // createKMessageBox(QDialog*,QDialogButtonBox*,QIcon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,QString,QMessageBox::Icon)
                }
            }
        } else if (numArgs >= 8
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMessageBox_Icon_IDX])))->converter, (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[4])))
            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[6])))
            && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
            if (numArgs == 8) {
                overloadId = 0; // createKMessageBox(QDialog*,QDialogButtonBox*,QMessageBox::Icon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,QString)
            } else if (numArgs >= 9
                && (pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[8])))) {
                overloadId = 0; // createKMessageBox(QDialog*,QDialogButtonBox*,QMessageBox::Icon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "createKMessageBox", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // createKMessageBox(QDialog *dialog, QDialogButtonBox *buttons, QMessageBox::Icon icon, const QString &text, const QStringList &strlist, const QString &ask, bool *checkboxReturn, QFlags<KMessageBox::Option> options, const QString &details)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"details", 8}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[8] != nullptr && !(pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[8]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "createKMessageBox", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDialog *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QDialogButtonBox *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QMessageBox::Icon cppArg2{QMessageBox::NoIcon};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QStringList cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            bool *cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QFlags<KMessageBox::Option> cppArg7 = QFlags<KMessageBox::Option>(0);
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QString cppArg8 = QString();
            if (pythonToCpp[8])
                pythonToCpp[8](pyArgs[8], &cppArg8);

            if (Shiboken::Errors::occurred() == nullptr) {
                // createKMessageBox(QDialog*,QDialogButtonBox*,QMessageBox::Icon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,QString)
                QDialogButtonBox::StandardButton cppResult = ::KMessageBox::createKMessageBox(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialogButtonBox_StandardButton_IDX])))->converter, &cppResult);
            }
            break;
        }
        case 1: // createKMessageBox(QDialog *dialog, QDialogButtonBox *buttons, const QIcon &icon, const QString &text, const QStringList &strlist, const QString &ask, bool *checkboxReturn, QFlags<KMessageBox::Option> options, const QString &details, QMessageBox::Icon notifyType)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"details", 8}, {"notifyType", 9}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[8] != nullptr && !(pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[8]))))
                    || (pyArgs[9] != nullptr && !(pythonToCpp[9] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMessageBox_Icon_IDX])))->converter, (pyArgs[9]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "createKMessageBox", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QDialog *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QDialogButtonBox *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QIcon cppArg2_local;
            ::QIcon *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2].isValue())
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QStringList cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            bool *cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QFlags<KMessageBox::Option> cppArg7 = QFlags<KMessageBox::Option>(0);
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QString cppArg8 = QString();
            if (pythonToCpp[8])
                pythonToCpp[8](pyArgs[8], &cppArg8);
            ::QMessageBox::Icon cppArg9(QMessageBox::Information);
            if (pythonToCpp[9])
                pythonToCpp[9](pyArgs[9], &cppArg9);

            if (Shiboken::Errors::occurred() == nullptr) {
                // createKMessageBox(QDialog*,QDialogButtonBox*,QIcon,QString,QStringList,QString,bool*,QFlags<KMessageBox::Option>,QString,QMessageBox::Icon)
                QDialogButtonBox::StandardButton cppResult = ::KMessageBox::createKMessageBox(cppArg0, cppArg1, *cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
                pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialogButtonBox_StandardButton_IDX])))->converter, &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_detailedError(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[6];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 6));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "detailedError", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOO:detailedError", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::detailedError(QWidget*,QString,QString,const QString&=,QFlags<KMessageBox::Option>=)
    // 1: static KMessageBox::detailedError(QWidget*,QString,QString,QString,KGuiItem,QFlags<KMessageBox::Option>=)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // detailedError(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // detailedError(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 1; // detailedError(QWidget*,QString,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[5])))) {
                    overloadId = 1; // detailedError(QWidget*,QString,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                }
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4])))) {
                overloadId = 0; // detailedError(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "detailedError", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // detailedError(QWidget *parent, const QString &text, const QString &details, const QString &title, QFlags<KMessageBox::Option> options)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"title", 3}, {"options", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "detailedError", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<KMessageBox::Option> cppArg4(KMessageBox::Option::Notify);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // detailedError(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
                ::KMessageBox::detailedError(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // detailedError(QWidget *parent, const QString &text, const QString &details, const QString &title, const KGuiItem &buttonOk, QFlags<KMessageBox::Option> options)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"options", 5}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[5]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "detailedError", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::KGuiItem *cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QFlags<KMessageBox::Option> cppArg5(KMessageBox::Option::Notify);
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);

            if (Shiboken::Errors::occurred() == nullptr) {
                // detailedError(QWidget*,QString,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                ::KMessageBox::detailedError(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, cppArg5);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_detailedErrorWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[6];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 6));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "detailedErrorWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOO:detailedErrorWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::detailedErrorWId(WId,QString,QString,const QString&=,QFlags<KMessageBox::Option>=)
    // 1: static KMessageBox::detailedErrorWId(WId,QString,QString,QString,KGuiItem,QFlags<KMessageBox::Option>=)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // detailedErrorWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // detailedErrorWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 1; // detailedErrorWId(WId,QString,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[5])))) {
                    overloadId = 1; // detailedErrorWId(WId,QString,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                }
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4])))) {
                overloadId = 0; // detailedErrorWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "detailedErrorWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // detailedErrorWId(WId parent_id, const QString &text, const QString &details, const QString &title, QFlags<KMessageBox::Option> options)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"title", 3}, {"options", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "detailedErrorWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
                }
            }
            ::WId cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<KMessageBox::Option> cppArg4(KMessageBox::Option::Notify);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // detailedErrorWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
                ::KMessageBox::detailedErrorWId(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // detailedErrorWId(WId parent_id, const QString &text, const QString &details, const QString &title, const KGuiItem &buttonOk, QFlags<KMessageBox::Option> options)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"options", 5}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[5]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "detailedErrorWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
                }
            }
            ::WId cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::KGuiItem *cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QFlags<KMessageBox::Option> cppArg5(KMessageBox::Option::Notify);
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);

            if (Shiboken::Errors::occurred() == nullptr) {
                // detailedErrorWId(WId,QString,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                ::KMessageBox::detailedErrorWId(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, cppArg5);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_enableAllMessages(PyObject *self)
{
    SBK_UNUSED(self)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // enableAllMessages()
        ::KMessageBox::enableAllMessages();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_enableMessage(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KMessageBox::enableMessage(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // enableMessage(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "enableMessage", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // enableMessage(QString)
            ::KMessageBox::enableMessage(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_error(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "error", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:error", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::error(QWidget*,QString,const QString&=,QFlags<KMessageBox::Option>=)
    // 1: static KMessageBox::error(QWidget*,QString,QString,KGuiItem,QFlags<KMessageBox::Option>=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // error(QWidget*,QString,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // error(QWidget*,QString,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 1; // error(QWidget*,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4])))) {
                    overloadId = 1; // error(QWidget*,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                }
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[3])))) {
                overloadId = 0; // error(QWidget*,QString,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "error", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // error(QWidget *parent, const QString &text, const QString &title, QFlags<KMessageBox::Option> options)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"title", 2}, {"options", 3}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[3]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "error", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<KMessageBox::Option> cppArg3(KMessageBox::Option::Notify);
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // error(QWidget*,QString,QString,QFlags<KMessageBox::Option>)
                ::KMessageBox::error(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // error(QWidget *parent, const QString &text, const QString &title, const KGuiItem &buttonOk, QFlags<KMessageBox::Option> options)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"options", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "error", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::KGuiItem *cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<KMessageBox::Option> cppArg4(KMessageBox::Option::Notify);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // error(QWidget*,QString,QString,KGuiItem,QFlags<KMessageBox::Option>)
                ::KMessageBox::error(cppArg0, cppArg1, cppArg2, *cppArg3, cppArg4);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_errorList(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "errorList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:errorList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::errorList(QWidget*,QString,QStringList,const QString&=,QFlags<KMessageBox::Option>=)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // errorList(QWidget*,QString,QStringList,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // errorList(QWidget*,QString,QStringList,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4])))) {
                overloadId = 0; // errorList(QWidget*,QString,QStringList,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "errorList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"title", 3}, {"options", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "errorList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QFlags<KMessageBox::Option> cppArg4(KMessageBox::Option::Notify);
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // errorList(QWidget*,QString,QStringList,QString,QFlags<KMessageBox::Option>)
            ::KMessageBox::errorList(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_errorListWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "errorListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:errorListWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::errorListWId(WId,QString,QStringList,const QString&=,QFlags<KMessageBox::Option>=)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // errorListWId(WId,QString,QStringList,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // errorListWId(WId,QString,QStringList,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4])))) {
                overloadId = 0; // errorListWId(WId,QString,QStringList,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "errorListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"title", 3}, {"options", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "errorListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QFlags<KMessageBox::Option> cppArg4(KMessageBox::Option::Notify);
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // errorListWId(WId,QString,QStringList,QString,QFlags<KMessageBox::Option>)
            ::KMessageBox::errorListWId(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_errorWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "errorWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:errorWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::errorWId(WId,QString,const QString&=,QFlags<KMessageBox::Option>=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // errorWId(WId,QString,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // errorWId(WId,QString,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[3])))) {
                overloadId = 0; // errorWId(WId,QString,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "errorWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"title", 2}, {"options", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "errorWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QFlags<KMessageBox::Option> cppArg3(KMessageBox::Option::Notify);
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // errorWId(WId,QString,QString,QFlags<KMessageBox::Option>)
            ::KMessageBox::errorWId(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_information(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "information", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:information", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::information(QWidget*,QString,const QString&=,const QString&=,QFlags<KMessageBox::Option>=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // information(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // information(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // information(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4])))) {
                    overloadId = 0; // information(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "information", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"title", 2}, {"dontShowAgainName", 3}, {"options", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "information", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QFlags<KMessageBox::Option> cppArg4(KMessageBox::Option::Notify);
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // information(QWidget*,QString,QString,QString,QFlags<KMessageBox::Option>)
            ::KMessageBox::information(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_informationList(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[6];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 6));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "informationList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOO:informationList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::informationList(QWidget*,QString,QStringList,const QString&=,const QString&=,QFlags<KMessageBox::Option>=)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // informationList(QWidget*,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // informationList(QWidget*,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 0; // informationList(QWidget*,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[5])))) {
                    overloadId = 0; // informationList(QWidget*,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "informationList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"title", 3}, {"dontShowAgainName", 4}, {"options", 5}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[5]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "informationList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QFlags<KMessageBox::Option> cppArg5(KMessageBox::Option::Notify);
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);

        if (Shiboken::Errors::occurred() == nullptr) {
            // informationList(QWidget*,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
            ::KMessageBox::informationList(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_informationListWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[6];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 6));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "informationListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOO:informationListWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::informationListWId(WId,QString,QStringList,const QString&=,const QString&=,QFlags<KMessageBox::Option>=)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // informationListWId(WId,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // informationListWId(WId,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 0; // informationListWId(WId,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[5])))) {
                    overloadId = 0; // informationListWId(WId,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "informationListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"title", 3}, {"dontShowAgainName", 4}, {"options", 5}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[5]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "informationListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QFlags<KMessageBox::Option> cppArg5(KMessageBox::Option::Notify);
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);

        if (Shiboken::Errors::occurred() == nullptr) {
            // informationListWId(WId,QString,QStringList,QString,QString,QFlags<KMessageBox::Option>)
            ::KMessageBox::informationListWId(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_informationWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "informationWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:informationWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::informationWId(WId,QString,const QString&=,const QString&=,QFlags<KMessageBox::Option>=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // informationWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // informationWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // informationWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4])))) {
                    overloadId = 0; // informationWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "informationWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"title", 2}, {"dontShowAgainName", 3}, {"options", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "informationWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QFlags<KMessageBox::Option> cppArg4(KMessageBox::Option::Notify);
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // informationWId(WId,QString,QString,QString,QFlags<KMessageBox::Option>)
            ::KMessageBox::informationWId(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_messageBox(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[9];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 7, 9));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "messageBox", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOOO:messageBox", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::messageBox(QWidget*,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 7
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_DialogType_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[6])))) {
        if (numArgs == 7) {
            overloadId = 0; // messageBox(QWidget*,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 8
            && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7])))) {
            if (numArgs == 8) {
                overloadId = 0; // messageBox(QWidget*,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 9
                && (pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[8])))) {
                overloadId = 0; // messageBox(QWidget*,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "messageBox", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontShowAskAgainName", 7}, {"options", 8}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7]))))
                || (pyArgs[8] != nullptr && !(pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[8]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "messageBox", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KMessageBox::DialogType cppArg1 = static_cast< ::KMessageBox::DialogType>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        if (!Shiboken::Object::isValid(pyArgs[6]))
            return {};
        ::KGuiItem *cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QString cppArg7 = QString();
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);
        ::QFlags<KMessageBox::Option> cppArg8(KMessageBox::Option::Notify);
        if (pythonToCpp[8])
            pythonToCpp[8](pyArgs[8], &cppArg8);

        if (Shiboken::Errors::occurred() == nullptr) {
            // messageBox(QWidget*,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::messageBox(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, *cppArg6, cppArg7, cppArg8);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_messageBoxWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[9];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 7, 9));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "messageBoxWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOOO:messageBoxWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::messageBoxWId(WId,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 7
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_DialogType_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[6])))) {
        if (numArgs == 7) {
            overloadId = 0; // messageBoxWId(WId,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 8
            && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7])))) {
            if (numArgs == 8) {
                overloadId = 0; // messageBoxWId(WId,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 9
                && (pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[8])))) {
                overloadId = 0; // messageBoxWId(WId,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "messageBoxWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontShowAskAgainName", 7}, {"options", 8}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7]))))
                || (pyArgs[8] != nullptr && !(pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[8]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "messageBoxWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KMessageBox::DialogType cppArg1 = static_cast< ::KMessageBox::DialogType>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        if (!Shiboken::Object::isValid(pyArgs[6]))
            return {};
        ::KGuiItem *cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QString cppArg7 = QString();
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);
        ::QFlags<KMessageBox::Option> cppArg8(KMessageBox::Option::Notify);
        if (pythonToCpp[8])
            pythonToCpp[8](pyArgs[8], &cppArg8);

        if (Shiboken::Errors::occurred() == nullptr) {
            // messageBoxWId(WId,KMessageBox::DialogType,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::messageBoxWId(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, *cppArg6, cppArg7, cppArg8);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_questionTwoActions(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 5, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "questionTwoActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:questionTwoActions", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::questionTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
        if (numArgs == 5) {
            overloadId = 0; // questionTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 6
            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 0; // questionTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                overloadId = 0; // questionTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "questionTwoActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "questionTwoActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<KMessageBox::Option> cppArg6(KMessageBox::Option::Notify);
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // questionTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::questionTwoActions(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, cppArg5, cppArg6);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_questionTwoActionsCancel(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 6, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "questionTwoActionsCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:questionTwoActionsCancel", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::questionTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // questionTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 0; // questionTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                overloadId = 0; // questionTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "questionTwoActionsCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "questionTwoActionsCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7(KMessageBox::Option::Notify);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // questionTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::questionTwoActionsCancel(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_questionTwoActionsCancelWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 6, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "questionTwoActionsCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:questionTwoActionsCancelWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::questionTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // questionTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 0; // questionTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                overloadId = 0; // questionTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "questionTwoActionsCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "questionTwoActionsCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7(KMessageBox::Option::Notify);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // questionTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::questionTwoActionsCancelWId(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_questionTwoActionsList(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 6, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "questionTwoActionsList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:questionTwoActionsList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::questionTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // questionTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 0; // questionTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                overloadId = 0; // questionTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "questionTwoActionsList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "questionTwoActionsList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7(KMessageBox::Option::Notify);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // questionTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::questionTwoActionsList(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_questionTwoActionsListWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 6, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "questionTwoActionsListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:questionTwoActionsListWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::questionTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // questionTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 0; // questionTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                overloadId = 0; // questionTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "questionTwoActionsListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "questionTwoActionsListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7(KMessageBox::Option::Notify);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // questionTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::questionTwoActionsListWId(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_questionTwoActionsWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 5, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "questionTwoActionsWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:questionTwoActionsWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::questionTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
        if (numArgs == 5) {
            overloadId = 0; // questionTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 6
            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 0; // questionTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                overloadId = 0; // questionTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "questionTwoActionsWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "questionTwoActionsWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<KMessageBox::Option> cppArg6(KMessageBox::Option::Notify);
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // questionTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::questionTwoActionsWId(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, cppArg5, cppArg6);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_saveDontShowAgainContinue(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KMessageBox::saveDontShowAgainContinue(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // saveDontShowAgainContinue(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "saveDontShowAgainContinue", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // saveDontShowAgainContinue(QString)
            ::KMessageBox::saveDontShowAgainContinue(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_saveDontShowAgainTwoActions(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "saveDontShowAgainTwoActions", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::saveDontShowAgainTwoActions(QString,KMessageBox::ButtonCode)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // saveDontShowAgainTwoActions(QString,KMessageBox::ButtonCode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "saveDontShowAgainTwoActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KMessageBox::ButtonCode cppArg1 = static_cast< ::KMessageBox::ButtonCode>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // saveDontShowAgainTwoActions(QString,KMessageBox::ButtonCode)
            ::KMessageBox::saveDontShowAgainTwoActions(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_setNotifyInterface(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KMessageBox::setNotifyInterface(KMessageBoxNotifyInterface*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBoxNotifyInterface_IDX]), (pyArg)))) {
        overloadId = 0; // setNotifyInterface(KMessageBoxNotifyInterface*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setNotifyInterface", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KMessageBoxNotifyInterface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setNotifyInterface(KMessageBoxNotifyInterface*)
            ::KMessageBox::setNotifyInterface(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageBoxFunc_shouldBeShownContinue(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KMessageBox::shouldBeShownContinue(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // shouldBeShownContinue(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "shouldBeShownContinue", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // shouldBeShownContinue(QString)
            bool cppResult = ::KMessageBox::shouldBeShownContinue(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_shouldBeShownTwoActions(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "shouldBeShownTwoActions", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::shouldBeShownTwoActions(QString,KMessageBox::ButtonCode&)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, (pyArgs[1])))) {
        overloadId = 0; // shouldBeShownTwoActions(QString,KMessageBox::ButtonCode&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "shouldBeShownTwoActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KMessageBox::ButtonCode cppArg1 = static_cast< ::KMessageBox::ButtonCode>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // shouldBeShownTwoActions(QString,KMessageBox::ButtonCode&)
            bool cppResult = ::KMessageBox::shouldBeShownTwoActions(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningContinueCancel(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningContinueCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
    if (numArgs == 3 || numArgs == 4)
        return Shiboken::returnWrongArguments(args, "warningContinueCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:warningContinueCancel", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningContinueCancel(QWidget*,QString,const QString&=,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // warningContinueCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 5
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 0; // warningContinueCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                if (numArgs == 6) {
                    overloadId = 0; // warningContinueCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 7
                    && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                    overloadId = 0; // warningContinueCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningContinueCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"title", 2}, {"dontAskAgainName", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningContinueCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<KMessageBox::Option> cppArg6(KMessageBox::Option::Notify);
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningContinueCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningContinueCancel(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, cppArg5, cppArg6);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningContinueCancelDetailed(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningContinueCancelDetailed", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
    if (numArgs == 3 || numArgs == 4)
        return Shiboken::returnWrongArguments(args, "warningContinueCancelDetailed", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:warningContinueCancelDetailed", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningContinueCancelDetailed(QWidget*,QString,const QString&=,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=,const QString&=)->KMessageBox::ButtonCode
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // warningContinueCancelDetailed(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>,QString)
        } else if (numArgs >= 5
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 0; // warningContinueCancelDetailed(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>,QString)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                if (numArgs == 6) {
                    overloadId = 0; // warningContinueCancelDetailed(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>,QString)
                } else if (numArgs >= 7
                    && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                    if (numArgs == 7) {
                        overloadId = 0; // warningContinueCancelDetailed(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>,QString)
                    } else if (numArgs >= 8
                        && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7])))) {
                        overloadId = 0; // warningContinueCancelDetailed(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>,QString)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningContinueCancelDetailed", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"title", 2}, {"dontAskAgainName", 5}, {"options", 6}, {"details", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningContinueCancelDetailed", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<KMessageBox::Option> cppArg6(KMessageBox::Option::Notify);
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QString cppArg7 = QString();
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningContinueCancelDetailed(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>,QString)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningContinueCancelDetailed(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningContinueCancelList(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningContinueCancelList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
    if (numArgs == 4 || numArgs == 5)
        return Shiboken::returnWrongArguments(args, "warningContinueCancelList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:warningContinueCancelList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningContinueCancelList(QWidget*,QString,QStringList,const QString&=,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // warningContinueCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 6
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 0; // warningContinueCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
                if (numArgs == 7) {
                    overloadId = 0; // warningContinueCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 8
                    && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                    overloadId = 0; // warningContinueCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningContinueCancelList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"title", 3}, {"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningContinueCancelList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7(KMessageBox::Option::Notify);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningContinueCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningContinueCancelList(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningContinueCancelListWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningContinueCancelListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
    if (numArgs == 4 || numArgs == 5)
        return Shiboken::returnWrongArguments(args, "warningContinueCancelListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:warningContinueCancelListWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningContinueCancelListWId(WId,QString,QStringList,const QString&=,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // warningContinueCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 6
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 0; // warningContinueCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
                if (numArgs == 7) {
                    overloadId = 0; // warningContinueCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 8
                    && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                    overloadId = 0; // warningContinueCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningContinueCancelListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"title", 3}, {"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningContinueCancelListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7(KMessageBox::Option::Notify);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningContinueCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningContinueCancelListWId(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningContinueCancelWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningContinueCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
    if (numArgs == 3 || numArgs == 4)
        return Shiboken::returnWrongArguments(args, "warningContinueCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:warningContinueCancelWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningContinueCancelWId(WId,QString,const QString&=,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // warningContinueCancelWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 5
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 0; // warningContinueCancelWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                if (numArgs == 6) {
                    overloadId = 0; // warningContinueCancelWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
                } else if (numArgs >= 7
                    && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                    overloadId = 0; // warningContinueCancelWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningContinueCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"title", 2}, {"dontAskAgainName", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningContinueCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<KMessageBox::Option> cppArg6(KMessageBox::Option::Notify);
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningContinueCancelWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningContinueCancelWId(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, cppArg5, cppArg6);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningTwoActions(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 5, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningTwoActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:warningTwoActions", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
        if (numArgs == 5) {
            overloadId = 0; // warningTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 6
            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 0; // warningTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                overloadId = 0; // warningTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningTwoActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningTwoActions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<KMessageBox::Option> cppArg6 = KMessageBox::Options(KMessageBox::Option::Notify | KMessageBox::Option::Dangerous);
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningTwoActions(QWidget*,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningTwoActions(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, cppArg5, cppArg6);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningTwoActionsCancel(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 6, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningTwoActionsCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:warningTwoActionsCancel", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // warningTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 0; // warningTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                overloadId = 0; // warningTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningTwoActionsCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningTwoActionsCancel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7 = KMessageBox::Options(KMessageBox::Option::Notify | KMessageBox::Option::Dangerous);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningTwoActionsCancel(QWidget*,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningTwoActionsCancel(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningTwoActionsCancelList(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[9];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 7, 9));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOOO:warningTwoActionsCancelList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningTwoActionsCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 7
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[6])))) {
        if (numArgs == 7) {
            overloadId = 0; // warningTwoActionsCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 8
            && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7])))) {
            if (numArgs == 8) {
                overloadId = 0; // warningTwoActionsCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 9
                && (pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[8])))) {
                overloadId = 0; // warningTwoActionsCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 7}, {"options", 8}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7]))))
                || (pyArgs[8] != nullptr && !(pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[8]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        if (!Shiboken::Object::isValid(pyArgs[6]))
            return {};
        ::KGuiItem *cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QString cppArg7 = QString();
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);
        ::QFlags<KMessageBox::Option> cppArg8 = KMessageBox::Options(KMessageBox::Option::Notify | KMessageBox::Option::Dangerous);
        if (pythonToCpp[8])
            pythonToCpp[8](pyArgs[8], &cppArg8);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningTwoActionsCancelList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningTwoActionsCancelList(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, *cppArg6, cppArg7, cppArg8);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningTwoActionsCancelListWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[9];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 7, 9));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOOO:warningTwoActionsCancelListWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningTwoActionsCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 7
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[6])))) {
        if (numArgs == 7) {
            overloadId = 0; // warningTwoActionsCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 8
            && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7])))) {
            if (numArgs == 8) {
                overloadId = 0; // warningTwoActionsCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 9
                && (pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[8])))) {
                overloadId = 0; // warningTwoActionsCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 7}, {"options", 8}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7]))))
                || (pyArgs[8] != nullptr && !(pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[8]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        if (!Shiboken::Object::isValid(pyArgs[6]))
            return {};
        ::KGuiItem *cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QString cppArg7 = QString();
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);
        ::QFlags<KMessageBox::Option> cppArg8 = KMessageBox::Options(KMessageBox::Option::Notify | KMessageBox::Option::Dangerous);
        if (pythonToCpp[8])
            pythonToCpp[8](pyArgs[8], &cppArg8);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningTwoActionsCancelListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningTwoActionsCancelListWId(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, *cppArg6, cppArg7, cppArg8);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningTwoActionsCancelWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 6, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:warningTwoActionsCancelWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // warningTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 0; // warningTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                overloadId = 0; // warningTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningTwoActionsCancelWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7 = KMessageBox::Options(KMessageBox::Option::Notify | KMessageBox::Option::Dangerous);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningTwoActionsCancelWId(WId,QString,QString,KGuiItem,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningTwoActionsCancelWId(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningTwoActionsList(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 6, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningTwoActionsList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:warningTwoActionsList", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // warningTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 0; // warningTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                overloadId = 0; // warningTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningTwoActionsList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningTwoActionsList", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7 = KMessageBox::Options(KMessageBox::Option::Notify | KMessageBox::Option::Dangerous);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningTwoActionsList(QWidget*,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningTwoActionsList(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningTwoActionsListWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[8];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 6, 8));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningTwoActionsListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOO:warningTwoActionsListWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // warningTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
            if (numArgs == 7) {
                overloadId = 0; // warningTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 8
                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7])))) {
                overloadId = 0; // warningTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningTwoActionsListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 6}, {"options", 7}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[7]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningTwoActionsListWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::KGuiItem *cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);
        ::QFlags<KMessageBox::Option> cppArg7 = KMessageBox::Options(KMessageBox::Option::Notify | KMessageBox::Option::Dangerous);
        if (pythonToCpp[7])
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningTwoActionsListWId(WId,QString,QStringList,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningTwoActionsListWId(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4, *cppArg5, cppArg6, cppArg7);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageBoxFunc_warningTwoActionsWId(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 5, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "warningTwoActionsWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:warningTwoActionsWId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageBox::warningTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,const QString&=,QFlags<KMessageBox::Option>=)->KMessageBox::ButtonCode
    if (numArgs >= 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[4])))) {
        if (numArgs == 5) {
            overloadId = 0; // warningTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
        } else if (numArgs >= 6
            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
            if (numArgs == 6) {
                overloadId = 0; // warningTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            } else if (numArgs >= 7
                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                overloadId = 0; // warningTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warningTwoActionsWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"dontAskAgainName", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "warningTwoActionsWId", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX]);
            }
        }
        ::WId cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::KGuiItem *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::KGuiItem *cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<KMessageBox::Option> cppArg6 = KMessageBox::Options(KMessageBox::Option::Notify | KMessageBox::Option::Dangerous);
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warningTwoActionsWId(WId,QString,QString,KGuiItem,KGuiItem,QString,QFlags<KMessageBox::Option>)
            KMessageBox::ButtonCode cppResult = ::KMessageBox::warningTwoActionsWId(cppArg0, cppArg1, cppArg2, *cppArg3, *cppArg4, cppArg5, cppArg6);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KMessageBox_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KMessageBox_EnumFlagInfo[] = {
    "ButtonCode:IntEnum",
    "DialogType:IntEnum",
    "Option:IntFlag:Options",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMessageBox_methods[] = {
    {"createKMessageBox", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_createKMessageBox), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"detailedError", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_detailedError), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"detailedErrorWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_detailedErrorWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"enableAllMessages", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_enableAllMessages), METH_NOARGS|METH_STATIC, nullptr},
    {"enableMessage", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_enableMessage), METH_O|METH_STATIC, nullptr},
    {"error", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_error), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"errorList", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_errorList), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"errorListWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_errorListWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"errorWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_errorWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"information", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_information), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"informationList", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_informationList), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"informationListWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_informationListWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"informationWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_informationWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"messageBox", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_messageBox), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"messageBoxWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_messageBoxWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"questionTwoActions", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_questionTwoActions), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"questionTwoActionsCancel", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_questionTwoActionsCancel), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"questionTwoActionsCancelWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_questionTwoActionsCancelWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"questionTwoActionsList", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_questionTwoActionsList), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"questionTwoActionsListWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_questionTwoActionsListWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"questionTwoActionsWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_questionTwoActionsWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"saveDontShowAgainContinue", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_saveDontShowAgainContinue), METH_O|METH_STATIC, nullptr},
    {"saveDontShowAgainTwoActions", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_saveDontShowAgainTwoActions), METH_VARARGS|METH_STATIC, nullptr},
    {"setNotifyInterface", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_setNotifyInterface), METH_O|METH_STATIC, nullptr},
    {"shouldBeShownContinue", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_shouldBeShownContinue), METH_O|METH_STATIC, nullptr},
    {"shouldBeShownTwoActions", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_shouldBeShownTwoActions), METH_VARARGS|METH_STATIC, nullptr},
    {"warningContinueCancel", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningContinueCancel), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningContinueCancelDetailed", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningContinueCancelDetailed), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningContinueCancelList", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningContinueCancelList), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningContinueCancelListWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningContinueCancelListWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningContinueCancelWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningContinueCancelWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningTwoActions", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningTwoActions), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningTwoActionsCancel", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningTwoActionsCancel), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningTwoActionsCancelList", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningTwoActionsCancelList), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningTwoActionsCancelListWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningTwoActionsCancelListWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningTwoActionsCancelWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningTwoActionsCancelWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningTwoActionsList", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningTwoActionsList), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningTwoActionsListWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningTwoActionsListWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"warningTwoActionsWId", reinterpret_cast<PyCFunction>(Sbk_KMessageBoxFunc_warningTwoActionsWId), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KMessageBox_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMessageBox_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMessageBox_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMessageBox_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMessageBox_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMessageBox_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMessageBox_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMessageBox_spec = {
    "1:KWidgetsAddons.KMessageBox",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMessageBox_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KMessageBox_ButtonCode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMessageBox::ButtonCode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMessageBox::ButtonCode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMessageBox_ButtonCode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX])))
        return Enum_PythonToCpp_KMessageBox_ButtonCode;
    return {};
}

static PyObject *KMessageBox_ButtonCode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMessageBox::ButtonCode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMessageBox::ButtonCode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KMessageBox_DialogType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMessageBox::DialogType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMessageBox::DialogType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMessageBox_DialogType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_DialogType_IDX])))
        return Enum_PythonToCpp_KMessageBox_DialogType;
    return {};
}

static PyObject *KMessageBox_DialogType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMessageBox::DialogType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMessageBox::DialogType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KMessageBox_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMessageBox::Option>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMessageBox::Option *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMessageBox_Option_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_Option_IDX])))
        return Enum_PythonToCpp_KMessageBox_Option;
    return {};
}

static PyObject *KMessageBox_Option_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMessageBox::Option>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMessageBox::Option *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KMessageBox_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KMessageBox::Option>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KMessageBox::Option> *>(cppOut) = value;

}

static PyObject *KMessageBox_Option_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KMessageBox::Option> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_Option_IDX]), flags.toInt());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KWidgetsAddonsKMessageBox_SignatureStrings[] = {
    "1:KWidgetsAddons.KMessageBox.createKMessageBox(dialog:PySide6.QtWidgets.QDialog,buttons:PySide6.QtWidgets.QDialogButtonBox,icon:PySide6.QtWidgets.QMessageBox.Icon,text:QString,strlist:QStringList,ask:QString,checkboxReturn:bool*,options:KWidgetsAddons.KMessageBox.Option,details:QString=QString())->PySide6.QtWidgets.QDialogButtonBox.StandardButton",
    "0:KWidgetsAddons.KMessageBox.createKMessageBox(dialog:PySide6.QtWidgets.QDialog,buttons:PySide6.QtWidgets.QDialogButtonBox,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,strlist:QStringList,ask:QString,checkboxReturn:bool*,options:KWidgetsAddons.KMessageBox.Option,details:QString=QString(),notifyType:PySide6.QtWidgets.QMessageBox.Icon=QMessageBox.Information)->PySide6.QtWidgets.QDialogButtonBox.StandardButton",
    "1:KWidgetsAddons.KMessageBox.detailedError(parent:PySide6.QtWidgets.QWidget,text:QString,details:QString,title:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "0:KWidgetsAddons.KMessageBox.detailedError(parent:PySide6.QtWidgets.QWidget,text:QString,details:QString,title:QString,buttonOk:KWidgetsAddons.KGuiItem,options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "1:KWidgetsAddons.KMessageBox.detailedErrorWId(parent_id:WId,text:QString,details:QString,title:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "0:KWidgetsAddons.KMessageBox.detailedErrorWId(parent_id:WId,text:QString,details:QString,title:QString,buttonOk:KWidgetsAddons.KGuiItem,options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.enableAllMessages()",
    "KWidgetsAddons.KMessageBox.enableMessage(dontShowAgainName:QString)",
    "1:KWidgetsAddons.KMessageBox.error(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "0:KWidgetsAddons.KMessageBox.error(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString,buttonOk:KWidgetsAddons.KGuiItem,options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.errorList(parent:PySide6.QtWidgets.QWidget,text:QString,strlist:QStringList,title:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.errorListWId(parent_id:WId,text:QString,strlist:QStringList,title:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.errorWId(parent_id:WId,text:QString,title:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.information(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString=QString(),dontShowAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.informationList(parent:PySide6.QtWidgets.QWidget,text:QString,strlist:QStringList,title:QString=QString(),dontShowAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.informationListWId(parent_id:WId,text:QString,strlist:QStringList,title:QString=QString(),dontShowAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.informationWId(parent_id:WId,text:QString,title:QString=QString(),dontShowAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)",
    "KWidgetsAddons.KMessageBox.messageBox(parent:PySide6.QtWidgets.QWidget,type:KWidgetsAddons.KMessageBox.DialogType,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem,dontShowAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.messageBoxWId(parent_id:WId,type:KWidgetsAddons.KMessageBox.DialogType,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem,dontShowAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.questionTwoActions(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.questionTwoActionsCancel(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.questionTwoActionsCancelWId(parent_id:WId,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.questionTwoActionsList(parent:PySide6.QtWidgets.QWidget,text:QString,strlist:QStringList,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.questionTwoActionsListWId(parent_id:WId,text:QString,strlist:QStringList,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.questionTwoActionsWId(parent_id:WId,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.saveDontShowAgainContinue(dontShowAgainName:QString)",
    "KWidgetsAddons.KMessageBox.saveDontShowAgainTwoActions(dontShowAgainName:QString,result:KWidgetsAddons.KMessageBox.ButtonCode)",
    "KWidgetsAddons.KMessageBox.setNotifyInterface(notifyInterface:KWidgetsAddons.KMessageBoxNotifyInterface)",
    "KWidgetsAddons.KMessageBox.shouldBeShownContinue(dontShowAgainName:QString)->bool",
    "KWidgetsAddons.KMessageBox.shouldBeShownTwoActions(dontShowAgainName:QString,result:KWidgetsAddons.KMessageBox.ButtonCode)->bool",
    "KWidgetsAddons.KMessageBox.warningContinueCancel(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString=QString(),buttonContinue:KWidgetsAddons.KGuiItem,buttonCancel:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningContinueCancelDetailed(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString=QString(),buttonContinue:KWidgetsAddons.KGuiItem,buttonCancel:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify,details:QString=QString())->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningContinueCancelList(parent:PySide6.QtWidgets.QWidget,text:QString,strlist:QStringList,title:QString=QString(),buttonContinue:KWidgetsAddons.KGuiItem,buttonCancel:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningContinueCancelListWId(parent_id:WId,text:QString,strlist:QStringList,title:QString=QString(),buttonContinue:KWidgetsAddons.KGuiItem,buttonCancel:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningContinueCancelWId(parent_id:WId,text:QString,title:QString=QString(),buttonContinue:KWidgetsAddons.KGuiItem,buttonCancel:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Option.Notify)->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningTwoActions(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Options(KMessageBox.Option.Notify | KMessageBox.Option.Dangerous))->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningTwoActionsCancel(parent:PySide6.QtWidgets.QWidget,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Options(KMessageBox.Option.Notify | KMessageBox.Option.Dangerous))->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningTwoActionsCancelList(parent:PySide6.QtWidgets.QWidget,text:QString,strlist:QStringList,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Options(KMessageBox.Option.Notify | KMessageBox.Option.Dangerous))->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningTwoActionsCancelListWId(parent_id:WId,text:QString,strlist:QStringList,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Options(KMessageBox.Option.Notify | KMessageBox.Option.Dangerous))->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningTwoActionsCancelWId(parent_id:WId,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Options(KMessageBox.Option.Notify | KMessageBox.Option.Dangerous))->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningTwoActionsList(parent:PySide6.QtWidgets.QWidget,text:QString,strlist:QStringList,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Options(KMessageBox.Option.Notify | KMessageBox.Option.Dangerous))->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningTwoActionsListWId(parent_id:WId,text:QString,strlist:QStringList,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Options(KMessageBox.Option.Notify | KMessageBox.Option.Dangerous))->KWidgetsAddons.KMessageBox.ButtonCode",
    "KWidgetsAddons.KMessageBox.warningTwoActionsWId(parent_id:WId,text:QString,title:QString,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,dontAskAgainName:QString=QString(),options:KWidgetsAddons.KMessageBox.Option=KMessageBox.Options(KMessageBox.Option.Notify | KMessageBox.Option.Dangerous))->KWidgetsAddons.KMessageBox.ButtonCode",
    nullptr}; // Sentinel
#else
static constexpr size_t KWidgetsAddonsKMessageBox_SignatureByteSize = 765;
static constexpr uint8_t KWidgetsAddonsKMessageBox_SignatureBytes[765] = {
    0x78, 0xda, 0xed, 0x59, 0x4b, 0x8f, 0xda, 0x30, 0x10, 0xbe, 0xf7, 0x57, 0x70, 0x0c, 0x55, 0x36,
    0xea, 0x5e, 0x7a, 0x88, 0x04, 0x12, 0x8f, 0xaa, 0x42, 0xdb, 0xee, 0x2e, 0x65, 0x57, 0x7b, 0xa8,
    0xaa, 0xca, 0xc4, 0x03, 0x58, 0x24, 0x36, 0xb5, 0x9d, 0x02, 0x52, 0x7f, 0x7c, 0xf3, 0xda, 0xf0,
    0xd8, 0xc4, 0x09, 0x8f, 0x40, 0x58, 0x72, 0x22, 0x71, 0xc6, 0xe3, 0xf9, 0xbe, 0x6f, 0x1c, 0x4f,
    0x86, 0x5b, 0xf3, 0xee, 0x85, 0xe0, 0x31, 0x48, 0xd1, 0xc2, 0x98, 0x51, 0x61, 0xdc, 0x7d, 0x07,
    0x21, 0xd0, 0x18, 0xda, 0x6c, 0x61, 0x58, 0x1c, 0x90, 0x84, 0xb5, 0x11, 0x0d, 0x13, 0x64, 0xb3,
    0xb1, 0xf9, 0xb8, 0x1c, 0x10, 0x0c, 0x9f, 0x8d, 0xbe, 0x8c, 0x26, 0x1b, 0xfd, 0x6e, 0xf0, 0x44,
    0x1f, 0xba, 0x52, 0x7a, 0x6e, 0xd2, 0x2d, 0xda, 0x81, 0x81, 0xe7, 0x4b, 0x27, 0x16, 0xa3, 0x49,
    0x76, 0x6b, 0x01, 0xf4, 0x3c, 0x13, 0x5d, 0xc2, 0x42, 0x9a, 0xfd, 0x81, 0xe4, 0x84, 0x8e, 0x75,
    0x21, 0xb9, 0x4d, 0x44, 0x7c, 0xff, 0xcd, 0xbb, 0xd6, 0x91, 0x98, 0xc6, 0xcf, 0xad, 0x09, 0x58,
    0xd3, 0x21, 0x5b, 0xfc, 0x00, 0xe9, 0x72, 0x6a, 0x0e, 0x19, 0xb3, 0x3f, 0xea, 0x6c, 0x26, 0x89,
    0x1f, 0x94, 0x02, 0xea, 0x43, 0x60, 0xa2, 0x63, 0x90, 0x88, 0xd8, 0xe2, 0xd5, 0x5d, 0x23, 0xfa,
    0xd5, 0xea, 0xf5, 0x9b, 0x66, 0x36, 0x24, 0x63, 0x20, 0x11, 0xc5, 0x88, 0xe3, 0x70, 0xe4, 0xc3,
    0xa7, 0x33, 0x93, 0x2b, 0x97, 0x33, 0x2f, 0x78, 0xe3, 0x99, 0x7a, 0xd0, 0x7e, 0xae, 0x26, 0x7d,
    0x75, 0x89, 0xd1, 0x0f, 0xa8, 0xad, 0x6d, 0x0d, 0x3e, 0x92, 0x85, 0x83, 0x66, 0xbf, 0xca, 0x41,
    0xb9, 0x4e, 0x99, 0x24, 0xa3, 0xe5, 0xd3, 0x72, 0x06, 0x39, 0xd2, 0xa4, 0xb1, 0x31, 0x40, 0x47,
    0x8c, 0x3b, 0xc8, 0xf7, 0xbf, 0x97, 0x70, 0xb7, 0xaa, 0xb8, 0xc3, 0x80, 0x01, 0x7f, 0xe1, 0x9c,
    0x71, 0x6d, 0x86, 0x38, 0x50, 0x99, 0x14, 0x60, 0x78, 0xb1, 0xc9, 0xe5, 0x16, 0x58, 0x5d, 0x12,
    0x69, 0x43, 0x02, 0xf4, 0xdc, 0xf4, 0x35, 0xde, 0x0e, 0x19, 0xf7, 0x01, 0x6f, 0x75, 0x75, 0xfa,
    0x15, 0x86, 0x22, 0xca, 0xd2, 0x87, 0xe9, 0x9b, 0xd5, 0xbd, 0x14, 0xeb, 0x49, 0x70, 0x8e, 0x03,
    0x2e, 0xbf, 0x44, 0x2f, 0x3d, 0x1c, 0xe1, 0xfb, 0x4d, 0xb0, 0xe9, 0xdd, 0x5d, 0x84, 0x24, 0x87,
    0x44, 0x7d, 0x22, 0x09, 0x14, 0x93, 0x81, 0xa2, 0xa1, 0x0d, 0x2d, 0xdb, 0x8e, 0xc6, 0x84, 0x96,
    0xc3, 0x3c, 0x1a, 0xd0, 0xbc, 0xc7, 0x72, 0x30, 0x61, 0xf3, 0xd6, 0x18, 0x11, 0x7a, 0x8f, 0x9c,
    0x18, 0x57, 0x86, 0xea, 0xb0, 0x47, 0x2a, 0x9f, 0x4f, 0xed, 0x83, 0xa3, 0x2d, 0x81, 0xca, 0x3e,
    0x04, 0xff, 0x3c, 0xd8, 0x11, 0x46, 0xd2, 0x89, 0x52, 0xa8, 0x10, 0x79, 0x30, 0x64, 0x6c, 0xb8,
    0xd2, 0xc5, 0x9c, 0x11, 0xef, 0xb9, 0x62, 0x23, 0xab, 0xa3, 0xf7, 0x48, 0x5b, 0x31, 0xf5, 0x75,
    0x70, 0x1e, 0x54, 0x05, 0xe7, 0x7b, 0x09, 0xd1, 0x1e, 0x71, 0x67, 0x94, 0x0c, 0xdd, 0x9e, 0x7b,
    0xa8, 0x0c, 0x28, 0x9c, 0xd5, 0x77, 0x43, 0x76, 0x32, 0xfa, 0x25, 0xb4, 0xc2, 0x57, 0x58, 0x0d,
    0xfb, 0x85, 0xb6, 0xea, 0xb8, 0x99, 0x71, 0xe2, 0x20, 0xbe, 0x6c, 0x59, 0x7e, 0x88, 0xa9, 0x67,
    0x8e, 0x00, 0xaf, 0x18, 0xc7, 0xd9, 0x76, 0x16, 0xa2, 0x16, 0xd8, 0x19, 0x46, 0x31, 0xd1, 0x62,
    0x5a, 0x34, 0xd7, 0x37, 0x4d, 0xc5, 0xec, 0xf0, 0xb3, 0xa0, 0xc3, 0x30, 0xe4, 0x93, 0x24, 0x21,
    0xaf, 0x2a, 0x09, 0x4e, 0x21, 0xc1, 0x1f, 0x17, 0x84, 0xef, 0xf2, 0x69, 0xce, 0x42, 0x5c, 0xe2,
    0xa0, 0x0a, 0xeb, 0xb8, 0x7c, 0xfb, 0x54, 0x5e, 0x2a, 0x8d, 0x9d, 0x20, 0x57, 0x4a, 0x44, 0x66,
    0xee, 0xe4, 0xbd, 0x6c, 0xc6, 0x77, 0x39, 0xa1, 0x2a, 0x86, 0x77, 0x63, 0xb8, 0x88, 0x4a, 0xae,
    0x7a, 0x65, 0x6c, 0xd0, 0x7b, 0x68, 0xe9, 0x58, 0xd1, 0x19, 0xd3, 0x79, 0xc6, 0x37, 0xc1, 0xe5,
    0xd0, 0x26, 0xd0, 0x5f, 0xe8, 0xae, 0x57, 0xe7, 0x1d, 0xef, 0x86, 0x50, 0x57, 0xd9, 0x54, 0xda,
    0xc5, 0xdf, 0x5a, 0x61, 0x91, 0xea, 0x51, 0xe7, 0x20, 0x5c, 0x5b, 0x9a, 0xb9, 0xd0, 0xa8, 0x97,
    0x07, 0x19, 0x72, 0xd3, 0xa3, 0x12, 0xf8, 0x08, 0x59, 0xa0, 0xd1, 0xcd, 0x7b, 0xc5, 0x22, 0x5b,
    0x33, 0xd5, 0x0b, 0x4d, 0x98, 0x6b, 0xe3, 0x36, 0xf8, 0x78, 0xf2, 0x70, 0x76, 0xd3, 0xf4, 0xdb,
    0xfc, 0xb9, 0x3d, 0x1e, 0x9f, 0xb5, 0xec, 0x00, 0xe6, 0x88, 0x53, 0xcf, 0xed, 0x2b, 0x98, 0xc3,
    0x0b, 0x98, 0xb5, 0x6c, 0x1f, 0x46, 0x81, 0x84, 0xae, 0x53, 0xf7, 0x4d, 0x64, 0x16, 0xac, 0xfc,
    0x0e, 0x36, 0x57, 0x22, 0xa3, 0xdd, 0xa8, 0x69, 0x7d, 0xb5, 0xcc, 0x2a, 0xff, 0x33, 0x2c, 0x86,
    0xf3, 0x82, 0x5b, 0x50, 0x55, 0x76, 0x6f, 0x30, 0x7d, 0xc4, 0xf6, 0x57, 0xc5, 0x6c, 0xcc, 0xec,
    0x9e, 0xad, 0xb7, 0xab, 0x66, 0xf0, 0x1a, 0xbb, 0x1a, 0x42, 0x4b, 0x65, 0xb6, 0xf6, 0xaf, 0x96,
    0xf0, 0xac, 0x8b, 0xe8, 0x18, 0x38, 0x73, 0x45, 0xbd, 0x10, 0xe6, 0xab, 0x46, 0xc8, 0xc5, 0x88,
    0x74, 0x01, 0xdf, 0xf7, 0x95, 0x78, 0x2a, 0xf1, 0x4a, 0xd6, 0x3d, 0xa8, 0xc4, 0x4a, 0x13, 0xeb,
    0xca, 0xbb, 0x94, 0x65, 0x13, 0xa5, 0x6a, 0x6c, 0x96, 0x51, 0x91, 0xeb, 0xea, 0x85, 0x96, 0x4d,
    0x81, 0xf7, 0xdb, 0x3e, 0x3d, 0x05, 0xd3, 0xff, 0x01, 0xda, 0xd6, 0x44, 0x8c
};
#endif

PyTypeObject *init_KWidgetsAddonsKMessageBox(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX].type;

    Shiboken::AutoDecRef Sbk_KMessageBox_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KMessageBox_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMessageBox",
        "KMessageBox",
        &Sbk_KMessageBox_spec,
        nullptr,
        Sbk_KMessageBox_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KMessageBox_Type; // references _Sbk_KMessageBox_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KWidgetsAddonsKMessageBox_SignatureStrings);
#else
    InitSignatureBytes(pyType, KWidgetsAddonsKMessageBox_SignatureBytes, KWidgetsAddonsKMessageBox_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMessageBox_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KWidgetsAddonsKMessageBox_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KMessageBox_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ButtonCode'.
    const char *ButtonCode_Initializer[] = {
        "Ok",
        "Cancel",
        "PrimaryAction",
        "SecondaryAction",
        "Continue",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ButtonCode_InitializerValues[] = {
        uint8_t(KMessageBox::ButtonCode::Ok),              //  0x01  1
        uint8_t(KMessageBox::ButtonCode::Cancel),          //  0x02  2
        uint8_t(KMessageBox::ButtonCode::PrimaryAction),   //  0x03  3
        uint8_t(KMessageBox::ButtonCode::SecondaryAction), //  0x04  4
        uint8_t(KMessageBox::ButtonCode::Continue)         //  0x05  5
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMessageBox_TypeF(),
        "1:KWidgetsAddons.KMessageBox.ButtonCode",
        ButtonCode_Initializer, ButtonCode_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_ButtonCode_IDX].type = EType;
    // Register converter for enum 'KMessageBox::ButtonCode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMessageBox_ButtonCode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMessageBox_ButtonCode,
            is_Enum_PythonToCpp_KMessageBox_ButtonCode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMessageBox::ButtonCode");
        Shiboken::Conversions::registerConverterAlias(converter, "ButtonCode");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ButtonCode' enum.

    // Initialization of enum 'DialogType'.
    const char *DialogType_Initializer[] = {
        "QuestionTwoActions",
        "WarningTwoActions",
        "WarningContinueCancel",
        "WarningTwoActionsCancel",
        "Information",
        "Error",
        "QuestionTwoActionsCancel",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t DialogType_InitializerValues[] = {
        uint8_t(KMessageBox::DialogType::QuestionTwoActions),      //  0x01  1
        uint8_t(KMessageBox::DialogType::WarningTwoActions),       //  0x02  2
        uint8_t(KMessageBox::DialogType::WarningContinueCancel),   //  0x03  3
        uint8_t(KMessageBox::DialogType::WarningTwoActionsCancel), //  0x04  4
        uint8_t(KMessageBox::DialogType::Information),             //  0x05  5
        uint8_t(KMessageBox::DialogType::Error),                   //  0x08  8
        uint8_t(KMessageBox::DialogType::QuestionTwoActionsCancel) //  0x09  9
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMessageBox_TypeF(),
        "1:KWidgetsAddons.KMessageBox.DialogType",
        DialogType_Initializer, DialogType_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_DialogType_IDX].type = EType;
    // Register converter for enum 'KMessageBox::DialogType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMessageBox_DialogType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMessageBox_DialogType,
            is_Enum_PythonToCpp_KMessageBox_DialogType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMessageBox::DialogType");
        Shiboken::Conversions::registerConverterAlias(converter, "DialogType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'DialogType' enum.

    // Initialization of enum 'Option'.
    const char *Option_Initializer[] = {
        "Notify",
        "AllowLink",
        "Dangerous",
        "NoExec",
        "WindowModal",
        "PlainText",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Option_InitializerValues[] = {
        uint8_t(KMessageBox::Option::Notify),      //  0x01  1
        uint8_t(KMessageBox::Option::AllowLink),   //  0x02  2
        uint8_t(KMessageBox::Option::Dangerous),   //  0x04  4
        uint8_t(KMessageBox::Option::NoExec),      //  0x10  16
        uint8_t(KMessageBox::Option::WindowModal), //  0x20  32
        uint8_t(KMessageBox::Option::PlainText)    //  0x40  64
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMessageBox_TypeF(),
        "1:KWidgetsAddons.KMessageBox.Option",
        Option_Initializer, Option_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageBox_Option_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KMessageBox_Option_IDX].type =
        EType;
    // Register converter for enum 'KMessageBox::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMessageBox_Option_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMessageBox_Option,
            is_Enum_PythonToCpp_KMessageBox_Option_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMessageBox::Option");
        Shiboken::Conversions::registerConverterAlias(converter, "Option");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KMessageBox_Option_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KMessageBox_Option,
            is_Enum_PythonToCpp_KMessageBox_Option_Convertible);
        // Register converter for flag 'QFlags<KMessageBox::Option>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KMessageBox::Option>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KMessageBox::Options");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Option' enum/flags.

    qRegisterMetaType< ::KMessageBox::ButtonCode >("KMessageBox::ButtonCode");
    qRegisterMetaType< ::KMessageBox::DialogType >("KMessageBox::DialogType");
    qRegisterMetaType< ::KMessageBox::Option >("KMessageBox::Option");

    return pyType;
}
