/*
 * Copyright (C) 2020 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated file, do not edit */


#include "bi_swizzles.h"

uint32_t bi_op_swizzles[BI_NUM_OPCODES][BI_MAX_SRCS] = {
    [BI_OPCODE_ACMPSTORE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ACMPSTORE_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ACMPXCHG_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ACMPXCHG_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ARSHIFT_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_ARSHIFT_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_ARSHIFT_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_ARSHIFT_DOUBLE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
    },
    [BI_OPCODE_ATEST] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM1_RETURN_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM1_RETURN_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_C_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_C_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_C1_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_C1_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_C1_RETURN_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_C1_RETURN_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_CX] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_C_RETURN_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_C_RETURN_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_POST_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_POST_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_PRE_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_RETURN_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ATOM_RETURN_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_AXCHG_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_AXCHG_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BARRIER] = {
    },
    [BI_OPCODE_BITREV_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BLEND] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_F16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_I16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_I32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_S16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_S32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_U16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_U32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHC_I16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHC_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZ_F16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZ_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZ_I16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZ_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZ_S16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZ_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZ_U16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZ_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCHZI] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_DIVERG] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_LOWBITS_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_BRANCH_NO_DIVERG] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CLPER_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CLPER_OLD_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CLZ_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CLZ_V2U16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CLZ_V4U8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_COLLECT_I32] = {
    },
    [BI_OPCODE_CSEL_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CSEL_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CSEL_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CSEL_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CSEL_V2F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CSEL_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CSEL_V2S16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CSEL_V2U16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CUBEFACE] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CUBEFACE1] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CUBEFACE2] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CUBEFACE2_V9] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CUBE_SSEL] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_CUBE_TSEL] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_DISCARD_B32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_DISCARD_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_DTSEL_IMM] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_F16_TO_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_F16_TO_S32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_F16_TO_U32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_F32_TO_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_F32_TO_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FABSNEG_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FABSNEG_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FADD_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FADD_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FADD_IMM_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FADD_IMM_V2F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FADD_LSCALE_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FADD_RSCALE_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FCLAMP_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FCLAMP_V2F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FCMP_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FCMP_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FCMP_AND_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FCMP_AND_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FCMP_OR_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FCMP_OR_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FCOS_TABLE_U6] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FEXP_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FEXP_TABLE_U4] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FLOGD_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FLOG_TABLE_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FLSHIFT_DOUBLE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
    },
    [BI_OPCODE_FMA_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMA_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMAX_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMAX_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMA_RSCALE_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMA_RSCALE_V2F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMIN_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMIN_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMUL_CSLICE] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FMUL_SLICE_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FPCLASS_F16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FPCLASS_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FPOW_SC_APPLY] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FPOW_SC_DET_F16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FPOW_SC_DET_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FRCP_F16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FRCP_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FRCP_APPROX_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FREXPE_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FREXPE_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FREXPM_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FREXPM_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FROUND_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FROUND_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FRSHIFT_DOUBLE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
    },
    [BI_OPCODE_FRSQ_F16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FRSQ_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FRSQ_APPROX_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_FSINCOS_OFFSET_U6] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_FSIN_TABLE_U6] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_HADD_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_HADD_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_HADD_V2S16] = {
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_HADD_V2U16] = {
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_HADD_V4S8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_HADD_V4U8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IABS_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IABS_V2S16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IABS_V4S8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IADD_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B1) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B3) |
        0,
    },
    [BI_OPCODE_IADD_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B1) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B3) |
        0,
    },
    [BI_OPCODE_IADD_V2S16] = {
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_H11) |
        0,
    },
    [BI_OPCODE_IADD_V2U16] = {
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_H11) |
        0,
    },
    [BI_OPCODE_IADD_V4S8] = {
        (1 << BI_SWIZZLE_B0123) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B2323) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B0101) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_IADD_V4U8] = {
        (1 << BI_SWIZZLE_B0123) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B2323) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B0101) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_IADDC_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IADD_IMM_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IADD_IMM_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IADD_IMM_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_V2I16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_V2S16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_V2U16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_V4S8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_V4U8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMPF_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMPI_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMPI_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMPI_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMPM_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_AND_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_AND_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_AND_V2S16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_AND_V2U16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_AND_V4S8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_AND_V4U8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_MULTI_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_MULTI_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_OR_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_OR_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_OR_V2S16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_OR_V2U16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_OR_V4S8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ICMP_OR_V4U8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IDP_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ILOGB_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_ILOGB_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IMOV_FMA] = {
    },
    [BI_OPCODE_IMUL_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B1) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B3) |
        0,
    },
    [BI_OPCODE_IMUL_V2I16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_IMUL_V4I8] = {
        (1 << BI_SWIZZLE_B0123) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_IMULD] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ISUB_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B1) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B3) |
        0,
    },
    [BI_OPCODE_ISUB_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B1) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B3) |
        0,
    },
    [BI_OPCODE_ISUB_V2S16] = {
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_H11) |
        0,
    },
    [BI_OPCODE_ISUB_V2U16] = {
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_H11) |
        0,
    },
    [BI_OPCODE_ISUB_V4S8] = {
        (1 << BI_SWIZZLE_B0123) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B2323) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B0101) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_ISUB_V4U8] = {
        (1 << BI_SWIZZLE_B0123) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B2323) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B0101) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_ISUBB_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_JUMP] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_JUMP_EX] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_KABOOM] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LDEXP_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LDEXP_V2F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_ATTR] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_ATTR_IMM] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_ATTR_TEX] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_BUFFER_I128] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_BUFFER_I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_BUFFER_I24] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_BUFFER_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_BUFFER_I48] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_BUFFER_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_BUFFER_I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_BUFFER_I96] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_CVT] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_GCLK_U64] = {
    },
    [BI_OPCODE_LD_TEX] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_TEX_IMM] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_TILE] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_VAR] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_VAR_BUF_F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_VAR_BUF_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_VAR_BUF_IMM_F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_VAR_BUF_IMM_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_VAR_FLAT] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_VAR_FLAT_IMM] = {
    },
    [BI_OPCODE_LD_VAR_IMM] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LD_VAR_SPECIAL] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LEA_ATTR] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LEA_ATTR_IMM] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LEA_ATTR_TEX] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LEA_BUF_IMM] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LEA_TEX] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LEA_TEX_IMM] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOAD_I128] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOAD_I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOAD_I24] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOAD_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOAD_I48] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOAD_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOAD_I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOAD_I96] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LOGB_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_LOGB_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_LROT_DOUBLE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
    },
    [BI_OPCODE_LSHIFT_AND_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_LSHIFT_AND_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_LSHIFT_AND_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_LSHIFT_DOUBLE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
    },
    [BI_OPCODE_LSHIFT_OR_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_LSHIFT_OR_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_LSHIFT_OR_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_LSHIFT_XOR_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_LSHIFT_XOR_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_LSHIFT_XOR_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_MKVEC_V2I16] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_MKVEC_V2I8] = {
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_MKVEC_V4I8] = {
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
    },
    [BI_OPCODE_MOV_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_MUX_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_MUX_V2I16] = {
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_MUX_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_NOP] = {
    },
    [BI_OPCODE_PHI] = {
    },
    [BI_OPCODE_POPCOUNT_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_QUIET_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_QUIET_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_RROT_DOUBLE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
    },
    [BI_OPCODE_RSHIFT_AND_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_RSHIFT_AND_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_RSHIFT_AND_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_RSHIFT_DOUBLE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        0,
    },
    [BI_OPCODE_RSHIFT_OR_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_RSHIFT_OR_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_RSHIFT_OR_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_RSHIFT_XOR_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_RSHIFT_XOR_V2I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_RSHIFT_XOR_V4I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B0123) |
        0,
    },
    [BI_OPCODE_S16_TO_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_S16_TO_S32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_S32_TO_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_S8_TO_F32] = {
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_S8_TO_S32] = {
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_SEG_ADD] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_SEG_ADD_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_SHADDXH_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_SHADDXL_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_SHADDXL_S32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_SHADDXL_U32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H01) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_SHIFT_DOUBLE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_SPLIT_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_STORE_I128] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_STORE_I16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_STORE_I24] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_STORE_I32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_STORE_I48] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_STORE_I64] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_STORE_I8] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_STORE_I96] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ST_CVT] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ST_TILE] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_SWZ_V2I16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        0,
    },
    [BI_OPCODE_SWZ_V4I8] = {
        (1 << BI_SWIZZLE_B1111) |
        (1 << BI_SWIZZLE_B3333) |
        (1 << BI_SWIZZLE_B2233) |
        (1 << BI_SWIZZLE_B0011) |
        (1 << BI_SWIZZLE_B3210) |
        (1 << BI_SWIZZLE_B0000) |
        (1 << BI_SWIZZLE_B2222) |
        (1 << BI_SWIZZLE_B1032) |
        0,
    },
    [BI_OPCODE_TEXC] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_TEXC_DUAL] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_TEXS_2D_F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_TEXS_2D_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_TEXS_CUBE_F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_TEXS_CUBE_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_TEX_FETCH] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_TEX_GATHER] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_TEX_SINGLE] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_U16_TO_F32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_U16_TO_U32] = {
        (1 << BI_SWIZZLE_H1) |
        (1 << BI_SWIZZLE_H0) |
        0,
    },
    [BI_OPCODE_U32_TO_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_U8_TO_F32] = {
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_U8_TO_U32] = {
        (1 << BI_SWIZZLE_B3) |
        (1 << BI_SWIZZLE_B0) |
        (1 << BI_SWIZZLE_B2) |
        (1 << BI_SWIZZLE_B1) |
        0,
    },
    [BI_OPCODE_V2F16_TO_V2S16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_V2F16_TO_V2U16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_V2F32_TO_V2F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_V2S16_TO_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_V2S8_TO_V2F16] = {
        (1 << BI_SWIZZLE_B20) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B31) |
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B30) |
        (1 << BI_SWIZZLE_B12) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B03) |
        (1 << BI_SWIZZLE_B10) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B32) |
        (1 << BI_SWIZZLE_B13) |
        (1 << BI_SWIZZLE_B21) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_V2S8_TO_V2S16] = {
        (1 << BI_SWIZZLE_B20) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B31) |
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B30) |
        (1 << BI_SWIZZLE_B12) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B03) |
        (1 << BI_SWIZZLE_B10) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B32) |
        (1 << BI_SWIZZLE_B13) |
        (1 << BI_SWIZZLE_B21) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_V2U16_TO_V2F16] = {
        (1 << BI_SWIZZLE_H11) |
        (1 << BI_SWIZZLE_H10) |
        (1 << BI_SWIZZLE_H00) |
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_V2U8_TO_V2F16] = {
        (1 << BI_SWIZZLE_B20) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B31) |
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B30) |
        (1 << BI_SWIZZLE_B12) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B03) |
        (1 << BI_SWIZZLE_B10) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B32) |
        (1 << BI_SWIZZLE_B13) |
        (1 << BI_SWIZZLE_B21) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_V2U8_TO_V2U16] = {
        (1 << BI_SWIZZLE_B20) |
        (1 << BI_SWIZZLE_B02) |
        (1 << BI_SWIZZLE_B01) |
        (1 << BI_SWIZZLE_B31) |
        (1 << BI_SWIZZLE_B22) |
        (1 << BI_SWIZZLE_B30) |
        (1 << BI_SWIZZLE_B12) |
        (1 << BI_SWIZZLE_B11) |
        (1 << BI_SWIZZLE_B33) |
        (1 << BI_SWIZZLE_B03) |
        (1 << BI_SWIZZLE_B10) |
        (1 << BI_SWIZZLE_B23) |
        (1 << BI_SWIZZLE_B32) |
        (1 << BI_SWIZZLE_B13) |
        (1 << BI_SWIZZLE_B21) |
        (1 << BI_SWIZZLE_B00) |
        0,
    },
    [BI_OPCODE_VAR_TEX_F16] = {
    },
    [BI_OPCODE_VAR_TEX_F32] = {
    },
    [BI_OPCODE_VN_ASST1_F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_VN_ASST1_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_VN_ASST2_F32] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_VN_ASST2_V2F16] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_WMASK] = {
        (1 << BI_SWIZZLE_H01) |
        0,
    },
    [BI_OPCODE_ZS_EMIT] = {
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
        (1 << BI_SWIZZLE_H01) |
        0,
    },
};

